/**
 * Copyright 2016, GeoSolutions Sas.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

const React = require('react');
const {connect} = require('react-redux');
const {loadMapConfig} = require('../../MapStore2/web/client/actions/config');
const {changeMapType} = require('../actions/mapType');

const MapViewer = connect((state) => ({
    params: {
        mapType: state.mapType && state.mapType.mapType
    }
}), {
    loadMapConfig: loadMapConfig.bind(null, "config.json", false)
})(require('../../MapStore2/web/client/containers/MapViewer'));

const MapSwitcher = connect((state) => ({
    mapType: state.mapType && state.mapType.mapType
}), {
    onChange: changeMapType
})(require('../components/MapSwitcher'));

const Main = (props) => (
    <div>
        <MapViewer plugins={props.plugins}/>
        <MapSwitcher/>
    </div>
);

module.exports = Main;
