/**
 * Copyright 2016, GeoSolutions Sas.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */
const React = require('react');

var MapSwitcher = React.createClass( {
    propTypes: {
        mapType: React.PropTypes.string,
        onChange: React.PropTypes.func,
        style: React.PropTypes.object
    },
    getDefaultProps() {
        return {
            mapType: "openlayers",
            onChange: () => {},
            style: {
                position: "absolute",
                left: "100px"
            }
        };
    },
    onChange(e) {
        this.props.onChange(e.target.value);
    },
    render() {
        return (
            <select style={this.props.style} id="mapSwitcher" value={this.props.mapType} onChange={this.onChange}>
                <option value="openlayers">OpenLayers</option>
                <option value="leaflet">Leaflet</option>
                <option value="cesium">CesiumJS</option>
            </select>
        );
    }
});

module.exports = MapSwitcher;
