/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},i.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},i.lerp=function(e,t,n){return(1-n)*e+n*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,n,r,i){i=t(i,r);var a=Math.abs(e-n);return i>=a||a<=r*Math.max(Math.abs(e),Math.abs(n))};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var n=a[t-1],r=t;e>=r;r++)a.push(n*r);return a[e]},i.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return i.setRandomNumberSeed=function(t){o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},i}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";function a(t,n){this.x=e(t,0),this.y=e(n,0)}a.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new a(e,n)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y)},a.minimumComponent=function(e){return Math.min(e.x,e.y)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(e,t){return a.normalize(e,s),a.normalize(t,c),i.acosClamped(a.dot(s,c))};var l=new a;return a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,l);return a.abs(n,n),t=n.x<=n.y?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Y,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)},a.ZERO=r(new a(0,0)),a.UNIT_X=r(new a(1,0)),a.UNIT_Y=r(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";function a(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)}a.fromSpherical=function(n,r){t(r)||(r=new a);var i=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(i),r.y=s*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(e,n,r,i){return t(i)?(i.x=e,i.y=n,i.z=r,i):new a(e,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(e,t){a.normalize(e,s),a.normalize(t,c);var n=a.dot(s,c),r=a.magnitude(a.cross(s,c,s));return Math.atan2(r,n)};var l=new a;a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,l);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Z,t):n.y<=n.z?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_Z,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)},a.cross=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=t.x,u=t.y,s=t.z,c=i*s-a*u,l=a*o-r*s,f=r*u-i*o;return n.x=c,n.y=l,n.z=f,n},a.fromDegrees=function(e,t,n,r,o){var u=i.toRadians(e),s=i.toRadians(t);return a.fromRadians(u,s,n,r,o)};var f=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=e(i,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(r);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(r),f=a.normalize(f,f),a.multiplyComponents(s,f,h);var l=Math.sqrt(a.dot(f,h));return h=a.divideByScalar(h,l,h),f=a.multiplyByScalar(f,i,f),t(u)||(u=new a),a.add(h,f,u)},a.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=i.toRadians(e[o]);return a.fromRadiansArray(r,t,n)},a.fromRadiansArray=function(e,n,r){var i=e.length;t(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=a.fromRadians(u,s,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=i.toRadians(e[o]),r[o+1]=i.toRadians(e[o+1]),r[o+2]=e[o+2];return a.fromRadiansArrayHeights(r,t,n)},a.fromRadiansArrayHeights=function(e,n,r){var i=e.length;t(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=a.fromRadians(u,s,c,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r,i){"use strict";var a={};a.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var n=t.x,r=t.y;t.x=(1-Math.abs(r))*i.signNotZero(n),t.y=(1-Math.abs(n))*i.signNotZero(r)}return t.x=i.toSNorm(t.x),t.y=i.toSNorm(t.y),t},a.octDecode=function(e,n,r){if(r.x=i.fromSNorm(e),r.y=i.fromSNorm(n),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var a=r.x;r.x=(1-Math.abs(r.y))*i.signNotZero(a),r.y=(1-Math.abs(a))*i.signNotZero(r.y)}return t.normalize(r,r)},a.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){var n=e/256,r=Math.floor(n),i=256*(n-r);return a.octDecode(r,i,t)},a.octPack=function(e,t,n,r){var i=a.octEncodeFloat(e),u=a.octEncodeFloat(t),s=a.octEncode(n,o);return r.x=65536*s.x+i,r.y=65536*s.y+u,r},a.octUnpack=function(e,t,n,r){var i=e.x/65536,o=Math.floor(i),u=65536*(i-o);i=e.y/65536;var s=Math.floor(i),c=65536*(i-s);a.octDecodeFloat(u,t),a.octDecodeFloat(c,n),a.octDecode(o,s,r)},a.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*t+n},a.decompressTextureCoordinates=function(e,t){var n=e/4096;return t.x=Math.floor(n)/4096,t.y=n-Math.floor(n),t},a}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(n,i,u,s,c){var l=n.x,f=n.y,h=n.z,d=i.x,E=i.y,_=i.z,m=l*l*d*d,p=f*f*E*E,R=h*h*_*_,T=m+p+R,y=Math.sqrt(1/T),A=e.multiplyByScalar(n,y,a);if(s>T)return isFinite(y)?e.clone(A,c):void 0;var S=u.x,N=u.y,M=u.z,I=o;I.x=A.x*S*2,I.y=A.y*N*2,I.z=A.z*M*2;var O,v,w,g,C,x,P,U,D,L,F,B=(1-y)*e.magnitude(n)/(.5*e.magnitude(I)),z=0;do{B-=z,w=1/(1+B*S),g=1/(1+B*N),C=1/(1+B*M),x=w*w,P=g*g,U=C*C,D=x*w,L=P*g,F=U*C,O=m*x+p*P+R*U-1,v=m*D*S+p*L*N+R*F*M;var b=-2*v;z=O/b}while(Math.abs(O)>r.EPSILON12);return t(c)?(c.x=l*w,c.y=f*g,c.z=h*C,c):new e(l*w,f*g,h*C)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,i,a){return i=t(i,0),n(a)?(a.longitude=e,a.latitude=r,a.height=i,a):new u(e,r,i)},u.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,n,r)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=a.EPSILON1;return u.fromCartesian=function(t,r,i){var E=n(r)?r.oneOverRadii:f,_=n(r)?r.oneOverRadiiSquared:h,m=n(r)?r._centerToleranceSquared:d,p=o(t,E,_,m,c);if(n(p)){var R=e.multiplyComponents(t,_,s);R=e.normalize(R,R);var T=e.subtract(t,p,l),y=Math.atan2(R.y,R.x),A=Math.asin(R.z),S=a.sign(e.dot(T,t))*e.magnitude(T);return n(i)?(i.longitude=y,i.latitude=A,i.height=S,i):new u(y,A,S)}},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o,u,s){"use strict";function c(t,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),t._radii=new e(r,i,a),t._radiiSquared=new e(r*r,i*i,a*a),t._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,i,a),t._maximumRadius=Math.max(r,i,a),t._centerToleranceSquared=u.EPSILON1}function l(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,c(this,e,t,n)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,n){if(r(t)){var i=t._radii;return r(n)?(e.clone(i,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new l(i.x,i.y,i.z)}},l.fromCartesian3=function(e,t){return r(t)||(t=new l),r(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,i){i=n(i,0),e.pack(t._radii,r,i)},l.unpack=function(t,r,i){r=n(r,0);var a=e.unpack(t,r);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var f=new e,h=new e;l.prototype.cartographicToCartesian=function(t,n){var i=f,a=h;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),r(n)||(n=new e),e.add(a,i,n)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var d=new e,E=new e,_=new e;return l.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,E);if(r(a)){var o=this.geodeticSurfaceNormal(a,d),s=e.subtract(n,a,_),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,n))*e.magnitude(s);return r(i)?(i.longitude=c,i.latitude=l,i.height=f,i):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},l.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},l.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,i,a,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new e(a,o,u)},u.prototype.unproject=function(e,n){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e,n,r,i,a,o,u,s,c){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(a,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)}function u(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function s(e){for(var t=0,n=0;3>n;++n){var r=e[o.getElementIndex(d[n],h[n])];t+=2*r*r}return Math.sqrt(t)}function c(e,t){for(var n=a.EPSILON15,r=0,i=1,u=0;3>u;++u){var s=Math.abs(e[o.getElementIndex(d[u],h[u])]);s>r&&(i=u,r=s)}var c=1,l=0,f=h[i],E=d[i];if(Math.abs(e[o.getElementIndex(E,f)])>n){var _,m=e[o.getElementIndex(E,E)],p=e[o.getElementIndex(f,f)],R=e[o.getElementIndex(E,f)],T=(m-p)/2/R;_=0>T?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),c=1/Math.sqrt(1+_*_),l=_*c}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(f,f)]=t[o.getElementIndex(E,E)]=c,t[o.getElementIndex(E,f)]=l,t[o.getElementIndex(f,E)]=-l,t}o.packedLength=9,o.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},o.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i[0]=e[r++],i[1]=e[r++],i[2]=e[r++],i[3]=e[r++],i[4]=e[r++],i[5]=e[r++],i[6]=e[r++],i[7]=e[r++],i[8]=e[r++],i},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],i[8]=e[r+8],i},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var r=e.x*e.x,i=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,E=r-s-f+d,_=2*(i-h),m=2*(a+l),p=2*(i+h),R=-r+s-f+d,T=2*(c-u),y=2*(a-l),A=2*(c+u),S=-r-s+f+d;return n(t)?(t[0]=E,t[1]=p,t[2]=y,t[3]=_,t[4]=R,t[5]=A,t[6]=m,t[7]=T,t[8]=S,t):new o(E,_,m,p,R,T,y,A,S)},o.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=i,t[6]=0,t[7]=-i,t[8]=r,t):new o(1,0,0,0,r,-i,0,i,r)},o.fromRotationY=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=r,t):new o(r,0,i,0,1,0,-i,0,r)},o.fromRotationZ=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=i,t[2]=0,t[3]=-i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(r,-i,0,i,r,0,0,0,1)},o.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,n){var r=3*t,i=e[r],a=e[r+1],o=e[r+2];return n.x=i,n.y=a,n.z=o,n},o.setColumn=function(e,t,n,r){r=o.clone(e,r);var i=3*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},o.getRow=function(e,t,n){var r=e[t],i=e[t+3],a=e[t+6];return n.x=r,n.y=i,n.z=a,n},o.setRow=function(e,t,n,r){return r=o.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;o.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var f=new e;o.getMaximumScale=function(t){return o.getScale(t,f),e.maximumComponent(f)},o.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},o.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},o.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},o.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[3]*i+e[6]*a,u=e[1]*r+e[4]*i+e[7]*a,s=e[2]*r+e[5]*i+e[8]*a;return n.x=o,n.y=u,n.z=s,n},o.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},o.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var n=e[0],r=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],d=[2,2,1],E=new o,_=new o;return o.computeEigenDecomposition=function(e,t){var r=a.EPSILON20,i=10,l=0,f=0;n(t)||(t={});for(var h=t.unitary=o.clone(o.IDENTITY,t.unitary),d=t.diagonal=o.clone(e,t.diagonal),m=r*u(d);i>f&&s(d)>m;)c(d,E),o.transpose(E,_),o.multiply(d,E,d),o.multiply(_,d,d),o.multiply(h,E,h),++l>2&&(++f,l=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],n=e[3],r=e[6],i=e[1],a=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(a*c-s*o)+i*(s*r-n*c)+u*(n*o-a*r)},o.inverse=function(e,t){var n=e[0],i=e[1],u=e[2],s=e[3],c=e[4],l=e[5],f=e[6],h=e[7],d=e[8],E=o.determinant(e);if(Math.abs(E)<=a.EPSILON15)throw new r("matrix is not invertible");t[0]=c*d-h*l,t[1]=h*u-i*d,t[2]=i*l-c*u,t[3]=f*l-s*d,t[4]=n*d-f*u,t[5]=s*u-n*l,t[6]=s*h-f*c,t[7]=f*i-n*h,t[8]=n*c-s*i;var _=1/E;return o.multiplyByScalar(t,_,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},o.IDENTITY=i(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=i(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";function a(t,n,r,i){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(i,0)}a.fromElements=function(e,n,r,i,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=i,o):new a(e,n,r,i)},a.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var s=new a;return a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,s);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)&&i.equalsEpsilon(e.w,n.w,r,a)},
a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,i,a,o,u,s){"use strict";function c(e,t,r,i,a,o,u,s,c,l,f,h,d,E,_,m){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(E,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(_,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(m,0)}c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new c),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,i,a){return i=n(i,e.ZERO),r(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new c(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,i){r(i)||(i=new c);var a=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,d=t.y*t.y,E=t.y*t.z,_=t.y*t.w,m=t.z*t.z,p=t.z*t.w,R=t.w*t.w,T=s-d-m+R,y=2*(l-p),A=2*(f+_),S=2*(l+p),N=-s+d-m+R,M=2*(E-h),I=2*(f-_),O=2*(E+h),v=-s-d+m+R;return i[0]=T*a,i[1]=S*a,i[2]=I*a,i[3]=0,i[4]=y*o,i[5]=N*o,i[6]=O*o,i[7]=0,i[8]=A*u,i[9]=M*u,i[10]=v*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,n){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,E=l.x,_=l.y,m=l.z,p=h.x,R=h.y,T=h.z,y=i.x,A=i.y,S=i.z,N=u*-y+s*-A+d*-S,M=p*-y+R*-A+T*-S,I=E*y+_*A+m*S;return r(n)?(n[0]=u,n[1]=p,n[2]=-E,n[3]=0,n[4]=s,n[5]=R,n[6]=-_,n[7]=0,n[8]=d,n[9]=T,n[10]=-m,n[11]=0,n[12]=N,n[13]=M,n[14]=I,n[15]=1,n):new c(u,s,d,N,p,R,T,M,-E,-_,-m,I,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,i){var a=Math.tan(.5*e),o=1/a,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},c.computeOrthographicOffCenter=function(e,t,n,r,i,a,o){var u=1/(t-e),s=1/(r-n),c=1/(a-i),l=-(t+e)*u,f=-(r+n)*s,h=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,i,a,o){var u=2*i/(t-e),s=2*i/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),f=-(a+i)/(a-i),h=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,i,a){var o=2*i/(t-e),u=2*i/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,f=-1,h=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=l,a[11]=f,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},c.computeViewportTransformation=function(e,t,r,i){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-t),h=c,d=l,E=f,_=a+c,m=o+l,p=t+f,R=1;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=E,i[11]=0,i[12]=_,i[13]=m,i[14]=p,i[15]=R,i},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,i=e[r],a=e[r+1],o=e[r+2],u=e[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var i=4*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},c.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},c.getRow=function(e,t,n){var r=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var d=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),n};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],E=e[11],_=e[12],m=e[13],p=e[14],R=e[15],T=t[0],y=t[1],A=t[2],S=t[3],N=t[4],M=t[5],I=t[6],O=t[7],v=t[8],w=t[9],g=t[10],C=t[11],x=t[12],P=t[13],U=t[14],D=t[15],L=r*T+u*y+f*A+_*S,F=i*T+s*y+h*A+m*S,B=a*T+c*y+d*A+p*S,z=o*T+l*y+E*A+R*S,b=r*N+u*M+f*I+_*O,q=i*N+s*M+h*I+m*O,G=a*N+c*M+d*I+p*O,W=o*N+l*M+E*I+R*O,X=r*v+u*w+f*g+_*C,V=i*v+s*w+h*g+m*C,H=a*v+c*w+d*g+p*C,Y=o*v+l*w+E*g+R*C,Z=r*x+u*P+f*U+_*D,k=i*x+s*P+h*U+m*D,K=a*x+c*P+d*U+p*D,j=o*x+l*P+E*U+R*D;return n[0]=L,n[1]=F,n[2]=B,n[3]=z,n[4]=b,n[5]=q,n[6]=G,n[7]=W,n[8]=X,n[9]=V,n[10]=H,n[11]=Y,n[12]=Z,n[13]=k,n[14]=K,n[15]=j,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],E=e[14],_=t[0],m=t[1],p=t[2],R=t[4],T=t[5],y=t[6],A=t[8],S=t[9],N=t[10],M=t[12],I=t[13],O=t[14],v=r*_+o*m+c*p,w=i*_+u*m+l*p,g=a*_+s*m+f*p,C=r*R+o*T+c*y,x=i*R+u*T+l*y,P=a*R+s*T+f*y,U=r*A+o*S+c*N,D=i*A+u*S+l*N,L=a*A+s*S+f*N,F=r*M+o*I+c*O+h,B=i*M+u*I+l*O+d,z=a*M+s*I+f*O+E;return n[0]=v,n[1]=w,n[2]=g,n[3]=0,n[4]=C,n[5]=x,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=L,n[11]=0,n[12]=F,n[13]=B,n[14]=z,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],E=t[2],_=t[3],m=t[4],p=t[5],R=t[6],T=t[7],y=t[8],A=r*h+o*d+c*E,S=i*h+u*d+l*E,N=a*h+s*d+f*E,M=r*_+o*m+c*p,I=i*_+u*m+l*p,O=a*_+s*m+f*p,v=r*R+o*T+c*y,w=i*R+u*T+l*y,g=a*R+s*T+f*y;return n[0]=A,n[1]=S,n[2]=N,n[3]=0,n[4]=M,n[5]=I,n[6]=O,n[7]=0,n[8]=v,n[9]=w,n[10]=g,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=r*e[0]+i*e[4]+a*e[8]+e[12],u=r*e[1]+i*e[5]+a*e[9]+e[13],s=r*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var _=new e;c.multiplyByUniformScale=function(e,t,n){return _.x=t,_.y=t,_.z=t,c.multiplyByScale(e,_,n)},c.multiplyByScale=function(e,t,n){var r=t.x,i=t.y,a=t.z;return 1===r&&1===i&&1===a?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*r+e[4]*i+e[8]*a+e[12]*o,s=e[1]*r+e[5]*i+e[9]*a+e[13]*o,c=e[2]*r+e[6]*i+e[10]*a+e[14]*o,l=e[3]*r+e[7]*i+e[11]*a+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a,u=e[1]*r+e[5]*i+e[9]*a,s=e[2]*r+e[6]*i+e[10]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a+e[12],u=e[1]*r+e[5]*i+e[9]*a+e[13],s=e[2]*r+e[6]*i+e[10]*a+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new u,p=new u,R=new t,T=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,m),p,o.EPSILON7)&&t.equals(c.getRow(e,3,R),T))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],i=e[4],a=e[8],l=e[12],f=e[1],h=e[5],d=e[9],E=e[13],_=e[2],y=e[6],A=e[10],S=e[14],N=e[3],M=e[7],I=e[11],O=e[15],v=A*O,w=S*I,g=y*O,C=S*M,x=y*I,P=A*M,U=_*O,D=S*N,L=_*I,F=A*N,B=_*M,z=y*N,b=v*h+C*d+x*E-(w*h+g*d+P*E),q=w*f+U*d+F*E-(v*f+D*d+L*E),G=g*f+D*h+B*E-(C*f+U*h+z*E),W=P*f+L*h+z*d-(x*f+F*h+B*d),X=w*i+g*a+P*l-(v*i+C*a+x*l),V=v*r+D*a+L*l-(w*r+U*a+F*l),H=C*r+U*i+z*l-(g*r+D*i+B*l),Y=x*r+F*i+B*a-(P*r+L*i+z*a);v=a*E,w=l*d,g=i*E,C=l*h,x=i*d,P=a*h,U=r*E,D=l*f,L=r*d,F=a*f,B=r*h,z=i*f;var Z=v*M+C*I+x*O-(w*M+g*I+P*O),k=w*N+U*I+F*O-(v*N+D*I+L*O),K=g*N+D*M+B*O-(C*N+U*M+z*O),j=P*N+L*M+z*I-(x*N+F*M+B*I),J=g*A+P*S+w*y-(x*S+v*y+C*A),Q=L*S+v*_+D*A-(U*A+F*S+w*_),$=U*y+z*S+C*_-(B*S+g*_+D*y),ee=B*A+x*_+F*y-(L*y+z*A+P*_),te=r*b+i*q+a*G+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=b*te,n[1]=q*te,n[2]=G*te,n[3]=W*te,n[4]=X*te,n[5]=V*te,n[6]=H*te,n[7]=Y*te,n[8]=Z*te,n[9]=k*te,n[10]=K*te,n[11]=j*te,n[12]=J*te,n[13]=Q*te,n[14]=$*te,n[15]=ee*te,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],E=-n*f-r*h-i*d,_=-a*f-o*h-u*d,m=-s*f-c*h-l*d;return t[0]=n,t[1]=a,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=_,t[14]=m,t[15]=1,t},c.IDENTITY=a(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=a(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function i(t,n){this.normal=e.clone(t),this.distance=n}i.fromPointNormal=function(n,r,a){var o=-e.dot(r,n);return t(a)?(e.clone(r,a.normal),a.distance=o,a):new i(r,o)};var a=new e;return i.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,a),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new i(o,u)},i.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},i.ORIGIN_XY_PLANE=r(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=r(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=r(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";function s(e,n,r,i){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(i,0)}r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i.west=e[r++],i.south=e[r++],i.east=e[r++],i.north=e[r],i},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,i,a,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),i=u.toRadians(t(i,0)),a=u.toRadians(t(a,0)),n(o)?(o.west=e,o.south=r,o.east=i,o.north=a,o):new s(e,r,i,a)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,h=e.length;h>f;f++){var d=e[f];r=Math.min(r,d.longitude),i=Math.max(i,d.longitude),c=Math.min(c,d.latitude),l=Math.max(l,d.latitude);var E=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;a=Math.min(a,E),o=Math.max(o,E)}return i-r>o-a&&(r=a,i=o,i>u.PI&&(i-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=c,t.east=i,t.north=l,t):new s(r,c,i,l)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var i=t.east,a=t.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var i=e.east,a=e.west,o=t.east,c=t.west;a>i&&o>0?i+=u.TWO_PI:c>o&&i>0&&(o+=u.TWO_PI),a>i&&0>c?c+=u.TWO_PI:c>o&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,c)),f=u.negativePiToPi(Math.min(i,o));if(!((e.west<e.east||t.west<t.east)&&l>=f)){var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(h>=d))return n(r)?(r.west=l,r.south=h,r.east=f,r.north=d,r):new s(l,h,f,d)}},s.contains=function(e,t){var n=t.longitude,r=t.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0),n(o)||(o=[]);var l=0,f=e.north,h=e.south,d=e.east,E=e.west,_=c;_.height=i,_.longitude=E,_.latitude=f,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=d,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.latitude=h,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=E,o[l]=r.cartographicToCartesian(_,o[l]),l++,0>f?_.latitude=f:h>0?_.latitude=h:_.latitude=0;for(var m=1;8>m;++m)_.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,_)&&(o[l]=r.cartographicToCartesian(_,o[l]),l++);return 0===_.latitude&&(_.longitude=E,o[l]=r.cartographicToCartesian(_,o[l]),l++,_.longitude=d,o[l]=r.cartographicToCartesian(_,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,i,a,o,u,s,c,l,f,h){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var E=new e,_=new e,m=new e,p=new e,R=new e,T=new e,y=new e,A=new e,S=new e,N=new e,M=new e,I=new e;d.fromPoints=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var i=e.clone(t[0],y),a=e.clone(i,E),o=e.clone(i,_),u=e.clone(i,m),s=e.clone(i,p),c=e.clone(i,R),l=e.clone(i,T),f=t.length,h=1;f>h;h++){e.clone(t[h],i);var O=i.x,v=i.y,w=i.z;O<a.x&&e.clone(i,a),O>s.x&&e.clone(i,s),v<o.y&&e.clone(i,o),v>c.y&&e.clone(i,c),w<u.z&&e.clone(i,u),w>l.z&&e.clone(i,l)}var g=e.magnitudeSquared(e.subtract(s,a,A)),C=e.magnitudeSquared(e.subtract(c,o,A)),x=e.magnitudeSquared(e.subtract(l,u,A)),P=a,U=s,D=g;C>D&&(D=C,P=o,U=c),x>D&&(D=x,P=u,U=l);var L=S;L.x=.5*(P.x+U.x),L.y=.5*(P.y+U.y),L.z=.5*(P.z+U.z);var F=e.magnitudeSquared(e.subtract(U,L,A)),B=Math.sqrt(F),z=N;z.x=a.x,z.y=o.y,z.z=u.z;var b=M;b.x=s.x,b.y=c.y,b.z=l.z;var q=e.multiplyByScalar(e.add(z,b,A),.5,I),G=0;for(h=0;f>h;h++){e.clone(t[h],i);var W=e.magnitude(e.subtract(i,q,A));W>G&&(G=W);var X=e.magnitudeSquared(e.subtract(i,L,A));if(X>F){var V=Math.sqrt(X);B=.5*(B+V),F=B*B;var H=V-B;L.x=(B*L.x+H*i.x)/V,L.y=(B*L.y+H*i.y)/V,L.z=(B*L.z+H*i.z)/V}}return G>B?(e.clone(L,n.center),n.radius=B):(e.clone(q,n.center),n.radius=G),n};var O=new o,v=new e,w=new e,g=new t,C=new t;d.fromRectangle2D=function(e,t,n){return d.fromRectangleWithHeights2D(e,t,0,0,n)},d.fromRectangleWithHeights2D=function(t,i,a,o,u){if(r(u)||(u=new d),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,O),h.southwest(t,g),g.height=a,h.northeast(t,C),C.height=o;var s=i.project(g,v),c=i.project(C,w),l=c.x-s.x,f=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+E*E);var _=u.center;return _.x=s.x+.5*l,_.y=s.y+.5*f,_.z=s.z+.5*E,u};var x=[];d.fromRectangle3D=function(e,t,i,o){t=n(t,a.WGS84),i=n(i,0);var u;return r(e)&&(u=h.subsample(e,t,i,x)),d.fromPoints(u,o)},d.fromVertices=function(t,i,a,o){if(r(o)||(o=new d),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;i=n(i,e.ZERO),a=n(a,3);var u=y;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var s=e.clone(u,E),c=e.clone(u,_),l=e.clone(u,m),f=e.clone(u,p),h=e.clone(u,R),O=e.clone(u,T),v=t.length,w=0;v>w;w+=a){var g=t[w]+i.x,C=t[w+1]+i.y,x=t[w+2]+i.z;u.x=g,u.y=C,u.z=x,g<s.x&&e.clone(u,s),g>f.x&&e.clone(u,f),C<c.y&&e.clone(u,c),C>h.y&&e.clone(u,h),x<l.z&&e.clone(u,l),x>O.z&&e.clone(u,O)}var P=e.magnitudeSquared(e.subtract(f,s,A)),U=e.magnitudeSquared(e.subtract(h,c,A)),D=e.magnitudeSquared(e.subtract(O,l,A)),L=s,F=f,B=P;U>B&&(B=U,L=c,F=h),D>B&&(B=D,L=l,F=O);var z=S;z.x=.5*(L.x+F.x),z.y=.5*(L.y+F.y),z.z=.5*(L.z+F.z);var b=e.magnitudeSquared(e.subtract(F,z,A)),q=Math.sqrt(b),G=N;G.x=s.x,G.y=c.y,G.z=l.z;var W=M;W.x=f.x,W.y=h.y,W.z=O.z;var X=e.multiplyByScalar(e.add(G,W,A),.5,I),V=0;for(w=0;v>w;w+=a){u.x=t[w]+i.x,u.y=t[w+1]+i.y,u.z=t[w+2]+i.z;var H=e.magnitude(e.subtract(u,X,A));H>V&&(V=H);var Y=e.magnitudeSquared(e.subtract(u,z,A));if(Y>b){var Z=Math.sqrt(Y);q=.5*(q+Z),b=q*q;var k=Z-q;z.x=(q*z.x+k*u.x)/Z,z.y=(q*z.y+k*u.y)/Z,z.z=(q*z.z+k*u.z)/Z}}return V>q?(e.clone(z,o.center),o.radius=q):(e.clone(X,o.center),o.radius=V),o},d.fromCornerPoints=function(t,n,i){r(i)||(i=new d);var a=i.center;return e.add(t,n,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,n),i},d.fromEllipsoid=function(t,n){return r(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=t.length;if(1===i)return d.clone(t[0],n);if(2===i)return d.union(t[0],t[1],n);for(var a=[],o=0;i>o;o++)a.push(t[o].center);n=d.fromPoints(a,n);var u=n.center,s=n.radius;for(o=0;i>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return n.radius=s,n};var U=new e,D=new e,L=new e;d.fromOrientedBoundingBox=function(t,n){r(n)||(n=new d);var i=t.halfAxes,a=c.getColumn(i,0,U),o=c.getColumn(i,1,D),u=c.getColumn(i,2,L),s=e.magnitude(a),l=e.magnitude(o),f=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(s,l,f),n},d.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,r){r=n(r,0);var i=e.center;t[r++]=i.x,t[r++]=i.y,t[r++]=i.z,t[r]=e.radius},d.unpack=function(e,t,i){t=n(t,0),r(i)||(i=new d);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var F=new e,B=new e;d.union=function(t,n,i){r(i)||(i=new d);var a=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,a,F),l=e.magnitude(c);if(o>=l+s)return t.clone(i),i;if(s>=l+o)return n.clone(i),i;var f=.5*(o+l+s),h=e.multiplyByScalar(c,(-o+f)/l,B);return e.add(h,a,h),e.clone(h,i.center),i.radius=f,i};var z=new e;d.expand=function(t,n,r){r=d.clone(t,r);var i=e.magnitude(e.subtract(n,r.center,z));return i>r.radius&&(r.radius=i),r},d.intersectPlane=function(t,n){var r=t.center,i=t.radius,a=n.normal,o=e.dot(a,r)+n.distance;return-i>o?u.OUTSIDE:i>o?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var b=new e;d.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,b);return e.magnitudeSquared(r)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var q=new e;d.computePlaneDistances=function(t,n,i,a){r(a)||(a=new s);var o=e.subtract(t.center,n,q),u=e.dot(i,o);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var G=new e,W=new e,X=new e,V=new e,H=new e,Y=new t,Z=new Array(8),k=0;8>k;++k)Z[k]=new e;var K=new o;return d.projectTo2D=function(t,r,i){r=n(r,K);var a=r.ellipsoid,o=t.center,u=t.radius,s=a.geodeticSurfaceNormal(o,G),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,X);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,H),h=e.negate(c,V),E=Z,_=E[0];e.add(s,l,_),e.add(_,c,_),_=E[1],e.add(s,l,_),e.add(_,h,_),_=E[2],e.add(s,f,_),e.add(_,h,_),_=E[3],e.add(s,f,_),e.add(_,c,_),e.negate(s,s),_=E[4],e.add(s,l,_),e.add(_,c,_),_=E[5],e.add(s,l,_),e.add(_,h,_),_=E[6],e.add(s,f,_),e.add(_,h,_),_=E[7],e.add(s,f,_),e.add(_,c,_);for(var m=E.length,p=0;m>p;++p){var R=E[p];e.add(o,R,R);var T=a.cartesianToCartographic(R,Y);r.project(T,R)}i=d.fromPoints(E,i),o=i.center;var y=o.x,A=o.y,S=o.z;return o.x=S,o.y=y,o.z=A,i},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,n){return d.computePlaneDistances(this,e,t,n)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,n,r,i,a,o){"use strict";function u(e,n){this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,r(n)&&(this.cameraPosition=n)}function s(e,n,r){var i=e.transformPositionToScaledSpace(n,E),a=t.magnitudeSquared(i),o=Math.sqrt(a),u=t.divideByScalar(i,o,_);a=Math.max(1,a),o=Math.max(1,o);var s=t.dot(u,r),c=t.magnitude(t.cross(u,r,u)),l=1/o,f=Math.sqrt(a-1)*l;return 1/(s*l-c*f)}function c(e,n,r){return 0>=n||n===1/0||n!==n?void 0:t.multiplyByScalar(e,n,r)}function l(e,n){return e.transformPositionToScaledSpace(n,m),t.normalize(m,m)}i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var n=this._ellipsoid,r=n.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=t.magnitudeSquared(r)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=i}}});var f=new t;u.prototype.isPointVisible=function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,f);return this.isScaledSpacePointVisible(n)},u.prototype.isScaledSpacePointVisible=function(e){var n=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,i=t.subtract(e,n,f),a=-t.dot(i,n),o=0>r?a>0:a>r&&a*a/t.magnitudeSquared(i)>r;return!o},u.prototype.computeHorizonCullingPoint=function(e,n,i){r(i)||(i=new t);for(var a=this._ellipsoid,o=l(a,e),u=0,f=0,h=n.length;h>f;++f){var d=n[f],E=s(a,d,o);u=Math.max(u,E)}return c(o,u,i)};var h=new t;u.prototype.computeHorizonCullingPointFromVertices=function(e,i,a,o,u){r(u)||(u=new t),o=n(o,t.ZERO);for(var f=this._ellipsoid,d=l(f,e),E=0,_=0,m=i.length;m>_;_+=a){h.x=i[_]+o.x,h.y=i[_+1]+o.y,h.z=i[_+2]+o.z;var p=s(f,h,d);E=Math.max(E,p)}return c(d,E,u)},u.prototype.computeHorizonCullingPointFromPoints=function(e,n,i){r(i)||(i=new t);for(var a=this._ellipsoid,o=l(a,e),u=0,f=0,h=n.length;h>f;++f){var d=s(a,n[f],o);u=Math.max(u,d)}return c(o,u,i)};var d=[];u.prototype.computeHorizonCullingPointFromRectangle=function(n,r,i){var a=o.subsample(n,r,0,d),u=e.fromPoints(a);return t.magnitude(u.center)<.1*r.minimumRadius?void 0:this.computeHorizonCullingPoint(u.center,a,i)};var E=new t,_=new t,m=new t;return u}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,
DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(e){return t(e)&&(e===a.UNSIGNED_BYTE||e===a.UNSIGNED_SHORT||e===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,n,r){return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,r):new Uint16Array(t,n,r)},r(a)}),define("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,t,n){"use strict";var r={};return r.clipTriangleAtAxisAlignedThreshold=function(e,n,r,i,a,o){t(o)?o.length=0:o=[];var u,s,c;n?(u=e>r,s=e>i,c=e>a):(u=r>e,s=i>e,c=a>e);var l,f,h,d,E,_,m=u+s+c;return 1===m?u?(l=(e-r)/(i-r),f=(e-r)/(a-r),o.push(1),o.push(2),1!==f&&(o.push(-1),o.push(0),o.push(2),o.push(f)),1!==l&&(o.push(-1),o.push(0),o.push(1),o.push(l))):s?(h=(e-i)/(a-i),d=(e-i)/(r-i),o.push(2),o.push(0),1!==d&&(o.push(-1),o.push(1),o.push(0),o.push(d)),1!==h&&(o.push(-1),o.push(1),o.push(2),o.push(h))):c&&(E=(e-a)/(r-a),_=(e-a)/(i-a),o.push(0),o.push(1),1!==_&&(o.push(-1),o.push(2),o.push(1),o.push(_)),1!==E&&(o.push(-1),o.push(2),o.push(0),o.push(E))):2===m?u||r===e?s||i===e?c||a===e||(f=(e-r)/(a-r),h=(e-i)/(a-i),o.push(2),o.push(-1),o.push(0),o.push(2),o.push(f),o.push(-1),o.push(1),o.push(2),o.push(h)):(_=(e-a)/(i-a),l=(e-r)/(i-r),o.push(1),o.push(-1),o.push(2),o.push(1),o.push(_),o.push(-1),o.push(0),o.push(1),o.push(l)):(d=(e-i)/(r-i),E=(e-a)/(r-a),o.push(0),o.push(-1),o.push(1),o.push(0),o.push(d),o.push(-1),o.push(2),o.push(0),o.push(E)):3!==m&&(o.push(0),o.push(1),o.push(2)),o},r.computeBarycentricCoordinates=function(n,r,i,a,o,u,s,c,l){var f=i-s,h=s-o,d=u-c,E=a-c,_=1/(d*f+h*E),m=r-c,p=n-s,R=(d*p+h*m)*_,T=(-E*p+f*m)*_,y=1-R-T;return t(l)?(l.x=R,l.y=T,l.z=y,l):new e(R,T,y)},r}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,i){"use strict";function a(r,i,a){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(i,e.ZERO)),n(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a}a.fromPoints=function(t,r){if(n(r)||(r=new a),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var i=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var d=t[h],E=d.x,_=d.y,m=d.z;i=Math.min(E,i),s=Math.max(E,s),o=Math.min(_,o),c=Math.max(_,c),u=Math.min(m,u),l=Math.max(m,l)}var p=r.minimum;p.x=i,p.y=o,p.z=u;var R=r.maximum;R.x=s,R.y=c,R.z=l;var T=e.add(p,R,r.center);return e.multiplyByScalar(T,.5,T),r},a.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new a(t.minimum,t.maximum):void 0},a.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return a.intersectPlane=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),a=n.normal,u=r.x*Math.abs(a.x)+r.y*Math.abs(a.y)+r.z*Math.abs(a.z),s=e.dot(t.center,a)+n.distance;return s-u>0?i.INSIDE:0>s+u?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersectPlane=function(e){return a.intersectPlane(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var i=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(n)))<r?0:i}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,i){var a;if(0===e)return 0===r?[]:[-i/r];if(0===r){if(0===i)return[0,0];var o=Math.abs(i),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(a=-i/e,0>a)return[];var s=Math.sqrt(a);return[-s,s]}if(0===i)return a=-r/e,0>a?[a,0]:[0,a];var c=r*r,l=4*e*i,f=n(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*n(r,t.sign(r)*Math.sqrt(f),t.EPSILON14);return r>0?[h/e,i/h]:[i/h,h/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var i,a,o=e,u=t/3,s=n/3,c=r,l=o*s,f=u*c,h=u*u,d=s*s,E=o*s-h,_=o*c-u*s,m=u*c-d,p=4*E*m-_*_;if(0>p){var R,T,y;h*f>=l*d?(R=o,T=E,y=-2*u*E+o*_):(R=c,T=m,y=-c*_+2*s*m);var A=0>y?-1:1,S=-A*Math.abs(R)*Math.sqrt(-p);a=-y+S;var N=a/2,M=0>N?-Math.pow(-N,1/3):Math.pow(N,1/3),I=a===S?-M:-T/M;return i=0>=T?M+I:-y/(M*M+I*I+T),h*f>=l*d?[(i-u)/o]:[-c/(i+s)]}var O=E,v=-2*u*E+o*_,w=m,g=-c*_+2*s*m,C=Math.sqrt(p),x=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*C,-v)/3);i=2*Math.sqrt(-O);var U=Math.cos(P);a=i*U;var D=i*(-U/2-x*Math.sin(P)),L=a+D>2*u?a-u:D-u,F=o,B=L/F;P=Math.abs(Math.atan2(c*C,-g)/3),i=2*Math.sqrt(-w),U=Math.cos(P),a=i*U,D=i*(-U/2-x*Math.sin(P));var z=-c,b=2*s>a+D?a+s:D+s,q=z/b,G=F*b,W=-L*b-F*z,X=L*z,V=(s*W-u*X)/(-u*W+s*G);return V>=B?q>=B?q>=V?[B,V,q]:[B,q,V]:[q,B,V]:q>=B?[V,B,q]:q>=V?[V,q,B]:[q,V,B]}var r={};return r.computeDiscriminant=function(e,t,n,r){var i=e*e,a=t*t,o=n*n,u=r*r,s=18*e*t*n*r+a*o-27*i*u-4*(e*o*n+a*t*r);return s},r.computeRealRoots=function(e,r,i,a){var o,u;if(0===e)return t.computeRealRoots(r,i,a);if(0===r){if(0===i){if(0===a)return[0,0,0];u=-a/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===a?(o=t.computeRealRoots(e,0,i),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,i,a)}return 0===i?0===a?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,a):0===a?(o=t.computeRealRoots(e,r,i),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,i,a)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<n.EPSILON14){var E=r.computeRealRoots(1,s,l);if(2===E.length){var _,m=E[0],p=E[1];if(m>=0&&p>=0){var R=Math.sqrt(m),T=Math.sqrt(p);return[h-T,h-R,h+R,h+T]}if(m>=0&&0>p)return _=Math.sqrt(m),[h-_,h+_];if(0>m&&p>=0)return _=Math.sqrt(p),[h-_,h+_]}return[]}if(d>0){var y=Math.sqrt(d),A=(s+d-c/y)/2,S=(s+d+c/y)/2,N=r.computeRealRoots(1,y,A),M=r.computeRealRoots(1,-y,S);return 0!==N.length?(N[0]+=h,N[1]+=h,0!==M.length?(M[0]+=h,M[1]+=h,N[1]<=M[0]?[N[0],N[1],M[0],M[1]]:M[1]<=N[0]?[M[0],M[1],N[0],N[1]]:N[0]>=M[0]&&N[1]<=M[1]?[M[0],N[0],N[1],M[1]]:M[0]>=N[0]&&M[1]<=N[1]?[N[0],M[0],M[1],N[1]]:N[0]>M[0]&&N[0]<M[1]?[M[0],N[0],M[1],N[1]]:[N[0],M[0],N[1],M[1]]):N):0!==M.length?(M[0]+=h,M[1]+=h,M):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,f=a*t+s-4*o,h=c*o-a*i*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var E,_,m=d[0],p=i-m,R=p*p,T=t/2,y=p/2,A=R-4*o,S=R+4*Math.abs(o),N=c-4*m,M=c+4*Math.abs(m);if(0>m||N*S>A*M){var I=Math.sqrt(N);E=I/2,_=0===I?0:(t*y-a)/I}else{var O=Math.sqrt(A);E=0===O?0:(t*y-a)/O,_=O/2}var v,w;0===T&&0===E?(v=0,w=0):n.sign(T)===n.sign(E)?(v=T+E,w=m/v):(w=T-E,v=m/w);var g,C;0===y&&0===_?(g=0,C=0):n.sign(y)===n.sign(_)?(g=y+_,C=o/g):(C=y-_,g=o/C);var x=r.computeRealRoots(1,v,g),P=r.computeRealRoots(1,w,C);if(0!==x.length)return 0!==P.length?x[1]<=P[0]?[x[0],x[1],P[0],P[1]]:P[1]<=x[0]?[P[0],P[1],x[0],x[1]]:x[0]>=P[0]&&x[1]<=P[1]?[P[0],x[0],x[1],P[1]]:P[0]>=x[0]&&P[1]<=x[1]?[x[0],P[0],P[1],x[1]]:x[0]>P[0]&&x[0]<P[1]?[P[0],x[0],P[1],x[1]]:[x[0],P[0],x[1],P[1]]:x;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,i){var a=e*e,o=a*e,u=t*t,s=u*t,c=n*n,l=c*n,f=r*r,h=f*r,d=i*i,E=d*i,_=u*c*f-4*s*h-4*e*l*f+18*e*t*n*h-27*a*f*f+256*o*E+i*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*f+144*a*n*f)+d*(144*e*u*n-27*u*u-128*a*c-192*a*t*r);return _},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,f=u/t,h=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return i(c,l,f,h);case 1:return a(c,l,f,h);case 2:return a(c,l,f,h);case 3:return i(c,l,f,h);case 4:return i(c,l,f,h);case 5:return a(c,l,f,h);case 6:return i(c,l,f,h);case 7:return i(c,l,f,h);case 8:return a(c,l,f,h);case 9:return i(c,l,f,h);case 10:return i(c,l,f,h);case 11:return a(c,l,f,h);case 12:return i(c,l,f,h);case 13:return i(c,l,f,h);case 14:return i(c,l,f,h);case 15:return i(c,l,f,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function i(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r}return i.getPoint=function(t,r,i){return n(i)||(i=new e),i=e.multiplyByScalar(t.direction,r,i),e.add(t.origin,i,i)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,i,a,o,u,s,c){"use strict";function l(t,r,i,o,u){u=n(u,!1);var s,c,l,f,h,d=t.origin,E=t.direction,_=e.subtract(i,r,m),A=e.subtract(o,r,p),S=e.cross(E,A,R),N=e.dot(_,S);if(u){if(N<a.EPSILON6)return;if(s=e.subtract(d,r,T),l=e.dot(s,S),0>l||l>N)return;if(c=e.cross(s,_,y),f=e.dot(E,c),0>f||l+f>N)return;h=e.dot(A,c)/N}else{if(Math.abs(N)<a.EPSILON6)return;var M=1/N;if(s=e.subtract(d,r,T),l=e.dot(s,S)*M,0>l||l>1)return;if(c=e.cross(s,_,y),f=e.dot(E,c)*M,0>f||l+f>1)return;h=e.dot(A,c)*M}return h}function f(e,t,n,r){var i=t*t-4*e*n;if(!(0>i)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}function h(t,n,i){r(i)||(i={});var a=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(a,u,R),l=e.dot(o,o),h=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,E=f(l,h,d,S);return r(E)?(i.start=E.root0,i.stop=E.root1,i):void 0}function d(e,t,n){var r=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function E(t,n,r,i,c){var l,f=i*i,h=c*c,E=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*h,_=c*(i*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],a.EPSILON15)+n.y),m=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*h+i*n.x+r,p=h*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],a.EPSILON15),R=c*(i*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),T=[];if(0===R&&0===p){if(l=u.computeRealRoots(E,_,m),0===l.length)return T;var y=l[0],A=Math.sqrt(Math.max(1-y*y,0));if(T.push(new e(i,c*y,c*-A)),T.push(new e(i,c*y,c*A)),2===l.length){var S=l[1],N=Math.sqrt(Math.max(1-S*S,0));T.push(new e(i,c*S,c*-N)),T.push(new e(i,c*S,c*N))}return T}var M=R*R,I=p*p,O=E*E,v=R*p,w=O+I,g=2*(_*E+v),C=2*m*E+_*_-I+M,x=2*(m*_-v),P=m*m-M;if(0===w&&0===g&&0===C&&0===x)return T;l=s.computeRealRoots(w,g,C,x,P);var U=l.length;if(0===U)return T;for(var D=0;U>D;++D){var L,F=l[D],B=F*F,z=Math.max(1-B,0),b=Math.sqrt(z);L=a.sign(E)===a.sign(m)?d(E*B+m,_*F,a.EPSILON12):a.sign(m)===a.sign(_*F)?d(E*B,_*F+m,a.EPSILON12):d(E*B+_*F,m,a.EPSILON12);var q=d(p*F,R,a.EPSILON15),G=L*q;0>G?T.push(new e(i,c*F,c*b)):G>0?T.push(new e(i,c*F,c*-b)):0!==b?(T.push(new e(i,c*F,c*-b)),T.push(new e(i,c*F,c*b)),++D):T.push(new e(i,c*F,c*b))}return T}var _={};_.rayPlane=function(t,n,i){r(i)||(i=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(!(Math.abs(c)<a.EPSILON15)){var l=(-n.distance-e.dot(s,o))/c;if(!(0>l))return i=e.multiplyByScalar(u,l,i),e.add(o,i,i)}};var m=new e,p=new e,R=new e,T=new e,y=new e;_.rayTriangle=function(t,n,i,a,o,u){var s=l(t,n,i,a,o);if(r(s)&&!(0>s))return r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var A=new c;_.lineSegmentTriangle=function(t,n,i,a,o,u,s){var c=A;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,i,a,o,u);return!r(f)||0>f||f>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var S={root0:0,root1:0};_.raySphere=function(e,t,n){return n=h(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var N=new c;_.lineSegmentSphere=function(t,n,i,a){var o=N,u=e.subtract(n,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),a=h(o,i,a),!r(a)||a.stop<0||a.start>s?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,s),a)};var M=new e,I=new e;_.rayEllipsoid=function(t,n){var r,i,a,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,M),l=e.multiplyComponents(s,t.direction,I),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return;var d=h*h;if(r=f-1,i=e.magnitudeSquared(l),a=i*r,a>d)return;if(d>a){o=h*h-a,u=-h+Math.sqrt(o);var E=u/i,_=r/u;return _>E?{start:E,stop:_}:{start:_,stop:E}}var m=Math.sqrt(r/i);return{start:m,stop:m}}return 1>f?(r=f-1,i=e.magnitudeSquared(l),a=i*r,o=h*h-a,u=-h+Math.sqrt(o),{start:0,stop:u/i}):0>h?(i=e.magnitudeSquared(l),{start:0,stop:-h/i}):void 0};var O=new e,v=new e,w=new e,g=new e,C=new e,x=new o,P=new o,U=new o,D=new o,L=new o,F=new o,B=new o,z=new e,b=new e,q=new t;_.grazingAltitudeLocation=function(t,n){var i=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(i,O);if(e.dot(u,s)>=0)return i;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,O),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,g),d=e.normalize(e.cross(h,f,v),v),_=e.normalize(e.cross(f,d,w),w),m=x;m[0]=f.x,m[1]=f.y,m[2]=f.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=_.x,m[7]=_.y,m[8]=_.z;var p=o.transpose(m,P),R=o.fromScale(n.radii,U),T=o.fromScale(n.oneOverRadii,D),y=L;y[0]=0,y[1]=-u.z,y[2]=u.y,y[3]=u.z,y[4]=0,y[5]=-u.x,y[6]=-u.y,y[7]=u.x,y[8]=0;var A,S,N=o.multiply(o.multiply(p,T,F),y,F),M=o.multiply(o.multiply(N,R,B),m,B),I=o.multiplyByVector(N,i,C),G=E(M,e.negate(I,O),0,0,1),W=G.length;if(W>0){for(var X=e.clone(e.ZERO,b),V=Number.NEGATIVE_INFINITY,H=0;W>H;++H){A=o.multiplyByVector(R,o.multiplyByVector(m,G[H],z),z);var Y=e.normalize(e.subtract(A,i,g),g),Z=e.dot(Y,u);Z>V&&(V=Z,X=e.clone(A,X))}var k=n.cartesianToCartographic(X,q);return V=a.clamp(V,0,1),S=e.magnitude(e.subtract(X,i,g))*Math.sqrt(1-V*V),S=c?-S:S,k.height=S,n.cartographicToCartesian(k,new e)}};var G=new e;return _.lineSegmentPlane=function(t,n,i,o){r(o)||(o=new e);var u=e.subtract(n,t,G),s=i.normal,c=e.dot(s,u);if(!(Math.abs(c)<a.EPSILON6)){var l=e.dot(s,t),f=-(i.distance+l)/c;if(!(0>f||f>1))return e.multiplyByScalar(u,f,o),e.add(t,o,o),o}},_.trianglePlaneIntersection=function(t,n,r,i){var a=i.normal,o=i.distance,u=e.dot(a,t)+o<0,s=e.dot(a,n)+o<0,c=e.dot(a,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return _.lineSegmentPlane(t,n,i,f),_.lineSegmentPlane(t,r,i,h),{positions:[t,n,r,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return _.lineSegmentPlane(n,r,i,f),_.lineSegmentPlane(n,t,i,h),{positions:[t,n,r,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return _.lineSegmentPlane(r,t,i,f),_.lineSegmentPlane(r,n,i,h),{positions:[t,n,r,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return _.lineSegmentPlane(n,t,i,f),_.lineSegmentPlane(r,t,i,h),{positions:[t,n,r,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return _.lineSegmentPlane(r,n,i,f),_.lineSegmentPlane(t,n,i,h),{positions:[t,n,r,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return _.lineSegmentPlane(t,r,i,f),_.lineSegmentPlane(n,r,i,h),{positions:[t,n,r,f,h],indices:[0,1,4,0,4,3,2,3,4]}}},_}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,i){return t(e).then(n,r,i)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=i(e),t}function n(t){return e(t,a)}function r(e){this.then=e}function i(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return a(r)}});return n}function a(e){var n=new r(function(n,r){try{return r?t(r(e)):a(e)}catch(i){return a(i)}});return n}function o(){function e(e,t,n){return h(e,t,n)}function n(e){return E(e)}function i(e){return E(a(e))}function u(e){return d(e)}var s,c,l,f,h,d,E;return c=new r(e),s={then:e,resolve:n,reject:i,progress:u,promise:c,resolver:{resolve:n,reject:i,progress:u}},l=[],f=[],h=function(e,t,n){var r,i;return r=o(),i="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,i)}),f.push(i),r.promise},d=function(e){return _(f,e),e},E=function(e){return e=t(e),h=e.then,E=t,d=p,_(l,e),f=l=A,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,i,a){return m(2,arguments),e(t,function(t){function u(e){_(e)}function s(e){E(e)}var c,l,f,h,d,E,_,m,R,T;if(R=t.length>>>0,c=Math.max(0,Math.min(n,R)),f=[],l=R-c+1,h=[],d=o(),c)for(m=d.progress,_=function(e){h.push(e),--l||(E=_=p,d.reject(h))},E=function(e){f.push(e),--c||(E=_=p,d.resolve(f))},T=0;R>T;++T)T in t&&e(t[T],s,u,m);else d.resolve(f);return d.then(r,i,a)})}function c(e,t,n,r){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,n,r)}function l(e,t,n,r){return m(1,arguments),h(e,R).then(t,n,r)}function f(){return h(arguments,R)}function h(t,n){return e(t,function(t){var r,i,a,u,s,c;if(a=i=t.length>>>0,r=[],c=o(),a)for(u=function(t,i){e(t,n).then(function(e){r[i]=e,--a||c.resolve(r)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--a;else c.resolve(r);return c.promise})}function d(t,n){var r=y.call(arguments,1);return e(t,function(t){var i;return i=t.length,r[0]=function(t,r,a){return e(t,function(t){return e(r,function(e){return n(t,e,a,i)})})},T.apply(t,r)})}function E(t,n,r){var i=arguments.length>2;return e(t,function(e){return e=i?r:e,n.resolve(e),e},function(e){return n.reject(e),a(e)},n.progress)}function _(e,t){for(var n,r=0;n=e[r++];)n(t)}function m(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function p(){}function R(e){return e}var T,y,A;return e.defer=o,e.resolve=t,e.reject=n,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=E,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(A,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(A,t)})})}},y=[].slice,T=[].reduce||function(e){var t,n,r,i,a;if(a=0,t=Object(this),i=t.length>>>0,n=arguments,n.length<=1)for(;;){if(a in t){r=t[a++];break}if(++a>=i)throw new TypeError}else r=n[1];for(;i>a;++a)a in t&&(r=e(r,t[a],a,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e,t,n){for(var r,i,a=0,o=e.length-1;o>=a;)if(r=~~((a+o)/2),i=n(e[r],t),0>i)a=r+1;else{if(!(i>0))return r;o=r-1}return~(o+1)}return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,n,r,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],i=function(e,t,n,r){n||(n=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+i:i+e},a=function(e,t,n,r,a,o){var u=r-e.length;return u>0&&(e=n||!a?i(e,r,o,n):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+i(c.toString(t),u||0,"0",!1),a(e,n,r,o,s)},u=function(e,t,n,r,i,o){return null!=r&&(e=e.slice(0,r)),a(e,"",t,n,i,o)},s=function(e,r,s,c,l,f,h){var d,E,_,m,p;if("%%"==e)return"%";for(var R=!1,T="",y=!1,A=!1,S=" ",N=s.length,M=0;s&&N>M;M++)switch(s.charAt(M)){case" ":T=" ";break;case"+":T="+";break;case"-":R=!0;break;case"'":S=s.charAt(M+1);break;case"0":y=!0;break;case"#":A=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,R=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[n++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,p=r?t[r.slice(0,-1)]:t[n++],h){case"s":return u(String(p),R,c,f,y,S);case"c":return u(String.fromCharCode(+p),R,c,f,y);case"b":return o(p,2,A,R,c,f,y);case"o":return o(p,8,A,R,c,f,y);case"x":return o(p,16,A,R,c,f,y);case"X":return o(p,16,A,R,c,f,y).toUpperCase();case"u":return o(p,10,A,R,c,f,y);case"i":case"d":return d=+p||0,d=Math.round(d-d%1),E=0>d?"-":T,p=E+i(String(Math.abs(d)),f,"0",!1),a(p,E,R,c,y);case"e":case"E":case"f":case"F":case"g":case"G":return d=+p,E=0>d?"-":T,_=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],p=E+Math.abs(d)[_](f),a(p,E,R,c,y)[m]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,n,r,i,a,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=i,this.second=a,
this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,i,a,o,u,s,c){"use strict";function l(e,t){return _.compare(e.julianDate,t.julianDate)}function f(e){T.julianDate=e;var n=_.leapSeconds,r=t(n,T,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var i=n[r].offset;if(r>0){var a=_.secondsDifference(n[r].julianDate,e);a>i&&(r--,i=n[r].offset)}_.addSeconds(e,i,e)}function h(e,n){T.julianDate=e;var r=_.leapSeconds,i=t(r,T,l);if(0>i&&(i=~i),0===i)return _.addSeconds(e,-r[0].offset,n);if(i>=r.length)return _.addSeconds(e,-r[i-1].offset,n);var a=_.secondsDifference(r[i].julianDate,e);return 0===a?_.addSeconds(e,-r[i].offset,n):1>=a?void 0:_.addSeconds(e,-r[--i].offset,n)}function d(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function E(e,t,n,r,i,a,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,0>r&&(r+=24);var f=a+(r*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function _(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,d(i,t,this),r===c.UTC&&f(this)}var m=new a,p=[31,28,31,30,31,30,31,31,30,31,30,31],R=29,T=new u,y=/^(\d{4})$/,A=/^(\d{4})-(\d{2})$/,S=/^(\d{4})-?(\d{3})$/,N=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,I=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+I.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,w=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,g="Invalid ISO 8601 date.";_.fromDate=function(e,t){var n=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(d(n[0],n[1],t),f(t),t):new _(n[0],n[1],c.UTC)},_.fromIso8601=function(e,t){e=e.replace(",",".");var n,a,u,s=e.split("T"),l=1,h=1,m=0,T=0,I=0,C=0,x=s[0],P=s[1];if(!r(x))throw new i(g);var U;if(s=x.match(M),null!==s){if(U=x.split("-").length-1,U>0&&2!==U)throw new i(g);n=+s[1],l=+s[2],h=+s[3]}else if(s=x.match(A),null!==s)n=+s[1],l=+s[2];else if(s=x.match(y),null!==s)n=+s[1];else{var D;if(s=x.match(S),null!==s){if(n=+s[1],D=+s[2],u=o(n),1>D||u&&D>366||!u&&D>365)throw new i(g)}else{if(s=x.match(N),null===s)throw new i(g);n=+s[1];var L=+s[2],F=+s[3]||0;if(U=x.split("-").length-1,U>0&&(!r(s[3])&&1!==U||r(s[3])&&2!==U))throw new i(g);var B=new Date(Date.UTC(n,0,4));D=7*L+F-B.getUTCDay()-3}a=new Date(Date.UTC(n,0,1)),a.setUTCDate(D),l=a.getUTCMonth()+1,h=a.getUTCDate()}if(u=o(n),1>l||l>12||1>h||(2!==l||!u)&&h>p[l-1]||u&&2===l&&h>R)throw new i(g);var z;if(r(P)){if(s=P.match(w),null!==s){if(U=P.split(":").length-1,U>0&&2!==U&&3!==U)throw new i(g);m=+s[1],T=+s[2],I=+s[3],C=1e3*+(s[4]||0),z=5}else if(s=P.match(v),null!==s){if(U=P.split(":").length-1,U>2)throw new i(g);m=+s[1],T=+s[2],I=60*+(s[3]||0),z=4}else{if(s=P.match(O),null===s)throw new i(g);m=+s[1],T=60*+(s[2]||0),z=3}if(T>=60||I>=61||m>24||24===m&&(T>0||I>0||C>0))throw new i(g);var b=s[z],q=+s[z+1],G=+(s[z+2]||0);switch(b){case"+":m-=q,T-=G;break;case"-":m+=q,T+=G;break;case"Z":break;default:T+=new Date(Date.UTC(n,l-1,h,m,T)).getTimezoneOffset()}}else T+=new Date(n,l-1,h).getTimezoneOffset();var W=60===I;for(W&&I--;T>=60;)T-=60,m++;for(;m>=24;)m-=24,h++;for(a=u&&2===l?R:p[l-1];h>a;)h-=a,l++,l>12&&(l-=12,n++),a=u&&2===l?R:p[l-1];for(;0>T;)T+=60,m--;for(;0>m;)m+=24,h--;for(;1>h;)l--,1>l&&(l+=12,n--),a=u&&2===l?R:p[l-1],h+=a;var X=E(n,l,h,m,T,I,C);return r(t)?(d(X[0],X[1],t),f(t)):t=new _(X[0],X[1],c.UTC),W&&_.addSeconds(t,1,t),t},_.now=function(e){return _.fromDate(new Date,e)};var C=new _(0,0,c.TAI);return _.toGregorianDate=function(e,t){var n=!1,i=h(e,C);r(i)||(_.addSeconds(e,-1,C),i=h(C,C),n=!0);var o=i.dayNumber,u=i.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var d=80*c/2447|0,E=c-(2447*d/80|0)|0;c=d/11|0;var m=d+2-12*c|0,p=100*(l-49)+f+c|0,R=u/s.SECONDS_PER_HOUR|0,T=u-R*s.SECONDS_PER_HOUR,y=T/s.SECONDS_PER_MINUTE|0;T-=y*s.SECONDS_PER_MINUTE;var A=0|T,S=(T-A)/s.SECONDS_PER_MILLISECOND;return R+=12,R>23&&(R-=24),n&&(A+=1),r(t)?(t.year=p,t.month=m,t.day=E,t.hour=R,t.minute=y,t.second=A,t.millisecond=S,t.isLeapSecond=n,t):new a(p,m,E,R,y,A,S,n)},_.toDate=function(e){var t=_.toGregorianDate(e,m),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},_.toIso8601=function(t,n){var i,a=_.toGregorianDate(t,a);return r(n)||0===a.millisecond?r(n)&&0!==n?(i=(.01*a.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a.year,a.month,a.day,a.hour,a.minute,a.second):(i=(.01*a.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,i))},_.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new _(e.dayNumber,e.secondsOfDay,c.TAI):void 0},_.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},_.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},_.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(_.secondsDifference(e,t))<=n},_.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},_.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},_.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},_.computeTaiMinusUtc=function(e){T.julianDate=e;var n=_.leapSeconds,r=t(n,T,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},_.addSeconds=function(e,t,n){return d(e.dayNumber,e.secondsOfDay+t,n)},_.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,r,n)},_.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,r,n)},_.addDays=function(e,t,n){var r=e.dayNumber+t;return d(r,e.secondsOfDay,n)},_.lessThan=function(e,t){return _.compare(e,t)<0},_.lessThanOrEquals=function(e,t){return _.compare(e,t)<=0},_.greaterThan=function(e,t){return _.compare(e,t)>0},_.greaterThanOrEquals=function(e,t){return _.compare(e,t)>=0},_.prototype.clone=function(e){return _.clone(this,e)},_.prototype.equals=function(e){return _.equals(this,e)},_.prototype.equalsEpsilon=function(e,t){return _.equalsEpsilon(this,e,t)},_.prototype.toString=function(){return _.toIso8601(this)},_.leapSeconds=[new u(new _(2441317,43210,c.TAI),10),new u(new _(2441499,43211,c.TAI),11),new u(new _(2441683,43212,c.TAI),12),new u(new _(2442048,43213,c.TAI),13),new u(new _(2442413,43214,c.TAI),14),new u(new _(2442778,43215,c.TAI),15),new u(new _(2443144,43216,c.TAI),16),new u(new _(2443509,43217,c.TAI),17),new u(new _(2443874,43218,c.TAI),18),new u(new _(2444239,43219,c.TAI),19),new u(new _(2444786,43220,c.TAI),20),new u(new _(2445151,43221,c.TAI),21),new u(new _(2445516,43222,c.TAI),22),new u(new _(2446247,43223,c.TAI),23),new u(new _(2447161,43224,c.TAI),24),new u(new _(2447892,43225,c.TAI),25),new u(new _(2448257,43226,c.TAI),26),new u(new _(2448804,43227,c.TAI),27),new u(new _(2449169,43228,c.TAI),28),new u(new _(2449534,43229,c.TAI),29),new u(new _(2450083,43230,c.TAI),30),new u(new _(2450630,43231,c.TAI),31),new u(new _(2451179,43232,c.TAI),32),new u(new _(2453736,43233,c.TAI),33),new u(new _(2454832,43234,c.TAI),34),new u(new _(2456109,43235,c.TAI),35),new u(new _(2457204,43236,c.TAI),36)],_}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var i=new n.constructor;for(var a in n)if(n.hasOwnProperty(a)){var o=n[a];r&&(o=t(o,r)),i[a]=o}return i}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var i=n[r],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function n(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,i,a){"use strict";function o(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,i=t(n.method,"GET"),a=n.data,u=n.headers,s=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return o.load(t,r,i,a,u,n,s),n.promise})}function u(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function s(e,t){for(var n=u(e,t),r=new ArrayBuffer(n.length),i=new Uint8Array(r),a=0;a<n.length;a++)i[a]=n.charCodeAt(a);return r}function c(e,n){n=t(n,"");var i=e[1],a=!!e[2],o=e[3];switch(n){case"":case"text":return u(a,o);case"arraybuffer":return s(a,o);case"blob":var c=s(a,o);return new Blob([c],{type:i});case"document":var l=new DOMParser;return l.parseFromString(u(a,o),i);case"json":return JSON.parse(u(a,o));default:throw new r("Unhandled responseType: "+n)}}var l=/^data:(.*?)(;base64)?,(.*)$/;return o.load=function(e,t,r,o,u,s,f){var h=l.exec(e);if(null!==h)return void s.resolve(c(h,t));var d=new XMLHttpRequest;if(n(f)&&n(d.overrideMimeType)&&d.overrideMimeType(f),d.open(r,e,!0),n(u))for(var E in u)u.hasOwnProperty(E)&&d.setRequestHeader(E,u[E]);n(t)&&(d.responseType=t),d.onload=function(){d.status>=200&&d.status<300?n(d.response)?s.resolve(d.response):n(d.responseXML)&&d.responseXML.hasChildNodes()?s.resolve(d.responseXML):n(d.responseText)?s.resolve(d.responseText):s.reject(new a("unknown XMLHttpRequest response type.")):s.reject(new i(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){s.reject(new i)},d.send(o)},o.defaultLoad=o.load,o}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,n){return e({url:t,headers:n})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";function i(n,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,r(n,i).then(function(e){return JSON.parse(e)})}var a={Accept:"application/json,*/*;q=0.01"};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,i,a,o,u,s,c,l,f){"use strict";function h(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))E(this,t.data);else if(r(t.url)){var i=this;this._downloadPromise=e(s(t.url),function(e){E(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else E(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function E(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=n.columnNames.indexOf("modifiedJulianDateUtc"),a=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),h=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),_=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>c||0>h||0>E||0>_)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=n.samples,p=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=_,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var R,T=e._addNewLeapSeconds,y=0,A=m.length;A>y;y+=e._columnCount){var S=m[y+i],N=m[y+_],M=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,I=new o(M,N,f.TAI);if(p.push(I),T){if(N!==R&&r(R)){var O=o.leapSeconds,v=t(O,I,d);if(0>v){var w=new u(I,N);O.splice(~v,0,w)}}R=N}}}function _(e,t,n,r,i){var a=n*r;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,n){return t+e*(n-t)}function p(e,t,n,r,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[a];if(c.equals(l)||r.equals(c))return _(e,n,i,s,u),u;if(r.equals(l))return _(e,n,a,s,u),u;var f=o.secondsDifference(r,c)/o.secondsDifference(l,c),h=i*s,d=a*s,E=n[h+e._ut1MinusUtcSecondsColumn],p=n[d+e._ut1MinusUtcSecondsColumn],R=p-E;if(R>.5||-.5>R){var T=n[h+e._taiMinusUtcSecondsColumn],y=n[d+e._taiMinusUtcSecondsColumn];T!==y&&(l.equals(r)?E=p:p-=y-T)}return u.xPoleWander=m(f,n[h+e._xPoleWanderRadiansColumn],n[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,n[h+e._yPoleWanderRadiansColumn],n[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,n[h+e._xCelestialPoleOffsetRadiansColumn],n[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,n[h+e._yCelestialPoleOffsetRadiansColumn],n[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,E,p),u}return h.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,n){if(r(this._samples)){if(r(n)||(n=new i(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var a=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var f=a[u],h=a[u+1],d=o.lessThanOrEquals(f,e),E=!r(h),_=E||o.greaterThanOrEquals(h,e);if(d&&_)return s=u,!E&&h.equals(e)&&++s,l=s+1,p(this,a,this._samples,e,s,l,n),n}var m=t(a,e,o.compare,this._dateColumn);return m>=0?(m<a.length-1&&a[m+1].equals(e)&&++m,s=m,l=m):(l=~m,s=l-1,0>s&&(s=0)),this._lastIndex=s,p(this,a,this._samples,e,s,l,n),n}if(r(this._dataError))throw new c(this._dataError)},h}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function i(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),i=h.exec(r);if(null!==i)return i[1]}}function a(){if(t(c))return c;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return c=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(a()).toString()}function s(e){t(l)||(l=t(r.toUrl)?o:u),t(f)||(f=document.createElement("a"));var n=l(e);return f.href=n,f.href=f.href,f.href}var c,l,f,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return s._cesiumScriptRegex=h,s.setBaseUrl=function(t){c=new e(t).resolve(new e(document.location.href))},s}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,n){this.x=e,this.y=t,this.s=n}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,i,a,o,u){"use strict";function s(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,i[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,n){var r=f;return r.dayNumber=t,r.secondsOfDay=n,a.daysDifference(r,e._sampleZeroDateTT)}function l(n,i){if(n._chunkDownloadsInProgress[i])return n._chunkDownloadsInProgress[i];var a=e.defer();n._chunkDownloadsInProgress[i]=a;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",i):t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[i]=!1;for(var t=n._samples,r=e.samples,o=i*n._samplesPerXysFile*3,u=0,s=r.length;s>u;++u)t[o+u]=r[u];a.resolve()}),a.promise}var f=new a(0,0,u.TAI);return s.prototype.preload=function(t,n,r,i){var a=c(this,t,n),o=c(this,r,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,d=[],E=f;h>=E;++E)d.push(l(this,E));return e.all(d)},s.prototype.computeXysRadians=function(e,t,n){var a=c(this,e,t);if(!(0>a)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,0>s&&(s=0));var h=!1,d=this._samples;if(r(d[3*s])||(l(this,s/this._samplesPerXysFile|0),h=!0),r(d[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),!h){r(n)?(n.x=0,n.y=0,n.s=0):n=new i(0,0,0);var E,_,m=a-s*this._stepSizeDays,p=this._work,R=this._denominators,T=this._coef,y=this._xTable;for(E=0;u>=E;++E)p[E]=m-y[E];for(E=0;u>=E;++E){for(T[E]=1,_=0;u>=_;++_)_!==E&&(T[E]*=p[_]);T[E]*=R[E];var A=3*(s+E);n.x+=T[E]*d[A++],n.y+=T[E]*d[A++],n.s+=T[E]*d[A]}return n}}}},s}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(r.requestFullscreen=i,n=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(r.requestFullscreen=i,n=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function i(){if(!t(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(p=!0,R=r(e[1]))}return p}function a(){return i()&&R}function o(){if(!t(T)&&(T=!1,!i()&&/ Safari\/[\.0-9]+/.test(m.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(T=!0,y=r(e[1]))}return T}function u(){return o()&&y}function s(){if(!t(A)){A=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(m.userAgent);null!==e&&(A=!0,S=r(e[1]),S.isNightly=!!e[2])}return A}function c(){return s()&&S}function l(){if(!t(N)){N=!1;var e;"Microsoft Internet Explorer"===m.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(N=!0,M=r(e[1]))):"Netscape"===m.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(N=!0,M=r(e[1])))}return N}function f(){return l()&&M}function h(){if(!t(I)){I=!1;var e=/Firefox\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(I=!0,O=r(e[1]))}return I}function d(){return t(v)||(v=/Windows/i.test(m.appVersion)),v}function E(){return h()&&O}function _(){return t(w)||(w="undefined"!=typeof PointerEvent&&(!t(m.pointerEnabled)||m.pointerEnabled)),w}var m;m="undefined"!=typeof navigator?navigator:{};var p,R,T,y,A,S,N,M,I,O,v,w,g={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:E,isWindows:d,hardwareConcurrency:e(m.hardwareConcurrency,3),supportsPointerEvents:_};return g.supportsFullscreen=function(){return n.supportsFullscreen()},g.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},g.supportsWebWorkers=function(){return"undefined"!=typeof Worker},g}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,i,a,o,u){"use strict";function s(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)}var c=new e;s.fromAxisAngle=function(t,r,i){var a=r/2,o=Math.sin(a);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,h=Math.cos(a);return n(i)?(i.x=u,i.y=l,i.z=f,i.w=h,i):new s(u,l,f,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var r,i,a,o,c,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],_=h+d+E;if(_>0)r=Math.sqrt(_+1),c=.5*r,r=.5/r,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var m=l,p=0;d>h&&(p=1),E>h&&E>d&&(p=2);var R=m[p],T=m[R];r=Math.sqrt(e[u.getElementIndex(p,p)]-e[u.getElementIndex(R,R)]-e[u.getElementIndex(T,T)]+1);var y=f;y[p]=.5*r,r=.5/r,c=(e[u.getElementIndex(T,R)]-e[u.getElementIndex(R,T)])*r,y[R]=(e[u.getElementIndex(R,p)]+e[u.getElementIndex(p,R)])*r,y[T]=(e[u.getElementIndex(T,p)]+e[u.getElementIndex(p,T)])*r,i=-y[0],a=-y[1],o=-y[2]}return n(t)?(t.x=i,t.y=a,t.z=o,t.w=c,t):new s(i,a,o,c)};var h=new s;s.fromHeadingPitchRoll=function(t,n,r,i){var a=s.fromAxisAngle(e.UNIT_X,r,h),o=s.fromAxisAngle(e.UNIT_Y,-n,i);i=s.multiply(o,a,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,h);return s.multiply(u,i,i)};var d=new e,E=new e,_=new s,m=new s,p=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i.x=e[r],i.y=e[r+1],i.z=e[r+2],i.w=e[r+3],i},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,p),s.conjugate(p,p);for(var i=0,a=n-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),_),s.multiply(_,p,_),_.w<0&&s.negate(_,_),s.computeAxis(_,d);var u=s.computeAngle(_);r[o]=d.x*u,r[o+1]=d.y*u,r[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*a,m),0===u?s.clone(s.IDENTITY,_):s.fromAxisAngle(E,u,_),s.multiply(_,m,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,i=e.y*n,a=e.z*n,o=e.w*n;return t.x=r,t.y=i,t.z=a,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+r*l+i*c-a*s,h=o*s-r*c+i*l+a*u,d=o*c+r*s-i*u+a*l,E=o*l-r*u-i*s-a*c;return n.x=f,n.y=h,n.z=d,n.w=E,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var R=new s;s.lerp=function(e,t,n,r){return R=s.multiplyByScalar(t,n,R),r=s.multiplyByScalar(e,1-n,r),s.add(R,r,r)};var T=new s,y=new s,A=new s;s.slerp=function(e,t,n,r){var i=s.dot(e,t),a=t;if(0>i&&(i=-i,a=T=s.negate(t,T)),1-i<o.EPSILON6)return s.lerp(e,a,n,r);var u=Math.acos(i);return y=s.multiplyByScalar(e,Math.sin((1-n)*u),y),A=s.multiplyByScalar(a,Math.sin(n*u),A),r=s.add(y,A,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),i=0;return 0!==r&&(i=r/Math.sin(r)),e.multiplyByScalar(t,i,n)},s.exp=function(t,n){var r=e.magnitude(t),i=0;return 0!==r&&(i=Math.sin(r)/r),n.x=t.x*i,n.y=t.y*i,n.z=t.z*i,n.w=Math.cos(r),n};var S=new e,N=new e,M=new s,I=new s;s.computeInnerQuadrangle=function(t,n,r,i){var a=s.conjugate(n,M);s.multiply(a,r,I);var o=s.log(I,S);s.multiply(a,t,I);var u=s.log(I,N);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,M),s.multiply(n,M,i)},s.squad=function(e,t,n,r,i,a){var o=s.slerp(e,t,i,M),u=s.slerp(n,r,i,I);return s.slerp(o,u,2*i*(1-i),a)};for(var O=new s,v=1.9011074535173003,w=i.supportsTypedArrays()?new Float32Array(8):[],g=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var U=P+1,D=2*U+1;w[P]=1/(U*D),g[P]=U/D}return w[7]=v/136,g[7]=8*v/17,s.fastSlerp=function(e,t,n,r){var i,a=s.dot(e,t);a>=0?i=1:(i=-1,a=-a);for(var o=a-1,u=1-n,c=n*n,l=u*u,f=7;f>=0;--f)C[f]=(w[f]*c-g[f])*o,x[f]=(w[f]*l-g[f])*o;var h=i*n*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),d=u*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),E=s.multiplyByScalar(e,d,O);return s.multiplyByScalar(t,h,r),s.add(E,r,r)},s.fastSquad=function(e,t,n,r,i,a){
var o=s.fastSlerp(e,t,i,M),u=s.fastSlerp(n,r,i,I);return s.fastSlerp(o,u,2*i*(1-i),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,E,_,m,p){"use strict";var R={},T=new n,y=new n,A=new n;R.eastNorthUpToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return a(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=T,s=y,l=A;return t=i(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),a(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var S=new n,N=new n,M=new n;R.northEastDownToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return a(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=S,s=N,l=M;return t=i(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),a(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},R.northUpEastToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return a(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=T,s=y,l=A;return t=i(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),a(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var I=new m,O=new n(1,1,1),v=new _;R.headingPitchRollToFixedFrame=function(e,t,r,i,a,o){var u=m.fromHeadingPitchRoll(t,r,i,I),s=_.fromTranslationQuaternionRotationScale(n.ZERO,u,O,v);return o=R.eastNorthUpToFixedFrame(e,a,o),_.multiply(o,s,o)};var w=new _,g=new E;R.headingPitchRollQuaternion=function(e,t,n,r,i,a){var o=R.headingPitchRollToFixedFrame(e,t,n,r,i,w),u=_.getRotation(o,g);return m.fromRotationMatrix(u,a)};var C=24110.54841,x=8640184.812866,P=.093104,U=-62e-7,D=1.1772758384668e-19,L=72921158553e-15,F=d.TWO_PI/86400,B=new h;R.computeTemeToPseudoFixedMatrix=function(e,t){B=h.addSeconds(e,-h.computeTaiMinusUtc(e),B);var n,r=B.dayNumber,i=B.secondsOfDay,o=r-2451545;n=i>=43200?(o+.5)/p.DAYS_PER_JULIAN_CENTURY:(o-.5)/p.DAYS_PER_JULIAN_CENTURY;var u=C+n*(x+n*(P+n*U)),s=u*F%d.TWO_PI,c=L+D*(r-2451545.5),l=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,f=s+c*l,_=Math.cos(f),m=Math.sin(f);return a(t)?(t[0]=_,t[1]=-m,t[2]=0,t[3]=m,t[4]=_,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(_,m,0,-m,_,0,0,0,1)},R.iau2006XysData=new l,R.earthOrientationParameters=u.NONE;var z=32.184,b=2451545;R.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+z,i=t.stop.dayNumber,a=t.stop.secondsOfDay+z,o=R.iau2006XysData.preload(n,r,i,a),u=R.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},R.computeIcrfToFixedMatrix=function(e,t){a(t)||(t=new E);var n=R.computeFixedToIcrfMatrix(e,t);if(a(n))return E.transpose(n,t)};var q=new f(0,0,0),G=new s(0,0,0,0,0,0),W=new E,X=new E;R.computeFixedToIcrfMatrix=function(e,t){a(t)||(t=new E);var n=R.earthOrientationParameters.compute(e,G);if(a(n)){var r=e.dayNumber,i=e.secondsOfDay+z,o=R.iau2006XysData.computeXysRadians(r,i,q);if(a(o)){var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=E.fromRotationZ(-o.s,X),_=E.multiply(l,f,W),m=e.dayNumber,T=e.secondsOfDay-h.computeTaiMinusUtc(e)+n.ut1MinusUtc,y=m-2451545,A=T/p.SECONDS_PER_DAY,S=.779057273264+A+.00273781191135448*(y+A);S=S%1*d.TWO_PI;var N=E.fromRotationZ(S,X),M=E.multiply(_,N,W),I=Math.cos(n.xPoleWander),O=Math.cos(n.yPoleWander),v=Math.sin(n.xPoleWander),w=Math.sin(n.yPoleWander),g=r-b+i/p.SECONDS_PER_DAY;g/=36525;var C=-47e-6*g*d.RADIANS_PER_DEGREE/3600,x=Math.cos(C),P=Math.sin(C),U=X;return U[0]=I*x,U[1]=I*P,U[2]=v,U[3]=-O*P+w*v*x,U[4]=O*x+w*v*P,U[5]=-w*I,U[6]=-w*P-O*v*x,U[7]=w*x-O*v*P,U[8]=O*I,E.multiply(M,U,t)}}};var V=new r;R.pointToWindowCoordinates=function(e,t,n,r){return r=R.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},R.pointToGLWindowCoordinates=function(e,n,i,o){a(o)||(o=new t);var u=V;return _.multiplyByVector(e,r.fromElements(i.x,i.y,i.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),_.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var H=new n,Y=new n,Z=new n;return R.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=i(r,c.WGS84).geodeticSurfaceNormal(e,H),s=n.cross(t,u,Y);n.equalsEpsilon(s,n.ZERO,d.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,Z);return n.cross(t,l,s),n.negate(s,s),a(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},R}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,E){"use strict";function _(e,t){t=i(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=E.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(f.getColumn(r,0,m)),this._yAxis=n.fromCartesian4(f.getColumn(r,1,m));var a=n.fromCartesian4(f.getColumn(r,2,m));this._plane=h.fromPointNormal(e,a)}var m=new r;o(_.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var p=new e;_.fromPoints=function(t,n){var r=e.fromPoints(t,p);return new _(r.center,n)};var R=new d,T=new n;_.prototype.projectPointOntoPlane=function(e,r){var i=R;i.origin=e,n.normalize(e,i.direction);var o=c.rayPlane(i,this._plane,T);if(a(o)||(n.negate(i.direction,i.direction),o=c.rayPlane(i,this._plane,T)),a(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return a(r)?(r.x=s,r.y=l,r):new t(s,l)}},_.prototype.projectPointsOntoPlane=function(e,t){a(t)||(t=[]);for(var n=0,r=e.length,i=0;r>i;i++){var o=this.projectPointOntoPlane(e[i],t[n]);a(o)&&(t[n]=o,n++)}return t.length=n,t},_.prototype.projectPointToNearestOnPlane=function(e,r){a(r)||(r=new t);var i=R;i.origin=e,n.clone(this._plane.normal,i.direction);var o=c.rayPlane(i,this._plane,T);a(o)||(n.negate(i.direction,i.direction),o=c.rayPlane(i,this._plane,T));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},_.prototype.projectPointsToNearestOnPlane=function(e,t){a(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;n>r;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var y=new n;return _.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;a(t)?t.length=r:t=new Array(r);for(var i=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=y,l=0;r>l;++l){var f=e[l];n.multiplyByScalar(u,f.x,c),a(t[l])||(t[l]=new n);var h=n.add(o,c,t[l]);n.multiplyByScalar(s,f.y,c),n.add(h,c,h),i.scaleToGeocentricSurface(h,h)}return t},_}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,E){"use strict";function _(e,t){this.center=n.clone(i(e,n.ZERO)),this.halfAxes=h.clone(i(t,h.ZERO))}function m(e,t,r,i,o,u,s,c){a(c)||(c=new _);var l=c.halfAxes;h.setColumn(l,0,e.xAxis,l),h.setColumn(l,1,e.yAxis,l),h.setColumn(l,2,e.zAxis,l);var f=M;f.x=(t+r)/2,f.y=(i+o)/2,f.z=(u+s)/2;var d=I;d.x=(r-t)/2,d.y=(o-i)/2,d.z=(s-u)/2;var E=c.center;return f=h.multiplyByVector(l,f,f),n.add(e.origin,f,E),h.multiplyByScale(l,d,l),c}var p=new n,R=new n,T=new n,y=new n,A=new n,S=new h,N={unitary:new h,diagonal:new h};_.fromPoints=function(e,t){if(a(t)||(t=new _),!a(e)||0===e.length)return t.halfAxes=h.ZERO,t.center=n.ZERO,t;var r,i=e.length,o=n.clone(e[0],p);for(r=1;i>r;r++)n.add(o,e[r],o);var u=1/i;n.multiplyByScalar(o,u,o);var s,c=0,l=0,f=0,d=0,E=0,m=0;for(r=0;i>r;r++)s=n.subtract(e[r],o,R),c+=s.x*s.x,l+=s.x*s.y,f+=s.x*s.z,d+=s.y*s.y,E+=s.y*s.z,m+=s.z*s.z;c*=u,l*=u,f*=u,d*=u,E*=u,m*=u;var M=S;M[0]=c,M[1]=l,M[2]=f,M[3]=l,M[4]=d,M[5]=E,M[6]=f,M[7]=E,M[8]=m;var I=h.computeEigenDecomposition(M,N),O=h.transpose(I.unitary,t.halfAxes);s=n.subtract(e[0],o,R);var v=h.multiplyByVector(O,s,T),w=n.clone(v,y),g=n.clone(v,A);for(r=1;i>r;r++)s=n.subtract(e[r],o,s),h.multiplyByVector(O,s,v),n.minimumByComponent(g,v,g),n.maximumByComponent(w,v,w);var C=n.add(g,w,T);n.multiplyByScalar(C,.5,C),h.multiplyByVector(O,C,C),n.add(o,C,t.center);var x=n.subtract(w,g,T);return n.multiplyByScalar(x,.5,x),h.multiplyByScale(t.halfAxes,x,t.halfAxes),t};var M=new n,I=new n,O=new r,v=new n,w=[new r,new r,new r,new r,new r,new r,new r,new r],g=[new n,new n,new n,new n,new n,new n,new n,new n],C=[new t,new t,new t,new t,new t,new t,new t,new t];_.fromRectangle=function(e,t,n,r,a){t=i(t,0),n=i(n,0),r=i(r,u.WGS84);var o=E.center(e,O),c=r.cartographicToCartesian(o,v),l=new s(c,r),f=l.plane,h=w[0],_=w[1],p=w[2],R=w[3],T=w[4],y=w[5],A=w[6],S=w[7],N=o.longitude,M=e.south<0&&e.north>0?0:o.latitude;A.latitude=y.latitude=T.latitude=e.south,S.latitude=R.latitude=M,h.latitude=_.latitude=p.latitude=e.north,A.longitude=S.longitude=h.longitude=e.west,y.longitude=_.longitude=N,T.longitude=R.longitude=p.longitude=e.east,p.height=_.height=h.height=S.height=A.height=y.height=T.height=R.height=n,r.cartographicArrayToCartesianArray(w,g),l.projectPointsToNearestOnPlane(g,C);var I=Math.min(C[6].x,C[7].x,C[0].x),x=Math.max(C[2].x,C[3].x,C[4].x),P=Math.min(C[4].y,C[5].y,C[6].y),U=Math.max(C[0].y,C[1].y,C[2].y);p.height=h.height=T.height=A.height=t,r.cartographicArrayToCartesianArray(w,g);var D=Math.min(d.getPointDistance(f,g[0]),d.getPointDistance(f,g[2]),d.getPointDistance(f,g[4]),d.getPointDistance(f,g[6])),L=n;return m(l,I,x,P,U,D,L,a)},_.clone=function(e,t){return a(e)?a(t)?(n.clone(e.center,t.center),h.clone(e.halfAxes,t.halfAxes),t):new _(e.center,e.halfAxes):void 0},_.intersectPlane=function(e,t){var r=e.center,i=t.normal,a=e.halfAxes,o=i.x,u=i.y,s=i.z,l=Math.abs(o*a[h.COLUMN0ROW0]+u*a[h.COLUMN0ROW1]+s*a[h.COLUMN0ROW2])+Math.abs(o*a[h.COLUMN1ROW0]+u*a[h.COLUMN1ROW1]+s*a[h.COLUMN1ROW2])+Math.abs(o*a[h.COLUMN2ROW0]+u*a[h.COLUMN2ROW1]+s*a[h.COLUMN2ROW2]),f=n.dot(i,r)+t.distance;return-l>=f?c.OUTSIDE:f>=l?c.INSIDE:c.INTERSECTING};var x=new n,P=new n,U=new n,D=new n;_.distanceSquaredTo=function(e,t){var r=n.subtract(t,e.center,M),i=e.halfAxes,a=h.getColumn(i,0,x),o=h.getColumn(i,1,P),u=h.getColumn(i,2,U),s=n.magnitude(a),c=n.magnitude(o),l=n.magnitude(u);n.normalize(a,a),n.normalize(o,o),n.normalize(u,u);var f=D;f.x=n.dot(r,a),f.y=n.dot(r,o),f.z=n.dot(r,u);var d,E=0;return f.x<-s?(d=f.x+s,E+=d*d):f.x>s&&(d=f.x-s,E+=d*d),f.y<-c?(d=f.y+c,E+=d*d):f.y>c&&(d=f.y-c,E+=d*d),f.z<-l?(d=f.z+l,E+=d*d):f.z>l&&(d=f.z-l,E+=d*d),E};var L=new n,F=new n;_.computePlaneDistances=function(e,t,r,i){a(i)||(i=new l);var o=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,s=e.center,c=e.halfAxes,f=h.getColumn(c,0,x),d=h.getColumn(c,1,P),E=h.getColumn(c,2,U),_=n.add(f,d,L);n.add(_,E,_),n.add(_,s,_);var m=n.subtract(_,t,F),p=n.dot(r,m);return o=Math.min(p,o),u=Math.max(p,u),n.add(s,f,_),n.add(_,d,_),n.subtract(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.add(s,f,_),n.subtract(_,d,_),n.add(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.add(s,f,_),n.subtract(_,d,_),n.subtract(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.subtract(s,f,_),n.add(_,d,_),n.add(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.subtract(s,f,_),n.add(_,d,_),n.subtract(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.subtract(s,f,_),n.subtract(_,d,_),n.add(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),n.subtract(s,f,_),n.subtract(_,d,_),n.subtract(_,E,_),n.subtract(_,t,m),p=n.dot(r,m),o=Math.min(p,o),u=Math.max(p,u),i.start=o,i.stop=u,i};var B=new e;return _.isOccluded=function(t,n){var r=e.fromOrientedBoundingBox(t,B);return!n.isBoundingSphereVisible(r)},_.prototype.intersectPlane=function(e){return _.intersectPlane(this,e)},_.prototype.distanceSquaredTo=function(e){return _.distanceSquaredTo(this,e)},_.prototype.computePlaneDistances=function(e,t,n){return _.computePlaneDistances(this,e,t,n)},_.prototype.isOccluded=function(e){return _.isOccluded(this,e)},_.equals=function(e,t){return e===t||a(e)&&a(t)&&n.equals(e.center,t.center)&&h.equals(e.halfAxes,t.halfAxes)},_.prototype.clone=function(e){return _.clone(this,e)},_.prototype.equals=function(e){return _.equals(this,e)},_}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var n,r=t.name,i=t.message;n=e(r)&&e(i)?r+": "+i:t.toString();var a=t.stack;return e(a)&&(n+="\n"+a),n}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,n){"use strict";function r(r){var i,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,a)}catch(c){c instanceof Error?o.error={name:c.name,message:c.message,stack:c.stack}:o.error=c}t(i)||(i=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{i(o,a)}catch(c){o.result=void 0,o.error="postMessage failed with error: "+n(c)+"\n  with responseMessage: "+JSON.stringify(o),i(o)}}}return r}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/IndexDatatype","../Core/Intersections2D","../Core/Math","../Core/OrientedBoundingBox","./createTaskProcessorWorker"],function(e,t,n,r,i,a,o,u,s,c,l,f,h){"use strict";function d(e,n){var i=e.isEastChild,h=e.isNorthChild,d=i?R:0,_=i?p:R,P=h?R:0,U=h?p:R,D=M,L=I,F=O,B=w;D.length=0,L.length=0,F.length=0,B.length=0;var z=v;z.length=0;var b,q,G,W,X={},V=e.vertices,H=e.encodedNormals,Y=e.indices,Z=V.length/3,k=V.subarray(0,Z),K=V.subarray(Z,2*Z),j=V.subarray(2*Z,3*Z),J=0,Q=a(H);for(b=0,q=0;Z>b;++b,q+=2)G=k[b],W=K[b],(i&&G>=R||!i&&R>=G)&&(h&&W>=R||!h&&R>=W)&&(X[b]=J,D.push(G),L.push(W),F.push(j[b]),Q&&(B.push(H[q]),B.push(H[q+1])),++J);var $=[];$.push(new E),$.push(new E),$.push(new E);var ee=[];ee.push(new E),ee.push(new E),ee.push(new E);var te,ne;for(b=0;b<Y.length;b+=3){var re=Y[b],ie=Y[b+1],ae=Y[b+2],oe=k[re],ue=k[ie],se=k[ae];$[0].initializeIndexed(k,K,j,H,re),$[1].initializeIndexed(k,K,j,H,ie),$[2].initializeIndexed(k,K,j,H,ae);var ce=c.clipTriangleAtAxisAlignedThreshold(R,i,oe,ue,se,T);te=0,te>=ce.length||(te=ee[0].initializeFromClipResult(ce,te,$),te>=ce.length||(te=ee[1].initializeFromClipResult(ce,te,$),te>=ce.length||(te=ee[2].initializeFromClipResult(ce,te,$),ne=c.clipTriangleAtAxisAlignedThreshold(R,h,ee[0].getV(),ee[1].getV(),ee[2].getV(),y),m(D,L,F,B,z,X,ne,ee,Q),te<ce.length&&(ee[2].clone(ee[1]),ee[2].initializeFromClipResult(ce,te,$),ne=c.clipTriangleAtAxisAlignedThreshold(R,h,ee[0].getV(),ee[1].getV(),ee[2].getV(),y),m(D,L,F,B,z,X,ne,ee,Q)))))}var le=i?-p:0,fe=h?-p:0,he=e.minimumHeight,de=e.maximumHeight,Ee=[],_e=[],me=[],pe=[],Re=Number.MAX_VALUE,Te=-Re,ye=A;ye.length=0;var Ae=o.clone(e.ellipsoid),Se=e.childRectangle,Ne=Se.north,Me=Se.south,Ie=Se.east,Oe=Se.west;for(Oe>Ie&&(Ie+=l.TWO_PI),b=0;b<D.length;++b){G=Math.round(D[b]),d>=G?(Ee.push(b),G=0):G>=_?(me.push(b),G=p):G=2*G+le,D[b]=G,W=Math.round(L[b]),P>=W?(_e.push(b),W=0):W>=U?(pe.push(b),W=p):W=2*W+fe,L[b]=W;var ve=l.lerp(he,de,F[b]/p);Re>ve&&(Re=ve),ve>Te&&(Te=ve),F[b]=ve,S.longitude=l.lerp(Oe,Ie,G/p),S.latitude=l.lerp(Me,Ne,W/p),S.height=ve,Ae.cartographicToCartesian(S,N),ye.push(N.x),ye.push(N.y),ye.push(N.z)}var we=t.fromVertices(ye,r.ZERO,3,C),ge=f.fromRectangle(Se,Re,Te,Ae,x),Ce=new u(Ae),xe=Ce.computeHorizonCullingPointFromVertices(we.center,ye,3,we.center,g),Pe=Te-Re,Ue=new Uint16Array(D.length+L.length+F.length);for(b=0;b<D.length;++b)Ue[b]=D[b];var De=D.length;for(b=0;b<L.length;++b)Ue[De+b]=L[b];for(De+=L.length,b=0;b<F.length;++b)Ue[De+b]=p*(F[b]-Re)/Pe;var Le,Fe=s.createTypedArray(D.length,z);if(Q){var Be=new Uint8Array(B);n.push(Ue.buffer,Fe.buffer,Be.buffer),Le=Be.buffer}else n.push(Ue.buffer,Fe.buffer);return{vertices:Ue.buffer,encodedNormals:Le,indices:Fe.buffer,minimumHeight:Re,maximumHeight:Te,westIndices:Ee,southIndices:_e,eastIndices:me,northIndices:pe,boundingSphere:we,orientedBoundingBox:ge,horizonOcclusionPoint:xe}}function E(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function _(t,n){++U;var i=D[U],a=L[U];return i=e.octDecode(t.first.getNormalX(),t.first.getNormalY(),i),a=e.octDecode(t.second.getNormalX(),t.second.getNormalY(),a),N=r.lerp(i,a,t.ratio,N),r.normalize(N,N),e.octEncode(N,n),--U,n}function m(e,t,n,r,i,o,u,s,c){if(0!==u.length){for(var l=0,f=0;f<u.length;)f=F[l++].initializeFromClipResult(u,f,s);for(var h=0;l>h;++h){var d=F[h];if(d.isIndexed())d.newIndex=o[d.index],d.uBuffer=e,d.vBuffer=t,d.heightBuffer=n,c&&(d.normalBuffer=r);else{var E=d.getKey();if(a(o[E]))d.newIndex=o[E];else{var _=e.length;e.push(d.getU()),t.push(d.getV()),n.push(d.getH()),c&&(r.push(d.getNormalX()),r.push(d.getNormalY())),d.newIndex=_,o[E]=_}}}3===l?(i.push(F[0].newIndex),i.push(F[1].newIndex),i.push(F[2].newIndex)):4===l&&(i.push(F[0].newIndex),i.push(F[1].newIndex),i.push(F[2].newIndex),i.push(F[0].newIndex),i.push(F[2].newIndex),i.push(F[3].newIndex))}}var p=32767,R=p/2|0,T=[],y=[],A=[],S=new i,N=new r,M=[],I=[],O=[],v=[],w=[],g=new r,C=new t,x=new f;E.prototype.clone=function(e){return a(e)||(e=new E),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.normalBuffer=this.normalBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},E.prototype.initializeIndexed=function(e,t,n,r,i){this.uBuffer=e,this.vBuffer=t,this.heightBuffer=n,this.normalBuffer=r,this.index=i,this.first=void 0,this.second=void 0,this.ratio=void 0},E.prototype.initializeInterpolated=function(e,t,n){this.vertexBuffer=void 0,this.index=void 0,this.newIndex=void 0,this.first=e,this.second=t,this.ratio=n},E.prototype.initializeFromClipResult=function(e,t,n){var r=t+1;return-1!==e[t]?n[e[t]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=n[e[r]],++r,this.second=n[e[r]],++r,this.ratio=e[r],++r),r},E.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},E.prototype.isIndexed=function(){return a(this.index)},E.prototype.getH=function(){return a(this.index)?this.heightBuffer[this.index]:l.lerp(this.first.getH(),this.second.getH(),this.ratio)},E.prototype.getU=function(){return a(this.index)?this.uBuffer[this.index]:l.lerp(this.first.getU(),this.second.getU(),this.ratio)},E.prototype.getV=function(){return a(this.index)?this.vBuffer[this.index]:l.lerp(this.first.getV(),this.second.getV(),this.ratio)};var P=new n,U=-1,D=[new r,new r],L=[new r,new r];E.prototype.getNormalX=function(){return a(this.index)?this.normalBuffer[2*this.index]:(P=_(this,P),P.x)},E.prototype.getNormalY=function(){return a(this.index)?this.normalBuffer[2*this.index+1]:(P=_(this,P),P.y)};var F=[];return F.push(new E),F.push(new E),F.push(new E),F.push(new E),h(d)})}();