/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},a.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return a>=i||i<=r*Math.max(Math.abs(e),Math.abs(n))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var n=i[t-1],r=t;e>=r;r++)i.push(n*r);return i[e]},a.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)}i.fromSpherical=function(n,r){t(r)||(r=new i);var a=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(e,n,r,a){return t(a)?(a.x=e,a.y=n,a.z=r,a):new i(e,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var n=i.dot(s,c),r=i.magnitude(i.cross(s,c,s));return Math.atan2(r,n)};var l=new i;i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):n.y<=n.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)},i.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,f=r*u-a*o;return n.x=c,n.y=l,n.z=f,n},i.fromDegrees=function(e,t,n,r,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,n,r,o)};var f=new i,d=new i,E=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(n,r,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:E,c=Math.cos(r);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(r),f=i.normalize(f,f),i.multiplyComponents(s,f,d);var l=Math.sqrt(i.dot(f,d));return d=i.divideByScalar(d,l,d),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(d,f,u)},i.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=a.toRadians(e[o]);return i.fromRadiansArray(r,t,n)},i.fromRadiansArray=function(e,n,r){var a=e.length;t(r)?r.length=a/2:r=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=i.fromRadians(u,s,0,n,r[o/2])}return r},i.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=a.toRadians(e[o]),r[o+1]=a.toRadians(e[o+1]),r[o+2]=e[o+2];return i.fromRadiansArrayHeights(r,t,n)},i.fromRadiansArrayHeights=function(e,n,r){var a=e.length;t(r)?r.length=a/3:r=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=i.fromRadians(u,s,c,n,r[o/3])}return r},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function a(n,a,u,s,c){var l=n.x,f=n.y,d=n.z,E=a.x,h=a.y,m=a.z,_=l*l*E*E,R=f*f*h*h,T=d*d*m*m,p=_+R+T,y=Math.sqrt(1/p),S=e.multiplyByScalar(n,y,i);if(s>p)return isFinite(y)?e.clone(S,c):void 0;var A=u.x,N=u.y,M=u.z,I=o;I.x=S.x*A*2,I.y=S.y*N*2,I.z=S.z*M*2;var O,v,w,C,g,x,P,U,D,F,L,B=(1-y)*e.magnitude(n)/(.5*e.magnitude(I)),z=0;do{B-=z,w=1/(1+B*A),C=1/(1+B*N),g=1/(1+B*M),x=w*w,P=C*C,U=g*g,D=x*w,F=P*C,L=U*g,O=_*x+R*P+T*U-1,v=_*D*A+R*F*N+T*L*M;var b=-2*v;z=O/b}while(Math.abs(O)>r.EPSILON12);return t(c)?(c.x=l*w,c.y=f*C,c.z=d*g,c):new e(l*w,f*C,d*g)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,a,i){return a=t(a,0),n(i)?(i.longitude=e,i.latitude=r,i.height=a,i):new u(e,r,a)},u.fromDegrees=function(e,t,n,r){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,n,r)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),E=i.EPSILON1;return u.fromCartesian=function(t,r,a){var h=n(r)?r.oneOverRadii:f,m=n(r)?r.oneOverRadiiSquared:d,_=n(r)?r._centerToleranceSquared:E,R=o(t,h,m,_,c);if(n(R)){var T=e.multiplyComponents(t,m,s);T=e.normalize(T,T);var p=e.subtract(t,R,l),y=Math.atan2(T.y,T.x),S=Math.asin(T.z),A=i.sign(e.dot(p,t))*e.magnitude(p);return n(a)?(a.longitude=y,a.latitude=S,a.height=A,a):new u(y,S,A)}},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1}function l(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,c(this,e,t,n)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,n){if(r(t)){var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return r(t)||(t=new l),r(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,a){a=n(a,0),e.pack(t._radii,r,a)},l.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var f=new e,d=new e;l.prototype.cartographicToCartesian=function(t,n){var a=f,i=d;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var E=new e,h=new e,m=new e;return l.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,h);if(r(i)){var o=this.geodeticSurfaceNormal(i,E),s=e.subtract(n,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},l.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},l.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,a){"use strict";function i(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,d=1;f>d;d++){var E=t[d],h=E.x,m=E.y,_=E.z;a=Math.min(h,a),s=Math.max(h,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(_,u),l=Math.max(_,l)}var R=r.minimum;R.x=a,R.y=o,R.z=u;var T=r.maximum;T.x=s,T.y=c,T.z=l;var p=e.add(R,T,r.center);return e.multiplyByScalar(p,.5,p),r},i.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum):void 0},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return i.intersectPlane=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),i=n.normal,u=r.x*Math.abs(i.x)+r.y*Math.abs(i.y)+r.z*Math.abs(i.z),s=e.dot(t.center,i)+n.distance;return s-u>0?a.INSIDE:0>s+u?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e,n,r,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)}function u(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function s(e){for(var t=0,n=0;3>n;++n){var r=e[o.getElementIndex(E[n],d[n])];t+=2*r*r}return Math.sqrt(t)}function c(e,t){for(var n=i.EPSILON15,r=0,a=1,u=0;3>u;++u){var s=Math.abs(e[o.getElementIndex(E[u],d[u])]);s>r&&(a=u,r=s)}var c=1,l=0,f=d[a],h=E[a];if(Math.abs(e[o.getElementIndex(h,f)])>n){var m,_=e[o.getElementIndex(h,h)],R=e[o.getElementIndex(f,f)],T=e[o.getElementIndex(h,f)],p=(_-R)/2/T;m=0>p?-1/(-p+Math.sqrt(1+p*p)):1/(p+Math.sqrt(1+p*p)),c=1/Math.sqrt(1+m*m),l=m*c}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(f,f)]=t[o.getElementIndex(h,h)]=c,t[o.getElementIndex(h,f)]=l,t[o.getElementIndex(f,h)]=-l,t}o.packedLength=9,o.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},o.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a[4]=e[r+4],a[5]=e[r+5],a[6]=e[r+6],a[7]=e[r+7],a[8]=e[r+8],a},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,d=e.z*e.w,E=e.w*e.w,h=r-s-f+E,m=2*(a-d),_=2*(i+l),R=2*(a+d),T=-r+s-f+E,p=2*(c-u),y=2*(i-l),S=2*(c+u),A=-r-s+f+E;return n(t)?(t[0]=h,t[1]=R,t[2]=y,t[3]=m,t[4]=T,t[5]=S,t[6]=_,t[7]=p,t[8]=A,t):new o(h,m,_,R,T,p,y,S,A)},o.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new o(1,0,0,0,r,-a,0,a,r)},o.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new o(r,0,a,0,1,0,-a,0,r)},o.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(r,-a,0,a,r,0,0,0,1)},o.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},o.setColumn=function(e,t,n,r){r=o.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},o.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},o.setRow=function(e,t,n,r){return r=o.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;o.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var f=new e;o.getMaximumScale=function(t){return o.getScale(t,f),e.maximumComponent(f)},o.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},o.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},o.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},o.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},o.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},o.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var d=[1,0,0],E=[2,2,1],h=new o,m=new o;return o.computeEigenDecomposition=function(e,t){var r=i.EPSILON20,a=10,l=0,f=0;n(t)||(t={});for(var d=t.unitary=o.clone(o.IDENTITY,t.unitary),E=t.diagonal=o.clone(e,t.diagonal),_=r*u(E);a>f&&s(E)>_;)c(E,h),o.transpose(h,m),o.multiply(E,h,E),o.multiply(m,E,E),o.multiply(d,h,d),++l>2&&(++f,l=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},o.inverse=function(e,t){var n=e[0],a=e[1],u=e[2],s=e[3],c=e[4],l=e[5],f=e[6],d=e[7],E=e[8],h=o.determinant(e);if(Math.abs(h)<=i.EPSILON15)throw new r("matrix is not invertible");t[0]=c*E-d*l,t[1]=d*u-a*E,t[2]=a*l-c*u,t[3]=f*l-s*E,t[4]=n*E-f*u,t[5]=s*u-n*l,t[6]=s*d-f*c,t[7]=f*a-n*d,t[8]=n*c-s*a;var m=1/h;return o.multiplyByScalar(t,m,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},o.IDENTITY=a(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=a(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)}i.fromElements=function(e,n,r,a,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=a,o):new i(e,n,r,a)},i.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,s);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)&&a.equalsEpsilon(e.w,n.w,r,i)},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(e,t,r,a,i,o,u,s,c,l,f,d,E,h,m,_){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(E,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(h,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(m,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(_,0)}c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);
},c.fromRotationTranslation=function(t,a,i){return a=n(a,e.ZERO),r(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,a){r(a)||(a=new c);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,d=t.x*t.w,E=t.y*t.y,h=t.y*t.z,m=t.y*t.w,_=t.z*t.z,R=t.z*t.w,T=t.w*t.w,p=s-E-_+T,y=2*(l-R),S=2*(f+m),A=2*(l+R),N=-s+E-_+T,M=2*(h-d),I=2*(f-m),O=2*(h+d),v=-s-E+_+T;return a[0]=p*i,a[1]=A*i,a[2]=I*i,a[3]=0,a[4]=y*o,a[5]=N*o,a[6]=O*o,a[7]=0,a[8]=S*u,a[9]=M*u,a[10]=v*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,d=new e;c.fromCamera=function(t,n){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,d),d);var u=f.x,s=f.y,E=f.z,h=l.x,m=l.y,_=l.z,R=d.x,T=d.y,p=d.z,y=a.x,S=a.y,A=a.z,N=u*-y+s*-S+E*-A,M=R*-y+T*-S+p*-A,I=h*y+m*S+_*A;return r(n)?(n[0]=u,n[1]=R,n[2]=-h,n[3]=0,n[4]=s,n[5]=T,n[6]=-m,n[7]=0,n[8]=E,n[9]=p,n[10]=-_,n[11]=0,n[12]=N,n[13]=M,n[14]=I,n[15]=1,n):new c(u,s,E,N,R,T,p,M,-h,-m,-_,I,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,f=-(r+n)*s,d=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=d,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),f=-(i+a)/(i-a),d=-1,E=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=d,o[12]=0,o[13]=0,o[14]=E,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,f=-1,d=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=d,i[15]=0,i},c.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-t),d=c,E=l,h=f,m=i+c,_=o+l,R=t+f,T=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=E,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=h,a[11]=0,a[12]=m,a[13]=_,a[14]=R,a[15]=T,a},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},c.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},c.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var E=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],E)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],E)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],E)),n};var h=new e;c.getMaximumScale=function(t){return c.getScale(t,h),e.maximumComponent(h)},c.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],d=e[9],E=e[10],h=e[11],m=e[12],_=e[13],R=e[14],T=e[15],p=t[0],y=t[1],S=t[2],A=t[3],N=t[4],M=t[5],I=t[6],O=t[7],v=t[8],w=t[9],C=t[10],g=t[11],x=t[12],P=t[13],U=t[14],D=t[15],F=r*p+u*y+f*S+m*A,L=a*p+s*y+d*S+_*A,B=i*p+c*y+E*S+R*A,z=o*p+l*y+h*S+T*A,b=r*N+u*M+f*I+m*O,q=a*N+s*M+d*I+_*O,G=i*N+c*M+E*I+R*O,W=o*N+l*M+h*I+T*O,X=r*v+u*w+f*C+m*g,V=a*v+s*w+d*C+_*g,H=i*v+c*w+E*C+R*g,Y=o*v+l*w+h*C+T*g,Z=r*x+u*P+f*U+m*D,k=a*x+s*P+d*U+_*D,j=i*x+c*P+E*U+R*D,K=o*x+l*P+h*U+T*D;return n[0]=F,n[1]=L,n[2]=B,n[3]=z,n[4]=b,n[5]=q,n[6]=G,n[7]=W,n[8]=X,n[9]=V,n[10]=H,n[11]=Y,n[12]=Z,n[13]=k,n[14]=j,n[15]=K,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=e[12],E=e[13],h=e[14],m=t[0],_=t[1],R=t[2],T=t[4],p=t[5],y=t[6],S=t[8],A=t[9],N=t[10],M=t[12],I=t[13],O=t[14],v=r*m+o*_+c*R,w=a*m+u*_+l*R,C=i*m+s*_+f*R,g=r*T+o*p+c*y,x=a*T+u*p+l*y,P=i*T+s*p+f*y,U=r*S+o*A+c*N,D=a*S+u*A+l*N,F=i*S+s*A+f*N,L=r*M+o*I+c*O+d,B=a*M+u*I+l*O+E,z=i*M+s*I+f*O+h;return n[0]=v,n[1]=w,n[2]=C,n[3]=0,n[4]=g,n[5]=x,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=F,n[11]=0,n[12]=L,n[13]=B,n[14]=z,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=t[0],E=t[1],h=t[2],m=t[3],_=t[4],R=t[5],T=t[6],p=t[7],y=t[8],S=r*d+o*E+c*h,A=a*d+u*E+l*h,N=i*d+s*E+f*h,M=r*m+o*_+c*R,I=a*m+u*_+l*R,O=i*m+s*_+f*R,v=r*T+o*p+c*y,w=a*T+u*p+l*y,C=i*T+s*p+f*y;return n[0]=S,n[1]=A,n[2]=N,n[3]=0,n[4]=M,n[5]=I,n[6]=O,n[7]=0,n[8]=v,n[9]=w,n[10]=C,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var m=new e;c.multiplyByUniformScale=function(e,t,n){return m.x=t,m.y=t,m.z=t,c.multiplyByScale(e,m,n)},c.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var _=new u,R=new u,T=new t,p=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,_),R,o.EPSILON7)&&t.equals(c.getRow(e,3,T),p))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],l=e[12],f=e[1],d=e[5],E=e[9],h=e[13],m=e[2],y=e[6],S=e[10],A=e[14],N=e[3],M=e[7],I=e[11],O=e[15],v=S*O,w=A*I,C=y*O,g=A*M,x=y*I,P=S*M,U=m*O,D=A*N,F=m*I,L=S*N,B=m*M,z=y*N,b=v*d+g*E+x*h-(w*d+C*E+P*h),q=w*f+U*E+L*h-(v*f+D*E+F*h),G=C*f+D*d+B*h-(g*f+U*d+z*h),W=P*f+F*d+z*E-(x*f+L*d+B*E),X=w*a+C*i+P*l-(v*a+g*i+x*l),V=v*r+D*i+F*l-(w*r+U*i+L*l),H=g*r+U*a+z*l-(C*r+D*a+B*l),Y=x*r+L*a+B*i-(P*r+F*a+z*i);v=i*h,w=l*E,C=a*h,g=l*d,x=a*E,P=i*d,U=r*h,D=l*f,F=r*E,L=i*f,B=r*d,z=a*f;var Z=v*M+g*I+x*O-(w*M+C*I+P*O),k=w*N+U*I+L*O-(v*N+D*I+F*O),j=C*N+D*M+B*O-(g*N+U*M+z*O),K=P*N+F*M+z*I-(x*N+L*M+B*I),J=C*S+P*A+w*y-(x*A+v*y+g*S),Q=F*A+v*m+D*S-(U*S+L*A+w*m),$=U*y+z*A+g*m-(B*A+C*m+D*y),ee=B*S+x*m+L*y-(F*y+z*S+P*m),te=r*b+a*q+i*G+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=b*te,n[1]=q*te,n[2]=G*te,n[3]=W*te,n[4]=X*te,n[5]=V*te,n[6]=H*te,n[7]=Y*te,n[8]=Z*te,n[9]=k*te,n[10]=j*te,n[11]=K*te,n[12]=J*te,n[13]=Q*te,n[14]=$*te,n[15]=ee*te,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],d=e[13],E=e[14],h=-n*f-r*d-a*E,m=-i*f-o*d-u*E,_=-s*f-c*d-l*E;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=h,t[13]=m,t[14]=_,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function a(t,n){this.normal=e.clone(t),this.distance=n}a.fromPointNormal=function(n,r,i){var o=-e.dot(r,n);return t(i)?(e.clone(r,i.normal),i.distance=o,i):new a(r,o)};var i=new e;return a.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,i),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new a(o,u)},a.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},a.ORIGIN_XY_PLANE=r(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=r(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=r(new a(e.UNIT_Y,0)),a}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,n,r,a){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(a,0)}r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,a,i,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),n(o)?(o.west=e,o.south=r,o.east=a,o.north=i,o):new s(e,r,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,d=e.length;d>f;f++){var E=e[f];r=Math.min(r,E.longitude),a=Math.max(a,E.longitude),c=Math.min(c,E.latitude),l=Math.max(l,E.latitude);var h=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;i=Math.min(i,h),o=Math.max(o,h)}return a-r>o-i&&(r=i,a=o,a>u.PI&&(a-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=c,t.east=a,t.north=l,t):new s(r,c,a,l)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&l>=f)){var d=Math.max(e.south,t.south),E=Math.min(e.north,t.north);if(!(d>=E))return n(r)?(r.west=l,r.south=d,r.east=f,r.north=E,r):new s(l,d,f,E)}},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(i>n||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,a,o){r=t(r,i.WGS84),a=t(a,0),n(o)||(o=[]);var l=0,f=e.north,d=e.south,E=e.east,h=e.west,m=c;m.height=a,m.longitude=h,m.latitude=f,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=E,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.latitude=d,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=h,o[l]=r.cartographicToCartesian(m,o[l]),l++,0>f?m.latitude=f:d>0?m.latitude=d:m.latitude=0;for(var _=1;8>_;++_)m.longitude=-Math.PI+_*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=r.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=h,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=E,o[l]=r.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,f,d){"use strict";function E(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,m=new e,_=new e,R=new e,T=new e,p=new e,y=new e,S=new e,A=new e,N=new e,M=new e,I=new e;E.fromPoints=function(t,n){if(r(n)||(n=new E),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var a=e.clone(t[0],y),i=e.clone(a,h),o=e.clone(a,m),u=e.clone(a,_),s=e.clone(a,R),c=e.clone(a,T),l=e.clone(a,p),f=t.length,d=1;f>d;d++){e.clone(t[d],a);var O=a.x,v=a.y,w=a.z;O<i.x&&e.clone(a,i),O>s.x&&e.clone(a,s),v<o.y&&e.clone(a,o),v>c.y&&e.clone(a,c),w<u.z&&e.clone(a,u),w>l.z&&e.clone(a,l)}var C=e.magnitudeSquared(e.subtract(s,i,S)),g=e.magnitudeSquared(e.subtract(c,o,S)),x=e.magnitudeSquared(e.subtract(l,u,S)),P=i,U=s,D=C;g>D&&(D=g,P=o,U=c),x>D&&(D=x,P=u,U=l);var F=A;F.x=.5*(P.x+U.x),F.y=.5*(P.y+U.y),F.z=.5*(P.z+U.z);var L=e.magnitudeSquared(e.subtract(U,F,S)),B=Math.sqrt(L),z=N;z.x=i.x,z.y=o.y,z.z=u.z;var b=M;b.x=s.x,b.y=c.y,b.z=l.z;var q=e.multiplyByScalar(e.add(z,b,S),.5,I),G=0;for(d=0;f>d;d++){e.clone(t[d],a);var W=e.magnitude(e.subtract(a,q,S));W>G&&(G=W);var X=e.magnitudeSquared(e.subtract(a,F,S));if(X>L){var V=Math.sqrt(X);B=.5*(B+V),L=B*B;var H=V-B;F.x=(B*F.x+H*a.x)/V,F.y=(B*F.y+H*a.y)/V,F.z=(B*F.z+H*a.z)/V}}return G>B?(e.clone(F,n.center),n.radius=B):(e.clone(q,n.center),n.radius=G),n};var O=new o,v=new e,w=new e,C=new t,g=new t;E.fromRectangle2D=function(e,t,n){return E.fromRectangleWithHeights2D(e,t,0,0,n)},E.fromRectangleWithHeights2D=function(t,a,i,o,u){if(r(u)||(u=new E),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,O),d.southwest(t,C),C.height=i,d.northeast(t,g),g.height=o;var s=a.project(C,v),c=a.project(g,w),l=c.x-s.x,f=c.y-s.y,h=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+h*h);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*f,m.z=s.z+.5*h,u};var x=[];E.fromRectangle3D=function(e,t,a,o){t=n(t,i.WGS84),a=n(a,0);var u;return r(e)&&(u=d.subsample(e,t,a,x)),E.fromPoints(u,o)},E.fromVertices=function(t,a,i,o){if(r(o)||(o=new E),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=n(a,e.ZERO),i=n(i,3);var u=y;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,h),c=e.clone(u,m),l=e.clone(u,_),f=e.clone(u,R),d=e.clone(u,T),O=e.clone(u,p),v=t.length,w=0;v>w;w+=i){var C=t[w]+a.x,g=t[w+1]+a.y,x=t[w+2]+a.z;u.x=C,u.y=g,u.z=x,C<s.x&&e.clone(u,s),C>f.x&&e.clone(u,f),g<c.y&&e.clone(u,c),g>d.y&&e.clone(u,d),x<l.z&&e.clone(u,l),x>O.z&&e.clone(u,O)}var P=e.magnitudeSquared(e.subtract(f,s,S)),U=e.magnitudeSquared(e.subtract(d,c,S)),D=e.magnitudeSquared(e.subtract(O,l,S)),F=s,L=f,B=P;U>B&&(B=U,F=c,L=d),D>B&&(B=D,F=l,L=O);var z=A;z.x=.5*(F.x+L.x),z.y=.5*(F.y+L.y),z.z=.5*(F.z+L.z);var b=e.magnitudeSquared(e.subtract(L,z,S)),q=Math.sqrt(b),G=N;G.x=s.x,G.y=c.y,G.z=l.z;var W=M;W.x=f.x,W.y=d.y,W.z=O.z;var X=e.multiplyByScalar(e.add(G,W,S),.5,I),V=0;for(w=0;v>w;w+=i){u.x=t[w]+a.x,u.y=t[w+1]+a.y,u.z=t[w+2]+a.z;var H=e.magnitude(e.subtract(u,X,S));H>V&&(V=H);var Y=e.magnitudeSquared(e.subtract(u,z,S));if(Y>b){var Z=Math.sqrt(Y);q=.5*(q+Z),b=q*q;var k=Z-q;z.x=(q*z.x+k*u.x)/Z,z.y=(q*z.y+k*u.y)/Z,z.z=(q*z.z+k*u.z)/Z}}return V>q?(e.clone(z,o.center),o.radius=q):(e.clone(X,o.center),o.radius=V),o},E.fromCornerPoints=function(t,n,a){r(a)||(a=new E);var i=a.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,n),a},E.fromEllipsoid=function(t,n){return r(n)||(n=new E),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;E.fromBoundingSpheres=function(t,n){if(r(n)||(n=new E),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=t.length;if(1===a)return E.clone(t[0],n);if(2===a)return E.union(t[0],t[1],n);for(var i=[],o=0;a>o;o++)i.push(t[o].center);n=E.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return n.radius=s,n};var U=new e,D=new e,F=new e;E.fromOrientedBoundingBox=function(t,n){r(n)||(n=new E);var a=t.halfAxes,i=c.getColumn(a,0,U),o=c.getColumn(a,1,D),u=c.getColumn(a,2,F),s=e.magnitude(i),l=e.magnitude(o),f=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(s,l,f),n},E.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new E(t.center,t.radius):void 0},E.packedLength=4,E.pack=function(e,t,r){r=n(r,0);var a=e.center;t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius},E.unpack=function(e,t,a){t=n(t,0),r(a)||(a=new E);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var L=new e,B=new e;E.union=function(t,n,a){r(a)||(a=new E);var i=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,i,L),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return n.clone(a),a;var f=.5*(o+l+s),d=e.multiplyByScalar(c,(-o+f)/l,B);return e.add(d,i,d),e.clone(d,a.center),a.radius=f,a};var z=new e;E.expand=function(t,n,r){r=E.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,z));return a>r.radius&&(r.radius=a),r},E.intersectPlane=function(t,n){var r=t.center,a=t.radius,i=n.normal,o=e.dot(i,r)+n.distance;return-a>o?u.OUTSIDE:a>o?u.INTERSECTING:u.INSIDE},E.transform=function(e,t,n){return r(n)||(n=new E),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var b=new e;E.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,b);return e.magnitudeSquared(r)-t.radius*t.radius},E.transformWithoutScale=function(e,t,n){return r(n)||(n=new E),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var q=new e;E.computePlaneDistances=function(t,n,a,i){r(i)||(i=new s);var o=e.subtract(t.center,n,q),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var G=new e,W=new e,X=new e,V=new e,H=new e,Y=new t,Z=new Array(8),k=0;8>k;++k)Z[k]=new e;var j=new o;return E.projectTo2D=function(t,r,a){r=n(r,j);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,G),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,X);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,H),d=e.negate(c,V),h=Z,m=h[0];e.add(s,l,m),e.add(m,c,m),m=h[1],e.add(s,l,m),e.add(m,d,m),m=h[2],e.add(s,f,m),e.add(m,d,m),m=h[3],e.add(s,f,m),e.add(m,c,m),e.negate(s,s),m=h[4],e.add(s,l,m),e.add(m,c,m),m=h[5],e.add(s,l,m),e.add(m,d,m),m=h[6],e.add(s,f,m),e.add(m,d,m),m=h[7],e.add(s,f,m),e.add(m,c,m);for(var _=h.length,R=0;_>R;++R){var T=h[R];e.add(o,T,T);var p=i.cartesianToCartographic(T,Y);r.project(p,T)}a=E.fromPoints(h,a),o=a.center;var y=o.x,S=o.y,A=o.z;return o.x=A,o.y=y,o.z=S,a},E.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},E.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},E.prototype.intersectPlane=function(e){return E.intersectPlane(this,e)},E.prototype.distanceSquaredTo=function(e){return E.distanceSquaredTo(this,e)},E.prototype.computePlaneDistances=function(e,t,n){return E.computePlaneDistances(this,e,t,n)},E.prototype.isOccluded=function(e){return E.isOccluded(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.clone=function(e){return E.clone(this,e)},E}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n){this.x=e(t,0),this.y=e(n,0)}i.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new i(e,n)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)},i.ZERO=r(new i(0,0)),i.UNIT_X=r(new i(1,0)),i.UNIT_Y=r(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,n,r,a,i,o){"use strict";function u(e,n){this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,r(n)&&(this.cameraPosition=n)}function s(e,n,r){var a=e.transformPositionToScaledSpace(n,h),i=t.magnitudeSquared(a),o=Math.sqrt(i),u=t.divideByScalar(a,o,m);i=Math.max(1,i),o=Math.max(1,o);var s=t.dot(u,r),c=t.magnitude(t.cross(u,r,u)),l=1/o,f=Math.sqrt(i-1)*l;return 1/(s*l-c*f)}function c(e,n,r){return 0>=n||n===1/0||n!==n?void 0:t.multiplyByScalar(e,n,r)}function l(e,n){return e.transformPositionToScaledSpace(n,_),t.normalize(_,_)}a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var n=this._ellipsoid,r=n.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),a=t.magnitudeSquared(r)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=a}}});var f=new t;u.prototype.isPointVisible=function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,f);return this.isScaledSpacePointVisible(n)},u.prototype.isScaledSpacePointVisible=function(e){var n=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,a=t.subtract(e,n,f),i=-t.dot(a,n),o=0>r?i>0:i>r&&i*i/t.magnitudeSquared(a)>r;return!o},u.prototype.computeHorizonCullingPoint=function(e,n,a){r(a)||(a=new t);for(var i=this._ellipsoid,o=l(i,e),u=0,f=0,d=n.length;d>f;++f){var E=n[f],h=s(i,E,o);u=Math.max(u,h)}return c(o,u,a)};var d=new t;u.prototype.computeHorizonCullingPointFromVertices=function(e,a,i,o,u){r(u)||(u=new t),o=n(o,t.ZERO);for(var f=this._ellipsoid,E=l(f,e),h=0,m=0,_=a.length;_>m;m+=i){d.x=a[m]+o.x,d.y=a[m+1]+o.y,d.z=a[m+2]+o.z;var R=s(f,d,E);h=Math.max(h,R)}return c(E,h,u)},u.prototype.computeHorizonCullingPointFromPoints=function(e,n,a){r(a)||(a=new t);for(var i=this._ellipsoid,o=l(i,e),u=0,f=0,d=n.length;d>f;++f){var E=s(i,n[f],o);u=Math.max(u,E)}return c(o,u,a)};var E=[];u.prototype.computeHorizonCullingPointFromRectangle=function(n,r,a){var i=o.subsample(n,r,0,E),u=e.fromPoints(i);return t.magnitude(u.center)<.1*r.minimumRadius?void 0:this.computeHorizonCullingPoint(u.center,i,a)};var h=new t,m=new t,_=new t;return u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,0>i?[i,0]:[0,i];var c=r*r,l=4*e*a,f=n(c,-l,t.EPSILON14);if(0>f)return[];var d=-.5*n(r,t.sign(r)*Math.sqrt(f),t.EPSILON14);return r>0?[d/e,a/d]:[a/d,d/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,f=u*c,d=u*u,E=s*s,h=o*s-d,m=o*c-u*s,_=u*c-E,R=4*h*_-m*m;if(0>R){var T,p,y;d*f>=l*E?(T=o,p=h,y=-2*u*h+o*m):(T=c,p=_,y=-c*m+2*s*_);var S=0>y?-1:1,A=-S*Math.abs(T)*Math.sqrt(-R);i=-y+A;var N=i/2,M=0>N?-Math.pow(-N,1/3):Math.pow(N,1/3),I=i===A?-M:-p/M;return a=0>=p?M+I:-y/(M*M+I*I+p),d*f>=l*E?[(a-u)/o]:[-c/(a+s)]}var O=h,v=-2*u*h+o*m,w=_,C=-c*m+2*s*_,g=Math.sqrt(R),x=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*g,-v)/3);a=2*Math.sqrt(-O);var U=Math.cos(P);i=a*U;var D=a*(-U/2-x*Math.sin(P)),F=i+D>2*u?i-u:D-u,L=o,B=F/L;P=Math.abs(Math.atan2(c*g,-C)/3),a=2*Math.sqrt(-w),U=Math.cos(P),i=a*U,D=a*(-U/2-x*Math.sin(P));var z=-c,b=2*s>i+D?i+s:D+s,q=z/b,G=L*b,W=-F*b-L*z,X=F*z,V=(s*W-u*X)/(-u*W+s*G);return V>=B?q>=B?q>=V?[B,V,q]:[B,q,V]:[q,B,V]:q>=B?[V,B,q]:q>=V?[V,q,B]:[q,V,B]}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),
0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var d=-t/4,E=f[f.length-1];if(Math.abs(E)<n.EPSILON14){var h=r.computeRealRoots(1,s,l);if(2===h.length){var m,_=h[0],R=h[1];if(_>=0&&R>=0){var T=Math.sqrt(_),p=Math.sqrt(R);return[d-p,d-T,d+T,d+p]}if(_>=0&&0>R)return m=Math.sqrt(_),[d-m,d+m];if(0>_&&R>=0)return m=Math.sqrt(R),[d-m,d+m]}return[]}if(E>0){var y=Math.sqrt(E),S=(s+E-c/y)/2,A=(s+E+c/y)/2,N=r.computeRealRoots(1,y,S),M=r.computeRealRoots(1,-y,A);return 0!==N.length?(N[0]+=d,N[1]+=d,0!==M.length?(M[0]+=d,M[1]+=d,N[1]<=M[0]?[N[0],N[1],M[0],M[1]]:M[1]<=N[0]?[M[0],M[1],N[0],N[1]]:N[0]>=M[0]&&N[1]<=M[1]?[M[0],N[0],N[1],M[1]]:M[0]>=N[0]&&M[1]<=N[1]?[N[0],M[0],M[1],N[1]]:N[0]>M[0]&&N[0]<M[1]?[M[0],N[0],M[1],N[1]]:[N[0],M[0],N[1],M[1]]):N):0!==M.length?(M[0]+=d,M[1]+=d,M):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,d=c*o-i*a*t+u,E=e.computeRealRoots(1,l,f,d);if(E.length>0){var h,m,_=E[0],R=a-_,T=R*R,p=t/2,y=R/2,S=T-4*o,A=T+4*Math.abs(o),N=c-4*_,M=c+4*Math.abs(_);if(0>_||N*A>S*M){var I=Math.sqrt(N);h=I/2,m=0===I?0:(t*y-i)/I}else{var O=Math.sqrt(S);h=0===O?0:(t*y-i)/O,m=O/2}var v,w;0===p&&0===h?(v=0,w=0):n.sign(p)===n.sign(h)?(v=p+h,w=_/v):(w=p-h,v=_/w);var C,g;0===y&&0===m?(C=0,g=0):n.sign(y)===n.sign(m)?(C=y+m,g=o/C):(g=y-m,C=o/g);var x=r.computeRealRoots(1,v,C),P=r.computeRealRoots(1,w,g);if(0!==x.length)return 0!==P.length?x[1]<=P[0]?[x[0],x[1],P[0],P[1]]:P[1]<=x[0]?[P[0],P[1],x[0],x[1]]:x[0]>=P[0]&&x[1]<=P[1]?[P[0],x[0],x[1],P[1]]:P[0]>=x[0]&&P[1]<=x[1]?[x[0],P[0],P[1],x[1]]:x[0]>P[0]&&x[0]<P[1]?[P[0],x[0],P[1],x[1]]:[x[0],P[0],x[1],P[1]]:x;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,f=r*r,d=f*r,E=a*a,h=E*a,m=u*c*f-4*s*d-4*e*l*f+18*e*t*n*d-27*i*f*f+256*o*h+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*f+144*i*n*f)+E*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return m},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,f=u/t,d=s/t,E=0>c?1:0;switch(E+=0>l?E+1:E,E+=0>f?E+1:E,E+=0>d?E+1:E){case 0:return a(c,l,f,d);case 1:return i(c,l,f,d);case 2:return i(c,l,f,d);case 3:return a(c,l,f,d);case 4:return a(c,l,f,d);case 5:return i(c,l,f,d);case 6:return a(c,l,f,d);case 7:return a(c,l,f,d);case 8:return i(c,l,f,d);case 9:return a(c,l,f,d);case 10:return a(c,l,f,d);case 11:return i(c,l,f,d);case 12:return a(c,l,f,d);case 13:return a(c,l,f,d);case 14:return a(c,l,f,d);case 15:return a(c,l,f,d);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r}return a.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(t,r,a,o,u){u=n(u,!1);var s,c,l,f,d,E=t.origin,h=t.direction,m=e.subtract(a,r,_),S=e.subtract(o,r,R),A=e.cross(h,S,T),N=e.dot(m,A);if(u){if(N<i.EPSILON6)return;if(s=e.subtract(E,r,p),l=e.dot(s,A),0>l||l>N)return;if(c=e.cross(s,m,y),f=e.dot(h,c),0>f||l+f>N)return;d=e.dot(S,c)/N}else{if(Math.abs(N)<i.EPSILON6)return;var M=1/N;if(s=e.subtract(E,r,p),l=e.dot(s,A)*M,0>l||l>1)return;if(c=e.cross(s,m,y),f=e.dot(h,c)*M,0>f||l+f>1)return;d=e.dot(S,c)*M}return d}function f(e,t,n,r){var a=t*t-4*e*n;if(!(0>a)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}function d(t,n,a){r(a)||(a={});var i=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(i,u,T),l=e.dot(o,o),d=2*e.dot(o,c),E=e.magnitudeSquared(c)-s,h=f(l,d,E,A);return r(h)?(a.start=h.root0,a.stop=h.root1,a):void 0}function E(e,t,n){var r=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function h(t,n,r,a,c){var l,f=a*a,d=c*c,h=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*d,m=c*(a*E(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+n.y),_=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*d+a*n.x+r,R=d*E(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),T=c*(a*E(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),p=[];if(0===T&&0===R){if(l=u.computeRealRoots(h,m,_),0===l.length)return p;var y=l[0],S=Math.sqrt(Math.max(1-y*y,0));if(p.push(new e(a,c*y,c*-S)),p.push(new e(a,c*y,c*S)),2===l.length){var A=l[1],N=Math.sqrt(Math.max(1-A*A,0));p.push(new e(a,c*A,c*-N)),p.push(new e(a,c*A,c*N))}return p}var M=T*T,I=R*R,O=h*h,v=T*R,w=O+I,C=2*(m*h+v),g=2*_*h+m*m-I+M,x=2*(_*m-v),P=_*_-M;if(0===w&&0===C&&0===g&&0===x)return p;l=s.computeRealRoots(w,C,g,x,P);var U=l.length;if(0===U)return p;for(var D=0;U>D;++D){var F,L=l[D],B=L*L,z=Math.max(1-B,0),b=Math.sqrt(z);F=i.sign(h)===i.sign(_)?E(h*B+_,m*L,i.EPSILON12):i.sign(_)===i.sign(m*L)?E(h*B,m*L+_,i.EPSILON12):E(h*B+m*L,_,i.EPSILON12);var q=E(R*L,T,i.EPSILON15),G=F*q;0>G?p.push(new e(a,c*L,c*b)):G>0?p.push(new e(a,c*L,c*-b)):0!==b?(p.push(new e(a,c*L,c*-b)),p.push(new e(a,c*L,c*b)),++D):p.push(new e(a,c*L,c*b))}return p}var m={};m.rayPlane=function(t,n,a){r(a)||(a=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON15)){var l=(-n.distance-e.dot(s,o))/c;if(!(0>l))return a=e.multiplyByScalar(u,l,a),e.add(o,a,a)}};var _=new e,R=new e,T=new e,p=new e,y=new e;m.rayTriangle=function(t,n,a,i,o,u){var s=l(t,n,a,i,o);if(r(s)&&!(0>s))return r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var S=new c;m.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=S;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!r(f)||0>f||f>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var A={root0:0,root1:0};m.raySphere=function(e,t,n){return n=d(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var N=new c;m.lineSegmentSphere=function(t,n,a,i){var o=N,u=e.subtract(n,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=d(o,a,i),!r(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var M=new e,I=new e;m.rayEllipsoid=function(t,n){var r,a,i,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,M),l=e.multiplyComponents(s,t.direction,I),f=e.magnitudeSquared(c),d=e.dot(c,l);if(f>1){if(d>=0)return;var E=d*d;if(r=f-1,a=e.magnitudeSquared(l),i=a*r,i>E)return;if(E>i){o=d*d-i,u=-d+Math.sqrt(o);var h=u/a,m=r/u;return m>h?{start:h,stop:m}:{start:m,stop:h}}var _=Math.sqrt(r/a);return{start:_,stop:_}}return 1>f?(r=f-1,a=e.magnitudeSquared(l),i=a*r,o=d*d-i,u=-d+Math.sqrt(o),{start:0,stop:u/a}):0>d?(a=e.magnitudeSquared(l),{start:0,stop:-d/a}):void 0};var O=new e,v=new e,w=new e,C=new e,g=new e,x=new o,P=new o,U=new o,D=new o,F=new o,L=new o,B=new o,z=new e,b=new e,q=new t;m.grazingAltitudeLocation=function(t,n){var a=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(a,O);if(e.dot(u,s)>=0)return a;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,O),f=e.normalize(l,l),d=e.mostOrthogonalAxis(l,C),E=e.normalize(e.cross(d,f,v),v),m=e.normalize(e.cross(f,E,w),w),_=x;_[0]=f.x,_[1]=f.y,_[2]=f.z,_[3]=E.x,_[4]=E.y,_[5]=E.z,_[6]=m.x,_[7]=m.y,_[8]=m.z;var R=o.transpose(_,P),T=o.fromScale(n.radii,U),p=o.fromScale(n.oneOverRadii,D),y=F;y[0]=0,y[1]=-u.z,y[2]=u.y,y[3]=u.z,y[4]=0,y[5]=-u.x,y[6]=-u.y,y[7]=u.x,y[8]=0;var S,A,N=o.multiply(o.multiply(R,p,L),y,L),M=o.multiply(o.multiply(N,T,B),_,B),I=o.multiplyByVector(N,a,g),G=h(M,e.negate(I,O),0,0,1),W=G.length;if(W>0){for(var X=e.clone(e.ZERO,b),V=Number.NEGATIVE_INFINITY,H=0;W>H;++H){S=o.multiplyByVector(T,o.multiplyByVector(_,G[H],z),z);var Y=e.normalize(e.subtract(S,a,C),C),Z=e.dot(Y,u);Z>V&&(V=Z,X=e.clone(S,X))}var k=n.cartesianToCartographic(X,q);return V=i.clamp(V,0,1),A=e.magnitude(e.subtract(X,a,C))*Math.sqrt(1-V*V),A=c?-A:A,k.height=A,n.cartographicToCartesian(k,new e)}};var G=new e;return m.lineSegmentPlane=function(t,n,a,o){r(o)||(o=new e);var u=e.subtract(n,t,G),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON6)){var l=e.dot(s,t),f=-(a.distance+l)/c;if(!(0>f||f>1))return e.multiplyByScalar(u,f,o),e.add(t,o,o),o}},m.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,d;if((1===l||2===l)&&(f=new e,d=new e),1===l){if(u)return m.lineSegmentPlane(t,n,a,f),m.lineSegmentPlane(t,r,a,d),{positions:[t,n,r,f,d],indices:[0,3,4,1,2,4,1,4,3]};if(s)return m.lineSegmentPlane(n,r,a,f),m.lineSegmentPlane(n,t,a,d),{positions:[t,n,r,f,d],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(r,t,a,f),m.lineSegmentPlane(r,n,a,d),{positions:[t,n,r,f,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(n,t,a,f),m.lineSegmentPlane(r,t,a,d),{positions:[t,n,r,f,d],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(r,n,a,f),m.lineSegmentPlane(t,n,a,d),{positions:[t,n,r,f,d],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,r,a,f),m.lineSegmentPlane(n,r,a,d),{positions:[t,n,r,f,d],indices:[0,1,4,0,4,3,2,3,4]}}},m}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return i(r)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(a){return i(a)}});return n}function o(){function e(e,t,n){return d(e,t,n)}function n(e){return h(e)}function a(e){return h(i(e))}function u(e){return E(e)}var s,c,l,f,d,E,h;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],f=[],d=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),f.push(a),r.promise},E=function(e){return m(f,e),e},h=function(e){return e=t(e),d=e.then,h=t,E=R,m(l,e),f=l=S,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return _(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){h(e)}var c,l,f,d,E,h,m,_,T,p;if(T=t.length>>>0,c=Math.max(0,Math.min(n,T)),f=[],l=T-c+1,d=[],E=o(),c)for(_=E.progress,m=function(e){d.push(e),--l||(h=m=R,E.reject(d))},h=function(e){f.push(e),--c||(h=m=R,E.resolve(f))},p=0;T>p;++p)p in t&&e(t[p],s,u,_);else E.resolve(f);return E.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return _(1,arguments),d(e,T).then(t,n,r)}function f(){return d(arguments,T)}function d(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function E(t,n){var r=y.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},p.apply(t,r)})}function h(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function m(e,t){for(var n,r=0;n=e[r++];)n(t)}function _(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function R(){}function T(e){return e}var p,y,S;return e.defer=o,e.resolve=t,e.reject=n,e.join=f,e.all=l,e.map=d,e.reduce=E,e.any=c,e.some=s,e.chain=h,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(S,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(S,t)})})}},y=[].slice,p=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;a>i;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e,t,n){for(var r,a,i=0,o=e.length-1;o>=i;)if(r=~~((i+o)/2),a=n(e[r],t),0>a)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)}return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,f,d){var E,h,m,_,R;if("%%"==e)return"%";for(var T=!1,p="",y=!1,S=!1,A=" ",N=s.length,M=0;s&&N>M;M++)switch(s.charAt(M)){case" ":p=" ";break;case"+":p="+";break;case"-":T=!0;break;case"'":A=s.charAt(M+1);break;case"0":y=!0;break;case"#":S=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,T=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[n++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,R=r?t[r.slice(0,-1)]:t[n++],d){case"s":return u(String(R),T,c,f,y,A);case"c":return u(String.fromCharCode(+R),T,c,f,y);case"b":return o(R,2,S,T,c,f,y);case"o":return o(R,8,S,T,c,f,y);case"x":return o(R,16,S,T,c,f,y);case"X":return o(R,16,S,T,c,f,y).toUpperCase();case"u":return o(R,10,S,T,c,f,y);case"i":case"d":return E=+R||0,E=Math.round(E-E%1),h=0>E?"-":p,R=h+a(String(Math.abs(E)),f,"0",!1),i(R,h,T,c,y);case"e":case"E":case"f":case"F":case"g":case"G":return E=+R,h=0>E?"-":p,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],_=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],R=h+Math.abs(E)[m](f),i(R,h,T,c,y)[_]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return m.compare(e.julianDate,t.julianDate)}function f(e){p.julianDate=e;var n=m.leapSeconds,r=t(n,p,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=m.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}m.addSeconds(e,a,e)}function d(e,n){p.julianDate=e;var r=m.leapSeconds,a=t(r,p,l);if(0>a&&(a=~a),0===a)return m.addSeconds(e,-r[0].offset,n);if(a>=r.length)return m.addSeconds(e,-r[a-1].offset,n);var i=m.secondsDifference(r[a].julianDate,e);return 0===i?m.addSeconds(e,-r[a].offset,n):1>=i?void 0:m.addSeconds(e,-r[--a].offset,n)}function E(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function h(e,t,n,r,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,0>r&&(r+=24);var f=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function m(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,E(a,t,this),r===c.UTC&&f(this)}var _=new i,R=[31,28,31,30,31,30,31,31,30,31,30,31],T=29,p=new u,y=/^(\d{4})$/,S=/^(\d{4})-(\d{2})$/,A=/^(\d{4})-?(\d{3})$/,N=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,I=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+I.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,w=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,C="Invalid ISO 8601 date.";m.fromDate=function(e,t){var n=h(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(E(n[0],n[1],t),f(t),t):new m(n[0],n[1],c.UTC)},m.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,u,s=e.split("T"),l=1,d=1,_=0,p=0,I=0,g=0,x=s[0],P=s[1];if(!r(x))throw new a(C);var U;if(s=x.match(M),null!==s){if(U=x.split("-").length-1,U>0&&2!==U)throw new a(C);n=+s[1],l=+s[2],d=+s[3]}else if(s=x.match(S),null!==s)n=+s[1],l=+s[2];else if(s=x.match(y),null!==s)n=+s[1];else{var D;if(s=x.match(A),null!==s){if(n=+s[1],D=+s[2],u=o(n),1>D||u&&D>366||!u&&D>365)throw new a(C)}else{if(s=x.match(N),null===s)throw new a(C);n=+s[1];var F=+s[2],L=+s[3]||0;if(U=x.split("-").length-1,U>0&&(!r(s[3])&&1!==U||r(s[3])&&2!==U))throw new a(C);var B=new Date(Date.UTC(n,0,4));D=7*F+L-B.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(D),l=i.getUTCMonth()+1,d=i.getUTCDate()}if(u=o(n),1>l||l>12||1>d||(2!==l||!u)&&d>R[l-1]||u&&2===l&&d>T)throw new a(C);var z;if(r(P)){if(s=P.match(w),null!==s){if(U=P.split(":").length-1,U>0&&2!==U&&3!==U)throw new a(C);_=+s[1],p=+s[2],I=+s[3],g=1e3*+(s[4]||0),z=5}else if(s=P.match(v),null!==s){if(U=P.split(":").length-1,U>2)throw new a(C);_=+s[1],p=+s[2],I=60*+(s[3]||0),z=4}else{if(s=P.match(O),null===s)throw new a(C);_=+s[1],p=60*+(s[2]||0),z=3}if(p>=60||I>=61||_>24||24===_&&(p>0||I>0||g>0))throw new a(C);var b=s[z],q=+s[z+1],G=+(s[z+2]||0);switch(b){case"+":_-=q,p-=G;break;case"-":_+=q,p+=G;break;case"Z":break;default:p+=new Date(Date.UTC(n,l-1,d,_,p)).getTimezoneOffset()}}else p+=new Date(n,l-1,d).getTimezoneOffset();var W=60===I;for(W&&I--;p>=60;)p-=60,_++;for(;_>=24;)_-=24,d++;for(i=u&&2===l?T:R[l-1];d>i;)d-=i,l++,l>12&&(l-=12,n++),i=u&&2===l?T:R[l-1];for(;0>p;)p+=60,_--;for(;0>_;)_+=24,d--;for(;1>d;)l--,1>l&&(l+=12,n--),i=u&&2===l?T:R[l-1],d+=i;var X=h(n,l,d,_,p,I,g);return r(t)?(E(X[0],X[1],t),f(t)):t=new m(X[0],X[1],c.UTC),W&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var g=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){var n=!1,a=d(e,g);r(a)||(m.addSeconds(e,-1,g),a=d(g,g),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var E=80*c/2447|0,h=c-(2447*E/80|0)|0;c=E/11|0;var _=E+2-12*c|0,R=100*(l-49)+f+c|0,T=u/s.SECONDS_PER_HOUR|0,p=u-T*s.SECONDS_PER_HOUR,y=p/s.SECONDS_PER_MINUTE|0;p-=y*s.SECONDS_PER_MINUTE;var S=0|p,A=(p-S)/s.SECONDS_PER_MILLISECOND;return T+=12,T>23&&(T-=24),n&&(S+=1),r(t)?(t.year=R,t.month=_,t.day=h,t.hour=T,t.minute=y,t.second=S,t.millisecond=A,t.isLeapSecond=n,t):new i(R,_,h,T,y,S,A,n)},m.toDate=function(e){var t=m.toGregorianDate(e,_),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},m.toIso8601=function(t,n){var a,i=m.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},m.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI):void 0},m.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(m.secondsDifference(e,t))<=n},m.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},m.computeTaiMinusUtc=function(e){p.julianDate=e;var n=m.leapSeconds,r=t(n,p,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},m.addSeconds=function(e,t,n){return E(e.dayNumber,e.secondsOfDay+t,n)},m.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return E(e.dayNumber,r,n)},m.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return E(e.dayNumber,r,n)},m.addDays=function(e,t,n){var r=e.dayNumber+t;return E(r,e.secondsOfDay,n)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36)],m}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function n(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,a,i){"use strict";function o(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,u=n.headers,s=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return o.load(t,r,a,i,u,n,s),n.promise})}function u(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function s(e,t){for(var n=u(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function c(e,n){n=t(n,"");var a=e[1],i=!!e[2],o=e[3];switch(n){case"":case"text":return u(i,o);case"arraybuffer":return s(i,o);case"blob":var c=s(i,o);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(u(i,o),a);case"json":return JSON.parse(u(i,o));default:throw new r("Unhandled responseType: "+n)}}var l=/^data:(.*?)(;base64)?,(.*)$/;return o.load=function(e,t,r,o,u,s,f){var d=l.exec(e);if(null!==d)return void s.resolve(c(d,t));var E=new XMLHttpRequest;if(n(f)&&n(E.overrideMimeType)&&E.overrideMimeType(f),E.open(r,e,!0),n(u))for(var h in u)u.hasOwnProperty(h)&&E.setRequestHeader(h,u[h]);n(t)&&(E.responseType=t),E.onload=function(){E.status>=200&&E.status<300?n(E.response)?s.resolve(E.response):n(E.responseXML)&&E.responseXML.hasChildNodes()?s.resolve(E.responseXML):n(E.responseText)?s.resolve(E.responseText):s.reject(new i("unknown XMLHttpRequest response type.")):s.reject(new a(E.status,E.response,E.getAllResponseHeaders()))},E.onerror=function(e){s.reject(new a)},E.send(o)},o.defaultLoad=o.load,o}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,n){return e({url:t,headers:n})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";function a(n,a){return t(a)?t(a.Accept)||(a=e(a),a.Accept=i.Accept):a=i,r(n,a).then(function(e){return JSON.parse(e)})}var i={Accept:"application/json,*/*;q=0.01"};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function d(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))h(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){h(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function E(e,t){return o.compare(e.julianDate,t)}function h(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),d=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),h=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>d||0>h||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var _=e._samples=n.samples,R=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=h,e._taiMinusUtcSecondsColumn=m,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var T,p=e._addNewLeapSeconds,y=0,S=_.length;S>y;y+=e._columnCount){var A=_[y+a],N=_[y+m],M=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,I=new o(M,N,f.TAI);if(R.push(I),p){if(N!==T&&r(T)){var O=o.leapSeconds,v=t(O,I,E);if(0>v){var w=new u(I,N);O.splice(~v,0,w)}}T=N}}}function m(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function _(e,t,n){return t+e*(n-t)}function R(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return m(e,n,a,s,u),u;if(r.equals(l))return m(e,n,i,s,u),u;var f=o.secondsDifference(r,c)/o.secondsDifference(l,c),d=a*s,E=i*s,h=n[d+e._ut1MinusUtcSecondsColumn],R=n[E+e._ut1MinusUtcSecondsColumn],T=R-h;if(T>.5||-.5>T){var p=n[d+e._taiMinusUtcSecondsColumn],y=n[E+e._taiMinusUtcSecondsColumn];p!==y&&(l.equals(r)?h=R:R-=y-p)}return u.xPoleWander=_(f,n[d+e._xPoleWanderRadiansColumn],n[E+e._xPoleWanderRadiansColumn]),u.yPoleWander=_(f,n[d+e._yPoleWanderRadiansColumn],n[E+e._yPoleWanderRadiansColumn]),u.xPoleOffset=_(f,n[d+e._xCelestialPoleOffsetRadiansColumn],n[E+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=_(f,n[d+e._yCelestialPoleOffsetRadiansColumn],n[E+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=_(f,h,R),u}return d.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,n){if(r(this._samples)){if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var f=i[u],d=i[u+1],E=o.lessThanOrEquals(f,e),h=!r(d),m=h||o.greaterThanOrEquals(d,e);if(E&&m)return s=u,!h&&d.equals(e)&&++s,l=s+1,R(this,i,this._samples,e,s,l,n),n}var _=t(i,e,o.compare,this._dateColumn);return _>=0?(_<i.length-1&&i[_+1].equals(e)&&++_,s=_,l=_):(l=~_,s=l-1,0>s&&(s=0)),this._lastIndex=s,R(this,i,this._samples,e,s,l,n),n}if(r(this._dataError))throw new c(this._dataError)},d}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],
this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),a=d.exec(r);if(null!==a)return a[1]}}function i(){if(t(c))return c;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return c=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}function s(e){t(l)||(l=t(r.toUrl)?o:u),t(f)||(f=document.createElement("a"));var n=l(e);return f.href=n,f.href=f.href,f.href}var c,l,f,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return s._cesiumScriptRegex=d,s.setBaseUrl=function(t){c=new e(t).resolve(new e(document.location.href))},s}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,n){this.x=e,this.y=t,this.s=n}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,n){var r=f;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function l(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=a*n._samplesPerXysFile*3,u=0,s=r.length;s>u;++u)t[o+u]=r[u];i.resolve()}),i.promise}var f=new i(0,0,u.TAI);return s.prototype.preload=function(t,n,r,a){var i=c(this,t,n),o=c(this,r,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,E=[],h=f;d>=h;++h)E.push(l(this,h));return e.all(E)},s.prototype.computeXysRadians=function(e,t,n){var i=c(this,e,t);if(!(0>i)){var o=i/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,0>s&&(s=0));var d=!1,E=this._samples;if(r(E[3*s])||(l(this,s/this._samplesPerXysFile|0),d=!0),r(E[3*f])||(l(this,f/this._samplesPerXysFile|0),d=!0),!d){r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var h,m,_=i-s*this._stepSizeDays,R=this._work,T=this._denominators,p=this._coef,y=this._xTable;for(h=0;u>=h;++h)R[h]=_-y[h];for(h=0;u>=h;++h){for(p[h]=1,m=0;u>=m;++m)m!==h&&(p[h]*=R[m]);p[h]*=T[h];var S=3*(s+h);n.x+=p[h]*E[S++],n.y+=p[h]*E[S++],n.s+=p[h]*E[S]}return n}}}},s}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?r.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(r.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[r.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(R)){R=!1;var e=/ Chrome\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(R=!0,T=r(e[1]))}return R}function i(){return a()&&T}function o(){if(!t(p)&&(p=!1,!a()&&/ Safari\/[\.0-9]+/.test(_.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(p=!0,y=r(e[1]))}return p}function u(){return o()&&y}function s(){if(!t(S)){S=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(_.userAgent);null!==e&&(S=!0,A=r(e[1]),A.isNightly=!!e[2])}return S}function c(){return s()&&A}function l(){if(!t(N)){N=!1;var e;"Microsoft Internet Explorer"===_.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(_.userAgent),null!==e&&(N=!0,M=r(e[1]))):"Netscape"===_.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(_.userAgent),null!==e&&(N=!0,M=r(e[1])))}return N}function f(){return l()&&M}function d(){if(!t(I)){I=!1;var e=/Firefox\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(I=!0,O=r(e[1]))}return I}function E(){return t(v)||(v=/Windows/i.test(_.appVersion)),v}function h(){return d()&&O}function m(){return t(w)||(w="undefined"!=typeof PointerEvent&&(!t(_.pointerEnabled)||_.pointerEnabled)),w}var _;_="undefined"!=typeof navigator?navigator:{};var R,T,p,y,S,A,N,M,I,O,v,w,C={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:d,firefoxVersion:h,isWindows:E,hardwareConcurrency:e(_.hardwareConcurrency,3),supportsPointerEvents:m};return C.supportsFullscreen=function(){return n.supportsFullscreen()},C.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},C.supportsWebWorkers=function(){return"undefined"!=typeof Worker},C}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)}var c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,d=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=f,a.w=d,a):new s(u,l,f,d)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,d=e[u.COLUMN0ROW0],E=e[u.COLUMN1ROW1],h=e[u.COLUMN2ROW2],m=d+E+h;if(m>0)r=Math.sqrt(m+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var _=l,R=0;E>d&&(R=1),h>d&&h>E&&(R=2);var T=_[R],p=_[T];r=Math.sqrt(e[u.getElementIndex(R,R)]-e[u.getElementIndex(T,T)]-e[u.getElementIndex(p,p)]+1);var y=f;y[R]=.5*r,r=.5/r,c=(e[u.getElementIndex(p,T)]-e[u.getElementIndex(T,p)])*r,y[T]=(e[u.getElementIndex(T,R)]+e[u.getElementIndex(R,T)])*r,y[p]=(e[u.getElementIndex(p,R)]+e[u.getElementIndex(R,p)])*r,a=-y[0],i=-y[1],o=-y[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var d=new s;s.fromHeadingPitchRoll=function(t,n,r,a){var i=s.fromAxisAngle(e.UNIT_X,r,d),o=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,d);return s.multiply(u,a,a)};var E=new e,h=new e,m=new s,_=new s,R=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.x=e[r],a.y=e[r+1],a.z=e[r+2],a.w=e[r+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,R),s.conjugate(R,R);for(var a=0,i=n-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),m),s.multiply(m,R,m),m.w<0&&s.negate(m,m),s.computeAxis(m,E);var u=s.computeAngle(m);r[o]=E.x*u,r[o+1]=E.y*u,r[o+2]=E.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,h);var u=e.magnitude(h);return s.unpack(r,4*i,_),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(h,u,m),s.multiply(m,_,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+r*l+a*c-i*s,d=o*s-r*c+a*l+i*u,E=o*c+r*s-a*u+i*l,h=o*l-r*u-a*s-i*c;return n.x=f,n.y=d,n.z=E,n.w=h,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,t,n,r){return T=s.multiplyByScalar(t,n,T),r=s.multiplyByScalar(e,1-n,r),s.add(T,r,r)};var p=new s,y=new s,S=new s;s.slerp=function(e,t,n,r){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=p=s.negate(t,p)),1-a<o.EPSILON6)return s.lerp(e,i,n,r);var u=Math.acos(a);return y=s.multiplyByScalar(e,Math.sin((1-n)*u),y),S=s.multiplyByScalar(i,Math.sin(n*u),S),r=s.add(y,S,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},s.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var A=new e,N=new e,M=new s,I=new s;s.computeInnerQuadrangle=function(t,n,r,a){var i=s.conjugate(n,M);s.multiply(i,r,I);var o=s.log(I,A);s.multiply(i,t,I);var u=s.log(I,N);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,M),s.multiply(n,M,a)},s.squad=function(e,t,n,r,a,i){var o=s.slerp(e,t,a,M),u=s.slerp(n,r,a,I);return s.slerp(o,u,2*a*(1-a),i)};for(var O=new s,v=1.9011074535173003,w=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],g=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var U=P+1,D=2*U+1;w[P]=1/(U*D),C[P]=U/D}return w[7]=v/136,C[7]=8*v/17,s.fastSlerp=function(e,t,n,r){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,l=u*u,f=7;f>=0;--f)g[f]=(w[f]*c-C[f])*o,x[f]=(w[f]*l-C[f])*o;var d=a*n*(1+g[0]*(1+g[1]*(1+g[2]*(1+g[3]*(1+g[4]*(1+g[5]*(1+g[6]*(1+g[7])))))))),E=u*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),h=s.multiplyByScalar(e,E,O);return s.multiplyByScalar(t,d,r),s.add(h,r,r)},s.fastSquad=function(e,t,n,r,a,i){var o=s.fastSlerp(e,t,a,M),u=s.fastSlerp(n,r,a,I);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,f,d,E,h,m,_,R){"use strict";var T={},p=new n,y=new n,S=new n;T.eastNorthUpToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var o=E.sign(e.z);return i(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=p,s=y,l=S;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var A=new n,N=new n,M=new n;T.northEastDownToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var o=E.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=A,s=N,l=M;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},T.northUpEastToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var o=E.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=p,s=y,l=S;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var I=new _,O=new n(1,1,1),v=new m;T.headingPitchRollToFixedFrame=function(e,t,r,a,i,o){var u=_.fromHeadingPitchRoll(t,r,a,I),s=m.fromTranslationQuaternionRotationScale(n.ZERO,u,O,v);return o=T.eastNorthUpToFixedFrame(e,i,o),m.multiply(o,s,o)};var w=new m,C=new h;T.headingPitchRollQuaternion=function(e,t,n,r,a,i){var o=T.headingPitchRollToFixedFrame(e,t,n,r,a,w),u=m.getRotation(o,C);return _.fromRotationMatrix(u,i)};var g=24110.54841,x=8640184.812866,P=.093104,U=-62e-7,D=1.1772758384668e-19,F=72921158553e-15,L=E.TWO_PI/86400,B=new d;T.computeTemeToPseudoFixedMatrix=function(e,t){B=d.addSeconds(e,-d.computeTaiMinusUtc(e),B);var n,r=B.dayNumber,a=B.secondsOfDay,o=r-2451545;n=a>=43200?(o+.5)/R.DAYS_PER_JULIAN_CENTURY:(o-.5)/R.DAYS_PER_JULIAN_CENTURY;var u=g+n*(x+n*(P+n*U)),s=u*L%E.TWO_PI,c=F+D*(r-2451545.5),l=(a+.5*R.SECONDS_PER_DAY)%R.SECONDS_PER_DAY,f=s+c*l,m=Math.cos(f),_=Math.sin(f);return i(t)?(t[0]=m,t[1]=-_,t[2]=0,t[3]=_,t[4]=m,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new h(m,_,0,-_,m,0,0,0,1)},T.iau2006XysData=new l,T.earthOrientationParameters=u.NONE;var z=32.184,b=2451545;T.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+z,a=t.stop.dayNumber,i=t.stop.secondsOfDay+z,o=T.iau2006XysData.preload(n,r,a,i),u=T.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},T.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new h);var n=T.computeFixedToIcrfMatrix(e,t);if(i(n))return h.transpose(n,t)};var q=new f(0,0,0),G=new s(0,0,0,0,0,0),W=new h,X=new h;T.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new h);var n=T.earthOrientationParameters.compute(e,G);if(i(n)){var r=e.dayNumber,a=e.secondsOfDay+z,o=T.iau2006XysData.computeXysRadians(r,a,q);if(i(o)){var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=h.fromRotationZ(-o.s,X),m=h.multiply(l,f,W),_=e.dayNumber,p=e.secondsOfDay-d.computeTaiMinusUtc(e)+n.ut1MinusUtc,y=_-2451545,S=p/R.SECONDS_PER_DAY,A=.779057273264+S+.00273781191135448*(y+S);A=A%1*E.TWO_PI;var N=h.fromRotationZ(A,X),M=h.multiply(m,N,W),I=Math.cos(n.xPoleWander),O=Math.cos(n.yPoleWander),v=Math.sin(n.xPoleWander),w=Math.sin(n.yPoleWander),C=r-b+a/R.SECONDS_PER_DAY;C/=36525;var g=-47e-6*C*E.RADIANS_PER_DEGREE/3600,x=Math.cos(g),P=Math.sin(g),U=X;return U[0]=I*x,U[1]=I*P,U[2]=v,U[3]=-O*P+w*v*x,U[4]=O*x+w*v*P,U[5]=-w*I,U[6]=-w*P-O*v*x,U[7]=w*x-O*v*P,U[8]=O*I,h.multiply(M,U,t)}}};var V=new r;T.pointToWindowCoordinates=function(e,t,n,r){return r=T.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},T.pointToGLWindowCoordinates=function(e,n,a,o){i(o)||(o=new t);var u=V;return m.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var H=new n,Y=new n,Z=new n;return T.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=a(r,c.WGS84).geodeticSurfaceNormal(e,H),s=n.cross(t,u,Y);n.equalsEpsilon(s,n.ZERO,E.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,Z);return n.cross(t,l,s),n.negate(s,s),i(o)||(o=new h),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},T}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,f,d,E,h){"use strict";function m(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=h.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(f.getColumn(r,0,_)),this._yAxis=n.fromCartesian4(f.getColumn(r,1,_));var i=n.fromCartesian4(f.getColumn(r,2,_));this._plane=d.fromPointNormal(e,i)}var _=new r;o(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var R=new e;m.fromPoints=function(t,n){var r=e.fromPoints(t,R);return new m(r.center,n)};var T=new E,p=new n;m.prototype.projectPointOntoPlane=function(e,r){var a=T;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,p);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,p)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}},m.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;r>a;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t},m.prototype.projectPointToNearestOnPlane=function(e,r){i(r)||(r=new t);var a=T;a.origin=e,n.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,p);i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,p));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},m.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;n>r;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var y=new n;return m.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=y,l=0;r>l;++l){var f=e[l];n.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new n);var d=n.add(o,c,t[l]);n.multiplyByScalar(s,f.y,c),n.add(d,c,d),a.scaleToGeocentricSurface(d,d)}return t},m}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,f,d,E,h){"use strict";function m(e,t){this.center=n.clone(a(e,n.ZERO)),this.halfAxes=d.clone(a(t,d.ZERO))}function _(e,t,r,a,o,u,s,c){i(c)||(c=new m);var l=c.halfAxes;d.setColumn(l,0,e.xAxis,l),d.setColumn(l,1,e.yAxis,l),d.setColumn(l,2,e.zAxis,l);var f=M;f.x=(t+r)/2,f.y=(a+o)/2,f.z=(u+s)/2;var E=I;E.x=(r-t)/2,E.y=(o-a)/2,E.z=(s-u)/2;var h=c.center;return f=d.multiplyByVector(l,f,f),n.add(e.origin,f,h),d.multiplyByScale(l,E,l),c}var R=new n,T=new n,p=new n,y=new n,S=new n,A=new d,N={unitary:new d,diagonal:new d};m.fromPoints=function(e,t){if(i(t)||(t=new m),!i(e)||0===e.length)return t.halfAxes=d.ZERO,t.center=n.ZERO,t;var r,a=e.length,o=n.clone(e[0],R);for(r=1;a>r;r++)n.add(o,e[r],o);var u=1/a;n.multiplyByScalar(o,u,o);var s,c=0,l=0,f=0,E=0,h=0,_=0;for(r=0;a>r;r++)s=n.subtract(e[r],o,T),c+=s.x*s.x,l+=s.x*s.y,f+=s.x*s.z,E+=s.y*s.y,h+=s.y*s.z,_+=s.z*s.z;c*=u,l*=u,f*=u,E*=u,h*=u,_*=u;var M=A;M[0]=c,M[1]=l,M[2]=f,M[3]=l,M[4]=E,M[5]=h,M[6]=f,M[7]=h,M[8]=_;var I=d.computeEigenDecomposition(M,N),O=d.transpose(I.unitary,t.halfAxes);s=n.subtract(e[0],o,T);var v=d.multiplyByVector(O,s,p),w=n.clone(v,y),C=n.clone(v,S);for(r=1;a>r;r++)s=n.subtract(e[r],o,s),d.multiplyByVector(O,s,v),n.minimumByComponent(C,v,C),n.maximumByComponent(w,v,w);var g=n.add(C,w,p);n.multiplyByScalar(g,.5,g),d.multiplyByVector(O,g,g),n.add(o,g,t.center);var x=n.subtract(w,C,p);return n.multiplyByScalar(x,.5,x),d.multiplyByScale(t.halfAxes,x,t.halfAxes),t};var M=new n,I=new n,O=new r,v=new n,w=[new r,new r,new r,new r,new r,new r,new r,new r],C=[new n,new n,new n,new n,new n,new n,new n,new n],g=[new t,new t,new t,new t,new t,new t,new t,new t];m.fromRectangle=function(e,t,n,r,i){t=a(t,0),n=a(n,0),r=a(r,u.WGS84);var o=h.center(e,O),c=r.cartographicToCartesian(o,v),l=new s(c,r),f=l.plane,d=w[0],m=w[1],R=w[2],T=w[3],p=w[4],y=w[5],S=w[6],A=w[7],N=o.longitude,M=e.south<0&&e.north>0?0:o.latitude;S.latitude=y.latitude=p.latitude=e.south,A.latitude=T.latitude=M,d.latitude=m.latitude=R.latitude=e.north,S.longitude=A.longitude=d.longitude=e.west,y.longitude=m.longitude=N,p.longitude=T.longitude=R.longitude=e.east,R.height=m.height=d.height=A.height=S.height=y.height=p.height=T.height=n,r.cartographicArrayToCartesianArray(w,C),l.projectPointsToNearestOnPlane(C,g);var I=Math.min(g[6].x,g[7].x,g[0].x),x=Math.max(g[2].x,g[3].x,g[4].x),P=Math.min(g[4].y,g[5].y,g[6].y),U=Math.max(g[0].y,g[1].y,g[2].y);R.height=d.height=p.height=S.height=t,r.cartographicArrayToCartesianArray(w,C);var D=Math.min(E.getPointDistance(f,C[0]),E.getPointDistance(f,C[2]),E.getPointDistance(f,C[4]),E.getPointDistance(f,C[6])),F=n;return _(l,I,x,P,U,D,F,i)},m.clone=function(e,t){return i(e)?i(t)?(n.clone(e.center,t.center),d.clone(e.halfAxes,t.halfAxes),t):new m(e.center,e.halfAxes):void 0},m.intersectPlane=function(e,t){var r=e.center,a=t.normal,i=e.halfAxes,o=a.x,u=a.y,s=a.z,l=Math.abs(o*i[d.COLUMN0ROW0]+u*i[d.COLUMN0ROW1]+s*i[d.COLUMN0ROW2])+Math.abs(o*i[d.COLUMN1ROW0]+u*i[d.COLUMN1ROW1]+s*i[d.COLUMN1ROW2])+Math.abs(o*i[d.COLUMN2ROW0]+u*i[d.COLUMN2ROW1]+s*i[d.COLUMN2ROW2]),f=n.dot(a,r)+t.distance;return-l>=f?c.OUTSIDE:f>=l?c.INSIDE:c.INTERSECTING};var x=new n,P=new n,U=new n,D=new n;m.distanceSquaredTo=function(e,t){var r=n.subtract(t,e.center,M),a=e.halfAxes,i=d.getColumn(a,0,x),o=d.getColumn(a,1,P),u=d.getColumn(a,2,U),s=n.magnitude(i),c=n.magnitude(o),l=n.magnitude(u);n.normalize(i,i),n.normalize(o,o),n.normalize(u,u);var f=D;f.x=n.dot(r,i),f.y=n.dot(r,o),f.z=n.dot(r,u);var E,h=0;return f.x<-s?(E=f.x+s,h+=E*E):f.x>s&&(E=f.x-s,h+=E*E),f.y<-c?(E=f.y+c,h+=E*E):f.y>c&&(E=f.y-c,h+=E*E),f.z<-l?(E=f.z+l,h+=E*E):f.z>l&&(E=f.z-l,h+=E*E),h};var F=new n,L=new n;m.computePlaneDistances=function(e,t,r,a){i(a)||(a=new l);var o=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,s=e.center,c=e.halfAxes,f=d.getColumn(c,0,x),E=d.getColumn(c,1,P),h=d.getColumn(c,2,U),m=n.add(f,E,F);n.add(m,h,m),n.add(m,s,m);var _=n.subtract(m,t,L),R=n.dot(r,_);return o=Math.min(R,o),u=Math.max(R,u),n.add(s,f,m),n.add(m,E,m),n.subtract(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.add(s,f,m),n.subtract(m,E,m),n.add(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.add(s,f,m),n.subtract(m,E,m),n.subtract(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.subtract(s,f,m),n.add(m,E,m),n.add(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.subtract(s,f,m),n.add(m,E,m),n.subtract(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.subtract(s,f,m),n.subtract(m,E,m),n.add(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),n.subtract(s,f,m),n.subtract(m,E,m),n.subtract(m,h,m),n.subtract(m,t,_),R=n.dot(r,_),o=Math.min(R,o),u=Math.max(R,u),a.start=o,a.stop=u,a};var B=new e;return m.isOccluded=function(t,n){var r=e.fromOrientedBoundingBox(t,B);return!n.isBoundingSphereVisible(r)},m.prototype.intersectPlane=function(e){return m.intersectPlane(this,e)},m.prototype.distanceSquaredTo=function(e){return m.distanceSquaredTo(this,e)},m.prototype.computePlaneDistances=function(e,t,n){return m.computePlaneDistances(this,e,t,n)},m.prototype.isOccluded=function(e){return m.isOccluded(this,e)},m.equals=function(e,t){return e===t||i(e)&&i(t)&&n.equals(e.center,t.center)&&d.equals(e.halfAxes,t.halfAxes)},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var n=t.x,r=t.y;t.x=(1-Math.abs(r))*a.signNotZero(n),t.y=(1-Math.abs(n))*a.signNotZero(r)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,n,r){if(r.x=a.fromSNorm(e),r.y=a.fromSNorm(n),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var i=r.x;r.x=(1-Math.abs(r.y))*a.signNotZero(i),r.y=(1-Math.abs(i))*a.signNotZero(r.y)}return t.normalize(r,r)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var n=e/256,r=Math.floor(n),a=256*(n-r);return i.octDecode(r,a,t)},i.octPack=function(e,t,n,r){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(n,o);return r.x=65536*s.x+a,r.y=65536*s.y+u,r},i.octUnpack=function(e,t,n,r){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,n),i.octDecode(o,s,r)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*t+n},i.decompressTextureCoordinates=function(e,t){var n=e/4096;return t.x=Math.floor(n)/4096,t.y=n-Math.floor(n),t},i}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,
ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return n(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,n,a,i){switch(a=t(a,0),i=t(i,(n.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(n,a,i);case o.SHORT:return new Int16Array(n,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(n,a,i);case o.FLOAT:return new Float32Array(n,a,i);case o.DOUBLE:return new Float64Array(n,a,i);default:throw new r("componentDatatype is not a valid value.")}},i(o)}),define("Core/TerrainQuantization",["./freezeObject"],function(e){"use strict";var t={NONE:0,BITS12:1};return e(t)}),define("Core/TerrainEncoding",["./AttributeCompression","./Cartesian2","./Cartesian3","./ComponentDatatype","./defined","./Math","./Matrix3","./Matrix4","./TerrainQuantization"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(e,t,r,i,o){var c,d,_,R;if(a(e)&&a(t)&&a(r)&&a(i)){var T=e.minimum,p=e.maximum,y=n.subtract(p,T,f),S=r-t,A=Math.max(n.maximumComponent(y),S);c=m-1>A?s.BITS12:s.NONE,d=e.center,_=u.inverseTransformation(i,new u);var N=n.negate(T,l);u.multiply(u.fromTranslation(N,E),_,_);var M=l;M.x=1/y.x,M.y=1/y.y,M.z=1/y.z,u.multiply(u.fromScale(M,E),_,_),R=u.clone(i),u.setTranslation(R,n.ZERO,R),i=u.clone(i,new u);var I=u.fromTranslation(T,E),O=u.fromScale(y,h),v=u.multiply(I,O,E);u.multiply(i,v,i),u.multiply(R,v,R)}this.quantization=c,this.minimumHeight=t,this.maximumHeight=r,this.center=d,this.toScaledENU=_,this.fromScaledENU=i,this.matrix=R,this.hasVertexNormals=o}var l=new n,f=new n,d=new t,E=new u,h=new u,m=Math.pow(2,12);c.prototype.encode=function(r,a,o,c,f,E){var h=c.x,m=c.y;if(this.quantization===s.BITS12){o=u.multiplyByPoint(this.toScaledENU,o,l),o.x=i.clamp(o.x,0,1),o.y=i.clamp(o.y,0,1),o.z=i.clamp(o.z,0,1);var _=this.maximumHeight-this.minimumHeight,R=i.clamp((f-this.minimumHeight)/_,0,1);t.fromElements(o.x,o.y,d);var T=e.compressTextureCoordinates(d);t.fromElements(o.z,R,d);var p=e.compressTextureCoordinates(d);t.fromElements(h,m,d);var y=e.compressTextureCoordinates(d);r[a++]=T,r[a++]=p,r[a++]=y}else n.subtract(o,this.center,l),r[a++]=l.x,r[a++]=l.y,r[a++]=l.z,r[a++]=f,r[a++]=h,r[a++]=m;return this.hasVertexNormals&&(r[a++]=e.octPackFloat(E)),a},c.prototype.decodePosition=function(t,r,i){if(a(i)||(i=new n),r*=this.getStride(),this.quantization===s.BITS12){var o=e.decompressTextureCoordinates(t[r],d);i.x=o.x,i.y=o.y;var c=e.decompressTextureCoordinates(t[r+1],d);return i.z=c.x,u.multiplyByPoint(this.fromScaledENU,i,i)}return i.x=t[r],i.y=t[r+1],i.z=t[r+2],n.add(i,this.center,i)},c.prototype.getStride=function(){var e;switch(this.quantization){case s.BITS12:e=3;break;default:e=6}return this.hasVertexNormals&&++e,e};var _={position3DAndHeight:0,textureCoordAndEncodedNormals:1},R={compressed:0};return c.prototype.getAttributes=function(e){var t=r.FLOAT;if(this.quantization===s.NONE){var n=r.getSizeInBytes(t),a=4,i=this.hasVertexNormals?3:2,o=(this.hasVertexNormals?7:6)*n;return[{index:_.position3DAndHeight,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:a,offsetInBytes:0,strideInBytes:o},{index:_.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:i,offsetInBytes:a*n,strideInBytes:o}]}var u=3;return u+=this.hasVertexNormals?1:0,[{index:R.compressed,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:u}]},c.prototype.getAttributeLocations=function(){return this.quantization===s.NONE?_:R},c.clone=function(e,t){return a(t)||(t=new c),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=n.clone(e.center),t.toScaledENU=u.clone(e.toScaledENU),t.fromScaledENU=u.clone(e.fromScaledENU),t.matrix=u.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t},c}),define("Core/HeightmapTessellator",["./AxisAlignedBoundingBox","./BoundingSphere","./Cartesian2","./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidalOccluder","./freezeObject","./Math","./Matrix4","./OrientedBoundingBox","./Rectangle","./TerrainEncoding","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,f,d,E,h,m){"use strict";var _={};_.DEFAULT_STRUCTURE=c({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var R=new r,T=new f,p=new r,y=new r;return _.computeVertices=function(o){var c,S,A,N,M=Math.cos,I=Math.sin,O=Math.sqrt,v=Math.atan,w=Math.exp,C=l.PI_OVER_TWO,g=l.toRadians,x=o.heightmap,P=o.width,U=o.height,D=o.skirtHeight,F=a(o.isGeographic,!0),L=a(o.ellipsoid,u.WGS84),B=1/L.maximumRadius,z=o.nativeRectangle,b=o.rectangle;i(b)?(c=b.west,S=b.south,A=b.east,N=b.north):F?(c=g(z.west),S=g(z.south),A=g(z.east),N=g(z.north)):(c=z.west*B,S=C-2*v(w(-z.south*B)),A=z.east*B,N=C-2*v(w(-z.north*B)));var q=a(o.relativeToCenter,r.ZERO),G=a(o.exaggeration,1),W=a(o.structure,_.DEFAULT_STRUCTURE),X=a(W.heightScale,_.DEFAULT_STRUCTURE.heightScale),V=a(W.heightOffset,_.DEFAULT_STRUCTURE.heightOffset),H=a(W.elementsPerHeight,_.DEFAULT_STRUCTURE.elementsPerHeight),Y=a(W.stride,_.DEFAULT_STRUCTURE.stride),Z=a(W.elementMultiplier,_.DEFAULT_STRUCTURE.elementMultiplier),k=a(W.isBigEndian,_.DEFAULT_STRUCTURE.isBigEndian),j=E.computeWidth(z)/(P-1),K=E.computeHeight(z)/(U-1),J=L.radiiSquared,Q=J.x,$=J.y,ee=J.z,te=65536,ne=-65536,re=m.eastNorthUpToFixedFrame(q,L),ae=f.inverseTransformation(re,T),ie=p;ie.x=Number.POSITIVE_INFINITY,ie.y=Number.POSITIVE_INFINITY,ie.z=Number.POSITIVE_INFINITY;var oe=y;oe.x=Number.NEGATIVE_INFINITY,oe.y=Number.NEGATIVE_INFINITY,oe.z=Number.NEGATIVE_INFINITY;var ue=Number.POSITIVE_INFINITY,se=P+(D>0?2:0),ce=U+(D>0?2:0),le=se*ce,fe=new Array(le),de=new Array(le),Ee=new Array(le),he=0,me=U,_e=0,Re=P;D>0&&(--he,++me,--_e,++Re);for(var Te=0,pe=he;me>pe;++pe){var ye=pe;0>ye&&(ye=0),ye>=U&&(ye=U-1);var Se=z.north-K*ye;Se=F?g(Se):C-2*v(w(-Se*B));var Ae=M(Se),Ne=I(Se),Me=ee*Ne,Ie=(Se-S)/(N-S);Ie=l.clamp(Ie,0,1);for(var Oe=_e;Re>Oe;++Oe){var ve=Oe;0>ve&&(ve=0),ve>=P&&(ve=P-1);var we=z.west+j*ve;F?we=g(we):we*=B;var Ce,ge=ye*(P*Y)+ve*Y;if(1===H)Ce=x[ge];else{Ce=0;var xe;if(k)for(xe=0;H>xe;++xe)Ce=Ce*Z+x[ge+xe];else for(xe=H-1;xe>=0;--xe)Ce=Ce*Z+x[ge+xe]}Ce=(Ce*X+V)*G,ne=Math.max(ne,Ce),te=Math.min(te,Ce),(Oe!==ve||pe!==ye)&&(Ce-=D);var Pe=Ae*M(we),Ue=Ae*I(we),De=Q*Pe,Fe=$*Ue,Le=O(De*Pe+Fe*Ue+Me*Ne),Be=1/Le,ze=De*Be,be=Fe*Be,qe=Me*Be,Ge=new r;Ge.x=ze+Pe*Ce,Ge.y=be+Ue*Ce,Ge.z=qe+Ne*Ce,fe[Te]=Ge,de[Te]=Ce;var We=(we-c)/(A-c);We=l.clamp(We,0,1),Ee[Te]=new n(We,Ie),Te++,f.multiplyByPoint(ae,Ge,R),r.minimumByComponent(R,ie,ie),r.maximumByComponent(R,oe,oe),ue=Math.min(ue,Ce)}}var Xe,Ve=t.fromPoints(fe);i(b)&&b.width<l.PI_OVER_TWO+l.EPSILON5&&(Xe=d.fromRectangle(b,te,ne,L));var He,Ye=o.relativetoCenter;if(i(Ye)){var Ze=new s(L);He=Ze.computeHorizonCullingPointFromPoints(Ye,fe)}for(var ke=new e(ie,oe,q),je=new h(ke,ue,ne,re,!1),Ke=new Float32Array(le*je.getStride()),Je=0,Qe=0;le>Qe;++Qe)Je=je.encode(Ke,Je,fe[Qe],Ee[Qe],de[Qe]);return{vertices:Ke,maximumHeight:ne,minimumHeight:te,encoding:je,boundingSphere3D:Ve,orientedBoundingBox:Xe,occludeePointInScaledSpace:He}},_}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var n,r=t.name,a=t.message;n=e(r)&&e(a)?r+": "+a:t.toString();var i=t.stack;return e(i)&&(n+="\n"+i),n}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,n){"use strict";function r(r){var a,i=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(c){c instanceof Error?o.error={name:c.name,message:c.message,stack:c.stack}:o.error=c}t(a)||(a=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{a(o,i)}catch(c){o.result=void 0,o.error="postMessage failed with error: "+n(c)+"\n  with responseMessage: "+JSON.stringify(o),a(o)}}}return r}),define("Workers/createVerticesFromHeightmap",["../Core/Ellipsoid","../Core/HeightmapTessellator","../Core/Rectangle","./createTaskProcessorWorker"],function(e,t,n,r){"use strict";function a(r,a){var i=r.width,o=r.height;r.skirtHeight>0&&(i+=2,o+=2),r.ellipsoid=e.clone(r.ellipsoid),r.rectangle=n.clone(r.rectangle);var u=t.computeVertices(r),s=u.vertices;return a.push(s.buffer),{vertices:s.buffer,numberOfAttributes:u.encoding.getStride(),minimumHeight:u.minimumHeight,maximumHeight:u.maximumHeight,gridWidth:i,gridHeight:o,boundingSphere3D:u.boundingSphere3D,orientedBoundingBox:u.orientedBoundingBox,occludeePointInScaledSpace:u.occludeePointInScaledSpace,encoding:u.encoding}}return r(a)})}();