/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},a.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return a>=i||i<=r*Math.max(Math.abs(e),Math.abs(n))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var n=i[t-1],r=t;e>=r;r++)i.push(n*r);return i[e]},a.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)}i.fromSpherical=function(n,r){t(r)||(r=new i);var a=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(e,n,r,a){return t(a)?(a.x=e,a.y=n,a.z=r,a):new i(e,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var n=i.dot(s,c),r=i.magnitude(i.cross(s,c,s));return Math.atan2(r,n)};var l=new i;i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):n.y<=n.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)},i.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,f=r*u-a*o;return n.x=c,n.y=l,n.z=f,n},i.fromDegrees=function(e,t,n,r,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,n,r,o)};var f=new i,h=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(n,r,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(r);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(r),f=i.normalize(f,f),i.multiplyComponents(s,f,h);var l=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,l,h),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(h,f,u)},i.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=a.toRadians(e[o]);return i.fromRadiansArray(r,t,n)},i.fromRadiansArray=function(e,n,r){var a=e.length;t(r)?r.length=a/2:r=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=i.fromRadians(u,s,0,n,r[o/2])}return r},i.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=a.toRadians(e[o]),r[o+1]=a.toRadians(e[o+1]),r[o+2]=e[o+2];return i.fromRadiansArrayHeights(r,t,n)},i.fromRadiansArrayHeights=function(e,n,r){var a=e.length;t(r)?r.length=a/3:r=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=i.fromRadians(u,s,c,n,r[o/3])}return r},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function a(n,a,u,s,c){var l=n.x,f=n.y,h=n.z,d=a.x,E=a.y,m=a.z,p=l*l*d*d,y=f*f*E*E,_=h*h*m*m,v=p+y+_,T=Math.sqrt(1/v),R=e.multiplyByScalar(n,T,i);if(s>v)return isFinite(T)?e.clone(R,c):void 0;var A=u.x,S=u.y,g=u.z,N=o;N.x=R.x*A*2,N.y=R.y*S*2,N.z=R.z*g*2;var O,I,M,w,x,C,P,D,L,U,b,F=(1-T)*e.magnitude(n)/(.5*e.magnitude(N)),z=0;do{F-=z,M=1/(1+F*A),w=1/(1+F*S),x=1/(1+F*g),C=M*M,P=w*w,D=x*x,L=C*M,U=P*w,b=D*x,O=p*C+y*P+_*D-1,I=p*L*A+y*U*S+_*b*g;var B=-2*I;z=O/B}while(Math.abs(O)>r.EPSILON12);return t(c)?(c.x=l*M,c.y=f*w,c.z=h*x,c):new e(l*M,f*w,h*x)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,a,i){return a=t(a,0),n(i)?(i.longitude=e,i.latitude=r,i.height=a,i):new u(e,r,a)},u.fromDegrees=function(e,t,n,r){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,n,r)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=i.EPSILON1;return u.fromCartesian=function(t,r,a){var E=n(r)?r.oneOverRadii:f,m=n(r)?r.oneOverRadiiSquared:h,p=n(r)?r._centerToleranceSquared:d,y=o(t,E,m,p,c);if(n(y)){var _=e.multiplyComponents(t,m,s);_=e.normalize(_,_);var v=e.subtract(t,y,l),T=Math.atan2(_.y,_.x),R=Math.asin(_.z),A=i.sign(e.dot(v,t))*e.magnitude(v);return n(a)?(a.longitude=T,a.latitude=R,a.height=A,a):new u(T,R,A)}},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1}function l(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,c(this,e,t,n)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,n){if(r(t)){var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return r(t)||(t=new l),r(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,a){a=n(a,0),e.pack(t._radii,r,a)},l.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var f=new e,h=new e;l.prototype.cartographicToCartesian=function(t,n){var a=f,i=h;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,E=new e,m=new e;return l.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,E);if(r(i)){var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(n,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},l.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},l.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,n,r,a){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(a,0)}r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,a,i,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),n(o)?(o.west=e,o.south=r,o.east=a,o.north=i,o):new s(e,r,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,h=e.length;h>f;f++){var d=e[f];r=Math.min(r,d.longitude),a=Math.max(a,d.longitude),c=Math.min(c,d.latitude),l=Math.max(l,d.latitude);var E=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;i=Math.min(i,E),o=Math.max(o,E)}return a-r>o-i&&(r=i,a=o,a>u.PI&&(a-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=c,t.east=a,t.north=l,t):new s(r,c,a,l)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&l>=f)){var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(h>=d))return n(r)?(r.west=l,r.south=h,r.east=f,r.north=d,r):new s(l,h,f,d)}},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(i>n||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,a,o){r=t(r,i.WGS84),a=t(a,0),n(o)||(o=[]);var l=0,f=e.north,h=e.south,d=e.east,E=e.west,m=c;m.height=a,m.longitude=E,m.latitude=f,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.latitude=h,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=E,o[l]=r.cartographicToCartesian(m,o[l]),l++,0>f?m.latitude=f:h>0?m.latitude=h:m.latitude=0;for(var p=1;8>p;++p)m.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=r.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=E,o[l]=r.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=r.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e,n,r,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)}function u(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function s(e){for(var t=0,n=0;3>n;++n){var r=e[o.getElementIndex(d[n],h[n])];t+=2*r*r}return Math.sqrt(t)}function c(e,t){for(var n=i.EPSILON15,r=0,a=1,u=0;3>u;++u){var s=Math.abs(e[o.getElementIndex(d[u],h[u])]);s>r&&(a=u,r=s)}var c=1,l=0,f=h[a],E=d[a];if(Math.abs(e[o.getElementIndex(E,f)])>n){var m,p=e[o.getElementIndex(E,E)],y=e[o.getElementIndex(f,f)],_=e[o.getElementIndex(E,f)],v=(p-y)/2/_;m=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),c=1/Math.sqrt(1+m*m),l=m*c}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(f,f)]=t[o.getElementIndex(E,E)]=c,t[o.getElementIndex(E,f)]=l,t[o.getElementIndex(f,E)]=-l,t}o.packedLength=9,o.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},o.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a[4]=e[r+4],a[5]=e[r+5],a[6]=e[r+6],a[7]=e[r+7],a[8]=e[r+8],a},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,E=r-s-f+d,m=2*(a-h),p=2*(i+l),y=2*(a+h),_=-r+s-f+d,v=2*(c-u),T=2*(i-l),R=2*(c+u),A=-r-s+f+d;return n(t)?(t[0]=E,t[1]=y,t[2]=T,t[3]=m,t[4]=_,t[5]=R,t[6]=p,t[7]=v,t[8]=A,t):new o(E,m,p,y,_,v,T,R,A)},o.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new o(1,0,0,0,r,-a,0,a,r)},o.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new o(r,0,a,0,1,0,-a,0,r)},o.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(r,-a,0,a,r,0,0,0,1)},o.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},o.setColumn=function(e,t,n,r){r=o.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},o.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},o.setRow=function(e,t,n,r){return r=o.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;o.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var f=new e;o.getMaximumScale=function(t){return o.getScale(t,f),e.maximumComponent(f)},o.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},o.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},o.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},o.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},o.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},o.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],d=[2,2,1],E=new o,m=new o;return o.computeEigenDecomposition=function(e,t){var r=i.EPSILON20,a=10,l=0,f=0;n(t)||(t={});for(var h=t.unitary=o.clone(o.IDENTITY,t.unitary),d=t.diagonal=o.clone(e,t.diagonal),p=r*u(d);a>f&&s(d)>p;)c(d,E),o.transpose(E,m),o.multiply(d,E,d),o.multiply(m,d,d),o.multiply(h,E,h),++l>2&&(++f,l=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},o.inverse=function(e,t){var n=e[0],a=e[1],u=e[2],s=e[3],c=e[4],l=e[5],f=e[6],h=e[7],d=e[8],E=o.determinant(e);if(Math.abs(E)<=i.EPSILON15)throw new r("matrix is not invertible");t[0]=c*d-h*l,t[1]=h*u-a*d,t[2]=a*l-c*u,t[3]=f*l-s*d,t[4]=n*d-f*u,t[5]=s*u-n*l,t[6]=s*h-f*c,t[7]=f*a-n*h,t[8]=n*c-s*a;var m=1/E;return o.multiplyByScalar(t,m,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},o.IDENTITY=a(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=a(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)}i.fromElements=function(e,n,r,a,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=a,o):new i(e,n,r,a)},i.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,s);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)&&a.equalsEpsilon(e.w,n.w,r,i);
},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(e,t,r,a,i,o,u,s,c,l,f,h,d,E,m,p){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(E,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(m,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(p,0)}c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=n(a,e.ZERO),r(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,a){r(a)||(a=new c);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,d=t.y*t.y,E=t.y*t.z,m=t.y*t.w,p=t.z*t.z,y=t.z*t.w,_=t.w*t.w,v=s-d-p+_,T=2*(l-y),R=2*(f+m),A=2*(l+y),S=-s+d-p+_,g=2*(E-h),N=2*(f-m),O=2*(E+h),I=-s-d+p+_;return a[0]=v*i,a[1]=A*i,a[2]=N*i,a[3]=0,a[4]=T*o,a[5]=S*o,a[6]=O*o,a[7]=0,a[8]=R*u,a[9]=g*u,a[10]=I*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,n){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,E=l.x,m=l.y,p=l.z,y=h.x,_=h.y,v=h.z,T=a.x,R=a.y,A=a.z,S=u*-T+s*-R+d*-A,g=y*-T+_*-R+v*-A,N=E*T+m*R+p*A;return r(n)?(n[0]=u,n[1]=y,n[2]=-E,n[3]=0,n[4]=s,n[5]=_,n[6]=-m,n[7]=0,n[8]=d,n[9]=v,n[10]=-p,n[11]=0,n[12]=S,n[13]=g,n[14]=N,n[15]=1,n):new c(u,s,d,S,y,_,v,g,-E,-m,-p,N,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,f=-(r+n)*s,h=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),f=-(i+a)/(i-a),h=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,f=-1,h=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},c.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-t),h=c,d=l,E=f,m=i+c,p=o+l,y=t+f,_=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=m,a[13]=p,a[14]=y,a[15]=_,a},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},c.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},c.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var d=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),n};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],E=e[11],m=e[12],p=e[13],y=e[14],_=e[15],v=t[0],T=t[1],R=t[2],A=t[3],S=t[4],g=t[5],N=t[6],O=t[7],I=t[8],M=t[9],w=t[10],x=t[11],C=t[12],P=t[13],D=t[14],L=t[15],U=r*v+u*T+f*R+m*A,b=a*v+s*T+h*R+p*A,F=i*v+c*T+d*R+y*A,z=o*v+l*T+E*R+_*A,B=r*S+u*g+f*N+m*O,G=a*S+s*g+h*N+p*O,q=i*S+c*g+d*N+y*O,W=o*S+l*g+E*N+_*O,X=r*I+u*M+f*w+m*x,V=a*I+s*M+h*w+p*x,H=i*I+c*M+d*w+y*x,Y=o*I+l*M+E*w+_*x,k=r*C+u*P+f*D+m*L,j=a*C+s*P+h*D+p*L,Z=i*C+c*P+d*D+y*L,K=o*C+l*P+E*D+_*L;return n[0]=U,n[1]=b,n[2]=F,n[3]=z,n[4]=B,n[5]=G,n[6]=q,n[7]=W,n[8]=X,n[9]=V,n[10]=H,n[11]=Y,n[12]=k,n[13]=j,n[14]=Z,n[15]=K,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],E=e[14],m=t[0],p=t[1],y=t[2],_=t[4],v=t[5],T=t[6],R=t[8],A=t[9],S=t[10],g=t[12],N=t[13],O=t[14],I=r*m+o*p+c*y,M=a*m+u*p+l*y,w=i*m+s*p+f*y,x=r*_+o*v+c*T,C=a*_+u*v+l*T,P=i*_+s*v+f*T,D=r*R+o*A+c*S,L=a*R+u*A+l*S,U=i*R+s*A+f*S,b=r*g+o*N+c*O+h,F=a*g+u*N+l*O+d,z=i*g+s*N+f*O+E;return n[0]=I,n[1]=M,n[2]=w,n[3]=0,n[4]=x,n[5]=C,n[6]=P,n[7]=0,n[8]=D,n[9]=L,n[10]=U,n[11]=0,n[12]=b,n[13]=F,n[14]=z,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],E=t[2],m=t[3],p=t[4],y=t[5],_=t[6],v=t[7],T=t[8],R=r*h+o*d+c*E,A=a*h+u*d+l*E,S=i*h+s*d+f*E,g=r*m+o*p+c*y,N=a*m+u*p+l*y,O=i*m+s*p+f*y,I=r*_+o*v+c*T,M=a*_+u*v+l*T,w=i*_+s*v+f*T;return n[0]=R,n[1]=A,n[2]=S,n[3]=0,n[4]=g,n[5]=N,n[6]=O,n[7]=0,n[8]=I,n[9]=M,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var m=new e;c.multiplyByUniformScale=function(e,t,n){return m.x=t,m.y=t,m.z=t,c.multiplyByScale(e,m,n)},c.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new u,y=new u,_=new t,v=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,p),y,o.EPSILON7)&&t.equals(c.getRow(e,3,_),v))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],l=e[12],f=e[1],h=e[5],d=e[9],E=e[13],m=e[2],T=e[6],R=e[10],A=e[14],S=e[3],g=e[7],N=e[11],O=e[15],I=R*O,M=A*N,w=T*O,x=A*g,C=T*N,P=R*g,D=m*O,L=A*S,U=m*N,b=R*S,F=m*g,z=T*S,B=I*h+x*d+C*E-(M*h+w*d+P*E),G=M*f+D*d+b*E-(I*f+L*d+U*E),q=w*f+L*h+F*E-(x*f+D*h+z*E),W=P*f+U*h+z*d-(C*f+b*h+F*d),X=M*a+w*i+P*l-(I*a+x*i+C*l),V=I*r+L*i+U*l-(M*r+D*i+b*l),H=x*r+D*a+z*l-(w*r+L*a+F*l),Y=C*r+b*a+F*i-(P*r+U*a+z*i);I=i*E,M=l*d,w=a*E,x=l*h,C=a*d,P=i*h,D=r*E,L=l*f,U=r*d,b=i*f,F=r*h,z=a*f;var k=I*g+x*N+C*O-(M*g+w*N+P*O),j=M*S+D*N+b*O-(I*S+L*N+U*O),Z=w*S+L*g+F*O-(x*S+D*g+z*O),K=P*S+U*g+z*N-(C*S+b*g+F*N),J=w*R+P*A+M*T-(C*A+I*T+x*R),Q=U*A+I*m+L*R-(D*R+b*A+M*m),$=D*T+z*A+x*m-(F*A+w*m+L*T),ee=F*R+C*m+b*T-(U*T+z*R+P*m),te=r*B+a*G+i*q+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=B*te,n[1]=G*te,n[2]=q*te,n[3]=W*te,n[4]=X*te,n[5]=V*te,n[6]=H*te,n[7]=Y*te,n[8]=k*te,n[9]=j*te,n[10]=Z*te,n[11]=K*te,n[12]=J*te,n[13]=Q*te,n[14]=$*te,n[15]=ee*te,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],E=-n*f-r*h-a*d,m=-i*f-o*h-u*d,p=-s*f-c*h-l*d;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=m,t[14]=p,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function a(t,n){this.normal=e.clone(t),this.distance=n}a.fromPointNormal=function(n,r,i){var o=-e.dot(r,n);return t(i)?(e.clone(r,i.normal),i.distance=o,i):new a(r,o)};var i=new e;return a.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,i),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new a(o,u)},a.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},a.ORIGIN_XY_PLANE=r(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=r(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=r(new a(e.UNIT_Y,0)),a}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,f,h){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var E=new e,m=new e,p=new e,y=new e,_=new e,v=new e,T=new e,R=new e,A=new e,S=new e,g=new e,N=new e;d.fromPoints=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var a=e.clone(t[0],T),i=e.clone(a,E),o=e.clone(a,m),u=e.clone(a,p),s=e.clone(a,y),c=e.clone(a,_),l=e.clone(a,v),f=t.length,h=1;f>h;h++){e.clone(t[h],a);var O=a.x,I=a.y,M=a.z;O<i.x&&e.clone(a,i),O>s.x&&e.clone(a,s),I<o.y&&e.clone(a,o),I>c.y&&e.clone(a,c),M<u.z&&e.clone(a,u),M>l.z&&e.clone(a,l)}var w=e.magnitudeSquared(e.subtract(s,i,R)),x=e.magnitudeSquared(e.subtract(c,o,R)),C=e.magnitudeSquared(e.subtract(l,u,R)),P=i,D=s,L=w;x>L&&(L=x,P=o,D=c),C>L&&(L=C,P=u,D=l);var U=A;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var b=e.magnitudeSquared(e.subtract(D,U,R)),F=Math.sqrt(b),z=S;z.x=i.x,z.y=o.y,z.z=u.z;var B=g;B.x=s.x,B.y=c.y,B.z=l.z;var G=e.multiplyByScalar(e.add(z,B,R),.5,N),q=0;for(h=0;f>h;h++){e.clone(t[h],a);var W=e.magnitude(e.subtract(a,G,R));W>q&&(q=W);var X=e.magnitudeSquared(e.subtract(a,U,R));if(X>b){var V=Math.sqrt(X);F=.5*(F+V),b=F*F;var H=V-F;U.x=(F*U.x+H*a.x)/V,U.y=(F*U.y+H*a.y)/V,U.z=(F*U.z+H*a.z)/V}}return q>F?(e.clone(U,n.center),n.radius=F):(e.clone(G,n.center),n.radius=q),n};var O=new o,I=new e,M=new e,w=new t,x=new t;d.fromRectangle2D=function(e,t,n){return d.fromRectangleWithHeights2D(e,t,0,0,n)},d.fromRectangleWithHeights2D=function(t,a,i,o,u){if(r(u)||(u=new d),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,O),h.southwest(t,w),w.height=i,h.northeast(t,x),x.height=o;var s=a.project(w,I),c=a.project(x,M),l=c.x-s.x,f=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+E*E);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*f,m.z=s.z+.5*E,u};var C=[];d.fromRectangle3D=function(e,t,a,o){t=n(t,i.WGS84),a=n(a,0);var u;return r(e)&&(u=h.subsample(e,t,a,C)),d.fromPoints(u,o)},d.fromVertices=function(t,a,i,o){if(r(o)||(o=new d),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=n(a,e.ZERO),i=n(i,3);var u=T;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,E),c=e.clone(u,m),l=e.clone(u,p),f=e.clone(u,y),h=e.clone(u,_),O=e.clone(u,v),I=t.length,M=0;I>M;M+=i){var w=t[M]+a.x,x=t[M+1]+a.y,C=t[M+2]+a.z;u.x=w,u.y=x,u.z=C,w<s.x&&e.clone(u,s),w>f.x&&e.clone(u,f),x<c.y&&e.clone(u,c),x>h.y&&e.clone(u,h),C<l.z&&e.clone(u,l),C>O.z&&e.clone(u,O)}var P=e.magnitudeSquared(e.subtract(f,s,R)),D=e.magnitudeSquared(e.subtract(h,c,R)),L=e.magnitudeSquared(e.subtract(O,l,R)),U=s,b=f,F=P;D>F&&(F=D,U=c,b=h),L>F&&(F=L,U=l,b=O);var z=A;z.x=.5*(U.x+b.x),z.y=.5*(U.y+b.y),z.z=.5*(U.z+b.z);var B=e.magnitudeSquared(e.subtract(b,z,R)),G=Math.sqrt(B),q=S;q.x=s.x,q.y=c.y,q.z=l.z;var W=g;W.x=f.x,W.y=h.y,W.z=O.z;var X=e.multiplyByScalar(e.add(q,W,R),.5,N),V=0;for(M=0;I>M;M+=i){u.x=t[M]+a.x,u.y=t[M+1]+a.y,u.z=t[M+2]+a.z;var H=e.magnitude(e.subtract(u,X,R));H>V&&(V=H);var Y=e.magnitudeSquared(e.subtract(u,z,R));if(Y>B){var k=Math.sqrt(Y);G=.5*(G+k),B=G*G;var j=k-G;z.x=(G*z.x+j*u.x)/k,z.y=(G*z.y+j*u.y)/k,z.z=(G*z.z+j*u.z)/k}}return V>G?(e.clone(z,o.center),o.radius=G):(e.clone(X,o.center),o.radius=V),o},d.fromCornerPoints=function(t,n,a){r(a)||(a=new d);var i=a.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,n),a},d.fromEllipsoid=function(t,n){return r(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=t.length;if(1===a)return d.clone(t[0],n);if(2===a)return d.union(t[0],t[1],n);for(var i=[],o=0;a>o;o++)i.push(t[o].center);n=d.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return n.radius=s,n};var D=new e,L=new e,U=new e;d.fromOrientedBoundingBox=function(t,n){r(n)||(n=new d);var a=t.halfAxes,i=c.getColumn(a,0,D),o=c.getColumn(a,1,L),u=c.getColumn(a,2,U),s=e.magnitude(i),l=e.magnitude(o),f=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(s,l,f),n},d.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,r){r=n(r,0);var a=e.center;t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius},d.unpack=function(e,t,a){t=n(t,0),r(a)||(a=new d);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var b=new e,F=new e;d.union=function(t,n,a){r(a)||(a=new d);var i=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,i,b),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return n.clone(a),a;var f=.5*(o+l+s),h=e.multiplyByScalar(c,(-o+f)/l,F);return e.add(h,i,h),e.clone(h,a.center),a.radius=f,a};var z=new e;d.expand=function(t,n,r){r=d.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,z));return a>r.radius&&(r.radius=a),r},d.intersectPlane=function(t,n){var r=t.center,a=t.radius,i=n.normal,o=e.dot(i,r)+n.distance;return-a>o?u.OUTSIDE:a>o?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var B=new e;d.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,B);return e.magnitudeSquared(r)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var G=new e;d.computePlaneDistances=function(t,n,a,i){r(i)||(i=new s);var o=e.subtract(t.center,n,G),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var q=new e,W=new e,X=new e,V=new e,H=new e,Y=new t,k=new Array(8),j=0;8>j;++j)k[j]=new e;var Z=new o;return d.projectTo2D=function(t,r,a){r=n(r,Z);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,q),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,X);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,H),h=e.negate(c,V),E=k,m=E[0];e.add(s,l,m),e.add(m,c,m),m=E[1],e.add(s,l,m),e.add(m,h,m),m=E[2],e.add(s,f,m),e.add(m,h,m),m=E[3],e.add(s,f,m),e.add(m,c,m),e.negate(s,s),m=E[4],e.add(s,l,m),e.add(m,c,m),m=E[5],e.add(s,l,m),e.add(m,h,m),m=E[6],e.add(s,f,m),e.add(m,h,m),m=E[7],e.add(s,f,m),e.add(m,c,m);for(var p=E.length,y=0;p>y;++y){var _=E[y];e.add(o,_,_);var v=i.cartesianToCartographic(_,Y);r.project(v,_)}a=d.fromPoints(E,a),o=a.center;var T=o.x,R=o.y,A=o.z;return o.x=A,o.y=T,o.z=R,a},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,n){return d.computePlaneDistances(this,e,t,n)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";function i(t,n){this.x=e(t,0),this.y=e(n,0)}i.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new i(e,n)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)},i.ZERO=r(new i(0,0)),i.UNIT_X=r(new i(1,0)),i.UNIT_Y=r(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,
CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?r.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(r.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[r.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(p.userAgent);null!==e&&(y=!0,_=r(e[1]))}return y}function i(){return a()&&_}function o(){if(!t(v)&&(v=!1,!a()&&/ Safari\/[\.0-9]+/.test(p.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(p.userAgent);null!==e&&(v=!0,T=r(e[1]))}return v}function u(){return o()&&T}function s(){if(!t(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(p.userAgent);null!==e&&(R=!0,A=r(e[1]),A.isNightly=!!e[2])}return R}function c(){return s()&&A}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===p.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(p.userAgent),null!==e&&(S=!0,g=r(e[1]))):"Netscape"===p.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(p.userAgent),null!==e&&(S=!0,g=r(e[1])))}return S}function f(){return l()&&g}function h(){if(!t(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(p.userAgent);null!==e&&(N=!0,O=r(e[1]))}return N}function d(){return t(I)||(I=/Windows/i.test(p.appVersion)),I}function E(){return h()&&O}function m(){return t(M)||(M="undefined"!=typeof PointerEvent&&(!t(p.pointerEnabled)||p.pointerEnabled)),M}var p;p="undefined"!=typeof navigator?navigator:{};var y,_,v,T,R,A,S,g,N,O,I,M,w={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:E,isWindows:d,hardwareConcurrency:e(p.hardwareConcurrency,3),supportsPointerEvents:m};return w.supportsFullscreen=function(){return n.supportsFullscreen()},w.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},w.supportsWebWorkers=function(){return"undefined"!=typeof Worker},w}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return n(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,n,a,i){switch(a=t(a,0),i=t(i,(n.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(n,a,i);case o.SHORT:return new Int16Array(n,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(n,a,i);case o.FLOAT:return new Float32Array(n,a,i);case o.DOUBLE:return new Float64Array(n,a,i);default:throw new r("componentDatatype is not a valid value.")}},i(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===n.POINTS||e===n.LINES||e===n.LINE_LOOP||e===n.LINE_STRIP||e===n.TRIANGLES||e===n.TRIANGLE_STRIP||e===n.TRIANGLE_FAN}};return t(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,a){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0}return i.computeNumberOfVertices=function(e){var r=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return r}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,n,r){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=r.clone(e(t.modelMatrix,r.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var n=t.x,r=t.y;t.x=(1-Math.abs(r))*a.signNotZero(n),t.y=(1-Math.abs(n))*a.signNotZero(r)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,n,r){if(r.x=a.fromSNorm(e),r.y=a.fromSNorm(n),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var i=r.x;r.x=(1-Math.abs(r.y))*a.signNotZero(i),r.y=(1-Math.abs(i))*a.signNotZero(r.y)}return t.normalize(r,r)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var n=e/256,r=Math.floor(n),a=256*(n-r);return i.octDecode(r,a,t)},i.octPack=function(e,t,n,r){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(n,o);return r.x=65536*s.x+a,r.y=65536*s.y+u,r},i.octUnpack=function(e,t,n,r){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,n),i.octDecode(o,s,r)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*t+n},i.decompressTextureCoordinates=function(e,t){var n=e/4096;return t.x=Math.floor(n)/4096,t.y=n-Math.floor(n),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(r,a,s,c,l){n(l)||(l=new t);var f,h,d,E,m,p,y,_;n(a.z)?(f=t.subtract(s,a,i),h=t.subtract(c,a,o),d=t.subtract(r,a,u),E=t.dot(f,f),m=t.dot(f,h),p=t.dot(f,d),y=t.dot(h,h),_=t.dot(h,d)):(f=e.subtract(s,a,i),h=e.subtract(c,a,o),d=e.subtract(r,a,u),E=e.dot(f,f),m=e.dot(f,h),p=e.dot(f,d),y=e.dot(h,h),_=e.dot(h,d));var v=1/(E*y-m*m);return l.y=(y*p-m*_)*v,l.z=(E*_-m*p)*v,l.x=1-l.y-l.z,l}var i=new t,o=new t,u=new t;return a}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}r.encode=function(e,n){t(n)||(n={high:0,low:0});var r;return e>=0?(r=65536*Math.floor(e/65536),n.high=r,n.low=e-r):(r=65536*Math.floor(-e/65536),n.high=-r,n.low=e+r),n};var a={high:0,low:0};r.fromCartesian=function(e,n){t(n)||(n=new r);var i=n.high,o=n.low;return r.encode(e.x,a),i.x=a.high,o.x=a.low,r.encode(e.y,a),i.y=a.high,o.y=a.low,r.encode(e.z,a),i.z=a.high,o.z=a.low,n};var i=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,i);var a=i.high,o=i.low;t[n]=a.x,t[n+1]=a.y,t[n+2]=a.z,t[n+3]=o.x,t[n+4]=o.y,t[n+5]=o.z},r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,n,r){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,r):new Uint16Array(t,n,r)},r(i)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,0>i?[i,0]:[0,i];var c=r*r,l=4*e*a,f=n(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*n(r,t.sign(r)*Math.sqrt(f),t.EPSILON14);return r>0?[h/e,a/h]:[a/h,h/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,f=u*c,h=u*u,d=s*s,E=o*s-h,m=o*c-u*s,p=u*c-d,y=4*E*p-m*m;if(0>y){var _,v,T;h*f>=l*d?(_=o,v=E,T=-2*u*E+o*m):(_=c,v=p,T=-c*m+2*s*p);var R=0>T?-1:1,A=-R*Math.abs(_)*Math.sqrt(-y);i=-T+A;var S=i/2,g=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),N=i===A?-g:-v/g;return a=0>=v?g+N:-T/(g*g+N*N+v),h*f>=l*d?[(a-u)/o]:[-c/(a+s)]}var O=E,I=-2*u*E+o*m,M=p,w=-c*m+2*s*p,x=Math.sqrt(y),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-I)/3);a=2*Math.sqrt(-O);var D=Math.cos(P);i=a*D;var L=a*(-D/2-C*Math.sin(P)),U=i+L>2*u?i-u:L-u,b=o,F=U/b;P=Math.abs(Math.atan2(c*x,-w)/3),a=2*Math.sqrt(-M),D=Math.cos(P),i=a*D,L=a*(-D/2-C*Math.sin(P));var z=-c,B=2*s>i+L?i+s:L+s,G=z/B,q=b*B,W=-U*B-b*z,X=U*z,V=(s*W-u*X)/(-u*W+s*q);return V>=F?G>=F?G>=V?[F,V,G]:[F,G,V]:[G,F,V]:G>=F?[V,F,G]:G>=V?[V,G,F]:[G,V,F]}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<n.EPSILON14){var E=r.computeRealRoots(1,s,l);if(2===E.length){var m,p=E[0],y=E[1];if(p>=0&&y>=0){var _=Math.sqrt(p),v=Math.sqrt(y);return[h-v,h-_,h+_,h+v]}if(p>=0&&0>y)return m=Math.sqrt(p),[h-m,h+m];if(0>p&&y>=0)return m=Math.sqrt(y),[h-m,h+m]}return[]}if(d>0){var T=Math.sqrt(d),R=(s+d-c/T)/2,A=(s+d+c/T)/2,S=r.computeRealRoots(1,T,R),g=r.computeRealRoots(1,-T,A);return 0!==S.length?(S[0]+=h,S[1]+=h,0!==g.length?(g[0]+=h,g[1]+=h,S[1]<=g[0]?[S[0],S[1],g[0],g[1]]:g[1]<=S[0]?[g[0],g[1],S[0],S[1]]:S[0]>=g[0]&&S[1]<=g[1]?[g[0],S[0],S[1],g[1]]:g[0]>=S[0]&&g[1]<=S[1]?[S[0],g[0],g[1],S[1]]:S[0]>g[0]&&S[0]<g[1]?[g[0],S[0],g[1],S[1]]:[S[0],g[0],S[1],g[1]]):S):0!==g.length?(g[0]+=h,g[1]+=h,g):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,h=c*o-i*a*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var E,m,p=d[0],y=a-p,_=y*y,v=t/2,T=y/2,R=_-4*o,A=_+4*Math.abs(o),S=c-4*p,g=c+4*Math.abs(p);if(0>p||S*A>R*g){var N=Math.sqrt(S);E=N/2,m=0===N?0:(t*T-i)/N}else{var O=Math.sqrt(R);E=0===O?0:(t*T-i)/O,m=O/2}var I,M;0===v&&0===E?(I=0,M=0):n.sign(v)===n.sign(E)?(I=v+E,M=p/I):(M=v-E,I=p/M);var w,x;0===T&&0===m?(w=0,x=0):n.sign(T)===n.sign(m)?(w=T+m,x=o/w):(x=T-m,w=o/x);var C=r.computeRealRoots(1,I,w),P=r.computeRealRoots(1,M,x);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,f=r*r,h=f*r,d=a*a,E=d*a,m=u*c*f-4*s*h-4*e*l*f+18*e*t*n*h-27*i*f*f+256*o*E+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*f+144*i*n*f)+d*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return m},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,f=u/t,h=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return a(c,l,f,h);case 1:return i(c,l,f,h);case 2:return i(c,l,f,h);case 3:return a(c,l,f,h);case 4:return a(c,l,f,h);case 5:return i(c,l,f,h);case 6:return a(c,l,f,h);case 7:return a(c,l,f,h);case 8:return i(c,l,f,h);case 9:return a(c,l,f,h);case 10:return a(c,l,f,h);case 11:return i(c,l,f,h);case 12:return a(c,l,f,h);case 13:return a(c,l,f,h);case 14:return a(c,l,f,h);case 15:return a(c,l,f,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r}return a.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(t,r,a,o,u){u=n(u,!1);var s,c,l,f,h,d=t.origin,E=t.direction,m=e.subtract(a,r,p),R=e.subtract(o,r,y),A=e.cross(E,R,_),S=e.dot(m,A);if(u){if(S<i.EPSILON6)return;if(s=e.subtract(d,r,v),l=e.dot(s,A),0>l||l>S)return;if(c=e.cross(s,m,T),f=e.dot(E,c),0>f||l+f>S)return;h=e.dot(R,c)/S}else{if(Math.abs(S)<i.EPSILON6)return;var g=1/S;if(s=e.subtract(d,r,v),l=e.dot(s,A)*g,0>l||l>1)return;if(c=e.cross(s,m,T),f=e.dot(E,c)*g,0>f||l+f>1)return;h=e.dot(R,c)*g}return h}function f(e,t,n,r){var a=t*t-4*e*n;if(!(0>a)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}function h(t,n,a){r(a)||(a={});var i=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(i,u,_),l=e.dot(o,o),h=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,E=f(l,h,d,A);return r(E)?(a.start=E.root0,a.stop=E.root1,a):void 0}function d(e,t,n){var r=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function E(t,n,r,a,c){var l,f=a*a,h=c*c,E=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*h,m=c*(a*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+n.y),p=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*h+a*n.x+r,y=h*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),_=c*(a*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),v=[];if(0===_&&0===y){if(l=u.computeRealRoots(E,m,p),0===l.length)return v;var T=l[0],R=Math.sqrt(Math.max(1-T*T,0));if(v.push(new e(a,c*T,c*-R)),v.push(new e(a,c*T,c*R)),2===l.length){var A=l[1],S=Math.sqrt(Math.max(1-A*A,0));v.push(new e(a,c*A,c*-S)),v.push(new e(a,c*A,c*S))}return v}var g=_*_,N=y*y,O=E*E,I=_*y,M=O+N,w=2*(m*E+I),x=2*p*E+m*m-N+g,C=2*(p*m-I),P=p*p-g;if(0===M&&0===w&&0===x&&0===C)return v;l=s.computeRealRoots(M,w,x,C,P);var D=l.length;if(0===D)return v;for(var L=0;D>L;++L){var U,b=l[L],F=b*b,z=Math.max(1-F,0),B=Math.sqrt(z);U=i.sign(E)===i.sign(p)?d(E*F+p,m*b,i.EPSILON12):i.sign(p)===i.sign(m*b)?d(E*F,m*b+p,i.EPSILON12):d(E*F+m*b,p,i.EPSILON12);var G=d(y*b,_,i.EPSILON15),q=U*G;0>q?v.push(new e(a,c*b,c*B)):q>0?v.push(new e(a,c*b,c*-B)):0!==B?(v.push(new e(a,c*b,c*-B)),v.push(new e(a,c*b,c*B)),++L):v.push(new e(a,c*b,c*B))}return v}var m={};m.rayPlane=function(t,n,a){r(a)||(a=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON15)){var l=(-n.distance-e.dot(s,o))/c;if(!(0>l))return a=e.multiplyByScalar(u,l,a),e.add(o,a,a)}};var p=new e,y=new e,_=new e,v=new e,T=new e;m.rayTriangle=function(t,n,a,i,o,u){var s=l(t,n,a,i,o);if(r(s)&&!(0>s))return r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var R=new c;m.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=R;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!r(f)||0>f||f>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var A={root0:0,root1:0};m.raySphere=function(e,t,n){return n=h(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var S=new c;m.lineSegmentSphere=function(t,n,a,i){var o=S,u=e.subtract(n,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=h(o,a,i),!r(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var g=new e,N=new e;m.rayEllipsoid=function(t,n){var r,a,i,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,g),l=e.multiplyComponents(s,t.direction,N),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return;var d=h*h;if(r=f-1,a=e.magnitudeSquared(l),i=a*r,i>d)return;if(d>i){o=h*h-i,u=-h+Math.sqrt(o);var E=u/a,m=r/u;return m>E?{start:E,stop:m}:{start:m,stop:E}}var p=Math.sqrt(r/a);return{start:p,stop:p}}return 1>f?(r=f-1,a=e.magnitudeSquared(l),i=a*r,o=h*h-i,u=-h+Math.sqrt(o),{start:0,stop:u/a}):0>h?(a=e.magnitudeSquared(l),{start:0,stop:-h/a}):void 0};var O=new e,I=new e,M=new e,w=new e,x=new e,C=new o,P=new o,D=new o,L=new o,U=new o,b=new o,F=new o,z=new e,B=new e,G=new t;m.grazingAltitudeLocation=function(t,n){var a=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(a,O);if(e.dot(u,s)>=0)return a;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,O),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(h,f,I),I),m=e.normalize(e.cross(f,d,M),M),p=C;p[0]=f.x,p[1]=f.y,p[2]=f.z,p[3]=d.x,p[4]=d.y,p[5]=d.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var y=o.transpose(p,P),_=o.fromScale(n.radii,D),v=o.fromScale(n.oneOverRadii,L),T=U;T[0]=0,T[1]=-u.z,T[2]=u.y,T[3]=u.z,T[4]=0,T[5]=-u.x,T[6]=-u.y,T[7]=u.x,T[8]=0;var R,A,S=o.multiply(o.multiply(y,v,b),T,b),g=o.multiply(o.multiply(S,_,F),p,F),N=o.multiplyByVector(S,a,x),q=E(g,e.negate(N,O),0,0,1),W=q.length;if(W>0){for(var X=e.clone(e.ZERO,B),V=Number.NEGATIVE_INFINITY,H=0;W>H;++H){R=o.multiplyByVector(_,o.multiplyByVector(p,q[H],z),z);var Y=e.normalize(e.subtract(R,a,w),w),k=e.dot(Y,u);k>V&&(V=k,X=e.clone(R,X))}var j=n.cartesianToCartographic(X,G);return V=i.clamp(V,0,1),A=e.magnitude(e.subtract(X,a,w))*Math.sqrt(1-V*V),A=c?-A:A,j.height=A,n.cartographicToCartesian(j,new e)}};var q=new e;return m.lineSegmentPlane=function(t,n,a,o){r(o)||(o=new e);var u=e.subtract(n,t,q),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON6)){var l=e.dot(s,t),f=-(a.distance+l)/c;if(!(0>f||f>1))return e.multiplyByScalar(u,f,o),e.add(t,o,o),o}},m.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return m.lineSegmentPlane(t,n,a,f),m.lineSegmentPlane(t,r,a,h),{positions:[t,n,r,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return m.lineSegmentPlane(n,r,a,f),m.lineSegmentPlane(n,t,a,h),{positions:[t,n,r,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(r,t,a,f),m.lineSegmentPlane(r,n,a,h),{positions:[t,n,r,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(n,t,a,f),m.lineSegmentPlane(r,t,a,h),{positions:[t,n,r,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(r,n,a,f),m.lineSegmentPlane(t,n,a,h),{positions:[t,n,r,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,r,a,f),m.lineSegmentPlane(n,r,a,h),{positions:[t,n,r,f,h],indices:[0,1,4,0,4,3,2,3,4]}}},m}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";var r={};return r.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var r=n.indices,a=n.maximumIndex,i=e(n.cacheSize,24),o=r.length;if(!t(a)){a=0;for(var u=0,s=r[u];o>u;)s>a&&(a=s),++u,s=r[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var f=i+1,h=0;o>h;++h)f-c[r[h]]>i&&(c[r[h]]=f,++f);return(f-i+1)/(o/3)},r.tipsify=function(n){function r(e,t,n,r){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;r>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,n,a,i,o,u){for(var s,c=-1,l=-1,f=0;f<n.length;){var h=n[f];a[h].numLiveTriangles&&(s=0,i-a[h].timeStamp+2*a[h].numLiveTriangles<=t&&(s=i-a[h].timeStamp),(s>l||-1===l)&&(l=s,c=h)),++f}return-1===c?r(a,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var i,o=n.indices,u=n.maximumIndex,s=e(n.cacheSize,24),c=o.length,l=0,f=0,h=o[f],d=c;if(t(u))l=u+1;else{for(;d>f;)h>l&&(l=h),++f,h=o[f];if(-1===l)return 0;++l}for(var E=[],m=0;l>m;m++)E[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var p=0;d>f;)E[o[f]].vertexTriangles.push(p),++E[o[f]].numLiveTriangles,E[o[f+1]].vertexTriangles.push(p),++E[o[f+1]].numLiveTriangles,E[o[f+2]].vertexTriangles.push(p),++E[o[f+2]].numLiveTriangles,++p,f+=3;var y=0,_=s+1;i=1;var v,T,R=[],A=[],S=0,g=[],N=c/3,O=[];for(m=0;N>m;m++)O[m]=!1;for(var I,M;-1!==y;){R=[],T=E[y],M=T.vertexTriangles.length;for(var w=0;M>w;++w)if(p=T.vertexTriangles[w],!O[p]){O[p]=!0,f=p+p+p;for(var x=0;3>x;++x)I=o[f],R.push(I),A.push(I),g[S]=I,++S,v=E[I],--v.numLiveTriangles,_-v.timeStamp>s&&(v.timeStamp=_,++_),++f}y=a(o,s,R,E,_,A,l)}return g},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,m,p,y,_,v,T,R,A,S,g,N){
"use strict";function O(e,t,n,r,a){e[t++]=n,e[t++]=r,e[t++]=r,e[t++]=a,e[t++]=a,e[t]=n}function I(e){for(var t=e.length,n=t/3*6,r=y.createTypedArray(t,n),a=0,i=0;t>i;i+=3,a+=6)O(r,a,e[i],e[i+1],e[i+2]);return r}function M(e){var t=e.length;if(t>=3){var n=6*(t-2),r=y.createTypedArray(t,n);O(r,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)O(r,a,e[i-1],e[i],e[i-2]);return r}return new Uint16Array}function w(e){if(e.length>0){for(var t=e.length-1,n=6*(t-1),r=y.createTypedArray(t,n),a=e[0],i=0,o=1;t>o;++o,i+=6)O(r,i,a,e[o],e[o+1]);return r}return new Uint16Array}function x(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&c(e[n])&&c(e[n].values)){var r=e[n];t[n]=new E({componentDatatype:r.componentDatatype,componentsPerAttribute:r.componentsPerAttribute,normalize:r.normalize,values:[]})}return t}function C(e,t,n){for(var r in t)if(t.hasOwnProperty(r)&&c(t[r])&&c(t[r].values))for(var a=t[r],i=0;i<a.componentsPerAttribute;++i)e[r].values.push(a.values[n*a.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var n=t.values,r=n.length,i=0;r>i;i+=3)a.unpack(n,i,ie),A.multiplyByPoint(e,ie,ie),a.pack(ie,n,i)}function D(e,t){if(c(t))for(var n=t.values,r=n.length,i=0;r>i;i+=3)a.unpack(n,i,ie),R.multiplyByVector(e,ie,ie),ie=a.normalize(ie,ie),a.pack(ie,n,i)}function L(e,t){var n,r=e.length,a={},i=e[0][t].attributes;for(n in i)if(i.hasOwnProperty(n)&&c(i[n])&&c(i[n].values)){for(var o=i[n],s=o.values.length,l=!0,f=1;r>f;++f){var h=e[f][t].attributes[n];if(!c(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(a[n]=new E({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function U(e,t){var r,i,o,u,s,l,f,h=e.length,E=(e[0].modelMatrix,c(e[0][t].indices)),m=e[0][t].primitiveType,p=L(e,t);for(r in p)if(p.hasOwnProperty(r))for(s=p[r].values,u=0,i=0;h>i;++i)for(l=e[i][t].attributes[r].values,f=l.length,o=0;f>o;++o)s[u++]=l[o];var _;if(E){var v=0;for(i=0;h>i;++i)v+=e[i][t].indices.length;var T=d.computeNumberOfVertices(new d({attributes:p,primitiveType:g.POINTS})),R=y.createTypedArray(T,v),A=0,S=0;for(i=0;h>i;++i){var N=e[i][t].indices,O=N.length;for(u=0;O>u;++u)R[A++]=S+N[u];S+=d.computeNumberOfVertices(e[i][t])}_=R}var I,M=new a,w=0;for(i=0;h>i;++i){if(I=e[i][t].boundingSphere,!c(I)){M=void 0;break}a.add(I.center,M,M)}if(c(M))for(a.divideByScalar(M,h,M),i=0;h>i;++i){I=e[i][t].boundingSphere;var x=a.magnitude(a.subtract(I.center,M,se))+I.radius;x>w&&(w=x)}return new d({attributes:p,indices:_,primitiveType:m,boundingSphere:c(M)?new n(M,w):void 0})}function b(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,t),r=0;t>r;++r)n[r]=r;return e.indices=n,e}function F(e){var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,3*(t-2));n[0]=1,n[1]=0,n[2]=2;for(var r=3,a=3;t>a;++a)n[r++]=a-1,n[r++]=0,n[r++]=a;return e.indices=n,e.primitiveType=g.TRIANGLES,e}function z(e){var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,3*(t-2));n[0]=0,n[1]=1,n[2]=2,t>3&&(n[3]=0,n[4]=2,n[5]=3);for(var r=6,a=3;t-1>a;a+=2)n[r++]=a,n[r++]=a-1,n[r++]=a+1,t>a+2&&(n[r++]=a,n[r++]=a+1,n[r++]=a+2);return e.indices=n,e.primitiveType=g.TRIANGLES,e}function B(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,t),r=0;t>r;++r)n[r]=r;return e.indices=n,e}function G(e){var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,2*(t-1));n[0]=0,n[1]=1;for(var r=2,a=2;t>a;++a)n[r++]=a-1,n[r++]=a;return e.indices=n,e.primitiveType=g.LINES,e}function q(e){var t=d.computeNumberOfVertices(e),n=y.createTypedArray(t,2*t);n[0]=0,n[1]=1;for(var r=2,a=2;t>a;++a)n[r++]=a-1,n[r++]=a;return n[r++]=t-1,n[r]=0,e.indices=n,e.primitiveType=g.LINES,e}function W(e){switch(e.primitiveType){case g.TRIANGLE_FAN:return F(e);case g.TRIANGLE_STRIP:return z(e);case g.TRIANGLES:return b(e);case g.LINE_STRIP:return G(e);case g.LINE_LOOP:return q(e);case g.LINES:return B(e)}return e}function X(e,t){Math.abs(e.y)<T.EPSILON6&&(t?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function V(e,t,n){if(0!==e.y&&0!==t.y&&0!==n.y)return X(e,e.y<0),X(t,t.y<0),void X(n,n.y<0);var r,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(n.y);r=a>i?a>o?T.sign(e.y):T.sign(n.y):i>o?T.sign(t.y):T.sign(n.y);var u=0>r;X(e,u),X(t,u),X(n,u)}function H(e,t,n,r){a.add(e,a.multiplyByScalar(a.subtract(t,e,Te),e.y/(e.y-t.y),Te),n),a.clone(n,r),X(n,!0),X(r,!1)}function Y(e,t,n){if(!(e.x>=0||t.x>=0||n.x>=0)){V(e,t,n);var r=e.y<0,a=t.y<0,i=n.y<0,o=0;o+=r?1:0,o+=a?1:0,o+=i?1:0;var u=Ne.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,r?(H(e,t,Re,Se),H(e,n,Ae,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(H(t,n,Re,Se),H(t,e,Ae,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(H(n,e,Re,Se),H(n,t,Ae,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,r?a?i||(H(n,e,Re,Se),H(n,t,Ae,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(H(t,n,Re,Se),H(t,e,Ae,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(H(e,t,Re,Se),H(e,n,Ae,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ne.positions;return s[0]=e,s[1]=t,s[2]=n,s.length=3,(1===o||2===o)&&(s[3]=Re,s[4]=Ae,s[5]=Se,s[6]=ge,s.length=7),Ne}}function k(e,t){var r=e.attributes;if(0!==r.position.values.length){for(var a in r)if(r.hasOwnProperty(a)&&c(r[a])&&c(r[a].values)){var i=r[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=d.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),t&&(e.boundingSphere=n.fromVertices(r.position.values)),e}}function j(e){var t=e.attributes,n={};for(var r in t)if(t.hasOwnProperty(r)&&c(t[r])&&c(t[r].values)){var a=t[r];n[r]=new E({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new d({attributes:n,indices:[],primitiveType:e.primitiveType})}function Z(e,t,n){var r=c(e.geometry.boundingSphere);t=k(t,r),n=k(n,r),c(n)&&!c(t)?e.geometry=n:!c(n)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=n,e.geometry=void 0)}function K(e,n,i,o,u,s,l,f,h,d,E){if(c(s)||c(l)||c(f)||c(h)){var m=a.fromArray(u,3*e,Oe),p=a.fromArray(u,3*n,Ie),y=a.fromArray(u,3*i,Me),_=t(o,m,p,y,we);if(c(s)){var v=a.fromArray(s,3*e,Oe),T=a.fromArray(s,3*n,Ie),R=a.fromArray(s,3*i,Me);a.multiplyByScalar(v,_.x,v),a.multiplyByScalar(T,_.y,T),a.multiplyByScalar(R,_.z,R);var A=a.add(v,T,v);a.add(A,R,A),a.normalize(A,A),a.pack(A,d.normal.values,3*E)}if(c(l)){var S=a.fromArray(l,3*e,Oe),g=a.fromArray(l,3*n,Ie),N=a.fromArray(l,3*i,Me);a.multiplyByScalar(S,_.x,S),a.multiplyByScalar(g,_.y,g),a.multiplyByScalar(N,_.z,N);var O=a.add(S,g,S);a.add(O,N,O),a.normalize(O,O),a.pack(O,d.binormal.values,3*E)}if(c(f)){var I=a.fromArray(f,3*e,Oe),M=a.fromArray(f,3*n,Ie),w=a.fromArray(f,3*i,Me);a.multiplyByScalar(I,_.x,I),a.multiplyByScalar(M,_.y,M),a.multiplyByScalar(w,_.z,w);var x=a.add(I,M,I);a.add(x,w,x),a.normalize(x,x),a.pack(x,d.tangent.values,3*E)}if(c(h)){var C=r.fromArray(h,2*e,xe),P=r.fromArray(h,2*n,Ce),D=r.fromArray(h,2*i,Pe);r.multiplyByScalar(C,_.x,C),r.multiplyByScalar(P,_.y,P),r.multiplyByScalar(D,_.z,D);var L=r.add(C,P,C);r.add(L,D,L),r.pack(L,d.st.values,2*E)}}}function J(e,t,n,r,a,i){var o=e.position.values.length/3;if(-1!==a){var u=r[a],s=n[u];return-1===s?(n[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function Q(e){var t,n,r,i,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,h=c(s.binormal)?s.binormal.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,E=c(s.st)?s.st.values:void 0,m=u.indices,p=j(u),y=j(u),_=[];_.length=l.length/3;var v=[];for(v.length=l.length/3,o=0;o<_.length;++o)_[o]=-1,v[o]=-1;var T=m.length;for(o=0;T>o;o+=3){var R=m[o],A=m[o+1],S=m[o+2],g=a.fromArray(l,3*R),N=a.fromArray(l,3*A),O=a.fromArray(l,3*S),I=Y(g,N,O);if(c(I)&&I.positions.length>3)for(var M=I.positions,w=I.indices,x=w.length,C=0;x>C;++C){var P=w[C],D=M[P];D.y<0?(t=y.attributes,n=y.indices,r=_):(t=p.attributes,n=p.indices,r=v),i=J(t,n,r,m,3>P?o+P:-1,D),K(R,A,S,D,l,f,h,d,E,t,i)}else c(I)&&(g=I.positions[0],N=I.positions[1],O=I.positions[2]),g.y<0?(t=y.attributes,n=y.indices,r=_):(t=p.attributes,n=p.indices,r=v),i=J(t,n,r,m,o,g),K(R,A,S,g,l,f,h,d,E,t,i),i=J(t,n,r,m,o+1,N),K(R,A,S,N,l,f,h,d,E,t,i),i=J(t,n,r,m,o+2,O),K(R,A,S,O,l,f,h,d,E,t,i)}Z(e,y,p)}function $(e){var t,n=e.geometry,r=n.attributes,i=r.position.values,o=n.indices,u=j(n),s=j(n),l=o.length,f=[];f.length=i.length/3;var h=[];for(h.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,h[t]=-1;for(t=0;l>t;t+=2){var d=o[t],E=o[t+1],m=a.fromArray(i,3*d,Oe),p=a.fromArray(i,3*E,Ie);Math.abs(m.y)<T.EPSILON6&&(m.y<0?m.y=-T.EPSILON6:m.y=T.EPSILON6),Math.abs(p.y)<T.EPSILON6&&(p.y<0?p.y=-T.EPSILON6:p.y=T.EPSILON6);var y=u.attributes,_=u.indices,R=h,A=s.attributes,S=s.indices,g=f,N=v.lineSegmentPlane(m,p,De,Me);if(c(N)){var O=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,Le);m.y<0&&(a.negate(O,O),y=s.attributes,_=s.indices,R=f,A=u.attributes,S=u.indices,g=h);var I=a.add(N,O,Ue);J(y,_,R,o,t,m),J(y,_,R,o,-1,I),a.negate(O,O),a.add(N,O,I),J(A,S,g,o,-1,I),J(A,S,g,o,t+1,p)}else{var M,w,x;m.y<0?(M=s.attributes,w=s.indices,x=f):(M=u.attributes,w=u.indices,x=h),J(M,w,x,o,t,m),J(M,w,x,o,t+1,p)}}Z(e,s,u)}function ee(e){var t,n,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,d=s.expandAndWidth.values,E=c(s.st)?s.st.values:void 0,m=c(s.color)?s.color.values:void 0,p=j(u),y=j(u),_=l.length/3;for(t=0;_>t;t+=4){var R=t,A=t+1,S=t+2,g=t+3,N=a.fromArray(l,3*R,ze),O=a.fromArray(l,3*A,Be),I=a.fromArray(l,3*S,Ge),M=a.fromArray(l,3*g,qe);Math.abs(N.y)<T.EPSILON6&&(N.y=T.EPSILON6*(I.y<0?-1:1),O.y=N.y),Math.abs(I.y)<T.EPSILON6&&(I.y=T.EPSILON6*(N.y<0?-1:1),M.y=I.y);var w=p.attributes,x=p.indices,C=y.attributes,P=y.indices,D=v.lineSegmentPlane(N,I,De,We);if(c(D)){var L=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,Xe);N.y<0&&(a.negate(L,L),w=y.attributes,x=y.indices,C=p.attributes,P=p.indices);var U=a.add(D,L,Ve);for(w.position.values.push(N.x,N.y,N.z,O.x,O.y,O.z),w.position.values.push(U.x,U.y,U.z),w.position.values.push(U.x,U.y,U.z),a.negate(L,L),a.add(D,L,U),C.position.values.push(U.x,U.y,U.z),C.position.values.push(U.x,U.y,U.z),C.position.values.push(I.x,I.y,I.z,M.x,M.y,M.z),n=3*R;3*R+6>n;++n)w.prevPosition.values.push(f[n]);for(w.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),C.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),n=3*S;3*S+6>n;++n)C.prevPosition.values.push(f[n]);for(n=3*R;3*R+6>n;++n)w.nextPosition.values.push(h[n]);for(w.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),C.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),n=3*S;3*S+6>n;++n)C.nextPosition.values.push(h[n]);var b=r.fromArray(d,2*R,be),F=Math.abs(b.y);w.expandAndWidth.values.push(-1,F,1,F),w.expandAndWidth.values.push(-1,-F,1,-F),C.expandAndWidth.values.push(-1,F,1,F),C.expandAndWidth.values.push(-1,-F,1,-F);var z=a.magnitudeSquared(a.subtract(D,N,qe));if(z/=a.magnitudeSquared(a.subtract(I,N,qe)),c(m)){var B=i.fromArray(m,4*R,He),G=i.fromArray(m,4*S,He),q=T.lerp(B.x,G.x,z),W=T.lerp(B.y,G.y,z),X=T.lerp(B.z,G.z,z),V=T.lerp(B.w,G.w,z);for(n=4*R;4*R+8>n;++n)w.color.values.push(m[n]);for(w.color.values.push(q,W,X,V),w.color.values.push(q,W,X,V),C.color.values.push(q,W,X,V),C.color.values.push(q,W,X,V),n=4*S;4*S+8>n;++n)C.color.values.push(m[n])}if(c(E)){var H=r.fromArray(E,2*R,be),Y=r.fromArray(E,2*(t+3),Fe),k=T.lerp(H.x,Y.x,z);for(n=2*R;2*R+4>n;++n)w.st.values.push(E[n]);for(w.st.values.push(k,H.y),w.st.values.push(k,Y.y),C.st.values.push(k,H.y),C.st.values.push(k,Y.y),n=2*S;2*S+4>n;++n)C.st.values.push(E[n])}o=w.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=C.position.values.length/3-4,P.push(o,o+2,o+1),P.push(o+1,o+2,o+3)}else{var K,J;for(N.y<0?(K=y.attributes,J=y.indices):(K=p.attributes,J=p.indices),K.position.values.push(N.x,N.y,N.z),K.position.values.push(O.x,O.y,O.z),K.position.values.push(I.x,I.y,I.z),K.position.values.push(M.x,M.y,M.z),n=3*t;3*t+12>n;++n)K.prevPosition.values.push(f[n]),K.nextPosition.values.push(h[n]);for(n=2*t;2*t+8>n;++n)K.expandAndWidth.values.push(d[n]),c(E)&&K.st.values.push(E[n]);if(c(m))for(n=4*t;4*t+16>n;++n)K.color.values.push(m[n]);o=K.position.values.length/3-4,J.push(o,o+2,o+1),J.push(o+1,o+2,o+3)}}Z(e,y,p)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case g.TRIANGLES:e.indices=I(t);break;case g.TRIANGLE_STRIP:e.indices=M(t);break;case g.TRIANGLE_FAN:e.indices=w(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=g.LINES}return e},te.createLineSegmentsForVectors=function(e,t,r){t=s(t,"normal"),r=s(r,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),f=0,h=0;o>h;h+=3)l[f++]=a[h],l[f++]=a[h+1],l[f++]=a[h+2],l[f++]=a[h]+i[h]*r,l[f++]=a[h+1]+i[h+1]*r,l[f++]=a[h+2]+i[h+2]*r;var m,p=e.boundingSphere;return c(p)&&(m=new n(p.center,p.radius+r)),new d({attributes:{position:new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:g.LINES,boundingSphere:m})},te.createAttributeLocations=function(e){var t,n=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],r=e.attributes,a={},i=0,o=n.length;for(t=0;o>t;++t){var u=n[t];c(r[u])&&(a[u]=i++)}for(var s in r)r.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},te.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),n=e.indices;if(c(n)){for(var r=new Int32Array(t),a=0;t>a;a++)r[a]=-1;for(var i,o=n,s=o.length,l=y.createTypedArray(t,s),f=0,h=0,E=0;s>f;)i=r[o[f]],-1!==i?l[h]=i:(i=o[f],r[i]=E,l[h]=E,++E),++f,++h;e.indices=l;var m=e.attributes;for(var p in m)if(m.hasOwnProperty(p)&&c(m[p])&&c(m[p].values)){for(var _=m[p],v=_.values,T=0,R=_.componentsPerAttribute,A=u.createTypedArray(_.componentDatatype,E*R);t>T;){var S=r[T];if(-1!==S)for(a=0;R>a;a++)A[R*S+a]=v[R*T+a];++T}_.values=A}}return e},te.reorderForPostVertexCache=function(e,t){var n=e.indices;if(e.primitiveType===g.TRIANGLES&&c(n)){for(var r=n.length,a=0,i=0;r>i;i++)n[i]>a&&(a=n[i]);e.indices=N.tipsify({indices:n,maximumIndex:a,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],n=d.computeNumberOfVertices(e);if(c(e.indices)&&n>=T.SIXTY_FOUR_KILOBYTES){var r,a=[],i=[],o=0,u=x(e.attributes),s=e.indices,l=s.length;e.primitiveType===g.TRIANGLES?r=3:e.primitiveType===g.LINES?r=2:e.primitiveType===g.POINTS&&(r=1);for(var f=0;l>f;f+=r){for(var h=0;r>h;++h){var E=s[f+h],m=a[E];c(m)||(m=o++,a[E]=m,C(u,e.attributes,E)),i.push(m)}o+r>=T.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=x(e.attributes))}0!==i.length&&t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var ne=new a,re=new o;te.projectTo2D=function(e,t,n,r,i){var o=e.attributes[t];i=c(i)?i:new h;for(var s=i.ellipsoid,f=o.values,d=new Float64Array(f.length),m=0,p=0;p<f.length;p+=3){var y=a.fromArray(f,p,ne),_=s.cartesianToCartographic(y,re);if(!c(_))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=i.project(_,ne);d[m++]=v.x,d[m++]=v.y,d[m++]=v.z}return e.attributes[n]=o,e.attributes[r]=new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var ae={high:0,low:0};te.encodeAttribute=function(e,t,n,r){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)f.encode(i[l],ae),s[l]=ae.high,c[l]=ae.low;var h=a.componentsPerAttribute;return e.attributes[n]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:s}),e.attributes[r]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:c}),delete e.attributes[t],e};var ie=new a,oe=new A,ue=new R;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(A.equals(t,A.IDENTITY))return e;var r=e.geometry.attributes;P(t,r.position),P(t,r.prevPosition),P(t,r.nextPosition),(c(r.normal)||c(r.binormal)||c(r.tangent))&&(A.inverse(t,oe),A.transpose(oe,oe),A.getRotation(oe,ue),D(ue,r.normal),D(ue,r.binormal),D(ue,r.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=n.transform(a,t,a)),e.modelMatrix=A.clone(A.IDENTITY),e};var se=new a;te.combineInstances=function(e){for(var t=[],n=[],r=e.length,a=0;r>a;++a){var i=e[a];c(i.geometry)?t.push(i):n.push(i)}var o=[];return t.length>0&&o.push(U(t,"geometry")),n.length>0&&(o.push(U(n,"westHemisphereGeometry")),o.push(U(n,"eastHemisphereGeometry"))),o};var ce=new a,le=new a,fe=new a,he=new a;te.computeNormal=function(e){for(var t=e.indices,n=e.attributes,r=n.position.values,i=n.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var h=0;for(f=0;o>f;f+=3){var d=t[f],m=t[f+1],p=t[f+2],y=3*d,_=3*m,v=3*p;le.x=r[y],le.y=r[y+1],le.z=r[y+2],fe.x=r[_],fe.y=r[_+1],fe.z=r[_+2],he.x=r[v],he.y=r[v+1],he.z=r[v+2],s[d].count++,s[m].count++,s[p].count++,a.subtract(fe,le,fe),a.subtract(he,le,he),c[h]=a.cross(fe,he,new a),h++}var T=0;for(f=0;i>f;f++)s[f].indexOffset+=T,T+=s[f].count;h=0;var R;for(f=0;o>f;f+=3){R=s[t[f]];var A=R.indexOffset+R.currentCount;l[A]=h,R.currentCount++,R=s[t[f+1]],A=R.indexOffset+R.currentCount,l[A]=h,R.currentCount++,R=s[t[f+2]],A=R.indexOffset+R.currentCount,l[A]=h,R.currentCount++,h++}var S=new Float32Array(3*i);for(f=0;i>f;f++){var g=3*f;if(R=s[f],R.count>0){for(a.clone(a.ZERO,ce),h=0;h<R.count;h++)a.add(ce,c[l[R.indexOffset+h]],ce);a.normalize(ce,ce),S[g]=ce.x,S[g+1]=ce.y,S[g+2]=ce.z}else S[g]=0,S[g+1]=0,S[g+2]=1}return e.attributes.normal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var de=new a,Ee=new a,me=new a;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),n=e.attributes.position.values,r=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,h,d;for(l=0;s>l;l+=3){var m=t[l],p=t[l+1],y=t[l+2];f=3*m,h=3*p,d=3*y;var _=2*m,v=2*p,T=2*y,R=n[f],A=n[f+1],S=n[f+2],g=i[_],N=i[_+1],O=i[v+1]-N,I=i[T+1]-N,M=1/((i[v]-g)*I-(i[T]-g)*O),w=(I*(n[h]-R)-O*(n[d]-R))*M,x=(I*(n[h+1]-A)-O*(n[d+1]-A))*M,C=(I*(n[h+2]-S)-O*(n[d+2]-S))*M;c[f]+=w,c[f+1]+=x,c[f+2]+=C,c[h]+=w,c[h+1]+=x,c[h+2]+=C,c[d]+=w,c[d+1]+=x,c[d+2]+=C}var P=new Float32Array(3*o),D=new Float32Array(3*o);for(l=0;o>l;l++){f=3*l,h=f+1,d=f+2;var L=a.fromArray(r,f,de),U=a.fromArray(c,f,me),b=a.dot(L,U);a.multiplyByScalar(L,b,Ee),a.normalize(a.subtract(U,Ee,U),U),D[f]=U.x,D[h]=U.y,D[d]=U.z,a.normalize(a.cross(L,U,U),U),P[f]=U.x,P[h]=U.y,P[d]=U.z}return e.attributes.tangent=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.binormal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e};var pe=new r,ye=new a,_e=new a,ve=new a;te.compressVertices=function(t){var n=t.attributes.normal,i=t.attributes.st;if(!c(n)&&!c(i))return t;var o,s,l,f,h=t.attributes.tangent,d=t.attributes.binormal;c(n)&&(o=n.values),c(i)&&(s=i.values),c(h)&&(l=h.values),d&&(f=d.values);var m=c(o)?o.length:s.length,p=c(o)?3:2,y=m/p,_=y,v=c(s)&&c(o)?2:1;v+=c(l)||c(f)?1:0,_*=v;for(var T=new Float32Array(_),R=0,A=0;y>A;++A){c(s)&&(r.fromArray(s,2*A,pe),T[R++]=e.compressTextureCoordinates(pe));var S=3*A;c(o)&&c(l)&&c(f)?(a.fromArray(o,S,ye),a.fromArray(l,S,_e),a.fromArray(f,S,ve),e.octPack(ye,_e,ve,pe),T[R++]=pe.x,T[R++]=pe.y):(c(o)&&(a.fromArray(o,S,ye),T[R++]=e.octEncodeFloat(ye)),c(l)&&(a.fromArray(l,S,ye),T[R++]=e.octEncodeFloat(ye)),c(f)&&(a.fromArray(f,S,ye),T[R++]=e.octEncodeFloat(ye)))}return t.attributes.compressedAttributes=new E({componentDatatype:u.FLOAT,componentsPerAttribute:v,values:T}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var Te=new a,Re=new a,Ae=new a,Se=new a,ge=new a,Ne={positions:new Array(7),indices:new Array(9)},Oe=new a,Ie=new a,Me=new a,we=new a,xe=new r,Ce=new r,Pe=new r,De=S.fromPointNormal(a.ZERO,a.UNIT_Y),Le=new a,Ue=new a,be=new r,Fe=new r,ze=new a,Be=new a,Ge=new a,qe=new a,We=new a,Xe=new a,Ve=new a,He=new i;return te.splitLongitude=function(e){var t=e.geometry,r=t.boundingSphere;if(c(r)){var a=r.center.x-r.radius;if(a>0||n.intersectPlane(r,S.ORIGIN_ZX_PLANE)!==_.INTERSECTING)return e}if(t.geometryType!==p.NONE)switch(t.geometryType){case p.POLYLINES:ee(e);break;case p.TRIANGLES:Q(e);break;case p.LINES:$(e)}else W(t),t.primitiveType===g.TRIANGLES?Q(e):t.primitiveType===g.LINES&&$(e);return e},te}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r,a){"use strict";function i(e,n,r,a){this[0]=t(e,0),this[1]=t(r,0),this[2]=t(n,0),this[3]=t(a,0)}i.packedLength=4,i.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3]},i.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new i),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a},i.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new i(e[0],e[2],e[1],e[3]):void 0},i.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new i),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a},i.fromColumnMajorArray=function(e,t){return i.clone(e,t)},i.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new i(e[0],e[1],e[2],e[3])},i.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new i(e.x,0,0,e.y)},i.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new i(e,0,0,e)},i.fromRotation=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t):new i(r,-a,a,r)},i.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},i.getElementIndex=function(e,t){return 2*e+t},i.getColumn=function(e,t,n){var r=2*t,a=e[r],i=e[r+1];return n.x=a,n.y=i,n},i.setColumn=function(e,t,n,r){r=i.clone(e,r);var a=2*t;return r[a]=n.x,r[a+1]=n.y,r},i.getRow=function(e,t,n){var r=e[t],a=e[t+2];return n.x=r,n.y=a,n},i.setRow=function(e,t,n,r){return r=i.clone(e,r),r[t]=n.x,r[t+2]=n.y,r};var o=new e;i.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],o)),n.y=e.magnitude(e.fromElements(t[2],t[3],o)),n};var u=new e;return i.getMaximumScale=function(t){return i.getScale(t,u),e.maximumComponent(u)},i.multiply=function(e,t,n){var r=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],i=e[1]*t[0]+e[3]*t[1],o=e[1]*t[2]+e[3]*t[3];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n},i.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n},i.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n},i.multiplyByVector=function(e,t,n){var r=e[0]*t.x+e[2]*t.y,a=e[1]*t.x+e[3]*t.y;return n.x=r,n.y=a,n},i.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n},i.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.y,n[3]=e[3]*t.y,n},i.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},i.transpose=function(e,t){var n=e[0],r=e[2],a=e[1],i=e[3];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t},i.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},i.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},i.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]},i.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r},i.IDENTITY=a(new i(1,0,0,1)),i.ZERO=a(new i(0,0,0,0)),i.COLUMN0ROW0=0,i.COLUMN0ROW1=1,i.COLUMN1ROW0=2,i.COLUMN1ROW1=3,i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},i}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,a){"use strict";function i(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var d=t[h],E=d.x,m=d.y,p=d.z;a=Math.min(E,a),s=Math.max(E,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(p,u),l=Math.max(p,l)}var y=r.minimum;y.x=a,y.y=o,y.z=u;var _=r.maximum;_.x=s,_.y=c,_.z=l;var v=e.add(y,_,r.center);return e.multiplyByScalar(v,.5,v),r},i.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum):void 0},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return i.intersectPlane=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),i=n.normal,u=r.x*Math.abs(i.x)+r.y*Math.abs(i.y)+r.z*Math.abs(i.z),s=e.dot(t.center,i)+n.distance;return s-u>0?a.INSIDE:0>s+u?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return i(r)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(a){return i(a)}});return n}function o(){function e(e,t,n){return h(e,t,n)}function n(e){return E(e)}function a(e){return E(i(e))}function u(e){return d(e)}var s,c,l,f,h,d,E;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],f=[],h=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),f.push(a),r.promise},d=function(e){return m(f,e),e},E=function(e){return e=t(e),h=e.then,E=t,d=y,m(l,e),f=l=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return p(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){E(e)}var c,l,f,h,d,E,m,p,_,v;if(_=t.length>>>0,c=Math.max(0,Math.min(n,_)),f=[],l=_-c+1,h=[],d=o(),c)for(p=d.progress,m=function(e){h.push(e),--l||(E=m=y,d.reject(h))},E=function(e){f.push(e),--c||(E=m=y,d.resolve(f))},v=0;_>v;++v)v in t&&e(t[v],s,u,p);else d.resolve(f);return d.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return p(1,arguments),h(e,_).then(t,n,r)}function f(){return h(arguments,_)}function h(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function d(t,n){var r=T.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},v.apply(t,r)})}function E(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function m(e,t){for(var n,r=0;n=e[r++];)n(t)}function p(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function y(){}function _(e){return e}var v,T,R;return e.defer=o,e.resolve=t,e.reject=n,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=E,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(R,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(R,t)})})}},T=[].slice,v=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;a>i;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e,t,n){for(var r,a,i=0,o=e.length-1;o>=i;)if(r=~~((i+o)/2),a=n(e[r],t),0>a)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)}return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,f,h){var d,E,m,p,y;if("%%"==e)return"%";for(var _=!1,v="",T=!1,R=!1,A=" ",S=s.length,g=0;s&&S>g;g++)switch(s.charAt(g)){case" ":v=" ";break;case"+":v="+";break;case"-":_=!0;break;case"'":A=s.charAt(g+1);break;case"0":T=!0;break;case"#":R=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[n++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,y=r?t[r.slice(0,-1)]:t[n++],h){case"s":return u(String(y),_,c,f,T,A);case"c":return u(String.fromCharCode(+y),_,c,f,T);case"b":return o(y,2,R,_,c,f,T);case"o":return o(y,8,R,_,c,f,T);case"x":return o(y,16,R,_,c,f,T);case"X":return o(y,16,R,_,c,f,T).toUpperCase();case"u":return o(y,10,R,_,c,f,T);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),E=0>d?"-":v,y=E+a(String(Math.abs(d)),f,"0",!1),i(y,E,_,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,E=0>d?"-":v,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],y=E+Math.abs(d)[m](f),i(y,E,_,c,T)[p]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){
"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return m.compare(e.julianDate,t.julianDate)}function f(e){v.julianDate=e;var n=m.leapSeconds,r=t(n,v,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=m.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}m.addSeconds(e,a,e)}function h(e,n){v.julianDate=e;var r=m.leapSeconds,a=t(r,v,l);if(0>a&&(a=~a),0===a)return m.addSeconds(e,-r[0].offset,n);if(a>=r.length)return m.addSeconds(e,-r[a-1].offset,n);var i=m.secondsDifference(r[a].julianDate,e);return 0===i?m.addSeconds(e,-r[a].offset,n):1>=i?void 0:m.addSeconds(e,-r[--a].offset,n)}function d(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function E(e,t,n,r,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,0>r&&(r+=24);var f=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function m(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,d(a,t,this),r===c.UTC&&f(this)}var p=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],_=29,v=new u,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,A=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,N=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+N.source,I=/^(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,M=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,w="Invalid ISO 8601 date.";m.fromDate=function(e,t){var n=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(d(n[0],n[1],t),f(t),t):new m(n[0],n[1],c.UTC)},m.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,u,s=e.split("T"),l=1,h=1,p=0,v=0,N=0,x=0,C=s[0],P=s[1];if(!r(C))throw new a(w);var D;if(s=C.match(g),null!==s){if(D=C.split("-").length-1,D>0&&2!==D)throw new a(w);n=+s[1],l=+s[2],h=+s[3]}else if(s=C.match(R),null!==s)n=+s[1],l=+s[2];else if(s=C.match(T),null!==s)n=+s[1];else{var L;if(s=C.match(A),null!==s){if(n=+s[1],L=+s[2],u=o(n),1>L||u&&L>366||!u&&L>365)throw new a(w)}else{if(s=C.match(S),null===s)throw new a(w);n=+s[1];var U=+s[2],b=+s[3]||0;if(D=C.split("-").length-1,D>0&&(!r(s[3])&&1!==D||r(s[3])&&2!==D))throw new a(w);var F=new Date(Date.UTC(n,0,4));L=7*U+b-F.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(L),l=i.getUTCMonth()+1,h=i.getUTCDate()}if(u=o(n),1>l||l>12||1>h||(2!==l||!u)&&h>y[l-1]||u&&2===l&&h>_)throw new a(w);var z;if(r(P)){if(s=P.match(M),null!==s){if(D=P.split(":").length-1,D>0&&2!==D&&3!==D)throw new a(w);p=+s[1],v=+s[2],N=+s[3],x=1e3*+(s[4]||0),z=5}else if(s=P.match(I),null!==s){if(D=P.split(":").length-1,D>2)throw new a(w);p=+s[1],v=+s[2],N=60*+(s[3]||0),z=4}else{if(s=P.match(O),null===s)throw new a(w);p=+s[1],v=60*+(s[2]||0),z=3}if(v>=60||N>=61||p>24||24===p&&(v>0||N>0||x>0))throw new a(w);var B=s[z],G=+s[z+1],q=+(s[z+2]||0);switch(B){case"+":p-=G,v-=q;break;case"-":p+=G,v+=q;break;case"Z":break;default:v+=new Date(Date.UTC(n,l-1,h,p,v)).getTimezoneOffset()}}else v+=new Date(n,l-1,h).getTimezoneOffset();var W=60===N;for(W&&N--;v>=60;)v-=60,p++;for(;p>=24;)p-=24,h++;for(i=u&&2===l?_:y[l-1];h>i;)h-=i,l++,l>12&&(l-=12,n++),i=u&&2===l?_:y[l-1];for(;0>v;)v+=60,p--;for(;0>p;)p+=24,h--;for(;1>h;)l--,1>l&&(l+=12,n--),i=u&&2===l?_:y[l-1],h+=i;var X=E(n,l,h,p,v,N,x);return r(t)?(d(X[0],X[1],t),f(t)):t=new m(X[0],X[1],c.UTC),W&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var x=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){var n=!1,a=h(e,x);r(a)||(m.addSeconds(e,-1,x),a=h(x,x),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var d=80*c/2447|0,E=c-(2447*d/80|0)|0;c=d/11|0;var p=d+2-12*c|0,y=100*(l-49)+f+c|0,_=u/s.SECONDS_PER_HOUR|0,v=u-_*s.SECONDS_PER_HOUR,T=v/s.SECONDS_PER_MINUTE|0;v-=T*s.SECONDS_PER_MINUTE;var R=0|v,A=(v-R)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),n&&(R+=1),r(t)?(t.year=y,t.month=p,t.day=E,t.hour=_,t.minute=T,t.second=R,t.millisecond=A,t.isLeapSecond=n,t):new i(y,p,E,_,T,R,A,n)},m.toDate=function(e){var t=m.toGregorianDate(e,p),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},m.toIso8601=function(t,n){var a,i=m.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},m.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI):void 0},m.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(m.secondsDifference(e,t))<=n},m.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},m.computeTaiMinusUtc=function(e){v.julianDate=e;var n=m.leapSeconds,r=t(n,v,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},m.addSeconds=function(e,t,n){return d(e.dayNumber,e.secondsOfDay+t,n)},m.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,r,n)},m.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,r,n)},m.addDays=function(e,t,n){var r=e.dayNumber+t;return d(r,e.secondsOfDay,n)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36)],m}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function n(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,a,i){"use strict";function o(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,u=n.headers,s=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return o.load(t,r,a,i,u,n,s),n.promise})}function u(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function s(e,t){for(var n=u(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function c(e,n){n=t(n,"");var a=e[1],i=!!e[2],o=e[3];switch(n){case"":case"text":return u(i,o);case"arraybuffer":return s(i,o);case"blob":var c=s(i,o);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(u(i,o),a);case"json":return JSON.parse(u(i,o));default:throw new r("Unhandled responseType: "+n)}}var l=/^data:(.*?)(;base64)?,(.*)$/;return o.load=function(e,t,r,o,u,s,f){var h=l.exec(e);if(null!==h)return void s.resolve(c(h,t));var d=new XMLHttpRequest;if(n(f)&&n(d.overrideMimeType)&&d.overrideMimeType(f),d.open(r,e,!0),n(u))for(var E in u)u.hasOwnProperty(E)&&d.setRequestHeader(E,u[E]);n(t)&&(d.responseType=t),d.onload=function(){d.status>=200&&d.status<300?n(d.response)?s.resolve(d.response):n(d.responseXML)&&d.responseXML.hasChildNodes()?s.resolve(d.responseXML):n(d.responseText)?s.resolve(d.responseText):s.reject(new i("unknown XMLHttpRequest response type.")):s.reject(new a(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){s.reject(new a)},d.send(o)},o.defaultLoad=o.load,o}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,n){return e({url:t,headers:n})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";function a(n,a){return t(a)?t(a.Accept)||(a=e(a),a.Accept=i.Accept):a=i,r(n,a).then(function(e){return JSON.parse(e)})}var i={Accept:"application/json,*/*;q=0.01"};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function h(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))E(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){E(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else E(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function E(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),h=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>h||0>E||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=n.samples,y=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=m,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var _,v=e._addNewLeapSeconds,T=0,R=p.length;R>T;T+=e._columnCount){var A=p[T+a],S=p[T+m],g=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new o(g,S,f.TAI);if(y.push(N),v){if(S!==_&&r(_)){var O=o.leapSeconds,I=t(O,N,d);if(0>I){var M=new u(N,S);O.splice(~I,0,M)}}_=S}}}function m(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function p(e,t,n){return t+e*(n-t)}function y(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return m(e,n,a,s,u),u;if(r.equals(l))return m(e,n,i,s,u),u;var f=o.secondsDifference(r,c)/o.secondsDifference(l,c),h=a*s,d=i*s,E=n[h+e._ut1MinusUtcSecondsColumn],y=n[d+e._ut1MinusUtcSecondsColumn],_=y-E;if(_>.5||-.5>_){var v=n[h+e._taiMinusUtcSecondsColumn],T=n[d+e._taiMinusUtcSecondsColumn];v!==T&&(l.equals(r)?E=y:y-=T-v)}return u.xPoleWander=p(f,n[h+e._xPoleWanderRadiansColumn],n[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=p(f,n[h+e._yPoleWanderRadiansColumn],n[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=p(f,n[h+e._xCelestialPoleOffsetRadiansColumn],n[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=p(f,n[h+e._yCelestialPoleOffsetRadiansColumn],n[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=p(f,E,y),u}return h.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,n){if(r(this._samples)){if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var f=i[u],h=i[u+1],d=o.lessThanOrEquals(f,e),E=!r(h),m=E||o.greaterThanOrEquals(h,e);if(d&&m)return s=u,!E&&h.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,n),n}var p=t(i,e,o.compare,this._dateColumn);return p>=0?(p<i.length-1&&i[p+1].equals(e)&&++p,s=p,l=p):(l=~p,s=l-1,0>s&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,n),n}if(r(this._dataError))throw new c(this._dataError)},h}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),a=h.exec(r);if(null!==a)return a[1]}}function i(){if(t(c))return c;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return c=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}function s(e){t(l)||(l=t(r.toUrl)?o:u),t(f)||(f=document.createElement("a"));var n=l(e);return f.href=n,f.href=f.href,f.href}var c,l,f,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return s._cesiumScriptRegex=h,s.setBaseUrl=function(t){c=new e(t).resolve(new e(document.location.href))},s}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,n){this.x=e,this.y=t,this.s=n}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,n){var r=f;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function l(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=a*n._samplesPerXysFile*3,u=0,s=r.length;s>u;++u)t[o+u]=r[u];i.resolve()}),i.promise}var f=new i(0,0,u.TAI);return s.prototype.preload=function(t,n,r,a){var i=c(this,t,n),o=c(this,r,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,d=[],E=f;h>=E;++E)d.push(l(this,E));return e.all(d)},s.prototype.computeXysRadians=function(e,t,n){var i=c(this,e,t);if(!(0>i)){var o=i/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,0>s&&(s=0));var h=!1,d=this._samples;if(r(d[3*s])||(l(this,s/this._samplesPerXysFile|0),h=!0),r(d[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),!h){r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var E,m,p=i-s*this._stepSizeDays,y=this._work,_=this._denominators,v=this._coef,T=this._xTable;for(E=0;u>=E;++E)y[E]=p-T[E];for(E=0;u>=E;++E){for(v[E]=1,m=0;u>=m;++m)m!==E&&(v[E]*=y[m]);v[E]*=_[E];var R=3*(s+E);n.x+=v[E]*d[R++],n.y+=v[E]*d[R++],n.s+=v[E]*d[R]}return n}}}},s}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)}var c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,h=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=f,a.w=h,a):new s(u,l,f,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],m=h+d+E;if(m>0)r=Math.sqrt(m+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var p=l,y=0;d>h&&(y=1),E>h&&E>d&&(y=2);var _=p[y],v=p[_];r=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(v,v)]+1);var T=f;T[y]=.5*r,r=.5/r,c=(e[u.getElementIndex(v,_)]-e[u.getElementIndex(_,v)])*r,T[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*r,T[v]=(e[u.getElementIndex(v,y)]+e[u.getElementIndex(y,v)])*r,a=-T[0],i=-T[1],o=-T[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var h=new s;s.fromHeadingPitchRoll=function(t,n,r,a){var i=s.fromAxisAngle(e.UNIT_X,r,h),o=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,h);return s.multiply(u,a,a)};var d=new e,E=new e,m=new s,p=new s,y=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.x=e[r],a.y=e[r+1],a.z=e[r+2],a.w=e[r+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,y),s.conjugate(y,y);for(var a=0,i=n-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),m),s.multiply(m,y,m),m.w<0&&s.negate(m,m),s.computeAxis(m,d);var u=s.computeAngle(m);r[o]=d.x*u,r[o+1]=d.y*u,r[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*i,p),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(E,u,m),s.multiply(m,p,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+r*l+a*c-i*s,h=o*s-r*c+a*l+i*u,d=o*c+r*s-a*u+i*l,E=o*l-r*u-a*s-i*c;return n.x=f,n.y=h,n.z=d,n.w=E,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,t,n,r){return _=s.multiplyByScalar(t,n,_),r=s.multiplyByScalar(e,1-n,r),s.add(_,r,r)};var v=new s,T=new s,R=new s;s.slerp=function(e,t,n,r){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=v=s.negate(t,v)),1-a<o.EPSILON6)return s.lerp(e,i,n,r);var u=Math.acos(a);return T=s.multiplyByScalar(e,Math.sin((1-n)*u),T),R=s.multiplyByScalar(i,Math.sin(n*u),R),r=s.add(T,R,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},s.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var A=new e,S=new e,g=new s,N=new s;s.computeInnerQuadrangle=function(t,n,r,a){var i=s.conjugate(n,g);s.multiply(i,r,N);var o=s.log(N,A);s.multiply(i,t,N);var u=s.log(N,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,g),s.multiply(n,g,a)},s.squad=function(e,t,n,r,a,i){var o=s.slerp(e,t,a,g),u=s.slerp(n,r,a,N);return s.slerp(o,u,2*a*(1-a),i)};for(var O=new s,I=1.9011074535173003,M=a.supportsTypedArrays()?new Float32Array(8):[],w=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var D=P+1,L=2*D+1;M[P]=1/(D*L),w[P]=D/L}return M[7]=I/136,w[7]=8*I/17,s.fastSlerp=function(e,t,n,r){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,l=u*u,f=7;f>=0;--f)x[f]=(M[f]*c-w[f])*o,C[f]=(M[f]*l-w[f])*o;var h=a*n*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),d=u*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),E=s.multiplyByScalar(e,d,O);return s.multiplyByScalar(t,h,r),s.add(E,r,r)},s.fastSquad=function(e,t,n,r,a,i){var o=s.fastSlerp(e,t,a,g),u=s.fastSlerp(n,r,a,N);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,m,p,y){"use strict";var _={},v=new n,T=new n,R=new n;_.eastNorthUpToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var A=new n,S=new n,g=new n;_.northEastDownToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=A,s=S,l=g;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,t,r){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new m(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var N=new p,O=new n(1,1,1),I=new m;_.headingPitchRollToFixedFrame=function(e,t,r,a,i,o){var u=p.fromHeadingPitchRoll(t,r,a,N),s=m.fromTranslationQuaternionRotationScale(n.ZERO,u,O,I);return o=_.eastNorthUpToFixedFrame(e,i,o),m.multiply(o,s,o)};var M=new m,w=new E;_.headingPitchRollQuaternion=function(e,t,n,r,a,i){var o=_.headingPitchRollToFixedFrame(e,t,n,r,a,M),u=m.getRotation(o,w);return p.fromRotationMatrix(u,i)};var x=24110.54841,C=8640184.812866,P=.093104,D=-62e-7,L=1.1772758384668e-19,U=72921158553e-15,b=d.TWO_PI/86400,F=new h;_.computeTemeToPseudoFixedMatrix=function(e,t){F=h.addSeconds(e,-h.computeTaiMinusUtc(e),F);var n,r=F.dayNumber,a=F.secondsOfDay,o=r-2451545;n=a>=43200?(o+.5)/y.DAYS_PER_JULIAN_CENTURY:(o-.5)/y.DAYS_PER_JULIAN_CENTURY;var u=x+n*(C+n*(P+n*D)),s=u*b%d.TWO_PI,c=U+L*(r-2451545.5),l=(a+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,f=s+c*l,m=Math.cos(f),p=Math.sin(f);return i(t)?(t[0]=m,t[1]=-p,t[2]=0,t[3]=p,t[4]=m,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(m,p,0,-p,m,0,0,0,1)},_.iau2006XysData=new l,_.earthOrientationParameters=u.NONE;var z=32.184,B=2451545;_.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+z,a=t.stop.dayNumber,i=t.stop.secondsOfDay+z,o=_.iau2006XysData.preload(n,r,a,i),u=_.earthOrientationParameters.getPromiseToLoad();
return e.all([o,u])},_.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new E);var n=_.computeFixedToIcrfMatrix(e,t);if(i(n))return E.transpose(n,t)};var G=new f(0,0,0),q=new s(0,0,0,0,0,0),W=new E,X=new E;_.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new E);var n=_.earthOrientationParameters.compute(e,q);if(i(n)){var r=e.dayNumber,a=e.secondsOfDay+z,o=_.iau2006XysData.computeXysRadians(r,a,G);if(i(o)){var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=E.fromRotationZ(-o.s,X),m=E.multiply(l,f,W),p=e.dayNumber,v=e.secondsOfDay-h.computeTaiMinusUtc(e)+n.ut1MinusUtc,T=p-2451545,R=v/y.SECONDS_PER_DAY,A=.779057273264+R+.00273781191135448*(T+R);A=A%1*d.TWO_PI;var S=E.fromRotationZ(A,X),g=E.multiply(m,S,W),N=Math.cos(n.xPoleWander),O=Math.cos(n.yPoleWander),I=Math.sin(n.xPoleWander),M=Math.sin(n.yPoleWander),w=r-B+a/y.SECONDS_PER_DAY;w/=36525;var x=-47e-6*w*d.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),D=X;return D[0]=N*C,D[1]=N*P,D[2]=I,D[3]=-O*P+M*I*C,D[4]=O*C+M*I*P,D[5]=-M*N,D[6]=-M*P-O*I*C,D[7]=M*C-O*I*P,D[8]=O*N,E.multiply(g,D,t)}}};var V=new r;_.pointToWindowCoordinates=function(e,t,n,r){return r=_.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},_.pointToGLWindowCoordinates=function(e,n,a,o){i(o)||(o=new t);var u=V;return m.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var H=new n,Y=new n,k=new n;return _.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=a(r,c.WGS84).geodeticSurfaceNormal(e,H),s=n.cross(t,u,Y);n.equalsEpsilon(s,n.ZERO,d.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,k);return n.cross(t,l,s),n.negate(s,s),i(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},_}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E){"use strict";function m(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=E.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(f.getColumn(r,0,p)),this._yAxis=n.fromCartesian4(f.getColumn(r,1,p));var i=n.fromCartesian4(f.getColumn(r,2,p));this._plane=h.fromPointNormal(e,i)}var p=new r;o(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var y=new e;m.fromPoints=function(t,n){var r=e.fromPoints(t,y);return new m(r.center,n)};var _=new d,v=new n;m.prototype.projectPointOntoPlane=function(e,r){var a=_;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,v);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}},m.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;r>a;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t},m.prototype.projectPointToNearestOnPlane=function(e,r){i(r)||(r=new t);var a=_;a.origin=e,n.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,v);i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},m.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;n>r;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var T=new n;return m.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=T,l=0;r>l;++l){var f=e[l];n.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new n);var h=n.add(o,c,t[l]);n.multiplyByScalar(s,f.y,c),n.add(h,c,h),a.scaleToGeocentricSurface(h,h)}return t},m}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";function n(t,n,a,i){return e(t,n,a,i,r),r.x>0&&r.y>0&&r.z>0}var r=new t;return n}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){var t=e._uSquared,n=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,a=(n-r)/n,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,h=f*f,d=1-h,E=Math.sqrt(d),m=t/4,p=m*m,y=p*m,_=p*p,v=1+m-3*p/4+5*y/4-175*_/64,T=1-m+15*p/8-35*y/8,R=1-3*m+35*p/4,A=1-5*m,S=v*l-T*Math.sin(2*l)*m/2-R*Math.sin(4*l)*p/16-A*Math.sin(6*l)*y/48-5*Math.sin(8*l)*_/512,g=e._constants;g.a=n,g.b=r,g.f=a,g.cosineHeading=i,g.sineHeading=o,g.tanU=u,g.cosineU=s,g.sineU=c,g.sigma=l,g.sineAlpha=f,g.sineSquaredAlpha=h,g.cosineSquaredAlpha=d,g.cosineAlpha=E,g.u2Over4=m,g.u4Over16=p,g.u6Over64=y,g.u8Over256=_,g.a0=v,g.a1=T,g.a2=R,g.a3=A,g.distanceRatio=S}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,n,r,a,i,o){var u=c(e,n);return(1-u)*e*t*(r+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,n,r,a,i,o){var s,c,f,h,d,E=(t-n)/t,m=i-r,p=Math.atan((1-E)*Math.tan(a)),y=Math.atan((1-E)*Math.tan(o)),_=Math.cos(p),v=Math.sin(p),T=Math.cos(y),R=Math.sin(y),A=_*T,S=_*R,g=v*R,N=v*T,O=m,I=u.TWO_PI,M=Math.cos(O),w=Math.sin(O);do{M=Math.cos(O),w=Math.sin(O);var x=S-N*M;f=Math.sqrt(T*T*w*w+x*x),c=g+A*M,s=Math.atan2(f,c);var C;0===f?(C=0,h=1):(C=A*w/f,h=1-C*C),I=O,d=c-2*g/h,isNaN(d)&&(d=0),O=m+l(E,C,h,s,f,c,d)}while(Math.abs(O-I)>u.EPSILON12);var P=h*(t*t-n*n)/(n*n),D=1+P*(4096+P*(P*(320-175*P)-768))/16384,L=P*(256+P*(P*(74-47*P)-128))/1024,U=d*d,b=L*f*(d+L*(c*(2*U-1)-L*d*(4*f*f-3)*(4*U-3)/6)/4),F=n*D*(s-b),z=Math.atan2(T*w,S-N*M),B=Math.atan2(_*w,S*M-N);e._distance=F,e._startHeading=z,e._endHeading=B,e._uSquared=P}function h(n,r,a,i){e.normalize(i.cartographicToCartesian(r,m),E),e.normalize(i.cartographicToCartesian(a,m),m);f(n,i.maximumRadius,i.minimumRadius,r.longitude,r.latitude,a.longitude,a.latitude),n._start=t.clone(r,n._start),n._end=t.clone(a,n._end),n._start.height=0,n._end.height=0,s(n)}function d(e,a,i){var u=n(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(a)&&h(this,e,a,u)}var E=new e,m=new e;return a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),d.prototype.setEndPoints=function(e,t){h(this,e,t,this._ellipsoid)},d.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},d.prototype.interpolateUsingSurfaceDistance=function(e,n){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),h=Math.sin(6*i),d=Math.sin(8*i),E=i*i,m=i*E,p=a.u8Over256,y=a.u2Over4,_=a.u6Over64,v=a.u4Over16,T=2*m*p*o/3+i*(1-y+7*v/4-15*_/4+579*p/64-(v-15*_/4+187*p/16)*o-(5*_/4-115*p/16)*u-29*p*s/16)+(y/2-v+71*_/32-85*p/16)*c+(5*v/16-5*_/4+383*p/96)*f-E*((_-11*p/2)*c+5*p*f/2)+(29*_/96-29*p/16)*h+539*p*d/1536,R=Math.asin(Math.sin(T)*a.cosineAlpha),A=Math.atan(a.a/a.b*Math.tan(R));T-=a.sigma;var S=Math.cos(2*a.sigma+T),g=Math.sin(T),N=Math.cos(T),O=a.cosineU*N,I=a.sineU*g,M=Math.atan2(g*a.sineHeading,O-I*a.cosineHeading),w=M-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,T,g,N,S);return r(n)?(n.longitude=this._start.longitude+w,n.latitude=A,n.height=0,n):new t(this._start.longitude+w,A,0)},d}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,n,r,a,i,o,u,s,c,l,f){"use strict";function h(e,t,n){var r=g;r.length=e;var a;if(t===n){for(a=0;e>a;a++)r[a]=t;return r}var i=n-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;r[a]=u}return r}function d(t,n,r,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,M),l=a.scaleToGeodeticSurface(n,w),f=E.numberOfPoints(t,n,r),d=a.cartesianToCartographic(c,N),m=a.cartesianToCartographic(l,O),p=h(f,i,o);x.setEndPoints(d,m);var y=x.surfaceDistance/f,_=s;d.height=i;var v=a.cartographicToCartesian(d,I);e.pack(v,u,_),_+=3;for(var T=1;f>T;T++){var R=x.interpolateUsingSurfaceDistance(T*y,O);R.height=p[T],v=a.cartographicToCartesian(R,I),e.pack(v,u,_),_+=3}return _}var E={};E.numberOfPoints=function(t,n,r){var a=e.distance(t,n);return Math.ceil(a/r)};var m=new t;E.extractHeights=function(e,t){for(var n=e.length,r=new Array(n),a=0;n>a;a++){var i=e[a];r[a]=t.cartesianToCartographic(i,m).height}return r};var p=new l,y=new e,_=new e,v=new f(e.ZERO,0),T=new e,R=new f(e.ZERO,0),A=new e,S=new e,g=[],N=new t,O=new t,I=new e,M=new e,w=new e,x=new o;E.wrapLongitude=function(t,a){var i=[],o=[];if(r(t)&&t.length>0){a=n(a,l.IDENTITY);var s=l.inverseTransformation(a,p),c=l.multiplyByPoint(s,e.ZERO,y),h=l.multiplyByPointAsVector(s,e.UNIT_Y,_),d=f.fromPointNormal(c,h,v),E=l.multiplyByPointAsVector(s,e.UNIT_X,T),m=f.fromPointNormal(c,E,R),g=1;i.push(e.clone(t[0]));for(var N=i[0],O=t.length,I=1;O>I;++I){var M=t[I];if(f.getPointDistance(m,N)<0||f.getPointDistance(m,M)<0){var w=u.lineSegmentPlane(N,M,d,A);if(r(w)){var x=e.multiplyByScalar(h,5e-9,S);f.getPointDistance(d,N)<0&&e.negate(x,x),i.push(e.add(w,x,new e)),o.push(g+1),e.negate(x,x),i.push(e.add(w,x,new e)),g=1}}i.push(e.clone(t[I])),g++,N=M}o.push(g)}return{positions:i,lengths:o}};var C=c.EPSILON10;return E.removeDuplicates=function(t){var n=t.length;if(2>n)return t;var r,a,i;for(r=1;n>r&&(a=t[r-1],i=t[r],!e.equalsEpsilon(a,i,C));++r);if(r===n)return t;for(var o=t.slice(0,r);n>r;++r)i=t[r],e.equalsEpsilon(a,i,C)||(o.push(e.clone(i)),a=i);return o},E.generateArc=function(t){r(t)||(t={});var a=t.positions,o=a.length,u=n(t.ellipsoid,i.WGS84),l=n(t.height,0);if(1>o)return[];if(1===o){var f=u.scaleToGeodeticSurface(a[0],M);if(0!==l){var h=u.geodeticSurfaceNormal(f,I);e.multiplyByScalar(h,l,h),e.add(f,h,f)}return[f.x,f.y,f.z]}var m=t.minDistance;if(!r(m)){var p=n(t.granularity,c.RADIANS_PER_DEGREE);m=c.chordLength(p,u.maximumRadius)}var y,_=0;for(y=0;o-1>y;y++)_+=E.numberOfPoints(a[y],a[y+1],m);var v=3*(_+1),T=new Array(v),R=0,A=s(l);for(y=0;o-1>y;y++){var S=a[y],O=a[y+1],w=A?l[y]:l,x=A?l[y+1]:l;R=d(S,O,m,u,w,x,T,R)}g.length=0;var C=a[o-1],P=u.cartesianToCartographic(C,N);P.height=A?l[o-1]:l;var D=u.cartographicToCartesian(P,I);return e.pack(D,T,v-3),T},E.generateCartesianArc=function(t){for(var n=E.generateArc(t),r=n.length/3,a=new Array(r),i=0;r>i;i++)a[i]=e.unpack(n,3*i);return a},E}),define("Core/Queue",["../Core/defineProperties"],function(e){"use strict";function t(){this._array=[],this._offset=0,this._length=0}return e(t.prototype,{length:{get:function(){return this._length}}}),t.prototype.enqueue=function(e){this._array.push(e),this._length++},t.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,n=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,n}},t.prototype.peek=function(){return 0!==this._length?this._array[this._offset]:void 0},t.prototype.contains=function(e){return-1!==this._array.indexOf(e)},t.prototype.clear=function(){this._array.length=this._offset=this._length=0},t.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},t}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===n.CLOCKWISE||e===n.COUNTER_CLOCKWISE}};return t(n)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,m){"use strict";function p(t,n,r){var a=e.subtract(n,t,b),i=e.subtract(r,n,F);return a.x*i.y-a.y*i.x>=0}function y(e){for(var t=e[0].x,n=0,r=0;r<e.length;r++)e[r].x>t&&(t=e[r].x,n=r);return n}function _(e){for(var t=e[0][0].x,n=0,r=0;r<e.length;r++){var a=e[r][y(e[r])].x;a>t&&(t=a,n=r)}return n}function v(e){for(var t=[],n=0;n<e.length;n++){var r=e[(n-1+e.length)%e.length],a=e[n],i=e[(n+1)%e.length];p(r,a,i)||t.push(a)}return t}function T(t,n){for(var r=0;r<t.length;r++)if(e.equals(n,t[r]))return r;return-1}function R(n,a,i){i=r(i,[]);var o=Number.MAX_VALUE,u=y(a),s=new e(a[u].x,n.y);i.push(u),i.push((u+1)%a.length);for(var c=a[0].x,l=c,f=1;f<a.length;++f)a[f].x<c?c=a[f].x:a[f].x>l&&(l=a[f].x);l+=l-c;var h=new t(l,n.y,0);for(f=0;f<a.length;f++){var d=a[f],E=a[(f+1)%a.length];if((d.x>=n.x||E.x>=n.x)&&(d.y>=n.y&&E.y<=n.y||d.y<=n.y&&E.y>=n.y)){var m=(E.y-d.y)*(h.x-n.x)-(E.x-d.x)*(h.y-n.y);if(0!==m){m=1/m;var p=((E.x-d.x)*(n.y-d.y)-(E.y-d.y)*(n.x-d.x))*m,_=((h.x-n.x)*(n.y-d.y)-(h.y-n.y)*(n.x-d.x))*m;if(p>=0&&1>=p&&_>=0&&1>=_){var v=new e(n.x+p*(h.x-n.x),n.y+p*(h.y-n.y)),T=e.subtract(v,n,z);m=e.magnitudeSquared(T),o>m&&(s=v,o=m,i[0]=f,i[1]=(f+1)%a.length)}}}}return s}function A(t,n){var r=_(n),a=n[r],i=y(a),o=a[i],u=[],s=R(o,t,u),c=T(t,s);if(-1!==c)return c;var h=e.magnitudeSquared(e.subtract(t[u[0]],o,B)),d=e.magnitudeSquared(e.subtract(t[u[1]],o,B)),E=d>h?t[u[0]]:t[u[1]],m=v(t),p=m.indexOf(E);-1!==p&&m.splice(p,1);for(var A=[],S=0;S<m.length;S++){var g=m[S];f(g,o,s,E)&&A.push(g)}var N=Number.MAX_VALUE;if(A.length>0){var O=e.fromElements(1,0,B);for(S=0;S<A.length;S++){var I=e.subtract(A[S],o,G),M=e.magnitude(O)*e.magnitudeSquared(I);if(0!==M){var w=Math.abs(l.acosClamped(e.dot(O,I)/M));N>w&&(N=w,E=A[S])}}}return t.indexOf(E)}function S(e,n,r){for(var a=ee.computeWindingOrder2D(e),i=0;i<n.length;i++){var o=n[i];t.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===a&&o.reverse()}var c=u.fromPoints(e,r),l=c.projectPointsOntoPlane(e),f=[];for(i=0;i<n.length;i++)f.push(c.projectPointsOntoPlane(n[i]));var h=A(l,f),d=_(f),E=y(f[d]),m=n[d],p=[];for(i=0;i<e.length;i++)p.push(e[i]);var v,T=[];if(0!==E)for(v=0;v<=m.length;v++){var R=(v+E)%m.length;0!==R&&T.push(m[R])}else for(v=0;v<m.length;v++)T.push(m[(v+E)%m.length]);var S=p.lastIndexOf(e[h]);T.push(e[S]);var g=p.slice(0,S+1),N=p.slice(S+1);return p=g.concat(T,N),n.splice(d,1),p}function g(e){var t=l.nextRandomNumber(),n=Math.floor(t*e);return n===e&&n--,n}function N(e,t,n,r){var a=r[e].position,i=r[t].position,o=r[n].position,u=o.x,s=o.y,c=a.x-u,l=a.y-s,f=i.x-u,h=i.y-s;return c*h-l*f}function O(e,t){return e.x*t.y-e.y*t.x}function I(e,t){var n=t.length,r=l.mod(e-1,n),a=l.mod(e+1,n);return 0===N(r,a,e,t)?!1:!0}function M(t,n){return e.magnitudeSquared(n)<e.magnitudeSquared(t)}function w(t,n,r){if(!I(t,r))return t;var a=r[t].position,i=r[n].position,o=r.length,u=l.mod(t-1,o);if(!I(u,r))return u;var s=l.mod(t+1,o);if(!I(s,r))return s;var c=e.subtract(r[u].position,a,X),f=e.subtract(r[s].position,a,V),h=e.subtract(i,a,H),d=O(c,h),E=O(f,h);if(0===d)return M(c,h)?q:W;if(0===E)return M(f,h)?q:W;var m=O(c,f);return 0>m?0>d&&E>0?q:W:m>0?d>0&&0>E?W:q:void 0}function x(e,t,n){return(e>t||e>n)&&(t>e||n>e)||t===n&&t===e}function C(t,n,r,a){var i=e.subtract(r,t,k),o=n.x*a.y-n.y*a.x,u=o*o,s=e.magnitudeSquared(n),c=e.magnitudeSquared(a);if(u>Y*s*c){var l=(i.x*a.y-i.y*a.x)/o;return e.add(t,e.multiplyByScalar(n,l,k),k)}}function P(t,n,r){for(var i=e.subtract(n,t,j),o=r.length,u=0;o>u;u++){var s=r[u].position,c=r[l.mod(u+1,o)].position;if(!(e.equals(t,s)||e.equals(n,c)||e.equals(t,c)||e.equals(n,s))){var f=e.subtract(c,s,Z),h=C(t,i,s,f);if(a(h)&&!(e.equals(h,t)||e.equals(h,n)||e.equals(h,s)||e.equals(h,c))){var d=h.x,E=h.y,m=x(d,t.x,n.x)&&x(E,t.y,n.y)&&x(d,s.x,c.x)&&x(E,s.y,c.y);if(m)return!0}}}return!1}function D(t,n,r){var a=w(t,n,r);if(a>=0)return a;var i=w(n,t,r);return i>=0?i:a!==q||i!==q||P(r[t].position,r[n].position,r)||e.equals(r[t].position,r[n].position)?J:K}function L(e){return 0===N(1,2,0,e)}function U(e){var t=e.length;if(3===t)return L(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new i("Invalid polygon: must have at least three vertices.");for(var n,r,a=0,o=10*e.length,u=J;K>u&&a++<o;){for(n=g(e.length),r=n+1;Math.abs(n-r)<2||Math.abs(n-r)>e.length-2;)r=g(e.length);if(n>r){var s=n;n=r,r=s}u=D(n,r,e)}if(u===K){var c=e.splice(n,r-n+1,e[n],e[r]);return U(e).concat(U(c))}return u>=0?(e.splice(u,1),U(e)):[]}var b=new e,F=new e,z=new e,B=new e(1,0),G=new e,q=-1,W=-2,X=new t,V=new t,H=new t,Y=l.EPSILON14,k=new e,j=new e,Z=new e,K=-1,J=-2,Q=new t,$=new t,ee={};ee.removeDuplicates=function(e){var n=h.removeDuplicates(e);return t.equals(n[0],n[n.length-1])?n.slice(1):n},ee.computeArea2D=function(e){for(var t=e.length,n=0,r=t-1,a=0;t>a;r=a++){var i=e[r],o=e[a];n+=i.x*o.y-o.x*i.y}return.5*n},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?m.COUNTER_CLOCKWISE:m.CLOCKWISE},ee.triangulate=function(e){for(var t=e.length,n=[],r=0;t>r;++r)n[r]={position:e[r],index:r};return U(n)};var te=new t,ne=new t,re=new t,ae=new t,ie=new t,oe=new t,ue=new t;return ee.computeSubdivision=function(e,i,o,u){u=r(u,l.RADIANS_PER_DEGREE);var f,h=o.slice(0),E=i.length,m=new Array(3*E),p=0;for(f=0;E>f;f++){var y=i[f];m[p++]=y.x,m[p++]=y.y,m[p++]=y.z}for(var _=[],v={},T=e.maximumRadius,R=l.chordLength(u,T),A=R*R;h.length>0;){var S,g,N=h.pop(),O=h.pop(),I=h.pop(),M=t.fromArray(m,3*I,te),w=t.fromArray(m,3*O,ne),x=t.fromArray(m,3*N,re),C=t.multiplyByScalar(t.normalize(M,ae),T,ae),P=t.multiplyByScalar(t.normalize(w,ie),T,ie),D=t.multiplyByScalar(t.normalize(x,oe),T,oe),L=t.magnitudeSquared(t.subtract(C,P,ue)),U=t.magnitudeSquared(t.subtract(P,D,ue)),b=t.magnitudeSquared(t.subtract(D,C,ue)),F=Math.max(L,U,b);F>A?L===F?(S=Math.min(I,O)+" "+Math.max(I,O),f=v[S],a(f)||(g=t.add(M,w,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),h.push(I,f,N),h.push(f,O,N)):U===F?(S=Math.min(O,N)+" "+Math.max(O,N),f=v[S],a(f)||(g=t.add(w,x,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),h.push(O,f,I),h.push(f,N,I)):b===F&&(S=Math.min(N,I)+" "+Math.max(N,I),f=v[S],a(f)||(g=t.add(x,M,ue),t.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),f=m.length/3-1,v[S]=f),h.push(N,f,O),h.push(f,I,O)):(_.push(I),_.push(O),_.push(N))}return new s({attributes:{position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:m})},indices:_,primitiveType:d.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,n,i,u){i=r(i,o.WGS84);var s=Q,c=$;if(n=r(n,0),u=r(u,!0),a(e)&&a(e.attributes)&&a(e.attributes.position))for(var l=e.attributes.position.values,f=l.length,h=0;f>h;h+=3)t.fromArray(l,h,c),u&&(c=i.scaleToGeodeticSurface(c,c)),s=i.geodeticSurfaceNormal(c,s),t.multiplyByScalar(s,n,s),t.add(c,s,c),l[h]=c.x,l[h+1]=c.y,l[h+2]=c.z;return e},ee.eliminateHoles=function(e,n,a){a=r(a,o.WGS84);for(var i=[],u=0;u<n.length;u++){for(var s=[],c=0;c<n[u].length;c++)s.push(t.clone(n[u][c]));i.push(s)}for(var l=e;i.length>0;)l=S(l,i,a);return l},ee}),define("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,n,r,a,i,o,u){"use strict";var s=Math.cos,c=Math.sin,l=Math.sqrt,f={};f.computePosition=function(e,t,r,a,i){var u=e.ellipsoid.radiiSquared,f=e.nwCorner,h=e.rectangle,d=f.latitude-e.granYCos*t+r*e.granXSin,E=s(d),m=c(d),p=u.z*m,y=f.longitude+t*e.granYSin+r*e.granXCos,_=E*s(y),v=E*c(y),T=u.x*_,R=u.y*v,A=l(T*_+R*v+p*m);a.x=T/A,a.y=R/A,a.z=p/A,n(e.vertexFormat)&&e.vertexFormat.st&&(i.x=(y-h.west)*e.lonScalar-.5,i.y=(d-h.south)*e.latScalar-.5,o.multiplyByVector(e.textureMatrix,i,i),i.x+=.5,i.y+=.5)};var h=new o,d=new e,E=new t,m=new e,p=new a;return f.computeOptions=function(t,a,s){var c,l,f,y,_,v=t._granularity,T=t._ellipsoid,R=t._surfaceHeight,A=t._rotation,S=t._extrudedHeight,g=a.east,N=a.west,O=a.north,I=a.south,M=O-I;N>g?(_=i.TWO_PI-N+g,c=Math.ceil(_/v)+1,l=Math.ceil(M/v)+1,f=_/(c-1),y=M/(l-1)):(_=g-N,c=Math.ceil(_/v)+1,l=Math.ceil(M/v)+1,f=_/(c-1),y=M/(l-1)),s=u.northwest(a,s);var w=u.center(a,E),x=y,C=f,P=0,D=0;if(n(A)){var L=Math.cos(A);x*=L,C*=L;var U=Math.sin(A);P=y*U,D=f*U,d=p.project(s,d),m=p.project(w,m),d=e.subtract(d,m,d);var b=o.fromRotation(A,h);d=o.multiplyByVector(b,d,d),d=e.add(d,m,d),s=p.unproject(d,s);var F=s.latitude,z=F+(c-1)*D,B=F-x*(l-1),G=F-x*(l-1)+(c-1)*D;O=Math.max(F,z,B,G),I=Math.min(F,z,B,G);var q=s.longitude,W=q+(c-1)*C,X=q+(l-1)*P,V=q+(l-1)*P+(c-1)*C;if(g=Math.max(q,W,X,V),N=Math.min(q,W,X,V),O<-i.PI_OVER_TWO||O>i.PI_OVER_TWO||I<-i.PI_OVER_TWO||I>i.PI_OVER_TWO)throw new r("Rotated rectangle is invalid.  It crosses over either the north or south pole.");a.north=O,a.south=I,a.east=g,a.west=N}return{granYCos:x,granYSin:P,granXCos:C,granXSin:D,ellipsoid:T,width:c,height:l,surfaceHeight:R,extrudedHeight:S,nwCorner:s,rectangle:a}},f}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return a.POSITION_ONLY=r(new a({position:!0})),a.POSITION_AND_NORMAL=r(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=r(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=r(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=r(new a({position:!0,color:!0})),a.ALL=r(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.position?1:0,n[r++]=t.normal?1:0,n[r++]=t.st?1:0,n[r++]=t.binormal?1:0,n[r++]=t.tangent?1:0,n[r++]=t.color?1:0},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.position=1===n[r++],i.normal=1===n[r++],i.st=1===n[r++],i.binormal=1===n[r++],i.tangent=1===n[r++],i.color=1===n[r++],i},a.clone=function(e,n){return t(e)?(t(n)||(n=new a),n.position=e.position,n.normal=e.normal,n.st=e.st,n.binormal=e.binormal,n.tangent=e.tangent,n.color=e.color,n):void 0},a}),define("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,n,r,a,i,o,u,s,c,l,f,h,d,E,m,p,y,_,v,T,R,A,S){"use strict";function g(e,t){var n=new c({attributes:new f,primitiveType:v.TRIANGLES});return n.attributes.position=new l({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(n.attributes.normal=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(n.attributes.tangent=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(n.attributes.binormal=new l({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.binormals})),n}function N(e,t,r,a){for(var i=e.length,o=t.normal?new Float32Array(i):void 0,u=t.tangent?new Float32Array(i):void 0,s=t.binormal?new Float32Array(i):void 0,c=0,l=U,f=L,h=D,d=0;i>d;d+=3){var E=n.fromArray(e,d,P),m=c+1,p=c+2;(t.normal||t.tangent||t.binormal)&&(h=r.geodeticSurfaceNormal(E,h),(t.tangent||t.binormal)&&(n.cross(n.UNIT_Z,h,f),y.multiplyByVector(a,f,f),n.normalize(f,f),t.binormal&&n.normalize(n.cross(h,f,l),l)),t.normal&&(o[c]=h.x,o[m]=h.y,o[p]=h.z),t.tangent&&(u[c]=f.x,u[m]=f.y,u[p]=f.z),t.binormal&&(s[c]=l.x,s[m]=l.y,s[p]=l.z)),c+=3}return g(t,{positions:e,normals:o,tangents:u,binormals:s})}function O(e,t,r){for(var a=e.length,i=t.normal?new Float32Array(a):void 0,o=t.tangent?new Float32Array(a):void 0,u=t.binormal?new Float32Array(a):void 0,s=0,c=0,l=0,f=!0,h=U,d=L,E=D,p=0;a>p;p+=6){var y=n.fromArray(e,p,P);if(t.normal||t.tangent||t.binormal){var _=n.fromArray(e,(p+6)%a,G);if(f){var v=n.fromArray(e,(p+3)%a,q);n.subtract(_,y,_),n.subtract(v,y,v),E=n.normalize(n.cross(v,_,E),E),f=!1}n.equalsEpsilon(_,y,m.EPSILON10)&&(f=!0),(t.tangent||t.binormal)&&(h=r.geodeticSurfaceNormal(y,h),t.tangent&&(d=n.normalize(n.cross(h,E,d),d))),t.normal&&(i[s++]=E.x,i[s++]=E.y,i[s++]=E.z,i[s++]=E.x,i[s++]=E.y,i[s++]=E.z),t.tangent&&(o[c++]=d.x,o[c++]=d.y,o[c++]=d.z,o[c++]=d.x,o[c++]=d.y,o[c++]=d.z),t.binormal&&(u[l++]=h.x,u[l++]=h.y,u[l++]=h.z,u[l++]=h.x,u[l++]=h.y,u[l++]=h.z)}}return g(t,{positions:e,normals:i,tangents:o,binormals:u})}function I(e){for(var t=e.vertexFormat,n=e.ellipsoid,r=e.size,i=e.height,o=e.width,u=t.position?new Float64Array(3*r):void 0,s=t.st?new Float32Array(2*r):void 0,c=0,f=0,h=P,d=F,m=Number.MAX_VALUE,p=Number.MAX_VALUE,y=Number.MIN_VALUE,_=Number.MIN_VALUE,v=0;i>v;++v)for(var T=0;o>T;++T)A.computePosition(e,v,T,h,d),u[c++]=h.x,u[c++]=h.y,u[c++]=h.z,t.st&&(s[f++]=d.x,s[f++]=d.y,m=Math.min(m,d.x),p=Math.min(p,d.y),y=Math.max(y,d.x),_=Math.max(_,d.y));if(t.st&&(0>m||0>p||y>1||_>1))for(var R=0;R<s.length;R+=2)s[R]=(s[R]-m)/(y-m),s[R+1]=(s[R+1]-p)/(_-p);for(var S=N(u,t,n,e.tangentRotationMatrix),g=6*(o-1)*(i-1),O=E.createTypedArray(r,g),I=0,M=0,w=0;i-1>w;++w){for(var x=0;o-1>x;++x){var C=I,D=C+o,L=D+1,U=C+1;O[M++]=C,O[M++]=D,O[M++]=U,O[M++]=U,O[M++]=D,O[M++]=L,++I}++I}return S.indices=O,t.st&&(S.attributes.st=new l({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:s})),S}function M(e,t,n,r,a){return e[t++]=r[n],e[t++]=r[n+1],e[t++]=r[n+2],e[t++]=a[n],e[t++]=a[n+1],e[t++]=a[n+2],e}function w(e,t,n,r){return e[t++]=r[n],e[t++]=r[n+1],e[t++]=r[n],e[t++]=r[n+1],e}function x(e){var t,r=e.vertexFormat,i=e.surfaceHeight,o=e.extrudedHeight,u=Math.min(o,i),s=Math.max(o,i),c=e.height,f=e.width,p=e.ellipsoid,y=I(e);if(m.equalsEpsilon(u,s,m.EPSILON10))return y;y=_.scaleToGeodeticHeight(y,s,p,!1);var v=new Float64Array(y.attributes.position.values),T=v.length,R=2*T,A=new Float64Array(R);A.set(v),y=_.scaleToGeodeticHeight(y,u,p);var S=y.attributes.position.values;A.set(S,T),y.attributes.position.values=A;var g,N=r.normal?new Float32Array(R):void 0,x=r.tangent?new Float32Array(R):void 0,C=r.binormal?new Float32Array(R):void 0,P=r.st?new Float32Array(R/3*2):void 0;if(r.normal){var D=y.attributes.normal.values;for(N.set(D),t=0;T>t;t++)D[t]=-D[t];N.set(D,T),y.attributes.normal.values=N}if(r.tangent){var L=y.attributes.tangent.values;for(x.set(L),t=0;T>t;t++)L[t]=-L[t];x.set(L,T),y.attributes.tangent.values=x}if(r.binormal){var U=y.attributes.binormal.values;C.set(U),C.set(U,T),y.attributes.binormal.values=C}r.st&&(g=y.attributes.st.values,P.set(g),P.set(g,T/3*2),y.attributes.st.values=P);var b=y.indices,F=b.length,z=T/3,B=E.createTypedArray(R/3,2*F);for(B.set(b),t=0;F>t;t+=3)B[t+F]=b[t+2]+z,B[t+1+F]=b[t+1]+z,B[t+2+F]=b[t]+z;y.indices=B;var W=2*f+2*c-4,X=2*(W+4),V=new Float64Array(3*X),H=r.st?new Float32Array(2*X):void 0,Y=0,k=0,j=f*c;for(t=0;j>t;t+=f)V=M(V,Y,3*t,v,S),Y+=6,r.st&&(H=w(H,k,2*t,g),k+=4);for(t=j-f;j>t;t++)V=M(V,Y,3*t,v,S),Y+=6,r.st&&(H=w(H,k,2*t,g),k+=4);for(t=j-1;t>0;t-=f)V=M(V,Y,3*t,v,S),Y+=6,r.st&&(H=w(H,k,2*t,g),k+=4);for(t=f-1;t>=0;t--)V=M(V,Y,3*t,v,S),Y+=6,r.st&&(H=w(H,k,2*t,g),k+=4);var Z=O(V,r,p);r.st&&(Z.attributes.st=new l({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:H}));var K,J,Q,$,ee=E.createTypedArray(X,6*W);T=V.length/3;var te=0;for(t=0;T-1>t;t+=2){K=t,$=(K+2)%T;var ne=n.fromArray(V,3*K,G),re=n.fromArray(V,3*$,q);n.equalsEpsilon(ne,re,m.EPSILON10)||(J=(K+1)%T,Q=(J+2)%T,ee[te++]=K,ee[te++]=J,ee[te++]=$,ee[te++]=$,ee[te++]=J,ee[te++]=Q)}return Z.indices=ee,Z=d.combineInstances([new h({geometry:y}),new h({geometry:Z})]),Z[0]}function C(e){e=i(e,i.EMPTY_OBJECT);var t=e.rectangle,n=i(e.granularity,m.RADIANS_PER_DEGREE),r=i(e.ellipsoid,s.WGS84),a=i(e.height,0),u=i(e.rotation,0),c=i(e.stRotation,0),l=i(e.vertexFormat,S.DEFAULT),f=e.extrudedHeight,h=o(f),d=i(e.closeTop,!0),E=i(e.closeBottom,!0);this._rectangle=t,this._granularity=n,this._ellipsoid=s.clone(r),this._surfaceHeight=a,this._rotation=u,this._stRotation=c,this._vertexFormat=S.clone(l),this._extrudedHeight=i(f,0),this._extrude=h,this._closeTop=d,this._closeBottom=E,this._workerName="createRectangleGeometry"}var P=new n,D=new n,L=new n,U=new n,b=new R,F=new t,z=new e,B=new e,G=new n,q=new n;C.packedLength=R.packedLength+s.packedLength+S.packedLength+8,C.pack=function(e,t,n){n=i(n,0),R.pack(e._rectangle,t,n),n+=R.packedLength,s.pack(e._ellipsoid,t,n),n+=s.packedLength,S.pack(e._vertexFormat,t,n),n+=S.packedLength,t[n++]=e._granularity,t[n++]=e._surfaceHeight,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._extrudedHeight,t[n++]=e._extrude?1:0,t[n++]=e._closeTop?1:0,t[n]=e._closeBottom?1:0};var W=new R,X=s.clone(s.UNIT_SPHERE),V=new S,H={rectangle:W,ellipsoid:X,vertexFormat:V,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0};C.unpack=function(e,t,n){t=i(t,0);var r=R.unpack(e,t,W);t+=R.packedLength;var a=s.unpack(e,t,X);t+=s.packedLength;var u=S.unpack(e,t,V);t+=S.packedLength;var c=e[t++],l=e[t++],f=e[t++],h=e[t++],d=e[t++],E=1===e[t++],m=1===e[t++],p=1===e[t];return o(n)?(n._rectangle=R.clone(r,n._rectangle),n._ellipsoid=s.clone(a,n._ellipsoid),n._vertexFormat=S.clone(u,n._vertexFormat),n._granularity=c,n._surfaceHeight=l,n._rotation=f,n._stRotation=h,n._extrudedHeight=E?d:void 0,n._extrude=E,n._closeTop=m,n._closeBottom=p,n):(H.granularity=c,H.height=l,H.rotation=f,H.stRotation=h,H.extrudedHeight=E?d:void 0,H.closeTop=m,H.closeBottom=p,new C(H))};var Y=new p,k=new y,j=new r,Z=new T,K=new r;return C.createGeometry=function(t){var r=R.clone(t._rectangle,b),a=t._ellipsoid,i=t._surfaceHeight,u=t._extrude,s=t._extrudedHeight,l=t._stRotation,h=t._vertexFormat,d=A.computeOptions(t,r,j),E=Y,m=k;if(o(l)){p.fromRotation(-l,E);var v=R.center(r,K),S=a.cartographicToCartesian(v,G);n.normalize(S,S),T.fromAxisAngle(S,-l,Z),y.fromQuaternion(Z,m)}else p.clone(p.IDENTITY,E),y.clone(y.IDENTITY,m);d.lonScalar=1/r.width,d.latScalar=1/r.height,d.vertexFormat=h,d.textureMatrix=E,d.tangentRotationMatrix=m,d.size=d.width*d.height;var g,N;if(r=t._rectangle,u){g=x(d);var O=e.fromRectangle3D(r,a,i,B),M=e.fromRectangle3D(r,a,s,z);N=e.union(O,M)}else g=I(d),g=_.scaleToGeodeticHeight(g,i,a,!1),N=e.fromRectangle3D(r,a,i);return h.position||delete g.attributes.position,new c({attributes:new f(g.attributes),indices:g.indices,primitiveType:g.primitiveType,boundingSphere:N})},C.createShadowVolume=function(e,t,n){var r=e._granularity,a=e._ellipsoid,i=t(r,a),o=n(r,a);return new C({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:a,stRotation:e._stRotation,granularity:r,extrudedHeight:o,height:i,closeTop:!0,closeBottom:!0,vertexFormat:S.POSITION_ONLY})},C}),define("Workers/createRectangleGeometry",["../Core/defined","../Core/Ellipsoid","../Core/Rectangle","../Core/RectangleGeometry"],function(e,t,n,r){"use strict";function a(a,i){return e(i)&&(a=r.unpack(a,i)),a._ellipsoid=t.clone(a._ellipsoid),a._rectangle=n.clone(a._rectangle),r.createGeometry(a)}return a})}();