/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function t(t){return void 0!==t}return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";function e(t,e){return void 0!==t?t:e}return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";function e(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(r){e=r.stack}this.stack=e}return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^t>>>1^e[1&t];for(;r<this.N-1;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=t<<7&2636928640,t^=t<<15&4022730752,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e,r,n){"use strict";var o={};o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=function(t){return t>0?1:0>t?-1:0},o.signNotZero=function(t){return 0>t?-1:1},o.toSNorm=function(t){return Math.round(255*(.5*o.clamp(t,-1,1)+.5))},o.fromSNorm=function(t){return o.clamp(t,0,255)/255*2-1},o.sinh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e-r)},o.cosh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e+r)},o.lerp=function(t,e,r){return(1-r)*t+r*e},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=.5*Math.PI,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI*.5,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(t){return t*o.RADIANS_PER_DEGREE},o.toDegrees=function(t){return t*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(t){var e=o.TWO_PI,r=t-Math.floor(t/e)*e;return r<-Math.PI?r+e:r>=Math.PI?r-e:r},o.negativePiToPi=function(t){return o.zeroToTwoPi(t+o.PI)-o.PI},o.zeroToTwoPi=function(t){var e=o.mod(t,o.TWO_PI);return Math.abs(e)<o.EPSILON14&&Math.abs(t)>o.EPSILON14?o.TWO_PI:e},o.mod=function(t,e){return(t%e+e)%e},o.equalsEpsilon=function(t,r,n,o){o=e(o,n);var i=Math.abs(t-r);return o>=i||i<=n*Math.max(Math.abs(t),Math.abs(r))};var i=[1];o.factorial=function(t){var e=i.length;if(t>=e)for(var r=i[e-1],n=e;t>=n;n++)i.push(r*n);return i[t]},o.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},o.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},o.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},o.clamp=function(t,e,r){return e>t?e:t>r?r:t};var a=new t;return o.setRandomNumberSeed=function(e){a=new t(e)},o.nextRandomNumber=function(){return a.random()},o.acosClamped=function(t){return Math.acos(o.clamp(t,-1,1))},o.asinClamped=function(t){return Math.asin(o.clamp(t,-1,1))},o.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},o.fog=function(t,e){var r=t*e;return 1-Math.exp(-(r*r))},o}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o){"use strict";function i(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}i.fromSpherical=function(r,n){e(n)||(n=new i);var o=r.clock,a=r.cone,s=t(r.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(t,r,n,o){return e(o)?(o.x=t,o.y=r,o.z=n,o):new i(t,r,n)},i.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r.z=t.z,r):new i(t.x,t.y,t.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z},i.unpack=function(r,n,o){return n=t(n,0),e(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},i.minimumByComponent=function(t,e,r){return r.x=Math.min(t.x,e.x),r.y=Math.min(t.y,e.y),r.z=Math.min(t.z,e.z),r},i.maximumByComponent=function(t,e,r){return r.x=Math.max(t.x,e.x),r.y=Math.max(t.y,e.y),r.z=Math.max(t.z,e.z),r},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,e){return i.subtract(t,e,a),i.magnitude(a)},i.distanceSquared=function(t,e){return i.subtract(t,e,a),i.magnitudeSquared(a)},i.normalize=function(t,e){var r=i.magnitude(t);return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e},i.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},i.multiplyComponents=function(t,e,r){return r.x=t.x*e.x,r.y=t.y*e.y,r.z=t.z*e.z,r},i.add=function(t,e,r){return r.x=t.x+e.x,r.y=t.y+e.y,r.z=t.z+e.z,r},i.subtract=function(t,e,r){return r.x=t.x-e.x,r.y=t.y-e.y,r.z=t.z-e.z,r},i.multiplyByScalar=function(t,e,r){return r.x=t.x*e,r.y=t.y*e,r.z=t.z*e,r},i.divideByScalar=function(t,e,r){return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r},i.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},i.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var s=new i;i.lerp=function(t,e,r,n){return i.multiplyByScalar(e,r,s),n=i.multiplyByScalar(t,1-r,n),i.add(s,n,n)};var u=new i,E=new i;i.angleBetween=function(t,e){i.normalize(t,u),i.normalize(e,E);var r=i.dot(u,E),n=i.magnitude(i.cross(u,E,u));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(t,e){var r=i.normalize(t,l);return i.abs(r,r),e=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,e):i.clone(i.UNIT_Z,e):r.y<=r.z?i.clone(i.UNIT_Y,e):i.clone(i.UNIT_Z,e)},i.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y&&t.z===r.z},i.equalsArray=function(t,e,r){return t.x===e[r]&&t.y===e[r+1]&&t.z===e[r+2]},i.equalsEpsilon=function(t,r,n,i){return t===r||e(t)&&e(r)&&o.equalsEpsilon(t.x,r.x,n,i)&&o.equalsEpsilon(t.y,r.y,n,i)&&o.equalsEpsilon(t.z,r.z,n,i)},i.cross=function(t,e,r){var n=t.x,o=t.y,i=t.z,a=e.x,s=e.y,u=e.z,E=o*u-i*s,l=i*a-n*u,c=n*s-o*a;return r.x=E,r.y=l,r.z=c,r},i.fromDegrees=function(t,e,r,n,a){var s=o.toRadians(t),u=o.toRadians(e);return i.fromRadians(s,u,r,n,a)};var c=new i,_=new i,R=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,o,a,s){o=t(o,0);var u=e(a)?a.radiiSquared:R,E=Math.cos(n);c.x=E*Math.cos(r),c.y=E*Math.sin(r),c.z=Math.sin(n),c=i.normalize(c,c),i.multiplyComponents(u,c,_);var l=Math.sqrt(i.dot(c,_));return _=i.divideByScalar(_,l,_),c=i.multiplyByScalar(c,o,c),e(s)||(s=new i),i.add(_,c,s)},i.fromDegreesArray=function(t,e,r){for(var n=new Array(t.length),a=0;a<t.length;a++)n[a]=o.toRadians(t[a]);return i.fromRadiansArray(n,e,r)},i.fromRadiansArray=function(t,r,n){var o=t.length;e(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var s=t[a],u=t[a+1];n[a/2]=i.fromRadians(s,u,0,r,n[a/2])}return n},i.fromDegreesArrayHeights=function(t,e,r){for(var n=new Array(t.length),a=0;a<t.length;a+=3)n[a]=o.toRadians(t[a]),n[a+1]=o.toRadians(t[a+1]),n[a+2]=t[a+2];return i.fromRadiansArrayHeights(n,e,r)},i.fromRadiansArrayHeights=function(t,r,n){var o=t.length;e(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var s=t[a],u=t[a+1],E=t[a+2];n[a/3]=i.fromRadians(s,u,E,r,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,e,r){return i.equalsEpsilon(this,t,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(t,e,r,n){"use strict";function o(r,o,s,u,E){var l=r.x,c=r.y,_=r.z,R=o.x,f=o.y,T=o.z,A=l*l*R*R,h=c*c*f*f,d=_*_*T*T,S=A+h+d,m=Math.sqrt(1/S),C=t.multiplyByScalar(r,m,i);if(u>S)return isFinite(m)?t.clone(C,E):void 0;var N=s.x,I=s.y,M=s.z,O=a;O.x=C.x*N*2,O.y=C.y*I*2,O.z=C.z*M*2;var p,g,F,y,L,v,D,U,P,B,w,x=(1-m)*t.magnitude(r)/(.5*t.magnitude(O)),G=0;do{x-=G,F=1/(1+x*N),y=1/(1+x*I),L=1/(1+x*M),v=F*F,D=y*y,U=L*L,P=v*F,B=D*y,w=U*L,p=A*v+h*D+d*U-1,g=A*P*N+h*B*I+d*w*M;var b=-2*g;G=p/b}while(Math.abs(p)>n.EPSILON12);return e(E)?(E.x=l*F,E.y=c*y,E.z=_*L,E):new t(l*F,c*y,_*L)}var i=new t,a=new t;return o}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(t,e,r,n,o,i,a){"use strict";function s(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)}s.fromRadians=function(t,n,o,i){return o=e(o,0),r(i)?(i.longitude=t,i.latitude=n,i.height=o,i):new s(t,n,o)},s.fromDegrees=function(t,e,r,n){return t=i.toRadians(t),e=i.toRadians(e),s.fromRadians(t,e,r,n)};var u=new t,E=new t,l=new t,c=new t(1/6378137,1/6378137,1/6356752.314245179),_=new t(1/40680631590769,1/40680631590769,1/40408299984661.445),R=i.EPSILON1;return s.fromCartesian=function(e,n,o){var f=r(n)?n.oneOverRadii:c,T=r(n)?n.oneOverRadiiSquared:_,A=r(n)?n._centerToleranceSquared:R,h=a(e,f,T,A,E);if(r(h)){var d=t.multiplyComponents(e,T,u);d=t.normalize(d,d);var S=t.subtract(e,h,l),m=Math.atan2(d.y,d.x),C=Math.asin(d.z),N=i.sign(t.dot(S,e))*t.magnitude(S);return r(o)?(o.longitude=m,o.latitude=C,o.height=N,o):new s(m,C,N)}},s.clone=function(t,e){return r(t)?r(e)?(e.longitude=t.longitude,e.latitude=t.latitude,e.height=t.height,e):new s(t.longitude,t.latitude,t.height):void 0},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.longitude===e.longitude&&t.latitude===e.latitude&&t.height===e.height},s.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.longitude-e.longitude)<=n&&Math.abs(t.latitude-e.latitude)<=n&&Math.abs(t.height-e.height)<=n},s.ZERO=o(new s(0,0,0)),s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,e){return s.equalsEpsilon(this,t,e)},s.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},s}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),r=Object.defineProperties;return e&&t(r)||(r=function(t){return t}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(t,e,r,n,o,i,a,s,u){"use strict";function E(e,n,o,i){n=r(n,0),o=r(o,0),i=r(i,0),e._radii=new t(n,o,i),e._radiiSquared=new t(n*n,o*o,i*i),e._radiiToTheFourth=new t(n*n*n*n,o*o*o*o,i*i*i*i),e._oneOverRadii=new t(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),e._oneOverRadiiSquared=new t(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),e._minimumRadius=Math.min(n,o,i),e._maximumRadius=Math.max(n,o,i),e._centerToleranceSquared=s.EPSILON1}function l(t,e,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,E(this,t,e,r)}o(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(e,r){if(n(e)){var o=e._radii;return n(r)?(t.clone(o,r._radii),t.clone(e._radiiSquared,r._radiiSquared),t.clone(e._radiiToTheFourth,r._radiiToTheFourth),t.clone(e._oneOverRadii,r._oneOverRadii),t.clone(e._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=e._minimumRadius,r._maximumRadius=e._maximumRadius,r._centerToleranceSquared=e._centerToleranceSquared,r):new l(o.x,o.y,o.z)}},l.fromCartesian3=function(t,e){return n(e)||(e=new l),n(t)?(E(e,t.x,t.y,t.z),e):e},l.WGS84=a(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=a(new l(1,1,1)),l.MOON=a(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(t){return l.clone(this,t)},l.packedLength=t.packedLength,l.pack=function(e,n,o){o=r(o,0),t.pack(e._radii,n,o)},l.unpack=function(e,n,o){n=r(n,0);var i=t.unpack(e,n);return l.fromCartesian3(i,o)},l.prototype.geocentricSurfaceNormal=t.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(e,r){var o=e.longitude,i=e.latitude,a=Math.cos(i),s=a*Math.cos(o),u=a*Math.sin(o),E=Math.sin(i);return n(r)||(r=new t),r.x=s,r.y=u,r.z=E,t.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(e,r){return n(r)||(r=new t),r=t.multiplyComponents(e,this._oneOverRadiiSquared,r),t.normalize(r,r)};var c=new t,_=new t;l.prototype.cartographicToCartesian=function(e,r){var o=c,i=_;this.geodeticSurfaceNormalCartographic(e,o),t.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(t.dot(o,i));return t.divideByScalar(i,a,i),t.multiplyByScalar(o,e.height,o),n(r)||(r=new t),t.add(i,o,r)},l.prototype.cartographicArrayToCartesianArray=function(t,e){var r=t.length;n(e)?e.length=r:e=new Array(r);for(var o=0;r>o;o++)e[o]=this.cartographicToCartesian(t[o],e[o]);return e};var R=new t,f=new t,T=new t;return l.prototype.cartesianToCartographic=function(r,o){var i=this.scaleToGeodeticSurface(r,f);if(n(i)){var a=this.geodeticSurfaceNormal(i,R),u=t.subtract(r,i,T),E=Math.atan2(a.y,a.x),l=Math.asin(a.z),c=s.sign(t.dot(u,r))*t.magnitude(u);return n(o)?(o.longitude=E,o.latitude=l,o.height=c,o):new e(E,l,c)}},l.prototype.cartesianArrayToCartographicArray=function(t,e){var r=t.length;n(e)?e.length=r:e=new Array(r);for(var o=0;r>o;++o)e[o]=this.cartesianToCartographic(t[o],e[o]);return e},l.prototype.scaleToGeodeticSurface=function(t,e){return u(t,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,e)},l.prototype.scaleToGeocentricSurface=function(e,r){n(r)||(r=new t);var o=e.x,i=e.y,a=e.z,s=this._oneOverRadiiSquared,u=1/Math.sqrt(o*o*s.x+i*i*s.y+a*a*s.z);return t.multiplyByScalar(e,u,r)},l.prototype.transformPositionToScaledSpace=function(e,r){return n(r)||(r=new t),t.multiplyComponents(e,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(e,r){return n(r)||(r=new t),t.multiplyComponents(e,this._radii,r)},l.prototype.equals=function(e){return this===e||n(e)&&t.equals(this._radii,e._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,e,r,n,o,i,a){"use strict";function s(t){this._ellipsoid=r(t,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(e,r){var o=this._semimajorAxis,i=e.longitude*o,a=e.latitude*o,s=e.height;return n(r)?(r.x=i,r.y=a,r.z=s,r):new t(i,a,s)},s.prototype.unproject=function(t,r){var o=this._oneOverSemimajorAxis,i=t.x*o,a=t.y*o,s=t.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=s,r):new e(i,a,s)},s}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(e)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";function e(e,r){this.start=t(e,0),this.stop=t(r,0)}return e}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o,i){"use strict";function a(t,r,n,o,i,a,s,u,E){this[0]=e(t,0),this[1]=e(o,0),this[2]=e(s,0),this[3]=e(r,0),this[4]=e(i,0),this[5]=e(u,0),this[6]=e(n,0),this[7]=e(a,0),this[8]=e(E,0)}function s(t){for(var e=0,r=0;9>r;++r){var n=t[r];e+=n*n}return Math.sqrt(e)}function u(t){for(var e=0,r=0;3>r;++r){var n=t[a.getElementIndex(R[r],_[r])];e+=2*n*n}return Math.sqrt(e)}function E(t,e){for(var r=i.EPSILON15,n=0,o=1,s=0;3>s;++s){var u=Math.abs(t[a.getElementIndex(R[s],_[s])]);u>n&&(o=s,n=u)}var E=1,l=0,c=_[o],f=R[o];if(Math.abs(t[a.getElementIndex(f,c)])>r){var T,A=t[a.getElementIndex(f,f)],h=t[a.getElementIndex(c,c)],d=t[a.getElementIndex(f,c)],S=(A-h)/2/d;T=0>S?-1/(-S+Math.sqrt(1+S*S)):1/(S+Math.sqrt(1+S*S)),E=1/Math.sqrt(1+T*T),l=T*E}return e=a.clone(a.IDENTITY,e),e[a.getElementIndex(c,c)]=e[a.getElementIndex(f,f)]=E,e[a.getElementIndex(f,c)]=l,e[a.getElementIndex(c,f)]=-l,e}a.packedLength=9,a.pack=function(t,r,n){n=e(n,0),r[n++]=t[0],r[n++]=t[1],r[n++]=t[2],r[n++]=t[3],r[n++]=t[4],r[n++]=t[5],r[n++]=t[6],r[n++]=t[7],r[n++]=t[8]},a.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new a),o[0]=t[n++],o[1]=t[n++],o[2]=t[n++],o[3]=t[n++],o[4]=t[n++],o[5]=t[n++],o[6]=t[n++],o[7]=t[n++],o[8]=t[n++],o},a.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new a(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},a.fromArray=function(t,n,o){return n=e(n,0),r(o)||(o=new a),o[0]=t[n],o[1]=t[n+1],o[2]=t[n+2],o[3]=t[n+3],o[4]=t[n+4],o[5]=t[n+5],o[6]=t[n+6],o[7]=t[n+7],o[8]=t[n+8],o},a.fromColumnMajorArray=function(t,e){return a.clone(t,e)},a.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new a(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},a.fromQuaternion=function(t,e){var n=t.x*t.x,o=t.x*t.y,i=t.x*t.z,s=t.x*t.w,u=t.y*t.y,E=t.y*t.z,l=t.y*t.w,c=t.z*t.z,_=t.z*t.w,R=t.w*t.w,f=n-u-c+R,T=2*(o-_),A=2*(i+l),h=2*(o+_),d=-n+u-c+R,S=2*(E-s),m=2*(i-l),C=2*(E+s),N=-n-u+c+R;return r(e)?(e[0]=f,e[1]=h,e[2]=m,e[3]=T,e[4]=d,e[5]=C,e[6]=A,e[7]=S,e[8]=N,e):new a(f,T,A,h,d,S,m,C,N)},a.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new a(t.x,0,0,0,t.y,0,0,0,t.z)},a.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new a(t,0,0,0,t,0,0,0,t)},a.fromCrossProduct=function(t,e){return r(e)?(e[0]=0,e[1]=t.z,e[2]=-t.y,e[3]=-t.z,e[4]=0,e[5]=t.x,e[6]=t.y,e[7]=-t.x,e[8]=0,e):new a(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},a.fromRotationX=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=n,e[5]=o,e[6]=0,e[7]=-o,e[8]=n,e):new a(1,0,0,0,n,-o,0,o,n)},a.fromRotationY=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=n,e[1]=0,e[2]=-o,e[3]=0,e[4]=1,e[5]=0,e[6]=o,e[7]=0,e[8]=n,e):new a(n,0,o,0,1,0,-o,0,n)},a.fromRotationZ=function(t,e){var n=Math.cos(t),o=Math.sin(t);return r(e)?(e[0]=n,e[1]=o,e[2]=0,e[3]=-o,e[4]=n,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new a(n,-o,0,o,n,0,0,0,1)},a.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},a.getElementIndex=function(t,e){return 3*t+e},a.getColumn=function(t,e,r){var n=3*e,o=t[n],i=t[n+1],a=t[n+2];return r.x=o,r.y=i,r.z=a,r},a.setColumn=function(t,e,r,n){n=a.clone(t,n);var o=3*e;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},a.getRow=function(t,e,r){var n=t[e],o=t[e+3],i=t[e+6];return r.x=n,r.y=o,r.z=i,r},a.setRow=function(t,e,r,n){return n=a.clone(t,n),n[e]=r.x,n[e+3]=r.y,n[e+6]=r.z,n};var l=new t;a.getScale=function(e,r){return r.x=t.magnitude(t.fromElements(e[0],e[1],e[2],l)),r.y=t.magnitude(t.fromElements(e[3],e[4],e[5],l)),r.z=t.magnitude(t.fromElements(e[6],e[7],e[8],l)),r};var c=new t;a.getMaximumScale=function(e){return a.getScale(e,c),t.maximumComponent(c)},a.multiply=function(t,e,r){var n=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],o=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],i=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],a=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],s=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],u=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],E=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],l=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],c=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=s,r[5]=u,r[6]=E,r[7]=l,r[8]=c,r},a.add=function(t,e,r){return r[0]=t[0]+e[0],r[1]=t[1]+e[1],r[2]=t[2]+e[2],r[3]=t[3]+e[3],r[4]=t[4]+e[4],r[5]=t[5]+e[5],r[6]=t[6]+e[6],r[7]=t[7]+e[7],r[8]=t[8]+e[8],r},a.subtract=function(t,e,r){return r[0]=t[0]-e[0],r[1]=t[1]-e[1],r[2]=t[2]-e[2],r[3]=t[3]-e[3],r[4]=t[4]-e[4],r[5]=t[5]-e[5],r[6]=t[6]-e[6],r[7]=t[7]-e[7],r[8]=t[8]-e[8],r},a.multiplyByVector=function(t,e,r){var n=e.x,o=e.y,i=e.z,a=t[0]*n+t[3]*o+t[6]*i,s=t[1]*n+t[4]*o+t[7]*i,u=t[2]*n+t[5]*o+t[8]*i;return r.x=a,r.y=s,r.z=u,r},a.multiplyByScalar=function(t,e,r){return r[0]=t[0]*e,r[1]=t[1]*e,r[2]=t[2]*e,r[3]=t[3]*e,r[4]=t[4]*e,r[5]=t[5]*e,r[6]=t[6]*e,r[7]=t[7]*e,r[8]=t[8]*e,r},a.multiplyByScale=function(t,e,r){return r[0]=t[0]*e.x,r[1]=t[1]*e.x,r[2]=t[2]*e.x,r[3]=t[3]*e.y,r[4]=t[4]*e.y,r[5]=t[5]*e.y,r[6]=t[6]*e.z,r[7]=t[7]*e.z,r[8]=t[8]*e.z,r},a.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e},a.transpose=function(t,e){var r=t[0],n=t[3],o=t[6],i=t[1],a=t[4],s=t[7],u=t[2],E=t[5],l=t[8];return e[0]=r,e[1]=n,e[2]=o,e[3]=i,e[4]=a,e[5]=s,e[6]=u,e[7]=E,e[8]=l,e};var _=[1,0,0],R=[2,2,1],f=new a,T=new a;return a.computeEigenDecomposition=function(t,e){var n=i.EPSILON20,o=10,l=0,c=0;r(e)||(e={});for(var _=e.unitary=a.clone(a.IDENTITY,e.unitary),R=e.diagonal=a.clone(t,e.diagonal),A=n*s(R);o>c&&u(R)>A;)E(R,f),a.transpose(f,T),a.multiply(R,f,R),a.multiply(T,R,R),a.multiply(_,f,_),++l>2&&(++c,l=0);return e},a.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e},a.determinant=function(t){var e=t[0],r=t[3],n=t[6],o=t[1],i=t[4],a=t[7],s=t[2],u=t[5],E=t[8];return e*(i*E-u*a)+o*(u*n-r*E)+s*(r*a-i*n)},a.inverse=function(t,e){var r=t[0],o=t[1],s=t[2],u=t[3],E=t[4],l=t[5],c=t[6],_=t[7],R=t[8],f=a.determinant(t);if(Math.abs(f)<=i.EPSILON15)throw new n("matrix is not invertible");e[0]=E*R-_*l,e[1]=_*s-o*R,e[2]=o*l-E*s,e[3]=c*l-u*R,e[4]=r*R-c*s,e[5]=u*s-r*l,e[6]=u*_-c*E,e[7]=c*o-r*_,e[8]=r*E-u*o;var T=1/f;return a.multiplyByScalar(e,T,e)},a.equals=function(t,e){return t===e||r(t)&&r(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},a.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n},a.IDENTITY=o(new a(1,0,0,0,1,0,0,0,1)),a.ZERO=o(new a(0,0,0,0,0,0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN0ROW2=2,a.COLUMN1ROW0=3,a.COLUMN1ROW1=4,a.COLUMN1ROW2=5,a.COLUMN2ROW0=6,a.COLUMN2ROW1=7,a.COLUMN2ROW2=8,a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.equalsArray=function(t,e,r){return t[0]===e[r]&&t[1]===e[r+1]&&t[2]===e[r+2]&&t[3]===e[r+3]&&t[4]===e[r+4]&&t[5]===e[r+5]&&t[6]===e[r+6]&&t[7]===e[r+7]&&t[8]===e[r+8]},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},a}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o){"use strict";function i(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}i.fromElements=function(t,r,n,o,a){return e(a)?(a.x=t,a.y=r,a.z=n,a.w=o,a):new i(t,r,n,o)},i.fromColor=function(t,r){return e(r)?(r.x=t.red,r.y=t.green,r.z=t.blue,r.w=t.alpha,r):new i(t.red,t.green,t.blue,t.alpha)},i.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r.z=t.z,r.w=t.w,r):new i(t.x,t.y,t.z,t.w):void 0},i.packedLength=4,i.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},i.unpack=function(r,n,o){return n=t(n,0),e(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},i.minimumByComponent=function(t,e,r){return r.x=Math.min(t.x,e.x),r.y=Math.min(t.y,e.y),r.z=Math.min(t.z,e.z),r.w=Math.min(t.w,e.w),r},i.maximumByComponent=function(t,e,r){return r.x=Math.max(t.x,e.x),r.y=Math.max(t.y,e.y),r.z=Math.max(t.z,e.z),r.w=Math.max(t.w,e.w),r},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,e){return i.subtract(t,e,a),i.magnitude(a)},i.distanceSquared=function(t,e){return i.subtract(t,e,a),i.magnitudeSquared(a)},i.normalize=function(t,e){var r=i.magnitude(t);return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e.w=t.w/r,e},i.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},i.multiplyComponents=function(t,e,r){return r.x=t.x*e.x,r.y=t.y*e.y,r.z=t.z*e.z,r.w=t.w*e.w,r},i.add=function(t,e,r){return r.x=t.x+e.x,r.y=t.y+e.y,r.z=t.z+e.z,r.w=t.w+e.w,r},i.subtract=function(t,e,r){return r.x=t.x-e.x,r.y=t.y-e.y,r.z=t.z-e.z,r.w=t.w-e.w,r},i.multiplyByScalar=function(t,e,r){return r.x=t.x*e,r.y=t.y*e,r.z=t.z*e,r.w=t.w*e,r},i.divideByScalar=function(t,e,r){return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r.w=t.w/e,r},i.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},i.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e.w=Math.abs(t.w),e};var s=new i;i.lerp=function(t,e,r,n){return i.multiplyByScalar(e,r,s),n=i.multiplyByScalar(t,1-r,n),i.add(s,n,n)};var u=new i;return i.mostOrthogonalAxis=function(t,e){var r=i.normalize(t,u);return i.abs(r,r),e=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,e):i.clone(i.UNIT_W,e):r.z<=r.w?i.clone(i.UNIT_Z,e):i.clone(i.UNIT_W,e):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,e):i.clone(i.UNIT_W,e):r.z<=r.w?i.clone(i.UNIT_Z,e):i.clone(i.UNIT_W,e)},i.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y&&t.z===r.z&&t.w===r.w},i.equalsArray=function(t,e,r){return t.x===e[r]&&t.y===e[r+1]&&t.z===e[r+2]&&t.w===e[r+3]},i.equalsEpsilon=function(t,r,n,i){return t===r||e(t)&&e(r)&&o.equalsEpsilon(t.x,r.x,n,i)&&o.equalsEpsilon(t.y,r.y,n,i)&&o.equalsEpsilon(t.z,r.z,n,i)&&o.equalsEpsilon(t.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,e,r){return i.equalsEpsilon(this,t,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/RuntimeError",["./defined"],function(t){"use strict";function e(t){this.name="RuntimeError",this.message=t;var e;try{throw new Error}catch(r){e=r.stack}this.stack=e}return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,r,n,o,i,a,s,u){"use strict";function E(t,e,n,o,i,a,s,u,E,l,c,_,R,f,T,A){this[0]=r(t,0),this[1]=r(i,0),this[2]=r(E,0),this[3]=r(R,0),this[4]=r(e,0),this[5]=r(a,0),this[6]=r(l,0),this[7]=r(f,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(c,0),this[11]=r(T,0),this[12]=r(o,0),this[13]=r(u,0),this[14]=r(_,0),this[15]=r(A,0)}E.packedLength=16,E.pack=function(t,e,n){n=r(n,0),e[n++]=t[0],e[n++]=t[1],e[n++]=t[2],e[n++]=t[3],e[n++]=t[4],e[n++]=t[5],e[n++]=t[6],e[n++]=t[7],e[n++]=t[8],e[n++]=t[9],e[n++]=t[10],e[n++]=t[11],e[n++]=t[12],e[n++]=t[13],e[n++]=t[14],e[n]=t[15]},E.unpack=function(t,e,o){return e=r(e,0),n(o)||(o=new E),o[0]=t[e++],o[1]=t[e++],o[2]=t[e++],o[3]=t[e++],o[4]=t[e++],o[5]=t[e++],o[6]=t[e++],o[7]=t[e++],o[8]=t[e++],o[9]=t[e++],o[10]=t[e++],o[11]=t[e++],o[12]=t[e++],o[13]=t[e++],o[14]=t[e++],o[15]=t[e],o},E.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new E(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},E.fromArray=E.unpack,E.fromColumnMajorArray=function(t,e){return E.clone(t,e)},E.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new E(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},E.fromRotationTranslation=function(e,o,i){return o=r(o,t.ZERO),n(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new E(e[0],e[3],e[6],o.x,e[1],e[4],e[7],o.y,e[2],e[5],e[8],o.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(t,e,r,o){n(o)||(o=new E);var i=r.x,a=r.y,s=r.z,u=e.x*e.x,l=e.x*e.y,c=e.x*e.z,_=e.x*e.w,R=e.y*e.y,f=e.y*e.z,T=e.y*e.w,A=e.z*e.z,h=e.z*e.w,d=e.w*e.w,S=u-R-A+d,m=2*(l-h),C=2*(c+T),N=2*(l+h),I=-u+R-A+d,M=2*(f-_),O=2*(c-T),p=2*(f+_),g=-u-R+A+d;return o[0]=S*i,o[1]=N*i,o[2]=O*i,o[3]=0,o[4]=m*a,o[5]=I*a,o[6]=p*a,o[7]=0,o[8]=C*s,o[9]=M*s,o[10]=g*s,o[11]=0,o[12]=t.x,o[13]=t.y,o[14]=t.z,o[15]=1,o},E.fromTranslationRotationScale=function(t,e){return E.fromTranslationQuaternionRotationScale(t.translation,t.rotation,t.scale,e)},E.fromTranslation=function(t,e){return E.fromRotationTranslation(s.IDENTITY,t,e)},E.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new E(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},E.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new E(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var l=new t,c=new t,_=new t;E.fromCamera=function(e,r){var o=e.eye,i=e.target,a=e.up;t.normalize(t.subtract(i,o,l),l),t.normalize(t.cross(l,a,c),c),t.normalize(t.cross(c,l,_),_);var s=c.x,u=c.y,R=c.z,f=l.x,T=l.y,A=l.z,h=_.x,d=_.y,S=_.z,m=o.x,C=o.y,N=o.z,I=s*-m+u*-C+R*-N,M=h*-m+d*-C+S*-N,O=f*m+T*C+A*N;
return n(r)?(r[0]=s,r[1]=h,r[2]=-f,r[3]=0,r[4]=u,r[5]=d,r[6]=-T,r[7]=0,r[8]=R,r[9]=S,r[10]=-A,r[11]=0,r[12]=I,r[13]=M,r[14]=O,r[15]=1,r):new E(s,u,R,I,h,d,S,M,-f,-T,-A,O,0,0,0,1)},E.computePerspectiveFieldOfView=function(t,e,r,n,o){var i=Math.tan(.5*t),a=1/i,s=a/e,u=(n+r)/(r-n),E=2*n*r/(r-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=u,o[11]=-1,o[12]=0,o[13]=0,o[14]=E,o[15]=0,o},E.computeOrthographicOffCenter=function(t,e,r,n,o,i,a){var s=1/(e-t),u=1/(n-r),E=1/(i-o),l=-(e+t)*s,c=-(n+r)*u,_=-(i+o)*E;return s*=2,u*=2,E*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=l,a[13]=c,a[14]=_,a[15]=1,a},E.computePerspectiveOffCenter=function(t,e,r,n,o,i,a){var s=2*o/(e-t),u=2*o/(n-r),E=(e+t)/(e-t),l=(n+r)/(n-r),c=-(i+o)/(i-o),_=-1,R=-2*i*o/(i-o);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=E,a[9]=l,a[10]=c,a[11]=_,a[12]=0,a[13]=0,a[14]=R,a[15]=0,a},E.computeInfinitePerspectiveOffCenter=function(t,e,r,n,o,i){var a=2*o/(e-t),s=2*o/(n-r),u=(e+t)/(e-t),E=(n+r)/(n-r),l=-1,c=-1,_=-2*o;return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=u,i[9]=E,i[10]=l,i[11]=c,i[12]=0,i[13]=0,i[14]=_,i[15]=0,i},E.computeViewportTransformation=function(t,e,n,o){t=r(t,r.EMPTY_OBJECT);var i=r(t.x,0),a=r(t.y,0),s=r(t.width,0),u=r(t.height,0);e=r(e,0),n=r(n,1);var E=.5*s,l=.5*u,c=.5*(n-e),_=E,R=l,f=c,T=i+E,A=a+l,h=e+c,d=1;return o[0]=_,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=R,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=f,o[11]=0,o[12]=T,o[13]=A,o[14]=h,o[15]=d,o},E.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},E.getElementIndex=function(t,e){return 4*t+e},E.getColumn=function(t,e,r){var n=4*e,o=t[n],i=t[n+1],a=t[n+2],s=t[n+3];return r.x=o,r.y=i,r.z=a,r.w=s,r},E.setColumn=function(t,e,r,n){n=E.clone(t,n);var o=4*e;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},E.setTranslation=function(t,e,r){return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=t[15],r},E.getRow=function(t,e,r){var n=t[e],o=t[e+4],i=t[e+8],a=t[e+12];return r.x=n,r.y=o,r.z=i,r.w=a,r},E.setRow=function(t,e,r,n){return n=E.clone(t,n),n[e]=r.x,n[e+4]=r.y,n[e+8]=r.z,n[e+12]=r.w,n};var R=new t;E.getScale=function(e,r){return r.x=t.magnitude(t.fromElements(e[0],e[1],e[2],R)),r.y=t.magnitude(t.fromElements(e[4],e[5],e[6],R)),r.z=t.magnitude(t.fromElements(e[8],e[9],e[10],R)),r};var f=new t;E.getMaximumScale=function(e){return E.getScale(e,f),t.maximumComponent(f)},E.multiply=function(t,e,r){var n=t[0],o=t[1],i=t[2],a=t[3],s=t[4],u=t[5],E=t[6],l=t[7],c=t[8],_=t[9],R=t[10],f=t[11],T=t[12],A=t[13],h=t[14],d=t[15],S=e[0],m=e[1],C=e[2],N=e[3],I=e[4],M=e[5],O=e[6],p=e[7],g=e[8],F=e[9],y=e[10],L=e[11],v=e[12],D=e[13],U=e[14],P=e[15],B=n*S+s*m+c*C+T*N,w=o*S+u*m+_*C+A*N,x=i*S+E*m+R*C+h*N,G=a*S+l*m+f*C+d*N,b=n*I+s*M+c*O+T*p,z=o*I+u*M+_*O+A*p,H=i*I+E*M+R*O+h*p,V=a*I+l*M+f*O+d*p,X=n*g+s*F+c*y+T*L,W=o*g+u*F+_*y+A*L,q=i*g+E*F+R*y+h*L,Y=a*g+l*F+f*y+d*L,K=n*v+s*D+c*U+T*P,k=o*v+u*D+_*U+A*P,Z=i*v+E*D+R*U+h*P,j=a*v+l*D+f*U+d*P;return r[0]=B,r[1]=w,r[2]=x,r[3]=G,r[4]=b,r[5]=z,r[6]=H,r[7]=V,r[8]=X,r[9]=W,r[10]=q,r[11]=Y,r[12]=K,r[13]=k,r[14]=Z,r[15]=j,r},E.add=function(t,e,r){return r[0]=t[0]+e[0],r[1]=t[1]+e[1],r[2]=t[2]+e[2],r[3]=t[3]+e[3],r[4]=t[4]+e[4],r[5]=t[5]+e[5],r[6]=t[6]+e[6],r[7]=t[7]+e[7],r[8]=t[8]+e[8],r[9]=t[9]+e[9],r[10]=t[10]+e[10],r[11]=t[11]+e[11],r[12]=t[12]+e[12],r[13]=t[13]+e[13],r[14]=t[14]+e[14],r[15]=t[15]+e[15],r},E.subtract=function(t,e,r){return r[0]=t[0]-e[0],r[1]=t[1]-e[1],r[2]=t[2]-e[2],r[3]=t[3]-e[3],r[4]=t[4]-e[4],r[5]=t[5]-e[5],r[6]=t[6]-e[6],r[7]=t[7]-e[7],r[8]=t[8]-e[8],r[9]=t[9]-e[9],r[10]=t[10]-e[10],r[11]=t[11]-e[11],r[12]=t[12]-e[12],r[13]=t[13]-e[13],r[14]=t[14]-e[14],r[15]=t[15]-e[15],r},E.multiplyTransformation=function(t,e,r){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],E=t[8],l=t[9],c=t[10],_=t[12],R=t[13],f=t[14],T=e[0],A=e[1],h=e[2],d=e[4],S=e[5],m=e[6],C=e[8],N=e[9],I=e[10],M=e[12],O=e[13],p=e[14],g=n*T+a*A+E*h,F=o*T+s*A+l*h,y=i*T+u*A+c*h,L=n*d+a*S+E*m,v=o*d+s*S+l*m,D=i*d+u*S+c*m,U=n*C+a*N+E*I,P=o*C+s*N+l*I,B=i*C+u*N+c*I,w=n*M+a*O+E*p+_,x=o*M+s*O+l*p+R,G=i*M+u*O+c*p+f;return r[0]=g,r[1]=F,r[2]=y,r[3]=0,r[4]=L,r[5]=v,r[6]=D,r[7]=0,r[8]=U,r[9]=P,r[10]=B,r[11]=0,r[12]=w,r[13]=x,r[14]=G,r[15]=1,r},E.multiplyByMatrix3=function(t,e,r){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],E=t[8],l=t[9],c=t[10],_=e[0],R=e[1],f=e[2],T=e[3],A=e[4],h=e[5],d=e[6],S=e[7],m=e[8],C=n*_+a*R+E*f,N=o*_+s*R+l*f,I=i*_+u*R+c*f,M=n*T+a*A+E*h,O=o*T+s*A+l*h,p=i*T+u*A+c*h,g=n*d+a*S+E*m,F=o*d+s*S+l*m,y=i*d+u*S+c*m;return r[0]=C,r[1]=N,r[2]=I,r[3]=0,r[4]=M,r[5]=O,r[6]=p,r[7]=0,r[8]=g,r[9]=F,r[10]=y,r[11]=0,r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r},E.multiplyByTranslation=function(t,e,r){var n=e.x,o=e.y,i=e.z,a=n*t[0]+o*t[4]+i*t[8]+t[12],s=n*t[1]+o*t[5]+i*t[9]+t[13],u=n*t[2]+o*t[6]+i*t[10]+t[14];return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=a,r[13]=s,r[14]=u,r[15]=t[15],r};var T=new t;E.multiplyByUniformScale=function(t,e,r){return T.x=e,T.y=e,T.z=e,E.multiplyByScale(t,T,r)},E.multiplyByScale=function(t,e,r){var n=e.x,o=e.y,i=e.z;return 1===n&&1===o&&1===i?E.clone(t,r):(r[0]=n*t[0],r[1]=n*t[1],r[2]=n*t[2],r[3]=0,r[4]=o*t[4],r[5]=o*t[5],r[6]=o*t[6],r[7]=0,r[8]=i*t[8],r[9]=i*t[9],r[10]=i*t[10],r[11]=0,r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=1,r)},E.multiplyByVector=function(t,e,r){var n=e.x,o=e.y,i=e.z,a=e.w,s=t[0]*n+t[4]*o+t[8]*i+t[12]*a,u=t[1]*n+t[5]*o+t[9]*i+t[13]*a,E=t[2]*n+t[6]*o+t[10]*i+t[14]*a,l=t[3]*n+t[7]*o+t[11]*i+t[15]*a;return r.x=s,r.y=u,r.z=E,r.w=l,r},E.multiplyByPointAsVector=function(t,e,r){var n=e.x,o=e.y,i=e.z,a=t[0]*n+t[4]*o+t[8]*i,s=t[1]*n+t[5]*o+t[9]*i,u=t[2]*n+t[6]*o+t[10]*i;return r.x=a,r.y=s,r.z=u,r},E.multiplyByPoint=function(t,e,r){var n=e.x,o=e.y,i=e.z,a=t[0]*n+t[4]*o+t[8]*i+t[12],s=t[1]*n+t[5]*o+t[9]*i+t[13],u=t[2]*n+t[6]*o+t[10]*i+t[14];return r.x=a,r.y=s,r.z=u,r},E.multiplyByScalar=function(t,e,r){return r[0]=t[0]*e,r[1]=t[1]*e,r[2]=t[2]*e,r[3]=t[3]*e,r[4]=t[4]*e,r[5]=t[5]*e,r[6]=t[6]*e,r[7]=t[7]*e,r[8]=t[8]*e,r[9]=t[9]*e,r[10]=t[10]*e,r[11]=t[11]*e,r[12]=t[12]*e,r[13]=t[13]*e,r[14]=t[14]*e,r[15]=t[15]*e,r},E.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e},E.transpose=function(t,e){var r=t[1],n=t[2],o=t[3],i=t[6],a=t[7],s=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=r,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=n,e[9]=i,e[10]=t[10],e[11]=t[14],e[12]=o,e[13]=a,e[14]=s,e[15]=t[15],e},E.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e},E.equals=function(t,e){return t===e||n(t)&&n(e)&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[3]===e[3]&&t[7]===e[7]&&t[11]===e[11]&&t[15]===e[15]},E.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r&&Math.abs(t[9]-e[9])<=r&&Math.abs(t[10]-e[10])<=r&&Math.abs(t[11]-e[11])<=r&&Math.abs(t[12]-e[12])<=r&&Math.abs(t[13]-e[13])<=r&&Math.abs(t[14]-e[14])<=r&&Math.abs(t[15]-e[15])<=r},E.getTranslation=function(t,e){return e.x=t[12],e.y=t[13],e.z=t[14],e},E.getRotation=function(t,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e};var A=new s,h=new s,d=new e,S=new e(0,0,0,1);return E.inverse=function(t,r){if(s.equalsEpsilon(E.getRotation(t,A),h,a.EPSILON7)&&e.equals(E.getRow(t,3,d),S))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-t[12],r[13]=-t[13],r[14]=-t[14],r[15]=1,r;var n=t[0],o=t[4],i=t[8],l=t[12],c=t[1],_=t[5],R=t[9],f=t[13],T=t[2],m=t[6],C=t[10],N=t[14],I=t[3],M=t[7],O=t[11],p=t[15],g=C*p,F=N*O,y=m*p,L=N*M,v=m*O,D=C*M,U=T*p,P=N*I,B=T*O,w=C*I,x=T*M,G=m*I,b=g*_+L*R+v*f-(F*_+y*R+D*f),z=F*c+U*R+w*f-(g*c+P*R+B*f),H=y*c+P*_+x*f-(L*c+U*_+G*f),V=D*c+B*_+G*R-(v*c+w*_+x*R),X=F*o+y*i+D*l-(g*o+L*i+v*l),W=g*n+P*i+B*l-(F*n+U*i+w*l),q=L*n+U*o+G*l-(y*n+P*o+x*l),Y=v*n+w*o+x*i-(D*n+B*o+G*i);g=i*f,F=l*R,y=o*f,L=l*_,v=o*R,D=i*_,U=n*f,P=l*c,B=n*R,w=i*c,x=n*_,G=o*c;var K=g*M+L*O+v*p-(F*M+y*O+D*p),k=F*I+U*O+w*p-(g*I+P*O+B*p),Z=y*I+P*M+x*p-(L*I+U*M+G*p),j=D*I+B*M+G*O-(v*I+w*M+x*O),Q=y*C+D*N+F*m-(v*N+g*m+L*C),J=B*N+g*T+P*C-(U*C+w*N+F*T),$=U*m+G*N+L*T-(x*N+y*T+P*m),tt=x*C+v*T+w*m-(B*m+G*C+D*T),et=n*b+o*z+i*H+l*V;if(Math.abs(et)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return et=1/et,r[0]=b*et,r[1]=z*et,r[2]=H*et,r[3]=V*et,r[4]=X*et,r[5]=W*et,r[6]=q*et,r[7]=Y*et,r[8]=K*et,r[9]=k*et,r[10]=Z*et,r[11]=j*et,r[12]=Q*et,r[13]=J*et,r[14]=$*et,r[15]=tt*et,r},E.inverseTransformation=function(t,e){var r=t[0],n=t[1],o=t[2],i=t[4],a=t[5],s=t[6],u=t[8],E=t[9],l=t[10],c=t[12],_=t[13],R=t[14],f=-r*c-n*_-o*R,T=-i*c-a*_-s*R,A=-u*c-E*_-l*R;return e[0]=r,e[1]=i,e[2]=u,e[3]=0,e[4]=n,e[5]=a,e[6]=E,e[7]=0,e[8]=o,e[9]=s,e[10]=l,e[11]=0,e[12]=f,e[13]=T,e[14]=A,e[15]=1,e},E.IDENTITY=i(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=i(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,E.prototype.clone=function(t){return E.clone(this,t)},E.prototype.equals=function(t){return E.equals(this,t)},E.equalsArray=function(t,e,r){return t[0]===e[r]&&t[1]===e[r+1]&&t[2]===e[r+2]&&t[3]===e[r+3]&&t[4]===e[r+4]&&t[5]===e[r+5]&&t[6]===e[r+6]&&t[7]===e[r+7]&&t[8]===e[r+8]&&t[9]===e[r+9]&&t[10]===e[r+10]&&t[11]===e[r+11]&&t[12]===e[r+12]&&t[13]===e[r+13]&&t[14]===e[r+14]&&t[15]===e[r+15]},E.prototype.equalsEpsilon=function(t,e){return E.equalsEpsilon(this,t,e)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n){"use strict";function o(e,r){this.normal=t.clone(e),this.distance=r}o.fromPointNormal=function(r,n,i){var a=-t.dot(n,r);return e(i)?(t.clone(n,i.normal),i.distance=a,i):new o(n,a)};var i=new t;return o.fromCartesian4=function(r,n){var a=t.fromCartesian4(r,i),s=r.w;return e(n)?(t.clone(a,n.normal),n.distance=s,n):new o(a,s)},o.getPointDistance=function(e,r){return t.dot(e.normal,r)+e.distance},o.ORIGIN_XY_PLANE=n(new o(t.UNIT_Z,0)),o.ORIGIN_YZ_PLANE=n(new o(t.UNIT_X,0)),o.ORIGIN_ZX_PLANE=n(new o(t.UNIT_Y,0)),o}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,e,r,n,o,i,a,s){"use strict";function u(t,r,n,o){this.west=e(t,0),this.south=e(r,0),this.east=e(n,0),this.north=e(o,0)}n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(t,r,n){n=e(n,0),r[n++]=t.west,r[n++]=t.south,r[n++]=t.east,r[n]=t.north},u.unpack=function(t,n,o){return n=e(n,0),r(o)||(o=new u),o.west=t[n++],o.south=t[n++],o.east=t[n++],o.north=t[n],o},u.computeWidth=function(t){var e=t.east,r=t.west;return r>e&&(e+=s.TWO_PI),e-r},u.computeHeight=function(t){return t.north-t.south},u.fromDegrees=function(t,n,o,i,a){return t=s.toRadians(e(t,0)),n=s.toRadians(e(n,0)),o=s.toRadians(e(o,0)),i=s.toRadians(e(i,0)),r(a)?(a.west=t,a.south=n,a.east=o,a.north=i,a):new u(t,n,o,i)},u.fromCartographicArray=function(t,e){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,E=Number.MAX_VALUE,l=-Number.MAX_VALUE,c=0,_=t.length;_>c;c++){var R=t[c];n=Math.min(n,R.longitude),o=Math.max(o,R.longitude),E=Math.min(E,R.latitude),l=Math.max(l,R.latitude);var f=R.longitude>=0?R.longitude:R.longitude+s.TWO_PI;i=Math.min(i,f),a=Math.max(a,f)}return o-n>a-i&&(n=i,o=a,o>s.PI&&(o-=s.TWO_PI),n>s.PI&&(n-=s.TWO_PI)),r(e)?(e.west=n,e.south=E,e.east=o,e.north=l,e):new u(n,E,o,l)},u.clone=function(t,e){return r(t)?r(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new u(t.west,t.south,t.east,t.north):void 0},u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.equals=function(t,e){return t===e||r(t)&&r(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},u.prototype.equalsEpsilon=function(t,e){return r(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},u.validate=function(t){},u.southwest=function(e,n){return r(n)?(n.longitude=e.west,n.latitude=e.south,n.height=0,n):new t(e.west,e.south)},u.northwest=function(e,n){return r(n)?(n.longitude=e.west,n.latitude=e.north,n.height=0,n):new t(e.west,e.north)},u.northeast=function(e,n){return r(n)?(n.longitude=e.east,n.latitude=e.north,n.height=0,n):new t(e.east,e.north)},u.southeast=function(e,n){return r(n)?(n.longitude=e.east,n.latitude=e.south,n.height=0,n):new t(e.east,e.south)},u.center=function(e,n){var o=e.east,i=e.west;i>o&&(o+=s.TWO_PI);var a=s.negativePiToPi(.5*(i+o)),u=.5*(e.south+e.north);return r(n)?(n.longitude=a,n.latitude=u,n.height=0,n):new t(a,u)},u.intersection=function(t,e,n){var o=t.east,i=t.west,a=e.east,E=e.west;i>o&&a>0?o+=s.TWO_PI:E>a&&o>0&&(a+=s.TWO_PI),i>o&&0>E?E+=s.TWO_PI:E>a&&0>i&&(i+=s.TWO_PI);var l=s.negativePiToPi(Math.max(i,E)),c=s.negativePiToPi(Math.min(o,a));if(!((t.west<t.east||e.west<e.east)&&l>=c)){var _=Math.max(t.south,e.south),R=Math.min(t.north,e.north);if(!(_>=R))return r(n)?(n.west=l,n.south=_,n.east=c,n.north=R,n):new u(l,_,c,R)}},u.contains=function(t,e){var r=e.longitude,n=e.latitude,o=t.west,i=t.east;return o>i&&(i+=s.TWO_PI,0>r&&(r+=s.TWO_PI)),(r>o||s.equalsEpsilon(r,o,s.EPSILON14))&&(i>r||s.equalsEpsilon(r,i,s.EPSILON14))&&n>=t.south&&n<=t.north};var E=new t;return u.subsample=function(t,n,o,a){n=e(n,i.WGS84),o=e(o,0),r(a)||(a=[]);var l=0,c=t.north,_=t.south,R=t.east,f=t.west,T=E;T.height=o,T.longitude=f,T.latitude=c,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=R,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.latitude=_,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=f,a[l]=n.cartographicToCartesian(T,a[l]),l++,0>c?T.latitude=c:_>0?T.latitude=_:T.latitude=0;for(var A=1;8>A;++A)T.longitude=-Math.PI+A*s.PI_OVER_TWO,u.contains(t,T)&&(a[l]=n.cartographicToCartesian(T,a[l]),l++);return 0===T.latitude&&(T.longitude=f,a[l]=n.cartographicToCartesian(T,a[l]),l++,T.longitude=R,a[l]=n.cartographicToCartesian(T,a[l]),l++),a.length=l,a},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(t,e,r,n,o,i,a,s,u,E,l,c,_){"use strict";function R(e,n){this.center=t.clone(r(e,t.ZERO)),this.radius=r(n,0)}var f=new t,T=new t,A=new t,h=new t,d=new t,S=new t,m=new t,C=new t,N=new t,I=new t,M=new t,O=new t;R.fromPoints=function(e,r){if(n(r)||(r=new R),!n(e)||0===e.length)return r.center=t.clone(t.ZERO,r.center),r.radius=0,r;for(var o=t.clone(e[0],m),i=t.clone(o,f),a=t.clone(o,T),s=t.clone(o,A),u=t.clone(o,h),E=t.clone(o,d),l=t.clone(o,S),c=e.length,_=1;c>_;_++){t.clone(e[_],o);var p=o.x,g=o.y,F=o.z;p<i.x&&t.clone(o,i),p>u.x&&t.clone(o,u),g<a.y&&t.clone(o,a),g>E.y&&t.clone(o,E),F<s.z&&t.clone(o,s),F>l.z&&t.clone(o,l)}var y=t.magnitudeSquared(t.subtract(u,i,C)),L=t.magnitudeSquared(t.subtract(E,a,C)),v=t.magnitudeSquared(t.subtract(l,s,C)),D=i,U=u,P=y;L>P&&(P=L,D=a,U=E),v>P&&(P=v,D=s,U=l);var B=N;B.x=.5*(D.x+U.x),B.y=.5*(D.y+U.y),B.z=.5*(D.z+U.z);var w=t.magnitudeSquared(t.subtract(U,B,C)),x=Math.sqrt(w),G=I;G.x=i.x,G.y=a.y,G.z=s.z;var b=M;b.x=u.x,b.y=E.y,b.z=l.z;var z=t.multiplyByScalar(t.add(G,b,C),.5,O),H=0;for(_=0;c>_;_++){t.clone(e[_],o);var V=t.magnitude(t.subtract(o,z,C));V>H&&(H=V);var X=t.magnitudeSquared(t.subtract(o,B,C));if(X>w){var W=Math.sqrt(X);x=.5*(x+W),w=x*x;var q=W-x;B.x=(x*B.x+q*o.x)/W,B.y=(x*B.y+q*o.y)/W,B.z=(x*B.z+q*o.z)/W}}return H>x?(t.clone(B,r.center),r.radius=x):(t.clone(z,r.center),r.radius=H),r};var p=new a,g=new t,F=new t,y=new e,L=new e;R.fromRectangle2D=function(t,e,r){return R.fromRectangleWithHeights2D(t,e,0,0,r)},R.fromRectangleWithHeights2D=function(e,o,i,a,s){if(n(s)||(s=new R),!n(e))return s.center=t.clone(t.ZERO,s.center),s.radius=0,s;o=r(o,p),_.southwest(e,y),y.height=i,_.northeast(e,L),L.height=a;var u=o.project(y,g),E=o.project(L,F),l=E.x-u.x,c=E.y-u.y,f=E.z-u.z;s.radius=.5*Math.sqrt(l*l+c*c+f*f);var T=s.center;return T.x=u.x+.5*l,T.y=u.y+.5*c,T.z=u.z+.5*f,s};var v=[];R.fromRectangle3D=function(t,e,o,a){e=r(e,i.WGS84),o=r(o,0);var s;return n(t)&&(s=_.subsample(t,e,o,v)),R.fromPoints(s,a)},R.fromVertices=function(e,o,i,a){if(n(a)||(a=new R),!n(e)||0===e.length)return a.center=t.clone(t.ZERO,a.center),a.radius=0,a;o=r(o,t.ZERO),i=r(i,3);var s=m;s.x=e[0]+o.x,s.y=e[1]+o.y,s.z=e[2]+o.z;for(var u=t.clone(s,f),E=t.clone(s,T),l=t.clone(s,A),c=t.clone(s,h),_=t.clone(s,d),p=t.clone(s,S),g=e.length,F=0;g>F;F+=i){var y=e[F]+o.x,L=e[F+1]+o.y,v=e[F+2]+o.z;s.x=y,s.y=L,s.z=v,y<u.x&&t.clone(s,u),y>c.x&&t.clone(s,c),L<E.y&&t.clone(s,E),L>_.y&&t.clone(s,_),v<l.z&&t.clone(s,l),v>p.z&&t.clone(s,p)}var D=t.magnitudeSquared(t.subtract(c,u,C)),U=t.magnitudeSquared(t.subtract(_,E,C)),P=t.magnitudeSquared(t.subtract(p,l,C)),B=u,w=c,x=D;U>x&&(x=U,B=E,w=_),P>x&&(x=P,B=l,w=p);var G=N;G.x=.5*(B.x+w.x),G.y=.5*(B.y+w.y),G.z=.5*(B.z+w.z);var b=t.magnitudeSquared(t.subtract(w,G,C)),z=Math.sqrt(b),H=I;H.x=u.x,H.y=E.y,H.z=l.z;var V=M;V.x=c.x,V.y=_.y,V.z=p.z;var X=t.multiplyByScalar(t.add(H,V,C),.5,O),W=0;for(F=0;g>F;F+=i){s.x=e[F]+o.x,s.y=e[F+1]+o.y,s.z=e[F+2]+o.z;var q=t.magnitude(t.subtract(s,X,C));q>W&&(W=q);var Y=t.magnitudeSquared(t.subtract(s,G,C));if(Y>b){var K=Math.sqrt(Y);z=.5*(z+K),b=z*z;var k=K-z;G.x=(z*G.x+k*s.x)/K,G.y=(z*G.y+k*s.y)/K,G.z=(z*G.z+k*s.z)/K}}return W>z?(t.clone(G,a.center),a.radius=z):(t.clone(X,a.center),a.radius=W),a},R.fromCornerPoints=function(e,r,o){n(o)||(o=new R);var i=o.center;return t.add(e,r,i),t.multiplyByScalar(i,.5,i),o.radius=t.distance(i,r),o},R.fromEllipsoid=function(e,r){return n(r)||(r=new R),t.clone(t.ZERO,r.center),r.radius=e.maximumRadius,r};var D=new t;R.fromBoundingSpheres=function(e,r){if(n(r)||(r=new R),!n(e)||0===e.length)return r.center=t.clone(t.ZERO,r.center),r.radius=0,r;var o=e.length;if(1===o)return R.clone(e[0],r);if(2===o)return R.union(e[0],e[1],r);for(var i=[],a=0;o>a;a++)i.push(e[a].center);r=R.fromPoints(i,r);var s=r.center,u=r.radius;for(a=0;o>a;a++){var E=e[a];u=Math.max(u,t.distance(s,E.center,D)+E.radius)}return r.radius=u,r};var U=new t,P=new t,B=new t;R.fromOrientedBoundingBox=function(e,r){n(r)||(r=new R);var o=e.halfAxes,i=E.getColumn(o,0,U),a=E.getColumn(o,1,P),s=E.getColumn(o,2,B),u=t.magnitude(i),l=t.magnitude(a),c=t.magnitude(s);return r.center=t.clone(e.center,r.center),r.radius=Math.max(u,l,c),r},R.clone=function(e,r){return n(e)?n(r)?(r.center=t.clone(e.center,r.center),r.radius=e.radius,r):new R(e.center,e.radius):void 0},R.packedLength=4,R.pack=function(t,e,n){n=r(n,0);var o=t.center;e[n++]=o.x,e[n++]=o.y,e[n++]=o.z,e[n]=t.radius},R.unpack=function(t,e,o){e=r(e,0),n(o)||(o=new R);var i=o.center;return i.x=t[e++],i.y=t[e++],i.z=t[e++],o.radius=t[e],o};var w=new t,x=new t;R.union=function(e,r,o){n(o)||(o=new R);var i=e.center,a=e.radius,s=r.center,u=r.radius,E=t.subtract(s,i,w),l=t.magnitude(E);if(a>=l+u)return e.clone(o),o;if(u>=l+a)return r.clone(o),o;var c=.5*(a+l+u),_=t.multiplyByScalar(E,(-a+c)/l,x);return t.add(_,i,_),t.clone(_,o.center),o.radius=c,o};var G=new t;R.expand=function(e,r,n){n=R.clone(e,n);var o=t.magnitude(t.subtract(r,n.center,G));return o>n.radius&&(n.radius=o),n},R.intersectPlane=function(e,r){var n=e.center,o=e.radius,i=r.normal,a=t.dot(i,n)+r.distance;return-o>a?s.OUTSIDE:o>a?s.INTERSECTING:s.INSIDE},R.transform=function(t,e,r){return n(r)||(r=new R),r.center=l.multiplyByPoint(e,t.center,r.center),r.radius=l.getMaximumScale(e)*t.radius,r};var b=new t;R.distanceSquaredTo=function(e,r){var n=t.subtract(e.center,r,b);return t.magnitudeSquared(n)-e.radius*e.radius},R.transformWithoutScale=function(t,e,r){return n(r)||(r=new R),r.center=l.multiplyByPoint(e,t.center,r.center),r.radius=t.radius,r};var z=new t;R.computePlaneDistances=function(e,r,o,i){n(i)||(i=new u);var a=t.subtract(e.center,r,z),s=t.dot(o,a);return i.start=s-e.radius,i.stop=s+e.radius,i};for(var H=new t,V=new t,X=new t,W=new t,q=new t,Y=new e,K=new Array(8),k=0;8>k;++k)K[k]=new t;var Z=new a;return R.projectTo2D=function(e,n,o){n=r(n,Z);var i=n.ellipsoid,a=e.center,s=e.radius,u=i.geodeticSurfaceNormal(a,H),E=t.cross(t.UNIT_Z,u,V);t.normalize(E,E);var l=t.cross(u,E,X);t.normalize(l,l),t.multiplyByScalar(u,s,u),t.multiplyByScalar(l,s,l),t.multiplyByScalar(E,s,E);var c=t.negate(l,q),_=t.negate(E,W),f=K,T=f[0];t.add(u,l,T),t.add(T,E,T),T=f[1],t.add(u,l,T),t.add(T,_,T),T=f[2],t.add(u,c,T),t.add(T,_,T),T=f[3],t.add(u,c,T),t.add(T,E,T),t.negate(u,u),T=f[4],t.add(u,l,T),t.add(T,E,T),T=f[5],t.add(u,l,T),t.add(T,_,T),T=f[6],t.add(u,c,T),t.add(T,_,T),T=f[7],t.add(u,c,T),t.add(T,E,T);for(var A=f.length,h=0;A>h;++h){var d=f[h];t.add(a,d,d);var S=i.cartesianToCartographic(d,Y);n.project(S,d)}o=R.fromPoints(f,o),a=o.center;var m=a.x,C=a.y,N=a.z;return a.x=N,a.y=m,a.z=C,o},R.isOccluded=function(t,e){return!e.isBoundingSphereVisible(t)},R.equals=function(e,r){return e===r||n(e)&&n(r)&&t.equals(e.center,r.center)&&e.radius===r.radius},R.prototype.intersectPlane=function(t){return R.intersectPlane(this,t)},R.prototype.distanceSquaredTo=function(t){return R.distanceSquaredTo(this,t)},R.prototype.computePlaneDistances=function(t,e,r){return R.computePlaneDistances(this,t,e,r)},R.prototype.isOccluded=function(t){return R.isOccluded(this,t)},R.prototype.equals=function(t){return R.equals(this,t)},R.prototype.clone=function(t){return R.clone(this,t)},R}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,e){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return e(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(t(r))return r;r=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;s>a;++a){var u=i[a];o=u+"RequestFullscreen","function"==typeof e[o]?(n.requestFullscreen=o,r=!0):(o=u+"RequestFullScreen","function"==typeof e[o]&&(n.requestFullscreen=o,r=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",t(document[o])?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",t(document[o])&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",t(document[o])?n.fullscreenElement=o:(o=u+"FullScreenElement",t(document[o])&&(n.fullscreenElement=o)),o=u+"fullscreenchange",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(t){o.supportsFullscreen()&&t[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,e,r){"use strict";function n(t){for(var e=t.split("."),r=0,n=e.length;n>r;++r)e[r]=parseInt(e[r],10);return e}function o(){if(!e(h)){h=!1;var t=/ Chrome\/([\.0-9]+)/.exec(A.userAgent);null!==t&&(h=!0,d=n(t[1]))}return h}function i(){return o()&&d}function a(){if(!e(S)&&(S=!1,!o()&&/ Safari\/[\.0-9]+/.test(A.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(A.userAgent);null!==t&&(S=!0,m=n(t[1]))}return S}function s(){return a()&&m}function u(){if(!e(C)){C=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(A.userAgent);null!==t&&(C=!0,N=n(t[1]),N.isNightly=!!t[2])}return C}function E(){return u()&&N}function l(){if(!e(I)){I=!1;var t;"Microsoft Internet Explorer"===A.appName?(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent),null!==t&&(I=!0,M=n(t[1]))):"Netscape"===A.appName&&(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent),null!==t&&(I=!0,M=n(t[1])))}return I}function c(){return l()&&M}function _(){if(!e(O)){O=!1;var t=/Firefox\/([\.0-9]+)/.exec(A.userAgent);null!==t&&(O=!0,p=n(t[1]))}return O}function R(){return e(g)||(g=/Windows/i.test(A.appVersion)),g}function f(){return _()&&p}function T(){return e(F)||(F="undefined"!=typeof PointerEvent&&(!e(A.pointerEnabled)||A.pointerEnabled)),F}var A;A="undefined"!=typeof navigator?navigator:{};var h,d,S,m,C,N,I,M,O,p,g,F,y={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:E,isInternetExplorer:l,internetExplorerVersion:c,isFirefox:_,firefoxVersion:f,isWindows:R,hardwareConcurrency:t(A.hardwareConcurrency,3),supportsPointerEvents:T};return y.supportsFullscreen=function(){return r.supportsFullscreen()},y.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},y.supportsWebWorkers=function(){return"undefined"!=typeof Worker},y}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(t,e,r,n,o,i){"use strict";function a(t,e,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?t+6*(e-t)*r:1>2*r?e:2>3*r?t+(e-t)*(2/3-r)*6:t}function s(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}s.fromCartesian4=function(t,r){return e(r)?(r.red=t.x,r.green=t.y,r.blue=t.z,r.alpha=t.w,r):new s(t.x,t.y,t.z,t.w)},s.fromBytes=function(r,n,o,i,a){return r=s.byteToFloat(t(r,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),i=s.byteToFloat(t(i,255)),e(a)?(a.red=r,a.green=n,a.blue=o,a.alpha=i,a):new s(r,n,o,i)},s.fromAlpha=function(t,r,n){return e(n)?(n.red=t.red,n.green=t.green,n.blue=t.blue,n.alpha=r,n):new s(t.red,t.green,t.blue,r)};var u,E,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),E=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(t){return E[0]=t,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(e,r,n,o){e=t(e,0)%1,r=t(r,0),n=t(n,0),o=t(o,1);var i=n,u=n,E=n;if(0!==r){var l;l=.5>n?n*(1+r):n+r-n*r;var c=2*n-l;i=a(c,l,e+1/3),u=a(c,l,e),E=a(c,l,e-1/3)}return new s(i,u,E,o)},s.fromRandom=function(r,n){r=t(r,t.EMPTY_OBJECT);var o=r.red;if(!e(o)){var a=t(r.minimumRed,0),u=t(r.maximumRed,1);o=a+i.nextRandomNumber()*(u-a)}var E=r.green;if(!e(E)){var l=t(r.minimumGreen,0),c=t(r.maximumGreen,1);E=l+i.nextRandomNumber()*(c-l)}var _=r.blue;if(!e(_)){var R=t(r.minimumBlue,0),f=t(r.maximumBlue,1);_=R+i.nextRandomNumber()*(f-R)}var T=r.alpha;if(!e(T)){var A=t(r.minimumAlpha,0),h=t(r.maximumAlpha,1);T=A+i.nextRandomNumber()*(h-A)}return e(n)?(n.red=o,n.green=E,n.blue=_,n.alpha=T,n):new s(o,E,_,T)};var c=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,_=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,R=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,f=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){var n=s[r.toUpperCase()];if(e(n))return s.clone(n);var o=c.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=_.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=R.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(t(o[4],"1.0"))):(o=f.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(t(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.red,r[n++]=e.green,r[n++]=e.blue,r[n]=e.alpha},s.unpack=function(r,n,o){return n=t(n,0),e(o)||(o=new s),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},s.byteToFloat=function(t){return t/255},s.floatToByte=function(t){return 1===t?255:256*t|0},s.clone=function(t,r){return e(t)?e(r)?(r.red=t.red,r.green=t.green,r.blue=t.blue,r.alpha=t.alpha,r):new s(t.red,t.green,t.blue,t.alpha):void 0},s.equals=function(t,r){return t===r||e(t)&&e(r)&&t.red===r.red&&t.green===r.green&&t.blue===r.blue&&t.alpha===r.alpha},s.equalsArray=function(t,e,r){return t.red===e[r]&&t.green===e[r+1]&&t.blue===e[r+2]&&t.alpha===e[r+3]},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,r){return this===t||e(t)&&Math.abs(this.red-t.red)<=r&&Math.abs(this.green-t.green)<=r&&Math.abs(this.blue-t.blue)<=r&&Math.abs(this.alpha-t.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var t=s.floatToByte(this.red),e=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+t+","+e+","+r+")":"rgba("+t+","+e+","+r+","+this.alpha+")"},s.prototype.toBytes=function(t){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return e(t)?(t[0]=r,t[1]=n,t[2]=o,t[3]=i,t):[r,n,o,i]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),E[0]},s.prototype.brighten=function(t,e){return t=1-t,e.red=1-(1-this.red)*t,e.green=1-(1-this.green)*t,e.blue=1-(1-this.blue)*t,e.alpha=this.alpha,e},s.prototype.darken=function(t,e){return t=1-t,e.red=this.red*t,e.green=this.green*t,e.blue=this.blue*t,e.alpha=this.alpha,e},s.prototype.withAlpha=function(t,e){return s.fromAlpha(this,t,e)},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),
s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUSCHIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(t){"use strict";var e={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return t(e)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(t,e,r,n,o,i){"use strict";if(!o.supportsTypedArrays())return{};var a={BYTE:t.BYTE,UNSIGNED_BYTE:t.UNSIGNED_BYTE,SHORT:t.SHORT,UNSIGNED_SHORT:t.UNSIGNED_SHORT,FLOAT:t.FLOAT,DOUBLE:t.DOUBLE};return a.getSizeInBytes=function(t){switch(t){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(t){return t instanceof Int8Array?a.BYTE:t instanceof Uint8Array?a.UNSIGNED_BYTE:t instanceof Int16Array?a.SHORT:t instanceof Uint16Array?a.UNSIGNED_SHORT:t instanceof Float32Array?a.FLOAT:t instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(t){return r(t)&&(t===a.BYTE||t===a.UNSIGNED_BYTE||t===a.SHORT||t===a.UNSIGNED_SHORT||t===a.FLOAT||t===a.DOUBLE)},a.createTypedArray=function(t,e){switch(t){case a.BYTE:return new Int8Array(e);case a.UNSIGNED_BYTE:return new Uint8Array(e);case a.SHORT:return new Int16Array(e);case a.UNSIGNED_SHORT:return new Uint16Array(e);case a.FLOAT:return new Float32Array(e);case a.DOUBLE:return new Float64Array(e);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(t,r,o,i){switch(o=e(o,0),i=e(i,(r.byteLength-o)/a.getSizeInBytes(t)),t){case a.BYTE:return new Int8Array(r,o,i);case a.UNSIGNED_BYTE:return new Uint8Array(r,o,i);case a.SHORT:return new Int16Array(r,o,i);case a.UNSIGNED_SHORT:return new Uint16Array(r,o,i);case a.FLOAT:return new Float32Array(r,o,i);case a.DOUBLE:return new Float64Array(r,o,i);default:throw new n("componentDatatype is not a valid value.")}},i(a)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";var e={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return t(e)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(t,e){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(t){return t===r.POINTS||t===r.LINES||t===r.LINE_LOOP||t===r.LINE_STRIP||t===r.TRIANGLES||t===r.TRIANGLE_STRIP||t===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,e,r,n,o){"use strict";function i(e){e=t(e,t.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=t(e.primitiveType,o.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=t(e.geometryType,n.NONE),this.boundingSphereCV=void 0}return i.computeNumberOfVertices=function(t){var n=-1;for(var o in t.attributes)if(t.attributes.hasOwnProperty(o)&&e(t.attributes[o])&&e(t.attributes[o].values)){var i=t.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t,e,r){"use strict";function n(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.values=e.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";function e(e){e=t(e,t.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.binormal=e.binormal,this.tangent=e.tangent,this.color=e.color}return e}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,o){"use strict";var i={UNSIGNED_BYTE:t.UNSIGNED_BYTE,UNSIGNED_SHORT:t.UNSIGNED_SHORT,UNSIGNED_INT:t.UNSIGNED_INT};return i.getSizeInBytes=function(t){switch(t){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(t,e){return t>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},i.createTypedArrayFromArrayBuffer=function(t,e,r,n){return t>=o.SIXTY_FOUR_KILOBYTES?new Uint32Array(e,r,n):new Uint16Array(e,r,n)},n(i)}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(t,e,r,n,o,i,a,s){"use strict";function u(t){var e=t._uSquared,r=t._ellipsoid.maximumRadius,n=t._ellipsoid.minimumRadius,o=(r-n)/r,i=Math.cos(t._startHeading),a=Math.sin(t._startHeading),s=(1-o)*Math.tan(t._start.latitude),u=1/Math.sqrt(1+s*s),E=u*s,l=Math.atan2(s,i),c=u*a,_=c*c,R=1-_,f=Math.sqrt(R),T=e/4,A=T*T,h=A*T,d=A*A,S=1+T-3*A/4+5*h/4-175*d/64,m=1-T+15*A/8-35*h/8,C=1-3*T+35*A/4,N=1-5*T,I=S*l-m*Math.sin(2*l)*T/2-C*Math.sin(4*l)*A/16-N*Math.sin(6*l)*h/48-5*Math.sin(8*l)*d/512,M=t._constants;M.a=r,M.b=n,M.f=o,M.cosineHeading=i,M.sineHeading=a,M.tanU=s,M.cosineU=u,M.sineU=E,M.sigma=l,M.sineAlpha=c,M.sineSquaredAlpha=_,M.cosineSquaredAlpha=R,M.cosineAlpha=f,M.u2Over4=T,M.u4Over16=A,M.u6Over64=h,M.u8Over256=d,M.a0=S,M.a1=m,M.a2=C,M.a3=N,M.distanceRatio=I}function E(t,e){return t*e*(4+t*(4-3*e))/16}function l(t,e,r,n,o,i,a){var s=E(t,r);return(1-s)*t*e*(n+s*o*(a+s*i*(2*a*a-1)))}function c(t,e,r,n,o,i,a){var u,E,c,_,R,f=(e-r)/e,T=i-n,A=Math.atan((1-f)*Math.tan(o)),h=Math.atan((1-f)*Math.tan(a)),d=Math.cos(A),S=Math.sin(A),m=Math.cos(h),C=Math.sin(h),N=d*m,I=d*C,M=S*C,O=S*m,p=T,g=s.TWO_PI,F=Math.cos(p),y=Math.sin(p);do{F=Math.cos(p),y=Math.sin(p);var L=I-O*F;c=Math.sqrt(m*m*y*y+L*L),E=M+N*F,u=Math.atan2(c,E);var v;0===c?(v=0,_=1):(v=N*y/c,_=1-v*v),g=p,R=E-2*M/_,isNaN(R)&&(R=0),p=T+l(f,v,_,u,c,E,R)}while(Math.abs(p-g)>s.EPSILON12);var D=_*(e*e-r*r)/(r*r),U=1+D*(4096+D*(D*(320-175*D)-768))/16384,P=D*(256+D*(D*(74-47*D)-128))/1024,B=R*R,w=P*c*(R+P*(E*(2*B-1)-P*R*(4*c*c-3)*(4*B-3)/6)/4),x=r*U*(u-w),G=Math.atan2(m*y,I-O*F),b=Math.atan2(d*y,I*F-O);t._distance=x,t._startHeading=G,t._endHeading=b,t._uSquared=D}function _(r,n,o,i){t.normalize(i.cartographicToCartesian(n,T),f),t.normalize(i.cartographicToCartesian(o,T),T);c(r,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,o.longitude,o.latitude),r._start=e.clone(n,r._start),r._end=e.clone(o,r._end),r._start.height=0,r._end.height=0,u(r)}function R(t,o,i){var s=r(i,a.WGS84);this._ellipsoid=s,this._start=new e,this._end=new e,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(t)&&n(o)&&_(this,t,o,s)}var f=new t,T=new t;return o(R.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),R.prototype.setEndPoints=function(t,e){_(this,t,e,this._ellipsoid)},R.prototype.interpolateUsingFraction=function(t,e){return this.interpolateUsingSurfaceDistance(this._distance*t,e)},R.prototype.interpolateUsingSurfaceDistance=function(t,r){var o=this._constants,i=o.distanceRatio+t/o.b,a=Math.cos(2*i),s=Math.cos(4*i),u=Math.cos(6*i),E=Math.sin(2*i),c=Math.sin(4*i),_=Math.sin(6*i),R=Math.sin(8*i),f=i*i,T=i*f,A=o.u8Over256,h=o.u2Over4,d=o.u6Over64,S=o.u4Over16,m=2*T*A*a/3+i*(1-h+7*S/4-15*d/4+579*A/64-(S-15*d/4+187*A/16)*a-(5*d/4-115*A/16)*s-29*A*u/16)+(h/2-S+71*d/32-85*A/16)*E+(5*S/16-5*d/4+383*A/96)*c-f*((d-11*A/2)*E+5*A*c/2)+(29*d/96-29*A/16)*_+539*A*R/1536,C=Math.asin(Math.sin(m)*o.cosineAlpha),N=Math.atan(o.a/o.b*Math.tan(C));m-=o.sigma;var I=Math.cos(2*o.sigma+m),M=Math.sin(m),O=Math.cos(m),p=o.cosineU*O,g=o.sineU*M,F=Math.atan2(M*o.sineHeading,p-g*o.cosineHeading),y=F-l(o.f,o.sineAlpha,o.cosineSquaredAlpha,m,M,O,I);return n(r)?(r.longitude=this._start.longitude+y,r.latitude=N,r.height=0,r):new e(this._start.longitude+y,N,0)},R}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(t,e){"use strict";function r(t,r,n){var o=t+r;return e.sign(t)!==e.sign(r)&&Math.abs(o/Math.max(Math.abs(t),Math.abs(r)))<n?0:o}var n={};return n.computeDiscriminant=function(t,e,r){var n=e*e-4*t*r;return n},n.computeRealRoots=function(t,n,o){var i;if(0===t)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),s=Math.abs(t);if(s>a&&a/s<e.EPSILON14)return[0,0];if(a>s&&s/a<e.EPSILON14)return[];if(i=-o/t,0>i)return[];var u=Math.sqrt(i);return[-u,u]}if(0===o)return i=-n/t,0>i?[i,0]:[0,i];var E=n*n,l=4*t*o,c=r(E,-l,e.EPSILON14);if(0>c)return[];var _=-.5*r(n,e.sign(n)*Math.sqrt(c),e.EPSILON14);return n>0?[_/t,o/_]:[o/_,_/t]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(t,e){"use strict";function r(t,e,r,n){var o,i,a=t,s=e/3,u=r/3,E=n,l=a*u,c=s*E,_=s*s,R=u*u,f=a*u-_,T=a*E-s*u,A=s*E-R,h=4*f*A-T*T;if(0>h){var d,S,m;_*c>=l*R?(d=a,S=f,m=-2*s*f+a*T):(d=E,S=A,m=-E*T+2*u*A);var C=0>m?-1:1,N=-C*Math.abs(d)*Math.sqrt(-h);i=-m+N;var I=i/2,M=0>I?-Math.pow(-I,1/3):Math.pow(I,1/3),O=i===N?-M:-S/M;return o=0>=S?M+O:-m/(M*M+O*O+S),_*c>=l*R?[(o-s)/a]:[-E/(o+u)]}var p=f,g=-2*s*f+a*T,F=A,y=-E*T+2*u*A,L=Math.sqrt(h),v=Math.sqrt(3)/2,D=Math.abs(Math.atan2(a*L,-g)/3);o=2*Math.sqrt(-p);var U=Math.cos(D);i=o*U;var P=o*(-U/2-v*Math.sin(D)),B=i+P>2*s?i-s:P-s,w=a,x=B/w;D=Math.abs(Math.atan2(E*L,-y)/3),o=2*Math.sqrt(-F),U=Math.cos(D),i=o*U,P=o*(-U/2-v*Math.sin(D));var G=-E,b=2*u>i+P?i+u:P+u,z=G/b,H=w*b,V=-B*b-w*G,X=B*G,W=(u*V-s*X)/(-s*V+u*H);return W>=x?z>=x?z>=W?[x,W,z]:[x,z,W]:[z,x,W]:z>=x?[W,x,z]:z>=W?[W,z,x]:[z,W,x]}var n={};return n.computeDiscriminant=function(t,e,r,n){var o=t*t,i=e*e,a=r*r,s=n*n,u=18*t*e*r*n+i*a-27*o*s-4*(t*a*r+i*e*n);return u},n.computeRealRoots=function(t,n,o,i){var a,s;if(0===t)return e.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];s=-i/t;var u=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[u,u,u]}return 0===i?(a=e.computeRealRoots(t,0,o),0===a.Length?[0]:[a[0],0,a[1]]):r(t,0,o,i)}return 0===o?0===i?(s=-n/t,0>s?[s,0,0]:[0,0,s]):r(t,n,0,i):0===i?(a=e.computeRealRoots(t,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):r(t,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(t,e,r,n){"use strict";function o(e,o,i,a){var s=e*e,u=o-3*s/8,E=i-o*e/2+s*e/8,l=a-i*e/4+o*s/16-3*s*s/256,c=t.computeRealRoots(1,2*u,u*u-4*l,-E*E);if(c.length>0){var _=-e/4,R=c[c.length-1];if(Math.abs(R)<r.EPSILON14){var f=n.computeRealRoots(1,u,l);if(2===f.length){var T,A=f[0],h=f[1];if(A>=0&&h>=0){var d=Math.sqrt(A),S=Math.sqrt(h);return[_-S,_-d,_+d,_+S]}if(A>=0&&0>h)return T=Math.sqrt(A),[_-T,_+T];if(0>A&&h>=0)return T=Math.sqrt(h),[_-T,_+T]}return[]}if(R>0){var m=Math.sqrt(R),C=(u+R-E/m)/2,N=(u+R+E/m)/2,I=n.computeRealRoots(1,m,C),M=n.computeRealRoots(1,-m,N);return 0!==I.length?(I[0]+=_,I[1]+=_,0!==M.length?(M[0]+=_,M[1]+=_,I[1]<=M[0]?[I[0],I[1],M[0],M[1]]:M[1]<=I[0]?[M[0],M[1],I[0],I[1]]:I[0]>=M[0]&&I[1]<=M[1]?[M[0],I[0],I[1],M[1]]:M[0]>=I[0]&&M[1]<=I[1]?[I[0],M[0],M[1],I[1]]:I[0]>M[0]&&I[0]<M[1]?[M[0],I[0],M[1],I[1]]:[I[0],M[0],I[1],M[1]]):I):0!==M.length?(M[0]+=_,M[1]+=_,M):[]}}return[]}function i(e,o,i,a){var s=i*i,u=o*o,E=e*e,l=-2*o,c=i*e+u-4*a,_=E*a-i*o*e+s,R=t.computeRealRoots(1,l,c,_);if(R.length>0){var f,T,A=R[0],h=o-A,d=h*h,S=e/2,m=h/2,C=d-4*a,N=d+4*Math.abs(a),I=E-4*A,M=E+4*Math.abs(A);if(0>A||I*N>C*M){var O=Math.sqrt(I);f=O/2,T=0===O?0:(e*m-i)/O}else{var p=Math.sqrt(C);f=0===p?0:(e*m-i)/p,T=p/2}var g,F;0===S&&0===f?(g=0,F=0):r.sign(S)===r.sign(f)?(g=S+f,F=A/g):(F=S-f,g=A/F);var y,L;0===m&&0===T?(y=0,L=0):r.sign(m)===r.sign(T)?(y=m+T,L=a/y):(L=m-T,y=a/L);var v=n.computeRealRoots(1,g,y),D=n.computeRealRoots(1,F,L);if(0!==v.length)return 0!==D.length?v[1]<=D[0]?[v[0],v[1],D[0],D[1]]:D[1]<=v[0]?[D[0],D[1],v[0],v[1]]:v[0]>=D[0]&&v[1]<=D[1]?[D[0],v[0],v[1],D[1]]:D[0]>=v[0]&&D[1]<=v[1]?[v[0],D[0],D[1],v[1]]:v[0]>D[0]&&v[0]<D[1]?[D[0],v[0],D[1],v[1]]:[v[0],D[0],v[1],D[1]]:v;if(0!==D.length)return D}return[]}var a={};return a.computeDiscriminant=function(t,e,r,n,o){var i=t*t,a=i*t,s=e*e,u=s*e,E=r*r,l=E*r,c=n*n,_=c*n,R=o*o,f=R*o,T=s*E*c-4*u*_-4*t*l*c+18*t*e*r*_-27*i*c*c+256*a*f+o*(18*u*r*n-4*s*l+16*t*E*E-80*t*e*E*n-6*t*s*c+144*i*r*c)+R*(144*t*s*r-27*s*s-128*i*E-192*i*e*n);
return T},a.computeRealRoots=function(e,n,a,s,u){if(Math.abs(e)<r.EPSILON15)return t.computeRealRoots(n,a,s,u);var E=n/e,l=a/e,c=s/e,_=u/e,R=0>E?1:0;switch(R+=0>l?R+1:R,R+=0>c?R+1:R,R+=0>_?R+1:R){case 0:return o(E,l,c,_);case 1:return i(E,l,c,_);case 2:return i(E,l,c,_);case 3:return o(E,l,c,_);case 4:return o(E,l,c,_);case 5:return i(E,l,c,_);case 6:return o(E,l,c,_);case 7:return o(E,l,c,_);case 8:return i(E,l,c,_);case 9:return o(E,l,c,_);case 10:return o(E,l,c,_);case 11:return i(E,l,c,_);case 12:return o(E,l,c,_);case 13:return o(E,l,c,_);case 14:return o(E,l,c,_);case 15:return o(E,l,c,_);default:return}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(t,e,r,n){"use strict";function o(r,n){n=t.clone(e(n,t.ZERO)),t.equals(n,t.ZERO)||t.normalize(n,n),this.origin=t.clone(e(r,t.ZERO)),this.direction=n}return o.getPoint=function(e,n,o){return r(o)||(o=new t),o=t.multiplyByScalar(e.direction,n,o),t.add(e.origin,o,o)},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(t,e,r,n,o,i,a,s,u,E){"use strict";function l(e,n,o,a,s){s=r(s,!1);var u,E,l,c,_,R=e.origin,f=e.direction,T=t.subtract(o,n,A),C=t.subtract(a,n,h),N=t.cross(f,C,d),I=t.dot(T,N);if(s){if(I<i.EPSILON6)return;if(u=t.subtract(R,n,S),l=t.dot(u,N),0>l||l>I)return;if(E=t.cross(u,T,m),c=t.dot(f,E),0>c||l+c>I)return;_=t.dot(C,E)/I}else{if(Math.abs(I)<i.EPSILON6)return;var M=1/I;if(u=t.subtract(R,n,S),l=t.dot(u,N)*M,0>l||l>1)return;if(E=t.cross(u,T,m),c=t.dot(f,E)*M,0>c||l+c>1)return;_=t.dot(C,E)*M}return _}function c(t,e,r,n){var o=e*e-4*t*r;if(!(0>o)){if(o>0){var i=1/(2*t),a=Math.sqrt(o),s=(-e+a)*i,u=(-e-a)*i;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var E=-e/(2*t);if(0!==E)return n.root0=n.root1=E,n}}function _(e,r,o){n(o)||(o={});var i=e.origin,a=e.direction,s=r.center,u=r.radius*r.radius,E=t.subtract(i,s,d),l=t.dot(a,a),_=2*t.dot(a,E),R=t.magnitudeSquared(E)-u,f=c(l,_,R,N);return n(f)?(o.start=f.root0,o.stop=f.root1,o):void 0}function R(t,e,r){var n=t+e;return i.sign(t)!==i.sign(e)&&Math.abs(n/Math.max(Math.abs(t),Math.abs(e)))<r?0:n}function f(e,r,n,o,E){var l,c=o*o,_=E*E,f=(e[a.COLUMN1ROW1]-e[a.COLUMN2ROW2])*_,T=E*(o*R(e[a.COLUMN1ROW0],e[a.COLUMN0ROW1],i.EPSILON15)+r.y),A=e[a.COLUMN0ROW0]*c+e[a.COLUMN2ROW2]*_+o*r.x+n,h=_*R(e[a.COLUMN2ROW1],e[a.COLUMN1ROW2],i.EPSILON15),d=E*(o*R(e[a.COLUMN2ROW0],e[a.COLUMN0ROW2])+r.z),S=[];if(0===d&&0===h){if(l=s.computeRealRoots(f,T,A),0===l.length)return S;var m=l[0],C=Math.sqrt(Math.max(1-m*m,0));if(S.push(new t(o,E*m,E*-C)),S.push(new t(o,E*m,E*C)),2===l.length){var N=l[1],I=Math.sqrt(Math.max(1-N*N,0));S.push(new t(o,E*N,E*-I)),S.push(new t(o,E*N,E*I))}return S}var M=d*d,O=h*h,p=f*f,g=d*h,F=p+O,y=2*(T*f+g),L=2*A*f+T*T-O+M,v=2*(A*T-g),D=A*A-M;if(0===F&&0===y&&0===L&&0===v)return S;l=u.computeRealRoots(F,y,L,v,D);var U=l.length;if(0===U)return S;for(var P=0;U>P;++P){var B,w=l[P],x=w*w,G=Math.max(1-x,0),b=Math.sqrt(G);B=i.sign(f)===i.sign(A)?R(f*x+A,T*w,i.EPSILON12):i.sign(A)===i.sign(T*w)?R(f*x,T*w+A,i.EPSILON12):R(f*x+T*w,A,i.EPSILON12);var z=R(h*w,d,i.EPSILON15),H=B*z;0>H?S.push(new t(o,E*w,E*b)):H>0?S.push(new t(o,E*w,E*-b)):0!==b?(S.push(new t(o,E*w,E*-b)),S.push(new t(o,E*w,E*b)),++P):S.push(new t(o,E*w,E*b))}return S}var T={};T.rayPlane=function(e,r,o){n(o)||(o=new t);var a=e.origin,s=e.direction,u=r.normal,E=t.dot(u,s);if(!(Math.abs(E)<i.EPSILON15)){var l=(-r.distance-t.dot(u,a))/E;if(!(0>l))return o=t.multiplyByScalar(s,l,o),t.add(a,o,o)}};var A=new t,h=new t,d=new t,S=new t,m=new t;T.rayTriangle=function(e,r,o,i,a,s){var u=l(e,r,o,i,a);if(n(u)&&!(0>u))return n(s)||(s=new t),t.multiplyByScalar(e.direction,u,s),t.add(e.origin,s,s)};var C=new E;T.lineSegmentTriangle=function(e,r,o,i,a,s,u){var E=C;t.clone(e,E.origin),t.subtract(r,e,E.direction),t.normalize(E.direction,E.direction);var c=l(E,o,i,a,s);return!n(c)||0>c||c>t.distance(e,r)?void 0:(n(u)||(u=new t),t.multiplyByScalar(E.direction,c,u),t.add(E.origin,u,u))};var N={root0:0,root1:0};T.raySphere=function(t,e,r){return r=_(t,e,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var I=new E;T.lineSegmentSphere=function(e,r,o,i){var a=I,s=t.subtract(r,e,a.direction),u=t.magnitude(s);return t.normalize(s,s),i=_(a,o,i),!n(i)||i.stop<0||i.start>u?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,u),i)};var M=new t,O=new t;T.rayEllipsoid=function(e,r){var n,o,i,a,s,u=r.oneOverRadii,E=t.multiplyComponents(u,e.origin,M),l=t.multiplyComponents(u,e.direction,O),c=t.magnitudeSquared(E),_=t.dot(E,l);if(c>1){if(_>=0)return;var R=_*_;if(n=c-1,o=t.magnitudeSquared(l),i=o*n,i>R)return;if(R>i){a=_*_-i,s=-_+Math.sqrt(a);var f=s/o,T=n/s;return T>f?{start:f,stop:T}:{start:T,stop:f}}var A=Math.sqrt(n/o);return{start:A,stop:A}}return 1>c?(n=c-1,o=t.magnitudeSquared(l),i=o*n,a=_*_-i,s=-_+Math.sqrt(a),{start:0,stop:s/o}):0>_?(o=t.magnitudeSquared(l),{start:0,stop:-_/o}):void 0};var p=new t,g=new t,F=new t,y=new t,L=new t,v=new a,D=new a,U=new a,P=new a,B=new a,w=new a,x=new a,G=new t,b=new t,z=new e;T.grazingAltitudeLocation=function(e,r){var o=e.origin,s=e.direction,u=r.geodeticSurfaceNormal(o,p);if(t.dot(s,u)>=0)return o;var E=n(this.rayEllipsoid(e,r)),l=r.transformPositionToScaledSpace(s,p),c=t.normalize(l,l),_=t.mostOrthogonalAxis(l,y),R=t.normalize(t.cross(_,c,g),g),T=t.normalize(t.cross(c,R,F),F),A=v;A[0]=c.x,A[1]=c.y,A[2]=c.z,A[3]=R.x,A[4]=R.y,A[5]=R.z,A[6]=T.x,A[7]=T.y,A[8]=T.z;var h=a.transpose(A,D),d=a.fromScale(r.radii,U),S=a.fromScale(r.oneOverRadii,P),m=B;m[0]=0,m[1]=-s.z,m[2]=s.y,m[3]=s.z,m[4]=0,m[5]=-s.x,m[6]=-s.y,m[7]=s.x,m[8]=0;var C,N,I=a.multiply(a.multiply(h,S,w),m,w),M=a.multiply(a.multiply(I,d,x),A,x),O=a.multiplyByVector(I,o,L),H=f(M,t.negate(O,p),0,0,1),V=H.length;if(V>0){for(var X=t.clone(t.ZERO,b),W=Number.NEGATIVE_INFINITY,q=0;V>q;++q){C=a.multiplyByVector(d,a.multiplyByVector(A,H[q],G),G);var Y=t.normalize(t.subtract(C,o,y),y),K=t.dot(Y,s);K>W&&(W=K,X=t.clone(C,X))}var k=r.cartesianToCartographic(X,z);return W=i.clamp(W,0,1),N=t.magnitude(t.subtract(X,o,y))*Math.sqrt(1-W*W),N=E?-N:N,k.height=N,r.cartographicToCartesian(k,new t)}};var H=new t;return T.lineSegmentPlane=function(e,r,o,a){n(a)||(a=new t);var s=t.subtract(r,e,H),u=o.normal,E=t.dot(u,s);if(!(Math.abs(E)<i.EPSILON6)){var l=t.dot(u,e),c=-(o.distance+l)/E;if(!(0>c||c>1))return t.multiplyByScalar(s,c,a),t.add(e,a,a),a}},T.trianglePlaneIntersection=function(e,r,n,o){var i=o.normal,a=o.distance,s=t.dot(i,e)+a<0,u=t.dot(i,r)+a<0,E=t.dot(i,n)+a<0,l=0;l+=s?1:0,l+=u?1:0,l+=E?1:0;var c,_;if((1===l||2===l)&&(c=new t,_=new t),1===l){if(s)return T.lineSegmentPlane(e,r,o,c),T.lineSegmentPlane(e,n,o,_),{positions:[e,r,n,c,_],indices:[0,3,4,1,2,4,1,4,3]};if(u)return T.lineSegmentPlane(r,n,o,c),T.lineSegmentPlane(r,e,o,_),{positions:[e,r,n,c,_],indices:[1,3,4,2,0,4,2,4,3]};if(E)return T.lineSegmentPlane(n,e,o,c),T.lineSegmentPlane(n,r,o,_),{positions:[e,r,n,c,_],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!s)return T.lineSegmentPlane(r,e,o,c),T.lineSegmentPlane(n,e,o,_),{positions:[e,r,n,c,_],indices:[1,2,4,1,4,3,0,3,4]};if(!u)return T.lineSegmentPlane(n,r,o,c),T.lineSegmentPlane(e,r,o,_),{positions:[e,r,n,c,_],indices:[2,0,4,2,4,3,1,3,4]};if(!E)return T.lineSegmentPlane(e,n,o,c),T.lineSegmentPlane(r,n,o,_),{positions:[e,r,n,c,_],indices:[0,1,4,0,4,3,2,3,4]}}},T}),define("Core/isArray",["./defined"],function(t){"use strict";var e=Array.isArray;return t(e)||(e=function(t){return"[object Array]"===Object.prototype.toString.call(t)}),e}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(t,e,r,n,o,i,a,s,u,E,l,c){"use strict";function _(t,e,r){var n=M;n.length=t;var o;if(e===r){for(o=0;t>o;o++)n[o]=e;return n}var i=r-e,a=i/t;for(o=0;t>o;o++){var s=e+o*a;n[o]=s}return n}function R(e,r,n,o,i,a,s,u){var E=o.scaleToGeodeticSurface(e,F),l=o.scaleToGeodeticSurface(r,y),c=f.numberOfPoints(e,r,n),R=o.cartesianToCartographic(E,O),T=o.cartesianToCartographic(l,p),A=_(c,i,a);L.setEndPoints(R,T);var h=L.surfaceDistance/c,d=u;R.height=i;var S=o.cartographicToCartesian(R,g);t.pack(S,s,d),d+=3;for(var m=1;c>m;m++){var C=L.interpolateUsingSurfaceDistance(m*h,p);C.height=A[m],S=o.cartographicToCartesian(C,g),t.pack(S,s,d),d+=3}return d}var f={};f.numberOfPoints=function(e,r,n){var o=t.distance(e,r);return Math.ceil(o/n)};var T=new e;f.extractHeights=function(t,e){for(var r=t.length,n=new Array(r),o=0;r>o;o++){var i=t[o];n[o]=e.cartesianToCartographic(i,T).height}return n};var A=new l,h=new t,d=new t,S=new c(t.ZERO,0),m=new t,C=new c(t.ZERO,0),N=new t,I=new t,M=[],O=new e,p=new e,g=new t,F=new t,y=new t,L=new a;f.wrapLongitude=function(e,o){var i=[],a=[];if(n(e)&&e.length>0){o=r(o,l.IDENTITY);var u=l.inverseTransformation(o,A),E=l.multiplyByPoint(u,t.ZERO,h),_=l.multiplyByPointAsVector(u,t.UNIT_Y,d),R=c.fromPointNormal(E,_,S),f=l.multiplyByPointAsVector(u,t.UNIT_X,m),T=c.fromPointNormal(E,f,C),M=1;i.push(t.clone(e[0]));for(var O=i[0],p=e.length,g=1;p>g;++g){var F=e[g];if(c.getPointDistance(T,O)<0||c.getPointDistance(T,F)<0){var y=s.lineSegmentPlane(O,F,R,N);if(n(y)){var L=t.multiplyByScalar(_,5e-9,I);c.getPointDistance(R,O)<0&&t.negate(L,L),i.push(t.add(y,L,new t)),a.push(M+1),t.negate(L,L),i.push(t.add(y,L,new t)),M=1}}i.push(t.clone(e[g])),M++,O=F}a.push(M)}return{positions:i,lengths:a}};var v=E.EPSILON10;return f.removeDuplicates=function(e){var r=e.length;if(2>r)return e;var n,o,i;for(n=1;r>n&&(o=e[n-1],i=e[n],!t.equalsEpsilon(o,i,v));++n);if(n===r)return e;for(var a=e.slice(0,n);r>n;++n)i=e[n],t.equalsEpsilon(o,i,v)||(a.push(t.clone(i)),o=i);return a},f.generateArc=function(e){n(e)||(e={});var o=e.positions,a=o.length,s=r(e.ellipsoid,i.WGS84),l=r(e.height,0);if(1>a)return[];if(1===a){var c=s.scaleToGeodeticSurface(o[0],F);if(0!==l){var _=s.geodeticSurfaceNormal(c,g);t.multiplyByScalar(_,l,_),t.add(c,_,c)}return[c.x,c.y,c.z]}var T=e.minDistance;if(!n(T)){var A=r(e.granularity,E.RADIANS_PER_DEGREE);T=E.chordLength(A,s.maximumRadius)}var h,d=0;for(h=0;a-1>h;h++)d+=f.numberOfPoints(o[h],o[h+1],T);var S=3*(d+1),m=new Array(S),C=0,N=u(l);for(h=0;a-1>h;h++){var I=o[h],p=o[h+1],y=N?l[h]:l,L=N?l[h+1]:l;C=R(I,p,T,s,y,L,m,C)}M.length=0;var v=o[a-1],D=s.cartesianToCartographic(v,O);D.height=N?l[a-1]:l;var U=s.cartographicToCartesian(D,g);return t.pack(U,m,S-3),m},f.generateCartesianArc=function(e){for(var r=f.generateArc(e),n=r.length/3,o=new Array(n),i=0;n>i;i++)o[i]=t.unpack(r,3*i);return o},f}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,r,n){"use strict";function o(e){e=t(e,t.EMPTY_OBJECT),this.position=t(e.position,!1),this.normal=t(e.normal,!1),this.st=t(e.st,!1),this.binormal=t(e.binormal,!1),this.tangent=t(e.tangent,!1),this.color=t(e.color,!1)}return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(e,r,n){n=t(n,0),r[n++]=e.position?1:0,r[n++]=e.normal?1:0,r[n++]=e.st?1:0,r[n++]=e.binormal?1:0,r[n++]=e.tangent?1:0,r[n++]=e.color?1:0},o.unpack=function(r,n,i){return n=t(n,0),e(i)||(i=new o),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.binormal=1===r[n++],i.tangent=1===r[n++],i.color=1===r[n++],i},o.clone=function(t,r){return e(t)?(e(r)||(r=new o),r.position=t.position,r.normal=t.normal,r.st=t.st,r.binormal=t.binormal,r.tangent=t.tangent,r.color=t.color,r):void 0},o}),define("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(t,e,r,n,o,i,a,s,u,E,l,c,_,R,f,T,A){"use strict";function h(t,e,n,o,i){var a=S;a.length=i;var s,u=n.red,E=n.green,l=n.blue,c=n.alpha,_=o.red,R=o.green,f=o.blue,T=o.alpha;if(r.equals(n,o)){for(s=0;i>s;s++)a[s]=r.clone(n);return a}var A=(_-u)/i,h=(R-E)/i,d=(f-l)/i,m=(T-c)/i;for(s=0;i>s;s++)a[s]=new r(u+s*A,E+s*h,l+s*d,c+s*m);return a}function d(t){t=o(t,o.EMPTY_OBJECT);var n=t.positions,a=t.colors,u=o(t.width,1),E=o(t.colorsPerVertex,!1);this._positions=n,this._colors=a,this._width=u,this._colorsPerVertex=E,this._vertexFormat=A.clone(o(t.vertexFormat,A.DEFAULT)),this._followSurface=o(t.followSurface,!0),this._granularity=o(t.granularity,R.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(o(t.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var l=1+n.length*e.packedLength;l+=i(a)?1+a.length*r.packedLength:1,this.packedLength=l+s.packedLength+A.packedLength+4}var S=[];d.pack=function(t,n,a){a=o(a,0);var u,E=t._positions,l=E.length;for(n[a++]=l,u=0;l>u;++u,a+=e.packedLength)e.pack(E[u],n,a);var c=t._colors;for(l=i(c)?c.length:0,n[a++]=l,u=0;l>u;++u,a+=r.packedLength)r.pack(c[u],n,a);s.pack(t._ellipsoid,n,a),a+=s.packedLength,A.pack(t._vertexFormat,n,a),a+=A.packedLength,n[a++]=t._width,n[a++]=t._colorsPerVertex?1:0,n[a++]=t._followSurface?1:0,n[a]=t._granularity};var m=s.clone(s.UNIT_SPHERE),C=new A,N={positions:void 0,colors:void 0,ellipsoid:m,vertexFormat:C,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};d.unpack=function(t,n,a){n=o(n,0);var u,E=t[n++],l=new Array(E);for(u=0;E>u;++u,n+=e.packedLength)l[u]=e.unpack(t,n);E=t[n++];var c=E>0?new Array(E):void 0;for(u=0;E>u;++u,n+=r.packedLength)c[u]=r.unpack(t,n);var _=s.unpack(t,n,m);n+=s.packedLength;var R=A.unpack(t,n,C);n+=A.packedLength;var f=t[n++],T=1===t[n++],h=1===t[n++],S=t[n];return i(a)?(a._positions=l,a._colors=c,a._ellipsoid=s.clone(_,a._ellipsoid),a._vertexFormat=A.clone(R,a._vertexFormat),a._width=f,a._colorsPerVertex=T,a._followSurface=h,a._granularity=S,a):(N.positions=l,N.colors=c,N.width=f,N.colorsPerVertex=T,N.followSurface=h,N.granularity=S,new d(N))};var I=new e,M=new e,O=new e,p=new e;return d.createGeometry=function(o){var a,s,A,d=o._width,m=o._vertexFormat,C=o._colors,N=o._colorsPerVertex,g=o._followSurface,F=o._granularity,y=o._ellipsoid,L=R.chordLength(F,y.maximumRadius),v=f.removeDuplicates(o._positions),D=v.length;if(!(2>D)){if(g){var U=f.extractHeights(v,y);if(i(C)){var P=1;for(a=0;D-1>a;++a)P+=f.numberOfPoints(v[a],v[a+1],L);var B=new Array(P),w=0;for(a=0;D-1>a;++a){var x=v[a],G=v[a+1],b=C[a],z=f.numberOfPoints(x,G,L);if(N&&P>a){var H=C[a+1],V=h(x,G,b,H,z),X=V.length;for(s=0;X>s;++s)B[w++]=V[s]}else for(s=0;z>s;++s)B[w++]=r.clone(b)}B[w]=r.clone(C[C.length-1]),C=B,S.length=0}v=f.generateCartesianArc({positions:v,minDistance:L,ellipsoid:y,height:U})}D=v.length;var W,q=4*D-4,Y=new Float64Array(3*q),K=new Float64Array(3*q),k=new Float64Array(3*q),Z=new Float32Array(2*q),j=m.st?new Float32Array(2*q):void 0,Q=i(C)?new Uint8Array(4*q):void 0,J=0,$=0,tt=0,et=0;for(s=0;D>s;++s){0===s?(W=I,e.subtract(v[0],v[1],W),e.add(v[0],W,W)):W=v[s-1],e.clone(W,O),e.clone(v[s],M),s===D-1?(W=I,e.subtract(v[D-1],v[D-2],W),e.add(v[D-1],W,W)):W=v[s+1],e.clone(W,p);var rt,nt;i(Q)&&(rt=0===s||N?C[s]:C[s-1],s!==D-1&&(nt=C[s]));var ot=0===s?2:0,it=s===D-1?2:4;for(A=ot;it>A;++A){e.pack(M,Y,J),e.pack(O,K,J),e.pack(p,k,J),J+=3;var at=0>A-2?-1:1;if(Z[$++]=2*(A%2)-1,Z[$++]=at*d,m.st&&(j[tt++]=s/(D-1),j[tt++]=Math.max(Z[$-2],0)),i(Q)){var st=2>A?rt:nt;Q[et++]=r.floatToByte(st.red),Q[et++]=r.floatToByte(st.green),Q[et++]=r.floatToByte(st.blue),Q[et++]=r.floatToByte(st.alpha)}}}var ut=new l;ut.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:Y}),ut.prevPosition=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:K}),ut.nextPosition=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:k}),ut.expandAndWidth=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:Z}),m.st&&(ut.st=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:j})),i(Q)&&(ut.color=new E({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:Q,normalize:!0}));var Et=_.createTypedArray(q,6*D-6),lt=0,ct=0,_t=D-1;for(s=0;_t>s;++s)Et[ct++]=lt,Et[ct++]=lt+2,Et[ct++]=lt+1,Et[ct++]=lt+1,Et[ct++]=lt+2,Et[ct++]=lt+3,lt+=4;return new u({attributes:ut,indices:Et,primitiveType:T.TRIANGLES,boundingSphere:t.fromPoints(v),geometryType:c.POLYLINES})}},d}),define("Workers/createPolylineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineGeometry"],function(t,e,r){"use strict";function n(n,o){return t(o)&&(n=r.unpack(n,o)),n._ellipsoid=e.clone(n._ellipsoid),r.createGeometry(n)}return n})}();