/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},a.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return a>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;e>=n;n++)i.push(r*n);return i[e]},a.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)}i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,f=n*u-a*o;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,r,n,o)};var f=new i,h=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,h);var l=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,l,h),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(h,f,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=a.toRadians(e[o]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=i.fromRadians(u,s,0,r,n[o/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=a.toRadians(e[o]),n[o+1]=a.toRadians(e[o+1]),n[o+2]=e[o+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=i.fromRadians(u,s,c,r,n[o/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function a(r,a,u,s,c){var l=r.x,f=r.y,h=r.z,d=a.x,E=a.y,p=a.z,m=l*l*d*d,y=f*f*E*E,_=h*h*p*p,v=m+y+_,T=Math.sqrt(1/v),R=e.multiplyByScalar(r,T,i);if(s>v)return isFinite(T)?e.clone(R,c):void 0;var A=u.x,S=u.y,g=u.z,N=o;N.x=R.x*A*2,N.y=R.y*S*2,N.z=R.z*g*2;var I,O,M,w,x,C,P,D,L,U,b,F=(1-T)*e.magnitude(r)/(.5*e.magnitude(N)),z=0;do{F-=z,M=1/(1+F*A),w=1/(1+F*S),x=1/(1+F*g),C=M*M,P=w*w,D=x*x,L=C*M,U=P*w,b=D*x,I=m*C+y*P+_*D-1,O=m*L*A+y*U*S+_*b*g;var B=-2*O;z=I/B}while(Math.abs(I)>n.EPSILON12);return t(c)?(c.x=l*M,c.y=f*w,c.z=h*x,c):new e(l*M,f*w,h*x)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,n,a,i){return a=t(a,0),r(i)?(i.longitude=e,i.latitude=n,i.height=a,i):new u(e,n,a)},u.fromDegrees=function(e,t,r,n){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,r,n)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=i.EPSILON1;return u.fromCartesian=function(t,n,a){var E=r(n)?n.oneOverRadii:f,p=r(n)?n.oneOverRadiiSquared:h,m=r(n)?n._centerToleranceSquared:d,y=o(t,E,p,m,c);if(r(y)){var _=e.multiplyComponents(t,p,s);_=e.normalize(_,_);var v=e.subtract(t,y,l),T=Math.atan2(_.y,_.x),R=Math.asin(_.z),A=i.sign(e.dot(v,t))*e.magnitude(v);return r(a)?(a.longitude=T,a.latitude=R,a.height=A,a):new u(T,R,A)}},u.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,c(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(n(t)){var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return n(t)||(t=new l),n(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,n,a){a=r(a,0),e.pack(t._radii,n,a)},l.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var f=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var a=f,i=h;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,E=new e,p=new e;return l.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,E);if(n(i)){var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(r,i,p),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)}function u(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[o.getElementIndex(d[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function c(e,t){for(var r=i.EPSILON15,n=0,a=1,u=0;3>u;++u){var s=Math.abs(e[o.getElementIndex(d[u],h[u])]);s>n&&(a=u,n=s)}var c=1,l=0,f=h[a],E=d[a];if(Math.abs(e[o.getElementIndex(E,f)])>r){var p,m=e[o.getElementIndex(E,E)],y=e[o.getElementIndex(f,f)],_=e[o.getElementIndex(E,f)],v=(m-y)/2/_;p=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),c=1/Math.sqrt(1+p*p),l=p*c}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(f,f)]=t[o.getElementIndex(E,E)]=c,t[o.getElementIndex(E,f)]=l,t[o.getElementIndex(f,E)]=-l,t}o.packedLength=9,o.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a[4]=e[n++],a[5]=e[n++],a[6]=e[n++],a[7]=e[n++],a[8]=e[n++],a},o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,E=n-s-f+d,p=2*(a-h),m=2*(i+l),y=2*(a+h),_=-n+s-f+d,v=2*(c-u),T=2*(i-l),R=2*(c+u),A=-n-s+f+d;return r(t)?(t[0]=E,t[1]=y,t[2]=T,t[3]=p,t[4]=_,t[5]=R,t[6]=m,t[7]=v,t[8]=A,t):new o(E,p,m,y,_,v,T,R,A)},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new o(1,0,0,0,n,-a,0,a,n)},o.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new o(n,0,a,0,1,0,-a,0,n)},o.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(n,-a,0,a,n,0,0,0,1)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},o.setColumn=function(e,t,r,n){n=o.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},o.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},o.setRow=function(e,t,r,n){return n=o.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;o.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;o.getMaximumScale=function(t){return o.getScale(t,f),e.maximumComponent(f)},o.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},o.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},o.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},o.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},o.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},o.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],d=[2,2,1],E=new o,p=new o;return o.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,a=10,l=0,f=0;r(t)||(t={});for(var h=t.unitary=o.clone(o.IDENTITY,t.unitary),d=t.diagonal=o.clone(e,t.diagonal),m=n*u(d);a>f&&s(d)>m;)c(d,E),o.transpose(E,p),o.multiply(d,E,d),o.multiply(p,d,d),o.multiply(h,E,h),++l>2&&(++f,l=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},o.inverse=function(e,t){var r=e[0],a=e[1],u=e[2],s=e[3],c=e[4],l=e[5],f=e[6],h=e[7],d=e[8],E=o.determinant(e);if(Math.abs(E)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=c*d-h*l,t[1]=h*u-a*d,t[2]=a*l-c*u,t[3]=f*l-s*d,t[4]=r*d-f*u,t[5]=s*u-r*l,t[6]=s*h-f*c,t[7]=f*a-r*h,t[8]=r*c-s*a;var p=1/E;return o.multiplyByScalar(t,p,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},o.IDENTITY=a(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=a(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r,n,a){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(a,0)}i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)&&a.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(e,t,n,a,i,o,u,s,c,l,f,h,d,E,p,m){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(E,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(h,0),this[15]=r(m,0)}c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=r(a,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,a){n(a)||(a=new c);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,d=t.y*t.y,E=t.y*t.z,p=t.y*t.w,m=t.z*t.z,y=t.z*t.w,_=t.w*t.w,v=s-d-m+_,T=2*(l-y),R=2*(f+p),A=2*(l+y),S=-s+d-m+_,g=2*(E-h),N=2*(f-p),I=2*(E+h),O=-s-d+m+_;return a[0]=v*i,a[1]=A*i,a[2]=N*i,a[3]=0,a[4]=T*o,a[5]=S*o,a[6]=I*o,a[7]=0,a[8]=R*u,a[9]=g*u,a[10]=O*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,r){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,E=l.x,p=l.y,m=l.z,y=h.x,_=h.y,v=h.z,T=a.x,R=a.y,A=a.z,S=u*-T+s*-R+d*-A,g=y*-T+_*-R+v*-A,N=E*T+p*R+m*A;
return n(r)?(r[0]=u,r[1]=y,r[2]=-E,r[3]=0,r[4]=s,r[5]=_,r[6]=-p,r[7]=0,r[8]=d,r[9]=v,r[10]=-m,r[11]=0,r[12]=S,r[13]=g,r[14]=N,r[15]=1,r):new c(u,s,d,S,y,_,v,g,-E,-p,-m,N,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,f=-(n+r)*s,h=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+a)/(i-a),h=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,h=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),h=c,d=l,E=f,p=i+c,m=o+l,y=t+f,_=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=p,a[13]=m,a[14]=y,a[15]=_,a},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var d=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),r};var E=new e;c.getMaximumScale=function(t){return c.getScale(t,E),e.maximumComponent(E)},c.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],E=e[11],p=e[12],m=e[13],y=e[14],_=e[15],v=t[0],T=t[1],R=t[2],A=t[3],S=t[4],g=t[5],N=t[6],I=t[7],O=t[8],M=t[9],w=t[10],x=t[11],C=t[12],P=t[13],D=t[14],L=t[15],U=n*v+u*T+f*R+p*A,b=a*v+s*T+h*R+m*A,F=i*v+c*T+d*R+y*A,z=o*v+l*T+E*R+_*A,B=n*S+u*g+f*N+p*I,G=a*S+s*g+h*N+m*I,q=i*S+c*g+d*N+y*I,W=o*S+l*g+E*N+_*I,H=n*O+u*M+f*w+p*x,X=a*O+s*M+h*w+m*x,V=i*O+c*M+d*w+y*x,Y=o*O+l*M+E*w+_*x,k=n*C+u*P+f*D+p*L,Z=a*C+s*P+h*D+m*L,j=i*C+c*P+d*D+y*L,K=o*C+l*P+E*D+_*L;return r[0]=U,r[1]=b,r[2]=F,r[3]=z,r[4]=B,r[5]=G,r[6]=q,r[7]=W,r[8]=H,r[9]=X,r[10]=V,r[11]=Y,r[12]=k,r[13]=Z,r[14]=j,r[15]=K,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],E=e[14],p=t[0],m=t[1],y=t[2],_=t[4],v=t[5],T=t[6],R=t[8],A=t[9],S=t[10],g=t[12],N=t[13],I=t[14],O=n*p+o*m+c*y,M=a*p+u*m+l*y,w=i*p+s*m+f*y,x=n*_+o*v+c*T,C=a*_+u*v+l*T,P=i*_+s*v+f*T,D=n*R+o*A+c*S,L=a*R+u*A+l*S,U=i*R+s*A+f*S,b=n*g+o*N+c*I+h,F=a*g+u*N+l*I+d,z=i*g+s*N+f*I+E;return r[0]=O,r[1]=M,r[2]=w,r[3]=0,r[4]=x,r[5]=C,r[6]=P,r[7]=0,r[8]=D,r[9]=L,r[10]=U,r[11]=0,r[12]=b,r[13]=F,r[14]=z,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],E=t[2],p=t[3],m=t[4],y=t[5],_=t[6],v=t[7],T=t[8],R=n*h+o*d+c*E,A=a*h+u*d+l*E,S=i*h+s*d+f*E,g=n*p+o*m+c*y,N=a*p+u*m+l*y,I=i*p+s*m+f*y,O=n*_+o*v+c*T,M=a*_+u*v+l*T,w=i*_+s*v+f*T;return r[0]=R,r[1]=A,r[2]=S,r[3]=0,r[4]=g,r[5]=N,r[6]=I,r[7]=0,r[8]=O,r[9]=M,r[10]=w,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var p=new e;c.multiplyByUniformScale=function(e,t,r){return p.x=t,p.y=t,p.z=t,c.multiplyByScale(e,p,r)},c.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new u,y=new u,_=new t,v=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,m),y,o.EPSILON7)&&t.equals(c.getRow(e,3,_),v))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],l=e[12],f=e[1],h=e[5],d=e[9],E=e[13],p=e[2],T=e[6],R=e[10],A=e[14],S=e[3],g=e[7],N=e[11],I=e[15],O=R*I,M=A*N,w=T*I,x=A*g,C=T*N,P=R*g,D=p*I,L=A*S,U=p*N,b=R*S,F=p*g,z=T*S,B=O*h+x*d+C*E-(M*h+w*d+P*E),G=M*f+D*d+b*E-(O*f+L*d+U*E),q=w*f+L*h+F*E-(x*f+D*h+z*E),W=P*f+U*h+z*d-(C*f+b*h+F*d),H=M*a+w*i+P*l-(O*a+x*i+C*l),X=O*n+L*i+U*l-(M*n+D*i+b*l),V=x*n+D*a+z*l-(w*n+L*a+F*l),Y=C*n+b*a+F*i-(P*n+U*a+z*i);O=i*E,M=l*d,w=a*E,x=l*h,C=a*d,P=i*h,D=n*E,L=l*f,U=n*d,b=i*f,F=n*h,z=a*f;var k=O*g+x*N+C*I-(M*g+w*N+P*I),Z=M*S+D*N+b*I-(O*S+L*N+U*I),j=w*S+L*g+F*I-(x*S+D*g+z*I),K=P*S+U*g+z*N-(C*S+b*g+F*N),J=w*R+P*A+M*T-(C*A+O*T+x*R),Q=U*A+O*p+L*R-(D*R+b*A+M*p),$=D*T+z*A+x*p-(F*A+w*p+L*T),ee=F*R+C*p+b*T-(U*T+z*R+P*p),te=n*B+a*G+i*q+l*W;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=B*te,r[1]=G*te,r[2]=q*te,r[3]=W*te,r[4]=H*te,r[5]=X*te,r[6]=V*te,r[7]=Y*te,r[8]=k*te,r[9]=Z*te,r[10]=j*te,r[11]=K*te,r[12]=J*te,r[13]=Q*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],E=-r*f-n*h-a*d,p=-i*f-o*h-u*d,m=-s*f-c*h-l*d;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=p,t[14]=m,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t,r){this.normal=e.clone(t),this.distance=r}a.fromPointNormal=function(r,n,i){var o=-e.dot(n,r);return t(i)?(e.clone(n,i.normal),i.distance=o,i):new a(n,o)};var i=new e;return a.fromCartesian4=function(r,n){var o=e.fromCartesian4(r,i),u=r.w;return t(n)?(e.clone(o,n.normal),n.distance=u,n):new a(o,u)},a.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},a.ORIGIN_XY_PLANE=n(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=n(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=n(new a(e.UNIT_Y,0)),a}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,r,n,a){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(a,0)}n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,a,i,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),r(o)?(o.west=e,o.south=n,o.east=a,o.north=i,o):new s(e,n,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,h=e.length;h>f;f++){var d=e[f];n=Math.min(n,d.longitude),a=Math.max(a,d.longitude),c=Math.min(c,d.latitude),l=Math.max(l,d.latitude);var E=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;i=Math.min(i,E),o=Math.max(o,E)}return a-n>o-i&&(n=i,a=o,a>u.PI&&(a-=u.TWO_PI),n>u.PI&&(n-=u.TWO_PI)),r(t)?(t.west=n,t.south=c,t.east=a,t.north=l,t):new s(n,c,a,l)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&l>=f)){var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(h>=d))return r(n)?(n.west=l,n.south=h,n.east=f,n.north=d,n):new s(l,h,f,d)}},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,a,o){n=t(n,i.WGS84),a=t(a,0),r(o)||(o=[]);var l=0,f=e.north,h=e.south,d=e.east,E=e.west,p=c;p.height=a,p.longitude=E,p.latitude=f,o[l]=n.cartographicToCartesian(p,o[l]),l++,p.longitude=d,o[l]=n.cartographicToCartesian(p,o[l]),l++,p.latitude=h,o[l]=n.cartographicToCartesian(p,o[l]),l++,p.longitude=E,o[l]=n.cartographicToCartesian(p,o[l]),l++,0>f?p.latitude=f:h>0?p.latitude=h:p.latitude=0;for(var m=1;8>m;++m)p.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,p)&&(o[l]=n.cartographicToCartesian(p,o[l]),l++);return 0===p.latitude&&(p.longitude=E,o[l]=n.cartographicToCartesian(p,o[l]),l++,p.longitude=d,o[l]=n.cartographicToCartesian(p,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l,f,h){"use strict";function d(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)}var E=new e,p=new e,m=new e,y=new e,_=new e,v=new e,T=new e,R=new e,A=new e,S=new e,g=new e,N=new e;d.fromPoints=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var a=e.clone(t[0],T),i=e.clone(a,E),o=e.clone(a,p),u=e.clone(a,m),s=e.clone(a,y),c=e.clone(a,_),l=e.clone(a,v),f=t.length,h=1;f>h;h++){e.clone(t[h],a);var I=a.x,O=a.y,M=a.z;I<i.x&&e.clone(a,i),I>s.x&&e.clone(a,s),O<o.y&&e.clone(a,o),O>c.y&&e.clone(a,c),M<u.z&&e.clone(a,u),M>l.z&&e.clone(a,l)}var w=e.magnitudeSquared(e.subtract(s,i,R)),x=e.magnitudeSquared(e.subtract(c,o,R)),C=e.magnitudeSquared(e.subtract(l,u,R)),P=i,D=s,L=w;x>L&&(L=x,P=o,D=c),C>L&&(L=C,P=u,D=l);var U=A;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var b=e.magnitudeSquared(e.subtract(D,U,R)),F=Math.sqrt(b),z=S;z.x=i.x,z.y=o.y,z.z=u.z;var B=g;B.x=s.x,B.y=c.y,B.z=l.z;var G=e.multiplyByScalar(e.add(z,B,R),.5,N),q=0;for(h=0;f>h;h++){e.clone(t[h],a);var W=e.magnitude(e.subtract(a,G,R));W>q&&(q=W);var H=e.magnitudeSquared(e.subtract(a,U,R));if(H>b){var X=Math.sqrt(H);F=.5*(F+X),b=F*F;var V=X-F;U.x=(F*U.x+V*a.x)/X,U.y=(F*U.y+V*a.y)/X,U.z=(F*U.z+V*a.z)/X}}return q>F?(e.clone(U,r.center),r.radius=F):(e.clone(G,r.center),r.radius=q),r};var I=new o,O=new e,M=new e,w=new t,x=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,a,i,o,u){if(n(u)||(u=new d),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=r(a,I),h.southwest(t,w),w.height=i,h.northeast(t,x),x.height=o;var s=a.project(w,O),c=a.project(x,M),l=c.x-s.x,f=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+E*E);var p=u.center;return p.x=s.x+.5*l,p.y=s.y+.5*f,p.z=s.z+.5*E,u};var C=[];d.fromRectangle3D=function(e,t,a,o){t=r(t,i.WGS84),a=r(a,0);var u;return n(e)&&(u=h.subsample(e,t,a,C)),d.fromPoints(u,o)},d.fromVertices=function(t,a,i,o){if(n(o)||(o=new d),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=r(a,e.ZERO),i=r(i,3);var u=T;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,E),c=e.clone(u,p),l=e.clone(u,m),f=e.clone(u,y),h=e.clone(u,_),I=e.clone(u,v),O=t.length,M=0;O>M;M+=i){var w=t[M]+a.x,x=t[M+1]+a.y,C=t[M+2]+a.z;u.x=w,u.y=x,u.z=C,w<s.x&&e.clone(u,s),w>f.x&&e.clone(u,f),x<c.y&&e.clone(u,c),x>h.y&&e.clone(u,h),C<l.z&&e.clone(u,l),C>I.z&&e.clone(u,I)}var P=e.magnitudeSquared(e.subtract(f,s,R)),D=e.magnitudeSquared(e.subtract(h,c,R)),L=e.magnitudeSquared(e.subtract(I,l,R)),U=s,b=f,F=P;D>F&&(F=D,U=c,b=h),L>F&&(F=L,U=l,b=I);var z=A;z.x=.5*(U.x+b.x),z.y=.5*(U.y+b.y),z.z=.5*(U.z+b.z);var B=e.magnitudeSquared(e.subtract(b,z,R)),G=Math.sqrt(B),q=S;q.x=s.x,q.y=c.y,q.z=l.z;var W=g;W.x=f.x,W.y=h.y,W.z=I.z;var H=e.multiplyByScalar(e.add(q,W,R),.5,N),X=0;for(M=0;O>M;M+=i){u.x=t[M]+a.x,u.y=t[M+1]+a.y,u.z=t[M+2]+a.z;var V=e.magnitude(e.subtract(u,H,R));V>X&&(X=V);var Y=e.magnitudeSquared(e.subtract(u,z,R));if(Y>B){var k=Math.sqrt(Y);G=.5*(G+k),B=G*G;var Z=k-G;z.x=(G*z.x+Z*u.x)/k,z.y=(G*z.y+Z*u.y)/k,z.z=(G*z.z+Z*u.z)/k}}return X>G?(e.clone(z,o.center),o.radius=G):(e.clone(H,o.center),o.radius=X),o},d.fromCornerPoints=function(t,r,a){n(a)||(a=new d);var i=a.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,r),a},d.fromEllipsoid=function(t,r){return n(r)||(r=new d),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var P=new e;d.fromBoundingSpheres=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=t.length;if(1===a)return d.clone(t[0],r);if(2===a)return d.union(t[0],t[1],r);for(var i=[],o=0;a>o;o++)i.push(t[o].center);r=d.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var D=new e,L=new e,U=new e;d.fromOrientedBoundingBox=function(t,r){n(r)||(r=new d);var a=t.halfAxes,i=c.getColumn(a,0,D),o=c.getColumn(a,1,L),u=c.getColumn(a,2,U),s=e.magnitude(i),l=e.magnitude(o),f=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,l,f),r},d.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,n){n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},d.unpack=function(e,t,a){t=r(t,0),n(a)||(a=new d);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var b=new e,F=new e;d.union=function(t,r,a){n(a)||(a=new d);var i=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,b),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return r.clone(a),a;var f=.5*(o+l+s),h=e.multiplyByScalar(c,(-o+f)/l,F);return e.add(h,i,h),e.clone(h,a.center),a.radius=f,a};var z=new e;d.expand=function(t,r,n){n=d.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,z));return a>n.radius&&(n.radius=a),n},d.intersectPlane=function(t,r){var n=t.center,a=t.radius,i=r.normal,o=e.dot(i,n)+r.distance;return-a>o?u.OUTSIDE:a>o?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var B=new e;d.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,B);return e.magnitudeSquared(n)-t.radius*t.radius},d.transformWithoutScale=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var G=new e;d.computePlaneDistances=function(t,r,a,i){n(i)||(i=new s);var o=e.subtract(t.center,r,G),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var q=new e,W=new e,H=new e,X=new e,V=new e,Y=new t,k=new Array(8),Z=0;8>Z;++Z)k[Z]=new e;var j=new o;return d.projectTo2D=function(t,n,a){n=r(n,j);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,q),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,H);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,V),h=e.negate(c,X),E=k,p=E[0];e.add(s,l,p),e.add(p,c,p),p=E[1],e.add(s,l,p),e.add(p,h,p),p=E[2],e.add(s,f,p),e.add(p,h,p),p=E[3],e.add(s,f,p),e.add(p,c,p),e.negate(s,s),p=E[4],e.add(s,l,p),e.add(p,c,p),p=E[5],e.add(s,l,p),e.add(p,h,p),p=E[6],e.add(s,f,p),e.add(p,h,p),p=E[7],e.add(s,f,p),e.add(p,c,p);for(var m=E.length,y=0;m>y;++y){var _=E[y];e.add(o,_,_);var v=i.cartesianToCartographic(_,Y);n.project(v,_)}a=d.fromPoints(E,a),o=a.center;var T=o.x,R=o.y,A=o.z;return o.x=A,o.y=T,o.z=R,a},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,
RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?n.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(n.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[n.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(y=!0,_=n(e[1]))}return y}function i(){return a()&&_}function o(){if(!t(v)&&(v=!1,!a()&&/ Safari\/[\.0-9]+/.test(m.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(v=!0,T=n(e[1]))}return v}function u(){return o()&&T}function s(){if(!t(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(m.userAgent);null!==e&&(R=!0,A=n(e[1]),A.isNightly=!!e[2])}return R}function c(){return s()&&A}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===m.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(S=!0,g=n(e[1]))):"Netscape"===m.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(S=!0,g=n(e[1])))}return S}function f(){return l()&&g}function h(){if(!t(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(N=!0,I=n(e[1]))}return N}function d(){return t(O)||(O=/Windows/i.test(m.appVersion)),O}function E(){return h()&&I}function p(){return t(M)||(M="undefined"!=typeof PointerEvent&&(!t(m.pointerEnabled)||m.pointerEnabled)),M}var m;m="undefined"!=typeof navigator?navigator:{};var y,_,v,T,R,A,S,g,N,I,O,M,w={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:E,isWindows:d,hardwareConcurrency:e(m.hardwareConcurrency,3),supportsPointerEvents:p};return w.supportsFullscreen=function(){return r.supportsFullscreen()},w.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},w.supportsWebWorkers=function(){return"undefined"!=typeof Worker},w}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return r(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,r,a,i){switch(a=t(a,0),i=t(i,(r.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(r,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(r,a,i);case o.SHORT:return new Int16Array(r,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(r,a,i);case o.FLOAT:return new Float32Array(r,a,i);case o.DOUBLE:return new Float64Array(r,a,i);default:throw new n("componentDatatype is not a valid value.")}},i(o)}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,r,n,a){"use strict";function i(n,a,i){this.minimum=e.clone(t(n,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),r(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i}i.fromPoints=function(t,n){if(r(n)||(n=new i),!r(t)||0===t.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var d=t[h],E=d.x,p=d.y,m=d.z;a=Math.min(E,a),s=Math.max(E,s),o=Math.min(p,o),c=Math.max(p,c),u=Math.min(m,u),l=Math.max(m,l)}var y=n.minimum;y.x=a,y.y=o,y.z=u;var _=n.maximum;_.x=s,_.y=c,_.z=l;var v=e.add(y,_,n.center);return e.multiplyByScalar(v,.5,v),n},i.clone=function(t,n){return r(t)?r(n)?(n.minimum=e.clone(t.minimum,n.minimum),n.maximum=e.clone(t.maximum,n.maximum),n.center=e.clone(t.center,n.center),n):new i(t.minimum,t.maximum):void 0},i.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&e.equals(t.minimum,n.minimum)&&e.equals(t.maximum,n.maximum)};var o=new e;return i.intersectPlane=function(t,r){o=e.subtract(t.maximum,t.minimum,o);var n=e.multiplyByScalar(o,.5,o),i=r.normal,u=n.x*Math.abs(i.x)+n.y*Math.abs(i.y)+n.z*Math.abs(i.z),s=e.dot(t.center,i)+r.distance;return s-u>0?a.INSIDE:0>s+u?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r){this.x=e(t,0),this.y=e(r,0)}i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*a,f=r(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[h/e,a/h]:[a/h,h/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,h=u*u,d=s*s,E=o*s-h,p=o*c-u*s,m=u*c-d,y=4*E*m-p*p;if(0>y){var _,v,T;h*f>=l*d?(_=o,v=E,T=-2*u*E+o*p):(_=c,v=m,T=-c*p+2*s*m);var R=0>T?-1:1,A=-R*Math.abs(_)*Math.sqrt(-y);i=-T+A;var S=i/2,g=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),N=i===A?-g:-v/g;return a=0>=v?g+N:-T/(g*g+N*N+v),h*f>=l*d?[(a-u)/o]:[-c/(a+s)]}var I=E,O=-2*u*E+o*p,M=m,w=-c*p+2*s*m,x=Math.sqrt(y),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-O)/3);a=2*Math.sqrt(-I);var D=Math.cos(P);i=a*D;var L=a*(-D/2-C*Math.sin(P)),U=i+L>2*u?i-u:L-u,b=o,F=U/b;P=Math.abs(Math.atan2(c*x,-w)/3),a=2*Math.sqrt(-M),D=Math.cos(P),i=a*D,L=a*(-D/2-C*Math.sin(P));var z=-c,B=2*s>i+L?i+s:L+s,G=z/B,q=b*B,W=-U*B-b*z,H=U*z,X=(s*W-u*H)/(-u*W+s*q);return X>=F?G>=F?G>=X?[F,X,G]:[F,G,X]:[G,F,X]:G>=F?[X,F,G]:G>=X?[X,G,F]:[G,X,F]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<r.EPSILON14){var E=n.computeRealRoots(1,s,l);if(2===E.length){var p,m=E[0],y=E[1];if(m>=0&&y>=0){var _=Math.sqrt(m),v=Math.sqrt(y);return[h-v,h-_,h+_,h+v]}if(m>=0&&0>y)return p=Math.sqrt(m),[h-p,h+p];if(0>m&&y>=0)return p=Math.sqrt(y),[h-p,h+p]}return[]}if(d>0){var T=Math.sqrt(d),R=(s+d-c/T)/2,A=(s+d+c/T)/2,S=n.computeRealRoots(1,T,R),g=n.computeRealRoots(1,-T,A);return 0!==S.length?(S[0]+=h,S[1]+=h,0!==g.length?(g[0]+=h,g[1]+=h,S[1]<=g[0]?[S[0],S[1],g[0],g[1]]:g[1]<=S[0]?[g[0],g[1],S[0],S[1]]:S[0]>=g[0]&&S[1]<=g[1]?[g[0],S[0],S[1],g[1]]:g[0]>=S[0]&&g[1]<=S[1]?[S[0],g[0],g[1],S[1]]:S[0]>g[0]&&S[0]<g[1]?[g[0],S[0],g[1],S[1]]:[S[0],g[0],S[1],g[1]]):S):0!==g.length?(g[0]+=h,g[1]+=h,g):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,h=c*o-i*a*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var E,p,m=d[0],y=a-m,_=y*y,v=t/2,T=y/2,R=_-4*o,A=_+4*Math.abs(o),S=c-4*m,g=c+4*Math.abs(m);if(0>m||S*A>R*g){var N=Math.sqrt(S);E=N/2,p=0===N?0:(t*T-i)/N}else{var I=Math.sqrt(R);E=0===I?0:(t*T-i)/I,p=I/2}var O,M;0===v&&0===E?(O=0,M=0):r.sign(v)===r.sign(E)?(O=v+E,M=m/O):(M=v-E,O=m/M);var w,x;0===T&&0===p?(w=0,x=0):r.sign(T)===r.sign(p)?(w=T+p,x=o/w):(x=T-p,w=o/x);var C=n.computeRealRoots(1,O,w),P=n.computeRealRoots(1,M,x);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,h=f*n,d=a*a,E=d*a,p=u*c*f-4*s*h-4*e*l*f+18*e*t*r*h-27*i*f*f+256*o*E+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+d*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return p},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,f=u/t,h=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return a(c,l,f,h);case 1:return i(c,l,f,h);case 2:return i(c,l,f,h);case 3:return a(c,l,f,h);case 4:return a(c,l,f,h);case 5:return i(c,l,f,h);case 6:return a(c,l,f,h);case 7:return a(c,l,f,h);case 8:return i(c,l,f,h);case 9:return a(c,l,f,h);case 10:return a(c,l,f,h);case 11:return i(c,l,f,h);case 12:return a(c,l,f,h);case 13:return a(c,l,f,h);case 14:return a(c,l,f,h);case 15:return a(c,l,f,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return a.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,n,a,o,u){u=r(u,!1);var s,c,l,f,h,d=t.origin,E=t.direction,p=e.subtract(a,n,m),R=e.subtract(o,n,y),A=e.cross(E,R,_),S=e.dot(p,A);if(u){if(S<i.EPSILON6)return;if(s=e.subtract(d,n,v),l=e.dot(s,A),0>l||l>S)return;if(c=e.cross(s,p,T),f=e.dot(E,c),0>f||l+f>S)return;h=e.dot(R,c)/S}else{if(Math.abs(S)<i.EPSILON6)return;var g=1/S;if(s=e.subtract(d,n,v),l=e.dot(s,A)*g,0>l||l>1)return;if(c=e.cross(s,p,T),f=e.dot(E,c)*g,0>f||l+f>1)return;h=e.dot(R,c)*g}return h}function f(e,t,r,n){var a=t*t-4*e*r;if(!(0>a)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function h(t,r,a){n(a)||(a={});var i=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,_),l=e.dot(o,o),h=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,E=f(l,h,d,A);return n(E)?(a.start=E.root0,a.stop=E.root1,a):void 0}function d(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function E(t,r,n,a,c){var l,f=a*a,h=c*c,E=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*h,p=c*(a*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+r.y),m=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*h+a*r.x+n,y=h*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),_=c*(a*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),v=[];if(0===_&&0===y){if(l=u.computeRealRoots(E,p,m),0===l.length)return v;var T=l[0],R=Math.sqrt(Math.max(1-T*T,0));if(v.push(new e(a,c*T,c*-R)),v.push(new e(a,c*T,c*R)),2===l.length){var A=l[1],S=Math.sqrt(Math.max(1-A*A,0));v.push(new e(a,c*A,c*-S)),v.push(new e(a,c*A,c*S))}return v}var g=_*_,N=y*y,I=E*E,O=_*y,M=I+N,w=2*(p*E+O),x=2*m*E+p*p-N+g,C=2*(m*p-O),P=m*m-g;if(0===M&&0===w&&0===x&&0===C)return v;l=s.computeRealRoots(M,w,x,C,P);var D=l.length;if(0===D)return v;for(var L=0;D>L;++L){var U,b=l[L],F=b*b,z=Math.max(1-F,0),B=Math.sqrt(z);U=i.sign(E)===i.sign(m)?d(E*F+m,p*b,i.EPSILON12):i.sign(m)===i.sign(p*b)?d(E*F,p*b+m,i.EPSILON12):d(E*F+p*b,m,i.EPSILON12);var G=d(y*b,_,i.EPSILON15),q=U*G;0>q?v.push(new e(a,c*b,c*B)):q>0?v.push(new e(a,c*b,c*-B)):0!==B?(v.push(new e(a,c*b,c*-B)),v.push(new e(a,c*b,c*B)),++L):v.push(new e(a,c*b,c*B))}return v}var p={};p.rayPlane=function(t,r,a){n(a)||(a=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON15)){var l=(-r.distance-e.dot(s,o))/c;if(!(0>l))return a=e.multiplyByScalar(u,l,a),e.add(o,a,a)}};var m=new e,y=new e,_=new e,v=new e,T=new e;p.rayTriangle=function(t,r,a,i,o,u){var s=l(t,r,a,i,o);if(n(s)&&!(0>s))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var R=new c;p.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=R;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var A={root0:0,root1:0};p.raySphere=function(e,t,r){return r=h(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var S=new c;p.lineSegmentSphere=function(t,r,a,i){var o=S,u=e.subtract(r,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=h(o,a,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var g=new e,N=new e;p.rayEllipsoid=function(t,r){var n,a,i,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,g),l=e.multiplyComponents(s,t.direction,N),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return;var d=h*h;if(n=f-1,a=e.magnitudeSquared(l),i=a*n,i>d)return;if(d>i){o=h*h-i,u=-h+Math.sqrt(o);var E=u/a,p=n/u;return p>E?{start:E,stop:p}:{start:p,stop:E}}var m=Math.sqrt(n/a);return{start:m,stop:m}}return 1>f?(n=f-1,a=e.magnitudeSquared(l),i=a*n,o=h*h-i,u=-h+Math.sqrt(o),{start:0,stop:u/a}):0>h?(a=e.magnitudeSquared(l),{start:0,stop:-h/a}):void 0};var I=new e,O=new e,M=new e,w=new e,x=new e,C=new o,P=new o,D=new o,L=new o,U=new o,b=new o,F=new o,z=new e,B=new e,G=new t;p.grazingAltitudeLocation=function(t,r){var a=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(a,I);if(e.dot(u,s)>=0)return a;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,I),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(h,f,O),O),p=e.normalize(e.cross(f,d,M),M),m=C;m[0]=f.x,m[1]=f.y,m[2]=f.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=p.x,m[7]=p.y,m[8]=p.z;var y=o.transpose(m,P),_=o.fromScale(r.radii,D),v=o.fromScale(r.oneOverRadii,L),T=U;T[0]=0,T[1]=-u.z,T[2]=u.y,T[3]=u.z,T[4]=0,T[5]=-u.x,T[6]=-u.y,T[7]=u.x,T[8]=0;var R,A,S=o.multiply(o.multiply(y,v,b),T,b),g=o.multiply(o.multiply(S,_,F),m,F),N=o.multiplyByVector(S,a,x),q=E(g,e.negate(N,I),0,0,1),W=q.length;if(W>0){for(var H=e.clone(e.ZERO,B),X=Number.NEGATIVE_INFINITY,V=0;W>V;++V){R=o.multiplyByVector(_,o.multiplyByVector(m,q[V],z),z);var Y=e.normalize(e.subtract(R,a,w),w),k=e.dot(Y,u);k>X&&(X=k,H=e.clone(R,H))}var Z=r.cartesianToCartographic(H,G);return X=i.clamp(X,0,1),A=e.magnitude(e.subtract(H,a,w))*Math.sqrt(1-X*X),A=c?-A:A,Z.height=A,r.cartographicToCartesian(Z,new e)}};var q=new e;return p.lineSegmentPlane=function(t,r,a,o){n(o)||(o=new e);var u=e.subtract(r,t,q),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON6)){var l=e.dot(s,t),f=-(a.distance+l)/c;if(!(0>f||f>1))return e.multiplyByScalar(u,f,o),e.add(t,o,o),o}},p.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return p.lineSegmentPlane(t,r,a,f),p.lineSegmentPlane(t,n,a,h),{positions:[t,r,n,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return p.lineSegmentPlane(r,n,a,f),p.lineSegmentPlane(r,t,a,h),{positions:[t,r,n,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(n,t,a,f),p.lineSegmentPlane(n,r,a,h),{positions:[t,r,n,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return p.lineSegmentPlane(r,t,a,f),p.lineSegmentPlane(n,t,a,h),{positions:[t,r,n,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return p.lineSegmentPlane(n,r,a,f),p.lineSegmentPlane(t,r,a,h),{positions:[t,r,n,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,n,a,f),p.lineSegmentPlane(r,n,a,h),{positions:[t,r,n,f,h],indices:[0,1,4,0,4,3,2,3,4]}}},p}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,a){return t(e).then(r,n,a)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=a(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function a(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(a){return i(a)}});return r}function o(){function e(e,t,r){return h(e,t,r)}function r(e){return E(e)}function a(e){return E(i(e))}function u(e){return d(e)}var s,c,l,f,h,d,E;return c=new n(e),s={then:e,resolve:r,reject:a,progress:u,promise:c,resolver:{resolve:r,reject:a,progress:u}},l=[],f=[],h=function(e,t,r){var n,a;return n=o(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,a)}),f.push(a),n.promise},d=function(e){return p(f,e),e},E=function(e){return e=t(e),h=e.then,E=t,d=y,p(l,e),f=l=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,a,i){return m(2,arguments),e(t,function(t){function u(e){p(e)}function s(e){E(e)}var c,l,f,h,d,E,p,m,_,v;if(_=t.length>>>0,c=Math.max(0,Math.min(r,_)),f=[],l=_-c+1,h=[],d=o(),c)for(m=d.progress,p=function(e){h.push(e),--l||(E=p=y,d.reject(h))},E=function(e){f.push(e),--c||(E=p=y,d.resolve(f))},v=0;_>v;++v)v in t&&e(t[v],s,u,m);else d.resolve(f);return d.then(n,a,i)})}function c(e,t,r,n){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,r,n)}function l(e,t,r,n){return m(1,arguments),h(e,_).then(t,r,n)}function f(){return h(arguments,_)}function h(t,r){return e(t,function(t){var n,a,i,u,s,c;if(i=a=t.length>>>0,n=[],c=o(),i)for(u=function(t,a){e(t,r).then(function(e){n[a]=e,--i||c.resolve(n)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function d(t,r){var n=T.call(arguments,1);return e(t,function(t){var a;return a=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,a)})})},v.apply(t,n)})}function E(t,r,n){var a=arguments.length>2;return e(t,function(e){return e=a?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function p(e,t){for(var r,n=0;r=e[n++];)r(t)}function m(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function _(e){return e}var v,T,R;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=E,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(R,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(R,t)})})}},T=[].slice,v=[].reduce||function(e){var t,r,n,a,i;if(i=0,t=Object(this),a=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=a)throw new TypeError}else n=r[1];for(;a>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e,t,r){for(var n,a,i=0,o=e.length-1;o>=i;)if(n=~~((i+o)/2),a=r(e[n],t),0>a)i=n+1;else{if(!(a>0))return n;o=n-1}return~(o+1)}return r}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=a}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],a=function(e,t,r,n){r||(r=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+a:a+e},i=function(e,t,r,n,i,o){var u=n-e.length;return u>0&&(e=r||!i?a(e,n,o,r):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+a(c.toString(t),u||0,"0",!1),i(e,r,n,o,s)},u=function(e,t,r,n,a,o){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,a,o)},s=function(e,n,s,c,l,f,h){var d,E,p,m,y;if("%%"==e)return"%";for(var _=!1,v="",T=!1,R=!1,A=" ",S=s.length,g=0;s&&S>g;g++)switch(s.charAt(g)){case" ":v=" ";break;case"+":v="+";break;case"-":_=!0;break;case"'":A=s.charAt(g+1);break;case"0":T=!0;break;case"#":R=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,y=n?t[n.slice(0,-1)]:t[r++],h){case"s":return u(String(y),_,c,f,T,A);case"c":return u(String.fromCharCode(+y),_,c,f,T);case"b":return o(y,2,R,_,c,f,T);case"o":return o(y,8,R,_,c,f,T);case"x":return o(y,16,R,_,c,f,T);case"X":return o(y,16,R,_,c,f,T).toUpperCase();case"u":return o(y,10,R,_,c,f,T);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),E=0>d?"-":v,y=E+a(String(Math.abs(d)),f,"0",!1),i(y,E,_,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,E=0>d?"-":v,p=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],y=E+Math.abs(d)[p](f),i(y,E,_,c,T)[m]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,a,i,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){
"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(e,t){return p.compare(e.julianDate,t.julianDate)}function f(e){v.julianDate=e;var r=p.leapSeconds,n=t(r,v,l);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var a=r[n].offset;if(n>0){var i=p.secondsDifference(r[n].julianDate,e);i>a&&(n--,a=r[n].offset)}p.addSeconds(e,a,e)}function h(e,r){v.julianDate=e;var n=p.leapSeconds,a=t(n,v,l);if(0>a&&(a=~a),0===a)return p.addSeconds(e,-n[0].offset,r);if(a>=n.length)return p.addSeconds(e,-n[a-1].offset,r);var i=p.secondsDifference(n[a].julianDate,e);return 0===i?p.addSeconds(e,-n[a].offset,r):1>=i?void 0:p.addSeconds(e,-n[--a].offset,r)}function d(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var f=i+(n*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function p(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,d(a,t,this),n===c.UTC&&f(this)}var m=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],_=29,v=new u,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,A=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,N=/([Z+\-])?(\d{2})?:?(\d{2})?$/,I=/^(\d{2})(\.\d+)?/.source+N.source,O=/^(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,M=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,w="Invalid ISO 8601 date.";p.fromDate=function(e,t){var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(d(r[0],r[1],t),f(t),t):new p(r[0],r[1],c.UTC)},p.fromIso8601=function(e,t){e=e.replace(",",".");var r,i,u,s=e.split("T"),l=1,h=1,m=0,v=0,N=0,x=0,C=s[0],P=s[1];if(!n(C))throw new a(w);var D;if(s=C.match(g),null!==s){if(D=C.split("-").length-1,D>0&&2!==D)throw new a(w);r=+s[1],l=+s[2],h=+s[3]}else if(s=C.match(R),null!==s)r=+s[1],l=+s[2];else if(s=C.match(T),null!==s)r=+s[1];else{var L;if(s=C.match(A),null!==s){if(r=+s[1],L=+s[2],u=o(r),1>L||u&&L>366||!u&&L>365)throw new a(w)}else{if(s=C.match(S),null===s)throw new a(w);r=+s[1];var U=+s[2],b=+s[3]||0;if(D=C.split("-").length-1,D>0&&(!n(s[3])&&1!==D||n(s[3])&&2!==D))throw new a(w);var F=new Date(Date.UTC(r,0,4));L=7*U+b-F.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(L),l=i.getUTCMonth()+1,h=i.getUTCDate()}if(u=o(r),1>l||l>12||1>h||(2!==l||!u)&&h>y[l-1]||u&&2===l&&h>_)throw new a(w);var z;if(n(P)){if(s=P.match(M),null!==s){if(D=P.split(":").length-1,D>0&&2!==D&&3!==D)throw new a(w);m=+s[1],v=+s[2],N=+s[3],x=1e3*+(s[4]||0),z=5}else if(s=P.match(O),null!==s){if(D=P.split(":").length-1,D>2)throw new a(w);m=+s[1],v=+s[2],N=60*+(s[3]||0),z=4}else{if(s=P.match(I),null===s)throw new a(w);m=+s[1],v=60*+(s[2]||0),z=3}if(v>=60||N>=61||m>24||24===m&&(v>0||N>0||x>0))throw new a(w);var B=s[z],G=+s[z+1],q=+(s[z+2]||0);switch(B){case"+":m-=G,v-=q;break;case"-":m+=G,v+=q;break;case"Z":break;default:v+=new Date(Date.UTC(r,l-1,h,m,v)).getTimezoneOffset()}}else v+=new Date(r,l-1,h).getTimezoneOffset();var W=60===N;for(W&&N--;v>=60;)v-=60,m++;for(;m>=24;)m-=24,h++;for(i=u&&2===l?_:y[l-1];h>i;)h-=i,l++,l>12&&(l-=12,r++),i=u&&2===l?_:y[l-1];for(;0>v;)v+=60,m--;for(;0>m;)m+=24,h--;for(;1>h;)l--,1>l&&(l+=12,r--),i=u&&2===l?_:y[l-1],h+=i;var H=E(r,l,h,m,v,N,x);return n(t)?(d(H[0],H[1],t),f(t)):t=new p(H[0],H[1],c.UTC),W&&p.addSeconds(t,1,t),t},p.now=function(e){return p.fromDate(new Date,e)};var x=new p(0,0,c.TAI);return p.toGregorianDate=function(e,t){var r=!1,a=h(e,x);n(a)||(p.addSeconds(e,-1,x),a=h(x,x),r=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var d=80*c/2447|0,E=c-(2447*d/80|0)|0;c=d/11|0;var m=d+2-12*c|0,y=100*(l-49)+f+c|0,_=u/s.SECONDS_PER_HOUR|0,v=u-_*s.SECONDS_PER_HOUR,T=v/s.SECONDS_PER_MINUTE|0;v-=T*s.SECONDS_PER_MINUTE;var R=0|v,A=(v-R)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(R+=1),n(t)?(t.year=y,t.month=m,t.day=E,t.hour=_,t.minute=T,t.second=R,t.millisecond=A,t.isLeapSecond=r,t):new i(y,m,E,_,T,R,A,r)},p.toDate=function(e){var t=p.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},p.toIso8601=function(t,r){var a,i=p.toGregorianDate(t,i);return n(r)||0===i.millisecond?n(r)&&0!==r?(a=(.01*i.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},p.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new p(e.dayNumber,e.secondsOfDay,c.TAI):void 0},p.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},p.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},p.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(p.secondsDifference(e,t))<=r},p.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},p.secondsDifference=function(e,t){var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},p.daysDifference=function(e,t){var r=e.dayNumber-t.dayNumber,n=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+n},p.computeTaiMinusUtc=function(e){v.julianDate=e;var r=p.leapSeconds,n=t(r,v,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},p.addSeconds=function(e,t,r){return d(e.dayNumber,e.secondsOfDay+t,r)},p.addMinutes=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,n,r)},p.addHours=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,n,r)},p.addDays=function(e,t,r){var n=e.dayNumber+t;return d(n,e.secondsOfDay,r)},p.lessThan=function(e,t){return p.compare(e,t)<0},p.lessThanOrEquals=function(e,t){return p.compare(e,t)<=0},p.greaterThan=function(e,t){return p.compare(e,t)>0},p.greaterThanOrEquals=function(e,t){return p.compare(e,t)>=0},p.prototype.clone=function(e){return p.clone(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.equalsEpsilon=function(e,t){return p.equalsEpsilon(this,e,t)},p.prototype.toString=function(){return p.toIso8601(this)},p.leapSeconds=[new u(new p(2441317,43210,c.TAI),10),new u(new p(2441499,43211,c.TAI),11),new u(new p(2441683,43212,c.TAI),12),new u(new p(2442048,43213,c.TAI),13),new u(new p(2442413,43214,c.TAI),14),new u(new p(2442778,43215,c.TAI),15),new u(new p(2443144,43216,c.TAI),16),new u(new p(2443509,43217,c.TAI),17),new u(new p(2443874,43218,c.TAI),18),new u(new p(2444239,43219,c.TAI),19),new u(new p(2444786,43220,c.TAI),20),new u(new p(2445151,43221,c.TAI),21),new u(new p(2445516,43222,c.TAI),22),new u(new p(2446247,43223,c.TAI),23),new u(new p(2447161,43224,c.TAI),24),new u(new p(2447892,43225,c.TAI),25),new u(new p(2448257,43226,c.TAI),26),new u(new p(2448804,43227,c.TAI),27),new u(new p(2449169,43228,c.TAI),28),new u(new p(2449534,43229,c.TAI),29),new u(new p(2450083,43230,c.TAI),30),new u(new p(2450630,43231,c.TAI),31),new u(new p(2451179,43232,c.TAI),32),new u(new p(2453736,43233,c.TAI),33),new u(new p(2454832,43234,c.TAI),34),new u(new p(2456109,43235,c.TAI),35),new u(new p(2457204,43236,c.TAI),36)],p}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var a=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n&&(o=t(o,n)),a[i]=o}return a}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var a=r[n],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,r,n,a,i){"use strict";function o(r){r=t(r,t.EMPTY_OBJECT);var n=r.responseType,a=t(r.method,"GET"),i=r.data,u=r.headers,s=r.overrideMimeType;return e(r.url,function(t){var r=e.defer();return o.load(t,n,a,i,u,r,s),r.promise})}function u(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function s(e,t){for(var r=u(e,t),n=new ArrayBuffer(r.length),a=new Uint8Array(n),i=0;i<r.length;i++)a[i]=r.charCodeAt(i);return n}function c(e,r){r=t(r,"");var a=e[1],i=!!e[2],o=e[3];switch(r){case"":case"text":return u(i,o);case"arraybuffer":return s(i,o);case"blob":var c=s(i,o);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(u(i,o),a);case"json":return JSON.parse(u(i,o));default:throw new n("Unhandled responseType: "+r)}}var l=/^data:(.*?)(;base64)?,(.*)$/;return o.load=function(e,t,n,o,u,s,f){var h=l.exec(e);if(null!==h)return void s.resolve(c(h,t));var d=new XMLHttpRequest;if(r(f)&&r(d.overrideMimeType)&&d.overrideMimeType(f),d.open(n,e,!0),r(u))for(var E in u)u.hasOwnProperty(E)&&d.setRequestHeader(E,u[E]);r(t)&&(d.responseType=t),d.onload=function(){d.status>=200&&d.status<300?r(d.response)?s.resolve(d.response):r(d.responseXML)&&d.responseXML.hasChildNodes()?s.resolve(d.responseXML):r(d.responseText)?s.resolve(d.responseText):s.reject(new i("unknown XMLHttpRequest response type.")):s.reject(new a(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){s.reject(new a)},d.send(o)},o.defaultLoad=o.load,o}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,headers:r})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,n){"use strict";function a(r,a){return t(a)?t(a.Accept)||(a=e(a),a.Accept=i.Accept):a=i,n(r,a).then(function(e){return JSON.parse(e)})}var i={Accept:"application/json,*/*;q=0.01"};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function h(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))E(this,t.data);else if(n(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){E(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else E(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function E(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),h=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>h||0>E||0>p)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=r.samples,y=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=p,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,v=e._addNewLeapSeconds,T=0,R=m.length;R>T;T+=e._columnCount){var A=m[T+a],S=m[T+p],g=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new o(g,S,f.TAI);if(y.push(N),v){if(S!==_&&n(_)){var I=o.leapSeconds,O=t(I,N,d);if(0>O){var M=new u(N,S);I.splice(~O,0,M)}}_=S}}}function p(e,t,r,n,a){var i=r*n;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function y(e,t,r,n,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||n.equals(c))return p(e,r,a,s,u),u;if(n.equals(l))return p(e,r,i,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),h=a*s,d=i*s,E=r[h+e._ut1MinusUtcSecondsColumn],y=r[d+e._ut1MinusUtcSecondsColumn],_=y-E;if(_>.5||-.5>_){var v=r[h+e._taiMinusUtcSecondsColumn],T=r[d+e._taiMinusUtcSecondsColumn];v!==T&&(l.equals(n)?E=y:y-=T-v)}return u.xPoleWander=m(f,r[h+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[h+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[h+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[h+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,E,y),u}return h.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new a(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=i[u],h=i[u+1],d=o.lessThanOrEquals(f,e),E=!n(h),p=E||o.greaterThanOrEquals(h,e);if(d&&p)return s=u,!E&&h.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,r),r}var m=t(i,e,o.compare,this._dateColumn);return m>=0?(m<i.length-1&&i[m+1].equals(e)&&++m,s=m,l=m):(l=~m,s=l-1,0>s&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},h}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,n){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),a=h.exec(n);if(null!==a)return a[1]}}function i(){if(t(c))return c;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(n))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return c=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}function s(e){t(l)||(l=t(n.toUrl)?o:u),t(f)||(f=document.createElement("a"));var r=l(e);return f.href=r,f.href=f.href,f.href}var c,l,f,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return s._cesiumScriptRegex=h,s.setBaseUrl=function(t){c=new e(t).resolve(new e(document.location.href))},s}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){n[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(n[s]*=s-c);n[s]=1/n[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function l(r,a){if(r._chunkDownloadsInProgress[a])return r._chunkDownloadsInProgress[a];var i=e.defer();r._chunkDownloadsInProgress[a]=i;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){r._chunkDownloadsInProgress[a]=!1;for(var t=r._samples,n=e.samples,o=a*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[o+u]=n[u];i.resolve()}),i.promise}var f=new i(0,0,u.TAI);return s.prototype.preload=function(t,r,n,a){var i=c(this,t,r),o=c(this,n,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,d=[],E=f;h>=E;++E)d.push(l(this,E));return e.all(d)},s.prototype.computeXysRadians=function(e,t,r){var i=c(this,e,t);if(!(0>i)){var o=i/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,0>s&&(s=0));var h=!1,d=this._samples;if(n(d[3*s])||(l(this,s/this._samplesPerXysFile|0),h=!0),n(d[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),!h){n(r)?(r.x=0,r.y=0,r.s=0):r=new a(0,0,0);var E,p,m=i-s*this._stepSizeDays,y=this._work,_=this._denominators,v=this._coef,T=this._xTable;for(E=0;u>=E;++E)y[E]=m-T[E];for(E=0;u>=E;++E){for(v[E]=1,p=0;u>=p;++p)p!==E&&(v[E]*=y[p]);v[E]*=_[E];var R=3*(s+E);r.x+=v[E]*d[R++],r.y+=v[E]*d[R++],r.s+=v[E]*d[R]}return r}}}},s}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)}var c=new e;s.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,h=Math.cos(i);return r(a)?(a.x=u,a.y=l,a.z=f,a.w=h,a):new s(u,l,f,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var n,a,i,o,c,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],p=h+d+E;if(p>0)n=Math.sqrt(p+1),c=.5*n,n=.5/n,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var m=l,y=0;d>h&&(y=1),E>h&&E>d&&(y=2);var _=m[y],v=m[_];n=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(v,v)]+1);var T=f;T[y]=.5*n,n=.5/n,c=(e[u.getElementIndex(v,_)]-e[u.getElementIndex(_,v)])*n,T[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*n,T[v]=(e[u.getElementIndex(v,y)]+e[u.getElementIndex(y,v)])*n,a=-T[0],i=-T[1],o=-T[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var h=new s;s.fromHeadingPitchRoll=function(t,r,n,a){var i=s.fromAxisAngle(e.UNIT_X,n,h),o=s.fromAxisAngle(e.UNIT_Y,-r,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,h);return s.multiply(u,a,a)};var d=new e,E=new e,p=new s,m=new s,y=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.x=e[n],a.y=e[n+1],a.z=e[n+2],a.w=e[n+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,y),s.conjugate(y,y);for(var a=0,i=r-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),p),s.multiply(p,y,p),p.w<0&&s.negate(p,p),s.computeAxis(p,d);var u=s.computeAngle(p);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(n,4*i,m),0===u?s.clone(s.IDENTITY,p):s.fromAxisAngle(E,u,p),s.multiply(p,m,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+n*l+a*c-i*s,h=o*s-n*c+a*l+i*u,d=o*c+n*s-a*u+i*l,E=o*l-n*u-a*s-i*c;return r.x=f,r.y=h,r.z=d,r.w=E,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,t,r,n){return _=s.multiplyByScalar(t,r,_),n=s.multiplyByScalar(e,1-r,n),s.add(_,n,n)};var v=new s,T=new s,R=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=v=s.negate(t,v)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return T=s.multiplyByScalar(e,Math.sin((1-r)*u),T),R=s.multiplyByScalar(i,Math.sin(r*u),R),n=s.add(T,R,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var A=new e,S=new e,g=new s,N=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,g);s.multiply(i,n,N);var o=s.log(N,A);s.multiply(i,t,N);var u=s.log(N,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,g),s.multiply(r,g,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,g),u=s.slerp(r,n,a,N);return s.slerp(o,u,2*a*(1-a),i)};for(var I=new s,O=1.9011074535173003,M=a.supportsTypedArrays()?new Float32Array(8):[],w=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var D=P+1,L=2*D+1;M[P]=1/(D*L),w[P]=D/L}return M[7]=O/136,w[7]=8*O/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,f=7;f>=0;--f)x[f]=(M[f]*c-w[f])*o,C[f]=(M[f]*l-w[f])*o;var h=a*r*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),d=u*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),E=s.multiplyByScalar(e,d,I);return s.multiplyByScalar(t,h,n),s.add(E,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,g),u=s.fastSlerp(r,n,a,N);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E,p,m,y){"use strict";var _={},v=new r,T=new r,R=new r;_.eastNorthUpToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-o,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=s.x,n[1]=s.y,n[2]=s.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var A=new r,S=new r,g=new r;_.northEastDownToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=A,s=S,l=g;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=o,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=v,s=T,l=R;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=u.x,n[5]=u.y,n[6]=u.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new p(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var N=new m,I=new r(1,1,1),O=new p;_.headingPitchRollToFixedFrame=function(e,t,n,a,i,o){var u=m.fromHeadingPitchRoll(t,n,a,N),s=p.fromTranslationQuaternionRotationScale(r.ZERO,u,I,O);return o=_.eastNorthUpToFixedFrame(e,i,o),p.multiply(o,s,o)};var M=new p,w=new E;_.headingPitchRollQuaternion=function(e,t,r,n,a,i){var o=_.headingPitchRollToFixedFrame(e,t,r,n,a,M),u=p.getRotation(o,w);return m.fromRotationMatrix(u,i)};var x=24110.54841,C=8640184.812866,P=.093104,D=-62e-7,L=1.1772758384668e-19,U=72921158553e-15,b=d.TWO_PI/86400,F=new h;_.computeTemeToPseudoFixedMatrix=function(e,t){F=h.addSeconds(e,-h.computeTaiMinusUtc(e),F);var r,n=F.dayNumber,a=F.secondsOfDay,o=n-2451545;r=a>=43200?(o+.5)/y.DAYS_PER_JULIAN_CENTURY:(o-.5)/y.DAYS_PER_JULIAN_CENTURY;var u=x+r*(C+r*(P+r*D)),s=u*b%d.TWO_PI,c=U+L*(n-2451545.5),l=(a+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,f=s+c*l,p=Math.cos(f),m=Math.sin(f);return i(t)?(t[0]=p,t[1]=-m,t[2]=0,t[3]=m,t[4]=p,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(p,m,0,-m,p,0,0,0,1)},_.iau2006XysData=new l,
_.earthOrientationParameters=u.NONE;var z=32.184,B=2451545;_.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+z,a=t.stop.dayNumber,i=t.stop.secondsOfDay+z,o=_.iau2006XysData.preload(r,n,a,i),u=_.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},_.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new E);var r=_.computeFixedToIcrfMatrix(e,t);if(i(r))return E.transpose(r,t)};var G=new f(0,0,0),q=new s(0,0,0,0,0,0),W=new E,H=new E;_.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new E);var r=_.earthOrientationParameters.compute(e,q);if(i(r)){var n=e.dayNumber,a=e.secondsOfDay+z,o=_.iau2006XysData.computeXysRadians(n,a,G);if(i(o)){var u=o.x+r.xPoleOffset,s=o.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=W;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=E.fromRotationZ(-o.s,H),p=E.multiply(l,f,W),m=e.dayNumber,v=e.secondsOfDay-h.computeTaiMinusUtc(e)+r.ut1MinusUtc,T=m-2451545,R=v/y.SECONDS_PER_DAY,A=.779057273264+R+.00273781191135448*(T+R);A=A%1*d.TWO_PI;var S=E.fromRotationZ(A,H),g=E.multiply(p,S,W),N=Math.cos(r.xPoleWander),I=Math.cos(r.yPoleWander),O=Math.sin(r.xPoleWander),M=Math.sin(r.yPoleWander),w=n-B+a/y.SECONDS_PER_DAY;w/=36525;var x=-47e-6*w*d.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),D=H;return D[0]=N*C,D[1]=N*P,D[2]=O,D[3]=-I*P+M*O*C,D[4]=I*C+M*O*P,D[5]=-M*N,D[6]=-M*P-I*O*C,D[7]=M*C-I*O*P,D[8]=I*N,E.multiply(g,D,t)}}};var X=new n;_.pointToWindowCoordinates=function(e,t,r,n){return n=_.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,r,a,o){i(o)||(o=new t);var u=X;return p.multiplyByVector(e,n.fromElements(a.x,a.y,a.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),p.multiplyByVector(r,u,u),t.fromCartesian4(u,o)};var V=new r,Y=new r,k=new r;return _.rotationMatrixFromPositionVelocity=function(e,t,n,o){var u=a(n,c.WGS84).geodeticSurfaceNormal(e,V),s=r.cross(t,u,Y);r.equalsEpsilon(s,r.ZERO,d.EPSILON6)&&(s=r.clone(r.UNIT_X,s));var l=r.cross(s,t,k);return r.cross(t,l,s),r.negate(s,s),i(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},_}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E){"use strict";function p(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var n=E.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(f.getColumn(n,0,m)),this._yAxis=r.fromCartesian4(f.getColumn(n,1,m));var i=r.fromCartesian4(f.getColumn(n,2,m));this._plane=h.fromPointNormal(e,i)}var m=new n;o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var y=new e;p.fromPoints=function(t,r){var n=e.fromPoints(t,y);return new p(n.center,r)};var _=new d,v=new r;p.prototype.projectPointOntoPlane=function(e,n){var a=_;a.origin=e,r.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,v);if(i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v)),i(o)){var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return i(n)?(n.x=s,n.y=l,n):new t(s,l)}},p.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var o=this.projectPointOntoPlane(e[a],t[r]);i(o)&&(t[r]=o,r++)}return t.length=r,t},p.prototype.projectPointToNearestOnPlane=function(e,n){i(n)||(n=new t);var a=_;a.origin=e,r.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,v);i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,v));var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return n.x=s,n.y=l,n},p.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;r>n;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var T=new r;return p.prototype.projectPointsOntoEllipsoid=function(e,t){var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=T,l=0;n>l;++l){var f=e[l];r.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new r);var h=r.add(o,c,t[l]);r.multiplyByScalar(s,f.y,c),r.add(h,c,h),a.scaleToGeocentricSurface(h,h)}return t},p}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0}return i.computeNumberOfVertices=function(e){var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*a.signNotZero(r),t.y=(1-Math.abs(r))*a.signNotZero(n)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=a.fromSNorm(e),n.y=a.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*a.signNotZero(i),n.y=(1-Math.abs(i))*a.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(n,a,s,c,l){r(l)||(l=new t);var f,h,d,E,p,m,y,_;r(a.z)?(f=t.subtract(s,a,i),h=t.subtract(c,a,o),d=t.subtract(n,a,u),E=t.dot(f,f),p=t.dot(f,h),m=t.dot(f,d),y=t.dot(h,h),_=t.dot(h,d)):(f=e.subtract(s,a,i),h=e.subtract(c,a,o),d=e.subtract(n,a,u),E=e.dot(f,f),p=e.dot(f,h),m=e.dot(f,d),y=e.dot(h,h),_=e.dot(h,d));var v=1/(E*y-p*p);return l.y=(y*m-p*_)*v,l.z=(E*_-p*m)*v,l.x=1-l.y-l.z,l}var i=new t,o=new t,u=new t;return a}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var a={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var i=r.high,o=r.low;return n.encode(e.x,a),i.x=a.high,o.x=a.low,n.encode(e.y,a),i.y=a.high,o.y=a.low,n.encode(e.z,a),i.z=a.high,o.z=a.low,r};var i=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,i);var a=i.high,o=i.low;t[r]=a.x,t[r+1]=a.y,t[r+2]=a.z,t[r+3]=o.x,t[r+4]=o.y,t[r+5]=o.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,n){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,n):new Uint16Array(t,r,n)},n(i)}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];o>u;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var f=i+1,h=0;o>h;++h)f-c[n[h]]>i&&(c[n[h]]=f,++f);return(f-i+1)/(o/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var h=r[f];a[h].numLiveTriangles&&(s=0,i-a[h].timeStamp+2*a[h].numLiveTriangles<=t&&(s=i-a[h].timeStamp),(s>l||-1===l)&&(l=s,c=h)),++f}return-1===c?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,f=0,h=o[f],d=c;if(t(u))l=u+1;else{for(;d>f;)h>l&&(l=h),++f,h=o[f];if(-1===l)return 0;++l}for(var E=[],p=0;l>p;p++)E[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var m=0;d>f;)E[o[f]].vertexTriangles.push(m),++E[o[f]].numLiveTriangles,E[o[f+1]].vertexTriangles.push(m),++E[o[f+1]].numLiveTriangles,E[o[f+2]].vertexTriangles.push(m),++E[o[f+2]].numLiveTriangles,++m,f+=3;var y=0,_=s+1;i=1;var v,T,R=[],A=[],S=0,g=[],N=c/3,I=[];for(p=0;N>p;p++)I[p]=!1;for(var O,M;-1!==y;){R=[],T=E[y],M=T.vertexTriangles.length;for(var w=0;M>w;++w)if(m=T.vertexTriangles[w],!I[m]){I[m]=!0,f=m+m+m;for(var x=0;3>x;++x)O=o[f],R.push(O),A.push(O),g[S]=O,++S,v=E[O],--v.numLiveTriangles,_-v.timeStamp>s&&(v.timeStamp=_,++_),++f}y=a(o,s,R,E,_,A,l)}return g},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E,p,m,y,_,v,T,R,A,S,g,N){"use strict";function I(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function O(e){for(var t=e.length,r=t/3*6,n=y.createTypedArray(t,r),a=0,i=0;t>i;i+=3,a+=6)I(n,a,e[i],e[i+1],e[i+2]);return n}function M(e){var t=e.length;if(t>=3){var r=6*(t-2),n=y.createTypedArray(t,r);I(n,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)I(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function w(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=y.createTypedArray(t,r),a=e[0],i=0,o=1;t>o;++o,i+=6)I(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function x(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new E({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function C(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),A.multiplyByPoint(e,ie,ie),a.pack(ie,r,i)}function D(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),R.multiplyByVector(e,ie,ie),ie=a.normalize(ie,ie),a.pack(ie,r,i)}function L(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,f=1;n>f;++f){var h=e[f][t].attributes[r];if(!c(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(a[r]=new E({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function U(e,t){var n,i,o,u,s,l,f,h=e.length,E=(e[0].modelMatrix,c(e[0][t].indices)),p=e[0][t].primitiveType,m=L(e,t);for(n in m)if(m.hasOwnProperty(n))for(s=m[n].values,u=0,i=0;h>i;++i)for(l=e[i][t].attributes[n].values,f=l.length,o=0;f>o;++o)s[u++]=l[o];var _;if(E){var v=0;for(i=0;h>i;++i)v+=e[i][t].indices.length;var T=d.computeNumberOfVertices(new d({attributes:m,primitiveType:g.POINTS})),R=y.createTypedArray(T,v),A=0,S=0;for(i=0;h>i;++i){var N=e[i][t].indices,I=N.length;for(u=0;I>u;++u)R[A++]=S+N[u];S+=d.computeNumberOfVertices(e[i][t])}_=R}var O,M=new a,w=0;for(i=0;h>i;++i){if(O=e[i][t].boundingSphere,!c(O)){M=void 0;break}a.add(O.center,M,M)}if(c(M))for(a.divideByScalar(M,h,M),i=0;h>i;++i){O=e[i][t].boundingSphere;var x=a.magnitude(a.subtract(O.center,M,se))+O.radius;x>w&&(w=x)}return new d({attributes:m,indices:_,primitiveType:p,boundingSphere:c(M)?new r(M,w):void 0})}function b(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function F(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;t>a;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=g.TRIANGLES,e}function z(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;t-1>a;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,t>a+2&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=g.TRIANGLES,e}function B(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=g.LINES,e}function q(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=g.LINES,e}function W(e){switch(e.primitiveType){case g.TRIANGLE_FAN:return F(e);case g.TRIANGLE_STRIP:return z(e);case g.TRIANGLES:return b(e);case g.LINE_STRIP:return G(e);case g.LINE_LOOP:return q(e);case g.LINES:return B(e)}return e}function H(e,t){Math.abs(e.y)<T.EPSILON6&&(t?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function X(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return H(e,e.y<0),H(t,t.y<0),void H(r,r.y<0);var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?T.sign(e.y):T.sign(r.y):i>o?T.sign(t.y):T.sign(r.y);var u=0>n;H(e,u),H(t,u),H(r,u)}function V(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,Te),e.y/(e.y-t.y),Te),r),a.clone(r,n),H(r,!0),H(n,!1)}function Y(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){X(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Ne.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(V(e,t,Re,Se),V(e,r,Ae,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(V(t,r,Re,Se),V(t,e,Ae,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(V(r,e,Re,Se),V(r,t,Ae,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(V(r,e,Re,Se),V(r,t,Ae,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(V(t,r,Re,Se),V(t,e,Ae,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(V(e,t,Re,Se),V(e,r,Ae,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ne.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Re,s[4]=Ae,s[5]=Se,s[6]=ge,s.length=7),Ne}}function k(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=d.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function Z(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new E({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function j(e,t,r){var n=c(e.geometry.boundingSphere);t=k(t,n),r=k(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function K(e,r,i,o,u,s,l,f,h,d,E){if(c(s)||c(l)||c(f)||c(h)){var p=a.fromArray(u,3*e,Ie),m=a.fromArray(u,3*r,Oe),y=a.fromArray(u,3*i,Me),_=t(o,p,m,y,we);if(c(s)){var v=a.fromArray(s,3*e,Ie),T=a.fromArray(s,3*r,Oe),R=a.fromArray(s,3*i,Me);a.multiplyByScalar(v,_.x,v),a.multiplyByScalar(T,_.y,T),a.multiplyByScalar(R,_.z,R);var A=a.add(v,T,v);a.add(A,R,A),a.normalize(A,A),a.pack(A,d.normal.values,3*E)}if(c(l)){var S=a.fromArray(l,3*e,Ie),g=a.fromArray(l,3*r,Oe),N=a.fromArray(l,3*i,Me);a.multiplyByScalar(S,_.x,S),a.multiplyByScalar(g,_.y,g),a.multiplyByScalar(N,_.z,N);var I=a.add(S,g,S);a.add(I,N,I),a.normalize(I,I),a.pack(I,d.binormal.values,3*E)}if(c(f)){var O=a.fromArray(f,3*e,Ie),M=a.fromArray(f,3*r,Oe),w=a.fromArray(f,3*i,Me);a.multiplyByScalar(O,_.x,O),a.multiplyByScalar(M,_.y,M),a.multiplyByScalar(w,_.z,w);var x=a.add(O,M,O);a.add(x,w,x),a.normalize(x,x),a.pack(x,d.tangent.values,3*E)}if(c(h)){var C=n.fromArray(h,2*e,xe),P=n.fromArray(h,2*r,Ce),D=n.fromArray(h,2*i,Pe);n.multiplyByScalar(C,_.x,C),n.multiplyByScalar(P,_.y,P),n.multiplyByScalar(D,_.z,D);var L=n.add(C,P,C);n.add(L,D,L),n.pack(L,d.st.values,2*E)}}}function J(e,t,r,n,a,i){var o=e.position.values.length/3;if(-1!==a){var u=n[a],s=r[u];return-1===s?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function Q(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,h=c(s.binormal)?s.binormal.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,E=c(s.st)?s.st.values:void 0,p=u.indices,m=Z(u),y=Z(u),_=[];_.length=l.length/3;var v=[];for(v.length=l.length/3,o=0;o<_.length;++o)_[o]=-1,v[o]=-1;var T=p.length;for(o=0;T>o;o+=3){var R=p[o],A=p[o+1],S=p[o+2],g=a.fromArray(l,3*R),N=a.fromArray(l,3*A),I=a.fromArray(l,3*S),O=Y(g,N,I);if(c(O)&&O.positions.length>3)for(var M=O.positions,w=O.indices,x=w.length,C=0;x>C;++C){var P=w[C],D=M[P];D.y<0?(t=y.attributes,r=y.indices,n=_):(t=m.attributes,r=m.indices,n=v),i=J(t,r,n,p,3>P?o+P:-1,D),K(R,A,S,D,l,f,h,d,E,t,i)}else c(O)&&(g=O.positions[0],N=O.positions[1],I=O.positions[2]),g.y<0?(t=y.attributes,r=y.indices,n=_):(t=m.attributes,r=m.indices,n=v),i=J(t,r,n,p,o,g),K(R,A,S,g,l,f,h,d,E,t,i),i=J(t,r,n,p,o+1,N),K(R,A,S,N,l,f,h,d,E,t,i),i=J(t,r,n,p,o+2,I),K(R,A,S,I,l,f,h,d,E,t,i)}j(e,y,m)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=Z(r),s=Z(r),l=o.length,f=[];f.length=i.length/3;var h=[];for(h.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,h[t]=-1;for(t=0;l>t;t+=2){var d=o[t],E=o[t+1],p=a.fromArray(i,3*d,Ie),m=a.fromArray(i,3*E,Oe);Math.abs(p.y)<T.EPSILON6&&(p.y<0?p.y=-T.EPSILON6:p.y=T.EPSILON6),Math.abs(m.y)<T.EPSILON6&&(m.y<0?m.y=-T.EPSILON6:m.y=T.EPSILON6);var y=u.attributes,_=u.indices,R=h,A=s.attributes,S=s.indices,g=f,N=v.lineSegmentPlane(p,m,De,Me);if(c(N)){var I=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,Le);p.y<0&&(a.negate(I,I),y=s.attributes,_=s.indices,R=f,A=u.attributes,S=u.indices,g=h);var O=a.add(N,I,Ue);J(y,_,R,o,t,p),J(y,_,R,o,-1,O),a.negate(I,I),a.add(N,I,O),J(A,S,g,o,-1,O),J(A,S,g,o,t+1,m)}else{var M,w,x;p.y<0?(M=s.attributes,w=s.indices,x=f):(M=u.attributes,w=u.indices,x=h),J(M,w,x,o,t,p),J(M,w,x,o,t+1,m)}}j(e,s,u)}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,d=s.expandAndWidth.values,E=c(s.st)?s.st.values:void 0,p=c(s.color)?s.color.values:void 0,m=Z(u),y=Z(u),_=l.length/3;for(t=0;_>t;t+=4){var R=t,A=t+1,S=t+2,g=t+3,N=a.fromArray(l,3*R,ze),I=a.fromArray(l,3*A,Be),O=a.fromArray(l,3*S,Ge),M=a.fromArray(l,3*g,qe);Math.abs(N.y)<T.EPSILON6&&(N.y=T.EPSILON6*(O.y<0?-1:1),I.y=N.y),Math.abs(O.y)<T.EPSILON6&&(O.y=T.EPSILON6*(N.y<0?-1:1),M.y=O.y);var w=m.attributes,x=m.indices,C=y.attributes,P=y.indices,D=v.lineSegmentPlane(N,O,De,We);if(c(D)){var L=a.multiplyByScalar(a.UNIT_Y,5*T.EPSILON9,He);N.y<0&&(a.negate(L,L),w=y.attributes,x=y.indices,C=m.attributes,P=m.indices);var U=a.add(D,L,Xe);for(w.position.values.push(N.x,N.y,N.z,I.x,I.y,I.z),w.position.values.push(U.x,U.y,U.z),w.position.values.push(U.x,U.y,U.z),a.negate(L,L),a.add(D,L,U),C.position.values.push(U.x,U.y,U.z),C.position.values.push(U.x,U.y,U.z),C.position.values.push(O.x,O.y,O.z,M.x,M.y,M.z),r=3*R;3*R+6>r;++r)w.prevPosition.values.push(f[r]);for(w.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),C.prevPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),r=3*S;3*S+6>r;++r)C.prevPosition.values.push(f[r]);for(r=3*R;3*R+6>r;++r)w.nextPosition.values.push(h[r]);for(w.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),C.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),r=3*S;3*S+6>r;++r)C.nextPosition.values.push(h[r]);var b=n.fromArray(d,2*R,be),F=Math.abs(b.y);w.expandAndWidth.values.push(-1,F,1,F),w.expandAndWidth.values.push(-1,-F,1,-F),C.expandAndWidth.values.push(-1,F,1,F),C.expandAndWidth.values.push(-1,-F,1,-F);var z=a.magnitudeSquared(a.subtract(D,N,qe));if(z/=a.magnitudeSquared(a.subtract(O,N,qe)),c(p)){var B=i.fromArray(p,4*R,Ve),G=i.fromArray(p,4*S,Ve),q=T.lerp(B.x,G.x,z),W=T.lerp(B.y,G.y,z),H=T.lerp(B.z,G.z,z),X=T.lerp(B.w,G.w,z);for(r=4*R;4*R+8>r;++r)w.color.values.push(p[r]);for(w.color.values.push(q,W,H,X),w.color.values.push(q,W,H,X),C.color.values.push(q,W,H,X),C.color.values.push(q,W,H,X),r=4*S;4*S+8>r;++r)C.color.values.push(p[r])}if(c(E)){var V=n.fromArray(E,2*R,be),Y=n.fromArray(E,2*(t+3),Fe),k=T.lerp(V.x,Y.x,z);for(r=2*R;2*R+4>r;++r)w.st.values.push(E[r]);for(w.st.values.push(k,V.y),w.st.values.push(k,Y.y),C.st.values.push(k,V.y),C.st.values.push(k,Y.y),r=2*S;2*S+4>r;++r)C.st.values.push(E[r])}o=w.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=C.position.values.length/3-4,P.push(o,o+2,o+1),P.push(o+1,o+2,o+3)}else{var K,J;for(N.y<0?(K=y.attributes,J=y.indices):(K=m.attributes,J=m.indices),K.position.values.push(N.x,N.y,N.z),K.position.values.push(I.x,I.y,I.z),K.position.values.push(O.x,O.y,O.z),K.position.values.push(M.x,M.y,M.z),r=3*t;3*t+12>r;++r)K.prevPosition.values.push(f[r]),K.nextPosition.values.push(h[r]);for(r=2*t;2*t+8>r;++r)K.expandAndWidth.values.push(d[r]),c(E)&&K.st.values.push(E[r]);if(c(p))for(r=4*t;4*t+16>r;++r)K.color.values.push(p[r]);o=K.position.values.length/3-4,J.push(o,o+2,o+1),J.push(o+1,o+2,o+3)}}j(e,y,m)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case g.TRIANGLES:e.indices=O(t);break;case g.TRIANGLE_STRIP:e.indices=M(t);break;case g.TRIANGLE_FAN:e.indices=w(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=g.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),f=0,h=0;o>h;h+=3)l[f++]=a[h],l[f++]=a[h+1],l[f++]=a[h+2],l[f++]=a[h]+i[h]*n,l[f++]=a[h+1]+i[h+1]*n,l[f++]=a[h+2]+i[h+2]*n;var p,m=e.boundingSphere;return c(m)&&(p=new r(m.center,m.radius+n)),new d({attributes:{position:new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:g.LINES,boundingSphere:p})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},te.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;t>a;a++)n[a]=-1;for(var i,o=r,s=o.length,l=y.createTypedArray(t,s),f=0,h=0,E=0;s>f;)i=n[o[f]],-1!==i?l[h]=i:(i=o[f],n[i]=E,l[h]=E,++E),++f,++h;e.indices=l;var p=e.attributes;for(var m in p)if(p.hasOwnProperty(m)&&c(p[m])&&c(p[m].values)){for(var _=p[m],v=_.values,T=0,R=_.componentsPerAttribute,A=u.createTypedArray(_.componentDatatype,E*R);t>T;){var S=n[T];if(-1!==S)for(a=0;R>a;a++)A[R*S+a]=v[R*T+a];++T}_.values=A}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===g.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;n>i;i++)r[i]>a&&(a=r[i]);e.indices=N.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>=T.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=x(e.attributes),s=e.indices,l=s.length;e.primitiveType===g.TRIANGLES?n=3:e.primitiveType===g.LINES?n=2:e.primitiveType===g.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var h=0;n>h;++h){var E=s[f+h],p=a[E];c(p)||(p=o++,a[E]=p,C(u,e.attributes,E)),i.push(p)}o+n>=T.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=x(e.attributes))}0!==i.length&&t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new a,ne=new o;te.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new h;for(var s=i.ellipsoid,f=o.values,d=new Float64Array(f.length),p=0,m=0;m<f.length;m+=3){var y=a.fromArray(f,m,re),_=s.cartesianToCartographic(y,ne);if(!c(_))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=i.project(_,re);d[p++]=v.x,d[p++]=v.y,d[p++]=v.z}return e.attributes[r]=o,e.attributes[n]=new E({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var ae={high:0,low:0};te.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)f.encode(i[l],ae),s[l]=ae.high,c[l]=ae.low;var h=a.componentsPerAttribute;return e.attributes[r]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:s}),e.attributes[n]=new E({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:c}),delete e.attributes[t],e};var ie=new a,oe=new A,ue=new R;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(A.equals(t,A.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(A.inverse(t,oe),A.transpose(oe,oe),A.getRotation(oe,ue),D(ue,n.normal),D(ue,n.binormal),D(ue,n.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=A.clone(A.IDENTITY),e};var se=new a;te.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;n>a;++a){var i=e[a];c(i.geometry)?t.push(i):r.push(i)}var o=[];return t.length>0&&o.push(U(t,"geometry")),r.length>0&&(o.push(U(r,"westHemisphereGeometry")),o.push(U(r,"eastHemisphereGeometry"))),o};var ce=new a,le=new a,fe=new a,he=new a;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var h=0;for(f=0;o>f;f+=3){var d=t[f],p=t[f+1],m=t[f+2],y=3*d,_=3*p,v=3*m;le.x=n[y],le.y=n[y+1],le.z=n[y+2],fe.x=n[_],fe.y=n[_+1],fe.z=n[_+2],he.x=n[v],he.y=n[v+1],he.z=n[v+2],s[d].count++,s[p].count++,s[m].count++,a.subtract(fe,le,fe),a.subtract(he,le,he),c[h]=a.cross(fe,he,new a),h++}var T=0;for(f=0;i>f;f++)s[f].indexOffset+=T,T+=s[f].count;h=0;var R;for(f=0;o>f;f+=3){R=s[t[f]];var A=R.indexOffset+R.currentCount;l[A]=h,R.currentCount++,R=s[t[f+1]],A=R.indexOffset+R.currentCount,l[A]=h,R.currentCount++,R=s[t[f+2]],A=R.indexOffset+R.currentCount,l[A]=h,R.currentCount++,h++}var S=new Float32Array(3*i);for(f=0;i>f;f++){var g=3*f;if(R=s[f],R.count>0){for(a.clone(a.ZERO,ce),h=0;h<R.count;h++)a.add(ce,c[l[R.indexOffset+h]],ce);a.normalize(ce,ce),S[g]=ce.x,S[g+1]=ce.y,S[g+2]=ce.z}else S[g]=0,S[g+1]=0,S[g+2]=1}return e.attributes.normal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var de=new a,Ee=new a,pe=new a;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,h,d;for(l=0;s>l;l+=3){var p=t[l],m=t[l+1],y=t[l+2];f=3*p,h=3*m,d=3*y;var _=2*p,v=2*m,T=2*y,R=r[f],A=r[f+1],S=r[f+2],g=i[_],N=i[_+1],I=i[v+1]-N,O=i[T+1]-N,M=1/((i[v]-g)*O-(i[T]-g)*I),w=(O*(r[h]-R)-I*(r[d]-R))*M,x=(O*(r[h+1]-A)-I*(r[d+1]-A))*M,C=(O*(r[h+2]-S)-I*(r[d+2]-S))*M;c[f]+=w,c[f+1]+=x,c[f+2]+=C,c[h]+=w,c[h+1]+=x,c[h+2]+=C,c[d]+=w,c[d+1]+=x,c[d+2]+=C}var P=new Float32Array(3*o),D=new Float32Array(3*o);for(l=0;o>l;l++){f=3*l,h=f+1,d=f+2;var L=a.fromArray(n,f,de),U=a.fromArray(c,f,pe),b=a.dot(L,U);a.multiplyByScalar(L,b,Ee),a.normalize(a.subtract(U,Ee,U),U),D[f]=U.x,D[h]=U.y,D[d]=U.z,a.normalize(a.cross(L,U,U),U),P[f]=U.x,P[h]=U.y,P[d]=U.z}return e.attributes.tangent=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.binormal=new E({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e};var me=new n,ye=new a,_e=new a,ve=new a;te.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var o,s,l,f,h=t.attributes.tangent,d=t.attributes.binormal;c(r)&&(o=r.values),c(i)&&(s=i.values),c(h)&&(l=h.values),
d&&(f=d.values);var p=c(o)?o.length:s.length,m=c(o)?3:2,y=p/m,_=y,v=c(s)&&c(o)?2:1;v+=c(l)||c(f)?1:0,_*=v;for(var T=new Float32Array(_),R=0,A=0;y>A;++A){c(s)&&(n.fromArray(s,2*A,me),T[R++]=e.compressTextureCoordinates(me));var S=3*A;c(o)&&c(l)&&c(f)?(a.fromArray(o,S,ye),a.fromArray(l,S,_e),a.fromArray(f,S,ve),e.octPack(ye,_e,ve,me),T[R++]=me.x,T[R++]=me.y):(c(o)&&(a.fromArray(o,S,ye),T[R++]=e.octEncodeFloat(ye)),c(l)&&(a.fromArray(l,S,ye),T[R++]=e.octEncodeFloat(ye)),c(f)&&(a.fromArray(f,S,ye),T[R++]=e.octEncodeFloat(ye)))}return t.attributes.compressedAttributes=new E({componentDatatype:u.FLOAT,componentsPerAttribute:v,values:T}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var Te=new a,Re=new a,Ae=new a,Se=new a,ge=new a,Ne={positions:new Array(7),indices:new Array(9)},Ie=new a,Oe=new a,Me=new a,we=new a,xe=new n,Ce=new n,Pe=new n,De=S.fromPointNormal(a.ZERO,a.UNIT_Y),Le=new a,Ue=new a,be=new n,Fe=new n,ze=new a,Be=new a,Ge=new a,qe=new a,We=new a,He=new a,Xe=new a,Ve=new i;return te.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersectPlane(n,S.ORIGIN_ZX_PLANE)!==_.INTERSECTING)return e}if(t.geometryType!==m.NONE)switch(t.geometryType){case m.POLYLINES:ee(e);break;case m.TRIANGLES:Q(e);break;case m.LINES:$(e)}else W(t),t.primitiveType===g.TRIANGLES?Q(e):t.primitiveType===g.LINES&&$(e);return e},te}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";function r(t,r,a,i){return e(t,r,a,i,n),n.x>0&&n.y>0&&n.z>0}var n=new t;return r}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,a=(r-n)/r,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,h=f*f,d=1-h,E=Math.sqrt(d),p=t/4,m=p*p,y=m*p,_=m*m,v=1+p-3*m/4+5*y/4-175*_/64,T=1-p+15*m/8-35*y/8,R=1-3*p+35*m/4,A=1-5*p,S=v*l-T*Math.sin(2*l)*p/2-R*Math.sin(4*l)*m/16-A*Math.sin(6*l)*y/48-5*Math.sin(8*l)*_/512,g=e._constants;g.a=r,g.b=n,g.f=a,g.cosineHeading=i,g.sineHeading=o,g.tanU=u,g.cosineU=s,g.sineU=c,g.sigma=l,g.sineAlpha=f,g.sineSquaredAlpha=h,g.cosineSquaredAlpha=d,g.cosineAlpha=E,g.u2Over4=p,g.u4Over16=m,g.u6Over64=y,g.u8Over256=_,g.a0=v,g.a1=T,g.a2=R,g.a3=A,g.distanceRatio=S}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,r,n,a,i,o){var u=c(e,r);return(1-u)*e*t*(n+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,r,n,a,i,o){var s,c,f,h,d,E=(t-r)/t,p=i-n,m=Math.atan((1-E)*Math.tan(a)),y=Math.atan((1-E)*Math.tan(o)),_=Math.cos(m),v=Math.sin(m),T=Math.cos(y),R=Math.sin(y),A=_*T,S=_*R,g=v*R,N=v*T,I=p,O=u.TWO_PI,M=Math.cos(I),w=Math.sin(I);do{M=Math.cos(I),w=Math.sin(I);var x=S-N*M;f=Math.sqrt(T*T*w*w+x*x),c=g+A*M,s=Math.atan2(f,c);var C;0===f?(C=0,h=1):(C=A*w/f,h=1-C*C),O=I,d=c-2*g/h,isNaN(d)&&(d=0),I=p+l(E,C,h,s,f,c,d)}while(Math.abs(I-O)>u.EPSILON12);var P=h*(t*t-r*r)/(r*r),D=1+P*(4096+P*(P*(320-175*P)-768))/16384,L=P*(256+P*(P*(74-47*P)-128))/1024,U=d*d,b=L*f*(d+L*(c*(2*U-1)-L*d*(4*f*f-3)*(4*U-3)/6)/4),F=r*D*(s-b),z=Math.atan2(T*w,S-N*M),B=Math.atan2(_*w,S*M-N);e._distance=F,e._startHeading=z,e._endHeading=B,e._uSquared=P}function h(r,n,a,i){e.normalize(i.cartographicToCartesian(n,p),E),e.normalize(i.cartographicToCartesian(a,p),p);f(r,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,a.longitude,a.latitude),r._start=t.clone(n,r._start),r._end=t.clone(a,r._end),r._start.height=0,r._end.height=0,s(r)}function d(e,a,i){var u=r(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(a)&&h(this,e,a,u)}var E=new e,p=new e;return a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),d.prototype.setEndPoints=function(e,t){h(this,e,t,this._ellipsoid)},d.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},d.prototype.interpolateUsingSurfaceDistance=function(e,r){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),h=Math.sin(6*i),d=Math.sin(8*i),E=i*i,p=i*E,m=a.u8Over256,y=a.u2Over4,_=a.u6Over64,v=a.u4Over16,T=2*p*m*o/3+i*(1-y+7*v/4-15*_/4+579*m/64-(v-15*_/4+187*m/16)*o-(5*_/4-115*m/16)*u-29*m*s/16)+(y/2-v+71*_/32-85*m/16)*c+(5*v/16-5*_/4+383*m/96)*f-E*((_-11*m/2)*c+5*m*f/2)+(29*_/96-29*m/16)*h+539*m*d/1536,R=Math.asin(Math.sin(T)*a.cosineAlpha),A=Math.atan(a.a/a.b*Math.tan(R));T-=a.sigma;var S=Math.cos(2*a.sigma+T),g=Math.sin(T),N=Math.cos(T),I=a.cosineU*N,O=a.sineU*g,M=Math.atan2(g*a.sineHeading,I-O*a.cosineHeading),w=M-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,T,g,N,S);return n(r)?(r.longitude=this._start.longitude+w,r.latitude=A,r.height=0,r):new t(this._start.longitude+w,A,0)},d}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function h(e,t,r){var n=g;n.length=e;var a;if(t===r){for(a=0;e>a;a++)n[a]=t;return n}var i=r-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;n[a]=u}return n}function d(t,r,n,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,M),l=a.scaleToGeodeticSurface(r,w),f=E.numberOfPoints(t,r,n),d=a.cartesianToCartographic(c,N),p=a.cartesianToCartographic(l,I),m=h(f,i,o);x.setEndPoints(d,p);var y=x.surfaceDistance/f,_=s;d.height=i;var v=a.cartographicToCartesian(d,O);e.pack(v,u,_),_+=3;for(var T=1;f>T;T++){var R=x.interpolateUsingSurfaceDistance(T*y,I);R.height=m[T],v=a.cartographicToCartesian(R,O),e.pack(v,u,_),_+=3}return _}var E={};E.numberOfPoints=function(t,r,n){var a=e.distance(t,r);return Math.ceil(a/n)};var p=new t;E.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),a=0;r>a;a++){var i=e[a];n[a]=t.cartesianToCartographic(i,p).height}return n};var m=new l,y=new e,_=new e,v=new f(e.ZERO,0),T=new e,R=new f(e.ZERO,0),A=new e,S=new e,g=[],N=new t,I=new t,O=new e,M=new e,w=new e,x=new o;E.wrapLongitude=function(t,a){var i=[],o=[];if(n(t)&&t.length>0){a=r(a,l.IDENTITY);var s=l.inverseTransformation(a,m),c=l.multiplyByPoint(s,e.ZERO,y),h=l.multiplyByPointAsVector(s,e.UNIT_Y,_),d=f.fromPointNormal(c,h,v),E=l.multiplyByPointAsVector(s,e.UNIT_X,T),p=f.fromPointNormal(c,E,R),g=1;i.push(e.clone(t[0]));for(var N=i[0],I=t.length,O=1;I>O;++O){var M=t[O];if(f.getPointDistance(p,N)<0||f.getPointDistance(p,M)<0){var w=u.lineSegmentPlane(N,M,d,A);if(n(w)){var x=e.multiplyByScalar(h,5e-9,S);f.getPointDistance(d,N)<0&&e.negate(x,x),i.push(e.add(w,x,new e)),o.push(g+1),e.negate(x,x),i.push(e.add(w,x,new e)),g=1}}i.push(e.clone(t[O])),g++,N=M}o.push(g)}return{positions:i,lengths:o}};var C=c.EPSILON10;return E.removeDuplicates=function(t){var r=t.length;if(2>r)return t;var n,a,i;for(n=1;r>n&&(a=t[n-1],i=t[n],!e.equalsEpsilon(a,i,C));++n);if(n===r)return t;for(var o=t.slice(0,n);r>n;++n)i=t[n],e.equalsEpsilon(a,i,C)||(o.push(e.clone(i)),a=i);return o},E.generateArc=function(t){n(t)||(t={});var a=t.positions,o=a.length,u=r(t.ellipsoid,i.WGS84),l=r(t.height,0);if(1>o)return[];if(1===o){var f=u.scaleToGeodeticSurface(a[0],M);if(0!==l){var h=u.geodeticSurfaceNormal(f,O);e.multiplyByScalar(h,l,h),e.add(f,h,f)}return[f.x,f.y,f.z]}var p=t.minDistance;if(!n(p)){var m=r(t.granularity,c.RADIANS_PER_DEGREE);p=c.chordLength(m,u.maximumRadius)}var y,_=0;for(y=0;o-1>y;y++)_+=E.numberOfPoints(a[y],a[y+1],p);var v=3*(_+1),T=new Array(v),R=0,A=s(l);for(y=0;o-1>y;y++){var S=a[y],I=a[y+1],w=A?l[y]:l,x=A?l[y+1]:l;R=d(S,I,p,u,w,x,T,R)}g.length=0;var C=a[o-1],P=u.cartesianToCartographic(C,N);P.height=A?l[o-1]:l;var D=u.cartographicToCartesian(P,O);return e.pack(D,T,v-3),T},E.generateCartesianArc=function(t){for(var r=E.generateArc(t),n=r.length/3,a=new Array(n),i=0;n>i;i++)a[i]=e.unpack(r,3*i);return a},E}),define("Core/Queue",["../Core/defineProperties"],function(e){"use strict";function t(){this._array=[],this._offset=0,this._length=0}return e(t.prototype,{length:{get:function(){return this._length}}}),t.prototype.enqueue=function(e){this._array.push(e),this._length++},t.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,r}},t.prototype.peek=function(){return 0!==this._length?this._array[this._offset]:void 0},t.prototype.contains=function(e){return-1!==this._array.indexOf(e)},t.prototype.clear=function(){this._array.length=this._offset=this._length=0},t.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},t}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return t(r)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E,p){"use strict";function m(t,r,n){var a=e.subtract(r,t,b),i=e.subtract(n,r,F);return a.x*i.y-a.y*i.x>=0}function y(e){for(var t=e[0].x,r=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,r=n);return r}function _(e){for(var t=e[0][0].x,r=0,n=0;n<e.length;n++){var a=e[n][y(e[n])].x;a>t&&(t=a,r=n)}return r}function v(e){for(var t=[],r=0;r<e.length;r++){var n=e[(r-1+e.length)%e.length],a=e[r],i=e[(r+1)%e.length];m(n,a,i)||t.push(a)}return t}function T(t,r){for(var n=0;n<t.length;n++)if(e.equals(r,t[n]))return n;return-1}function R(r,a,i){i=n(i,[]);var o=Number.MAX_VALUE,u=y(a),s=new e(a[u].x,r.y);i.push(u),i.push((u+1)%a.length);for(var c=a[0].x,l=c,f=1;f<a.length;++f)a[f].x<c?c=a[f].x:a[f].x>l&&(l=a[f].x);l+=l-c;var h=new t(l,r.y,0);for(f=0;f<a.length;f++){var d=a[f],E=a[(f+1)%a.length];if((d.x>=r.x||E.x>=r.x)&&(d.y>=r.y&&E.y<=r.y||d.y<=r.y&&E.y>=r.y)){var p=(E.y-d.y)*(h.x-r.x)-(E.x-d.x)*(h.y-r.y);if(0!==p){p=1/p;var m=((E.x-d.x)*(r.y-d.y)-(E.y-d.y)*(r.x-d.x))*p,_=((h.x-r.x)*(r.y-d.y)-(h.y-r.y)*(r.x-d.x))*p;if(m>=0&&1>=m&&_>=0&&1>=_){var v=new e(r.x+m*(h.x-r.x),r.y+m*(h.y-r.y)),T=e.subtract(v,r,z);p=e.magnitudeSquared(T),o>p&&(s=v,o=p,i[0]=f,i[1]=(f+1)%a.length)}}}}return s}function A(t,r){var n=_(r),a=r[n],i=y(a),o=a[i],u=[],s=R(o,t,u),c=T(t,s);if(-1!==c)return c;var h=e.magnitudeSquared(e.subtract(t[u[0]],o,B)),d=e.magnitudeSquared(e.subtract(t[u[1]],o,B)),E=d>h?t[u[0]]:t[u[1]],p=v(t),m=p.indexOf(E);-1!==m&&p.splice(m,1);for(var A=[],S=0;S<p.length;S++){var g=p[S];f(g,o,s,E)&&A.push(g)}var N=Number.MAX_VALUE;if(A.length>0){var I=e.fromElements(1,0,B);for(S=0;S<A.length;S++){var O=e.subtract(A[S],o,G),M=e.magnitude(I)*e.magnitudeSquared(O);if(0!==M){var w=Math.abs(l.acosClamped(e.dot(I,O)/M));N>w&&(N=w,E=A[S])}}}return t.indexOf(E)}function S(e,r,n){for(var a=ee.computeWindingOrder2D(e),i=0;i<r.length;i++){var o=r[i];t.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===a&&o.reverse()}var c=u.fromPoints(e,n),l=c.projectPointsOntoPlane(e),f=[];for(i=0;i<r.length;i++)f.push(c.projectPointsOntoPlane(r[i]));var h=A(l,f),d=_(f),E=y(f[d]),p=r[d],m=[];for(i=0;i<e.length;i++)m.push(e[i]);var v,T=[];if(0!==E)for(v=0;v<=p.length;v++){var R=(v+E)%p.length;0!==R&&T.push(p[R])}else for(v=0;v<p.length;v++)T.push(p[(v+E)%p.length]);var S=m.lastIndexOf(e[h]);T.push(e[S]);var g=m.slice(0,S+1),N=m.slice(S+1);return m=g.concat(T,N),r.splice(d,1),m}function g(e){var t=l.nextRandomNumber(),r=Math.floor(t*e);return r===e&&r--,r}function N(e,t,r,n){var a=n[e].position,i=n[t].position,o=n[r].position,u=o.x,s=o.y,c=a.x-u,l=a.y-s,f=i.x-u,h=i.y-s;return c*h-l*f}function I(e,t){return e.x*t.y-e.y*t.x}function O(e,t){var r=t.length,n=l.mod(e-1,r),a=l.mod(e+1,r);return 0===N(n,a,e,t)?!1:!0}function M(t,r){return e.magnitudeSquared(r)<e.magnitudeSquared(t)}function w(t,r,n){if(!O(t,n))return t;var a=n[t].position,i=n[r].position,o=n.length,u=l.mod(t-1,o);if(!O(u,n))return u;var s=l.mod(t+1,o);if(!O(s,n))return s;var c=e.subtract(n[u].position,a,H),f=e.subtract(n[s].position,a,X),h=e.subtract(i,a,V),d=I(c,h),E=I(f,h);if(0===d)return M(c,h)?q:W;if(0===E)return M(f,h)?q:W;var p=I(c,f);return 0>p?0>d&&E>0?q:W:p>0?d>0&&0>E?W:q:void 0}function x(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function C(t,r,n,a){var i=e.subtract(n,t,k),o=r.x*a.y-r.y*a.x,u=o*o,s=e.magnitudeSquared(r),c=e.magnitudeSquared(a);if(u>Y*s*c){var l=(i.x*a.y-i.y*a.x)/o;return e.add(t,e.multiplyByScalar(r,l,k),k)}}function P(t,r,n){for(var i=e.subtract(r,t,Z),o=n.length,u=0;o>u;u++){var s=n[u].position,c=n[l.mod(u+1,o)].position;if(!(e.equals(t,s)||e.equals(r,c)||e.equals(t,c)||e.equals(r,s))){var f=e.subtract(c,s,j),h=C(t,i,s,f);if(a(h)&&!(e.equals(h,t)||e.equals(h,r)||e.equals(h,s)||e.equals(h,c))){var d=h.x,E=h.y,p=x(d,t.x,r.x)&&x(E,t.y,r.y)&&x(d,s.x,c.x)&&x(E,s.y,c.y);if(p)return!0}}}return!1}function D(t,r,n){var a=w(t,r,n);if(a>=0)return a;var i=w(r,t,n);return i>=0?i:a!==q||i!==q||P(n[t].position,n[r].position,n)||e.equals(n[t].position,n[r].position)?J:K}function L(e){return 0===N(1,2,0,e)}function U(e){var t=e.length;if(3===t)return L(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new i("Invalid polygon: must have at least three vertices.");for(var r,n,a=0,o=10*e.length,u=J;K>u&&a++<o;){for(r=g(e.length),n=r+1;Math.abs(r-n)<2||Math.abs(r-n)>e.length-2;)n=g(e.length);if(r>n){var s=r;r=n,n=s}u=D(r,n,e)}if(u===K){var c=e.splice(r,n-r+1,e[r],e[n]);return U(e).concat(U(c))}return u>=0?(e.splice(u,1),U(e)):[]}var b=new e,F=new e,z=new e,B=new e(1,0),G=new e,q=-1,W=-2,H=new t,X=new t,V=new t,Y=l.EPSILON14,k=new e,Z=new e,j=new e,K=-1,J=-2,Q=new t,$=new t,ee={};ee.removeDuplicates=function(e){var r=h.removeDuplicates(e);return t.equals(r[0],r[r.length-1])?r.slice(1):r},ee.computeArea2D=function(e){for(var t=e.length,r=0,n=t-1,a=0;t>a;n=a++){var i=e[n],o=e[a];r+=i.x*o.y-o.x*i.y}return.5*r},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},ee.triangulate=function(e){for(var t=e.length,r=[],n=0;t>n;++n)r[n]={position:e[n],index:n};return U(r)};var te=new t,re=new t,ne=new t,ae=new t,ie=new t,oe=new t,ue=new t;return ee.computeSubdivision=function(e,i,o,u){u=n(u,l.RADIANS_PER_DEGREE);var f,h=o.slice(0),E=i.length,p=new Array(3*E),m=0;for(f=0;E>f;f++){var y=i[f];p[m++]=y.x,p[m++]=y.y,p[m++]=y.z}for(var _=[],v={},T=e.maximumRadius,R=l.chordLength(u,T),A=R*R;h.length>0;){var S,g,N=h.pop(),I=h.pop(),O=h.pop(),M=t.fromArray(p,3*O,te),w=t.fromArray(p,3*I,re),x=t.fromArray(p,3*N,ne),C=t.multiplyByScalar(t.normalize(M,ae),T,ae),P=t.multiplyByScalar(t.normalize(w,ie),T,ie),D=t.multiplyByScalar(t.normalize(x,oe),T,oe),L=t.magnitudeSquared(t.subtract(C,P,ue)),U=t.magnitudeSquared(t.subtract(P,D,ue)),b=t.magnitudeSquared(t.subtract(D,C,ue)),F=Math.max(L,U,b);F>A?L===F?(S=Math.min(O,I)+" "+Math.max(O,I),f=v[S],a(f)||(g=t.add(M,w,ue),t.multiplyByScalar(g,.5,g),p.push(g.x,g.y,g.z),f=p.length/3-1,v[S]=f),h.push(O,f,N),h.push(f,I,N)):U===F?(S=Math.min(I,N)+" "+Math.max(I,N),f=v[S],a(f)||(g=t.add(w,x,ue),t.multiplyByScalar(g,.5,g),p.push(g.x,g.y,g.z),f=p.length/3-1,v[S]=f),h.push(I,f,O),h.push(f,N,O)):b===F&&(S=Math.min(N,O)+" "+Math.max(N,O),f=v[S],a(f)||(g=t.add(x,M,ue),t.multiplyByScalar(g,.5,g),p.push(g.x,g.y,g.z),f=p.length/3-1,v[S]=f),h.push(N,f,I),h.push(f,O,I)):(_.push(O),_.push(I),_.push(N))}return new s({attributes:{position:new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:p})},indices:_,primitiveType:d.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,r,i,u){i=n(i,o.WGS84);var s=Q,c=$;if(r=n(r,0),u=n(u,!0),a(e)&&a(e.attributes)&&a(e.attributes.position))for(var l=e.attributes.position.values,f=l.length,h=0;f>h;h+=3)t.fromArray(l,h,c),u&&(c=i.scaleToGeodeticSurface(c,c)),s=i.geodeticSurfaceNormal(c,s),t.multiplyByScalar(s,r,s),t.add(c,s,c),l[h]=c.x,l[h+1]=c.y,l[h+2]=c.z;return e},ee.eliminateHoles=function(e,r,a){a=n(a,o.WGS84);for(var i=[],u=0;u<r.length;u++){for(var s=[],c=0;c<r[u].length;c++)s.push(t.clone(r[u][c]));i.push(s)}for(var l=e;i.length>0;)l=S(l,i,a);return l},ee}),define("Core/PolygonGeometryLibrary",["./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E){"use strict";function p(t,r,n,a){return e.subtract(r,t,y),e.multiplyByScalar(y,n/a,y),e.add(t,y,y),[y.x,y.y,y.z]}var m={};m.computeHierarchyPackedLength=function(t){for(var r=0,a=[t];a.length>0;){var i=a.pop();if(n(i)){r+=2;var o=i.positions,u=i.holes;if(n(o)&&(r+=o.length*e.packedLength),n(u))for(var s=u.length,c=0;s>c;++c)a.push(u[c])}}return r},m.packPolygonHierarchy=function(t,r,a){for(var i=[t];i.length>0;){var o=i.pop();if(n(o)){var u=o.positions,s=o.holes;if(r[a++]=n(u)?u.length:0,r[a++]=n(s)?s.length:0,n(u))for(var c=u.length,l=0;c>l;++l,a+=3)e.pack(u[l],r,a);if(n(s))for(var f=s.length,h=0;f>h;++h)i.push(s[h])}}return a},m.unpackPolygonHierarchy=function(t,r){for(var n=t[r++],a=t[r++],i=new Array(n),o=a>0?new Array(a):void 0,u=0;n>u;++u,r+=e.packedLength)i[u]=e.unpack(t,r);for(var s=0;a>s;++s)o[s]=m.unpackPolygonHierarchy(t,r),r=o[s].startingIndex,delete o[s].startingIndex;return{positions:i,holes:o,startingIndex:r}};var y=new e;m.subdivideLineCount=function(t,r,n){var a=e.distance(t,r),i=a/n,o=Math.max(0,Math.ceil(Math.log(i)/Math.log(2)));return Math.pow(2,o)},m.subdivideLine=function(t,r,a,i){var o=m.subdivideLineCount(t,r,a),u=e.distance(t,r),s=u/o;n(i)||(i=[]);var c=i;c.length=3*o;for(var l=0,f=0;o>f;f++){var h=p(t,r,f*s,u);c[l++]=h[0],c[l++]=h[1],c[l++]=h[2]}return c};var _=new e,v=new e,T=new e,R=new e;m.scaleToGeodeticHeightExtruded=function(t,i,o,u,s){u=r(u,a.WGS84);var c=_,l=v,f=T,h=R;if(n(t)&&n(t.attributes)&&n(t.attributes.position))for(var d=t.attributes.position.values,E=d.length/2,p=0;E>p;p+=3)e.fromArray(d,p,f),u.geodeticSurfaceNormal(f,c),h=u.scaleToGeodeticSurface(f,h),l=e.multiplyByScalar(c,o,l),l=e.add(h,l,l),d[p+E]=l.x,d[p+1+E]=l.y,d[p+2+E]=l.z,s&&(h=e.clone(f,h)),l=e.multiplyByScalar(c,i,l),l=e.add(h,l,l),d[p]=l.x,d[p+1]=l.y,d[p+2]=l.z;return t},m.polygonsFromHierarchy=function(e){var t=[],r=[],a=new d;for(a.enqueue(e);0!==a.length;){var i=a.dequeue(),o=i.positions,u=i.holes;if(o=f.removeDuplicates(o),!(o.length<3)){for(var s=n(u)?u.length:0,c=[],l=0;s>l;l++){var h=u[l];if(h.positions=f.removeDuplicates(h.positions),!(h.positions.length<3)){c.push(h.positions);var E=0;n(h.holes)&&(E=h.holes.length);for(var p=0;E>p;p++)a.enqueue(h.holes[p])}}r.push({outerRing:o,holes:c});var m=c.length>0?f.eliminateHoles(o,c):o;t.push(m)}}return{hierarchy:r,polygons:t}};var A=[];m.createGeometryFromPositions=function(e,r,n,a){var s=i.fromPoints(r,e),c=s.projectPointsOntoPlane(r,A),l=f.computeWindingOrder2D(c);l===E.CLOCKWISE&&(c.reverse(),r=r.slice().reverse());var d=f.triangulate(c);if(d.length<3&&(d=[0,1,2]),a){for(var p=r.length,m=new Array(3*p),y=0,_=0;p>_;_++){var v=r[_];m[y++]=v.x,m[y++]=v.y,m[y++]=v.z}return new o({attributes:{position:new u({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:m})},indices:d,primitiveType:h.TRIANGLES})}return f.computeSubdivision(e,r,d,n)};var S=[],g=new e,N=new e;return m.computeWallGeometry=function(r,n,a,i){var f,d,E,p,y,_=r.length,v=0;if(i)for(d=3*_*2,f=new Array(2*d),E=0;_>E;E++)p=r[E],y=r[(E+1)%_],f[v]=f[v+d]=p.x,++v,f[v]=f[v+d]=p.y,++v,f[v]=f[v+d]=p.z,++v,f[v]=f[v+d]=y.x,++v,f[v]=f[v+d]=y.y,++v,f[v]=f[v+d]=y.z,++v;else{var T=l.chordLength(a,n.maximumRadius),R=0;for(E=0;_>E;E++)R+=m.subdivideLineCount(r[E],r[(E+1)%_],T);for(d=3*(R+_),f=new Array(2*d),E=0;_>E;E++){p=r[E],y=r[(E+1)%_];for(var A=m.subdivideLine(p,y,T,S),I=A.length,O=0;I>O;++O,++v)f[v]=A[O],f[v+d]=A[O];f[v]=y.x,f[v+d]=y.x,++v,f[v]=y.y,f[v+d]=y.y,++v,f[v]=y.z,f[v+d]=y.z,++v}}_=f.length;var M=c.createTypedArray(_/3,_-6*r.length),w=0;for(_/=6,E=0;_>E;E++){var x=E,C=x+1,P=x+_,D=P+1;p=e.fromArray(f,3*x,g),y=e.fromArray(f,3*C,N),e.equalsEpsilon(p,y,l.EPSILON14)||(M[w++]=x,M[w++]=P,M[w++]=C,M[w++]=C,M[w++]=P,M[w++]=D)}return new o({attributes:new s({position:new u({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:f})}),indices:M,primitiveType:h.TRIANGLES})},m}),define("Core/PolygonOutlineGeometry",["./BoundingSphere","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,E,p,m,y,_){"use strict";function v(e,r,n,a){var i=o.fromPoints(r,e),f=i.projectPointsOntoPlane(r,A),d=p.computeWindingOrder2D(f);d===_.CLOCKWISE&&(f.reverse(),r=r.slice().reverse());var y,v,T=r.length,R=0;if(a)for(y=new Float64Array(2*T*3),v=0;T>v;v++){var g=r[v],N=r[(v+1)%T];y[R++]=g.x,y[R++]=g.y,y[R++]=g.z,y[R++]=N.x,y[R++]=N.y,y[R++]=N.z}else{var I=0;for(v=0;T>v;v++)I+=E.subdivideLineCount(r[v],r[(v+1)%T],n);for(y=new Float64Array(3*I),v=0;T>v;v++)for(var O=E.subdivideLine(r[v],r[(v+1)%T],n,S),M=O.length,w=0;M>w;++w)y[R++]=O[w]}T=y.length/3;var x=2*T,C=h.createTypedArray(T,x);for(R=0,v=0;T-1>v;v++)C[R++]=v,C[R++]=v+1;return C[R++]=T-1,C[R++]=0,new l({geometry:new u({attributes:new c({position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:y})}),indices:C,primitiveType:m.LINES})})}function T(e,r,n,a){var i=o.fromPoints(r,e),f=i.projectPointsOntoPlane(r,A),d=p.computeWindingOrder2D(f);d===_.CLOCKWISE&&(f.reverse(),r=r.slice().reverse());var y,v,T=r.length,R=new Array(T),g=0;if(a)for(y=new Float64Array(2*T*3*2),v=0;T>v;++v){R[v]=g/3;var N=r[v],I=r[(v+1)%T];y[g++]=N.x,y[g++]=N.y,y[g++]=N.z,y[g++]=I.x,y[g++]=I.y,y[g++]=I.z}else{var O=0;for(v=0;T>v;v++)O+=E.subdivideLineCount(r[v],r[(v+1)%T],n);for(y=new Float64Array(3*O*2),v=0;T>v;++v){R[v]=g/3;for(var M=E.subdivideLine(r[v],r[(v+1)%T],n,S),w=M.length,x=0;w>x;++x)y[g++]=M[x]}}T=y.length/6;var C=R.length,P=2*(2*T+C),D=h.createTypedArray(T,P);for(g=0,v=0;T>v;++v)D[g++]=v,D[g++]=(v+1)%T,D[g++]=v+T,D[g++]=(v+1)%T+T;for(v=0;C>v;v++){var L=R[v];D[g++]=L,D[g++]=L+T}return new l({geometry:new u({attributes:new c({position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:y})}),indices:D,primitiveType:m.LINES})})}function R(e){var t=e.polygonHierarchy,a=r(e.ellipsoid,i.WGS84),o=r(e.granularity,d.RADIANS_PER_DEGREE),u=r(e.height,0),s=r(e.perPositionHeight,!1),c=e.extrudedHeight,l=n(c);if(l&&!s){var f=c;c=Math.min(f,u),u=Math.max(f,u)}this._ellipsoid=i.clone(a),this._granularity=o,this._height=u,this._extrudedHeight=r(c,0),this._extrude=l,this._polygonHierarchy=t,this._perPositionHeight=s,this._workerName="createPolygonOutlineGeometry",this.packedLength=E.computeHierarchyPackedLength(t)+i.packedLength+6}var A=[],S=[];R.pack=function(e,t,n){n=r(n,0),n=E.packPolygonHierarchy(e._polygonHierarchy,t,n),i.pack(e._ellipsoid,t,n),n+=i.packedLength,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._granularity,t[n++]=e._extrude?1:0,t[n++]=e._perPositionHeight?1:0,t[n++]=e.packedLength};var g=i.clone(i.UNIT_SPHERE),N={polygonHierarchy:{}};return R.unpack=function(e,t,a){t=r(t,0);var o=E.unpackPolygonHierarchy(e,t);t=o.startingIndex,delete o.startingIndex;var u=i.unpack(e,t,g);t+=i.packedLength;var s=e[t++],c=e[t++],l=e[t++],f=1===e[t++],h=1===e[t++],d=e[t++];return n(a)||(a=new R(N)),a._polygonHierarchy=o,a._ellipsoid=i.clone(u,a._ellipsoid),a._height=s,a._extrudedHeight=c,a._granularity=l,a._extrude=f,a._perPositionHeight=h,a.packedLength=d,a},R.fromPositions=function(e){e=r(e,r.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new R(t)},R.createGeometry=function(t){var r=t._ellipsoid,a=t._granularity,i=t._height,o=t._extrudedHeight,s=t._extrude,c=t._polygonHierarchy,l=t._perPositionHeight,h=[],m=new y;m.enqueue(c);for(var _;0!==m.length;){var R=m.dequeue(),A=R.positions;if(A=p.removeDuplicates(A),!(A.length<3)){var S=R.holes?R.holes.length:0;for(_=0;S>_;_++){var g=R.holes[_];if(g.positions=p.removeDuplicates(g.positions),!(g.positions.length<3)){h.push(g.positions);var N=0;n(g.holes)&&(N=g.holes.length);for(var I=0;N>I;I++)m.enqueue(g.holes[I])}}h.push(A)}}if(0!==h.length){var O,M=[],w=d.chordLength(a,r.maximumRadius);if(s)for(_=0;_<h.length;_++)O=T(r,h[_],w,l),O.geometry=E.scaleToGeodeticHeightExtruded(O.geometry,i,o,r,l),M.push(O);else for(_=0;_<h.length;_++)O=v(r,h[_],w,l),O.geometry=p.scaleToGeodeticHeight(O.geometry,i,r,!l),M.push(O);O=f.combineInstances(M)[0];var x=e.fromVertices(O.attributes.position.values);return new u({attributes:O.attributes,indices:O.indices,primitiveType:O.primitiveType,boundingSphere:x})}},R}),define("Workers/createPolygonOutlineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolygonOutlineGeometry"],function(e,t,r){"use strict";function n(n,a){return e(a)&&(n=r.unpack(n,a)),n._ellipsoid=t.clone(n._ellipsoid),r.createGeometry(n)}return n})}();