/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:0>e?-1:0},a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e){return Math.round(255*(.5*a.clamp(e,-1,1)+.5))},a.fromSNorm=function(e){return a.clamp(e,0,255)/255*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},a.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return a>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;e>=n;n++)i.push(r*n);return i[e]},a.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)}i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,E=n*u-a*o;return r.x=c,r.y=l,r.z=E,r},i.fromDegrees=function(e,t,r,n,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,r,n,o)};var E=new i,f=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(n);E.x=c*Math.cos(r),E.y=c*Math.sin(r),E.z=Math.sin(n),E=i.normalize(E,E),i.multiplyComponents(s,E,f);var l=Math.sqrt(i.dot(E,f));return f=i.divideByScalar(f,l,f),E=i.multiplyByScalar(E,a,E),t(u)||(u=new i),i.add(f,E,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=a.toRadians(e[o]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=i.fromRadians(u,s,0,r,n[o/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=a.toRadians(e[o]),n[o+1]=a.toRadians(e[o+1]),n[o+2]=e[o+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=i.fromRadians(u,s,c,r,n[o/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function a(r,a,u,s,c){var l=r.x,E=r.y,f=r.z,d=a.x,_=a.y,h=a.z,m=l*l*d*d,y=E*E*_*_,T=f*f*h*h,p=m+y+T,R=Math.sqrt(1/p),A=e.multiplyByScalar(r,R,i);if(s>p)return isFinite(R)?e.clone(A,c):void 0;var N=u.x,v=u.y,S=u.z,I=o;I.x=A.x*N*2,I.y=A.y*v*2,I.z=A.z*S*2;var M,O,g,w,x,C,L,P,F,U,b,D=(1-R)*e.magnitude(r)/(.5*e.magnitude(I)),B=0;do{D-=B,g=1/(1+D*N),w=1/(1+D*v),x=1/(1+D*S),C=g*g,L=w*w,P=x*x,F=C*g,U=L*w,b=P*x,M=m*C+y*L+T*P-1,O=m*F*N+y*U*v+T*b*S;var z=-2*O;B=M/z}while(Math.abs(M)>n.EPSILON12);return t(c)?(c.x=l*g,c.y=E*w,c.z=f*x,c):new e(l*g,E*w,f*x)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,n,a,i){return a=t(a,0),r(i)?(i.longitude=e,i.latitude=n,i.height=a,i):new u(e,n,a)},u.fromDegrees=function(e,t,r,n){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,r,n)};var s=new e,c=new e,l=new e,E=new e(1/6378137,1/6378137,1/6356752.314245179),f=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=i.EPSILON1;return u.fromCartesian=function(t,n,a){var _=r(n)?n.oneOverRadii:E,h=r(n)?n.oneOverRadiiSquared:f,m=r(n)?n._centerToleranceSquared:d,y=o(t,_,h,m,c);if(r(y)){var T=e.multiplyComponents(t,h,s);T=e.normalize(T,T);var p=e.subtract(t,y,l),R=Math.atan2(T.y,T.x),A=Math.asin(T.z),N=i.sign(e.dot(p,t))*e.magnitude(p);return r(a)?(a.longitude=R,a.latitude=A,a.height=N,a):new u(R,A,N)}},u.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,c(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(n(t)){var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return n(t)||(t=new l),n(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,n,a){a=r(a,0),e.pack(t._radii,n,a)},l.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var E=new e,f=new e;l.prototype.cartographicToCartesian=function(t,r){var a=E,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,_=new e,h=new e;return l.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,_);if(n(i)){var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(r,i,h),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),E=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=E,a):new t(c,l,E)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)}function u(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[o.getElementIndex(d[r],f[r])];t+=2*n*n}return Math.sqrt(t)}function c(e,t){for(var r=i.EPSILON15,n=0,a=1,u=0;3>u;++u){var s=Math.abs(e[o.getElementIndex(d[u],f[u])]);s>n&&(a=u,n=s)}var c=1,l=0,E=f[a],_=d[a];if(Math.abs(e[o.getElementIndex(_,E)])>r){var h,m=e[o.getElementIndex(_,_)],y=e[o.getElementIndex(E,E)],T=e[o.getElementIndex(_,E)],p=(m-y)/2/T;h=0>p?-1/(-p+Math.sqrt(1+p*p)):1/(p+Math.sqrt(1+p*p)),c=1/Math.sqrt(1+h*h),l=h*c}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(E,E)]=t[o.getElementIndex(_,_)]=c,t[o.getElementIndex(_,E)]=l,t[o.getElementIndex(E,_)]=-l,t}o.packedLength=9,o.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a[4]=e[n++],a[5]=e[n++],a[6]=e[n++],a[7]=e[n++],a[8]=e[n++],a},o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,E=e.z*e.z,f=e.z*e.w,d=e.w*e.w,_=n-s-E+d,h=2*(a-f),m=2*(i+l),y=2*(a+f),T=-n+s-E+d,p=2*(c-u),R=2*(i-l),A=2*(c+u),N=-n-s+E+d;return r(t)?(t[0]=_,t[1]=y,t[2]=R,t[3]=h,t[4]=T,t[5]=A,t[6]=m,t[7]=p,t[8]=N,t):new o(_,h,m,y,T,p,R,A,N)},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new o(1,0,0,0,n,-a,0,a,n)},o.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new o(n,0,a,0,1,0,-a,0,n)},o.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(n,-a,0,a,n,0,0,0,1)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},o.setColumn=function(e,t,r,n){n=o.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},o.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},o.setRow=function(e,t,r,n){return n=o.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;o.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var E=new e;o.getMaximumScale=function(t){return o.getScale(t,E),e.maximumComponent(E)},o.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],E=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=E,r},o.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},o.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},o.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},o.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},o.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],d=[2,2,1],_=new o,h=new o;return o.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,a=10,l=0,E=0;r(t)||(t={});for(var f=t.unitary=o.clone(o.IDENTITY,t.unitary),d=t.diagonal=o.clone(e,t.diagonal),m=n*u(d);a>E&&s(d)>m;)c(d,_),o.transpose(_,h),o.multiply(d,_,d),o.multiply(h,d,d),o.multiply(f,_,f),++l>2&&(++E,l=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},o.inverse=function(e,t){var r=e[0],a=e[1],u=e[2],s=e[3],c=e[4],l=e[5],E=e[6],f=e[7],d=e[8],_=o.determinant(e);if(Math.abs(_)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=c*d-f*l,t[1]=f*u-a*d,t[2]=a*l-c*u,t[3]=E*l-s*d,t[4]=r*d-E*u,t[5]=s*u-r*l,t[6]=s*f-E*c,t[7]=E*a-r*f,t[8]=r*c-s*a;var h=1/_;return o.multiplyByScalar(t,h,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},o.IDENTITY=a(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=a(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r,n,a){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(a,0)}i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)&&a.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(e,t,n,a,i,o,u,s,c,l,E,f,d,_,h,m){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(_,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(E,0),this[11]=r(h,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(f,0),this[15]=r(m,0)}c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=r(a,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,a){n(a)||(a=new c);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,E=t.x*t.z,f=t.x*t.w,d=t.y*t.y,_=t.y*t.z,h=t.y*t.w,m=t.z*t.z,y=t.z*t.w,T=t.w*t.w,p=s-d-m+T,R=2*(l-y),A=2*(E+h),N=2*(l+y),v=-s+d-m+T,S=2*(_-f),I=2*(E-h),M=2*(_+f),O=-s-d+m+T;return a[0]=p*i,a[1]=N*i,a[2]=I*i,a[3]=0,a[4]=R*o,a[5]=v*o,a[6]=M*o,a[7]=0,a[8]=A*u,a[9]=S*u,a[10]=O*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,E=new e,f=new e;c.fromCamera=function(t,r){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,E),E),e.normalize(e.cross(E,l,f),f);var u=E.x,s=E.y,d=E.z,_=l.x,h=l.y,m=l.z,y=f.x,T=f.y,p=f.z,R=a.x,A=a.y,N=a.z,v=u*-R+s*-A+d*-N,S=y*-R+T*-A+p*-N,I=_*R+h*A+m*N;
return n(r)?(r[0]=u,r[1]=y,r[2]=-_,r[3]=0,r[4]=s,r[5]=T,r[6]=-h,r[7]=0,r[8]=d,r[9]=p,r[10]=-m,r[11]=0,r[12]=v,r[13]=S,r[14]=I,r[15]=1,r):new c(u,s,d,v,y,T,p,S,-_,-h,-m,I,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,E=-(n+r)*s,f=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=E,o[14]=f,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),E=-(i+a)/(i-a),f=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=E,o[11]=f,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,E=-1,f=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=E,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,E=.5*(n-t),f=c,d=l,_=E,h=i+c,m=o+l,y=t+E,T=1;return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=_,a[11]=0,a[12]=h,a[13]=m,a[14]=y,a[15]=T,a},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var d=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),r};var _=new e;c.getMaximumScale=function(t){return c.getScale(t,_),e.maximumComponent(_)},c.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],E=e[8],f=e[9],d=e[10],_=e[11],h=e[12],m=e[13],y=e[14],T=e[15],p=t[0],R=t[1],A=t[2],N=t[3],v=t[4],S=t[5],I=t[6],M=t[7],O=t[8],g=t[9],w=t[10],x=t[11],C=t[12],L=t[13],P=t[14],F=t[15],U=n*p+u*R+E*A+h*N,b=a*p+s*R+f*A+m*N,D=i*p+c*R+d*A+y*N,B=o*p+l*R+_*A+T*N,z=n*v+u*S+E*I+h*M,G=a*v+s*S+f*I+m*M,V=i*v+c*S+d*I+y*M,q=o*v+l*S+_*I+T*M,X=n*O+u*g+E*w+h*x,H=a*O+s*g+f*w+m*x,W=i*O+c*g+d*w+y*x,Y=o*O+l*g+_*w+T*x,k=n*C+u*L+E*P+h*F,K=a*C+s*L+f*P+m*F,Z=i*C+c*L+d*P+y*F,j=o*C+l*L+_*P+T*F;return r[0]=U,r[1]=b,r[2]=D,r[3]=B,r[4]=z,r[5]=G,r[6]=V,r[7]=q,r[8]=X,r[9]=H,r[10]=W,r[11]=Y,r[12]=k,r[13]=K,r[14]=Z,r[15]=j,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=e[12],d=e[13],_=e[14],h=t[0],m=t[1],y=t[2],T=t[4],p=t[5],R=t[6],A=t[8],N=t[9],v=t[10],S=t[12],I=t[13],M=t[14],O=n*h+o*m+c*y,g=a*h+u*m+l*y,w=i*h+s*m+E*y,x=n*T+o*p+c*R,C=a*T+u*p+l*R,L=i*T+s*p+E*R,P=n*A+o*N+c*v,F=a*A+u*N+l*v,U=i*A+s*N+E*v,b=n*S+o*I+c*M+f,D=a*S+u*I+l*M+d,B=i*S+s*I+E*M+_;return r[0]=O,r[1]=g,r[2]=w,r[3]=0,r[4]=x,r[5]=C,r[6]=L,r[7]=0,r[8]=P,r[9]=F,r[10]=U,r[11]=0,r[12]=b,r[13]=D,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=t[0],d=t[1],_=t[2],h=t[3],m=t[4],y=t[5],T=t[6],p=t[7],R=t[8],A=n*f+o*d+c*_,N=a*f+u*d+l*_,v=i*f+s*d+E*_,S=n*h+o*m+c*y,I=a*h+u*m+l*y,M=i*h+s*m+E*y,O=n*T+o*p+c*R,g=a*T+u*p+l*R,w=i*T+s*p+E*R;return r[0]=A,r[1]=N,r[2]=v,r[3]=0,r[4]=S,r[5]=I,r[6]=M,r[7]=0,r[8]=O,r[9]=g,r[10]=w,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var h=new e;c.multiplyByUniformScale=function(e,t,r){return h.x=t,h.y=t,h.z=t,c.multiplyByScale(e,h,r)},c.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new u,y=new u,T=new t,p=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,m),y,o.EPSILON7)&&t.equals(c.getRow(e,3,T),p))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],l=e[12],E=e[1],f=e[5],d=e[9],_=e[13],h=e[2],R=e[6],A=e[10],N=e[14],v=e[3],S=e[7],I=e[11],M=e[15],O=A*M,g=N*I,w=R*M,x=N*S,C=R*I,L=A*S,P=h*M,F=N*v,U=h*I,b=A*v,D=h*S,B=R*v,z=O*f+x*d+C*_-(g*f+w*d+L*_),G=g*E+P*d+b*_-(O*E+F*d+U*_),V=w*E+F*f+D*_-(x*E+P*f+B*_),q=L*E+U*f+B*d-(C*E+b*f+D*d),X=g*a+w*i+L*l-(O*a+x*i+C*l),H=O*n+F*i+U*l-(g*n+P*i+b*l),W=x*n+P*a+B*l-(w*n+F*a+D*l),Y=C*n+b*a+D*i-(L*n+U*a+B*i);O=i*_,g=l*d,w=a*_,x=l*f,C=a*d,L=i*f,P=n*_,F=l*E,U=n*d,b=i*E,D=n*f,B=a*E;var k=O*S+x*I+C*M-(g*S+w*I+L*M),K=g*v+P*I+b*M-(O*v+F*I+U*M),Z=w*v+F*S+D*M-(x*v+P*S+B*M),j=L*v+U*S+B*I-(C*v+b*S+D*I),Q=w*A+L*N+g*R-(C*N+O*R+x*A),J=U*N+O*h+F*A-(P*A+b*N+g*h),$=P*R+B*N+x*h-(D*N+w*h+F*R),ee=D*A+C*h+b*R-(U*R+B*A+L*h),te=n*z+a*G+i*V+l*q;if(Math.abs(te)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=G*te,r[2]=V*te,r[3]=q*te,r[4]=X*te,r[5]=H*te,r[6]=W*te,r[7]=Y*te,r[8]=k*te,r[9]=K*te,r[10]=Z*te,r[11]=j*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],E=e[12],f=e[13],d=e[14],_=-r*E-n*f-a*d,h=-i*E-o*f-u*d,m=-s*E-c*f-l*d;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=_,t[13]=h,t[14]=m,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t,r){this.normal=e.clone(t),this.distance=r}a.fromPointNormal=function(r,n,i){var o=-e.dot(n,r);return t(i)?(e.clone(n,i.normal),i.distance=o,i):new a(n,o)};var i=new e;return a.fromCartesian4=function(r,n){var o=e.fromCartesian4(r,i),u=r.w;return t(n)?(e.clone(o,n.normal),n.distance=u,n):new a(o,u)},a.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},a.ORIGIN_XY_PLANE=n(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=n(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=n(new a(e.UNIT_Y,0)),a}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,r,n,a){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(a,0)}n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,a,i,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),r(o)?(o.west=e,o.south=n,o.east=a,o.north=i,o):new s(e,n,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,E=0,f=e.length;f>E;E++){var d=e[E];n=Math.min(n,d.longitude),a=Math.max(a,d.longitude),c=Math.min(c,d.latitude),l=Math.max(l,d.latitude);var _=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;i=Math.min(i,_),o=Math.max(o,_)}return a-n>o-i&&(n=i,a=o,a>u.PI&&(a-=u.TWO_PI),n>u.PI&&(n-=u.TWO_PI)),r(t)?(t.west=n,t.south=c,t.east=a,t.north=l,t):new s(n,c,a,l)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),E=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&l>=E)){var f=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(f>=d))return r(n)?(n.west=l,n.south=f,n.east=E,n.north=d,n):new s(l,f,E,d)}},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,a,o){n=t(n,i.WGS84),a=t(a,0),r(o)||(o=[]);var l=0,E=e.north,f=e.south,d=e.east,_=e.west,h=c;h.height=a,h.longitude=_,h.latitude=E,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=d,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.latitude=f,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=_,o[l]=n.cartographicToCartesian(h,o[l]),l++,0>E?h.latitude=E:f>0?h.latitude=f:h.latitude=0;for(var m=1;8>m;++m)h.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,h)&&(o[l]=n.cartographicToCartesian(h,o[l]),l++);return 0===h.latitude&&(h.longitude=_,o[l]=n.cartographicToCartesian(h,o[l]),l++,h.longitude=d,o[l]=n.cartographicToCartesian(h,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l,E,f){"use strict";function d(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)}var _=new e,h=new e,m=new e,y=new e,T=new e,p=new e,R=new e,A=new e,N=new e,v=new e,S=new e,I=new e;d.fromPoints=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var a=e.clone(t[0],R),i=e.clone(a,_),o=e.clone(a,h),u=e.clone(a,m),s=e.clone(a,y),c=e.clone(a,T),l=e.clone(a,p),E=t.length,f=1;E>f;f++){e.clone(t[f],a);var M=a.x,O=a.y,g=a.z;M<i.x&&e.clone(a,i),M>s.x&&e.clone(a,s),O<o.y&&e.clone(a,o),O>c.y&&e.clone(a,c),g<u.z&&e.clone(a,u),g>l.z&&e.clone(a,l)}var w=e.magnitudeSquared(e.subtract(s,i,A)),x=e.magnitudeSquared(e.subtract(c,o,A)),C=e.magnitudeSquared(e.subtract(l,u,A)),L=i,P=s,F=w;x>F&&(F=x,L=o,P=c),C>F&&(F=C,L=u,P=l);var U=N;U.x=.5*(L.x+P.x),U.y=.5*(L.y+P.y),U.z=.5*(L.z+P.z);var b=e.magnitudeSquared(e.subtract(P,U,A)),D=Math.sqrt(b),B=v;B.x=i.x,B.y=o.y,B.z=u.z;var z=S;z.x=s.x,z.y=c.y,z.z=l.z;var G=e.multiplyByScalar(e.add(B,z,A),.5,I),V=0;for(f=0;E>f;f++){e.clone(t[f],a);var q=e.magnitude(e.subtract(a,G,A));q>V&&(V=q);var X=e.magnitudeSquared(e.subtract(a,U,A));if(X>b){var H=Math.sqrt(X);D=.5*(D+H),b=D*D;var W=H-D;U.x=(D*U.x+W*a.x)/H,U.y=(D*U.y+W*a.y)/H,U.z=(D*U.z+W*a.z)/H}}return V>D?(e.clone(U,r.center),r.radius=D):(e.clone(G,r.center),r.radius=V),r};var M=new o,O=new e,g=new e,w=new t,x=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,a,i,o,u){if(n(u)||(u=new d),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=r(a,M),f.southwest(t,w),w.height=i,f.northeast(t,x),x.height=o;var s=a.project(w,O),c=a.project(x,g),l=c.x-s.x,E=c.y-s.y,_=c.z-s.z;u.radius=.5*Math.sqrt(l*l+E*E+_*_);var h=u.center;return h.x=s.x+.5*l,h.y=s.y+.5*E,h.z=s.z+.5*_,u};var C=[];d.fromRectangle3D=function(e,t,a,o){t=r(t,i.WGS84),a=r(a,0);var u;return n(e)&&(u=f.subsample(e,t,a,C)),d.fromPoints(u,o)},d.fromVertices=function(t,a,i,o){if(n(o)||(o=new d),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=r(a,e.ZERO),i=r(i,3);var u=R;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,_),c=e.clone(u,h),l=e.clone(u,m),E=e.clone(u,y),f=e.clone(u,T),M=e.clone(u,p),O=t.length,g=0;O>g;g+=i){var w=t[g]+a.x,x=t[g+1]+a.y,C=t[g+2]+a.z;u.x=w,u.y=x,u.z=C,w<s.x&&e.clone(u,s),w>E.x&&e.clone(u,E),x<c.y&&e.clone(u,c),x>f.y&&e.clone(u,f),C<l.z&&e.clone(u,l),C>M.z&&e.clone(u,M)}var L=e.magnitudeSquared(e.subtract(E,s,A)),P=e.magnitudeSquared(e.subtract(f,c,A)),F=e.magnitudeSquared(e.subtract(M,l,A)),U=s,b=E,D=L;P>D&&(D=P,U=c,b=f),F>D&&(D=F,U=l,b=M);var B=N;B.x=.5*(U.x+b.x),B.y=.5*(U.y+b.y),B.z=.5*(U.z+b.z);var z=e.magnitudeSquared(e.subtract(b,B,A)),G=Math.sqrt(z),V=v;V.x=s.x,V.y=c.y,V.z=l.z;var q=S;q.x=E.x,q.y=f.y,q.z=M.z;var X=e.multiplyByScalar(e.add(V,q,A),.5,I),H=0;for(g=0;O>g;g+=i){u.x=t[g]+a.x,u.y=t[g+1]+a.y,u.z=t[g+2]+a.z;var W=e.magnitude(e.subtract(u,X,A));W>H&&(H=W);var Y=e.magnitudeSquared(e.subtract(u,B,A));if(Y>z){var k=Math.sqrt(Y);G=.5*(G+k),z=G*G;var K=k-G;B.x=(G*B.x+K*u.x)/k,B.y=(G*B.y+K*u.y)/k,B.z=(G*B.z+K*u.z)/k}}return H>G?(e.clone(B,o.center),o.radius=G):(e.clone(X,o.center),o.radius=H),o},d.fromCornerPoints=function(t,r,a){n(a)||(a=new d);var i=a.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,r),a},d.fromEllipsoid=function(t,r){return n(r)||(r=new d),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var L=new e;d.fromBoundingSpheres=function(t,r){if(n(r)||(r=new d),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=t.length;if(1===a)return d.clone(t[0],r);if(2===a)return d.union(t[0],t[1],r);for(var i=[],o=0;a>o;o++)i.push(t[o].center);r=d.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,L)+c.radius)}return r.radius=s,r};var P=new e,F=new e,U=new e;d.fromOrientedBoundingBox=function(t,r){n(r)||(r=new d);var a=t.halfAxes,i=c.getColumn(a,0,P),o=c.getColumn(a,1,F),u=c.getColumn(a,2,U),s=e.magnitude(i),l=e.magnitude(o),E=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,l,E),r},d.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,n){n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},d.unpack=function(e,t,a){t=r(t,0),n(a)||(a=new d);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var b=new e,D=new e;d.union=function(t,r,a){n(a)||(a=new d);var i=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,b),l=e.magnitude(c);if(o>=l+s)return t.clone(a),a;if(s>=l+o)return r.clone(a),a;var E=.5*(o+l+s),f=e.multiplyByScalar(c,(-o+E)/l,D);return e.add(f,i,f),e.clone(f,a.center),a.radius=E,a};var B=new e;d.expand=function(t,r,n){n=d.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,B));return a>n.radius&&(n.radius=a),n},d.intersectPlane=function(t,r){var n=t.center,a=t.radius,i=r.normal,o=e.dot(i,n)+r.distance;return-a>o?u.OUTSIDE:a>o?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var z=new e;d.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,z);return e.magnitudeSquared(n)-t.radius*t.radius},d.transformWithoutScale=function(e,t,r){return n(r)||(r=new d),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var G=new e;d.computePlaneDistances=function(t,r,a,i){n(i)||(i=new s);var o=e.subtract(t.center,r,G),u=e.dot(a,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var V=new e,q=new e,X=new e,H=new e,W=new e,Y=new t,k=new Array(8),K=0;8>K;++K)k[K]=new e;var Z=new o;return d.projectTo2D=function(t,n,a){n=r(n,Z);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,V),c=e.cross(e.UNIT_Z,s,q);e.normalize(c,c);var l=e.cross(s,c,X);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var E=e.negate(l,W),f=e.negate(c,H),_=k,h=_[0];e.add(s,l,h),e.add(h,c,h),h=_[1],e.add(s,l,h),e.add(h,f,h),h=_[2],e.add(s,E,h),e.add(h,f,h),h=_[3],e.add(s,E,h),e.add(h,c,h),e.negate(s,s),h=_[4],e.add(s,l,h),e.add(h,c,h),h=_[5],e.add(s,l,h),e.add(h,f,h),h=_[6],e.add(s,E,h),e.add(h,f,h),h=_[7],e.add(s,E,h),e.add(h,c,h);for(var m=_.length,y=0;m>y;++y){var T=_[y];e.add(o,T,T);var p=i.cartesianToCartographic(T,Y);n.project(p,T)}a=d.fromPoints(_,a),o=a.center;var R=o.x,A=o.y,N=o.z;return o.x=N,o.y=R,o.z=A,a},d.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";function i(t,r){this.x=e(t,0),this.y=e(r,0)}i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,
CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?n.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(n.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[n.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(y=!0,T=n(e[1]))}return y}function i(){return a()&&T}function o(){if(!t(p)&&(p=!1,!a()&&/ Safari\/[\.0-9]+/.test(m.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(p=!0,R=n(e[1]))}return p}function u(){return o()&&R}function s(){if(!t(A)){A=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(m.userAgent);null!==e&&(A=!0,N=n(e[1]),N.isNightly=!!e[2])}return A}function c(){return s()&&N}function l(){if(!t(v)){v=!1;var e;"Microsoft Internet Explorer"===m.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(v=!0,S=n(e[1]))):"Netscape"===m.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(m.userAgent),null!==e&&(v=!0,S=n(e[1])))}return v}function E(){return l()&&S}function f(){if(!t(I)){I=!1;var e=/Firefox\/([\.0-9]+)/.exec(m.userAgent);null!==e&&(I=!0,M=n(e[1]))}return I}function d(){return t(O)||(O=/Windows/i.test(m.appVersion)),O}function _(){return f()&&M}function h(){return t(g)||(g="undefined"!=typeof PointerEvent&&(!t(m.pointerEnabled)||m.pointerEnabled)),g}var m;m="undefined"!=typeof navigator?navigator:{};var y,T,p,R,A,N,v,S,I,M,O,g,w={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:E,isFirefox:f,firefoxVersion:_,isWindows:d,hardwareConcurrency:e(m.hardwareConcurrency,3),supportsPointerEvents:h};return w.supportsFullscreen=function(){return r.supportsFullscreen()},w.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},w.supportsWebWorkers=function(){return"undefined"!=typeof Worker},w}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,a,i){"use strict";if(!a.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return r(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,r,a,i){switch(a=t(a,0),i=t(i,(r.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(r,a,i);case o.UNSIGNED_BYTE:return new Uint8Array(r,a,i);case o.SHORT:return new Int16Array(r,a,i);case o.UNSIGNED_SHORT:return new Uint16Array(r,a,i);case o.FLOAT:return new Float32Array(r,a,i);case o.DOUBLE:return new Float64Array(r,a,i);default:throw new n("componentDatatype is not a valid value.")}},i(o)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)}var c=new e;s.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,E=c.z*o,f=Math.cos(i);return r(a)?(a.x=u,a.y=l,a.z=E,a.w=f,a):new s(u,l,E,f)};var l=[1,2,0],E=new Array(3);s.fromRotationMatrix=function(e,t){var n,a,i,o,c,f=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],_=e[u.COLUMN2ROW2],h=f+d+_;if(h>0)n=Math.sqrt(h+1),c=.5*n,n=.5/n,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var m=l,y=0;d>f&&(y=1),_>f&&_>d&&(y=2);var T=m[y],p=m[T];n=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(T,T)]-e[u.getElementIndex(p,p)]+1);var R=E;R[y]=.5*n,n=.5/n,c=(e[u.getElementIndex(p,T)]-e[u.getElementIndex(T,p)])*n,R[T]=(e[u.getElementIndex(T,y)]+e[u.getElementIndex(y,T)])*n,R[p]=(e[u.getElementIndex(p,y)]+e[u.getElementIndex(y,p)])*n,a=-R[0],i=-R[1],o=-R[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var f=new s;s.fromHeadingPitchRoll=function(t,r,n,a){var i=s.fromAxisAngle(e.UNIT_X,n,f),o=s.fromAxisAngle(e.UNIT_Y,-r,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,f);return s.multiply(u,a,a)};var d=new e,_=new e,h=new s,m=new s,y=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.x=e[n],a.y=e[n+1],a.z=e[n+2],a.w=e[n+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,y),s.conjugate(y,y);for(var a=0,i=r-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),h),s.multiply(h,y,h),h.w<0&&s.negate(h,h),s.computeAxis(h,d);var u=s.computeAngle(h);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new s),e.fromArray(t,0,_);var u=e.magnitude(_);return s.unpack(n,4*i,m),0===u?s.clone(s.IDENTITY,h):s.fromAxisAngle(_,u,h),s.multiply(h,m,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,E=o*u+n*l+a*c-i*s,f=o*s-n*c+a*l+i*u,d=o*c+n*s-a*u+i*l,_=o*l-n*u-a*s-i*c;return r.x=E,r.y=f,r.z=d,r.w=_,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,t,r,n){return T=s.multiplyByScalar(t,r,T),n=s.multiplyByScalar(e,1-r,n),s.add(T,n,n)};var p=new s,R=new s,A=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=p=s.negate(t,p)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return R=s.multiplyByScalar(e,Math.sin((1-r)*u),R),A=s.multiplyByScalar(i,Math.sin(r*u),A),n=s.add(R,A,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var N=new e,v=new e,S=new s,I=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,S);s.multiply(i,n,I);var o=s.log(I,N);s.multiply(i,t,I);var u=s.log(I,v);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,S),s.multiply(r,S,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,S),u=s.slerp(r,n,a,I);return s.slerp(o,u,2*a*(1-a),i)};for(var M=new s,O=1.9011074535173003,g=a.supportsTypedArrays()?new Float32Array(8):[],w=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],L=0;7>L;++L){var P=L+1,F=2*P+1;g[L]=1/(P*F),w[L]=P/F}return g[7]=O/136,w[7]=8*O/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,E=7;E>=0;--E)x[E]=(g[E]*c-w[E])*o,C[E]=(g[E]*l-w[E])*o;var f=a*r*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),d=u*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),_=s.multiplyByScalar(e,d,M);return s.multiplyByScalar(t,f,n),s.add(_,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,S),u=s.fastSlerp(r,n,a,I);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,n){"use strict";function a(t,a,i,l,E,f,d,_,h,m){var y=t+a;e.multiplyByScalar(l,Math.cos(y),o),e.multiplyByScalar(i,Math.sin(y),u),e.add(o,u,o);var T=Math.cos(t);T*=T;var p=Math.sin(t);p*=p;var R=f/Math.sqrt(d*T+E*p),A=R/_;return n.fromAxisAngle(o,A,s),r.fromQuaternion(s,c),r.multiplyByVector(c,h,m),e.normalize(m,m),e.multiplyByScalar(m,_,m),m}var i={},o=new e,u=new e,s=new n,c=new r,l=new e,E=new e,f=new e,d=new e;i.raisePositionsToHeight=function(t,r,n){for(var a=r.ellipsoid,i=r.height,o=r.extrudedHeight,u=n?t.length/3*2:t.length/3,s=new Float64Array(3*u),c=t.length,_=n?c:0,h=0;c>h;h+=3){var m=h+1,y=h+2,T=e.fromArray(t,h,l);a.scaleToGeodeticSurface(T,T);var p=e.clone(T,E),R=a.geodeticSurfaceNormal(T,d),A=e.multiplyByScalar(R,i,f);e.add(T,A,T),n&&(e.multiplyByScalar(R,o,A),e.add(p,A,p),s[h+_]=p.x,s[m+_]=p.y,s[y+_]=p.z),s[h]=T.x,s[m]=T.y,s[y]=T.z}return s};var _=new e,h=new e,m=new e;return i.computeEllipsePositions=function(r,n,i){var o=r.semiMinorAxis,u=r.semiMajorAxis,s=r.rotation,c=r.center,d=8*r.granularity,y=o*o,T=u*u,p=u*o,R=e.magnitude(c),A=e.normalize(c,_),N=e.cross(e.UNIT_Z,c,h);N=e.normalize(N,N);var v=e.cross(A,N,m),S=1+Math.ceil(t.PI_OVER_TWO/d),I=t.PI_OVER_TWO/(S-1),M=t.PI_OVER_TWO-S*I;0>M&&(S-=Math.ceil(Math.abs(M)/I));var O,g,w,x,C,L=2*(S*(S+2)),P=n?new Array(3*L):void 0,F=0,U=l,b=E,D=4*S*3,B=D-1,z=0,G=i?new Array(D):void 0;for(M=t.PI_OVER_TWO,U=a(M,s,v,N,y,p,T,R,A,U),n&&(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z),i&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x),M=t.PI_OVER_TWO-I,O=1;S+1>O;++O){if(U=a(M,s,v,N,y,p,T,R,A,U),b=a(Math.PI-M,s,v,N,y,p,T,R,A,b),n){for(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z,w=2*O+2,g=1;w-1>g;++g)x=g/(w-1),C=e.lerp(U,b,x,f),P[F++]=C.x,P[F++]=C.y,P[F++]=C.z;P[F++]=b.x,P[F++]=b.y,P[F++]=b.z}i&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x,G[z++]=b.x,G[z++]=b.y,G[z++]=b.z),M=t.PI_OVER_TWO-(O+1)*I}for(O=S;O>1;--O){if(M=t.PI_OVER_TWO-(O-1)*I,U=a(-M,s,v,N,y,p,T,R,A,U),b=a(M+Math.PI,s,v,N,y,p,T,R,A,b),n){for(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z,w=2*(O-1)+2,g=1;w-1>g;++g)x=g/(w-1),C=e.lerp(U,b,x,f),P[F++]=C.x,P[F++]=C.y,P[F++]=C.z;P[F++]=b.x,P[F++]=b.y,P[F++]=b.z}i&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x,G[z++]=b.x,G[z++]=b.y,G[z++]=b.z)}M=t.PI_OVER_TWO,U=a(-M,s,v,N,y,p,T,R,A,U);var V={};return n&&(P[F++]=U.x,P[F++]=U.y,P[F++]=U.z,V.positions=P,V.numPts=S),i&&(G[B--]=U.z,G[B--]=U.y,G[B--]=U.x,V.outerPositions=G),V},i}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0}return i.computeNumberOfVertices=function(e){var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*a.signNotZero(r),t.y=(1-Math.abs(r))*a.signNotZero(n)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=a.fromSNorm(e),n.y=a.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*a.signNotZero(i),n.y=(1-Math.abs(i))*a.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(n,a,s,c,l){r(l)||(l=new t);var E,f,d,_,h,m,y,T;r(a.z)?(E=t.subtract(s,a,i),f=t.subtract(c,a,o),d=t.subtract(n,a,u),_=t.dot(E,E),h=t.dot(E,f),m=t.dot(E,d),y=t.dot(f,f),T=t.dot(f,d)):(E=e.subtract(s,a,i),f=e.subtract(c,a,o),d=e.subtract(n,a,u),_=e.dot(E,E),h=e.dot(E,f),m=e.dot(E,d),y=e.dot(f,f),T=e.dot(f,d));var p=1/(_*y-h*h);return l.y=(y*m-h*T)*p,l.z=(_*T-h*m)*p,l.x=1-l.y-l.z,l}var i=new t,o=new t,u=new t;return a}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var a={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var i=r.high,o=r.low;return n.encode(e.x,a),i.x=a.high,o.x=a.low,n.encode(e.y,a),i.y=a.high,o.y=a.low,n.encode(e.z,a),i.z=a.high,o.z=a.low,r};var i=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,i);var a=i.high,o=i.low;t[r]=a.x,t[r+1]=a.y,t[r+2]=a.z,t[r+3]=o.x,t[r+4]=o.y,t[r+5]=o.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,n){return e>=a.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,n):new Uint16Array(t,r,n)},n(i)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*a,E=r(c,-l,t.EPSILON14);if(0>E)return[];var f=-.5*r(n,t.sign(n)*Math.sqrt(E),t.EPSILON14);return n>0?[f/e,a/f]:[a/f,f/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,E=u*c,f=u*u,d=s*s,_=o*s-f,h=o*c-u*s,m=u*c-d,y=4*_*m-h*h;if(0>y){var T,p,R;f*E>=l*d?(T=o,p=_,R=-2*u*_+o*h):(T=c,p=m,R=-c*h+2*s*m);var A=0>R?-1:1,N=-A*Math.abs(T)*Math.sqrt(-y);i=-R+N;var v=i/2,S=0>v?-Math.pow(-v,1/3):Math.pow(v,1/3),I=i===N?-S:-p/S;return a=0>=p?S+I:-R/(S*S+I*I+p),f*E>=l*d?[(a-u)/o]:[-c/(a+s)]}var M=_,O=-2*u*_+o*h,g=m,w=-c*h+2*s*m,x=Math.sqrt(y),C=Math.sqrt(3)/2,L=Math.abs(Math.atan2(o*x,-O)/3);a=2*Math.sqrt(-M);var P=Math.cos(L);i=a*P;var F=a*(-P/2-C*Math.sin(L)),U=i+F>2*u?i-u:F-u,b=o,D=U/b;L=Math.abs(Math.atan2(c*x,-w)/3),a=2*Math.sqrt(-g),P=Math.cos(L),i=a*P,F=a*(-P/2-C*Math.sin(L));var B=-c,z=2*s>i+F?i+s:F+s,G=B/z,V=b*z,q=-U*z-b*B,X=U*B,H=(s*q-u*X)/(-u*q+s*V);return H>=D?G>=D?G>=H?[D,H,G]:[D,G,H]:[G,D,H]:G>=D?[H,D,G]:G>=H?[H,G,D]:[G,H,D]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,E=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(E.length>0){var f=-t/4,d=E[E.length-1];if(Math.abs(d)<r.EPSILON14){var _=n.computeRealRoots(1,s,l);if(2===_.length){var h,m=_[0],y=_[1];if(m>=0&&y>=0){var T=Math.sqrt(m),p=Math.sqrt(y);return[f-p,f-T,f+T,f+p]}if(m>=0&&0>y)return h=Math.sqrt(m),[f-h,f+h];if(0>m&&y>=0)return h=Math.sqrt(y),[f-h,f+h]}return[]}if(d>0){var R=Math.sqrt(d),A=(s+d-c/R)/2,N=(s+d+c/R)/2,v=n.computeRealRoots(1,R,A),S=n.computeRealRoots(1,-R,N);return 0!==v.length?(v[0]+=f,v[1]+=f,0!==S.length?(S[0]+=f,S[1]+=f,v[1]<=S[0]?[v[0],v[1],S[0],S[1]]:S[1]<=v[0]?[S[0],S[1],v[0],v[1]]:v[0]>=S[0]&&v[1]<=S[1]?[S[0],v[0],v[1],S[1]]:S[0]>=v[0]&&S[1]<=v[1]?[v[0],S[0],S[1],v[1]]:v[0]>S[0]&&v[0]<S[1]?[S[0],v[0],S[1],v[1]]:[v[0],S[0],v[1],S[1]]):v):0!==S.length?(S[0]+=f,S[1]+=f,S):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,E=i*t+s-4*o,f=c*o-i*a*t+u,d=e.computeRealRoots(1,l,E,f);if(d.length>0){var _,h,m=d[0],y=a-m,T=y*y,p=t/2,R=y/2,A=T-4*o,N=T+4*Math.abs(o),v=c-4*m,S=c+4*Math.abs(m);if(0>m||v*N>A*S){var I=Math.sqrt(v);_=I/2,h=0===I?0:(t*R-i)/I}else{var M=Math.sqrt(A);_=0===M?0:(t*R-i)/M,h=M/2}var O,g;0===p&&0===_?(O=0,g=0):r.sign(p)===r.sign(_)?(O=p+_,g=m/O):(g=p-_,O=m/g);var w,x;0===R&&0===h?(w=0,x=0):r.sign(R)===r.sign(h)?(w=R+h,x=o/w):(x=R-h,w=o/x);var C=n.computeRealRoots(1,O,w),L=n.computeRealRoots(1,g,x);if(0!==C.length)return 0!==L.length?C[1]<=L[0]?[C[0],C[1],L[0],L[1]]:L[1]<=C[0]?[L[0],L[1],C[0],C[1]]:C[0]>=L[0]&&C[1]<=L[1]?[L[0],C[0],C[1],L[1]]:L[0]>=C[0]&&L[1]<=C[1]?[C[0],L[0],L[1],C[1]]:C[0]>L[0]&&C[0]<L[1]?[L[0],C[0],L[1],C[1]]:[C[0],L[0],C[1],L[1]]:C;if(0!==L.length)return L}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,E=n*n,f=E*n,d=a*a,_=d*a,h=u*c*E-4*s*f-4*e*l*E+18*e*t*r*f-27*i*E*E+256*o*_+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*E+144*i*r*E)+d*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return h},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,E=u/t,f=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>E?d+1:d,d+=0>f?d+1:d){case 0:return a(c,l,E,f);case 1:return i(c,l,E,f);case 2:return i(c,l,E,f);case 3:return a(c,l,E,f);case 4:return a(c,l,E,f);case 5:return i(c,l,E,f);case 6:return a(c,l,E,f);case 7:return a(c,l,E,f);case 8:return i(c,l,E,f);case 9:return a(c,l,E,f);case 10:return a(c,l,E,f);case 11:return i(c,l,E,f);case 12:return a(c,l,E,f);case 13:return a(c,l,E,f);case 14:return a(c,l,E,f);case 15:return a(c,l,E,f);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(r,n){n=e.clone(t(n,e.ZERO)),
e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return a.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,n,a,o,u){u=r(u,!1);var s,c,l,E,f,d=t.origin,_=t.direction,h=e.subtract(a,n,m),A=e.subtract(o,n,y),N=e.cross(_,A,T),v=e.dot(h,N);if(u){if(v<i.EPSILON6)return;if(s=e.subtract(d,n,p),l=e.dot(s,N),0>l||l>v)return;if(c=e.cross(s,h,R),E=e.dot(_,c),0>E||l+E>v)return;f=e.dot(A,c)/v}else{if(Math.abs(v)<i.EPSILON6)return;var S=1/v;if(s=e.subtract(d,n,p),l=e.dot(s,N)*S,0>l||l>1)return;if(c=e.cross(s,h,R),E=e.dot(_,c)*S,0>E||l+E>1)return;f=e.dot(A,c)*S}return f}function E(e,t,r,n){var a=t*t-4*e*r;if(!(0>a)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function f(t,r,a){n(a)||(a={});var i=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,T),l=e.dot(o,o),f=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,_=E(l,f,d,N);return n(_)?(a.start=_.root0,a.stop=_.root1,a):void 0}function d(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function _(t,r,n,a,c){var l,E=a*a,f=c*c,_=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*f,h=c*(a*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+r.y),m=t[o.COLUMN0ROW0]*E+t[o.COLUMN2ROW2]*f+a*r.x+n,y=f*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),T=c*(a*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),p=[];if(0===T&&0===y){if(l=u.computeRealRoots(_,h,m),0===l.length)return p;var R=l[0],A=Math.sqrt(Math.max(1-R*R,0));if(p.push(new e(a,c*R,c*-A)),p.push(new e(a,c*R,c*A)),2===l.length){var N=l[1],v=Math.sqrt(Math.max(1-N*N,0));p.push(new e(a,c*N,c*-v)),p.push(new e(a,c*N,c*v))}return p}var S=T*T,I=y*y,M=_*_,O=T*y,g=M+I,w=2*(h*_+O),x=2*m*_+h*h-I+S,C=2*(m*h-O),L=m*m-S;if(0===g&&0===w&&0===x&&0===C)return p;l=s.computeRealRoots(g,w,x,C,L);var P=l.length;if(0===P)return p;for(var F=0;P>F;++F){var U,b=l[F],D=b*b,B=Math.max(1-D,0),z=Math.sqrt(B);U=i.sign(_)===i.sign(m)?d(_*D+m,h*b,i.EPSILON12):i.sign(m)===i.sign(h*b)?d(_*D,h*b+m,i.EPSILON12):d(_*D+h*b,m,i.EPSILON12);var G=d(y*b,T,i.EPSILON15),V=U*G;0>V?p.push(new e(a,c*b,c*z)):V>0?p.push(new e(a,c*b,c*-z)):0!==z?(p.push(new e(a,c*b,c*-z)),p.push(new e(a,c*b,c*z)),++F):p.push(new e(a,c*b,c*z))}return p}var h={};h.rayPlane=function(t,r,a){n(a)||(a=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON15)){var l=(-r.distance-e.dot(s,o))/c;if(!(0>l))return a=e.multiplyByScalar(u,l,a),e.add(o,a,a)}};var m=new e,y=new e,T=new e,p=new e,R=new e;h.rayTriangle=function(t,r,a,i,o,u){var s=l(t,r,a,i,o);if(n(s)&&!(0>s))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var A=new c;h.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=A;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var E=l(c,a,i,o,u);return!n(E)||0>E||E>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,E,s),e.add(c.origin,s,s))};var N={root0:0,root1:0};h.raySphere=function(e,t,r){return r=f(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var v=new c;h.lineSegmentSphere=function(t,r,a,i){var o=v,u=e.subtract(r,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=f(o,a,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var S=new e,I=new e;h.rayEllipsoid=function(t,r){var n,a,i,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,S),l=e.multiplyComponents(s,t.direction,I),E=e.magnitudeSquared(c),f=e.dot(c,l);if(E>1){if(f>=0)return;var d=f*f;if(n=E-1,a=e.magnitudeSquared(l),i=a*n,i>d)return;if(d>i){o=f*f-i,u=-f+Math.sqrt(o);var _=u/a,h=n/u;return h>_?{start:_,stop:h}:{start:h,stop:_}}var m=Math.sqrt(n/a);return{start:m,stop:m}}return 1>E?(n=E-1,a=e.magnitudeSquared(l),i=a*n,o=f*f-i,u=-f+Math.sqrt(o),{start:0,stop:u/a}):0>f?(a=e.magnitudeSquared(l),{start:0,stop:-f/a}):void 0};var M=new e,O=new e,g=new e,w=new e,x=new e,C=new o,L=new o,P=new o,F=new o,U=new o,b=new o,D=new o,B=new e,z=new e,G=new t;h.grazingAltitudeLocation=function(t,r){var a=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(a,M);if(e.dot(u,s)>=0)return a;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,M),E=e.normalize(l,l),f=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(f,E,O),O),h=e.normalize(e.cross(E,d,g),g),m=C;m[0]=E.x,m[1]=E.y,m[2]=E.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=h.x,m[7]=h.y,m[8]=h.z;var y=o.transpose(m,L),T=o.fromScale(r.radii,P),p=o.fromScale(r.oneOverRadii,F),R=U;R[0]=0,R[1]=-u.z,R[2]=u.y,R[3]=u.z,R[4]=0,R[5]=-u.x,R[6]=-u.y,R[7]=u.x,R[8]=0;var A,N,v=o.multiply(o.multiply(y,p,b),R,b),S=o.multiply(o.multiply(v,T,D),m,D),I=o.multiplyByVector(v,a,x),V=_(S,e.negate(I,M),0,0,1),q=V.length;if(q>0){for(var X=e.clone(e.ZERO,z),H=Number.NEGATIVE_INFINITY,W=0;q>W;++W){A=o.multiplyByVector(T,o.multiplyByVector(m,V[W],B),B);var Y=e.normalize(e.subtract(A,a,w),w),k=e.dot(Y,u);k>H&&(H=k,X=e.clone(A,X))}var K=r.cartesianToCartographic(X,G);return H=i.clamp(H,0,1),N=e.magnitude(e.subtract(X,a,w))*Math.sqrt(1-H*H),N=c?-N:N,K.height=N,r.cartographicToCartesian(K,new e)}};var V=new e;return h.lineSegmentPlane=function(t,r,a,o){n(o)||(o=new e);var u=e.subtract(r,t,V),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<i.EPSILON6)){var l=e.dot(s,t),E=-(a.distance+l)/c;if(!(0>E||E>1))return e.multiplyByScalar(u,E,o),e.add(t,o,o),o}},h.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var E,f;if((1===l||2===l)&&(E=new e,f=new e),1===l){if(u)return h.lineSegmentPlane(t,r,a,E),h.lineSegmentPlane(t,n,a,f),{positions:[t,r,n,E,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return h.lineSegmentPlane(r,n,a,E),h.lineSegmentPlane(r,t,a,f),{positions:[t,r,n,E,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return h.lineSegmentPlane(n,t,a,E),h.lineSegmentPlane(n,r,a,f),{positions:[t,r,n,E,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return h.lineSegmentPlane(r,t,a,E),h.lineSegmentPlane(n,t,a,f),{positions:[t,r,n,E,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return h.lineSegmentPlane(n,r,a,E),h.lineSegmentPlane(t,r,a,f),{positions:[t,r,n,E,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return h.lineSegmentPlane(t,n,a,E),h.lineSegmentPlane(r,n,a,f),{positions:[t,r,n,E,f],indices:[0,1,4,0,4,3,2,3,4]}}},h}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];o>u;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var E=i+1,f=0;o>f;++f)E-c[n[f]]>i&&(c[n[f]]=E,++E);return(E-i+1)/(o/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,E=0;E<r.length;){var f=r[E];a[f].numLiveTriangles&&(s=0,i-a[f].timeStamp+2*a[f].numLiveTriangles<=t&&(s=i-a[f].timeStamp),(s>l||-1===l)&&(l=s,c=f)),++E}return-1===c?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,E=0,f=o[E],d=c;if(t(u))l=u+1;else{for(;d>E;)f>l&&(l=f),++E,f=o[E];if(-1===l)return 0;++l}for(var _=[],h=0;l>h;h++)_[h]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};E=0;for(var m=0;d>E;)_[o[E]].vertexTriangles.push(m),++_[o[E]].numLiveTriangles,_[o[E+1]].vertexTriangles.push(m),++_[o[E+1]].numLiveTriangles,_[o[E+2]].vertexTriangles.push(m),++_[o[E+2]].numLiveTriangles,++m,E+=3;var y=0,T=s+1;i=1;var p,R,A=[],N=[],v=0,S=[],I=c/3,M=[];for(h=0;I>h;h++)M[h]=!1;for(var O,g;-1!==y;){A=[],R=_[y],g=R.vertexTriangles.length;for(var w=0;g>w;++w)if(m=R.vertexTriangles[w],!M[m]){M[m]=!0,E=m+m+m;for(var x=0;3>x;++x)O=o[E],A.push(O),N.push(O),S[v]=O,++v,p=_[O],--p.numLiveTriangles,T-p.timeStamp>s&&(p.timeStamp=T,++T),++E}y=a(o,s,A,_,T,N,l)}return S},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,E,f,d,_,h,m,y,T,p,R,A,N,v,S,I){"use strict";function M(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function O(e){for(var t=e.length,r=t/3*6,n=y.createTypedArray(t,r),a=0,i=0;t>i;i+=3,a+=6)M(n,a,e[i],e[i+1],e[i+2]);return n}function g(e){var t=e.length;if(t>=3){var r=6*(t-2),n=y.createTypedArray(t,r);M(n,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)M(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function w(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=y.createTypedArray(t,r),a=e[0],i=0,o=1;t>o;++o,i+=6)M(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function x(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new _({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function C(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function L(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),N.multiplyByPoint(e,ie,ie),a.pack(ie,r,i)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,ie),A.multiplyByVector(e,ie,ie),ie=a.normalize(ie,ie),a.pack(ie,r,i)}function F(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,E=1;n>E;++E){var f=e[E][t].attributes[r];if(!c(f)||o.componentDatatype!==f.componentDatatype||o.componentsPerAttribute!==f.componentsPerAttribute||o.normalize!==f.normalize){l=!1;break}s+=f.values.length}l&&(a[r]=new _({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function U(e,t){var n,i,o,u,s,l,E,f=e.length,_=(e[0].modelMatrix,c(e[0][t].indices)),h=e[0][t].primitiveType,m=F(e,t);for(n in m)if(m.hasOwnProperty(n))for(s=m[n].values,u=0,i=0;f>i;++i)for(l=e[i][t].attributes[n].values,E=l.length,o=0;E>o;++o)s[u++]=l[o];var T;if(_){var p=0;for(i=0;f>i;++i)p+=e[i][t].indices.length;var R=d.computeNumberOfVertices(new d({attributes:m,primitiveType:S.POINTS})),A=y.createTypedArray(R,p),N=0,v=0;for(i=0;f>i;++i){var I=e[i][t].indices,M=I.length;for(u=0;M>u;++u)A[N++]=v+I[u];v+=d.computeNumberOfVertices(e[i][t])}T=A}var O,g=new a,w=0;for(i=0;f>i;++i){if(O=e[i][t].boundingSphere,!c(O)){g=void 0;break}a.add(O.center,g,g)}if(c(g))for(a.divideByScalar(g,f,g),i=0;f>i;++i){O=e[i][t].boundingSphere;var x=a.magnitude(a.subtract(O.center,g,se))+O.radius;x>w&&(w=x)}return new d({attributes:m,indices:T,primitiveType:h,boundingSphere:c(g)?new r(g,w):void 0})}function b(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function D(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;t>a;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=S.TRIANGLES,e}function B(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;t-1>a;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,t>a+2&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=S.TRIANGLES,e}function z(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=S.LINES,e}function V(e){var t=d.computeNumberOfVertices(e),r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=S.LINES,e}function q(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return D(e);case S.TRIANGLE_STRIP:return B(e);case S.TRIANGLES:return b(e);case S.LINE_STRIP:return G(e);case S.LINE_LOOP:return V(e);case S.LINES:return z(e)}return e}function X(e,t){Math.abs(e.y)<R.EPSILON6&&(t?e.y=-R.EPSILON6:e.y=R.EPSILON6)}function H(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return X(e,e.y<0),X(t,t.y<0),void X(r,r.y<0);var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?R.sign(e.y):R.sign(r.y):i>o?R.sign(t.y):R.sign(r.y);var u=0>n;X(e,u),X(t,u),X(r,u)}function W(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,Re),e.y/(e.y-t.y),Re),r),a.clone(r,n),X(r,!0),X(n,!1)}function Y(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){H(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Ie.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,t,Ae,ve),W(e,r,Ne,Se),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(W(t,r,Ae,ve),W(t,e,Ne,Se),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(W(r,e,Ae,ve),W(r,t,Ne,Se),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(W(r,e,Ae,ve),W(r,t,Ne,Se),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(t,r,Ae,ve),W(t,e,Ne,Se),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,t,Ae,ve),W(e,r,Ne,Se),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ie.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Ae,s[4]=Ne,s[5]=ve,s[6]=Se,s.length=7),Ie}}function k(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=d.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function K(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new _({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var n=c(e.geometry.boundingSphere);t=k(t,n),r=k(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function j(e,r,i,o,u,s,l,E,f,d,_){if(c(s)||c(l)||c(E)||c(f)){var h=a.fromArray(u,3*e,Me),m=a.fromArray(u,3*r,Oe),y=a.fromArray(u,3*i,ge),T=t(o,h,m,y,we);if(c(s)){var p=a.fromArray(s,3*e,Me),R=a.fromArray(s,3*r,Oe),A=a.fromArray(s,3*i,ge);a.multiplyByScalar(p,T.x,p),a.multiplyByScalar(R,T.y,R),a.multiplyByScalar(A,T.z,A);var N=a.add(p,R,p);a.add(N,A,N),a.normalize(N,N),a.pack(N,d.normal.values,3*_)}if(c(l)){var v=a.fromArray(l,3*e,Me),S=a.fromArray(l,3*r,Oe),I=a.fromArray(l,3*i,ge);a.multiplyByScalar(v,T.x,v),a.multiplyByScalar(S,T.y,S),a.multiplyByScalar(I,T.z,I);var M=a.add(v,S,v);a.add(M,I,M),a.normalize(M,M),a.pack(M,d.binormal.values,3*_)}if(c(E)){var O=a.fromArray(E,3*e,Me),g=a.fromArray(E,3*r,Oe),w=a.fromArray(E,3*i,ge);a.multiplyByScalar(O,T.x,O),a.multiplyByScalar(g,T.y,g),a.multiplyByScalar(w,T.z,w);var x=a.add(O,g,O);a.add(x,w,x),a.normalize(x,x),a.pack(x,d.tangent.values,3*_)}if(c(f)){var C=n.fromArray(f,2*e,xe),L=n.fromArray(f,2*r,Ce),P=n.fromArray(f,2*i,Le);n.multiplyByScalar(C,T.x,C),n.multiplyByScalar(L,T.y,L),n.multiplyByScalar(P,T.z,P);var F=n.add(C,L,C);n.add(F,P,F),n.pack(F,d.st.values,2*_)}}}function Q(e,t,r,n,a,i){var o=e.position.values.length/3;if(-1!==a){var u=n[a],s=r[u];return-1===s?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function J(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,E=c(s.normal)?s.normal.values:void 0,f=c(s.binormal)?s.binormal.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,_=c(s.st)?s.st.values:void 0,h=u.indices,m=K(u),y=K(u),T=[];T.length=l.length/3;var p=[];for(p.length=l.length/3,o=0;o<T.length;++o)T[o]=-1,p[o]=-1;var R=h.length;for(o=0;R>o;o+=3){var A=h[o],N=h[o+1],v=h[o+2],S=a.fromArray(l,3*A),I=a.fromArray(l,3*N),M=a.fromArray(l,3*v),O=Y(S,I,M);if(c(O)&&O.positions.length>3)for(var g=O.positions,w=O.indices,x=w.length,C=0;x>C;++C){var L=w[C],P=g[L];P.y<0?(t=y.attributes,r=y.indices,n=T):(t=m.attributes,r=m.indices,n=p),i=Q(t,r,n,h,3>L?o+L:-1,P),j(A,N,v,P,l,E,f,d,_,t,i)}else c(O)&&(S=O.positions[0],I=O.positions[1],M=O.positions[2]),S.y<0?(t=y.attributes,r=y.indices,n=T):(t=m.attributes,r=m.indices,n=p),i=Q(t,r,n,h,o,S),j(A,N,v,S,l,E,f,d,_,t,i),i=Q(t,r,n,h,o+1,I),j(A,N,v,I,l,E,f,d,_,t,i),i=Q(t,r,n,h,o+2,M),j(A,N,v,M,l,E,f,d,_,t,i)}Z(e,y,m)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=K(r),s=K(r),l=o.length,E=[];E.length=i.length/3;var f=[];for(f.length=i.length/3,t=0;t<E.length;++t)E[t]=-1,f[t]=-1;for(t=0;l>t;t+=2){var d=o[t],_=o[t+1],h=a.fromArray(i,3*d,Me),m=a.fromArray(i,3*_,Oe);Math.abs(h.y)<R.EPSILON6&&(h.y<0?h.y=-R.EPSILON6:h.y=R.EPSILON6),Math.abs(m.y)<R.EPSILON6&&(m.y<0?m.y=-R.EPSILON6:m.y=R.EPSILON6);var y=u.attributes,T=u.indices,A=f,N=s.attributes,v=s.indices,S=E,I=p.lineSegmentPlane(h,m,Pe,ge);if(c(I)){var M=a.multiplyByScalar(a.UNIT_Y,5*R.EPSILON9,Fe);h.y<0&&(a.negate(M,M),y=s.attributes,T=s.indices,A=E,N=u.attributes,v=u.indices,S=f);var O=a.add(I,M,Ue);Q(y,T,A,o,t,h),Q(y,T,A,o,-1,O),a.negate(M,M),a.add(I,M,O),Q(N,v,S,o,-1,O),Q(N,v,S,o,t+1,m)}else{var g,w,x;h.y<0?(g=s.attributes,w=s.indices,x=E):(g=u.attributes,w=u.indices,x=f),Q(g,w,x,o,t,h),Q(g,w,x,o,t+1,m)}}Z(e,s,u)}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,E=s.prevPosition.values,f=s.nextPosition.values,d=s.expandAndWidth.values,_=c(s.st)?s.st.values:void 0,h=c(s.color)?s.color.values:void 0,m=K(u),y=K(u),T=l.length/3;for(t=0;T>t;t+=4){var A=t,N=t+1,v=t+2,S=t+3,I=a.fromArray(l,3*A,Be),M=a.fromArray(l,3*N,ze),O=a.fromArray(l,3*v,Ge),g=a.fromArray(l,3*S,Ve);Math.abs(I.y)<R.EPSILON6&&(I.y=R.EPSILON6*(O.y<0?-1:1),M.y=I.y),Math.abs(O.y)<R.EPSILON6&&(O.y=R.EPSILON6*(I.y<0?-1:1),g.y=O.y);var w=m.attributes,x=m.indices,C=y.attributes,L=y.indices,P=p.lineSegmentPlane(I,O,Pe,qe);if(c(P)){var F=a.multiplyByScalar(a.UNIT_Y,5*R.EPSILON9,Xe);I.y<0&&(a.negate(F,F),w=y.attributes,x=y.indices,C=m.attributes,L=m.indices);var U=a.add(P,F,He);for(w.position.values.push(I.x,I.y,I.z,M.x,M.y,M.z),w.position.values.push(U.x,U.y,U.z),w.position.values.push(U.x,U.y,U.z),a.negate(F,F),a.add(P,F,U),C.position.values.push(U.x,U.y,U.z),C.position.values.push(U.x,U.y,U.z),C.position.values.push(O.x,O.y,O.z,g.x,g.y,g.z),r=3*A;3*A+6>r;++r)w.prevPosition.values.push(E[r]);for(w.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),C.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),r=3*v;3*v+6>r;++r)C.prevPosition.values.push(E[r]);for(r=3*A;3*A+6>r;++r)w.nextPosition.values.push(f[r]);for(w.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),C.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),r=3*v;3*v+6>r;++r)C.nextPosition.values.push(f[r]);var b=n.fromArray(d,2*A,be),D=Math.abs(b.y);w.expandAndWidth.values.push(-1,D,1,D),w.expandAndWidth.values.push(-1,-D,1,-D),C.expandAndWidth.values.push(-1,D,1,D),C.expandAndWidth.values.push(-1,-D,1,-D);var B=a.magnitudeSquared(a.subtract(P,I,Ve));if(B/=a.magnitudeSquared(a.subtract(O,I,Ve)),c(h)){var z=i.fromArray(h,4*A,We),G=i.fromArray(h,4*v,We),V=R.lerp(z.x,G.x,B),q=R.lerp(z.y,G.y,B),X=R.lerp(z.z,G.z,B),H=R.lerp(z.w,G.w,B);for(r=4*A;4*A+8>r;++r)w.color.values.push(h[r]);for(w.color.values.push(V,q,X,H),w.color.values.push(V,q,X,H),C.color.values.push(V,q,X,H),C.color.values.push(V,q,X,H),r=4*v;4*v+8>r;++r)C.color.values.push(h[r])}if(c(_)){var W=n.fromArray(_,2*A,be),Y=n.fromArray(_,2*(t+3),De),k=R.lerp(W.x,Y.x,B);for(r=2*A;2*A+4>r;++r)w.st.values.push(_[r]);for(w.st.values.push(k,W.y),w.st.values.push(k,Y.y),C.st.values.push(k,W.y),C.st.values.push(k,Y.y),r=2*v;2*v+4>r;++r)C.st.values.push(_[r])}o=w.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=C.position.values.length/3-4,L.push(o,o+2,o+1),L.push(o+1,o+2,o+3)}else{var j,Q;for(I.y<0?(j=y.attributes,Q=y.indices):(j=m.attributes,Q=m.indices),j.position.values.push(I.x,I.y,I.z),j.position.values.push(M.x,M.y,M.z),j.position.values.push(O.x,O.y,O.z),j.position.values.push(g.x,g.y,g.z),r=3*t;3*t+12>r;++r)j.prevPosition.values.push(E[r]),j.nextPosition.values.push(f[r]);for(r=2*t;2*t+8>r;++r)j.expandAndWidth.values.push(d[r]),c(_)&&j.st.values.push(_[r]);if(c(h))for(r=4*t;4*t+16>r;++r)j.color.values.push(h[r]);o=j.position.values.length/3-4,Q.push(o,o+2,o+1),Q.push(o+1,o+2,o+3)}}Z(e,y,m)}var te={};te.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case S.TRIANGLES:e.indices=O(t);break;case S.TRIANGLE_STRIP:e.indices=g(t);break;case S.TRIANGLE_FAN:e.indices=w(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=S.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),E=0,f=0;o>f;f+=3)l[E++]=a[f],l[E++]=a[f+1],l[E++]=a[f+2],l[E++]=a[f]+i[f]*n,l[E++]=a[f+1]+i[f+1]*n,l[E++]=a[f+2]+i[f+2]*n;var h,m=e.boundingSphere;return c(m)&&(h=new r(m.center,m.radius+n)),new d({attributes:{position:new _({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:S.LINES,boundingSphere:h})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},te.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;t>a;a++)n[a]=-1;for(var i,o=r,s=o.length,l=y.createTypedArray(t,s),E=0,f=0,_=0;s>E;)i=n[o[E]],-1!==i?l[f]=i:(i=o[E],n[i]=_,l[f]=_,++_),++E,++f;e.indices=l;var h=e.attributes;for(var m in h)if(h.hasOwnProperty(m)&&c(h[m])&&c(h[m].values)){for(var T=h[m],p=T.values,R=0,A=T.componentsPerAttribute,N=u.createTypedArray(T.componentDatatype,_*A);t>R;){var v=n[R];if(-1!==v)for(a=0;A>a;a++)N[A*v+a]=p[A*R+a];++R}T.values=N}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===S.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;n>i;i++)r[i]>a&&(a=r[i]);e.indices=I.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>=R.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=x(e.attributes),s=e.indices,l=s.length;e.primitiveType===S.TRIANGLES?n=3:e.primitiveType===S.LINES?n=2:e.primitiveType===S.POINTS&&(n=1);for(var E=0;l>E;E+=n){for(var f=0;n>f;++f){var _=s[E+f],h=a[_];c(h)||(h=o++,a[_]=h,C(u,e.attributes,_)),i.push(h)}o+n>=R.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=x(e.attributes))}0!==i.length&&t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new a,ne=new o;te.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new f;for(var s=i.ellipsoid,E=o.values,d=new Float64Array(E.length),h=0,m=0;m<E.length;m+=3){var y=a.fromArray(E,m,re),T=s.cartesianToCartographic(y,ne);if(!c(T))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var p=i.project(T,re);d[h++]=p.x,d[h++]=p.y,d[h++]=p.z}return e.attributes[r]=o,e.attributes[n]=new _({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var ae={high:0,low:0};te.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)E.encode(i[l],ae),s[l]=ae.high,c[l]=ae.low;var f=a.componentsPerAttribute;return e.attributes[r]=new _({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:s}),e.attributes[n]=new _({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:c}),delete e.attributes[t],e};var ie=new a,oe=new N,ue=new A;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(N.equals(t,N.IDENTITY))return e;var n=e.geometry.attributes;L(t,n.position),L(t,n.prevPosition),L(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(N.inverse(t,oe),N.transpose(oe,oe),N.getRotation(oe,ue),P(ue,n.normal),P(ue,n.binormal),P(ue,n.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=N.clone(N.IDENTITY),e};var se=new a;te.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;n>a;++a){var i=e[a];c(i.geometry)?t.push(i):r.push(i)}var o=[];return t.length>0&&o.push(U(t,"geometry")),r.length>0&&(o.push(U(r,"westHemisphereGeometry")),o.push(U(r,"eastHemisphereGeometry"))),o};var ce=new a,le=new a,Ee=new a,fe=new a;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),E=0;i>E;E++)s[E]={indexOffset:0,count:0,currentCount:0};var f=0;for(E=0;o>E;E+=3){var d=t[E],h=t[E+1],m=t[E+2],y=3*d,T=3*h,p=3*m;le.x=n[y],le.y=n[y+1],le.z=n[y+2],Ee.x=n[T],Ee.y=n[T+1],Ee.z=n[T+2],fe.x=n[p],fe.y=n[p+1],fe.z=n[p+2],s[d].count++,s[h].count++,s[m].count++,a.subtract(Ee,le,Ee),a.subtract(fe,le,fe),c[f]=a.cross(Ee,fe,new a),f++}var R=0;for(E=0;i>E;E++)s[E].indexOffset+=R,R+=s[E].count;f=0;var A;for(E=0;o>E;E+=3){A=s[t[E]];var N=A.indexOffset+A.currentCount;l[N]=f,A.currentCount++,A=s[t[E+1]],N=A.indexOffset+A.currentCount,l[N]=f,A.currentCount++,A=s[t[E+2]],N=A.indexOffset+A.currentCount,l[N]=f,A.currentCount++,f++}var v=new Float32Array(3*i);for(E=0;i>E;E++){var S=3*E;if(A=s[E],A.count>0){for(a.clone(a.ZERO,ce),f=0;f<A.count;f++)a.add(ce,c[l[A.indexOffset+f]],ce);a.normalize(ce,ce),v[S]=ce.x,v[S+1]=ce.y,v[S+2]=ce.z}else v[S]=0,v[S+1]=0,v[S+2]=1}return e.attributes.normal=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:v}),e};var de=new a,_e=new a,he=new a;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var E,f,d;for(l=0;s>l;l+=3){var h=t[l],m=t[l+1],y=t[l+2];E=3*h,f=3*m,d=3*y;var T=2*h,p=2*m,R=2*y,A=r[E],N=r[E+1],v=r[E+2],S=i[T],I=i[T+1],M=i[p+1]-I,O=i[R+1]-I,g=1/((i[p]-S)*O-(i[R]-S)*M),w=(O*(r[f]-A)-M*(r[d]-A))*g,x=(O*(r[f+1]-N)-M*(r[d+1]-N))*g,C=(O*(r[f+2]-v)-M*(r[d+2]-v))*g;c[E]+=w,c[E+1]+=x,c[E+2]+=C,c[f]+=w,c[f+1]+=x,c[f+2]+=C,c[d]+=w,c[d+1]+=x,c[d+2]+=C}var L=new Float32Array(3*o),P=new Float32Array(3*o);for(l=0;o>l;l++){E=3*l,f=E+1,d=E+2;var F=a.fromArray(n,E,de),U=a.fromArray(c,E,he),b=a.dot(F,U);a.multiplyByScalar(F,b,_e),a.normalize(a.subtract(U,_e,U),U),P[E]=U.x,P[f]=U.y,P[d]=U.z,a.normalize(a.cross(F,U,U),U),L[E]=U.x,L[f]=U.y,L[d]=U.z}return e.attributes.tangent=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.binormal=new _({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e};var me=new n,ye=new a,Te=new a,pe=new a;te.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var o,s,l,E,f=t.attributes.tangent,d=t.attributes.binormal;c(r)&&(o=r.values),c(i)&&(s=i.values),c(f)&&(l=f.values),d&&(E=d.values);var h=c(o)?o.length:s.length,m=c(o)?3:2,y=h/m,T=y,p=c(s)&&c(o)?2:1;p+=c(l)||c(E)?1:0,T*=p;for(var R=new Float32Array(T),A=0,N=0;y>N;++N){c(s)&&(n.fromArray(s,2*N,me),R[A++]=e.compressTextureCoordinates(me));var v=3*N;c(o)&&c(l)&&c(E)?(a.fromArray(o,v,ye),a.fromArray(l,v,Te),a.fromArray(E,v,pe),e.octPack(ye,Te,pe,me),R[A++]=me.x,R[A++]=me.y):(c(o)&&(a.fromArray(o,v,ye),R[A++]=e.octEncodeFloat(ye)),c(l)&&(a.fromArray(l,v,ye),R[A++]=e.octEncodeFloat(ye)),c(E)&&(a.fromArray(E,v,ye),R[A++]=e.octEncodeFloat(ye)))}return t.attributes.compressedAttributes=new _({componentDatatype:u.FLOAT,componentsPerAttribute:p,values:R}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(E)&&delete t.attributes.binormal,t};var Re=new a,Ae=new a,Ne=new a,ve=new a,Se=new a,Ie={positions:new Array(7),indices:new Array(9)},Me=new a,Oe=new a,ge=new a,we=new a,xe=new n,Ce=new n,Le=new n,Pe=v.fromPointNormal(a.ZERO,a.UNIT_Y),Fe=new a,Ue=new a,be=new n,De=new n,Be=new a,ze=new a,Ge=new a,Ve=new a,qe=new a,Xe=new a,He=new a,We=new i;return te.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersectPlane(n,v.ORIGIN_ZX_PLANE)!==T.INTERSECTING)return e}if(t.geometryType!==m.NONE)switch(t.geometryType){case m.POLYLINES:ee(e);break;case m.TRIANGLES:J(e);break;case m.LINES:$(e)}else q(t),t.primitiveType===S.TRIANGLES?J(e):t.primitiveType===S.LINES&&$(e);return e},te}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.binormal?1:0,r[n++]=t.tangent?1:0,r[n++]=t.color?1:0},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.binormal=1===r[n++],i.tangent=1===r[n++],i.color=1===r[n++],i},a.clone=function(e,r){return t(e)?(t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},a}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,n,a,i,o,u,s,c,l,E,f,d,_,h,m,y,T,p,R,A){"use strict";function N(e,n,i){var o=n.vertexFormat,u=n.center,c=n.semiMajorAxis,E=n.semiMinorAxis,_=n.ellipsoid,h=n.stRotation,m=i?e.length/3*2:e.length/3,y=o.st?new Float32Array(2*m):void 0,p=o.normal?new Float32Array(3*m):void 0,A=o.tangent?new Float32Array(3*m):void 0,N=o.binormal?new Float32Array(3*m):void 0,v=0,S=b,I=D,M=B,O=new l(_),g=O.project(_.cartesianToCartographic(u,z),G),L=_.scaleToGeodeticSurface(u,w);_.geodeticSurfaceNormal(L,L);for(var X=R.fromAxisAngle(L,h,U),H=T.fromQuaternion(X,F),W=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,V),Y=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,q),k=e.length,K=i?k:0,Z=K/3*2,j=0;k>j;j+=3){
var Q=j+1,J=j+2,$=r.fromArray(e,j,w);if(o.st){var ee=T.multiplyByVector(H,$,x),te=O.project(_.cartesianToCartographic(ee,z),C);r.subtract(te,g,te),P.x=(te.x+c)/(2*c),P.y=(te.y+E)/(2*E),W.x=Math.min(P.x,W.x),W.y=Math.min(P.y,W.y),Y.x=Math.max(P.x,Y.x),Y.y=Math.max(P.y,Y.y),i&&(y[v+Z]=P.x,y[v+1+Z]=P.y),y[v++]=P.x,y[v++]=P.y}S=_.geodeticSurfaceNormal($,S),(o.normal||o.tangent||o.binormal)&&((o.tangent||o.binormal)&&(I=r.normalize(r.cross(r.UNIT_Z,S,I),I),T.multiplyByVector(H,I,I)),o.normal&&(p[j]=S.x,p[Q]=S.y,p[J]=S.z,i&&(p[j+K]=-S.x,p[Q+K]=-S.y,p[J+K]=-S.z)),o.tangent&&(A[j]=I.x,A[Q]=I.y,A[J]=I.z,i&&(A[j+K]=-I.x,A[Q+K]=-I.y,A[J+K]=-I.z)),o.binormal&&(M=r.normalize(r.cross(S,I,M),M),N[j]=M.x,N[Q]=M.y,N[J]=M.z,i&&(N[j+K]=M.x,N[Q+K]=M.y,N[J+K]=M.z)))}if(o.st){k=y.length;for(var re=0;k>re;re+=2)y[re]=(y[re]-W.x)/(Y.x-W.x),y[re+1]=(y[re+1]-W.y)/(Y.y-W.y)}var ne=new d;if(o.position){var ae=s.raisePositionsToHeight(e,n,i);ne.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:ae})}return o.st&&(ne.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:y})),o.normal&&(ne.normal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:p})),o.tangent&&(ne.tangent=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:A})),o.binormal&&(ne.binormal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:N})),ne}function v(e){var t,r,n,a,i,o=new Array(12*(e*(e+1))-6),u=0;for(t=0,n=1,a=0;3>a;a++)o[u++]=n++,o[u++]=t,o[u++]=n;for(a=2;e+1>a;++a){for(n=a*(a+1)-1,t=(a-1)*a-1,o[u++]=n++,o[u++]=t,o[u++]=n,r=2*a,i=0;r-1>i;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=n++,o[u++]=t,o[u++]=n}for(r=2*e,++n,++t,a=0;r-1>a;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;for(o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t++,o[u++]=t,++t,a=e-1;a>1;--a){for(o[u++]=t++,o[u++]=t,o[u++]=n,r=2*a,i=0;r-1>i;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=t++,o[u++]=t++,o[u++]=n++}for(a=0;3>a;a++)o[u++]=t++,o[u++]=t,o[u++]=n;return o}function S(t){var n=t.center;X=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(n,X),t.height,X),X=r.add(n,X,X);var a=new e(X,t.semiMajorAxis),i=s.computeEllipsePositions(t,!0,!1),o=i.positions,u=i.numPts,c=N(o,t,!1),l=v(u);return l=m.createTypedArray(o.length/3,l),{boundingSphere:a,attributes:c,indices:l}}function I(e,n){var i=n.vertexFormat,o=n.center,u=n.semiMajorAxis,s=n.semiMinorAxis,c=n.ellipsoid,E=n.height,_=n.extrudedHeight,h=n.stRotation,m=e.length/3*2,y=new Float64Array(3*m),p=i.st?new Float32Array(2*m):void 0,A=i.normal?new Float32Array(3*m):void 0,N=i.tangent?new Float32Array(3*m):void 0,v=i.binormal?new Float32Array(3*m):void 0,S=0,I=b,M=D,O=B,g=new l(c),X=g.project(c.cartesianToCartographic(o,z),G),H=c.scaleToGeodeticSurface(o,w);c.geodeticSurfaceNormal(H,H);for(var W=R.fromAxisAngle(H,h,U),Y=T.fromQuaternion(W,F),k=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,V),K=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,q),Z=e.length,j=Z/3*2,Q=0;Z>Q;Q+=3){var J,$=Q+1,ee=Q+2,te=r.fromArray(e,Q,w);if(i.st){var re=T.multiplyByVector(Y,te,x),ne=g.project(c.cartesianToCartographic(re,z),C);r.subtract(ne,X,ne),P.x=(ne.x+u)/(2*u),P.y=(ne.y+s)/(2*s),k.x=Math.min(P.x,k.x),k.y=Math.min(P.y,k.y),K.x=Math.max(P.x,K.x),K.y=Math.max(P.y,K.y),p[S+j]=P.x,p[S+1+j]=P.y,p[S++]=P.x,p[S++]=P.y}te=c.scaleToGeodeticSurface(te,te),J=r.clone(te,x),I=c.geodeticSurfaceNormal(te,I);var ae=r.multiplyByScalar(I,E,L);if(te=r.add(te,ae,te),ae=r.multiplyByScalar(I,_,ae),J=r.add(J,ae,J),i.position&&(y[Q+Z]=J.x,y[$+Z]=J.y,y[ee+Z]=J.z,y[Q]=te.x,y[$]=te.y,y[ee]=te.z),i.normal||i.tangent||i.binormal){O=r.clone(I,O);var ie=r.fromArray(e,(Q+3)%Z,L);r.subtract(ie,te,ie);var oe=r.subtract(J,te,C);I=r.normalize(r.cross(oe,ie,I),I),i.normal&&(A[Q]=I.x,A[$]=I.y,A[ee]=I.z,A[Q+Z]=I.x,A[$+Z]=I.y,A[ee+Z]=I.z),i.tangent&&(M=r.normalize(r.cross(O,I,M),M),N[Q]=M.x,N[$]=M.y,N[ee]=M.z,N[Q+Z]=M.x,N[Q+1+Z]=M.y,N[Q+2+Z]=M.z),i.binormal&&(v[Q]=O.x,v[$]=O.y,v[ee]=O.z,v[Q+Z]=O.x,v[$+Z]=O.y,v[ee+Z]=O.z)}}if(i.st){Z=p.length;for(var ue=0;Z>ue;ue+=2)p[ue]=(p[ue]-k.x)/(K.x-k.x),p[ue+1]=(p[ue+1]-k.y)/(K.y-k.y)}var se=new d;return i.position&&(se.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:y})),i.st&&(se.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:p})),i.normal&&(se.normal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:A})),i.tangent&&(se.tangent=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:N})),i.binormal&&(se.binormal=new f({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:v})),se}function M(e){for(var t=e.length/3,r=m.createTypedArray(t,6*t),n=0,a=0;t>a;a++){var i=a,o=a+t,u=(i+1)%t,s=u+t;r[n++]=i,r[n++]=o,r[n++]=u,r[n++]=u,r[n++]=o,r[n++]=s}return r}function O(t){var n=t.center,a=t.ellipsoid,i=t.semiMajorAxis,o=r.multiplyByScalar(a.geodeticSurfaceNormal(n,w),t.height,w);H.center=r.add(n,o,H.center),H.radius=i,o=r.multiplyByScalar(a.geodeticSurfaceNormal(n,o),t.extrudedHeight,o),W.center=r.add(n,o,W.center),W.radius=i;var u=s.computeEllipsePositions(t,!0,!0),c=u.positions,l=u.numPts,f=u.outerPositions,d=e.union(H,W),y=N(c,t,!0),T=v(l),R=T.length;T.length=2*R;for(var A=c.length/3,S=0;R>S;S+=3)T[S+R]=T[S+2]+A,T[S+1+R]=T[S+1]+A,T[S+2+R]=T[S]+A;var O=m.createTypedArray(2*A/3,T),g=new E({attributes:y,indices:O,primitiveType:p.TRIANGLES}),x=I(f,t);T=M(f);var C=m.createTypedArray(2*f.length/3,T),L=new E({attributes:x,indices:C,primitiveType:p.TRIANGLES}),P=h.combineInstances([new _({geometry:g}),new _({geometry:L})]);return{boundingSphere:d,attributes:P[0].attributes,indices:P[0].indices}}function g(e){e=i(e,i.EMPTY_OBJECT);var t=e.center,n=i(e.ellipsoid,c.WGS84),a=e.semiMajorAxis,u=e.semiMinorAxis,s=i(e.granularity,y.RADIANS_PER_DEGREE),l=i(e.height,0),E=e.extrudedHeight,f=o(E)&&Math.abs(l-E)>1,d=i(e.vertexFormat,A.DEFAULT);this._center=r.clone(t),this._semiMajorAxis=a,this._semiMinorAxis=u,this._ellipsoid=c.clone(n),this._rotation=i(e.rotation,0),this._stRotation=i(e.stRotation,0),this._height=l,this._granularity=s,this._vertexFormat=A.clone(d),this._extrudedHeight=i(E,l),this._extrude=f,this._workerName="createEllipseGeometry"}var w=new r,x=new r,C=new r,L=new r,P=new t,F=new T,U=new R,b=new r,D=new r,B=new r,z=new n,G=new r,V=new t,q=new t,X=new r,H=new e,W=new e;g.packedLength=r.packedLength+c.packedLength+A.packedLength+8,g.pack=function(e,t,n){n=i(n,0),r.pack(e._center,t,n),n+=r.packedLength,c.pack(e._ellipsoid,t,n),n+=c.packedLength,A.pack(e._vertexFormat,t,n),n+=A.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n]=e._extrude?1:0};var Y=new r,k=new c,K=new A,Z={center:Y,ellipsoid:k,vertexFormat:K,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return g.unpack=function(e,t,n){t=i(t,0);var a=r.unpack(e,t,Y);t+=r.packedLength;var u=c.unpack(e,t,k);t+=c.packedLength;var s=A.unpack(e,t,K);t+=A.packedLength;var l=e[t++],E=e[t++],f=e[t++],d=e[t++],_=e[t++],h=e[t++],m=e[t++],y=1===e[t];return o(n)?(n._center=r.clone(a,n._center),n._ellipsoid=c.clone(u,n._ellipsoid),n._vertexFormat=A.clone(s,n._vertexFormat),n._semiMajorAxis=l,n._semiMinorAxis=E,n._rotation=f,n._stRotation=d,n._height=_,n._granularity=h,n._extrudedHeight=m,n._extrude=y,n):(Z.height=_,Z.extrudedHeight=m,Z.granularity=h,Z.stRotation=d,Z.rotation=f,Z.semiMajorAxis=l,Z.semiMinorAxis=E,new g(Z))},g.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=O(r)):t=S(r),new E({attributes:t.attributes,indices:t.indices,primitiveType:p.TRIANGLES,boundingSphere:t.boundingSphere})},g.createShadowVolume=function(e,t,r){var n=e._granularity,a=e._ellipsoid,i=t(n,a),o=r(n,a);return new g({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:a,stRotation:e._stRotation,granularity:n,extrudedHeight:i,height:o,vertexFormat:A.POSITION_ONLY})},g}),define("Workers/createEllipseGeometry",["../Core/Cartesian3","../Core/defined","../Core/EllipseGeometry","../Core/Ellipsoid"],function(e,t,r,n){"use strict";function a(a,i){return t(i)&&(a=r.unpack(a,i)),a._center=e.clone(a._center),a._ellipsoid=n.clone(a._ellipsoid),r.createGeometry(a)}return a})}();