/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},i.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},i.lerp=function(e,t,n){return(1-n)*e+n*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,n,r,i){i=t(i,r);var a=Math.abs(e-n);return i>=a||a<=r*Math.max(Math.abs(e),Math.abs(n))};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var n=a[t-1],r=t;e>=r;r++)a.push(n*r);return a[e]},i.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,n){return t>e?t:e>n?n:e};var o=new e;return i.setRandomNumberSeed=function(t){o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";function a(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)}a.fromSpherical=function(n,r){t(r)||(r=new a);var i=n.clock,o=n.cone,u=e(n.magnitude,1),E=u*Math.sin(o);return r.x=E*Math.cos(i),r.y=E*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(e,n,r,i){return t(i)?(i.x=e,i.y=n,i.z=r,i):new a(e,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var E=new a,s=new a;a.angleBetween=function(e,t){a.normalize(e,E),a.normalize(t,s);var n=a.dot(E,s),r=a.magnitude(a.cross(E,s,E));return Math.atan2(r,n)};var _=new a;a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,_);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Z,t):n.y<=n.z?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_Z,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)},a.cross=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=t.x,u=t.y,E=t.z,s=i*E-a*u,_=a*o-r*E,c=r*u-i*o;return n.x=s,n.y=_,n.z=c,n},a.fromDegrees=function(e,t,n,r,o){var u=i.toRadians(e),E=i.toRadians(t);return a.fromRadians(u,E,n,r,o)};var c=new a,R=new a,T=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=e(i,0);var E=t(o)?o.radiiSquared:T,s=Math.cos(r);c.x=s*Math.cos(n),c.y=s*Math.sin(n),c.z=Math.sin(r),c=a.normalize(c,c),a.multiplyComponents(E,c,R);var _=Math.sqrt(a.dot(c,R));return R=a.divideByScalar(R,_,R),c=a.multiplyByScalar(c,i,c),t(u)||(u=new a),a.add(R,c,u)},a.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=i.toRadians(e[o]);return a.fromRadiansArray(r,t,n)},a.fromRadiansArray=function(e,n,r){var i=e.length;t(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=e[o],E=e[o+1];r[o/2]=a.fromRadians(u,E,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=i.toRadians(e[o]),r[o+1]=i.toRadians(e[o+1]),r[o+2]=e[o+2];return a.fromRadiansArrayHeights(r,t,n)},a.fromRadiansArrayHeights=function(e,n,r){var i=e.length;t(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=e[o],E=e[o+1],s=e[o+2];r[o/3]=a.fromRadians(u,E,s,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(n,i,u,E,s){var _=n.x,c=n.y,R=n.z,T=i.x,l=i.y,A=i.z,f=_*_*T*T,N=c*c*l*l,h=R*R*A*A,I=f+N+h,d=Math.sqrt(1/I),S=e.multiplyByScalar(n,d,a);if(E>I)return isFinite(d)?e.clone(S,s):void 0;var M=u.x,O=u.y,m=u.z,y=o;y.x=S.x*M*2,y.y=S.y*O*2,y.z=S.z*m*2;var C,p,U,L,F,P,B,D,w,v,x,g=(1-d)*e.magnitude(n)/(.5*e.magnitude(y)),z=0;do{g-=z,U=1/(1+g*M),L=1/(1+g*O),F=1/(1+g*m),P=U*U,B=L*L,D=F*F,w=P*U,v=B*L,x=D*F,C=f*P+N*B+h*D-1,p=f*w*M+N*v*O+h*x*m;var G=-2*p;z=C/G}while(Math.abs(C)>r.EPSILON12);return t(s)?(s.x=_*U,s.y=c*L,s.z=R*F,s):new e(_*U,c*L,R*F)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,i,a){return i=t(i,0),n(a)?(a.longitude=e,a.latitude=r,a.height=i,a):new u(e,r,i)},u.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,n,r)};var E=new e,s=new e,_=new e,c=new e(1/6378137,1/6378137,1/6356752.314245179),R=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),T=a.EPSILON1;return u.fromCartesian=function(t,r,i){var l=n(r)?r.oneOverRadii:c,A=n(r)?r.oneOverRadiiSquared:R,f=n(r)?r._centerToleranceSquared:T,N=o(t,l,A,f,s);if(n(N)){var h=e.multiplyComponents(t,A,E);h=e.normalize(h,h);var I=e.subtract(t,N,_),d=Math.atan2(h.y,h.x),S=Math.asin(h.z),M=a.sign(e.dot(I,t))*e.magnitude(I);return n(i)?(i.longitude=d,i.latitude=S,i.height=M,i):new u(d,S,M)}},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o,u,E){"use strict";function s(t,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),t._radii=new e(r,i,a),t._radiiSquared=new e(r*r,i*i,a*a),t._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,i,a),t._maximumRadius=Math.max(r,i,a),t._centerToleranceSquared=u.EPSILON1}function _(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,n)}i(_.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),_.clone=function(t,n){if(r(t)){var i=t._radii;return r(n)?(e.clone(i,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new _(i.x,i.y,i.z)}},_.fromCartesian3=function(e,t){return r(t)||(t=new _),r(e)?(s(t,e.x,e.y,e.z),t):t},_.WGS84=o(new _(6378137,6378137,6356752.314245179)),_.UNIT_SPHERE=o(new _(1,1,1)),_.MOON=o(new _(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),_.prototype.clone=function(e){return _.clone(this,e)},_.packedLength=e.packedLength,_.pack=function(t,r,i){i=n(i,0),e.pack(t._radii,r,i)},_.unpack=function(t,r,i){r=n(r,0);var a=e.unpack(t,r);return _.fromCartesian3(a,i)},_.prototype.geocentricSurfaceNormal=e.normalize,_.prototype.geodeticSurfaceNormalCartographic=function(t,n){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),E=o*Math.sin(i),s=Math.sin(a);return r(n)||(n=new e),n.x=u,n.y=E,n.z=s,e.normalize(n,n)},_.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var c=new e,R=new e;_.prototype.cartographicToCartesian=function(t,n){var i=c,a=R;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),r(n)||(n=new e),e.add(a,i,n)},_.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var T=new e,l=new e,A=new e;return _.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,l);if(r(a)){var o=this.geodeticSurfaceNormal(a,T),E=e.subtract(n,a,A),s=Math.atan2(o.y,o.x),_=Math.asin(o.z),c=u.sign(e.dot(E,n))*e.magnitude(E);return r(i)?(i.longitude=s,i.latitude=_,i.height=c,i):new t(s,_,c)}},_.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},_.prototype.scaleToGeodeticSurface=function(e,t){return E(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},_.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,E=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,E,n)},_.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},_.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},_.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},_.prototype.toString=function(){return this._radii.toString()},_}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,i,a,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new e(a,o,u)},u.prototype.unproject=function(e,n){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e,n,r,i,a,o,u,E,s){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(a,0),this[5]=t(E,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(s,0)}function u(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function E(e){for(var t=0,n=0;3>n;++n){var r=e[o.getElementIndex(T[n],R[n])];t+=2*r*r}return Math.sqrt(t)}function s(e,t){for(var n=a.EPSILON15,r=0,i=1,u=0;3>u;++u){var E=Math.abs(e[o.getElementIndex(T[u],R[u])]);E>r&&(i=u,r=E)}var s=1,_=0,c=R[i],l=T[i];if(Math.abs(e[o.getElementIndex(l,c)])>n){var A,f=e[o.getElementIndex(l,l)],N=e[o.getElementIndex(c,c)],h=e[o.getElementIndex(l,c)],I=(f-N)/2/h;A=0>I?-1/(-I+Math.sqrt(1+I*I)):1/(I+Math.sqrt(1+I*I)),s=1/Math.sqrt(1+A*A),_=A*s}return t=o.clone(o.IDENTITY,t),t[o.getElementIndex(c,c)]=t[o.getElementIndex(l,l)]=s,t[o.getElementIndex(l,c)]=_,t[o.getElementIndex(c,l)]=-_,t}o.packedLength=9,o.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},o.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i[0]=e[r++],i[1]=e[r++],i[2]=e[r++],i[3]=e[r++],i[4]=e[r++],i[5]=e[r++],i[6]=e[r++],i[7]=e[r++],i[8]=e[r++],i},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new o(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},o.fromArray=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],i[8]=e[r+8],i},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new o(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},o.fromQuaternion=function(e,t){var r=e.x*e.x,i=e.x*e.y,a=e.x*e.z,u=e.x*e.w,E=e.y*e.y,s=e.y*e.z,_=e.y*e.w,c=e.z*e.z,R=e.z*e.w,T=e.w*e.w,l=r-E-c+T,A=2*(i-R),f=2*(a+_),N=2*(i+R),h=-r+E-c+T,I=2*(s-u),d=2*(a-_),S=2*(s+u),M=-r-E+c+T;return n(t)?(t[0]=l,t[1]=N,t[2]=d,t[3]=A,t[4]=h,t[5]=S,t[6]=f,t[7]=I,t[8]=M,t):new o(l,A,f,N,h,I,d,S,M)},o.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new o(e.x,0,0,0,e.y,0,0,0,e.z)},o.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new o(e,0,0,0,e,0,0,0,e)},o.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new o(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},o.fromRotationX=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=i,t[6]=0,t[7]=-i,t[8]=r,t):new o(1,0,0,0,r,-i,0,i,r)},o.fromRotationY=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=r,t):new o(r,0,i,0,1,0,-i,0,r)},o.fromRotationZ=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=i,t[2]=0,t[3]=-i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new o(r,-i,0,i,r,0,0,0,1)},o.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},o.getElementIndex=function(e,t){return 3*e+t},o.getColumn=function(e,t,n){var r=3*t,i=e[r],a=e[r+1],o=e[r+2];return n.x=i,n.y=a,n.z=o,n},o.setColumn=function(e,t,n,r){r=o.clone(e,r);var i=3*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},o.getRow=function(e,t,n){var r=e[t],i=e[t+3],a=e[t+6];return n.x=r,n.y=i,n.z=a,n},o.setRow=function(e,t,n,r){return r=o.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var _=new e;o.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],_)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],_)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],_)),n};var c=new e;o.getMaximumScale=function(t){return o.getScale(t,c),e.maximumComponent(c)},o.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],E=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],s=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],_=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],c=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=E,n[6]=s,n[7]=_,n[8]=c,n},o.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},o.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},o.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[3]*i+e[6]*a,u=e[1]*r+e[4]*i+e[7]*a,E=e[2]*r+e[5]*i+e[8]*a;return n.x=o,n.y=u,n.z=E,n},o.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},o.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},o.transpose=function(e,t){var n=e[0],r=e[3],i=e[6],a=e[1],o=e[4],u=e[7],E=e[2],s=e[5],_=e[8];return t[0]=n,t[1]=r,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=E,t[7]=s,t[8]=_,t};var R=[1,0,0],T=[2,2,1],l=new o,A=new o;return o.computeEigenDecomposition=function(e,t){var r=a.EPSILON20,i=10,_=0,c=0;n(t)||(t={});for(var R=t.unitary=o.clone(o.IDENTITY,t.unitary),T=t.diagonal=o.clone(e,t.diagonal),f=r*u(T);i>c&&E(T)>f;)s(T,l),o.transpose(l,A),o.multiply(T,l,T),o.multiply(A,T,T),o.multiply(R,l,R),++_>2&&(++c,_=0);return t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},o.determinant=function(e){var t=e[0],n=e[3],r=e[6],i=e[1],a=e[4],o=e[7],u=e[2],E=e[5],s=e[8];return t*(a*s-E*o)+i*(E*r-n*s)+u*(n*o-a*r)},o.inverse=function(e,t){var n=e[0],i=e[1],u=e[2],E=e[3],s=e[4],_=e[5],c=e[6],R=e[7],T=e[8],l=o.determinant(e);if(Math.abs(l)<=a.EPSILON15)throw new r("matrix is not invertible");t[0]=s*T-R*_,t[1]=R*u-i*T,t[2]=i*_-s*u,t[3]=c*_-E*T,t[4]=n*T-c*u,t[5]=E*u-n*_,t[6]=E*R-c*s,t[7]=c*i-n*R,t[8]=n*s-E*i;var A=1/l;return o.multiplyByScalar(t,A,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},o.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},o.IDENTITY=i(new o(1,0,0,0,1,0,0,0,1)),o.ZERO=i(new o(0,0,0,0,0,0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN0ROW2=2,o.COLUMN1ROW0=3,o.COLUMN1ROW1=4,o.COLUMN1ROW2=5,o.COLUMN2ROW0=6,o.COLUMN2ROW1=7,o.COLUMN2ROW2=8,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},o}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";function a(t,n,r,i){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(i,0)}a.fromElements=function(e,n,r,i,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=i,o):new a(e,n,r,i)},a.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var E=new a;return a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,E);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)&&i.equalsEpsilon(e.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,i,a,o,u,E){"use strict";function s(e,t,r,i,a,o,u,E,s,_,c,R,T,l,A,f){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(s,0),this[3]=n(T,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(_,0),this[7]=n(l,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(c,0),this[11]=n(A,0),this[12]=n(i,0),this[13]=n(E,0),this[14]=n(R,0),this[15]=n(f,0)}s.packedLength=16,s.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},s.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new s),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},s.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new s(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},s.fromArray=s.unpack,s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},s.fromRotationTranslation=function(t,i,a){return i=n(i,e.ZERO),r(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new s(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},s.fromTranslationQuaternionRotationScale=function(e,t,n,i){r(i)||(i=new s);var a=n.x,o=n.y,u=n.z,E=t.x*t.x,_=t.x*t.y,c=t.x*t.z,R=t.x*t.w,T=t.y*t.y,l=t.y*t.z,A=t.y*t.w,f=t.z*t.z,N=t.z*t.w,h=t.w*t.w,I=E-T-f+h,d=2*(_-N),S=2*(c+A),M=2*(_+N),O=-E+T-f+h,m=2*(l-R),y=2*(c-A),C=2*(l+R),p=-E-T+f+h;return i[0]=I*a,i[1]=M*a,i[2]=y*a,i[3]=0,i[4]=d*o,i[5]=O*o,i[6]=C*o,i[7]=0,i[8]=S*u,i[9]=m*u,i[10]=p*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},s.fromTranslationRotationScale=function(e,t){return s.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},s.fromTranslation=function(e,t){return s.fromRotationTranslation(u.IDENTITY,e,t)},s.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new s(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},s.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new s(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var _=new e,c=new e,R=new e;s.fromCamera=function(t,n){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,_),_),e.normalize(e.cross(_,o,c),c),e.normalize(e.cross(c,_,R),R);var u=c.x,E=c.y,T=c.z,l=_.x,A=_.y,f=_.z,N=R.x,h=R.y,I=R.z,d=i.x,S=i.y,M=i.z,O=u*-d+E*-S+T*-M,m=N*-d+h*-S+I*-M,y=l*d+A*S+f*M;
return r(n)?(n[0]=u,n[1]=N,n[2]=-l,n[3]=0,n[4]=E,n[5]=h,n[6]=-A,n[7]=0,n[8]=T,n[9]=I,n[10]=-f,n[11]=0,n[12]=O,n[13]=m,n[14]=y,n[15]=1,n):new s(u,E,T,O,N,h,I,m,-l,-A,-f,y,0,0,0,1)},s.computePerspectiveFieldOfView=function(e,t,n,r,i){var a=Math.tan(.5*e),o=1/a,u=o/t,E=(r+n)/(n-r),s=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=E,i[11]=-1,i[12]=0,i[13]=0,i[14]=s,i[15]=0,i},s.computeOrthographicOffCenter=function(e,t,n,r,i,a,o){var u=1/(t-e),E=1/(r-n),s=1/(a-i),_=-(t+e)*u,c=-(r+n)*E,R=-(a+i)*s;return u*=2,E*=2,s*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=0,o[12]=_,o[13]=c,o[14]=R,o[15]=1,o},s.computePerspectiveOffCenter=function(e,t,n,r,i,a,o){var u=2*i/(t-e),E=2*i/(r-n),s=(t+e)/(t-e),_=(r+n)/(r-n),c=-(a+i)/(a-i),R=-1,T=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=s,o[9]=_,o[10]=c,o[11]=R,o[12]=0,o[13]=0,o[14]=T,o[15]=0,o},s.computeInfinitePerspectiveOffCenter=function(e,t,n,r,i,a){var o=2*i/(t-e),u=2*i/(r-n),E=(t+e)/(t-e),s=(r+n)/(r-n),_=-1,c=-1,R=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=E,a[9]=s,a[10]=_,a[11]=c,a[12]=0,a[13]=0,a[14]=R,a[15]=0,a},s.computeViewportTransformation=function(e,t,r,i){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),o=n(e.y,0),u=n(e.width,0),E=n(e.height,0);t=n(t,0),r=n(r,1);var s=.5*u,_=.5*E,c=.5*(r-t),R=s,T=_,l=c,A=a+s,f=o+_,N=t+c,h=1;return i[0]=R,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=T,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=l,i[11]=0,i[12]=A,i[13]=f,i[14]=N,i[15]=h,i},s.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},s.getElementIndex=function(e,t){return 4*e+t},s.getColumn=function(e,t,n){var r=4*t,i=e[r],a=e[r+1],o=e[r+2],u=e[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},s.setColumn=function(e,t,n,r){r=s.clone(e,r);var i=4*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},s.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},s.getRow=function(e,t,n){var r=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},s.setRow=function(e,t,n,r){return r=s.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var T=new e;s.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],T)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],T)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],T)),n};var l=new e;s.getMaximumScale=function(t){return s.getScale(t,l),e.maximumComponent(l)},s.multiply=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[3],u=e[4],E=e[5],s=e[6],_=e[7],c=e[8],R=e[9],T=e[10],l=e[11],A=e[12],f=e[13],N=e[14],h=e[15],I=t[0],d=t[1],S=t[2],M=t[3],O=t[4],m=t[5],y=t[6],C=t[7],p=t[8],U=t[9],L=t[10],F=t[11],P=t[12],B=t[13],D=t[14],w=t[15],v=r*I+u*d+c*S+A*M,x=i*I+E*d+R*S+f*M,g=a*I+s*d+T*S+N*M,z=o*I+_*d+l*S+h*M,G=r*O+u*m+c*y+A*C,b=i*O+E*m+R*y+f*C,X=a*O+s*m+T*y+N*C,V=o*O+_*m+l*y+h*C,H=r*p+u*U+c*L+A*F,W=i*p+E*U+R*L+f*F,q=a*p+s*U+T*L+N*F,Y=o*p+_*U+l*L+h*F,K=r*P+u*B+c*D+A*w,Z=i*P+E*B+R*D+f*w,k=a*P+s*B+T*D+N*w,j=o*P+_*B+l*D+h*w;return n[0]=v,n[1]=x,n[2]=g,n[3]=z,n[4]=G,n[5]=b,n[6]=X,n[7]=V,n[8]=H,n[9]=W,n[10]=q,n[11]=Y,n[12]=K,n[13]=Z,n[14]=k,n[15]=j,n},s.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},s.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},s.multiplyTransformation=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],E=e[6],s=e[8],_=e[9],c=e[10],R=e[12],T=e[13],l=e[14],A=t[0],f=t[1],N=t[2],h=t[4],I=t[5],d=t[6],S=t[8],M=t[9],O=t[10],m=t[12],y=t[13],C=t[14],p=r*A+o*f+s*N,U=i*A+u*f+_*N,L=a*A+E*f+c*N,F=r*h+o*I+s*d,P=i*h+u*I+_*d,B=a*h+E*I+c*d,D=r*S+o*M+s*O,w=i*S+u*M+_*O,v=a*S+E*M+c*O,x=r*m+o*y+s*C+R,g=i*m+u*y+_*C+T,z=a*m+E*y+c*C+l;return n[0]=p,n[1]=U,n[2]=L,n[3]=0,n[4]=F,n[5]=P,n[6]=B,n[7]=0,n[8]=D,n[9]=w,n[10]=v,n[11]=0,n[12]=x,n[13]=g,n[14]=z,n[15]=1,n},s.multiplyByMatrix3=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],E=e[6],s=e[8],_=e[9],c=e[10],R=t[0],T=t[1],l=t[2],A=t[3],f=t[4],N=t[5],h=t[6],I=t[7],d=t[8],S=r*R+o*T+s*l,M=i*R+u*T+_*l,O=a*R+E*T+c*l,m=r*A+o*f+s*N,y=i*A+u*f+_*N,C=a*A+E*f+c*N,p=r*h+o*I+s*d,U=i*h+u*I+_*d,L=a*h+E*I+c*d;return n[0]=S,n[1]=M,n[2]=O,n[3]=0,n[4]=m,n[5]=y,n[6]=C,n[7]=0,n[8]=p,n[9]=U,n[10]=L,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},s.multiplyByTranslation=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=r*e[0]+i*e[4]+a*e[8]+e[12],u=r*e[1]+i*e[5]+a*e[9]+e[13],E=r*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=E,n[15]=e[15],n};var A=new e;s.multiplyByUniformScale=function(e,t,n){return A.x=t,A.y=t,A.z=t,s.multiplyByScale(e,A,n)},s.multiplyByScale=function(e,t,n){var r=t.x,i=t.y,a=t.z;return 1===r&&1===i&&1===a?s.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},s.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*r+e[4]*i+e[8]*a+e[12]*o,E=e[1]*r+e[5]*i+e[9]*a+e[13]*o,s=e[2]*r+e[6]*i+e[10]*a+e[14]*o,_=e[3]*r+e[7]*i+e[11]*a+e[15]*o;return n.x=u,n.y=E,n.z=s,n.w=_,n},s.multiplyByPointAsVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a,u=e[1]*r+e[5]*i+e[9]*a,E=e[2]*r+e[6]*i+e[10]*a;return n.x=o,n.y=u,n.z=E,n},s.multiplyByPoint=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a+e[12],u=e[1]*r+e[5]*i+e[9]*a+e[13],E=e[2]*r+e[6]*i+e[10]*a+e[14];return n.x=o,n.y=u,n.z=E,n},s.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},s.transpose=function(e,t){var n=e[1],r=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},s.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},s.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var f=new u,N=new u,h=new t,I=new t(0,0,0,1);return s.inverse=function(e,n){if(u.equalsEpsilon(s.getRotation(e,f),N,o.EPSILON7)&&t.equals(s.getRow(e,3,h),I))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],i=e[4],a=e[8],_=e[12],c=e[1],R=e[5],T=e[9],l=e[13],A=e[2],d=e[6],S=e[10],M=e[14],O=e[3],m=e[7],y=e[11],C=e[15],p=S*C,U=M*y,L=d*C,F=M*m,P=d*y,B=S*m,D=A*C,w=M*O,v=A*y,x=S*O,g=A*m,z=d*O,G=p*R+F*T+P*l-(U*R+L*T+B*l),b=U*c+D*T+x*l-(p*c+w*T+v*l),X=L*c+w*R+g*l-(F*c+D*R+z*l),V=B*c+v*R+z*T-(P*c+x*R+g*T),H=U*i+L*a+B*_-(p*i+F*a+P*_),W=p*r+w*a+v*_-(U*r+D*a+x*_),q=F*r+D*i+z*_-(L*r+w*i+g*_),Y=P*r+x*i+g*a-(B*r+v*i+z*a);p=a*l,U=_*T,L=i*l,F=_*R,P=i*T,B=a*R,D=r*l,w=_*c,v=r*T,x=a*c,g=r*R,z=i*c;var K=p*m+F*y+P*C-(U*m+L*y+B*C),Z=U*O+D*y+x*C-(p*O+w*y+v*C),k=L*O+w*m+g*C-(F*O+D*m+z*C),j=B*O+v*m+z*y-(P*O+x*m+g*y),Q=L*S+B*M+U*d-(P*M+p*d+F*S),J=v*M+p*A+w*S-(D*S+x*M+U*A),$=D*d+z*M+F*A-(g*M+L*A+w*d),ee=g*S+P*A+x*d-(v*d+z*S+B*A),te=r*G+i*b+a*X+_*V;if(Math.abs(te)<o.EPSILON20)throw new E("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=G*te,n[1]=b*te,n[2]=X*te,n[3]=V*te,n[4]=H*te,n[5]=W*te,n[6]=q*te,n[7]=Y*te,n[8]=K*te,n[9]=Z*te,n[10]=k*te,n[11]=j*te,n[12]=Q*te,n[13]=J*te,n[14]=$*te,n[15]=ee*te,n},s.inverseTransformation=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[4],o=e[5],u=e[6],E=e[8],s=e[9],_=e[10],c=e[12],R=e[13],T=e[14],l=-n*c-r*R-i*T,A=-a*c-o*R-u*T,f=-E*c-s*R-_*T;return t[0]=n,t[1]=a,t[2]=E,t[3]=0,t[4]=r,t[5]=o,t[6]=s,t[7]=0,t[8]=i,t[9]=u,t[10]=_,t[11]=0,t[12]=l,t[13]=A,t[14]=f,t[15]=1,t},s.IDENTITY=a(new s(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN0ROW3=3,s.COLUMN1ROW0=4,s.COLUMN1ROW1=5,s.COLUMN1ROW2=6,s.COLUMN1ROW3=7,s.COLUMN2ROW0=8,s.COLUMN2ROW1=9,s.COLUMN2ROW2=10,s.COLUMN2ROW3=11,s.COLUMN3ROW0=12,s.COLUMN3ROW1=13,s.COLUMN3ROW2=14,s.COLUMN3ROW3=15,s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},s}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function i(t,n){this.normal=e.clone(t),this.distance=n}i.fromPointNormal=function(n,r,a){var o=-e.dot(r,n);return t(a)?(e.clone(r,a.normal),a.distance=o,a):new i(r,o)};var a=new e;return i.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,a),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new i(o,u)},i.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},i.ORIGIN_XY_PLANE=r(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=r(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=r(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";function E(e,n,r,i){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(i,0)}r(E.prototype,{width:{get:function(){return E.computeWidth(this)}},height:{get:function(){return E.computeHeight(this)}}}),E.packedLength=4,E.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},E.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new E),i.west=e[r++],i.south=e[r++],i.east=e[r++],i.north=e[r],i},E.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},E.computeHeight=function(e){return e.north-e.south},E.fromDegrees=function(e,r,i,a,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),i=u.toRadians(t(i,0)),a=u.toRadians(t(a,0)),n(o)?(o.west=e,o.south=r,o.east=i,o.north=a,o):new E(e,r,i,a)},E.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,s=Number.MAX_VALUE,_=-Number.MAX_VALUE,c=0,R=e.length;R>c;c++){var T=e[c];r=Math.min(r,T.longitude),i=Math.max(i,T.longitude),s=Math.min(s,T.latitude),_=Math.max(_,T.latitude);var l=T.longitude>=0?T.longitude:T.longitude+u.TWO_PI;a=Math.min(a,l),o=Math.max(o,l)}return i-r>o-a&&(r=a,i=o,i>u.PI&&(i-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=s,t.east=i,t.north=_,t):new E(r,s,i,_)},E.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new E(e.west,e.south,e.east,e.north):void 0},E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},E.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},E.validate=function(e){},E.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},E.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},E.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},E.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},E.center=function(t,r){var i=t.east,a=t.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),E=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=E,r.height=0,r):new e(o,E)},E.intersection=function(e,t,r){var i=e.east,a=e.west,o=t.east,s=t.west;a>i&&o>0?i+=u.TWO_PI:s>o&&i>0&&(o+=u.TWO_PI),a>i&&0>s?s+=u.TWO_PI:s>o&&0>a&&(a+=u.TWO_PI);var _=u.negativePiToPi(Math.max(a,s)),c=u.negativePiToPi(Math.min(i,o));if(!((e.west<e.east||t.west<t.east)&&_>=c)){var R=Math.max(e.south,t.south),T=Math.min(e.north,t.north);if(!(R>=T))return n(r)?(r.west=_,r.south=R,r.east=c,r.north=T,r):new E(_,R,c,T)}},E.contains=function(e,t){var n=t.longitude,r=t.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=e.south&&r<=e.north};var s=new e;return E.subsample=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0),n(o)||(o=[]);var _=0,c=e.north,R=e.south,T=e.east,l=e.west,A=s;A.height=i,A.longitude=l,A.latitude=c,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=T,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.latitude=R,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=l,o[_]=r.cartographicToCartesian(A,o[_]),_++,0>c?A.latitude=c:R>0?A.latitude=R:A.latitude=0;for(var f=1;8>f;++f)A.longitude=-Math.PI+f*u.PI_OVER_TWO,E.contains(e,A)&&(o[_]=r.cartographicToCartesian(A,o[_]),_++);return 0===A.latitude&&(A.longitude=l,o[_]=r.cartographicToCartesian(A,o[_]),_++,A.longitude=T,o[_]=r.cartographicToCartesian(A,o[_]),_++),o.length=_,o},E.MAX_VALUE=o(new E(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),E}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,n,r,i,a,o,u,E,s,_,c,R){"use strict";function T(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var l=new e,A=new e,f=new e,N=new e,h=new e,I=new e,d=new e,S=new e,M=new e,O=new e,m=new e,y=new e;T.fromPoints=function(t,n){if(r(n)||(n=new T),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var i=e.clone(t[0],d),a=e.clone(i,l),o=e.clone(i,A),u=e.clone(i,f),E=e.clone(i,N),s=e.clone(i,h),_=e.clone(i,I),c=t.length,R=1;c>R;R++){e.clone(t[R],i);var C=i.x,p=i.y,U=i.z;C<a.x&&e.clone(i,a),C>E.x&&e.clone(i,E),p<o.y&&e.clone(i,o),p>s.y&&e.clone(i,s),U<u.z&&e.clone(i,u),U>_.z&&e.clone(i,_)}var L=e.magnitudeSquared(e.subtract(E,a,S)),F=e.magnitudeSquared(e.subtract(s,o,S)),P=e.magnitudeSquared(e.subtract(_,u,S)),B=a,D=E,w=L;F>w&&(w=F,B=o,D=s),P>w&&(w=P,B=u,D=_);var v=M;v.x=.5*(B.x+D.x),v.y=.5*(B.y+D.y),v.z=.5*(B.z+D.z);var x=e.magnitudeSquared(e.subtract(D,v,S)),g=Math.sqrt(x),z=O;z.x=a.x,z.y=o.y,z.z=u.z;var G=m;G.x=E.x,G.y=s.y,G.z=_.z;var b=e.multiplyByScalar(e.add(z,G,S),.5,y),X=0;for(R=0;c>R;R++){e.clone(t[R],i);var V=e.magnitude(e.subtract(i,b,S));V>X&&(X=V);var H=e.magnitudeSquared(e.subtract(i,v,S));if(H>x){var W=Math.sqrt(H);g=.5*(g+W),x=g*g;var q=W-g;v.x=(g*v.x+q*i.x)/W,v.y=(g*v.y+q*i.y)/W,v.z=(g*v.z+q*i.z)/W}}return X>g?(e.clone(v,n.center),n.radius=g):(e.clone(b,n.center),n.radius=X),n};var C=new o,p=new e,U=new e,L=new t,F=new t;T.fromRectangle2D=function(e,t,n){return T.fromRectangleWithHeights2D(e,t,0,0,n)},T.fromRectangleWithHeights2D=function(t,i,a,o,u){if(r(u)||(u=new T),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,C),R.southwest(t,L),L.height=a,R.northeast(t,F),F.height=o;var E=i.project(L,p),s=i.project(F,U),_=s.x-E.x,c=s.y-E.y,l=s.z-E.z;u.radius=.5*Math.sqrt(_*_+c*c+l*l);var A=u.center;return A.x=E.x+.5*_,A.y=E.y+.5*c,A.z=E.z+.5*l,u};var P=[];T.fromRectangle3D=function(e,t,i,o){t=n(t,a.WGS84),i=n(i,0);var u;return r(e)&&(u=R.subsample(e,t,i,P)),T.fromPoints(u,o)},T.fromVertices=function(t,i,a,o){if(r(o)||(o=new T),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;i=n(i,e.ZERO),a=n(a,3);var u=d;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var E=e.clone(u,l),s=e.clone(u,A),_=e.clone(u,f),c=e.clone(u,N),R=e.clone(u,h),C=e.clone(u,I),p=t.length,U=0;p>U;U+=a){var L=t[U]+i.x,F=t[U+1]+i.y,P=t[U+2]+i.z;u.x=L,u.y=F,u.z=P,L<E.x&&e.clone(u,E),L>c.x&&e.clone(u,c),F<s.y&&e.clone(u,s),F>R.y&&e.clone(u,R),P<_.z&&e.clone(u,_),P>C.z&&e.clone(u,C)}var B=e.magnitudeSquared(e.subtract(c,E,S)),D=e.magnitudeSquared(e.subtract(R,s,S)),w=e.magnitudeSquared(e.subtract(C,_,S)),v=E,x=c,g=B;D>g&&(g=D,v=s,x=R),w>g&&(g=w,v=_,x=C);var z=M;z.x=.5*(v.x+x.x),z.y=.5*(v.y+x.y),z.z=.5*(v.z+x.z);var G=e.magnitudeSquared(e.subtract(x,z,S)),b=Math.sqrt(G),X=O;X.x=E.x,X.y=s.y,X.z=_.z;var V=m;V.x=c.x,V.y=R.y,V.z=C.z;var H=e.multiplyByScalar(e.add(X,V,S),.5,y),W=0;for(U=0;p>U;U+=a){u.x=t[U]+i.x,u.y=t[U+1]+i.y,u.z=t[U+2]+i.z;var q=e.magnitude(e.subtract(u,H,S));q>W&&(W=q);var Y=e.magnitudeSquared(e.subtract(u,z,S));if(Y>G){var K=Math.sqrt(Y);b=.5*(b+K),G=b*b;var Z=K-b;z.x=(b*z.x+Z*u.x)/K,z.y=(b*z.y+Z*u.y)/K,z.z=(b*z.z+Z*u.z)/K}}return W>b?(e.clone(z,o.center),o.radius=b):(e.clone(H,o.center),o.radius=W),o},T.fromCornerPoints=function(t,n,i){r(i)||(i=new T);var a=i.center;return e.add(t,n,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,n),i},T.fromEllipsoid=function(t,n){return r(n)||(n=new T),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var B=new e;T.fromBoundingSpheres=function(t,n){if(r(n)||(n=new T),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=t.length;if(1===i)return T.clone(t[0],n);if(2===i)return T.union(t[0],t[1],n);for(var a=[],o=0;i>o;o++)a.push(t[o].center);n=T.fromPoints(a,n);var u=n.center,E=n.radius;for(o=0;i>o;o++){var s=t[o];E=Math.max(E,e.distance(u,s.center,B)+s.radius)}return n.radius=E,n};var D=new e,w=new e,v=new e;T.fromOrientedBoundingBox=function(t,n){r(n)||(n=new T);var i=t.halfAxes,a=s.getColumn(i,0,D),o=s.getColumn(i,1,w),u=s.getColumn(i,2,v),E=e.magnitude(a),_=e.magnitude(o),c=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(E,_,c),n},T.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new T(t.center,t.radius):void 0},T.packedLength=4,T.pack=function(e,t,r){r=n(r,0);var i=e.center;t[r++]=i.x,t[r++]=i.y,t[r++]=i.z,t[r]=e.radius},T.unpack=function(e,t,i){t=n(t,0),r(i)||(i=new T);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var x=new e,g=new e;T.union=function(t,n,i){r(i)||(i=new T);var a=t.center,o=t.radius,u=n.center,E=n.radius,s=e.subtract(u,a,x),_=e.magnitude(s);if(o>=_+E)return t.clone(i),i;if(E>=_+o)return n.clone(i),i;var c=.5*(o+_+E),R=e.multiplyByScalar(s,(-o+c)/_,g);return e.add(R,a,R),e.clone(R,i.center),i.radius=c,i};var z=new e;T.expand=function(t,n,r){r=T.clone(t,r);var i=e.magnitude(e.subtract(n,r.center,z));return i>r.radius&&(r.radius=i),r},T.intersectPlane=function(t,n){var r=t.center,i=t.radius,a=n.normal,o=e.dot(a,r)+n.distance;return-i>o?u.OUTSIDE:i>o?u.INTERSECTING:u.INSIDE},T.transform=function(e,t,n){return r(n)||(n=new T),n.center=_.multiplyByPoint(t,e.center,n.center),n.radius=_.getMaximumScale(t)*e.radius,n};var G=new e;T.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,G);return e.magnitudeSquared(r)-t.radius*t.radius},T.transformWithoutScale=function(e,t,n){return r(n)||(n=new T),n.center=_.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var b=new e;T.computePlaneDistances=function(t,n,i,a){r(a)||(a=new E);var o=e.subtract(t.center,n,b),u=e.dot(i,o);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var X=new e,V=new e,H=new e,W=new e,q=new e,Y=new t,K=new Array(8),Z=0;8>Z;++Z)K[Z]=new e;var k=new o;return T.projectTo2D=function(t,r,i){r=n(r,k);var a=r.ellipsoid,o=t.center,u=t.radius,E=a.geodeticSurfaceNormal(o,X),s=e.cross(e.UNIT_Z,E,V);e.normalize(s,s);var _=e.cross(E,s,H);e.normalize(_,_),e.multiplyByScalar(E,u,E),e.multiplyByScalar(_,u,_),e.multiplyByScalar(s,u,s);var c=e.negate(_,q),R=e.negate(s,W),l=K,A=l[0];e.add(E,_,A),e.add(A,s,A),A=l[1],e.add(E,_,A),e.add(A,R,A),A=l[2],e.add(E,c,A),e.add(A,R,A),A=l[3],e.add(E,c,A),e.add(A,s,A),e.negate(E,E),A=l[4],e.add(E,_,A),e.add(A,s,A),A=l[5],e.add(E,_,A),e.add(A,R,A),A=l[6],e.add(E,c,A),e.add(A,R,A),A=l[7],e.add(E,c,A),e.add(A,s,A);for(var f=l.length,N=0;f>N;++N){var h=l[N];e.add(o,h,h);var I=a.cartesianToCartographic(h,Y);r.project(I,h)}i=T.fromPoints(l,i),o=i.center;var d=o.x,S=o.y,M=o.z;return o.x=M,o.y=d,o.z=S,i},T.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},T.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},T.prototype.intersectPlane=function(e){return T.intersectPlane(this,e)},T.prototype.distanceSquaredTo=function(e){return T.distanceSquaredTo(this,e)},T.prototype.computePlaneDistances=function(e,t,n){return T.computePlaneDistances(this,e,t,n)},T.prototype.isOccluded=function(e){return T.isOccluded(this,e)},T.prototype.equals=function(e){return T.equals(this,e)},T.prototype.clone=function(e){return T.clone(this,e)},T}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,
RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var E=a[o];i=E+"RequestFullscreen","function"==typeof t[i]?(r.requestFullscreen=i,n=!0):(i=E+"RequestFullScreen","function"==typeof t[i]&&(r.requestFullscreen=i,n=!0)),i=E+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=E+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=E+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=E+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=E+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=E+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=E+"fullscreenchange",e(document["on"+i])&&("ms"===E&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=E+"fullscreenerror",e(document["on"+i])&&("ms"===E&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function i(){if(!t(N)){N=!1;var e=/ Chrome\/([\.0-9]+)/.exec(f.userAgent);null!==e&&(N=!0,h=r(e[1]))}return N}function a(){return i()&&h}function o(){if(!t(I)&&(I=!1,!i()&&/ Safari\/[\.0-9]+/.test(f.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(f.userAgent);null!==e&&(I=!0,d=r(e[1]))}return I}function u(){return o()&&d}function E(){if(!t(S)){S=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(f.userAgent);null!==e&&(S=!0,M=r(e[1]),M.isNightly=!!e[2])}return S}function s(){return E()&&M}function _(){if(!t(O)){O=!1;var e;"Microsoft Internet Explorer"===f.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(f.userAgent),null!==e&&(O=!0,m=r(e[1]))):"Netscape"===f.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(f.userAgent),null!==e&&(O=!0,m=r(e[1])))}return O}function c(){return _()&&m}function R(){if(!t(y)){y=!1;var e=/Firefox\/([\.0-9]+)/.exec(f.userAgent);null!==e&&(y=!0,C=r(e[1]))}return y}function T(){return t(p)||(p=/Windows/i.test(f.appVersion)),p}function l(){return R()&&C}function A(){return t(U)||(U="undefined"!=typeof PointerEvent&&(!t(f.pointerEnabled)||f.pointerEnabled)),U}var f;f="undefined"!=typeof navigator?navigator:{};var N,h,I,d,S,M,O,m,y,C,p,U,L={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:E,webkitVersion:s,isInternetExplorer:_,internetExplorerVersion:c,isFirefox:R,firefoxVersion:l,isWindows:T,hardwareConcurrency:e(f.hardwareConcurrency,3),supportsPointerEvents:A};return L.supportsFullscreen=function(){return n.supportsFullscreen()},L.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},L.supportsWebWorkers=function(){return"undefined"!=typeof Worker},L}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,i,a){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return n(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,n,i,a){switch(i=t(i,0),a=t(a,(n.byteLength-i)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,i,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,i,a);case o.SHORT:return new Int16Array(n,i,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,i,a);case o.FLOAT:return new Float32Array(n,i,a);case o.DOUBLE:return new Float64Array(n,i,a);default:throw new r("componentDatatype is not a valid value.")}},a(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var n={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===n.POINTS||e===n.LINES||e===n.LINE_LOOP||e===n.LINE_STRIP||e===n.TRIANGLES||e===n.TRIANGLE_STRIP||e===n.TRIANGLE_FAN}};return t(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,i){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0}return a.computeNumberOfVertices=function(e){var r=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return r}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/BoxOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType"],function(e,t,n,r,i,a,o,u,E,s){"use strict";function _(e){e=r(e,r.EMPTY_OBJECT);var n=e.minimum,i=e.maximum;this._min=t.clone(n),this._max=t.clone(i),this._workerName="createBoxOutlineGeometry"}var c=new t;_.fromDimensions=function(e){e=r(e,r.EMPTY_OBJECT);var n=e.dimensions,i=t.multiplyByScalar(n,.5,new t);return new _({minimum:t.negate(i,new t),maximum:i})},_.fromAxisAlignedBoundingBox=function(e){if(!i(e))throw new a("boundingBox is required.");return new _({minimum:e.minimum,maximum:e.maximum})},_.packedLength=2*t.packedLength,_.pack=function(e,n,i){i=r(i,0),t.pack(e._min,n,i),t.pack(e._max,n,i+t.packedLength)};var R=new t,T=new t,l={minimum:R,maximum:T};return _.unpack=function(e,n,a){n=r(n,0);var o=t.unpack(e,n,R),u=t.unpack(e,n+t.packedLength,T);return i(a)?(a._min=t.clone(o,a._min),a._max=t.clone(u,a._max),a):new _(l)},_.createGeometry=function(r){var i=r._min,a=r._max,_=new E,R=new Uint16Array(24),T=new Float64Array(24);T[0]=i.x,T[1]=i.y,T[2]=i.z,T[3]=a.x,T[4]=i.y,T[5]=i.z,T[6]=a.x,T[7]=a.y,T[8]=i.z,T[9]=i.x,T[10]=a.y,T[11]=i.z,T[12]=i.x,T[13]=i.y,T[14]=a.z,T[15]=a.x,T[16]=i.y,T[17]=a.z,T[18]=a.x,T[19]=a.y,T[20]=a.z,T[21]=i.x,T[22]=a.y,T[23]=a.z,_.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:T}),R[0]=4,R[1]=5,R[2]=5,R[3]=6,R[4]=6,R[5]=7,R[6]=7,R[7]=4,R[8]=0,R[9]=1,R[10]=1,R[11]=2,R[12]=2,R[13]=3,R[14]=3,R[15]=0,R[16]=0,R[17]=4,R[18]=1,R[19]=5,R[20]=2,R[21]=6,R[22]=3,R[23]=7;var l=t.subtract(a,i,c),A=.5*t.magnitude(l);return new o({attributes:_,indices:R,primitiveType:s.LINES,boundingSphere:new e(t.ZERO,A)})},_}),define("Workers/createBoxOutlineGeometry",["../Core/BoxOutlineGeometry","../Core/defined"],function(e,t){"use strict";return function(n,r){return t(r)&&(n=e.unpack(n,r)),e.createGeometry(n)}})}();