/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
 * @license almond 0.3.1 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

// Copyright 2012 Google Inc., Apache 2.0 license.

/**
@license
tween.js - https://github.com/sole/tween.js

Copyright (c) 2010-2012 Tween.js authors.

Easing equations Copyright (c) 2001 Robert Penner http://robertpenner.com/easing/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/**
  @license
  fontmetrics.js - https://github.com/Pomax/fontmetrics.js

  Copyright (C) 2011 by Mike "Pomax" Kamermans

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
**/

/**
@license
topojson - https://github.com/mbostock/topojson

Copyright (c) 2012, Michael Bostock
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* The name Michael Bostock may not be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
 * Autolinker.js
 * 0.17.1
 *
 * Copyright(c) 2015 Gregory Jacobs <greg@greg-jacobs.com>
 * MIT Licensed. http://www.opensource.org/licenses/mit-license.php
 *
 * https://github.com/gregjacobs/Autolinker.js
 */

/**
@license
 Copyright (c) 2013 Gildas Lormeau. All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in
 the documentation and/or other materials provided with the distribution.

 3. The names of the authors may not be used to endorse or promote products
 derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
 INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**/

/**
 * @license
 * Copyright (c) 2011 NVIDIA Corporation. All rights reserved.
 *
 * TO  THE MAXIMUM  EXTENT PERMITTED  BY APPLICABLE  LAW, THIS SOFTWARE  IS PROVIDED
 * *AS IS*  AND NVIDIA AND  ITS SUPPLIERS DISCLAIM  ALL WARRANTIES,  EITHER  EXPRESS
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED  TO, NONINFRINGEMENT,IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL  NVIDIA 
 * OR ITS SUPPLIERS BE  LIABLE  FOR  ANY  DIRECT, SPECIAL,  INCIDENTAL,  INDIRECT,  OR  
 * CONSEQUENTIAL DAMAGES WHATSOEVER (INCLUDING, WITHOUT LIMITATION,  DAMAGES FOR LOSS 
 * OF BUSINESS PROFITS, BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR ANY 
 * OTHER PECUNIARY LOSS) ARISING OUT OF THE  USE OF OR INABILITY  TO USE THIS SOFTWARE, 
 * EVEN IF NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

/**
 * @license
 * Copyright (c) 2000-2005, Sean O'Neil (s_p_oneil@hotmail.com)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of the project nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modifications made by Analytical Graphics, Inc.
 */

/**
 * @license
 * Knockout JavaScript library v3.2.0
 * (c) Steven Sanderson - http://knockoutjs.com/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * @license
 * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5
 * Copyright (c) Steve Sanderson
 * MIT license
 */

!function(){var e,t,r;!function(i){function n(e,t){return C.call(e,t)}function o(e,t){var r,i,n,o,a,s,l,u,c,h,d,p=t&&t.split("/"),m=g.map,f=m&&m["*"]||{};if(e&&"."===e.charAt(0))if(t){for(e=e.split("/"),a=e.length-1,g.nodeIdCompat&&S.test(e[a])&&(e[a]=e[a].replace(S,"")),e=p.slice(0,p.length-1).concat(e),c=0;c<e.length;c+=1)if(d=e[c],"."===d)e.splice(c,1),c-=1;else if(".."===d){if(1===c&&(".."===e[2]||".."===e[0]))break;c>0&&(e.splice(c-1,2),c-=2)}e=e.join("/")}else 0===e.indexOf("./")&&(e=e.substring(2));if((p||f)&&m){for(r=e.split("/"),c=r.length;c>0;c-=1){if(i=r.slice(0,c).join("/"),p)for(h=p.length;h>0;h-=1)if(n=m[p.slice(0,h).join("/")],n&&(n=n[i])){o=n,s=c;break}if(o)break;!l&&f&&f[i]&&(l=f[i],u=c)}!o&&l&&(o=l,s=u),o&&(r.splice(0,s,o),e=r.join("/"))}return e}function a(e,t){return function(){var r=E.call(arguments,0);return"string"!=typeof r[0]&&1===r.length&&r.push(null),p.apply(i,r.concat([e,t]))}}function s(e){return function(t){return o(t,e)}}function l(e){return function(t){v[e]=t}}function u(e){if(n(_,e)){var t=_[e];delete _[e],y[e]=!0,d.apply(i,t)}if(!n(v,e)&&!n(y,e))throw new Error("No "+e);return v[e]}function c(e){var t,r=e?e.indexOf("!"):-1;return r>-1&&(t=e.substring(0,r),e=e.substring(r+1,e.length)),[t,e]}function h(e){return function(){return g&&g.config&&g.config[e]||{}}}var d,p,m,f,v={},_={},g={},y={},C=Object.prototype.hasOwnProperty,E=[].slice,S=/\.js$/;m=function(e,t){var r,i=c(e),n=i[0];return e=i[1],n&&(n=o(n,t),r=u(n)),n?e=r&&r.normalize?r.normalize(e,s(t)):o(e,t):(e=o(e,t),i=c(e),n=i[0],e=i[1],n&&(r=u(n))),{f:n?n+"!"+e:e,n:e,pr:n,p:r}},f={require:function(e){return a(e)},exports:function(e){var t=v[e];return"undefined"!=typeof t?t:v[e]={}},module:function(e){return{id:e,uri:"",exports:v[e],config:h(e)}}},d=function(e,t,r,o){var s,c,h,d,p,g,C=[],E=typeof r;if(o=o||e,"undefined"===E||"function"===E){for(t=!t.length&&r.length?["require","exports","module"]:t,p=0;p<t.length;p+=1)if(d=m(t[p],o),c=d.f,"require"===c)C[p]=f.require(e);else if("exports"===c)C[p]=f.exports(e),g=!0;else if("module"===c)s=C[p]=f.module(e);else if(n(v,c)||n(_,c)||n(y,c))C[p]=u(c);else{if(!d.p)throw new Error(e+" missing "+c);d.p.load(d.n,a(o,!0),l(c),{}),C[p]=v[c]}h=r?r.apply(v[e],C):void 0,e&&(s&&s.exports!==i&&s.exports!==v[e]?v[e]=s.exports:h===i&&g||(v[e]=h))}else e&&(v[e]=r)},e=t=p=function(e,t,r,n,o){if("string"==typeof e)return f[e]?f[e](t):u(m(e,t).f);if(!e.splice){if(g=e,g.deps&&p(g.deps,g.callback),!t)return;t.splice?(e=t,t=r,r=null):e=i}return t=t||function(){},"function"==typeof r&&(r=n,n=o),n?d(i,e,t,r):setTimeout(function(){d(i,e,t,r)},4),p},p.config=function(e){return p(e)},e._defined=v,r=function(e,t,r){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(r=t,t=[]),n(v,e)||n(_,e)||(_[e]=[e,t,r])},r.amd={jQuery:!0}}(),r("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,i,n){return t(e).then(r,i,n)}function t(e){var t,r;return e instanceof i?t=e:s(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=n(e),t}function r(t){return e(t,o)}function i(e){this.then=e}function n(e){var r=new i(function(r){try{return t(r?r(e):e)}catch(i){return o(i)}});return r}function o(e){var r=new i(function(r,i){try{return i?t(i(e)):o(e)}catch(n){return o(n)}});return r}function a(){function e(e,t,r){return d(e,t,r)}function r(e){return m(e)}function n(e){return m(o(e))}function s(e){return p(e)}var l,u,c,h,d,p,m;return u=new i(e),l={then:e,resolve:r,reject:n,progress:s,promise:u,resolver:{resolve:r,reject:n,progress:s}},c=[],h=[],d=function(e,t,r){var i,n;return i=a(),n="function"==typeof r?function(e){try{i.progress(r(e))}catch(t){i.progress(t)}}:function(e){i.progress(e)},c.push(function(r){r.then(e,t).then(i.resolve,i.reject,n)}),h.push(n),i.promise},p=function(e){return f(h,e),e},m=function(e){return e=t(e),d=e.then,m=t,p=_,f(c,e),h=c=E,e},l}function s(e){return e&&"function"==typeof e.then}function l(t,r,i,n,o){return v(2,arguments),e(t,function(t){function s(e){f(e)}function l(e){m(e)}var u,c,h,d,p,m,f,v,g,y;if(g=t.length>>>0,u=Math.max(0,Math.min(r,g)),h=[],c=g-u+1,d=[],p=a(),u)for(v=p.progress,f=function(e){d.push(e),--c||(m=f=_,p.reject(d))},m=function(e){h.push(e),--u||(m=f=_,p.resolve(h))},y=0;g>y;++y)y in t&&e(t[y],l,s,v);else p.resolve(h);return p.then(i,n,o)})}function u(e,t,r,i){function n(e){return t?t(e[0]):e[0]}return l(e,1,n,r,i)}function c(e,t,r,i){return v(1,arguments),d(e,g).then(t,r,i)}function h(){return d(arguments,g)}function d(t,r){return e(t,function(t){var i,n,o,s,l,u;if(o=n=t.length>>>0,i=[],u=a(),o)for(s=function(t,n){e(t,r).then(function(e){i[n]=e,--o||u.resolve(i)},u.reject)},l=0;n>l;l++)l in t?s(t[l],l):--o;else u.resolve(i);return u.promise})}function p(t,r){var i=C.call(arguments,1);return e(t,function(t){var n;return n=t.length,i[0]=function(t,i,o){return e(t,function(t){return e(i,function(e){return r(t,e,o,n)})})},y.apply(t,i)})}function m(t,r,i){var n=arguments.length>2;return e(t,function(e){return e=n?i:e,r.resolve(e),e},function(e){return r.reject(e),o(e)},r.progress)}function f(e,t){for(var r,i=0;r=e[i++];)r(t)}function v(e,t){for(var r,i=t.length;i>e;)if(r=t[--i],null!=r&&"function"!=typeof r)throw new Error("arg "+i+" must be a function")}function _(){}function g(e){return e}var y,C,E;return e.defer=a,e.resolve=t,e.reject=r,e.join=h,e.all=c,e.map=d,e.reduce=p,e.any=u,e.some=l,e.chain=m,e.isPromise=s,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(E,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return c(t,function(t){return e.apply(E,t)})})}},C=[].slice,y=[].reduce||function(e){var t,r,i,n,o;if(o=0,t=Object(this),n=t.length>>>0,r=arguments,r.length<=1)for(;;){if(o in t){i=t[o++];break}if(++o>=n)throw new TypeError}else i=r[1];for(;n>o;++o)o in t&&(i=e(i,t[o],o,t));return i},e})}("function"==typeof r&&r.amd?r:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),r("Core/defined",[],function(){"use strict";function e(e){return void 0!==e}return e}),r("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),r("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),r("Core/Credit",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,i){var a=e(i),s=e(r),l=e(t);l||s||(t=i),this._text=t,this._imageUrl=r,this._link=i,this._hasLink=a,this._hasImage=s;var u,c=JSON.stringify([t,r,i]);e(o[c])?u=o[c]:(u=n++,o[c]=u),this._id=u}var n=0,o={};return t(i.prototype,{text:{get:function(){return this._text}},imageUrl:{get:function(){return this._imageUrl}},link:{get:function(){return this._link}},id:{get:function(){return this._id}}}),i.prototype.hasImage=function(){return this._hasImage},i.prototype.hasLink=function(){return this._hasLink},i.equals=function(t,r){return t===r||e(t)&&e(r)&&t._id===r._id},i.prototype.equals=function(e){return i.equals(this,e)},i}),r("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),r("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),r("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),r("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},n.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},n.lerp=function(e,t,r){return(1-r)*e+r*t},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){var t=n.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},n.negativePiToPi=function(e){return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){var t=n.mod(e,n.TWO_PI);return Math.abs(t)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:t},n.mod=function(e,t){return(e%t+t)%t},n.equalsEpsilon=function(e,r,i,n){n=t(n,i);var o=Math.abs(e-r);return n>=o||o<=i*Math.max(Math.abs(e),Math.abs(r))};var o=[1];n.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],i=t;e>=i;i++)o.push(r*i);return o[e]},n.incrementWrap=function(e,r,i){return i=t(i,0),++e,e>r&&(e=i),e},n.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new e;return n.setRandomNumberSeed=function(t){a=new e(t)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},n.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},n}),r("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";function o(t,r,i){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0)}o.fromSpherical=function(r,i){t(i)||(i=new o);var n=r.clock,a=r.cone,s=e(r.magnitude,1),l=s*Math.sin(a);return i.x=l*Math.cos(n),i.y=l*Math.sin(n),i.z=s*Math.cos(a),i},o.fromElements=function(e,r,i,n){return t(n)?(n.x=e,n.y=r,n.z=i,n):new o(e,r,i)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i++]=t.y,r[i]=t.z},o.unpack=function(r,i,n){return i=e(i,0),t(n)||(n=new o),n.x=r[i++],n.y=r[i++],n.z=r[i],n},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,r,i){return o.multiplyByScalar(t,r,s),i=o.multiplyByScalar(e,1-r,i),o.add(s,i,i)};var l=new o,u=new o;o.angleBetween=function(e,t){o.normalize(e,l),o.normalize(t,u);var r=o.dot(l,u),i=o.magnitude(o.cross(l,u,l));return Math.atan2(i,r)};var c=new o;o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,c);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):r.y<=r.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)&&n.equalsEpsilon(e.z,r.z,i,o)},o.cross=function(e,t,r){var i=e.x,n=e.y,o=e.z,a=t.x,s=t.y,l=t.z,u=n*l-o*s,c=o*a-i*l,h=i*s-n*a;return r.x=u,r.y=c,r.z=h,r},o.fromDegrees=function(e,t,r,i,a){var s=n.toRadians(e),l=n.toRadians(t);return o.fromRadians(s,l,r,i,a)};var h=new o,d=new o,p=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(r,i,n,a,s){n=e(n,0);var l=t(a)?a.radiiSquared:p,u=Math.cos(i);h.x=u*Math.cos(r),h.y=u*Math.sin(r),h.z=Math.sin(i),h=o.normalize(h,h),o.multiplyComponents(l,h,d);var c=Math.sqrt(o.dot(h,d));return d=o.divideByScalar(d,c,d),h=o.multiplyByScalar(h,n,h),t(s)||(s=new o),o.add(d,h,s)},o.fromDegreesArray=function(e,t,r){for(var i=new Array(e.length),a=0;a<e.length;a++)i[a]=n.toRadians(e[a]);return o.fromRadiansArray(i,t,r)},o.fromRadiansArray=function(e,r,i){var n=e.length;t(i)?i.length=n/2:i=new Array(n/2);for(var a=0;n>a;a+=2){var s=e[a],l=e[a+1];i[a/2]=o.fromRadians(s,l,0,r,i[a/2])}return i},o.fromDegreesArrayHeights=function(e,t,r){for(var i=new Array(e.length),a=0;a<e.length;a+=3)i[a]=n.toRadians(e[a]),i[a+1]=n.toRadians(e[a+1]),i[a+2]=e[a+2];return o.fromRadiansArrayHeights(i,t,r)},o.fromRadiansArrayHeights=function(e,r,i){var n=e.length;t(i)?i.length=n/3:i=new Array(n/3);for(var a=0;n>a;a+=3){var s=e[a],l=e[a+1],u=e[a+2];i[a/3]=o.fromRadians(s,l,u,r,i[a/3])}return i},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),r("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,i){"use strict";function n(r,n,s,l,u){var c=r.x,h=r.y,d=r.z,p=n.x,m=n.y,f=n.z,v=c*c*p*p,_=h*h*m*m,g=d*d*f*f,y=v+_+g,C=Math.sqrt(1/y),E=e.multiplyByScalar(r,C,o);if(l>y)return isFinite(C)?e.clone(E,u):void 0;var S=s.x,w=s.y,T=s.z,x=a;x.x=E.x*S*2,x.y=E.y*w*2,x.z=E.z*T*2;var b,P,A,I,M,D,R,O,N,L,F,B=(1-C)*e.magnitude(r)/(.5*e.magnitude(x)),V=0;do{B-=V,A=1/(1+B*S),I=1/(1+B*w),M=1/(1+B*T),D=A*A,R=I*I,O=M*M,N=D*A,L=R*I,F=O*M,b=v*D+_*R+g*O-1,P=v*N*S+_*L*w+g*F*T;var z=-2*P;V=b/z}while(Math.abs(b)>i.EPSILON12);return t(u)?(u.x=c*A,u.y=h*I,u.z=d*M,u):new e(c*A,h*I,d*M)}var o=new e,a=new e;return n}),r("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,i){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(i,0)}s.fromRadians=function(e,i,n,o){return n=t(n,0),r(o)?(o.longitude=e,o.latitude=i,o.height=n,o):new s(e,i,n)},s.fromDegrees=function(e,t,r,i){return e=o.toRadians(e),t=o.toRadians(t),s.fromRadians(e,t,r,i)};var l=new e,u=new e,c=new e,h=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),p=o.EPSILON1;return s.fromCartesian=function(t,i,n){var m=r(i)?i.oneOverRadii:h,f=r(i)?i.oneOverRadiiSquared:d,v=r(i)?i._centerToleranceSquared:p,_=a(t,m,f,v,u);if(r(_)){var g=e.multiplyComponents(t,f,l);g=e.normalize(g,g);var y=e.subtract(t,_,c),C=Math.atan2(g.y,g.x),E=Math.asin(g.z),S=o.sign(e.dot(y,t))*e.magnitude(y);return r(n)?(n.longitude=C,n.latitude=E,n.height=S,n):new s(C,E,S)}},s.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new s(e.longitude,e.latitude,e.height):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},s.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},s.ZERO=n(new s(0,0,0)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},s}),r("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(t,i,n,o){i=r(i,0),n=r(n,0),o=r(o,0),t._radii=new e(i,n,o),t._radiiSquared=new e(i*i,n*n,o*o),t._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,n,o),t._maximumRadius=Math.max(i,n,o),t._centerToleranceSquared=s.EPSILON1}function c(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,e,t,r)}n(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(n.x,n.y,n.z)}},c.fromCartesian3=function(e,t){return i(t)||(t=new c),i(e)?(u(t,e.x,e.y,e.z),t):t},c.WGS84=a(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=a(new c(1,1,1)),c.MOON=a(new c(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,i,n){n=r(n,0),e.pack(t._radii,i,n)},c.unpack=function(t,i,n){i=r(i,0);var o=e.unpack(t,i);return c.fromCartesian3(o,n)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var n=t.longitude,o=t.latitude,a=Math.cos(o),s=a*Math.cos(n),l=a*Math.sin(n),u=Math.sin(o);return i(r)||(r=new e),r.x=s,r.y=l,r.z=u,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var h=new e,d=new e;c.prototype.cartographicToCartesian=function(t,r){var n=h,o=d;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(o,n,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var n=0;r>n;n++)t[n]=this.cartographicToCartesian(e[n],t[n]);return t};var p=new e,m=new e,f=new e;return c.prototype.cartesianToCartographic=function(r,n){var o=this.scaleToGeodeticSurface(r,m);if(i(o)){var a=this.geodeticSurfaceNormal(o,p),l=e.subtract(r,o,f),u=Math.atan2(a.y,a.x),c=Math.asin(a.z),h=s.sign(e.dot(l,r))*e.magnitude(l);return i(n)?(n.longitude=u,n.latitude=c,n.height=h,n):new t(u,c,h)}},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var n=0;r>n;++n)t[n]=this.cartesianToCartographic(e[n],t[n]);return t},c.prototype.scaleToGeodeticSurface=function(e,t){return l(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},c.prototype.scaleToGeocentricSurface=function(t,r){i(r)||(r=new e);var n=t.x,o=t.y,a=t.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(n*n*s.x+o*o*s.y+a*a*s.z);return e.multiplyByScalar(t,l,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),r("Core/Event",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";function i(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}return t(i.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),i.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var r=this;return function(){r.removeEventListener(e,t)}},i.prototype.removeEventListener=function(e,t){for(var r=this._listeners,i=this._scopes,n=-1,o=0;o<r.length;o++)if(r[o]===e&&i[o]===t){n=o;break}return-1!==n?(this._insideRaiseEvent?(this._toRemove.push(n),r[n]=void 0,i[n]=void 0):(r.splice(n,1),i.splice(n,1)),!0):!1},i.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var t,r=this._listeners,i=this._scopes,n=r.length;for(t=0;n>t;t++){var o=r[t];e(o)&&r[t].apply(i[t],arguments)}var a=this._toRemove;for(n=a.length,t=0;n>t;t++){var s=a[t];r.splice(s,1),i.splice(s,1)}a.length=0,this._insideRaiseEvent=!1},i}),r("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";function o(t,r){this.x=e(t,0),this.y=e(r,0)}o.fromElements=function(e,r,i){return t(i)?(i.x=e,i.y=r,i):new o(e,r)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i]=t.y},o.unpack=function(r,i,n){return i=e(i,0),t(n)||(n=new o),n.x=r[i++],n.y=r[i],n},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,r,i){return o.multiplyByScalar(t,r,s),i=o.multiplyByScalar(e,1-r,i),o.add(s,i,i)};var l=new o,u=new o;o.angleBetween=function(e,t){return o.normalize(e,l),o.normalize(t,u),n.acosClamped(o.dot(l,u))};var c=new o;return o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,c);return o.abs(r,r),t=r.x<=r.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),r("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,i,n,o,a){"use strict";function s(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return n(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var n=this._semimajorAxis,o=t.longitude*n,a=t.latitude*n,s=t.height;return i(r)?(r.x=o,r.y=a,r.z=s,r):new e(o,a,s)},s.prototype.unproject=function(e,r){var n=this._oneOverSemimajorAxis,o=e.x*n,a=e.y*n,s=e.z;return i(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new t(o,a,s)},s}),r("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,r,i,n){this.west=t(e,0),this.south=t(r,0),this.east=t(i,0),this.north=t(n,0)}i(l.prototype,{width:{get:function(){return l.computeWidth(this)}},height:{get:function(){return l.computeHeight(this)}}}),l.packedLength=4,l.pack=function(e,r,i){i=t(i,0),r[i++]=e.west,r[i++]=e.south,r[i++]=e.east,r[i]=e.north},l.unpack=function(e,i,n){return i=t(i,0),r(n)||(n=new l),n.west=e[i++],n.south=e[i++],n.east=e[i++],n.north=e[i],n},l.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=s.TWO_PI),t-r},l.computeHeight=function(e){return e.north-e.south},l.fromDegrees=function(e,i,n,o,a){return e=s.toRadians(t(e,0)),i=s.toRadians(t(i,0)),n=s.toRadians(t(n,0)),o=s.toRadians(t(o,0)),r(a)?(a.west=e,a.south=i,a.east=n,a.north=o,a):new l(e,i,n,o)},l.fromCartographicArray=function(e,t){for(var i=Number.MAX_VALUE,n=-Number.MAX_VALUE,o=Number.MAX_VALUE,a=-Number.MAX_VALUE,u=Number.MAX_VALUE,c=-Number.MAX_VALUE,h=0,d=e.length;d>h;h++){var p=e[h];i=Math.min(i,p.longitude),n=Math.max(n,p.longitude),u=Math.min(u,p.latitude),c=Math.max(c,p.latitude);var m=p.longitude>=0?p.longitude:p.longitude+s.TWO_PI;o=Math.min(o,m),a=Math.max(a,m)}return n-i>a-o&&(i=o,n=a,n>s.PI&&(n-=s.TWO_PI),i>s.PI&&(i-=s.TWO_PI)),r(t)?(t.west=i,t.south=u,t.east=n,t.north=c,t):new l(i,u,n,c)},l.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new l(e.west,e.south,e.east,e.north):void 0},l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},l.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},l.validate=function(e){},l.southwest=function(t,i){return r(i)?(i.longitude=t.west,i.latitude=t.south,i.height=0,i):new e(t.west,t.south)},l.northwest=function(t,i){return r(i)?(i.longitude=t.west,i.latitude=t.north,i.height=0,i):new e(t.west,t.north)},l.northeast=function(t,i){return r(i)?(i.longitude=t.east,i.latitude=t.north,i.height=0,i):new e(t.east,t.north)},l.southeast=function(t,i){return r(i)?(i.longitude=t.east,i.latitude=t.south,i.height=0,i):new e(t.east,t.south)},l.center=function(t,i){var n=t.east,o=t.west;o>n&&(n+=s.TWO_PI);var a=s.negativePiToPi(.5*(o+n)),l=.5*(t.south+t.north);return r(i)?(i.longitude=a,i.latitude=l,i.height=0,i):new e(a,l)},l.intersection=function(e,t,i){var n=e.east,o=e.west,a=t.east,u=t.west;o>n&&a>0?n+=s.TWO_PI:u>a&&n>0&&(a+=s.TWO_PI),o>n&&0>u?u+=s.TWO_PI:u>a&&0>o&&(o+=s.TWO_PI);var c=s.negativePiToPi(Math.max(o,u)),h=s.negativePiToPi(Math.min(n,a));if(!((e.west<e.east||t.west<t.east)&&c>=h)){var d=Math.max(e.south,t.south),p=Math.min(e.north,t.north);if(!(d>=p))return r(i)?(i.west=c,i.south=d,i.east=h,i.north=p,i):new l(c,d,h,p)}},l.contains=function(e,t){var r=t.longitude,i=t.latitude,n=e.west,o=e.east;return n>o&&(o+=s.TWO_PI,0>r&&(r+=s.TWO_PI)),(r>n||s.equalsEpsilon(r,n,s.EPSILON14))&&(o>r||s.equalsEpsilon(r,o,s.EPSILON14))&&i>=e.south&&i<=e.north};var u=new e;return l.subsample=function(e,i,n,a){i=t(i,o.WGS84),n=t(n,0),r(a)||(a=[]);var c=0,h=e.north,d=e.south,p=e.east,m=e.west,f=u;f.height=n,f.longitude=m,f.latitude=h,a[c]=i.cartographicToCartesian(f,a[c]),c++,f.longitude=p,a[c]=i.cartographicToCartesian(f,a[c]),c++,f.latitude=d,a[c]=i.cartographicToCartesian(f,a[c]),c++,f.longitude=m,a[c]=i.cartographicToCartesian(f,a[c]),c++,0>h?f.latitude=h:d>0?f.latitude=d:f.latitude=0;for(var v=1;8>v;++v)f.longitude=-Math.PI+v*s.PI_OVER_TWO,l.contains(e,f)&&(a[c]=i.cartographicToCartesian(f,a[c]),c++);return 0===f.latitude&&(f.longitude=m,a[c]=i.cartographicToCartesian(f,a[c]),c++,f.longitude=p,a[c]=i.cartographicToCartesian(f,a[c]),c++),a.length=c,a},l.MAX_VALUE=a(new l(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),l}),r("Core/GeographicTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./GeographicProjection","./Math","./Rectangle"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e){e=t(e,{}),this._ellipsoid=t(e.ellipsoid,o.WGS84),this._rectangle=t(e.rectangle,l.MAX_VALUE),this._projection=new a(this._ellipsoid),this._numberOfLevelZeroTilesX=t(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=t(e.numberOfLevelZeroTilesY,1)}return i(u.prototype,{
ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),u.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},u.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},u.prototype.rectangleToNativeRectangle=function(e,t){var i=s.toDegrees(e.west),n=s.toDegrees(e.south),o=s.toDegrees(e.east),a=s.toDegrees(e.north);return r(t)?(t.west=i,t.south=n,t.east=o,t.north=a,t):new l(i,n,o,a)},u.prototype.tileXYToNativeRectangle=function(e,t,r,i){var n=this.tileXYToRectangle(e,t,r,i);return n.west=s.toDegrees(n.west),n.south=s.toDegrees(n.south),n.east=s.toDegrees(n.east),n.north=s.toDegrees(n.north),n},u.prototype.tileXYToRectangle=function(e,t,i,n){var o=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),s=this.getNumberOfYTilesAtLevel(i),u=o.width/a,c=e*u+o.west,h=(e+1)*u+o.west,d=o.height/s,p=o.north-t*d,m=o.north-(t+1)*d;return r(n)||(n=new l(c,m,h,p)),n.west=c,n.south=m,n.east=h,n.north=p,n},u.prototype.positionToTileXY=function(t,i,n){var o=this._rectangle;if(l.contains(o,t)){var a=this.getNumberOfXTilesAtLevel(i),u=this.getNumberOfYTilesAtLevel(i),c=o.width/a,h=o.height/u,d=t.longitude;o.east<o.west&&(d+=s.TWO_PI);var p=(d-o.west)/c|0;p>=a&&(p=a-1);var m=(o.north-t.latitude)/h|0;return m>=u&&(m=u-1),r(n)?(n.x=p,n.y=m,n):new e(p,m)}},u}),r("Core/getImagePixels",["./defined"],function(e){"use strict";function t(t,i,n){e(i)||(i=t.width),e(n)||(n=t.height);var o=r[i];e(o)||(o={},r[i]=o);var a=o[n];if(!e(a)){var s=document.createElement("canvas");s.width=i,s.height=n,a=s.getContext("2d"),a.globalCompositeOperation="copy",o[n]=a}return a.drawImage(t,0,0,i,n),a.getImageData(0,0,i,n).data}var r={};return t}),r("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),r("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,r,i,n){"use strict";function o(i,n,o){this.minimum=e.clone(t(i,e.ZERO)),this.maximum=e.clone(t(n,e.ZERO)),r(o)?o=e.clone(o):(o=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(o,.5,o)),this.center=o}o.fromPoints=function(t,i){if(r(i)||(i=new o),!r(t)||0===t.length)return i.minimum=e.clone(e.ZERO,i.minimum),i.maximum=e.clone(e.ZERO,i.maximum),i.center=e.clone(e.ZERO,i.center),i;for(var n=t[0].x,a=t[0].y,s=t[0].z,l=t[0].x,u=t[0].y,c=t[0].z,h=t.length,d=1;h>d;d++){var p=t[d],m=p.x,f=p.y,v=p.z;n=Math.min(m,n),l=Math.max(m,l),a=Math.min(f,a),u=Math.max(f,u),s=Math.min(v,s),c=Math.max(v,c)}var _=i.minimum;_.x=n,_.y=a,_.z=s;var g=i.maximum;g.x=l,g.y=u,g.z=c;var y=e.add(_,g,i.center);return e.multiplyByScalar(y,.5,y),i},o.clone=function(t,i){return r(t)?r(i)?(i.minimum=e.clone(t.minimum,i.minimum),i.maximum=e.clone(t.maximum,i.maximum),i.center=e.clone(t.center,i.center),i):new o(t.minimum,t.maximum):void 0},o.equals=function(t,i){return t===i||r(t)&&r(i)&&e.equals(t.center,i.center)&&e.equals(t.minimum,i.minimum)&&e.equals(t.maximum,i.maximum)};var a=new e;return o.intersectPlane=function(t,r){a=e.subtract(t.maximum,t.minimum,a);var i=e.multiplyByScalar(a,.5,a),o=r.normal,s=i.x*Math.abs(o.x)+i.y*Math.abs(o.y)+i.z*Math.abs(o.z),l=e.dot(t.center,o)+r.distance;return l-s>0?n.INSIDE:0>l+s?n.OUTSIDE:n.INTERSECTING},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.intersectPlane=function(e){return o.intersectPlane(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o}),r("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),r("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n,o){"use strict";function a(e,r,i,n,o,a,s,l,u){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(l,0),this[6]=t(i,0),this[7]=t(a,0),this[8]=t(u,0)}function s(e){for(var t=0,r=0;9>r;++r){var i=e[r];t+=i*i}return Math.sqrt(t)}function l(e){for(var t=0,r=0;3>r;++r){var i=e[a.getElementIndex(p[r],d[r])];t+=2*i*i}return Math.sqrt(t)}function u(e,t){for(var r=o.EPSILON15,i=0,n=1,s=0;3>s;++s){var l=Math.abs(e[a.getElementIndex(p[s],d[s])]);l>i&&(n=s,i=l)}var u=1,c=0,h=d[n],m=p[n];if(Math.abs(e[a.getElementIndex(m,h)])>r){var f,v=e[a.getElementIndex(m,m)],_=e[a.getElementIndex(h,h)],g=e[a.getElementIndex(m,h)],y=(v-_)/2/g;f=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),u=1/Math.sqrt(1+f*f),c=f*u}return t=a.clone(a.IDENTITY,t),t[a.getElementIndex(h,h)]=t[a.getElementIndex(m,m)]=u,t[a.getElementIndex(m,h)]=c,t[a.getElementIndex(h,m)]=-c,t}a.packedLength=9,a.pack=function(e,r,i){i=t(i,0),r[i++]=e[0],r[i++]=e[1],r[i++]=e[2],r[i++]=e[3],r[i++]=e[4],r[i++]=e[5],r[i++]=e[6],r[i++]=e[7],r[i++]=e[8]},a.unpack=function(e,i,n){return i=t(i,0),r(n)||(n=new a),n[0]=e[i++],n[1]=e[i++],n[2]=e[i++],n[3]=e[i++],n[4]=e[i++],n[5]=e[i++],n[6]=e[i++],n[7]=e[i++],n[8]=e[i++],n},a.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new a(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},a.fromArray=function(e,i,n){return i=t(i,0),r(n)||(n=new a),n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],n[4]=e[i+4],n[5]=e[i+5],n[6]=e[i+6],n[7]=e[i+7],n[8]=e[i+8],n},a.fromColumnMajorArray=function(e,t){return a.clone(e,t)},a.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new a(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},a.fromQuaternion=function(e,t){var i=e.x*e.x,n=e.x*e.y,o=e.x*e.z,s=e.x*e.w,l=e.y*e.y,u=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,p=e.w*e.w,m=i-l-h+p,f=2*(n-d),v=2*(o+c),_=2*(n+d),g=-i+l-h+p,y=2*(u-s),C=2*(o-c),E=2*(u+s),S=-i-l+h+p;return r(t)?(t[0]=m,t[1]=_,t[2]=C,t[3]=f,t[4]=g,t[5]=E,t[6]=v,t[7]=y,t[8]=S,t):new a(m,f,v,_,g,y,C,E,S)},a.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new a(e.x,0,0,0,e.y,0,0,0,e.z)},a.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new a(e,0,0,0,e,0,0,0,e)},a.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new a(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},a.fromRotationX=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=n,t[6]=0,t[7]=-n,t[8]=i,t):new a(1,0,0,0,i,-n,0,n,i)},a.fromRotationY=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=0,t[2]=-n,t[3]=0,t[4]=1,t[5]=0,t[6]=n,t[7]=0,t[8]=i,t):new a(i,0,n,0,1,0,-n,0,i)},a.fromRotationZ=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=n,t[2]=0,t[3]=-n,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new a(i,-n,0,n,i,0,0,0,1)},a.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},a.getElementIndex=function(e,t){return 3*e+t},a.getColumn=function(e,t,r){var i=3*t,n=e[i],o=e[i+1],a=e[i+2];return r.x=n,r.y=o,r.z=a,r},a.setColumn=function(e,t,r,i){i=a.clone(e,i);var n=3*t;return i[n]=r.x,i[n+1]=r.y,i[n+2]=r.z,i},a.getRow=function(e,t,r){var i=e[t],n=e[t+3],o=e[t+6];return r.x=i,r.y=n,r.z=o,r},a.setRow=function(e,t,r,i){return i=a.clone(e,i),i[t]=r.x,i[t+3]=r.y,i[t+6]=r.z,i};var c=new e;a.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],c)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],c)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],c)),r};var h=new e;a.getMaximumScale=function(t){return a.getScale(t,h),e.maximumComponent(h)},a.multiply=function(e,t,r){var i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],n=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],o=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],u=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],c=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=i,r[1]=n,r[2]=o,r[3]=a,r[4]=s,r[5]=l,r[6]=u,r[7]=c,r[8]=h,r},a.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},a.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},a.multiplyByVector=function(e,t,r){var i=t.x,n=t.y,o=t.z,a=e[0]*i+e[3]*n+e[6]*o,s=e[1]*i+e[4]*n+e[7]*o,l=e[2]*i+e[5]*n+e[8]*o;return r.x=a,r.y=s,r.z=l,r},a.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},a.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},a.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},a.transpose=function(e,t){var r=e[0],i=e[3],n=e[6],o=e[1],a=e[4],s=e[7],l=e[2],u=e[5],c=e[8];return t[0]=r,t[1]=i,t[2]=n,t[3]=o,t[4]=a,t[5]=s,t[6]=l,t[7]=u,t[8]=c,t};var d=[1,0,0],p=[2,2,1],m=new a,f=new a;return a.computeEigenDecomposition=function(e,t){var i=o.EPSILON20,n=10,c=0,h=0;r(t)||(t={});for(var d=t.unitary=a.clone(a.IDENTITY,t.unitary),p=t.diagonal=a.clone(e,t.diagonal),v=i*s(p);n>h&&l(p)>v;)u(p,m),a.transpose(m,f),a.multiply(p,m,p),a.multiply(f,p,p),a.multiply(d,m,d),++c>2&&(++h,c=0);return t},a.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},a.determinant=function(e){var t=e[0],r=e[3],i=e[6],n=e[1],o=e[4],a=e[7],s=e[2],l=e[5],u=e[8];return t*(o*u-l*a)+n*(l*i-r*u)+s*(r*a-o*i)},a.inverse=function(e,t){var r=e[0],n=e[1],s=e[2],l=e[3],u=e[4],c=e[5],h=e[6],d=e[7],p=e[8],m=a.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new i("matrix is not invertible");t[0]=u*p-d*c,t[1]=d*s-n*p,t[2]=n*c-u*s,t[3]=h*c-l*p,t[4]=r*p-h*s,t[5]=l*s-r*c,t[6]=l*d-h*u,t[7]=h*n-r*d,t[8]=r*u-l*n;var f=1/m;return a.multiplyByScalar(t,f,t)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},a.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},a.IDENTITY=n(new a(1,0,0,0,1,0,0,0,1)),a.ZERO=n(new a(0,0,0,0,0,0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN0ROW2=2,a.COLUMN1ROW0=3,a.COLUMN1ROW1=4,a.COLUMN1ROW2=5,a.COLUMN2ROW0=6,a.COLUMN2ROW1=7,a.COLUMN2ROW2=8,a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},a}),r("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";function o(t,r,i,n){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0),this.w=e(n,0)}o.fromElements=function(e,r,i,n,a){return t(a)?(a.x=e,a.y=r,a.z=i,a.w=n,a):new o(e,r,i,n)},o.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(t,r,i){i=e(i,0),r[i++]=t.x,r[i++]=t.y,r[i++]=t.z,r[i]=t.w},o.unpack=function(r,i,n){return i=e(i,0),t(n)||(n=new o),n.x=r[i++],n.y=r[i++],n.z=r[i++],n.w=r[i],n},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,r,i){return o.multiplyByScalar(t,r,s),i=o.multiplyByScalar(e,1-r,i),o.add(s,i,i)};var l=new o;return o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,l);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):r.y<=r.z?r.y<=r.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)&&n.equalsEpsilon(e.z,r.z,i,o)&&n.equalsEpsilon(e.w,r.w,i,o)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),r("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),r("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e,t,i,n,o,a,s,l,u,c,h,d,p,m,f,v){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(u,0),this[3]=r(p,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(m,0),this[8]=r(i,0),this[9]=r(s,0),this[10]=r(h,0),this[11]=r(f,0),this[12]=r(n,0),this[13]=r(l,0),this[14]=r(d,0),this[15]=r(v,0)}u.packedLength=16,u.pack=function(e,t,i){i=r(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15]},u.unpack=function(e,t,n){return t=r(t,0),i(n)||(n=new u),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n},u.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new u(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},u.fromArray=u.unpack,u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},u.fromRotationTranslation=function(t,n,o){return n=r(n,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=n.x,o[13]=n.y,o[14]=n.z,o[15]=1,o):new u(t[0],t[3],t[6],n.x,t[1],t[4],t[7],n.y,t[2],t[5],t[8],n.z,0,0,0,1)},u.fromTranslationQuaternionRotationScale=function(e,t,r,n){i(n)||(n=new u);var o=r.x,a=r.y,s=r.z,l=t.x*t.x,c=t.x*t.y,h=t.x*t.z,d=t.x*t.w,p=t.y*t.y,m=t.y*t.z,f=t.y*t.w,v=t.z*t.z,_=t.z*t.w,g=t.w*t.w,y=l-p-v+g,C=2*(c-_),E=2*(h+f),S=2*(c+_),w=-l+p-v+g,T=2*(m-d),x=2*(h-f),b=2*(m+d),P=-l-p+v+g;return n[0]=y*o,n[1]=S*o,n[2]=x*o,n[3]=0,n[4]=C*a,n[5]=w*a,n[6]=b*a,n[7]=0,n[8]=E*s,n[9]=T*s,n[10]=P*s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},u.fromTranslationRotationScale=function(e,t){return u.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},u.fromTranslation=function(e,t){return u.fromRotationTranslation(s.IDENTITY,e,t)},u.fromScale=function(e,t){return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},u.fromUniformScale=function(e,t){return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,h=new e,d=new e;u.fromCamera=function(t,r){var n=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,n,c),c),e.normalize(e.cross(c,a,h),h),e.normalize(e.cross(h,c,d),d);var s=h.x,l=h.y,p=h.z,m=c.x,f=c.y,v=c.z,_=d.x,g=d.y,y=d.z,C=n.x,E=n.y,S=n.z,w=s*-C+l*-E+p*-S,T=_*-C+g*-E+y*-S,x=m*C+f*E+v*S;return i(r)?(r[0]=s,r[1]=_,r[2]=-m,r[3]=0,r[4]=l,r[5]=g,r[6]=-f,r[7]=0,r[8]=p,r[9]=y,r[10]=-v,r[11]=0,r[12]=w,r[13]=T,r[14]=x,r[15]=1,r):new u(s,l,p,w,_,g,y,T,-m,-f,-v,x,0,0,0,1)},u.computePerspectiveFieldOfView=function(e,t,r,i,n){var o=Math.tan(.5*e),a=1/o,s=a/t,l=(i+r)/(r-i),u=2*i*r/(r-i);return n[0]=s,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=a,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=l,n[11]=-1,n[12]=0,n[13]=0,n[14]=u,n[15]=0,n},u.computeOrthographicOffCenter=function(e,t,r,i,n,o,a){var s=1/(t-e),l=1/(i-r),u=1/(o-n),c=-(t+e)*s,h=-(i+r)*l,d=-(o+n)*u;return s*=2,l*=2,u*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=u,a[11]=0,a[12]=c,a[13]=h,a[14]=d,a[15]=1,a},u.computePerspectiveOffCenter=function(e,t,r,i,n,o,a){var s=2*n/(t-e),l=2*n/(i-r),u=(t+e)/(t-e),c=(i+r)/(i-r),h=-(o+n)/(o-n),d=-1,p=-2*o*n/(o-n);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=u,a[9]=c,a[10]=h,a[11]=d,a[12]=0,a[13]=0,a[14]=p,a[15]=0,a},u.computeInfinitePerspectiveOffCenter=function(e,t,r,i,n,o){var a=2*n/(t-e),s=2*n/(i-r),l=(t+e)/(t-e),u=(i+r)/(i-r),c=-1,h=-1,d=-2*n;return o[0]=a,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=l,o[9]=u,o[10]=c,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},u.computeViewportTransformation=function(e,t,i,n){e=r(e,r.EMPTY_OBJECT);var o=r(e.x,0),a=r(e.y,0),s=r(e.width,0),l=r(e.height,0);t=r(t,0),i=r(i,1);var u=.5*s,c=.5*l,h=.5*(i-t),d=u,p=c,m=h,f=o+u,v=a+c,_=t+h,g=1;return n[0]=d,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=p,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=m,n[11]=0,n[12]=f,n[13]=v,n[14]=_,n[15]=g,n},u.toArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},u.getElementIndex=function(e,t){return 4*e+t},u.getColumn=function(e,t,r){var i=4*t,n=e[i],o=e[i+1],a=e[i+2],s=e[i+3];return r.x=n,r.y=o,r.z=a,r.w=s,r},u.setColumn=function(e,t,r,i){i=u.clone(e,i);var n=4*t;return i[n]=r.x,i[n+1]=r.y,i[n+2]=r.z,i[n+3]=r.w,i},u.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},u.getRow=function(e,t,r){var i=e[t],n=e[t+4],o=e[t+8],a=e[t+12];return r.x=i,r.y=n,r.z=o,r.w=a,r},u.setRow=function(e,t,r,i){return i=u.clone(e,i),i[t]=r.x,i[t+4]=r.y,i[t+8]=r.z,i[t+12]=r.w,i};var p=new e;u.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],p)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],p)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],p)),r};var m=new e;u.getMaximumScale=function(t){return u.getScale(t,m),e.maximumComponent(m)},u.multiply=function(e,t,r){var i=e[0],n=e[1],o=e[2],a=e[3],s=e[4],l=e[5],u=e[6],c=e[7],h=e[8],d=e[9],p=e[10],m=e[11],f=e[12],v=e[13],_=e[14],g=e[15],y=t[0],C=t[1],E=t[2],S=t[3],w=t[4],T=t[5],x=t[6],b=t[7],P=t[8],A=t[9],I=t[10],M=t[11],D=t[12],R=t[13],O=t[14],N=t[15],L=i*y+s*C+h*E+f*S,F=n*y+l*C+d*E+v*S,B=o*y+u*C+p*E+_*S,V=a*y+c*C+m*E+g*S,z=i*w+s*T+h*x+f*b,k=n*w+l*T+d*x+v*b,U=o*w+u*T+p*x+_*b,G=a*w+c*T+m*x+g*b,W=i*P+s*A+h*I+f*M,H=n*P+l*A+d*I+v*M,q=o*P+u*A+p*I+_*M,j=a*P+c*A+m*I+g*M,Y=i*D+s*R+h*O+f*N,X=n*D+l*R+d*O+v*N,Z=o*D+u*R+p*O+_*N,K=a*D+c*R+m*O+g*N;return r[0]=L,r[1]=F,r[2]=B,r[3]=V,r[4]=z,r[5]=k,r[6]=U,r[7]=G,r[8]=W,r[9]=H,r[10]=q,r[11]=j,r[12]=Y,r[13]=X,r[14]=Z,r[15]=K,r},u.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},u.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},u.multiplyTransformation=function(e,t,r){var i=e[0],n=e[1],o=e[2],a=e[4],s=e[5],l=e[6],u=e[8],c=e[9],h=e[10],d=e[12],p=e[13],m=e[14],f=t[0],v=t[1],_=t[2],g=t[4],y=t[5],C=t[6],E=t[8],S=t[9],w=t[10],T=t[12],x=t[13],b=t[14],P=i*f+a*v+u*_,A=n*f+s*v+c*_,I=o*f+l*v+h*_,M=i*g+a*y+u*C,D=n*g+s*y+c*C,R=o*g+l*y+h*C,O=i*E+a*S+u*w,N=n*E+s*S+c*w,L=o*E+l*S+h*w,F=i*T+a*x+u*b+d,B=n*T+s*x+c*b+p,V=o*T+l*x+h*b+m;return r[0]=P,r[1]=A,r[2]=I,r[3]=0,r[4]=M,r[5]=D,r[6]=R,r[7]=0,r[8]=O,r[9]=N,r[10]=L,r[11]=0,r[12]=F,r[13]=B,r[14]=V,r[15]=1,r},u.multiplyByMatrix3=function(e,t,r){var i=e[0],n=e[1],o=e[2],a=e[4],s=e[5],l=e[6],u=e[8],c=e[9],h=e[10],d=t[0],p=t[1],m=t[2],f=t[3],v=t[4],_=t[5],g=t[6],y=t[7],C=t[8],E=i*d+a*p+u*m,S=n*d+s*p+c*m,w=o*d+l*p+h*m,T=i*f+a*v+u*_,x=n*f+s*v+c*_,b=o*f+l*v+h*_,P=i*g+a*y+u*C,A=n*g+s*y+c*C,I=o*g+l*y+h*C;return r[0]=E,r[1]=S,r[2]=w,r[3]=0,r[4]=T,r[5]=x,r[6]=b,r[7]=0,r[8]=P,r[9]=A,r[10]=I,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},u.multiplyByTranslation=function(e,t,r){var i=t.x,n=t.y,o=t.z,a=i*e[0]+n*e[4]+o*e[8]+e[12],s=i*e[1]+n*e[5]+o*e[9]+e[13],l=i*e[2]+n*e[6]+o*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=a,r[13]=s,r[14]=l,r[15]=e[15],r};var f=new e;u.multiplyByUniformScale=function(e,t,r){return f.x=t,f.y=t,f.z=t,u.multiplyByScale(e,f,r)},u.multiplyByScale=function(e,t,r){var i=t.x,n=t.y,o=t.z;return 1===i&&1===n&&1===o?u.clone(e,r):(r[0]=i*e[0],r[1]=i*e[1],r[2]=i*e[2],r[3]=0,r[4]=n*e[4],r[5]=n*e[5],r[6]=n*e[6],r[7]=0,r[8]=o*e[8],r[9]=o*e[9],r[10]=o*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},u.multiplyByVector=function(e,t,r){var i=t.x,n=t.y,o=t.z,a=t.w,s=e[0]*i+e[4]*n+e[8]*o+e[12]*a,l=e[1]*i+e[5]*n+e[9]*o+e[13]*a,u=e[2]*i+e[6]*n+e[10]*o+e[14]*a,c=e[3]*i+e[7]*n+e[11]*o+e[15]*a;return r.x=s,r.y=l,r.z=u,r.w=c,r},u.multiplyByPointAsVector=function(e,t,r){var i=t.x,n=t.y,o=t.z,a=e[0]*i+e[4]*n+e[8]*o,s=e[1]*i+e[5]*n+e[9]*o,l=e[2]*i+e[6]*n+e[10]*o;return r.x=a,r.y=s,r.z=l,r},u.multiplyByPoint=function(e,t,r){var i=t.x,n=t.y,o=t.z,a=e[0]*i+e[4]*n+e[8]*o+e[12],s=e[1]*i+e[5]*n+e[9]*o+e[13],l=e[2]*i+e[6]*n+e[10]*o+e[14];return r.x=a,r.y=s,r.z=l,r},u.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},u.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},u.transpose=function(e,t){var r=e[1],i=e[2],n=e[3],o=e[6],a=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=n,t[13]=a,t[14]=s,t[15]=e[15],t},u.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},u.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},u.equalsEpsilon=function(e,t,r){return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},u.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},u.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var v=new s,_=new s,g=new t,y=new t(0,0,0,1);return u.inverse=function(e,r){if(s.equalsEpsilon(u.getRotation(e,v),_,a.EPSILON7)&&t.equals(u.getRow(e,3,g),y))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var i=e[0],n=e[4],o=e[8],c=e[12],h=e[1],d=e[5],p=e[9],m=e[13],f=e[2],C=e[6],E=e[10],S=e[14],w=e[3],T=e[7],x=e[11],b=e[15],P=E*b,A=S*x,I=C*b,M=S*T,D=C*x,R=E*T,O=f*b,N=S*w,L=f*x,F=E*w,B=f*T,V=C*w,z=P*d+M*p+D*m-(A*d+I*p+R*m),k=A*h+O*p+F*m-(P*h+N*p+L*m),U=I*h+N*d+B*m-(M*h+O*d+V*m),G=R*h+L*d+V*p-(D*h+F*d+B*p),W=A*n+I*o+R*c-(P*n+M*o+D*c),H=P*i+N*o+L*c-(A*i+O*o+F*c),q=M*i+O*n+V*c-(I*i+N*n+B*c),j=D*i+F*n+B*o-(R*i+L*n+V*o);P=o*m,A=c*p,I=n*m,M=c*d,D=n*p,R=o*d,O=i*m,N=c*h,L=i*p,F=o*h,B=i*d,V=n*h;var Y=P*T+M*x+D*b-(A*T+I*x+R*b),X=A*w+O*x+F*b-(P*w+N*x+L*b),Z=I*w+N*T+B*b-(M*w+O*T+V*b),K=R*w+L*T+V*x-(D*w+F*T+B*x),Q=I*E+R*S+A*C-(D*S+P*C+M*E),J=L*S+P*f+N*E-(O*E+F*S+A*f),$=O*C+V*S+M*f-(B*S+I*f+N*C),ee=B*E+D*f+F*C-(L*C+V*E+R*f),te=i*z+n*k+o*U+c*G;if(Math.abs(te)<a.EPSILON20)throw new l("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=k*te,r[2]=U*te,r[3]=G*te,r[4]=W*te,r[5]=H*te,r[6]=q*te,r[7]=j*te,r[8]=Y*te,r[9]=X*te,r[10]=Z*te,r[11]=K*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},u.inverseTransformation=function(e,t){var r=e[0],i=e[1],n=e[2],o=e[4],a=e[5],s=e[6],l=e[8],u=e[9],c=e[10],h=e[12],d=e[13],p=e[14],m=-r*h-i*d-n*p,f=-o*h-a*d-s*p,v=-l*h-u*d-c*p;return t[0]=r,t[1]=o,t[2]=l,t[3]=0,t[4]=i,t[5]=a,t[6]=u,t[7]=0,t[8]=n,t[9]=s,t[10]=c,t[11]=0,t[12]=m,t[13]=f,t[14]=v,t[15]=1,t},u.IDENTITY=o(new u(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),u.ZERO=o(new u(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN0ROW3=3,u.COLUMN1ROW0=4,u.COLUMN1ROW1=5,u.COLUMN1ROW2=6,u.COLUMN1ROW3=7,u.COLUMN2ROW0=8,u.COLUMN2ROW1=9,u.COLUMN2ROW2=10,u.COLUMN2ROW3=11,u.COLUMN3ROW0=12,u.COLUMN3ROW1=13,u.COLUMN3ROW2=14,u.COLUMN3ROW3=15,u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},u}),r("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";function n(t,r){this.normal=e.clone(t),this.distance=r}n.fromPointNormal=function(r,i,o){var a=-e.dot(i,r);return t(o)?(e.clone(i,o.normal),o.distance=a,o):new n(i,a)};var o=new e;return n.fromCartesian4=function(r,i){var a=e.fromCartesian4(r,o),s=r.w;return t(i)?(e.clone(a,i.normal),i.distance=s,i):new n(a,s)},n.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},n.ORIGIN_XY_PLANE=i(new n(e.UNIT_Z,0)),n.ORIGIN_YZ_PLANE=i(new n(e.UNIT_X,0)),n.ORIGIN_ZX_PLANE=i(new n(e.UNIT_Y,0)),n}),r("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Plane","./Rectangle"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(t,i){this.center=e.clone(r(t,e.ZERO)),this.radius=r(i,0)}var m=new e,f=new e,v=new e,_=new e,g=new e,y=new e,C=new e,E=new e,S=new e,w=new e,T=new e,x=new e;p.fromPoints=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],C),o=e.clone(n,m),a=e.clone(n,f),s=e.clone(n,v),l=e.clone(n,_),u=e.clone(n,g),c=e.clone(n,y),h=t.length,d=1;h>d;d++){e.clone(t[d],n);var b=n.x,P=n.y,A=n.z;b<o.x&&e.clone(n,o),b>l.x&&e.clone(n,l),P<a.y&&e.clone(n,a),P>u.y&&e.clone(n,u),A<s.z&&e.clone(n,s),A>c.z&&e.clone(n,c)}var I=e.magnitudeSquared(e.subtract(l,o,E)),M=e.magnitudeSquared(e.subtract(u,a,E)),D=e.magnitudeSquared(e.subtract(c,s,E)),R=o,O=l,N=I;M>N&&(N=M,R=a,O=u),D>N&&(N=D,R=s,O=c);var L=S;L.x=.5*(R.x+O.x),L.y=.5*(R.y+O.y),L.z=.5*(R.z+O.z);var F=e.magnitudeSquared(e.subtract(O,L,E)),B=Math.sqrt(F),V=w;V.x=o.x,V.y=a.y,V.z=s.z;var z=T;z.x=l.x,z.y=u.y,z.z=c.z;var k=e.multiplyByScalar(e.add(V,z,E),.5,x),U=0;for(d=0;h>d;d++){e.clone(t[d],n);var G=e.magnitude(e.subtract(n,k,E));G>U&&(U=G);var W=e.magnitudeSquared(e.subtract(n,L,E));if(W>F){var H=Math.sqrt(W);B=.5*(B+H),F=B*B;var q=H-B;L.x=(B*L.x+q*n.x)/H,L.y=(B*L.y+q*n.y)/H,L.z=(B*L.z+q*n.z)/H}}return U>B?(e.clone(L,r.center),r.radius=B):(e.clone(k,r.center),r.radius=U),r};var b=new a,P=new e,A=new e,I=new t,M=new t;p.fromRectangle2D=function(e,t,r){return p.fromRectangleWithHeights2D(e,t,0,0,r)},p.fromRectangleWithHeights2D=function(t,n,o,a,s){if(i(s)||(s=new p),!i(t))return s.center=e.clone(e.ZERO,s.center),
s.radius=0,s;n=r(n,b),d.southwest(t,I),I.height=o,d.northeast(t,M),M.height=a;var l=n.project(I,P),u=n.project(M,A),c=u.x-l.x,h=u.y-l.y,m=u.z-l.z;s.radius=.5*Math.sqrt(c*c+h*h+m*m);var f=s.center;return f.x=l.x+.5*c,f.y=l.y+.5*h,f.z=l.z+.5*m,s};var D=[];p.fromRectangle3D=function(e,t,n,a){t=r(t,o.WGS84),n=r(n,0);var s;return i(e)&&(s=d.subsample(e,t,n,D)),p.fromPoints(s,a)},p.fromVertices=function(t,n,o,a){if(i(a)||(a=new p),!i(t)||0===t.length)return a.center=e.clone(e.ZERO,a.center),a.radius=0,a;n=r(n,e.ZERO),o=r(o,3);var s=C;s.x=t[0]+n.x,s.y=t[1]+n.y,s.z=t[2]+n.z;for(var l=e.clone(s,m),u=e.clone(s,f),c=e.clone(s,v),h=e.clone(s,_),d=e.clone(s,g),b=e.clone(s,y),P=t.length,A=0;P>A;A+=o){var I=t[A]+n.x,M=t[A+1]+n.y,D=t[A+2]+n.z;s.x=I,s.y=M,s.z=D,I<l.x&&e.clone(s,l),I>h.x&&e.clone(s,h),M<u.y&&e.clone(s,u),M>d.y&&e.clone(s,d),D<c.z&&e.clone(s,c),D>b.z&&e.clone(s,b)}var R=e.magnitudeSquared(e.subtract(h,l,E)),O=e.magnitudeSquared(e.subtract(d,u,E)),N=e.magnitudeSquared(e.subtract(b,c,E)),L=l,F=h,B=R;O>B&&(B=O,L=u,F=d),N>B&&(B=N,L=c,F=b);var V=S;V.x=.5*(L.x+F.x),V.y=.5*(L.y+F.y),V.z=.5*(L.z+F.z);var z=e.magnitudeSquared(e.subtract(F,V,E)),k=Math.sqrt(z),U=w;U.x=l.x,U.y=u.y,U.z=c.z;var G=T;G.x=h.x,G.y=d.y,G.z=b.z;var W=e.multiplyByScalar(e.add(U,G,E),.5,x),H=0;for(A=0;P>A;A+=o){s.x=t[A]+n.x,s.y=t[A+1]+n.y,s.z=t[A+2]+n.z;var q=e.magnitude(e.subtract(s,W,E));q>H&&(H=q);var j=e.magnitudeSquared(e.subtract(s,V,E));if(j>z){var Y=Math.sqrt(j);k=.5*(k+Y),z=k*k;var X=Y-k;V.x=(k*V.x+X*s.x)/Y,V.y=(k*V.y+X*s.y)/Y,V.z=(k*V.z+X*s.z)/Y}}return H>k?(e.clone(V,a.center),a.radius=k):(e.clone(W,a.center),a.radius=H),a},p.fromCornerPoints=function(t,r,n){i(n)||(n=new p);var o=n.center;return e.add(t,r,o),e.multiplyByScalar(o,.5,o),n.radius=e.distance(o,r),n},p.fromEllipsoid=function(t,r){return i(r)||(r=new p),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var R=new e;p.fromBoundingSpheres=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return p.clone(t[0],r);if(2===n)return p.union(t[0],t[1],r);for(var o=[],a=0;n>a;a++)o.push(t[a].center);r=p.fromPoints(o,r);var s=r.center,l=r.radius;for(a=0;n>a;a++){var u=t[a];l=Math.max(l,e.distance(s,u.center,R)+u.radius)}return r.radius=l,r};var O=new e,N=new e,L=new e;p.fromOrientedBoundingBox=function(t,r){i(r)||(r=new p);var n=t.halfAxes,o=u.getColumn(n,0,O),a=u.getColumn(n,1,N),s=u.getColumn(n,2,L),l=e.magnitude(o),c=e.magnitude(a),h=e.magnitude(s);return r.center=e.clone(t.center,r.center),r.radius=Math.max(l,c,h),r},p.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new p(t.center,t.radius):void 0},p.packedLength=4,p.pack=function(e,t,i){i=r(i,0);var n=e.center;t[i++]=n.x,t[i++]=n.y,t[i++]=n.z,t[i]=e.radius},p.unpack=function(e,t,n){t=r(t,0),i(n)||(n=new p);var o=n.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],n.radius=e[t],n};var F=new e,B=new e;p.union=function(t,r,n){i(n)||(n=new p);var o=t.center,a=t.radius,s=r.center,l=r.radius,u=e.subtract(s,o,F),c=e.magnitude(u);if(a>=c+l)return t.clone(n),n;if(l>=c+a)return r.clone(n),n;var h=.5*(a+c+l),d=e.multiplyByScalar(u,(-a+h)/c,B);return e.add(d,o,d),e.clone(d,n.center),n.radius=h,n};var V=new e;p.expand=function(t,r,i){i=p.clone(t,i);var n=e.magnitude(e.subtract(r,i.center,V));return n>i.radius&&(i.radius=n),i},p.intersectPlane=function(t,r){var i=t.center,n=t.radius,o=r.normal,a=e.dot(o,i)+r.distance;return-n>a?s.OUTSIDE:n>a?s.INTERSECTING:s.INSIDE},p.transform=function(e,t,r){return i(r)||(r=new p),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var z=new e;p.distanceSquaredTo=function(t,r){var i=e.subtract(t.center,r,z);return e.magnitudeSquared(i)-t.radius*t.radius},p.transformWithoutScale=function(e,t,r){return i(r)||(r=new p),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var k=new e;p.computePlaneDistances=function(t,r,n,o){i(o)||(o=new l);var a=e.subtract(t.center,r,k),s=e.dot(n,a);return o.start=s-t.radius,o.stop=s+t.radius,o};for(var U=new e,G=new e,W=new e,H=new e,q=new e,j=new t,Y=new Array(8),X=0;8>X;++X)Y[X]=new e;var Z=new a;return p.projectTo2D=function(t,i,n){i=r(i,Z);var o=i.ellipsoid,a=t.center,s=t.radius,l=o.geodeticSurfaceNormal(a,U),u=e.cross(e.UNIT_Z,l,G);e.normalize(u,u);var c=e.cross(l,u,W);e.normalize(c,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(u,s,u);var h=e.negate(c,q),d=e.negate(u,H),m=Y,f=m[0];e.add(l,c,f),e.add(f,u,f),f=m[1],e.add(l,c,f),e.add(f,d,f),f=m[2],e.add(l,h,f),e.add(f,d,f),f=m[3],e.add(l,h,f),e.add(f,u,f),e.negate(l,l),f=m[4],e.add(l,c,f),e.add(f,u,f),f=m[5],e.add(l,c,f),e.add(f,d,f),f=m[6],e.add(l,h,f),e.add(f,d,f),f=m[7],e.add(l,h,f),e.add(f,u,f);for(var v=m.length,_=0;v>_;++_){var g=m[_];e.add(a,g,g);var y=o.cartesianToCartographic(g,j);i.project(y,g)}n=p.fromPoints(m,n),a=n.center;var C=a.x,E=a.y,S=a.z;return a.x=S,a.y=C,a.z=E,n},p.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},p.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,r){return p.computePlaneDistances(this,e,t,r)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.clone=function(e){return p.clone(this,e)},p}),r("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,r,i,n,o,a){"use strict";function s(e,r){this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,i(r)&&(this.cameraPosition=r)}function l(e,r,i){var n=e.transformPositionToScaledSpace(r,m),o=t.magnitudeSquared(n),a=Math.sqrt(o),s=t.divideByScalar(n,a,f);o=Math.max(1,o),a=Math.max(1,a);var l=t.dot(s,i),u=t.magnitude(t.cross(s,i,s)),c=1/a,h=Math.sqrt(o-1)*c;return 1/(l*c-u*h)}function u(e,r,i){return 0>=r||r===1/0||r!==r?void 0:t.multiplyByScalar(e,r,i)}function c(e,r){return e.transformPositionToScaledSpace(r,v),t.normalize(v,v)}n(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var r=this._ellipsoid,i=r.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=t.magnitudeSquared(i)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=i,this._distanceToLimbInScaledSpaceSquared=n}}});var h=new t;s.prototype.isPointVisible=function(e){var t=this._ellipsoid,r=t.transformPositionToScaledSpace(e,h);return this.isScaledSpacePointVisible(r)},s.prototype.isScaledSpacePointVisible=function(e){var r=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared,n=t.subtract(e,r,h),o=-t.dot(n,r),a=0>i?o>0:o>i&&o*o/t.magnitudeSquared(n)>i;return!a},s.prototype.computeHorizonCullingPoint=function(e,r,n){i(n)||(n=new t);for(var o=this._ellipsoid,a=c(o,e),s=0,h=0,d=r.length;d>h;++h){var p=r[h],m=l(o,p,a);s=Math.max(s,m)}return u(a,s,n)};var d=new t;s.prototype.computeHorizonCullingPointFromVertices=function(e,n,o,a,s){i(s)||(s=new t),a=r(a,t.ZERO);for(var h=this._ellipsoid,p=c(h,e),m=0,f=0,v=n.length;v>f;f+=o){d.x=n[f]+a.x,d.y=n[f+1]+a.y,d.z=n[f+2]+a.z;var _=l(h,d,p);m=Math.max(m,_)}return u(p,m,s)},s.prototype.computeHorizonCullingPointFromPoints=function(e,r,n){i(n)||(n=new t);for(var o=this._ellipsoid,a=c(o,e),s=0,h=0,d=r.length;d>h;++h){var p=l(o,r[h],a);s=Math.max(s,p)}return u(a,s,n)};var p=[];s.prototype.computeHorizonCullingPointFromRectangle=function(r,i,n){var o=a.subsample(r,i,0,p),s=e.fromPoints(o);return t.magnitude(s.center)<.1*i.minimumRadius?void 0:this.computeHorizonCullingPoint(s.center,o,n)};var m=new t,f=new t,v=new t;return s}),r("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,i){var n=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<i?0:n}var i={};return i.computeDiscriminant=function(e,t,r){var i=t*t-4*e*r;return i},i.computeRealRoots=function(e,i,n){var o;if(0===e)return 0===i?[]:[-n/i];if(0===i){if(0===n)return[0,0];var a=Math.abs(n),s=Math.abs(e);if(s>a&&a/s<t.EPSILON14)return[0,0];if(a>s&&s/a<t.EPSILON14)return[];if(o=-n/e,0>o)return[];var l=Math.sqrt(o);return[-l,l]}if(0===n)return o=-i/e,0>o?[o,0]:[0,o];var u=i*i,c=4*e*n,h=r(u,-c,t.EPSILON14);if(0>h)return[];var d=-.5*r(i,t.sign(i)*Math.sqrt(h),t.EPSILON14);return i>0?[d/e,n/d]:[n/d,d/e]},i}),r("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,i){var n,o,a=e,s=t/3,l=r/3,u=i,c=a*l,h=s*u,d=s*s,p=l*l,m=a*l-d,f=a*u-s*l,v=s*u-p,_=4*m*v-f*f;if(0>_){var g,y,C;d*h>=c*p?(g=a,y=m,C=-2*s*m+a*f):(g=u,y=v,C=-u*f+2*l*v);var E=0>C?-1:1,S=-E*Math.abs(g)*Math.sqrt(-_);o=-C+S;var w=o/2,T=0>w?-Math.pow(-w,1/3):Math.pow(w,1/3),x=o===S?-T:-y/T;return n=0>=y?T+x:-C/(T*T+x*x+y),d*h>=c*p?[(n-s)/a]:[-u/(n+l)]}var b=m,P=-2*s*m+a*f,A=v,I=-u*f+2*l*v,M=Math.sqrt(_),D=Math.sqrt(3)/2,R=Math.abs(Math.atan2(a*M,-P)/3);n=2*Math.sqrt(-b);var O=Math.cos(R);o=n*O;var N=n*(-O/2-D*Math.sin(R)),L=o+N>2*s?o-s:N-s,F=a,B=L/F;R=Math.abs(Math.atan2(u*M,-I)/3),n=2*Math.sqrt(-A),O=Math.cos(R),o=n*O,N=n*(-O/2-D*Math.sin(R));var V=-u,z=2*l>o+N?o+l:N+l,k=V/z,U=F*z,G=-L*z-F*V,W=L*V,H=(l*G-s*W)/(-s*G+l*U);return H>=B?k>=B?k>=H?[B,H,k]:[B,k,H]:[k,B,H]:k>=B?[H,B,k]:k>=H?[H,k,B]:[k,H,B]}var i={};return i.computeDiscriminant=function(e,t,r,i){var n=e*e,o=t*t,a=r*r,s=i*i,l=18*e*t*r*i+o*a-27*n*s-4*(e*a*r+o*t*i);return l},i.computeRealRoots=function(e,i,n,o){var a,s;if(0===e)return t.computeRealRoots(i,n,o);if(0===i){if(0===n){if(0===o)return[0,0,0];s=-o/e;var l=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}return 0===o?(a=t.computeRealRoots(e,0,n),0===a.Length?[0]:[a[0],0,a[1]]):r(e,0,n,o)}return 0===n?0===o?(s=-i/e,0>s?[s,0,0]:[0,0,s]):r(e,i,0,o):0===o?(a=t.computeRealRoots(e,i,n),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):r(e,i,n,o)},i}),r("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,i){"use strict";function n(t,n,o,a){var s=t*t,l=n-3*s/8,u=o-n*t/2+s*t/8,c=a-o*t/4+n*s/16-3*s*s/256,h=e.computeRealRoots(1,2*l,l*l-4*c,-u*u);if(h.length>0){var d=-t/4,p=h[h.length-1];if(Math.abs(p)<r.EPSILON14){var m=i.computeRealRoots(1,l,c);if(2===m.length){var f,v=m[0],_=m[1];if(v>=0&&_>=0){var g=Math.sqrt(v),y=Math.sqrt(_);return[d-y,d-g,d+g,d+y]}if(v>=0&&0>_)return f=Math.sqrt(v),[d-f,d+f];if(0>v&&_>=0)return f=Math.sqrt(_),[d-f,d+f]}return[]}if(p>0){var C=Math.sqrt(p),E=(l+p-u/C)/2,S=(l+p+u/C)/2,w=i.computeRealRoots(1,C,E),T=i.computeRealRoots(1,-C,S);return 0!==w.length?(w[0]+=d,w[1]+=d,0!==T.length?(T[0]+=d,T[1]+=d,w[1]<=T[0]?[w[0],w[1],T[0],T[1]]:T[1]<=w[0]?[T[0],T[1],w[0],w[1]]:w[0]>=T[0]&&w[1]<=T[1]?[T[0],w[0],w[1],T[1]]:T[0]>=w[0]&&T[1]<=w[1]?[w[0],T[0],T[1],w[1]]:w[0]>T[0]&&w[0]<T[1]?[T[0],w[0],T[1],w[1]]:[w[0],T[0],w[1],T[1]]):w):0!==T.length?(T[0]+=d,T[1]+=d,T):[]}}return[]}function o(t,n,o,a){var s=o*o,l=n*n,u=t*t,c=-2*n,h=o*t+l-4*a,d=u*a-o*n*t+s,p=e.computeRealRoots(1,c,h,d);if(p.length>0){var m,f,v=p[0],_=n-v,g=_*_,y=t/2,C=_/2,E=g-4*a,S=g+4*Math.abs(a),w=u-4*v,T=u+4*Math.abs(v);if(0>v||w*S>E*T){var x=Math.sqrt(w);m=x/2,f=0===x?0:(t*C-o)/x}else{var b=Math.sqrt(E);m=0===b?0:(t*C-o)/b,f=b/2}var P,A;0===y&&0===m?(P=0,A=0):r.sign(y)===r.sign(m)?(P=y+m,A=v/P):(A=y-m,P=v/A);var I,M;0===C&&0===f?(I=0,M=0):r.sign(C)===r.sign(f)?(I=C+f,M=a/I):(M=C-f,I=a/M);var D=i.computeRealRoots(1,P,I),R=i.computeRealRoots(1,A,M);if(0!==D.length)return 0!==R.length?D[1]<=R[0]?[D[0],D[1],R[0],R[1]]:R[1]<=D[0]?[R[0],R[1],D[0],D[1]]:D[0]>=R[0]&&D[1]<=R[1]?[R[0],D[0],D[1],R[1]]:R[0]>=D[0]&&R[1]<=D[1]?[D[0],R[0],R[1],D[1]]:D[0]>R[0]&&D[0]<R[1]?[R[0],D[0],R[1],D[1]]:[D[0],R[0],D[1],R[1]]:D;if(0!==R.length)return R}return[]}var a={};return a.computeDiscriminant=function(e,t,r,i,n){var o=e*e,a=o*e,s=t*t,l=s*t,u=r*r,c=u*r,h=i*i,d=h*i,p=n*n,m=p*n,f=s*u*h-4*l*d-4*e*c*h+18*e*t*r*d-27*o*h*h+256*a*m+n*(18*l*r*i-4*s*c+16*e*u*u-80*e*t*u*i-6*e*s*h+144*o*r*h)+p*(144*e*s*r-27*s*s-128*o*u-192*o*t*i);return f},a.computeRealRoots=function(t,i,a,s,l){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(i,a,s,l);var u=i/t,c=a/t,h=s/t,d=l/t,p=0>u?1:0;switch(p+=0>c?p+1:p,p+=0>h?p+1:p,p+=0>d?p+1:p){case 0:return n(u,c,h,d);case 1:return o(u,c,h,d);case 2:return o(u,c,h,d);case 3:return n(u,c,h,d);case 4:return n(u,c,h,d);case 5:return o(u,c,h,d);case 6:return n(u,c,h,d);case 7:return n(u,c,h,d);case 8:return o(u,c,h,d);case 9:return n(u,c,h,d);case 10:return n(u,c,h,d);case 11:return o(u,c,h,d);case 12:return n(u,c,h,d);case 13:return n(u,c,h,d);case 14:return n(u,c,h,d);case 15:return n(u,c,h,d);default:return}},a}),r("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i){"use strict";function n(r,i){i=e.clone(t(i,e.ZERO)),e.equals(i,e.ZERO)||e.normalize(i,i),this.origin=e.clone(t(r,e.ZERO)),this.direction=i}return n.getPoint=function(t,i,n){return r(n)||(n=new e),n=e.multiplyByScalar(t.direction,i,n),e.add(t.origin,n,n)},n}),r("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(t,i,n,a,s){s=r(s,!1);var l,u,c,h,d,p=t.origin,m=t.direction,f=e.subtract(n,i,v),E=e.subtract(a,i,_),S=e.cross(m,E,g),w=e.dot(f,S);if(s){if(w<o.EPSILON6)return;if(l=e.subtract(p,i,y),c=e.dot(l,S),0>c||c>w)return;if(u=e.cross(l,f,C),h=e.dot(m,u),0>h||c+h>w)return;d=e.dot(E,u)/w}else{if(Math.abs(w)<o.EPSILON6)return;var T=1/w;if(l=e.subtract(p,i,y),c=e.dot(l,S)*T,0>c||c>1)return;if(u=e.cross(l,f,C),h=e.dot(m,u)*T,0>h||c+h>1)return;d=e.dot(E,u)*T}return d}function h(e,t,r,i){var n=t*t-4*e*r;if(!(0>n)){if(n>0){var o=1/(2*e),a=Math.sqrt(n),s=(-t+a)*o,l=(-t-a)*o;return l>s?(i.root0=s,i.root1=l):(i.root0=l,i.root1=s),i}var u=-t/(2*e);if(0!==u)return i.root0=i.root1=u,i}}function d(t,r,n){i(n)||(n={});var o=t.origin,a=t.direction,s=r.center,l=r.radius*r.radius,u=e.subtract(o,s,g),c=e.dot(a,a),d=2*e.dot(a,u),p=e.magnitudeSquared(u)-l,m=h(c,d,p,S);return i(m)?(n.start=m.root0,n.stop=m.root1,n):void 0}function p(e,t,r){var i=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<r?0:i}function m(t,r,i,n,u){var c,h=n*n,d=u*u,m=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*d,f=u*(n*p(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],o.EPSILON15)+r.y),v=t[a.COLUMN0ROW0]*h+t[a.COLUMN2ROW2]*d+n*r.x+i,_=d*p(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],o.EPSILON15),g=u*(n*p(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),y=[];if(0===g&&0===_){if(c=s.computeRealRoots(m,f,v),0===c.length)return y;var C=c[0],E=Math.sqrt(Math.max(1-C*C,0));if(y.push(new e(n,u*C,u*-E)),y.push(new e(n,u*C,u*E)),2===c.length){var S=c[1],w=Math.sqrt(Math.max(1-S*S,0));y.push(new e(n,u*S,u*-w)),y.push(new e(n,u*S,u*w))}return y}var T=g*g,x=_*_,b=m*m,P=g*_,A=b+x,I=2*(f*m+P),M=2*v*m+f*f-x+T,D=2*(v*f-P),R=v*v-T;if(0===A&&0===I&&0===M&&0===D)return y;c=l.computeRealRoots(A,I,M,D,R);var O=c.length;if(0===O)return y;for(var N=0;O>N;++N){var L,F=c[N],B=F*F,V=Math.max(1-B,0),z=Math.sqrt(V);L=o.sign(m)===o.sign(v)?p(m*B+v,f*F,o.EPSILON12):o.sign(v)===o.sign(f*F)?p(m*B,f*F+v,o.EPSILON12):p(m*B+f*F,v,o.EPSILON12);var k=p(_*F,g,o.EPSILON15),U=L*k;0>U?y.push(new e(n,u*F,u*z)):U>0?y.push(new e(n,u*F,u*-z)):0!==z?(y.push(new e(n,u*F,u*-z)),y.push(new e(n,u*F,u*z)),++N):y.push(new e(n,u*F,u*z))}return y}var f={};f.rayPlane=function(t,r,n){i(n)||(n=new e);var a=t.origin,s=t.direction,l=r.normal,u=e.dot(l,s);if(!(Math.abs(u)<o.EPSILON15)){var c=(-r.distance-e.dot(l,a))/u;if(!(0>c))return n=e.multiplyByScalar(s,c,n),e.add(a,n,n)}};var v=new e,_=new e,g=new e,y=new e,C=new e;f.rayTriangle=function(t,r,n,o,a,s){var l=c(t,r,n,o,a);if(i(l)&&!(0>l))return i(s)||(s=new e),e.multiplyByScalar(t.direction,l,s),e.add(t.origin,s,s)};var E=new u;f.lineSegmentTriangle=function(t,r,n,o,a,s,l){var u=E;e.clone(t,u.origin),e.subtract(r,t,u.direction),e.normalize(u.direction,u.direction);var h=c(u,n,o,a,s);return!i(h)||0>h||h>e.distance(t,r)?void 0:(i(l)||(l=new e),e.multiplyByScalar(u.direction,h,l),e.add(u.origin,l,l))};var S={root0:0,root1:0};f.raySphere=function(e,t,r){return r=d(e,t,r),!i(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var w=new u;f.lineSegmentSphere=function(t,r,n,o){var a=w,s=e.subtract(r,t,a.direction),l=e.magnitude(s);return e.normalize(s,s),o=d(a,n,o),!i(o)||o.stop<0||o.start>l?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,l),o)};var T=new e,x=new e;f.rayEllipsoid=function(t,r){var i,n,o,a,s,l=r.oneOverRadii,u=e.multiplyComponents(l,t.origin,T),c=e.multiplyComponents(l,t.direction,x),h=e.magnitudeSquared(u),d=e.dot(u,c);if(h>1){if(d>=0)return;var p=d*d;if(i=h-1,n=e.magnitudeSquared(c),o=n*i,o>p)return;if(p>o){a=d*d-o,s=-d+Math.sqrt(a);var m=s/n,f=i/s;return f>m?{start:m,stop:f}:{start:f,stop:m}}var v=Math.sqrt(i/n);return{start:v,stop:v}}return 1>h?(i=h-1,n=e.magnitudeSquared(c),o=n*i,a=d*d-o,s=-d+Math.sqrt(a),{start:0,stop:s/n}):0>d?(n=e.magnitudeSquared(c),{start:0,stop:-d/n}):void 0};var b=new e,P=new e,A=new e,I=new e,M=new e,D=new a,R=new a,O=new a,N=new a,L=new a,F=new a,B=new a,V=new e,z=new e,k=new t;f.grazingAltitudeLocation=function(t,r){var n=t.origin,s=t.direction,l=r.geodeticSurfaceNormal(n,b);if(e.dot(s,l)>=0)return n;var u=i(this.rayEllipsoid(t,r)),c=r.transformPositionToScaledSpace(s,b),h=e.normalize(c,c),d=e.mostOrthogonalAxis(c,I),p=e.normalize(e.cross(d,h,P),P),f=e.normalize(e.cross(h,p,A),A),v=D;v[0]=h.x,v[1]=h.y,v[2]=h.z,v[3]=p.x,v[4]=p.y,v[5]=p.z,v[6]=f.x,v[7]=f.y,v[8]=f.z;var _=a.transpose(v,R),g=a.fromScale(r.radii,O),y=a.fromScale(r.oneOverRadii,N),C=L;C[0]=0,C[1]=-s.z,C[2]=s.y,C[3]=s.z,C[4]=0,C[5]=-s.x,C[6]=-s.y,C[7]=s.x,C[8]=0;var E,S,w=a.multiply(a.multiply(_,y,F),C,F),T=a.multiply(a.multiply(w,g,B),v,B),x=a.multiplyByVector(w,n,M),U=m(T,e.negate(x,b),0,0,1),G=U.length;if(G>0){for(var W=e.clone(e.ZERO,z),H=Number.NEGATIVE_INFINITY,q=0;G>q;++q){E=a.multiplyByVector(g,a.multiplyByVector(v,U[q],V),V);var j=e.normalize(e.subtract(E,n,I),I),Y=e.dot(j,s);Y>H&&(H=Y,W=e.clone(E,W))}var X=r.cartesianToCartographic(W,k);return H=o.clamp(H,0,1),S=e.magnitude(e.subtract(W,n,I))*Math.sqrt(1-H*H),S=u?-S:S,X.height=S,r.cartographicToCartesian(X,new e)}};var U=new e;return f.lineSegmentPlane=function(t,r,n,a){i(a)||(a=new e);var s=e.subtract(r,t,U),l=n.normal,u=e.dot(l,s);if(!(Math.abs(u)<o.EPSILON6)){var c=e.dot(l,t),h=-(n.distance+c)/u;if(!(0>h||h>1))return e.multiplyByScalar(s,h,a),e.add(t,a,a),a}},f.trianglePlaneIntersection=function(t,r,i,n){var o=n.normal,a=n.distance,s=e.dot(o,t)+a<0,l=e.dot(o,r)+a<0,u=e.dot(o,i)+a<0,c=0;c+=s?1:0,c+=l?1:0,c+=u?1:0;var h,d;if((1===c||2===c)&&(h=new e,d=new e),1===c){if(s)return f.lineSegmentPlane(t,r,n,h),f.lineSegmentPlane(t,i,n,d),{positions:[t,r,i,h,d],indices:[0,3,4,1,2,4,1,4,3]};if(l)return f.lineSegmentPlane(r,i,n,h),f.lineSegmentPlane(r,t,n,d),{positions:[t,r,i,h,d],indices:[1,3,4,2,0,4,2,4,3]};if(u)return f.lineSegmentPlane(i,t,n,h),f.lineSegmentPlane(i,r,n,d),{positions:[t,r,i,h,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===c){if(!s)return f.lineSegmentPlane(r,t,n,h),f.lineSegmentPlane(i,t,n,d),{positions:[t,r,i,h,d],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return f.lineSegmentPlane(i,r,n,h),f.lineSegmentPlane(t,r,n,d),{positions:[t,r,i,h,d],indices:[2,0,4,2,4,3,1,3,4]};if(!u)return f.lineSegmentPlane(t,i,n,h),f.lineSegmentPlane(r,i,n,d),{positions:[t,r,i,h,d],indices:[0,1,4,0,4,3,2,3,4]}}},f}),r("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e,t,r){for(var i,n,o=0,a=e.length-1;a>=o;)if(i=~~((o+a)/2),n=r(e[i],t),0>n)o=i+1;else{if(!(n>0))return i;a=i-1}return~(a+1)}return r}),r("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,i,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=i,this.ut1MinusUtc=n}return e}),r("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,i=t[r++],n=function(e,t,r,i){r||(r=" ");var n=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return i?e+n:n+e},o=function(e,t,r,i,o,a){var s=i-e.length;return s>0&&(e=r||!o?n(e,i,a,r):e.slice(0,t.length)+n("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,i,a,s,l){var u=e>>>0;return r=r&&u&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+n(u.toString(t),s||0,"0",!1),o(e,r,i,a,l)},s=function(e,t,r,i,n,a){return null!=i&&(e=e.slice(0,i)),o(e,"",t,r,n,a)},l=function(e,i,l,u,c,h,d){var p,m,f,v,_;if("%%"==e)return"%";for(var g=!1,y="",C=!1,E=!1,S=" ",w=l.length,T=0;l&&w>T;T++)switch(l.charAt(T)){case" ":y=" ";break;case"+":y="+";break;case"-":g=!0;break;case"'":S=l.charAt(T+1);break;case"0":C=!0;break;case"#":E=!0}if(u=u?"*"==u?+t[r++]:"*"==u.charAt(0)?+t[u.slice(1,-1)]:+u:0,0>u&&(u=-u,g=!0),!isFinite(u))throw new Error("sprintf: (minimum-)width must be finite");switch(h=h?"*"==h?+t[r++]:"*"==h.charAt(0)?+t[h.slice(1,-1)]:+h:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,_=i?t[i.slice(0,-1)]:t[r++],d){case"s":return s(String(_),g,u,h,C,S);case"c":return s(String.fromCharCode(+_),g,u,h,C);case"b":return a(_,2,E,g,u,h,C);case"o":return a(_,8,E,g,u,h,C);case"x":return a(_,16,E,g,u,h,C);case"X":return a(_,16,E,g,u,h,C).toUpperCase();case"u":return a(_,10,E,g,u,h,C);case"i":case"d":return p=+_||0,p=Math.round(p-p%1),m=0>p?"-":y,_=m+n(String(Math.abs(p)),h,"0",!1),o(_,m,g,u,C);case"e":case"E":case"f":case"F":case"g":case"G":return p=+_,m=0>p?"-":y,f=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],v=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],_=m+Math.abs(p)[f](h),o(_,m,g,u,C)[v]();default:return e}};return i.replace(e,l)}return e}),r("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,i,n,o,a,s){this.year=e,this.month=t,this.day=r,this.hour=i,this.minute=n,this.second=o,this.millisecond=a,this.isLeapSecond=s}return e}),r("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),r("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),r("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),r("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),r("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,t){return f.compare(e.julianDate,t.julianDate)}function h(e){y.julianDate=e;var r=f.leapSeconds,i=t(r,y,c);0>i&&(i=~i),i>=r.length&&(i=r.length-1);var n=r[i].offset;if(i>0){var o=f.secondsDifference(r[i].julianDate,e);o>n&&(i--,n=r[i].offset)}f.addSeconds(e,n,e)}function d(e,r){y.julianDate=e;var i=f.leapSeconds,n=t(i,y,c);if(0>n&&(n=~n),0===n)return f.addSeconds(e,-i[0].offset,r);if(n>=i.length)return f.addSeconds(e,-i[n-1].offset,r);var o=f.secondsDifference(i[n].julianDate,e);return 0===o?f.addSeconds(e,-i[n].offset,r):1>=o?void 0:f.addSeconds(e,-i[--n].offset,r)}function p(e,t,r){var i=t/l.SECONDS_PER_DAY|0;return e+=i,t-=l.SECONDS_PER_DAY*i,0>t&&(e--,t+=l.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function m(e,t,r,i,n,o,a){var s=(t-14)/12|0,u=e+4800+s,c=(1461*u/4|0)+(367*(t-2-12*s)/12|0)-(3*((u+100)/100|0)/4|0)+r-32075;i-=12,0>i&&(i+=24);var h=o+(i*l.SECONDS_PER_HOUR+n*l.SECONDS_PER_MINUTE+a*l.SECONDS_PER_MILLISECOND);return h>=43200&&(c-=1),[c,h]}function f(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),i=r(i,u.UTC);var n=0|e;t+=(e-n)*l.SECONDS_PER_DAY,p(n,t,this),i===u.UTC&&h(this)}var v=new o,_=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,y=new s,C=/^(\d{4})$/,E=/^(\d{4})-(\d{2})$/,S=/^(\d{4})-?(\d{3})$/,w=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,T=/^(\d{4})-?(\d{2})-?(\d{2})$/,x=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+x.source,P=/^(\d{2}):?(\d{2})(\.\d+)?/.source+x.source,A=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+x.source,I="Invalid ISO 8601 date.";f.fromDate=function(e,t){var r=m(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return i(t)?(p(r[0],r[1],t),h(t),t):new f(r[0],r[1],u.UTC)},f.fromIso8601=function(e,t){e=e.replace(",",".");var r,o,s,l=e.split("T"),c=1,d=1,v=0,y=0,x=0,M=0,D=l[0],R=l[1];if(!i(D))throw new n(I);var O;if(l=D.match(T),null!==l){if(O=D.split("-").length-1,O>0&&2!==O)throw new n(I);r=+l[1],c=+l[2],d=+l[3]}else if(l=D.match(E),null!==l)r=+l[1],c=+l[2];else if(l=D.match(C),null!==l)r=+l[1];else{var N;if(l=D.match(S),null!==l){if(r=+l[1],N=+l[2],s=a(r),1>N||s&&N>366||!s&&N>365)throw new n(I)}else{if(l=D.match(w),null===l)throw new n(I);r=+l[1];var L=+l[2],F=+l[3]||0;if(O=D.split("-").length-1,O>0&&(!i(l[3])&&1!==O||i(l[3])&&2!==O))throw new n(I);var B=new Date(Date.UTC(r,0,4));N=7*L+F-B.getUTCDay()-3}o=new Date(Date.UTC(r,0,1)),o.setUTCDate(N),c=o.getUTCMonth()+1,d=o.getUTCDate()}if(s=a(r),1>c||c>12||1>d||(2!==c||!s)&&d>_[c-1]||s&&2===c&&d>g)throw new n(I);var V;if(i(R)){if(l=R.match(A),null!==l){if(O=R.split(":").length-1,O>0&&2!==O&&3!==O)throw new n(I);v=+l[1],y=+l[2],x=+l[3],M=1e3*+(l[4]||0),V=5}else if(l=R.match(P),null!==l){if(O=R.split(":").length-1,O>2)throw new n(I);v=+l[1],y=+l[2],x=60*+(l[3]||0),V=4}else{if(l=R.match(b),null===l)throw new n(I);v=+l[1],y=60*+(l[2]||0),V=3}if(y>=60||x>=61||v>24||24===v&&(y>0||x>0||M>0))throw new n(I);var z=l[V],k=+l[V+1],U=+(l[V+2]||0);switch(z){case"+":v-=k,y-=U;break;case"-":v+=k,y+=U;break;case"Z":break;default:y+=new Date(Date.UTC(r,c-1,d,v,y)).getTimezoneOffset()}}else y+=new Date(r,c-1,d).getTimezoneOffset();var G=60===x;for(G&&x--;y>=60;)y-=60,v++;for(;v>=24;)v-=24,d++;for(o=s&&2===c?g:_[c-1];d>o;)d-=o,c++,c>12&&(c-=12,r++),o=s&&2===c?g:_[c-1];for(;0>y;)y+=60,v--;for(;0>v;)v+=24,d--;for(;1>d;)c--,1>c&&(c+=12,r--),o=s&&2===c?g:_[c-1],d+=o;var W=m(r,c,d,v,y,x,M);return i(t)?(p(W[0],W[1],t),h(t)):t=new f(W[0],W[1],u.UTC),G&&f.addSeconds(t,1,t),t},f.now=function(e){return f.fromDate(new Date,e)};var M=new f(0,0,u.TAI);return f.toGregorianDate=function(e,t){var r=!1,n=d(e,M);i(n)||(f.addSeconds(e,-1,M),n=d(M,M),r=!0);var a=n.dayNumber,s=n.secondsOfDay;s>=43200&&(a+=1);var u=a+68569|0,c=4*u/146097|0;u=u-((146097*c+3)/4|0)|0;var h=4e3*(u+1)/1461001|0;u=u-(1461*h/4|0)+31|0;var p=80*u/2447|0,m=u-(2447*p/80|0)|0;u=p/11|0;var v=p+2-12*u|0,_=100*(c-49)+h+u|0,g=s/l.SECONDS_PER_HOUR|0,y=s-g*l.SECONDS_PER_HOUR,C=y/l.SECONDS_PER_MINUTE|0;y-=C*l.SECONDS_PER_MINUTE;var E=0|y,S=(y-E)/l.SECONDS_PER_MILLISECOND;return g+=12,g>23&&(g-=24),r&&(E+=1),i(t)?(t.year=_,t.month=v,t.day=m,t.hour=g,t.minute=C,t.second=E,t.millisecond=S,t.isLeapSecond=r,t):new o(_,v,m,g,C,E,S,r)},f.toDate=function(e){var t=f.toGregorianDate(e,v),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},f.toIso8601=function(t,r){var n,o=f.toGregorianDate(t,o);return i(r)||0===o.millisecond?i(r)&&0!==r?(n=(.01*o.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,n)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(n=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,n))},f.clone=function(e,t){return i(e)?i(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new f(e.dayNumber,e.secondsOfDay,u.TAI):void 0},f.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},f.equalsEpsilon=function(e,t,r){return e===t||i(e)&&i(t)&&Math.abs(f.secondsDifference(e,t))<=r},f.totalDays=function(e){return e.dayNumber+e.secondsOfDay/l.SECONDS_PER_DAY},f.secondsDifference=function(e,t){var r=(e.dayNumber-t.dayNumber)*l.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},f.daysDifference=function(e,t){var r=e.dayNumber-t.dayNumber,i=(e.secondsOfDay-t.secondsOfDay)/l.SECONDS_PER_DAY;return r+i},f.computeTaiMinusUtc=function(e){y.julianDate=e;var r=f.leapSeconds,i=t(r,y,c);return 0>i&&(i=~i,--i,0>i&&(i=0)),r[i].offset},f.addSeconds=function(e,t,r){return p(e.dayNumber,e.secondsOfDay+t,r)},f.addMinutes=function(e,t,r){var i=e.secondsOfDay+t*l.SECONDS_PER_MINUTE;return p(e.dayNumber,i,r)},f.addHours=function(e,t,r){var i=e.secondsOfDay+t*l.SECONDS_PER_HOUR;return p(e.dayNumber,i,r)},f.addDays=function(e,t,r){var i=e.dayNumber+t;return p(i,e.secondsOfDay,r)},f.lessThan=function(e,t){return f.compare(e,t)<0},f.lessThanOrEquals=function(e,t){return f.compare(e,t)<=0},f.greaterThan=function(e,t){return f.compare(e,t)>0},f.greaterThanOrEquals=function(e,t){return f.compare(e,t)>=0},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return f.toIso8601(this)},f.leapSeconds=[new s(new f(2441317,43210,u.TAI),10),new s(new f(2441499,43211,u.TAI),11),new s(new f(2441683,43212,u.TAI),12),new s(new f(2442048,43213,u.TAI),13),new s(new f(2442413,43214,u.TAI),14),new s(new f(2442778,43215,u.TAI),15),new s(new f(2443144,43216,u.TAI),16),new s(new f(2443509,43217,u.TAI),17),new s(new f(2443874,43218,u.TAI),18),new s(new f(2444239,43219,u.TAI),19),new s(new f(2444786,43220,u.TAI),20),new s(new f(2445151,43221,u.TAI),21),new s(new f(2445516,43222,u.TAI),22),new s(new f(2446247,43223,u.TAI),23),new s(new f(2447161,43224,u.TAI),24),new s(new f(2447892,43225,u.TAI),25),new s(new f(2448257,43226,u.TAI),26),new s(new f(2448804,43227,u.TAI),27),new s(new f(2449169,43228,u.TAI),28),new s(new f(2449534,43229,u.TAI),29),new s(new f(2450083,43230,u.TAI),30),new s(new f(2450630,43231,u.TAI),31),new s(new f(2451179,43232,u.TAI),32),new s(new f(2453736,43233,u.TAI),33),new s(new f(2454832,43234,u.TAI),34),new s(new f(2456109,43235,u.TAI),35),new s(new f(2457204,43236,u.TAI),36)],f}),r("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,i){if(null===r||"object"!=typeof r)return r;i=e(i,!1);var n=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];i&&(a=t(a,i)),n[o]=a}return n}return t}),r("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),i=0;i<r.length;++i){var n=r[i],o=n.indexOf(": ");if(o>0){var a=n.substring(0,o),s=n.substring(o+2);t[a]=s}}return t}return e}),r("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,i){this.statusCode=e,this.response=r,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),r("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,r,i,n,o){"use strict";function a(r){r=t(r,t.EMPTY_OBJECT);var i=r.responseType,n=t(r.method,"GET"),o=r.data,s=r.headers,l=r.overrideMimeType;return e(r.url,function(t){var r=e.defer();return a.load(t,i,n,o,s,r,l),r.promise});
}function s(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function l(e,t){for(var r=s(e,t),i=new ArrayBuffer(r.length),n=new Uint8Array(i),o=0;o<r.length;o++)n[o]=r.charCodeAt(o);return i}function u(e,r){r=t(r,"");var n=e[1],o=!!e[2],a=e[3];switch(r){case"":case"text":return s(o,a);case"arraybuffer":return l(o,a);case"blob":var u=l(o,a);return new Blob([u],{type:n});case"document":var c=new DOMParser;return c.parseFromString(s(o,a),n);case"json":return JSON.parse(s(o,a));default:throw new i("Unhandled responseType: "+r)}}var c=/^data:(.*?)(;base64)?,(.*)$/;return a.load=function(e,t,i,a,s,l,h){var d=c.exec(e);if(null!==d)return void l.resolve(u(d,t));var p=new XMLHttpRequest;if(r(h)&&r(p.overrideMimeType)&&p.overrideMimeType(h),p.open(i,e,!0),r(s))for(var m in s)s.hasOwnProperty(m)&&p.setRequestHeader(m,s[m]);r(t)&&(p.responseType=t),p.onload=function(){p.status>=200&&p.status<300?r(p.response)?l.resolve(p.response):r(p.responseXML)&&p.responseXML.hasChildNodes()?l.resolve(p.responseXML):r(p.responseText)?l.resolve(p.responseText):l.reject(new o("unknown XMLHttpRequest response type.")):l.reject(new n(p.status,p.response,p.getAllResponseHeaders()))},p.onerror=function(e){l.reject(new n)},p.send(a)},a.defaultLoad=a.load,a}),r("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,headers:r})}return t}),r("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,i){"use strict";function n(r,n){return t(n)?t(n.Accept)||(n=e(n),n.Accept=o.Accept):n=o,i(r,n).then(function(e){return JSON.parse(e)})}var o={Accept:"application/json,*/*;q=0.01"};return n}),r("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),i(t.data))m(this,t.data);else if(i(t.url)){var n=this;this._downloadPromise=e(l(t.url),function(e){m(n,e)},function(){n._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else m(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function p(e,t){return a.compare(e.julianDate,t)}function m(e,r){if(!i(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!i(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var n=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),l=r.columnNames.indexOf("yPoleWanderRadians"),u=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),f=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>n||0>o||0>l||0>u||0>d||0>m||0>f)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var v=e._samples=r.samples,_=e._dates=[];e._dateColumn=n,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=l,e._ut1MinusUtcSecondsColumn=u,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=m,e._taiMinusUtcSecondsColumn=f,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var g,y=e._addNewLeapSeconds,C=0,E=v.length;E>C;C+=e._columnCount){var S=v[C+n],w=v[C+f],T=S+c.MODIFIED_JULIAN_DATE_DIFFERENCE,x=new a(T,w,h.TAI);if(_.push(x),y){if(w!==g&&i(g)){var b=a.leapSeconds,P=t(b,x,p);if(0>P){var A=new s(x,w);b.splice(~P,0,A)}}g=w}}}function f(e,t,r,i,n){var o=r*i;n.xPoleWander=t[o+e._xPoleWanderRadiansColumn],n.yPoleWander=t[o+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function v(e,t,r){return t+e*(r-t)}function _(e,t,r,i,n,o,s){var l=e._columnCount;if(o>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var u=t[n],c=t[o];if(u.equals(c)||i.equals(u))return f(e,r,n,l,s),s;if(i.equals(c))return f(e,r,o,l,s),s;var h=a.secondsDifference(i,u)/a.secondsDifference(c,u),d=n*l,p=o*l,m=r[d+e._ut1MinusUtcSecondsColumn],_=r[p+e._ut1MinusUtcSecondsColumn],g=_-m;if(g>.5||-.5>g){var y=r[d+e._taiMinusUtcSecondsColumn],C=r[p+e._taiMinusUtcSecondsColumn];y!==C&&(c.equals(i)?m=_:_-=C-y)}return s.xPoleWander=v(h,r[d+e._xPoleWanderRadiansColumn],r[p+e._xPoleWanderRadiansColumn]),s.yPoleWander=v(h,r[d+e._yPoleWanderRadiansColumn],r[p+e._yPoleWanderRadiansColumn]),s.xPoleOffset=v(h,r[d+e._xCelestialPoleOffsetRadiansColumn],r[p+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=v(h,r[d+e._yCelestialPoleOffsetRadiansColumn],r[p+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=v(h,m,_),s}return d.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return i(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new n(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(i(this._samples)){if(i(r)||(r=new n(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var o=this._dates,s=this._lastIndex,l=0,c=0;if(i(s)){var h=o[s],d=o[s+1],p=a.lessThanOrEquals(h,e),m=!i(d),f=m||a.greaterThanOrEquals(d,e);if(p&&f)return l=s,!m&&d.equals(e)&&++l,c=l+1,_(this,o,this._samples,e,l,c,r),r}var v=t(o,e,a.compare,this._dateColumn);return v>=0?(v<o.length-1&&o[v+1].equals(e)&&++v,l=v,c=v):(c=~v,l=c-1,0>l&&(l=0)),this._lastIndex=l,_(this,o,this._samples,e,l,c,r),r}if(i(this._dataError))throw new u(this._dataError)},d}),r("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=i.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return o.test(t)?t:e.toUpperCase()}function r(e,t,r,i){return(t||"")+r.toLowerCase()+(i||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var i=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(n,t)),this.path&&(this.path=this.path.replace(n,t)),this.query&&(this.query=this.query.replace(n,t)),this.fragment&&(this.fragment=this.fragment.replace(n,t))};var n=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],i=""==t[0];i&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),i&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),r("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,i){"use strict";function n(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var i=e[t].getAttribute("src"),n=d.exec(i);if(null!==n)return n[1]}}function o(){if(t(u))return u;var i;if(i="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:n(),!t(i))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new e(i).resolve(new e(document.location.href))}function a(e){return i.toUrl("../"+e)}function s(t){return new e(t).resolve(o()).toString()}function l(e){t(c)||(c=t(i.toUrl)?a:s),t(h)||(h=document.createElement("a"));var r=c(e);return h.href=r,h.href=h.href,h.href}var u,c,h,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return l._cesiumScriptRegex=d,l.setBaseUrl=function(t){u=new e(t).resolve(new e(document.location.href))},l}),r("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),r("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),n=this._xTable=new Array(t+1),a=Math.pow(this._stepSizeDays,t),l=0;t>=l;++l){i[l]=a,n[l]=l*this._stepSizeDays;for(var u=0;t>=u;++u)u!==l&&(i[l]*=l-u);i[l]=1/i[l]}this._work=new Array(t+1),this._coef=new Array(t+1)}function u(e,t,r){var i=h;return i.dayNumber=t,i.secondsOfDay=r,o.daysDifference(i,e._sampleZeroDateTT)}function c(r,n){if(r._chunkDownloadsInProgress[n])return r._chunkDownloadsInProgress[n];var o=e.defer();r._chunkDownloadsInProgress[n]=o;var s,l=r._xysFileUrlTemplate;return s=i(l)?l.replace("{0}",n):t("Assets/IAU2006_XYS/IAU2006_XYS_"+n+".json"),e(a(s),function(e){r._chunkDownloadsInProgress[n]=!1;for(var t=r._samples,i=e.samples,a=n*r._samplesPerXysFile*3,s=0,l=i.length;l>s;++s)t[a+s]=i[s];o.resolve()}),o.promise}var h=new o(0,0,s.TAI);return l.prototype.preload=function(t,r,i,n){var o=u(this,t,r),a=u(this,i,n),s=o/this._stepSizeDays-this._interpolationOrder/2|0;0>s&&(s=0);var l=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var h=s/this._samplesPerXysFile|0,d=l/this._samplesPerXysFile|0,p=[],m=h;d>=m;++m)p.push(c(this,m));return e.all(p)},l.prototype.computeXysRadians=function(e,t,r){var o=u(this,e,t);if(!(0>o)){var a=o/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var s=this._interpolationOrder,l=a-(s/2|0);0>l&&(l=0);var h=l+s;h>=this._totalSamples&&(h=this._totalSamples-1,l=h-s,0>l&&(l=0));var d=!1,p=this._samples;if(i(p[3*l])||(c(this,l/this._samplesPerXysFile|0),d=!0),i(p[3*h])||(c(this,h/this._samplesPerXysFile|0),d=!0),!d){i(r)?(r.x=0,r.y=0,r.s=0):r=new n(0,0,0);var m,f,v=o-l*this._stepSizeDays,_=this._work,g=this._denominators,y=this._coef,C=this._xTable;for(m=0;s>=m;++m)_[m]=v-C[m];for(m=0;s>=m;++m){for(y[m]=1,f=0;s>=f;++f)f!==m&&(y[m]*=_[f]);y[m]*=g[m];var E=3*(l+m);r.x+=y[m]*p[E++],r.y+=y[m]*p[E++],r.s+=y[m]*p[E]}return r}}}},l}),r("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,i={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return t(n,{element:{get:function(){return n.supportsFullscreen()?document[i.fullscreenElement]:void 0}},changeEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenchange:void 0}},errorEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenerror:void 0}},enabled:{get:function(){return n.supportsFullscreen()?document[i.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return n.supportsFullscreen()?null!==n.element:void 0}}}),n.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return i.requestFullscreen="requestFullscreen",i.exitFullscreen="exitFullscreen",i.fullscreenEnabled="fullscreenEnabled",i.fullscreenElement="fullscreenElement",i.fullscreenchange="fullscreenchange",i.fullscreenerror="fullscreenerror",r=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var l=o[a];n=l+"RequestFullscreen","function"==typeof t[n]?(i.requestFullscreen=n,r=!0):(n=l+"RequestFullScreen","function"==typeof t[n]&&(i.requestFullscreen=n,r=!0)),n=l+"ExitFullscreen","function"==typeof document[n]?i.exitFullscreen=n:(n=l+"CancelFullScreen","function"==typeof document[n]&&(i.exitFullscreen=n)),n=l+"FullscreenEnabled",e(document[n])?i.fullscreenEnabled=n:(n=l+"FullScreenEnabled",e(document[n])&&(i.fullscreenEnabled=n)),n=l+"FullscreenElement",e(document[n])?i.fullscreenElement=n:(n=l+"FullScreenElement",e(document[n])&&(i.fullscreenElement=n)),n=l+"fullscreenchange",e(document["on"+n])&&("ms"===l&&(n="MSFullscreenChange"),i.fullscreenchange=n),n=l+"fullscreenerror",e(document["on"+n])&&("ms"===l&&(n="MSFullscreenError"),i.fullscreenerror=n)}return r},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[i.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[i.exitFullscreen]()},n}),r("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function i(e){for(var t=e.split("."),r=0,i=t.length;i>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!t(_)){_=!1;var e=/ Chrome\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(_=!0,g=i(e[1]))}return _}function o(){return n()&&g}function a(){if(!t(y)&&(y=!1,!n()&&/ Safari\/[\.0-9]+/.test(v.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(y=!0,C=i(e[1]))}return y}function s(){return a()&&C}function l(){if(!t(E)){E=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(v.userAgent);null!==e&&(E=!0,S=i(e[1]),S.isNightly=!!e[2])}return E}function u(){return l()&&S}function c(){if(!t(w)){w=!1;var e;"Microsoft Internet Explorer"===v.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(v.userAgent),null!==e&&(w=!0,T=i(e[1]))):"Netscape"===v.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(v.userAgent),null!==e&&(w=!0,T=i(e[1])))}return w}function h(){return c()&&T}function d(){if(!t(x)){x=!1;var e=/Firefox\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(x=!0,b=i(e[1]))}return x}function p(){return t(P)||(P=/Windows/i.test(v.appVersion)),P}function m(){return d()&&b}function f(){return t(A)||(A="undefined"!=typeof PointerEvent&&(!t(v.pointerEnabled)||v.pointerEnabled)),A}var v;v="undefined"!=typeof navigator?navigator:{};var _,g,y,C,E,S,w,T,x,b,P,A,I={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:l,webkitVersion:u,isInternetExplorer:c,internetExplorerVersion:h,isFirefox:d,firefoxVersion:m,isWindows:p,hardwareConcurrency:e(v.hardwareConcurrency,3),supportsPointerEvents:f};return I.supportsFullscreen=function(){return r.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),r("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,r,i,n){this.x=t(e,0),this.y=t(r,0),this.z=t(i,0),this.w=t(n,0)}var u=new e;l.fromAxisAngle=function(t,i,n){var o=i/2,a=Math.sin(o);u=e.normalize(t,u);var s=u.x*a,c=u.y*a,h=u.z*a,d=Math.cos(o);return r(n)?(n.x=s,n.y=c,n.z=h,n.w=d,n):new l(s,c,h,d)};var c=[1,2,0],h=new Array(3);l.fromRotationMatrix=function(e,t){var i,n,o,a,u,d=e[s.COLUMN0ROW0],p=e[s.COLUMN1ROW1],m=e[s.COLUMN2ROW2],f=d+p+m;if(f>0)i=Math.sqrt(f+1),u=.5*i,i=.5/i,n=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*i,o=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*i,a=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*i;else{var v=c,_=0;p>d&&(_=1),m>d&&m>p&&(_=2);var g=v[_],y=v[g];i=Math.sqrt(e[s.getElementIndex(_,_)]-e[s.getElementIndex(g,g)]-e[s.getElementIndex(y,y)]+1);var C=h;C[_]=.5*i,i=.5/i,u=(e[s.getElementIndex(y,g)]-e[s.getElementIndex(g,y)])*i,C[g]=(e[s.getElementIndex(g,_)]+e[s.getElementIndex(_,g)])*i,C[y]=(e[s.getElementIndex(y,_)]+e[s.getElementIndex(_,y)])*i,n=-C[0],o=-C[1],a=-C[2]}return r(t)?(t.x=n,t.y=o,t.z=a,t.w=u,t):new l(n,o,a,u)};var d=new l;l.fromHeadingPitchRoll=function(t,r,i,n){var o=l.fromAxisAngle(e.UNIT_X,i,d),a=l.fromAxisAngle(e.UNIT_Y,-r,n);n=l.multiply(a,o,a);var s=l.fromAxisAngle(e.UNIT_Z,-t,d);return l.multiply(s,n,n)};var p=new e,m=new e,f=new l,v=new l,_=new l;l.packedLength=4,l.pack=function(e,r,i){i=t(i,0),r[i++]=e.x,r[i++]=e.y,r[i++]=e.z,r[i]=e.w},l.unpack=function(e,i,n){return i=t(i,0),r(n)||(n=new l),n.x=e[i],n.y=e[i+1],n.z=e[i+2],n.w=e[i+3],n},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,r,i){l.unpack(e,4*r,_),l.conjugate(_,_);for(var n=0,o=r-t+1;o>n;n++){var a=3*n;l.unpack(e,4*(t+n),f),l.multiply(f,_,f),f.w<0&&l.negate(f,f),l.computeAxis(f,p);var s=l.computeAngle(f);i[a]=p.x*s,i[a+1]=p.y*s,i[a+2]=p.z*s}},l.unpackInterpolationResult=function(t,i,n,o,a){r(a)||(a=new l),e.fromArray(t,0,m);var s=e.magnitude(m);return l.unpack(i,4*o,v),0===s?l.clone(l.IDENTITY,f):l.fromAxisAngle(m,s,f),l.multiply(f,v,a)},l.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w):void 0},l.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},l.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,t){var r=1/l.magnitude(e),i=e.x*r,n=e.y*r,o=e.z*r,a=e.w*r;return t.x=i,t.y=n,t.z=o,t.w=a,t},l.inverse=function(e,t){var r=l.magnitudeSquared(e);return t=l.conjugate(e,t),l.multiplyByScalar(t,1/r,t)},l.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},l.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},l.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},l.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},l.multiply=function(e,t,r){var i=e.x,n=e.y,o=e.z,a=e.w,s=t.x,l=t.y,u=t.z,c=t.w,h=a*s+i*c+n*u-o*l,d=a*l-i*u+n*c+o*s,p=a*u+i*l-n*s+o*c,m=a*c-i*s-n*l-o*u;return r.x=h,r.y=d,r.z=p,r.w=m,r},l.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},l.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},l.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<a.EPSILON6)return t.x=t.y=t.z=0,t;var i=1/Math.sqrt(1-r*r);return t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t},l.computeAngle=function(e){return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var g=new l;l.lerp=function(e,t,r,i){return g=l.multiplyByScalar(t,r,g),i=l.multiplyByScalar(e,1-r,i),l.add(g,i,i)};var y=new l,C=new l,E=new l;l.slerp=function(e,t,r,i){var n=l.dot(e,t),o=t;if(0>n&&(n=-n,o=y=l.negate(t,y)),1-n<a.EPSILON6)return l.lerp(e,o,r,i);var s=Math.acos(n);return C=l.multiplyByScalar(e,Math.sin((1-r)*s),C),E=l.multiplyByScalar(o,Math.sin(r*s),E),i=l.add(C,E,i),l.multiplyByScalar(i,1/Math.sin(s),i)},l.log=function(t,r){var i=a.acosClamped(t.w),n=0;return 0!==i&&(n=i/Math.sin(i)),e.multiplyByScalar(t,n,r)},l.exp=function(t,r){var i=e.magnitude(t),n=0;return 0!==i&&(n=Math.sin(i)/i),r.x=t.x*n,r.y=t.y*n,r.z=t.z*n,r.w=Math.cos(i),r};var S=new e,w=new e,T=new l,x=new l;l.computeInnerQuadrangle=function(t,r,i,n){var o=l.conjugate(r,T);l.multiply(o,i,x);var a=l.log(x,S);l.multiply(o,t,x);var s=l.log(x,w);return e.add(a,s,a),e.multiplyByScalar(a,.25,a),e.negate(a,a),l.exp(a,T),l.multiply(r,T,n)},l.squad=function(e,t,r,i,n,o){var a=l.slerp(e,t,n,T),s=l.slerp(r,i,n,x);return l.slerp(a,s,2*n*(1-n),o)};for(var b=new l,P=1.9011074535173003,A=n.supportsTypedArrays()?new Float32Array(8):[],I=n.supportsTypedArrays()?new Float32Array(8):[],M=n.supportsTypedArrays()?new Float32Array(8):[],D=n.supportsTypedArrays()?new Float32Array(8):[],R=0;7>R;++R){var O=R+1,N=2*O+1;A[R]=1/(O*N),I[R]=O/N}return A[7]=P/136,I[7]=8*P/17,l.fastSlerp=function(e,t,r,i){var n,o=l.dot(e,t);o>=0?n=1:(n=-1,o=-o);for(var a=o-1,s=1-r,u=r*r,c=s*s,h=7;h>=0;--h)M[h]=(A[h]*u-I[h])*a,D[h]=(A[h]*c-I[h])*a;var d=n*r*(1+M[0]*(1+M[1]*(1+M[2]*(1+M[3]*(1+M[4]*(1+M[5]*(1+M[6]*(1+M[7])))))))),p=s*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),m=l.multiplyByScalar(e,p,b);return l.multiplyByScalar(t,d,i),l.add(m,i,i)},l.fastSquad=function(e,t,r,i,n,o){var a=l.fastSlerp(e,t,n,T),s=l.fastSlerp(r,i,n,x);return l.fastSlerp(a,s,2*n*(1-n),o)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},l.ZERO=o(new l(0,0,0,0)),l.IDENTITY=o(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),r("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_){"use strict";var g={},y=new r,C=new r,E=new r;g.eastNorthUpToFixedFrame=function(e,t,i){if(p.equalsEpsilon(e.x,0,p.EPSILON14)&&p.equalsEpsilon(e.y,0,p.EPSILON14)){var a=p.sign(e.z);return o(i)?(i[0]=0,i[1]=1,i[2]=0,i[3]=0,i[4]=-a,i[5]=0,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=a,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(0,-a,0,e.x,1,0,0,e.y,0,0,a,e.z,0,0,0,1)}var s=y,l=C,c=E;return t=n(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,r.normalize(l,l),r.cross(s,l,c),o(i)?(i[0]=l.x,i[1]=l.y,i[2]=l.z,i[3]=0,i[4]=c.x,i[5]=c.y,i[6]=c.z,i[7]=0,i[8]=s.x,i[9]=s.y,i[10]=s.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(l.x,c.x,s.x,e.x,l.y,c.y,s.y,e.y,l.z,c.z,s.z,e.z,0,0,0,1)};var S=new r,w=new r,T=new r;g.northEastDownToFixedFrame=function(e,t,i){if(p.equalsEpsilon(e.x,0,p.EPSILON14)&&p.equalsEpsilon(e.y,0,p.EPSILON14)){var a=p.sign(e.z);return o(i)?(i[0]=-a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=1,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=-a,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(-a,0,0,e.x,0,1,0,e.y,0,0,-a,e.z,0,0,0,1)}var s=S,l=w,c=T;return t=n(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,r.normalize(l,l),r.cross(s,l,c),o(i)?(i[0]=c.x,i[1]=c.y,i[2]=c.z,i[3]=0,i[4]=l.x,i[5]=l.y,i[6]=l.z,i[7]=0,i[8]=-s.x,i[9]=-s.y,i[10]=-s.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(c.x,l.x,-s.x,e.x,c.y,l.y,-s.y,e.y,c.z,l.z,-s.z,e.z,0,0,0,1)},g.northUpEastToFixedFrame=function(e,t,i){if(p.equalsEpsilon(e.x,0,p.EPSILON14)&&p.equalsEpsilon(e.y,0,p.EPSILON14)){var a=p.sign(e.z);return o(i)?(i[0]=-a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=0,i[6]=a,i[7]=0,i[8]=0,i[9]=1,i[10]=0,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(-a,0,0,e.x,0,0,1,e.y,0,a,0,e.z,0,0,0,1)}var s=y,l=C,c=E;return t=n(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,r.normalize(l,l),r.cross(s,l,c),o(i)?(i[0]=c.x,i[1]=c.y,i[2]=c.z,i[3]=0,i[4]=s.x,i[5]=s.y,i[6]=s.z,i[7]=0,i[8]=l.x,i[9]=l.y,i[10]=l.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(c.x,s.x,l.x,e.x,c.y,s.y,l.y,e.y,c.z,s.z,l.z,e.z,0,0,0,1)};var x=new v,b=new r(1,1,1),P=new f;g.headingPitchRollToFixedFrame=function(e,t,i,n,o,a){var s=v.fromHeadingPitchRoll(t,i,n,x),l=f.fromTranslationQuaternionRotationScale(r.ZERO,s,b,P);return a=g.eastNorthUpToFixedFrame(e,o,a),f.multiply(a,l,a)};var A=new f,I=new m;g.headingPitchRollQuaternion=function(e,t,r,i,n,o){var a=g.headingPitchRollToFixedFrame(e,t,r,i,n,A),s=f.getRotation(a,I);return v.fromRotationMatrix(s,o)};var M=24110.54841,D=8640184.812866,R=.093104,O=-62e-7,N=1.1772758384668e-19,L=72921158553e-15,F=p.TWO_PI/86400,B=new d;g.computeTemeToPseudoFixedMatrix=function(e,t){B=d.addSeconds(e,-d.computeTaiMinusUtc(e),B);var r,i=B.dayNumber,n=B.secondsOfDay,a=i-2451545;r=n>=43200?(a+.5)/_.DAYS_PER_JULIAN_CENTURY:(a-.5)/_.DAYS_PER_JULIAN_CENTURY;var s=M+r*(D+r*(R+r*O)),l=s*F%p.TWO_PI,u=L+N*(i-2451545.5),c=(n+.5*_.SECONDS_PER_DAY)%_.SECONDS_PER_DAY,h=l+u*c,f=Math.cos(h),v=Math.sin(h);return o(t)?(t[0]=f,t[1]=-v,t[2]=0,t[3]=v,t[4]=f,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(f,v,0,-v,f,0,0,0,1)},g.iau2006XysData=new c,g.earthOrientationParameters=s.NONE;var V=32.184,z=2451545;g.preloadIcrfFixed=function(t){var r=t.start.dayNumber,i=t.start.secondsOfDay+V,n=t.stop.dayNumber,o=t.stop.secondsOfDay+V,a=g.iau2006XysData.preload(r,i,n,o),s=g.earthOrientationParameters.getPromiseToLoad();return e.all([a,s])},g.computeIcrfToFixedMatrix=function(e,t){o(t)||(t=new m);var r=g.computeFixedToIcrfMatrix(e,t);if(o(r))return m.transpose(r,t)};var k=new h(0,0,0),U=new l(0,0,0,0,0,0),G=new m,W=new m;g.computeFixedToIcrfMatrix=function(e,t){o(t)||(t=new m);var r=g.earthOrientationParameters.compute(e,U);if(o(r)){var i=e.dayNumber,n=e.secondsOfDay+V,a=g.iau2006XysData.computeXysRadians(i,n,k);if(o(a)){var s=a.x+r.xPoleOffset,l=a.y+r.yPoleOffset,u=1/(1+Math.sqrt(1-s*s-l*l)),c=G;c[0]=1-u*s*s,c[3]=-u*s*l,c[6]=s,c[1]=-u*s*l,c[4]=1-u*l*l,c[7]=l,c[2]=-s,c[5]=-l,c[8]=1-u*(s*s+l*l);var h=m.fromRotationZ(-a.s,W),f=m.multiply(c,h,G),v=e.dayNumber,y=e.secondsOfDay-d.computeTaiMinusUtc(e)+r.ut1MinusUtc,C=v-2451545,E=y/_.SECONDS_PER_DAY,S=.779057273264+E+.00273781191135448*(C+E);S=S%1*p.TWO_PI;var w=m.fromRotationZ(S,W),T=m.multiply(f,w,G),x=Math.cos(r.xPoleWander),b=Math.cos(r.yPoleWander),P=Math.sin(r.xPoleWander),A=Math.sin(r.yPoleWander),I=i-z+n/_.SECONDS_PER_DAY;I/=36525;var M=-47e-6*I*p.RADIANS_PER_DEGREE/3600,D=Math.cos(M),R=Math.sin(M),O=W;return O[0]=x*D,O[1]=x*R,O[2]=P,O[3]=-b*R+A*P*D,O[4]=b*D+A*P*R,O[5]=-A*x,O[6]=-A*R-b*P*D,O[7]=A*D-b*P*R,O[8]=b*x,m.multiply(T,O,t)}}};var H=new i;g.pointToWindowCoordinates=function(e,t,r,i){return i=g.pointToGLWindowCoordinates(e,t,r,i),i.y=2*t[5]-i.y,i},g.pointToGLWindowCoordinates=function(e,r,n,a){o(a)||(a=new t);var s=H;return f.multiplyByVector(e,i.fromElements(n.x,n.y,n.z,1,s),s),i.multiplyByScalar(s,1/s.w,s),f.multiplyByVector(r,s,s),t.fromCartesian4(s,a)};var q=new r,j=new r,Y=new r;return g.rotationMatrixFromPositionVelocity=function(e,t,i,a){var s=n(i,u.WGS84).geodeticSurfaceNormal(e,q),l=r.cross(t,s,j);r.equalsEpsilon(l,r.ZERO,p.EPSILON6)&&(l=r.clone(r.UNIT_X,l));var c=r.cross(l,t,Y);return r.cross(t,c,l),r.negate(l,l),o(a)||(a=new m),a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=l.x,a[4]=l.y,a[5]=l.z,a[6]=c.x,a[7]=c.y,a[8]=c.z,a},g}),r("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e,t){t=n(t,l.WGS84),e=t.scaleToGeodeticSurface(e);var i=m.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(h.getColumn(i,0,v)),this._yAxis=r.fromCartesian4(h.getColumn(i,1,v));var o=r.fromCartesian4(h.getColumn(i,2,v));this._plane=d.fromPointNormal(e,o)}var v=new i;a(f.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var _=new e;f.fromPoints=function(t,r){var i=e.fromPoints(t,_);return new f(i.center,r)};var g=new p,y=new r;f.prototype.projectPointOntoPlane=function(e,i){var n=g;n.origin=e,r.normalize(e,n.direction);var a=u.rayPlane(n,this._plane,y);if(o(a)||(r.negate(n.direction,n.direction),a=u.rayPlane(n,this._plane,y)),o(a)){var s=r.subtract(a,this._origin,a),l=r.dot(this._xAxis,s),c=r.dot(this._yAxis,s);return o(i)?(i.x=l,i.y=c,i):new t(l,c)}},f.prototype.projectPointsOntoPlane=function(e,t){o(t)||(t=[]);for(var r=0,i=e.length,n=0;i>n;n++){var a=this.projectPointOntoPlane(e[n],t[r]);o(a)&&(t[r]=a,r++)}return t.length=r,t},f.prototype.projectPointToNearestOnPlane=function(e,i){o(i)||(i=new t);var n=g;n.origin=e,r.clone(this._plane.normal,n.direction);var a=u.rayPlane(n,this._plane,y);o(a)||(r.negate(n.direction,n.direction),a=u.rayPlane(n,this._plane,y));var s=r.subtract(a,this._origin,a),l=r.dot(this._xAxis,s),c=r.dot(this._yAxis,s);return i.x=l,i.y=c,i},f.prototype.projectPointsToNearestOnPlane=function(e,t){o(t)||(t=[]);var r=e.length;t.length=r;for(var i=0;r>i;i++)t[i]=this.projectPointToNearestOnPlane(e[i],t[i]);return t};var C=new r;return f.prototype.projectPointsOntoEllipsoid=function(e,t){var i=e.length;o(t)?t.length=i:t=new Array(i);for(var n=this._ellipsoid,a=this._origin,s=this._xAxis,l=this._yAxis,u=C,c=0;i>c;++c){var h=e[c];r.multiplyByScalar(s,h.x,u),o(t[c])||(t[c]=new r);var d=r.add(a,u,t[c]);r.multiplyByScalar(l,h.y,u),r.add(d,u,d),n.scaleToGeocentricSurface(d,d)}return t},f}),r("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e,t){this.center=r.clone(n(e,r.ZERO)),this.halfAxes=d.clone(n(t,d.ZERO))}function v(e,t,i,n,a,s,l,u){o(u)||(u=new f);var c=u.halfAxes;d.setColumn(c,0,e.xAxis,c),d.setColumn(c,1,e.yAxis,c),d.setColumn(c,2,e.zAxis,c);var h=T;h.x=(t+i)/2,h.y=(n+a)/2,h.z=(s+l)/2;var p=x;p.x=(i-t)/2,p.y=(a-n)/2,p.z=(l-s)/2;var m=u.center;return h=d.multiplyByVector(c,h,h),r.add(e.origin,h,m),d.multiplyByScale(c,p,c),u}var _=new r,g=new r,y=new r,C=new r,E=new r,S=new d,w={unitary:new d,diagonal:new d};f.fromPoints=function(e,t){if(o(t)||(t=new f),!o(e)||0===e.length)return t.halfAxes=d.ZERO,t.center=r.ZERO,t;var i,n=e.length,a=r.clone(e[0],_);for(i=1;n>i;i++)r.add(a,e[i],a);var s=1/n;r.multiplyByScalar(a,s,a);var l,u=0,c=0,h=0,p=0,m=0,v=0;for(i=0;n>i;i++)l=r.subtract(e[i],a,g),u+=l.x*l.x,c+=l.x*l.y,h+=l.x*l.z,p+=l.y*l.y,m+=l.y*l.z,v+=l.z*l.z;u*=s,c*=s,h*=s,
p*=s,m*=s,v*=s;var T=S;T[0]=u,T[1]=c,T[2]=h,T[3]=c,T[4]=p,T[5]=m,T[6]=h,T[7]=m,T[8]=v;var x=d.computeEigenDecomposition(T,w),b=d.transpose(x.unitary,t.halfAxes);l=r.subtract(e[0],a,g);var P=d.multiplyByVector(b,l,y),A=r.clone(P,C),I=r.clone(P,E);for(i=1;n>i;i++)l=r.subtract(e[i],a,l),d.multiplyByVector(b,l,P),r.minimumByComponent(I,P,I),r.maximumByComponent(A,P,A);var M=r.add(I,A,y);r.multiplyByScalar(M,.5,M),d.multiplyByVector(b,M,M),r.add(a,M,t.center);var D=r.subtract(A,I,y);return r.multiplyByScalar(D,.5,D),d.multiplyByScale(t.halfAxes,D,t.halfAxes),t};var T=new r,x=new r,b=new i,P=new r,A=[new i,new i,new i,new i,new i,new i,new i,new i],I=[new r,new r,new r,new r,new r,new r,new r,new r],M=[new t,new t,new t,new t,new t,new t,new t,new t];f.fromRectangle=function(e,t,r,i,o){t=n(t,0),r=n(r,0),i=n(i,s.WGS84);var a=m.center(e,b),u=i.cartographicToCartesian(a,P),c=new l(u,i),h=c.plane,d=A[0],f=A[1],_=A[2],g=A[3],y=A[4],C=A[5],E=A[6],S=A[7],w=a.longitude,T=e.south<0&&e.north>0?0:a.latitude;E.latitude=C.latitude=y.latitude=e.south,S.latitude=g.latitude=T,d.latitude=f.latitude=_.latitude=e.north,E.longitude=S.longitude=d.longitude=e.west,C.longitude=f.longitude=w,y.longitude=g.longitude=_.longitude=e.east,_.height=f.height=d.height=S.height=E.height=C.height=y.height=g.height=r,i.cartographicArrayToCartesianArray(A,I),c.projectPointsToNearestOnPlane(I,M);var x=Math.min(M[6].x,M[7].x,M[0].x),D=Math.max(M[2].x,M[3].x,M[4].x),R=Math.min(M[4].y,M[5].y,M[6].y),O=Math.max(M[0].y,M[1].y,M[2].y);_.height=d.height=y.height=E.height=t,i.cartographicArrayToCartesianArray(A,I);var N=Math.min(p.getPointDistance(h,I[0]),p.getPointDistance(h,I[2]),p.getPointDistance(h,I[4]),p.getPointDistance(h,I[6])),L=r;return v(c,x,D,R,O,N,L,o)},f.clone=function(e,t){return o(e)?o(t)?(r.clone(e.center,t.center),d.clone(e.halfAxes,t.halfAxes),t):new f(e.center,e.halfAxes):void 0},f.intersectPlane=function(e,t){var i=e.center,n=t.normal,o=e.halfAxes,a=n.x,s=n.y,l=n.z,c=Math.abs(a*o[d.COLUMN0ROW0]+s*o[d.COLUMN0ROW1]+l*o[d.COLUMN0ROW2])+Math.abs(a*o[d.COLUMN1ROW0]+s*o[d.COLUMN1ROW1]+l*o[d.COLUMN1ROW2])+Math.abs(a*o[d.COLUMN2ROW0]+s*o[d.COLUMN2ROW1]+l*o[d.COLUMN2ROW2]),h=r.dot(n,i)+t.distance;return-c>=h?u.OUTSIDE:h>=c?u.INSIDE:u.INTERSECTING};var D=new r,R=new r,O=new r,N=new r;f.distanceSquaredTo=function(e,t){var i=r.subtract(t,e.center,T),n=e.halfAxes,o=d.getColumn(n,0,D),a=d.getColumn(n,1,R),s=d.getColumn(n,2,O),l=r.magnitude(o),u=r.magnitude(a),c=r.magnitude(s);r.normalize(o,o),r.normalize(a,a),r.normalize(s,s);var h=N;h.x=r.dot(i,o),h.y=r.dot(i,a),h.z=r.dot(i,s);var p,m=0;return h.x<-l?(p=h.x+l,m+=p*p):h.x>l&&(p=h.x-l,m+=p*p),h.y<-u?(p=h.y+u,m+=p*p):h.y>u&&(p=h.y-u,m+=p*p),h.z<-c?(p=h.z+c,m+=p*p):h.z>c&&(p=h.z-c,m+=p*p),m};var L=new r,F=new r;f.computePlaneDistances=function(e,t,i,n){o(n)||(n=new c);var a=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,l=e.center,u=e.halfAxes,h=d.getColumn(u,0,D),p=d.getColumn(u,1,R),m=d.getColumn(u,2,O),f=r.add(h,p,L);r.add(f,m,f),r.add(f,l,f);var v=r.subtract(f,t,F),_=r.dot(i,v);return a=Math.min(_,a),s=Math.max(_,s),r.add(l,h,f),r.add(f,p,f),r.subtract(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.add(l,h,f),r.subtract(f,p,f),r.add(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.add(l,h,f),r.subtract(f,p,f),r.subtract(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.subtract(l,h,f),r.add(f,p,f),r.add(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.subtract(l,h,f),r.add(f,p,f),r.subtract(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.subtract(l,h,f),r.subtract(f,p,f),r.add(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),r.subtract(l,h,f),r.subtract(f,p,f),r.subtract(f,m,f),r.subtract(f,t,v),_=r.dot(i,v),a=Math.min(_,a),s=Math.max(_,s),n.start=a,n.stop=s,n};var B=new e;return f.isOccluded=function(t,r){var i=e.fromOrientedBoundingBox(t,B);return!r.isBoundingSphereVisible(i)},f.prototype.intersectPlane=function(e){return f.intersectPlane(this,e)},f.prototype.distanceSquaredTo=function(e){return f.distanceSquaredTo(this,e)},f.prototype.computePlaneDistances=function(e,t,r){return f.computePlaneDistances(this,e,t,r)},f.prototype.isOccluded=function(e){return f.isOccluded(this,e)},f.equals=function(e,t){return e===t||o(e)&&o(t)&&r.equals(e.center,t.center)&&d.equals(e.halfAxes,t.halfAxes)},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f}),r("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,i,n){"use strict";var o={};o.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,i=t.y;t.x=(1-Math.abs(i))*n.signNotZero(r),t.y=(1-Math.abs(r))*n.signNotZero(i)}return t.x=n.toSNorm(t.x),t.y=n.toSNorm(t.y),t},o.octDecode=function(e,r,i){if(i.x=n.fromSNorm(e),i.y=n.fromSNorm(r),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var o=i.x;i.x=(1-Math.abs(i.y))*n.signNotZero(o),i.y=(1-Math.abs(o))*n.signNotZero(i.y)}return t.normalize(i,i)},o.octPackFloat=function(e){return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,t){var r=e/256,i=Math.floor(r),n=256*(r-i);return o.octDecode(i,n,t)},o.octPack=function(e,t,r,i){var n=o.octEncodeFloat(e),s=o.octEncodeFloat(t),l=o.octEncode(r,a);return i.x=65536*l.x+n,i.y=65536*l.y+s,i},o.octUnpack=function(e,t,r,i){var n=e.x/65536,a=Math.floor(n),s=65536*(n-a);n=e.y/65536;var l=Math.floor(n),u=65536*(n-l);o.octDecodeFloat(s,t),o.octDecodeFloat(u,r),o.octDecode(a,l,i)},o.compressTextureCoordinates=function(e){var t=1===e.x?4095:4096*e.x|0,r=1===e.y?4095:4096*e.y|0;return 4096*t+r},o.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},o}),r("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),r("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,i,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return r(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,t){switch(e){case a.BYTE:return new Int8Array(t);case a.UNSIGNED_BYTE:return new Uint8Array(t);case a.SHORT:return new Int16Array(t);case a.UNSIGNED_SHORT:return new Uint16Array(t);case a.FLOAT:return new Float32Array(t);case a.DOUBLE:return new Float64Array(t);default:throw new i("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,r,n,o){switch(n=t(n,0),o=t(o,(r.byteLength-n)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(r,n,o);case a.UNSIGNED_BYTE:return new Uint8Array(r,n,o);case a.SHORT:return new Int16Array(r,n,o);case a.UNSIGNED_SHORT:return new Uint16Array(r,n,o);case a.FLOAT:return new Float32Array(r,n,o);case a.DOUBLE:return new Float64Array(r,n,o);default:throw new i("componentDatatype is not a valid value.")}},o(a)}),r("Core/TerrainQuantization",["./freezeObject"],function(e){"use strict";var t={NONE:0,BITS12:1};return e(t)}),r("Core/TerrainEncoding",["./AttributeCompression","./Cartesian2","./Cartesian3","./ComponentDatatype","./defined","./Math","./Matrix3","./Matrix4","./TerrainQuantization"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e,t,i,o,a){var u,d,v,_;if(n(e)&&n(t)&&n(i)&&n(o)){var g=e.minimum,y=e.maximum,C=r.subtract(y,g,h),E=i-t,S=Math.max(r.maximumComponent(C),E);u=f-1>S?l.BITS12:l.NONE,d=e.center,v=s.inverseTransformation(o,new s);var w=r.negate(g,c);s.multiply(s.fromTranslation(w,p),v,v);var T=c;T.x=1/C.x,T.y=1/C.y,T.z=1/C.z,s.multiply(s.fromScale(T,p),v,v),_=s.clone(o),s.setTranslation(_,r.ZERO,_),o=s.clone(o,new s);var x=s.fromTranslation(g,p),b=s.fromScale(C,m),P=s.multiply(x,b,p);s.multiply(o,P,o),s.multiply(_,P,_)}this.quantization=u,this.minimumHeight=t,this.maximumHeight=i,this.center=d,this.toScaledENU=v,this.fromScaledENU=o,this.matrix=_,this.hasVertexNormals=a}var c=new r,h=new r,d=new t,p=new s,m=new s,f=Math.pow(2,12);u.prototype.encode=function(i,n,a,u,h,p){var m=u.x,f=u.y;if(this.quantization===l.BITS12){a=s.multiplyByPoint(this.toScaledENU,a,c),a.x=o.clamp(a.x,0,1),a.y=o.clamp(a.y,0,1),a.z=o.clamp(a.z,0,1);var v=this.maximumHeight-this.minimumHeight,_=o.clamp((h-this.minimumHeight)/v,0,1);t.fromElements(a.x,a.y,d);var g=e.compressTextureCoordinates(d);t.fromElements(a.z,_,d);var y=e.compressTextureCoordinates(d);t.fromElements(m,f,d);var C=e.compressTextureCoordinates(d);i[n++]=g,i[n++]=y,i[n++]=C}else r.subtract(a,this.center,c),i[n++]=c.x,i[n++]=c.y,i[n++]=c.z,i[n++]=h,i[n++]=m,i[n++]=f;return this.hasVertexNormals&&(i[n++]=e.octPackFloat(p)),n},u.prototype.decodePosition=function(t,i,o){if(n(o)||(o=new r),i*=this.getStride(),this.quantization===l.BITS12){var a=e.decompressTextureCoordinates(t[i],d);o.x=a.x,o.y=a.y;var u=e.decompressTextureCoordinates(t[i+1],d);return o.z=u.x,s.multiplyByPoint(this.fromScaledENU,o,o)}return o.x=t[i],o.y=t[i+1],o.z=t[i+2],r.add(o,this.center,o)},u.prototype.getStride=function(){var e;switch(this.quantization){case l.BITS12:e=3;break;default:e=6}return this.hasVertexNormals&&++e,e};var v={position3DAndHeight:0,textureCoordAndEncodedNormals:1},_={compressed:0};return u.prototype.getAttributes=function(e){var t=i.FLOAT;if(this.quantization===l.NONE){var r=i.getSizeInBytes(t),n=4,o=this.hasVertexNormals?3:2,a=(this.hasVertexNormals?7:6)*r;return[{index:v.position3DAndHeight,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:n,offsetInBytes:0,strideInBytes:a},{index:v.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:o,offsetInBytes:n*r,strideInBytes:a}]}var s=3;return s+=this.hasVertexNormals?1:0,[{index:_.compressed,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:s}]},u.prototype.getAttributeLocations=function(){return this.quantization===l.NONE?v:_},u.clone=function(e,t){return n(t)||(t=new u),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=r.clone(e.center),t.toScaledENU=s.clone(e.toScaledENU),t.fromScaledENU=s.clone(e.fromScaledENU),t.matrix=s.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t},u}),r("Core/HeightmapTessellator",["./AxisAlignedBoundingBox","./BoundingSphere","./Cartesian2","./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidalOccluder","./freezeObject","./Math","./Matrix4","./OrientedBoundingBox","./Rectangle","./TerrainEncoding","./Transforms"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f){"use strict";var v={};v.DEFAULT_STRUCTURE=u({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var _=new i,g=new h,y=new i,C=new i;return v.computeVertices=function(a){var u,E,S,w,T=Math.cos,x=Math.sin,b=Math.sqrt,P=Math.atan,A=Math.exp,I=c.PI_OVER_TWO,M=c.toRadians,D=a.heightmap,R=a.width,O=a.height,N=a.skirtHeight,L=n(a.isGeographic,!0),F=n(a.ellipsoid,s.WGS84),B=1/F.maximumRadius,V=a.nativeRectangle,z=a.rectangle;o(z)?(u=z.west,E=z.south,S=z.east,w=z.north):L?(u=M(V.west),E=M(V.south),S=M(V.east),w=M(V.north)):(u=V.west*B,E=I-2*P(A(-V.south*B)),S=V.east*B,w=I-2*P(A(-V.north*B)));var k=n(a.relativeToCenter,i.ZERO),U=n(a.exaggeration,1),G=n(a.structure,v.DEFAULT_STRUCTURE),W=n(G.heightScale,v.DEFAULT_STRUCTURE.heightScale),H=n(G.heightOffset,v.DEFAULT_STRUCTURE.heightOffset),q=n(G.elementsPerHeight,v.DEFAULT_STRUCTURE.elementsPerHeight),j=n(G.stride,v.DEFAULT_STRUCTURE.stride),Y=n(G.elementMultiplier,v.DEFAULT_STRUCTURE.elementMultiplier),X=n(G.isBigEndian,v.DEFAULT_STRUCTURE.isBigEndian),Z=p.computeWidth(V)/(R-1),K=p.computeHeight(V)/(O-1),Q=F.radiiSquared,J=Q.x,$=Q.y,ee=Q.z,te=65536,re=-65536,ie=f.eastNorthUpToFixedFrame(k,F),ne=h.inverseTransformation(ie,g),oe=y;oe.x=Number.POSITIVE_INFINITY,oe.y=Number.POSITIVE_INFINITY,oe.z=Number.POSITIVE_INFINITY;var ae=C;ae.x=Number.NEGATIVE_INFINITY,ae.y=Number.NEGATIVE_INFINITY,ae.z=Number.NEGATIVE_INFINITY;var se=Number.POSITIVE_INFINITY,le=R+(N>0?2:0),ue=O+(N>0?2:0),ce=le*ue,he=new Array(ce),de=new Array(ce),pe=new Array(ce),me=0,fe=O,ve=0,_e=R;N>0&&(--me,++fe,--ve,++_e);for(var ge=0,ye=me;fe>ye;++ye){var Ce=ye;0>Ce&&(Ce=0),Ce>=O&&(Ce=O-1);var Ee=V.north-K*Ce;Ee=L?M(Ee):I-2*P(A(-Ee*B));var Se=T(Ee),we=x(Ee),Te=ee*we,xe=(Ee-E)/(w-E);xe=c.clamp(xe,0,1);for(var be=ve;_e>be;++be){var Pe=be;0>Pe&&(Pe=0),Pe>=R&&(Pe=R-1);var Ae=V.west+Z*Pe;L?Ae=M(Ae):Ae*=B;var Ie,Me=Ce*(R*j)+Pe*j;if(1===q)Ie=D[Me];else{Ie=0;var De;if(X)for(De=0;q>De;++De)Ie=Ie*Y+D[Me+De];else for(De=q-1;De>=0;--De)Ie=Ie*Y+D[Me+De]}Ie=(Ie*W+H)*U,re=Math.max(re,Ie),te=Math.min(te,Ie),(be!==Pe||ye!==Ce)&&(Ie-=N);var Re=Se*T(Ae),Oe=Se*x(Ae),Ne=J*Re,Le=$*Oe,Fe=b(Ne*Re+Le*Oe+Te*we),Be=1/Fe,Ve=Ne*Be,ze=Le*Be,ke=Te*Be,Ue=new i;Ue.x=Ve+Re*Ie,Ue.y=ze+Oe*Ie,Ue.z=ke+we*Ie,he[ge]=Ue,de[ge]=Ie;var Ge=(Ae-u)/(S-u);Ge=c.clamp(Ge,0,1),pe[ge]=new r(Ge,xe),ge++,h.multiplyByPoint(ne,Ue,_),i.minimumByComponent(_,oe,oe),i.maximumByComponent(_,ae,ae),se=Math.min(se,Ie)}}var We,He=t.fromPoints(he);o(z)&&z.width<c.PI_OVER_TWO+c.EPSILON5&&(We=d.fromRectangle(z,te,re,F));var qe,je=a.relativetoCenter;if(o(je)){var Ye=new l(F);qe=Ye.computeHorizonCullingPointFromPoints(je,he)}for(var Xe=new e(oe,ae,k),Ze=new m(Xe,se,re,ie,!1),Ke=new Float32Array(ce*Ze.getStride()),Qe=0,Je=0;ce>Je;++Je)Qe=Ze.encode(Ke,Qe,he[Je],pe[Je],de[Je]);return{vertices:Ke,maximumHeight:re,minimumHeight:te,encoding:Ze,boundingSphere3D:He,orientedBoundingBox:We,occludeePointInScaledSpace:qe}},v}),r("Core/destroyObject",["./defaultValue","./DeveloperError"],function(e,t){"use strict";function r(){return!0}function i(i,n){function o(){throw new t(n)}n=e(n,"This object was destroyed, i.e., destroy() was called.");for(var a in i)"function"==typeof i[a]&&(i[a]=o);i.isDestroyed=r}return i}),r("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var i=r.host,n=r.protocol;return r.href=t,r.href=r.href,n!==r.protocol||i!==r.host}var r;return t}),r("Core/TaskProcessor",["../ThirdParty/Uri","../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./destroyObject","./DeveloperError","./isCrossOriginUrl","./RuntimeError","require"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(){if(!n(f._canTransferArrayBuffer)){var e=new Worker(d("Workers/transferTypedArrayTest.js"));e.postMessage=i(e.webkitPostMessage,e.postMessage);var r=99,o=new Int8Array([r]);try{e.postMessage({array:o},[o.buffer])}catch(a){return f._canTransferArrayBuffer=!1,f._canTransferArrayBuffer}var s=t.defer();e.onmessage=function(t){var i=t.data.array,o=n(i)&&i[0]===r;s.resolve(o),e.terminate(),f._canTransferArrayBuffer=o},f._canTransferArrayBuffer=s.promise}return f._canTransferArrayBuffer}function h(e,t){--e._activeTasks;var r=t.id;if(n(r)){var i=e._deferreds,o=i[r];if(n(t.error)){var s=t.error;"RuntimeError"===s.name?(s=new l(t.error.message),s.stack=t.error.stack):"DeveloperError"===s.name&&(s=new a(t.error.message),s.stack=t.error.stack),o.reject(s)}else o.resolve(t.result);delete i[r]}}function d(e){var t=r(e);if(s(t)){var i,n='importScripts("'+t+'");';try{i=new Blob([n],{type:"application/javascript"})}catch(o){var a=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,l=new a;l.append(n),i=l.getBlob("application/javascript")}var u=window.URL||window.webkitURL;t=u.createObjectURL(i)}return t}function p(){return n(v)||(v=d("Workers/cesiumWorkerBootstrapper.js")),v}function m(t){var o=new Worker(p());o.postMessage=i(o.webkitPostMessage,o.postMessage);var a={loaderConfig:{},workerModule:f._workerModulePrefix+t._workerName};if(n(f._loaderConfig))a.loaderConfig=f._loaderConfig;else if(n(u.toUrl)){var s=new e("..").resolve(new e(r("Workers/cesiumWorkerBootstrapper.js"))).toString();a.loaderConfig.baseUrl=s}else a.loaderConfig.paths={Workers:r("Workers")};return o.postMessage(a),o.onmessage=function(e){h(t,e.data)},o}function f(e,t){this._workerName=e,this._maximumActiveTasks=i(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0}var v,_=[];return f.prototype.scheduleTask=function(e,r){if(n(this._worker)||(this._worker=m(this)),!(this._activeTasks>=this._maximumActiveTasks)){++this._activeTasks;var i=this;return t(c(),function(o){n(r)?o||(r.length=0):r=_;var a=i._nextID++,s=t.defer();return i._deferreds[a]=s,i._worker.postMessage({id:a,parameters:e,canTransferArrayBuffer:o},r),s.promise})}},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){return n(this._worker)&&this._worker.terminate(),o(this)},f._defaultWorkerModulePrefix="Workers/",f._workerModulePrefix=f._defaultWorkerModulePrefix,f._loaderConfig=void 0,f._canTransferArrayBuffer=void 0,f}),r("Core/TerrainMesh",["../Core/defaultValue"],function(e){"use strict";function t(t,r,i,n,o,a,s,l,u,c){this.center=t,this.vertices=r,this.stride=e(l,6),this.indices=i,this.minimumHeight=n,this.maximumHeight=o,this.boundingSphere3D=a,this.occludeePointInScaledSpace=s,this.orientedBoundingBox=u,this.encoding=c}return t}),r("Core/TerrainProvider",["./defined","./defineProperties","./DeveloperError","./Math"],function(e,t,r,i){"use strict";function n(){r.throwInstantiationError()}t(n.prototype,{errorEvent:{get:r.throwInstantiationError},credit:{get:r.throwInstantiationError},tilingScheme:{get:r.throwInstantiationError},ready:{get:r.throwInstantiationError},readyPromise:{get:r.throwInstantiationError},hasWaterMask:{get:r.throwInstantiationError},hasVertexNormals:{get:r.throwInstantiationError}});var o=[];return n.getRegularGridIndices=function(t,r){var i=o[t];e(i)||(o[t]=i=[]);var n=i[r];if(!e(n)){n=i[r]=new Uint16Array((t-1)*(r-1)*6);for(var a=0,s=0,l=0;r-1>l;++l){for(var u=0;t-1>u;++u){var c=a,h=c+t,d=h+1,p=c+1;n[s++]=c,n[s++]=h,n[s++]=p,n[s++]=p,n[s++]=h,n[s++]=d,++a}++a}}return n},n.heightmapTerrainQuality=.25,n.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,r){return 2*e.maximumRadius*Math.PI*n.heightmapTerrainQuality/(t*r)},n.prototype.requestTileGeometry=r.throwInstantiationError,
n.prototype.getLevelMaximumGeometricError=r.throwInstantiationError,n.prototype.getTileDataAvailable=r.throwInstantiationError,n}),r("Core/HeightmapTerrainData",["../ThirdParty/when","./defaultValue","./defined","./defineProperties","./DeveloperError","./GeographicTilingScheme","./HeightmapTessellator","./Math","./Rectangle","./TaskProcessor","./TerrainEncoding","./TerrainMesh","./TerrainProvider"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=t(e.childTileMask,15);var i=a.DEFAULT_STRUCTURE,n=e.structure;r(n)?n!==i&&(n.heightScale=t(n.heightScale,i.heightScale),n.heightOffset=t(n.heightOffset,i.heightOffset),n.elementsPerHeight=t(n.elementsPerHeight,i.elementsPerHeight),n.stride=t(n.stride,i.stride),n.elementMultiplier=t(n.elementMultiplier,i.elementMultiplier),n.isBigEndian=t(n.isBigEndian,i.isBigEndian)):n=i,this._structure=n,this._createdByUpsampling=t(e.createdByUpsampling,!1),this._waterMask=e.waterMask}function m(e,t,r,i,n,o,a,s){var l=1,u=e._width,c=e._height,h=o*(u-1),d=h+u-1,m=a*(c-1),f=m+c-1,v=1<<l;h/=v,d/=v,m/=v,f/=v;var _=r*(u-1),g=i*(c-1);h-=_,d-=_,m-=g,f-=g;var y,C,E=0|h,S=0|d,w=0|m,T=0|f,x=S-E+1,b=T-w+1,P=e._buffer,A=e._structure,I=x*b,M=I*A.stride,D=new P.constructor(M),R=0,O=A.stride;if(O>1)for(C=w;T>=C;++C)for(y=E;S>=y;++y)for(var N=(C*u+y)*O,L=0;O>L;++L)D[R++]=P[N+L];else for(C=w;T>=C;++C)for(y=E;S>=y;++y)D[R++]=P[C*u+y];return new p({buffer:D,width:x,height:b,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function f(e,t,r,i,n,o,a,l){var u,c,h,d,m=e._width,f=e._height,g=e._structure,y=g.stride,E=e._buffer,S=new E.constructor(m*f*y),w=t.tileXYToRectangle(r,i,n),T=t.tileXYToRectangle(o,a,l);if(y>1){var x=g.elementsPerHeight,b=g.elementMultiplier,P=g.isBigEndian,A=Math.pow(b,x-1);for(c=0;f>c;++c)for(h=s.lerp(T.north,T.south,c/(f-1)),u=0;m>u;++u){d=s.lerp(T.west,T.east,u/(m-1));var I=_(E,x,b,y,P,w,m,f,d,h);C(S,x,b,A,y,P,c*m+u,I)}}else for(c=0;f>c;++c)for(h=s.lerp(T.north,T.south,c/(f-1)),u=0;m>u;++u)d=s.lerp(T.west,T.east,u/(m-1)),S[c*m+u]=v(E,w,m,f,d,h);return new p({buffer:S,width:m,height:f,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function v(e,t,r,i,n,o){var a=(n-t.west)*(r-1)/(t.east-t.west),s=(o-t.south)*(i-1)/(t.north-t.south),l=0|a,u=l+1;u>=r&&(u=r-1,l=r-2);var c=0|s,h=c+1;h>=i&&(h=i-1,c=i-2);var d=a-l,p=s-c;c=i-1-c,h=i-1-h;var m=e[c*r+l],f=e[c*r+u],v=e[h*r+l],_=e[h*r+u];return g(d,p,m,f,v,_)}function _(e,t,r,i,n,o,a,s,l,u){var c=(l-o.west)*(a-1)/(o.east-o.west),h=(u-o.south)*(s-1)/(o.north-o.south),d=0|c,p=d+1;p>=a&&(p=a-1,d=a-2);var m=0|h,f=m+1;f>=s&&(f=s-1,m=s-2);var v=c-d,_=h-m;m=s-1-m,f=s-1-f;var C=y(e,t,r,i,n,m*a+d),E=y(e,t,r,i,n,m*a+p),S=y(e,t,r,i,n,f*a+d),w=y(e,t,r,i,n,f*a+p);return g(v,_,C,E,S,w)}function g(e,t,r,i,n,o){return e>t?r+e*(i-r)+t*(o-i):r+e*(o-n)+t*(n-r)}function y(e,t,r,i,n,o){o*=i;var a,s=0;if(n)for(a=0;t>a;++a)s=s*r+e[o+a];else for(a=t-1;a>=0;--a)s=s*r+e[o+a];return s}function C(e,t,r,i,n,o,a,s){a*=n;var l;if(o)for(l=0;t>l;++l)e[a+l]=s/i|0,s-=e[a+l]*i,i/=r;else for(l=t-1;l>=0;--l)e[a+l]=s/i|0,s-=e[a+l]*i,i/=r}i(p.prototype,{waterMask:{get:function(){return this._waterMask}}});var E=new u("createVerticesFromHeightmap");return p.prototype.createMesh=function(i,n,a,s,u){var p=i.ellipsoid,m=i.tileXYToNativeRectangle(n,a,s),f=i.tileXYToRectangle(n,a,s);u=t(u,1);var v=p.cartographicToCartesian(l.center(f)),_=this._structure,g=d.getEstimatedLevelZeroGeometricErrorForAHeightmap(p,this._width,i.getNumberOfXTilesAtLevel(0)),y=g/(1<<s),C=E.scheduleTask({heightmap:this._buffer,structure:_,width:this._width,height:this._height,nativeRectangle:m,rectangle:f,relativeToCenter:v,ellipsoid:p,skirtHeight:Math.min(4*y,1e3),isGeographic:i instanceof o,exaggeration:u});return r(C)?e(C,function(e){return new h(v,new Float32Array(e.vertices),d.getRegularGridIndices(e.gridWidth,e.gridHeight),e.minimumHeight,e.maximumHeight,e.boundingSphere3D,e.occludeePointInScaledSpace,6,e.orientedBoundingBox,c.clone(e.encoding))}):void 0},p.prototype.interpolateHeight=function(e,t,r){var i,n=this._width,o=this._height,a=this._structure,s=a.stride;if(s>1){var l=a.elementsPerHeight,u=a.elementMultiplier,c=a.isBigEndian;i=_(this._buffer,l,u,s,c,e,n,o,t,r)}else i=v(this._buffer,e,n,o,t,r);return i*a.heightScale+a.heightOffset},p.prototype.upsample=function(e,t,r,i,n,o,a){var s;return s=this._width%2===1&&this._height%2===1?m(this,e,t,r,i,n,o,a):f(this,e,t,r,i,n,o,a)},p.prototype.isChildAvailable=function(e,t,r,i){var n=2;return r!==2*e&&++n,i!==2*t&&(n-=2),0!==(this._childTileMask&1<<n)},p.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling},p}),r("Core/loadImage",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./isCrossOriginUrl"],function(e,t,r,i,n){"use strict";function o(r,i){return i=t(i,!0),e(r,function(t){var r;r=a.test(t)||!i?!1:n(t);var s=e.defer();return o.createImage(t,r,s),s.promise})}var a=/^data:/;return o.createImage=function(e,t,r){var i=new Image;i.onload=function(){r.resolve(i)},i.onerror=function(e){r.reject(e)},t&&(i.crossOrigin=""),i.src=e},o.defaultCreateImage=o.createImage,o}),r("Core/throttleRequestByServer",["../ThirdParty/Uri","../ThirdParty/when","./defaultValue"],function(e,t,r){"use strict";function i(t){var r=new e(t).resolve(a);r.normalize();var i=r.authority;return/:/.test(i)||(i=i+":"+("https"===r.scheme?"443":"80")),i}function n(e,a){var s=i(e),l=r(o[s],0);return l>=n.maximumRequestsPerServer?void 0:(o[s]=l+1,t(a(e),function(e){return o[s]--,e}).otherwise(function(e){return o[s]--,t.reject(e)}))}var o={},a="undefined"!=typeof document?new e(document.location.href):new e;return n.maximumRequestsPerServer=6,n}),r("Core/ArcGisImageServerTerrainProvider",["../ThirdParty/when","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Event","./GeographicTilingScheme","./getImagePixels","./HeightmapTerrainData","./loadImage","./Math","./TerrainProvider","./throttleRequestByServer"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(n){this._url=n.url,this._token=n.token,this._tilingScheme=n.tilingScheme,i(this._tilingScheme)||(this._tilingScheme=new l({ellipsoid:r(n.ellipsoid,a.WGS84)})),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=p.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._proxy=n.proxy,this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0},this._errorEvent=new s;var o=n.credit;"string"==typeof o&&(o=new t(o)),this._credit=o,this._readyPromise=e.resolve(!0)}return n(f.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),f.prototype.requestTileGeometry=function(t,r,n){var o=this._tilingScheme.tileXYToRectangle(t,r,n),a=(o.east-o.west)/(this._heightmapWidth-1),s=(o.north-o.south)/(this._heightmapWidth-1);o.west-=.5*a,o.east+=.5*a,o.south-=.5*s,o.north+=.5*s;var l=d.toDegrees(o.west)+"%2C"+d.toDegrees(o.south)+"%2C"+d.toDegrees(o.east)+"%2C"+d.toDegrees(o.north),p=this._url+"/exportImage?interpolation=RSP_BilinearInterpolation&format=tiff&f=image&size="+this._heightmapWidth+"%2C"+this._heightmapWidth+"&bboxSR=4326&imageSR=4326&bbox="+l;this._token&&(p+="&token="+this._token);var f=this._proxy;i(f)&&(p=f.getURL(p));var v=m(p,h);if(i(v)){var _=this;return e(v,function(e){return new c({buffer:u(e),width:_._heightmapWidth,height:_._heightmapWidth,childTileMask:15,structure:_._terrainDataStructure})})}},f.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},f.prototype.getTileDataAvailable=function(e,t,r){},f}),r("Core/AssociativeArray",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";function i(){this._array=[],this._hash={}}return t(i.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),i.prototype.contains=function(t){return e(this._hash[t])},i.prototype.set=function(e,t){var r=this._hash[e];t!==r&&(this.remove(e),this._hash[e]=t,this._array.push(t))},i.prototype.get=function(e){return this._hash[e]},i.prototype.remove=function(t){var r=this._hash[t],i=e(r);if(i){var n=this._array;n.splice(n.indexOf(r),1),delete this._hash[t]}return i},i.prototype.removeAll=function(){var e=this._array;e.length>0&&(this._hash={},e.length=0)},i}),r("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,i){"use strict";function n(i,n,l,u,c){r(c)||(c=new t);var h,d,p,m,f,v,_,g;r(n.z)?(h=t.subtract(l,n,o),d=t.subtract(u,n,a),p=t.subtract(i,n,s),m=t.dot(h,h),f=t.dot(h,d),v=t.dot(h,p),_=t.dot(d,d),g=t.dot(d,p)):(h=e.subtract(l,n,o),d=e.subtract(u,n,a),p=e.subtract(i,n,s),m=e.dot(h,h),f=e.dot(h,d),v=e.dot(h,p),_=e.dot(d,d),g=e.dot(d,p));var y=1/(m*_-f*f);return c.y=(_*v-f*g)*y,c.z=(m*g-f*v)*y,c.x=1-c.y-c.z,c}var o=new t,a=new t,s=new t;return n}),r("Core/BingMapsApi",["./defined"],function(e){"use strict";var t={};t.defaultKey=void 0;var r=!1;return t.getKey=function(i){return e(i)?i:e(t.defaultKey)?t.defaultKey:(r||(console.log("This application is using Cesium's default Bing Maps key.  Please create a new key for the application as soon as possible and prior to deployment by visiting https://www.bingmapsportal.com/, and provide your key to Cesium by setting the Cesium.BingMapsApi.defaultKey property before constructing the CesiumWidget or any other object that uses the Bing Maps API."),r=!0),"Aj1ony_-Typ-KjG9SJWiKSHY23U1KmK7yAmZa9lDmuF2osXWkcZ22VPsqmCt0TCt")},t}),r("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t,i,n){this.x=r(e,0),this.y=r(t,0),this.width=r(i,0),this.height=r(n,0)}l.fromPoints=function(e,t){if(i(t)||(t=new l),!i(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var r=e.length,n=e[0].x,o=e[0].y,a=e[0].x,s=e[0].y,u=1;r>u;u++){var c=e[u],h=c.x,d=c.y;n=Math.min(h,n),a=Math.max(h,a),o=Math.min(d,o),s=Math.max(d,s)}return t.x=n,t.y=o,t.width=a-n,t.height=s-o,t};var u=new o,c=new t,h=new t;return l.fromRectangle=function(t,n,o){if(i(o)||(o=new l),!i(t))return o.x=0,o.y=0,o.width=0,o.height=0,o;n=r(n,u);var a=n.project(s.southwest(t,c)),d=n.project(s.northeast(t,h));return e.subtract(d,a,d),o.x=a.x,o.y=a.y,o.width=d.x,o.height=d.y,o},l.clone=function(e,t){return i(e)?i(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new l(e.x,e.y,e.width,e.height):void 0},l.union=function(e,t,r){i(r)||(r=new l);var n=Math.min(e.x,t.x),o=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),s=Math.max(e.y+e.height,t.y+t.height);return r.x=n,r.y=o,r.width=a-n,r.height=s-o,r},l.expand=function(e,t,r){r=l.clone(e,r);var i=t.x-r.x,n=t.y-r.y;return i>r.width?r.width=i:0>i&&(r.width-=i,r.x=t.x),n>r.height?r.height=n:0>n&&(r.height-=n,r.y=t.y),r},l.intersect=function(e,t){var r=e.x,i=e.y,n=t.x,o=t.y;return r>n+t.width||r+e.width<n||i+e.height<o||i>o+t.height?a.OUTSIDE:a.INTERSECTING},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.intersect=function(e){return l.intersect(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l}),r("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),r("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),r("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,i,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,n.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,i.NONE),this.boundingSphereCV=void 0}return o.computeNumberOfVertices=function(e){var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&t(e.attributes[n])&&t(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new r("All attribute lists must have the same number of attributes.");i=a}return i},o}),r("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return i}),r("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color}return t}),r("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return n.POSITION_ONLY=i(new n({position:!0})),n.POSITION_AND_NORMAL=i(new n({position:!0,normal:!0})),n.POSITION_NORMAL_AND_ST=i(new n({position:!0,normal:!0,st:!0})),n.POSITION_AND_ST=i(new n({position:!0,st:!0})),n.POSITION_AND_COLOR=i(new n({position:!0,color:!0})),n.ALL=i(new n({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),n.DEFAULT=n.POSITION_NORMAL_AND_ST,n.packedLength=6,n.pack=function(t,r,i){i=e(i,0),r[i++]=t.position?1:0,r[i++]=t.normal?1:0,r[i++]=t.st?1:0,r[i++]=t.binormal?1:0,r[i++]=t.tangent?1:0,r[i++]=t.color?1:0},n.unpack=function(r,i,o){return i=e(i,0),t(o)||(o=new n),o.position=1===r[i++],o.normal=1===r[i++],o.st=1===r[i++],o.binormal=1===r[i++],o.tangent=1===r[i++],o.color=1===r[i++],o},n.clone=function(e,r){return t(e)?(t(r)||(r=new n),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},n}),r("Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e){e=i(e,i.EMPTY_OBJECT);var r=e.minimum,n=e.maximum,o=i(e.vertexFormat,c.DEFAULT);this._minimum=t.clone(r),this._maximum=t.clone(n),this._vertexFormat=o,this._workerName="createBoxGeometry"}var d=new t;h.fromDimensions=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.dimensions,n=t.multiplyByScalar(r,.5,new t);return new h({minimum:t.negate(n,new t),maximum:n,vertexFormat:e.vertexFormat})},h.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new o("boundingBox is required.");return new h({minimum:e.minimum,maximum:e.maximum})},h.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new o("boundingBox is required.");return new h({minimum:e.minimum,maximum:e.maximum})},h.packedLength=2*t.packedLength+c.packedLength,h.pack=function(e,r,n){n=i(n,0),t.pack(e._minimum,r,n),t.pack(e._maximum,r,n+t.packedLength),c.pack(e._vertexFormat,r,n+2*t.packedLength)};var p=new t,m=new t,f=new c,v={minimum:p,maximum:m,vertexFormat:f};return h.unpack=function(e,r,o){r=i(r,0);var a=t.unpack(e,r,p),s=t.unpack(e,r+t.packedLength,m),l=c.unpack(e,r+2*t.packedLength,f);return n(o)?(o._minimum=t.clone(a,o._minimum),o._maximum=t.clone(s,o._maximum),o._vertexFormat=c.clone(l,o._vertexFormat),o):new h(v)},h.createGeometry=function(i){var n,o,c=i._minimum,h=i._maximum,p=i._vertexFormat,m=new l;if(p.position&&(p.st||p.normal||p.binormal||p.tangent)){if(p.position&&(o=new Float64Array(72),o[0]=c.x,o[1]=c.y,o[2]=h.z,o[3]=h.x,o[4]=c.y,o[5]=h.z,o[6]=h.x,o[7]=h.y,o[8]=h.z,o[9]=c.x,o[10]=h.y,o[11]=h.z,o[12]=c.x,o[13]=c.y,o[14]=c.z,o[15]=h.x,o[16]=c.y,o[17]=c.z,o[18]=h.x,o[19]=h.y,o[20]=c.z,o[21]=c.x,o[22]=h.y,o[23]=c.z,o[24]=h.x,o[25]=c.y,o[26]=c.z,o[27]=h.x,o[28]=h.y,o[29]=c.z,o[30]=h.x,o[31]=h.y,o[32]=h.z,o[33]=h.x,o[34]=c.y,o[35]=h.z,o[36]=c.x,o[37]=c.y,o[38]=c.z,o[39]=c.x,o[40]=h.y,o[41]=c.z,o[42]=c.x,o[43]=h.y,o[44]=h.z,o[45]=c.x,o[46]=c.y,o[47]=h.z,o[48]=c.x,o[49]=h.y,o[50]=c.z,o[51]=h.x,o[52]=h.y,o[53]=c.z,o[54]=h.x,o[55]=h.y,o[56]=h.z,o[57]=c.x,o[58]=h.y,o[59]=h.z,o[60]=c.x,o[61]=c.y,o[62]=c.z,o[63]=h.x,o[64]=c.y,o[65]=c.z,o[66]=h.x,o[67]=c.y,o[68]=h.z,o[69]=c.x,o[70]=c.y,o[71]=h.z,m.position=new s({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:o})),p.normal){var f=new Float32Array(72);f[0]=0,f[1]=0,f[2]=1,f[3]=0,f[4]=0,f[5]=1,f[6]=0,f[7]=0,f[8]=1,f[9]=0,f[10]=0,f[11]=1,f[12]=0,f[13]=0,f[14]=-1,f[15]=0,f[16]=0,f[17]=-1,f[18]=0,f[19]=0,f[20]=-1,f[21]=0,f[22]=0,f[23]=-1,f[24]=1,f[25]=0,f[26]=0,f[27]=1,f[28]=0,f[29]=0,f[30]=1,f[31]=0,f[32]=0,f[33]=1,f[34]=0,f[35]=0,f[36]=-1,f[37]=0,f[38]=0,f[39]=-1,f[40]=0,f[41]=0,f[42]=-1,f[43]=0,f[44]=0,f[45]=-1,f[46]=0,f[47]=0,f[48]=0,f[49]=1,f[50]=0,f[51]=0,f[52]=1,f[53]=0,f[54]=0,f[55]=1,f[56]=0,f[57]=0,f[58]=1,f[59]=0,f[60]=0,f[61]=-1,f[62]=0,f[63]=0,f[64]=-1,f[65]=0,f[66]=0,f[67]=-1,f[68]=0,f[69]=0,f[70]=-1,f[71]=0,m.normal=new s({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:f})}if(p.st){var v=new Float32Array(48);v[0]=0,v[1]=0,v[2]=1,v[3]=0,v[4]=1,v[5]=1,v[6]=0,v[7]=1,v[8]=1,v[9]=0,v[10]=0,v[11]=0,v[12]=0,v[13]=1,v[14]=1,v[15]=1,v[16]=0,v[17]=0,v[18]=1,v[19]=0,v[20]=1,v[21]=1,v[22]=0,v[23]=1,v[24]=1,v[25]=0,v[26]=0,v[27]=0,v[28]=0,v[29]=1,v[30]=1,v[31]=1,v[32]=1,v[33]=0,v[34]=0,v[35]=0,v[36]=0,v[37]=1,v[38]=1,v[39]=1,v[40]=0,v[41]=0,v[42]=1,v[43]=0,v[44]=1,v[45]=1,v[46]=0,v[47]=1,m.st=new s({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:v})}if(p.tangent){var _=new Float32Array(72);_[0]=1,_[1]=0,_[2]=0,_[3]=1,_[4]=0,_[5]=0,_[6]=1,_[7]=0,_[8]=0,_[9]=1,_[10]=0,_[11]=0,_[12]=-1,_[13]=0,_[14]=0,_[15]=-1,_[16]=0,_[17]=0,_[18]=-1,_[19]=0,_[20]=0,_[21]=-1,_[22]=0,_[23]=0,_[24]=0,_[25]=1,_[26]=0,_[27]=0,_[28]=1,_[29]=0,_[30]=0,_[31]=1,_[32]=0,_[33]=0,_[34]=1,_[35]=0,_[36]=0,_[37]=-1,_[38]=0,_[39]=0,_[40]=-1,_[41]=0,_[42]=0,_[43]=-1,_[44]=0,_[45]=0,_[46]=-1,_[47]=0,_[48]=-1,_[49]=0,_[50]=0,_[51]=-1,_[52]=0,_[53]=0,_[54]=-1,_[55]=0,_[56]=0,_[57]=-1,_[58]=0,_[59]=0,_[60]=1,_[61]=0,_[62]=0,_[63]=1,_[64]=0,_[65]=0,_[66]=1,_[67]=0,_[68]=0,_[69]=1,_[70]=0,_[71]=0,m.tangent=new s({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:_})}if(p.binormal){var g=new Float32Array(72);g[0]=0,g[1]=1,g[2]=0,g[3]=0,g[4]=1,g[5]=0,g[6]=0,g[7]=1,g[8]=0,g[9]=0,g[10]=1,g[11]=0,g[12]=0,g[13]=1,g[14]=0,g[15]=0,g[16]=1,g[17]=0,g[18]=0,g[19]=1,g[20]=0,g[21]=0,g[22]=1,g[23]=0,g[24]=0,g[25]=0,g[26]=1,g[27]=0,g[28]=0,g[29]=1,g[30]=0,g[31]=0,g[32]=1,g[33]=0,g[34]=0,g[35]=1,g[36]=0,g[37]=0,g[38]=1,g[39]=0,g[40]=0,g[41]=1,g[42]=0,g[43]=0,g[44]=1,g[45]=0,g[46]=0,g[47]=1,g[48]=0,g[49]=0,g[50]=1,g[51]=0,g[52]=0,g[53]=1,g[54]=0,g[55]=0,g[56]=1,g[57]=0,g[58]=0,g[59]=1,g[60]=0,g[61]=0,g[62]=1,g[63]=0,g[64]=0,g[65]=1,g[66]=0,g[67]=0,g[68]=1,g[69]=0,g[70]=0,g[71]=1,m.binormal=new s({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:g})}n=new Uint16Array(36),n[0]=0,n[1]=1,n[2]=2,n[3]=0,n[4]=2,n[5]=3,n[6]=6,n[7]=5,n[8]=4,n[9]=7,n[10]=6,n[11]=4,n[12]=8,n[13]=9,n[14]=10,n[15]=8,n[16]=10,n[17]=11,n[18]=14,n[19]=13,n[20]=12,n[21]=15,n[22]=14,n[23]=12,n[24]=18,n[25]=17,n[26]=16,n[27]=19,n[28]=18,n[29]=16,n[30]=20,n[31]=21,n[32]=22,n[33]=20,n[34]=22,n[35]=23}else o=new Float64Array(24),o[0]=c.x,o[1]=c.y,o[2]=c.z,o[3]=h.x,o[4]=c.y,o[5]=c.z,o[6]=h.x,o[7]=h.y,o[8]=c.z,o[9]=c.x,o[10]=h.y,o[11]=c.z,o[12]=c.x,o[13]=c.y,o[14]=h.z,o[15]=h.x,o[16]=c.y,o[17]=h.z,o[18]=h.x,o[19]=h.y,o[20]=h.z,o[21]=c.x,o[22]=h.y,o[23]=h.z,m.position=new s({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:o}),n=new Uint16Array(36),n[0]=4,n[1]=5,n[2]=6,n[3]=4,n[4]=6,n[5]=7,n[6]=1,n[7]=0,n[8]=3,n[9]=1,n[10]=3,n[11]=2,n[12]=1,n[13]=6,n[14]=5,n[15]=1,n[16]=2,n[17]=6,n[18]=2,n[19]=3,n[20]=7,n[21]=2,n[22]=7,n[23]=6,n[24]=3,n[25]=0,n[26]=4,n[27]=3,n[28]=4,n[29]=7,n[30]=0,n[31]=1,n[32]=5,n[33]=0,n[34]=5,n[35]=4;var y=t.subtract(h,c,d),C=.5*t.magnitude(y);return new a({attributes:m,indices:n,primitiveType:u.TRIANGLES,boundingSphere:new e(t.ZERO,C)})},h}),r("Core/BoxOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e){e=i(e,i.EMPTY_OBJECT);var r=e.minimum,n=e.maximum;this._min=t.clone(r),this._max=t.clone(n),this._workerName="createBoxOutlineGeometry"}var h=new t;c.fromDimensions=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.dimensions,n=t.multiplyByScalar(r,.5,new t);return new c({minimum:t.negate(n,new t),maximum:n})},c.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new o("boundingBox is required.");return new c({minimum:e.minimum,maximum:e.maximum})},c.packedLength=2*t.packedLength,c.pack=function(e,r,n){n=i(n,0),t.pack(e._min,r,n),t.pack(e._max,r,n+t.packedLength)};var d=new t,p=new t,m={minimum:d,maximum:p};return c.unpack=function(e,r,o){r=i(r,0);var a=t.unpack(e,r,d),s=t.unpack(e,r+t.packedLength,p);return n(o)?(o._min=t.clone(a,o._min),o._max=t.clone(s,o._max),o):new c(m)},c.createGeometry=function(i){var n=i._min,o=i._max,c=new l,d=new Uint16Array(24),p=new Float64Array(24);p[0]=n.x,p[1]=n.y,p[2]=n.z,p[3]=o.x,p[4]=n.y,p[5]=n.z,p[6]=o.x,p[7]=o.y,p[8]=n.z,p[9]=n.x,p[10]=o.y,p[11]=n.z,p[12]=n.x,p[13]=n.y,p[14]=o.z,p[15]=o.x,p[16]=n.y,p[17]=o.z,p[18]=o.x,p[19]=o.y,p[20]=o.z,p[21]=n.x,p[22]=o.y,p[23]=o.z,c.position=new s({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:p}),d[0]=4,d[1]=5,d[2]=5,d[3]=6,d[4]=6,d[5]=7,d[6]=7,d[7]=4,d[8]=0,d[9]=1,d[10]=1,d[11]=2,d[12]=2,d[13]=3,d[14]=3,d[15]=0,d[16]=0,d[17]=4,d[18]=1,d[19]=5,d[20]=2,d[21]=6,d[22]=3,d[23]=7;var m=t.subtract(o,n,h),f=.5*t.magnitude(m);return new a({attributes:c,indices:d,primitiveType:u.LINES,boundingSphere:new e(t.ZERO,f)})},c}),r("Core/cancelAnimationFrame",["./defined"],function(e){"use strict";function t(e){r(e)}if("undefined"!=typeof window){var r=window.cancelAnimationFrame;return function(){if(!e(r))for(var t=["webkit","moz","ms","o"],i=0,n=t.length;n>i&&!e(r);)r=window[t[i]+"CancelAnimationFrame"],e(r)||(r=window[t[i]+"CancelRequestAnimationFrame"]),++i;e(r)||(r=clearTimeout)}(),t}}),r("Core/Spline",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(){this.times=void 0,this.points=void 0,r.throwInstantiationError()}return i.prototype.evaluate=r.throwInstantiationError,i.prototype.findTimeInterval=function(t,r){var i=this.times,n=i.length;if(r=e(r,0),t>=i[r]){if(n>r+1&&t<i[r+1])return r;if(n>r+2&&t<i[r+2])return r+1}else if(r-1>=0&&t>=i[r-1])return r-1;var o;if(t>i[r])for(o=r;n-1>o&&!(t>=i[o]&&t<i[o+1]);++o);else for(o=r-1;o>=0&&!(t>=i[o]&&t<i[o+1]);--o);return o===n-1&&(o=n-2),o},i}),r("Core/LinearSpline",["./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Spline"],function(e,t,r,i,n,o){"use strict";function a(e){e=t(e,t.EMPTY_OBJECT);var r=e.points,i=e.times;this._times=i,this._points=r,this._lastTimeIndex=0}return i(a.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),a.prototype.findTimeInterval=o.prototype.findTimeInterval,a.prototype.evaluate=function(t,i){var n=this.points,o=this.times,a=this._lastTimeIndex=this.findTimeInterval(t,this._lastTimeIndex),s=(t-o[a])/(o[a+1]-o[a]);return r(i)||(i=new e),e.lerp(n[a],n[a+1],s,i)},a}),r("Core/TridiagonalSystemSolver",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.solve=function(t,r,i,n){var o,a=new Array(i.length),s=new Array(n.length),l=new Array(n.length);for(o=0;o<s.length;o++)s[o]=new e,l[o]=new e;a[0]=i[0]/r[0],s[0]=e.multiplyByScalar(n[0],1/r[0],s[0]);var u;for(o=1;o<a.length;++o)u=1/(r[o]-a[o-1]*t[o-1]),a[o]=i[o]*u,s[o]=e.subtract(n[o],e.multiplyByScalar(s[o-1],t[o-1],s[o]),s[o]),s[o]=e.multiplyByScalar(s[o],u,s[o]);for(u=1/(r[o]-a[o-1]*t[o-1]),s[o]=e.subtract(n[o],e.multiplyByScalar(s[o-1],t[o-1],s[o]),s[o]),s[o]=e.multiplyByScalar(s[o],u,s[o]),l[l.length-1]=s[s.length-1],o=l.length-2;o>=0;--o)l[o]=e.subtract(s[o],e.multiplyByScalar(l[o+1],a[o],l[o]),l[o]);return l},i}),r("Core/HermiteSpline",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./LinearSpline","./Matrix4","./Spline","./TridiagonalSystemSolver"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(t,r,n){var o=p,a=f,s=m,l=v;o.length=a.length=t.length-1,s.length=l.length=t.length;var c;o[0]=s[0]=1,a[0]=0;var h=l[0];for(i(h)||(h=l[0]=new e),e.clone(r,h),c=1;c<o.length-1;++c)o[c]=a[c]=1,s[c]=4,h=l[c],i(h)||(h=l[c]=new e),e.subtract(t[c+1],t[c-1],h),e.multiplyByScalar(h,3,h);return o[c]=0,a[c]=1,s[c]=4,h=l[c],i(h)||(h=l[c]=new e),e.subtract(t[c+1],t[c-1],h),e.multiplyByScalar(h,3,h),s[c+1]=1,h=l[c+1],i(h)||(h=l[c+1]=new e),e.clone(n,h),u.solve(o,s,a,l)}function h(t){var r=p,n=f,o=m,a=v;r.length=n.length=t.length-1,o.length=a.length=t.length;var s;r[0]=n[0]=1,o[0]=2;var l=a[0];for(i(l)||(l=a[0]=new e),e.subtract(t[1],t[0],l),e.multiplyByScalar(l,3,l),s=1;s<r.length;++s)r[s]=n[s]=1,o[s]=4,l=a[s],i(l)||(l=a[s]=new e),e.subtract(t[s+1],t[s-1],l),e.multiplyByScalar(l,3,l);return o[s]=2,l=a[s],i(l)||(l=a[s]=new e),e.subtract(t[s],t[s-1],l),e.multiplyByScalar(l,3,l),u.solve(r,o,n,a)}function d(e){e=r(e,r.EMPTY_OBJECT);var t=e.points,i=e.times,n=e.inTangents,o=e.outTangents;this._times=i,this._points=t,this._inTangents=n,this._outTangents=o,this._lastTimeIndex=0}var p=[],m=[],f=[],v=[];n(d.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),d.createC1=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,i=e.points,n=e.tangents,o=n.slice(0,n.length-1),a=n.slice(1,n.length);return new d({times:t,points:i,inTangents:a,outTangents:o})},d.createNaturalCubic=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,i=e.points;if(i.length<3)return new a({points:i,times:t});var n=h(i),o=n.slice(0,n.length-1),s=n.slice(1,n.length);return new d({times:t,points:i,inTangents:s,outTangents:o})},d.createClampedCubic=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,i=e.points,n=e.firstTangent,o=e.lastTangent;if(i.length<3)return new a({points:i,times:t});var s=c(i,n,o),l=s.slice(0,s.length-1),u=s.slice(1,s.length);return new d({times:t,points:i,inTangents:u,outTangents:l})},d.hermiteCoefficientMatrix=new s(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),d.prototype.findTimeInterval=l.prototype.findTimeInterval;var _=new t,g=new e;return d.prototype.evaluate=function(t,r){i(r)||(r=new e);var n=this.points,o=this.times,a=this.inTangents,l=this.outTangents,u=this._lastTimeIndex=this.findTimeInterval(t,this._lastTimeIndex),c=(t-o[u])/(o[u+1]-o[u]),h=_;h.z=c,h.y=c*c,h.x=h.y*c,h.w=1;var p=s.multiplyByVector(d.hermiteCoefficientMatrix,h,h);return r=e.multiplyByScalar(n[u],p.x,r),e.multiplyByScalar(n[u+1],p.y,g),e.add(r,g,r),e.multiplyByScalar(l[u],p.z,g),e.add(r,g,r),e.multiplyByScalar(a[u],p.w,g),e.add(r,g,r)},d}),r("Core/CatmullRomSpline",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./HermiteSpline","./Matrix4","./Spline"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(t){var r=t.points,n=t.times;if(r.length<3){var o=n[0],l=1/(n[1]-o),u=r[0],m=r[1];return function(t,r){i(r)||(r=new e);var n=(t-o)*l;return e.lerp(u,m,n,r)}}return function(o,l){i(l)||(l=new e);var u=t._lastTimeIndex=t.findTimeInterval(o,t._lastTimeIndex),m=(o-n[u])/(n[u+1]-n[u]),f=h;f.z=m,f.y=m*m,f.x=f.y*m,f.w=1;var v,_,g,y,C;return 0===u?(v=r[0],_=r[1],g=t.firstTangent,y=e.subtract(r[2],v,d),e.multiplyByScalar(y,.5,y),C=s.multiplyByVector(a.hermiteCoefficientMatrix,f,f)):u===r.length-2?(v=r[u],_=r[u+1],y=t.lastTangent,g=e.subtract(_,r[u-1],d),e.multiplyByScalar(g,.5,g),C=s.multiplyByVector(a.hermiteCoefficientMatrix,f,f)):(v=r[u-1],_=r[u],g=r[u+1],y=r[u+2],C=s.multiplyByVector(c.catmullRomCoefficientMatrix,f,f)),l=e.multiplyByScalar(v,C.x,l),e.multiplyByScalar(_,C.y,p),e.add(l,p,l),e.multiplyByScalar(g,C.z,p),e.add(l,p,l),e.multiplyByScalar(y,C.w,p),e.add(l,p,l)}}function c(t){t=r(t,r.EMPTY_OBJECT);var n=t.points,o=t.times,a=t.firstTangent,s=t.lastTangent;if(n.length>2&&(i(a)||(a=m,e.multiplyByScalar(n[1],2,a),e.subtract(a,n[2],a),e.subtract(a,n[0],a),e.multiplyByScalar(a,.5,a)),!i(s))){var l=n.length-1;s=f,e.multiplyByScalar(n[l-1],2,s),e.subtract(n[l],s,s),e.add(s,n[l-2],s),e.multiplyByScalar(s,.5,s)}this._times=o,this._points=n,this._firstTangent=e.clone(a),this._lastTangent=e.clone(s),this._evaluateFunction=u(this),this._lastTimeIndex=0}var h=new t,d=new e,p=new e,m=new e,f=new e;return n(c.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),c.catmullRomCoefficientMatrix=new s(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),c.prototype.findTimeInterval=l.prototype.findTimeInterval,c.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},c}),r("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},o.validate=function(e){return t(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,t){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},o.createTypedArrayFromArrayBuffer=function(e,t,r,i){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,i):new Uint16Array(t,r,i)},i(o)}),r("Core/definedNotNull",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),r("Core/joinUrls",["../ThirdParty/Uri","./defaultValue","./defined","./definedNotNull","./DeveloperError"],function(e,t,r,i,n){"use strict";function o(n,o,a){a=t(a,!0),n instanceof e||(n=new e(n)),o instanceof e||(o=new e(o)),i(o.authority)&&!i(o.scheme)&&("undefined"!=typeof document&&r(document.location)&&r(document.location.href)?o.scheme=new e(document.location.href).scheme:o.scheme=n.scheme);var s=n;o.isAbsolute()&&(s=o);var l="";i(s.scheme)&&(l+=s.scheme+":"),i(s.authority)&&(l+="//"+s.authority,""!==s.path&&(l=l.replace(/\/?$/,"/"),s.path=s.path.replace(/^\/?/g,""))),l+=s===n?a?n.path.replace(/\/?$/,"/")+o.path.replace(/^\/?/g,""):n.path+o.path:o.path;var u=i(n.query),c=i(o.query);u&&c?l+="?"+n.query+"&"+o.query:u&&!c?l+="?"+n.query:!u&&c&&(l+="?"+o.query);var h=i(o.fragment);return i(n.fragment)&&!h?l+="#"+n.fragment:h&&(l+="#"+o.fragment),l}return o}),r("Core/loadArrayBuffer",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,responseType:"arraybuffer",headers:r})}return t}),r("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){
"use strict";var i={};return i.clipTriangleAtAxisAlignedThreshold=function(e,r,i,n,o,a){t(a)?a.length=0:a=[];var s,l,u;r?(s=e>i,l=e>n,u=e>o):(s=i>e,l=n>e,u=o>e);var c,h,d,p,m,f,v=s+l+u;return 1===v?s?(c=(e-i)/(n-i),h=(e-i)/(o-i),a.push(1),a.push(2),1!==h&&(a.push(-1),a.push(0),a.push(2),a.push(h)),1!==c&&(a.push(-1),a.push(0),a.push(1),a.push(c))):l?(d=(e-n)/(o-n),p=(e-n)/(i-n),a.push(2),a.push(0),1!==p&&(a.push(-1),a.push(1),a.push(0),a.push(p)),1!==d&&(a.push(-1),a.push(1),a.push(2),a.push(d))):u&&(m=(e-o)/(i-o),f=(e-o)/(n-o),a.push(0),a.push(1),1!==f&&(a.push(-1),a.push(2),a.push(1),a.push(f)),1!==m&&(a.push(-1),a.push(2),a.push(0),a.push(m))):2===v?s||i===e?l||n===e?u||o===e||(h=(e-i)/(o-i),d=(e-n)/(o-n),a.push(2),a.push(-1),a.push(0),a.push(2),a.push(h),a.push(-1),a.push(1),a.push(2),a.push(d)):(f=(e-o)/(n-o),c=(e-i)/(n-i),a.push(1),a.push(-1),a.push(2),a.push(1),a.push(f),a.push(-1),a.push(0),a.push(1),a.push(c)):(p=(e-n)/(i-n),m=(e-o)/(i-o),a.push(0),a.push(-1),a.push(1),a.push(0),a.push(p),a.push(-1),a.push(2),a.push(0),a.push(m)):3!==v&&(a.push(0),a.push(1),a.push(2)),a},i.computeBarycentricCoordinates=function(r,i,n,o,a,s,l,u,c){var h=n-l,d=l-a,p=s-u,m=o-u,f=1/(p*h+d*m),v=i-u,_=r-l,g=(p*_+d*v)*f,y=(-m*_+h*v)*f,C=1-g-y;return t(c)?(c.x=g,c.y=y,c.z=C,c):new e(g,y,C)},i}),r("Core/QuantizedMeshTerrainData",["../ThirdParty/when","./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./IndexDatatype","./Intersections2D","./Math","./OrientedBoundingBox","./TaskProcessor","./TerrainEncoding","./TerrainMesh"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(e){function t(e,t){return a[e]-a[t]}function r(e,t){return o[e]-o[t]}this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint;var n=this._quantizedVertices.length/3,o=this._uValues=this._quantizedVertices.subarray(0,n),a=this._vValues=this._quantizedVertices.subarray(n,2*n);this._heightValues=this._quantizedVertices.subarray(2*n,3*n),this._westIndices=f(e.westIndices,t,n),this._southIndices=f(e.southIndices,r,n),this._eastIndices=f(e.eastIndices,t,n),this._northIndices=f(e.northIndices,r,n),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=i(e.childTileMask,15),this._createdByUpsampling=i(e.createdByUpsampling,!1),this._waterMask=e.waterMask}function f(e,t,r){v.length=e.length;for(var i=!1,n=0,o=e.length;o>n;++n)v[n]=e[n],i=i||n>0&&t(e[n-1],e[n])>0;return i?(v.sort(t),s.createTypedArray(r,v)):e}o(m.prototype,{waterMask:{get:function(){return this._waterMask}}});var v=[],_=new h("createVerticesFromQuantizedTerrainMesh");m.prototype.createMesh=function(t,r,o,a,l){var u=t.ellipsoid,c=t.tileXYToRectangle(r,o,a);l=i(l,1);var h=_.scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:c,relativeToCenter:this._boundingSphere.center,ellipsoid:u,exaggeration:l});if(n(h)){var m=this;return e(h,function(e){var t=m._quantizedVertices.length/3;t+=m._westIndices.length+m._southIndices.length+m._eastIndices.length+m._northIndices.length;var r=s.createTypedArray(t,e.indices),n=new Float32Array(e.vertices),o=e.center,a=e.minimumHeight,l=e.maximumHeight,u=i(e.boundingSphere,m._boundingSphere),c=i(e.orientedBoundingBox,m._orientedBoundingBox),h=i(e.occludeePointInScaledSpace,m._horizonOcclusionPoint),f=e.vertexStride,v=d.clone(e.encoding);return new p(o,n,r,a,l,u,h,f,c,v)})}};var g=new h("upsampleQuantizedTerrainMesh");m.prototype.upsample=function(i,o,a,l,u,h,d){var p=2*o!==u,f=2*a===h,v=i.ellipsoid,_=i.tileXYToRectangle(u,h,d),y=g.scheduleTask({vertices:this._quantizedVertices,indices:this._indices,encodedNormals:this._encodedNormals,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:p,isNorthChild:f,childRectangle:_,ellipsoid:v});if(n(y)){var C=Math.min(this._westSkirtHeight,this._eastSkirtHeight);C=Math.min(C,this._southSkirtHeight),C=Math.min(C,this._northSkirtHeight);var E=p?.5*C:this._westSkirtHeight,S=f?.5*C:this._southSkirtHeight,w=p?this._eastSkirtHeight:.5*C,T=f?this._northSkirtHeight:.5*C;return e(y,function(e){var i,o=new Uint16Array(e.vertices),a=s.createTypedArray(o.length/3,e.indices);return n(e.encodedNormals)&&(i=new Uint8Array(e.encodedNormals)),new m({quantizedVertices:o,indices:a,encodedNormals:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:t.clone(e.boundingSphere),orientedBoundingBox:c.clone(e.orientedBoundingBox),horizonOcclusionPoint:r.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:E,southSkirtHeight:S,eastSkirtHeight:w,northSkirtHeight:T,childTileMask:0,createdByUpsampling:!0})})}};var y=32767,C=new r;return m.prototype.interpolateHeight=function(e,t,r){var i=u.clamp((t-e.west)/e.width,0,1);i*=y;var n=u.clamp((r-e.south)/e.height,0,1);n*=y;for(var o=this._uValues,a=this._vValues,s=this._heightValues,c=this._indices,h=0,d=c.length;d>h;h+=3){var p=c[h],m=c[h+1],f=c[h+2],v=o[p],_=o[m],g=o[f],E=a[p],S=a[m],w=a[f],T=l.computeBarycentricCoordinates(i,n,v,E,_,S,g,w,C);if(T.x>=-1e-15&&T.y>=-1e-15&&T.z>=-1e-15){var x=T.x*s[p]+T.y*s[m]+T.z*s[f];return u.lerp(this._minimumHeight,this._maximumHeight,x/y)}}},m.prototype.isChildAvailable=function(e,t,r,i){var n=2;return r!==2*e&&++n,i!==2*t&&(n-=2),0!==(this._childTileMask&1<<n)},m.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling},m}),r("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,i=t.name,n=t.message;r=e(i)&&e(n)?i+": "+n:t.toString();var o=t.stack;return e(o)&&(r+="\n"+o),r}return t}),r("Core/TileProviderError",["./defaultValue","./defined","./formatError"],function(e,t,r){"use strict";function i(t,r,i,n,o,a,s){this.provider=t,this.message=r,this.x=i,this.y=n,this.level=o,this.timesRetried=e(a,0),this.retry=!1,this.error=s}return i.handleError=function(e,n,o,a,s,l,u,c,h){var d=e;return t(e)?(d.provider=n,d.message=a,d.x=s,d.y=l,d.level=u,d.retry=!1,d.error=h,++d.timesRetried):d=new i(n,a,s,l,u,0,h),o.numberOfListeners>0?o.raiseEvent(d):console.log('An error occurred in "'+n.constructor.name+'": '+r(a)),d.retry&&t(c)&&c(),d},i.handleSuccess=function(e){t(e)&&(e.timesRetried=-1)},i}),r("Core/CesiumTerrainProvider",["../ThirdParty/Uri","../ThirdParty/when","./BoundingSphere","./Cartesian3","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Event","./GeographicTilingScheme","./HeightmapTerrainData","./IndexDatatype","./joinUrls","./loadArrayBuffer","./loadJson","./Math","./Matrix3","./OrientedBoundingBox","./QuantizedMeshTerrainData","./RuntimeError","./TerrainProvider","./throttleRequestByServer","./TileProviderError"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w){"use strict";function T(r){function i(t){var r;if(!t.format)return r="The tile format is not specified in the layer.json file.",void(m=w.handleError(m,v,v._errorEvent,r,void 0,void 0,void 0,l));if(!t.tiles||0===t.tiles.length)return r="The layer.json file does not specify any tile URL templates.",void(m=w.handleError(m,v,v._errorEvent,r,void 0,void 0,void 0,l));if("heightmap-1.0"===t.format)v._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1},v._hasWaterMask=!0,v._requestWaterMask=!0;else if(0!==t.format.indexOf("quantized-mesh-1."))return r='The tile format "'+t.format+'" is invalid or not supported.',void(m=w.handleError(m,v,v._errorEvent,r,void 0,void 0,void 0,l));v._tileUrlTemplates=t.tiles;for(var i=0;i<v._tileUrlTemplates.length;++i){var o=new e(v._tileUrlTemplates[i]),s=new e(v._url);o.authority&&!s.authority&&(s.authority=o.authority,s.scheme=o.scheme),v._tileUrlTemplates[i]=p(s,o).toString().replace("{version}",t.version)}v._availableTiles=t.available,!a(v._credit)&&a(t.attribution)&&null!==t.attribution&&(v._credit=new n(t.attribution)),a(t.extensions)&&-1!==t.extensions.indexOf("octvertexnormals")?v._hasVertexNormals=!0:a(t.extensions)&&-1!==t.extensions.indexOf("vertexnormals")&&(v._hasVertexNormals=!0,v._littleEndianExtensionSize=!1),a(t.extensions)&&-1!==t.extensions.indexOf("watermask")&&(v._hasWaterMask=!0),v._ready=!0,v._readyPromise.resolve(!0)}function s(e){if(a(e)&&404===e.statusCode)return void i({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]});var t="An error occurred while accessing "+d+".";m=w.handleError(m,v,v._errorEvent,t,void 0,void 0,void 0,l)}function l(){var e=f(d);t(e,i,s)}this._url=r.url,this._proxy=r.proxy,this._tilingScheme=new c({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:r.ellipsoid}),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=E.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._requestVertexNormals=o(r.requestVertexNormals,!1),this._littleEndianExtensionSize=!0,this._requestWaterMask=o(r.requestWaterMask,!1),this._errorEvent=new u;var h=r.credit;"string"==typeof h&&(h=new n(h)),this._credit=h,this._ready=!1,this._readyPromise=t.defer();var d=p(this._url,"layer.json");a(this._proxy)&&(d=this._proxy.getURL(d));var m,v=this;l()}function x(e){if(a(e)&&0!==e.length){var t=e.join("-");return{Accept:"application/vnd.quantized-mesh;extensions="+t+",application/octet-stream;q=0.9,*/*;q=0.01"}}return{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function b(e,t,r,i,n,o){var a=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new h({buffer:a,childTileMask:new Uint8Array(t,a.byteLength,1)[0],waterMask:new Uint8Array(t,a.byteLength+1,t.byteLength-a.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure})}function P(e,t,n,o,a,s){function l(e){return e>>1^-(1&e)}var u=0,c=3,h=c+1,p=Float64Array.BYTES_PER_ELEMENT*c,m=Float64Array.BYTES_PER_ELEMENT*h,f=3,_=Uint16Array.BYTES_PER_ELEMENT*f,C=3,E=Uint16Array.BYTES_PER_ELEMENT,S=E*C,w=new DataView(t),T=new i(w.getFloat64(u,!0),w.getFloat64(u+8,!0),w.getFloat64(u+16,!0));u+=p;var x=w.getFloat32(u,!0);u+=Float32Array.BYTES_PER_ELEMENT;var b=w.getFloat32(u,!0);u+=Float32Array.BYTES_PER_ELEMENT;var P=new r(new i(w.getFloat64(u,!0),w.getFloat64(u+8,!0),w.getFloat64(u+16,!0)),w.getFloat64(u+p,!0));u+=m;var I=new i(w.getFloat64(u,!0),w.getFloat64(u+8,!0),w.getFloat64(u+16,!0));u+=p;var D=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var R=new Uint16Array(t,u,3*D);u+=D*_,D>65536&&(E=Uint32Array.BYTES_PER_ELEMENT,S=E*C);var O,N=R.subarray(0,D),L=R.subarray(D,2*D),F=R.subarray(2*D,3*D),B=0,V=0,z=0;for(O=0;D>O;++O)B+=l(N[O]),V+=l(L[O]),z+=l(F[O]),N[O]=B,L[O]=V,F[O]=z;u%E!==0&&(u+=E-u%E);var k=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var U=d.createTypedArrayFromArrayBuffer(D,t,u,k*C);u+=k*S;var G=0;for(O=0;O<U.length;++O){var W=U[O];U[O]=G-W,0===W&&++G}var H=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var q=d.createTypedArrayFromArrayBuffer(D,t,u,H);u+=H*E;var j=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var Y=d.createTypedArrayFromArrayBuffer(D,t,u,j);u+=j*E;var X=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var Z=d.createTypedArrayFromArrayBuffer(D,t,u,X);u+=X*E;var K=w.getUint32(u,!0);u+=Uint32Array.BYTES_PER_ELEMENT;var Q=d.createTypedArrayFromArrayBuffer(D,t,u,K);u+=K*E;for(var J,$;u<w.byteLength;){var ee=w.getUint8(u,!0);u+=Uint8Array.BYTES_PER_ELEMENT;var te=w.getUint32(u,e._littleEndianExtensionSize);u+=Uint32Array.BYTES_PER_ELEMENT,ee===M.OCT_VERTEX_NORMALS&&e._requestVertexNormals?J=new Uint8Array(t,u,2*D):ee===M.WATER_MASK&&e._requestWaterMask&&($=new Uint8Array(t,u,te)),u+=te}var re,ie=5*e.getLevelMaximumGeometricError(n),ne=e._tilingScheme.tileXYToRectangle(o,a,n);return ne.width<v.PI_OVER_TWO+v.EPSILON5&&(re=g.fromRectangle(ne,x,b,e._tilingScheme.ellipsoid)),new y({center:T,minimumHeight:x,maximumHeight:b,boundingSphere:P,orientedBoundingBox:re,horizonOcclusionPoint:I,quantizedVertices:R,encodedNormals:J,indices:U,westIndices:q,southIndices:Y,eastIndices:Z,northIndices:Q,westSkirtHeight:ie,southSkirtHeight:ie,eastSkirtHeight:ie,northSkirtHeight:ie,childTileMask:A(e,n,o,s),waterMask:$})}function A(e,t,r,i){var n=e._availableTiles;if(!n||0===n.length)return 15;var o=t+1;if(o>=n.length)return 0;var a=n[o],s=0;return s|=I(a,2*r,2*i)?1:0,s|=I(a,2*r+1,2*i)?2:0,s|=I(a,2*r,2*i+1)?4:0,s|=I(a,2*r+1,2*i+1)?8:0}function I(e,t,r){for(var i=0,n=e.length;n>i;++i){var o=e[i];if(t>=o.startX&&t<=o.endX&&r>=o.startY&&r<=o.endY)return!0}return!1}var M={OCT_VERTEX_NORMALS:1,WATER_MASK:2};return T.prototype.requestTileGeometry=function(e,r,i,n){function s(e){return m(e,x(f))}var l=this._tileUrlTemplates;if(0!==l.length){var u=this._tilingScheme.getNumberOfYTilesAtLevel(i),c=u-r-1,h=l[(e+c+i)%l.length].replace("{z}",i).replace("{x}",e).replace("{y}",c),d=this._proxy;a(d)&&(h=d.getURL(h));var p,f=[];if(this._requestVertexNormals&&this._hasVertexNormals&&f.push(this._littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),this._requestWaterMask&&this._hasWaterMask&&f.push("watermask"),n=o(n,!0)){if(p=S(h,s),!a(p))return}else p=s(h);var v=this;return t(p,function(t){return a(v._heightmapStructure)?b(v,t,i,e,r,c):P(v,t,i,e,r,c)})}},s(T.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}}}),T.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},T.prototype.getTileDataAvailable=function(e,t,r){var i=this._availableTiles;if(i&&0!==i.length){if(r>=i.length)return!1;var n=i[r],o=this._tilingScheme.getNumberOfYTilesAtLevel(r),a=o-t-1;return I(n,e,a)}},T}),r("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,i){"use strict";function n(t,n,o,c,h,d,p,m,f,v){var _=t+n;e.multiplyByScalar(c,Math.cos(_),a),e.multiplyByScalar(o,Math.sin(_),s),e.add(a,s,a);var g=Math.cos(t);g*=g;var y=Math.sin(t);y*=y;var C=d/Math.sqrt(p*g+h*y),E=C/m;return i.fromAxisAngle(a,E,l),r.fromQuaternion(l,u),r.multiplyByVector(u,f,v),e.normalize(v,v),e.multiplyByScalar(v,m,v),v}var o={},a=new e,s=new e,l=new i,u=new r,c=new e,h=new e,d=new e,p=new e;o.raisePositionsToHeight=function(t,r,i){for(var n=r.ellipsoid,o=r.height,a=r.extrudedHeight,s=i?t.length/3*2:t.length/3,l=new Float64Array(3*s),u=t.length,m=i?u:0,f=0;u>f;f+=3){var v=f+1,_=f+2,g=e.fromArray(t,f,c);n.scaleToGeodeticSurface(g,g);var y=e.clone(g,h),C=n.geodeticSurfaceNormal(g,p),E=e.multiplyByScalar(C,o,d);e.add(g,E,g),i&&(e.multiplyByScalar(C,a,E),e.add(y,E,y),l[f+m]=y.x,l[v+m]=y.y,l[_+m]=y.z),l[f]=g.x,l[v]=g.y,l[_]=g.z}return l};var m=new e,f=new e,v=new e;return o.computeEllipsePositions=function(r,i,o){var a=r.semiMinorAxis,s=r.semiMajorAxis,l=r.rotation,u=r.center,p=8*r.granularity,_=a*a,g=s*s,y=s*a,C=e.magnitude(u),E=e.normalize(u,m),S=e.cross(e.UNIT_Z,u,f);S=e.normalize(S,S);var w=e.cross(E,S,v),T=1+Math.ceil(t.PI_OVER_TWO/p),x=t.PI_OVER_TWO/(T-1),b=t.PI_OVER_TWO-T*x;0>b&&(T-=Math.ceil(Math.abs(b)/x));var P,A,I,M,D,R=2*(T*(T+2)),O=i?new Array(3*R):void 0,N=0,L=c,F=h,B=4*T*3,V=B-1,z=0,k=o?new Array(B):void 0;for(b=t.PI_OVER_TWO,L=n(b,l,w,S,_,y,g,C,E,L),i&&(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z),o&&(k[V--]=L.z,k[V--]=L.y,k[V--]=L.x),b=t.PI_OVER_TWO-x,P=1;T+1>P;++P){if(L=n(b,l,w,S,_,y,g,C,E,L),F=n(Math.PI-b,l,w,S,_,y,g,C,E,F),i){for(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z,I=2*P+2,A=1;I-1>A;++A)M=A/(I-1),D=e.lerp(L,F,M,d),O[N++]=D.x,O[N++]=D.y,O[N++]=D.z;O[N++]=F.x,O[N++]=F.y,O[N++]=F.z}o&&(k[V--]=L.z,k[V--]=L.y,k[V--]=L.x,k[z++]=F.x,k[z++]=F.y,k[z++]=F.z),b=t.PI_OVER_TWO-(P+1)*x}for(P=T;P>1;--P){if(b=t.PI_OVER_TWO-(P-1)*x,L=n(-b,l,w,S,_,y,g,C,E,L),F=n(b+Math.PI,l,w,S,_,y,g,C,E,F),i){for(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z,I=2*(P-1)+2,A=1;I-1>A;++A)M=A/(I-1),D=e.lerp(L,F,M,d),O[N++]=D.x,O[N++]=D.y,O[N++]=D.z;O[N++]=F.x,O[N++]=F.y,O[N++]=F.z}o&&(k[V--]=L.z,k[V--]=L.y,k[V--]=L.x,k[z++]=F.x,k[z++]=F.y,k[z++]=F.z)}b=t.PI_OVER_TWO,L=n(-b,l,w,S,_,y,g,C,E,L);var U={};return i&&(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z,U.positions=O,U.numPts=T),o&&(k[V--]=L.z,k[V--]=L.y,k[V--]=L.x,U.outerPositions=k),U},o}),r("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,i){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=i.clone(e(t.modelMatrix,i.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return n}),r("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}i.encode=function(e,r){t(r)||(r={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),r.high=i,r.low=e-i):(i=65536*Math.floor(-e/65536),r.high=-i,r.low=e+i),r};var n={high:0,low:0};i.fromCartesian=function(e,r){t(r)||(r=new i);var o=r.high,a=r.low;return i.encode(e.x,n),o.x=n.high,a.x=n.low,i.encode(e.y,n),o.y=n.high,a.y=n.low,i.encode(e.z,n),o.z=n.high,a.z=n.low,r};var o=new i;return i.writeElements=function(e,t,r){i.fromCartesian(e,o);var n=o.high,a=o.low;t[r]=n.x,t[r+1]=n.y,t[r+2]=n.z,t[r+3]=a.x,t[r+4]=a.y,t[r+5]=a.z},i}),r("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var i=r.indices,n=r.maximumIndex,o=e(r.cacheSize,24),a=i.length;if(!t(n)){n=0;for(var s=0,l=i[s];a>s;)l>n&&(n=l),++s,l=i[s]}for(var u=[],c=0;n+1>c;c++)u[c]=0;for(var h=o+1,d=0;a>d;++d)h-u[i[d]]>o&&(u[i[d]]=h,++h);return(h-o+1)/(a/3)},i.tipsify=function(r){function i(e,t,r,i){for(;t.length>=1;){var n=t[t.length-1];if(t.splice(t.length-1,1),e[n].numLiveTriangles>0)return n}for(;i>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function n(e,t,r,n,o,a,s){for(var l,u=-1,c=-1,h=0;h<r.length;){var d=r[h];n[d].numLiveTriangles&&(l=0,o-n[d].timeStamp+2*n[d].numLiveTriangles<=t&&(l=o-n[d].timeStamp),(l>c||-1===c)&&(c=l,u=d)),++h}return-1===u?i(n,a,e,s):u}r=e(r,e.EMPTY_OBJECT);var o,a=r.indices,s=r.maximumIndex,l=e(r.cacheSize,24),u=a.length,c=0,h=0,d=a[h],p=u;if(t(s))c=s+1;else{for(;p>h;)d>c&&(c=d),++h,d=a[h];if(-1===c)return 0;++c}for(var m=[],f=0;c>f;f++)m[f]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var v=0;p>h;)m[a[h]].vertexTriangles.push(v),++m[a[h]].numLiveTriangles,m[a[h+1]].vertexTriangles.push(v),++m[a[h+1]].numLiveTriangles,m[a[h+2]].vertexTriangles.push(v),++m[a[h+2]].numLiveTriangles,++v,h+=3;var _=0,g=l+1;o=1;var y,C,E=[],S=[],w=0,T=[],x=u/3,b=[];for(f=0;x>f;f++)b[f]=!1;for(var P,A;-1!==_;){E=[],C=m[_],A=C.vertexTriangles.length;for(var I=0;A>I;++I)if(v=C.vertexTriangles[I],!b[v]){b[v]=!0,h=v+v+v;for(var M=0;3>M;++M)P=a[h],E.push(P),S.push(P),T[w]=P,++w,y=m[P],--y.numLiveTriangles,g-y.timeStamp>l&&(y.timeStamp=g,++g),++h}_=n(a,l,E,m,g,S,c)}return T},i}),r("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x){"use strict";function b(e,t,r,i,n){e[t++]=r,e[t++]=i,e[t++]=i,e[t++]=n,e[t++]=n,e[t]=r}function P(e){for(var t=e.length,r=t/3*6,i=_.createTypedArray(t,r),n=0,o=0;t>o;o+=3,n+=6)b(i,n,e[o],e[o+1],e[o+2]);return i}function A(e){var t=e.length;if(t>=3){var r=6*(t-2),i=_.createTypedArray(t,r);b(i,0,e[0],e[1],e[2]);for(var n=6,o=3;t>o;++o,n+=6)b(i,n,e[o-1],e[o],e[o-2]);return i}return new Uint16Array}function I(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),i=_.createTypedArray(t,r),n=e[0],o=0,a=1;t>a;++a,o+=6)b(i,o,n,e[a],e[a+1]);return i}return new Uint16Array}function M(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&u(e[r])&&u(e[r].values)){var i=e[r];t[r]=new m({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function D(e,t,r){for(var i in t)if(t.hasOwnProperty(i)&&u(t[i])&&u(t[i].values))for(var n=t[i],o=0;o<n.componentsPerAttribute;++o)e[i].values.push(n.values[r*n.componentsPerAttribute+o])}function R(e,t){if(u(t))for(var r=t.values,i=r.length,o=0;i>o;o+=3)n.unpack(r,o,oe),S.multiplyByPoint(e,oe,oe),n.pack(oe,r,o)}function O(e,t){if(u(t))for(var r=t.values,i=r.length,o=0;i>o;o+=3)n.unpack(r,o,oe),E.multiplyByVector(e,oe,oe),oe=n.normalize(oe,oe),n.pack(oe,r,o)}function N(e,t){var r,i=e.length,n={},o=e[0][t].attributes;for(r in o)if(o.hasOwnProperty(r)&&u(o[r])&&u(o[r].values)){for(var a=o[r],l=a.values.length,c=!0,h=1;i>h;++h){var d=e[h][t].attributes[r];if(!u(d)||a.componentDatatype!==d.componentDatatype||a.componentsPerAttribute!==d.componentsPerAttribute||a.normalize!==d.normalize){c=!1;break}l+=d.values.length}c&&(n[r]=new m({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:s.createTypedArray(a.componentDatatype,l)}))}return n}function L(e,t){var i,o,a,s,l,c,h,d=e.length,m=(e[0].modelMatrix,u(e[0][t].indices)),f=e[0][t].primitiveType,v=N(e,t);for(i in v)if(v.hasOwnProperty(i))for(l=v[i].values,s=0,o=0;d>o;++o)for(c=e[o][t].attributes[i].values,h=c.length,a=0;h>a;++a)l[s++]=c[a];var g;if(m){var y=0;for(o=0;d>o;++o)y+=e[o][t].indices.length;var C=p.computeNumberOfVertices(new p({attributes:v,primitiveType:T.POINTS})),E=_.createTypedArray(C,y),S=0,w=0;for(o=0;d>o;++o){var x=e[o][t].indices,b=x.length;for(s=0;b>s;++s)E[S++]=w+x[s];w+=p.computeNumberOfVertices(e[o][t])}g=E}var P,A=new n,I=0;for(o=0;d>o;++o){if(P=e[o][t].boundingSphere,!u(P)){A=void 0;break}n.add(P.center,A,A)}if(u(A))for(n.divideByScalar(A,d,A),o=0;d>o;++o){P=e[o][t].boundingSphere;var M=n.magnitude(n.subtract(P.center,A,le))+P.radius;M>I&&(I=M)}return new p({attributes:v,indices:g,primitiveType:f,boundingSphere:u(A)?new r(A,I):void 0})}function F(e){if(u(e.indices))return e;for(var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,t),i=0;t>i;++i)r[i]=i;return e.indices=r,e}function B(e){var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,n=3;t>n;++n)r[i++]=n-1,r[i++]=0,r[i++]=n;return e.indices=r,e.primitiveType=T.TRIANGLES,e}function V(e){var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,n=3;t-1>n;n+=2)r[i++]=n,r[i++]=n-1,r[i++]=n+1,t>n+2&&(r[i++]=n,r[i++]=n+1,r[i++]=n+2);return e.indices=r,e.primitiveType=T.TRIANGLES,e}function z(e){if(u(e.indices))return e;for(var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,t),i=0;t>i;++i)r[i]=i;return e.indices=r,e}function k(e){var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,n=2;t>n;++n)r[i++]=n-1,r[i++]=n;return e.indices=r,e.primitiveType=T.LINES,e}function U(e){var t=p.computeNumberOfVertices(e),r=_.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,n=2;t>n;++n)r[i++]=n-1,r[i++]=n;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=T.LINES,e}function G(e){switch(e.primitiveType){case T.TRIANGLE_FAN:return B(e);case T.TRIANGLE_STRIP:return V(e);case T.TRIANGLES:return F(e);case T.LINE_STRIP:return k(e);case T.LINE_LOOP:return U(e);case T.LINES:return z(e)}return e}function W(e,t){Math.abs(e.y)<C.EPSILON6&&(t?e.y=-C.EPSILON6:e.y=C.EPSILON6)}function H(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return W(e,e.y<0),W(t,t.y<0),void W(r,r.y<0);var i,n=Math.abs(e.y),o=Math.abs(t.y),a=Math.abs(r.y);i=n>o?n>a?C.sign(e.y):C.sign(r.y):o>a?C.sign(t.y):C.sign(r.y);var s=0>i;W(e,s),W(t,s),W(r,s)}function q(e,t,r,i){n.add(e,n.multiplyByScalar(n.subtract(t,e,Ce),e.y/(e.y-t.y),Ce),r),n.clone(r,i),W(r,!0),W(i,!1)}function j(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){H(e,t,r);var i=e.y<0,n=t.y<0,o=r.y<0,a=0;a+=i?1:0,a+=n?1:0,a+=o?1:0;var s=xe.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,i?(q(e,t,Ee,we),q(e,r,Se,Te),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(q(t,r,Ee,we),q(t,e,Se,Te),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(q(r,e,Ee,we),q(r,t,Se,Te),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,i?n?o||(q(r,e,Ee,we),q(r,t,Se,Te),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(q(t,r,Ee,we),q(t,e,Se,Te),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(q(e,t,Ee,we),q(e,r,Se,Te),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var l=xe.positions;return l[0]=e,l[1]=t,l[2]=r,l.length=3,(1===a||2===a)&&(l[3]=Ee,l[4]=Se,l[5]=we,l[6]=Te,l.length=7),xe}}function Y(e,t){var i=e.attributes;if(0!==i.position.values.length){for(var n in i)if(i.hasOwnProperty(n)&&u(i[n])&&u(i[n].values)){var o=i[n];o.values=s.createTypedArray(o.componentDatatype,o.values)}var a=p.computeNumberOfVertices(e);return e.indices=_.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(i.position.values)),e}}function X(e){var t=e.attributes,r={};for(var i in t)if(t.hasOwnProperty(i)&&u(t[i])&&u(t[i].values)){var n=t[i];r[i]=new m({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return new p({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var i=u(e.geometry.boundingSphere);t=Y(t,i),r=Y(r,i),u(r)&&!u(t)?e.geometry=r:!u(r)&&u(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function K(e,r,o,a,s,l,c,h,d,p,m){if(u(l)||u(c)||u(h)||u(d)){var f=n.fromArray(s,3*e,be),v=n.fromArray(s,3*r,Pe),_=n.fromArray(s,3*o,Ae),g=t(a,f,v,_,Ie);if(u(l)){var y=n.fromArray(l,3*e,be),C=n.fromArray(l,3*r,Pe),E=n.fromArray(l,3*o,Ae);n.multiplyByScalar(y,g.x,y),n.multiplyByScalar(C,g.y,C),n.multiplyByScalar(E,g.z,E);var S=n.add(y,C,y);n.add(S,E,S),n.normalize(S,S),n.pack(S,p.normal.values,3*m)}if(u(c)){var w=n.fromArray(c,3*e,be),T=n.fromArray(c,3*r,Pe),x=n.fromArray(c,3*o,Ae);n.multiplyByScalar(w,g.x,w),n.multiplyByScalar(T,g.y,T),n.multiplyByScalar(x,g.z,x);var b=n.add(w,T,w);n.add(b,x,b),n.normalize(b,b),n.pack(b,p.binormal.values,3*m)}if(u(h)){var P=n.fromArray(h,3*e,be),A=n.fromArray(h,3*r,Pe),I=n.fromArray(h,3*o,Ae);n.multiplyByScalar(P,g.x,P),n.multiplyByScalar(A,g.y,A),n.multiplyByScalar(I,g.z,I);var M=n.add(P,A,P);n.add(M,I,M),n.normalize(M,M),n.pack(M,p.tangent.values,3*m)}if(u(d)){var D=i.fromArray(d,2*e,Me),R=i.fromArray(d,2*r,De),O=i.fromArray(d,2*o,Re);i.multiplyByScalar(D,g.x,D),i.multiplyByScalar(R,g.y,R),i.multiplyByScalar(O,g.z,O);var N=i.add(D,R,D);i.add(N,O,N),i.pack(N,p.st.values,2*m)}}}function Q(e,t,r,i,n,o){var a=e.position.values.length/3;if(-1!==n){var s=i[n],l=r[s];return-1===l?(r[s]=a,e.position.values.push(o.x,o.y,o.z),t.push(a),a):(t.push(l),l)}return e.position.values.push(o.x,o.y,o.z),t.push(a),a}function J(e){var t,r,i,o,a,s=e.geometry,l=s.attributes,c=l.position.values,h=u(l.normal)?l.normal.values:void 0,d=u(l.binormal)?l.binormal.values:void 0,p=u(l.tangent)?l.tangent.values:void 0,m=u(l.st)?l.st.values:void 0,f=s.indices,v=X(s),_=X(s),g=[];g.length=c.length/3;var y=[];for(y.length=c.length/3,a=0;a<g.length;++a)g[a]=-1,y[a]=-1;var C=f.length;for(a=0;C>a;a+=3){var E=f[a],S=f[a+1],w=f[a+2],T=n.fromArray(c,3*E),x=n.fromArray(c,3*S),b=n.fromArray(c,3*w),P=j(T,x,b);if(u(P)&&P.positions.length>3)for(var A=P.positions,I=P.indices,M=I.length,D=0;M>D;++D){var R=I[D],O=A[R];O.y<0?(t=_.attributes,r=_.indices,i=g):(t=v.attributes,r=v.indices,i=y),o=Q(t,r,i,f,3>R?a+R:-1,O),K(E,S,w,O,c,h,d,p,m,t,o)}else u(P)&&(T=P.positions[0],x=P.positions[1],b=P.positions[2]),T.y<0?(t=_.attributes,r=_.indices,i=g):(t=v.attributes,r=v.indices,i=y),o=Q(t,r,i,f,a,T),K(E,S,w,T,c,h,d,p,m,t,o),o=Q(t,r,i,f,a+1,x),K(E,S,w,x,c,h,d,p,m,t,o),o=Q(t,r,i,f,a+2,b),K(E,S,w,b,c,h,d,p,m,t,o)}Z(e,_,v)}function $(e){var t,r=e.geometry,i=r.attributes,o=i.position.values,a=r.indices,s=X(r),l=X(r),c=a.length,h=[];h.length=o.length/3;var d=[];for(d.length=o.length/3,t=0;t<h.length;++t)h[t]=-1,d[t]=-1;for(t=0;c>t;t+=2){var p=a[t],m=a[t+1],f=n.fromArray(o,3*p,be),v=n.fromArray(o,3*m,Pe);Math.abs(f.y)<C.EPSILON6&&(f.y<0?f.y=-C.EPSILON6:f.y=C.EPSILON6),Math.abs(v.y)<C.EPSILON6&&(v.y<0?v.y=-C.EPSILON6:v.y=C.EPSILON6);var _=s.attributes,g=s.indices,E=d,S=l.attributes,w=l.indices,T=h,x=y.lineSegmentPlane(f,v,Oe,Ae);if(u(x)){var b=n.multiplyByScalar(n.UNIT_Y,5*C.EPSILON9,Ne);f.y<0&&(n.negate(b,b),_=l.attributes,g=l.indices,E=h,S=s.attributes,w=s.indices,T=d);var P=n.add(x,b,Le);Q(_,g,E,a,t,f),Q(_,g,E,a,-1,P),n.negate(b,b),n.add(x,b,P),Q(S,w,T,a,-1,P),Q(S,w,T,a,t+1,v)}else{var A,I,M;f.y<0?(A=l.attributes,I=l.indices,M=h):(A=s.attributes,I=s.indices,M=d),Q(A,I,M,a,t,f),Q(A,I,M,a,t+1,v)}}Z(e,l,s)}function ee(e){var t,r,a,s=e.geometry,l=s.attributes,c=l.position.values,h=l.prevPosition.values,d=l.nextPosition.values,p=l.expandAndWidth.values,m=u(l.st)?l.st.values:void 0,f=u(l.color)?l.color.values:void 0,v=X(s),_=X(s),g=c.length/3;for(t=0;g>t;t+=4){var E=t,S=t+1,w=t+2,T=t+3,x=n.fromArray(c,3*E,Ve),b=n.fromArray(c,3*S,ze),P=n.fromArray(c,3*w,ke),A=n.fromArray(c,3*T,Ue);Math.abs(x.y)<C.EPSILON6&&(x.y=C.EPSILON6*(P.y<0?-1:1),b.y=x.y),Math.abs(P.y)<C.EPSILON6&&(P.y=C.EPSILON6*(x.y<0?-1:1),A.y=P.y);var I=v.attributes,M=v.indices,D=_.attributes,R=_.indices,O=y.lineSegmentPlane(x,P,Oe,Ge);if(u(O)){var N=n.multiplyByScalar(n.UNIT_Y,5*C.EPSILON9,We);x.y<0&&(n.negate(N,N),I=_.attributes,M=_.indices,D=v.attributes,R=v.indices);var L=n.add(O,N,He);for(I.position.values.push(x.x,x.y,x.z,b.x,b.y,b.z),I.position.values.push(L.x,L.y,L.z),I.position.values.push(L.x,L.y,L.z),n.negate(N,N),n.add(O,N,L),D.position.values.push(L.x,L.y,L.z),D.position.values.push(L.x,L.y,L.z),D.position.values.push(P.x,P.y,P.z,A.x,A.y,A.z),r=3*E;3*E+6>r;++r)I.prevPosition.values.push(h[r]);for(I.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),D.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),r=3*w;3*w+6>r;++r)D.prevPosition.values.push(h[r]);for(r=3*E;3*E+6>r;++r)I.nextPosition.values.push(d[r]);for(I.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),D.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),r=3*w;3*w+6>r;++r)D.nextPosition.values.push(d[r]);var F=i.fromArray(p,2*E,Fe),B=Math.abs(F.y);I.expandAndWidth.values.push(-1,B,1,B),I.expandAndWidth.values.push(-1,-B,1,-B),D.expandAndWidth.values.push(-1,B,1,B),D.expandAndWidth.values.push(-1,-B,1,-B);var V=n.magnitudeSquared(n.subtract(O,x,Ue));if(V/=n.magnitudeSquared(n.subtract(P,x,Ue)),u(f)){var z=o.fromArray(f,4*E,qe),k=o.fromArray(f,4*w,qe),U=C.lerp(z.x,k.x,V),G=C.lerp(z.y,k.y,V),W=C.lerp(z.z,k.z,V),H=C.lerp(z.w,k.w,V);for(r=4*E;4*E+8>r;++r)I.color.values.push(f[r]);for(I.color.values.push(U,G,W,H),
I.color.values.push(U,G,W,H),D.color.values.push(U,G,W,H),D.color.values.push(U,G,W,H),r=4*w;4*w+8>r;++r)D.color.values.push(f[r])}if(u(m)){var q=i.fromArray(m,2*E,Fe),j=i.fromArray(m,2*(t+3),Be),Y=C.lerp(q.x,j.x,V);for(r=2*E;2*E+4>r;++r)I.st.values.push(m[r]);for(I.st.values.push(Y,q.y),I.st.values.push(Y,j.y),D.st.values.push(Y,q.y),D.st.values.push(Y,j.y),r=2*w;2*w+4>r;++r)D.st.values.push(m[r])}a=I.position.values.length/3-4,M.push(a,a+2,a+1),M.push(a+1,a+2,a+3),a=D.position.values.length/3-4,R.push(a,a+2,a+1),R.push(a+1,a+2,a+3)}else{var K,Q;for(x.y<0?(K=_.attributes,Q=_.indices):(K=v.attributes,Q=v.indices),K.position.values.push(x.x,x.y,x.z),K.position.values.push(b.x,b.y,b.z),K.position.values.push(P.x,P.y,P.z),K.position.values.push(A.x,A.y,A.z),r=3*t;3*t+12>r;++r)K.prevPosition.values.push(h[r]),K.nextPosition.values.push(d[r]);for(r=2*t;2*t+8>r;++r)K.expandAndWidth.values.push(p[r]),u(m)&&K.st.values.push(m[r]);if(u(f))for(r=4*t;4*t+16>r;++r)K.color.values.push(f[r]);a=K.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,_,v)}var te={};te.toWireframe=function(e){var t=e.indices;if(u(t)){switch(e.primitiveType){case T.TRIANGLES:e.indices=P(t);break;case T.TRIANGLE_STRIP:e.indices=A(t);break;case T.TRIANGLE_FAN:e.indices=I(t);break;default:throw new c("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=T.LINES}return e},te.createLineSegmentsForVectors=function(e,t,i){t=l(t,"normal"),i=l(i,1e4);for(var n=e.attributes.position.values,o=e.attributes[t].values,a=n.length,c=new Float64Array(2*a),h=0,d=0;a>d;d+=3)c[h++]=n[d],c[h++]=n[d+1],c[h++]=n[d+2],c[h++]=n[d]+o[d]*i,c[h++]=n[d+1]+o[d+1]*i,c[h++]=n[d+2]+o[d+2]*i;var f,v=e.boundingSphere;return u(v)&&(f=new r(v.center,v.radius+i)),new p({attributes:{position:new m({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:T.LINES,boundingSphere:f})},te.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],i=e.attributes,n={},o=0,a=r.length;for(t=0;a>t;++t){var s=r[t];u(i[s])&&(n[s]=o++)}for(var l in i)i.hasOwnProperty(l)&&!u(n[l])&&(n[l]=o++);return n},te.reorderForPreVertexCache=function(e){var t=p.computeNumberOfVertices(e),r=e.indices;if(u(r)){for(var i=new Int32Array(t),n=0;t>n;n++)i[n]=-1;for(var o,a=r,l=a.length,c=_.createTypedArray(t,l),h=0,d=0,m=0;l>h;)o=i[a[h]],-1!==o?c[d]=o:(o=a[h],i[o]=m,c[d]=m,++m),++h,++d;e.indices=c;var f=e.attributes;for(var v in f)if(f.hasOwnProperty(v)&&u(f[v])&&u(f[v].values)){for(var g=f[v],y=g.values,C=0,E=g.componentsPerAttribute,S=s.createTypedArray(g.componentDatatype,m*E);t>C;){var w=i[C];if(-1!==w)for(n=0;E>n;n++)S[E*w+n]=y[E*C+n];++C}g.values=S}}return e},te.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===T.TRIANGLES&&u(r)){for(var i=r.length,n=0,o=0;i>o;o++)r[o]>n&&(n=r[o]);e.indices=x.tipsify({indices:r,maximumIndex:n,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){var t=[],r=p.computeNumberOfVertices(e);if(u(e.indices)&&r>=C.SIXTY_FOUR_KILOBYTES){var i,n=[],o=[],a=0,s=M(e.attributes),l=e.indices,c=l.length;e.primitiveType===T.TRIANGLES?i=3:e.primitiveType===T.LINES?i=2:e.primitiveType===T.POINTS&&(i=1);for(var h=0;c>h;h+=i){for(var d=0;i>d;++d){var m=l[h+d],f=n[m];u(f)||(f=a++,n[m]=f,D(s,e.attributes,m)),o.push(f)}a+i>=C.SIXTY_FOUR_KILOBYTES&&(t.push(new p({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],o=[],a=0,s=M(e.attributes))}0!==o.length&&t.push(new p({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new n,ie=new a;te.projectTo2D=function(e,t,r,i,o){var a=e.attributes[t];o=u(o)?o:new d;for(var l=o.ellipsoid,h=a.values,p=new Float64Array(h.length),f=0,v=0;v<h.length;v+=3){var _=n.fromArray(h,v,re),g=l.cartesianToCartographic(_,ie);if(!u(g))throw new c("Could not project point ("+_.x+", "+_.y+", "+_.z+") to 2D.");var y=o.project(g,re);p[f++]=y.x,p[f++]=y.y,p[f++]=y.z}return e.attributes[r]=a,e.attributes[i]=new m({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:p}),delete e.attributes[t],e};var ne={high:0,low:0};te.encodeAttribute=function(e,t,r,i){for(var n=e.attributes[t],o=n.values,a=o.length,l=new Float32Array(a),u=new Float32Array(a),c=0;a>c;++c)h.encode(o[c],ne),l[c]=ne.high,u[c]=ne.low;var d=n.componentsPerAttribute;return e.attributes[r]=new m({componentDatatype:s.FLOAT,componentsPerAttribute:d,values:l}),e.attributes[i]=new m({componentDatatype:s.FLOAT,componentsPerAttribute:d,values:u}),delete e.attributes[t],e};var oe=new n,ae=new S,se=new E;te.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(S.equals(t,S.IDENTITY))return e;var i=e.geometry.attributes;R(t,i.position),R(t,i.prevPosition),R(t,i.nextPosition),(u(i.normal)||u(i.binormal)||u(i.tangent))&&(S.inverse(t,ae),S.transpose(ae,ae),S.getRotation(ae,se),O(se,i.normal),O(se,i.binormal),O(se,i.tangent));var n=e.geometry.boundingSphere;return u(n)&&(e.geometry.boundingSphere=r.transform(n,t,n)),e.modelMatrix=S.clone(S.IDENTITY),e};var le=new n;te.combineInstances=function(e){for(var t=[],r=[],i=e.length,n=0;i>n;++n){var o=e[n];u(o.geometry)?t.push(o):r.push(o)}var a=[];return t.length>0&&a.push(L(t,"geometry")),r.length>0&&(a.push(L(r,"westHemisphereGeometry")),a.push(L(r,"eastHemisphereGeometry"))),a};var ue=new n,ce=new n,he=new n,de=new n;te.computeNormal=function(e){for(var t=e.indices,r=e.attributes,i=r.position.values,o=r.position.values.length/3,a=t.length,l=new Array(o),u=new Array(a/3),c=new Array(a),h=0;o>h;h++)l[h]={indexOffset:0,count:0,currentCount:0};var d=0;for(h=0;a>h;h+=3){var p=t[h],f=t[h+1],v=t[h+2],_=3*p,g=3*f,y=3*v;ce.x=i[_],ce.y=i[_+1],ce.z=i[_+2],he.x=i[g],he.y=i[g+1],he.z=i[g+2],de.x=i[y],de.y=i[y+1],de.z=i[y+2],l[p].count++,l[f].count++,l[v].count++,n.subtract(he,ce,he),n.subtract(de,ce,de),u[d]=n.cross(he,de,new n),d++}var C=0;for(h=0;o>h;h++)l[h].indexOffset+=C,C+=l[h].count;d=0;var E;for(h=0;a>h;h+=3){E=l[t[h]];var S=E.indexOffset+E.currentCount;c[S]=d,E.currentCount++,E=l[t[h+1]],S=E.indexOffset+E.currentCount,c[S]=d,E.currentCount++,E=l[t[h+2]],S=E.indexOffset+E.currentCount,c[S]=d,E.currentCount++,d++}var w=new Float32Array(3*o);for(h=0;o>h;h++){var T=3*h;if(E=l[h],E.count>0){for(n.clone(n.ZERO,ue),d=0;d<E.count;d++)n.add(ue,u[c[E.indexOffset+d]],ue);n.normalize(ue,ue),w[T]=ue.x,w[T+1]=ue.y,w[T+2]=ue.z}else w[T]=0,w[T+1]=0,w[T+2]=1}return e.attributes.normal=new m({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:w}),e};var pe=new n,me=new n,fe=new n;te.computeBinormalAndTangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,i=e.attributes.normal.values,o=e.attributes.st.values,a=e.attributes.position.values.length/3,l=t.length,u=new Array(3*a),c=0;c<u.length;c++)u[c]=0;var h,d,p;for(c=0;l>c;c+=3){var f=t[c],v=t[c+1],_=t[c+2];h=3*f,d=3*v,p=3*_;var g=2*f,y=2*v,C=2*_,E=r[h],S=r[h+1],w=r[h+2],T=o[g],x=o[g+1],b=o[y+1]-x,P=o[C+1]-x,A=1/((o[y]-T)*P-(o[C]-T)*b),I=(P*(r[d]-E)-b*(r[p]-E))*A,M=(P*(r[d+1]-S)-b*(r[p+1]-S))*A,D=(P*(r[d+2]-w)-b*(r[p+2]-w))*A;u[h]+=I,u[h+1]+=M,u[h+2]+=D,u[d]+=I,u[d+1]+=M,u[d+2]+=D,u[p]+=I,u[p+1]+=M,u[p+2]+=D}var R=new Float32Array(3*a),O=new Float32Array(3*a);for(c=0;a>c;c++){h=3*c,d=h+1,p=h+2;var N=n.fromArray(i,h,pe),L=n.fromArray(u,h,fe),F=n.dot(N,L);n.multiplyByScalar(N,F,me),n.normalize(n.subtract(L,me,L),L),O[h]=L.x,O[d]=L.y,O[p]=L.z,n.normalize(n.cross(N,L,L),L),R[h]=L.x,R[d]=L.y,R[p]=L.z}return e.attributes.tangent=new m({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:O}),e.attributes.binormal=new m({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:R}),e};var ve=new i,_e=new n,ge=new n,ye=new n;te.compressVertices=function(t){var r=t.attributes.normal,o=t.attributes.st;if(!u(r)&&!u(o))return t;var a,l,c,h,d=t.attributes.tangent,p=t.attributes.binormal;u(r)&&(a=r.values),u(o)&&(l=o.values),u(d)&&(c=d.values),p&&(h=p.values);var f=u(a)?a.length:l.length,v=u(a)?3:2,_=f/v,g=_,y=u(l)&&u(a)?2:1;y+=u(c)||u(h)?1:0,g*=y;for(var C=new Float32Array(g),E=0,S=0;_>S;++S){u(l)&&(i.fromArray(l,2*S,ve),C[E++]=e.compressTextureCoordinates(ve));var w=3*S;u(a)&&u(c)&&u(h)?(n.fromArray(a,w,_e),n.fromArray(c,w,ge),n.fromArray(h,w,ye),e.octPack(_e,ge,ye,ve),C[E++]=ve.x,C[E++]=ve.y):(u(a)&&(n.fromArray(a,w,_e),C[E++]=e.octEncodeFloat(_e)),u(c)&&(n.fromArray(c,w,_e),C[E++]=e.octEncodeFloat(_e)),u(h)&&(n.fromArray(h,w,_e),C[E++]=e.octEncodeFloat(_e)))}return t.attributes.compressedAttributes=new m({componentDatatype:s.FLOAT,componentsPerAttribute:y,values:C}),u(a)&&delete t.attributes.normal,u(l)&&delete t.attributes.st,u(c)&&delete t.attributes.tangent,u(h)&&delete t.attributes.binormal,t};var Ce=new n,Ee=new n,Se=new n,we=new n,Te=new n,xe={positions:new Array(7),indices:new Array(9)},be=new n,Pe=new n,Ae=new n,Ie=new n,Me=new i,De=new i,Re=new i,Oe=w.fromPointNormal(n.ZERO,n.UNIT_Y),Ne=new n,Le=new n,Fe=new i,Be=new i,Ve=new n,ze=new n,ke=new n,Ue=new n,Ge=new n,We=new n,He=new n,qe=new o;return te.splitLongitude=function(e){var t=e.geometry,i=t.boundingSphere;if(u(i)){var n=i.center.x-i.radius;if(n>0||r.intersectPlane(i,w.ORIGIN_ZX_PLANE)!==g.INTERSECTING)return e}if(t.geometryType!==v.NONE)switch(t.geometryType){case v.POLYLINES:ee(e);break;case v.TRIANGLES:J(e);break;case v.LINES:$(e)}else G(t),t.primitiveType===T.TRIANGLES?J(e):t.primitiveType===T.LINES&&$(e);return e},te}),r("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E){"use strict";function S(e,i,o){var a=i.vertexFormat,s=i.center,u=i.semiMajorAxis,h=i.semiMinorAxis,m=i.ellipsoid,f=i.stRotation,v=o?e.length/3*2:e.length/3,_=a.st?new Float32Array(2*v):void 0,y=a.normal?new Float32Array(3*v):void 0,E=a.tangent?new Float32Array(3*v):void 0,S=a.binormal?new Float32Array(3*v):void 0,w=0,T=F,x=B,b=V,P=new c(m),A=P.project(m.cartesianToCartographic(s,z),k),R=m.scaleToGeodeticSurface(s,I);m.geodeticSurfaceNormal(R,R);for(var W=C.fromAxisAngle(R,f,L),H=g.fromQuaternion(W,N),q=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,U),j=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),Y=e.length,X=o?Y:0,Z=X/3*2,K=0;Y>K;K+=3){var Q=K+1,J=K+2,$=r.fromArray(e,K,I);if(a.st){var ee=g.multiplyByVector(H,$,M),te=P.project(m.cartesianToCartographic(ee,z),D);r.subtract(te,A,te),O.x=(te.x+u)/(2*u),O.y=(te.y+h)/(2*h),q.x=Math.min(O.x,q.x),q.y=Math.min(O.y,q.y),j.x=Math.max(O.x,j.x),j.y=Math.max(O.y,j.y),o&&(_[w+Z]=O.x,_[w+1+Z]=O.y),_[w++]=O.x,_[w++]=O.y}T=m.geodeticSurfaceNormal($,T),(a.normal||a.tangent||a.binormal)&&((a.tangent||a.binormal)&&(x=r.normalize(r.cross(r.UNIT_Z,T,x),x),g.multiplyByVector(H,x,x)),a.normal&&(y[K]=T.x,y[Q]=T.y,y[J]=T.z,o&&(y[K+X]=-T.x,y[Q+X]=-T.y,y[J+X]=-T.z)),a.tangent&&(E[K]=x.x,E[Q]=x.y,E[J]=x.z,o&&(E[K+X]=-x.x,E[Q+X]=-x.y,E[J+X]=-x.z)),a.binormal&&(b=r.normalize(r.cross(T,x,b),b),S[K]=b.x,S[Q]=b.y,S[J]=b.z,o&&(S[K+X]=b.x,S[Q+X]=b.y,S[J+X]=b.z)))}if(a.st){Y=_.length;for(var re=0;Y>re;re+=2)_[re]=(_[re]-q.x)/(j.x-q.x),_[re+1]=(_[re+1]-q.y)/(j.y-q.y)}var ie=new p;if(a.position){var ne=l.raisePositionsToHeight(e,i,o);ie.position=new d({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:ne})}return a.st&&(ie.st=new d({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:_})),a.normal&&(ie.normal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:y})),a.tangent&&(ie.tangent=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),a.binormal&&(ie.binormal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:S})),ie}function w(e){var t,r,i,n,o,a=new Array(12*(e*(e+1))-6),s=0;for(t=0,i=1,n=0;3>n;n++)a[s++]=i++,a[s++]=t,a[s++]=i;for(n=2;e+1>n;++n){for(i=n*(n+1)-1,t=(n-1)*n-1,a[s++]=i++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=i++,a[s++]=t,a[s++]=i}for(r=2*e,++i,++t,n=0;r-1>n;++n)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;for(a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t++,a[s++]=t,++t,n=e-1;n>1;--n){for(a[s++]=t++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=t++,a[s++]=t++,a[s++]=i++}for(n=0;3>n;n++)a[s++]=t++,a[s++]=t,a[s++]=i;return a}function T(t){var i=t.center;W=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(i,W),t.height,W),W=r.add(i,W,W);var n=new e(W,t.semiMajorAxis),o=l.computeEllipsePositions(t,!0,!1),a=o.positions,s=o.numPts,u=S(a,t,!1),c=w(s);return c=v.createTypedArray(a.length/3,c),{boundingSphere:n,attributes:u,indices:c}}function x(e,i){var o=i.vertexFormat,a=i.center,s=i.semiMajorAxis,l=i.semiMinorAxis,u=i.ellipsoid,h=i.height,m=i.extrudedHeight,f=i.stRotation,v=e.length/3*2,_=new Float64Array(3*v),y=o.st?new Float32Array(2*v):void 0,E=o.normal?new Float32Array(3*v):void 0,S=o.tangent?new Float32Array(3*v):void 0,w=o.binormal?new Float32Array(3*v):void 0,T=0,x=F,b=B,P=V,A=new c(u),W=A.project(u.cartesianToCartographic(a,z),k),H=u.scaleToGeodeticSurface(a,I);u.geodeticSurfaceNormal(H,H);for(var q=C.fromAxisAngle(H,f,L),j=g.fromQuaternion(q,N),Y=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,U),X=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),Z=e.length,K=Z/3*2,Q=0;Z>Q;Q+=3){var J,$=Q+1,ee=Q+2,te=r.fromArray(e,Q,I);if(o.st){var re=g.multiplyByVector(j,te,M),ie=A.project(u.cartesianToCartographic(re,z),D);r.subtract(ie,W,ie),O.x=(ie.x+s)/(2*s),O.y=(ie.y+l)/(2*l),Y.x=Math.min(O.x,Y.x),Y.y=Math.min(O.y,Y.y),X.x=Math.max(O.x,X.x),X.y=Math.max(O.y,X.y),y[T+K]=O.x,y[T+1+K]=O.y,y[T++]=O.x,y[T++]=O.y}te=u.scaleToGeodeticSurface(te,te),J=r.clone(te,M),x=u.geodeticSurfaceNormal(te,x);var ne=r.multiplyByScalar(x,h,R);if(te=r.add(te,ne,te),ne=r.multiplyByScalar(x,m,ne),J=r.add(J,ne,J),o.position&&(_[Q+Z]=J.x,_[$+Z]=J.y,_[ee+Z]=J.z,_[Q]=te.x,_[$]=te.y,_[ee]=te.z),o.normal||o.tangent||o.binormal){P=r.clone(x,P);var oe=r.fromArray(e,(Q+3)%Z,R);r.subtract(oe,te,oe);var ae=r.subtract(J,te,D);x=r.normalize(r.cross(ae,oe,x),x),o.normal&&(E[Q]=x.x,E[$]=x.y,E[ee]=x.z,E[Q+Z]=x.x,E[$+Z]=x.y,E[ee+Z]=x.z),o.tangent&&(b=r.normalize(r.cross(P,x,b),b),S[Q]=b.x,S[$]=b.y,S[ee]=b.z,S[Q+Z]=b.x,S[Q+1+Z]=b.y,S[Q+2+Z]=b.z),o.binormal&&(w[Q]=P.x,w[$]=P.y,w[ee]=P.z,w[Q+Z]=P.x,w[$+Z]=P.y,w[ee+Z]=P.z)}}if(o.st){Z=y.length;for(var se=0;Z>se;se+=2)y[se]=(y[se]-Y.x)/(X.x-Y.x),y[se+1]=(y[se+1]-Y.y)/(X.y-Y.y)}var le=new p;return o.position&&(le.position=new d({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:_})),o.st&&(le.st=new d({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:y})),o.normal&&(le.normal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),o.tangent&&(le.tangent=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:S})),o.binormal&&(le.binormal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:w})),le}function b(e){for(var t=e.length/3,r=v.createTypedArray(t,6*t),i=0,n=0;t>n;n++){var o=n,a=n+t,s=(o+1)%t,l=s+t;r[i++]=o,r[i++]=a,r[i++]=s,r[i++]=s,r[i++]=a,r[i++]=l}return r}function P(t){var i=t.center,n=t.ellipsoid,o=t.semiMajorAxis,a=r.multiplyByScalar(n.geodeticSurfaceNormal(i,I),t.height,I);H.center=r.add(i,a,H.center),H.radius=o,a=r.multiplyByScalar(n.geodeticSurfaceNormal(i,a),t.extrudedHeight,a),q.center=r.add(i,a,q.center),q.radius=o;var s=l.computeEllipsePositions(t,!0,!0),u=s.positions,c=s.numPts,d=s.outerPositions,p=e.union(H,q),_=S(u,t,!0),g=w(c),C=g.length;g.length=2*C;for(var E=u.length/3,T=0;C>T;T+=3)g[T+C]=g[T+2]+E,g[T+1+C]=g[T+1]+E,g[T+2+C]=g[T]+E;var P=v.createTypedArray(2*E/3,g),A=new h({attributes:_,indices:P,primitiveType:y.TRIANGLES}),M=x(d,t);g=b(d);var D=v.createTypedArray(2*d.length/3,g),R=new h({attributes:M,indices:D,primitiveType:y.TRIANGLES}),O=f.combineInstances([new m({geometry:A}),new m({geometry:R})]);return{boundingSphere:p,attributes:O[0].attributes,indices:O[0].indices}}function A(e){e=o(e,o.EMPTY_OBJECT);var t=e.center,i=o(e.ellipsoid,u.WGS84),n=e.semiMajorAxis,s=e.semiMinorAxis,l=o(e.granularity,_.RADIANS_PER_DEGREE),c=o(e.height,0),h=e.extrudedHeight,d=a(h)&&Math.abs(c-h)>1,p=o(e.vertexFormat,E.DEFAULT);this._center=r.clone(t),this._semiMajorAxis=n,this._semiMinorAxis=s,this._ellipsoid=u.clone(i),this._rotation=o(e.rotation,0),this._stRotation=o(e.stRotation,0),this._height=c,this._granularity=l,this._vertexFormat=E.clone(p),this._extrudedHeight=o(h,c),this._extrude=d,this._workerName="createEllipseGeometry"}var I=new r,M=new r,D=new r,R=new r,O=new t,N=new g,L=new C,F=new r,B=new r,V=new r,z=new i,k=new r,U=new t,G=new t,W=new r,H=new e,q=new e;A.packedLength=r.packedLength+u.packedLength+E.packedLength+8,A.pack=function(e,t,i){i=o(i,0),r.pack(e._center,t,i),i+=r.packedLength,u.pack(e._ellipsoid,t,i),i+=u.packedLength,E.pack(e._vertexFormat,t,i),i+=E.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i]=e._extrude?1:0};var j=new r,Y=new u,X=new E,Z={center:j,ellipsoid:Y,vertexFormat:X,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return A.unpack=function(e,t,i){t=o(t,0);var n=r.unpack(e,t,j);t+=r.packedLength;var s=u.unpack(e,t,Y);t+=u.packedLength;var l=E.unpack(e,t,X);t+=E.packedLength;var c=e[t++],h=e[t++],d=e[t++],p=e[t++],m=e[t++],f=e[t++],v=e[t++],_=1===e[t];return a(i)?(i._center=r.clone(n,i._center),i._ellipsoid=u.clone(s,i._ellipsoid),i._vertexFormat=E.clone(l,i._vertexFormat),i._semiMajorAxis=c,i._semiMinorAxis=h,i._rotation=d,i._stRotation=p,i._height=m,i._granularity=f,i._extrudedHeight=v,i._extrude=_,i):(Z.height=m,Z.extrudedHeight=v,Z.granularity=f,Z.stRotation=p,Z.rotation=d,Z.semiMajorAxis=c,Z.semiMinorAxis=h,new A(Z))},A.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=P(r)):t=T(r),new h({attributes:t.attributes,indices:t.indices,primitiveType:y.TRIANGLES,boundingSphere:t.boundingSphere})},A.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new A({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,stRotation:e._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:E.POSITION_ONLY})},A}),r("Core/CircleGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseGeometry","./Ellipsoid","./Math","./VertexFormat"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){e=t(e,t.EMPTY_OBJECT);var r=e.radius,i={center:e.center,semiMajorAxis:r,semiMinorAxis:r,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation};this._ellipseGeometry=new n(i),this._workerName="createCircleGeometry"}l.packedLength=n.packedLength,l.pack=function(e,t,r){n.pack(e._ellipseGeometry,t,r)};var u=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),c={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new s,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return l.unpack=function(t,i,a){var h=n.unpack(t,i,u);return c.center=e.clone(h._center,c.center),c.ellipsoid=o.clone(h._ellipsoid,c.ellipsoid),c.height=h._height,c.extrudedHeight=h._extrudedHeight,c.granularity=h._granularity,c.vertexFormat=s.clone(h._vertexFormat,c.vertexFormat),c.stRotation=h._stRotation,r(a)?(c.semiMajorAxis=h._semiMajorAxis,c.semiMinorAxis=h._semiMinorAxis,a._ellipseGeometry=new n(c),a):(c.radius=h._semiMajorAxis,new l(c))},l.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},l.createShadowVolume=function(e,t,r){var i=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,o=t(i,n),a=r(i,n);return new l({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:s.POSITION_ONLY})},l}),r("Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(i){var n=i.center;g=t.multiplyByScalar(i.ellipsoid.geodeticSurfaceNormal(n,g),i.height,g),g=t.add(n,g,g);for(var o=new e(g,i.semiMajorAxis),s=a.computeEllipsePositions(i,!1,!0).outerPositions,l=new c({position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(s,i,!1)})}),d=s.length/3,p=h.createTypedArray(d,2*d),m=0,f=0;d>f;++f)p[m++]=f,p[m++]=(f+1)%d;return{boundingSphere:o,attributes:l,indices:p}}function f(n){var o=i(n.numberOfVerticalLines,16);o=Math.max(o,0);var s=n.center,l=n.ellipsoid,d=n.semiMajorAxis,p=t.multiplyByScalar(l.geodeticSurfaceNormal(s,_),n.height,_);y.center=t.add(s,p,y.center),y.radius=d,p=t.multiplyByScalar(l.geodeticSurfaceNormal(s,p),n.extrudedHeight,p),C.center=t.add(s,p,C.center),C.radius=d;var m=a.computeEllipsePositions(n,!1,!0).outerPositions,f=new c({position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(m,n,!0)})});m=f.position.values;var v=e.union(y,C),g=m.length/3,E=h.createTypedArray(g,2*g+2*o);g/=2;var S,w=0;for(S=0;g>S;++S)E[w++]=S,E[w++]=(S+1)%g,E[w++]=S+g,E[w++]=(S+1)%g+g;var T;if(o>0){var x=Math.min(o,g);T=Math.round(g/x)}var b=Math.min(T*o,g);if(o>0)for(S=0;b>S;S+=T)E[w++]=S,E[w++]=S+g;return{boundingSphere:v,attributes:f,indices:E}}function v(e){e=i(e,i.EMPTY_OBJECT);var r=e.center,o=i(e.ellipsoid,s.WGS84),a=e.semiMajorAxis,l=e.semiMinorAxis,u=i(e.granularity,d.RADIANS_PER_DEGREE),c=i(e.height,0),h=e.extrudedHeight,p=n(h)&&Math.abs(c-h)>1;this._center=t.clone(r),this._semiMajorAxis=a,this._semiMinorAxis=l,this._ellipsoid=s.clone(o),this._rotation=i(e.rotation,0),this._height=c,this._granularity=u,this._extrudedHeight=h,this._extrude=p,this._numberOfVerticalLines=Math.max(i(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"}var _=new t,g=new t,y=new e,C=new e;v.packedLength=t.packedLength+s.packedLength+9,v.pack=function(e,r,o){o=i(o,0),t.pack(e._center,r,o),o+=t.packedLength,s.pack(e._ellipsoid,r,o),o+=s.packedLength,r[o++]=e._semiMajorAxis,r[o++]=e._semiMinorAxis,r[o++]=e._rotation,r[o++]=e._height,r[o++]=e._granularity,r[o++]=n(e._extrudedHeight)?1:0,r[o++]=i(e._extrudedHeight,0),r[o++]=e._extrude?1:0,r[o]=e._numberOfVerticalLines};var E=new t,S=new s,w={center:E,ellipsoid:S,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return v.unpack=function(e,r,o){r=i(r,0);var a=t.unpack(e,r,E);r+=t.packedLength;var l=s.unpack(e,r,S);r+=s.packedLength;var u=e[r++],c=e[r++],h=e[r++],d=e[r++],p=e[r++],m=e[r++],f=e[r++],_=1===e[r++],g=e[r];return n(o)?(o._center=t.clone(a,o._center),o._ellipsoid=s.clone(l,o._ellipsoid),o._semiMajorAxis=u,o._semiMinorAxis=c,o._rotation=h,o._height=d,o._granularity=p,o._extrudedHeight=m?f:void 0,o._extrude=_,o._numberOfVerticalLines=g,o):(w.height=d,w.extrudedHeight=m?f:void 0,w.granularity=p,w.rotation=h,w.semiMajorAxis=u,w.semiMinorAxis=c,w.numberOfVerticalLines=g,new v(w))},v.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=f(r)):t=m(r),new l({attributes:t.attributes,indices:t.indices,primitiveType:p.LINES,boundingSphere:t.boundingSphere})},v}),r("Core/CircleOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseOutlineGeometry","./Ellipsoid"],function(e,t,r,i,n,o){"use strict";function a(e){e=t(e,t.EMPTY_OBJECT);var r=e.radius,i={center:e.center,semiMajorAxis:r,semiMinorAxis:r,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new n(i),this._workerName="createCircleOutlineGeometry"}a.packedLength=n.packedLength,a.pack=function(e,t,r){n.pack(e._ellipseGeometry,t,r)};var s=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),l={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return a.unpack=function(t,i,u){var c=n.unpack(t,i,s);return l.center=e.clone(c._center,l.center),l.ellipsoid=o.clone(c._ellipsoid,l.ellipsoid),l.height=c._height,l.extrudedHeight=c._extrudedHeight,l.granularity=c._granularity,l.numberOfVerticalLines=c._numberOfVerticalLines,r(u)?(l.semiMajorAxis=c._semiMajorAxis,l.semiMinorAxis=c._semiMinorAxis,u._ellipseGeometry=new n(l),u):(l.radius=c._semiMajorAxis,new a(l))},a.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},a}),r("Core/ClockRange",["./freezeObject"],function(e){"use strict";var t={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2};return e(t)}),r("Core/ClockStep",["./freezeObject"],function(e){"use strict";var t={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2};return e(t)}),r("Core/getTimestamp",["./defined"],function(e){"use strict";var t;return t="undefined"!=typeof performance&&e(performance.now)?function(){return performance.now()}:function(){return Date.now()}}),r("Core/Clock",["./ClockRange","./ClockStep","./defaultValue","./defined","./DeveloperError","./Event","./getTimestamp","./JulianDate"],function(e,t,r,i,n,o,a,s){"use strict";function l(n){n=r(n,r.EMPTY_OBJECT);var l=n.startTime,u=!i(l),c=n.stopTime,h=!i(c),d=n.currentTime,p=!i(d);u&&h&&p?(d=s.now(),l=s.clone(d),c=s.addDays(d,1,new s)):u&&h?(l=s.clone(d),c=s.addDays(d,1,new s)):u&&p?(l=s.addDays(c,-1,new s),d=s.clone(l)):p&&h?(d=s.clone(l),c=s.addDays(l,1,new s)):p?d=s.clone(l):h?c=s.addDays(d,1,new s):u&&(l=s.clone(d)),this.startTime=l,this.stopTime=c,this.currentTime=d,this.multiplier=r(n.multiplier,1),this.clockStep=r(n.clockStep,t.SYSTEM_CLOCK_MULTIPLIER),this.clockRange=r(n.clockRange,e.UNBOUNDED),this.canAnimate=r(n.canAnimate,!0),this.shouldAnimate=r(n.shouldAnimate,!0),this.onTick=new o,this._lastSystemTime=a()}return l.prototype.tick=function(){var r=a(),i=s.clone(this.currentTime),n=this.startTime,o=this.stopTime,l=this.multiplier;if(this.canAnimate&&this.shouldAnimate)if(this.clockStep===t.SYSTEM_CLOCK)i=s.now(i);else{if(this.clockStep===t.TICK_DEPENDENT)i=s.addSeconds(i,l,i);else{var u=r-this._lastSystemTime;i=s.addSeconds(i,l*(u/1e3),i)}if(this.clockRange===e.CLAMPED)s.lessThan(i,n)?i=s.clone(n,i):s.greaterThan(i,o)&&(i=s.clone(o,i));else if(this.clockRange===e.LOOP_STOP)for(s.lessThan(i,n)&&(i=s.clone(n,i));s.greaterThan(i,o);)i=s.addSeconds(n,s.secondsDifference(i,o),i)}return this.currentTime=i,this._lastSystemTime=r,this.onTick.raiseEvent(this),i},l}),r("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,i,n,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+(t-e)*(2/3-r)*6:e}function s(t,r,i,n){this.red=e(t,1),this.green=e(r,1),this.blue=e(i,1),this.alpha=e(n,1)}s.fromCartesian4=function(e,r){return t(r)?(r.red=e.x,r.green=e.y,r.blue=e.z,r.alpha=e.w,r):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,i,n,o,a){return r=s.byteToFloat(e(r,255)),i=s.byteToFloat(e(i,255)),n=s.byteToFloat(e(n,255)),o=s.byteToFloat(e(o,255)),t(a)?(a.red=r,a.green=i,a.blue=n,a.alpha=o,a):new s(r,i,n,o)},s.fromAlpha=function(e,r,i){return t(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=r,i):new s(e.red,e.green,e.blue,r)};var l,u,c;i.supportsTypedArrays()&&(l=new ArrayBuffer(4),u=new Uint32Array(l),c=new Uint8Array(l)),s.fromRgba=function(e){return u[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,i,n){t=e(t,0)%1,r=e(r,0),i=e(i,0),n=e(n,1);var o=i,l=i,u=i;if(0!==r){var c;c=.5>i?i*(1+r):i+r-i*r;var h=2*i-c;o=a(h,c,t+1/3),l=a(h,c,t),u=a(h,c,t-1/3)}return new s(o,l,u,n)},s.fromRandom=function(r,i){r=e(r,e.EMPTY_OBJECT);var n=r.red;if(!t(n)){var a=e(r.minimumRed,0),l=e(r.maximumRed,1);n=a+o.nextRandomNumber()*(l-a)}var u=r.green;if(!t(u)){var c=e(r.minimumGreen,0),h=e(r.maximumGreen,1);u=c+o.nextRandomNumber()*(h-c)}var d=r.blue;if(!t(d)){var p=e(r.minimumBlue,0),m=e(r.maximumBlue,1);d=p+o.nextRandomNumber()*(m-p)}var f=r.alpha;if(!t(f)){var v=e(r.minimumAlpha,0),_=e(r.maximumAlpha,1);f=v+o.nextRandomNumber()*(_-v)}return t(i)?(i.red=n,i.green=u,i.blue=d,i.alpha=f,i):new s(n,u,d,f)};var h=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,p=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,m=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){var i=s[r.toUpperCase()];if(t(i))return s.clone(i);var n=h.exec(r);return null!==n?new s(parseInt(n[1],16)/15,parseInt(n[2],16)/15,parseInt(n[3],16)/15):(n=d.exec(r),null!==n?new s(parseInt(n[1],16)/255,parseInt(n[2],16)/255,parseInt(n[3],16)/255):(n=p.exec(r),null!==n?new s(parseFloat(n[1])/("%"===n[1].substr(-1)?100:255),parseFloat(n[2])/("%"===n[2].substr(-1)?100:255),parseFloat(n[3])/("%"===n[3].substr(-1)?100:255),parseFloat(e(n[4],"1.0"))):(n=m.exec(r),null!==n?s.fromHsl(parseFloat(n[1])/360,parseFloat(n[2])/100,parseFloat(n[3])/100,parseFloat(e(n[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(t,r,i){i=e(i,0),r[i++]=t.red,r[i++]=t.green,r[i++]=t.blue,r[i]=t.alpha},s.unpack=function(r,i,n){return i=e(i,0),t(n)||(n=new s),n.red=r[i++],n.green=r[i++],n.blue=r[i++],n.alpha=r[i],n},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")";
},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),i=s.floatToByte(this.green),n=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=i,e[2]=n,e[3]=o,e):[r,i,n,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),u[0]},s.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},s.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.ALICEBLUE=n(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=n(s.fromCssColorString("#FAEBD7")),s.AQUA=n(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=n(s.fromCssColorString("#7FFFD4")),s.AZURE=n(s.fromCssColorString("#F0FFFF")),s.BEIGE=n(s.fromCssColorString("#F5F5DC")),s.BISQUE=n(s.fromCssColorString("#FFE4C4")),s.BLACK=n(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=n(s.fromCssColorString("#FFEBCD")),s.BLUE=n(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=n(s.fromCssColorString("#8A2BE2")),s.BROWN=n(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=n(s.fromCssColorString("#DEB887")),s.CADETBLUE=n(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=n(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=n(s.fromCssColorString("#D2691E")),s.CORAL=n(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=n(s.fromCssColorString("#6495ED")),s.CORNSILK=n(s.fromCssColorString("#FFF8DC")),s.CRIMSON=n(s.fromCssColorString("#DC143C")),s.CYAN=n(s.fromCssColorString("#00FFFF")),s.DARKBLUE=n(s.fromCssColorString("#00008B")),s.DARKCYAN=n(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=n(s.fromCssColorString("#B8860B")),s.DARKGRAY=n(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=n(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=n(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=n(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=n(s.fromCssColorString("#556B2F")),s.DARKORANGE=n(s.fromCssColorString("#FF8C00")),s.DARKORCHID=n(s.fromCssColorString("#9932CC")),s.DARKRED=n(s.fromCssColorString("#8B0000")),s.DARKSALMON=n(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=n(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=n(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=n(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=n(s.fromCssColorString("#00CED1")),s.DARKVIOLET=n(s.fromCssColorString("#9400D3")),s.DEEPPINK=n(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=n(s.fromCssColorString("#00BFFF")),s.DIMGRAY=n(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=n(s.fromCssColorString("#1E90FF")),s.FIREBRICK=n(s.fromCssColorString("#B22222")),s.FLORALWHITE=n(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=n(s.fromCssColorString("#228B22")),s.FUSCHIA=n(s.fromCssColorString("#FF00FF")),s.GAINSBORO=n(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=n(s.fromCssColorString("#F8F8FF")),s.GOLD=n(s.fromCssColorString("#FFD700")),s.GOLDENROD=n(s.fromCssColorString("#DAA520")),s.GRAY=n(s.fromCssColorString("#808080")),s.GREEN=n(s.fromCssColorString("#008000")),s.GREENYELLOW=n(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=n(s.fromCssColorString("#F0FFF0")),s.HOTPINK=n(s.fromCssColorString("#FF69B4")),s.INDIANRED=n(s.fromCssColorString("#CD5C5C")),s.INDIGO=n(s.fromCssColorString("#4B0082")),s.IVORY=n(s.fromCssColorString("#FFFFF0")),s.KHAKI=n(s.fromCssColorString("#F0E68C")),s.LAVENDER=n(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=n(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=n(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=n(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=n(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=n(s.fromCssColorString("#F08080")),s.LIGHTCYAN=n(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=n(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=n(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=n(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=n(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=n(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=n(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=n(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=n(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=n(s.fromCssColorString("#FFFFE0")),s.LIME=n(s.fromCssColorString("#00FF00")),s.LIMEGREEN=n(s.fromCssColorString("#32CD32")),s.LINEN=n(s.fromCssColorString("#FAF0E6")),s.MAGENTA=n(s.fromCssColorString("#FF00FF")),s.MAROON=n(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=n(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=n(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=n(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=n(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=n(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=n(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=n(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=n(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=n(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=n(s.fromCssColorString("#191970")),s.MINTCREAM=n(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=n(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=n(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=n(s.fromCssColorString("#FFDEAD")),s.NAVY=n(s.fromCssColorString("#000080")),s.OLDLACE=n(s.fromCssColorString("#FDF5E6")),s.OLIVE=n(s.fromCssColorString("#808000")),s.OLIVEDRAB=n(s.fromCssColorString("#6B8E23")),s.ORANGE=n(s.fromCssColorString("#FFA500")),s.ORANGERED=n(s.fromCssColorString("#FF4500")),s.ORCHID=n(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=n(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=n(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=n(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=n(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=n(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=n(s.fromCssColorString("#FFDAB9")),s.PERU=n(s.fromCssColorString("#CD853F")),s.PINK=n(s.fromCssColorString("#FFC0CB")),s.PLUM=n(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=n(s.fromCssColorString("#B0E0E6")),s.PURPLE=n(s.fromCssColorString("#800080")),s.RED=n(s.fromCssColorString("#FF0000")),s.ROSYBROWN=n(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=n(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=n(s.fromCssColorString("#8B4513")),s.SALMON=n(s.fromCssColorString("#FA8072")),s.SANDYBROWN=n(s.fromCssColorString("#F4A460")),s.SEAGREEN=n(s.fromCssColorString("#2E8B57")),s.SEASHELL=n(s.fromCssColorString("#FFF5EE")),s.SIENNA=n(s.fromCssColorString("#A0522D")),s.SILVER=n(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=n(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=n(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=n(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=n(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=n(s.fromCssColorString("#00FF7F")),s.STEELBLUE=n(s.fromCssColorString("#4682B4")),s.TAN=n(s.fromCssColorString("#D2B48C")),s.TEAL=n(s.fromCssColorString("#008080")),s.THISTLE=n(s.fromCssColorString("#D8BFD8")),s.TOMATO=n(s.fromCssColorString("#FF6347")),s.TURQUOISE=n(s.fromCssColorString("#40E0D0")),s.VIOLET=n(s.fromCssColorString("#EE82EE")),s.WHEAT=n(s.fromCssColorString("#F5DEB3")),s.WHITE=n(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=n(s.fromCssColorString("#F5F5F5")),s.YELLOW=n(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=n(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=n(new s(0,0,0,0)),s}),r("Core/ColorGeometryInstanceAttribute",["./Color","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,r,i,n,o){"use strict";function a(t,i,n,o){t=r(t,1),i=r(i,1),n=r(n,1),o=r(o,1),this.value=new Uint8Array([e.floatToByte(t),e.floatToByte(i),e.floatToByte(n),e.floatToByte(o)])}return n(a.prototype,{componentDatatype:{get:function(){return t.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),a.fromColor=function(e){return new a(e.red,e.green,e.blue,e.alpha)},a.toValue=function(e,t){return i(t)?e.toBytes(t):new Uint8Array(e.toBytes())},a}),r("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(i,n,o){o=e(o,!1);var a,s,l,u={},c=t(i),h=t(n);if(c)for(a in i)i.hasOwnProperty(a)&&(s=i[a],h&&o&&"object"==typeof s&&n.hasOwnProperty(a)?(l=n[a],"object"==typeof l?u[a]=r(s,l,o):u[a]=s):u[a]=s);if(h)for(a in n)n.hasOwnProperty(a)&&!u.hasOwnProperty(a)&&(l=n[a],u[a]=l);return u}return r}),r("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),r("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),r("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,i=e._ellipsoid.minimumRadius,n=(r-i)/r,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),u=l*s,c=Math.atan2(s,o),h=l*a,d=h*h,p=1-d,m=Math.sqrt(p),f=t/4,v=f*f,_=v*f,g=v*v,y=1+f-3*v/4+5*_/4-175*g/64,C=1-f+15*v/8-35*_/8,E=1-3*f+35*v/4,S=1-5*f,w=y*c-C*Math.sin(2*c)*f/2-E*Math.sin(4*c)*v/16-S*Math.sin(6*c)*_/48-5*Math.sin(8*c)*g/512,T=e._constants;T.a=r,T.b=i,T.f=n,T.cosineHeading=o,T.sineHeading=a,T.tanU=s,T.cosineU=l,T.sineU=u,T.sigma=c,T.sineAlpha=h,T.sineSquaredAlpha=d,T.cosineSquaredAlpha=p,T.cosineAlpha=m,T.u2Over4=f,T.u4Over16=v,T.u6Over64=_,T.u8Over256=g,T.a0=y,T.a1=C,T.a2=E,T.a3=S,T.distanceRatio=w}function u(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,r,i,n,o,a){var s=u(e,r);return(1-s)*e*t*(i+s*n*(a+s*o*(2*a*a-1)))}function h(e,t,r,i,n,o,a){var l,u,h,d,p,m=(t-r)/t,f=o-i,v=Math.atan((1-m)*Math.tan(n)),_=Math.atan((1-m)*Math.tan(a)),g=Math.cos(v),y=Math.sin(v),C=Math.cos(_),E=Math.sin(_),S=g*C,w=g*E,T=y*E,x=y*C,b=f,P=s.TWO_PI,A=Math.cos(b),I=Math.sin(b);do{A=Math.cos(b),I=Math.sin(b);var M=w-x*A;h=Math.sqrt(C*C*I*I+M*M),u=T+S*A,l=Math.atan2(h,u);var D;0===h?(D=0,d=1):(D=S*I/h,d=1-D*D),P=b,p=u-2*T/d,isNaN(p)&&(p=0),b=f+c(m,D,d,l,h,u,p)}while(Math.abs(b-P)>s.EPSILON12);var R=d*(t*t-r*r)/(r*r),O=1+R*(4096+R*(R*(320-175*R)-768))/16384,N=R*(256+R*(R*(74-47*R)-128))/1024,L=p*p,F=N*h*(p+N*(u*(2*L-1)-N*p*(4*h*h-3)*(4*L-3)/6)/4),B=r*O*(l-F),V=Math.atan2(C*I,w-x*A),z=Math.atan2(g*I,w*A-x);e._distance=B,e._startHeading=V,e._endHeading=z,e._uSquared=R}function d(r,i,n,o){e.normalize(o.cartographicToCartesian(i,f),m),e.normalize(o.cartographicToCartesian(n,f),f);h(r,o.maximumRadius,o.minimumRadius,i.longitude,i.latitude,n.longitude,n.latitude),r._start=t.clone(i,r._start),r._end=t.clone(n,r._end),r._start.height=0,r._end.height=0,l(r)}function p(e,n,o){var s=r(o,a.WGS84);this._ellipsoid=s,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,i(e)&&i(n)&&d(this,e,n,s)}var m=new e,f=new e;return n(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),p.prototype.setEndPoints=function(e,t){d(this,e,t,this._ellipsoid)},p.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},p.prototype.interpolateUsingSurfaceDistance=function(e,r){var n=this._constants,o=n.distanceRatio+e/n.b,a=Math.cos(2*o),s=Math.cos(4*o),l=Math.cos(6*o),u=Math.sin(2*o),h=Math.sin(4*o),d=Math.sin(6*o),p=Math.sin(8*o),m=o*o,f=o*m,v=n.u8Over256,_=n.u2Over4,g=n.u6Over64,y=n.u4Over16,C=2*f*v*a/3+o*(1-_+7*y/4-15*g/4+579*v/64-(y-15*g/4+187*v/16)*a-(5*g/4-115*v/16)*s-29*v*l/16)+(_/2-y+71*g/32-85*v/16)*u+(5*y/16-5*g/4+383*v/96)*h-m*((g-11*v/2)*u+5*v*h/2)+(29*g/96-29*v/16)*d+539*v*p/1536,E=Math.asin(Math.sin(C)*n.cosineAlpha),S=Math.atan(n.a/n.b*Math.tan(E));C-=n.sigma;var w=Math.cos(2*n.sigma+C),T=Math.sin(C),x=Math.cos(C),b=n.cosineU*x,P=n.sineU*T,A=Math.atan2(T*n.sineHeading,b-P*n.cosineHeading),I=A-c(n.f,n.sineAlpha,n.cosineSquaredAlpha,C,T,x,w);return i(r)?(r.longitude=this._start.longitude+I,r.latitude=S,r.height=0,r):new t(this._start.longitude+I,S,0)},p}),r("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(e,t,r){var i=T;i.length=e;var n;if(t===r){for(n=0;e>n;n++)i[n]=t;return i}var o=r-t,a=o/e;for(n=0;e>n;n++){var s=t+n*a;i[n]=s}return i}function p(t,r,i,n,o,a,s,l){var u=n.scaleToGeodeticSurface(t,A),c=n.scaleToGeodeticSurface(r,I),h=m.numberOfPoints(t,r,i),p=n.cartesianToCartographic(u,x),f=n.cartesianToCartographic(c,b),v=d(h,o,a);M.setEndPoints(p,f);var _=M.surfaceDistance/h,g=l;p.height=o;var y=n.cartographicToCartesian(p,P);e.pack(y,s,g),g+=3;for(var C=1;h>C;C++){var E=M.interpolateUsingSurfaceDistance(C*_,b);E.height=v[C],y=n.cartographicToCartesian(E,P),e.pack(y,s,g),g+=3}return g}var m={};m.numberOfPoints=function(t,r,i){var n=e.distance(t,r);return Math.ceil(n/i)};var f=new t;m.extractHeights=function(e,t){for(var r=e.length,i=new Array(r),n=0;r>n;n++){var o=e[n];i[n]=t.cartesianToCartographic(o,f).height}return i};var v=new c,_=new e,g=new e,y=new h(e.ZERO,0),C=new e,E=new h(e.ZERO,0),S=new e,w=new e,T=[],x=new t,b=new t,P=new e,A=new e,I=new e,M=new a;m.wrapLongitude=function(t,n){var o=[],a=[];if(i(t)&&t.length>0){n=r(n,c.IDENTITY);var l=c.inverseTransformation(n,v),u=c.multiplyByPoint(l,e.ZERO,_),d=c.multiplyByPointAsVector(l,e.UNIT_Y,g),p=h.fromPointNormal(u,d,y),m=c.multiplyByPointAsVector(l,e.UNIT_X,C),f=h.fromPointNormal(u,m,E),T=1;o.push(e.clone(t[0]));for(var x=o[0],b=t.length,P=1;b>P;++P){var A=t[P];if(h.getPointDistance(f,x)<0||h.getPointDistance(f,A)<0){var I=s.lineSegmentPlane(x,A,p,S);if(i(I)){var M=e.multiplyByScalar(d,5e-9,w);h.getPointDistance(p,x)<0&&e.negate(M,M),o.push(e.add(I,M,new e)),a.push(T+1),e.negate(M,M),o.push(e.add(I,M,new e)),T=1}}o.push(e.clone(t[P])),T++,x=A}a.push(T)}return{positions:o,lengths:a}};var D=u.EPSILON10;return m.removeDuplicates=function(t){var r=t.length;if(2>r)return t;var i,n,o;for(i=1;r>i&&(n=t[i-1],o=t[i],!e.equalsEpsilon(n,o,D));++i);if(i===r)return t;for(var a=t.slice(0,i);r>i;++i)o=t[i],e.equalsEpsilon(n,o,D)||(a.push(e.clone(o)),n=o);return a},m.generateArc=function(t){i(t)||(t={});var n=t.positions,a=n.length,s=r(t.ellipsoid,o.WGS84),c=r(t.height,0);if(1>a)return[];if(1===a){var h=s.scaleToGeodeticSurface(n[0],A);if(0!==c){var d=s.geodeticSurfaceNormal(h,P);e.multiplyByScalar(d,c,d),e.add(h,d,h)}return[h.x,h.y,h.z]}var f=t.minDistance;if(!i(f)){var v=r(t.granularity,u.RADIANS_PER_DEGREE);f=u.chordLength(v,s.maximumRadius)}var _,g=0;for(_=0;a-1>_;_++)g+=m.numberOfPoints(n[_],n[_+1],f);var y=3*(g+1),C=new Array(y),E=0,S=l(c);for(_=0;a-1>_;_++){var w=n[_],b=n[_+1],I=S?c[_]:c,M=S?c[_+1]:c;E=p(w,b,f,s,I,M,C,E)}T.length=0;var D=n[a-1],R=s.cartesianToCartographic(D,x);R.height=S?c[a-1]:c;var O=s.cartographicToCartesian(R,P);return e.pack(O,C,y-3),C},m.generateCartesianArc=function(t){for(var r=m.generateArc(t),i=r.length/3,n=new Array(i),o=0;i>o;o++)n[o]=e.unpack(r,3*o);return n},m}),r("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(e,t){for(var r=new Array(e.length),i=0;i<e.length;i++){var n=e[i];O=t.cartesianToCartographic(n,O),r[i]=O.height,e[i]=t.scaleToGeodeticSurface(n,n)}return r}function p(e,r,i,n){var o,a=e[0],s=e[1],l=t.angleBetween(a,s),u=Math.ceil(l/n),c=new Array(u);if(r===i){for(o=0;u>o;o++)c[o]=r;return c.push(i),c}var h=i-r,d=h/u;for(o=1;u>o;o++){var p=r+o*d;c[o]=p}return c[0]=r,c.push(i),c}function m(r,i,n,a){var s=new o(n,a),l=s.projectPointOntoPlane(t.add(n,r,j),j),u=s.projectPointOntoPlane(t.add(n,i,Y),Y),c=e.angleBetween(l,u);return u.x*l.y-u.y*l.x>=0?-c:c}function f(e,r,i,n,o,a,u,c){var d=z,p=k;L=h.eastNorthUpToFixedFrame(e,o,L),d=l.multiplyByPointAsVector(L,N,d),d=t.normalize(d,d);var f=m(d,r,e,o);B=s.fromRotationZ(f,B),U.z=a,L=l.multiplyTransformation(L,l.fromRotationTranslation(B,U,F),L);var v=V;v[0]=u;for(var _=0;c>_;_++)for(var g=0;g<i.length;g+=3)p=t.fromArray(i,g,p),p=s.multiplyByVector(v,p,p),p=l.multiplyByPoint(L,p,p),n.push(p.x,p.y,p.z);return n}function v(e,r,i,n,o,a,s){for(var l=0;l<e.length;l+=3){var u=t.fromArray(e,l,G);n=f(u,r,i,n,o,a[l/3],s,1)}return n}function _(e,t){var r=e.length,i=new Array(6*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=e[0];i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a;for(var l=1;r>l;l++){s=e[l];var u=s.x-o,c=s.y-a;i[n++]=u,i[n++]=0,i[n++]=c,i[n++]=u,i[n++]=0,i[n++]=c}return s=e[0],i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a,i}function g(e,t){for(var r=e.length,i=new Array(3*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=0;r>s;s++)i[n++]=e[s].x-o,i[n++]=0,i[n++]=e[s].y-a;return i}function y(e,r,i,o,l,u,h,d,p,m){var v,_=t.angleBetween(t.subtract(r,e,M),t.subtract(i,e,D)),g=o===n.BEVELED?0:Math.ceil(_/a.toRadians(5));v=l?s.fromQuaternion(c.fromAxisAngle(t.negate(e,M),_/(g+1),W),q):s.fromQuaternion(c.fromAxisAngle(e,_/(g+1),W),q);var y,C;if(r=t.clone(r,H),g>0)for(var E=m?2:1,S=0;g>S;S++)r=s.multiplyByVector(v,r,r),y=t.subtract(r,e,M),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(r,D),h=f(C,y,d,h,u,p,1,E);else y=t.subtract(r,e,M),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(r,D),h=f(C,y,d,h,u,p,1,1),i=t.clone(i,H),y=t.subtract(i,e,M),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(i,D),h=f(C,y,d,h,u,p,1,1);return h}var C=[new t,new t],E=new t,S=new t,w=new t,T=new t,x=new t,b=new t,P=new t,A=new t,I=new t,M=new t,D=new t,R={},O=new i,N=new t(-1,0,0),L=new l,F=new l,B=new s,V=s.IDENTITY.clone(),z=new t,k=new r,U=new t,G=new t,W=new c,H=new t,q=new s;R.removeDuplicatesFromShape=function(t){for(var r=t.length,i=[],n=r-1,o=0;r>o;n=o++){var a=t[n],s=t[o];e.equals(a,s)||i.push(s)}return i};var j=new t,Y=new t;R.angleIsGreaterThanPi=function(e,r,i,n){var a=new o(i,n),s=a.projectPointOntoPlane(t.add(i,e,j),j),l=a.projectPointOntoPlane(t.add(i,r,Y),Y);return l.x*s.y-l.y*s.x>=0};var X=new t,Z=new t;return R.computePositions=function(e,r,i,o,s){var l=o._ellipsoid,c=d(e,l),h=o._granularity,m=o._cornerType,D=s?_(r,i):g(r,i),O=s?g(r,i):void 0,N=i.height/2,L=i.width/2,F=e.length,B=[],V=s?[]:void 0,z=E,k=S,U=w,G=T,W=x,H=b,q=P,j=A,Y=I,K=e[0],Q=e[1];G=l.geodeticSurfaceNormal(K,G),z=t.subtract(Q,K,z),z=t.normalize(z,z),j=t.cross(G,z,j),j=t.normalize(j,j);var J=c[0],$=c[1];s&&(V=f(K,j,O,V,l,J+N,1,1)),Y=t.clone(K,Y),K=Q,k=t.negate(z,k);for(var ee,te,re=1;F-1>re;re++){var ie=s?2:1;Q=e[re+1],z=t.subtract(Q,K,z),z=t.normalize(z,z),U=t.add(z,k,U),U=t.normalize(U,U),G=l.geodeticSurfaceNormal(K,G);var ne=t.multiplyByScalar(G,t.dot(z,G),X);t.subtract(z,ne,ne),t.normalize(ne,ne);var oe=t.multiplyByScalar(G,t.dot(k,G),Z);t.subtract(k,oe,oe),t.normalize(oe,oe);var ae=!a.equalsEpsilon(Math.abs(t.dot(ne,oe)),1,a.EPSILON7);if(ae){U=t.cross(U,G,U),U=t.cross(G,U,U),U=t.normalize(U,U);var se=1/Math.max(.25,t.magnitude(t.cross(U,k,M))),le=R.angleIsGreaterThanPi(z,k,K,l);le?(W=t.add(K,t.multiplyByScalar(U,se*L,U),W),H=t.add(W,t.multiplyByScalar(j,L,H),H),C[0]=t.clone(Y,C[0]),C[1]=t.clone(H,C[1]),ee=p(C,J+N,$+N,h),te=u.generateArc({positions:C,granularity:h,ellipsoid:l}),B=v(te,j,D,B,l,ee,1),j=t.cross(G,z,j),j=t.normalize(j,j),q=t.add(W,t.multiplyByScalar(j,L,q),q),m===n.ROUNDED||m===n.BEVELED?y(W,H,q,m,le,l,B,D,$+N,s):(U=t.negate(U,U),B=f(K,U,D,B,l,$+N,se,ie)),Y=t.clone(q,Y)):(W=t.add(K,t.multiplyByScalar(U,se*L,U),W),H=t.add(W,t.multiplyByScalar(j,-L,H),H),C[0]=t.clone(Y,C[0]),C[1]=t.clone(H,C[1]),ee=p(C,J+N,$+N,h),te=u.generateArc({positions:C,granularity:h,ellipsoid:l}),B=v(te,j,D,B,l,ee,1),j=t.cross(G,z,j),j=t.normalize(j,j),q=t.add(W,t.multiplyByScalar(j,-L,q),q),m===n.ROUNDED||m===n.BEVELED?y(W,H,q,m,le,l,B,D,$+N,s):B=f(K,U,D,B,l,$+N,se,ie),Y=t.clone(q,Y)),k=t.negate(z,k)}else B=f(Y,j,D,B,l,J+N,1,1),Y=K;J=$,$=c[re+1],K=Q}C[0]=t.clone(Y,C[0]),C[1]=t.clone(K,C[1]),ee=p(C,J+N,$+N,h),te=u.generateArc({positions:C,granularity:h,ellipsoid:l}),B=v(te,j,D,B,l,ee,1),s&&(V=f(K,j,O,V,l,$+N,1,1)),F=B.length;var ue=s?F+V.length:F,ce=new Float64Array(ue);return ce.set(B),s&&ce.set(V,F),ce},R}),r("Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./isArray","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(r,i,a,s,u){var c=e.angleBetween(e.subtract(i,r,f),e.subtract(a,r,v)),h=s===t.BEVELED?1:Math.ceil(c/n.toRadians(5))+1,d=3*h,p=new Array(d);p[d-3]=a.x,p[d-2]=a.y,p[d-1]=a.z;var m;m=u?o.fromQuaternion(l.fromAxisAngle(e.negate(r,f),c/h,M),D):o.fromQuaternion(l.fromAxisAngle(r,c/h,M),D);var _=0;i=e.clone(i,f);for(var g=0;h>g;g++)i=o.multiplyByVector(m,i,i),p[_++]=i.x,p[_++]=i.y,p[_++]=i.z;return p}function c(r){var i=C,n=E,o=S,a=r[1];n=e.fromArray(r[1],a.length-3,n),o=e.fromArray(r[0],0,o),i=e.multiplyByScalar(e.add(n,o,i),.5,i);var s=u(i,n,o,t.ROUNDED,!1),l=r.length-1,c=r[l-1];a=r[l],n=e.fromArray(c,c.length-3,n),o=e.fromArray(a,0,o),i=e.multiplyByScalar(e.add(n,o,i),.5,i);var h=u(i,n,o,t.ROUNDED,!1);return[s,h]}function h(t,r,i,n){var o=f;return n?o=e.add(t,r,o):(r=e.negate(r,r),o=e.add(t,r,o)),[o.x,o.y,o.z,i.x,i.y,i.z]}function d(t,r,i,n){for(var o=new Array(t.length),a=new Array(t.length),s=e.multiplyByScalar(r,i,f),l=e.negate(s,v),u=0,c=t.length-1,h=0;h<t.length;h+=3){var d=e.fromArray(t,h,_),p=e.add(d,l,g);o[u++]=p.x,o[u++]=p.y,o[u++]=p.z;var m=e.add(d,s,g);a[c--]=m.z,a[c--]=m.y,a[c--]=m.x}return n.push(o,a),n}function p(e,t){for(var r=0;r<e.length;r++)e[r]=t.scaleToGeodeticSurface(e[r],e[r]);return e}var m={},f=new e,v=new e,_=new e,g=new e,y=[new e,new e],C=new e,E=new e,S=new e,w=new e,T=new e,x=new e,b=new e,P=new e,A=new e,I=new e,M=new l,D=new o;m.addAttribute=function(e,t,i,n){var o=t.x,a=t.y,s=t.z;r(i)&&(e[i]=o,e[i+1]=a,e[i+2]=s),r(n)&&(e[n]=s,e[n-1]=a,e[n-2]=o)};var R=new e,O=new e;m.computePositions=function(r){var i=r.granularity,o=r.positions,l=r.ellipsoid;o=p(o,l);var m=r.width/2,v=r.cornerType,_=r.saveAttributes,g=C,M=E,D=S,N=w,L=T,F=x,B=b,V=P,z=A,k=I,U=[],G=_?[]:void 0,W=_?[]:void 0,H=o[0],q=o[1];M=e.normalize(e.subtract(q,H,M),M),g=l.geodeticSurfaceNormal(H,g),N=e.normalize(e.cross(g,M,N),N),_&&(G.push(N.x,N.y,N.z),W.push(g.x,g.y,g.z)),B=e.clone(H,B),H=q,D=e.negate(M,D);var j,Y,X=[],Z=o.length;for(Y=1;Z-1>Y;Y++){g=l.geodeticSurfaceNormal(H,g),q=o[Y+1],M=e.normalize(e.subtract(q,H,M),M),L=e.normalize(e.add(M,D,L),L);var K=e.multiplyByScalar(g,e.dot(M,g),R);e.subtract(M,K,K),e.normalize(K,K);var Q=e.multiplyByScalar(g,e.dot(D,g),O);e.subtract(D,Q,Q),e.normalize(Q,Q);var J=!n.equalsEpsilon(Math.abs(e.dot(K,Q)),1,n.EPSILON7);if(J){L=e.cross(L,g,L),L=e.cross(g,L,L),L=e.normalize(L,L);var $=m/Math.max(.25,e.magnitude(e.cross(L,D,f))),ee=s.angleIsGreaterThanPi(M,D,H,l);L=e.multiplyByScalar(L,$,L),ee?(V=e.add(H,L,V),k=e.add(V,e.multiplyByScalar(N,m,k),k),z=e.add(V,e.multiplyByScalar(N,2*m,z),z),y[0]=e.clone(B,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:l}),U=d(j,N,m,U),_&&(G.push(N.x,N.y,N.z),W.push(g.x,g.y,g.z)),F=e.clone(z,F),N=e.normalize(e.cross(g,M,N),N),z=e.add(V,e.multiplyByScalar(N,2*m,z),z),B=e.add(V,e.multiplyByScalar(N,m,B),B),v===t.ROUNDED||v===t.BEVELED?X.push({leftPositions:u(V,F,z,v,ee)}):X.push({leftPositions:h(H,e.negate(L,L),z,ee)})):(z=e.add(H,L,z),k=e.add(z,e.negate(e.multiplyByScalar(N,m,k),k),k),V=e.add(z,e.negate(e.multiplyByScalar(N,2*m,V),V),V),y[0]=e.clone(B,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:l}),U=d(j,N,m,U),_&&(G.push(N.x,N.y,N.z),W.push(g.x,g.y,g.z)),F=e.clone(V,F),N=e.normalize(e.cross(g,M,N),N),V=e.add(z,e.negate(e.multiplyByScalar(N,2*m,V),V),V),B=e.add(z,e.negate(e.multiplyByScalar(N,m,B),B),B),v===t.ROUNDED||v===t.BEVELED?X.push({rightPositions:u(z,F,V,v,ee)}):X.push({rightPositions:h(H,L,V,ee)})),D=e.negate(M,D)}H=q}g=l.geodeticSurfaceNormal(H,g),y[0]=e.clone(B,y[0]),y[1]=e.clone(H,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:l}),U=d(j,N,m,U),_&&(G.push(N.x,N.y,N.z),W.push(g.x,g.y,g.z));var te;return v===t.ROUNDED&&(te=c(U)),{positions:U,corners:X,lefts:G,normals:W,endPositions:te}};var N=new e,L=new e;return m.scaleToGeodeticHeight=function(t,r,n,o){var a=t.length,s=i(o)?o:new Array(t.length);s.length=t.length;for(var l=r,u=0;a>u;u+=3){var c=n.scaleToGeodeticSurface(e.fromArray(t,u,L),L),h=N;0!==r&&(h=n.geodeticSurfaceNormal(c,h),h=e.multiplyByScalar(h,l,h),c=e.add(c,h,c)),s[u]=c.x,s[u+1]=c.y,s[u+2]=c.z}return s},m}),r("Core/CorridorGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v){"use strict";function _(e,r,i,o,a,s){var l=e.normals,u=e.tangents,c=e.binormals,h=t.normalize(t.cross(i,r,I),I);s.normal&&n.addAttribute(l,r,o,a),s.binormal&&n.addAttribute(c,i,o,a),s.tangent&&n.addAttribute(u,h,o,a)}function g(e,i,o){var s,l,u,m=e.positions,f=e.corners,v=e.endPositions,g=e.lefts,y=e.normals,C=new h,E=0,S=0,P=0;for(l=0;l<m.length;l+=2)u=m[l].length-3,E+=u,P+=2*u,S+=m[l+1].length-3;for(E+=3,S+=3,l=0;l<f.length;l++){s=f[l];var D=f[l].leftPositions;a(D)?(u=D.length,E+=u,P+=u):(u=f[l].rightPositions.length,S+=u,P+=u)}var R,O=a(v);O&&(R=v[0].length-3,E+=R,S+=R,R/=3,P+=6*R);var N,L,F,B,V,z,k=E+S,U=new Float64Array(k),G=i.normal?new Float32Array(k):void 0,W=i.tangent?new Float32Array(k):void 0,H=i.binormal?new Float32Array(k):void 0,q={normals:G,tangents:W,binormals:H},j=0,Y=k-1,X=w,Z=T,K=R/2,Q=d.createTypedArray(k/3,P),J=0;if(O){z=x,V=b;var $=v[0];for(X=t.fromArray(y,0,X),Z=t.fromArray(g,0,Z),l=0;K>l;l++)z=t.fromArray($,3*(K-1-l),z),V=t.fromArray($,3*(K+l),V),n.addAttribute(U,V,j),n.addAttribute(U,z,void 0,Y),_(q,X,Z,j,Y,i),L=j/3,B=L+1,N=(Y-2)/3,F=N-1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3}var ee=0,te=0,re=m[ee++],ie=m[ee++];U.set(re,j),U.set(ie,Y-ie.length+1),Z=t.fromArray(g,te,Z);var ne,oe;for(u=ie.length-3,l=0;u>l;l+=3)ne=o.geodeticSurfaceNormal(t.fromArray(re,l,I),I),oe=o.geodeticSurfaceNormal(t.fromArray(ie,u-l,M),M),X=t.normalize(t.add(ne,oe,X),X),_(q,X,Z,j,Y,i),L=j/3,B=L+1,N=(Y-2)/3,F=N-1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3;for(ne=o.geodeticSurfaceNormal(t.fromArray(re,u,I),I),oe=o.geodeticSurfaceNormal(t.fromArray(ie,u,M),M),X=t.normalize(t.add(ne,oe,X),X),te+=3,l=0;l<f.length;l++){var ae;s=f[l];var se,le,ue=s.leftPositions,ce=s.rightPositions,he=A,de=x,pe=b;if(X=t.fromArray(y,te,X),a(ue)){for(_(q,X,Z,void 0,Y,i),Y-=3,se=B,le=F,ae=0;ae<ue.length/3;ae++)he=t.fromArray(ue,3*ae,he),Q[J++]=se,Q[J++]=le-ae-1,Q[J++]=le-ae,n.addAttribute(U,he,void 0,Y),de=t.fromArray(U,3*(le-ae-1),de),pe=t.fromArray(U,3*se,pe),Z=t.normalize(t.subtract(de,pe,Z),Z),_(q,X,Z,void 0,Y,i),Y-=3;he=t.fromArray(U,3*se,he),de=t.subtract(t.fromArray(U,3*le,de),he,de),pe=t.subtract(t.fromArray(U,3*(le-ae),pe),he,pe),Z=t.normalize(t.add(de,pe,Z),Z),_(q,X,Z,j,void 0,i),j+=3}else{for(_(q,X,Z,j,void 0,i),j+=3,se=F,le=B,ae=0;ae<ce.length/3;ae++)he=t.fromArray(ce,3*ae,he),Q[J++]=se,Q[J++]=le+ae,Q[J++]=le+ae+1,n.addAttribute(U,he,j),de=t.fromArray(U,3*se,de),pe=t.fromArray(U,3*(le+ae),pe),Z=t.normalize(t.subtract(de,pe,Z),Z),_(q,X,Z,j,void 0,i),j+=3;he=t.fromArray(U,3*se,he),de=t.subtract(t.fromArray(U,3*(le+ae),de),he,de),pe=t.subtract(t.fromArray(U,3*le,pe),he,pe),Z=t.normalize(t.negate(t.add(pe,de,Z),Z),Z),_(q,X,Z,void 0,Y,i),Y-=3}for(re=m[ee++],ie=m[ee++],re.splice(0,3),ie.splice(ie.length-3,3),U.set(re,j),U.set(ie,Y-ie.length+1),u=ie.length-3,te+=3,Z=t.fromArray(g,te,Z),ae=0;ae<ie.length;ae+=3)ne=o.geodeticSurfaceNormal(t.fromArray(re,ae,I),I),oe=o.geodeticSurfaceNormal(t.fromArray(ie,u-ae,M),M),X=t.normalize(t.add(ne,oe,X),X),_(q,X,Z,j,Y,i),B=j/3,L=B-1,F=(Y-2)/3,N=F+1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3;j-=3,Y+=3}if(X=t.fromArray(y,y.length-3,X),_(q,X,Z,j,Y,i),O){j+=3,Y-=3,z=x,V=b;var me=v[1];for(l=0;K>l;l++)z=t.fromArray(me,3*(R-l-1),z),V=t.fromArray(me,3*l,V),n.addAttribute(U,z,void 0,Y),n.addAttribute(U,V,j),_(q,X,Z,j,Y,i),B=j/3,L=B-1,F=(Y-2)/3,N=F+1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3}if(C.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:U}),i.st){var fe,ve,_e=new Float32Array(k/3*2),ge=0;if(O){E/=3,S/=3;var ye=Math.PI/(R+1);ve=1/(E-R+1),fe=1/(S-R+1);var Ce,Ee=R/2;for(l=Ee+1;R+1>l;l++)Ce=p.PI_OVER_TWO+ye*l,_e[ge++]=fe*(1+Math.cos(Ce)),_e[ge++]=.5*(1+Math.sin(Ce));for(l=1;S-R+1>l;l++)_e[ge++]=l*fe,_e[ge++]=0;for(l=R;l>Ee;l--)Ce=p.PI_OVER_TWO-l*ye,_e[ge++]=1-fe*(1+Math.cos(Ce)),_e[ge++]=.5*(1+Math.sin(Ce));for(l=Ee;l>0;l--)Ce=p.PI_OVER_TWO-ye*l,_e[ge++]=1-ve*(1+Math.cos(Ce)),_e[ge++]=.5*(1+Math.sin(Ce));for(l=E-R;l>0;l--)_e[ge++]=l*ve,_e[ge++]=1;for(l=1;Ee+1>l;l++)Ce=p.PI_OVER_TWO+ye*l,_e[ge++]=ve*(1+Math.cos(Ce)),_e[ge++]=.5*(1+Math.sin(Ce))}else{for(E/=3,S/=3,ve=1/(E-1),fe=1/(S-1),l=0;S>l;l++)_e[ge++]=l*fe,_e[ge++]=0;for(l=E;l>0;l--)_e[ge++]=(l-1)*ve,_e[ge++]=1}C.st=new c({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:_e})}return i.normal&&(C.normal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:q.normals})),i.tangent&&(C.tangent=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:q.tangents})),i.binormal&&(C.binormal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:q.binormals})),{attributes:C,indices:Q}}function y(e,r){if(!(r.normal||r.binormal||r.tangent||r.st))return e;var i,o,a=e.position.values;(r.normal||r.binormal)&&(i=e.normal.values,o=e.binormal.values);var s,l=e.position.values.length/18,u=3*l,c=2*l,h=2*u;if(r.normal||r.binormal||r.tangent){var d=r.normal?new Float32Array(6*u):void 0,p=r.binormal?new Float32Array(6*u):void 0,m=r.tangent?new Float32Array(6*u):void 0,f=w,v=T,_=x,g=b,y=P,C=A,E=h;for(s=0;u>s;s+=3){var S=E+h;f=t.fromArray(a,s,f),v=t.fromArray(a,s+u,v),_=t.fromArray(a,(s+3)%u,_),v=t.subtract(v,f,v),_=t.subtract(_,f,_),g=t.normalize(t.cross(v,_,g),g),r.normal&&(n.addAttribute(d,g,S),n.addAttribute(d,g,S+3),n.addAttribute(d,g,E),n.addAttribute(d,g,E+3)),(r.tangent||r.binormal)&&(C=t.fromArray(i,s,C),r.binormal&&(n.addAttribute(p,C,S),n.addAttribute(p,C,S+3),n.addAttribute(p,C,E),n.addAttribute(p,C,E+3)),r.tangent&&(y=t.normalize(t.cross(C,g,y),y),n.addAttribute(m,y,S),n.addAttribute(m,y,S+3),n.addAttribute(m,y,E),n.addAttribute(m,y,E+3))),E+=6}if(r.normal){for(d.set(i),s=0;u>s;s+=3)d[s+u]=-i[s],d[s+u+1]=-i[s+1],d[s+u+2]=-i[s+2];e.normal.values=d}else e.normal=void 0;if(r.binormal?(p.set(o),p.set(o,u),e.binormal.values=p):e.binormal=void 0,r.tangent){var I=e.tangent.values;m.set(I),m.set(I,u),e.tangent.values=m}}if(r.st){var M=e.st.values,D=new Float32Array(6*c);D.set(M),D.set(M,c);for(var R=2*c,O=0;2>O;O++){for(D[R++]=M[0],D[R++]=M[1],s=2;c>s;s+=2){var N=M[s],L=M[s+1];D[R++]=N,D[R++]=L,D[R++]=N,D[R++]=L}D[R++]=M[0],D[R++]=M[1]}e.st.values=D}return e}function C(e,t,r){r[t++]=e[0],r[t++]=e[1],r[t++]=e[2];for(var i=3;i<e.length;i+=3){var n=e[i],o=e[i+1],a=e[i+2];r[t++]=n,r[t++]=o,r[t++]=a,r[t++]=n,r[t++]=o,r[t++]=a}return r[t++]=e[0],r[t++]=e[1],r[t++]=e[2],r}function E(e,t){var r=new v({position:t.positon,normal:t.normal||t.binormal,tangent:t.tangent,binormal:t.normal||t.binormal,st:t.st}),i=e.ellipsoid,o=n.computePositions(e),a=g(o,r,i),s=e.height,l=e.extrudedHeight,u=a.attributes,c=a.indices,h=u.position.values,p=h.length,m=new Float64Array(6*p),f=new Float64Array(p);
f.set(h);var _=new Float64Array(4*p);h=n.scaleToGeodeticHeight(h,s,i,h),_=C(h,0,_),f=n.scaleToGeodeticHeight(f,l,i,f),_=C(f,2*p,_),m.set(h),m.set(f,p),m.set(_,2*p),u.position.values=m,p/=3;var E,S=c.length,w=p+p,T=d.createTypedArray(m.length/3,2*S+3*w);T.set(c);var x=S;for(E=0;S>E;E+=3){var b=c[E],P=c[E+1],A=c[E+2];T[x++]=A+p,T[x++]=P+p,T[x++]=b+p}u=y(u,t);var I,M,D,R;for(E=0;w>E;E+=2)I=E+w,M=I+w,D=I+1,R=M+1,T[x++]=I,T[x++]=M,T[x++]=D,T[x++]=D,T[x++]=M,T[x++]=R;return{attributes:u,indices:T}}function S(e){e=o(e,o.EMPTY_OBJECT);var r=e.positions,n=e.width;this._positions=r,this._ellipsoid=l.clone(o(e.ellipsoid,l.WGS84)),this._vertexFormat=v.clone(o(e.vertexFormat,v.DEFAULT)),this._width=n,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,i.ROUNDED),this._granularity=o(e.granularity,p.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry",this.packedLength=1+r.length*t.packedLength+l.packedLength+v.packedLength+5}var w=new t,T=new t,x=new t,b=new t,P=new t,A=new t,I=new t,M=new t;S.pack=function(e,r,i){i=o(i,0);var n=e._positions,a=n.length;r[i++]=a;for(var s=0;a>s;++s,i+=t.packedLength)t.pack(n[s],r,i);l.pack(e._ellipsoid,r,i),i+=l.packedLength,v.pack(e._vertexFormat,r,i),i+=v.packedLength,r[i++]=e._width,r[i++]=e._height,r[i++]=e._extrudedHeight,r[i++]=e._cornerType,r[i]=e._granularity};var D=l.clone(l.UNIT_SPHERE),R=new v,O={positions:void 0,ellipsoid:D,vertexFormat:R,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return S.unpack=function(e,r,i){r=o(r,0);for(var n=e[r++],s=new Array(n),u=0;n>u;++u,r+=t.packedLength)s[u]=t.unpack(e,r);var c=l.unpack(e,r,D);r+=l.packedLength;var h=v.unpack(e,r,R);r+=v.packedLength;var d=e[r++],p=e[r++],m=e[r++],f=e[r++],_=e[r];return a(i)?(i._positions=s,i._ellipsoid=l.clone(c,i._ellipsoid),i._vertexFormat=v.clone(h,i._vertexFormat),i._width=d,i._height=p,i._extrudedHeight=m,i._cornerType=f,i._granularity=_,i):(O.positions=s,O.width=d,O.height=p,O.extrudedHeight=m,O.cornerType=f,O.granularity=_,new S(O))},S.createGeometry=function(t){var r=t._positions,i=t._height,o=t._extrudedHeight,a=i!==o,s=m.removeDuplicates(r);if(!(s.length<2)){var l,c=t._ellipsoid,h=t._vertexFormat,d={ellipsoid:c,positions:s,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!0};if(a){var p=Math.max(i,o);o=Math.min(i,o),i=p,d.height=i,d.extrudedHeight=o,l=E(d,h)}else{var v=n.computePositions(d);l=g(v,h,c),l.attributes.position.values=n.scaleToGeodeticHeight(l.attributes.position.values,i,c,l.attributes.position.values)}var _=l.attributes,y=e.fromVertices(_.position.values,void 0,3);return h.position||(l.attributes.position.values=void 0),new u({attributes:_,indices:l.indices,primitiveType:f.TRIANGLES,boundingSphere:y})}},S.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new S({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:i,extrudedHeight:o,height:a,vertexFormat:v.POSITION_ONLY})},S}),r("Core/CorridorOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f){"use strict";function v(e,o){var s,l,u,p=[],m=e.positions,f=e.corners,v=e.endPositions,_=new h,g=0,S=0,w=0;for(l=0;l<m.length;l+=2)u=m[l].length-3,g+=u,w+=u/3*4,S+=m[l+1].length-3;for(g+=3,S+=3,l=0;l<f.length;l++){s=f[l];var T=f[l].leftPositions;a(T)?(u=T.length,g+=u,w+=u/3*2):(u=f[l].rightPositions.length,S+=u,w+=u/3*2)}var x,b=a(v);b&&(x=v[0].length-3,g+=x,S+=x,x/=3,w+=4*x);var P,A,I,M,D,R,O=g+S,N=new Float64Array(O),L=0,F=O-1,B=x/2,V=d.createTypedArray(O/3,w+4),z=0;if(V[z++]=L/3,V[z++]=(F-2)/3,b){p.push(L/3),R=y,D=C;var k=v[0];for(l=0;B>l;l++)R=t.fromArray(k,3*(B-1-l),R),D=t.fromArray(k,3*(B+l),D),n.addAttribute(N,D,L),n.addAttribute(N,R,void 0,F),A=L/3,M=A+1,P=(F-2)/3,I=P-1,V[z++]=P,V[z++]=I,V[z++]=A,V[z++]=M,L+=3,F-=3}var U=0,G=m[U++],W=m[U++];for(N.set(G,L),N.set(W,F-W.length+1),u=W.length-3,p.push(L/3,(F-2)/3),l=0;u>l;l+=3)A=L/3,M=A+1,P=(F-2)/3,I=P-1,V[z++]=P,V[z++]=I,V[z++]=A,V[z++]=M,L+=3,F-=3;for(l=0;l<f.length;l++){var H;s=f[l];var q,j=s.leftPositions,Y=s.rightPositions,X=E;if(a(j)){for(F-=3,q=I,p.push(M),H=0;H<j.length/3;H++)X=t.fromArray(j,3*H,X),V[z++]=q-H-1,V[z++]=q-H,n.addAttribute(N,X,void 0,F),F-=3;p.push(q-Math.floor(j.length/6)),o===i.BEVELED&&p.push((F-2)/3+1),L+=3}else{for(L+=3,q=M,p.push(I),H=0;H<Y.length/3;H++)X=t.fromArray(Y,3*H,X),V[z++]=q+H,V[z++]=q+H+1,n.addAttribute(N,X,L),L+=3;p.push(q+Math.floor(Y.length/6)),o===i.BEVELED&&p.push(L/3-1),F-=3}for(G=m[U++],W=m[U++],G.splice(0,3),W.splice(W.length-3,3),N.set(G,L),N.set(W,F-W.length+1),u=W.length-3,H=0;H<W.length;H+=3)M=L/3,A=M-1,I=(F-2)/3,P=I+1,V[z++]=P,V[z++]=I,V[z++]=A,V[z++]=M,L+=3,F-=3;L-=3,F+=3,p.push(L/3,(F-2)/3)}if(b){L+=3,F-=3,R=y,D=C;var Z=v[1];for(l=0;B>l;l++)R=t.fromArray(Z,3*(x-l-1),R),D=t.fromArray(Z,3*l,D),n.addAttribute(N,R,void 0,F),n.addAttribute(N,D,L),M=L/3,A=M-1,I=(F-2)/3,P=I+1,V[z++]=P,V[z++]=I,V[z++]=A,V[z++]=M,L+=3,F-=3;p.push(L/3)}else p.push(L/3,(F-2)/3);return V[z++]=L/3,V[z++]=(F-2)/3,_.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:N}),{attributes:_,indices:V,wallIndices:p}}function _(e){var t=e.ellipsoid,r=n.computePositions(e),i=v(r,e.cornerType),o=i.wallIndices,a=e.height,s=e.extrudedHeight,l=i.attributes,u=i.indices,c=l.position.values,h=c.length,p=new Float64Array(h);p.set(c);var m=new Float64Array(2*h);c=n.scaleToGeodeticHeight(c,a,t,c),p=n.scaleToGeodeticHeight(p,s,t,p),m.set(c),m.set(p,h),l.position.values=m,h/=3;var f,_=u.length,g=d.createTypedArray(m.length/3,2*(_+o.length));g.set(u);var y=_;for(f=0;_>f;f+=2){var C=u[f],E=u[f+1];g[y++]=C+h,g[y++]=E+h}var S,w;for(f=0;f<o.length;f++)S=o[f],w=S+h,g[y++]=S,g[y++]=w;return{attributes:l,indices:g}}function g(e){e=o(e,o.EMPTY_OBJECT);var r=e.positions,n=e.width;this._positions=r,this._ellipsoid=l.clone(o(e.ellipsoid,l.WGS84)),this._width=n,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,i.ROUNDED),this._granularity=o(e.granularity,p.RADIANS_PER_DEGREE),this._workerName="createCorridorOutlineGeometry",this.packedLength=1+r.length*t.packedLength+l.packedLength+5}var y=new t,C=new t,E=new t;g.pack=function(e,r,i){i=o(i,0);var n=e._positions,a=n.length;r[i++]=a;for(var s=0;a>s;++s,i+=t.packedLength)t.pack(n[s],r,i);l.pack(e._ellipsoid,r,i),i+=l.packedLength,r[i++]=e._width,r[i++]=e._height,r[i++]=e._extrudedHeight,r[i++]=e._cornerType,r[i]=e._granularity};var S=l.clone(l.UNIT_SPHERE),w={positions:void 0,ellipsoid:S,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return g.unpack=function(e,r,i){r=o(r,0);for(var n=e[r++],s=new Array(n),u=0;n>u;++u,r+=t.packedLength)s[u]=t.unpack(e,r);var c=l.unpack(e,r,S);r+=l.packedLength;var h=e[r++],d=e[r++],p=e[r++],m=e[r++],f=e[r];return a(i)?(i._positions=s,i._ellipsoid=l.clone(c,i._ellipsoid),i._width=h,i._height=d,i._extrudedHeight=p,i._cornerType=m,i._granularity=f,i):(w.positions=s,w.width=h,w.height=d,w.extrudedHeight=p,w.cornerType=m,w.granularity=f,new g(w))},g.createGeometry=function(t){var r=t._positions,i=t._height,o=t._extrudedHeight,a=i!==o,s=m.removeDuplicates(r);if(!(s.length<2)){var l,c=t._ellipsoid,h={ellipsoid:c,positions:s,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!1};if(a){var d=Math.max(i,o);o=Math.min(i,o),i=d,h.height=i,h.extrudedHeight=o,l=_(h)}else{var p=n.computePositions(h);l=v(p,h.cornerType),l.attributes.position.values=n.scaleToGeodeticHeight(l.attributes.position.values,i,c,l.attributes.position.values)}var g=l.attributes,y=e.fromVertices(g.position.values,void 0,3);return new u({attributes:g,indices:l.indices,primitiveType:f.LINES,boundingSphere:y})}},g}),r("Core/createGuid",[],function(){"use strict";function e(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0,r="x"===e?t:3&t|8;return r.toString(16)})}return e}),r("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,i,n,o){var a,s=.5*t,l=-s,u=n+n,c=o?2*u:u,h=new Float64Array(3*c),d=0,p=0,m=o?3*u:0,f=o?3*(u+n):3*n;for(a=0;n>a;a++){var v=a/n*e.TWO_PI,_=Math.cos(v),g=Math.sin(v),y=_*i,C=g*i,E=_*r,S=g*r;h[p+m]=y,h[p+m+1]=C,h[p+m+2]=l,h[p+f]=E,h[p+f+1]=S,h[p+f+2]=s,p+=3,o&&(h[d++]=y,h[d++]=C,h[d++]=l,h[d++]=E,h[d++]=S,h[d++]=s)}return h},t}),r("Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,r=e.topRadius,i=e.bottomRadius,n=o(e.vertexFormat,m.DEFAULT),a=o(e.slices,128);this._length=t,this._topRadius=r,this._bottomRadius=i,this._vertexFormat=m.clone(n),this._slices=a,this._workerName="createCylinderGeometry"}var v=new t,_=new r,g=new r,y=new r,C=new r;f.packedLength=m.packedLength+4,f.pack=function(e,t,r){r=o(r,0),m.pack(e._vertexFormat,t,r),r+=m.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r]=e._slices};var E=new m,S={vertexFormat:E,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};return f.unpack=function(e,t,r){t=o(t,0);var i=m.unpack(e,t,E);t+=m.packedLength;var n=e[t++],s=e[t++],l=e[t++],u=e[t];return a(r)?(r._vertexFormat=m.clone(i,r._vertexFormat),r._length=n,r._topRadius=s,r._bottomRadius=l,r._slices=u,r):(S.length=n,S.topRadius=s,S.bottomRadius=l,S.slices=u,new f(S))},f.createGeometry=function(o){var a,s=o._length,m=o._topRadius,f=o._bottomRadius,E=o._vertexFormat,S=o._slices,w=S+S,T=S+w,x=w+w,b=n.computePositions(s,m,f,S,!0),P=E.st?new Float32Array(2*x):void 0,A=E.normal?new Float32Array(3*x):void 0,I=E.tangent?new Float32Array(3*x):void 0,M=E.binormal?new Float32Array(3*x):void 0,D=E.normal||E.tangent||E.binormal;if(D){var R=E.tangent||E.binormal,O=0,N=0,L=0,F=_;F.z=0;var B=y,V=g;for(a=0;S>a;a++){var z=a/S*d.TWO_PI,k=Math.cos(z),U=Math.sin(z);D&&(F.x=k,F.y=U,R&&(B=r.normalize(r.cross(r.UNIT_Z,F,B),B)),E.normal&&(A[O++]=k,A[O++]=U,A[O++]=0,A[O++]=k,A[O++]=U,A[O++]=0),E.tangent&&(I[N++]=B.x,I[N++]=B.y,I[N++]=B.z,I[N++]=B.x,I[N++]=B.y,I[N++]=B.z),E.binormal&&(V=r.normalize(r.cross(F,B,V),V),M[L++]=V.x,M[L++]=V.y,M[L++]=V.z,M[L++]=V.x,M[L++]=V.y,M[L++]=V.z))}for(a=0;S>a;a++)E.normal&&(A[O++]=0,A[O++]=0,A[O++]=-1),E.tangent&&(I[N++]=1,I[N++]=0,I[N++]=0),E.binormal&&(M[L++]=0,M[L++]=-1,M[L++]=0);for(a=0;S>a;a++)E.normal&&(A[O++]=0,A[O++]=0,A[O++]=1),E.tangent&&(I[N++]=1,I[N++]=0,I[N++]=0),E.binormal&&(M[L++]=0,M[L++]=1,M[L++]=0)}var G=12*S-12,W=h.createTypedArray(x,G),H=0,q=0;for(a=0;S-1>a;a++)W[H++]=q,W[H++]=q+2,W[H++]=q+3,W[H++]=q,W[H++]=q+3,W[H++]=q+1,q+=2;for(W[H++]=w-2,W[H++]=0,W[H++]=1,W[H++]=w-2,W[H++]=1,W[H++]=w-1,a=1;S-1>a;a++)W[H++]=w+a+1,W[H++]=w+a,W[H++]=w;for(a=1;S-1>a;a++)W[H++]=T,W[H++]=T+a,W[H++]=T+a+1;var j=0;if(E.st){var Y=Math.max(m,f);for(a=0;x>a;a++){var X=r.fromArray(b,3*a,C);P[j++]=(X.x+Y)/(2*Y),P[j++]=(X.y+Y)/(2*Y)}}var Z=new c;E.position&&(Z.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:b})),E.normal&&(Z.normal=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),E.tangent&&(Z.tangent=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:I})),E.binormal&&(Z.binormal=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:M})),E.st&&(Z.st=new u({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:P})),v.x=.5*s,v.y=Math.max(f,m);var K=new e(r.ZERO,t.magnitude(v));return new l({attributes:Z,indices:W,primitiveType:p.TRIANGLES,boundingSphere:K})},f}),r("Core/CylinderOutlineGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,r=e.topRadius,i=e.bottomRadius,n=o(e.slices,128),a=Math.max(o(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=r,this._bottomRadius=i,this._slices=n,this._numberOfVerticalLines=a,this._workerName="createCylinderOutlineGeometry"}var m=new t;p.packedLength=5,p.pack=function(e,t,r){r=o(r,0),t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r++]=e._slices,t[r]=e._numberOfVerticalLines};var f={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0};return p.unpack=function(e,t,r){t=o(t,0);var i=e[t++],n=e[t++],s=e[t++],l=e[t++],u=e[t];return a(r)?(r._length=i,r._topRadius=n,r._bottomRadius=s,r._slices=l,r._numberOfVerticalLines=u,r):(f.length=i,f.topRadius=n,f.bottomRadius=s,f.slices=l,f.numberOfVerticalLines=u,new p(f))},p.createGeometry=function(o){var a,s=o._length,p=o._topRadius,f=o._bottomRadius,v=o._slices,_=o._numberOfVerticalLines,g=2*v,y=n.computePositions(s,p,f,v,!1),C=2*v;if(_>0){var E=Math.min(_,v);a=Math.round(v/E),C+=E}for(var S=h.createTypedArray(g,2*C),w=0,T=0;v-1>T;T++)S[w++]=T,S[w++]=T+1,S[w++]=T+v,S[w++]=T+1+v;if(S[w++]=v-1,S[w++]=0,S[w++]=v+v-1,S[w++]=v,_>0)for(T=0;v>T;T+=a)S[w++]=T,S[w++]=T+v;var x=new c;x.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:y}),m.x=.5*s,m.y=Math.max(f,p);var b=new e(r.ZERO,t.magnitude(m));return new l({attributes:x,indices:S,primitiveType:d.LINES,boundingSphere:b})},p}),r("Core/DefaultProxy",[],function(){"use strict";function e(e){this.proxy=e}return e.prototype.getURL=function(e){return this.proxy+"?"+encodeURIComponent(e)},e}),r("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";function r(t,r){e(i[t])||(i[t]=!0,console.log(r))}var i={};return r}),r("ThirdParty/Tween",[],function(){void 0===Date.now&&(Date.now=function(){return(new Date).valueOf()});var e=e||function(){var e=[];return{REVISION:"13",getAll:function(){return e},removeAll:function(){e=[]},add:function(t){e.push(t)},remove:function(t){var r=e.indexOf(t);-1!==r&&e.splice(r,1)},update:function(t){if(0===e.length)return!1;var r=0;for(t=void 0!==t?t:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now();r<e.length;)e[r].update(t)?r++:e.splice(r,1);return!0}}}();return e.Tween=function(t){var r=t,i={},n={},o={},a=1e3,s=0,l=!1,u=!1,c=!1,h=0,d=null,p=e.Easing.Linear.None,m=e.Interpolation.Linear,f=[],v=null,_=!1,g=null,y=null,C=null;for(var E in t)i[E]=parseFloat(t[E],10);this.to=function(e,t){return void 0!==t&&(a=t),n=e,this},this.start=function(t){e.add(this),u=!0,_=!1,d=void 0!==t?t:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now(),d+=h;for(var a in n){if(n[a]instanceof Array){if(0===n[a].length)continue;n[a]=[r[a]].concat(n[a])}i[a]=r[a],i[a]instanceof Array==!1&&(i[a]*=1),o[a]=i[a]||0}return this},this.stop=function(){return u?(e.remove(this),u=!1,null!==C&&C.call(r),this.stopChainedTweens(),this):this},this.stopChainedTweens=function(){for(var e=0,t=f.length;t>e;e++)f[e].stop()},this.delay=function(e){return h=e,this},this.repeat=function(e){return s=e,this},this.yoyo=function(e){return l=e,this},this.easing=function(e){return p=e,this},this.interpolation=function(e){return m=e,this},this.chain=function(){return f=arguments,this},this.onStart=function(e){return v=e,this},this.onUpdate=function(e){return g=e,this},this.onComplete=function(e){return y=e,this},this.onStop=function(e){return C=e,this},this.update=function(e){var t;if(d>e)return!0;_===!1&&(null!==v&&v.call(r),_=!0);var u=(e-d)/a;u=u>1?1:u;var C=p(u);for(t in n){var E=i[t]||0,S=n[t];S instanceof Array?r[t]=m(S,C):("string"==typeof S&&(S=E+parseFloat(S,10)),"number"==typeof S&&(r[t]=E+(S-E)*C))}if(null!==g&&g.call(r,C),1==u){if(s>0){isFinite(s)&&s--;for(t in o){if("string"==typeof n[t]&&(o[t]=o[t]+parseFloat(n[t],10)),l){var w=o[t];o[t]=n[t],n[t]=w}i[t]=o[t]}return l&&(c=!c),d=e+h,!0}null!==y&&y.call(r);for(var T=0,x=f.length;x>T;T++)f[T].start(e);return!1}return!0}},e.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),-(r*Math.pow(2,10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/i)))},Out:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),r*Math.pow(2,-10*e)*Math.sin((e-t)*(2*Math.PI)/i)+1)},InOut:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),(e*=2)<1?-.5*(r*Math.pow(2,10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/i)):r*Math.pow(2,-10*(e-=1))*Math.sin((e-t)*(2*Math.PI)/i)*.5+1)}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?.5*(e*e*((t+1)*e-t)):.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(t){return 1-e.Easing.Bounce.Out(1-t)},Out:function(e){return 1/2.75>e?7.5625*e*e:2/2.75>e?7.5625*(e-=1.5/2.75)*e+.75:2.5/2.75>e?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(t){return.5>t?.5*e.Easing.Bounce.In(2*t):.5*e.Easing.Bounce.Out(2*t-1)+.5}}},e.Interpolation={Linear:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.Linear;return 0>r?a(t[0],t[1],n):r>1?a(t[i],t[i-1],i-n):a(t[o],t[o+1>i?i:o+1],n-o)},Bezier:function(t,r){var i,n=0,o=t.length-1,a=Math.pow,s=e.Interpolation.Utils.Bernstein;for(i=0;o>=i;i++)n+=a(1-r,o-i)*a(r,i)*t[i]*s(o,i);return n},CatmullRom:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.CatmullRom;return t[0]===t[i]?(0>r&&(o=Math.floor(n=i*(1+r))),a(t[(o-1+i)%i],t[o],t[(o+1)%i],t[(o+2)%i],n-o)):0>r?t[0]-(a(t[0],t[0],t[1],t[1],-n)-t[0]):r>1?t[i]-(a(t[i],t[i],t[i-1],t[i-1],n-i)-t[i]):a(t[o?o-1:0],t[o],t[o+1>i?i:o+1],t[o+2>i?i:o+2],n-o)},Utils:{Linear:function(e,t,r){return(t-e)*r+e},Bernstein:function(t,r){var i=e.Interpolation.Utils.Factorial;return i(t)/i(r)/i(t-r)},Factorial:function(){var e=[1];return function(t){var r,i=1;if(e[t])return e[t];for(r=t;r>1;r--)i*=r;return e[t]=i}}(),CatmullRom:function(e,t,r,i,n){var o=.5*(r-e),a=.5*(i-t),s=n*n,l=n*s;return(2*t-2*r+o+a)*l+(-3*t+3*r-2*o-a)*s+o*n+t}}},e}),r("Core/EasingFunction",["../ThirdParty/Tween","./freezeObject"],function(e,t){"use strict";var r={LINEAR_NONE:e.Easing.Linear.None,QUADRACTIC_IN:e.Easing.Quadratic.In,QUADRACTIC_OUT:e.Easing.Quadratic.Out,QUADRACTIC_IN_OUT:e.Easing.Quadratic.InOut,CUBIC_IN:e.Easing.Cubic.In,CUBIC_OUT:e.Easing.Cubic.Out,CUBIC_IN_OUT:e.Easing.Cubic.InOut,QUARTIC_IN:e.Easing.Quartic.In,QUARTIC_OUT:e.Easing.Quartic.Out,QUARTIC_IN_OUT:e.Easing.Quartic.InOut,QUINTIC_IN:e.Easing.Quintic.In,QUINTIC_OUT:e.Easing.Quintic.Out,QUINTIC_IN_OUT:e.Easing.Quintic.InOut,SINUSOIDAL_IN:e.Easing.Sinusoidal.In,SINUSOIDAL_OUT:e.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:e.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:e.Easing.Exponential.In,EXPONENTIAL_OUT:e.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:e.Easing.Exponential.InOut,CIRCULAR_IN:e.Easing.Circular.In,CIRCULAR_OUT:e.Easing.Circular.Out,CIRCULAR_IN_OUT:e.Easing.Circular.InOut,ELASTIC_IN:e.Easing.Elastic.In,ELASTIC_OUT:e.Easing.Elastic.Out,ELASTIC_IN_OUT:e.Easing.Elastic.InOut,BACK_IN:e.Easing.Back.In,BACK_OUT:e.Easing.Back.Out,BACK_IN_OUT:e.Easing.Back.InOut,BOUNCE_IN:e.Easing.Bounce.In,BOUNCE_OUT:e.Easing.Bounce.Out,BOUNCE_IN_OUT:e.Easing.Bounce.InOut};return t(r)}),r("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e){e=n(e,n.EMPTY_OBJECT);var t=n(e.radii,E),i=n(e.stackPartitions,64),o=n(e.slicePartitions,64),a=n(e.vertexFormat,m.DEFAULT);this._radii=r.clone(t),this._stackPartitions=i,this._slicePartitions=o,this._vertexFormat=m.clone(a),this._workerName="createEllipsoidGeometry"}var v=new r,_=new r,g=new r,y=new r,C=new r,E=new r(1,1,1),S=Math.cos,w=Math.sin;f.packedLength=r.packedLength+m.packedLength+2,f.pack=function(e,t,i){i=n(i,0),r.pack(e._radii,t,i),i+=r.packedLength,m.pack(e._vertexFormat,t,i),i+=m.packedLength,t[i++]=e._stackPartitions,t[i]=e._slicePartitions};var T=new r,x=new m,b={radii:T,vertexFormat:x,stackPartitions:void 0,slicePartitions:void 0};return f.unpack=function(e,t,i){t=n(t,0);var a=r.unpack(e,t,T);t+=r.packedLength;var s=m.unpack(e,t,x);t+=m.packedLength;var l=e[t++],u=e[t];return o(i)?(i._radii=r.clone(a,i._radii),i._vertexFormat=m.clone(s,i._vertexFormat),i._stackPartitions=l,i._slicePartitions=u,i):(b.stackPartitions=l,b.slicePartitions=u,new f(b))},f.createGeometry=function(n){var o,a,m=n._radii,f=s.fromCartesian3(m),E=n._vertexFormat,T=n._slicePartitions+1,x=n._stackPartitions+1,b=x*T,P=new Float64Array(3*b),A=6*(T-1)*(x-1),I=h.createTypedArray(b,A),M=E.normal?new Float32Array(3*b):void 0,D=E.tangent?new Float32Array(3*b):void 0,R=E.binormal?new Float32Array(3*b):void 0,O=E.st?new Float32Array(2*b):void 0,N=new Array(T),L=new Array(T),F=0;for(o=0;T>o;o++){var B=d.TWO_PI*o/(T-1);N[o]=S(B),L[o]=w(B),P[F++]=0,P[F++]=0,P[F++]=m.z}for(o=1;x-1>o;o++){var V=Math.PI*o/(x-1),z=w(V),k=m.x*z,U=m.y*z,G=m.z*S(V);for(a=0;T>a;a++)P[F++]=N[a]*k,P[F++]=L[a]*U,P[F++]=G}for(o=0;T>o;o++)P[F++]=0,P[F++]=0,P[F++]=-m.z;var W=new c;E.position&&(W.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:P}));var H=0,q=0,j=0,Y=0;if(E.st||E.normal||E.tangent||E.binormal){for(o=0;b>o;o++){var X=r.fromArray(P,3*o,v),Z=f.geodeticSurfaceNormal(X,_);if(E.st){var K=t.negate(Z,C);t.magnitude(K)<d.EPSILON6&&(F=3*(o+T*Math.floor(.5*x)),F>P.length&&(F=3*(o-T*Math.floor(.5*x))),r.fromArray(P,F,K),f.geodeticSurfaceNormal(K,K),t.negate(K,K)),O[H++]=Math.atan2(K.y,K.x)/d.TWO_PI+.5,O[H++]=Math.asin(Z.z)/Math.PI+.5}if(E.normal&&(M[q++]=Z.x,M[q++]=Z.y,M[q++]=Z.z),E.tangent||E.binormal){var Q=g;if(T>o||o>b-T-1?(r.cross(r.UNIT_X,Z,Q),r.normalize(Q,Q)):(r.cross(r.UNIT_Z,Z,Q),r.normalize(Q,Q)),E.tangent&&(D[j++]=Q.x,D[j++]=Q.y,D[j++]=Q.z),E.binormal){var J=r.cross(Z,Q,y);r.normalize(J,J),R[Y++]=J.x,R[Y++]=J.y,R[Y++]=J.z}}}E.st&&(W.st=new u({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:O})),E.normal&&(W.normal=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:M})),E.tangent&&(W.tangent=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:D})),E.binormal&&(W.binormal=new u({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R}))}for(F=0,o=0;x>o;o++){var $=o*T,ee=(o+1)*T;for(a=0;T-1>a;a++)I[F++]=ee+a,I[F++]=ee+a+1,I[F++]=$+a+1,I[F++]=ee+a,I[F++]=$+a+1,I[F++]=$+a}return new l({attributes:W,indices:I,primitiveType:p.TRIANGLES,boundingSphere:e.fromEllipsoid(f)})},f}),r("Core/EllipsoidOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(e){e=i(e,i.EMPTY_OBJECT);var r=i(e.radii,m),n=i(e.stackPartitions,10),o=i(e.slicePartitions,8),a=i(e.subdivisions,128);this._radii=t.clone(r),this._stackPartitions=n,this._slicePartitions=o,this._subdivisions=a,this._workerName="createEllipsoidOutlineGeometry"}var m=new t(1,1,1),f=Math.cos,v=Math.sin;p.packedLength=t.packedLength+3,p.pack=function(e,r,n){n=i(n,0),t.pack(e._radii,r,n),n+=t.packedLength,r[n++]=e._stackPartitions,r[n++]=e._slicePartitions,r[n]=e._subdivisions};var _=new t,g={radii:_,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return p.unpack=function(e,r,o){r=i(r,0);var a=t.unpack(e,r,_);r+=t.packedLength;var s=e[r++],l=e[r++],u=e[r++];return n(o)?(o._radii=t.clone(a,o._radii),o._stackPartitions=s,o._slicePartitions=l,o._subdivisions=u,o):(g.stackPartitions=s,g.slicePartitions=l,g.subdivisions=u,new p(g))},p.createGeometry=function(t){var i,n,o,p,m,_,g=t._radii,y=a.fromCartesian3(g),C=t._stackPartitions,E=t._slicePartitions,S=t._subdivisions,w=S*(C+E-1),T=w-E+2,x=new Float64Array(3*T),b=c.createTypedArray(T,2*w),P=0,A=new Array(S),I=new Array(S);for(i=0;S>i;i++)o=h.TWO_PI*i/S,A[i]=f(o),I[i]=v(o);for(i=1;C>i;i++)for(p=Math.PI*i/C,m=f(p),_=v(p),n=0;S>n;n++)x[P++]=g.x*A[n]*_,x[P++]=g.y*I[n]*_,x[P++]=g.z*m;for(A.length=E,I.length=E,i=0;E>i;i++)o=h.TWO_PI*i/E,A[i]=f(o),I[i]=v(o);for(x[P++]=0,x[P++]=0,x[P++]=g.z,i=1;S>i;i++)for(p=Math.PI*i/S,m=f(p),_=v(p),n=0;E>n;n++)x[P++]=g.x*A[n]*_,x[P++]=g.y*I[n]*_,x[P++]=g.z*m;for(x[P++]=0,x[P++]=0,x[P++]=-g.z,P=0,i=0;C-1>i;++i){var M=i*S;for(n=0;S-1>n;++n)b[P++]=M+n,b[P++]=M+n+1;b[P++]=M+S-1,b[P++]=M}var D=S*(C-1);for(n=1;E+1>n;++n)b[P++]=D,b[P++]=D+n;for(i=0;S-2>i;++i){var R=i*E+1+D,O=(i+1)*E+1+D;for(n=0;E-1>n;++n)b[P++]=O+n,b[P++]=R+n;b[P++]=O+E-1,b[P++]=R+E-1}var N=x.length/3-1;for(n=N-1;n>N-E-1;--n)b[P++]=N,b[P++]=n;var L=new u({position:new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:x})});return new s({attributes:L,indices:b,primitiveType:d.LINES,boundingSphere:e.fromEllipsoid(y)})},p}),r("Core/EllipsoidTerrainProvider",["../ThirdParty/when","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Event","./GeographicTilingScheme","./HeightmapTerrainData","./TerrainProvider"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(i){i=t(i,{}),this._tilingScheme=i.tilingScheme,r(this._tilingScheme)||(this._tilingScheme=new a({ellipsoid:t(i.ellipsoid,n.WGS84)})),this._levelZeroMaximumGeometricError=l.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0));var u=16,c=16;this._terrainData=new s({buffer:new Uint8Array(u*c),width:16,height:16}),this._errorEvent=new o,this._readyPromise=e.resolve(!0)}return i(u.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),u.prototype.requestTileGeometry=function(e,t,r,i){return this._terrainData},u.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},u.prototype.getTileDataAvailable=function(e,t,r){},u}),r("Core/EventHelper",["./defined","./DeveloperError"],function(e,t){"use strict";function r(){this._removalFunctions=[]}return r.prototype.add=function(e,t,r){var i=e.addEventListener(t,r);this._removalFunctions.push(i);var n=this;return function(){i();var e=n._removalFunctions;e.splice(e.indexOf(i),1)}},r.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,r=e.length;r>t;++t)e[t]();e.length=0},r}),r("Core/ExtrapolationType",["./freezeObject"],function(e){"use strict";var t={NONE:0,HOLD:1,EXTRAPOLATE:2};return e(t)}),r("Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.value=t.value}return i}),r("Core/getBaseUri",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){var t="",r=e.lastIndexOf("/");return-1!==r&&(t=e.substring(0,r+1)),t}return r}),r("Core/getFilenameFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t){var r=new e(t);r.normalize();var i=r.path,n=i.lastIndexOf("/");return-1!==n&&(i=i.substr(n+1)),i}return i}),r("Core/getStringFromTypedArray",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,n){return r=e(r,0),n=e(n,t.byteLength-r),t=t.subarray(r,r+n),i.decode(t)}return i.decodeWithTextDecoder=function(e){var t=new TextDecoder("utf-8");return t.decode(e)},i.decodeWithFromCharCode=function(e){for(var t="",r=e.length,i=0;r>i;++i)t+=String.fromCharCode(e[i]);return t},"undefined"!=typeof TextDecoder?i.decode=i.decodeWithTextDecoder:i.decode=i.decodeWithFromCharCode,i}),r("Core/getMagic",["../Core/defaultValue","../Core/getStringFromTypedArray"],function(e,t){"use strict";function r(r,i){return i=e(i,0),t(r,i,Math.min(4,r.length))}return r}),r("Core/HeadingPitchRange",["./defaultValue","./defined"],function(e,t){"use strict";function r(t,r,i){this.heading=e(t,0),this.pitch=e(r,0),this.range=e(i,0)}return r.clone=function(e,i){return t(e)?(t(i)||(i=new r),i.heading=e.heading,i.pitch=e.pitch,i.range=e.range,i):void 0},r}),r("Core/HermitePolynomialApproximation",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,i){"use strict";function n(e,t,r,i,o,a){var s,l,u,c=0;if(i>0){for(l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(a.push(l),c+=n(e,t,r,i-1,o,a),a.splice(a.length-1,1))}return c}for(c=1,l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(c*=e-r[t[l]])}return c}function o(e,t,r,n,o,a){for(var s,l,u=-1,c=t.length,h=c*(c+1)/2,d=0;o>d;d++){var p=Math.floor(d*h);for(s=0;c>s;s++)l=t[s]*o*(a+1)+d,e[p+s]=n[l];for(var m=1;c>m;m++){var f=0,v=Math.floor(m*(1-m)/2)+c*m,_=!1;for(s=0;c-m>s;s++){var g,y,C=r[t[s]],E=r[t[s+m]];if(0>=E-C)l=t[s]*o*(a+1)+o*m+d,g=n[l],y=g/i.factorial(m),e[p+v+f]=y,f++;else{var S=Math.floor((m-1)*(2-m)/2)+c*(m-1);g=e[p+S+s+1]-e[p+S+s],y=g/(E-C),e[p+v+f]=y,f++}_=_||0!==g}_&&(u=Math.max(u,m))}}return u}var a=i.factorial,s={type:"Hermite"};s.getRequiredDataPoints=function(t,r){return r=e(r,0),Math.max(Math.floor((t+1)/(r+1)),2)},s.interpolateOrderZero=function(e,r,i,o,s){t(s)||(s=new Array(o));var l,u,c,h,d,p,m=r.length,f=new Array(o);for(l=0;o>l;l++){s[l]=0;var v=new Array(m);for(f[l]=v,u=0;m>u;u++)v[u]=[]}var _=m,g=new Array(_);for(l=0;_>l;l++)g[l]=l;var y=m-1;for(h=0;o>h;h++){for(u=0;_>u;u++)p=g[u]*o+h,f[h][0].push(i[p]);for(l=1;_>l;l++){var C=!1;for(u=0;_-l>u;u++){var E,S=r[g[u]],w=r[g[u+l]];0>=w-S?(p=g[u]*o+o*l+h,E=i[p],f[h][l].push(E/a(l))):(E=f[h][l-1][u+1]-f[h][l-1][u],f[h][l].push(E/(w-S))),C=C||0!==E}C||(y=l-1)}}for(c=0,d=0;d>=c;c++)for(l=c;y>=l;l++){var T=n(e,g,r,c,l,[]);for(h=0;o>h;h++){var x=f[h][l][0];s[h+c*o]+=x*T}}return s};var l=[];return s.interpolate=function(e,r,i,a,s,u,c){var h=a*(u+1);t(c)||(c=new Array(h));for(var d=0;h>d;d++)c[d]=0;for(var p=r.length,m=new Array(p*(s+1)),f=0;p>f;f++)for(var v=0;s+1>v;v++)m[f*(s+1)+v]=f;
for(var _=m.length,g=l,y=o(g,m,r,i,a,s),C=[],E=_*(_+1)/2,S=Math.min(y,u),w=0;S>=w;w++)for(f=w;y>=f;f++){C.length=0;for(var T=n(e,m,r,w,f,C),x=Math.floor(f*(1-f)/2)+_*f,b=0;a>b;b++){var P=Math.floor(b*E),A=g[P+x];c[b+w*a]+=A*T}}return c},s}),r("Core/IauOrientationParameters",[],function(){"use strict";function e(e,t,r,i){this.rightAscension=e,this.declination=t,this.rotation=r,this.rotationRate=i}return e}),r("Core/Iau2000Orientation",["./defined","./IauOrientationParameters","./JulianDate","./Math","./TimeConstants"],function(e,t,r,i,n){"use strict";var o={},a=32.184,s=2451545,l=-.0529921,u=-.1059842,c=13.0120009,h=13.3407154,d=.9856003,p=26.4057084,m=13.064993,f=.3287146,v=1.7484877,_=-.1589763,g=.0036096,y=.1643573,C=12.9590088,E=new r;return o.ComputeMoon=function(o,S){e(o)||(o=r.now()),E=r.addSeconds(o,a,E);var w=r.totalDays(E)-s,T=w/n.DAYS_PER_JULIAN_CENTURY,x=(125.045+l*w)*i.RADIANS_PER_DEGREE,b=(250.089+u*w)*i.RADIANS_PER_DEGREE,P=(260.008+c*w)*i.RADIANS_PER_DEGREE,A=(176.625+h*w)*i.RADIANS_PER_DEGREE,I=(357.529+d*w)*i.RADIANS_PER_DEGREE,M=(311.589+p*w)*i.RADIANS_PER_DEGREE,D=(134.963+m*w)*i.RADIANS_PER_DEGREE,R=(276.617+f*w)*i.RADIANS_PER_DEGREE,O=(34.226+v*w)*i.RADIANS_PER_DEGREE,N=(15.134+_*w)*i.RADIANS_PER_DEGREE,L=(119.743+g*w)*i.RADIANS_PER_DEGREE,F=(239.961+y*w)*i.RADIANS_PER_DEGREE,B=(25.053+C*w)*i.RADIANS_PER_DEGREE,V=Math.sin(x),z=Math.sin(b),k=Math.sin(P),U=Math.sin(A),G=Math.sin(I),W=Math.sin(M),H=Math.sin(D),q=Math.sin(R),j=Math.sin(O),Y=Math.sin(N),X=Math.sin(L),Z=Math.sin(F),K=Math.sin(B),Q=Math.cos(x),J=Math.cos(b),$=Math.cos(P),ee=Math.cos(A),te=Math.cos(I),re=Math.cos(M),ie=Math.cos(D),ne=Math.cos(R),oe=Math.cos(O),ae=Math.cos(N),se=Math.cos(L),le=Math.cos(F),ue=Math.cos(B),ce=(269.9949+.0031*T-3.8787*V-.1204*z+.07*k-.0172*U+.0072*W-.0052*Y+.0043*K)*i.RADIANS_PER_DEGREE,he=(66.5392+.013*T+1.5419*Q+.0239*J-.0278*$+.0068*ee-.0029*re+9e-4*ie+8e-4*ae-9e-4*ue)*i.RADIANS_PER_DEGREE,de=(38.3213+13.17635815*w-1.4e-12*w*w+3.561*V+.1208*z-.0642*k+.0158*U+.0252*G-.0066*W-.0047*H-.0046*q+.0028*j+.0052*Y+.004*X+.0019*Z-.0044*K)*i.RADIANS_PER_DEGREE,pe=(13.17635815-1.4e-12*(2*w)+3.561*Q*l+.1208*J*u-.0642*$*c+.0158*ee*h+.0252*te*d-.0066*re*p-.0047*ie*m-.0046*ne*f+.0028*oe*v+.0052*ae*_+.004*se*g+.0019*le*y-.0044*ue*C)/86400*i.RADIANS_PER_DEGREE;return e(S)||(S=new t),S.rightAscension=ce,S.declination=he,S.rotation=de,S.rotationRate=pe,S},o}),r("Core/IauOrientationAxes",["./Cartesian3","./defined","./Iau2000Orientation","./JulianDate","./Math","./Matrix3","./Quaternion"],function(e,t,r,i,n,o,a){"use strict";function s(e){t(e)&&"function"==typeof e||(e=r.ComputeMoon),this._computeFunction=e}function l(r,i,a){var s=u;s.x=Math.cos(r+n.PI_OVER_TWO),s.y=Math.sin(r+n.PI_OVER_TWO),s.z=0;var l=Math.cos(i),d=h;d.x=l*Math.cos(r),d.y=l*Math.sin(r),d.z=Math.sin(i);var p=e.cross(d,s,c);return t(a)||(a=new o),a[0]=s.x,a[1]=p.x,a[2]=d.x,a[3]=s.y,a[4]=p.y,a[5]=d.y,a[6]=s.z,a[7]=p.z,a[8]=d.z,a}var u=new e,c=new e,h=new e,d=new o,p=new a;return s.prototype.evaluate=function(r,s){t(r)||(r=i.now());var u=this._computeFunction(r),c=l(u.rightAscension,u.declination,s),h=n.zeroToTwoPi(u.rotation),m=a.fromAxisAngle(e.UNIT_Z,h,p),f=o.fromQuaternion(a.conjugate(m,m),d),v=o.multiply(f,c,c);return v},s}),r("Core/InterpolationAlgorithm",["./DeveloperError"],function(e){"use strict";var t={};return t.type=void 0,t.getRequiredDataPoints=e.throwInstantiationError,t.interpolateOrderZero=e.throwInstantiationError,t.interpolate=e.throwInstantiationError,t}),r("Core/TimeInterval",["./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./JulianDate"],function(e,t,r,i,n,o){"use strict";function a(r){r=e(r,e.EMPTY_OBJECT),this.start=t(r.start)?o.clone(r.start):new o,this.stop=t(r.stop)?o.clone(r.stop):new o,this.data=r.data,this.isStartIncluded=e(r.isStartIncluded,!0),this.isStopIncluded=e(r.isStopIncluded,!0)}r(a.prototype,{isEmpty:{get:function(){var e=o.compare(this.stop,this.start);return 0>e||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var s={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};return a.fromIso8601=function(r,i){var n=r.iso8601.split("/"),l=o.fromIso8601(n[0]),u=o.fromIso8601(n[1]),c=e(r.isStartIncluded,!0),h=e(r.isStopIncluded,!0),d=r.data;return t(i)?(i.start=l,i.stop=u,i.isStartIncluded=c,i.isStopIncluded=h,i.data=d,i):(s.start=l,s.stop=u,s.isStartIncluded=c,s.isStopIncluded=h,s.data=d,new a(s))},a.toIso8601=function(e,t){return o.toIso8601(e.start,t)+"/"+o.toIso8601(e.stop,t)},a.clone=function(e,r){return t(e)?t(r)?(r.start=e.start,r.stop=e.stop,r.isStartIncluded=e.isStartIncluded,r.isStopIncluded=e.isStopIncluded,r.data=e.data,r):new a(e):void 0},a.equals=function(e,r,i){return e===r||t(e)&&t(r)&&(e.isEmpty&&r.isEmpty||e.isStartIncluded===r.isStartIncluded&&e.isStopIncluded===r.isStopIncluded&&o.equals(e.start,r.start)&&o.equals(e.stop,r.stop)&&(e.data===r.data||t(i)&&i(e.data,r.data)))},a.equalsEpsilon=function(e,r,i,n){return e===r||t(e)&&t(r)&&(e.isEmpty&&r.isEmpty||e.isStartIncluded===r.isStartIncluded&&e.isStopIncluded===r.isStopIncluded&&o.equalsEpsilon(e.start,r.start,i)&&o.equalsEpsilon(e.stop,r.stop,i)&&(e.data===r.data||t(n)&&n(e.data,r.data)))},a.intersect=function(e,r,i,n){if(!t(r))return a.clone(a.EMPTY,i);var s=e.start,l=e.stop,u=r.start,c=r.stop,h=o.greaterThanOrEquals(u,s)&&o.greaterThanOrEquals(l,u),d=!h&&o.lessThanOrEquals(u,s)&&o.lessThanOrEquals(s,c);if(!h&&!d)return a.clone(a.EMPTY,i);var p=e.isStartIncluded,m=e.isStopIncluded,f=r.isStartIncluded,v=r.isStopIncluded,_=o.lessThan(l,c);return i.start=h?u:s,i.isStartIncluded=p&&f||!o.equals(u,s)&&(h&&f||d&&p),i.stop=_?l:c,i.isStopIncluded=_?m:m&&v||!o.equals(c,l)&&v,i.data=t(n)?n(e.data,r.data):e.data,i},a.contains=function(e,t){if(e.isEmpty)return!1;var r=o.compare(e.start,t);if(0===r)return e.isStartIncluded;var i=o.compare(t,e.stop);return 0===i?e.isStopIncluded:0>r&&0>i},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e,t){return a.equals(this,e,t)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return a.toIso8601(this)},a.EMPTY=n(new a({start:new o,stop:new o,isStartIncluded:!1,isStopIncluded:!1})),a}),r("Core/Iso8601",["./freezeObject","./JulianDate","./TimeInterval"],function(e,t,r){"use strict";var i=e(t.fromIso8601("0000-01-01T00:00:00Z")),n=e(t.fromIso8601("9999-12-31T24:00:00Z")),o=e(new r({start:i,stop:n})),a={MINIMUM_VALUE:i,MAXIMUM_VALUE:n,MAXIMUM_INTERVAL:o};return a}),r("Core/KeyboardEventModifier",["./freezeObject"],function(e){"use strict";var t={SHIFT:0,CTRL:1,ALT:2};return e(t)}),r("Core/LagrangePolynomialApproximation",["./defined"],function(e){"use strict";var t={type:"Lagrange"};return t.getRequiredDataPoints=function(e){return Math.max(e+1,2)},t.interpolateOrderZero=function(t,r,i,n,o){e(o)||(o=new Array(n));var a,s,l=r.length;for(a=0;n>a;a++)o[a]=0;for(a=0;l>a;a++){var u=1;for(s=0;l>s;s++)if(s!==a){var c=r[a]-r[s];u*=(t-r[s])/c}for(s=0;n>s;s++)o[s]+=u*i[a*n+s]}return o},t}),r("Core/LinearApproximation",["./defined","./DeveloperError"],function(e,t){"use strict";var r={type:"Linear"};return r.getRequiredDataPoints=function(e){return 2},r.interpolateOrderZero=function(t,r,i,n,o){e(o)||(o=new Array(n));var a,s,l,u=r[0],c=r[1];for(a=0;n>a;a++)s=i[a],l=i[a+n],o[a]=((l-s)*t+c*s-u*l)/(c-u);return o},r}),r("Core/loadBlob",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,responseType:"blob",headers:r})}return t}),r("Core/loadImageFromTypedArray",["../ThirdParty/when","./defined","./DeveloperError","./loadImage"],function(e,t,r,i){"use strict";function n(t,r){var n=new Blob([t],{type:r}),o=window.URL.createObjectURL(n);return i(o,!1).then(function(e){return window.URL.revokeObjectURL(o),e},function(t){return window.URL.revokeObjectURL(o),e.reject(t)})}return n}),r("Core/loadImageViaBlob",["../ThirdParty/when","./loadBlob","./loadImage"],function(e,t,r){"use strict";function i(i){return n.test(i)?r(i):t(i).then(function(t){var i=window.URL.createObjectURL(t);return r(i,!1).then(function(e){return e.blob=t,window.URL.revokeObjectURL(i),e},function(t){return window.URL.revokeObjectURL(i),e.reject(t)})})}var n=/^data:/,o=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();return o?i:r}),r("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function i(e){var t="";for(var i in e)if(e.hasOwnProperty(i)){var n=e[i],o=encodeURIComponent(i)+"=";if(r(n))for(var a=0,s=n.length;s>a;++a)t+=o+encodeURIComponent(n[a])+"&";else t+=o+encodeURIComponent(n)+"&"}return t=t.slice(0,-1)}return i}),r("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function i(t){var i={};if(""===t)return i;for(var n=t.replace(/\+/g,"%20").split("&"),o=0,a=n.length;a>o;++o){var s=n[o].split("="),l=decodeURIComponent(s[0]),u=s[1];u=e(u)?decodeURIComponent(u):"";var c=i[l];"string"==typeof c?i[l]=[c,u]:r(c)?c.push(u):i[l]=u}return i}return i}),r("Core/loadJsonp",["../ThirdParty/Uri","../ThirdParty/when","./combine","./defaultValue","./defined","./DeveloperError","./objectToQuery","./queryToObject"],function(e,t,r,i,n,o,a,s){"use strict";function l(o,u){u=i(u,i.EMPTY_OBJECT);var c;do c="loadJsonp"+Math.random().toString().substring(2,8);while(n(window[c]));var h=t.defer();window[c]=function(e){h.resolve(e);try{delete window[c]}catch(t){window[c]=void 0}};var d=new e(o),p=s(i(d.query,""));n(u.parameters)&&(p=r(u.parameters,p));var m=i(u.callbackParameterName,"callback");p[m]=c,d.query=a(p),o=d.toString();var f=u.proxy;return n(f)&&(o=f.getURL(o)),l.loadAndExecuteScript(o,c,h),h.promise}return l.loadAndExecuteScript=function(e,t,r){var i=document.createElement("script");i.async=!0,i.src=e;var n=document.getElementsByTagName("head")[0];i.onload=function(){i.onload=void 0,n.removeChild(i)},i.onerror=function(e){r.reject(e)},n.appendChild(i)},l.defaultLoadAndExecuteScript=l.loadAndExecuteScript,l}),r("Core/loadXML",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,responseType:"document",headers:r,overrideMimeType:"text/xml"})}return t}),r("Core/MapboxApi",["./defined"],function(e){"use strict";var t={};t.defaultAccessToken=void 0;var r=!1;return t.getAccessToken=function(i){return e(i)?i:e(t.defaultAccessToken)?t.defaultAccessToken:(r||(console.log("This application is using Cesium's default Mapbox access token.  Please create a new access token for the application as soon as possible and prior to deployment by visiting https://www.mapbox.com/account/apps/, and provide your token to Cesium by setting the Cesium.MapboxApi.defaultAccessToken property before constructing the CesiumWidget or any other object that uses the Mapbox API."),r=!0),"pk.eyJ1IjoiYW5hbHl0aWNhbGdyYXBoaWNzIiwiYSI6IjA2YzBjOTM3YzFlYzljYmQ5NDAxZWI1Y2ZjNzZlM2E1In0.vDZL2SPFEpi_f7ziAIP_yw")},t}),r("Core/MapProjection",["./defineProperties","./DeveloperError"],function(e,t){"use strict";function r(){t.throwInstantiationError()}return e(r.prototype,{ellipsoid:{get:t.throwInstantiationError}}),r.prototype.project=t.throwInstantiationError,r.prototype.unproject=t.throwInstantiationError,r}),r("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i,n){"use strict";function o(e,r,i,n){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(r,0),this[3]=t(n,0)}o.packedLength=4,o.pack=function(e,r,i){i=t(i,0),r[i++]=e[0],r[i++]=e[1],r[i++]=e[2],r[i++]=e[3]},o.unpack=function(e,i,n){return i=t(i,0),r(n)||(n=new o),n[0]=e[i++],n[1]=e[i++],n[2]=e[i++],n[3]=e[i++],n},o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,i,n){return i=t(i,0),r(n)||(n=new o),n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],n},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var i=Math.cos(e),n=Math.sin(e);return r(t)?(t[0]=i,t[1]=n,t[2]=-n,t[3]=i,t):new o(i,-n,n,i)},o.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(e,t,r){var i=2*t,n=e[i],o=e[i+1];return r.x=n,r.y=o,r},o.setColumn=function(e,t,r,i){i=o.clone(e,i);var n=2*t;return i[n]=r.x,i[n+1]=r.y,i},o.getRow=function(e,t,r){var i=e[t],n=e[t+2];return r.x=i,r.y=n,r},o.setRow=function(e,t,r,i){return i=o.clone(e,i),i[t]=r.x,i[t+2]=r.y,i};var a=new e;o.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],a)),r.y=e.magnitude(e.fromElements(t[2],t[3],a)),r};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,t,r){var i=e[0]*t[0]+e[2]*t[1],n=e[0]*t[2]+e[2]*t[3],o=e[1]*t[0]+e[3]*t[1],a=e[1]*t[2]+e[3]*t[3];return r[0]=i,r[1]=o,r[2]=n,r[3]=a,r},o.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r},o.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r},o.multiplyByVector=function(e,t,r){var i=e[0]*t.x+e[2]*t.y,n=e[1]*t.x+e[3]*t.y;return r.x=i,r.y=n,r},o.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r},o.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.y,r[3]=e[3]*t.y,r},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},o.transpose=function(e,t){var r=e[0],i=e[2],n=e[1],o=e[3];return t[0]=r,t[1]=i,t[2]=n,t[3]=o,t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,t,i){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},o.IDENTITY=n(new o(1,0,0,1)),o.ZERO=n(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),r("Core/mergeSort",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e,t,r,i,n,s){var l,u,c=n-i+1,h=s-n,d=o,p=a;for(l=0;c>l;++l)d[l]=e[i+l];for(u=0;h>u;++u)p[u]=e[n+u+1];l=0,u=0;for(var m=i;s>=m;++m){var f=d[l],v=p[u];c>l&&(u>=h||t(f,v,r)<=0)?(e[m]=f,++l):h>u&&(e[m]=v,++u)}}function i(e,t,n,o,a){if(!(o>=a)){var s=Math.floor(.5*(o+a));i(e,t,n,o,s),i(e,t,n,s+1,a),r(e,t,n,o,s,a)}}function n(e,t,r){var n=e.length,s=Math.ceil(.5*n);o.length=s,a.length=s,i(e,t,r,0,n-1),o.length=0,a.length=0}var o=[],a=[];return n}),r("Core/NearFarScalar",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,i,n){this.near=e(t,0),this.nearValue=e(r,0),this.far=e(i,1),this.farValue=e(n,0)}return i.clone=function(e,r){return t(e)?t(r)?(r.near=e.near,r.nearValue=e.nearValue,r.far=e.far,r.farValue=e.farValue,r):new i(e.near,e.nearValue,e.far,e.farValue):void 0},i.packedLength=4,i.pack=function(t,r,i){i=e(i,0),r[i++]=t.near,r[i++]=t.nearValue,r[i++]=t.far,r[i]=t.farValue},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.near=r[n++],o.nearValue=r[n++],o.far=r[n++],o.farValue=r[n],o},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.near===r.near&&e.nearValue===r.nearValue&&e.far===r.far&&e.farValue===r.farValue},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),r("Core/Visibility",["./freezeObject"],function(e){"use strict";var t={NONE:-1,PARTIAL:0,FULL:1};return e(t)}),r("Core/Occluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math","./Rectangle","./Visibility"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,r){this._occluderPosition=t.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=r}var h=new t;n(c.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=t.clone(e,this._cameraPosition);var r,i,n,o=t.subtract(this._occluderPosition,e,h),a=t.magnitudeSquared(o),s=this._occluderRadius*this._occluderRadius;if(a>s){r=Math.sqrt(a-s),a=1/Math.sqrt(a),i=t.multiplyByScalar(o,a,h);var l=r*r*a;n=t.add(e,t.multiplyByScalar(i,l,h),h)}else r=Number.MAX_VALUE;this._horizonDistance=r,this._horizonPlaneNormal=i,this._horizonPlanePosition=n,this._cameraPosition=e}}}),c.fromBoundingSphere=function(e,r,n){if(!i(e))throw new o("occluderBoundingSphere is required.");if(!i(r))throw new o("camera position is required.");return i(n)?(t.clone(e.center,n._occluderPosition),n._occluderRadius=e.radius,n.cameraPosition=r,n):new c(e,r)};var d=new t;c.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var r=t.subtract(e,this._occluderPosition,d),i=this._occluderRadius;if(i=t.magnitudeSquared(r)-i*i,i>0)return i=Math.sqrt(i)+this._horizonDistance,r=t.subtract(e,this._cameraPosition,r),i*i>t.magnitudeSquared(r)}return!1};var p=new t;c.prototype.isBoundingSphereVisible=function(e){var r=t.clone(e.center,p),i=e.radius;if(this._horizonDistance!==Number.MAX_VALUE){var n=t.subtract(r,this._occluderPosition,d),o=this._occluderRadius-i;if(o=t.magnitudeSquared(n)-o*o,i<this._occluderRadius)return o>0?(o=Math.sqrt(o)+this._horizonDistance,n=t.subtract(r,this._cameraPosition,n),o*o+i*i>t.magnitudeSquared(n)):!1;if(o>0){n=t.subtract(r,this._cameraPosition,n);var a=t.magnitudeSquared(n),s=this._occluderRadius*this._occluderRadius,l=i*i;return(this._horizonDistance*this._horizonDistance+s)*l>a*s?!0:(o=Math.sqrt(o)+this._horizonDistance,o*o+l>a)}return!0}return!1};var m=new t;c.prototype.computeVisibility=function(e){if(!i(e))throw new o("occludeeBS is required.");var r=t.clone(e.center),n=e.radius;if(n>this._occluderRadius)return u.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var a=t.subtract(r,this._occluderPosition,m),s=this._occluderRadius-n,l=t.magnitudeSquared(a);if(s=l-s*s,s>0){s=Math.sqrt(s)+this._horizonDistance,a=t.subtract(r,this._cameraPosition,a);var c=t.magnitudeSquared(a);return c>s*s+n*n?u.NONE:(s=this._occluderRadius+n,s=l-s*s,s>0?(s=Math.sqrt(s)+this._horizonDistance,s*s+n*n>c?u.FULL:u.PARTIAL):(a=t.subtract(r,this._horizonPlanePosition,a),t.dot(a,this._horizonPlaneNormal)>-n?u.PARTIAL:u.FULL))}}return u.NONE};var f=new t;c.computeOccludeePoint=function(e,r,i){var n=t.clone(r),a=t.clone(e.center),s=e.radius,l=i.length;if(t.equals(a,r))throw new o("occludeePosition must be different than occluderBoundingSphere.center");var u=t.normalize(t.subtract(n,a,f),f),h=-t.dot(u,a),d=c._anyRotationVector(a,u,h),p=c._horizonToPlaneNormalDotProduct(e,u,h,d,i[0]);if(p){for(var m,v=1;l>v;++v){if(m=c._horizonToPlaneNormalDotProduct(e,u,h,d,i[v]),!m)return;p>m&&(p=m)}if(!(.0017453283658983088>p)){var _=s/p;return t.add(a,t.multiplyByScalar(u,_,f),f)}}};var v=[];c.computeOccludeePointFromRectangle=function(i,n){n=r(n,a.WGS84);var o=l.subsample(i,n,0,v),s=e.fromPoints(o),u=t.ZERO;return t.equals(u,s.center)?void 0:c.computeOccludeePoint(new e(u,n.minimumRadius),s.center,o)};var _=new t;c._anyRotationVector=function(e,r,i){var n=t.abs(r,_),o=n.x>n.y?0:1;(0===o&&n.z>n.x||1===o&&n.z>n.y)&&(o=2);var a,s=new t;0===o?(n.x=e.x,n.y=e.y+1,n.z=e.z+1,a=t.UNIT_X):1===o?(n.x=e.x+1,n.y=e.y,n.z=e.z+1,a=t.UNIT_Y):(n.x=e.x+1,n.y=e.y+1,n.z=e.z,a=t.UNIT_Z);var l=(t.dot(r,n)+i)/-t.dot(r,a);return t.normalize(t.subtract(t.add(n,t.multiplyByScalar(a,l,s),n),e,n),n)};var g=new t;c._rotationVector=function(e,r,i,n,o){var a=t.subtract(n,e,g);if(a=t.normalize(a,a),t.dot(r,a)<.9999999847691291){var l=t.cross(r,a,a),u=t.magnitude(l);if(u>s.EPSILON13)return t.normalize(l,new t)}return o};var y=new t,C=new t,E=new t,S=new t;return c._horizonToPlaneNormalDotProduct=function(e,r,i,n,o){var a=t.clone(o,y),s=t.clone(e.center,C),l=e.radius,u=t.subtract(s,a,E),c=t.magnitudeSquared(u),h=l*l;if(h>c)return!1;var d=c-h,p=Math.sqrt(d),m=Math.sqrt(c),f=1/m,v=p*f,_=v*p;u=t.normalize(u,u);var g=t.add(a,t.multiplyByScalar(u,_,S),S),w=Math.sqrt(d-_*_),T=this._rotationVector(s,r,i,a,n),x=t.fromElements(T.x*T.x*u.x+(T.x*T.y-T.z)*u.y+(T.x*T.z+T.y)*u.z,(T.x*T.y+T.z)*u.x+T.y*T.y*u.y+(T.y*T.z-T.x)*u.z,(T.x*T.z-T.y)*u.x+(T.y*T.z+T.x)*u.y+T.z*T.z*u.z,y);x=t.normalize(x,x);var b=t.multiplyByScalar(x,w,y);T=t.normalize(t.subtract(t.add(g,b,E),s,E),E);var P=t.dot(r,T);T=t.normalize(t.subtract(t.subtract(g,b,T),s,T),T);var A=t.dot(r,T);return A>P?P:A},c}),r("Core/Packable",["./DeveloperError"],function(e){"use strict";var t={packedLength:void 0,pack:e.throwInstantiationError,unpack:e.throwInstantiationError};return t}),r("Core/PackableForInterpolation",["./DeveloperError"],function(e){"use strict";var t={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:e.throwInstantiationError,unpackInterpolationResult:e.throwInstantiationError};return t}),r("ThirdParty/measureText",[],function(){var e=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},t=function(t,r,i,n){var o=t.measureText(r),a=e(t.canvas,"font-family"),s=e(t.canvas,"font-size").replace("px",""),l=!/\S/.test(r);o.fontsize=s;var u=document.createElement("div");u.style.position="absolute",u.style.opacity=0,u.style.font=s+"px "+a,u.innerHTML=r+"<br/>"+r,document.body.appendChild(u),o.leading=1.2*s;var c=e(u,"height");if(c=c.replace("px",""),c>=2*s&&(o.leading=c/2|0),document.body.removeChild(u),l)o.ascent=0,o.descent=0,o.bounds={minx:0,maxx:o.width,miny:0,maxy:0},o.height=0;else{var h=document.createElement("canvas"),d=100;h.width=o.width+d,h.height=3*s,h.style.opacity=1,h.style.fontFamily=a,h.style.fontSize=s;var p=h.getContext("2d");p.font=s+"px "+a;var m=h.width,f=h.height,v=f/2;p.fillStyle="white",p.fillRect(-1,-1,m+2,f+2),i&&(p.strokeStyle="black",p.lineWidth=t.lineWidth,p.strokeText(r,d/2,v)),n&&(p.fillStyle="black",p.fillText(r,d/2,v));for(var _=p.getImageData(0,0,m,f).data,g=0,y=4*m,C=_.length;++g<C&&255===_[g];);var E=g/y|0;for(g=C-1;--g>0&&255===_[g];);var S=g/y|0;for(g=0;C>g&&255===_[g];)g+=y,g>=C&&(g=g-C+4);var w=g%y/4|0,T=1;for(g=C-3;g>=0&&255===_[g];)g-=y,0>g&&(g=C-3-4*T++);var x=g%y/4+1|0;o.ascent=v-E,o.descent=S-v,o.bounds={minx:w-d/2,maxx:x-d/2,miny:0,maxy:S-E},o.height=1+(S-E)}return o};return t}),r("Core/writeTextToCanvas",["../ThirdParty/measureText","./Color","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i,n){"use strict";function o(n,o){if(""!==n){o=r(o,r.EMPTY_OBJECT);var s=r(o.font,"10px sans-serif"),l=r(o.stroke,!1),u=r(o.fill,!0),c=r(o.strokeWidth,1),h=document.createElement("canvas");h.width=1,h.height=1,h.style.font=s;var d=h.getContext("2d");i(a)||(i(d.imageSmoothingEnabled)?a="imageSmoothingEnabled":i(d.mozImageSmoothingEnabled)?a="mozImageSmoothingEnabled":i(d.webkitImageSmoothingEnabled)?a="webkitImageSmoothingEnabled":i(d.msImageSmoothingEnabled)&&(a="msImageSmoothingEnabled")),d.font=s,d.lineJoin="round",d.lineWidth=c,d[a]=!1,d.textBaseline=r(o.textBaseline,"bottom"),h.style.visibility="hidden",document.body.appendChild(h);var p=e(d,n,l,u);p.computedWidth=Math.max(p.width,p.bounds.maxx-p.bounds.minx),h.dimensions=p,document.body.removeChild(h),h.style.visibility="";var m=p.height-p.ascent;h.width=p.computedWidth,h.height=p.height;var f=h.height-m;if(d.font=s,d.lineJoin="round",d.lineWidth=c,d[a]=!1,l){var v=r(o.strokeColor,t.BLACK);d.strokeStyle=v.toCssColorString(),d.strokeText(n,0,f)}if(u){var _=r(o.fillColor,t.WHITE);d.fillStyle=_.toCssColorString(),d.fillText(n,0,f)}return h}}var a;return o}),r("Core/PinBuilder",["./buildModuleUrl","./Color","./defined","./DeveloperError","./loadImage","./writeTextToCanvas"],function(e,t,r,i,n,o){"use strict";function a(){this._cache={}}function s(e,t,r){e.save(),e.scale(r/24,r/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,c).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function l(e,r,i){var n=i/2.5,o=n,a=n;r.width>r.height?a=n*(r.height/r.width):r.width<r.height&&(o=n*(r.width/r.height));var s=(i-o)/2,l=7/24*i-a/2;e.globalCompositeOperation="destination-out",e.drawImage(r,s-1,l,o,a),e.drawImage(r,s,l-1,o,a),e.drawImage(r,s+1,l,o,a),e.drawImage(r,s,l+1,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.BLACK.toCssColorString(),e.fillRect(s-1,l-1,o+1,a+1),e.globalCompositeOperation="destination-out",e.drawImage(r,s,l,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.WHITE.toCssColorString(),e.fillRect(s,l,o,a)}function u(e,t,i,a,u){h[0]=e,h[1]=t,h[2]=i,h[3]=a;var c=JSON.stringify(h),d=u[c];if(r(d))return d;var p=document.createElement("canvas");p.width=a,p.height=a;var m=p.getContext("2d");if(s(m,i,a),r(e)){var f=n(e).then(function(e){return l(m,e,a),u[c]=p,p});return u[c]=f,f}if(r(t)){var v=o(t,{font:"bold "+a+"px sans-serif"});l(m,v,a)}return u[c]=p,p}a.prototype.fromColor=function(e,t){return u(void 0,void 0,e,t,this._cache)},a.prototype.fromUrl=function(e,t,r){return u(e,void 0,t,r,this._cache)},a.prototype.fromMakiIconId=function(t,r,i){return u(e("Assets/Textures/maki/"+encodeURIComponent(t)+".png"),void 0,r,i,this._cache)},a.prototype.fromText=function(e,t,r){return u(void 0,e,t,r,this._cache)};var c=new t,h=new Array(4);return a}),r("Core/PixelFormat",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={DEPTH_COMPONENT:e.DEPTH_COMPONENT,DEPTH_STENCIL:e.DEPTH_STENCIL,ALPHA:e.ALPHA,RGB:e.RGB,RGBA:e.RGBA,LUMINANCE:e.LUMINANCE,LUMINANCE_ALPHA:e.LUMINANCE_ALPHA,validate:function(e){return e===r.DEPTH_COMPONENT||e===r.DEPTH_STENCIL||e===r.ALPHA||e===r.RGB||e===r.RGBA||e===r.LUMINANCE||e===r.LUMINANCE_ALPHA},isColorFormat:function(e){return e===r.ALPHA||e===r.RGB||e===r.RGBA||e===r.LUMINANCE||e===r.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===r.DEPTH_COMPONENT||e===r.DEPTH_STENCIL}};return t(r)}),r("Core/PointGeometry",["./BoundingSphere","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(t){t=r(t,r.EMPTY_OBJECT),this._positionsTypedArray=t.positionsTypedArray,this._colorsTypedArray=t.colorsTypedArray,this._boundingSphere=e.clone(t.boundingSphere),this._workerName="createPointGeometry"}return u.createGeometry=function(r){var n=r._positionsTypedArray,u=n.byteLength/n.length,c=4===u?t.FLOAT:t.DOUBLE,h=new s;h.position=new a({componentDatatype:c,componentsPerAttribute:3,values:n}),h.color=new a({componentDatatype:t.UNSIGNED_BYTE,componentsPerAttribute:3,values:r._colorsTypedArray,normalize:!0});var d=r._boundingSphere;return i(d)||(d=e.fromVertices(n)),new o({attributes:h,primitiveType:l.POINTS,boundingSphere:d})},u}),r("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";function r(t,r,n,o){return e(t,r,n,o,i),i.x>0&&i.y>0&&i.z>0}var i=new t;return r}),r("Core/Queue",["../Core/defineProperties"],function(e){"use strict";function t(){this._array=[],this._offset=0,this._length=0}return e(t.prototype,{length:{get:function(){return this._length}}}),t.prototype.enqueue=function(e){this._array.push(e),this._length++},t.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,r}},t.prototype.peek=function(){return 0!==this._length?this._array[this._offset]:void 0},t.prototype.contains=function(e){return-1!==this._array.indexOf(e)},t.prototype.clear=function(){this._array.length=this._offset=this._length=0},t.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},t}),r("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return t(r)}),r("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f){"use strict";function v(t,r,i){var n=e.subtract(r,t,F),o=e.subtract(i,r,B);return n.x*o.y-n.y*o.x>=0}function _(e){for(var t=e[0].x,r=0,i=0;i<e.length;i++)e[i].x>t&&(t=e[i].x,r=i);return r}function g(e){for(var t=e[0][0].x,r=0,i=0;i<e.length;i++){var n=e[i][_(e[i])].x;n>t&&(t=n,r=i)}return r}function y(e){for(var t=[],r=0;r<e.length;r++){var i=e[(r-1+e.length)%e.length],n=e[r],o=e[(r+1)%e.length];v(i,n,o)||t.push(n)}return t}function C(t,r){for(var i=0;i<t.length;i++)if(e.equals(r,t[i]))return i;return-1}function E(r,n,o){o=i(o,[]);var a=Number.MAX_VALUE,s=_(n),l=new e(n[s].x,r.y);o.push(s),o.push((s+1)%n.length);for(var u=n[0].x,c=u,h=1;h<n.length;++h)n[h].x<u?u=n[h].x:n[h].x>c&&(c=n[h].x);c+=c-u;var d=new t(c,r.y,0);for(h=0;h<n.length;h++){var p=n[h],m=n[(h+1)%n.length];if((p.x>=r.x||m.x>=r.x)&&(p.y>=r.y&&m.y<=r.y||p.y<=r.y&&m.y>=r.y)){var f=(m.y-p.y)*(d.x-r.x)-(m.x-p.x)*(d.y-r.y);if(0!==f){f=1/f;var v=((m.x-p.x)*(r.y-p.y)-(m.y-p.y)*(r.x-p.x))*f,g=((d.x-r.x)*(r.y-p.y)-(d.y-r.y)*(r.x-p.x))*f;if(v>=0&&1>=v&&g>=0&&1>=g){var y=new e(r.x+v*(d.x-r.x),r.y+v*(d.y-r.y)),C=e.subtract(y,r,V);f=e.magnitudeSquared(C),a>f&&(l=y,a=f,o[0]=h,o[1]=(h+1)%n.length)}}}}return l}function S(t,r){var i=g(r),n=r[i],o=_(n),a=n[o],s=[],l=E(a,t,s),u=C(t,l);if(-1!==u)return u;var d=e.magnitudeSquared(e.subtract(t[s[0]],a,z)),p=e.magnitudeSquared(e.subtract(t[s[1]],a,z)),m=p>d?t[s[0]]:t[s[1]],f=y(t),v=f.indexOf(m);-1!==v&&f.splice(v,1);for(var S=[],w=0;w<f.length;w++){var T=f[w];h(T,a,l,m)&&S.push(T)}var x=Number.MAX_VALUE;if(S.length>0){var b=e.fromElements(1,0,z);for(w=0;w<S.length;w++){var P=e.subtract(S[w],a,k),A=e.magnitude(b)*e.magnitudeSquared(P);if(0!==A){var I=Math.abs(c.acosClamped(e.dot(b,P)/A));x>I&&(x=I,m=S[w])}}}return t.indexOf(m)}function w(e,r,i){for(var n=ee.computeWindingOrder2D(e),o=0;o<r.length;o++){var a=r[o];t.equals(a[0],a[a.length-1])||a.push(a[0]);var l=ee.computeWindingOrder2D(a);l===n&&a.reverse()}var u=s.fromPoints(e,i),c=u.projectPointsOntoPlane(e),h=[];for(o=0;o<r.length;o++)h.push(u.projectPointsOntoPlane(r[o]));var d=S(c,h),p=g(h),m=_(h[p]),f=r[p],v=[];for(o=0;o<e.length;o++)v.push(e[o]);var y,C=[];if(0!==m)for(y=0;y<=f.length;y++){var E=(y+m)%f.length;0!==E&&C.push(f[E])}else for(y=0;y<f.length;y++)C.push(f[(y+m)%f.length]);var w=v.lastIndexOf(e[d]);C.push(e[w]);var T=v.slice(0,w+1),x=v.slice(w+1);return v=T.concat(C,x),r.splice(p,1),v}function T(e){var t=c.nextRandomNumber(),r=Math.floor(t*e);return r===e&&r--,r}function x(e,t,r,i){
var n=i[e].position,o=i[t].position,a=i[r].position,s=a.x,l=a.y,u=n.x-s,c=n.y-l,h=o.x-s,d=o.y-l;return u*d-c*h}function b(e,t){return e.x*t.y-e.y*t.x}function P(e,t){var r=t.length,i=c.mod(e-1,r),n=c.mod(e+1,r);return 0===x(i,n,e,t)?!1:!0}function A(t,r){return e.magnitudeSquared(r)<e.magnitudeSquared(t)}function I(t,r,i){if(!P(t,i))return t;var n=i[t].position,o=i[r].position,a=i.length,s=c.mod(t-1,a);if(!P(s,i))return s;var l=c.mod(t+1,a);if(!P(l,i))return l;var u=e.subtract(i[s].position,n,W),h=e.subtract(i[l].position,n,H),d=e.subtract(o,n,q),p=b(u,d),m=b(h,d);if(0===p)return A(u,d)?U:G;if(0===m)return A(h,d)?U:G;var f=b(u,h);return 0>f?0>p&&m>0?U:G:f>0?p>0&&0>m?G:U:void 0}function M(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function D(t,r,i,n){var o=e.subtract(i,t,Y),a=r.x*n.y-r.y*n.x,s=a*a,l=e.magnitudeSquared(r),u=e.magnitudeSquared(n);if(s>j*l*u){var c=(o.x*n.y-o.y*n.x)/a;return e.add(t,e.multiplyByScalar(r,c,Y),Y)}}function R(t,r,i){for(var o=e.subtract(r,t,X),a=i.length,s=0;a>s;s++){var l=i[s].position,u=i[c.mod(s+1,a)].position;if(!(e.equals(t,l)||e.equals(r,u)||e.equals(t,u)||e.equals(r,l))){var h=e.subtract(u,l,Z),d=D(t,o,l,h);if(n(d)&&!(e.equals(d,t)||e.equals(d,r)||e.equals(d,l)||e.equals(d,u))){var p=d.x,m=d.y,f=M(p,t.x,r.x)&&M(m,t.y,r.y)&&M(p,l.x,u.x)&&M(m,l.y,u.y);if(f)return!0}}}return!1}function O(t,r,i){var n=I(t,r,i);if(n>=0)return n;var o=I(r,t,i);return o>=0?o:n!==U||o!==U||R(i[t].position,i[r].position,i)||e.equals(i[t].position,i[r].position)?Q:K}function N(e){return 0===x(1,2,0,e)}function L(e){var t=e.length;if(3===t)return N(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new o("Invalid polygon: must have at least three vertices.");for(var r,i,n=0,a=10*e.length,s=Q;K>s&&n++<a;){for(r=T(e.length),i=r+1;Math.abs(r-i)<2||Math.abs(r-i)>e.length-2;)i=T(e.length);if(r>i){var l=r;r=i,i=l}s=O(r,i,e)}if(s===K){var u=e.splice(r,i-r+1,e[r],e[i]);return L(e).concat(L(u))}return s>=0?(e.splice(s,1),L(e)):[]}var F=new e,B=new e,V=new e,z=new e(1,0),k=new e,U=-1,G=-2,W=new t,H=new t,q=new t,j=c.EPSILON14,Y=new e,X=new e,Z=new e,K=-1,Q=-2,J=new t,$=new t,ee={};ee.removeDuplicates=function(e){var r=d.removeDuplicates(e);return t.equals(r[0],r[r.length-1])?r.slice(1):r},ee.computeArea2D=function(e){for(var t=e.length,r=0,i=t-1,n=0;t>n;i=n++){var o=e[i],a=e[n];r+=o.x*a.y-a.x*o.y}return.5*r},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?f.COUNTER_CLOCKWISE:f.CLOCKWISE},ee.triangulate=function(e){for(var t=e.length,r=[],i=0;t>i;++i)r[i]={position:e[i],index:i};return L(r)};var te=new t,re=new t,ie=new t,ne=new t,oe=new t,ae=new t,se=new t;return ee.computeSubdivision=function(e,o,a,s){s=i(s,c.RADIANS_PER_DEGREE);var h,d=a.slice(0),m=o.length,f=new Array(3*m),v=0;for(h=0;m>h;h++){var _=o[h];f[v++]=_.x,f[v++]=_.y,f[v++]=_.z}for(var g=[],y={},C=e.maximumRadius,E=c.chordLength(s,C),S=E*E;d.length>0;){var w,T,x=d.pop(),b=d.pop(),P=d.pop(),A=t.fromArray(f,3*P,te),I=t.fromArray(f,3*b,re),M=t.fromArray(f,3*x,ie),D=t.multiplyByScalar(t.normalize(A,ne),C,ne),R=t.multiplyByScalar(t.normalize(I,oe),C,oe),O=t.multiplyByScalar(t.normalize(M,ae),C,ae),N=t.magnitudeSquared(t.subtract(D,R,se)),L=t.magnitudeSquared(t.subtract(R,O,se)),F=t.magnitudeSquared(t.subtract(O,D,se)),B=Math.max(N,L,F);B>S?N===B?(w=Math.min(P,b)+" "+Math.max(P,b),h=y[w],n(h)||(T=t.add(A,I,se),t.multiplyByScalar(T,.5,T),f.push(T.x,T.y,T.z),h=f.length/3-1,y[w]=h),d.push(P,h,x),d.push(h,b,x)):L===B?(w=Math.min(b,x)+" "+Math.max(b,x),h=y[w],n(h)||(T=t.add(I,M,se),t.multiplyByScalar(T,.5,T),f.push(T.x,T.y,T.z),h=f.length/3-1,y[w]=h),d.push(b,h,P),d.push(h,x,P)):F===B&&(w=Math.min(x,P)+" "+Math.max(x,P),h=y[w],n(h)||(T=t.add(M,A,se),t.multiplyByScalar(T,.5,T),f.push(T.x,T.y,T.z),h=f.length/3-1,y[w]=h),d.push(x,h,b),d.push(h,P,b)):(g.push(P),g.push(b),g.push(x))}return new l({attributes:{position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:f})},indices:g,primitiveType:p.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,r,o,s){o=i(o,a.WGS84);var l=J,u=$;if(r=i(r,0),s=i(s,!0),n(e)&&n(e.attributes)&&n(e.attributes.position))for(var c=e.attributes.position.values,h=c.length,d=0;h>d;d+=3)t.fromArray(c,d,u),s&&(u=o.scaleToGeodeticSurface(u,u)),l=o.geodeticSurfaceNormal(u,l),t.multiplyByScalar(l,r,l),t.add(u,l,u),c[d]=u.x,c[d+1]=u.y,c[d+2]=u.z;return e},ee.eliminateHoles=function(e,r,n){n=i(n,a.WGS84);for(var o=[],s=0;s<r.length;s++){for(var l=[],u=0;u<r[s].length;u++)l.push(t.clone(r[s][u]));o.push(l)}for(var c=e;o.length>0;)c=w(c,o,n);return c},ee}),r("Core/PolygonGeometryLibrary",["./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(t,r,i,n){return e.subtract(r,t,_),e.multiplyByScalar(_,i/n,_),e.add(t,_,_),[_.x,_.y,_.z]}var v={};v.computeHierarchyPackedLength=function(t){for(var r=0,n=[t];n.length>0;){var o=n.pop();if(i(o)){r+=2;var a=o.positions,s=o.holes;if(i(a)&&(r+=a.length*e.packedLength),i(s))for(var l=s.length,u=0;l>u;++u)n.push(s[u])}}return r},v.packPolygonHierarchy=function(t,r,n){for(var o=[t];o.length>0;){var a=o.pop();if(i(a)){var s=a.positions,l=a.holes;if(r[n++]=i(s)?s.length:0,r[n++]=i(l)?l.length:0,i(s))for(var u=s.length,c=0;u>c;++c,n+=3)e.pack(s[c],r,n);if(i(l))for(var h=l.length,d=0;h>d;++d)o.push(l[d])}}return n},v.unpackPolygonHierarchy=function(t,r){for(var i=t[r++],n=t[r++],o=new Array(i),a=n>0?new Array(n):void 0,s=0;i>s;++s,r+=e.packedLength)o[s]=e.unpack(t,r);for(var l=0;n>l;++l)a[l]=v.unpackPolygonHierarchy(t,r),r=a[l].startingIndex,delete a[l].startingIndex;return{positions:o,holes:a,startingIndex:r}};var _=new e;v.subdivideLineCount=function(t,r,i){var n=e.distance(t,r),o=n/i,a=Math.max(0,Math.ceil(Math.log(o)/Math.log(2)));return Math.pow(2,a)},v.subdivideLine=function(t,r,n,o){var a=v.subdivideLineCount(t,r,n),s=e.distance(t,r),l=s/a;i(o)||(o=[]);var u=o;u.length=3*a;for(var c=0,h=0;a>h;h++){var d=f(t,r,h*l,s);u[c++]=d[0],u[c++]=d[1],u[c++]=d[2]}return u};var g=new e,y=new e,C=new e,E=new e;v.scaleToGeodeticHeightExtruded=function(t,o,a,s,l){s=r(s,n.WGS84);var u=g,c=y,h=C,d=E;if(i(t)&&i(t.attributes)&&i(t.attributes.position))for(var p=t.attributes.position.values,m=p.length/2,f=0;m>f;f+=3)e.fromArray(p,f,h),s.geodeticSurfaceNormal(h,u),d=s.scaleToGeodeticSurface(h,d),c=e.multiplyByScalar(u,a,c),c=e.add(d,c,c),p[f+m]=c.x,p[f+1+m]=c.y,p[f+2+m]=c.z,l&&(d=e.clone(h,d)),c=e.multiplyByScalar(u,o,c),c=e.add(d,c,c),p[f]=c.x,p[f+1]=c.y,p[f+2]=c.z;return t},v.polygonsFromHierarchy=function(e){var t=[],r=[],n=new p;for(n.enqueue(e);0!==n.length;){var o=n.dequeue(),a=o.positions,s=o.holes;if(a=h.removeDuplicates(a),!(a.length<3)){for(var l=i(s)?s.length:0,u=[],c=0;l>c;c++){var d=s[c];if(d.positions=h.removeDuplicates(d.positions),!(d.positions.length<3)){u.push(d.positions);var m=0;i(d.holes)&&(m=d.holes.length);for(var f=0;m>f;f++)n.enqueue(d.holes[f])}}r.push({outerRing:a,holes:u});var v=u.length>0?h.eliminateHoles(a,u):a;t.push(v)}}return{hierarchy:r,polygons:t}};var S=[];v.createGeometryFromPositions=function(e,r,i,n){var l=o.fromPoints(r,e),u=l.projectPointsOntoPlane(r,S),c=h.computeWindingOrder2D(u);c===m.CLOCKWISE&&(u.reverse(),r=r.slice().reverse());var p=h.triangulate(u);if(p.length<3&&(p=[0,1,2]),n){for(var f=r.length,v=new Array(3*f),_=0,g=0;f>g;g++){var y=r[g];v[_++]=y.x,v[_++]=y.y,v[_++]=y.z}return new a({attributes:{position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:v})},indices:p,primitiveType:d.TRIANGLES})}return h.computeSubdivision(e,r,p,i)};var w=[],T=new e,x=new e;return v.computeWallGeometry=function(r,i,n,o){var h,p,m,f,_,g=r.length,y=0;if(o)for(p=3*g*2,h=new Array(2*p),m=0;g>m;m++)f=r[m],_=r[(m+1)%g],h[y]=h[y+p]=f.x,++y,h[y]=h[y+p]=f.y,++y,h[y]=h[y+p]=f.z,++y,h[y]=h[y+p]=_.x,++y,h[y]=h[y+p]=_.y,++y,h[y]=h[y+p]=_.z,++y;else{var C=c.chordLength(n,i.maximumRadius),E=0;for(m=0;g>m;m++)E+=v.subdivideLineCount(r[m],r[(m+1)%g],C);for(p=3*(E+g),h=new Array(2*p),m=0;g>m;m++){f=r[m],_=r[(m+1)%g];for(var S=v.subdivideLine(f,_,C,w),b=S.length,P=0;b>P;++P,++y)h[y]=S[P],h[y+p]=S[P];h[y]=_.x,h[y+p]=_.x,++y,h[y]=_.y,h[y+p]=_.y,++y,h[y]=_.z,h[y+p]=_.z,++y}}g=h.length;var A=u.createTypedArray(g/3,g-6*r.length),I=0;for(g/=6,m=0;g>m;m++){var M=m,D=M+1,R=M+g,O=R+1;f=e.fromArray(h,3*M,T),_=e.fromArray(h,3*D,x),e.equalsEpsilon(f,_,c.EPSILON14)||(A[I++]=M,A[I++]=R,A[I++]=D,A[I++]=D,A[I++]=R,A[I++]=O)}return new a({attributes:new l({position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:h})}),indices:A,primitiveType:d.TRIANGLES})},v}),r("Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./Quaternion","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S){"use strict";function w(e,t,r,n){for(var o=C.fromAxisAngle(e._plane.normal,r,I),s=_.fromQuaternion(o,M),l=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,h=Number.NEGATIVE_INFINITY,d=t.length,p=0;d>p;++p){var m=i.clone(t[p],A);_.multiplyByVector(s,m,m);var f=e.projectPointOntoPlane(m,P);a(f)&&(l=Math.min(l,f.x),u=Math.max(u,f.x),c=Math.min(c,f.y),h=Math.max(h,f.y))}return n.x=l,n.y=c,n.width=u-l,n.height=h-c,n}function T(e,t,o,a,s,l,c){if(e.st||e.normal||e.tangent||e.binormal){var d=u.fromPoints(o,a),p=w(d,o,s,D),m=V;m.x=p.x,m.y=p.y;var f=t.attributes.position.values,g=f.length,y=e.st?new Float32Array(2*(g/3)):void 0,E=e.normal?new Float32Array(g):void 0,S=e.tangent?new Float32Array(g):void 0,T=e.binormal?new Float32Array(g):void 0,x=0,b=0,P=O,A=N,I=L,M=!0,W=C.fromAxisAngle(d._plane.normal,s,U),H=_.fromQuaternion(W,G),q=g/2,j=g/3;l&&(g/=2);for(var Y=0;g>Y;Y+=3){var X=i.fromArray(f,Y,k);if(e.st){var Z=_.multiplyByVector(H,X,R),K=d.projectPointOntoPlane(Z,z);r.subtract(K,m,K),l&&(y[x+j]=K.x/p.width,y[x+1+j]=K.y/p.height),y[x]=K.x/p.width,y[x+1]=K.y/p.height,x+=2}if(e.normal||e.tangent||e.binormal){var Q=b+1,J=b+2;if(c){if(g>Y+3){var $=i.fromArray(f,Y+3,F);if(M){var ee=i.fromArray(f,Y+g,B);i.subtract($,X,$),i.subtract(ee,X,ee),P=i.normalize(i.cross(ee,$,P),P),M=!1}i.equalsEpsilon($,X,v.EPSILON10)&&(M=!0)}(e.tangent||e.binormal)&&(I=a.geodeticSurfaceNormal(X,I),e.tangent&&(A=i.normalize(i.cross(I,P,A),A)))}else P=a.geodeticSurfaceNormal(X,P),(e.tangent||e.binormal)&&(A=i.cross(i.UNIT_Z,P,A),A=i.normalize(_.multiplyByVector(H,A,A),A),e.binormal&&(I=i.normalize(i.cross(P,A,I),I)));e.normal&&(l&&!c?(E[b+q]=-P.x,E[Q+q]=-P.y,E[J+q]=-P.z):(E[b+q]=P.x,E[Q+q]=P.y,E[J+q]=P.z),E[b]=P.x,E[Q]=P.y,E[J]=P.z),e.tangent&&(l&&!c?(S[b+q]=-A.x,S[Q+q]=-A.y,S[J+q]=-A.z):(S[b+q]=A.x,S[Q+q]=A.y,S[J+q]=A.z),S[b]=A.x,S[Q]=A.y,S[J]=A.z),e.binormal&&(l&&(T[b+q]=I.x,T[Q+q]=I.y,T[J+q]=I.z),T[b]=I.x,T[Q]=I.y,T[J]=I.z),b+=3}}e.st&&(t.attributes.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:y})),e.normal&&(t.attributes.normal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),e.tangent&&(t.attributes.tangent=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:S})),e.binormal&&(t.attributes.binormal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:T}))}return t}function x(e,t,r,i,o){var a=g.createGeometryFromPositions(e,t,r,o),s=a.attributes.position.values,l=a.indices,m=s.concat(s),v=m.length/3,_=f.createTypedArray(v,2*l.length);_.set(l);var C,E=l.length,w=v/2;for(C=0;E>C;C+=3){var T=_[C]+w,x=_[C+1]+w,b=_[C+2]+w;_[C+E]=b,_[C+1+E]=x,_[C+2+E]=T}var P=new c({attributes:new d({position:new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:m})}),indices:_,primitiveType:a.primitiveType}),A={topAndBottom:new p({geometry:P}),walls:[]},I=i.outerRing,M=u.fromPoints(I,e),D=M.projectPointsOntoPlane(I,W),R=y.computeWindingOrder2D(D);R===S.CLOCKWISE&&(I=I.slice().reverse());var O=g.computeWallGeometry(I,e,r,o);A.walls.push(new p({geometry:O}));var N=i.holes;for(C=0;C<N.length;C++){var L=N[C];M=u.fromPoints(L,e),D=M.projectPointsOntoPlane(L,W),R=y.computeWindingOrder2D(D),R===S.COUNTER_CLOCKWISE&&(L=L.slice().reverse()),O=g.computeWallGeometry(L,e,r),A.walls.push(new p({geometry:O}))}return A}function b(e){var t=e.polygonHierarchy,r=o(e.vertexFormat,E.DEFAULT),i=o(e.ellipsoid,l.WGS84),n=o(e.granularity,v.RADIANS_PER_DEGREE),s=o(e.stRotation,0),u=o(e.height,0),c=o(e.perPositionHeight,!1),h=e.extrudedHeight,d=a(h);if(d&&!c){var p=h;h=Math.min(p,u),u=Math.max(p,u)}this._vertexFormat=E.clone(r),this._ellipsoid=l.clone(i),this._granularity=n,this._stRotation=s,this._height=u,this._extrudedHeight=o(h,0),this._extrude=d,this._polygonHierarchy=t,this._perPositionHeight=c,this._workerName="createPolygonGeometry",this.packedLength=g.computeHierarchyPackedLength(t)+l.packedLength+E.packedLength+7}var P=new r,A=new i,I=new C,M=new _,D=new e,R=new i,O=new i,N=new i,L=new i,F=new i,B=new i,V=new r,z=new r,k=new i,U=new C,G=new _,W=[];b.fromPositions=function(e){e=o(e,o.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new b(t)},b.pack=function(e,t,r){r=o(r,0),r=g.packPolygonHierarchy(e._polygonHierarchy,t,r),l.pack(e._ellipsoid,t,r),r+=l.packedLength,E.pack(e._vertexFormat,t,r),r+=E.packedLength,t[r++]=e._height,t[r++]=e._extrudedHeight,t[r++]=e._granularity,t[r++]=e._stRotation,t[r++]=e._extrude?1:0,t[r++]=e._perPositionHeight?1:0,t[r]=e.packedLength};var H=l.clone(l.UNIT_SPHERE),q=new E,j={polygonHierarchy:{}};return b.unpack=function(e,t,r){t=o(t,0);var i=g.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;var n=l.unpack(e,t,H);t+=l.packedLength;var s=E.unpack(e,t,q);t+=E.packedLength;var u=e[t++],c=e[t++],h=e[t++],d=e[t++],p=1===e[t++],m=1===e[t++],f=e[t];return a(r)||(r=new b(j)),r._polygonHierarchy=i,r._ellipsoid=l.clone(n,r._ellipsoid),r._vertexFormat=E.clone(s,r._vertexFormat),r._height=u,r._extrudedHeight=c,r._granularity=h,r._stRotation=d,r._extrude=p,r._perPositionHeight=m,r.packedLength=f,r},b.createGeometry=function(e){var r,i,n,o=e._vertexFormat,a=e._ellipsoid,s=e._granularity,l=e._stRotation,u=e._height,h=e._extrudedHeight,d=e._extrude,v=e._polygonHierarchy,_=e._perPositionHeight,C=g.polygonsFromHierarchy(v),E=C.hierarchy,S=C.polygons;if(0!==S.length){n=S[0];var w,b,P=[];if(d)for(b=0;b<S.length;b++){w=x(a,S[b],s,E[b],_),i=w.topAndBottom,i.geometry=g.scaleToGeodeticHeightExtruded(i.geometry,u,h,a,_),i.geometry=T(o,i.geometry,n,a,l,!0,!1),P.push(i),r=w.walls;for(var A=0;A<r.length;A++){var I=r[A];I.geometry=g.scaleToGeodeticHeightExtruded(I.geometry,u,h,a,_),I.geometry=T(o,I.geometry,n,a,l,!0,!0),P.push(I)}}else for(b=0;b<S.length;b++)w=new p({geometry:g.createGeometryFromPositions(a,S[b],s,_)}),w.geometry=y.scaleToGeodeticHeight(w.geometry,u,a,!_),w.geometry=T(o,w.geometry,n,a,l,!1,!1),P.push(w);w=m.combineInstances(P)[0],w.attributes.position.values=new Float64Array(w.attributes.position.values),w.indices=f.createTypedArray(w.attributes.position.values.length/3,w.indices);var M=w.attributes,D=t.fromVertices(M.position.values);return o.position||delete M.position,new c({attributes:M,indices:w.indices,primitiveType:w.primitiveType,boundingSphere:D})}},b.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new b({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:i,perPositionHeight:!1,extrudedHeight:o,height:a,vertexFormat:E.POSITION_ONLY})},b}),r("Core/PolygonHierarchy",["./defined"],function(e){"use strict";function t(t,r){this.positions=e(t)?t:[],this.holes=e(r)?r:[]}return t}),r("Core/PolygonOutlineGeometry",["./BoundingSphere","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g){"use strict";function y(e,r,i,n){var o=a.fromPoints(r,e),h=o.projectPointsOntoPlane(r,S),p=f.computeWindingOrder2D(h);p===g.CLOCKWISE&&(h.reverse(),r=r.slice().reverse());var _,y,C=r.length,E=0;if(n)for(_=new Float64Array(2*C*3),y=0;C>y;y++){var T=r[y],x=r[(y+1)%C];_[E++]=T.x,_[E++]=T.y,_[E++]=T.z,_[E++]=x.x,_[E++]=x.y,_[E++]=x.z}else{var b=0;for(y=0;C>y;y++)b+=m.subdivideLineCount(r[y],r[(y+1)%C],i);for(_=new Float64Array(3*b),y=0;C>y;y++)for(var P=m.subdivideLine(r[y],r[(y+1)%C],i,w),A=P.length,I=0;A>I;++I)_[E++]=P[I]}C=_.length/3;var M=2*C,D=d.createTypedArray(C,M);for(E=0,y=0;C-1>y;y++)D[E++]=y,D[E++]=y+1;return D[E++]=C-1,D[E++]=0,new c({geometry:new s({attributes:new u({position:new l({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:_})}),indices:D,primitiveType:v.LINES})})}function C(e,r,i,n){var o=a.fromPoints(r,e),h=o.projectPointsOntoPlane(r,S),p=f.computeWindingOrder2D(h);p===g.CLOCKWISE&&(h.reverse(),r=r.slice().reverse());var _,y,C=r.length,E=new Array(C),T=0;if(n)for(_=new Float64Array(2*C*3*2),y=0;C>y;++y){E[y]=T/3;var x=r[y],b=r[(y+1)%C];_[T++]=x.x,_[T++]=x.y,_[T++]=x.z,_[T++]=b.x,_[T++]=b.y,_[T++]=b.z}else{var P=0;for(y=0;C>y;y++)P+=m.subdivideLineCount(r[y],r[(y+1)%C],i);for(_=new Float64Array(3*P*2),y=0;C>y;++y){E[y]=T/3;for(var A=m.subdivideLine(r[y],r[(y+1)%C],i,w),I=A.length,M=0;I>M;++M)_[T++]=A[M]}}C=_.length/6;var D=E.length,R=2*(2*C+D),O=d.createTypedArray(C,R);for(T=0,y=0;C>y;++y)O[T++]=y,O[T++]=(y+1)%C,O[T++]=y+C,O[T++]=(y+1)%C+C;for(y=0;D>y;y++){var N=E[y];O[T++]=N,O[T++]=N+C}return new c({geometry:new s({attributes:new u({position:new l({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:_})}),indices:O,primitiveType:v.LINES})})}function E(e){var t=e.polygonHierarchy,n=r(e.ellipsoid,o.WGS84),a=r(e.granularity,p.RADIANS_PER_DEGREE),s=r(e.height,0),l=r(e.perPositionHeight,!1),u=e.extrudedHeight,c=i(u);if(c&&!l){var h=u;u=Math.min(h,s),s=Math.max(h,s)}this._ellipsoid=o.clone(n),this._granularity=a,this._height=s,this._extrudedHeight=r(u,0),this._extrude=c,this._polygonHierarchy=t,this._perPositionHeight=l,this._workerName="createPolygonOutlineGeometry",this.packedLength=m.computeHierarchyPackedLength(t)+o.packedLength+6}var S=[],w=[];E.pack=function(e,t,i){i=r(i,0),i=m.packPolygonHierarchy(e._polygonHierarchy,t,i),o.pack(e._ellipsoid,t,i),i+=o.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._extrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e.packedLength};var T=o.clone(o.UNIT_SPHERE),x={polygonHierarchy:{}};return E.unpack=function(e,t,n){t=r(t,0);var a=m.unpackPolygonHierarchy(e,t);t=a.startingIndex,delete a.startingIndex;var s=o.unpack(e,t,T);t+=o.packedLength;var l=e[t++],u=e[t++],c=e[t++],h=1===e[t++],d=1===e[t++],p=e[t++];return i(n)||(n=new E(x)),n._polygonHierarchy=a,n._ellipsoid=o.clone(s,n._ellipsoid),n._height=l,n._extrudedHeight=u,n._granularity=c,n._extrude=h,n._perPositionHeight=d,n.packedLength=p,n},E.fromPositions=function(e){e=r(e,r.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new E(t)},E.createGeometry=function(t){var r=t._ellipsoid,n=t._granularity,o=t._height,a=t._extrudedHeight,l=t._extrude,u=t._polygonHierarchy,c=t._perPositionHeight,d=[],v=new _;v.enqueue(u);for(var g;0!==v.length;){var E=v.dequeue(),S=E.positions;if(S=f.removeDuplicates(S),!(S.length<3)){var w=E.holes?E.holes.length:0;for(g=0;w>g;g++){var T=E.holes[g];if(T.positions=f.removeDuplicates(T.positions),!(T.positions.length<3)){d.push(T.positions);var x=0;i(T.holes)&&(x=T.holes.length);for(var b=0;x>b;b++)v.enqueue(T.holes[b])}}d.push(S)}}if(0!==d.length){var P,A=[],I=p.chordLength(n,r.maximumRadius);if(l)for(g=0;g<d.length;g++)P=C(r,d[g],I,c),P.geometry=m.scaleToGeodeticHeightExtruded(P.geometry,o,a,r,c),A.push(P);else for(g=0;g<d.length;g++)P=y(r,d[g],I,c),P.geometry=f.scaleToGeodeticHeight(P.geometry,o,r,!c),A.push(P);P=h.combineInstances(A)[0];var M=e.fromVertices(P.attributes.position.values);return new s({attributes:P.attributes,indices:P.indices,primitiveType:P.primitiveType,boundingSphere:M})}},E}),r("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v){"use strict";function _(e,t,i,n,o){var a=y;a.length=o;var s,l=i.red,u=i.green,c=i.blue,h=i.alpha,d=n.red,p=n.green,m=n.blue,f=n.alpha;if(r.equals(i,n)){for(s=0;o>s;s++)a[s]=r.clone(i);return a}var v=(d-l)/o,_=(p-u)/o,g=(m-c)/o,C=(f-h)/o;for(s=0;o>s;s++)a[s]=new r(l+s*v,u+s*_,c+s*g,h+s*C);return a}function g(e){e=n(e,n.EMPTY_OBJECT);var i=e.positions,a=e.colors,l=n(e.width,1),u=n(e.colorsPerVertex,!1);this._positions=i,this._colors=a,this._width=l,this._colorsPerVertex=u,this._vertexFormat=v.clone(n(e.vertexFormat,v.DEFAULT)),this._followSurface=n(e.followSurface,!0),this._granularity=n(e.granularity,p.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(n(e.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var c=1+i.length*t.packedLength;c+=o(a)?1+a.length*r.packedLength:1,this.packedLength=c+s.packedLength+v.packedLength+4}var y=[];g.pack=function(e,i,a){a=n(a,0);var l,u=e._positions,c=u.length;for(i[a++]=c,l=0;c>l;++l,a+=t.packedLength)t.pack(u[l],i,a);var h=e._colors;for(c=o(h)?h.length:0,i[a++]=c,l=0;c>l;++l,a+=r.packedLength)r.pack(h[l],i,a);s.pack(e._ellipsoid,i,a),a+=s.packedLength,v.pack(e._vertexFormat,i,a),a+=v.packedLength,i[a++]=e._width,i[a++]=e._colorsPerVertex?1:0,i[a++]=e._followSurface?1:0,i[a]=e._granularity};var C=s.clone(s.UNIT_SPHERE),E=new v,S={positions:void 0,colors:void 0,ellipsoid:C,vertexFormat:E,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};g.unpack=function(e,i,a){i=n(i,0);var l,u=e[i++],c=new Array(u);for(l=0;u>l;++l,i+=t.packedLength)c[l]=t.unpack(e,i);u=e[i++];var h=u>0?new Array(u):void 0;for(l=0;u>l;++l,i+=r.packedLength)h[l]=r.unpack(e,i);var d=s.unpack(e,i,C);i+=s.packedLength;var p=v.unpack(e,i,E);i+=v.packedLength;var m=e[i++],f=1===e[i++],_=1===e[i++],y=e[i];return o(a)?(a._positions=c,a._colors=h,a._ellipsoid=s.clone(d,a._ellipsoid),a._vertexFormat=v.clone(p,a._vertexFormat),a._width=m,a._colorsPerVertex=f,a._followSurface=_,a._granularity=y,a):(S.positions=c,S.colors=h,S.width=m,S.colorsPerVertex=f,S.followSurface=_,S.granularity=y,new g(S))};var w=new t,T=new t,x=new t,b=new t;return g.createGeometry=function(n){var a,s,v,g=n._width,C=n._vertexFormat,E=n._colors,S=n._colorsPerVertex,P=n._followSurface,A=n._granularity,I=n._ellipsoid,M=p.chordLength(A,I.maximumRadius),D=m.removeDuplicates(n._positions),R=D.length;if(!(2>R)){if(P){var O=m.extractHeights(D,I);if(o(E)){var N=1;for(a=0;R-1>a;++a)N+=m.numberOfPoints(D[a],D[a+1],M);var L=new Array(N),F=0;for(a=0;R-1>a;++a){var B=D[a],V=D[a+1],z=E[a],k=m.numberOfPoints(B,V,M);if(S&&N>a){var U=E[a+1],G=_(B,V,z,U,k),W=G.length;for(s=0;W>s;++s)L[F++]=G[s]}else for(s=0;k>s;++s)L[F++]=r.clone(z)}L[F]=r.clone(E[E.length-1]),E=L,y.length=0}D=m.generateCartesianArc({positions:D,minDistance:M,ellipsoid:I,height:O})}R=D.length;var H,q=4*R-4,j=new Float64Array(3*q),Y=new Float64Array(3*q),X=new Float64Array(3*q),Z=new Float32Array(2*q),K=C.st?new Float32Array(2*q):void 0,Q=o(E)?new Uint8Array(4*q):void 0,J=0,$=0,ee=0,te=0;for(s=0;R>s;++s){0===s?(H=w,t.subtract(D[0],D[1],H),t.add(D[0],H,H)):H=D[s-1],t.clone(H,x),t.clone(D[s],T),s===R-1?(H=w,t.subtract(D[R-1],D[R-2],H),t.add(D[R-1],H,H)):H=D[s+1],t.clone(H,b);var re,ie;o(Q)&&(re=0===s||S?E[s]:E[s-1],s!==R-1&&(ie=E[s]));var ne=0===s?2:0,oe=s===R-1?2:4;for(v=ne;oe>v;++v){t.pack(T,j,J),t.pack(x,Y,J),t.pack(b,X,J),J+=3;var ae=0>v-2?-1:1;if(Z[$++]=2*(v%2)-1,Z[$++]=ae*g,C.st&&(K[ee++]=s/(R-1),K[ee++]=Math.max(Z[$-2],0)),o(Q)){var se=2>v?re:ie;Q[te++]=r.floatToByte(se.red),Q[te++]=r.floatToByte(se.green),Q[te++]=r.floatToByte(se.blue),Q[te++]=r.floatToByte(se.alpha)}}}var le=new c;le.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:j}),le.prevPosition=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:Y}),le.nextPosition=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:X}),le.expandAndWidth=new u({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:Z}),C.st&&(le.st=new u({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:K})),o(Q)&&(le.color=new u({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,values:Q,normalize:!0}));var ue=d.createTypedArray(q,6*R-6),ce=0,he=0,de=R-1;for(s=0;de>s;++s)ue[he++]=ce,ue[he++]=ce+2,ue[he++]=ce+1,ue[he++]=ce+1,ue[he++]=ce+2,ue[he++]=ce+3,ce+=4;return new l({attributes:le,indices:ue,primitiveType:f.TRIANGLES,boundingSphere:e.fromPoints(D),geometryType:h.POLYLINES})}},g}),r("Core/PolylineVolumeGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E){"use strict";function S(e,r,i,o){var a=new d;o.position&&(a.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e}));var s,l,u,f,_,g,C=r.length,E=e.length/3,S=(E-2*C)/(2*C),w=v.triangulate(r),T=(S-1)*C*6+2*w.length,x=m.createTypedArray(E,T),b=2*C,P=0;for(s=0;S-1>s;s++){for(l=0;C-1>l;l++)u=2*l+s*C*2,g=u+b,f=u+1,_=f+b,x[P++]=f,x[P++]=u,x[P++]=_,x[P++]=_,x[P++]=u,x[P++]=g;u=2*C-2+s*C*2,f=u+1,_=f+b,g=u+b,x[P++]=f,x[P++]=u,x[P++]=_,x[P++]=_,x[P++]=u,x[P++]=g}if(o.st||o.tangent||o.binormal){var A,I,M=new Float32Array(2*E),D=1/(S-1),R=1/i.height,O=i.height/2,N=0;for(s=0;S>s;s++){for(A=s*D,I=R*(r[0].y+O),M[N++]=A,M[N++]=I,l=1;C>l;l++)I=R*(r[l].y+O),M[N++]=A,M[N++]=I,M[N++]=A,M[N++]=I;I=R*(r[0].y+O),M[N++]=A,M[N++]=I}for(l=0;C>l;l++)A=0,I=R*(r[l].y+O),M[N++]=A,M[N++]=I;for(l=0;C>l;l++)A=(S-1)*D,I=R*(r[l].y+O),M[N++]=A,M[N++]=I;a.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:new Float32Array(M)})}var L=E-2*C;for(s=0;s<w.length;s+=3){var F=w[s]+L,B=w[s+1]+L,V=w[s+2]+L;x[P++]=F,x[P++]=B,x[P++]=V,x[P++]=V+C,x[P++]=B+C,x[P++]=F+C}var z=new c({attributes:a,indices:x,boundingSphere:t.fromVertices(e),primitiveType:y.TRIANGLES});return o.normal&&(z=p.computeNormal(z)),(o.tangent||o.binormal)&&(z=p.computeBinormalAndTangent(z),o.tangent||(z.attributes.tangent=void 0),o.binormal||(z.attributes.binormal=void 0),o.st||(z.attributes.st=void 0)),z}function w(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,n=e.shapePositions;this._positions=t,this._shape=n,this._ellipsoid=u.clone(a(e.ellipsoid,u.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._vertexFormat=C.clone(a(e.vertexFormat,C.DEFAULT)),this._granularity=a(e.granularity,f.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var s=1+t.length*i.packedLength;s+=1+n.length*r.packedLength,this.packedLength=s+u.packedLength+C.packedLength+2}w.pack=function(e,t,n){n=a(n,0);var o,s=e._positions,l=s.length;for(t[n++]=l,o=0;l>o;++o,n+=i.packedLength)i.pack(s[o],t,n);var c=e._shape;for(l=c.length,t[n++]=l,o=0;l>o;++o,n+=r.packedLength)r.pack(c[o],t,n);u.pack(e._ellipsoid,t,n),n+=u.packedLength,C.pack(e._vertexFormat,t,n),n+=C.packedLength,t[n++]=e._cornerType,t[n]=e._granularity};var T=u.clone(u.UNIT_SPHERE),x=new C,b={polylinePositions:void 0,shapePositions:void 0,ellipsoid:T,vertexFormat:x,cornerType:void 0,granularity:void 0};w.unpack=function(e,t,n){t=a(t,0);var o,l=e[t++],c=new Array(l);for(o=0;l>o;++o,t+=i.packedLength)c[o]=i.unpack(e,t);l=e[t++];var h=new Array(l);for(o=0;l>o;++o,t+=r.packedLength)h[o]=r.unpack(e,t);var d=u.unpack(e,t,T);t+=u.packedLength;var p=C.unpack(e,t,x);t+=C.packedLength;var m=e[t++],f=e[t];return s(n)?(n._positions=c,n._shape=h,n._ellipsoid=u.clone(d,n._ellipsoid),n._vertexFormat=C.clone(p,n._vertexFormat),n._cornerType=m,n._granularity=f,n):(b.polylinePositions=c,b.shapePositions=h,b.cornerType=m,b.granularity=f,new w(b))};var P=new e;return w.createGeometry=function(t){var r=t._positions,i=_.removeDuplicates(r),n=t._shape;if(n=g.removeDuplicatesFromShape(n),!(i.length<2||n.length<3)){v.computeWindingOrder2D(n)===E.CLOCKWISE&&n.reverse();var o=e.fromPoints(n,P),a=g.computePositions(i,n,o,t,!0);return S(a,n,o,t._vertexFormat)}},w}),r("Core/PolylineVolumeOutlineGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./WindingOrder"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y){"use strict";function C(e,r){var i=new d;i.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e});var o,a,s=r.length,l=i.position.values.length/3,u=e.length/3,m=u/s,f=p.createTypedArray(l,2*s*(m+1)),v=0;o=0;var _=o*s;for(a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=m-1,_=o*s,a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=0;m-1>o;o++){var y=s*o,C=y+s;for(a=0;s>a;a++)f[v++]=a+y,f[v++]=a+C}var E=new c({attributes:i,indices:p.createTypedArray(l,f),boundingSphere:t.fromVertices(e),primitiveType:g.LINES});return E}function E(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,n=e.shapePositions;this._positions=t,this._shape=n,this._ellipsoid=u.clone(a(e.ellipsoid,u.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._granularity=a(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var s=1+t.length*i.packedLength;s+=1+n.length*r.packedLength,this.packedLength=s+u.packedLength+2}E.pack=function(e,t,n){n=a(n,0);var o,s=e._positions,l=s.length;for(t[n++]=l,o=0;l>o;++o,n+=i.packedLength)i.pack(s[o],t,n);var c=e._shape;for(l=c.length,t[n++]=l,o=0;l>o;++o,n+=r.packedLength)r.pack(c[o],t,n);u.pack(e._ellipsoid,t,n),n+=u.packedLength,t[n++]=e._cornerType,t[n]=e._granularity};var S=u.clone(u.UNIT_SPHERE),w={polylinePositions:void 0,shapePositions:void 0,ellipsoid:S,height:void 0,cornerType:void 0,granularity:void 0};E.unpack=function(e,t,n){t=a(t,0);var o,l=e[t++],c=new Array(l);for(o=0;l>o;++o,t+=i.packedLength)c[o]=i.unpack(e,t);l=e[t++];var h=new Array(l);for(o=0;l>o;++o,t+=r.packedLength)h[o]=r.unpack(e,t);var d=u.unpack(e,t,S);t+=u.packedLength;var p=e[t++],m=e[t];return s(n)?(n._positions=c,n._shape=h,n._ellipsoid=u.clone(d,n._ellipsoid),n._cornerType=p,n._granularity=m,n):(w.polylinePositions=c,w.shapePositions=h,w.cornerType=p,w.granularity=m,new E(w))};var T=new e;return E.createGeometry=function(t){var r=t._positions,i=v.removeDuplicates(r),n=t._shape;if(n=_.removeDuplicatesFromShape(n),!(i.length<2||n.length<3)){f.computeWindingOrder2D(n)===y.CLOCKWISE&&n.reverse();var o=e.fromPoints(n,T),a=_.computePositions(i,n,o,t,!1);return C(a,n)}},E}),r("Core/QuaternionSpline",["./defaultValue","./defined","./defineProperties","./DeveloperError","./Quaternion","./Spline"],function(e,t,r,i,n,o){
"use strict";function a(e,r,i){var o=e.length,a=new Array(o);a[0]=t(r)?r:e[0],a[o-1]=t(i)?i:e[o-1];for(var s=1;o-1>s;++s)a[s]=n.computeInnerQuadrangle(e[s-1],e[s],e[s+1],new n);return a}function s(e){var r=e.points,i=e.innerQuadrangles,o=e.times;if(r.length<3){var a=o[0],s=1/(o[1]-a),l=r[0],u=r[1];return function(e,r){t(r)||(r=new n);var i=(e-a)*s;return n.fastSlerp(l,u,i,r)}}return function(a,s){t(s)||(s=new n);var l=e._lastTimeIndex=e.findTimeInterval(a,e._lastTimeIndex),u=(a-o[l])/(o[l+1]-o[l]),c=r[l],h=r[l+1],d=i[l],p=i[l+1];return n.fastSquad(c,h,d,p,u,s)}}function l(t){t=e(t,e.EMPTY_OBJECT);var r=t.points,i=t.times,n=t.firstInnerQuadrangle,o=t.lastInnerQuadrangle,l=a(r,n,o);this._times=i,this._points=r,this._innerQuadrangles=l,this._evaluateFunction=s(this),this._lastTimeIndex=0}return r(l.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},innerQuadrangles:{get:function(){return this._innerQuadrangles}}}),l.prototype.findTimeInterval=o.prototype.findTimeInterval,l.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},l}),r("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,r,i,n,o,a,s){"use strict";var l=Math.cos,u=Math.sin,c=Math.sqrt,h={};h.computePosition=function(e,t,i,n,o){var s=e.ellipsoid.radiiSquared,h=e.nwCorner,d=e.rectangle,p=h.latitude-e.granYCos*t+i*e.granXSin,m=l(p),f=u(p),v=s.z*f,_=h.longitude+t*e.granYSin+i*e.granXCos,g=m*l(_),y=m*u(_),C=s.x*g,E=s.y*y,S=c(C*g+E*y+v*f);n.x=C/S,n.y=E/S,n.z=v/S,r(e.vertexFormat)&&e.vertexFormat.st&&(o.x=(_-d.west)*e.lonScalar-.5,o.y=(p-d.south)*e.latScalar-.5,a.multiplyByVector(e.textureMatrix,o,o),o.x+=.5,o.y+=.5)};var d=new a,p=new e,m=new t,f=new e,v=new n;return h.computeOptions=function(t,n,l){var u,c,h,_,g,y=t._granularity,C=t._ellipsoid,E=t._surfaceHeight,S=t._rotation,w=t._extrudedHeight,T=n.east,x=n.west,b=n.north,P=n.south,A=b-P;x>T?(g=o.TWO_PI-x+T,u=Math.ceil(g/y)+1,c=Math.ceil(A/y)+1,h=g/(u-1),_=A/(c-1)):(g=T-x,u=Math.ceil(g/y)+1,c=Math.ceil(A/y)+1,h=g/(u-1),_=A/(c-1)),l=s.northwest(n,l);var I=s.center(n,m),M=_,D=h,R=0,O=0;if(r(S)){var N=Math.cos(S);M*=N,D*=N;var L=Math.sin(S);R=_*L,O=h*L,p=v.project(l,p),f=v.project(I,f),p=e.subtract(p,f,p);var F=a.fromRotation(S,d);p=a.multiplyByVector(F,p,p),p=e.add(p,f,p),l=v.unproject(p,l);var B=l.latitude,V=B+(u-1)*O,z=B-M*(c-1),k=B-M*(c-1)+(u-1)*O;b=Math.max(B,V,z,k),P=Math.min(B,V,z,k);var U=l.longitude,G=U+(u-1)*D,W=U+(c-1)*R,H=U+(c-1)*R+(u-1)*D;if(T=Math.max(U,G,W,H),x=Math.min(U,G,W,H),b<-o.PI_OVER_TWO||b>o.PI_OVER_TWO||P<-o.PI_OVER_TWO||P>o.PI_OVER_TWO)throw new i("Rotated rectangle is invalid.  It crosses over either the north or south pole.");n.north=b,n.south=P,n.east=T,n.west=x}return{granYCos:M,granYSin:R,granXCos:D,granXSin:O,ellipsoid:C,width:u,height:c,surfaceHeight:E,extrudedHeight:w,nwCorner:l,rectangle:n}},h}),r("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w){"use strict";function T(e,t){var r=new u({attributes:new h,primitiveType:y.TRIANGLES});return r.attributes.position=new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(r.attributes.normal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(r.attributes.binormal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.binormals})),r}function x(e,t,i,n){for(var o=e.length,a=t.normal?new Float32Array(o):void 0,s=t.tangent?new Float32Array(o):void 0,l=t.binormal?new Float32Array(o):void 0,u=0,c=L,h=N,d=O,p=0;o>p;p+=3){var m=r.fromArray(e,p,R),f=u+1,v=u+2;(t.normal||t.tangent||t.binormal)&&(d=i.geodeticSurfaceNormal(m,d),(t.tangent||t.binormal)&&(r.cross(r.UNIT_Z,d,h),_.multiplyByVector(n,h,h),r.normalize(h,h),t.binormal&&r.normalize(r.cross(d,h,c),c)),t.normal&&(a[u]=d.x,a[f]=d.y,a[v]=d.z),t.tangent&&(s[u]=h.x,s[f]=h.y,s[v]=h.z),t.binormal&&(l[u]=c.x,l[f]=c.y,l[v]=c.z)),u+=3}return T(t,{positions:e,normals:a,tangents:s,binormals:l})}function b(e,t,i){for(var n=e.length,o=t.normal?new Float32Array(n):void 0,a=t.tangent?new Float32Array(n):void 0,s=t.binormal?new Float32Array(n):void 0,l=0,u=0,c=0,h=!0,d=L,p=N,m=O,v=0;n>v;v+=6){var _=r.fromArray(e,v,R);if(t.normal||t.tangent||t.binormal){var g=r.fromArray(e,(v+6)%n,k);if(h){var y=r.fromArray(e,(v+3)%n,U);r.subtract(g,_,g),r.subtract(y,_,y),m=r.normalize(r.cross(y,g,m),m),h=!1}r.equalsEpsilon(g,_,f.EPSILON10)&&(h=!0),(t.tangent||t.binormal)&&(d=i.geodeticSurfaceNormal(_,d),t.tangent&&(p=r.normalize(r.cross(d,m,p),p))),t.normal&&(o[l++]=m.x,o[l++]=m.y,o[l++]=m.z,o[l++]=m.x,o[l++]=m.y,o[l++]=m.z),t.tangent&&(a[u++]=p.x,a[u++]=p.y,a[u++]=p.z,a[u++]=p.x,a[u++]=p.y,a[u++]=p.z),t.binormal&&(s[c++]=d.x,s[c++]=d.y,s[c++]=d.z,s[c++]=d.x,s[c++]=d.y,s[c++]=d.z)}}return T(t,{positions:e,normals:o,tangents:a,binormals:s})}function P(e){for(var t=e.vertexFormat,r=e.ellipsoid,i=e.size,o=e.height,a=e.width,s=t.position?new Float64Array(3*i):void 0,l=t.st?new Float32Array(2*i):void 0,u=0,h=0,d=R,p=B,f=Number.MAX_VALUE,v=Number.MAX_VALUE,_=Number.MIN_VALUE,g=Number.MIN_VALUE,y=0;o>y;++y)for(var C=0;a>C;++C)S.computePosition(e,y,C,d,p),s[u++]=d.x,s[u++]=d.y,s[u++]=d.z,t.st&&(l[h++]=p.x,l[h++]=p.y,f=Math.min(f,p.x),v=Math.min(v,p.y),_=Math.max(_,p.x),g=Math.max(g,p.y));if(t.st&&(0>f||0>v||_>1||g>1))for(var E=0;E<l.length;E+=2)l[E]=(l[E]-f)/(_-f),l[E+1]=(l[E+1]-v)/(g-v);for(var w=x(s,t,r,e.tangentRotationMatrix),T=6*(a-1)*(o-1),b=m.createTypedArray(i,T),P=0,A=0,I=0;o-1>I;++I){for(var M=0;a-1>M;++M){var D=P,O=D+a,N=O+1,L=D+1;b[A++]=D,b[A++]=O,b[A++]=L,b[A++]=L,b[A++]=O,b[A++]=N,++P}++P}return w.indices=b,t.st&&(w.attributes.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:l})),w}function A(e,t,r,i,n){return e[t++]=i[r],e[t++]=i[r+1],e[t++]=i[r+2],e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r+2],e}function I(e,t,r,i){return e[t++]=i[r],e[t++]=i[r+1],e[t++]=i[r],e[t++]=i[r+1],e}function M(e){var t,i=e.vertexFormat,o=e.surfaceHeight,a=e.extrudedHeight,s=Math.min(a,o),l=Math.max(a,o),u=e.height,h=e.width,v=e.ellipsoid,_=P(e);if(f.equalsEpsilon(s,l,f.EPSILON10))return _;_=g.scaleToGeodeticHeight(_,l,v,!1);var y=new Float64Array(_.attributes.position.values),C=y.length,E=2*C,S=new Float64Array(E);S.set(y),_=g.scaleToGeodeticHeight(_,s,v);var w=_.attributes.position.values;S.set(w,C),_.attributes.position.values=S;var T,x=i.normal?new Float32Array(E):void 0,M=i.tangent?new Float32Array(E):void 0,D=i.binormal?new Float32Array(E):void 0,R=i.st?new Float32Array(E/3*2):void 0;if(i.normal){var O=_.attributes.normal.values;for(x.set(O),t=0;C>t;t++)O[t]=-O[t];x.set(O,C),_.attributes.normal.values=x}if(i.tangent){var N=_.attributes.tangent.values;for(M.set(N),t=0;C>t;t++)N[t]=-N[t];M.set(N,C),_.attributes.tangent.values=M}if(i.binormal){var L=_.attributes.binormal.values;D.set(L),D.set(L,C),_.attributes.binormal.values=D}i.st&&(T=_.attributes.st.values,R.set(T),R.set(T,C/3*2),_.attributes.st.values=R);var F=_.indices,B=F.length,V=C/3,z=m.createTypedArray(E/3,2*B);for(z.set(F),t=0;B>t;t+=3)z[t+B]=F[t+2]+V,z[t+1+B]=F[t+1]+V,z[t+2+B]=F[t]+V;_.indices=z;var G=2*h+2*u-4,W=2*(G+4),H=new Float64Array(3*W),q=i.st?new Float32Array(2*W):void 0,j=0,Y=0,X=h*u;for(t=0;X>t;t+=h)H=A(H,j,3*t,y,w),j+=6,i.st&&(q=I(q,Y,2*t,T),Y+=4);for(t=X-h;X>t;t++)H=A(H,j,3*t,y,w),j+=6,i.st&&(q=I(q,Y,2*t,T),Y+=4);for(t=X-1;t>0;t-=h)H=A(H,j,3*t,y,w),j+=6,i.st&&(q=I(q,Y,2*t,T),Y+=4);for(t=h-1;t>=0;t--)H=A(H,j,3*t,y,w),j+=6,i.st&&(q=I(q,Y,2*t,T),Y+=4);var Z=b(H,i,v);i.st&&(Z.attributes.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:q}));var K,Q,J,$,ee=m.createTypedArray(W,6*G);C=H.length/3;var te=0;for(t=0;C-1>t;t+=2){K=t,$=(K+2)%C;var re=r.fromArray(H,3*K,k),ie=r.fromArray(H,3*$,U);r.equalsEpsilon(re,ie,f.EPSILON10)||(Q=(K+1)%C,J=(Q+2)%C,ee[te++]=K,ee[te++]=Q,ee[te++]=$,ee[te++]=$,ee[te++]=Q,ee[te++]=J)}return Z.indices=ee,Z=p.combineInstances([new d({geometry:_}),new d({geometry:Z})]),Z[0]}function D(e){e=o(e,o.EMPTY_OBJECT);var t=e.rectangle,r=o(e.granularity,f.RADIANS_PER_DEGREE),i=o(e.ellipsoid,l.WGS84),n=o(e.height,0),s=o(e.rotation,0),u=o(e.stRotation,0),c=o(e.vertexFormat,w.DEFAULT),h=e.extrudedHeight,d=a(h),p=o(e.closeTop,!0),m=o(e.closeBottom,!0);this._rectangle=t,this._granularity=r,this._ellipsoid=l.clone(i),this._surfaceHeight=n,this._rotation=s,this._stRotation=u,this._vertexFormat=w.clone(c),this._extrudedHeight=o(h,0),this._extrude=d,this._closeTop=p,this._closeBottom=m,this._workerName="createRectangleGeometry"}var R=new r,O=new r,N=new r,L=new r,F=new E,B=new t,V=new e,z=new e,k=new r,U=new r;D.packedLength=E.packedLength+l.packedLength+w.packedLength+8,D.pack=function(e,t,r){r=o(r,0),E.pack(e._rectangle,t,r),r+=E.packedLength,l.pack(e._ellipsoid,t,r),r+=l.packedLength,w.pack(e._vertexFormat,t,r),r+=w.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=e._stRotation,t[r++]=e._extrudedHeight,t[r++]=e._extrude?1:0,t[r++]=e._closeTop?1:0,t[r]=e._closeBottom?1:0};var G=new E,W=l.clone(l.UNIT_SPHERE),H=new w,q={rectangle:G,ellipsoid:W,vertexFormat:H,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0};D.unpack=function(e,t,r){t=o(t,0);var i=E.unpack(e,t,G);t+=E.packedLength;var n=l.unpack(e,t,W);t+=l.packedLength;var s=w.unpack(e,t,H);t+=w.packedLength;var u=e[t++],c=e[t++],h=e[t++],d=e[t++],p=e[t++],m=1===e[t++],f=1===e[t++],v=1===e[t];return a(r)?(r._rectangle=E.clone(i,r._rectangle),r._ellipsoid=l.clone(n,r._ellipsoid),r._vertexFormat=w.clone(s,r._vertexFormat),r._granularity=u,r._surfaceHeight=c,r._rotation=h,r._stRotation=d,r._extrudedHeight=m?p:void 0,r._extrude=m,r._closeTop=f,r._closeBottom=v,r):(q.granularity=u,q.height=c,q.rotation=h,q.stRotation=d,q.extrudedHeight=m?p:void 0,q.closeTop=f,q.closeBottom=v,new D(q))};var j=new v,Y=new _,X=new i,Z=new C,K=new i;return D.createGeometry=function(t){var i=E.clone(t._rectangle,F),n=t._ellipsoid,o=t._surfaceHeight,s=t._extrude,l=t._extrudedHeight,c=t._stRotation,d=t._vertexFormat,p=S.computeOptions(t,i,X),m=j,f=Y;if(a(c)){v.fromRotation(-c,m);var y=E.center(i,K),w=n.cartographicToCartesian(y,k);r.normalize(w,w),C.fromAxisAngle(w,-c,Z),_.fromQuaternion(Z,f)}else v.clone(v.IDENTITY,m),_.clone(_.IDENTITY,f);p.lonScalar=1/i.width,p.latScalar=1/i.height,p.vertexFormat=d,p.textureMatrix=m,p.tangentRotationMatrix=f,p.size=p.width*p.height;var T,x;if(i=t._rectangle,s){T=M(p);var b=e.fromRectangle3D(i,n,o,z),A=e.fromRectangle3D(i,n,l,V);x=e.union(b,A)}else T=P(p),T=g.scaleToGeodeticHeight(T,o,n,!1),x=e.fromRectangle3D(i,n,o);return d.position||delete T.attributes.position,new u({attributes:new h(T.attributes),indices:T.indices,primitiveType:T.primitiveType,boundingSphere:x})},D.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new D({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:i,extrudedHeight:a,height:o,closeTop:!0,closeBottom:!0,vertexFormat:w.POSITION_ONLY})},D}),r("Core/RectangleOutlineGeometry",["./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Rectangle","./RectangleGeometryLibrary"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v){"use strict";function _(e){var t,r=e.size,n=e.height,o=e.width,a=new Float64Array(3*r),s=0,d=0,p=S;for(t=0;o>t;t++)v.computePosition(e,d,t,p),a[s++]=p.x,a[s++]=p.y,a[s++]=p.z;for(t=o-1,d=1;n>d;d++)v.computePosition(e,d,t,p),a[s++]=p.x,a[s++]=p.y,a[s++]=p.z;for(d=n-1,t=o-2;t>=0;t--)v.computePosition(e,d,t,p),a[s++]=p.x,a[s++]=p.y,a[s++]=p.z;for(t=0,d=n-2;d>0;d--)v.computePosition(e,d,t,p),a[s++]=p.x,a[s++]=p.y,a[s++]=p.z;for(var f=a.length/3*2,_=h.createTypedArray(a.length/3,f),g=0,y=0;y<a.length/3-1;y++)_[g++]=y,_[g++]=y+1;_[g++]=a.length/3-1,_[g++]=0;var C=new l({attributes:new c,primitiveType:m.LINES});return C.attributes.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:a}),C.indices=_,C}function g(e){var t=e.surfaceHeight,r=e.extrudedHeight,i=e.ellipsoid,n=Math.min(r,t),o=Math.max(r,t),a=_(e);if(d.equalsEpsilon(n,o,d.EPSILON10))return a;var s=e.height,l=e.width;a=p.scaleToGeodeticHeight(a,o,i,!1);var u=a.attributes.position.values,c=u.length,m=new Float64Array(2*c);m.set(u),a=p.scaleToGeodeticHeight(a,n,i);var f=a.attributes.position.values;m.set(f,c),a.attributes.position.values=m;var v=m.length/3*2+8,g=h.createTypedArray(m.length/3,v);c=m.length/6;for(var y=0,C=0;c-1>C;C++)g[y++]=C,g[y++]=C+1,g[y++]=C+c,g[y++]=C+c+1;return g[y++]=c-1,g[y++]=0,g[y++]=c+c-1,g[y++]=c,g[y++]=0,g[y++]=c,g[y++]=l-1,g[y++]=c+l-1,g[y++]=l+s-2,g[y++]=l+s-2+c,g[y++]=2*l+s-3,g[y++]=2*l+s-3+c,a.indices=g,a}function y(e){e=n(e,n.EMPTY_OBJECT);var t=e.rectangle,r=n(e.granularity,d.RADIANS_PER_DEGREE),i=n(e.ellipsoid,s.WGS84),o=n(e.height,0),a=n(e.rotation,0),l=e.extrudedHeight;this._rectangle=t,this._granularity=r,this._ellipsoid=i,this._surfaceHeight=o,this._rotation=a,this._extrudedHeight=l,this._workerName="createRectangleOutlineGeometry"}var C=new e,E=new e,S=new t,w=new f;y.packedLength=f.packedLength+s.packedLength+5,y.pack=function(e,t,r){r=n(r,0),f.pack(e._rectangle,t,r),r+=f.packedLength,s.pack(e._ellipsoid,t,r),r+=s.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=o(e._extrudedHeight)?1:0,t[r]=n(e._extrudedHeight,0)};var T=new f,x=s.clone(s.UNIT_SPHERE),b={rectangle:T,ellipsoid:x,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0};y.unpack=function(e,t,r){t=n(t,0);var i=f.unpack(e,t,T);t+=f.packedLength;var a=s.unpack(e,t,x);t+=s.packedLength;var l=e[t++],u=e[t++],c=e[t++],h=e[t++],d=e[t];return o(r)?(r._rectangle=f.clone(i,r._rectangle),r._ellipsoid=s.clone(a,r._ellipsoid),r._surfaceHeight=u,r._rotation=c,r._extrudedHeight=h?d:void 0,r):(b.granularity=l,b.height=u,b.rotation=c,b.extrudedHeight=h?d:void 0,new y(b))};var P=new r;return y.createGeometry=function(t){var r=f.clone(t._rectangle,w),i=t._ellipsoid,n=t._surfaceHeight,a=t._extrudedHeight,s=v.computeOptions(t,r,P);s.size=2*s.width+2*s.height-4;var u,c;if(r=t._rectangle,o(a)){u=g(s);var h=e.fromRectangle3D(r,i,n,E),d=e.fromRectangle3D(r,i,a,C);c=e.union(h,d)}else u=_(s),u=p.scaleToGeodeticHeight(u,n,i,!1),c=e.fromRectangle3D(r,i,n);return new l({attributes:u.attributes,indices:u.indices,primitiveType:m.LINES,boundingSphere:c})},y}),r("Core/ReferenceFrame",["./freezeObject"],function(e){"use strict";var t={FIXED:0,INERTIAL:1};return e(t)}),r("Core/requestAnimationFrame",["./defined","./getTimestamp"],function(e,t){"use strict";function r(e){return i(e)}if("undefined"!=typeof window){var i=window.requestAnimationFrame;return function(){if(!e(i))for(var r=["webkit","moz","ms","o"],n=0,o=r.length;o>n&&!e(i);)i=window[r[n]+"RequestAnimationFrame"],++n;if(!e(i)){var a=1e3/60,s=0;i=function(e){var r=t(),i=Math.max(a-(r-s),0);return s=r+i,setTimeout(function(){e(s)},i)}}}(),r}}),r("Core/sampleTerrain",["../ThirdParty/when","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,i){function o(){t.ready?e(n(t,r,i),function(e){a.resolve(e)}):setTimeout(o,10)}var a=e.defer();return o(),a.promise}function n(t,r,i){var n,s=t.tilingScheme,l=[],u={};for(n=0;n<i.length;++n){var c=s.positionToTileXY(i[n],r),h=c.toString();if(!u.hasOwnProperty(h)){var d={x:c.x,y:c.y,level:r,tilingScheme:s,terrainProvider:t,positions:[]};u[h]=d,l.push(d)}u[h].positions.push(i[n])}var p=[];for(n=0;n<l.length;++n){var m=l[n],f=m.terrainProvider.requestTileGeometry(m.x,m.y,m.level,!1),v=e(f,o(m),a(m));p.push(v)}return e.all(p,function(){return i})}function o(e){var t=e.positions,r=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(e){for(var i=0;i<t.length;++i){var n=t[i];n.height=e.interpolateHeight(r,n.longitude,n.latitude)}}}function a(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e){var r=t[e];r.height=void 0}}}return i}),r("Core/ScreenSpaceEventType",["./freezeObject"],function(e){"use strict";var t={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,RIGHT_DOUBLE_CLICK:8,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MIDDLE_DOUBLE_CLICK:13,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19};return e(t)}),r("Core/ScreenSpaceEventHandler",["./AssociativeArray","./Cartesian2","./defaultValue","./defined","./destroyObject","./DeveloperError","./FeatureDetection","./KeyboardEventModifier","./ScreenSpaceEventType"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e,t,r){var i=e._element;if(i===document)return r.x=t.clientX,r.y=t.clientY,r;var n=i.getBoundingClientRect();return r.x=t.clientX-n.left,r.y=t.clientY-n.top,r}function c(e,t){var r=e;return i(t)&&(r+="+"+t),r}function h(e){return e.shiftKey?s.SHIFT:e.ctrlKey?s.CTRL:e.altKey?s.ALT:void 0}function d(e,t,r,i){function n(t){i(e,t)}r.addEventListener(t,n,!1),e._removalFunctions.push(function(){r.removeEventListener(t,n,!1)})}function p(e){var t=e._element,r=i(t.disableRootEvents)?t:document;a.supportsPointerEvents()?(d(e,"pointerdown",t,x),d(e,"pointerup",t,b),d(e,"pointermove",t,P)):(d(e,"mousedown",t,f),d(e,"mouseup",r,v),d(e,"mousemove",r,_),d(e,"touchstart",t,C),d(e,"touchend",r,E),d(e,"touchmove",r,w)),d(e,"dblclick",t,g);var n;n="onwheel"in t?"wheel":i(document.onmousewheel)?"mousewheel":"DOMMouseScroll",d(e,n,t,y)}function m(e){for(var t=e._removalFunctions,r=0;r<t.length;++r)t[r]()}function f(e,r){if(!e._seenAnyTouchEvents){var n=r.button;e._buttonDown=n;var o;if(n===I.LEFT)o=l.LEFT_DOWN;else if(n===I.MIDDLE)o=l.MIDDLE_DOWN;else{if(n!==I.RIGHT)return;o=l.RIGHT_DOWN}var a=u(e,r,e._primaryPosition);t.clone(a,e._primaryStartPosition),t.clone(a,e._primaryPreviousPosition);var s=h(r),c=e.getInputAction(o,s);i(c)&&(t.clone(a,M.position),c(M),r.preventDefault())}}function v(e,r){if(!e._seenAnyTouchEvents){var n=r.button;e._buttonDown=void 0;var o,a;if(n===I.LEFT)o=l.LEFT_UP,a=l.LEFT_CLICK;else if(n===I.MIDDLE)o=l.MIDDLE_UP,a=l.MIDDLE_CLICK;else{if(n!==I.RIGHT)return;o=l.RIGHT_UP,a=l.RIGHT_CLICK}var s=h(r),c=e.getInputAction(o,s),d=e.getInputAction(a,s);if(i(c)||i(d)){var p=u(e,r,e._primaryPosition);if(i(c)&&(t.clone(p,D.position),c(D)),i(d)){var m=e._primaryStartPosition,f=m.x-p.x,v=m.y-p.y,_=Math.sqrt(f*f+v*v);_<e._clickPixelTolerance&&(t.clone(p,R.position),d(R))}}}}function _(e,r){if(!e._seenAnyTouchEvents){var n=h(r),o=u(e,r,e._primaryPosition),a=e._primaryPreviousPosition,s=e.getInputAction(l.MOUSE_MOVE,n);i(s)&&(t.clone(a,O.startPosition),t.clone(o,O.endPosition),s(O)),t.clone(o,a),i(e._buttonDown)&&r.preventDefault()}}function g(e,t){var r,n=t.button;if(n===I.LEFT)r=l.LEFT_DOUBLE_CLICK;else if(n===I.MIDDLE)r=l.MIDDLE_DOUBLE_CLICK;else{if(n!==I.RIGHT)return;r=l.RIGHT_DOUBLE_CLICK}var o=h(t),a=e.getInputAction(r,o);i(a)&&(u(e,t,N.position),a(N))}function y(e,t){var r;if(i(t.deltaY)){var n=t.deltaMode;r=n===t.DOM_DELTA_PIXEL?-t.deltaY:n===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY}else r=t.detail>0?-120*t.detail:t.wheelDelta;if(i(r)){var o=h(t),a=e.getInputAction(l.WHEEL,o);i(a)&&(a(r),t.preventDefault())}}function C(e,r){e._seenAnyTouchEvents=!0;var i,n,o,a=r.changedTouches,s=a.length,l=e._positions;for(i=0;s>i;++i)n=a[i],o=n.identifier,l.set(o,u(e,n,new t));S(e,r);var c=e._previousPositions;for(i=0;s>i;++i)n=a[i],o=n.identifier,c.set(o,t.clone(l.get(o)))}function E(e,t){e._seenAnyTouchEvents=!0;var r,i,n,o=t.changedTouches,a=o.length,s=e._positions;for(r=0;a>r;++r)i=o[r],n=i.identifier,s.remove(n);S(e,t);var l=e._previousPositions;for(r=0;a>r;++r)i=o[r],n=i.identifier,l.remove(n)}function S(e,r){var n,o,a=h(r),s=e._positions,u=e._previousPositions,c=s.length;if(1!==c&&e._buttonDown===I.LEFT&&(e._buttonDown=void 0,n=e.getInputAction(l.LEFT_UP,a),i(n)&&(t.clone(e._primaryPosition,B.position),n(B)),0===c&&(o=e.getInputAction(l.LEFT_CLICK,a),i(o)))){var d=e._primaryStartPosition,p=u.values[0],m=d.x-p.x,f=d.y-p.y,v=Math.sqrt(m*m+f*f);v<e._clickPixelTolerance&&(t.clone(e._primaryPosition,V.position),o(V))}if(2!==c&&e._isPinching&&(e._isPinching=!1,n=e.getInputAction(l.PINCH_END,a),i(n)&&n()),1===c){var _=s.values[0];t.clone(_,e._primaryPosition),t.clone(_,e._primaryStartPosition),t.clone(_,e._primaryPreviousPosition),e._buttonDown=I.LEFT,n=e.getInputAction(l.LEFT_DOWN,a),i(n)&&(t.clone(_,L.position),n(L)),r.preventDefault()}2===c&&(e._isPinching=!0,n=e.getInputAction(l.PINCH_START,a),i(n)&&(t.clone(s.values[0],F.position1),t.clone(s.values[1],F.position2),n(F)))}function w(e,r){e._seenAnyTouchEvents=!0;var n,o,a,s=r.changedTouches,l=s.length,c=e._positions;for(n=0;l>n;++n){o=s[n],a=o.identifier;var h=c.get(a);i(h)&&u(e,o,h)}T(e,r);var d=e._previousPositions;for(n=0;l>n;++n)o=s[n],a=o.identifier,t.clone(c.get(a),d.get(a))}function T(e,r){var n,o=h(r),a=e._positions,s=e._previousPositions,u=a.length;if(1===u&&e._buttonDown===I.LEFT){var c=a.values[0];t.clone(c,e._primaryPosition);var d=e._primaryPreviousPosition;n=e.getInputAction(l.MOUSE_MOVE,o),i(n)&&(t.clone(d,z.startPosition),t.clone(c,z.endPosition),n(z)),t.clone(c,d),r.preventDefault()}else if(2===u&&e._isPinching&&(n=e.getInputAction(l.PINCH_MOVE,o),i(n))){var p=a.values[0],m=a.values[1],f=s.values[0],v=s.values[1],_=m.x-p.x,g=m.y-p.y,y=.25*Math.sqrt(_*_+g*g),C=v.x-f.x,E=v.y-f.y,S=.25*Math.sqrt(C*C+E*E),w=.125*(m.y+p.y),T=.125*(v.y+f.y),x=Math.atan2(g,_),b=Math.atan2(E,C);t.fromElements(0,S,k.distance.startPosition),t.fromElements(0,y,k.distance.endPosition),t.fromElements(b,T,k.angleAndHeight.startPosition),t.fromElements(x,w,k.angleAndHeight.endPosition),n(k)}}function x(e,r){if(r.target.setPointerCapture(r.pointerId),"touch"===r.pointerType){var i=e._positions,n=r.pointerId;i.set(n,u(e,r,new t)),S(e,r);var o=e._previousPositions;o.set(n,t.clone(i.get(n)))}else f(e,r)}function b(e,t){if("touch"===t.pointerType){var r=e._positions,i=t.pointerId;r.remove(i),S(e,t);var n=e._previousPositions;n.remove(i)}else v(e,t)}function P(e,r){if("touch"===r.pointerType){var i=e._positions,n=r.pointerId;u(e,r,i.get(n)),T(e,r);var o=e._previousPositions;t.clone(i.get(n),o.get(n))}else _(e,r)}function A(i){this._inputEvents={},this._buttonDown=void 0,this._isPinching=!1,this._seenAnyTouchEvents=!1,this._primaryStartPosition=new t,this._primaryPosition=new t,this._primaryPreviousPosition=new t,this._positions=new e,this._previousPositions=new e,this._removalFunctions=[],this._clickPixelTolerance=5,this._element=r(i,document),p(this)}var I={LEFT:0,MIDDLE:1,RIGHT:2},M={position:new t},D={position:new t},R={position:new t},O={startPosition:new t,endPosition:new t},N={position:new t},L={position:new t},F={position1:new t,position2:new t},B={position:new t},V={position:new t},z={startPosition:new t,endPosition:new t},k={distance:{startPosition:new t,endPosition:new t},angleAndHeight:{startPosition:new t,endPosition:new t}};return A.prototype.setInputAction=function(e,t,r){var i=c(t,r);this._inputEvents[i]=e},A.prototype.getInputAction=function(e,t){var r=c(e,t);return this._inputEvents[r]},A.prototype.removeInputAction=function(e,t){var r=c(e,t);delete this._inputEvents[r]},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){return m(this),n(this)},A}),r("Core/ShowGeometryInstanceAttribute",["./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,r,i,n){"use strict";function o(e){e=t(e,!0),this.value=o.toValue(e)}return i(o.prototype,{componentDatatype:{get:function(){return e.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),o.toValue=function(e,t){return r(t)?(t[0]=e,t):new Uint8Array([e])},o}),r("Core/Simon1994PlanetaryPositions",["./Cartesian3","./defined","./DeveloperError","./JulianDate","./Math","./Matrix3","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){var t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}function u(e,t){t=i.addSeconds(e,C,t);var r=i.totalDays(t)-E;return t=i.addSeconds(t,l(r),t)}function c(i,a,s,l,u,c,p,m){if(0>s&&(s=-s,u+=n.PI),0>s||s>n.PI)throw new r("The inclination is out of range. Inclination must be greater than or equal to zero and less than or equal to Pi radians.");var v=i*(1-a),_=l-u,g=u,y=d(c-l,a),C=h(a,0);if("Hyperbolic"===C&&Math.abs(n.negativePiToPi(y))>=Math.acos(-1/a))throw new r("The true anomaly of the hyperbolic orbit lies outside of the bounds of the hyperbola.");f(_,s,g,I);var E=v*(1+a),S=Math.cos(y),w=Math.sin(y),T=1+a*S;if(T<=n.Epsilon10)throw new r("elements cannot be converted to cartesian");var x=E/T;return t(m)?(m.x=x*S,m.y=x*w,m.z=0):m=new e(x*S,x*w,0),o.multiplyByVector(I,m,m)}function h(e,t){if(0>e)throw new r("eccentricity cannot be negative.");return t>=e?"Circular":1-t>e?"Elliptical":1+t>=e?"Parabolic":"Hyperbolic"}function d(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=p(e,t);return m(i,t)}function p(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o,a=e+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),s=Number.MAX_VALUE;for(o=0;M>o&&Math.abs(s-a)>D;++o){s=a;var l=s-t*Math.sin(s)-e,u=1-t*Math.cos(s);a=s-l/u}if(o>=M)throw new r("Kepler equation did not converge");return s=a+i*n.TWO_PI}function m(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o=Math.cos(e)-t,a=Math.sin(e)*Math.sqrt(1-t*t),s=Math.atan2(a,o);return s=n.zeroToTwoPi(s),0>e&&(s-=n.TWO_PI),s+=i*n.TWO_PI}function f(e,i,a,s){if(0>i||i>n.PI)throw new r("inclination out of range");var l=Math.cos(e),u=Math.sin(e),c=Math.cos(i),h=Math.sin(i),d=Math.cos(a),p=Math.sin(a);return t(s)?(s[0]=d*l-p*u*c,s[1]=p*l+d*u*c,s[2]=u*h,s[3]=-d*u-p*l*c,s[4]=-p*u+d*l*c,s[5]=l*h,s[6]=p*h,s[7]=-d*h,s[8]=c):s=new o(d*l-p*u*c,-d*u-p*l*c,p*h,p*l+d*u*c,-p*u+d*l*c,-d*h,u*h,l*h,c),s}function v(e,t){u(e,Ie);var r=Ie.dayNumber-S.dayNumber+(Ie.secondsOfDay-S.secondsOfDay)/a.SECONDS_PER_DAY,i=r/(10*a.DAYS_PER_JULIAN_CENTURY),n=.3595362*i,o=R+W*Math.cos(L*n)+Q*Math.sin(L*n)+H*Math.cos(F*n)+J*Math.sin(F*n)+q*Math.cos(B*n)+$*Math.sin(B*n)+j*Math.cos(V*n)+ee*Math.sin(V*n)+Y*Math.cos(z*n)+te*Math.sin(z*n)+X*Math.cos(k*n)+re*Math.sin(k*n)+Z*Math.cos(U*n)+ie*Math.sin(U*n)+K*Math.cos(G*n)+ne*Math.sin(G*n),s=O+N*i+pe*Math.cos(oe*n)+Ee*Math.sin(oe*n)+me*Math.cos(ae*n)+Se*Math.sin(ae*n)+fe*Math.cos(se*n)+we*Math.sin(se*n)+ve*Math.cos(le*n)+Te*Math.sin(le*n)+_e*Math.cos(ue*n)+xe*Math.sin(ue*n)+ge*Math.cos(ce*n)+be*Math.sin(ce*n)+ye*Math.cos(he*n)+Pe*Math.sin(he*n)+Ce*Math.cos(de*n)+Ae*Math.sin(de*n),l=.0167086342-.0004203654*i,h=102.93734808*b+11612.3529*P*i,d=469.97289*P*i,p=174.87317577*b-8679.27034*P*i;return c(o,l,d,h,p,s,T,t)}function _(e,t){u(e,Ie);var r=Ie.dayNumber-S.dayNumber+(Ie.secondsOfDay-S.secondsOfDay)/a.SECONDS_PER_DAY,i=r/a.DAYS_PER_JULIAN_CENTURY,n=i*i,o=n*i,s=o*i,l=383397.7725+.004*i,h=.055545526-1.6e-8*i,d=5.15668983*b,p=-8e-5*i+.02966*n-42e-6*o-1.3e-7*s,m=83.35324312*b,f=14643420.2669*i-38.2702*n-.045047*o+21301e-8*s,v=125.04455501*b,_=-6967919.3631*i+6.3602*n+.007625*o-3586e-8*s,g=218.31664563*b,y=1732559343.4847*i-6.391*n+.006588*o-3169e-8*s,C=297.85019547*b+P*(1602961601.209*i-6.3706*n+.006593*o-3169e-8*s),E=93.27209062*b+P*(1739527262.8478*i-12.7512*n-.001037*o+417e-8*s),T=134.96340251*b+P*(1717915923.2178*i+31.8792*n+.051635*o-2447e-7*s),A=357.52910918*b+P*(129596581.0481*i-.5532*n+136e-6*o-1149e-8*s),I=310.17137918*b-P*(6967051.436*i+6.2068*n+.007618*o-3219e-8*s),M=2*C,D=4*C,R=6*C,O=2*T,N=3*T,L=4*T,F=2*E;l+=3400.4*Math.cos(M)-635.6*Math.cos(M-T)-235.6*Math.cos(T)+218.1*Math.cos(M-A)+181*Math.cos(M+T),h+=.014216*Math.cos(M-T)+.008551*Math.cos(M-O)-.001383*Math.cos(T)+.001356*Math.cos(M+T)-.001147*Math.cos(D-N)-914e-6*Math.cos(D-O)+869e-6*Math.cos(M-A-T)-627e-6*Math.cos(M)-394e-6*Math.cos(D-L)+282e-6*Math.cos(M-A-O)-279e-6*Math.cos(C-T)-236e-6*Math.cos(O)+231e-6*Math.cos(D)+229e-6*Math.cos(R-L)-201e-6*Math.cos(O-F),p+=486.26*Math.cos(M-F)-40.13*Math.cos(M)+37.51*Math.cos(F)+25.73*Math.cos(O-F)+19.97*Math.cos(M-A-F),f+=-55609*Math.sin(M-T)-34711*Math.sin(M-O)-9792*Math.sin(T)+9385*Math.sin(D-N)+7505*Math.sin(D-O)+5318*Math.sin(M+T)+3484*Math.sin(D-L)-3417*Math.sin(M-A-T)-2530*Math.sin(R-L)-2376*Math.sin(M)-2075*Math.sin(M-N)-1883*Math.sin(O)-1736*Math.sin(R-5*T)+1626*Math.sin(A)-1370*Math.sin(R-N),_+=-5392*Math.sin(M-F)-540*Math.sin(A)-441*Math.sin(M)+423*Math.sin(F)-288*Math.sin(O-F),y+=-3332.9*Math.sin(M)+1197.4*Math.sin(M-T)-662.5*Math.sin(A)+396.3*Math.sin(T)-218*Math.sin(M-A);var B=2*I,V=3*I;p+=46.997*Math.cos(I)*i-.614*Math.cos(M-F+I)*i+.614*Math.cos(M-F-I)*i-.0297*Math.cos(B)*n-.0335*Math.cos(I)*n+.0012*Math.cos(M-F+B)*n-16e-5*Math.cos(I)*o+4e-5*Math.cos(V)*o+4e-5*Math.cos(B)*o;var z=2.116*Math.sin(I)*i-.111*Math.sin(M-F-I)*i-.0015*Math.sin(I)*n;f+=z,y+=z,_+=-520.77*Math.sin(I)*i+13.66*Math.sin(M-F+I)*i+1.12*Math.sin(M-I)*i-1.06*Math.sin(F-I)*i+.66*Math.sin(B)*n+.371*Math.sin(I)*n-.035*Math.sin(M-F+B)*n-.015*Math.sin(M-F+I)*n+.0014*Math.sin(I)*o-.0011*Math.sin(V)*o-9e-4*Math.sin(B)*o,l*=x;var k=d+p*P,U=m+f*P,G=g+y*P,W=v+_*P;return c(l,h,k,U,W,G,w,t)}function g(t,r){return r=_(t,r),e.multiplyByScalar(r,De,r)}var y={},C=32.184,E=2451545,S=new i(2451545,0,s.TAI),w=398600435e6,T=1.012300034*w*328900.56,x=1e3,b=n.RADIANS_PER_DEGREE,P=n.RADIANS_PER_ARCSECOND,A=14959787e4,I=new o,M=50,D=n.EPSILON8,R=1.0000010178*A,O=100.46645683*b,N=1295977422.83429*P,L=16002,F=21863,B=32004,V=10931,z=14529,k=16368,U=15318,G=32794,W=64e-7*A,H=-152*1e-7*A,q=62e-7*A,j=-8e-7*A,Y=32e-7*A,X=-41*1e-7*A,Z=19e-7*A,K=-11*1e-7*A,Q=-150*1e-7*A,J=-46*1e-7*A,$=68*1e-7*A,ee=54e-7*A,te=14e-7*A,re=24e-7*A,ie=-28*1e-7*A,ne=22e-7*A,oe=10,ae=16002,se=21863,le=10931,ue=1473,ce=32004,he=4387,de=73,pe=-325*1e-7,me=-322*1e-7,fe=-79*1e-7,ve=232*1e-7,_e=-52*1e-7,ge=97e-7,ye=55e-7,Ce=-41*1e-7,Ee=-105*1e-7,Se=-137*1e-7,we=258e-7,Te=35e-7,xe=-116*1e-7,be=-88*1e-7,Pe=-112*1e-7,Ae=-80*1e-7,Ie=new i(0,0,s.TAI),Me=.012300034,De=Me/(Me+1)*-1,Re=new o(1.0000000000000002,5.619723173785822e-16,4.690511510146299e-19,-5.154129427414611e-16,.9174820620691819,-.39777715593191376,-2.23970096136568e-16,.39777715593191376,.9174820620691819),Oe=new e;return y.computeSunPositionInEarthInertialFrame=function(r,n){return t(r)||(r=i.now()),t(n)||(n=new e),Oe=v(r,Oe),n=e.negate(Oe,n),g(r,Oe),e.subtract(n,Oe,n),o.multiplyByVector(Re,n,n),n},y.computeMoonPositionInEarthInertialFrame=function(e,r){return t(e)||(e=i.now()),r=_(e,r),o.multiplyByVector(Re,r,r),r},y}),r("Core/SimplePolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e,t,i,n,o,a,s){var l,u=p.numberOfPoints(e,t,o),c=i.red,h=i.green,d=i.blue,m=i.alpha,f=n.red,v=n.green,_=n.blue,g=n.alpha;if(r.equals(i,n)){for(l=0;u>l;l++)a[s++]=r.floatToByte(c),a[s++]=r.floatToByte(h),a[s++]=r.floatToByte(d),a[s++]=r.floatToByte(m);return s}var y=(f-c)/u,C=(v-h)/u,E=(_-d)/u,S=(g-m)/u,w=s;for(l=0;u>l;l++)a[w++]=r.floatToByte(c+l*y),a[w++]=r.floatToByte(h+l*C),a[w++]=r.floatToByte(d+l*E),a[w++]=r.floatToByte(m+l*S);return w}function v(e){e=n(e,n.EMPTY_OBJECT);
var i=e.positions,a=e.colors,l=n(e.colorsPerVertex,!1);this._positions=i,this._colors=a,this._colorsPerVertex=l,this._followSurface=n(e.followSurface,!0),this._granularity=n(e.granularity,d.RADIANS_PER_DEGREE),this._ellipsoid=n(e.ellipsoid,s.WGS84),this._workerName="createSimplePolylineGeometry";var u=1+i.length*t.packedLength;u+=o(a)?1+a.length*r.packedLength:1,this.packedLength=u+s.packedLength+3}v.pack=function(e,i,a){a=n(a,0);var l,u=e._positions,c=u.length;for(i[a++]=c,l=0;c>l;++l,a+=t.packedLength)t.pack(u[l],i,a);var h=e._colors;for(c=o(h)?h.length:0,i[a++]=c,l=0;c>l;++l,a+=r.packedLength)r.pack(h[l],i,a);s.pack(e._ellipsoid,i,a),a+=s.packedLength,i[a++]=e._colorsPerVertex?1:0,i[a++]=e._followSurface?1:0,i[a]=e._granularity},v.unpack=function(e,i,a){i=n(i,0);var l,u=e[i++],c=new Array(u);for(l=0;u>l;++l,i+=t.packedLength)c[l]=t.unpack(e,i);u=e[i++];var h=u>0?new Array(u):void 0;for(l=0;u>l;++l,i+=r.packedLength)h[l]=r.unpack(e,i);var d=s.unpack(e,i);i+=s.packedLength;var p=1===e[i++],m=1===e[i++],f=e[i];return o(a)?(a._positions=c,a._colors=h,a._ellipsoid=d,a._colorsPerVertex=p,a._followSurface=m,a._granularity=f,a):new v({positions:c,colors:h,ellipsoid:d,colorsPerVertex:p,followSurface:m,granularity:f})};var _=new Array(2),g=new Array(2),y={positions:_,height:g,ellipsoid:void 0,minDistance:void 0};return v.createGeometry=function(n){var a,s,v,C,E,S=n._positions,w=n._colors,T=n._colorsPerVertex,x=n._followSurface,b=n._granularity,P=n._ellipsoid,A=d.chordLength(b,P.maximumRadius),I=o(w)&&!T,M=S.length,D=0;if(x){var R=p.extractHeights(S,P),O=y;if(O.minDistance=A,O.ellipsoid=P,I){var N=0;for(a=0;M-1>a;a++)N+=p.numberOfPoints(S[a],S[a+1],A)+1;s=new Float64Array(3*N),C=new Uint8Array(4*N),O.positions=_,O.height=g;var L=0;for(a=0;M-1>a;++a){_[0]=S[a],_[1]=S[a+1],g[0]=R[a],g[1]=R[a+1];var F=p.generateArc(O);if(o(w)){var B=F.length/3;E=w[a];for(var V=0;B>V;++V)C[L++]=r.floatToByte(E.red),C[L++]=r.floatToByte(E.green),C[L++]=r.floatToByte(E.blue),C[L++]=r.floatToByte(E.alpha)}s.set(F,D),D+=F.length}}else if(O.positions=S,O.height=R,s=new Float64Array(p.generateArc(O)),o(w)){for(C=new Uint8Array(s.length/3*4),a=0;M-1>a;++a){var z=S[a],k=S[a+1],U=w[a],G=w[a+1];D=f(z,k,U,G,A,C,D)}var W=w[M-1];C[D++]=r.floatToByte(W.red),C[D++]=r.floatToByte(W.green),C[D++]=r.floatToByte(W.blue),C[D++]=r.floatToByte(W.alpha)}}else{v=I?2*M-2:M,s=new Float64Array(3*v),C=o(w)?new Uint8Array(4*v):void 0;var H=0,q=0;for(a=0;M>a;++a){var j=S[a];if(I&&a>0&&(t.pack(j,s,H),H+=3,E=w[a-1],C[q++]=r.floatToByte(E.red),C[q++]=r.floatToByte(E.green),C[q++]=r.floatToByte(E.blue),C[q++]=r.floatToByte(E.alpha)),I&&a===M-1)break;t.pack(j,s,H),H+=3,o(w)&&(E=w[a],C[q++]=r.floatToByte(E.red),C[q++]=r.floatToByte(E.green),C[q++]=r.floatToByte(E.blue),C[q++]=r.floatToByte(E.alpha))}}var Y=new c;Y.position=new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:s}),o(w)&&(Y.color=new u({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,values:C,normalize:!0})),v=s.length/3;var X=2*(v-1),Z=h.createTypedArray(v,X),K=0;for(a=0;v-1>a;++a)Z[K++]=a,Z[K++]=a+1;return new l({attributes:Y,indices:Z,primitiveType:m.LINES,boundingSphere:e.fromPoints(S)})},v}),r("Core/SphereGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipsoidGeometry","./VertexFormat"],function(e,t,r,i,n,o){"use strict";function a(r){var i=t(r.radius,1),o=new e(i,i,i),a={radii:o,stackPartitions:r.stackPartitions,slicePartitions:r.slicePartitions,vertexFormat:r.vertexFormat};this._ellipsoidGeometry=new n(a),this._workerName="createSphereGeometry"}a.packedLength=n.packedLength,a.pack=function(e,t,r){n.pack(e._ellipsoidGeometry,t,r)};var s=new n,l={radius:void 0,radii:new e,vertexFormat:new o,stackPartitions:void 0,slicePartitions:void 0};return a.unpack=function(t,i,u){var c=n.unpack(t,i,s);return l.vertexFormat=o.clone(c._vertexFormat,l.vertexFormat),l.stackPartitions=c._stackPartitions,l.slicePartitions=c._slicePartitions,r(u)?(e.clone(c._radii,l.radii),u._ellipsoidGeometry=new n(l),u):(l.radius=c._radii.x,new a(l))},a.createGeometry=function(e){return n.createGeometry(e._ellipsoidGeometry)},a}),r("Core/SphereOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipsoidOutlineGeometry"],function(e,t,r,i,n){"use strict";function o(r){var i=t(r.radius,1),o=new e(i,i,i),a={radii:o,stackPartitions:r.stackPartitions,slicePartitions:r.slicePartitions,subdivisions:r.subdivisions};this._ellipsoidGeometry=new n(a),this._workerName="createSphereOutlineGeometry"}o.packedLength=n.packedLength,o.pack=function(e,t,r){n.pack(e._ellipsoidGeometry,t,r)};var a=new n,s={radius:void 0,radii:new e,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return o.unpack=function(t,i,l){var u=n.unpack(t,i,a);return s.stackPartitions=u._stackPartitions,s.slicePartitions=u._slicePartitions,s.subdivisions=u._subdivisions,r(l)?(e.clone(u._radii,s.radii),l._ellipsoidGeometry=new n(s),l):(s.radius=u._radii.x,new o(s))},o.createGeometry=function(e){return n.createGeometry(e._ellipsoidGeometry)},o}),r("Core/Spherical",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,i){this.clock=e(t,0),this.cone=e(r,0),this.magnitude=e(i,1)}return i.fromCartesian3=function(e,r){var n=e.x,o=e.y,a=e.z,s=n*n+o*o;return t(r)||(r=new i),r.clock=Math.atan2(o,n),r.cone=Math.atan2(Math.sqrt(s),a),r.magnitude=Math.sqrt(s+a*a),r},i.clone=function(e,r){return t(e)?t(r)?(r.clock=e.clock,r.cone=e.cone,r.magnitude=e.magnitude,r):new i(e.clock,e.cone,e.magnitude):void 0},i.normalize=function(e,r){return t(r)?(r.clock=e.clock,r.cone=e.cone,r.magnitude=1,r):new i(e.clock,e.cone,1)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.clock===r.clock&&e.cone===r.cone&&e.magnitude===r.magnitude},i.equalsEpsilon=function(r,i,n){return n=e(n,0),r===i||t(r)&&t(i)&&Math.abs(r.clock-i.clock)<=n&&Math.abs(r.cone-i.cone)<=n&&Math.abs(r.magnitude-i.magnitude)<=n},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"},i}),r("Core/subdivideArray",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e,t){for(var r=[],i=e.length,n=0;i>n;){var o=Math.ceil((i-n)/t--);r.push(e.slice(n,n+o)),n+=o}return r}return r}),r("Core/TerrainData",["./defineProperties","./DeveloperError"],function(e,t){"use strict";function r(){t.throwInstantiationError()}return e(r.prototype,{waterMask:{get:t.throwInstantiationError}}),r.prototype.interpolateHeight=t.throwInstantiationError,r.prototype.isChildAvailable=t.throwInstantiationError,r.prototype.createMesh=t.throwInstantiationError,r.prototype.upsample=t.throwInstantiationError,r.prototype.wasCreatedByUpsampling=t.throwInstantiationError,r}),r("Core/TilingScheme",["./defineProperties","./DeveloperError"],function(e,t){"use strict";function r(e){throw new t("This type should not be instantiated directly.  Instead, use WebMercatorTilingScheme or GeographicTilingScheme.")}return e(r.prototype,{ellipsoid:{get:t.throwInstantiationError},rectangle:{get:t.throwInstantiationError},projection:{get:t.throwInstantiationError}}),r.prototype.getNumberOfXTilesAtLevel=t.throwInstantiationError,r.prototype.getNumberOfYTilesAtLevel=t.throwInstantiationError,r.prototype.rectangleToNativeRectangle=t.throwInstantiationError,r.prototype.tileXYToNativeRectangle=t.throwInstantiationError,r.prototype.tileXYToRectangle=t.throwInstantiationError,r.prototype.positionToTileXY=t.throwInstantiationError,r}),r("Core/TimeIntervalCollection",["./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./Event","./JulianDate","./TimeInterval"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t){return a.compare(e.start,t.start)}function u(e){if(this._intervals=[],this._changedEvent=new o,r(e))for(var t=e.length,i=0;t>i;i++)this.addInterval(e[i])}i(u.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0===e.length?!1:e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0===t?!1:e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),u.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof u))return!1;var r=this._intervals,i=e._intervals,n=r.length;if(n!==i.length)return!1;for(var o=0;n>o;o++)if(!s.equals(r[o],i[o],t))return!1;return!0},u.prototype.get=function(e){return this._intervals[e]},u.prototype.removeAll=function(){this._intervals.length>0&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},u.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},u.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},u.prototype.contains=function(e){return this.indexOf(e)>=0};var c=new s;return u.prototype.indexOf=function(t){var r=this._intervals;c.start=t,c.stop=t;var i=e(r,c,l);return i>=0?r[i].isStartIncluded?i:i>0&&r[i-1].stop.equals(t)&&r[i-1].isStopIncluded?i-1:~i:(i=~i,i>0&&i-1<r.length&&s.contains(r[i-1],t)?i-1:~i)},u.prototype.findInterval=function(e){e=t(e,t.EMPTY_OBJECT);for(var i=e.start,n=e.stop,o=e.isStartIncluded,a=e.isStopIncluded,s=this._intervals,l=0,u=s.length;u>l;l++){var c=s[l];if((!r(i)||c.start.equals(i))&&(!r(n)||c.stop.equals(n))&&(!r(o)||c.isStartIncluded===o)&&(!r(a)||c.isStopIncluded===a))return s[l]}},u.prototype.addInterval=function(t,i){if(!t.isEmpty){var n,o,u=this._intervals;if(0===u.length||a.greaterThan(t.start,u[u.length-1].stop))return u.push(t),void this._changedEvent.raiseEvent(this);for(o=e(u,t,l),0>o?o=~o:o>0&&t.isStartIncluded&&u[o-1].isStartIncluded&&u[o-1].start.equals(t.start)?--o:o<u.length&&!t.isStartIncluded&&u[o].isStartIncluded&&u[o].start.equals(t.start)&&++o,o>0&&(n=a.compare(u[o-1].stop,t.start),(n>0||0===n&&(u[o-1].isStopIncluded||t.isStartIncluded))&&((r(i)?i(u[o-1].data,t.data):u[o-1].data===t.data)?(t=new s(a.greaterThan(t.stop,u[o-1].stop)?{start:u[o-1].start,stop:t.stop,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:t.isStopIncluded,data:t.data}:{start:u[o-1].start,stop:u[o-1].stop,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:u[o-1].isStopIncluded||t.stop.equals(u[o-1].stop)&&t.isStopIncluded,data:t.data}),u.splice(o-1,1),--o):(n=a.compare(u[o-1].stop,t.stop),n>0||0===n&&u[o-1].isStopIncluded&&!t.isStopIncluded?u.splice(o-1,1,new s({start:u[o-1].start,stop:t.start,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:u[o-1].data}),new s({start:t.stop,stop:u[o-1].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:u[o-1].isStopIncluded,data:u[o-1].data})):u[o-1]=new s({start:u[o-1].start,stop:t.start,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:u[o-1].data}))));o<u.length&&(n=a.compare(t.stop,u[o].start),n>0||0===n&&(t.isStopIncluded||u[o].isStartIncluded));)if(r(i)?i(u[o].data,t.data):u[o].data===t.data)t=new s({start:t.start,stop:a.greaterThan(u[o].stop,t.stop)?u[o].stop:t.stop,isStartIncluded:t.isStartIncluded,isStopIncluded:a.greaterThan(u[o].stop,t.stop)?u[o].isStopIncluded:t.isStopIncluded,data:t.data}),u.splice(o,1);else{if(u[o]=new s({start:t.stop,stop:u[o].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:u[o].isStopIncluded,data:u[o].data}),!u[o].isEmpty)break;u.splice(o,1)}u.splice(o,0,t),this._changedEvent.raiseEvent(this)}},u.prototype.removeInterval=function(t){if(t.isEmpty)return!1;var r=!1,i=this._intervals,n=e(i,t,l);0>n&&(n=~n);var o=t.start,u=t.stop,c=t.isStartIncluded,h=t.isStopIncluded;if(n>0){var d=i[n-1],p=d.stop;(a.greaterThan(p,o)||s.equals(p,o)&&d.isStopIncluded&&c)&&(r=!0,(a.greaterThan(p,u)||d.isStopIncluded&&!h&&s.equals(p,u))&&i.splice(n,0,new s({start:u,stop:p,isStartIncluded:!h,isStopIncluded:d.isStopIncluded,data:d.data})),i[n-1]=new s({start:d.start,stop:o,isStartIncluded:d.isStartIncluded,isStopIncluded:!c,data:d.data}))}var m=i[n];for(n<i.length&&!c&&m.isStartIncluded&&o.equals(m.start)&&(r=!0,i.splice(n,0,new s({start:m.start,stop:m.start,isStartIncluded:!0,isStopIncluded:!0,data:m.data})),++n,m=i[n]);n<i.length&&a.greaterThan(u,m.stop);)r=!0,i.splice(n,1);return n<i.length&&u.equals(m.stop)&&(r=!0,!h&&m.isStopIncluded?(n+1<i.length&&i[n+1].start.equals(u)&&m.data===i[n+1].data?(i.splice(n,1),m=new s({start:m.start,stop:m.stop,isStartIncluded:!0,isStopIncluded:m.isStopIncluded,data:m.data})):m=new s({start:u,stop:u,isStartIncluded:!0,isStopIncluded:!0,data:m.data}),i[n]=m):i.splice(n,1)),n<i.length&&(a.greaterThan(u,m.start)||u.equals(m.start)&&h&&m.isStartIncluded)&&(r=!0,i[n]=new s({start:u,stop:m.stop,isStartIncluded:!h,isStopIncluded:m.isStopIncluded,data:m.data})),r&&this._changedEvent.raiseEvent(this),r},u.prototype.intersect=function(e,t,i){for(var n=0,o=0,l=new u,c=this._intervals,h=e._intervals;n<c.length&&o<h.length;){var d=c[n],p=h[o];if(a.lessThan(d.stop,p.start))++n;else if(a.lessThan(p.stop,d.start))++o;else{if(r(i)||r(t)&&t(d.data,p.data)||!r(t)&&p.data===d.data){var m=s.intersect(d,p,new s,i);m.isEmpty||l.addInterval(m,t)}a.lessThan(d.stop,p.stop)||d.stop.equals(p.stop)&&!d.isStopIncluded&&p.isStopIncluded?++n:++o}}return l},u}),r("Core/TranslationRotationScale",["./Cartesian3","./defaultValue","./defined","./Matrix4","./Quaternion"],function(e,t,r,i,n){"use strict";var o=new e(1,1,1),a=e.ZERO,s=n.IDENTITY,l=function(r,i,l){this.translation=e.clone(t(r,a)),this.rotation=n.clone(t(i,s)),this.scale=e.clone(t(l,o))};return l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this.translation,t.translation)&&n.equals(this.rotation,t.rotation)&&e.equals(this.scale,t.scale)},l}),r("Core/VideoSynchronizer",["./defaultValue","./defined","./defineProperties","./destroyObject","./DeveloperError","./Event","./Iso8601","./JulianDate"],function(e,t,r,i,n,o,a,s){"use strict";function l(t){t=e(t,e.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this.clock=t.clock,this.element=t.element,this.epoch=e(t.epoch,a.MINIMUM_VALUE),this.tolerance=e(t.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function u(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}return r(l.prototype,{clock:{get:function(){return this._clock},set:function(e){var r=this._clock;r!==e&&(t(r)&&(this._clockSubscription(),this._clockSubscription=void 0),t(e)&&(this._clockSubscription=e.onTick.addEventListener(l.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){var r=this._element;r!==e&&(t(r)&&r.removeEventListener("seeked",this._seekFunction,!1),t(e)&&(this._seeking=!1,this._seekFunction=u(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),l.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,i(this)},l.prototype.isDestroyed=function(){return!1},l.prototype._onTick=function(r){var i=this._element;if(t(i)&&!(i.readyState<2)){var n=i.paused,o=r.shouldAnimate;if(o===n&&(o?i.play():i.pause()),this._seeking||this._firstTickAfterSeek)return void(this._firstTickAfterSeek=!1);i.playbackRate=r.multiplier;var l,u=r.currentTime,c=e(this.epoch,a.MINIMUM_VALUE),h=s.secondsDifference(u,c),d=i.duration,p=i.currentTime;i.loop?(h%=d,0>h&&(h=d-h),l=h):l=h>d?d:0>h?0:h;var m=o?e(this.tolerance,1):.001;Math.abs(l-p)>m&&(this._seeking=!0,i.currentTime=l)}},l}),r("Core/VRTheWorldTerrainProvider",["../ThirdParty/when","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Event","./GeographicTilingScheme","./getImagePixels","./HeightmapTerrainData","./loadImage","./loadXML","./Math","./Rectangle","./TerrainProvider","./throttleRequestByServer","./TileProviderError"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_){"use strict";function g(e,t){this.rectangle=e,this.maxLevel=t}function y(n){function u(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"!==t)return void c("SRS "+t+" is not supported.");C._tilingScheme=new l({ellipsoid:E});var r=e.getElementsByTagName("TileFormat")[0];C._heightmapWidth=parseInt(r.getAttribute("width"),10),C._heightmapHeight=parseInt(r.getAttribute("height"),10),C._levelZeroMaximumGeometricError=f.getEstimatedLevelZeroGeometricErrorForAHeightmap(E,Math.min(C._heightmapWidth,C._heightmapHeight),C._tilingScheme.getNumberOfXTilesAtLevel(0));for(var i=e.getElementsByTagName("DataExtent"),n=0;n<i.length;++n){var o=i[n],a=p.toRadians(parseFloat(o.getAttribute("minx"))),s=p.toRadians(parseFloat(o.getAttribute("miny"))),u=p.toRadians(parseFloat(o.getAttribute("maxx"))),h=p.toRadians(parseFloat(o.getAttribute("maxy"))),d=parseInt(o.getAttribute("maxlevel"),10);C._rectangles.push(new g(new m(a,s,u,h),d))}C._ready=!0,C._readyPromise.resolve(!0)}function c(e){var t=r(e,"An error occurred while accessing "+C._url+".");y=_.handleError(y,C,C._errorEvent,t,void 0,void 0,void 0,h)}function h(){e(d(C._url),u,c)}if(n=r(n,r.EMPTY_OBJECT),!i(n.url))throw new o("options.url is required.");this._url=n.url,this._url.length>0&&"/"!==this._url[this._url.length-1]&&(this._url+="/"),this._errorEvent=new s,this._ready=!1,this._readyPromise=e.defer(),this._proxy=n.proxy,this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0};var v=n.credit;"string"==typeof v&&(v=new t(v)),this._credit=v,this._tilingScheme=void 0,this._rectangles=[];var y,C=this,E=r(n.ellipsoid,a.WGS84);h()}function C(e,t,r,n){for(var o=e._tilingScheme,a=e._rectangles,s=o.tileXYToRectangle(t,r,n),l=0,u=0;u<a.length&&15!==l;++u){var c=a[u];if(!(c.maxLevel<=n)){var h=c.rectangle,d=m.intersection(h,s,S);i(d)&&(E(o,h,2*t,2*r,n+1)&&(l|=4),E(o,h,2*t+1,2*r,n+1)&&(l|=8),E(o,h,2*t,2*r+1,n+1)&&(l|=1),E(o,h,2*t+1,2*r+1,n+1)&&(l|=2))}}return l}function E(e,t,r,n,o){var a=e.tileXYToRectangle(r,n,o);return i(m.intersection(a,t,S))}n(y.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),y.prototype.requestTileGeometry=function(t,n,a,s){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");var l=this._tilingScheme.getNumberOfYTilesAtLevel(a),d=this._url+a+"/"+t+"/"+(l-n-1)+".tif?cesium=true",p=this._proxy;i(p)&&(d=p.getURL(d));var m;if(s=r(s,!0)){if(m=v(d,h),!i(m))return}else m=h(d);var f=this;return e(m,function(e){return new c({buffer:u(e),width:f._heightmapWidth,height:f._heightmapHeight,childTileMask:C(f,t,n,a),structure:f._terrainDataStructure})})},y.prototype.getLevelMaximumGeometricError=function(e){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");return this._levelZeroMaximumGeometricError/(1<<e)};var S=new m;return y.prototype.getTileDataAvailable=function(e,t,r){},y}),r("Core/WallGeometryLibrary",["./Cartographic","./defined","./DeveloperError","./EllipsoidTangentPlane","./Math","./PolygonPipeline","./PolylinePipeline","./WindingOrder"],function(e,t,r,i,n,o,a,s){"use strict";function l(e,t){return n.equalsEpsilon(e.latitude,t.latitude,n.EPSILON14)&&n.equalsEpsilon(e.longitude,t.longitude,n.EPSILON14)}function u(r,i,n,o){var a=i.length;if(2>a)return{positions:i};var s=t(o),u=t(n),c=new Array(a),p=new Array(a),m=new Array(a),f=i[0];c[0]=f;var v=r.cartesianToCartographic(f,h);u&&(v.height=n[0]),p[0]=v.height,s?m[0]=o[0]:m[0]=0;for(var _=1,g=1;a>g;++g){var y=i[g],C=r.cartesianToCartographic(y,d);u&&(C.height=n[g]),l(v,C)?v.height<C.height&&(p[_-1]=C.height):(c[_]=y,p[_]=C.height,s?m[_]=o[g]:m[_]=0,e.clone(C,v),++_)}return c.length=_,p.length=_,m.length=_,{positions:c,topHeights:p,bottomHeights:m}}var c={},h=new e,d=new e,p=new Array(2),m=new Array(2),f={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};return c.computePositions=function(e,t,r,l,c,h){var d=u(e,t,r,l);if(t=d.positions,r=d.topHeights,l=d.bottomHeights,!(t.length<2)){if(t.length>=3){var v=i.fromPoints(t,e),_=v.projectPointsOntoPlane(t);o.computeWindingOrder2D(_)===s.CLOCKWISE&&(t.reverse(),r.reverse(),l.reverse())}var g,y,C=t.length,E=n.chordLength(c,e.maximumRadius),S=f;if(S.minDistance=E,S.ellipsoid=e,h){var w,T=0;for(w=0;C-1>w;w++)T+=a.numberOfPoints(t[w],t[w+1],E)+1;g=new Float64Array(3*T),y=new Float64Array(3*T);var x=p,b=m;S.positions=x,S.height=b;var P=0;for(w=0;C-1>w;w++){x[0]=t[w],x[1]=t[w+1],b[0]=r[w],b[1]=r[w+1];var A=a.generateArc(S);g.set(A,P),b[0]=l[w],b[1]=l[w+1],y.set(a.generateArc(S),P),P+=A.length}}else S.positions=t,S.height=r,g=new Float64Array(a.generateArc(S)),S.height=l,y=new Float64Array(a.generateArc(S));return{bottomPositions:y,topPositions:g}}},c}),r("Core/WallGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,o=e.maximumHeights,s=e.minimumHeights,l=i(e.vertexFormat,p.DEFAULT),u=i(e.granularity,h.RADIANS_PER_DEGREE),c=i(e.ellipsoid,a.WGS84);this._positions=r,this._minimumHeights=s,this._maximumHeights=o,this._vertexFormat=p.clone(l),this._granularity=u,this._ellipsoid=a.clone(c),this._workerName="createWallGeometry";var d=1+r.length*t.packedLength+2;n(s)&&(d+=s.length),n(o)&&(d+=o.length),this.packedLength=d+a.packedLength+p.packedLength+1}var v=new t,_=new t,g=new t,y=new t,C=new t,E=new t,S=new t,w=new t;f.pack=function(e,r,o){o=i(o,0);var s,l=e._positions,u=l.length;for(r[o++]=u,s=0;u>s;++s,o+=t.packedLength)t.pack(l[s],r,o);var c=e._minimumHeights;if(u=n(c)?c.length:0,r[o++]=u,n(c))for(s=0;u>s;++s)r[o++]=c[s];var h=e._maximumHeights;if(u=n(h)?h.length:0,r[o++]=u,n(h))for(s=0;u>s;++s)r[o++]=h[s];a.pack(e._ellipsoid,r,o),o+=a.packedLength,p.pack(e._vertexFormat,r,o),o+=p.packedLength,r[o]=e._granularity};var T=a.clone(a.UNIT_SPHERE),x=new p,b={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:T,vertexFormat:x,granularity:void 0};return f.unpack=function(e,r,o){r=i(r,0);var s,l=e[r++],u=new Array(l);for(s=0;l>s;++s,r+=t.packedLength)u[s]=t.unpack(e,r);l=e[r++];var c;if(l>0)for(c=new Array(l),s=0;l>s;++s)c[s]=e[r++];l=e[r++];var h;if(l>0)for(h=new Array(l),s=0;l>s;++s)h[s]=e[r++];var d=a.unpack(e,r,T);r+=a.packedLength;var m=p.unpack(e,r,x);r+=p.packedLength;var v=e[r];return n(o)?(o._positions=u,o._minimumHeights=c,o._maximumHeights=h,o._ellipsoid=a.clone(d,o._ellipsoid),o._vertexFormat=p.clone(m,o._vertexFormat),o._granularity=v,o):(b.positions=u,b.minimumHeights=c,b.maximumHeights=h,b.granularity=v,new f(b))},f.fromConstantHeights=function(e){e=i(e,i.EMPTY_OBJECT);var t,r,o=e.positions,a=e.minimumHeight,s=e.maximumHeight,l=n(a),u=n(s);if(l||u){var c=o.length;t=l?new Array(c):void 0,r=u?new Array(c):void 0;for(var h=0;c>h;++h)l&&(t[h]=a),u&&(r[h]=s)}var d={positions:o,maximumHeights:r,minimumHeights:t,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat};return new f(d)},f.createGeometry=function(i){var o=i._positions,a=i._minimumHeights,p=i._maximumHeights,f=i._vertexFormat,T=i._granularity,x=i._ellipsoid,b=m.computePositions(x,o,p,a,T,!0);if(n(b)){var P=b.bottomPositions,A=b.topPositions,I=A.length,M=2*I,D=f.position?new Float64Array(M):void 0,R=f.normal?new Float32Array(M):void 0,O=f.tangent?new Float32Array(M):void 0,N=f.binormal?new Float32Array(M):void 0,L=f.st?new Float32Array(M/3*2):void 0,F=0,B=0,V=0,z=0,k=0,U=w,G=S,W=E,H=!0;I/=3;var q,j=0,Y=1/(I-o.length+1);for(q=0;I>q;++q){var X=3*q,Z=t.fromArray(A,X,v),K=t.fromArray(P,X,_);if(f.position&&(D[F++]=K.x,D[F++]=K.y,D[F++]=K.z,D[F++]=Z.x,D[F++]=Z.y,D[F++]=Z.z),f.st&&(L[k++]=j,L[k++]=0,L[k++]=j,L[k++]=1),f.normal||f.tangent||f.binormal){var Q,J=t.clone(t.ZERO,C),$=x.scaleToGeodeticSurface(t.fromArray(A,X,_),_);if(I>q+1&&(Q=x.scaleToGeodeticSurface(t.fromArray(A,X+3,g),g),J=t.fromArray(A,X+3,C)),H){var ee=t.subtract(J,Z,y),te=t.subtract($,Z,v);U=t.normalize(t.cross(te,ee,U),U),H=!1}t.equalsEpsilon(Q,$,h.EPSILON10)?H=!0:(j+=Y,f.tangent&&(G=t.normalize(t.subtract(Q,$,G),G)),f.binormal&&(W=t.normalize(t.cross(U,G,W),W))),f.normal&&(R[B++]=U.x,R[B++]=U.y,R[B++]=U.z,R[B++]=U.x,R[B++]=U.y,R[B++]=U.z),f.tangent&&(O[z++]=G.x,O[z++]=G.y,O[z++]=G.z,O[z++]=G.x,O[z++]=G.y,O[z++]=G.z),f.binormal&&(N[V++]=W.x,N[V++]=W.y,N[V++]=W.z,N[V++]=W.x,N[V++]=W.y,N[V++]=W.z)}}var re=new u;f.position&&(re.position=new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:D})),f.normal&&(re.normal=new l({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:R})),f.tangent&&(re.tangent=new l({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:O})),f.binormal&&(re.binormal=new l({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:N})),f.st&&(re.st=new l({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:L}));var ie=M/3;M-=6;var ne=c.createTypedArray(ie,M),oe=0;for(q=0;ie-2>q;q+=2){var ae=q,se=q+2,le=t.fromArray(D,3*ae,v),ue=t.fromArray(D,3*se,_);if(!t.equalsEpsilon(le,ue,h.EPSILON10)){var ce=q+1,he=q+3;ne[oe++]=ce,ne[oe++]=ae,ne[oe++]=he,ne[oe++]=he,ne[oe++]=ae,ne[oe++]=se}}return new s({attributes:re,indices:ne,primitiveType:d.TRIANGLES,boundingSphere:new e.fromVertices(D)})}},f}),r("Core/WallOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,o=e.maximumHeights,s=e.minimumHeights,l=i(e.granularity,h.RADIANS_PER_DEGREE),u=i(e.ellipsoid,a.WGS84);this._positions=r,this._minimumHeights=s,this._maximumHeights=o,this._granularity=l,this._ellipsoid=a.clone(u),this._workerName="createWallOutlineGeometry";var c=1+r.length*t.packedLength+2;n(s)&&(c+=s.length),n(o)&&(c+=o.length),this.packedLength=c+a.packedLength+1}var f=new t,v=new t;m.pack=function(e,r,o){o=i(o,0);var s,l=e._positions,u=l.length;for(r[o++]=u,s=0;u>s;++s,o+=t.packedLength)t.pack(l[s],r,o);var c=e._minimumHeights;if(u=n(c)?c.length:0,r[o++]=u,n(c))for(s=0;u>s;++s)r[o++]=c[s];var h=e._maximumHeights;if(u=n(h)?h.length:0,r[o++]=u,n(h))for(s=0;u>s;++s)r[o++]=h[s];a.pack(e._ellipsoid,r,o),o+=a.packedLength,r[o]=e._granularity};var _=a.clone(a.UNIT_SPHERE),g={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:_,granularity:void 0};return m.unpack=function(e,r,o){r=i(r,0);var s,l=e[r++],u=new Array(l);for(s=0;l>s;++s,r+=t.packedLength)u[s]=t.unpack(e,r);l=e[r++];var c;if(l>0)for(c=new Array(l),s=0;l>s;++s)c[s]=e[r++];l=e[r++];var h;if(l>0)for(h=new Array(l),s=0;l>s;++s)h[s]=e[r++];var d=a.unpack(e,r,_);r+=a.packedLength;var p=e[r];return n(o)?(o._positions=u,o._minimumHeights=c,o._maximumHeights=h,o._ellipsoid=a.clone(d,o._ellipsoid),o._granularity=p,o):(g.positions=u,g.minimumHeights=c,g.maximumHeights=h,g.granularity=p,new m(g))},m.fromConstantHeights=function(e){e=i(e,i.EMPTY_OBJECT);var t,r,o=e.positions,a=e.minimumHeight,s=e.maximumHeight,l=n(a),u=n(s);if(l||u){var c=o.length;t=l?new Array(c):void 0,r=u?new Array(c):void 0;for(var h=0;c>h;++h)l&&(t[h]=a),u&&(r[h]=s)}var d={positions:o,maximumHeights:r,minimumHeights:t,ellipsoid:e.ellipsoid};return new m(d)},m.createGeometry=function(i){var o=i._positions,a=i._minimumHeights,m=i._maximumHeights,_=i._granularity,g=i._ellipsoid,y=p.computePositions(g,o,m,a,_,!1);if(n(y)){var C=y.bottomPositions,E=y.topPositions,S=E.length,w=2*S,T=new Float64Array(w),x=0;S/=3;var b;for(b=0;S>b;++b){var P=3*b,A=t.fromArray(E,P,f),I=t.fromArray(C,P,v);T[x++]=I.x,T[x++]=I.y,T[x++]=I.z,T[x++]=A.x,T[x++]=A.y,T[x++]=A.z}var M=new u({position:new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:T})}),D=w/3;w=2*D-4+D;var R=c.createTypedArray(D,w),O=0;for(b=0;D-2>b;b+=2){var N=b,L=b+2,F=t.fromArray(T,3*N,f),B=t.fromArray(T,3*L,v);if(!t.equalsEpsilon(F,B,h.EPSILON10)){var V=b+1,z=b+3;R[O++]=V,R[O++]=N,R[O++]=V,R[O++]=z,R[O++]=N,R[O++]=L}}return R[O++]=D-2,R[O++]=D-1,new s({attributes:M,indices:R,primitiveType:d.LINES,boundingSphere:new e.fromVertices(T)})}},m}),r("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return n(l.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),l.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},l.geodeticLatitudeToMercatorAngle=function(e){e>l.MaximumLatitude?e=l.MaximumLatitude:e<-l.MaximumLatitude&&(e=-l.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},l.MaximumLatitude=l.mercatorAngleToGeodeticLatitude(Math.PI),l.prototype.project=function(t,r){var n=this._semimajorAxis,o=t.longitude*n,a=l.geodeticLatitudeToMercatorAngle(t.latitude)*n,s=t.height;return i(r)?(r.x=o,r.y=a,r.z=s,r):new e(o,a,s)},l.prototype.unproject=function(e,r){var n=this._oneOverSemimajorAxis,o=e.x*n,a=l.mercatorAngleToGeodeticLatitude(e.y*n),s=e.z;return i(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new t(o,a,s)},l}),r("Core/WebMercatorTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Rectangle","./WebMercatorProjection"],function(e,t,r,i,n,o,a){"use strict";function s(i){if(i=t(i,{}),this._ellipsoid=t(i.ellipsoid,n.WGS84),this._numberOfLevelZeroTilesX=t(i.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=t(i.numberOfLevelZeroTilesY,1),this._projection=new a(this._ellipsoid),r(i.rectangleSouthwestInMeters)&&r(i.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=i.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=i.rectangleNortheastInMeters;else{var s=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new e(-s,-s),this._rectangleNortheastInMeters=new e(s,s)}var l=this._projection.unproject(this._rectangleSouthwestInMeters),u=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new o(l.longitude,l.latitude,u.longitude,u.latitude)}return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),s.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},s.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},s.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,n=i.project(o.southwest(e)),a=i.project(o.northeast(e));return r(t)?(t.west=n.x,t.south=n.y,t.east=a.x,t.north=a.y,t):new o(n.x,n.y,a.x,a.y)},s.prototype.tileXYToNativeRectangle=function(e,t,i,n){var a=this.getNumberOfXTilesAtLevel(i),s=this.getNumberOfYTilesAtLevel(i),l=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/a,u=this._rectangleSouthwestInMeters.x+e*l,c=this._rectangleSouthwestInMeters.x+(e+1)*l,h=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/s,d=this._rectangleNortheastInMeters.y-t*h,p=this._rectangleNortheastInMeters.y-(t+1)*h;
return r(n)?(n.west=u,n.south=p,n.east=c,n.north=d,n):new o(u,p,c,d)},s.prototype.tileXYToRectangle=function(t,r,i,n){var o=this.tileXYToNativeRectangle(t,r,i,n),a=this._projection,s=a.unproject(new e(o.west,o.south)),l=a.unproject(new e(o.east,o.north));return o.west=s.longitude,o.south=s.latitude,o.east=l.longitude,o.north=l.latitude,o},s.prototype.positionToTileXY=function(t,i,n){var a=this._rectangle;if(o.contains(a,t)){var s=this.getNumberOfXTilesAtLevel(i),l=this.getNumberOfYTilesAtLevel(i),u=this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x,c=u/s,h=this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y,d=h/l,p=this._projection,m=p.project(t),f=m.x-this._rectangleSouthwestInMeters.x,v=this._rectangleNortheastInMeters.y-m.y,_=f/c|0;_>=s&&(_=s-1);var g=v/d|0;return g>=l&&(g=l-1),r(n)?(n.x=_,n.y=g,n):new e(_,g)}},s}),r("Core/wrapFunction",["./DeveloperError"],function(e){"use strict";function t(e,t,r){return function(){r.apply(e,arguments),t.apply(e,arguments)}}return t}),r("DataSources/ConstantProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,r,i,n){"use strict";function o(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new n,this.setValue(e)}return r(o.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),o.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},o.prototype.setValue=function(e){var r=this._value;if(r!==e){var i=t(e),n=i&&"function"==typeof e.clone,o=i&&"function"==typeof e.equals;this._hasClone=n,this._hasEquals=o;var a=!o||!e.equals(r);a&&(this._value=n?e.clone():e,this._definitionChanged.raiseEvent(this))}},o.prototype.equals=function(e){return this===e||e instanceof o&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},o}),r("DataSources/createPropertyDescriptor",["../Core/defaultValue","../Core/defined","./ConstantProperty"],function(e,t,r){"use strict";function i(e,r,i,n,o){return{configurable:n,get:function(){return this[r]},set:function(n){var a=this[r],s=this[i];t(s)&&(s(),this[i]=void 0);var l=t(n);l&&!t(n.getValue)&&t(o)&&(n=o(n)),a!==n&&(this[r]=n,this._definitionChanged.raiseEvent(this,e,n,a)),t(n)&&t(n.definitionChanged)&&(this[i]=n.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,e,n,n)},this))}}}function n(e){return new r(e)}function o(t,r,o){return i(t,"_"+t.toString(),"_"+t.toString()+"Subscription",e(r,!1),e(o,n))}return o}),r("DataSources/BillboardGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";function a(t){this._image=void 0,this._imageSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),imageSubRegion:o("imageSubRegion"),scale:o("scale"),rotation:o("rotation"),alignedAxis:o("alignedAxis"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),color:o("color"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),show:o("show"),width:o("width"),height:o("height"),scaleByDistance:o("scaleByDistance"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance"),sizeInMeters:o("sizeInMeters")}),a.prototype.clone=function(e){return t(e)?(e.color=this._color,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.image=this._image,e.imageSubRegion=this._imageSubRegion,e.pixelOffset=this._pixelOffset,e.scale=this._scale,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.show=this._show,e.verticalOrigin=this._verticalOrigin,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.sizeInMeters=this._sizeInMeters,e):new a(this)},a.prototype.merge=function(t){this.color=e(this._color,t.color),this.eyeOffset=e(this._eyeOffset,t.eyeOffset),this.horizontalOrigin=e(this._horizontalOrigin,t.horizontalOrigin),this.image=e(this._image,t.image),this.imageSubRegion=e(this._imageSubRegion,t.imageSubRegion),this.pixelOffset=e(this._pixelOffset,t.pixelOffset),this.scale=e(this._scale,t.scale),this.rotation=e(this._rotation,t.rotation),this.alignedAxis=e(this._alignedAxis,t.alignedAxis),this.show=e(this._show,t.show),this.verticalOrigin=e(this._verticalOrigin,t.verticalOrigin),this.width=e(this._width,t.width),this.height=e(this._height,t.height),this.scaleByDistance=e(this._scaleByDistance,t.scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,t.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,t.pixelOffsetScaleByDistance),this.sizeInMeters=e(this._sizeInMeters,t.sizeInMeters)},a}),r("Renderer/BufferUsage",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={STREAM_DRAW:t.STREAM_DRAW,STATIC_DRAW:t.STATIC_DRAW,DYNAMIC_DRAW:t.DYNAMIC_DRAW,validate:function(e){return e===r.STREAM_DRAW||e===r.STATIC_DRAW||e===r.DYNAMIC_DRAW}};return e(r)}),r("Renderer/Buffer",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/IndexDatatype","./BufferUsage","./WebGLConstants"],function(e,t,r,i,n,o,a,s){"use strict";function l(r){r=e(r,e.EMPTY_OBJECT);var i=r.context._gl,n=r.bufferTarget,o=r.typedArray,a=r.sizeInBytes,s=r.usage,l=t(o);l&&(a=o.byteLength);var u=i.createBuffer();i.bindBuffer(n,u),i.bufferData(n,l?o:a,s),i.bindBuffer(n,null),this._gl=i,this._bufferTarget=n,this._sizeInBytes=a,this._usage=s,this._buffer=u,this.vertexArrayDestroyable=!0}return l.createVertexBuffer=function(e){return new l({context:e.context,bufferTarget:s.ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage})},l.createIndexBuffer=function(e){var t=e.context,i=e.indexDatatype,n=o.getSizeInBytes(i),a=new l({context:t,bufferTarget:s.ELEMENT_ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage}),u=a.sizeInBytes/n;return r(a,{indexDatatype:{get:function(){return i}},bytesPerIndex:{get:function(){return n}},numberOfIndices:{get:function(){return u}}}),a},r(l.prototype,{sizeInBytes:{get:function(){return this._sizeInBytes}},usage:{get:function(){return this._usage}}}),l.prototype._getBuffer=function(){return this._buffer},l.prototype.copyFromArrayView=function(t,r){r=e(r,0);var i=this._gl,n=this._bufferTarget;i.bindBuffer(n,this._buffer),i.bufferSubData(n,r,t),i.bindBuffer(n,null)},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),i(this)},l}),r("Renderer/DrawCommand",["../Core/defaultValue","../Core/PrimitiveType"],function(e,t){"use strict";function r(r){r=e(r,e.EMPTY_OBJECT),this.boundingVolume=r.boundingVolume,this.orientedBoundingBox=r.orientedBoundingBox,this.cull=e(r.cull,!0),this.modelMatrix=r.modelMatrix,this.primitiveType=e(r.primitiveType,t.TRIANGLES),this.vertexArray=r.vertexArray,this.count=r.count,this.offset=e(r.offset,0),this.instanceCount=e(r.instanceCount,0),this.shaderProgram=r.shaderProgram,this.uniformMap=r.uniformMap,this.renderState=r.renderState,this.framebuffer=r.framebuffer,this.pass=r.pass,this.executeInClosestFrustum=e(r.executeInClosestFrustum,!1),this.owner=r.owner,this.debugShowBoundingVolume=e(r.debugShowBoundingVolume,!1),this.debugOverlappingFrustums=0,this.oit=void 0}return r.prototype.execute=function(e,t,r,i){e.draw(this,t,r,i)},r}),r("Renderer/ContextLimits",["../Core/defineProperties"],function(e){"use strict";var t={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};return e(t,{maximumCombinedTextureImageUnits:{get:function(){return t._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return t._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return t._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return t._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return t._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return t._maximumTextureSize}},maximumVaryingVectors:{get:function(){return t._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return t._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return t._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return t._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return t._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return t._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return t._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return t._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return t._maximumViewportWidth}},maximumViewportHeight:{get:function(){return t._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return t._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return t._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return t._maximumColorAttachments}},highpFloatSupported:{get:function(){return t._highpFloatSupported}},highpIntSupported:{get:function(){return t._highpIntSupported}}}),t}),r("Renderer/RenderState",["../Core/BoundingRectangle","../Core/Color","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/RuntimeError","../Core/WindingOrder","./ContextLimits","./WebGLConstants"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(n){var o=r(n,{}),s=r(o.cull,{}),u=r(o.polygonOffset,{}),c=r(o.scissorTest,{}),h=r(c.rectangle,{}),d=r(o.depthRange,{}),p=r(o.depthTest,{}),m=r(o.colorMask,{}),f=r(o.blending,{}),v=r(f.color,{}),_=r(o.stencilTest,{}),g=r(_.frontOperation,{}),y=r(_.backOperation,{}),C=r(o.sampleCoverage,{}),E=o.viewport;this.frontFace=r(o.frontFace,a.COUNTER_CLOCKWISE),this.cull={enabled:r(s.enabled,!1),face:r(s.face,l.BACK)},this.lineWidth=r(o.lineWidth,1),this.polygonOffset={enabled:r(u.enabled,!1),factor:r(u.factor,0),units:r(u.units,0)},this.scissorTest={enabled:r(c.enabled,!1),rectangle:e.clone(h)},this.depthRange={near:r(d.near,0),far:r(d.far,1)},this.depthTest={enabled:r(p.enabled,!1),func:r(p.func,l.LESS)},this.colorMask={red:r(m.red,!0),green:r(m.green,!0),blue:r(m.blue,!0),alpha:r(m.alpha,!0)},this.depthMask=r(o.depthMask,!0),this.stencilMask=r(o.stencilMask,-1),this.blending={enabled:r(f.enabled,!1),color:new t(r(v.red,0),r(v.green,0),r(v.blue,0),r(v.alpha,0)),equationRgb:r(f.equationRgb,l.FUNC_ADD),equationAlpha:r(f.equationAlpha,l.FUNC_ADD),functionSourceRgb:r(f.functionSourceRgb,l.ONE),functionSourceAlpha:r(f.functionSourceAlpha,l.ONE),functionDestinationRgb:r(f.functionDestinationRgb,l.ZERO),functionDestinationAlpha:r(f.functionDestinationAlpha,l.ZERO)},this.stencilTest={enabled:r(_.enabled,!1),frontFunction:r(_.frontFunction,l.ALWAYS),backFunction:r(_.backFunction,l.ALWAYS),reference:r(_.reference,0),mask:r(_.mask,-1),frontOperation:{fail:r(g.fail,l.KEEP),zFail:r(g.zFail,l.KEEP),zPass:r(g.zPass,l.KEEP)},backOperation:{fail:r(y.fail,l.KEEP),zFail:r(y.zFail,l.KEEP),zPass:r(y.zPass,l.KEEP)}},this.sampleCoverage={enabled:r(C.enabled,!1),value:r(C.value,1),invert:r(C.invert,!1)},this.viewport=i(E)?new e(E.x,E.y,E.width,E.height):void 0,this.id=0,this._applyFunctions=[]}function c(e,t,r){r?e.enable(t):e.disable(t)}function h(e,t){e.frontFace(t.frontFace)}function d(e,t){var r=t.cull,i=r.enabled;c(e,e.CULL_FACE,i),i&&e.cullFace(r.face)}function p(e,t){e.lineWidth(t.lineWidth)}function m(e,t){var r=t.polygonOffset,i=r.enabled;c(e,e.POLYGON_OFFSET_FILL,i),i&&e.polygonOffset(r.factor,r.units)}function f(e,t,r){var n=t.scissorTest,o=i(r.scissorTest)?r.scissorTest.enabled:n.enabled;if(c(e,e.SCISSOR_TEST,o),o){var a=i(r.scissorTest)?r.scissorTest.rectangle:n.rectangle;e.scissor(a.x,a.y,a.width,a.height)}}function v(e,t){var r=t.depthRange;e.depthRange(r.near,r.far)}function _(e,t){var r=t.depthTest,i=r.enabled;c(e,e.DEPTH_TEST,i),i&&e.depthFunc(r.func)}function g(e,t){var r=t.colorMask;e.colorMask(r.red,r.green,r.blue,r.alpha)}function y(e,t){e.depthMask(t.depthMask)}function C(e,t){e.stencilMask(t.stencilMask)}function E(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function S(e,t,r){var n=t.blending,o=i(r.blendingEnabled)?r.blendingEnabled:n.enabled;c(e,e.BLEND,o),o&&(E(e,n.color),e.blendEquationSeparate(n.equationRgb,n.equationAlpha),e.blendFuncSeparate(n.functionSourceRgb,n.functionDestinationRgb,n.functionSourceAlpha,n.functionDestinationAlpha))}function w(e,t){var r=t.stencilTest,i=r.enabled;if(c(e,e.STENCIL_TEST,i),i){var n=r.frontFunction,o=r.backFunction,a=r.reference,s=r.mask;e.stencilFunc(r.frontFunction,r.reference,r.mask),e.stencilFuncSeparate(e.BACK,o,a,s),e.stencilFuncSeparate(e.FRONT,n,a,s);var l=r.frontOperation,u=l.fail,h=l.zFail,d=l.zPass;e.stencilOpSeparate(e.FRONT,u,h,d);var p=r.backOperation,m=p.fail,f=p.zFail,v=p.zPass;e.stencilOpSeparate(e.BACK,m,f,v)}}function T(e,t){var r=t.sampleCoverage,i=r.enabled;c(e,e.SAMPLE_COVERAGE,i),i&&e.sampleCoverage(r.value,r.invert)}function x(e,t,n){var o=r(t.viewport,n.viewport);i(o)||(o=I,o.width=n.context.drawingBufferWidth,o.height=n.context.drawingBufferHeight),n.context.uniformState.viewport=o,e.viewport(o.x,o.y,o.width,o.height)}function b(e,t){var r=[];return e.frontFace!==t.frontFace&&r.push(h),(e.cull.enabled!==t.cull.enabled||e.cull.face!==t.cull.face)&&r.push(d),e.lineWidth!==t.lineWidth&&r.push(p),(e.polygonOffset.enabled!==t.polygonOffset.enabled||e.polygonOffset.factor!==t.polygonOffset.factor||e.polygonOffset.units!==t.polygonOffset.units)&&r.push(m),(e.depthRange.near!==t.depthRange.near||e.depthRange.far!==t.depthRange.far)&&r.push(v),(e.depthTest.enabled!==t.depthTest.enabled||e.depthTest.func!==t.depthTest.func)&&r.push(_),(e.colorMask.red!==t.colorMask.red||e.colorMask.green!==t.colorMask.green||e.colorMask.blue!==t.colorMask.blue||e.colorMask.alpha!==t.colorMask.alpha)&&r.push(g),e.depthMask!==t.depthMask&&r.push(y),e.stencilMask!==t.stencilMask&&r.push(C),(e.stencilTest.enabled!==t.stencilTest.enabled||e.stencilTest.frontFunction!==t.stencilTest.frontFunction||e.stencilTest.backFunction!==t.stencilTest.backFunction||e.stencilTest.reference!==t.stencilTest.reference||e.stencilTest.mask!==t.stencilTest.mask||e.stencilTest.frontOperation.fail!==t.stencilTest.frontOperation.fail||e.stencilTest.frontOperation.zFail!==t.stencilTest.frontOperation.zFail||e.stencilTest.backOperation.fail!==t.stencilTest.backOperation.fail||e.stencilTest.backOperation.zFail!==t.stencilTest.backOperation.zFail||e.stencilTest.backOperation.zPass!==t.stencilTest.backOperation.zPass)&&r.push(w),(e.sampleCoverage.enabled!==t.sampleCoverage.enabled||e.sampleCoverage.value!==t.sampleCoverage.value||e.sampleCoverage.invert!==t.sampleCoverage.invert)&&r.push(T),r}var P=0,A={};u.fromCache=function(e){var t=JSON.stringify(e),r=A[t];if(i(r))return++r.referenceCount,r.state;var n=new u(e),o=JSON.stringify(n);return r=A[o],i(r)||(n.id=P++,r={referenceCount:0,state:n},A[o]=r),++r.referenceCount,A[t]={referenceCount:1,state:r.state},r.state},u.removeFromCache=function(e){var t=new u(e),r=JSON.stringify(t),n=A[r],o=JSON.stringify(e),a=A[o];i(a)&&(--a.referenceCount,0===a.referenceCount&&(delete A[o],i(n)&&--n.referenceCount)),i(n)&&0===n.referenceCount&&delete A[r]},u.getCache=function(){return A},u.clearCache=function(){A={}};var I=new e;return u.apply=function(e,t,r){h(e,t),d(e,t),p(e,t),m(e,t),v(e,t),_(e,t),g(e,t),y(e,t),C(e,t),w(e,t),T(e,t),f(e,t,r),S(e,t,r),x(e,t,r)},u.partialApply=function(e,t,r,n,o,a){if(t!==r){var s=r._applyFunctions[t.id];i(s)||(s=b(t,r),r._applyFunctions[t.id]=s);for(var l=s.length,u=0;l>u;++u)s[u](e,r)}var c=i(n.scissorTest)?n.scissorTest:t.scissorTest,h=i(o.scissorTest)?o.scissorTest:r.scissorTest;(c!==h||a)&&f(e,r,o);var d=i(n.blendingEnabled)?n.blendingEnabled:t.blending.enabled,p=i(o.blendingEnabled)?o.blendingEnabled:r.blending.enabled;(d!==p||p&&t.blending!==r.blending)&&S(e,r,o),(t!==r||n.context!==o.context)&&x(e,r,o)},u.getState=function(r){return{frontFace:r.frontFace,cull:{enabled:r.cull.enabled,face:r.cull.face},lineWidth:r.lineWidth,polygonOffset:{enabled:r.polygonOffset.enabled,factor:r.polygonOffset.factor,units:r.polygonOffset.units},scissorTest:{enabled:r.scissorTest.enabled,rectangle:e.clone(r.scissorTest.rectangle)},depthRange:{near:r.depthRange.near,far:r.depthRange.far},depthTest:{enabled:r.depthTest.enabled,func:r.depthTest.func},colorMask:{red:r.colorMask.red,green:r.colorMask.green,blue:r.colorMask.blue,alpha:r.colorMask.alpha},depthMask:r.depthMask,stencilMask:r.stencilMask,blending:{enabled:r.blending.enabled,color:t.clone(r.blending.color),equationRgb:r.blending.equationRgb,equationAlpha:r.blending.equationAlpha,functionSourceRgb:r.blending.functionSourceRgb,functionSourceAlpha:r.blending.functionSourceAlpha,functionDestinationRgb:r.blending.functionDestinationRgb,functionDestinationAlpha:r.blending.functionDestinationAlpha},stencilTest:{enabled:r.stencilTest.enabled,frontFunction:r.stencilTest.frontFunction,backFunction:r.stencilTest.backFunction,reference:r.stencilTest.reference,mask:r.stencilTest.mask,frontOperation:{fail:r.stencilTest.frontOperation.fail,zFail:r.stencilTest.frontOperation.zFail,zPass:r.stencilTest.frontOperation.zPass},backOperation:{fail:r.stencilTest.backOperation.fail,zFail:r.stencilTest.backOperation.zFail,zPass:r.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:r.sampleCoverage.enabled,value:r.sampleCoverage.value,invert:r.sampleCoverage.invert},viewport:i(r.viewport)?e.clone(r.viewport):void 0}},u}),r("Renderer/AutomaticUniforms",["../Core/Cartesian3","../Core/Matrix4","./WebGLConstants"],function(e,t,r){"use strict";function i(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var n=new e;if("undefined"==typeof WebGLRenderingContext)return{};var o={};o[r.FLOAT]="float",o[r.FLOAT_VEC2]="vec2",o[r.FLOAT_VEC3]="vec3",o[r.FLOAT_VEC4]="vec4",o[r.INT]="int",o[r.INT_VEC2]="ivec2",o[r.INT_VEC3]="ivec3",o[r.INT_VEC4]="ivec4",o[r.BOOL]="bool",o[r.BOOL_VEC2]="bvec2",o[r.BOOL_VEC3]="bvec3",o[r.BOOL_VEC4]="bvec4",o[r.FLOAT_MAT2]="mat2",o[r.FLOAT_MAT3]="mat3",o[r.FLOAT_MAT4]="mat4",o[r.SAMPLER_2D]="sampler2D",o[r.SAMPLER_CUBE]="samplerCube",i.prototype.getDeclaration=function(e){var t="uniform "+o[this._datatype]+" "+e,r=this._size;return t+=1===r?";":"["+r.toString()+"];"};var a={czm_viewport:new i({size:1,datatype:r.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new i({size:1,datatype:r.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_inverseProjectionOIT:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseProjectionOIT}}),czm_infiniteProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new i({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_normal:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight2D:new i({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new i({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new i({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new i({size:1,datatype:r.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_sunPositionWC:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_encodedCameraPositionMCHigh:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new i({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return t.getTranslation(e.inverseView,n)}}),czm_frameNumber:new i({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new i({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new i({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_temeToPseudoFixed:new i({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_resolutionScale:new i({size:1,datatype:r.FLOAT,getValue:function(e){return e.resolutionScale}}),czm_fogDensity:new i({size:1,datatype:r.FLOAT,getValue:function(e){return e.fogDensity}})};return a}),r("Renderer/createUniform",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/defined","../Core/DeveloperError","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/RuntimeError"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e,t,r,i){switch(t.type){case e.FLOAT:return new h(e,t,r,i);case e.FLOAT_VEC2:return new d(e,t,r,i);case e.FLOAT_VEC3:return new p(e,t,r,i);case e.FLOAT_VEC4:return new m(e,t,r,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new f(e,t,r,i);case e.INT:case e.BOOL:return new v(e,t,r,i);case e.INT_VEC2:case e.BOOL_VEC2:return new _(e,t,r,i);case e.INT_VEC3:case e.BOOL_VEC3:return new g(e,t,r,i);case e.INT_VEC4:case e.BOOL_VEC4:return new y(e,t,r,i);case e.FLOAT_MAT2:return new C(e,t,r,i);case e.FLOAT_MAT3:return new E(e,t,r,i);case e.FLOAT_MAT4:return new S(e,t,r,i);default:throw new u("Unrecognized uniform type: "+t.type+' for uniform "'+r+'".')}}function h(e,t,r,i){this.name=r,this.value=void 0,this._value=0,this._gl=e,this._location=i}function d(t,r,i,n){this.name=i,this.value=void 0,this._value=new e,this._gl=t,this._location=n}function p(e,t,r,i){this.name=r,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}function m(e,t,r,i){this.name=r,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}function f(e,t,r,i){this.name=r,this.value=void 0,this._gl=e,this._location=i,this.textureUnitIndex=void 0}function v(e,t,r,i){this.name=r,this.value=void 0,this._value=0,this._gl=e,this._location=i}function _(t,r,i,n){this.name=i,this.value=void 0,this._value=new e,this._gl=t,this._location=n}function g(e,r,i,n){this.name=i,this.value=void 0,this._value=new t,this._gl=e,this._location=n}function y(e,t,i,n){this.name=i,this.value=void 0,this._value=new r,this._gl=e,this._location=n}function C(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(4),this._gl=e,this._location=i}function E(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(9),this._gl=e,this._location=i}function S(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(16),this._gl=e,this._location=i}return h.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))},d.prototype.set=function(){var t=this.value;e.equals(t,this._value)||(e.clone(t,this._value),this._gl.uniform2f(this._location,t.x,t.y))},p.prototype.set=function(){var e=this.value;if(n(e.red))i.equals(e,this._value)||(this._value=i.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue));else{if(!n(e.x))throw new o('Invalid vec3 value for uniform "'+this._activethis.name+'".');t.equals(e,this._value)||(this._value=t.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z))}},m.prototype.set=function(){var e=this.value;if(n(e.red))i.equals(e,this._value)||(this._value=i.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha));else{if(!n(e.x))throw new o('Invalid vec4 value for uniform "'+this._activethis.name+'".');r.equals(e,this._value)||(this._value=r.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w))}},f.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var t=this.value;e.bindTexture(t._target,t._texture)},f.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1},v.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))},_.prototype.set=function(){var t=this.value;e.equals(t,this._value)||(e.clone(t,this._value),this._gl.uniform2i(this._location,t.x,t.y))},g.prototype.set=function(){var e=this.value;t.equals(e,this._value)||(t.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))},y.prototype.set=function(){var e=this.value;r.equals(e,this._value)||(r.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))},C.prototype.set=function(){a.equalsArray(this.value,this._value,0)||(a.toArray(this.value,this._value),this._gl.uniformMatrix2fv(this._location,!1,this._value))},E.prototype.set=function(){s.equalsArray(this.value,this._value,0)||(s.toArray(this.value,this._value),this._gl.uniformMatrix3fv(this._location,!1,this._value))},S.prototype.set=function(){l.equalsArray(this.value,this._value,0)||(l.toArray(this.value,this._value),this._gl.uniformMatrix4fv(this._location,!1,this._value))},c}),r("Renderer/createUniformArray",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/RuntimeError"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e,t,r,i){switch(t.type){case e.FLOAT:return new d(e,t,r,i);case e.FLOAT_VEC2:return new p(e,t,r,i);case e.FLOAT_VEC3:return new m(e,t,r,i);case e.FLOAT_VEC4:return new f(e,t,r,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new v(e,t,r,i);case e.INT:case e.BOOL:return new _(e,t,r,i);case e.INT_VEC2:case e.BOOL_VEC2:return new g(e,t,r,i);case e.INT_VEC3:case e.BOOL_VEC3:return new y(e,t,r,i);case e.INT_VEC4:case e.BOOL_VEC4:return new C(e,t,r,i);case e.FLOAT_MAT2:return new E(e,t,r,i);case e.FLOAT_MAT3:return new S(e,t,r,i);case e.FLOAT_MAT4:return new w(e,t,r,i);default:throw new c("Unrecognized uniform type: "+t.type+' for uniform "'+r+'".')}}function d(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._location=i[0]}function p(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(2*n),this._gl=e,this._location=i[0]}function m(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(3*n),this._gl=e,this._location=i[0]}function f(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=i[0]}function v(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._locations=i,this.textureUnitIndex=void 0}function _(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(n),this._gl=e,this._location=i[0]}function g(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(2*n),this._gl=e,this._location=i[0];
}function y(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(3*n),this._gl=e,this._location=i[0]}function C(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(4*n),this._gl=e,this._location=i[0]}function E(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=i[0]}function S(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(9*n),this._gl=e,this._location=i[0]}function w(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(16*n),this._gl=e,this._location=i[0]}return d.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0;t>n;++n){var o=e[n];o!==r[n]&&(r[n]=o,i=!0)}i&&this._gl.uniform1fv(this._location,r)},p.prototype.set=function(){for(var t=this.value,r=t.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=t[a];e.equalsArray(s,i,o)||(e.pack(s,i,o),n=!0),o+=2}n&&this._gl.uniform2fv(this._location,i)},m.prototype.set=function(){for(var e=this.value,r=e.length,i=this._value,o=!1,s=0,l=0;r>l;++l){var u=e[l];if(n(u.red))(u.red!==i[s]||u.green!==i[s+1]||u.blue!==i[s+2])&&(i[s]=u.red,i[s+1]=u.green,i[s+2]=u.blue,o=!0);else{if(!n(u.x))throw new a("Invalid vec3 value.");t.equalsArray(u,i,s)||(t.pack(u,i,s),o=!0)}s+=3}o&&this._gl.uniform3fv(this._location,i)},f.prototype.set=function(){for(var e=this.value,t=e.length,o=this._value,s=!1,l=0,u=0;t>u;++u){var c=e[u];if(n(c.red))i.equalsArray(c,o,l)||(i.pack(c,o,l),s=!0);else{if(!n(c.x))throw new a("Invalid vec4 value.");r.equalsArray(c,o,l)||(r.pack(c,o,l),s=!0)}l+=4}s&&this._gl.uniform4fv(this._location,o)},v.prototype.set=function(){for(var e=this._gl,t=e.TEXTURE0+this.textureUnitIndex,r=this.value,i=r.length,n=0;i>n;++n){var o=r[n];e.activeTexture(t+n),e.bindTexture(o._target,o._texture)}},v.prototype._setSampler=function(e){this.textureUnitIndex=e;for(var t=this._locations,r=t.length,i=0;r>i;++i){var n=e+i;this._gl.uniform1i(t[i],n)}return e+r},_.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0;t>n;++n){var o=e[n];o!==r[n]&&(r[n]=o,i=!0)}i&&this._gl.uniform1iv(this._location,r)},g.prototype.set=function(){for(var t=this.value,r=t.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=t[a];e.equalsArray(s,i,o)||(e.pack(s,i,o),n=!0),o+=2}n&&this._gl.uniform2iv(this._location,i)},y.prototype.set=function(){for(var e=this.value,r=e.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=e[a];t.equalsArray(s,i,o)||(t.pack(s,i,o),n=!0),o+=3}n&&this._gl.uniform3iv(this._location,i)},C.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,n=!1,o=0,a=0;t>a;++a){var s=e[a];r.equalsArray(s,i,o)||(r.pack(s,i,o),n=!0),o+=4}n&&this._gl.uniform4iv(this._location,i)},E.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];s.equalsArray(a,r,n)||(s.pack(a,r,n),i=!0),n+=4}i&&this._gl.uniformMatrix2fv(this._location,!1,r)},S.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];l.equalsArray(a,r,n)||(l.pack(a,r,n),i=!0),n+=9}i&&this._gl.uniformMatrix3fv(this._location,!1,r)},w.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];u.equalsArray(a,r,n)||(u.pack(a,r,n),i=!0),n+=16}i&&this._gl.uniformMatrix4fv(this._location,!1,r)},h}),r("Renderer/ShaderProgram",["../Core/defaultValue","../Core/defined","../Core/definedNotNull","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/RuntimeError","./AutomaticUniforms","./ContextLimits","./createUniform","./createUniformArray"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e){var t=p(e.vertexShaderText,e.fragmentShaderText);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=t.duplicateUniformNames,this._cachedShader=void 0,this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=t.fragmentShaderText,this.id=C++}function d(e){var t=[],i=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(r(i))for(var n=i.length,o=0;n>o;o++){var a=i[o].trim(),s=a.slice(a.lastIndexOf(" ")+1);t.push(s)}return t}function p(e,t){var r={};if(!l.highpFloatSupported||!l.highpIntSupported){var i,n,o,a,s=d(e),u=d(t),c=s.length,h=u.length;for(i=0;c>i;i++)for(n=0;h>n;n++)if(s[i]===u[n]){o=s[i],a="czm_mediump_"+o;var p=new RegExp(o+"\\b","g");t=t.replace(p,a),r[a]=o}}return{fragmentShaderText:t,duplicateUniformNames:r}}function m(e,r){var i=r._vertexShaderText,n=r._fragmentShaderText,o=e.createShader(e.VERTEX_SHADER);e.shaderSource(o,i),e.compileShader(o);var s=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(s,n),e.compileShader(s);var l=e.createProgram();e.attachShader(l,o),e.attachShader(l,s),e.deleteShader(o),e.deleteShader(s);var u=r._attributeLocations;if(t(u))for(var c in u)u.hasOwnProperty(c)&&e.bindAttribLocation(l,u[c],c);e.linkProgram(l);var h;if(!e.getProgramParameter(l,e.LINK_STATUS)){var d=r._debugShaders;if(!e.getShaderParameter(s,e.COMPILE_STATUS)){if(h=e.getShaderInfoLog(s),console.error(E+"Fragment shader compile log: "+h),t(d)){var p=d.getTranslatedShaderSource(s);""!==p?console.error(E+"Translated fragment shader source:\n"+p):console.error(E+"Fragment shader translation failed.")}throw e.deleteProgram(l),new a("Fragment shader failed to compile.  Compile log: "+h)}if(!e.getShaderParameter(o,e.COMPILE_STATUS)){if(h=e.getShaderInfoLog(o),console.error(E+"Vertex shader compile log: "+h),t(d)){var m=d.getTranslatedShaderSource(o);""!==m?console.error(E+"Translated vertex shader source:\n"+m):console.error(E+"Vertex shader translation failed.")}throw e.deleteProgram(l),new a("Vertex shader failed to compile.  Compile log: "+h)}throw h=e.getProgramInfoLog(l),console.error(E+"Shader program link log: "+h),t(d)&&(console.error(E+"Translated vertex shader source:\n"+d.getTranslatedShaderSource(o)),console.error(E+"Translated fragment shader source:\n"+d.getTranslatedShaderSource(s))),e.deleteProgram(l),new a("Program failed to link.  Link log: "+h)}var f=r._logShaderCompilation;return f&&(h=e.getShaderInfoLog(o),t(h)&&h.length>0&&console.log(E+"Vertex shader compile log: "+h)),f&&(h=e.getShaderInfoLog(s),t(h)&&h.length>0&&console.log(E+"Fragment shader compile log: "+h)),f&&(h=e.getProgramInfoLog(l),t(h)&&h.length>0&&console.log(E+"Shader program link log: "+h)),l}function f(e,t,r){for(var i={},n=0;r>n;++n){var o=e.getActiveAttrib(t,n),a=e.getAttribLocation(t,o.name);i[o.name]={name:o.name,type:o.type,index:a}}return i}function v(e,r){for(var i={},n=[],o=[],a=e.getProgramParameter(r,e.ACTIVE_UNIFORMS),s=0;a>s;++s){var l=e.getActiveUniform(r,s),h="[0]",d=-1!==l.name.indexOf(h,l.name.length-h.length)?l.name.slice(0,l.name.length-3):l.name;if(0!==d.indexOf("gl_"))if(l.name.indexOf("[")<0){var p=e.getUniformLocation(r,d);if(null!==p){var m=u(e,l,d,p);i[d]=m,n.push(m),m._setSampler&&o.push(m)}}else{var f,v,_,g,y=d.indexOf("[");if(y>=0){if(f=i[d.slice(0,y)],!t(f))continue;v=f._locations,v.length<=1&&(_=f.value,g=e.getUniformLocation(r,d),null!==g&&(v.push(g),_.push(e.getUniform(r,g))))}else{v=[];for(var C=0;C<l.size;++C)g=e.getUniformLocation(r,d+"["+C+"]"),null!==g&&v.push(g);f=c(e,l,d,v),i[d]=f,n.push(f),f._setSampler&&o.push(f)}}}return{uniformsByName:i,uniforms:n,samplerUniforms:o}}function _(e,r){var i=[],n=[];for(var o in r)if(r.hasOwnProperty(o)){var a=r[o],l=o,u=e._duplicateUniformNames[l];t(u)&&(a.name=u,l=u);var c=s[l];t(c)?i.push({uniform:a,automaticUniform:c}):n.push(a)}return{automaticUniforms:i,manualUniforms:n}}function g(e,t,r){e.useProgram(t);for(var i=0,n=r.length,o=0;n>o;++o)i=r[o]._setSampler(i);return e.useProgram(null),i}function y(e){if(!t(e._program)){var r=e._gl,i=m(r,e,e._debugShaders),n=r.getProgramParameter(i,r.ACTIVE_ATTRIBUTES),o=v(r,i),a=_(e,o.uniformsByName);e._program=i,e._numberOfVertexAttributes=n,e._vertexAttributes=f(r,i,n),e._uniformsByName=o.uniformsByName,e._uniforms=o.uniforms,e._automaticUniforms=a.automaticUniforms,e._manualUniforms=a.manualUniforms,e.maximumTextureUnitIndex=g(r,i,o.samplerUniforms)}}var C=0;h.fromCache=function(t){return t=e(t,e.EMPTY_OBJECT),t.context.shaderCache.getShaderProgram(t)},h.replaceCache=function(t){return t=e(t,e.EMPTY_OBJECT),t.context.shaderCache.replaceShaderProgram(t)},i(h.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return y(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return y(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return y(this),this._uniformsByName}}});var E="[Cesium WebGL] ";return h.prototype._bind=function(){y(this),this._gl.useProgram(this._program)},h.prototype._setUniforms=function(e,r,i){var n,a;if(t(e)){var s=this._manualUniforms;for(n=s.length,a=0;n>a;++a){var l=s[a];l.value=e[l.name]()}}var u=this._automaticUniforms;for(n=u.length,a=0;n>a;++a){var c=u[a];c.uniform.value=c.automaticUniform.getValue(r)}var h=this._uniforms;for(n=h.length,a=0;n>a;++a)h[a].set();if(i){var d=this._gl,p=this._program;if(d.validateProgram(p),!d.getProgramParameter(p,d.VALIDATE_STATUS))throw new o("Program validation failed.  Program info log: "+d.getProgramInfoLog(p))}},h.prototype.isDestroyed=function(){return!1},h.prototype.destroy=function(){this._cachedShader.cache.releaseShaderProgram(this)},h.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),n(this)},h}),r("Shaders/Builtin/Constants/degreesPerRadian",[],function(){"use strict";return"const float czm_degreesPerRadian = 57.29577951308232;\n"}),r("Shaders/Builtin/Constants/depthRange",[],function(){"use strict";return"const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);\n"}),r("Shaders/Builtin/Constants/epsilon1",[],function(){"use strict";return"const float czm_epsilon1 = 0.1;\n"}),r("Shaders/Builtin/Constants/epsilon2",[],function(){"use strict";return"const float czm_epsilon2 = 0.01;\n"}),r("Shaders/Builtin/Constants/epsilon3",[],function(){"use strict";return"const float czm_epsilon3 = 0.001;\n"}),r("Shaders/Builtin/Constants/epsilon4",[],function(){"use strict";return"const float czm_epsilon4 = 0.0001;\n"}),r("Shaders/Builtin/Constants/epsilon5",[],function(){"use strict";return"const float czm_epsilon5 = 0.00001;\n"}),r("Shaders/Builtin/Constants/epsilon6",[],function(){"use strict";return"const float czm_epsilon6 = 0.000001;\n"}),r("Shaders/Builtin/Constants/epsilon7",[],function(){"use strict";return"const float czm_epsilon7 = 0.0000001;\n"}),r("Shaders/Builtin/Constants/infinity",[],function(){"use strict";return"const float czm_infinity = 5906376272000.0;\n"}),r("Shaders/Builtin/Constants/oneOverPi",[],function(){"use strict";return"const float czm_oneOverPi = 0.3183098861837907;\n"}),r("Shaders/Builtin/Constants/oneOverTwoPi",[],function(){"use strict";return"const float czm_oneOverTwoPi = 0.15915494309189535;\n"}),r("Shaders/Builtin/Constants/pi",[],function(){"use strict";return"const float czm_pi = 3.141592653589793;\n"}),r("Shaders/Builtin/Constants/piOverFour",[],function(){"use strict";return"const float czm_piOverFour = 0.7853981633974483;\n"}),r("Shaders/Builtin/Constants/piOverSix",[],function(){"use strict";return"const float czm_piOverSix = 0.5235987755982988;\n"}),r("Shaders/Builtin/Constants/piOverThree",[],function(){"use strict";return"const float czm_piOverThree = 1.0471975511965976;\n"}),r("Shaders/Builtin/Constants/piOverTwo",[],function(){"use strict";return"const float czm_piOverTwo = 1.5707963267948966;\n"}),r("Shaders/Builtin/Constants/radiansPerDegree",[],function(){"use strict";return"const float czm_radiansPerDegree = 0.017453292519943295;\n"}),r("Shaders/Builtin/Constants/sceneMode2D",[],function(){"use strict";return"const float czm_sceneMode2D = 2.0;\n"}),r("Shaders/Builtin/Constants/sceneMode3D",[],function(){"use strict";return"const float czm_sceneMode3D = 3.0;\n"}),r("Shaders/Builtin/Constants/sceneModeColumbusView",[],function(){"use strict";return"const float czm_sceneModeColumbusView = 1.0;\n"}),r("Shaders/Builtin/Constants/sceneModeMorphing",[],function(){"use strict";return"const float czm_sceneModeMorphing = 0.0;\n"}),r("Shaders/Builtin/Constants/solarRadius",[],function(){"use strict";return"const float czm_solarRadius = 695500000.0;\n"}),r("Shaders/Builtin/Constants/threePiOver2",[],function(){"use strict";return"const float czm_threePiOver2 = 4.71238898038469;\n"}),r("Shaders/Builtin/Constants/twoPi",[],function(){"use strict";return"const float czm_twoPi = 6.283185307179586;\n"}),r("Shaders/Builtin/Constants/webMercatorMaxLatitude",[],function(){"use strict";return"const float czm_webMercatorMaxLatitude = 1.4844222297453324;\n"}),r("Shaders/Builtin/Structs/depthRangeStruct",[],function(){"use strict";return"struct czm_depthRangeStruct\n{\nfloat near;\nfloat far;\n};\n"}),r("Shaders/Builtin/Structs/ellipsoid",[],function(){"use strict";return"struct czm_ellipsoid\n{\nvec3 center;\nvec3 radii;\nvec3 inverseRadii;\nvec3 inverseRadiiSquared;\n};\n"}),r("Shaders/Builtin/Structs/material",[],function(){"use strict";return"struct czm_material\n{\nvec3 diffuse;\nfloat specular;\nfloat shininess;\nvec3 normal;\nvec3 emission;\nfloat alpha;\n};\n"}),r("Shaders/Builtin/Structs/materialInput",[],function(){"use strict";return"struct czm_materialInput\n{\nfloat s;\nvec2 st;\nvec3 str;\nvec3 normalEC;\nmat3 tangentToEyeMatrix;\nvec3 positionToEyeEC;\n};\n"}),r("Shaders/Builtin/Structs/ray",[],function(){"use strict";return"struct czm_ray\n{\nvec3 origin;\nvec3 direction;\n};\n"}),r("Shaders/Builtin/Structs/raySegment",[],function(){"use strict";return"struct czm_raySegment\n{\nfloat start;\nfloat stop;\n};\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n"}),r("Shaders/Builtin/Functions/alphaWeight",[],function(){"use strict";return"float czm_alphaWeight(float a)\n{\nfloat z;\nif (czm_sceneMode != czm_sceneMode2D)\n{\nfloat x = 2.0 * (gl_FragCoord.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (gl_FragCoord.y - czm_viewport.y) / czm_viewport.w - 1.0;\nz = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 0.0);\nq /= gl_FragCoord.w;\nz = (czm_inverseProjectionOIT * q).z;\n}\nelse\n{\nz = gl_FragCoord.z * (czm_currentFrustum.y - czm_currentFrustum.x) + czm_currentFrustum.x;\n}\nreturn pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 100.0 / (1e-5 + pow(abs(z) / 10.0, 3.0) + pow(abs(z) / 200.0, 6.0))));\n}\n"}),r("Shaders/Builtin/Functions/antialias",[],function(){"use strict";return"vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\nfloat val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\nfloat val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\nval1 = val1 * (1.0 - val2);\nval1 = val1 * val1 * (3.0 - (2.0 * val1));\nval1 = pow(val1, 0.5);\nvec4 midColor = (color1 + color2) * 0.5;\nreturn mix(midColor, currentColor, val1);\n}\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\nreturn czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n"}),r("Shaders/Builtin/Functions/columbusViewMorph",[],function(){"use strict";return"vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\nvec3 p = mix(position2D.xyz, position3D.xyz, time);\nreturn vec4(p, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/computePosition",[],function(){"use strict";return"vec4 czm_computePosition();\n"}),r("Shaders/Builtin/Functions/cosineAndSine",[],function(){"use strict";return"vec2 cordic(float angle)\n{\nvec2 vector = vec2(6.0725293500888267e-1, 0.0);\nfloat sense = (angle < 0.0) ? -1.0 : 1.0;\nmat2 rotation = mat2(1.0, sense, -sense, 1.0);\nvector = rotation * vector;\nangle -= sense * 7.8539816339744828e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfloat factor = sense * 5.0e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.6364760900080609e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.5e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4497866312686414e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.25e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2435499454676144e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.25e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.2418809995957350e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.125e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.1239833430268277e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.5625e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5623728620476831e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.8125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.8123410601011111e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.90625e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.9062301319669718e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.953125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9531225164788188e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.765625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.7656218955931946e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.8828125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.8828121119489829e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.44140625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4414062014936177e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.220703125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2207031189367021e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.103515625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.1035156174208773e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.0517578125e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.0517578115526096e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.52587890625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5258789061315762e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.62939453125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.6293945311019700e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.814697265625e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.8146972656064961e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.9073486328125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9073486328101870e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.5367431640625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.5367431640596084e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.76837158203125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.7683715820308884e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.384185791015625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.3841857910155797e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.1920928955078125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nreturn vector;\n}\nvec2 czm_cosineAndSine(float angle)\n{\nif (angle < -czm_piOverTwo || angle > czm_piOverTwo)\n{\nif (angle < 0.0)\n{\nreturn -cordic(angle + czm_pi);\n}\nelse\n{\nreturn -cordic(angle - czm_pi);\n}\n}\nelse\n{\nreturn cordic(angle);\n}\n}\n"}),r("Shaders/Builtin/Functions/decompressTextureCoordinates",[],function(){"use strict";return"vec2 czm_decompressTextureCoordinates(float encoded)\n{\nfloat temp = encoded / 4096.0;\nfloat stx = floor(temp) / 4096.0;\nfloat sty = temp - floor(temp);\nreturn vec2(stx, sty);\n}\n"}),r("Shaders/Builtin/Functions/eastNorthUpToEyeCoordinates",[],function(){"use strict";return"mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\nvec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));\nvec3 tangentEC = normalize(czm_normal3D * tangentMC);\nvec3 bitangentEC = normalize(cross(normalEC, tangentEC));\nreturn mat3(\ntangentEC.x,   tangentEC.y,   tangentEC.z,\nbitangentEC.x, bitangentEC.y, bitangentEC.z,\nnormalEC.x,    normalEC.y,    normalEC.z);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidContainsPoint",[],function(){"use strict";return"bool czm_ellipsoidContainsPoint(czm_ellipsoid ellipsoid, vec3 point)\n{\nvec3 scaled = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\nreturn (dot(scaled, scaled) <= 1.0);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidNew",[],function(){"use strict";return"czm_ellipsoid czm_ellipsoidNew(vec3 center, vec3 radii)\n{\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(center, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidWgs84TextureCoordinates",[],function(){"use strict";return"vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\nreturn vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n"}),r("Shaders/Builtin/Functions/equalsEpsilon",[],function(){"use strict";return"bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\nreturn (abs(left - right) <= epsilon);\n}\n"}),r("Shaders/Builtin/Functions/eyeOffset",[],function(){"use strict";return"vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\nvec4 p = positionEC;\nvec4 zEyeOffset = normalize(p) * eyeOffset.z;\np.xy += eyeOffset.xy + zEyeOffset.xy;\np.z += zEyeOffset.z;\nreturn p;\n}\n"}),r("Shaders/Builtin/Functions/eyeToWindowCoordinates",[],function(){"use strict";return"vec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\nvec4 q = czm_projection * positionEC;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/fog",[],function(){"use strict";return"vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor)\n{\nfloat scalar = distanceToCamera * czm_fogDensity;\nfloat fog = 1.0 - exp(-(scalar * scalar));\nreturn mix(color, fogColor, fog);\n}\n"}),r("Shaders/Builtin/Functions/geodeticSurfaceNormal",[],function(){"use strict";return"vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\nreturn normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n"}),r("Shaders/Builtin/Functions/getDefaultMaterial",[],function(){"use strict";return"czm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\nczm_material material;\nmaterial.diffuse = vec3(0.0);\nmaterial.specular = 0.0;\nmaterial.shininess = 1.0;\nmaterial.normal = materialInput.normalEC;\nmaterial.emission = vec3(0.0);\nmaterial.alpha = 1.0;\nreturn material;\n}\n"}),r("Shaders/Builtin/Functions/getLambertDiffuse",[],function(){"use strict";return"float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\nreturn max(dot(lightDirectionEC, normalEC), 0.0);\n}\n"}),r("Shaders/Builtin/Functions/getSpecular",[],function(){"use strict";return"float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\nvec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\nfloat specular = max(dot(toReflectedLight, toEyeEC), 0.0);\nreturn pow(specular, shininess);\n}\n"}),r("Shaders/Builtin/Functions/getWaterNoise",[],function(){"use strict";return"vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\nfloat cosAngle = cos(angleInRadians);\nfloat sinAngle = sin(angleInRadians);\nvec2 s0 = vec2(1.0/17.0, 0.0);\nvec2 s1 = vec2(-1.0/29.0, 0.0);\nvec2 s2 = vec2(1.0/101.0, 1.0/59.0);\nvec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\ns0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\ns1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\ns2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\ns3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\nvec2 uv0 = (uv/103.0) + (time * s0);\nvec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\nvec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\nvec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\nuv0 = fract(uv0);\nuv1 = fract(uv1);\nuv2 = fract(uv2);\nuv3 = fract(uv3);\nvec4 noise = (texture2D(normalMap, uv0)) +\n(texture2D(normalMap, uv1)) +\n(texture2D(normalMap, uv2)) +\n(texture2D(normalMap, uv3));\nreturn ((noise / 4.0) - 0.5) * 2.0;\n}\n"}),r("Shaders/Builtin/Functions/getWgs84EllipsoidEC",[],function(){"use strict";return"czm_ellipsoid czm_getWgs84EllipsoidEC()\n{\nvec3 radii = vec3(6378137.0, 6378137.0, 6356752.314245);\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(czm_view[3].xyz, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/hue",[],function(){"use strict";return"vec3 czm_hue(vec3 rgb, float adjustment)\n{\nconst mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n0.595716, -0.274453, -0.321263,\n0.211456, -0.522591,  0.311135);\nconst mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n1.0, -0.2721, -0.6474,\n1.0, -1.107,   1.7046);\nvec3 yiq = toYIQ * rgb;\nfloat hue = atan(yiq.z, yiq.y) + adjustment;\nfloat chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\nvec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\nreturn toRGB * color;\n}\n"}),r("Shaders/Builtin/Functions/isEmpty",[],function(){"use strict";return"bool czm_isEmpty(czm_raySegment interval)\n{\nreturn (interval.stop < 0.0);\n}\n"}),r("Shaders/Builtin/Functions/isFull",[],function(){"use strict";return"bool czm_isFull(czm_raySegment interval)\n{\nreturn (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n"}),r("Shaders/Builtin/Functions/latitudeToWebMercatorFraction",[],function(){"use strict";return"float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)\n{\nfloat sinLatitude = sin(latitude);\nfloat mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\nreturn (mercatorY - southMercatorY) * oneOverMercatorHeight;\n}\n"}),r("Shaders/Builtin/Functions/luminance",[],function(){"use strict";return"float czm_luminance(vec3 rgb)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nreturn dot(rgb, W);\n}\n"}),r("Shaders/Builtin/Functions/metersPerPixel",[],function(){"use strict";return"float czm_metersPerPixel(vec4 positionEC)\n{\nfloat width = czm_viewport.z;\nfloat height = czm_viewport.w;\nfloat pixelWidth;\nfloat pixelHeight;\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nfloat frustumWidth = right - left;\nfloat frustumHeight = top - bottom;\npixelWidth = frustumWidth / width;\npixelHeight = frustumHeight / height;\n}\nelse\n{\nfloat distanceToPixel = -positionEC.z;\nfloat inverseNear = 1.0 / czm_currentFrustum.x;\nfloat tanTheta = top * inverseNear;\npixelHeight = 2.0 * distanceToPixel * tanTheta / height;\ntanTheta = right * inverseNear;\npixelWidth = 2.0 * distanceToPixel * tanTheta / width;\n}\nreturn max(pixelWidth, pixelHeight);\n}\n"}),r("Shaders/Builtin/Functions/modelToWindowCoordinates",[],function(){"use strict";return"vec4 czm_modelToWindowCoordinates(vec4 position)\n{\nvec4 q = czm_modelViewProjection * position;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/multiplyWithColorBalance",[],function(){"use strict";return"vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 target = left * right;\nfloat leftLuminance = dot(left, W);\nfloat rightLuminance = dot(right, W);\nfloat targetLuminance = dot(target, W);\nreturn ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n"}),r("Shaders/Builtin/Functions/nearFarScalar",[],function(){"use strict";return"float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\nfloat valueAtMin = nearFarScalar.y;\nfloat valueAtMax = nearFarScalar.w;\nfloat nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\nfloat farDistanceSq = nearFarScalar.z * nearFarScalar.z;\nfloat t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\nt = pow(clamp(t, 0.0, 1.0), 0.2);\nreturn mix(valueAtMin, valueAtMax, t);\n}\n"}),r("Shaders/Builtin/Functions/octDecode",[],function(){"use strict";return"vec3 czm_octDecode(vec2 encoded)\n{\nencoded = encoded / 255.0 * 2.0 - 1.0;\nvec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));\nif (v.z < 0.0)\n{\nv.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);\n}\nreturn normalize(v);\n}\nvec3 czm_octDecode(float encoded)\n{\nfloat temp = encoded / 256.0;\nfloat x = floor(temp);\nfloat y = (temp - x) * 256.0;\nreturn czm_octDecode(vec2(x, y));\n}\nvoid czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)\n{\nfloat temp = encoded.x / 65536.0;\nfloat x = floor(temp);\nfloat encodedFloat1 = (temp - x) * 65536.0;\ntemp = encoded.y / 65536.0;\nfloat y = floor(temp);\nfloat encodedFloat2 = (temp - y) * 65536.0;\nvector1 = czm_octDecode(encodedFloat1);\nvector2 = czm_octDecode(encodedFloat2);\nvector3 = czm_octDecode(vec2(x, y));\n}\n"}),r("Shaders/Builtin/Functions/packDepth",[],function(){"use strict";return"vec4 czm_packDepth(float depth)\n{\nvec4 enc = vec4(1.0, 255.0, 65025.0, 160581375.0) * depth;\nenc = fract(enc);\nenc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);\nreturn enc;\n}\n"}),r("Shaders/Builtin/Functions/phong",[],function(){"use strict";return"float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\nreturn czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\nreturn czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\nvec4 czm_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\n}\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material) + czm_private_getSpecularOfMaterial(czm_moonDirectionEC, toEye, material);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\nvec4 czm_private_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n";
}),r("Shaders/Builtin/Functions/pointAlongRay",[],function(){"use strict";return"vec3 czm_pointAlongRay(czm_ray ray, float time)\n{\nreturn ray.origin + (time * ray.direction);\n}\n"}),r("Shaders/Builtin/Functions/rayEllipsoidIntersectionInterval",[],function(){"use strict";return"czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, czm_ellipsoid ellipsoid)\n{\nvec3 q = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\nvec3 w = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\nq = q - ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ellipsoid.center, 1.0)).xyz;\nfloat q2 = dot(q, q);\nfloat qw = dot(q, w);\nif (q2 > 1.0)\n{\nif (qw >= 0.0)\n{\nreturn czm_emptyRaySegment;\n}\nelse\n{\nfloat qw2 = qw * qw;\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nif (qw2 < product)\n{\nreturn czm_emptyRaySegment;\n}\nelse if (qw2 > product)\n{\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nfloat root0 = temp / w2;\nfloat root1 = difference / temp;\nif (root0 < root1)\n{\nczm_raySegment i = czm_raySegment(root0, root1);\nreturn i;\n}\nelse\n{\nczm_raySegment i = czm_raySegment(root1, root0);\nreturn i;\n}\n}\nelse\n{\nfloat root = sqrt(difference / w2);\nczm_raySegment i = czm_raySegment(root, root);\nreturn i;\n}\n}\n}\nelse if (q2 < 1.0)\n{\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nczm_raySegment i = czm_raySegment(0.0, temp / w2);\nreturn i;\n}\nelse\n{\nif (qw < 0.0)\n{\nfloat w2 = dot(w, w);\nczm_raySegment i = czm_raySegment(0.0, -qw / w2);\nreturn i;\n}\nelse\n{\nreturn czm_emptyRaySegment;\n}\n}\n}\n"}),r("Shaders/Builtin/Functions/RGBToXYZ",[],function(){"use strict";return"vec3 czm_RGBToXYZ(vec3 rgb)\n{\nconst mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n0.3576, 0.7152, 0.1192,\n0.1805, 0.0722, 0.9505);\nvec3 xyz = RGB2XYZ * rgb;\nvec3 Yxy;\nYxy.r = xyz.g;\nfloat temp = dot(vec3(1.0), xyz);\nYxy.gb = xyz.rg / temp;\nreturn Yxy;\n}\n"}),r("Shaders/Builtin/Functions/saturation",[],function(){"use strict";return"vec3 czm_saturation(vec3 rgb, float adjustment)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 intensity = vec3(dot(rgb, W));\nreturn mix(intensity, rgb, adjustment);\n}\n"}),r("Shaders/Builtin/Functions/signNotZero",[],function(){"use strict";return"float czm_signNotZero(float value)\n{\nreturn value >= 0.0 ? 1.0 : -1.0;\n}\nvec2 czm_signNotZero(vec2 value)\n{\nreturn vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));\n}\nvec3 czm_signNotZero(vec3 value)\n{\nreturn vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));\n}\nvec4 czm_signNotZero(vec4 value)\n{\nreturn vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));\n}\n"}),r("Shaders/Builtin/Functions/tangentToEyeSpaceMatrix",[],function(){"use strict";return"mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 binormalEC)\n{\nvec3 normal = normalize(normalEC);\nvec3 tangent = normalize(tangentEC);\nvec3 binormal = normalize(binormalEC);\nreturn mat3(tangent.x,  tangent.y,  tangent.z,\nbinormal.x, binormal.y, binormal.z,\nnormal.x,   normal.y,   normal.z);\n}\n"}),r("Shaders/Builtin/Functions/translateRelativeToEye",[],function(){"use strict";return"vec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\nvec3 highDifference = high - czm_encodedCameraPositionMCHigh;\nvec3 lowDifference = low - czm_encodedCameraPositionMCLow;\nreturn vec4(highDifference + lowDifference, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/translucentPhong",[],function(){"use strict";return"vec4 czm_translucentPhong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);\n}\ndiffuse = clamp(diffuse, 0.0, 1.0);\nfloat specular = czm_getSpecular(czm_sunDirectionEC, toEye, material.normal, material.shininess);\nspecular += czm_getSpecular(czm_moonDirectionEC, toEye, material.normal, material.shininess);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n"}),r("Shaders/Builtin/Functions/transpose",[],function(){"use strict";return"mat2 czm_transpose(mat2 matrix)\n{\nreturn mat2(\nmatrix[0][0], matrix[1][0],\nmatrix[0][1], matrix[1][1]);\n}\nmat3 czm_transpose(mat3 matrix)\n{\nreturn mat3(\nmatrix[0][0], matrix[1][0], matrix[2][0],\nmatrix[0][1], matrix[1][1], matrix[2][1],\nmatrix[0][2], matrix[1][2], matrix[2][2]);\n}\nmat4 czm_transpose(mat4 matrix)\n{\nreturn mat4(\nmatrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\nmatrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\nmatrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\nmatrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n"}),r("Shaders/Builtin/Functions/unpackDepth",[],function(){"use strict";return"float czm_unpackDepth(vec4 packedDepth)\n{\nreturn dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 160581375.0));\n}\n"}),r("Shaders/Builtin/Functions/windowToEyeCoordinates",[],function(){"use strict";return"vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\nfloat x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\nfloat z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 1.0);\nq /= fragmentCoordinate.w;\nq = czm_inverseProjection * q;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/XYZToRGB",[],function(){"use strict";return"vec3 czm_XYZToRGB(vec3 Yxy)\n{\nconst mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n-1.5371,  1.8760, -0.2040,\n-0.4985,  0.0416,  1.0572);\nvec3 xyz;\nxyz.r = Yxy.r * Yxy.g / Yxy.b;\nxyz.g = Yxy.r;\nxyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\nreturn XYZ2RGB * xyz;\n}\n"}),r("Shaders/Builtin/CzmBuiltins",["./Constants/degreesPerRadian","./Constants/depthRange","./Constants/epsilon1","./Constants/epsilon2","./Constants/epsilon3","./Constants/epsilon4","./Constants/epsilon5","./Constants/epsilon6","./Constants/epsilon7","./Constants/infinity","./Constants/oneOverPi","./Constants/oneOverTwoPi","./Constants/pi","./Constants/piOverFour","./Constants/piOverSix","./Constants/piOverThree","./Constants/piOverTwo","./Constants/radiansPerDegree","./Constants/sceneMode2D","./Constants/sceneMode3D","./Constants/sceneModeColumbusView","./Constants/sceneModeMorphing","./Constants/solarRadius","./Constants/threePiOver2","./Constants/twoPi","./Constants/webMercatorMaxLatitude","./Structs/depthRangeStruct","./Structs/ellipsoid","./Structs/material","./Structs/materialInput","./Structs/ray","./Structs/raySegment","./Functions/alphaWeight","./Functions/antialias","./Functions/columbusViewMorph","./Functions/computePosition","./Functions/cosineAndSine","./Functions/decompressTextureCoordinates","./Functions/eastNorthUpToEyeCoordinates","./Functions/ellipsoidContainsPoint","./Functions/ellipsoidNew","./Functions/ellipsoidWgs84TextureCoordinates","./Functions/equalsEpsilon","./Functions/eyeOffset","./Functions/eyeToWindowCoordinates","./Functions/fog","./Functions/geodeticSurfaceNormal","./Functions/getDefaultMaterial","./Functions/getLambertDiffuse","./Functions/getSpecular","./Functions/getWaterNoise","./Functions/getWgs84EllipsoidEC","./Functions/hue","./Functions/isEmpty","./Functions/isFull","./Functions/latitudeToWebMercatorFraction","./Functions/luminance","./Functions/metersPerPixel","./Functions/modelToWindowCoordinates","./Functions/multiplyWithColorBalance","./Functions/nearFarScalar","./Functions/octDecode","./Functions/packDepth","./Functions/phong","./Functions/pointAlongRay","./Functions/rayEllipsoidIntersectionInterval","./Functions/RGBToXYZ","./Functions/saturation","./Functions/signNotZero","./Functions/tangentToEyeSpaceMatrix","./Functions/translateRelativeToEye","./Functions/translucentPhong","./Functions/transpose","./Functions/unpackDepth","./Functions/windowToEyeCoordinates","./Functions/XYZToRGB"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I,M,D,R,O,N,L,F,B,V,z,k,U,G,W,H,q,j,Y,X,Z,K,Q,J,$,ee,te,re,ie,ne,oe,ae,se,le,ue,ce,he,de,pe,me,fe,ve,_e,ge,ye,Ce,Ee){"use strict";return{czm_degreesPerRadian:e,czm_depthRange:t,czm_epsilon1:r,czm_epsilon2:i,czm_epsilon3:n,czm_epsilon4:o,czm_epsilon5:a,czm_epsilon6:s,czm_epsilon7:l,czm_infinity:u,czm_oneOverPi:c,czm_oneOverTwoPi:h,czm_pi:d,czm_piOverFour:p,czm_piOverSix:m,czm_piOverThree:f,czm_piOverTwo:v,czm_radiansPerDegree:_,czm_sceneMode2D:g,czm_sceneMode3D:y,czm_sceneModeColumbusView:C,czm_sceneModeMorphing:E,czm_solarRadius:S,czm_threePiOver2:w,czm_twoPi:T,czm_webMercatorMaxLatitude:x,czm_depthRangeStruct:b,czm_ellipsoid:P,czm_material:A,czm_materialInput:I,czm_ray:M,czm_raySegment:D,czm_alphaWeight:R,czm_antialias:O,czm_columbusViewMorph:N,czm_computePosition:L,czm_cosineAndSine:F,czm_decompressTextureCoordinates:B,czm_eastNorthUpToEyeCoordinates:V,czm_ellipsoidContainsPoint:z,czm_ellipsoidNew:k,czm_ellipsoidWgs84TextureCoordinates:U,czm_equalsEpsilon:G,czm_eyeOffset:W,czm_eyeToWindowCoordinates:H,czm_fog:q,czm_geodeticSurfaceNormal:j,czm_getDefaultMaterial:Y,czm_getLambertDiffuse:X,czm_getSpecular:Z,czm_getWaterNoise:K,czm_getWgs84EllipsoidEC:Q,czm_hue:J,czm_isEmpty:$,czm_isFull:ee,czm_latitudeToWebMercatorFraction:te,czm_luminance:re,czm_metersPerPixel:ie,czm_modelToWindowCoordinates:ne,czm_multiplyWithColorBalance:oe,czm_nearFarScalar:ae,czm_octDecode:se,czm_packDepth:le,czm_phong:ue,czm_pointAlongRay:ce,czm_rayEllipsoidIntersectionInterval:he,czm_RGBToXYZ:de,czm_saturation:pe,czm_signNotZero:me,czm_tangentToEyeSpaceMatrix:fe,czm_translateRelativeToEye:ve,czm_translucentPhong:_e,czm_transpose:ge,czm_unpackDepth:ye,czm_windowToEyeCoordinates:Ce,czm_XYZToRGB:Ee}}),r("Renderer/ShaderSource",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Shaders/Builtin/CzmBuiltins","./AutomaticUniforms"],function(e,t,r,i,n){"use strict";function o(e){return e=e.replace(/\/\/.*/g,""),e.replace(/\/\*\*[\s\S]*?\*\//gm,function(e){for(var t=e.match(/\n/gm).length,r="",i=0;t>i;++i)r+="\n";return r})}function a(e,r,i){for(var n,a=0;a<i.length;++a)i[a].name===e&&(n=i[a]);return t(n)||(r=o(r),n={name:e,glslSource:r,dependsOn:[],requiredBy:[],evaluated:!1},i.push(n)),n}function s(e,r){if(!e.evaluated){e.evaluated=!0;var i=e.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);t(i)&&null!==i&&(i=i.filter(function(e,t){return i.indexOf(e)===t}),i.forEach(function(t){if(t!==e.name&&h._czmBuiltinsAndUniforms.hasOwnProperty(t)){var i=a(t,h._czmBuiltinsAndUniforms[t],r);e.dependsOn.push(i),i.requiredBy.push(e),s(i,r)}}))}}function l(e){for(var t=[],i=[];e.length>0;){var n=e.pop();i.push(n),0===n.requiredBy.length&&t.push(n)}for(;t.length>0;){var o=t.shift();e.push(o);for(var a=0;a<o.dependsOn.length;++a){var s=o.dependsOn[a],l=s.requiredBy.indexOf(o);s.requiredBy.splice(l,1),0===s.requiredBy.length&&t.push(s)}}for(var u=[],c=0;c<i.length;++c)0!==i[c].requiredBy.length&&u.push(i[c]);if(0!==u.length){var h="A circular dependency was found in the following built-in functions/structs/constants: \n";for(c=0;c<u.length;++c)h=h+u[c].name+"\n";throw new r(h)}}function u(e){var t=[],r=a("main",e,t);s(r,t),l(t);for(var i="",n=t.length-1;n>=0;--n)i=i+t[n].glslSource+"\n";return i.replace(r.glslSource,"")}function c(e,i){var n,a,s="",l=e.sources;if(t(l))for(n=0,a=l.length;a>n;++n)s+="\n#line 0\n"+l[n];s=o(s);var c;s=s.replace(/#version\s+(.*?)\n/gm,function(e,i){if(t(c)&&c!==i)throw new r("inconsistent versions found: "+c+" and "+i);return c=i,"\n"}),s=s.replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");var d=e.pickColorQualifier;t(d)&&(s=h.createPickFragmentShaderSource(s,d));var p="";t(c)&&(p="#version "+c),i&&(p+="#ifdef GL_FRAGMENT_PRECISION_HIGH\n    precision highp float;\n#else\n    precision mediump float;\n#endif\n\n");var m=e.defines;if(t(m))for(n=0,a=m.length;a>n;++n){var f=m[n];0!==f.length&&(p+="#define "+f+"\n")}return e.includeBuiltIns&&(p+=u(s)),p+="\n#line 0\n",p+=s}function h(r){r=e(r,e.EMPTY_OBJECT);var i=r.pickColorQualifier;this.defines=t(r.defines)?r.defines.slice(0):[],this.sources=t(r.sources)?r.sources.slice(0):[],this.pickColorQualifier=i,this.includeBuiltIns=e(r.includeBuiltIns,!0)}h.prototype.clone=function(){return new h({sources:this.sources,defines:this.defines,pickColorQuantifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})},h.replaceMain=function(e,t){return t="void "+t+"()",e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,t)},h.prototype.createCombinedVertexShader=function(){return c(this,!1)},h.prototype.createCombinedFragmentShader=function(){return c(this,!0)},h._czmBuiltinsAndUniforms={};for(var d in i)i.hasOwnProperty(d)&&(h._czmBuiltinsAndUniforms[d]=i[d]);for(var p in n)if(n.hasOwnProperty(p)){var m=n[p];"function"==typeof m.getDeclaration&&(h._czmBuiltinsAndUniforms[p]=m.getDeclaration(p))}return h.createPickVertexShaderSource=function(e){var t=h.replaceMain(e,"czm_old_main"),r="attribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}";return t+"\n"+r},h.createPickFragmentShaderSource=function(e,t){var r=h.replaceMain(e,"czm_old_main"),i=t+" vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    if (gl_FragColor.a == 0.0) { \n       discard; \n    } \n    gl_FragColor = czm_pickColor; \n}";return r+"\n"+i},h}),r("Renderer/VertexArray",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Geometry","../Core/IndexDatatype","../Core/Math","../Core/RuntimeError","./Buffer","./BufferUsage","./ContextLimits"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(i,n,o,a){var s=r(n.vertexBuffer),l=r(n.value),u=n.value?n.value.length:n.componentsPerAttribute,c={index:t(n.index,o),enabled:t(n.enabled,!0),vertexBuffer:n.vertexBuffer,value:l?n.value.slice(0):void 0,componentsPerAttribute:u,componentDatatype:t(n.componentDatatype,e.FLOAT),normalize:t(n.normalize,!1),offsetInBytes:t(n.offsetInBytes,0),strideInBytes:t(n.strideInBytes,0),instanceDivisor:t(n.instanceDivisor,0)};if(s)c.vertexAttrib=function(e){var t=this.index;e.bindBuffer(e.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),e.vertexAttribPointer(t,this.componentsPerAttribute,this.componentDatatype,this.normalize,this.strideInBytes,this.offsetInBytes),e.enableVertexAttribArray(t),this.instanceDivisor>0&&(a.glVertexAttribDivisor(t,this.instanceDivisor),a._vertexAttribDivisors[t]=this.instanceDivisor,a._previousDrawInstanced=!0)},c.disableVertexAttribArray=function(e){e.disableVertexAttribArray(this.index),this.instanceDivisor>0&&a.glVertexAttribDivisor(o,0)};else{switch(c.componentsPerAttribute){case 1:c.vertexAttrib=function(e){e.vertexAttrib1fv(this.index,this.value)};break;case 2:c.vertexAttrib=function(e){e.vertexAttrib2fv(this.index,this.value)};break;case 3:c.vertexAttrib=function(e){e.vertexAttrib3fv(this.index,this.value)};break;case 4:c.vertexAttrib=function(e){e.vertexAttrib4fv(this.index,this.value)}}c.disableVertexAttribArray=function(e){}}i.push(c)}function m(e,t,i){for(var n=0;n<t.length;++n){var o=t[n];o.enabled&&o.vertexAttrib(e)}r(i)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,i._getBuffer())}function f(i){i=t(i,t.EMPTY_OBJECT);var n,o=i.context,a=o._gl,s=i.attributes,l=i.indexBuffer,u=[],c=1,h=!1,d=s.length;for(n=0;d>n;++n)p(u,s[n],n,o);for(d=u.length,n=0;d>n;++n){var f=u[n];if(r(f.vertexBuffer)&&0===f.instanceDivisor){var v=f.strideInBytes||f.componentsPerAttribute*e.getSizeInBytes(f.componentDatatype);c=f.vertexBuffer.sizeInBytes/v;break}}for(n=0;d>n;++n)if(u[n].instanceDivisor>0){h=!0;break}var _;o.vertexArrayObject&&(_=o.glCreateVertexArray(),o.glBindVertexArray(_),m(a,u,l),o.glBindVertexArray(null)),this._numberOfVertices=c,this._hasInstancedAttributes=h,this._context=o,this._gl=a,this._vao=_,this._attributes=u,this._indexBuffer=l}function v(e){return e.values.length/e.componentsPerAttribute}function _(t){return e.getSizeInBytes(t.componentDatatype)*t.componentsPerAttribute}function g(t){var i,n,o,a=[];for(n in t)t.hasOwnProperty(n)&&r(t[n])&&r(t[n].values)&&(a.push(n),t[n].componentDatatype===e.DOUBLE&&(t[n].componentDatatype=e.FLOAT,t[n].values=e.createTypedArray(e.FLOAT,t[n].values)));var s,l=a.length;if(l>0)for(s=v(t[a[0]]),i=1;l>i;++i){var c=v(t[a[i]]);if(c!==s)throw new u("Each attribute list must have the same number of vertices.  Attribute "+a[i]+" has a different number of vertices ("+c.toString()+") than attribute "+a[0]+" ("+s.toString()+").")}a.sort(function(r,i){return e.getSizeInBytes(t[i].componentDatatype)-e.getSizeInBytes(t[r].componentDatatype)});var h=0,d={};for(i=0;l>i;++i)n=a[i],o=t[n],d[n]=h,h+=_(o);if(h>0){var p=e.getSizeInBytes(t[a[0]].componentDatatype),m=h%p;0!==m&&(h+=p-m);var f=s*h,g=new ArrayBuffer(f),y={};for(i=0;l>i;++i){n=a[i];var C=e.getSizeInBytes(t[n].componentDatatype);y[n]={pointer:e.createTypedArray(t[n].componentDatatype,g),index:d[n]/C,strideInComponentType:h/C}}for(i=0;s>i;++i)for(var E=0;l>E;++E){n=a[E],o=t[n];for(var S=o.values,w=y[n],T=w.pointer,x=o.componentsPerAttribute,b=0;x>b;++b)T[w.index+b]=S[i*x+b];w.index+=w.strideInComponentType}return{buffer:g,offsetsInBytes:d,vertexSizeInBytes:h}}}function y(e){var t=e._context,r=e._hasInstancedAttributes;if(r||t._previousDrawInstanced){t._previousDrawInstanced=r;var i,n=t._vertexAttribDivisors,o=e._attributes,a=d.maximumVertexAttributes;if(r){var s=o.length;for(i=0;s>i;++i){var l=o[i];if(l.enabled){var u=l.instanceDivisor,c=l.index;u!==n[c]&&(t.glVertexAttribDivisor(c,u),n[c]=u)}}}else for(i=0;a>i;++i)n[i]>0&&(t.glVertexAttribDivisor(i,0),n[i]=0)}}return f.fromGeometry=function(i){i=t(i,t.EMPTY_OBJECT);var n,o,u,d=i.context,p=t(i.geometry,t.EMPTY_OBJECT),m=t(i.bufferUsage,h.DYNAMIC_DRAW),v=t(i.attributeLocations,t.EMPTY_OBJECT),_=t(i.interleave,!1),y=i.vertexArrayAttributes,C=r(y)?y:[],E=p.attributes;if(_){var S=g(E);if(r(S)){u=c.createVertexBuffer({context:d,typedArray:S.buffer,usage:m});var w=S.offsetsInBytes,T=S.vertexSizeInBytes;for(n in E)E.hasOwnProperty(n)&&r(E[n])&&(o=E[n],r(o.values)?C.push({index:v[n],vertexBuffer:u,componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,offsetInBytes:w[n],strideInBytes:T}):C.push({index:v[n],value:o.value,componentDatatype:o.componentDatatype,normalize:o.normalize}))}}else for(n in E)if(E.hasOwnProperty(n)&&r(E[n])){o=E[n];var x=o.componentDatatype;x===e.DOUBLE&&(x=e.FLOAT),u=void 0,r(o.values)&&(u=c.createVertexBuffer({context:d,typedArray:e.createTypedArray(x,o.values),usage:m})),C.push({index:v[n],vertexBuffer:u,value:o.value,componentDatatype:x,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize})}var b,P=p.indices;return r(P)&&(b=a.computeNumberOfVertices(p)>=l.SIXTY_FOUR_KILOBYTES&&d.elementIndexUint?c.createIndexBuffer({context:d,typedArray:new Uint32Array(P),usage:m,indexDatatype:s.UNSIGNED_INT}):c.createIndexBuffer({context:d,typedArray:new Uint16Array(P),usage:m,indexDatatype:s.UNSIGNED_SHORT})),new f({context:d,attributes:C,indexBuffer:b})},i(f.prototype,{numberOfAttributes:{get:function(){return this._attributes.length}},numberOfVertices:{get:function(){return this._numberOfVertices}},indexBuffer:{get:function(){return this._indexBuffer}}}),f.prototype.getAttribute=function(e){return this._attributes[e]},f.prototype._bind=function(){r(this._vao)?(this._context.glBindVertexArray(this._vao),this._context.instancedArrays&&y(this)):m(this._gl,this._attributes,this._indexBuffer)},f.prototype._unBind=function(){if(r(this._vao))this._context.glBindVertexArray(null);else{for(var e=this._attributes,t=this._gl,i=0;i<e.length;++i){var n=e[i];n.enabled&&n.disableVertexAttribArray(t)}this._indexBuffer&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null)}},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){for(var e=this._attributes,t=0;t<e.length;++t){var i=e[t].vertexBuffer;r(i)&&!i.isDestroyed()&&i.vertexArrayDestroyable&&i.destroy()}var o=this._indexBuffer;return r(o)&&!o.isDestroyed()&&o.vertexArrayDestroyable&&o.destroy(),r(this._vao)&&this._context.glDeleteVertexArray(this._vao),n(this)},f}),r("Renderer/VertexArrayFacade",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./Buffer","./BufferUsage","./VertexArray"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(i,n,o,a){function s(t,r){return e.getSizeInBytes(r.componentDatatype)-e.getSizeInBytes(t.componentDatatype)}var l=u._verifyAttributes(n);o=t(o,0);for(var c,h,d=[],p={},m=l.length,f=0;m>f;++f){var v=l[f];v.vertexBuffer?d.push(v):(h=v.usage,c=p[h],r(c)||(c=p[h]=[]),c.push(v))}this._allBuffers=[];for(h in p)if(p.hasOwnProperty(h)){c=p[h],c.sort(s);var _=u._vertexSizeInBytes(c),g=c[0].usage,y={vertexSizeInBytes:_,vertexBuffer:void 0,usage:g,needsCommit:!1,arrayBuffer:void 0,arrayViews:u._createArrayViews(c,_)};this._allBuffers.push(y)}this._size=0,this._instanced=t(a,!1),this._precreated=d,this._context=i,this.writers=void 0,this.va=void 0,this.resize(o)}function c(e,t){if(t.needsCommit&&t.vertexSizeInBytes>0){t.needsCommit=!1;var i=t.vertexBuffer,n=e._size*t.vertexSizeInBytes,o=r(i);if(!o||i.sizeInBytes<n)return o&&i.destroy(),t.vertexBuffer=a.createVertexBuffer({context:e._context,typedArray:t.arrayBuffer,usage:t.usage}),t.vertexBuffer.vertexArrayDestroyable=!1,!0;t.vertexBuffer.copyFromArrayView(t.arrayBuffer)}return!1}function h(e,t,r){if(e.needsCommit&&e.vertexSizeInBytes>0){var i=e.vertexSizeInBytes*t,n=e.vertexSizeInBytes*r;e.vertexBuffer.copyFromArrayView(new Uint8Array(e.arrayBuffer,i,n),i)}}function d(e){var t=e.va;if(r(t)){for(var i=t.length,n=0;i>n;++n)t[n].va.destroy();e.va=void 0}}u._verifyAttributes=function(r){for(var i=[],o=0;o<r.length;++o){var a=r[o],l={index:t(a.index,o),enabled:t(a.enabled,!0),componentsPerAttribute:a.componentsPerAttribute,componentDatatype:t(a.componentDatatype,e.FLOAT),normalize:t(a.normalize,!1),vertexBuffer:a.vertexBuffer,usage:t(a.usage,s.STATIC_DRAW)};if(i.push(l),1!==l.componentsPerAttribute&&2!==l.componentsPerAttribute&&3!==l.componentsPerAttribute&&4!==l.componentsPerAttribute)throw new n("attribute.componentsPerAttribute must be in the range [1, 4].");var u=l.componentDatatype;if(!e.validate(u))throw new n("Attribute must have a valid componentDatatype or not specify it.");if(!s.validate(l.usage))throw new n("Attribute must have a valid usage or not specify it.")}for(var c=new Array(i.length),h=0;h<i.length;++h){var d=i[h],p=d.index;if(c[p])throw new n("Index "+p+" is used by more than one attribute.");c[p]=!0}return i},u._vertexSizeInBytes=function(t){for(var r=0,i=t.length,n=0;i>n;++n){var o=t[n];r+=o.componentsPerAttribute*e.getSizeInBytes(o.componentDatatype)}var a=i>0?e.getSizeInBytes(t[0].componentDatatype):0,s=a>0?r%a:0,l=0===s?0:a-s;return r+=l},u._createArrayViews=function(t,r){for(var i=[],n=0,o=t.length,a=0;o>a;++a){var s=t[a],l=s.componentDatatype;i.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:l,normalize:s.normalize,offsetInBytes:n,vertexSizeInComponentType:r/e.getSizeInBytes(l),view:void 0}),n+=s.componentsPerAttribute*e.getSizeInBytes(l)}return i},u.prototype.resize=function(e){this._size=e;var t=this._allBuffers;this.writers=[];for(var r=0,i=t.length;i>r;++r){var n=t[r];u._resize(n,this._size),u._appendWriters(this.writers,n)}d(this)},u._resize=function(t,i){if(t.vertexSizeInBytes>0){var n=new ArrayBuffer(i*t.vertexSizeInBytes);if(r(t.arrayBuffer))for(var o=new Uint8Array(n),a=new Uint8Array(t.arrayBuffer),s=a.length,l=0;s>l;++l)o[l]=a[l];for(var u=t.arrayViews,c=u.length,h=0;c>h;++h){var d=u[h];d.view=e.createArrayBufferView(d.componentDatatype,n,d.offsetInBytes)}t.arrayBuffer=n}};var p=[function(e,t,r){return function(i,n){t[i*r]=n,e.needsCommit=!0}},function(e,t,r){return function(i,n,o){var a=i*r;t[a]=n,t[a+1]=o,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a){var s=i*r;t[s]=n,t[s+1]=o,t[s+2]=a,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a,s){var l=i*r;t[l]=n,t[l+1]=o,t[l+2]=a,t[l+3]=s,e.needsCommit=!0}}];return u._appendWriters=function(e,t){for(var r=t.arrayViews,i=r.length,n=0;i>n;++n){var o=r[n];e[o.index]=p[o.componentsPerAttribute-1](t,o.view,o.vertexSizeInComponentType)}},u.prototype.commit=function(e){var t,i,n,a=!1,s=this._allBuffers;for(i=0,n=s.length;n>i;++i)t=s[i],a=c(this,t)||a;if(a||!r(this.va)){d(this);for(var h=this.va=[],p=r(e)?Math.ceil(this._size/(o.SIXTY_FOUR_KILOBYTES-1)):1,m=0;p>m;++m){var f=[];for(i=0,n=s.length;n>i;++i){t=s[i];var v=m*(t.vertexSizeInBytes*(o.SIXTY_FOUR_KILOBYTES-1));u._appendAttributes(f,t,v,this._instanced)}f=f.concat(this._precreated),h.push({va:new l({context:this._context,attributes:f,indexBuffer:e}),indicesCount:1.5*(m!==p-1?o.SIXTY_FOUR_KILOBYTES-1:this._size%(o.SIXTY_FOUR_KILOBYTES-1))})}}},u._appendAttributes=function(e,t,r,i){for(var n=t.arrayViews,o=n.length,a=0;o>a;++a){var s=n[a];e.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:s.componentDatatype,normalize:s.normalize,vertexBuffer:t.vertexBuffer,offsetInBytes:r+s.offsetInBytes,strideInBytes:t.vertexSizeInBytes,instanceDivisor:i?1:0})}},u.prototype.subCommit=function(e,t){for(var r=this._allBuffers,i=0,n=r.length;n>i;++i)h(r[i],e,t)},u.prototype.endSubCommits=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t)e[t].needsCommit=!1},u.prototype.isDestroyed=function(){return!1},u.prototype.destroy=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t){var n=e[t];n.vertexBuffer=n.vertexBuffer&&n.vertexBuffer.destroy()}return d(this),i(this)},u}),r("Shaders/BillboardCollectionFS",[],function(){"use strict";return"uniform sampler2D u_atlas;\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nvoid main()\n{\n#ifdef RENDER_FOR_PICK\nvec4 vertexColor = vec4(1.0, 1.0, 1.0, 1.0);\n#else\nvec4 vertexColor = v_color;\n#endif\nvec4 color = texture2D(u_atlas, v_textureCoordinates) * vertexColor;\nif (color.a == 0.0)\n{\ndiscard;\n}\n#ifdef RENDER_FOR_PICK\ngl_FragColor = v_pickColor;\n#else\ngl_FragColor = color;\n#endif\n}\n"}),r("Shaders/BillboardCollectionVS",[],function(){"use strict";return"#ifdef INSTANCED\nattribute vec2 direction;\n#endif\nattribute vec4 positionHighAndScale;\nattribute vec4 positionLowAndRotation;\nattribute vec4 compressedAttribute0;\nattribute vec4 compressedAttribute1;\nattribute vec4 compressedAttribute2;\nattribute vec4 eyeOffset;\nattribute vec4 scaleByDistance;\nattribute vec4 pixelOffsetScaleByDistance;\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nconst float UPPER_BOUND = 32768.0;\nconst float SHIFT_LEFT16 = 65536.0;\nconst float SHIFT_LEFT8 = 256.0;\nconst float SHIFT_LEFT7 = 128.0;\nconst float SHIFT_LEFT5 = 32.0;\nconst float SHIFT_LEFT3 = 8.0;\nconst float SHIFT_LEFT2 = 4.0;\nconst float SHIFT_LEFT1 = 2.0;\nconst float SHIFT_RIGHT8 = 1.0 / 256.0;\nconst float SHIFT_RIGHT7 = 1.0 / 128.0;\nconst float SHIFT_RIGHT5 = 1.0 / 32.0;\nconst float SHIFT_RIGHT3 = 1.0 / 8.0;\nconst float SHIFT_RIGHT2 = 1.0 / 4.0;\nconst float SHIFT_RIGHT1 = 1.0 / 2.0;\nvec4 computePositionWindowCoordinates(vec4 positionEC, vec2 imageSize, float scale, vec2 direction, vec2 origin, vec2 translate, vec2 pixelOffset, vec3 alignedAxis, float rotation, bool sizeInMeters)\n{\nvec2 halfSize = imageSize * scale * czm_resolutionScale;\nhalfSize *= ((direction * 2.0) - 1.0);\nif (sizeInMeters)\n{\npositionEC.xy += halfSize;\n}\nvec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\nif (sizeInMeters)\n{\npositionWC.xy += (origin * abs(halfSize)) / czm_metersPerPixel(positionEC);\n}\nelse\n{\npositionWC.xy += (origin * abs(halfSize));\n}\n#if defined(ROTATION) || defined(ALIGNED_AXIS)\nif (!all(equal(alignedAxis, vec3(0.0))) || rotation != 0.0)\n{\nfloat angle = rotation;\nif (!all(equal(alignedAxis, vec3(0.0))))\n{\nvec3 pos = positionEC.xyz + czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow;\nvec3 normal = normalize(cross(alignedAxis, pos));\nvec4 tangent = vec4(normalize(cross(pos, normal)), 0.0);\ntangent = czm_modelViewProjection * tangent;\nangle += sign(-tangent.x) * acos(tangent.y / length(tangent.xy));\n}\nfloat cosTheta = cos(angle);\nfloat sinTheta = sin(angle);\nmat2 rotationMatrix = mat2(cosTheta, sinTheta, -sinTheta, cosTheta);\nhalfSize = rotationMatrix * halfSize;\n}\n#endif\nif (!sizeInMeters)\n{\npositionWC.xy += halfSize;\n}\npositionWC.xy += translate;\npositionWC.xy += (pixelOffset * czm_resolutionScale);\nreturn positionWC;\n}\nvoid main()\n{\nvec3 positionHigh = positionHighAndScale.xyz;\nvec3 positionLow = positionLowAndRotation.xyz;\nfloat scale = positionHighAndScale.w;\n#if defined(ROTATION) || defined(ALIGNED_AXIS)\nfloat rotation = positionLowAndRotation.w;\n#else\nfloat rotation = 0.0;\n#endif\nfloat compressed = compressedAttribute0.x;\nvec2 pixelOffset;\npixelOffset.x = floor(compressed * SHIFT_RIGHT7);\ncompressed -= pixelOffset.x * SHIFT_LEFT7;\npixelOffset.x -= UPPER_BOUND;\nvec2 origin;\norigin.x = floor(compressed * SHIFT_RIGHT5);\ncompressed -= origin.x * SHIFT_LEFT5;\norigin.y = floor(compressed * SHIFT_RIGHT3);\ncompressed -= origin.y * SHIFT_LEFT3;\norigin -= vec2(1.0);\nfloat show = floor(compressed * SHIFT_RIGHT2);\ncompressed -= show * SHIFT_LEFT2;\n#ifdef INSTANCED\nvec2 textureCoordinatesBottomLeft = czm_decompressTextureCoordinates(compressedAttribute0.w);\nvec2 textureCoordinatesRange = czm_decompressTextureCoordinates(eyeOffset.w);\nvec2 textureCoordinates = textureCoordinatesBottomLeft + direction * textureCoordinatesRange;\n#else\nvec2 direction;\ndirection.x = floor(compressed * SHIFT_RIGHT1);\ndirection.y = compressed - direction.x * SHIFT_LEFT1;\nvec2 textureCoordinates = czm_decompressTextureCoordinates(compressedAttribute0.w);\n#endif\nfloat temp = compressedAttribute0.y  * SHIFT_RIGHT8;\npixelOffset.y = -(floor(temp) - UPPER_BOUND);\nvec2 translate;\ntranslate.y = (temp - floor(temp)) * SHIFT_LEFT16;\ntemp = compressedAttribute0.z * SHIFT_RIGHT8;\ntranslate.x = floor(temp) - UPPER_BOUND;\ntranslate.y += (temp - floor(temp)) * SHIFT_LEFT8;\ntranslate.y -= UPPER_BOUND;\ntemp = compressedAttribute1.x * SHIFT_RIGHT8;\nvec2 imageSize = vec2(floor(temp), compressedAttribute2.w);\n#ifdef EYE_DISTANCE_TRANSLUCENCY\nvec4 translucencyByDistance;\ntranslucencyByDistance.x = compressedAttribute1.z;\ntranslucencyByDistance.z = compressedAttribute1.w;\ntranslucencyByDistance.y = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\ntemp = compressedAttribute1.y * SHIFT_RIGHT8;\ntranslucencyByDistance.w = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\n#endif\n#ifdef ALIGNED_AXIS\nvec3 alignedAxis = czm_octDecode(floor(compressedAttribute1.y * SHIFT_RIGHT8));\n#else\nvec3 alignedAxis = vec3(0.0);\n#endif\n#ifdef RENDER_FOR_PICK\ntemp = compressedAttribute2.y;\n#else\ntemp = compressedAttribute2.x;\n#endif\nvec4 color;\ntemp = temp * SHIFT_RIGHT8;\ncolor.b = (temp - floor(temp)) * SHIFT_LEFT8;\ntemp = floor(temp) * SHIFT_RIGHT8;\ncolor.g = (temp - floor(temp)) * SHIFT_LEFT8;\ncolor.r = floor(temp);\ntemp = compressedAttribute2.z * SHIFT_RIGHT8;\nbool sizeInMeters = (temp - floor(temp)) * SHIFT_LEFT8 > 0.0;\ntemp = floor(temp) * SHIFT_RIGHT8;\n#ifdef RENDER_FOR_PICK\ncolor.a = (temp - floor(temp)) * SHIFT_LEFT8;\nvec4 pickColor = color / 255.0;\n#else\ncolor.a = floor(temp);\ncolor /= 255.0;\n#endif\nvec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\nvec4 positionEC = czm_modelViewRelativeToEye * p;\npositionEC = czm_eyeOffset(positionEC, eyeOffset.xyz);\npositionEC.xyz *= show;\n#if defined(EYE_DISTANCE_SCALING) || defined(EYE_DISTANCE_TRANSLUCENCY) || defined(EYE_DISTANCE_PIXEL_OFFSET)\nfloat lengthSq;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nlengthSq = czm_eyeHeight2D.y;\n}\nelse\n{\nlengthSq = dot(positionEC.xyz, positionEC.xyz);\n}\n#endif\n#ifdef EYE_DISTANCE_SCALING\nscale *= czm_nearFarScalar(scaleByDistance, lengthSq);\nif (scale == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\nfloat translucency = 1.0;\n#ifdef EYE_DISTANCE_TRANSLUCENCY\ntranslucency = czm_nearFarScalar(translucencyByDistance, lengthSq);\nif (translucency == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\n#ifdef EYE_DISTANCE_PIXEL_OFFSET\nfloat pixelOffsetScale = czm_nearFarScalar(pixelOffsetScaleByDistance, lengthSq);\npixelOffset *= pixelOffsetScale;\n#endif\n#ifdef CLAMPED_TO_GROUND\npositionEC.z *= 0.995;\norigin.y = 1.0;\n#endif\nvec4 positionWC = computePositionWindowCoordinates(positionEC, imageSize, scale, direction, origin, translate, pixelOffset, alignedAxis, rotation, sizeInMeters);\ngl_Position = czm_viewportOrthographic * vec4(positionWC.xy, -positionWC.z, 1.0);\nv_textureCoordinates = textureCoordinates;\n#ifdef RENDER_FOR_PICK\nv_pickColor = pickColor;\n#else\nv_color = color;\nv_color.a *= translucency;\n#endif\n}\n";
}),r("Scene/HeightReference",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2};return e(t)}),r("Scene/HorizontalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,LEFT:1,RIGHT:-1};return e(t)}),r("Scene/SceneMode",["../Core/freezeObject"],function(e){"use strict";var t={MORPHING:0,COLUMBUS_VIEW:1,SCENE2D:2,SCENE3D:3};return t.getMorphTime=function(e){if(e===t.SCENE3D)return 1;if(e!==t.MORPHING)return 0},e(t)}),r("Scene/SceneTransforms",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/defined","../Core/DeveloperError","../Core/Math","../Core/Matrix4","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u){"use strict";var c={},h=new i(0,0,0,1),d=new i,p=new l;c.wgs84ToWindowCoordinates=function(e,t,r){var n=c.computeActualWgs84Position(e.frameState,t,h);if(o(n)){var a=e.camera,s=l.multiply(a.frustum.projectionMatrix,a.viewMatrix,p);if(l.multiplyByVector(s,i.fromElements(n.x,n.y,n.z,1,d),d),!(d.z<0&&e.mode!==u.SCENE2D))return r=c.clipToGLWindowCoordinates(e,d,r),r.y=e.canvas.clientHeight-r.y,r}},c.wgs84ToDrawingBufferCoordinates=function(e,t,r){var n=c.computeActualWgs84Position(e.frameState,t,h);if(o(n)){var a=e.camera,s=l.multiply(a.frustum.projectionMatrix,a.viewMatrix,p);if(l.multiplyByVector(s,i.fromElements(n.x,n.y,n.z,1,d),d),!(d.z<0&&e.mode!==u.SCENE2D))return c.clipToDrawingBufferCoordinates(e,d,r)}};var m=new r,f=new n;c.computeActualWgs84Position=function(e,t,i){var n=e.mode;if(n===u.SCENE3D)return r.clone(t,i);var a=e.mapProjection,l=a.ellipsoid.cartesianToCartographic(t,f);if(o(l)){if(a.project(l,m),n===u.COLUMBUS_VIEW)return r.fromElements(m.z,m.x,m.y,i);if(n===u.SCENE2D)return r.fromElements(0,m.x,m.y,i);var c=e.morphTime;return r.fromElements(s.lerp(m.z,t.x,c),s.lerp(m.x,t.y,c),s.lerp(m.y,t.z,c),i)}};var v=new r,_=new r,g=new e,y=new l;c.clipToGLWindowCoordinates=function(e,i,n){var o=e.canvas;return r.divideByScalar(i,i.w,v),g.width=o.clientWidth,g.height=o.clientHeight,l.computeViewportTransformation(g,0,1,y),l.multiplyByPoint(y,v,_),t.fromCartesian3(_,n)},c.clipToDrawingBufferCoordinates=function(i,n,o){return r.divideByScalar(n,n.w,v),e.clone(i._passState.viewport,g),l.computeViewportTransformation(g,0,1,y),l.multiplyByPoint(y,v,_),t.fromCartesian3(_,o)},c.transformWindowToDrawingBuffer=function(e,r,i){var n=e.canvas,o=e.drawingBufferWidth/n.clientWidth,a=e.drawingBufferHeight/n.clientHeight;return t.fromElements(r.x*o,r.y*a,i)};var C=new i,E=new i;return c.drawingBufferToWgs84Coordinates=function(e,t,n,o){var a=e.context,s=a.uniformState,u=e._passState.viewport,c=i.clone(i.UNIT_W,C);c.x=(t.x-u.x)/u.width*2-1,c.y=(t.y-u.y)/u.height*2-1,c.z=2*n-1,c.w=1;var h=l.multiplyByVector(s.inverseViewProjection,c,E),d=1/h.w;return r.multiplyByScalar(h,d,h),r.fromCartesian4(h,o)},c}),r("Scene/VerticalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,BOTTOM:1,TOP:-1};return e(t)}),r("Scene/Billboard",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/NearFarScalar","./HeightReference","./HorizontalOrigin","./SceneMode","./SceneTransforms","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_){"use strict";function g(e,i){e=s(e,s.EMPTY_OBJECT),this._show=s(e.show,!0),this._position=r.clone(s(e.position,r.ZERO)),this._actualPosition=r.clone(this._position),this._pixelOffset=t.clone(s(e.pixelOffset,t.ZERO)),this._translate=new t(0,0),this._eyeOffset=r.clone(s(e.eyeOffset,r.ZERO)),this._verticalOrigin=s(e.verticalOrigin,_.CENTER),this._horizontalOrigin=s(e.horizontalOrigin,m.CENTER),this._scale=s(e.scale,1),this._color=o.clone(s(e.color,o.WHITE)),this._rotation=s(e.rotation,0),this._alignedAxis=r.clone(s(e.alignedAxis,r.ZERO)),this._width=e.width,this._height=e.height,this._scaleByDistance=e.scaleByDistance,this._translucencyByDistance=e.translucencyByDistance,this._pixelOffsetScaleByDistance=e.pixelOffsetScaleByDistance,this._heightReference=s(e.heightReference,p.NONE),this._sizeInMeters=s(e.sizeInMeters,!1),this._id=e.id,this._collection=s(e.collection,i),this._pickId=void 0,this._pickPrimitive=s(e._pickPrimitive,this),this._billboardCollection=i,this._dirty=!1,this._index=-1,this._imageIndex=-1,this._imageIndexPromise=void 0,this._imageId=void 0,this._image=void 0,this._imageSubRegion=void 0,this._imageWidth=void 0,this._imageHeight=void 0;var n=e.image,u=e.imageId;l(n)&&(l(u)||(u="string"==typeof n?n:l(n.src)?n.src:a()),this._imageId=u,this._image=n),l(e.imageSubRegion)&&(this._imageId=u,this._imageSubRegion=e.imageSubRegion),l(this._billboardCollection._textureAtlas)&&this._loadImage(),this._actualClampedPosition=void 0,this._removeCallbackFunc=void 0,this._mode=f.SCENE3D,this._updateClamping()}function y(e,t){var r=e._billboardCollection;l(r)&&(r._updateBillboard(e,t),e._dirty=!0)}var C=g.SHOW_INDEX=0,E=g.POSITION_INDEX=1,S=g.PIXEL_OFFSET_INDEX=2,w=g.EYE_OFFSET_INDEX=3,T=g.HORIZONTAL_ORIGIN_INDEX=4,x=g.VERTICAL_ORIGIN_INDEX=5,b=g.SCALE_INDEX=6,P=g.IMAGE_INDEX_INDEX=7,A=g.COLOR_INDEX=8,I=g.ROTATION_INDEX=9,M=g.ALIGNED_AXIS_INDEX=10,D=g.SCALE_BY_DISTANCE_INDEX=11,R=g.TRANSLUCENCY_BY_DISTANCE_INDEX=12,O=g.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX=13;g.NUMBER_OF_PROPERTIES=14,u(g.prototype,{show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,y(this,C))}},position:{get:function(){return this._position},set:function(e){var t=this._position;r.equals(t,e)||(r.clone(e,t),r.clone(e,this._actualPosition),this._updateClamping(),y(this,E))}},heightReference:{get:function(){return this._heightReference},set:function(e){var t=this._heightReference;e!==t&&(this._heightReference=e,this._updateClamping(),y(this,E))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(e){var r=this._pixelOffset;t.equals(r,e)||(t.clone(e,r),y(this,S))}},scaleByDistance:{get:function(){return this._scaleByDistance},set:function(e){var t=this._scaleByDistance;d.equals(t,e)||(this._scaleByDistance=d.clone(e,t),y(this,D))}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){var t=this._translucencyByDistance;d.equals(t,e)||(this._translucencyByDistance=d.clone(e,t),y(this,R))}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){var t=this._pixelOffsetScaleByDistance;d.equals(t,e)||(this._pixelOffsetScaleByDistance=d.clone(e,t),y(this,O))}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){var t=this._eyeOffset;r.equals(t,e)||(r.clone(e,t),y(this,w))}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){this._horizontalOrigin!==e&&(this._horizontalOrigin=e,y(this,T))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){this._verticalOrigin!==e&&(this._verticalOrigin=e,y(this,x))}},scale:{get:function(){return this._scale},set:function(e){this._scale!==e&&(this._scale=e,y(this,b))}},color:{get:function(){return this._color},set:function(e){var t=this._color;o.equals(t,e)||(o.clone(e,t),y(this,A))}},rotation:{get:function(){return this._rotation},set:function(e){this._rotation!==e&&(this._rotation=e,y(this,I))}},alignedAxis:{get:function(){return this._alignedAxis},set:function(e){var t=this._alignedAxis;r.equals(t,e)||(r.clone(e,t),y(this,M))}},width:{get:function(){return s(this._width,this._imageWidth)},set:function(e){this._width!==e&&(this._width=e,y(this,P))}},height:{get:function(){return s(this._height,this._imageHeight)},set:function(e){this._height!==e&&(this._height=e,y(this,P))}},sizeInMeters:{get:function(){return this._sizeInMeters},set:function(e){this._sizeInMeters!==e&&(this._sizeInMeters=e,y(this,A))}},id:{get:function(){return this._id},set:function(e){this._id=e,l(this._pickId)&&(this._pickId.object.id=e)}},pickPrimitive:{get:function(){return this._pickPrimitive},set:function(e){this._pickPrimitive=e,l(this._pickId)&&(this._pickId.object.primitive=e)}},image:{get:function(){return this._imageId},set:function(e){l(e)?"string"==typeof e?this.setImage(e,e):l(e.src)?this.setImage(e.src,e):this.setImage(a(),e):(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=void 0,this._image=void 0,this._imageIndexPromise=void 0,y(this,P))}},ready:{get:function(){return-1!==this._imageIndex}},_clampedPosition:{get:function(){return this._actualClampedPosition},set:function(e){this._actualClampedPosition=r.clone(e,this._actualClampedPosition),y(this,E)}}}),g.prototype.getPickId=function(e){return l(this._pickId)||(this._pickId=e.createPickId({primitive:this._pickPrimitive,collection:this._collection,id:this._id})),this._pickId},g.prototype._updateClamping=function(){g._updateClamping(this._billboardCollection,this)};var N=new n,L=new r;g._updateClamping=function(e,t){function i(e){if(t._heightReference===p.RELATIVE_TO_GROUND)if(t._mode===f.SCENE3D){var i=s.cartesianToCartographic(e,N);i.height+=v.height,s.cartographicToCartesian(i,e)}else e.x+=v.height;t._clampedPosition=r.clone(e,t._clampedPosition)}var o=e._scene;if(l(o)){var a=o.globe,s=a.ellipsoid,u=a._surface,h=o.frameState.mode,d=o.frameState.mapProjection,m=h!==t._mode;if(t._mode=h,(t._heightReference===p.NONE||m)&&l(t._removeCallbackFunc)&&(t._removeCallbackFunc(),t._removeCallbackFunc=void 0,t._clampedPosition=void 0),t._heightReference!==p.NONE&&l(t._position)){var v=s.cartesianToCartographic(t._position);if(l(v)){l(t._removeCallbackFunc)&&t._removeCallbackFunc(),t._removeCallbackFunc=u.updateHeight(v,i);var _=a.getHeight(v);l(_)&&(n.clone(v,N),N.height=_,t._mode===f.SCENE3D?s.cartographicToCartesian(N,L):(d.project(N,L),r.fromElements(L.z,L.x,L.y,L)),i(L))}}}else if(t._heightReference!==p.NONE)throw new c("Height reference is not supported.")},g.prototype._loadImage=function(){var t,r=this._billboardCollection._textureAtlas,i=this._imageId,n=this._image,o=this._imageSubRegion;if(l(n)&&(t=r.addImage(i,n)),l(o)&&(t=r.addSubRegion(i,o)),this._imageIndexPromise=t,l(t)){var a=this;t.then(function(t){if(a._imageId===i&&a._image===n&&e.equals(a._imageSubRegion,o)){var s=r.textureCoordinates[t];a._imageWidth=r.texture.width*s.width,a._imageHeight=r.texture.height*s.height,a._imageIndex=t,a._ready=!0,a._image=void 0,a._imageIndexPromise=void 0,y(a,P)}}).otherwise(function(e){console.error("Error loading image for billboard: "+e),a._imageIndexPromise=void 0})}},g.prototype.setImage=function(e,t){this._imageId!==e&&(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=e,this._image=t,l(this._billboardCollection._textureAtlas)&&this._loadImage())},g.prototype.setImageSubRegion=function(t,r){this._imageId===t&&e.equals(this._imageSubRegion,r)||(this._imageIndex=-1,this._imageId=t,this._imageSubRegion=e.clone(r),l(this._billboardCollection._textureAtlas)&&this._loadImage())},g.prototype._setTranslate=function(e){var r=this._translate;t.equals(r,e)||(t.clone(e,r),y(this,S))},g.prototype._getActualPosition=function(){return l(this._clampedPosition)?this._clampedPosition:this._actualPosition},g.prototype._setActualPosition=function(e){l(this._clampedPosition)||r.clone(e,this._actualPosition),y(this,E)};var F=new i;g._computeActualPosition=function(e,t,r,i){return l(e._clampedPosition)?(r.mode!==e._mode&&e._updateClamping(),e._clampedPosition):r.mode===f.SCENE3D?t:(h.multiplyByPoint(i,t,F),v.computeActualWgs84Position(r,F))};var B=new h,V=new i,z=new r,k=new t,U=new t;g._computeScreenSpacePosition=function(e,n,o,a,s,l){var u=s.camera,c=u.viewMatrix,d=u.frustum.projectionMatrix,p=h.multiplyTransformation(c,e,B),m=h.multiplyByVector(p,i.fromElements(n.x,n.y,n.z,1,V),V),f=r.multiplyComponents(o,r.normalize(m,z),z);m.x+=o.x+f.x,m.y+=o.y+f.y,m.z+=f.z;var _=h.multiplyByVector(d,m,V),g=v.clipToGLWindowCoordinates(s,_,l);a=t.clone(a,U),a.y=-a.y;var y=t.multiplyByScalar(a,s.context.uniformState.resolutionScale,k);return g.x+=y.x,g.y+=y.y,g};var G=new t(0,0);return g.prototype.computeScreenSpacePosition=function(e,r){var i=this._billboardCollection;l(r)||(r=new t),t.clone(this._pixelOffset,G),t.add(G,this._translate,G);var n=i.modelMatrix,o=this._getActualPosition(),a=g._computeScreenSpacePosition(n,o,this._eyeOffset,G,e,r);return a.y=e.canvas.clientHeight-a.y,a},g.prototype.equals=function(i){return this===i||l(i)&&this._id===i._id&&r.equals(this._position,i._position)&&this._imageId===i._imageId&&this._show===i._show&&this._scale===i._scale&&this._verticalOrigin===i._verticalOrigin&&this._horizontalOrigin===i._horizontalOrigin&&e.equals(this._imageSubRegion,i._imageSubRegion)&&o.equals(this._color,i._color)&&t.equals(this._pixelOffset,i._pixelOffset)&&t.equals(this._translate,i._translate)&&r.equals(this._eyeOffset,i._eyeOffset)&&d.equals(this._scaleByDistance,i._scaleByDistance)&&d.equals(this._translucencyByDistance,i._translucencyByDistance)&&d.equals(this._pixelOffsetScaleByDistance,i._pixelOffsetScaleByDistance)},g.prototype._destroy=function(){l(this._customData)&&(this._billboardCollection._scene.globe._surface.removeTileCustomData(this._customData),this._customData=void 0),this.image=void 0,this._pickId=this._pickId&&this._pickId.destroy(),this._billboardCollection=void 0},g}),r("Scene/BlendEquation",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={ADD:t.FUNC_ADD,SUBTRACT:t.FUNC_SUBTRACT,REVERSE_SUBTRACT:t.FUNC_REVERSE_SUBTRACT};return e(r)}),r("Scene/BlendFunction",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={ZERO:t.ZERO,ONE:t.ONE,SOURCE_COLOR:t.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:t.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:t.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:t.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:t.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:t.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:t.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:t.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:t.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:t.ONE_MINUS_CONSTANT_ALPHA,CONSTANT_ALPHA:t.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:t.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:t.SRC_ALPHA_SATURATE};return e(r)}),r("Scene/BlendingState",["../Core/freezeObject","./BlendEquation","./BlendFunction"],function(e,t,r){"use strict";var i={DISABLED:e({enabled:!1}),ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.SOURCE_ALPHA,functionSourceAlpha:r.SOURCE_ALPHA,functionDestinationRgb:r.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:r.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.ONE,functionSourceAlpha:r.ONE,functionDestinationRgb:r.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:r.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.SOURCE_ALPHA,functionSourceAlpha:r.SOURCE_ALPHA,functionDestinationRgb:r.ONE,functionDestinationAlpha:r.ONE})};return e(i)}),r("Scene/Pass",["../Core/freezeObject"],function(e){"use strict";var t={COMPUTE:0,GLOBE:1,GROUND:2,OPAQUE:3,TRANSLUCENT:4,OVERLAY:5,NUMBER_OF_PASSES:6};return e(t)}),r("Renderer/Framebuffer",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/PixelFormat","./ContextLimits"],function(e,t,r,i,n,o,a){"use strict";function s(e,t,r){var i=e._gl;i.framebufferTexture2D(i.FRAMEBUFFER,t,r._target,r._texture,0)}function l(e,t,r){var i=e._gl;i.framebufferRenderbuffer(i.FRAMEBUFFER,t,i.RENDERBUFFER,r._getRenderbuffer())}function u(r){r=e(r,e.EMPTY_OBJECT);var i=r.context._gl;a.maximumColorAttachments;this._gl=i,this._framebuffer=i.createFramebuffer(),this._colorTextures=[],this._colorRenderbuffers=[],this._activeColorAttachments=[],this._depthTexture=void 0,this._depthRenderbuffer=void 0,this._stencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthStencilRenderbuffer=void 0,this.destroyAttachments=e(r.destroyAttachments,!0);t(r.depthTexture)||t(r.depthRenderbuffer),t(r.depthStencilTexture)||t(r.depthStencilRenderbuffer);this._bind();var n,o,u,c,h;if(t(r.colorTextures)){var d=r.colorTextures;for(c=this._colorTextures.length=this._activeColorAttachments.length=d.length,u=0;c>u;++u)n=d[u],h=this._gl.COLOR_ATTACHMENT0+u,s(this,h,n),this._activeColorAttachments[u]=h,this._colorTextures[u]=n}if(t(r.colorRenderbuffers)){var p=r.colorRenderbuffers;for(c=this._colorRenderbuffers.length=this._activeColorAttachments.length=p.length,u=0;c>u;++u)o=p[u],h=this._gl.COLOR_ATTACHMENT0+u,l(this,h,o),this._activeColorAttachments[u]=h,this._colorRenderbuffers[u]=o}t(r.depthTexture)&&(n=r.depthTexture,s(this,this._gl.DEPTH_ATTACHMENT,n),this._depthTexture=n),t(r.depthRenderbuffer)&&(o=r.depthRenderbuffer,l(this,this._gl.DEPTH_ATTACHMENT,o),this._depthRenderbuffer=o),t(r.stencilRenderbuffer)&&(o=r.stencilRenderbuffer,l(this,this._gl.STENCIL_ATTACHMENT,o),this._stencilRenderbuffer=o),t(r.depthStencilTexture)&&(n=r.depthStencilTexture,s(this,this._gl.DEPTH_STENCIL_ATTACHMENT,n),this._depthStencilTexture=n),t(r.depthStencilRenderbuffer)&&(o=r.depthStencilRenderbuffer,l(this,this._gl.DEPTH_STENCIL_ATTACHMENT,o),this._depthStencilRenderbuffer=o),this._unBind()}return r(u.prototype,{status:{get:function(){this._bind();var e=this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);return this._unBind(),e}},numberOfColorAttachments:{get:function(){return this._activeColorAttachments.length}},depthTexture:{get:function(){return this._depthTexture}},depthRenderbuffer:{get:function(){return this._depthRenderbuffer}},stencilRenderbuffer:{get:function(){return this._stencilRenderbuffer}},depthStencilTexture:{get:function(){return this._depthStencilTexture}},depthStencilRenderbuffer:{get:function(){return this._depthStencilRenderbuffer}},hasDepthAttachment:{get:function(){return!!(this.depthTexture||this.depthRenderbuffer||this.depthStencilTexture||this.depthStencilRenderbuffer)}}}),u.prototype._bind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,this._framebuffer)},u.prototype._unBind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,null)},u.prototype._getActiveColorAttachments=function(){return this._activeColorAttachments},u.prototype.getColorTexture=function(e){return this._colorTextures[e]},u.prototype.getColorRenderbuffer=function(e){return this._colorRenderbuffers[e]},u.prototype.isDestroyed=function(){return!1},u.prototype.destroy=function(){if(this.destroyAttachments){for(var e=0,r=this._colorTextures,n=r.length;n>e;++e){var o=r[e];t(o)&&o.destroy()}var a=this._colorRenderbuffers;for(n=a.length,e=0;n>e;++e){var s=a[e];t(s)&&s.destroy()}this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy(),this._stencilRenderbuffer=this._stencilRenderbuffer&&this._stencilRenderbuffer.destroy(),this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()}return this._gl.deleteFramebuffer(this._framebuffer),i(this)},u}),r("Renderer/MipmapHint",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={DONT_CARE:t.DONT_CARE,FASTEST:t.FASTEST,NICEST:t.NICEST,validate:function(e){return e===r.DONT_CARE||e===r.FASTEST||e===r.NICEST}};return e(r)}),r("Renderer/PixelDatatype",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={UNSIGNED_BYTE:t.UNSIGNED_BYTE,UNSIGNED_SHORT:t.UNSIGNED_SHORT,UNSIGNED_INT:t.UNSIGNED_INT,FLOAT:t.FLOAT,UNSIGNED_INT_24_8:t.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:t.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:t.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:t.UNSIGNED_SHORT_5_6_5,validate:function(e){return e===r.UNSIGNED_BYTE||e===r.UNSIGNED_SHORT||e===r.UNSIGNED_INT||e===r.FLOAT||e===r.UNSIGNED_INT_24_8||e===r.UNSIGNED_SHORT_4_4_4_4||e===r.UNSIGNED_SHORT_5_5_5_1||e===r.UNSIGNED_SHORT_5_6_5}};return e(r)}),r("Renderer/TextureMagnificationFilter",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={NEAREST:t.NEAREST,LINEAR:t.LINEAR,validate:function(e){return e===r.NEAREST||e===r.LINEAR}};return e(r)}),r("Renderer/TextureMinificationFilter",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={NEAREST:t.NEAREST,LINEAR:t.LINEAR,NEAREST_MIPMAP_NEAREST:t.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:t.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:t.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:t.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===r.NEAREST||e===r.LINEAR||e===r.NEAREST_MIPMAP_NEAREST||e===r.LINEAR_MIPMAP_NEAREST||e===r.NEAREST_MIPMAP_LINEAR||e===r.LINEAR_MIPMAP_LINEAR}};return e(r)}),r("Renderer/TextureWrap",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={CLAMP_TO_EDGE:t.CLAMP_TO_EDGE,REPEAT:t.REPEAT,MIRRORED_REPEAT:t.MIRRORED_REPEAT,validate:function(e){return e===r.CLAMP_TO_EDGE||e===r.REPEAT||e===r.MIRRORED_REPEAT}};return e(r)}),r("Renderer/Sampler",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,r,i,n,o,a){"use strict";function s(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.wrapS,a.CLAMP_TO_EDGE),s=e(r.wrapT,a.CLAMP_TO_EDGE),l=e(r.minificationFilter,o.LINEAR),u=e(r.magnificationFilter,n.LINEAR),c=t(r.maximumAnisotropy)?r.maximumAnisotropy:1;this._wrapS=i,this._wrapT=s,this._minificationFilter=l,this._magnificationFilter=u,this._maximumAnisotropy=c}return r(s.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),s}),r("Renderer/Texture",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/PixelFormat","./ContextLimits","./MipmapHint","./PixelDatatype","./Sampler","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap","./WebGLConstants"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f){"use strict";function v(i){i=t(i,t.EMPTY_OBJECT);var n=i.context,a=i.width,l=i.height,u=i.source;r(u)&&(r(a)||(a=t(u.videoWidth,u.width)),r(l)||(l=t(u.videoHeight,u.height)));var d=t(i.pixelFormat,s.RGBA),p=t(i.pixelDatatype,c.UNSIGNED_BYTE),m=d;if(n.webgl2&&(d===s.DEPTH_STENCIL?m=f.DEPTH24_STENCIL8:d===s.DEPTH_COMPONENT&&(p===c.UNSIGNED_SHORT?m=f.DEPTH_COMPONENT16:p===c.UNSIGNED_INT&&(m=f.DEPTH_COMPONENT24))),p===c.FLOAT&&!n.floatingPointTexture)throw new o("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.  Check context.floatingPointTexture.");if(s.isDepthFormat(d)&&!n.depthTexture)throw new o("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, this WebGL implementation must support WEBGL_depth_texture.  Check context.depthTexture.");var v=i.preMultiplyAlpha||d===s.RGB||d===s.LUMINANCE,_=t(i.flipY,!0),g=n._gl,y=g.TEXTURE_2D,C=g.createTexture();g.activeTexture(g.TEXTURE0),g.bindTexture(y,C),r(u)?(g.pixelStorei(g.UNPACK_PREMULTIPLY_ALPHA_WEBGL,v),g.pixelStorei(g.UNPACK_FLIP_Y_WEBGL,_),r(u.arrayBufferView)?g.texImage2D(y,0,m,a,l,0,d,p,u.arrayBufferView):r(u.framebuffer)?(u.framebuffer!==n.defaultFramebuffer&&u.framebuffer._bind(),g.copyTexImage2D(y,0,m,u.xOffset,u.yOffset,a,l,0),u.framebuffer!==n.defaultFramebuffer&&u.framebuffer._unBind()):g.texImage2D(y,0,m,d,p,u)):g.texImage2D(y,0,m,a,l,0,d,p,null),g.bindTexture(y,null),this._context=n,this._textureFilterAnisotropic=n._textureFilterAnisotropic,this._textureTarget=y,this._texture=C,this._pixelFormat=d,this._pixelDatatype=p,this._width=a,this._height=l,this._dimensions=new e(a,l),this._preMultiplyAlpha=v,this._flipY=_,this._sampler=void 0,this.sampler=r(i.sampler)?i.sampler:new h}return v.fromFramebuffer=function(e){e=t(e,t.EMPTY_OBJECT);var i=e.context,n=i._gl,o=t(e.pixelFormat,s.RGB),a=t(e.framebufferXOffset,0),l=t(e.framebufferYOffset,0),u=t(e.width,n.drawingBufferWidth),c=t(e.height,n.drawingBufferHeight),h=e.framebuffer,d=new v({context:i,width:u,height:c,pixelFormat:o,source:{framebuffer:r(h)?h:i.defaultFramebuffer,xOffset:a,yOffset:l,width:u,height:c}});return d},i(v.prototype,{sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,n=t===p.NEAREST_MIPMAP_NEAREST||t===p.NEAREST_MIPMAP_LINEAR||t===p.LINEAR_MIPMAP_NEAREST||t===p.LINEAR_MIPMAP_LINEAR;this._pixelDatatype===c.FLOAT&&(t=n?p.NEAREST_MIPMAP_NEAREST:p.NEAREST,i=d.NEAREST);var o=this._context._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),o.texParameteri(a,o.TEXTURE_MIN_FILTER,t),o.texParameteri(a,o.TEXTURE_MAG_FILTER,i),o.texParameteri(a,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(a,o.TEXTURE_WRAP_T,e.wrapT),r(this._textureFilterAnisotropic)&&o.texParameteri(a,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(a,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},_target:{get:function(){return this._textureTarget}}}),v.prototype.copyFrom=function(e,r,i){r=t(r,0),i=t(i,0);var n=this._context._gl,o=this._textureTarget;n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,this._flipY),n.activeTexture(n.TEXTURE0),n.bindTexture(o,this._texture),e.arrayBufferView?n.texSubImage2D(o,0,r,i,e.width,e.height,this._pixelFormat,this._pixelDatatype,e.arrayBufferView):n.texSubImage2D(o,0,r,i,this._pixelFormat,this._pixelDatatype,e),n.bindTexture(o,null)},v.prototype.copyFromFramebuffer=function(e,r,i,n,o,a){e=t(e,0),r=t(r,0),i=t(i,0),n=t(n,0),o=t(o,this._width),a=t(a,this._height);var s=this._context._gl,l=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),s.copyTexSubImage2D(l,0,e,r,i,n,o,a),s.bindTexture(l,null)},v.prototype.generateMipmap=function(e){e=t(e,u.DONT_CARE);var r=this._context._gl,i=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(i,this._texture),r.generateMipmap(i),r.bindTexture(i,null)},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),n(this)},v}),r("Scene/TextureAtlas",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/loadImage","../Core/PixelFormat","../Core/RuntimeError","../Renderer/Framebuffer","../Renderer/RenderState","../Renderer/Texture","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(e,r,n,o,a){this.bottomLeft=i(e,t.ZERO),this.topRight=i(r,t.ZERO),this.childNode1=n,this.childNode2=o,this.imageIndex=a}function v(e){e=i(e,i.EMPTY_OBJECT);var n=i(e.borderWidthInPixels,1),o=i(e.initialSize,C);this._context=e.context,this._pixelFormat=i(e.pixelFormat,u.RGBA),this._borderWidthInPixels=n,this._textureCoordinates=[],this._guid=r(),this._idHash={},this._texture=new p({context:this._context,width:o.x,height:o.y,pixelFormat:this._pixelFormat}),this._root=new f(new t,new t(o.x,o.y));var a=this,s={u_texture:function(){return a._texture}},l="uniform sampler2D u_texture;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\n    gl_FragColor = texture2D(u_texture, v_textureCoordinates);\n}\n";this._copyCommand=this._context.createViewportQuadCommand(l,{uniformMap:s})}function _(r,i){var o=r._context,a=r.numberOfImages,s=2;if(a>0){var l=r._texture.width,u=r._texture.height,c=s*(l+i.width+r._borderWidthInPixels),m=s*(u+i.height+r._borderWidthInPixels),v=l/c,_=u/m,g=new f(new t(l+r._borderWidthInPixels,0),new t(c,u)),y=new f(new t,new t(c,u),r._root,g),C=new f(new t(0,u+r._borderWidthInPixels),new t(c,m)),E=new f(new t,new t(c,m),y,C);r._root=E;for(var S=0;S<r._textureCoordinates.length;S++){var w=r._textureCoordinates[S];n(w)&&(w.x*=v,w.y*=_,w.width*=v,w.height*=_)}var T=new p({context:r._context,width:c,height:m,pixelFormat:r._pixelFormat}),x=new h({context:o,colorTextures:[T],destroyAttachments:!1}),b=r._copyCommand,P={viewport:new e(0,0,l,u)};b.renderState=d.fromCache(P),x._bind(),b.execute(r._context),x._unBind(),x.destroy(),r._texture=T,d.removeFromCache(P),b.renderState=void 0}else{var A=s*(i.width+r._borderWidthInPixels),I=s*(i.height+r._borderWidthInPixels);r._texture=r._texture&&r._texture.destroy(),r._texture=new p({context:r._context,width:A,height:I,pixelFormat:r._pixelFormat}),r._root=new f(new t,new t(A,I))}}function g(e,r,i){if(n(r)){if(!n(r.childNode1)&&!n(r.childNode2)){if(n(r.imageIndex))return;var o=r.topRight.x-r.bottomLeft.x,a=r.topRight.y-r.bottomLeft.y,s=o-i.width,l=a-i.height;if(0>s||0>l)return;if(0===s&&0===l)return r;if(s>l){r.childNode1=new f(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.bottomLeft.x+i.width,r.topRight.y));var u=r.bottomLeft.x+i.width+e._borderWidthInPixels;u<r.topRight.x&&(r.childNode2=new f(new t(u,r.bottomLeft.y),new t(r.topRight.x,r.topRight.y)))}else{r.childNode1=new f(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.topRight.x,r.bottomLeft.y+i.height));var c=r.bottomLeft.y+i.height+e._borderWidthInPixels;c<r.topRight.y&&(r.childNode2=new f(new t(r.bottomLeft.x,c),new t(r.topRight.x,r.topRight.y)))}return g(e,r.childNode1,i)}return g(e,r.childNode1,i)||g(e,r.childNode2,i)}}function y(t,i,o){var a=g(t,t._root,i);if(n(a)){a.imageIndex=o;var s=t._texture.width,l=t._texture.height,u=a.topRight.x-a.bottomLeft.x,c=a.topRight.y-a.bottomLeft.y,h=a.bottomLeft.x/s,d=a.bottomLeft.y/l,p=u/s,m=c/l;t._textureCoordinates[o]=new e(h,d,p,m),t._texture.copyFrom(i,a.bottomLeft.x,a.bottomLeft.y)}else _(t,i),y(t,i,o);t._guid=r()}var C=new t(16,16);return o(v.prototype,{borderWidthInPixels:{get:function(){return this._borderWidthInPixels}},textureCoordinates:{get:function(){return this._textureCoordinates}},texture:{get:function(){return this._texture}},numberOfImages:{get:function(){return this._textureCoordinates.length}},guid:{get:function(){return this._guid}}}),v.prototype.addImage=function(e,t){var r=this._idHash[e];if(n(r))return r;"function"==typeof t?t=t(e):"string"==typeof t&&(t=l(t));var i=this;return r=m(t,function(e){if(i.isDestroyed())return-1;var t=i.numberOfImages;return y(i,e,t),t}),this._idHash[e]=r,r},v.prototype.addSubRegion=function(t,i){var o=this._idHash[t];if(!n(o))throw new c('image with id "'+t+'" not found in the atlas.');var a=this;return m(o,function(t){if(-1===t)return-1;var n=a._texture.width,o=a._texture.height,s=a.numberOfImages,l=a._textureCoordinates[t],u=l.x+i.x/n,c=l.y+i.y/o,h=i.width/n,d=i.height/o;return a._textureCoordinates.push(new e(u,c,h,d)),a._guid=r(),s})},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),a(this)},v}),r("Scene/BillboardCollection",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/IndexDatatype","../Core/Math","../Core/Matrix4","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArrayFacade","../Shaders/BillboardCollectionFS","../Shaders/BillboardCollectionVS","./Billboard","./BlendingState","./HorizontalOrigin","./Pass","./SceneMode","./TextureAtlas"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I){
"use strict";function M(e){e=a(e,a.EMPTY_OBJECT),this._scene=e.scene,this._textureAtlas=void 0,this._textureAtlasGUID=void 0,this._destroyTextureAtlas=!0,this._sp=void 0,this._rs=void 0,this._vaf=void 0,this._spPick=void 0,this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!1,this._shaderRotation=!1,this._compiledShaderRotation=!1,this._compiledShaderRotationPick=!1,this._shaderAlignedAxis=!1,this._compiledShaderAlignedAxis=!1,this._compiledShaderAlignedAxisPick=!1,this._shaderScaleByDistance=!1,this._compiledShaderScaleByDistance=!1,this._compiledShaderScaleByDistancePick=!1,this._shaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistancePick=!1,this._shaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistancePick=!1,this._propertiesChanged=new Uint32Array(ue),this._maxSize=0,this._maxEyeOffset=0,this._maxScale=1,this._maxPixelOffset=0,this._allHorizontalCenter=!0,this._allVerticalCenter=!0,this._allSizedInMeters=!0,this._baseVolume=new t,this._baseVolumeWC=new t,this._baseVolume2D=new t,this._boundingVolume=new t,this._boundingVolumeDirty=!1,this._colorCommands=[],this._pickCommands=[],this.modelMatrix=m.clone(a(e.modelMatrix,m.IDENTITY)),this._modelMatrix=m.clone(m.IDENTITY),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this._mode=A.SCENE3D,this._buffersUsage=[v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW];var r=this;this._uniforms={u_atlas:function(){return r._textureAtlas.texture}}}function D(e){for(var t=e.length,r=0;t>r;++r)e[r]&&e[r]._destroy()}function R(e){if(e._billboardsRemoved){e._billboardsRemoved=!1;for(var t=[],r=e._billboards,i=r.length,n=0,o=0;i>n;++n){var a=r[n];a&&(a._index=o++,t.push(a))}e._billboards=t}}function O(e){var t=16384,r=e.cache.billboardCollection_indexBufferBatched;if(s(r))return r;for(var i=6*t-6,n=new Uint16Array(i),o=0,a=0;i>o;o+=6,a+=4)n[o]=a,n[o+1]=a+1,n[o+2]=a+2,n[o+3]=a+0,n[o+4]=a+2,n[o+5]=a+3;return r=f.createIndexBuffer({context:e,typedArray:n,usage:v.STATIC_DRAW,indexDatatype:d.UNSIGNED_SHORT}),r.vertexArrayDestroyable=!1,e.cache.billboardCollection_indexBufferBatched=r,r}function N(e){var t=e.cache.billboardCollection_indexBufferInstanced;return s(t)?t:(t=f.createIndexBuffer({context:e,typedArray:new Uint16Array([0,1,2,0,2,3]),usage:v.STATIC_DRAW,indexDatatype:d.UNSIGNED_SHORT}),t.vertexArrayDestroyable=!1,e.cache.billboardCollection_indexBufferInstanced=t,t)}function L(e){var t=e.cache.billboardCollection_vertexBufferInstanced;return s(t)?t:(t=f.createVertexBuffer({context:e,typedArray:new Float32Array([0,0,1,0,1,1,0,1]),usage:v.STATIC_DRAW}),t.vertexArrayDestroyable=!1,e.cache.billboardCollection_vertexBufferInstanced=t,t)}function F(e,t,r,i){var n=[{index:X.positionHighAndScale,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[K]},{index:X.positionLowAndRotation,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[K]},{index:X.compressedAttribute0,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[Q]},{index:X.compressedAttribute1,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[se]},{index:X.compressedAttribute2,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[ie]},{index:X.eyeOffset,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[J]},{index:X.scaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[ae]},{index:X.pixelOffsetScaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[le]}];i&&n.push({index:X.direction,componentsPerAttribute:2,componentDatatype:o.FLOAT,vertexBuffer:L(e)});var a=i?t:4*t;return new E(e,n,a,i)}function B(e,r,i,n,o){var a,s=n[X.positionHighAndScale],l=n[X.positionLowAndRotation],u=o._getActualPosition();e._mode===A.SCENE3D&&(t.expand(e._baseVolume,u,e._baseVolume),e._boundingVolumeDirty=!0),h.fromCartesian(u,pe);var c=o.scale,d=o.rotation;0!==d&&(e._shaderRotation=!0),e._maxScale=Math.max(e._maxScale,c);var p=pe.high,m=pe.low;e._instanced?(a=o._index,s(a,p.x,p.y,p.z,c),l(a,m.x,m.y,m.z,d)):(a=4*o._index,s(a+0,p.x,p.y,p.z,c),s(a+1,p.x,p.y,p.z,c),s(a+2,p.x,p.y,p.z,c),s(a+3,p.x,p.y,p.z,c),l(a+0,m.x,m.y,m.z,d),l(a+1,m.x,m.y,m.z,d),l(a+2,m.x,m.y,m.z,d),l(a+3,m.x,m.y,m.z,d))}function V(t,r,i,n,o){var a,s=n[X.compressedAttribute0],l=o.pixelOffset,u=l.x,c=l.y,h=o._translate,d=h.x,m=h.y;t._maxPixelOffset=Math.max(t._maxPixelOffset,Math.abs(u+d),Math.abs(-c+m));var f=o.horizontalOrigin,v=o.verticalOrigin,_=o.show;0===o.color.alpha&&(_=!1),t._allHorizontalCenter=t._allHorizontalCenter&&f===b.CENTER,t._allVerticalCenter=t._allVerticalCenter&&v===b.CENTER;var g=0,y=0,C=0,E=0,S=o._imageIndex;if(-1!==S){var w=i[S];g=w.x,y=w.y,C=w.width,E=w.height}var T=g+C,x=y+E,P=Math.floor(p.clamp(u,-fe,fe)+fe)*ge;P+=(f+1)*ye,P+=(v+1)*Ce,P+=(_?1:0)*Ee;var A=Math.floor(p.clamp(c,-fe,fe)+fe)*_e,I=Math.floor(p.clamp(d,-fe,fe)+fe)*_e,M=(p.clamp(m,-fe,fe)+fe)*Se,D=Math.floor(M),R=Math.floor((M-D)*_e);A+=D,I+=R,me.x=g,me.y=y;var O=e.compressTextureCoordinates(me);me.x=T;var N=e.compressTextureCoordinates(me);me.y=x;var L=e.compressTextureCoordinates(me);me.x=g;var F=e.compressTextureCoordinates(me);t._instanced?(a=o._index,s(a,P,A,I,O)):(a=4*o._index,s(a+0,P+we,A,I,O),s(a+1,P+Te,A,I,N),s(a+2,P+xe,A,I,L),s(a+3,P+be,A,I,F))}function z(t,r,n,o,l){var u,c=o[X.compressedAttribute1],h=l.alignedAxis;i.equals(h,i.ZERO)||(t._shaderAlignedAxis=!0);var d=0,m=1,f=1,v=1,_=l.translucencyByDistance;s(_)&&(d=_.near,m=_.nearValue,f=_.far,v=_.farValue,(1!==m||1!==v)&&(t._shaderTranslucencyByDistance=!0));var g=0,y=l._imageIndex;if(-1!==y){var C=n[y];g=C.width}var E=t._textureAtlas.texture.width,S=Math.ceil(.5*a(l.width,E*g));t._maxSize=Math.max(t._maxSize,S);var w=p.clamp(S,0,ve),T=0;Math.abs(i.magnitudeSquared(h)-1)<p.EPSILON6&&(T=e.octEncodeFloat(h)),m=p.clamp(m,0,1),m=1===m?255:255*m|0,w=w*_e+m,v=p.clamp(v,0,1),v=1===v?255:255*v|0,T=T*_e+v,t._instanced?(u=l._index,c(u,w,T,d,f)):(u=4*l._index,c(u+0,w,T,d,f),c(u+1,w,T,d,f),c(u+2,w,T,d,f),c(u+3,w,T,d,f))}function k(e,t,r,i,o){var s,l=i[X.compressedAttribute2],u=o.color,c=o.getPickId(t).color,h=o.sizeInMeters?1:0;e._allSizedInMeters=e._allSizedInMeters&&1===h;var d=0,p=o._imageIndex;if(-1!==p){var m=r[p];d=m.height}var f=e._textureAtlas.texture.dimensions,v=Math.ceil(.5*a(o.height,f.y*d));e._maxSize=Math.max(e._maxSize,v);var _=n.floatToByte(u.red),g=n.floatToByte(u.green),y=n.floatToByte(u.blue),C=_*ve+g*_e+y;_=n.floatToByte(c.red),g=n.floatToByte(c.green),y=n.floatToByte(c.blue);var E=_*ve+g*_e+y,S=n.floatToByte(u.alpha)*ve+n.floatToByte(c.alpha)*_e+h;e._instanced?(s=o._index,l(s,C,E,S,v)):(s=4*o._index,l(s+0,C,E,S,v),l(s+1,C,E,S,v),l(s+2,C,E,S,v),l(s+3,C,E,S,v))}function U(t,r,i,n,o){var a,s=n[X.eyeOffset],l=o.eyeOffset;if(t._maxEyeOffset=Math.max(t._maxEyeOffset,Math.abs(l.x),Math.abs(l.y),Math.abs(l.z)),t._instanced){var u=0,c=0,h=o._imageIndex;if(-1!==h){var d=i[h];u=d.width,c=d.height}me.x=u,me.y=c;var p=e.compressTextureCoordinates(me);a=o._index,s(a,l.x,l.y,l.z,p)}else a=4*o._index,s(a+0,l.x,l.y,l.z,0),s(a+1,l.x,l.y,l.z,0),s(a+2,l.x,l.y,l.z,0),s(a+3,l.x,l.y,l.z,0)}function G(e,t,r,i,n){var o,a=i[X.scaleByDistance],l=0,u=1,c=1,h=1,d=n.scaleByDistance;s(d)&&(l=d.near,u=d.nearValue,c=d.far,h=d.farValue,(1!==u||1!==h)&&(e._shaderScaleByDistance=!0)),e._instanced?(o=n._index,a(o,l,u,c,h)):(o=4*n._index,a(o+0,l,u,c,h),a(o+1,l,u,c,h),a(o+2,l,u,c,h),a(o+3,l,u,c,h))}function W(e,t,r,i,n){var o,a=i[X.pixelOffsetScaleByDistance],l=0,u=1,c=1,h=1,d=n.pixelOffsetScaleByDistance;s(d)&&(l=d.near,u=d.nearValue,c=d.far,h=d.farValue,(1!==u||1!==h)&&(e._shaderPixelOffsetScaleByDistance=!0)),e._instanced?(o=n._index,a(o,l,u,c,h)):(o=4*n._index,a(o+0,l,u,c,h),a(o+1,l,u,c,h),a(o+2,l,u,c,h),a(o+3,l,u,c,h))}function H(e,t,r,i,n){B(e,t,r,i,n),V(e,t,r,i,n),z(e,t,r,i,n),k(e,t,r,i,n),U(e,t,r,i,n),G(e,t,r,i,n),W(e,t,r,i,n)}function q(e,r,i,n,o,a){var l;n.mode===A.SCENE3D?(l=e._baseVolume,e._boundingVolumeDirty=!0):l=e._baseVolume2D;for(var u=[],c=0;i>c;++c){var h=r[c],d=h.position,p=T._computeActualPosition(h,d,n,o);s(p)&&(h._setActualPosition(p),a?u.push(p):t.expand(l,p,l))}a&&t.fromPoints(u,l)}function j(e,t){var r=t.mode,i=e._billboards,n=e._billboardsToUpdate,o=e._modelMatrix;e._createVertexArray||e._mode!==r||r!==A.SCENE3D&&!m.equals(o,e.modelMatrix)?(e._mode=r,m.clone(e.modelMatrix,o),e._createVertexArray=!0,(r===A.SCENE3D||r===A.SCENE2D||r===A.COLUMBUS_VIEW)&&q(e,i,i.length,t,o,!0)):r===A.MORPHING?q(e,i,i.length,t,o,!0):(r===A.SCENE2D||r===A.COLUMBUS_VIEW)&&q(e,n,e._billboardsToUpdateIndex,t,o,!1)}function Y(e,t,r){var i=1;e._allSizedInMeters&&0===e._maxPixelOffset||(i=t.camera.getPixelSize(r,t.context.drawingBufferWidth,t.context.drawingBufferHeight));var n=i*e._maxScale*e._maxSize*2;e._allHorizontalCenter&&e._allVerticalCenter&&(n*=.5);var o=i*e._maxPixelOffset+e._maxEyeOffset;r.radius+=n+o}var X,Z=T.SHOW_INDEX,K=T.POSITION_INDEX,Q=T.PIXEL_OFFSET_INDEX,J=T.EYE_OFFSET_INDEX,$=T.HORIZONTAL_ORIGIN_INDEX,ee=T.VERTICAL_ORIGIN_INDEX,te=T.SCALE_INDEX,re=T.IMAGE_INDEX_INDEX,ie=T.COLOR_INDEX,ne=T.ROTATION_INDEX,oe=T.ALIGNED_AXIS_INDEX,ae=T.SCALE_BY_DISTANCE_INDEX,se=T.TRANSLUCENCY_BY_DISTANCE_INDEX,le=T.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX,ue=T.NUMBER_OF_PROPERTIES,ce={positionHighAndScale:0,positionLowAndRotation:1,compressedAttribute0:2,compressedAttribute1:3,compressedAttribute2:4,eyeOffset:5,scaleByDistance:6,pixelOffsetScaleByDistance:7},he={direction:0,positionHighAndScale:1,positionLowAndRotation:2,compressedAttribute0:3,compressedAttribute1:4,compressedAttribute2:5,eyeOffset:6,scaleByDistance:7,pixelOffsetScaleByDistance:8};l(M.prototype,{length:{get:function(){return R(this),this._billboards.length}},textureAtlas:{get:function(){return this._textureAtlas},set:function(e){this._textureAtlas!==e&&(this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._textureAtlas=e,this._createVertexArray=!0)}},destroyTextureAtlas:{get:function(){return this._destroyTextureAtlas},set:function(e){this._destroyTextureAtlas=e}}}),M.prototype.add=function(e){var t=new T(e,this);return t._index=this._billboards.length,this._billboards.push(t),this._createVertexArray=!0,t},M.prototype.remove=function(e){return this.contains(e)?(this._billboards[e._index]=null,this._billboardsRemoved=!0,this._createVertexArray=!0,e._destroy(),!0):!1},M.prototype.removeAll=function(){D(this._billboards),this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!0},M.prototype._updateBillboard=function(e,t){e._dirty||(this._billboardsToUpdate[this._billboardsToUpdateIndex++]=e),++this._propertiesChanged[t]},M.prototype.contains=function(e){return s(e)&&e._billboardCollection===this},M.prototype.get=function(e){return R(this),this._billboards[e]};var de;M.prototype.computeNewBuffersUsage=function(){for(var e=this._buffersUsage,t=!1,r=this._propertiesChanged,i=0;ue>i;++i){var n=0===r[i]?v.STATIC_DRAW:v.STREAM_DRAW;t=t||e[i]!==n,e[i]=n}return t};var pe=new h,me=new r,fe=32768,ve=65536,_e=256,ge=128,ye=32,Ce=8,Ee=4,Se=1/256,we=0,Te=2,xe=3,be=1,Pe=[];return M.prototype.update=function(e){R(this);var r=this._billboards,i=r.length,n=e.context;this._instanced=n.instancedArrays,X=this._instanced?he:ce,de=this._instanced?N:O;var o=this._textureAtlas;if(!s(o)){o=this._textureAtlas=new I({context:n});for(var a=0;i>a;++a)r[a]._loadImage()}var l=o.textureCoordinates;if(0!==l.length){j(this,e),r=this._billboards,i=r.length;var u=this._billboardsToUpdate,c=this._billboardsToUpdateIndex,h=this._propertiesChanged,d=o.guid,p=this._createVertexArray||this._textureAtlasGUID!==d;this._textureAtlasGUID=d;var f,v=e.passes,E=v.pick;if(p||!E&&this.computeNewBuffersUsage()){this._createVertexArray=!1;for(var T=0;ue>T;++T)h[T]=0;if(this._vaf=this._vaf&&this._vaf.destroy(),i>0){this._vaf=F(n,i,this._buffersUsage,this._instanced),f=this._vaf.writers;for(var b=0;i>b;++b){var M=this._billboards[b];M._dirty=!1,H(this,n,l,f,M)}this._vaf.commit(de(n))}this._billboardsToUpdateIndex=0}else if(c>0){var D=Pe;D.length=0,(h[K]||h[ne]||h[te])&&D.push(B),(h[re]||h[Q]||h[$]||h[ee]||h[Z])&&(D.push(V),this._instanced&&D.push(U)),(h[re]||h[oe]||h[se])&&D.push(z),(h[re]||h[ie])&&D.push(k),h[J]&&D.push(U),h[ae]&&D.push(G),h[le]&&D.push(W);var L=D.length;if(f=this._vaf.writers,c/i>.1){for(var q=0;c>q;++q){var pe=u[q];pe._dirty=!1;for(var me=0;L>me;++me)D[me](this,n,l,f,pe)}this._vaf.commit(de(n))}else{for(var fe=0;c>fe;++fe){var ve=u[fe];ve._dirty=!1;for(var _e=0;L>_e;++_e)D[_e](this,n,l,f,ve);this._instanced?this._vaf.subCommit(ve._index,1):this._vaf.subCommit(4*ve._index,4)}this._vaf.endSubCommits()}this._billboardsToUpdateIndex=0}if(c>1.5*i&&(u.length=i),s(this._vaf)&&s(this._vaf.va)){this._boundingVolumeDirty&&(this._boundingVolumeDirty=!1,t.transform(this._baseVolume,this.modelMatrix,this._baseVolumeWC));var ge,ye=m.IDENTITY;e.mode===A.SCENE3D?(ye=this.modelMatrix,ge=t.clone(this._baseVolumeWC,this._boundingVolume)):ge=t.clone(this._baseVolume2D,this._boundingVolume),Y(this,e,ge);var Ce,Ee,Se,we,Te,xe,be=e.commandList;if(v.render){var Ae=this._colorCommands;for(s(this._rs)||(this._rs=g.fromCache({depthTest:{enabled:!0},blending:x.ALPHA_BLEND})),s(this._sp)&&this._shaderRotation===this._compiledShaderRotation&&this._shaderAlignedAxis===this._compiledShaderAlignedAxis&&this._shaderScaleByDistance===this._compiledShaderScaleByDistance&&this._shaderTranslucencyByDistance===this._compiledShaderTranslucencyByDistance&&this._shaderPixelOffsetScaleByDistance===this._compiledShaderPixelOffsetScaleByDistance||(we=new C({sources:[w]}),this._instanced&&we.defines.push("INSTANCED"),this._shaderRotation&&we.defines.push("ROTATION"),this._shaderAlignedAxis&&we.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&we.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&we.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&we.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),s(this._scene)&&we.defines.push("CLAMPED_TO_GROUND"),this._sp=y.replaceCache({context:n,shaderProgram:this._sp,vertexShaderSource:we,fragmentShaderSource:S,attributeLocations:X}),this._compiledShaderRotation=this._shaderRotation,this._compiledShaderAlignedAxis=this._shaderAlignedAxis,this._compiledShaderScaleByDistance=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistance=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistance=this._shaderPixelOffsetScaleByDistance),Ce=this._vaf.va,Ee=Ce.length,Ae.length=Ee,xe=0;Ee>xe;++xe)Se=Ae[xe],s(Se)||(Se=Ae[xe]=new _({pass:P.OPAQUE,owner:this})),Se.boundingVolume=ge,Se.modelMatrix=ye,Se.count=Ce[xe].indicesCount,Se.shaderProgram=this._sp,Se.uniformMap=this._uniforms,Se.vertexArray=Ce[xe].va,Se.renderState=this._rs,Se.debugShowBoundingVolume=this.debugShowBoundingVolume,this._instanced&&(Se.count=6,Se.instanceCount=i),be.push(Se)}if(E){var Ie=this._pickCommands;for(s(this._spPick)&&this._shaderRotation===this._compiledShaderRotationPick&&this._shaderAlignedAxis===this._compiledShaderAlignedAxisPick&&this._shaderScaleByDistance===this._compiledShaderScaleByDistancePick&&this._shaderTranslucencyByDistance===this._compiledShaderTranslucencyByDistancePick&&this._shaderPixelOffsetScaleByDistance===this._compiledShaderPixelOffsetScaleByDistancePick||(we=new C({defines:["RENDER_FOR_PICK"],sources:[w]}),this._instanced&&we.defines.push("INSTANCED"),this._shaderRotation&&we.defines.push("ROTATION"),this._shaderAlignedAxis&&we.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&we.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&we.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&we.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),s(this._scene)&&we.defines.push("CLAMPED_TO_GROUND"),Te=new C({defines:["RENDER_FOR_PICK"],sources:[S]}),this._spPick=y.replaceCache({context:n,shaderProgram:this._spPick,vertexShaderSource:we,fragmentShaderSource:Te,attributeLocations:X}),this._compiledShaderRotationPick=this._shaderRotation,this._compiledShaderAlignedAxisPick=this._shaderAlignedAxis,this._compiledShaderScaleByDistancePick=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistancePick=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistancePick=this._shaderPixelOffsetScaleByDistance),Ce=this._vaf.va,Ee=Ce.length,Ie.length=Ee,xe=0;Ee>xe;++xe)Se=Ie[xe],s(Se)||(Se=Ie[xe]=new _({pass:P.OPAQUE,owner:this})),Se.boundingVolume=ge,Se.modelMatrix=ye,Se.count=Ce[xe].indicesCount,Se.shaderProgram=this._spPick,Se.uniformMap=this._uniforms,Se.vertexArray=Ce[xe].va,Se.renderState=this._rs,this._instanced&&(Se.count=6,Se.instanceCount=i),be.push(Se)}}}},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){return this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._sp=this._sp&&this._sp.destroy(),this._spPick=this._spPick&&this._spPick.destroy(),this._vaf=this._vaf&&this._vaf.destroy(),D(this._billboards),u(this)},M}),r("DataSources/BoundingSphereState",["../Core/freezeObject"],function(e){"use strict";var t={DONE:0,PENDING:1,FAILED:2};return e(t)}),r("DataSources/Property",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Iso8601"],function(e,t,r,i,n){"use strict";function o(){i.throwInstantiationError()}return r(o.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError}}),o.prototype.getValue=i.throwInstantiationError,o.prototype.equals=i.throwInstantiationError,o.equals=function(e,r){return e===r||t(e)&&e.equals(r)},o.arrayEquals=function(e,r){if(e===r)return!0;if(!t(e)||!t(r)||e.length!==r.length)return!1;for(var i=e.length,n=0;i>n;n++)if(!o.equals(e[n],r[n]))return!1;return!0},o.isConstant=function(e){return!t(e)||e.isConstant},o.getValueOrUndefined=function(e,r,i){return t(e)?e.getValue(r,i):void 0},o.getValueOrDefault=function(r,i,n,o){return t(r)?e(r.getValue(i,o),n):n},o.getValueOrClonedDefault=function(e,r,i,n){var o;return t(e)&&(o=e.getValue(r,n)),t(o)||(o=i.clone(o)),o},o}),r("DataSources/BillboardVisualizer",["../Core/AssociativeArray","../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/BillboardCollection","../Scene/HorizontalOrigin","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function f(t,r){r.collectionChanged.addEventListener(f.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._billboardCollection=void 0,this._entityCollection=r,this._items=new e,this._onCollectionChanged(r,r.values,[],[])}function v(e,t){if(o(e)){var r=e.billboard;o(r)&&(e.textureValue=void 0,e.billboard=void 0,r.show=!1,r.image=void 0,t.push(r._index))}}var _=n.WHITE,g=i.ZERO,y=r.ZERO,C=1,E=0,S=i.ZERO,w=c.CENTER,T=h.CENTER,x=!1,b=new i,P=new n,A=new i,I=new r,M=new l,D=new l,R=new l,O=new t;return f.prototype.update=function(e){for(var t=this._items.values,r=this._unusedIndexes,i=0,n=t.length;n>i;i++){var a,s=t[i],l=s.entity,c=l._billboard,h=s.billboard,d=l.isShowing&&l.isAvailable(e)&&p.getValueOrDefault(c._show,e,!0);if(d&&(b=p.getValueOrUndefined(l._position,e,b),a=p.getValueOrUndefined(c._image,e),d=o(b)&&o(a)),d){if(!o(h)){var m=this._billboardCollection;o(m)||(m=new u,this._billboardCollection=m,this._scene.primitives.add(m));var f=r.length;h=f>0?m.get(r.pop()):m.add(),h.id=l,h.image=void 0,s.billboard=h}h.show=d,s.textureValue!==a&&(h.image=a,s.textureValue=a),h.position=b,h.color=p.getValueOrDefault(c._color,e,_,P),h.eyeOffset=p.getValueOrDefault(c._eyeOffset,e,g,A),h.pixelOffset=p.getValueOrDefault(c._pixelOffset,e,y,I),h.scale=p.getValueOrDefault(c._scale,e,C),h.rotation=p.getValueOrDefault(c._rotation,e,E),h.alignedAxis=p.getValueOrDefault(c._alignedAxis,e,S),h.horizontalOrigin=p.getValueOrDefault(c._horizontalOrigin,e,w),h.verticalOrigin=p.getValueOrDefault(c._verticalOrigin,e,T),h.width=p.getValueOrUndefined(c._width,e),h.height=p.getValueOrUndefined(c._height,e),h.scaleByDistance=p.getValueOrUndefined(c._scaleByDistance,e,M),h.translucencyByDistance=p.getValueOrUndefined(c._translucencyByDistance,e,D),h.pixelOffsetScaleByDistance=p.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,R),h.sizeInMeters=p.getValueOrDefault(c._sizeInMeters,x);var N=p.getValueOrUndefined(c._imageSubRegion,e,O);o(N)&&h.setImageSubRegion(h._imageId,N)}else v(s,r)}return!0},f.prototype.getBoundingSphere=function(e,t){var r=this._items.get(e.id);return o(r)&&o(r.billboard)?(t.center=i.clone(r.billboard.position,t.center),t.radius=0,d.DONE):d.FAILED},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(f.prototype._onCollectionChanged,this),o(this._billboardCollection)&&this._scene.primitives.remove(this._billboardCollection),a(this)},f.prototype._onCollectionChanged=function(e,t,r,i){var n,a,s=this._unusedIndexes,l=this._items;for(n=t.length-1;n>-1;n--)a=t[n],o(a._billboard)&&o(a._position)&&l.set(a.id,new m(a));for(n=i.length-1;n>-1;n--)a=i[n],o(a._billboard)&&o(a._position)?l.contains(a.id)||l.set(a.id,new m(a)):(v(l.get(a.id),s),l.remove(a.id));for(n=r.length-1;n>-1;n--)a=r[n],v(l.get(a.id),s),l.remove(a.id)},f}),r("Shaders/Appearances/AllMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_binormalEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/AllMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 binormal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_binormalEC = czm_normal * binormal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/BasicMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/BasicMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/TexturedMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);;\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/TexturedMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Scene/CullFace",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={FRONT:t.FRONT,BACK:t.BACK,FRONT_AND_BACK:t.FRONT_AND_BACK};return e(r)}),r("Scene/Appearance",["../Core/clone","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","./BlendingState","./CullFace"],function(e,t,r,i,n,o,a){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this.material=e.material,this.translucent=r(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=r(e.closed,!1)}return n(s.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),s.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),i(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},s.prototype.isTranslucent=function(){return i(this.material)&&this.material.isTranslucent()||!i(this.material)&&this.translucent},s.prototype.getRenderState=function(){var t=this.isTranslucent(),r=e(this.renderState,!1);return t?(r.depthMask=!1,r.blending=o.ALPHA_BLEND):r.depthMask=!0,r},s.getDefaultRenderState=function(e,r,n){var s={depthTest:{enabled:!0}};return e&&(s.depthMask=!1,s.blending=o.ALPHA_BLEND),r&&(s.cull={enabled:!0,face:a.BACK}),i(n)&&(s=t(n,s,!0)),s},s}),r("Renderer/CubeMapFace",["../Core/defaultValue","../Core/defineProperties","../Core/DeveloperError","./PixelDatatype"],function(e,t,r,i){"use strict";function n(e,t,r,i,n,o,a,s,l){this._gl=e,this._texture=t,this._textureTarget=r,this._targetFace=i,this._pixelFormat=n,this._pixelDatatype=o,this._size=a,this._preMultiplyAlpha=s,this._flipY=l}return t(n.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),n.prototype.copyFrom=function(t,r,i){r=e(r,0),i=e(i,0);var n=this._gl,o=this._textureTarget;n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,this._flipY),n.activeTexture(n.TEXTURE0),n.bindTexture(o,this._texture),t.arrayBufferView?n.texSubImage2D(this._targetFace,0,r,i,t.width,t.height,this._pixelFormat,this._pixelDatatype,t.arrayBufferView):n.texSubImage2D(this._targetFace,0,r,i,this._pixelFormat,this._pixelDatatype,t),n.bindTexture(o,null)},n.prototype.copyFromFramebuffer=function(t,r,i,n,o,a){t=e(t,0),r=e(r,0),i=e(i,0),n=e(n,0),o=e(o,this._size),a=e(a,this._size);var s=this._gl,l=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),s.copyTexSubImage2D(this._targetFace,0,t,r,i,n,o,a),s.bindTexture(l,null)},n}),r("Renderer/CubeMap",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/PixelFormat","./ContextLimits","./CubeMapFace","./MipmapHint","./PixelDatatype","./Sampler","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m){"use strict";function f(r){function i(e,t){t.arrayBufferView?g.texImage2D(e,0,m,p,p,0,m,f,t.arrayBufferView):g.texImage2D(e,0,m,m,f,t)}r=e(r,e.EMPTY_OBJECT);var n,o,s=r.context,u=r.source;if(t(u)){var d=[u.positiveX,u.negativeX,u.positiveY,u.negativeY,u.positiveZ,u.negativeZ];n=d[0].width,o=d[0].height}else n=r.width,o=r.height;var p=n,m=e(r.pixelFormat,a.RGBA),f=e(r.pixelDatatype,c.UNSIGNED_BYTE),v=r.preMultiplyAlpha||m===a.RGB||m===a.LUMINANCE,_=e(r.flipY,!0),g=s._gl,y=g.TEXTURE_CUBE_MAP,C=g.createTexture();g.activeTexture(g.TEXTURE0),g.bindTexture(y,C),t(u)?(g.pixelStorei(g.UNPACK_PREMULTIPLY_ALPHA_WEBGL,v),g.pixelStorei(g.UNPACK_FLIP_Y_WEBGL,_),i(g.TEXTURE_CUBE_MAP_POSITIVE_X,u.positiveX),i(g.TEXTURE_CUBE_MAP_NEGATIVE_X,u.negativeX),i(g.TEXTURE_CUBE_MAP_POSITIVE_Y,u.positiveY),i(g.TEXTURE_CUBE_MAP_NEGATIVE_Y,u.negativeY),i(g.TEXTURE_CUBE_MAP_POSITIVE_Z,u.positiveZ),i(g.TEXTURE_CUBE_MAP_NEGATIVE_Z,u.negativeZ)):(g.texImage2D(g.TEXTURE_CUBE_MAP_POSITIVE_X,0,m,p,p,0,m,f,null),g.texImage2D(g.TEXTURE_CUBE_MAP_NEGATIVE_X,0,m,p,p,0,m,f,null),g.texImage2D(g.TEXTURE_CUBE_MAP_POSITIVE_Y,0,m,p,p,0,m,f,null),g.texImage2D(g.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,m,p,p,0,m,f,null),g.texImage2D(g.TEXTURE_CUBE_MAP_POSITIVE_Z,0,m,p,p,0,m,f,null),g.texImage2D(g.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,m,p,p,0,m,f,null)),g.bindTexture(y,null),this._gl=g,this._textureFilterAnisotropic=s._textureFilterAnisotropic,this._textureTarget=y,this._texture=C,this._pixelFormat=m,this._pixelDatatype=f,this._size=p,this._preMultiplyAlpha=v,this._flipY=_,this._sampler=void 0,this._positiveX=new l(g,C,y,g.TEXTURE_CUBE_MAP_POSITIVE_X,m,f,p,v,_),this._negativeX=new l(g,C,y,g.TEXTURE_CUBE_MAP_NEGATIVE_X,m,f,p,v,_),this._positiveY=new l(g,C,y,g.TEXTURE_CUBE_MAP_POSITIVE_Y,m,f,p,v,_),this._negativeY=new l(g,C,y,g.TEXTURE_CUBE_MAP_NEGATIVE_Y,m,f,p,v,_),this._positiveZ=new l(g,C,y,g.TEXTURE_CUBE_MAP_POSITIVE_Z,m,f,p,v,_),this._negativeZ=new l(g,C,y,g.TEXTURE_CUBE_MAP_NEGATIVE_Z,m,f,p,v,_),this.sampler=new h}return r(f.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var r=e.minificationFilter,i=e.magnificationFilter,n=r===p.NEAREST_MIPMAP_NEAREST||r===p.NEAREST_MIPMAP_LINEAR||r===p.LINEAR_MIPMAP_NEAREST||r===p.LINEAR_MIPMAP_LINEAR;this._pixelDatatype===c.FLOAT&&(r=n?p.NEAREST_MIPMAP_NEAREST:p.NEAREST,i=d.NEAREST);var o=this._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),o.texParameteri(a,o.TEXTURE_MIN_FILTER,r),o.texParameteri(a,o.TEXTURE_MAG_FILTER,i),o.texParameteri(a,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(a,o.TEXTURE_WRAP_T,e.wrapT),t(this._textureFilterAnisotropic)&&o.texParameteri(a,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),
o.bindTexture(a,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),f.prototype.generateMipmap=function(t){t=e(t,u.DONT_CARE);var r=this._gl,i=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,t),r.activeTexture(r.TEXTURE0),r.bindTexture(i,this._texture),r.generateMipmap(i),r.bindTexture(i,null)},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){return this._gl.deleteTexture(this._texture),this._positiveX=i(this._positiveX),this._negativeX=i(this._negativeX),this._positiveY=i(this._positiveY),this._negativeY=i(this._negativeY),this._positiveZ=i(this._positiveZ),this._negativeZ=i(this._negativeZ),i(this)},f}),r("Shaders/Materials/BumpMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n"}),r("Shaders/Materials/CheckerboardMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/DotMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/FadeMaterial",[],function(){"use strict";return"uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/GridMaterial",[],function(){"use strict";return"#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_resolutionScale) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec3 halfColor = color.rgb * 0.5;\nmaterial.diffuse = halfColor;\nmaterial.emission = halfColor;\nmaterial.alpha = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nreturn material;\n}\n"}),r("Shaders/Materials/NormalMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineArrowMaterial",[],function(){"use strict";return"#extension GL_OES_standard_derivatives : enable\nuniform vec4 color;\nvarying float v_width;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0;\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineGlowMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform float glowPower;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nmaterial.emission = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nmaterial.alpha = clamp(0.0, 1.0, glow) * color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineOutlineMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Shaders/Materials/RimLightingMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nmaterial.diffuse = color.rgb;\nmaterial.emission = rimColor.rgb * s;\nmaterial.alpha = mix(color.a, rimColor.a, s);\nreturn material;\n}\n"}),r("Shaders/Materials/StripeMaterial",[],function(){"use strict";return"uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/Water",[],function(){"use strict";return"uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n"}),r("Scene/Material",["../Core/Cartesian2","../Core/clone","../Core/Color","../Core/combine","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/isArray","../Core/loadImage","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Renderer/CubeMap","../Renderer/Texture","../Shaders/Materials/BumpMapMaterial","../Shaders/Materials/CheckerboardMaterial","../Shaders/Materials/DotMaterial","../Shaders/Materials/FadeMaterial","../Shaders/Materials/GridMaterial","../Shaders/Materials/NormalMapMaterial","../Shaders/Materials/PolylineArrowMaterial","../Shaders/Materials/PolylineGlowMaterial","../Shaders/Materials/PolylineOutlineMaterial","../Shaders/Materials/RimLightingMaterial","../Shaders/Materials/StripeMaterial","../Shaders/Materials/Water","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I){"use strict";function M(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,D(e,this),s(this,{type:{value:this.type,writable:!1}}),a(M._uniformList[this.type])||(M._uniformList[this.type]=Object.keys(this._uniforms))}function D(e,r){e=o(e,o.EMPTY_OBJECT),r._strict=o(e.strict,!1),r._count=o(e.count,0),r._template=t(o(e.fabric,o.EMPTY_OBJECT)),r._template.uniforms=t(o(r._template.uniforms,o.EMPTY_OBJECT)),r._template.materials=t(o(r._template.materials,o.EMPTY_OBJECT)),r.type=a(r._template.type)?r._template.type:n(),r.shaderSource="",r.materials={},r.uniforms={},r._uniforms={},r._translucentFunctions=[];var s,l=M._materialCache.getMaterial(r.type);if(a(l)){var u=t(l.fabric,!0);r._template=i(r._template,u,!0),s=l.translucent}L(r),a(l)||M._materialCache.addMaterial(r.type,r),F(r),z(r),G(r);var c=0===r._translucentFunctions.length?!0:void 0;if(s=o(s,c),s=o(e.translucent,s),a(s))if("function"==typeof s){var h=function(){return s(r)};r._translucentFunctions.push(h)}else r._translucentFunctions.push(s)}function R(e,t,r,i){if(a(e))for(var n in e)if(e.hasOwnProperty(n)){var o=-1!==t.indexOf(n);(i&&!o||!i&&o)&&r(n,t)}}function O(e,t){for(var r="fabric: property name '"+e+"' is not valid. It should be ",i=0;i<t.length;i++){var n="'"+t[i]+"'";r+=i===t.length-1?"or "+n+".":n+", "}throw new u(r)}function N(e,t){var r="fabric: uniforms and materials cannot share the same property '"+e+"'";throw new u(r)}function L(e){var t=e._template,r=t.uniforms,i=t.materials,n=t.components;if(a(n)&&a(t.source))throw new u("fabric: cannot have source and components in the same template.");R(t,q,O,!0),R(n,j,O,!0);var o=[];for(var s in i)i.hasOwnProperty(s)&&o.push(s);R(r,o,N,!1)}function F(e){var t=e._template.components,r=e._template.source;if(a(r))e.shaderSource+=r+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",a(t))for(var i in t)t.hasOwnProperty(i)&&(e.shaderSource+="material."+i+" = "+t[i]+";\n");e.shaderSource+="return material;\n}\n"}}function B(e){var t;return function(r,i){var n=r.uniforms,o=n[e],s=t!==o;t=o;var l,u,c=r._textures[e];if(o instanceof HTMLVideoElement)if(o.readyState>=2){if(s&&a(c)&&(c!==i.defaultTexture&&c.destroy(),c=void 0),!a(c)||c===i.defaultTexture)return c=new v({context:i,source:o}),void(r._textures[e]=c);c.copyFrom(o)}else a(c)||(r._textures[e]=i.defaultTexture);else{if(o instanceof v&&o!==c){r._texturePaths[e]=void 0;var d=r._textures[e];return d!==r._defaultTexture&&d.destroy(),r._textures[e]=o,l=e+"Dimensions",void(n.hasOwnProperty(l)&&(u=n[l],u.x=o._width,u.y=o._height))}a(c)||(r._texturePaths[e]=void 0,a(r._defaultTexture)||(r._defaultTexture=i.defaultTexture),c=r._textures[e]=r._defaultTexture,l=e+"Dimensions",n.hasOwnProperty(l)&&(u=n[l],u.x=c._width,u.y=c._height)),o!==M.DefaultImageId&&o!==r._texturePaths[e]&&("string"==typeof o?I(h(o),function(t){r._loadedImages.push({id:e,image:t})}):o instanceof HTMLCanvasElement&&r._loadedImages.push({id:e,image:o}),r._texturePaths[e]=o)}}}function V(e){return function(t,r){var i=t.uniforms[e];if(i instanceof f){var n=t._textures[e];return n!==t._defaultTexture&&n.destroy(),t._texturePaths[e]=void 0,void(t._textures[e]=i)}if(a(t._textures[e])||(t._texturePaths[e]=void 0,t._textures[e]=r.defaultCubeMap),i!==M.DefaultCubeMapId){var o=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ;if(o!==t._texturePaths[e]){var s=[h(i.positiveX),h(i.negativeX),h(i.positiveY),h(i.negativeY),h(i.positiveZ),h(i.negativeZ)];I.all(s).then(function(r){t._loadedCubeMaps.push({id:e,images:r})}),t._texturePaths[e]=o}}}}function z(e){var t=e._template.uniforms;for(var r in t)t.hasOwnProperty(r)&&k(e,r)}function k(e,t){var r=e._strict,i=e._template.uniforms,n=i[t],o=U(n);if(!a(o))throw new u("fabric: uniform '"+t+"' has invalid type.");if("channels"===o){if(0===W(e,t,n,!1)&&r)throw new u("strict: shader source does not use channels '"+t+"'.")}else{if("sampler2D"===o){var s=t+"Dimensions";H(e,s)>0&&(i[s]={type:"ivec3",x:1,y:1},k(e,s))}var l=new RegExp("uniform\\s+"+o+"\\s+"+t+"\\s*;");if(!l.test(e.shaderSource)){var c="uniform "+o+" "+t+";";e.shaderSource=c+e.shaderSource}var h=t+"_"+e._count++;if(1===W(e,t,h)&&r)throw new u("strict: shader source does not use uniform '"+t+"'.");if(e.uniforms[t]=n,"sampler2D"===o)e._uniforms[h]=function(){return e._textures[t]},e._updateFunctions.push(B(t));else if("samplerCube"===o)e._uniforms[h]=function(){return e._textures[t]},e._updateFunctions.push(V(t));else if(-1!==o.indexOf("mat")){var d=new Y[o];e._uniforms[h]=function(){return Y[o].fromColumnMajorArray(e.uniforms[t],d)}}else e._uniforms[h]=function(){return e.uniforms[t]}}}function U(e){var t=e.type;if(!a(t)){var r=typeof e;if("number"===r)t="float";else if("boolean"===r)t="bool";else if("string"===r||e instanceof HTMLCanvasElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===M.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===r)if(c(e))(4===e.length||9===e.length||16===e.length)&&(t="mat"+Math.sqrt(e.length));else{var i=0;for(var n in e)e.hasOwnProperty(n)&&(i+=1);i>=2&&4>=i?t="vec"+i:6===i&&(t="samplerCube")}}return t}function G(e){var t=e._strict,r=e._template.materials;for(var n in r)if(r.hasOwnProperty(n)){var o=new M({strict:t,fabric:r[n],count:e._count});e._count=o._count,e._uniforms=i(e._uniforms,o._uniforms,!0),e.materials[n]=o,e._translucentFunctions=e._translucentFunctions.concat(o._translucentFunctions);var a="czm_getMaterial",s=a+"_"+e._count++;W(o,a,s),e.shaderSource=o.shaderSource+e.shaderSource;var l=s+"(materialInput)";if(0===W(e,n,l)&&t)throw new u("strict: shader source does not use material '"+n+"'.")}}function W(e,t,r,i){i=o(i,!0);var n=0,a="([\\w])?",s="([\\w"+(i?".":"")+"])?",l=new RegExp(s+t+a,"g");return e.shaderSource=e.shaderSource.replace(l,function(e,t,i){return t||i?e:(n+=1,r)}),n}function H(e,t,r){return W(e,t,t,r)}M._uniformList={},M.fromType=function(e,t){var r=new M({fabric:{type:e}});if(a(t))for(var i in t)t.hasOwnProperty(i)&&(r.uniforms[i]=t[i]);return r},M.prototype.isTranslucent=function(){if(a(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,r=t.length,i=0;r>i;++i){var n=t[i];if(e="function"==typeof n?e&&n():e&&n,!e)break}return e},M.prototype.update=function(e){var t,r,i=this._loadedImages,n=i.length;for(t=0;n>t;++t){var o=i[t];r=o.id;var a=o.image,s=new v({context:e,source:a});this._textures[r]=s;var l=r+"Dimensions";if(this.uniforms.hasOwnProperty(l)){var u=this.uniforms[l];u.x=s._width,u.y=s._height}}i.length=0;var c=this._loadedCubeMaps;for(n=c.length,t=0;n>t;++t){var h=c[t];r=h.id;var d=h.images,p=new f({context:e,source:{positiveX:d[0],negativeX:d[1],positiveY:d[2],negativeY:d[3],positiveZ:d[4],negativeZ:d[5]}});this._textures[r]=p}c.length=0;var m=this._updateFunctions;for(n=m.length,t=0;n>t;++t)m[t](this,e);var _=this.materials;for(var g in _)_.hasOwnProperty(g)&&_[g].update(e)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._textures;for(var t in e)if(e.hasOwnProperty(t)){var r=e[t];r!==this._defaultTexture&&r.destroy()}var i=this.materials;for(var n in i)i.hasOwnProperty(n)&&i[n].destroy();return l(this)};var q=["type","materials","uniforms","components","source"],j=["diffuse","specular","shininess","normal","emission","alpha"],Y={mat2:d,mat3:p,mat4:m};return M._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},M.DefaultImageId="czm_defaultImage",M.DefaultCubeMapId="czm_defaultCubeMap",M.ColorType="Color",M._materialCache.addMaterial(M.ColorType,{fabric:{type:M.ColorType,uniforms:{color:new r(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),M.ImageType="Image",M._materialCache.addMaterial(M.ImageType,{fabric:{type:M.ImageType,uniforms:{image:M.DefaultImageId,repeat:new e(1,1),alpha:1},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * alpha"}},translucent:function(e){return e.uniforms.alpha<1}}),M.DiffuseMapType="DiffuseMap",M._materialCache.addMaterial(M.DiffuseMapType,{fabric:{type:M.DiffuseMapType,uniforms:{image:M.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),M.AlphaMapType="AlphaMap",M._materialCache.addMaterial(M.AlphaMapType,{fabric:{type:M.AlphaMapType,uniforms:{image:M.DefaultImageId,channel:"a",repeat:new e(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),M.SpecularMapType="SpecularMap",M._materialCache.addMaterial(M.SpecularMapType,{fabric:{type:M.SpecularMapType,uniforms:{image:M.DefaultImageId,channel:"r",repeat:new e(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),M.EmissionMapType="EmissionMap",M._materialCache.addMaterial(M.EmissionMapType,{fabric:{type:M.EmissionMapType,uniforms:{image:M.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),M.BumpMapType="BumpMap",M._materialCache.addMaterial(M.BumpMapType,{fabric:{type:M.BumpMapType,uniforms:{image:M.DefaultImageId,channel:"r",strength:.8,repeat:new e(1,1)},source:_},translucent:!1}),M.NormalMapType="NormalMap",M._materialCache.addMaterial(M.NormalMapType,{fabric:{type:M.NormalMapType,uniforms:{image:M.DefaultImageId,channels:"rgb",strength:.8,repeat:new e(1,1)},source:S},translucent:!1}),M.GridType="Grid",M._materialCache.addMaterial(M.GridType,{fabric:{type:M.GridType,uniforms:{color:new r(0,1,0,1),cellAlpha:.1,lineCount:new e(8,8),lineThickness:new e(1,1),lineOffset:new e(0,0)},source:E},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),M.StripeType="Stripe",M._materialCache.addMaterial(M.StripeType,{fabric:{type:M.StripeType,uniforms:{horizontal:!0,evenColor:new r(1,1,1,.5),oddColor:new r(0,0,1,.5),offset:0,repeat:5},source:P},translucent:function(e){var t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<0}}),M.CheckerboardType="Checkerboard",M._materialCache.addMaterial(M.CheckerboardType,{fabric:{type:M.CheckerboardType,uniforms:{lightColor:new r(1,1,1,.5),darkColor:new r(0,0,0,.5),repeat:new e(5,5)},source:g},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),M.DotType="Dot",M._materialCache.addMaterial(M.DotType,{fabric:{type:M.DotType,uniforms:{lightColor:new r(1,1,0,.75),darkColor:new r(0,1,1,.75),repeat:new e(5,5)},source:y},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),M.WaterType="Water",M._materialCache.addMaterial(M.WaterType,{fabric:{type:M.WaterType,uniforms:{baseWaterColor:new r(.2,.3,.6,1),blendColor:new r(0,1,.699,1),specularMap:M.DefaultImageId,normalMap:M.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:A},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<0}}),M.RimLightingType="RimLighting",M._materialCache.addMaterial(M.RimLightingType,{fabric:{type:M.RimLightingType,uniforms:{color:new r(1,0,0,.7),rimColor:new r(1,1,1,.4),width:.3},source:b},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<0}}),M.FadeType="Fade",M._materialCache.addMaterial(M.FadeType,{fabric:{type:M.FadeType,uniforms:{fadeInColor:new r(1,0,0,1),fadeOutColor:new r(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new e(.5,.5)},source:C},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<0}}),M.PolylineArrowType="PolylineArrow",M._materialCache.addMaterial(M.PolylineArrowType,{fabric:{type:M.PolylineArrowType,uniforms:{color:new r(1,1,1,1)},source:w},translucent:!0}),M.PolylineGlowType="PolylineGlow",M._materialCache.addMaterial(M.PolylineGlowType,{fabric:{type:M.PolylineGlowType,uniforms:{color:new r(0,.5,1,1),glowPower:.25},source:T},translucent:!0}),M.PolylineOutlineType="PolylineOutline",M._materialCache.addMaterial(M.PolylineOutlineType,{fabric:{type:M.PolylineOutlineType,uniforms:{color:new r(1,1,1,1),outlineColor:new r(1,0,0,1),outlineWidth:1},source:x},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),M}),r("Scene/MaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/freezeObject","../Core/VertexFormat","../Shaders/Appearances/AllMaterialAppearanceFS","../Shaders/Appearances/AllMaterialAppearanceVS","../Shaders/Appearances/BasicMaterialAppearanceFS","../Shaders/Appearances/BasicMaterialAppearanceVS","../Shaders/Appearances/TexturedMaterialAppearanceFS","../Shaders/Appearances/TexturedMaterialAppearanceVS","./Appearance","./Material"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.translucent,!0),n=e(r.closed,!1),o=e(r.materialSupport,p.MaterialSupport.TEXTURED);this.material=t(r.material)?r.material:d.fromType(d.ColorType),this.translucent=i,this._vertexShaderSource=e(r.vertexShaderSource,o.vertexShaderSource),this._fragmentShaderSource=e(r.fragmentShaderSource,o.fragmentShaderSource),this._renderState=h.getDefaultRenderState(i,n,r.renderState),this._closed=n,this._materialSupport=o,this._vertexFormat=o.vertexFormat,this._flat=e(r.flat,!1),this._faceForward=e(r.faceForward,!n)}return r(p.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),p.prototype.getFragmentShaderSource=h.prototype.getFragmentShaderSource,p.prototype.isTranslucent=h.prototype.isTranslucent,p.prototype.getRenderState=h.prototype.getRenderState,p.MaterialSupport={BASIC:i({vertexFormat:n.POSITION_AND_NORMAL,vertexShaderSource:l,fragmentShaderSource:s}),TEXTURED:i({vertexFormat:n.POSITION_NORMAL_AND_ST,vertexShaderSource:c,fragmentShaderSource:u}),ALL:i({vertexFormat:n.ALL,vertexShaderSource:a,fragmentShaderSource:o})},p}),r("Shaders/Appearances/PerInstanceColorAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = v_color.rgb;\nmaterial.alpha = v_color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n}\n"}),r("Shaders/Appearances/PerInstanceColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceFS",[],function(){"use strict";return"varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = v_color;\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Scene/PerInstanceColorAppearance",["../Core/defaultValue","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PerInstanceColorAppearanceFS","../Shaders/Appearances/PerInstanceColorAppearanceVS","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/Appearances/PerInstanceFlatColorAppearanceVS","./Appearance"],function(e,t,r,i,n,o,a,s){"use strict";function l(t){t=e(t,e.EMPTY_OBJECT);var r=e(t.translucent,!0),u=e(t.closed,!1),c=e(t.flat,!1),h=c?a:n,d=c?o:i,p=c?l.FLAT_VERTEX_FORMAT:l.VERTEX_FORMAT;this.material=void 0,this.translucent=r,this._vertexShaderSource=e(t.vertexShaderSource,h),this._fragmentShaderSource=e(t.fragmentShaderSource,d),this._renderState=s.getDefaultRenderState(r,u,t.renderState),this._closed=u,this._vertexFormat=p,this._flat=c,this._faceForward=e(t.faceForward,!u)}return t(l.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),l.VERTEX_FORMAT=r.POSITION_AND_NORMAL,l.FLAT_VERTEX_FORMAT=r.POSITION_ONLY,l.prototype.getFragmentShaderSource=s.prototype.getFragmentShaderSource,l.prototype.isTranslucent=s.prototype.isTranslucent,l.prototype.getRenderState=s.prototype.getRenderState,l}),r("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f){"use strict";function v(e,t,r){var i,n=!r,o=e.length;if(!n&&o>1){var a=e[0].modelMatrix;for(i=1;o>i;++i)if(!m.equals(a,e[i].modelMatrix)){n=!0;break}}if(n)for(i=0;o>i;++i)d.transformToWorldCoordinates(e[i]);else m.multiplyTransformation(t,e[0].modelMatrix,t);
}function _(e,i){var n=e.attributes,o=n.position,a=4*(o.values.length/o.componentsPerAttribute);n.pickColor=new c({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var s=t.floatToByte(i.red),l=t.floatToByte(i.green),u=t.floatToByte(i.blue),h=t.floatToByte(i.alpha),d=n.pickColor.values,p=0;a>p;p+=4)d[p]=s,d[p+1]=l,d[p+2]=u,d[p+3]=h}function g(e,t){for(var r=e.length,i=0;r>i;++i){var o=e[i],a=t[i];n(o.geometry)?_(o.geometry,a):(_(o.westHemisphereGeometry,a),_(o.eastHemisphereGeometry,a))}}function y(e){var t,r=e.length,i=[],o=e[0].attributes;for(t in o)if(o.hasOwnProperty(t)){for(var a=o[t],s=!0,l=1;r>l;++l){var u=e[l].attributes[t];if(!n(u)||a.componentDatatype!==u.componentDatatype||a.componentsPerAttribute!==u.componentsPerAttribute||a.normalize!==u.normalize){s=!1;break}}s&&i.push(t)}return i}function C(e,t,i){for(var n=u.computeNumberOfVertices(t),o=i.length,a=0;o>a;++a){for(var s=i[a],l=e[s],h=l.componentDatatype,d=l.value,p=d.length,m=r.createTypedArray(h,n*p),f=0;n>f;++f)m.set(d,f*p);t.attributes[s]=new c({componentDatatype:h,componentsPerAttribute:p,normalize:l.normalize,values:m})}}function E(e,t){for(var r=e.length,i=0;r>i;++i){var o=e[i],a=o.attributes;n(o.geometry)?C(a,o.geometry,t):(C(a,o.westHemisphereGeometry,t),C(a,o.eastHemisphereGeometry,t))}}function S(t){var i,o,a=t.instances,s=t.pickIds,l=t.projection,u=t.elementIndexUintSupported,c=t.scene3DOnly,h=t.allowPicking,p=t.vertexCacheOptimize,m=t.compressVertices,f=t.modelMatrix,_=a.length;a[0].geometry.primitiveType;if(v(a,f,c),!c)for(i=0;_>i;++i)d.splitLongitude(a[i]);h&&g(a,s);var C=y(a);if(E(a,C),p)for(i=0;_>i;++i){var S=a[i];n(S.geometry)?(d.reorderForPostVertexCache(S.geometry),d.reorderForPreVertexCache(S.geometry)):(d.reorderForPostVertexCache(S.westHemisphereGeometry),d.reorderForPreVertexCache(S.westHemisphereGeometry),d.reorderForPostVertexCache(S.eastHemisphereGeometry),d.reorderForPreVertexCache(S.eastHemisphereGeometry))}var w=d.combineInstances(a);for(_=w.length,i=0;_>i;++i){o=w[i];var T,x=o.attributes;if(c)for(T in x)x.hasOwnProperty(T)&&x[T].componentDatatype===r.DOUBLE&&d.encodeAttribute(o,T,T+"3DHigh",T+"3DLow");else for(T in x)if(x.hasOwnProperty(T)&&x[T].componentDatatype===r.DOUBLE){var b=T+"3D",P=T+"2D";d.projectTo2D(o,T,b,P,l),n(o.boundingSphere)&&"position"===T&&(o.boundingSphereCV=e.fromVertices(o.attributes.position2D.values)),d.encodeAttribute(o,b,b+"High",b+"Low"),d.encodeAttribute(o,P,P+"High",P+"Low")}m&&d.compressVertices(o)}if(!u){var A=[];for(_=w.length,i=0;_>i;++i)o=w[i],A=A.concat(d.fitToUnsignedShortIndices(o));w=A}return w}function w(e,t,i){for(var n=[],o=e.attributes,a=i.length,s=0;a>s;++s){var l=i[s],u=o[l],c=u.componentDatatype;c===r.DOUBLE&&(c=r.FLOAT);var h=r.createTypedArray(c,u.values);n.push({index:t[l],componentDatatype:c,componentsPerAttribute:u.componentsPerAttribute,normalize:u.normalize,values:h}),delete o[l]}return n}function T(e,t,r,o,a,s,l,c,h){var d=u.computeNumberOfVertices(t);n(l[e])||(l[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var p=o.length,m=0;p>m;++m)for(var f=o[m],v=a[f],_=d;_>0;){for(var g,y=i(h[f],0),C=s[y],E=C.length,S=0;E>S&&(g=C[S],g.index!==v);++S);n(l[e][f])||(l[e][f]={dirty:!1,valid:!0,value:r[f].value,indices:[]});var w,T=g.values.length/g.componentsPerAttribute,x=i(c[f],0);T>x+_?(w=_,l[e][f].indices.push({attribute:g,offset:x,count:w}),c[f]=x+_):(w=T-x,l[e][f].indices.push({attribute:g,offset:x,count:w}),c[f]=0,h[f]=y+1),_-=w}}function x(e,t,r,i,o){var a,s,l,u=[],c=e.length,h={},d={};for(a=0;c>a;++a)s=e[a],l=s.attributes,n(s.geometry)&&T(a,s.geometry,l,o,i,r,u,h,d);for(a=0;c>a;++a)s=e[a],l=s.attributes,n(s.westHemisphereGeometry)&&T(a,s.westHemisphereGeometry,l,o,i,r,u,h,d);for(a=0;c>a;++a)s=e[a],l=s.attributes,n(s.eastHemisphereGeometry)&&T(a,s.eastHemisphereGeometry,l,o,i,r,u,h,d);for(c=t.length,a=0;c>a;++a){s=t[a],l=s.attributes;var p={};u.push(p);for(var m=o.length,f=0;m>f;++f){var v=o[f];p[v]={dirty:!1,valid:!1,value:l[v].value,indices:[]}}}return u}function b(e,t){var r=e.attributes;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n(o)&&n(o.values)&&t.push(o.values.buffer)}n(e.indices)&&t.push(e.indices.buffer)}function P(e,t){for(var r=e.length,i=0;r>i;++i)b(e[i],t)}function A(e,t){for(var r=e.length,i=0;r>i;++i)for(var n=e[i],o=n.length,a=0;o>a;++a)t.push(n[a].values.buffer)}function I(t){for(var r=1,i=t.length,o=0;i>o;o++){var a=t[o];if(++r,n(a)){var s=a.attributes;r+=6+2*e.packedLength+(n(a.indices)?a.indices.length:0);for(var l in s)if(s.hasOwnProperty(l)&&n(s[l])){var u=s[l];r+=5+u.values.length}}}return r}function M(e,t){for(var r=e.length,i=new Uint32Array(e.length),n=0;r>n;++n)i[n]=e[n].toRgba();return t.push(i.buffer),i}function D(e){for(var r=e.length,i=new Array(r),n=0;r>n;n++)i[n]=t.fromRgba(e[n]);return i}function R(e){for(var t=e.length,r=1+17*t,i=0;t>i;i++){var o=e[i].attributes;for(var a in o)if(o.hasOwnProperty(a)&&n(o[a])){var s=o[a];r+=5+s.value.length}}return r}function O(e,t){var r=new Float64Array(R(e)),i={},o=[],a=e.length,s=0;r[s++]=a;for(var l=0;a>l;l++){var u=e[l];m.pack(u.modelMatrix,r,s),s+=m.packedLength;var c=u.attributes,h=[];for(var d in c)c.hasOwnProperty(d)&&n(c[d])&&(h.push(d),n(i[d])||(i[d]=o.length,o.push(d)));r[s++]=h.length;for(var p=0;p<h.length;p++){var f=h[p],v=c[f];r[s++]=i[f],r[s++]=v.componentDatatype,r[s++]=v.componentsPerAttribute,r[s++]=v.normalize,r[s++]=v.value.length,r.set(v.value,s),s+=v.value.length}}return t.push(r.buffer),{stringTable:o,packedData:r}}function N(e){for(var t=e.packedData,i=e.stringTable,n=new Array(t[0]),o=0,a=1;a<t.length;){var s=m.unpack(t,a);a+=m.packedLength;for(var l={},u=t[a++],c=0;u>c;c++){for(var h=i[t[a++]],d=t[a++],p=t[a++],f=0!==t[a++],v=t[a++],_=r.createTypedArray(d,v),g=0;v>g;g++)_[g]=t[a++];l[h]={componentDatatype:d,componentsPerAttribute:p,normalize:f,value:_}}n[o++]={attributes:l,modelMatrix:s}}return n}function L(t){for(var r=t.length,i=1+r,o=0;r>o;o++){var a=t[o];i+=2,i+=n(a.boundingSphere)?e.packedLength:0,i+=n(a.boundingSphereCV)?e.packedLength:0;for(var s in a)if(a.hasOwnProperty(s)&&n(a[s])&&"boundingSphere"!==s&&"boundingSphereCV"!==s){var l=a[s];i+=4+3*l.indices.length+l.value.length}}return i}function F(t,r){var i=new Float64Array(L(t)),o=[],a=[],s={},l=t.length,u=0;i[u++]=l;for(var c=0;l>c;c++){var h=t[c],d=h.boundingSphere,p=n(d);i[u++]=p?1:0,p&&(e.pack(d,i,u),u+=e.packedLength),d=h.boundingSphereCV,p=n(d),i[u++]=p?1:0,p&&(e.pack(d,i,u),u+=e.packedLength);var m=[];for(var f in h)h.hasOwnProperty(f)&&n(h[f])&&"boundingSphere"!==f&&"boundingSphereCV"!==f&&(m.push(f),n(s[f])||(s[f]=o.length,o.push(f)));i[u++]=m.length;for(var v=0;v<m.length;v++){var _=m[v],g=h[_];i[u++]=s[_],i[u++]=g.valid?1:0;var y=g.indices,C=y.length;i[u++]=C;for(var E=0;C>E;E++){var S=y[E];i[u++]=S.count,i[u++]=S.offset;var w=a.indexOf(S.attribute);-1===w&&(w=a.length,a.push(S.attribute)),i[u++]=w}i[u++]=g.value.length,i.set(g.value,u),u+=g.value.length}}return r.push(i.buffer),{stringTable:o,packedData:i,attributeTable:a}}function B(t,i){for(var n=t.stringTable,o=t.attributeTable,a=t.packedData,s=new Array(a[0]),l=0,u=1,c=a.length;c>u;){var h={},d=1===a[u++];d&&(h.boundingSphere=e.unpack(a,u),u+=e.packedLength),d=1===a[u++],d&&(h.boundingSphereCV=e.unpack(a,u),u+=e.packedLength);for(var p=a[u++],m=0;p>m;m++){for(var f=n[a[u++]],v=1===a[u++],_=a[u++],g=_>0?new Array(_):void 0,y=0;_>y;y++){var C={};C.count=a[u++],C.offset=a[u++],C.attribute=o[a[u++]],g[y]=C}for(var E=a[u++],S=v?r.createTypedArray(g[0].attribute.componentDatatype,E):new Array(E),w=0;E>w;w++)S[w]=a[u++];h[f]={dirty:!1,valid:v,indices:g,value:S}}s[l++]=h}return s}if(!s.supportsTypedArrays())return{};var V={};return V.combineGeometry=function(e){var t,r,i,o,a,s=e.instances,l=e.invalidInstances;if(s.length>0){t=S(e),r=d.createAttributeLocations(t[0]),o=y(s),i=[],a=t.length;for(var u=0;a>u;++u){var c=t[u];i.push(w(c,r,o))}}o=n(o)?o:y(l);var h=x(s,l,i,r,o);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,vaAttributes:i,vaAttributeLocations:h,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},V.packCreateGeometryResults=function(t,r){var i=new Float64Array(I(t)),o=[],a={},s=t.length,l=0;i[l++]=s;for(var u=0;s>u;u++){var c=t[u],h=n(c);if(i[l++]=h?1:0,h){i[l++]=c.primitiveType,i[l++]=c.geometryType;var d=n(c.boundingSphere)?1:0;i[l++]=d,d&&e.pack(c.boundingSphere,i,l),l+=e.packedLength;var p=n(c.boundingSphereCV)?1:0;i[l++]=p,p&&e.pack(c.boundingSphereCV,i,l),l+=e.packedLength;var m=c.attributes,f=[];for(var v in m)m.hasOwnProperty(v)&&n(m[v])&&(f.push(v),n(a[v])||(a[v]=o.length,o.push(v)));i[l++]=f.length;for(var _=0;_<f.length;_++){var g=f[_],y=m[g];i[l++]=a[g],i[l++]=y.componentDatatype,i[l++]=y.componentsPerAttribute,i[l++]=y.normalize?1:0,i[l++]=y.values.length,i.set(y.values,l),l+=y.values.length}var C=n(c.indices)?c.indices.length:0;i[l++]=C,C>0&&(i.set(c.indices,l),l+=C)}}return r.push(i.buffer),{stringTable:o,packedData:i}},V.unpackCreateGeometryResults=function(t){for(var i,n=t.stringTable,o=t.packedData,a=new Array(o[0]),s=0,l=1;l<o.length;){var d=1===o[l++];if(d){var m,f,v=o[l++],_=o[l++],g=1===o[l++];g&&(m=e.unpack(o,l)),l+=e.packedLength;var y=1===o[l++];y&&(f=e.unpack(o,l)),l+=e.packedLength;var C,E,S,w=new h,T=o[l++];for(i=0;T>i;i++){var x=n[o[l++]],b=o[l++];S=o[l++];var P=0!==o[l++];C=o[l++],E=r.createTypedArray(b,C);for(var A=0;C>A;A++)E[A]=o[l++];w[x]=new c({componentDatatype:b,componentsPerAttribute:S,normalize:P,values:E})}var I;if(C=o[l++],C>0){var M=E.length/S;for(I=p.createTypedArray(M,C),i=0;C>i;i++)I[i]=o[l++]}a[s++]=new u({primitiveType:v,geometryType:_,boundingSphere:m,indices:I,attributes:w})}else a[s++]=void 0}return a},V.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,i=r.length,n=0;i>n;n++)t.push(r[n].packedData.buffer);var o;return e.allowPicking&&(o=M(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:O(e.instances,t),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof l,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},V.unpackCombineGeometryParameters=function(e){for(var t=N(e.packedInstances),r=e.allowPicking,i=r?D(e.packedPickIds):void 0,o=e.createGeometryResults,s=o.length,u=0,c=[],h=[],d=[],p=[],v=[],_=0;s>_;_++)for(var g=V.unpackCreateGeometryResults(o[_]),y=g.length,C=0;y>C;C++){var E=g[C],S=t[u];n(E)?(S.geometry=E,c.push(S),d.push(u),r&&v.push(i[u])):(h.push(S),p.push(u)),++u}var w=a.clone(e.ellipsoid),T=e.isGeographic?new l(w):new f(w);return{instances:c,invalidInstances:h,validInstancesIndices:d,invalidInstancesIndices:p,pickIds:v,ellipsoid:w,projection:T,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:m.clone(e.modelMatrix)}},V.packCombineGeometryResults=function(e,t){return n(e.geometries)&&(P(e.geometries,t),A(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:F(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},V.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:B(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},V}),r("Scene/PrimitiveState",["../Core/freezeObject"],function(e){"use strict";var t={READY:0,CREATING:1,CREATED:2,COMBINING:3,COMBINED:4,COMPLETE:5,FAILED:6};return e(t)}),r("Scene/Primitive",["../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/clone","../Core/combine","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryInstance","../Core/GeometryInstanceAttribute","../Core/isArray","../Core/Matrix4","../Core/subdivideArray","../Core/TaskProcessor","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArray","../ThirdParty/when","./CullFace","./Pass","./PrimitivePipeline","./PrimitiveState","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I,M,D,R,O){"use strict";function N(e){e=a(e,a.EMPTY_OBJECT),this.geometryInstances=e.geometryInstances,this.appearance=e.appearance,this._appearance=void 0,this._material=void 0,this.modelMatrix=g.clone(a(e.modelMatrix,g.IDENTITY)),this._modelMatrix=new g,this.show=a(e.show,!0),this._vertexCacheOptimize=a(e.vertexCacheOptimize,!1),this._interleave=a(e.interleave,!1),this._releaseGeometryInstances=a(e.releaseGeometryInstances,!0),this._allowPicking=a(e.allowPicking,!0),this._asynchronous=a(e.asynchronous,!0),this._compressVertices=a(e.compressVertices,!0),this.cull=a(e.cull,!0),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this.rtcCenter=e.rtcCenter,this._modifiedModelView=new g,this._translucent=void 0,this._state=R.READY,this._geometries=[],this._vaAttributes=void 0,this._error=void 0,this._numberOfInstances=0,this._validModelMatrix=!1,this._boundingSpheres=[],this._boundingSphereWC=[],this._boundingSphereCV=[],this._boundingSphere2D=[],this._boundingSphereMorph=[],this._perInstanceAttributeLocations=void 0,this._perInstanceAttributeCache=[],this._instanceIds=[],this._lastPerInstanceAttributeIndex=0,this._dirtyAttributes=[],this._va=[],this._attributeLocations=void 0,this._primitiveType=void 0,this._frontFaceRS=void 0,this._backFaceRS=void 0,this._sp=void 0,this._pickRS=void 0,this._pickSP=void 0,this._pickIds=[],this._colorCommands=[],this._pickCommands=[],this._createBoundingVolumeFunction=e._createBoundingVolumeFunction,this._createRenderStatesFunction=e._createRenderStatesFunction,this._createShaderProgramFunction=e._createShaderProgramFunction,this._createCommandsFunction=e._createCommandsFunction,this._updateAndQueueCommandsFunction=e._updateAndQueueCommandsFunction,this._createGeometryResults=void 0,this._ready=!1,this._readyPromise=A.defer()}function L(e){return new p({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,values:new e.values.constructor(e.values)})}function F(t){var r=t.attributes,i=new m;for(var n in r)r.hasOwnProperty(n)&&s(r[n])&&(i[n]=L(r[n]));var o;if(s(t.indices)){var a=t.indices;o=new a.constructor(a)}return new d({attributes:i,indices:o,primitiveType:t.primitiveType,boundingSphere:e.clone(t.boundingSphere)})}function B(e){return new v({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,value:new e.value.constructor(e.value)})}function V(e,t){var r=e.attributes,i={};for(var n in r)r.hasOwnProperty(n)&&(i[n]=B(r[n]));return new f({geometry:t,modelMatrix:g.clone(e.modelMatrix),attributes:i,pickPrimitive:e.pickPrimitive,id:e.id})}function z(e,t){if(!e.compressVertices)return t;var r=-1!==t.search(/attribute\s+vec3\s+normal;/g),i=-1!==t.search(/attribute\s+vec2\s+st;/g);if(!r&&!i)return t;var n=-1!==t.search(/attribute\s+vec3\s+tangent;/g),o=-1!==t.search(/attribute\s+vec3\s+binormal;/g),a=i&&r?2:1;a+=n||o?1:0;var s=a>1?"vec"+a:"float",l="compressedAttributes",u="attribute "+s+" "+l+";",c="",h="";if(i){c+="vec2 st;\n";var d=a>1?l+".x":l;h+="    st = czm_decompressTextureCoordinates("+d+");\n"}r&&n&&o?(c+="vec3 normal;\nvec3 tangent;\nvec3 binormal;\n",h+="    czm_octDecode("+l+"."+(i?"yz":"xy")+", normal, tangent, binormal);\n"):(r&&(c+="vec3 normal;\n",h+="    normal = czm_octDecode("+l+(a>1?"."+(i?"y":"x"):"")+");\n"),n&&(c+="vec3 tangent;\n",h+="    tangent = czm_octDecode("+l+"."+(i&&r?"z":"y")+");\n"),o&&(c+="vec3 binormal;\n",h+="    binormal = czm_octDecode("+l+"."+(i&&r?"z":"y")+");\n"));var p=t;p=p.replace(/attribute\s+vec3\s+normal;/g,""),p=p.replace(/attribute\s+vec2\s+st;/g,""),p=p.replace(/attribute\s+vec3\s+tangent;/g,""),p=p.replace(/attribute\s+vec3\s+binormal;/g,""),p=b.replaceMain(p,"czm_non_compressed_main");var m="void main() \n{ \n"+h+"    czm_non_compressed_main(); \n}";return[u,c,p,m].join("\n")}function k(e,t){e.vertexAttributes}function U(e,t,r){for(var i=[],n=r.length,o=0;n>o;++o){var l={primitive:a(r[o].pickPrimitive,t)};s(r[o].id)&&(l.id=r[o].id);var u=e.createPickId(l);t._pickIds.push(u),i.push(u.color)}return i}function G(e,t){return function(){return e[t]}}function W(e,t){var r,i,n,o,l=e._instanceIds;if(e._state===R.READY){r=_(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var u=e._numberOfInstances=r.length,c=[],h=[];for(n=0;u>n;++n)i=r[n].geometry,l.push(r[n].id),h.push({moduleName:i._workerName,geometry:i});if(!s(re))for(re=new Array(ie),n=0;ie>n;n++)re[n]=new C("createGeometry",Number.POSITIVE_INFINITY);var d;for(h=y(h,ie),n=0;n<h.length;n++){var p=0,m=h[n],f=m.length;for(o=0;f>o;++o)d=m[o],i=d.geometry,s(i.constructor.pack)&&(d.offset=p,p+=a(i.constructor.packedLength,i.packedLength));var v;if(p>0){var E=new Float64Array(p);for(v=[E.buffer],o=0;f>o;++o)d=m[o],i=d.geometry,s(i.constructor.pack)&&(i.constructor.pack(i,E,d.offset),d.geometry=E)}c.push(re[n].scheduleTask({subTasks:h[n]},v))}e._state=R.CREATING,A.all(c,function(t){e._createGeometryResults=t,e._state=R.CREATED}).otherwise(function(r){ee(e,t,R.FAILED,r)})}else if(e._state===R.CREATED){var S=[];r=_(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var w=e.allowPicking,T=t.scene3DOnly,x=t.mapProjection,b=ne.scheduleTask(D.packCombineGeometryParameters({createGeometryResults:e._createGeometryResults,instances:r,pickIds:w?U(t.context,e,r):void 0,ellipsoid:x.ellipsoid,projection:x,elementIndexUintSupported:t.context.elementIndexUint,scene3DOnly:T,allowPicking:w,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix},S),S);e._createGeometryResults=void 0,e._state=R.COMBINING,A(b,function(r){var i=D.unpackCombineGeometryResults(r);e._geometries=i.geometries,e._attributeLocations=i.attributeLocations,e._vaAttributes=i.vaAttributes,e._perInstanceAttributeLocations=i.perInstanceAttributeLocations,e.modelMatrix=g.clone(i.modelMatrix,e.modelMatrix),e._validModelMatrix=!g.equals(e.modelMatrix,g.IDENTITY);for(var n=r.validInstancesIndices,o=r.invalidInstancesIndices,a=e._instanceIds,l=new Array(a.length),u=n.length,c=0;u>c;++c)l[c]=a[n[c]];for(var h=o.length,d=0;h>d;++d)l[u+d]=a[o[d]];e._instanceIds=l,s(e._geometries)?e._state=R.COMBINED:ee(e,t,R.FAILED,void 0)}).otherwise(function(r){ee(e,t,R.FAILED,r)})}}function H(e,t){var r,i,n=_(e.geometryInstances)?e.geometryInstances:[e.geometryInstances],o=e._numberOfInstances=n.length,a=new Array(o),l=new Array(o),u=[],c=e._instanceIds,h=0;for(i=0;o>i;i++){r=n[i];var d,p=r.geometry;d=s(p.attributes)&&s(p.primitiveType)?F(p):p.constructor.createGeometry(p),s(d)?(a[h]=d,l[h++]=V(r,d),c.push(r.id)):u.push(r)}a.length=h,l.length=h;var m=e.allowPicking,f=t.scene3DOnly,v=t.mapProjection,y=D.combineGeometry({instances:l,invalidInstances:u,pickIds:m?U(t.context,e,l):void 0,ellipsoid:v.ellipsoid,projection:v,elementIndexUintSupported:t.context.elementIndexUint,scene3DOnly:f,allowPicking:m,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix});for(e._geometries=y.geometries,e._attributeLocations=y.attributeLocations,e._vaAttributes=y.vaAttributes,e._perInstanceAttributeLocations=y.vaAttributeLocations,e.modelMatrix=g.clone(y.modelMatrix,e.modelMatrix),e._validModelMatrix=!g.equals(e.modelMatrix,g.IDENTITY),i=0;i<u.length;++i)r=u[i],c.push(r.id);s(e._geometries)?e._state=R.COMBINED:ee(e,t,R.FAILED,void 0)}function q(t,r){for(var i=t._attributeLocations,n=t._geometries,o=t._vaAttributes,a=r.scene3DOnly,l=r.context,u=[],c=n.length,h=0;c>h;++h){for(var d=n[h],p=o[h],m=p.length,f=0;m>f;++f){var v=p[f];v.vertexBuffer=E.createVertexBuffer({context:l,typedArray:v.values,usage:S.DYNAMIC_DRAW}),delete v.values}if(u.push(P.fromGeometry({context:l,geometry:d,attributeLocations:i,bufferUsage:S.STATIC_DRAW,interleave:t._interleave,vertexArrayAttributes:p})),s(t._createBoundingVolumeFunction))t._createBoundingVolumeFunction(r,d);else if(t._boundingSpheres.push(e.clone(d.boundingSphere)),t._boundingSphereWC.push(new e),!a){var _=d.boundingSphereCV.center,g=_.x,y=_.y,C=_.z;_.x=C,_.y=g,_.z=y,t._boundingSphereCV.push(e.clone(d.boundingSphereCV)),t._boundingSphere2D.push(new e),t._boundingSphereMorph.push(new e)}}t._va=u,t._primitiveType=n[0].primitiveType,t.releaseGeometryInstances&&(t.geometryInstances=void 0),t._geometries=void 0,ee(t,r,R.COMPLETE,void 0)}function j(e,t,r,n){var o,a=r.getRenderState();n?(o=i(a,!1),o.cull={enabled:!0,face:I.BACK},e._frontFaceRS=T.fromCache(o),o.cull.face=I.FRONT,e._backFaceRS=T.fromCache(o)):(e._frontFaceRS=T.fromCache(a),e._backFaceRS=e._frontFaceRS),e.allowPicking?n?(o=i(a,!1),o.cull={enabled:!1},e._pickRS=T.fromCache(o)):e._pickRS=e._frontFaceRS:(o=i(a,!1),o.colorMask={red:!1,green:!1,blue:!1,alpha:!1},n?(o.cull={enabled:!1},e._pickRS=T.fromCache(o)):e._pickRS=T.fromCache(o))}function Y(e,t,r){var i=t.context,n=N._modifyShaderPosition(e,r.vertexShaderSource,t.scene3DOnly);n=N._appendShowToShader(e,n),n=z(e,n);var o=r.getFragmentShaderSource(),a=e._attributeLocations;if(e._sp=x.replaceCache({context:i,shaderProgram:e._sp,vertexShaderSource:n,fragmentShaderSource:o,attributeLocations:a}),k(e._sp,a),e.allowPicking){var s=new b({sources:[o],pickColorQualifier:"varying"});e._pickSP=x.replaceCache({context:i,shaderProgram:e._pickSP,vertexShaderSource:b.createPickVertexShaderSource(n),fragmentShaderSource:s,attributeLocations:a})}else e._pickSP=x.fromCache({context:i,vertexShaderSource:n,fragmentShaderSource:o,attributeLocations:a});k(e._pickSP,a)}function X(e,t,r,i,o,a,l){var u=s(r)?r._uniforms:void 0,h={},d=t.uniforms;if(s(d))for(var p in d)if(d.hasOwnProperty(p)){if(s(u)&&s(u[p]))throw new c("Appearance and material have a uniform with the same name: "+p);h[p]=G(d,p)}var m=n(h,u);s(e.rtcCenter)&&(m.u_modifiedModelView=function(){return e._modifiedModelView});var f=i?M.TRANSLUCENT:M.OPAQUE;a.length=e._va.length*(o?2:1),l.length=e._va.length;for(var v=a.length,_=0,g=0,y=0;v>y;++y){var C;o&&(C=a[y],s(C)||(C=a[y]=new w({owner:e,primitiveType:e._primitiveType})),C.vertexArray=e._va[g],C.renderState=e._backFaceRS,C.shaderProgram=e._sp,C.uniformMap=m,C.pass=f,++y),C=a[y],s(C)||(C=a[y]=new w({owner:e,primitiveType:e._primitiveType})),C.vertexArray=e._va[g],C.renderState=e._frontFaceRS,C.shaderProgram=e._sp,C.uniformMap=m,C.pass=f;var E=l[_];s(E)||(E=l[_]=new w({owner:e,primitiveType:e._primitiveType})),E.vertexArray=e._va[g],E.renderState=e._pickRS,E.shaderProgram=e._pickSP,E.uniformMap=m,E.pass=f,++_,++g}}function Z(e){if(0!==e._dirtyAttributes.length){for(var t=e._dirtyAttributes,r=t.length,i=0;r>i;++i){for(var n=t[i],a=n.value,s=n.indices,l=s.length,u=0;l>u;++u){for(var c=s[u],h=c.offset,d=c.count,p=c.attribute,m=p.componentDatatype,f=p.componentsPerAttribute,v=o.createTypedArray(m,d*f),_=0;d>_;++_)v.set(a,_*f);var g=h*f*o.getSizeInBytes(m);p.vertexBuffer.copyFromArrayView(v,g)}n.dirty=!1}t.length=0}}function K(e,t){var r=e.appearance.pixelSize;if(s(r))for(var i=e._boundingSpheres.length,n=0;i>n;++n){var o=e._boundingSpheres[n],a=e._boundingSphereWC[n],l=t.camera.getPixelSize(o,t.context.drawingBufferWidth,t.context.drawingBufferHeight),u=l*r;a.radius=o.radius+u}}function Q(t,r,i,n,o,a,l,u){if(K(t,r),!g.equals(o,t._modelMatrix)){g.clone(o,t._modelMatrix);for(var c=t._boundingSpheres.length,h=0;c>h;++h){var d=t._boundingSpheres[h];s(d)&&(t._boundingSphereWC[h]=e.transform(d,o,t._boundingSphereWC[h]),r.scene3DOnly||(t._boundingSphere2D[h]=e.clone(t._boundingSphereCV[h],t._boundingSphere2D[h]),t._boundingSphere2D[h].center.x=0,t._boundingSphereMorph[h]=e.union(t._boundingSphereWC[h],t._boundingSphereCV[h])))}}if(s(t.rtcCenter)){var p=r.camera.viewMatrix;g.multiply(p,t._modelMatrix,t._modifiedModelView),g.multiplyByPoint(t._modifiedModelView,t.rtcCenter,oe),g.setTranslation(t._modifiedModelView,oe,t._modifiedModelView)}var m;r.mode===O.SCENE3D?m=t._boundingSphereWC:r.mode===O.COLUMBUS_VIEW?m=t._boundingSphereCV:r.mode===O.SCENE2D&&s(t._boundingSphere2D)?m=t._boundingSphere2D:s(t._boundingSphereMorph)&&(m=t._boundingSphereMorph);var f=r.commandList,v=r.passes;if(v.render)for(var _=i.length,y=0;_>y;++y){var C=u?Math.floor(y/2):y;i[y].modelMatrix=o,i[y].boundingVolume=m[C],i[y].cull=a,i[y].debugShowBoundingVolume=l,f.push(i[y])}if(v.pick)for(var E=n.length,S=0;E>S;++S)n[S].modelMatrix=o,n[S].boundingVolume=m[S],n[S].cull=a,f.push(n[S])}function J(e,t){var r=t[e];return function(){return s(r)&&s(r.value)?t[e].value:r}}function $(e,t,r){return function(i){var n=t[e];n.value=i,!n.dirty&&n.valid&&(r.push(n),n.dirty=!0)}}function ee(e,t,r,i){e._error=i,e._state=r,t.afterRender.push(function(){e._ready=e._state===R.COMPLETE||e._state===R.FAILED,s(i)?e._readyPromise.reject(i):e._readyPromise.resolve(e)})}l(N.prototype,{vertexCacheOptimize:{get:function(){return this._vertexCacheOptimize}},interleave:{get:function(){return this._interleave}},releaseGeometryInstances:{get:function(){return this._releaseGeometryInstances}},allowPicking:{get:function(){return this._allowPicking}},asynchronous:{get:function(){return this._asynchronous}},compressVertices:{get:function(){return this._compressVertices}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}}});var te=/attribute\s+vec(?:3|4)\s+(.*)3DHigh;/g;N._modifyShaderPosition=function(e,t,r){for(var i,n="",o="",a="";null!==(i=te.exec(t));){var l=i[1],u="vec4 czm_compute"+l[0].toUpperCase()+l.substr(1)+"()";"vec4 czm_computePosition()"!==u&&(n+=u+";\n"),s(e.rtcCenter)?(t=t.replace(/attribute\s+vec(?:3|4)\s+position3DHigh;/g,""),t=t.replace(/attribute\s+vec(?:3|4)\s+position3DLow;/g,""),n+="uniform mat4 u_modifiedModelView;\n",o+="attribute vec4 position;\n",a+=u+"\n{\n    return u_modifiedModelView * position;\n}\n\n",t=t.replace(/czm_modelViewRelativeToEye\s+\*\s+/g,""),t=t.replace(/czm_modelViewProjectionRelativeToEye/g,"czm_projection")):r?a+=u+"\n{\n    return czm_translateRelativeToEye("+l+"3DHigh, "+l+"3DLow);\n}\n\n":(o+="attribute vec3 "+l+"2DHigh;\nattribute vec3 "+l+"2DLow;\n",a+=u+"\n{\n    vec4 p;\n    if (czm_morphTime == 1.0)\n    {\n        p = czm_translateRelativeToEye("+l+"3DHigh, "+l+"3DLow);\n    }\n    else if (czm_morphTime == 0.0)\n    {\n        p = czm_translateRelativeToEye("+l+"2DHigh.zxy, "+l+"2DLow.zxy);\n    }\n    else\n    {\n        p = czm_columbusViewMorph(\n                czm_translateRelativeToEye("+l+"2DHigh.zxy, "+l+"2DLow.zxy),\n                czm_translateRelativeToEye("+l+"3DHigh, "+l+"3DLow),\n                czm_morphTime);\n    }\n    return p;\n}\n\n")}return[n,o,t,a].join("\n")},N._appendShowToShader=function(e,t){if(!s(e._attributeLocations.show))return t;var r=b.replaceMain(t,"czm_non_show_main"),i="attribute float show;\nvoid main() \n{ \n    czm_non_show_main(); \n    gl_Position *= show; \n}";return r+"\n"+i};var re,ie=Math.max(h.hardwareConcurrency-1,1),ne=new C("combineGeometry",Number.POSITIVE_INFINITY),oe=new r;return N.prototype.update=function(e){if(!(!s(this.geometryInstances)&&0===this._va.length||s(this.geometryInstances)&&_(this.geometryInstances)&&0===this.geometryInstances.length||!s(this.appearance)||e.mode!==O.SCENE3D&&e.scene3DOnly||!e.passes.render&&!e.passes.pick)){if(s(this._error))throw this._error;if(s(this.rtcCenter)&&!e.scene3DOnly)throw new c("RTC rendering is only available for 3D only scenes.");if(this._state!==R.FAILED&&(this._state!==R.COMPLETE&&this._state!==R.COMBINED&&(this.asynchronous?W(this,e):H(this,e)),this._state===R.COMBINED&&q(this,e),this.show&&this._state===R.COMPLETE)){var t=this.appearance,r=t.material,i=!1,n=!1;this._appearance!==t?(this._appearance=t,this._material=r,i=!0,n=!0):this._material!==r&&(this._material=r,n=!0);var o=this._appearance.isTranslucent();this._translucent!==o&&(this._translucent=o,i=!0);var l=e.context;s(this._material)&&this._material.update(l);var u=t.closed&&o;if(i){var h=a(this._createRenderStatesFunction,j);h(this,l,t,u)}if(n){var d=a(this._createShaderProgramFunction,Y);d(this,e,t)}if(i||n){var p=a(this._createCommandsFunction,X);p(this,t,r,o,u,this._colorCommands,this._pickCommands)}Z(this);var m=a(this._updateAndQueueCommandsFunction,Q);m(this,e,this._colorCommands,this._pickCommands,this.modelMatrix,this.cull,this.debugShowBoundingVolume,u)}}},N.prototype.getGeometryInstanceAttributes=function(e){for(var t=-1,r=this._lastPerInstanceAttributeIndex,i=this._instanceIds,n=i.length,o=0;n>o;++o){var a=(r+o)%n;if(e===i[a]){t=a;break}}if(-1!==t){var u=this._perInstanceAttributeCache[t];if(s(u))return u;var c=this._perInstanceAttributeLocations[t];u={};var h={},d=!1;for(var p in c)c.hasOwnProperty(p)&&(d=!0,h[p]={get:J(p,c)},"boundingSphere"!==p&&"boundingSphereCV"!==p&&(h[p].set=$(p,c,this._dirtyAttributes)));return d&&l(u,h),this._lastPerInstanceAttributeIndex=t,this._perInstanceAttributeCache[t]=u,u}},N.prototype.isDestroyed=function(){return!1},N.prototype.destroy=function(){var e,t;this._sp=this._sp&&this._sp.destroy(),this._pickSP=this._pickSP&&this._pickSP.destroy();var r=this._va;for(e=r.length,t=0;e>t;++t)r[t].destroy();this._va=void 0;var i=this._pickIds;for(e=i.length,t=0;e>t;++t)i[t].destroy();return this._pickIds=void 0,this._instanceIds=void 0,this._perInstanceAttributeCache=void 0,this._perInstanceAttributeLocations=void 0,this._attributeLocations=void 0,this._dirtyAttributes=void 0,u(this)},N}),r("DataSources/ColorMaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./ConstantProperty","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this.color=e}return r(l.prototype,{isConstant:{get:function(){return s.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color")}),l.prototype.getType=function(e){return"Color"},l.prototype.getValue=function(r,i){return t(i)||(i={}),i.color=s.getValueOrClonedDefault(this._color,r,e.WHITE,i.color),i},l.prototype.equals=function(e){return this===e||e instanceof l&&s.equals(this._color,e._color)},l}),r("DataSources/dynamicGeometryGetBoundingSphere",["../Core/BoundingSphere","../Core/defined","../Core/DeveloperError","./BoundingSphereState"],function(e,t,r,i){"use strict";function n(r,n,o,a){var s;return t(n)&&n.show&&n.ready&&(s=n.getGeometryInstanceAttributes(r),t(s)&&t(s.boundingSphere))?(e.transform(s.boundingSphere,n.modelMatrix,a),i.DONE):t(o)&&o.show&&o.ready&&(s=o.getGeometryInstanceAttributes(r),t(s)&&t(s.boundingSphere))?(e.transform(s.boundingSphere,o.modelMatrix,a),i.DONE):t(n)&&!n.ready||t(o)&&!o.ready?i.PENDING:i.FAILED}return n}),r("DataSources/MaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Scene/Material"],function(e,t,r,i,n){"use strict";function o(){i.throwInstantiationError()}return r(o.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError}}),o.prototype.getType=i.throwInstantiationError,o.prototype.getValue=i.throwInstantiationError,o.prototype.equals=i.throwInstantiationError,o.getValue=function(r,i,o){var a;return t(i)&&(a=i.getType(r),t(a))?(t(o)&&o.type===a||(o=n.fromType(a)),i.getValue(r,o.uniforms),o):(t(o)&&o.type===n.ColorType||(o=n.fromType(n.ColorType)),e.clone(e.WHITE,o.uniforms.color),
o)},o}),r("DataSources/BoxGeometryUpdater",["../Core/BoxGeometry","../Core/BoxOutlineGeometry","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C){"use strict";function E(e){this.id=e,this.vertexFormat=void 0,this.dimensions=void 0}function S(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(S.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new E(e),this._onEntityPropertyChanged(e,"box",e.box,void 0)}function w(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new E(t._entity)}var T=new v(r.WHITE),x=new _(!0),b=new _(!0),P=new _(!1),A=new _(r.BLACK),I=new r;return a(S,{perInstanceColorAppearanceType:{value:m},materialAppearanceType:{value:p}}),a(S.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),S.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},S.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},S.prototype.createFillGeometryInstance=function(t){var n,a,s=this._entity,l=s.isAvailable(t),u=new d(l&&s.isShowing&&this._showProperty.getValue(t)&&this._fillProperty.getValue(t));if(this._materialProperty instanceof v){var p=r.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(p=this._materialProperty.color.getValue(t)),a=i.fromColor(p),n={show:u,color:a}}else n={show:u};return new c({id:s,geometry:e.fromDimensions(this._options),modelMatrix:s._getModelMatrix(h.MINIMUM_VALUE),attributes:n})},S.prototype.createOutlineGeometryInstance=function(e){var n=this._entity,o=n.isAvailable(e),a=C.getValueOrDefault(this._outlineColorProperty,e,r.BLACK);return new c({id:n,geometry:t.fromDimensions(this._options),modelMatrix:n._getModelMatrix(h.MINIMUM_VALUE),attributes:{show:new d(o&&n.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:i.fromColor(a)}})},S.prototype.isDestroyed=function(){return!1},S.prototype.destroy=function(){this._entitySubscription(),s(this)},S.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"position"===t||"orientation"===t||"box"===t){var a=this._entity.box;if(!o(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,l=o(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,u=a.outline,c=o(u);if(c&&u.isConstant&&(c=u.getValue(h.MINIMUM_VALUE)),!l&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=a.dimensions,f=e.position,_=a.show;if(!o(d)||!o(f)||o(_)&&_.isConstant&&!_.getValue(h.MINIMUM_VALUE))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var g=n(a.material,T),y=g instanceof v;this._materialProperty=g,this._fillProperty=n(s,b),this._showProperty=n(_,x),this._showOutlineProperty=n(a.outline,P),this._outlineColorProperty=c?n(a.outlineColor,A):void 0;var E=a.outlineWidth;if(this._fillEnabled=l,this._outlineEnabled=c,f.isConstant&&C.isConstant(e.orientation)&&d.isConstant&&C.isConstant(E)){var S=this._options;S.vertexFormat=y?m.VERTEX_FORMAT:p.MaterialSupport.TEXTURED.vertexFormat,S.dimensions=d.getValue(h.MINIMUM_VALUE,S.dimensions),this._outlineWidth=o(E)?E.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},S.prototype.createDynamicUpdater=function(e){return new w(e,this)},w.prototype.update=function(n){var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.box;if(l.isShowing&&l.isAvailable(n)&&C.getValueOrDefault(u.show,n,!0)){var h=this._options,d=l._getModelMatrix(n),v=C.getValueOrUndefined(u.dimensions,n,h.dimensions);if(o(d)&&o(v)){if(h.dimensions=v,C.getValueOrDefault(u.fill,n,!0)){var _=y.getValue(n,s.fillMaterialProperty,this._material);this._material=_;var g=new p({material:_,translucent:_.isTranslucent(),closed:!0});h.vertexFormat=g.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:e.fromDimensions(h),modelMatrix:d}),appearance:g,asynchronous:!1}))}if(C.getValueOrDefault(u.outline,n,!1)){h.vertexFormat=m.VERTEX_FORMAT;var E=C.getValueOrClonedDefault(u.outlineColor,n,r.BLACK,I),S=C.getValueOrDefault(u.outlineWidth,n,1),w=1!==E.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:t.fromDimensions(h),modelMatrix:d,attributes:{color:i.fromColor(E)}}),appearance:new m({flat:!0,translucent:w,renderState:{lineWidth:s._scene.clampLineWidth(S)}}),asynchronous:!1}))}}}},w.prototype.getBoundingSphere=function(e,t){return g(e,this._primitive,this._outlinePrimitive,t)},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},S}),r("DataSources/ImageMaterialProperty",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._image=void 0,this._imageSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this._alpha=void 0,this._alphaSubscription=void 0,this.image=e.image,this.repeat=e.repeat,this.alpha=e.alpha}var l=new e(1,1),u=1;return i(s.prototype,{isConstant:{get:function(){return a.isConstant(this._image)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),repeat:o("repeat"),alpha:o("alpha")}),s.prototype.getType=function(e){return"Image"},s.prototype.getValue=function(e,t){return r(t)||(t={}),t.image=a.getValueOrUndefined(this._image,e),t.repeat=a.getValueOrClonedDefault(this._repeat,e,l,t.repeat),t.alpha=a.getValueOrDefault(this._alpha,e,u),t},s.prototype.equals=function(e){return this===e||e instanceof s&&a.equals(this._image,e._image)&&a.equals(this._alpha,e._alpha)&&a.equals(this._repeat,e._repeat)},s}),r("DataSources/createMaterialPropertyDescriptor",["../Core/Color","../Core/DeveloperError","./ColorMaterialProperty","./createPropertyDescriptor","./ImageMaterialProperty"],function(e,t,r,i,n){"use strict";function o(t){if(t instanceof e)return new r(t);if("string"==typeof t||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement){var i=new n;return i.image=t,i}}function a(e,t){return i(e,t,o)}return a}),r("DataSources/BoxGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._dimensions=void 0,this._dimensionsSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),dimensions:a("dimensions"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.dimensions=this.dimensions,e.show=this.show,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.dimensions=e(this.dimensions,t.dimensions),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),r("DataSources/CallbackProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,r,i){"use strict";function n(e,t){this._callback=void 0,this._isConstant=void 0,this._definitionChanged=new i,this.setCallback(e,t)}return t(n.prototype,{isConstant:{get:function(){return this._isConstant}},definitionChanged:{get:function(){return this._definitionChanged}}}),n.prototype.getValue=function(e,t){return this._callback(e,t)},n.prototype.setCallback=function(e,t){var r=this._callback!==e||this._isConstant!==t;this._callback=e,this._isConstant=t,r&&this._definitionChanged.raiseEvent(this)},n.prototype.equals=function(e){return this===e||e instanceof n&&this._callback===e._callback&&this._isConstant===e._isConstant},n}),r("DataSources/CheckerboardMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){e=r(e,r.EMPTY_OBJECT),this._definitionChanged=new o,this._evenColor=void 0,this._evenColorSubscription=void 0,this._oddColor=void 0,this._oddColorSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.evenColor=e.evenColor,this.oddColor=e.oddColor,this.repeat=e.repeat}var u=t.WHITE,c=t.BLACK,h=new e(2,2);return n(l.prototype,{isConstant:{get:function(){return s.isConstant(this._evenColor)&&s.isConstant(this._oddColor)&&s.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},evenColor:a("evenColor"),oddColor:a("oddColor"),repeat:a("repeat")}),l.prototype.getType=function(e){return"Checkerboard"},l.prototype.getValue=function(e,t){return i(t)||(t={}),t.lightColor=s.getValueOrClonedDefault(this._evenColor,e,u,t.lightColor),t.darkColor=s.getValueOrClonedDefault(this._oddColor,e,c,t.darkColor),t.repeat=s.getValueOrDefault(this._repeat,e,h),t},l.prototype.equals=function(e){return this===e||e instanceof l&&s.equals(this._evenColor,e._evenColor)&&s.equals(this._oddColor,e._oddColor)&&s.equals(this._repeat,e._repeat)},l}),r("DataSources/PositionProperty",["../Core/Cartesian3","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix3","../Core/ReferenceFrame","../Core/Transforms"],function(e,t,r,i,n,o,a){"use strict";function s(){i.throwInstantiationError()}r(s.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError},referenceFrame:{get:i.throwInstantiationError}}),s.prototype.getValue=i.throwInstantiationError,s.prototype.getValueInReferenceFrame=i.throwInstantiationError,s.prototype.equals=i.throwInstantiationError;var l=new n;return s.convertToReferenceFrame=function(r,i,s,u,c){if(!t(i))return i;if(t(c)||(c=new e),s===u)return e.clone(i,c);var h=a.computeIcrfToFixedMatrix(r,l);return t(h)||(h=a.computeTemeToPseudoFixedMatrix(r,l)),s===o.INERTIAL?n.multiplyByVector(h,i,c):s===o.FIXED?n.multiplyByVector(n.transpose(h,l),i,c):void 0},s}),r("DataSources/ConstantPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty"],function(e,t,r,i,n,o,a,s){"use strict";function l(r,i){this._definitionChanged=new o,this._value=e.clone(r),this._referenceFrame=t(i,a.FIXED)}return i(l.prototype,{isConstant:{get:function(){return!r(this._value)||this._referenceFrame===a.FIXED}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},l.prototype.setValue=function(t,i){var n=!1;e.equals(this._value,t)||(n=!0,this._value=e.clone(t)),r(i)&&this._referenceFrame!==i&&(n=!0,this._referenceFrame=i),n&&this._definitionChanged.raiseEvent(this)},l.prototype.getValueInReferenceFrame=function(e,t,r){return s.convertToReferenceFrame(e,this._value,this._referenceFrame,t,r)},l.prototype.equals=function(t){return this===t||t instanceof l&&e.equals(this._value,t._value)&&this._referenceFrame===t._referenceFrame},l}),r("DataSources/CorridorGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),width:a("width"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.width=this.width,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.width=e(this.width,t.width),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.cornerType=e(this.cornerType,t.cornerType)},s}),r("DataSources/createRawPropertyDescriptor",["./createPropertyDescriptor"],function(e){"use strict";function t(e){return e}function r(r,i){return e(r,i,t)}return r}),r("DataSources/CylinderGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._length=void 0,this._lengthSubscription=void 0,this._topRadius=void 0,this._topRadiusSubscription=void 0,this._bottomRadius=void 0,this._bottomRadiusSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._slices=void 0,this._slicesSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},length:a("length"),topRadius:a("topRadius"),bottomRadius:a("bottomRadius"),numberOfVerticalLines:a("numberOfVerticalLines"),slices:a("slices"),show:a("show"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.bottomRadius=this.bottomRadius,e.length=this.length,e.topRadius=this.topRadius,e.show=this.show,e.material=this.material,e.numberOfVerticalLines=this.numberOfVerticalLines,e.slices=this.slices,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.bottomRadius=e(this.bottomRadius,t.bottomRadius),this.length=e(this.length,t.length),this.topRadius=e(this.topRadius,t.topRadius),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.numberOfVerticalLines=e(this.numberOfVerticalLines,t.numberOfVerticalLines),this.slices=e(this.slices,t.slices),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),r("DataSources/EllipseGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._semiMajorAxis=void 0,this._semiMajorAxisSubscription=void 0,this._semiMinorAxis=void 0,this._semiMinorAxisSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},semiMajorAxis:a("semiMajorAxis"),semiMinorAxis:a("semiMinorAxis"),rotation:a("rotation"),show:a("show"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),numberOfVerticalLines:a("numberOfVerticalLines")}),s.prototype.clone=function(e){return t(e)?(e.rotation=this.rotation,e.semiMajorAxis=this.semiMajorAxis,e.semiMinorAxis=this.semiMinorAxis,e.show=this.show,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.numberOfVerticalLines=this.numberOfVerticalLines,e):new s(this)},s.prototype.merge=function(t){this.rotation=e(this.rotation,t.rotation),this.semiMajorAxis=e(this.semiMajorAxis,t.semiMajorAxis),this.semiMinorAxis=e(this.semiMinorAxis,t.semiMinorAxis),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.numberOfVerticalLines=e(this.numberOfVerticalLines,t.numberOfVerticalLines)},s}),r("DataSources/EllipsoidGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._radii=void 0,this._radiiSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._stackPartitions=void 0,this._stackPartitionsSubscription=void 0,this._slicePartitions=void 0,this._slicePartitionsSubscription=void 0,this._subdivisions=void 0,this._subdivisionsSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),radii:a("radii"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),stackPartitions:a("stackPartitions"),slicePartitions:a("slicePartitions"),subdivisions:a("subdivisions")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.radii=this.radii,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.stackPartitions=this.stackPartitions,e.slicePartitions=this.slicePartitions,e.subdivisions=this.subdivisions,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.radii=e(this.radii,t.radii),this.material=e(this.material,t.material),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.stackPartitions=e(this.stackPartitions,t.stackPartitions),this.slicePartitions=e(this.slicePartitions,t.slicePartitions),this.subdivisions=e(this.subdivisions,t.subdivisions)},s}),r("DataSources/LabelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";function a(t){this._text=void 0,this._textSubscription=void 0,this._font=void 0,this._fontSubscription=void 0,this._style=void 0,this._styleSubscription=void 0,this._fillColor=void 0,this._fillColorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},text:o("text"),font:o("font"),style:o("style"),fillColor:o("fillColor"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),scale:o("scale"),show:o("show"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)?(e.text=this.text,e.font=this.font,e.show=this.show,e.style=this.style,e.fillColor=this.fillColor,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.scale=this.scale,e.horizontalOrigin=this.horizontalOrigin,e.verticalOrigin=this.verticalOrigin,e.eyeOffset=this.eyeOffset,e.pixelOffset=this.pixelOffset,e.translucencyByDistance=this.translucencyByDistance,e.pixelOffsetScaleByDistance=this.pixelOffsetScaleByDistance,e):new a(this)},a.prototype.merge=function(t){this.text=e(this.text,t.text),this.font=e(this.font,t.font),this.show=e(this.show,t.show),this.style=e(this.style,t.style),this.fillColor=e(this.fillColor,t.fillColor),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.scale=e(this.scale,t.scale),this.horizontalOrigin=e(this.horizontalOrigin,t.horizontalOrigin),this.verticalOrigin=e(this.verticalOrigin,t.verticalOrigin),this.eyeOffset=e(this.eyeOffset,t.eyeOffset),this.pixelOffset=e(this.pixelOffset,t.pixelOffset),this.translucencyByDistance=e(this._translucencyByDistance,t.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,t.pixelOffsetScaleByDistance)},a}),r("DataSources/NodeTransformationProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","../Core/TranslationRotationScale","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";var s=new n,l=function(t){t=e(t,e.EMPTY_OBJECT),this._definitionChanged=new i,this._translation=void 0,this._translationSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this.translation=t.translation,this.rotation=t.rotation,this.scale=t.scale};return r(l.prototype,{isConstant:{get:function(){return a.isConstant(this._translation)&&a.isConstant(this._rotation)&&a.isConstant(this._scale)}},definitionChanged:{get:function(){return this._definitionChanged}},translation:o("translation"),rotation:o("rotation"),scale:o("scale")}),l.prototype.getValue=function(e,r){return t(r)||(r=new n),r.translation=a.getValueOrClonedDefault(this._translation,e,s.translation,r.translation),r.rotation=a.getValueOrClonedDefault(this._rotation,e,s.rotation,r.rotation),r.scale=a.getValueOrClonedDefault(this._scale,e,s.scale,r.scale),r},l.prototype.equals=function(e){return this===e||e instanceof l&&a.equals(this._translation,e._translation)&&a.equals(this._rotation,e._rotation)&&a.equals(this._scale,e._scale)},l}),r("DataSources/PropertyBag",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor","./ConstantProperty","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){return new a(e)}function u(e,t){var r=e._propertyNames,i=t._propertyNames,n=r.length;if(n!==i.length)return!1;for(var o=0;n>o;++o){var a=r[o],l=i.indexOf(a);if(-1===l)return!1;if(!s.equals(e[a],t[a]))return!1}return!0}var c=function(e,r){this._propertyNames=[],this._definitionChanged=new n,t(e)&&this.merge(e,r)};return r(c.prototype,{propertyNames:{get:function(){return this._propertyNames}},isConstant:{get:function(){for(var e=this._propertyNames,t=0,r=e.length;r>t;t++)if(!s.isConstant(this[e[t]]))return!1;return!0}},definitionChanged:{get:function(){return this._definitionChanged}}}),c.prototype.hasProperty=function(e){return-1!==this._propertyNames.indexOf(e)},c.prototype.addProperty=function(r,i,n){var a=this._propertyNames;a.push(r),Object.defineProperty(this,r,o(r,!0,e(n,l))),t(i)&&(this[r]=i),this._definitionChanged.raiseEvent(this)},c.prototype.removeProperty=function(e){var t=this._propertyNames,r=t.indexOf(e);this._propertyNames.splice(r,1),delete this[e],this._definitionChanged.raiseEvent(this)},c.prototype.getValue=function(e,r){t(r)||(r={});for(var i=this._propertyNames,n=0,o=i.length;o>n;n++){var a=i[n];r[a]=s.getValueOrUndefined(this[a],e,r[a])}return r},c.prototype.merge=function(e,r){for(var i=this._propertyNames,n=t(e._propertyNames)?e._propertyNames:Object.keys(e),o=0,a=n.length;a>o;o++){var s=n[o],l=this[s],u=e[s];t(l)||-1!==i.indexOf(s)||this.addProperty(s,void 0,r),t(u)&&(t(l)?t(l.merge)&&l.merge(u):t(u.merge)&&t(u.clone)?this[s]=u.clone():this[s]=u)}},c.prototype.equals=function(e){return this===e||e instanceof c&&u(this,e)},c}),r("DataSources/ModelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor","./NodeTransformationProperty","./PropertyBag"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){return new a(e)}function u(e){return new s(e,l)}function c(t){this._show=void 0,this._showSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._minimumPixelSize=void 0,this._minimumPixelSizeSubscription=void 0,this._maximumScale=void 0,this._maximumScaleSubscription=void 0,this._incrementallyLoadTextures=void 0,this._incrementallyLoadTexturesSubscription=void 0,this._uri=void 0,this._uriSubscription=void 0,this._runAnimations=void 0,this._runAnimationsSubscription=void 0,this._nodeTransformations=void 0,this._nodeTransformationsSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(c.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:o("show"),scale:o("scale"),minimumPixelSize:o("minimumPixelSize"),maximumScale:o("maximumScale"),incrementallyLoadTextures:o("incrementallyLoadTextures"),uri:o("uri"),runAnimations:o("runAnimations"),nodeTransformations:o("nodeTransformations",void 0,u)}),c.prototype.clone=function(e){return t(e)?(e.show=this.show,e.scale=this.scale,e.minimumPixelSize=this.minimumPixelSize,e.maximumScale=this.maximumScale,e.incrementallyLoadTextures=this.incrementallyLoadTextures,e.uri=this.uri,e.runAnimations=this.runAnimations,e.nodeTransformations=this.nodeTransformations,e):new c(this)},c.prototype.merge=function(r){this.show=e(this.show,r.show),this.scale=e(this.scale,r.scale),this.minimumPixelSize=e(this.minimumPixelSize,r.minimumPixelSize),this.maximumScale=e(this.maximumScale,r.maximumScale),this.incrementallyLoadTextures=e(this.incrementallyLoadTextures,r.incrementallyLoadTextures),this.uri=e(this.uri,r.uri),this.runAnimations=e(this.runAnimations,r.runAnimations);var i=r.nodeTransformations;if(t(i)){var n=this.nodeTransformations;t(n)?n.merge(i):this.nodeTransformations=new s(i,l)}},c}),r("DataSources/PathGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){
"use strict";function s(t){this._material=void 0,this._materialSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._resolution=void 0,this._resolutionSubscription=void 0,this._leadTime=void 0,this._leadTimeSubscription=void 0,this._trailTime=void 0,this._trailTimeSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),width:a("width"),resolution:a("resolution"),leadTime:a("leadTime"),trailTime:a("trailTime")}),s.prototype.clone=function(e){return t(e)?(e.material=this.material,e.width=this.width,e.resolution=this.resolution,e.show=this.show,e.leadTime=this.leadTime,e.trailTime=this.trailTime,e):new s(this)},s.prototype.merge=function(t){this.material=e(this.material,t.material),this.width=e(this.width,t.width),this.resolution=e(this.resolution,t.resolution),this.show=e(this.show,t.show),this.leadTime=e(this.leadTime,t.leadTime),this.trailTime=e(this.trailTime,t.trailTime)},s}),r("DataSources/PointGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";function a(t){this._color=void 0,this._colorSubscription=void 0,this._pixelSize=void 0,this._pixelSizeSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),pixelSize:o("pixelSize"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),show:o("show"),scaleByDistance:o("scaleByDistance"),translucencyByDistance:o("translucencyByDistance")}),a.prototype.clone=function(e){return t(e)?(e.color=this.color,e.pixelSize=this.pixelSize,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.show=this.show,e.scaleByDistance=this.scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e):new a(this)},a.prototype.merge=function(t){this.color=e(this.color,t.color),this.pixelSize=e(this.pixelSize,t.pixelSize),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.show=e(this.show,t.show),this.scaleByDistance=e(this.scaleByDistance,t.scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,t.translucencyByDistance)},a}),r("DataSources/PolygonGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._hierarchy=void 0,this._hierarchySubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._perPositionHeight=void 0,this._perPositionHeightSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this._fill=void 0,this._fillSubscription=void 0,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),hierarchy:a("hierarchy"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),perPositionHeight:a("perPositionHeight")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.hierarchy=this.hierarchy,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.perPositionHeight=this.perPositionHeight,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.hierarchy=e(this.hierarchy,t.hierarchy),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.perPositionHeight=e(this.perPositionHeight,t.perPositionHeight)},s}),r("DataSources/PolylineGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._followSurface=void 0,this._followSurfaceSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._widthSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),width:a("width"),followSurface:a("followSurface"),granularity:a("granularity")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.width=this.width,e.followSurface=this.followSurface,e.granularity=this.granularity,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.width=e(this.width,t.width),this.followSurface=e(this.followSurface,t.followSurface),this.granularity=e(this.granularity,t.granularity)},s}),r("DataSources/PolylineVolumeGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._shape=void 0,this._shapeSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),shape:a("shape"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.shape=this.shape,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.shape=e(this.shape,t.shape),this.granularity=e(this.granularity,t.granularity),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.cornerType=e(this.cornerType,t.cornerType)},s}),r("DataSources/RectangleGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._coordinates=void 0,this._coordinatesSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._closeTop=void 0,this._closeTopSubscription=void 0,this._closeBottom=void 0,this._closeBottomSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),coordinates:a("coordinates"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),rotation:a("rotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),closeTop:a("closeTop"),closeBottom:a("closeBottom")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.coordinates=this.coordinates,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.rotation=this.rotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.closeTop=this.closeTop,e.closeBottom=this.closeBottom,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.coordinates=e(this.coordinates,t.coordinates),this.material=e(this.material,t.material),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.rotation=e(this.rotation,t.rotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.closeTop=e(this.closeTop,t.closeTop),this.closeBottom=e(this.closeBottom,t.closeBottom)},s}),r("DataSources/WallGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";function s(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._minimumHeights=void 0,this._minimumHeightsSubscription=void 0,this._maximumHeights=void 0,this._maximumHeightsSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))}return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),minimumHeights:a("minimumHeights"),maximumHeights:a("maximumHeights"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.minimumHeights=this.minimumHeights,e.maximumHeights=this.maximumHeights,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.minimumHeights=e(this.minimumHeights,t.minimumHeights),this.maximumHeights=e(this.maximumHeights,t.maximumHeights),this.granularity=e(this.granularity,t.granularity),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),r("DataSources/Entity",["../Core/Cartesian3","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Core/Transforms","./BillboardGraphics","./BoxGraphics","./ConstantPositionProperty","./CorridorGraphics","./createPropertyDescriptor","./createRawPropertyDescriptor","./CylinderGraphics","./EllipseGraphics","./EllipsoidGraphics","./LabelGraphics","./ModelGraphics","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGraphics","./PolylineVolumeGraphics","./Property","./RectangleGraphics","./WallGraphics"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I){"use strict";function M(e){return new p(e)}function D(e){return f(e,void 0,M)}function R(e,t){return f(e,void 0,function(e){return e instanceof t?e:new t(e)})}function O(e){e=r(e,r.EMPTY_OBJECT);var n=e.id;i(n)||(n=t()),this._availability=void 0,this._id=n,this._definitionChanged=new a,this._name=e.name,this._show=r(e.show,!0),this._parent=void 0,this._propertyNames=["billboard","box","corridor","cylinder","description","ellipse","ellipsoid","label","model","orientation","path","point","polygon","polyline","polylineVolume","position","rectangle","viewFrom","wall"],this._billboard=void 0,this._billboardSubscription=void 0,this._box=void 0,this._boxSubscription=void 0,this._corridor=void 0,this._corridorSubscription=void 0,this._cylinder=void 0,this._cylinderSubscription=void 0,this._description=void 0,this._descriptionSubscription=void 0,this._ellipse=void 0,this._ellipseSubscription=void 0,this._ellipsoid=void 0,this._ellipsoidSubscription=void 0,this._label=void 0,this._labelSubscription=void 0,this._model=void 0,this._modelSubscription=void 0,this._orientation=void 0,this._orientationSubscription=void 0,this._path=void 0,this._pathSubscription=void 0,this._point=void 0,this._pointSubscription=void 0,this._polygon=void 0,this._polygonSubscription=void 0,this._polyline=void 0,this._polylineSubscription=void 0,this._polylineVolume=void 0,this._polylineVolumeSubscription=void 0,this._position=void 0,this._positionSubscription=void 0,this._rectangle=void 0,this._rectangleSubscription=void 0,this._viewFrom=void 0,this._viewFromSubscription=void 0,this._wall=void 0,this._wallSubscription=void 0,this._children=[],this.entityCollection=void 0,this.parent=e.parent,this.merge(e)}function N(e,t,r){for(var i=t.length,n=0;i>n;n++){var o=t[n],a=o._show,s=!r&&a,l=r&&a;s!==l&&N(o,o._children,r)}e._definitionChanged.raiseEvent(e,"isShowing",r,!r)}n(O.prototype,{availability:v("availability"),id:{get:function(){return this._id}},definitionChanged:{get:function(){return this._definitionChanged}},name:v("name"),show:{get:function(){return this._show},set:function(e){if(e!==this._show){var t=this.isShowing;this._show=e;var r=this.isShowing;t!==r&&N(this,this._children,r),this._definitionChanged.raiseEvent(this,"show",e,!e)}}},isShowing:{get:function(){return this._show&&(!i(this._parent)||this._parent.isShowing)}},parent:{get:function(){return this._parent},set:function(e){var t=this._parent;if(t!==e){var r=this.isShowing;if(i(t)){var n=t._children.indexOf(this);t._children.splice(n,1)}this._parent=e,i(e)&&e._children.push(this);var o=this.isShowing;r!==o&&N(this,this._children,o),this._definitionChanged.raiseEvent(this,"parent",e,t)}}},propertyNames:{get:function(){return this._propertyNames}},billboard:R("billboard",h),box:R("box",d),corridor:R("corridor",m),cylinder:R("cylinder",_),description:f("description"),ellipse:R("ellipse",g),ellipsoid:R("ellipsoid",y),label:R("label",C),model:R("model",E),orientation:f("orientation"),path:R("path",S),point:R("point",w),polygon:R("polygon",T),polyline:R("polyline",x),polylineVolume:R("polylineVolume",b),position:D("position"),rectangle:R("rectangle",A),viewFrom:f("viewFrom"),wall:R("wall",I)}),O.prototype.isAvailable=function(e){var t=this._availability;return!i(t)||t.contains(e)},O.prototype.addProperty=function(e){var t=this._propertyNames;t.push(e),Object.defineProperty(this,e,v(e,!0))},O.prototype.removeProperty=function(e){var t=this._propertyNames,r=t.indexOf(e);this._propertyNames.splice(r,1),delete this[e]},O.prototype.merge=function(e){this.name=r(this.name,e.name),this.availability=r(e.availability,this.availability);for(var t=this._propertyNames,n=i(e._propertyNames)?e._propertyNames:Object.keys(e),o=n.length,a=0;o>a;a++){var s=n[a];if("parent"!==s){var l=this[s],u=e[s];i(l)||-1!==t.indexOf(s)||this.addProperty(s),i(u)&&(i(l)?i(l.merge)&&l.merge(u):i(u.merge)&&i(u.clone)?this[s]=u.clone():this[s]=u)}}};var L=new s,F=new e,B=new u;return O.prototype._getModelMatrix=function(e,t){var r=P.getValueOrUndefined(this._position,e,F);if(i(r)){var n=P.getValueOrUndefined(this._orientation,e,B);return t=i(n)?l.fromRotationTranslation(s.fromQuaternion(n,L),r,t):c.eastNorthUpToFixedFrame(r,void 0,t)}},O}),r("DataSources/EntityCollection",["../Core/AssociativeArray","../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Iso8601","../Core/JulianDate","../Core/RuntimeError","../Core/TimeInterval","./Entity"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e){if(0===e._suspendCount){var t=e._addedEntities,r=e._removedEntities,i=e._changedEntities;(0!==i.length||0!==t.length||0!==r.length)&&(e._collectionChanged.raiseEvent(e,t.values,r.values,i.values),t.removeAll(),r.removeAll(),i.removeAll())}}function d(r){this._owner=r,this._entities=new e,this._addedEntities=new e,this._removedEntities=new e,this._changedEntities=new e,this._suspendCount=0,this._collectionChanged=new o,this._id=t()}var p={id:void 0};return d.prototype.suspendEvents=function(){this._suspendCount++},d.prototype.resumeEvents=function(){this._suspendCount--,h(this)},d.collectionChangedEventCallback=void 0,i(d.prototype,{collectionChanged:{get:function(){return this._collectionChanged}},id:{get:function(){return this._id}},values:{get:function(){return this._entities.values}},owner:{get:function(){return this._owner}}}),d.prototype.computeAvailability=function(){for(var e=a.MAXIMUM_VALUE,t=a.MINIMUM_VALUE,i=this._entities.values,n=0,o=i.length;o>n;n++){var l=i[n],c=l.availability;if(r(c)){var h=c.start,d=c.stop;s.lessThan(h,e)&&!h.equals(a.MINIMUM_VALUE)&&(e=h),s.greaterThan(d,t)&&!d.equals(a.MAXIMUM_VALUE)&&(t=d)}}return a.MAXIMUM_VALUE.equals(e)&&(e=a.MINIMUM_VALUE),a.MINIMUM_VALUE.equals(t)&&(t=a.MAXIMUM_VALUE),new u({start:e,stop:t})},d.prototype.add=function(e){e instanceof c||(e=new c(e));var t=e.id,r=this._entities;if(r.contains(t))throw new l("An entity with id "+t+" already exists in this collection.");return e.entityCollection=this,r.set(t,e),this._removedEntities.remove(t)||this._addedEntities.set(t,e),e.definitionChanged.addEventListener(d.prototype._onEntityDefinitionChanged,this),h(this),e},d.prototype.remove=function(e){return r(e)?this.removeById(e.id):!1},d.prototype.contains=function(e){return this._entities.get(e.id)===e},d.prototype.removeById=function(e){if(!r(e))return!1;var t=this._entities,i=t.get(e);return this._entities.remove(e)?(this._addedEntities.remove(e)||(this._removedEntities.set(e,i),this._changedEntities.remove(e)),this._entities.remove(e),i.definitionChanged.removeEventListener(d.prototype._onEntityDefinitionChanged,this),h(this),!0):!1},d.prototype.removeAll=function(){for(var e=this._entities,t=e.length,i=e.values,n=this._addedEntities,o=this._removedEntities,a=0;t>a;a++){var s=i[a],l=s.id,u=n.get(l);r(u)||(s.definitionChanged.removeEventListener(d.prototype._onEntityDefinitionChanged,this),o.set(l,s))}e.removeAll(),n.removeAll(),this._changedEntities.removeAll(),h(this)},d.prototype.getById=function(e){return this._entities.get(e)},d.prototype.getOrCreateEntity=function(e){var t=this._entities.get(e);return r(t)||(p.id=e,t=new c(p),this.add(t)),t},d.prototype._onEntityDefinitionChanged=function(e){var t=e.id;this._addedEntities.contains(t)||this._changedEntities.set(t,e),h(this)},d}),r("DataSources/CompositeEntityCollection",["../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Math","./Entity","./EntityCollection"],function(e,t,r,i,n,o,a){"use strict";function s(e){for(var t=e.propertyNames,r=t.length,i=0;r>i;i++)e[t[i]]=void 0}function l(e,t,r,i){f[0]=r,f[1]=i.id,t[JSON.stringify(f)]=i.definitionChanged.addEventListener(h.prototype._onDefinitionChanged,e)}function u(e,t,r,i){f[0]=r,f[1]=i.id;var n=JSON.stringify(f);t[n](),t[n]=void 0}function c(e){if(e._shouldRecomposite=!0,0===e._suspendCount){var r,i,n,c,d,p,f=e._collections,v=f.length,_=e._collectionsCopy,g=_.length,y=e._composite,C=new a(e),E=e._eventHash;for(r=0;g>r;r++)for(d=_[r],d.collectionChanged.removeEventListener(h.prototype._onCollectionChanged,e),n=d.values,p=d.id,c=n.length-1;c>-1;c--)i=n[c],u(e,E,p,i);for(r=v-1;r>=0;r--)for(d=f[r],d.collectionChanged.addEventListener(h.prototype._onCollectionChanged,e),n=d.values,p=d.id,c=n.length-1;c>-1;c--){i=n[c],l(e,E,p,i);var S=C.getById(i.id);t(S)||(S=y.getById(i.id),t(S)?s(S):(m.id=i.id,S=new o(m)),C.add(S)),S.merge(i)}e._collectionsCopy=f.slice(0),y.suspendEvents(),y.removeAll();var w=C.values;for(r=0;r<w.length;r++)y.add(w[r]);y.resumeEvents()}}function h(r){this._composite=new a(this),this._suspendCount=0,this._collections=t(r)?r.slice():[],this._collectionsCopy=[],this._id=e(),this._eventHash={},c(this),this._shouldRecomposite=!1}function d(e,t){var r=e.indexOf(t);return r}function p(e,t,r){var i=e._collections;if(t=n.clamp(t,0,i.length-1),r=n.clamp(r,0,i.length-1),t!==r){var o=i[t];i[t]=i[r],i[r]=o,c(e)}}var m={id:void 0},f=new Array(2);return r(h.prototype,{collectionChanged:{get:function(){return this._composite._collectionChanged}},id:{get:function(){return this._id}},values:{get:function(){return this._composite.values}}}),h.prototype.addCollection=function(e,r){var i=t(r);i?this._collections.splice(r,0,e):(r=this._collections.length,this._collections.push(e)),c(this)},h.prototype.removeCollection=function(e){var t=this._collections.indexOf(e);return-1!==t?(this._collections.splice(t,1),c(this),!0):!1},h.prototype.removeAllCollections=function(){this._collections.length=0,c(this)},h.prototype.containsCollection=function(e){return-1!==this._collections.indexOf(e)},h.prototype.contains=function(e){return this._composite.contains(e)},h.prototype.indexOfCollection=function(e){return this._collections.indexOf(e)},h.prototype.getCollection=function(e){return this._collections[e]},h.prototype.getCollectionsLength=function(){return this._collections.length},h.prototype.raiseCollection=function(e){var t=d(this._collections,e);p(this,t,t+1)},h.prototype.lowerCollection=function(e){var t=d(this._collections,e);p(this,t,t-1)},h.prototype.raiseCollectionToTop=function(e){var t=d(this._collections,e);t!==this._collections.length-1&&(this._collections.splice(t,1),this._collections.push(e),c(this))},h.prototype.lowerCollectionToBottom=function(e){var t=d(this._collections,e);0!==t&&(this._collections.splice(t,1),this._collections.splice(0,0,e),c(this))},h.prototype.suspendEvents=function(){this._suspendCount++,this._composite.suspendEvents()},h.prototype.resumeEvents=function(){this._suspendCount--,this._shouldRecomposite&&0===this._suspendCount&&(c(this),this._shouldRecomposite=!1),this._composite.resumeEvents()},h.prototype.computeAvailability=function(){return this._composite.computeAvailability()},h.prototype.getById=function(e){return this._composite.getById(e)},h.prototype._onCollectionChanged=function(e,r,i){var n=this._collectionsCopy,a=n.length,c=this._composite;c.suspendEvents();var h,d,p,f,v=i.length,_=this._eventHash,g=e.id;for(h=0;v>h;h++){var y=i[h];u(this,_,g,y);var C=y.id;for(d=a-1;d>=0;d--)p=n[d].getById(C),t(p)&&(t(f)||(f=c.getById(C),s(f)),f.merge(p));t(f)||c.removeById(C),f=void 0}var E=r.length;for(h=0;E>h;h++){var S=r[h];l(this,_,g,S);var w=S.id;for(d=a-1;d>=0;d--)p=n[d].getById(w),t(p)&&(t(f)||(f=c.getById(w),t(f)?s(f):(m.id=w,f=new o(m),c.add(f))),f.merge(p));f=void 0}c.resumeEvents()},h.prototype._onDefinitionChanged=function(e,r,i,n){for(var o=this._collections,a=this._composite,s=o.length,l=e.id,u=a.getById(l),c=u[r],h=!t(c),d=!0,p=s-1;p>=0;p--){var m=o[p].getById(e.id);if(t(m)){var f=m[r];if(t(f)){if(d){if(d=!1,!t(f.merge)||!t(f.clone)){c=f;break}c=f.clone(c)}c.merge(f)}}}h&&-1===u.propertyNames.indexOf(r)&&u.addProperty(r),u[r]=c},h}),r("DataSources/CompositeProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(t,r,i,n){function o(){i.raiseEvent(t)}var a=[];r.removeAll();for(var s=n.length,l=0;s>l;l++){var u=n.get(l);e(u.data)&&-1===a.indexOf(u.data)&&r.add(u.data.definitionChanged,o)}}function l(){this._eventHelper=new n,this._definitionChanged=new i,this._intervals=new o,this._intervals.changedEvent.addEventListener(l.prototype._intervalsChanged,this)}return t(l.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),l.prototype.getValue=function(t,r){var i=this._intervals.findDataForIntervalContainingDate(t);return e(i)?i.getValue(t,r):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._intervals.equals(e._intervals,a.equals)},l.prototype._intervalsChanged=function(){s(this,this._eventHelper,this._definitionChanged,this._intervals),this._definitionChanged.raiseEvent(this)},l}),r("DataSources/CompositeMaterialProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./CompositeProperty","./Property"],function(e,t,r,i,n,o){"use strict";function a(){this._definitionChanged=new i,this._composite=new n,this._composite.definitionChanged.addEventListener(a.prototype._raiseDefinitionChanged,this)}return t(a.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite._intervals}}}),a.prototype.getType=function(t){var r=this._composite._intervals.findDataForIntervalContainingDate(t);return e(r)?r.getType(t):void 0},a.prototype.getValue=function(t,r){var i=this._composite._intervals.findDataForIntervalContainingDate(t);return e(i)?i.getValue(t,r):void 0},a.prototype.equals=function(e){return this===e||e instanceof a&&this._composite.equals(e._composite,o.equals)},a.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},a}),r("DataSources/CompositePositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./CompositeProperty","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(t){this._referenceFrame=e(t,o.FIXED),this._definitionChanged=new n,this._composite=new a,this._composite.definitionChanged.addEventListener(l.prototype._raiseDefinitionChanged,this)}return r(l.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite.intervals}},referenceFrame:{get:function(){return this._referenceFrame},set:function(e){this._referenceFrame=e}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,r,i){var n=this._composite._intervals.findDataForIntervalContainingDate(e);return t(n)?n.getValueInReferenceFrame(e,r,i):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._referenceFrame===e._referenceFrame&&this._composite.equals(e._composite,s.equals)},l.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},l}),r("DataSources/CorridorGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CorridorGeometry","../Core/CorridorOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C){"use strict";function E(e){this.id=e,this.vertexFormat=void 0,this.positions=void 0,this.width=void 0,this.cornerType=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0}function S(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(S.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new E(e),this._onEntityPropertyChanged(e,"corridor",e.corridor,void 0)}function w(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new E(t._entity)}var T=new v(e.WHITE),x=new _(!0),b=new _(!0),P=new _(!1),A=new _(e.BLACK),I=new e;return a(S,{perInstanceColorAppearanceType:{value:m},materialAppearanceType:{value:p}}),a(S.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),S.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e);
},S.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},S.prototype.createFillGeometryInstance=function(i){var n,a,s=this._entity,l=s.isAvailable(i),u=new d(l&&s.isShowing&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var h=e.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(h=this._materialProperty.color.getValue(i)),a=t.fromColor(h),n={show:u,color:a}}else n={show:u};return new c({id:s,geometry:new r(this._options),attributes:n})},S.prototype.createOutlineGeometryInstance=function(r){var n=this._entity,o=n.isAvailable(r),a=C.getValueOrDefault(this._outlineColorProperty,r,e.BLACK);return new c({id:n,geometry:new i(this._options),attributes:{show:new d(o&&n.isShowing&&this._showProperty.getValue(r)&&this._showOutlineProperty.getValue(r)),color:t.fromColor(a)}})},S.prototype.isDestroyed=function(){return!1},S.prototype.destroy=function(){this._entitySubscription(),s(this)},S.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"corridor"===t){var a=this._entity.corridor;if(!o(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,l=o(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,u=a.outline,c=o(u);if(c&&u.isConstant&&(c=u.getValue(h.MINIMUM_VALUE)),!l&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=a.positions,f=a.show;if(o(f)&&f.isConstant&&!f.getValue(h.MINIMUM_VALUE)||!o(d))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var _=n(a.material,T),g=_ instanceof v;this._materialProperty=_,this._fillProperty=n(s,b),this._showProperty=n(f,x),this._showOutlineProperty=n(a.outline,P),this._outlineColorProperty=c?n(a.outlineColor,A):void 0;var y=a.height,E=a.extrudedHeight,S=a.granularity,w=a.width,I=a.outlineWidth,M=a.cornerType;if(this._isClosed=o(E),this._fillEnabled=l,this._outlineEnabled=c,d.isConstant&&C.isConstant(y)&&C.isConstant(E)&&C.isConstant(S)&&C.isConstant(w)&&C.isConstant(I)&&C.isConstant(M)){var D=this._options;D.vertexFormat=g?m.VERTEX_FORMAT:p.MaterialSupport.TEXTURED.vertexFormat,D.positions=d.getValue(h.MINIMUM_VALUE,D.positions),D.height=o(y)?y.getValue(h.MINIMUM_VALUE):void 0,D.extrudedHeight=o(E)?E.getValue(h.MINIMUM_VALUE):void 0,D.granularity=o(S)?S.getValue(h.MINIMUM_VALUE):void 0,D.width=o(w)?w.getValue(h.MINIMUM_VALUE):void 0,D.cornerType=o(M)?M.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=o(I)?I.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},S.prototype.createDynamicUpdater=function(e){return new w(e,this)},w.prototype.update=function(n){var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.corridor;if(l.isShowing&&l.isAvailable(n)&&C.getValueOrDefault(u.show,n,!0)){var h=this._options,d=C.getValueOrUndefined(u.positions,n,h.positions),v=C.getValueOrUndefined(u.width,n);if(o(d)&&o(v)){if(h.positions=d,h.width=v,h.height=C.getValueOrUndefined(u.height,n),h.extrudedHeight=C.getValueOrUndefined(u.extrudedHeight,n),h.granularity=C.getValueOrUndefined(u.granularity,n),h.cornerType=C.getValueOrUndefined(u.cornerType,n),!o(u.fill)||u.fill.getValue(n)){var _=y.getValue(n,s.fillMaterialProperty,this._material);this._material=_;var g=new p({material:_,translucent:_.isTranslucent(),closed:o(h.extrudedHeight)});h.vertexFormat=g.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:new r(h)}),appearance:g,asynchronous:!1}))}if(o(u.outline)&&u.outline.getValue(n)){h.vertexFormat=m.VERTEX_FORMAT;var E=C.getValueOrClonedDefault(u.outlineColor,n,e.BLACK,I),S=C.getValueOrDefault(u.outlineWidth,n,1),w=1!==E.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:new i(h),attributes:{color:t.fromColor(E)}}),appearance:new m({flat:!0,translucent:w,renderState:{lineWidth:s._scene.clampLineWidth(S)}}),asynchronous:!1}))}}}},w.prototype.getBoundingSphere=function(e,t){return g(e,this._primitive,this._outlinePrimitive,t)},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},S}),r("DataSources/DataSource",["../Core/defineProperties","../Core/DeveloperError"],function(e,t){"use strict";function r(){t.throwInstantiationError()}return e(r.prototype,{name:{get:t.throwInstantiationError},clock:{get:t.throwInstantiationError},entities:{get:t.throwInstantiationError},isLoading:{get:t.throwInstantiationError},changedEvent:{get:t.throwInstantiationError},errorEvent:{get:t.throwInstantiationError},loadingEvent:{get:t.throwInstantiationError}}),r.prototype.update=t.throwInstantiationError,r.setLoading=function(e,t){e._isLoading!==t&&(t?e._entityCollection.suspendEvents():e._entityCollection.resumeEvents(),e._isLoading=t,e._loading.raiseEvent(e,t))},r}),r("DataSources/CustomDataSource",["../Core/defineProperties","../Core/Event","./DataSource","./EntityCollection"],function(e,t,r,i){"use strict";function n(e){this._name=e,this._clock=void 0,this._changed=new t,this._error=new t,this._isLoading=!1,this._loading=new t,this._entityCollection=new i(this)}return e(n.prototype,{name:{get:function(){return this._name},set:function(e){this._name!==e&&(this._name=e,this._changed.raiseEvent(this))}},clock:{get:function(){return this._clock},set:function(e){this._clock!==e&&(this._clock=e,this._changed.raiseEvent(this))}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading},set:function(e){r.setLoading(this,e)}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),n}),r("DataSources/CylinderGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CylinderGeometry","../Core/CylinderOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E){"use strict";function S(e){this.id=e,this.vertexFormat=void 0,this.length=void 0,this.topRadius=void 0,this.bottomRadius=void 0,this.slices=void 0,this.numberOfVerticalLines=void 0}function w(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(w.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new S(e),this._onEntityPropertyChanged(e,"cylinder",e.cylinder,void 0)}function T(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new S(t._entity)}var x=new _(t.WHITE),b=new g(!0),P=new g(!0),A=new g(!1),I=new g(t.BLACK),M=new t;return s(w,{perInstanceColorAppearanceType:{value:f},materialAppearanceType:{value:m}}),s(w.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!a(this._entity.availability)&&E.isConstant(this._showProperty)&&E.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!a(this._entity.availability)&&E.isConstant(this._showProperty)&&E.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),w.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},w.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},w.prototype.createFillGeometryInstance=function(e){var n,o,s=this._entity,l=s.isAvailable(e),u=new p(l&&s.isShowing&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof _){var c=t.WHITE;a(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(c=this._materialProperty.color.getValue(e)),o=r.fromColor(c),n={show:u,color:o}}else n={show:u};return new h({id:s,geometry:new i(this._options),modelMatrix:s._getModelMatrix(d.MINIMUM_VALUE),attributes:n})},w.prototype.createOutlineGeometryInstance=function(e){var i=this._entity,o=i.isAvailable(e),a=E.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new h({id:i,geometry:new n(this._options),modelMatrix:i._getModelMatrix(d.MINIMUM_VALUE),attributes:{show:new p(o&&i.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:r.fromColor(a)}})},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){this._entitySubscription(),l(this)},w.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"position"===t||"orientation"===t||"cylinder"===t){var n=e.cylinder;if(!a(n))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=n.fill,l=a(s)&&s.isConstant?s.getValue(d.MINIMUM_VALUE):!0,u=n.outline,c=a(u);if(c&&u.isConstant&&(c=u.getValue(d.MINIMUM_VALUE)),!l&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var h=e.position,p=n.length,v=n.topRadius,g=n.bottomRadius,y=n.show;if(a(y)&&y.isConstant&&!y.getValue(d.MINIMUM_VALUE)||!a(h)||!a(p)||!a(v)||!a(g))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var C=o(n.material,x),S=C instanceof _;this._materialProperty=C,this._fillProperty=o(s,P),this._showProperty=o(y,b),this._showOutlineProperty=o(n.outline,A),this._outlineColorProperty=c?o(n.outlineColor,I):void 0;var w=n.slices,T=n.outlineWidth,M=n.numberOfVerticalLines;if(this._fillEnabled=l,this._outlineEnabled=c,h.isConstant&&E.isConstant(e.orientation)&&p.isConstant&&v.isConstant&&g.isConstant&&E.isConstant(w)&&E.isConstant(T)&&E.isConstant(M)){var D=this._options;D.vertexFormat=S?f.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,D.length=p.getValue(d.MINIMUM_VALUE),D.topRadius=v.getValue(d.MINIMUM_VALUE),D.bottomRadius=g.getValue(d.MINIMUM_VALUE),D.slices=a(w)?w.getValue(d.MINIMUM_VALUE):void 0,D.numberOfVerticalLines=a(M)?M.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=a(T)?T.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},w.prototype.createDynamicUpdater=function(e){return new T(e,this)},T.prototype.update=function(e){var o=this._primitives;o.removeAndDestroy(this._primitive),o.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.cylinder;if(l.isShowing&&l.isAvailable(e)&&E.getValueOrDefault(u.show,e,!0)){var c=this._options,d=l._getModelMatrix(e),p=E.getValueOrUndefined(u.length,e),_=E.getValueOrUndefined(u.topRadius,e),g=E.getValueOrUndefined(u.bottomRadius,e);if(a(d)&&a(p)&&a(_)&&a(g)){if(c.length=p,c.topRadius=_,c.bottomRadius=g,c.slices=E.getValueOrUndefined(u.slices,e),c.numberOfVerticalLines=E.getValueOrUndefined(u.numberOfVerticalLines,e),E.getValueOrDefault(u.fill,e,!0)){var y=C.getValue(e,s.fillMaterialProperty,this._material);this._material=y;var S=new m({material:y,translucent:y.isTranslucent(),closed:!0});c.vertexFormat=S.vertexFormat,this._primitive=o.add(new v({geometryInstances:new h({id:l,geometry:new i(c),modelMatrix:d}),appearance:S,asynchronous:!1}))}if(E.getValueOrDefault(u.outline,e,!1)){c.vertexFormat=f.VERTEX_FORMAT;var w=E.getValueOrClonedDefault(u.outlineColor,e,t.BLACK,M),T=E.getValueOrDefault(u.outlineWidth,e,1),x=1!==w.alpha;this._outlinePrimitive=o.add(new v({geometryInstances:new h({id:l,geometry:new n(c),modelMatrix:d,attributes:{color:r.fromColor(w)}}),appearance:new f({flat:!0,translucent:x,renderState:{lineWidth:s._scene.clampLineWidth(T)}}),asynchronous:!1}))}}}},T.prototype.getBoundingSphere=function(e,t){return y(e,this._primitive,this._outlinePrimitive,t)},T.prototype.isDestroyed=function(){return!1},T.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),l(this)},w}),r("Scene/LabelStyle",["../Core/freezeObject"],function(e){"use strict";var t={FILL:0,OUTLINE:1,FILL_AND_OUTLINE:2};return e(t)}),r("DataSources/DataSourceClock",["../Core/Clock","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","./createRawPropertyDescriptor"],function(e,t,r,i,n,o,a,s){"use strict";function l(){this._startTime=void 0,this._stopTime=void 0,this._currentTime=void 0,this._clockRange=void 0,this._clockStep=void 0,this._multiplier=void 0,this._definitionChanged=new o}return i(l.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},startTime:s("startTime"),stopTime:s("stopTime"),currentTime:s("currentTime"),clockRange:s("clockRange"),clockStep:s("clockStep"),multiplier:s("multiplier")}),l.prototype.clone=function(e){return r(e)||(e=new l),e.startTime=this.startTime,e.stopTime=this.stopTime,e.currentTime=this.currentTime,e.clockRange=this.clockRange,e.clockStep=this.clockStep,e.multiplier=this.multiplier,e},l.prototype.equals=function(e){return this===e||r(e)&&a.equals(this.startTime,e.startTime)&&a.equals(this.stopTime,e.stopTime)&&a.equals(this.currentTime,e.currentTime)&&this.clockRange===e.clockRange&&this.clockStep===e.clockStep&&this.multiplier===e.multiplier},l.prototype.merge=function(e){this.startTime=t(this.startTime,e.startTime),this.stopTime=t(this.stopTime,e.stopTime),this.currentTime=t(this.currentTime,e.currentTime),this.clockRange=t(this.clockRange,e.clockRange),this.clockStep=t(this.clockStep,e.clockStep),this.multiplier=t(this.multiplier,e.multiplier)},l.prototype.getValue=function(t){return r(t)||(t=new e),t.startTime=this.startTime,t.stopTime=this.stopTime,t.clockRange=this.clockRange,t.clockStep=this.clockStep,t.multiplier=this.multiplier,t.currentTime=this.currentTime,t},l}),r("DataSources/GridMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){e=r(e,r.EMPTY_OBJECT),this._definitionChanged=new o,this._color=void 0,this._colorSubscription=void 0,this._cellAlpha=void 0,this._cellAlphaSubscription=void 0,this._lineCount=void 0,this._lineCountSubscription=void 0,this._lineThickness=void 0,this._lineThicknessSubscription=void 0,this._lineOffset=void 0,this._lineOffsetSubscription=void 0,this.color=e.color,this.cellAlpha=e.cellAlpha,this.lineCount=e.lineCount,this.lineThickness=e.lineThickness,this.lineOffset=e.lineOffset}var u=t.WHITE,c=.1,h=new e(8,8),d=new e(0,0),p=new e(1,1);return n(l.prototype,{isConstant:{get:function(){return s.isConstant(this._color)&&s.isConstant(this._cellAlpha)&&s.isConstant(this._lineCount)&&s.isConstant(this._lineThickness)&&s.isConstant(this._lineOffset)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color"),cellAlpha:a("cellAlpha"),lineCount:a("lineCount"),lineThickness:a("lineThickness"),lineOffset:a("lineOffset")}),l.prototype.getType=function(e){return"Grid"},l.prototype.getValue=function(e,t){return i(t)||(t={}),t.color=s.getValueOrClonedDefault(this._color,e,u,t.color),t.cellAlpha=s.getValueOrDefault(this._cellAlpha,e,c),t.lineCount=s.getValueOrClonedDefault(this._lineCount,e,h,t.lineCount),t.lineThickness=s.getValueOrClonedDefault(this._lineThickness,e,p,t.lineThickness),t.lineOffset=s.getValueOrClonedDefault(this._lineOffset,e,d,t.lineOffset),t},l.prototype.equals=function(e){return this===e||e instanceof l&&s.equals(this._color,e._color)&&s.equals(this._cellAlpha,e._cellAlpha)&&s.equals(this._lineCount,e._lineCount)&&s.equals(this._lineThickness,e._lineThickness)&&s.equals(this._lineOffset,e._lineOffset)},l}),r("DataSources/PolylineGlowMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this._glowPower=void 0,this._glowPowerSubscription=void 0,this.color=e.color,this.glowPower=e.glowPower}var l=e.WHITE,u=.25;return i(s.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._glow)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),glowPower:o("glowPower")}),s.prototype.getType=function(e){return"PolylineGlow"},s.prototype.getValue=function(e,t){return r(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,l,t.color),t.glowPower=a.getValueOrDefault(this._glowPower,e,u,t.glowPower),t},s.prototype.equals=function(e){return this===e||e instanceof s&&a.equals(this._color,e._color)&&a.equals(this._glowPower,e._glowPower)},s}),r("DataSources/PolylineOutlineMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this.color=e.color,this.outlineColor=e.outlineColor,this.outlineWidth=e.outlineWidth}var l=e.WHITE,u=e.BLACK,c=1;return i(s.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._outlineColor)&&a.isConstant(this._outlineWidth)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth")}),s.prototype.getType=function(e){return"PolylineOutline"},s.prototype.getValue=function(e,t){return r(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,l,t.color),t.outlineColor=a.getValueOrClonedDefault(this._outlineColor,e,u,t.outlineColor),t.outlineWidth=a.getValueOrDefault(this._outlineWidth,e,c),t},s.prototype.equals=function(e){return this===e||e instanceof s&&a.equals(this._color,e._color)&&a.equals(this._outlineColor,e._outlineColor)&&a.equals(this._outlineWidth,e._outlineWidth)},s}),r("DataSources/PositionPropertyArray",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/ReferenceFrame","./Property"],function(e,t,r,i,n,o,a,s){"use strict";function l(t,r){this._value=void 0,this._definitionChanged=new n,this._eventHelper=new o,this._referenceFrame=e(r,a.FIXED),this.setValue(t)}return r(l.prototype,{isConstant:{get:function(){var e=this._value;if(!t(e))return!0;for(var r=e.length,i=0;r>i;i++)if(!s.isConstant(e[i]))return!1;return!0}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,r,i){var n=this._value;if(t(n)){var o=n.length;t(i)||(i=new Array(o));for(var a=0,s=0;o>a;){var l=n[a],u=l.getValueInReferenceFrame(e,r,i[a]);t(u)&&(i[s]=u,s++),a++}return i.length=s,i}},l.prototype.setValue=function(e){var r=this._eventHelper;if(r.removeAll(),t(e)){this._value=e.slice();for(var i=e.length,n=0;i>n;n++){var o=e[n];t(o)&&r.add(o.definitionChanged,l.prototype._raiseDefinitionChanged,this)}}else this._value=void 0;this._definitionChanged.raiseEvent(this)},l.prototype.equals=function(e){return this===e||e instanceof l&&this._referenceFrame===e._referenceFrame&&s.arrayEquals(this._value,e._value)},l.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},l}),r("DataSources/ReferenceProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/RuntimeError","./Property"],function(e,t,r,i,n,o){"use strict";function a(t){var r=!0;if(t._resolveEntity){var i=t._targetCollection.getById(t._targetId);if(e(i)?(i.definitionChanged.addEventListener(l.prototype._onTargetEntityDefinitionChanged,t),t._targetEntity=i,t._resolveEntity=!1):(i=t._targetEntity,r=!1),!e(i))throw new n('target entity "'+t._targetId+'" could not be resolved.')}return r}function s(t){var r=t._targetProperty;if(t._resolveProperty){var i=a(t),o=t._targetPropertyNames;r=t._targetEntity;for(var s=o.length,l=0;s>l&&e(r);l++)r=r[o[l]];if(e(r))t._targetProperty=r,t._resolveProperty=!i;else if(!e(t._targetProperty))throw new n('targetProperty "'+t._targetId+"."+o.join(".")+'" could not be resolved.')}return r}function l(e,t,r){this._targetCollection=e,this._targetId=t,this._targetPropertyNames=r,this._targetProperty=void 0,this._targetEntity=void 0,this._definitionChanged=new i,this._resolveEntity=!0,this._resolveProperty=!0,e.collectionChanged.addEventListener(l.prototype._onCollectionChanged,this)}return t(l.prototype,{isConstant:{get:function(){return o.isConstant(s(this))}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return s(this).referenceFrame}},targetId:{get:function(){return this._targetId}},targetCollection:{get:function(){return this._targetCollection}},targetPropertyNames:{get:function(){return this._targetPropertyNames}},resolvedProperty:{get:function(){return s(this)}}}),l.fromString=function(e,t){for(var r,i=[],n=!0,o=!1,a="",s=0;s<t.length;++s){var u=t.charAt(s);o?(a+=u,o=!1):"\\"===u?o=!0:n&&"#"===u?(r=a,n=!1,a=""):n||"."!==u?a+=u:(i.push(a),a="")}return i.push(a),new l(e,r,i)},l.prototype.getValue=function(e,t){return s(this).getValue(e,t)},l.prototype.getValueInReferenceFrame=function(e,t,r){return s(this).getValueInReferenceFrame(e,t,r)},l.prototype.getType=function(e){return s(this).getType(e)},l.prototype.equals=function(e){if(this===e)return!0;var t=this._targetPropertyNames,r=e._targetPropertyNames;if(this._targetCollection!==e._targetCollection||this._targetId!==e._targetId||t.length!==r.length)return!1;for(var i=this._targetPropertyNames.length,n=0;i>n;n++)if(t[n]!==r[n])return!1;return!0},l.prototype._onTargetEntityDefinitionChanged=function(e,t,r,i){this._targetPropertyNames[0]===t&&(this._resolveProperty=!0,this._definitionChanged.raiseEvent(this))},l.prototype._onCollectionChanged=function(t,r,i){var n=this._targetEntity;e(n)&&(-1!==i.indexOf(n)?(n.definitionChanged.removeEventListener(l.prototype._onTargetEntityDefinitionChanged,this),this._resolveEntity=!0,this._resolveProperty=!0):this._resolveEntity&&(s(this),this._resolveEntity||this._definitionChanged.raiseEvent(this)))},l}),r("DataSources/Rotation",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Math"],function(e,t,r,i){"use strict";var n={packedLength:1,pack:function(t,r,i){i=e(i,0),r[i]=t},unpack:function(t,r,i){return r=e(r,0),t[r]},convertPackedArrayForInterpolation:function(t,r,n,o){r=e(r,0),n=e(n,t.length);for(var a,s=0,l=n-r+1;l>s;s++){var u=t[r+s];0===s||Math.abs(a-u)<Math.PI?o[s]=u:o[s]=u-i.TWO_PI,a=u}},unpackInterpolationResult:function(e,t,r,n,o){return o=e[0],0>o?o+i.TWO_PI:o}};return n}),r("DataSources/SampledProperty",["../Core/binarySearch","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ExtrapolationType","../Core/JulianDate","../Core/LinearApproximation"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(e,t,r){var i,n=e.length,o=r.length,a=n+o;if(e.length=a,n!==t){var s=n-1;for(i=a-1;i>=t;i--)e[i]=e[s--]}for(i=0;o>i;i++)e[t++]=r[i]}function c(e,t){return e instanceof s?e:"string"==typeof e?s.fromIso8601(e):s.addSeconds(t,e,new s)}function h(t,i,n,o,a){for(var l,h,d,p,v,_,g=0;g<o.length;){v=c(o[g],t),d=e(i,v,s.compare);var y=0,C=0;if(0>d){for(d=~d,p=d*a,h=void 0,_=i[d];g<o.length&&(v=c(o[g],t),!(r(h)&&s.compare(h,v)>=0||r(_)&&s.compare(v,_)>=0));){for(m[y++]=v,g+=1,l=0;a>l;l++)f[C++]=o[g],g+=1;h=v}y>0&&(f.length=C,u(n,p,f),m.length=y,u(i,d,m))}else{for(l=0;a>l;l++)g++,n[d*a+l]=o[g];g++}}}function d(e,i){var n=e;n===Number&&(n=p);var s,u=n.packedLength,c=t(n.packedInterpolationLength,u),h=0;if(r(i)){var d=i.length;s=new Array(d);for(var m=0;d>m;m++){var f=i[m];f===Number&&(f=p);var v=f.packedLength;u+=v,c+=t(f.packedInterpolationLength,v),s[m]=f}h=d}this._type=e,this._innerType=n,this._interpolationDegree=1,this._interpolationAlgorithm=l,this._numberOfPoints=0,this._times=[],this._values=[],this._xTable=[],this._yTable=[],this._packedLength=u,this._packedInterpolationLength=c,this._updateTableLength=!0,this._interpolationResult=new Array(c),this._definitionChanged=new o,this._derivativeTypes=i,this._innerDerivativeTypes=s,this._inputOrder=h,this._forwardExtrapolationType=a.NONE,this._forwardExtrapolationDuration=0,this._backwardExtrapolationType=a.NONE,this._backwardExtrapolationDuration=0}var p={packedLength:1,pack:function(e,r,i){i=t(i,0),r[i]=e},unpack:function(e,r,i){return r=t(r,0),e[r]}},m=[],f=[];return i(d.prototype,{isConstant:{get:function(){return 0===this._values.length}},definitionChanged:{get:function(){return this._definitionChanged}},type:{get:function(){return this._type}},derivativeTypes:{get:function(){return this._derivativeTypes}},interpolationDegree:{get:function(){return this._interpolationDegree}},interpolationAlgorithm:{get:function(){return this._interpolationAlgorithm}},forwardExtrapolationType:{get:function(){return this._forwardExtrapolationType},set:function(e){this._forwardExtrapolationType!==e&&(this._forwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},forwardExtrapolationDuration:{get:function(){return this._forwardExtrapolationDuration},set:function(e){this._forwardExtrapolationDuration!==e&&(this._forwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationType:{get:function(){return this._backwardExtrapolationType},set:function(e){this._backwardExtrapolationType!==e&&(this._backwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationDuration:{get:function(){return this._backwardExtrapolationDuration},set:function(e){this._backwardExtrapolationDuration!==e&&(this._backwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}}}),d.prototype.getValue=function(t,i){var n=this._times,o=n.length;if(0!==o){var l,u=this._innerType,c=this._values,h=e(n,t,s.compare);if(0>h){if(h=~h,0===h){var d=n[h];if(l=this._backwardExtrapolationDuration,this._backwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(d,t)>l)return;if(this._backwardExtrapolationType===a.HOLD)return u.unpack(c,0,i)}if(h>=o){h=o-1;var p=n[h];if(l=this._forwardExtrapolationDuration,this._forwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(t,p)>l)return;if(this._forwardExtrapolationType===a.HOLD)return h=o-1,u.unpack(c,h*u.packedLength,i)}var m=this._xTable,f=this._yTable,v=this._interpolationAlgorithm,_=this._packedInterpolationLength,g=this._inputOrder;if(this._updateTableLength){this._updateTableLength=!1;var y=Math.min(v.getRequiredDataPoints(this._interpolationDegree,g),o);y!==this._numberOfPoints&&(this._numberOfPoints=y,m.length=y,f.length=y*_)}var C=this._numberOfPoints-1;if(1>C)return;var E=0,S=o-1,w=S-E+1;if(w>=C+1){var T=h-(C/2|0)-1;E>T&&(T=E);var x=T+C;x>S&&(x=S,T=x-C,E>T&&(T=E)),E=T,S=x}for(var b=S-E+1,P=0;b>P;++P)m[P]=s.secondsDifference(n[E+P],n[S]);if(r(u.convertPackedArrayForInterpolation))u.convertPackedArrayForInterpolation(c,E,S,f);else for(var A=0,I=this._packedLength,M=E*I,D=(S+1)*I;D>M;)f[A]=c[M],M++,A++;var R,O=s.secondsDifference(t,n[S]);if(0!==g&&r(v.interpolate)){var N=Math.floor(_/(g+1));R=v.interpolate(O,m,f,N,g,g,this._interpolationResult)}else R=v.interpolateOrderZero(O,m,f,_,this._interpolationResult);return r(u.unpackInterpolationResult)?u.unpackInterpolationResult(R,c,E,S,i):u.unpack(R,0,i)}return u.unpack(c,h*this._packedLength,i)}},d.prototype.setInterpolationOptions=function(e){var t=!1,r=e.interpolationAlgorithm,i=e.interpolationDegree;this._interpolationAlgorithm!==r&&(this._interpolationAlgorithm=r,t=!0),this._interpolationDegree!==i&&(this._interpolationDegree=i,t=!0),t&&(this._updateTableLength=!0,this._definitionChanged.raiseEvent(this))},d.prototype.addSample=function(e,t,i){var n=this._innerDerivativeTypes,o=r(n),a=this._innerType,s=[];if(s.push(e),a.pack(t,s,s.length),o)for(var l=n.length,u=0;l>u;u++)n[u].pack(i[u],s,s.length);h(void 0,this._times,this._values,s,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},d.prototype.addSamples=function(e,t,i){for(var n=this._innerDerivativeTypes,o=r(n),a=this._innerType,s=e.length,l=[],u=0;s>u;u++)if(l.push(e[u]),a.pack(t[u],l,l.length),o)for(var c=i[u],d=n.length,p=0;d>p;p++)n[p].pack(c[p],l,l.length);h(void 0,this._times,this._values,l,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},d.prototype.addSamplesPackedArray=function(e,t){h(t,this._times,this._values,e,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},d.prototype.equals=function(e){if(this===e)return!0;if(!r(e))return!1;if(this._type!==e._type||this._interpolationDegree!==e._interpolationDegree||this._interpolationAlgorithm!==e._interpolationAlgorithm)return!1;var t=this._derivativeTypes,i=r(t),n=e._derivativeTypes,o=r(n);if(i!==o)return!1;var a,l;if(i){if(l=t.length,l!==n.length)return!1;for(a=0;l>a;a++)if(t[a]!==n[a])return!1}var u=this._times,c=e._times;if(l=u.length,l!==c.length)return!1;for(a=0;l>a;a++)if(!s.equals(u[a],c[a]))return!1;var h=this._values,d=e._values;for(a=0;l>a;a++)if(h[a]!==d[a])return!1;return!0},d._mergeNewSamples=h,d}),r("DataSources/SampledPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty","./Property","./SampledProperty"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(r,i){i=t(i,0);var n;if(i>0){n=new Array(i);for(var s=0;i>s;s++)n[s]=e}this._numberOfDerivatives=i,this._property=new u(e,n),this._definitionChanged=new o,this._referenceFrame=t(r,a.FIXED),this._property._definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this)},this)}return i(c.prototype,{isConstant:{
get:function(){return this._property.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}},interpolationDegree:{get:function(){return this._property.interpolationDegree}},interpolationAlgorithm:{get:function(){return this._property.interpolationAlgorithm}},numberOfDerivatives:{get:function(){return this._numberOfDerivatives}},forwardExtrapolationType:{get:function(){return this._property.forwardExtrapolationType},set:function(e){this._property.forwardExtrapolationType=e}},forwardExtrapolationDuration:{get:function(){return this._property.forwardExtrapolationDuration},set:function(e){this._property.forwardExtrapolationDuration=e}},backwardExtrapolationType:{get:function(){return this._property.backwardExtrapolationType},set:function(e){this._property.backwardExtrapolationType=e}},backwardExtrapolationDuration:{get:function(){return this._property.backwardExtrapolationDuration},set:function(e){this._property.backwardExtrapolationDuration=e}}}),c.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},c.prototype.getValueInReferenceFrame=function(e,t,i){return i=this._property.getValue(e,i),r(i)?s.convertToReferenceFrame(e,i,this._referenceFrame,t,i):void 0},c.prototype.setInterpolationOptions=function(e){this._property.setInterpolationOptions(e)},c.prototype.addSample=function(e,t,r){this._numberOfDerivatives;this._property.addSample(e,t,r)},c.prototype.addSamples=function(e,t,r){this._property.addSamples(e,t,r)},c.prototype.addSamplesPackedArray=function(e,t){this._property.addSamplesPackedArray(e,t)},c.prototype.equals=function(e){return this===e||e instanceof c&&l.equals(this._property,e._property)&&this._referenceFrame===e._referenceFrame},c}),r("DataSources/StripeOrientation",["../Core/freezeObject"],function(e){"use strict";var t={HORIZONTAL:0,VERTICAL:1};return e(t)}),r("DataSources/StripeMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property","./StripeOrientation"],function(e,t,r,i,n,o,a,s){"use strict";function l(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._orientation=void 0,this._orientationSubscription=void 0,this._evenColor=void 0,this._evenColorSubscription=void 0,this._oddColor=void 0,this._oddColorSubscription=void 0,this._offset=void 0,this._offsetSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.orientation=e.orientation,this.evenColor=e.evenColor,this.oddColor=e.oddColor,this.offset=e.offset,this.repeat=e.repeat}var u=s.HORIZONTAL,c=e.WHITE,h=e.BLACK,d=0,p=1;return i(l.prototype,{isConstant:{get:function(){return a.isConstant(this._orientation)&&a.isConstant(this._evenColor)&&a.isConstant(this._oddColor)&&a.isConstant(this._offset)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},orientation:o("orientation"),evenColor:o("evenColor"),oddColor:o("oddColor"),offset:o("offset"),repeat:o("repeat")}),l.prototype.getType=function(e){return"Stripe"},l.prototype.getValue=function(e,t){return r(t)||(t={}),t.horizontal=a.getValueOrDefault(this._orientation,e,u)===s.HORIZONTAL,t.evenColor=a.getValueOrClonedDefault(this._evenColor,e,c,t.evenColor),t.oddColor=a.getValueOrClonedDefault(this._oddColor,e,h,t.oddColor),t.offset=a.getValueOrDefault(this._offset,e,d),t.repeat=a.getValueOrDefault(this._repeat,e,p),t},l.prototype.equals=function(e){return this===e||e instanceof l&&a.equals(this._orientation,e._orientation)&&a.equals(this._evenColor,e._evenColor)&&a.equals(this._oddColor,e._oddColor)&&a.equals(this._offset,e._offset)&&a.equals(this._repeat,e._repeat)},l}),r("DataSources/TimeIntervalCollectionPositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","../Core/TimeIntervalCollection","./PositionProperty","./Property"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(t){this._definitionChanged=new n,this._intervals=new a,this._intervals.changedEvent.addEventListener(u.prototype._intervalsChanged,this),this._referenceFrame=e(t,o.FIXED)}return r(u.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}},referenceFrame:{get:function(){return this._referenceFrame}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,r,i){var n=this._intervals.findDataForIntervalContainingDate(e);return t(n)?s.convertToReferenceFrame(e,n,this._referenceFrame,r,i):void 0},u.prototype.equals=function(e){return this===e||e instanceof u&&this._intervals.equals(e._intervals,l.equals)&&this._referenceFrame===e._referenceFrame},u.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},u}),r("DataSources/TimeIntervalCollectionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n,o){"use strict";function a(){this._definitionChanged=new i,this._intervals=new n,this._intervals.changedEvent.addEventListener(a.prototype._intervalsChanged,this)}return t(a.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),a.prototype.getValue=function(t,r){var i=this._intervals.findDataForIntervalContainingDate(t);return e(i)&&"function"==typeof i.clone?i.clone(r):i},a.prototype.equals=function(e){return this===e||e instanceof a&&this._intervals.equals(e._intervals,o.equals)},a.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},a}),r("DataSources/CzmlDataSource",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/ClockRange","../Core/ClockStep","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/ExtrapolationType","../Core/getFilenameFromUri","../Core/HermitePolynomialApproximation","../Core/isArray","../Core/Iso8601","../Core/JulianDate","../Core/LagrangePolynomialApproximation","../Core/LinearApproximation","../Core/loadJson","../Core/Math","../Core/Quaternion","../Core/Rectangle","../Core/ReferenceFrame","../Core/RuntimeError","../Core/Spherical","../Core/TimeInterval","../Core/TimeIntervalCollection","../Scene/HorizontalOrigin","../Scene/LabelStyle","../Scene/VerticalOrigin","../ThirdParty/Uri","../ThirdParty/when","./BillboardGraphics","./ColorMaterialProperty","./CompositeMaterialProperty","./CompositePositionProperty","./CompositeProperty","./ConstantPositionProperty","./ConstantProperty","./DataSource","./DataSourceClock","./EllipseGraphics","./EllipsoidGraphics","./EntityCollection","./GridMaterialProperty","./ImageMaterialProperty","./LabelGraphics","./ModelGraphics","./NodeTransformationProperty","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGlowMaterialProperty","./PolylineGraphics","./PolylineOutlineMaterialProperty","./PositionPropertyArray","./PropertyBag","./RectangleGraphics","./ReferenceProperty","./Rotation","./SampledPositionProperty","./SampledProperty","./StripeMaterialProperty","./StripeOrientation","./TimeIntervalCollectionPositionProperty","./TimeIntervalCollectionProperty","./WallGraphics"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I,M,D,R,O,N,L,F,B,V,z,k,U,G,W,H,q,j,Y,X,Z,K,Q,J,$,ee,te,re,ie,ne,oe,ae,se,le,ue,ce,he,de,pe,me,fe){"use strict";function ve(e,t){return"#"===t[0]&&(t=nt+t),se.fromString(e,t)}function _e(e){var t=e.rgbaf;if(l(t))return t;var r=e.rgba;if(l(r)){if(r.length===o.length)return[o.byteToFloat(r[0]),o.byteToFloat(r[1]),o.byteToFloat(r[2]),o.byteToFloat(r[3])];var i=r.length;t=new Array(i);for(var n=0;i>n;n+=5)t[n]=r[n],t[n+1]=o.byteToFloat(r[n+1]),t[n+2]=o.byteToFloat(r[n+2]),t[n+3]=o.byteToFloat(r[n+3]),t[n+4]=o.byteToFloat(r[n+4]);return t}}function ge(e,t){var r=s(e.uri,e);if(l(t)){var i=new O(document.location.href);t=new O(t),r=new O(r).resolve(t.resolve(i)).toString()}return r}function ye(e){var t=e.wsenDegrees;if(l(t)){for(var r=t.length,i=0;r>i;i++)t[i]=S.toRadians(t[i]);return t}return e.wsen}function Ce(e){if(l(e.cartesian))return e.cartesian;if(l(e.cartesianVelocity))return e.cartesianVelocity;if(l(e.unitCartesian))return e.unitCartesian;var r,i,n,o=e.unitSpherical;if(l(o)){if(i=o.length,2===i)at.clock=o[0],at.cone=o[1],t.fromSpherical(at,ot),n=[ot.x,ot.y,ot.z];else{var a=0;for(n=new Array(i/3*4),r=0;i>r;r+=4)n[r]=o[a++],at.clock=o[a++],at.cone=o[a++],t.fromSpherical(at,ot),n[r+1]=ot.x,n[r+2]=ot.y,n[r+3]=ot.z}return n}var s=e.cartographicRadians;if(l(s)){if(3===s.length)st.longitude=s[0],st.latitude=s[1],st.height=s[2],h.WGS84.cartographicToCartesian(st,ot),n=[ot.x,ot.y,ot.z];else for(i=s.length,n=new Array(i),r=0;i>r;r+=4)st.longitude=s[r+1],st.latitude=s[r+2],st.height=s[r+3],h.WGS84.cartographicToCartesian(st,ot),n[r]=s[r],n[r+1]=ot.x,n[r+2]=ot.y,n[r+3]=ot.z;return n}var u=e.cartographicDegrees;if(!l(u))throw new b(JSON.stringify(e)+" is not a valid CZML interval.");if(3===u.length)st.longitude=S.toRadians(u[0]),st.latitude=S.toRadians(u[1]),st.height=u[2],h.WGS84.cartographicToCartesian(st,ot),n=[ot.x,ot.y,ot.z];else for(i=u.length,n=new Array(i),r=0;i>r;r+=4)st.longitude=S.toRadians(u[r+1]),st.latitude=S.toRadians(u[r+2]),st.height=u[r+3],h.WGS84.cartographicToCartesian(st,ot),n[r]=u[r],n[r+1]=ot.x,n[r+2]=ot.y,n[r+3]=ot.z;return n}function Ee(e,t){var r=e[t],i=e[t+1],n=e[t+2],o=e[t+3],a=1/Math.sqrt(r*r+i*i+n*n+o*o);e[t]=r*a,e[t+1]=i*a,e[t+2]=n*a,e[t+3]=o*a}function Se(e){var t=e.unitQuaternion;if(l(t)){if(4===t.length)return Ee(t,0),t;for(var r=1;r<t.length;r+=5)Ee(t,r)}return t}function we(r,i,n){switch(r){case Boolean:return s(i["boolean"],i);case e:return i.cartesian2;case t:return Ce(i);case o:return _e(i);case de:return de[s(i.stripeOrientation,i)];case M:return M[s(i.horizontalOrigin,i)];case Image:return ge(i,n);case g:return g.fromIso8601(s(i.date,i));case D:return D[s(i.labelStyle,i)];case le:return s(i.number,i);case Number:return s(i.number,i);case String:return s(i.string,i);case Array:return i.array;case w:return Se(i);case T:return ye(i);case O:return ge(i,n);case R:return R[s(i.verticalOrigin,i)];default:throw new b(r)}}function Te(e,t){var r=e.interpolationAlgorithm;(l(r)||l(e.interpolationDegree))&&t.setInterpolationOptions({interpolationAlgorithm:ut[r],interpolationDegree:e.interpolationDegree});var i=e.forwardExtrapolationType;l(i)&&(t.forwardExtrapolationType=p[i]);var n=e.forwardExtrapolationDuration;l(n)&&(t.forwardExtrapolationDuration=n);var o=e.backwardExtrapolationType;l(o)&&(t.backwardExtrapolationType=p[o]);var a=e.backwardExtrapolationDuration;l(a)&&(t.backwardExtrapolationDuration=a)}function xe(e,t,r,i,n,o,a){var u,c=i.interval;l(c)?(ct.iso8601=c,u=A.fromIso8601(ct),l(n)&&(u=A.intersect(u,n,lt))):l(n)&&(u=n);var h,d,p,m,f=l(i.reference),v=l(u)&&!u.equals(_.MAXIMUM_INTERVAL);f||(p=we(e,i,o),h=s(e.packedLength,1),m=s(p.length,1),d=!l(i.array)&&"string"!=typeof p&&m>h);var y="function"==typeof e.unpack&&e!==le;if(!d&&!v)return void(f?t[r]=ve(a,i.reference):y?t[r]=new U(e.unpack(p,0)):t[r]=new U(p));var C,E=t[r],S=i.epoch;if(l(S)&&(C=g.fromIso8601(S)),d&&!v)return E instanceof ce||(E=new ce(e),t[r]=E),E.addSamplesPackedArray(p,C),void Te(i,E);var w;if(!d&&v)return u=u.clone(),f?u.data=ve(a,i.reference):y?u.data=e.unpack(p,0):u.data=p,l(E)||(E=f?new z:new me,t[r]=E),void(!f&&E instanceof me?E.intervals.addInterval(u):E instanceof z?(u.data=f?u.data:new U(u.data),E.intervals.addInterval(u)):(w=_.MAXIMUM_INTERVAL.clone(),w.data=E,E=new z,t[r]=E,E.intervals.addInterval(w),u.data=f?u.data:new U(u.data),E.intervals.addInterval(u)));l(E)||(E=new z,t[r]=E),E instanceof z||(w=_.MAXIMUM_INTERVAL.clone(),w.data=E,E=new z,t[r]=E,E.intervals.addInterval(w));var T=E.intervals;w=T.findInterval(u),l(w)&&w.data instanceof ce||(w=u.clone(),w.data=new ce(e),T.addInterval(w)),w.data.addSamplesPackedArray(p,C),Te(i,w.data)}function be(e,t,r,i,n,o,a){if(l(i))if(v(i))for(var s=0,u=i.length;u>s;s++)xe(e,t,r,i[s],n,o,a);else xe(e,t,r,i,n,o,a)}function Pe(e,r,i,n,o,a){var u,c=i.interval;l(c)?(ct.iso8601=c,u=A.fromIso8601(ct),l(n)&&(u=A.intersect(u,n,lt))):l(n)&&(u=n);var h,d,p,m=!1,f=l(i.cartesianVelocity)?1:0,v=t.packedLength*(f+1),y=l(i.reference),C=l(u)&&!u.equals(_.MAXIMUM_INTERVAL);if(y||(h=s(x[i.referenceFrame],void 0),d=Ce(i),p=s(d.length,1),m=p>v),!m&&!C)return void(y?e[r]=ve(a,i.reference):e[r]=new k(t.unpack(d),h));var E,S=e[r],w=i.epoch;if(l(w)&&(E=g.fromIso8601(w)),m&&!C)return(!(S instanceof ue)||l(h)&&S.referenceFrame!==h)&&(S=new ue(h,f),e[r]=S),S.addSamplesPackedArray(d,E),void Te(i,S);var T;if(!m&&C)return u=u.clone(),y?u.data=ve(a,i.reference):u.data=t.unpack(d),l(S)||(S=y?new V(h):new pe(h),e[r]=S),void(!y&&S instanceof pe&&l(h)&&S.referenceFrame===h?S.intervals.addInterval(u):S instanceof V?(u.data=y?u.data:new k(u.data,h),S.intervals.addInterval(u)):(T=_.MAXIMUM_INTERVAL.clone(),T.data=S,S=new V(S.referenceFrame),e[r]=S,S.intervals.addInterval(T),u.data=y?u.data:new k(u.data,h),S.intervals.addInterval(u)));l(S)?S instanceof V||(T=_.MAXIMUM_INTERVAL.clone(),T.data=S,S=new V(S.referenceFrame),e[r]=S,S.intervals.addInterval(T)):(S=new V(h),e[r]=S);var b=S.intervals;T=b.findInterval(u),l(T)&&T.data instanceof ue&&(!l(h)||T.data.referenceFrame===h)||(T=u.clone(),T.data=new ue(h,f),b.addInterval(T)),T.data.addSamplesPackedArray(d,E),Te(i,T.data)}function Ae(e,t,r,i,n,o){if(l(r))if(v(r))for(var a=0,s=r.length;s>a;a++)Pe(e,t,r[a],i,n,o);else Pe(e,t,r,i,n,o)}function Ie(t,r,i,n,a,s){var u,c=i.interval;l(c)?(ct.iso8601=c,u=A.fromIso8601(ct),l(n)&&(u=A.intersect(u,n,lt))):l(n)&&(u=n);var h,d,p=t[r];if(l(u)){p instanceof B||(p=new B,t[r]=p);var m=p.intervals;d=m.findInterval({start:u.start,stop:u.stop}),l(d)?h=d.data:(d=u.clone(),m.addInterval(d))}else h=p;var f;l(i.solidColor)?(h instanceof F||(h=new F),f=i.solidColor,be(o,h,"color",f.color,void 0,void 0,s)):l(i.grid)?(h instanceof Y||(h=new Y),f=i.grid,be(o,h,"color",f.color,void 0,a,s),be(Number,h,"cellAlpha",f.cellAlpha,void 0,a,s),be(e,h,"lineThickness",f.lineThickness,void 0,a,s),be(e,h,"lineOffset",f.lineOffset,void 0,a,s),be(e,h,"lineCount",f.lineCount,void 0,a,s)):l(i.image)?(h instanceof X||(h=new X),f=i.image,be(Image,h,"image",f.image,void 0,a,s),be(e,h,"repeat",f.repeat,void 0,a,s)):l(i.stripe)?(h instanceof he||(h=new he),f=i.stripe,be(de,h,"orientation",f.orientation,void 0,a,s),be(o,h,"evenColor",f.evenColor,void 0,a,s),be(o,h,"oddColor",f.oddColor,void 0,a,s),be(Number,h,"offset",f.offset,void 0,a,s),be(Number,h,"repeat",f.repeat,void 0,a,s)):l(i.polylineOutline)?(h instanceof ie||(h=new ie),f=i.polylineOutline,be(o,h,"color",f.color,void 0,a,s),be(o,h,"outlineColor",f.outlineColor,void 0,a,s),be(Number,h,"outlineWidth",f.outlineWidth,void 0,a,s)):l(i.polylineGlow)&&(h instanceof te||(h=new te),f=i.polylineGlow,be(o,h,"color",f.color,void 0,a,s),be(Number,h,"glowPower",f.glowPower,void 0,a,s)),l(d)?d.data=h:t[r]=h}function Me(e,t,r,i,n,o){if(l(r))if(v(r))for(var a=0,s=r.length;s>a;a++)Ie(e,t,r[a],i,n,o);else Ie(e,t,r,i,n,o)}function De(e,t,r,i){e.name=s(t.name,e.name)}function Re(e,t,r,i){var n=t.description;l(n)&&be(String,e,"description",n,void 0,i,r)}function Oe(e,t,r,i){var n=t.position;l(n)&&Ae(e,"position",n,void 0,i,r)}function Ne(e,r,i,n){var o=r.viewFrom;l(o)&&be(t,e,"viewFrom",o,void 0,n,i)}function Le(e,t,r,i){var n=t.orientation;l(n)&&be(w,e,"orientation",n,void 0,i,r)}function Fe(e,r,i,n){var o,a,s=i.references;if(l(s)){var u=[];for(o=0,a=s.length;a>o;o++)u.push(ve(n,s[o]));var c=i.interval;if(l(c)){if(c=A.fromIso8601(c),!(e[r]instanceof V)){c.data=new ne(u);var d=new V;d.intervals.addInterval(c),e[r]=d}}else e[r]=new ne(u)}else{var p=[],m=i.cartesian;if(l(m)){for(o=0,a=m.length;a>o;o+=3)p.push(new t(m[o],m[o+1],m[o+2]));i.array=p}else if(m=i.cartographicRadians,l(m)){for(o=0,a=m.length;a>o;o+=3)st.longitude=m[o],st.latitude=m[o+1],st.height=m[o+2],p.push(h.WGS84.cartographicToCartesian(st));i.array=p}else if(m=i.cartographicDegrees,l(m)){for(o=0,a=m.length;a>o;o+=3)p.push(t.fromDegrees(m[o],m[o+1],m[o+2]));i.array=p}l(i.array)&&be(Array,e,r,i,void 0,void 0,n)}}function Be(e,t,r,i){if(l(r))if(v(r))for(var n=r.length,o=0;n>o;o++)Fe(e,t,r[o],i);else Fe(e,t,r,i)}function Ve(e,t,r,i){var n,o=t.availability;if(l(o)){var a;if(v(o))for(var s=o.length,u=0;s>u;u++)l(a)||(a=new I),ct.iso8601=o[u],n=A.fromIso8601(ct),a.addInterval(n);else ct.iso8601=o,n=A.fromIso8601(ct),a=new I,a.addInterval(n);e.availability=a}}function ze(r,i,n,a){var s=i.billboard;if(l(s)){var u,c=s.interval;l(c)&&(ct.iso8601=c,u=A.fromIso8601(ct));var h=r.billboard;l(h)||(r.billboard=h=new L),be(o,h,"color",s.color,u,a,n),be(t,h,"eyeOffset",s.eyeOffset,u,a,n),be(M,h,"horizontalOrigin",s.horizontalOrigin,u,a,n),be(Image,h,"image",s.image,u,a,n),be(e,h,"pixelOffset",s.pixelOffset,u,a,n),be(Number,h,"scale",s.scale,u,a,n),be(le,h,"rotation",s.rotation,u,a,n),be(t,h,"alignedAxis",s.alignedAxis,u,a,n),be(Boolean,h,"show",s.show,u,a,n),be(R,h,"verticalOrigin",s.verticalOrigin,u,a,n),be(Boolean,h,"sizeInMeters",s.sizeInMeters,u,a,n)}}function ke(e,t){var r=e.version;if(l(r)&&"string"==typeof r){var i=r.split(".");if(2===i.length){if("1"!==i[0])throw new b("Cesium only supports CZML version 1.");t._version=r}}if(!l(t._version))throw new b("CZML version information invalid.  It is expected to be a property on the document object in the <Major>.<Minor> version format.");var n=t._documentPacket;l(e.name)&&(n.name=e.name);var o=e.clock;if(l(o)){var a=n.clock;l(a)?(a.interval=s(o.interval,a.interval),a.currentTime=s(o.currentTime,a.currentTime),a.range=s(o.range,a.range),a.step=s(o.step,a.step),a.multiplier=s(o.multiplier,a.multiplier)):n.clock={interval:o.interval,currentTime:o.currentTime,range:o.range,step:o.step,multiplier:o.multiplier}}}function Ue(e,t,r,i){var n=t.ellipse;if(l(n)){var a,s=n.interval;l(s)&&(ct.iso8601=s,a=A.fromIso8601(ct));var u=e.ellipse;l(u)||(e.ellipse=u=new H),be(Boolean,u,"show",n.show,a,i,r),be(le,u,"rotation",n.rotation,a,i,r),be(Number,u,"semiMajorAxis",n.semiMajorAxis,a,i,r),be(Number,u,"semiMinorAxis",n.semiMinorAxis,a,i,r),be(Number,u,"height",n.height,a,i,r),be(Number,u,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,u,"granularity",n.granularity,a,i,r),be(le,u,"stRotation",n.stRotation,a,i,r),Me(u,"material",n.material,a,i,r),be(Boolean,u,"fill",n.fill,a,i,r),be(Boolean,u,"outline",n.outline,a,i,r),be(o,u,"outlineColor",n.outlineColor,a,i,r),be(Number,u,"outlineWidth",n.outlineWidth,a,i,r),be(Number,u,"numberOfVerticalLines",n.numberOfVerticalLines,a,i,r)}}function Ge(e,r,i,n){var a=r.ellipsoid;if(l(a)){var s,u=a.interval;l(u)&&(ct.iso8601=u,s=A.fromIso8601(ct));var c=e.ellipsoid;l(c)||(e.ellipsoid=c=new q),be(Boolean,c,"show",a.show,s,n,i),be(t,c,"radii",a.radii,s,n,i),Me(c,"material",a.material,s,n,i),be(Boolean,c,"fill",a.fill,s,n,i),be(Boolean,c,"outline",a.outline,s,n,i),be(o,c,"outlineColor",a.outlineColor,s,n,i),be(Number,c,"outlineWidth",a.outlineWidth,s,n,i)}}function We(r,i,n,a){var s=i.label;if(l(s)){var u,c=s.interval;l(c)&&(ct.iso8601=c,u=A.fromIso8601(ct));var h=r.label;l(h)||(r.label=h=new Z),be(o,h,"fillColor",s.fillColor,u,a,n),be(o,h,"outlineColor",s.outlineColor,u,a,n),be(Number,h,"outlineWidth",s.outlineWidth,u,a,n),be(t,h,"eyeOffset",s.eyeOffset,u,a,n),be(M,h,"horizontalOrigin",s.horizontalOrigin,u,a,n),be(String,h,"text",s.text,u,a,n),be(e,h,"pixelOffset",s.pixelOffset,u,a,n),be(Number,h,"scale",s.scale,u,a,n),be(Boolean,h,"show",s.show,u,a,n),be(R,h,"verticalOrigin",s.verticalOrigin,u,a,n),be(String,h,"font",s.font,u,a,n),be(D,h,"style",s.style,u,a,n)}}function He(e,t,r,i){var n=t.model;if(l(n)){var o,a=n.interval;l(a)&&(ct.iso8601=a,o=A.fromIso8601(ct));var s=e.model;l(s)||(e.model=s=new K),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"scale",n.scale,o,i,r),be(Number,s,"minimumPixelSize",n.minimumPixelSize,o,i,r),be(Boolean,s,"incrementallyLoadTextures",n.incrementallyLoadTextures,o,i,r),be(O,s,"uri",n.gltf,o,i,r),be(Boolean,s,"runAnimations",n.runAnimations,o,i,r);var u=n.nodeTransformations;if(l(u))if(v(u))for(var c=0,h=u.length;h>c;c++)qe(s,u[c],o,i,r);else qe(s,u,o,i,r)}}function qe(e,r,i,n,o){var a,s=r.interval;l(s)?(ct.iso8601=s,a=A.fromIso8601(ct),l(i)&&(a=A.intersect(a,i,lt))):l(i)&&(a=i);for(var u=e.nodeTransformations,c=Object.keys(r),h=0,d=c.length;d>h;++h){var p=c[h];if("interval"!==p){var m=r[p];if(l(m)){l(u)||(e.nodeTransformations=u=new oe),u.hasProperty(p)||u.addProperty(p);var f=u[p];l(f)||(u[p]=f=new Q),be(t,f,"translation",m.translation,a,n,o),be(w,f,"rotation",m.rotation,a,n,o),be(t,f,"scale",m.scale,a,n,o)}}}}function je(e,t,r,i){var n=t.path;if(l(n)){var o,a=n.interval;l(a)&&(ct.iso8601=a,o=A.fromIso8601(ct));var s=e.path;l(s)||(e.path=s=new J),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"width",n.width,o,i,r),be(Number,s,"resolution",n.resolution,o,i,r),be(Number,s,"leadTime",n.leadTime,o,i,r),be(Number,s,"trailTime",n.trailTime,o,i,r),Me(s,"material",n.material,o,i,r)}}function Ye(e,t,r,i){var n=t.point;if(l(n)){var a,s=n.interval;l(s)&&(ct.iso8601=s,a=A.fromIso8601(ct));var u=e.point;l(u)||(e.point=u=new $),be(o,u,"color",n.color,a,i,r),be(Number,u,"pixelSize",n.pixelSize,a,i,r),be(o,u,"outlineColor",n.outlineColor,a,i,r),be(Number,u,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,u,"show",n.show,a,i,r)}}function Xe(e,t,r,i){var n=t.polygon;if(l(n)){var a,s=n.interval;l(s)&&(ct.iso8601=s,a=A.fromIso8601(ct));var u=e.polygon;l(u)||(e.polygon=u=new ee),be(Boolean,u,"show",n.show,a,i,r),Me(u,"material",n.material,a,i,r),be(Number,u,"height",n.height,a,i,r),be(Number,u,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,u,"granularity",n.granularity,a,i,r),be(le,u,"stRotation",n.stRotation,a,i,r),be(Boolean,u,"fill",n.fill,a,i,r),be(Boolean,u,"outline",n.outline,a,i,r),be(o,u,"outlineColor",n.outlineColor,a,i,r),be(Number,u,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,u,"perPositionHeight",n.perPositionHeight,a,i,r),Be(u,"hierarchy",n.positions,r)}}function Ze(e,t,r,i){var n=t.rectangle;if(l(n)){var a,s=n.interval;l(s)&&(ct.iso8601=s,a=A.fromIso8601(ct));var u=e.rectangle;l(u)||(e.rectangle=u=new ae),be(Boolean,u,"show",n.show,a,i,r),be(T,u,"coordinates",n.coordinates,a,i,r),Me(u,"material",n.material,a,i,r),be(Number,u,"height",n.height,a,i,r),be(Number,u,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,u,"granularity",n.granularity,a,i,r),be(le,u,"rotation",n.rotation,a,i,r),be(le,u,"stRotation",n.stRotation,a,i,r),be(Boolean,u,"fill",n.fill,a,i,r),be(Boolean,u,"outline",n.outline,a,i,r),be(o,u,"outlineColor",n.outlineColor,a,i,r),be(Number,u,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,u,"closeBottom",n.closeBottom,a,i,r),be(Boolean,u,"closeTop",n.closeTop,a,i,r)}}function Ke(e,t,r,i){var n=t.wall;if(l(n)){var a,s=n.interval;l(s)&&(ct.iso8601=s,a=A.fromIso8601(ct));var u=e.wall;l(u)||(e.wall=u=new fe),be(Boolean,u,"show",n.show,a,i,r),Me(u,"material",n.material,a,i,r),be(Array,u,"minimumHeights",n.minimumHeights,a,i,r),be(Array,u,"maximumHeights",n.maximumHeights,a,i,r),be(Number,u,"granularity",n.granularity,a,i,r),be(Boolean,u,"fill",n.fill,a,i,r),be(Boolean,u,"outline",n.outline,a,i,r),be(o,u,"outlineColor",n.outlineColor,a,i,r),be(Number,u,"outlineWidth",n.outlineWidth,a,i,r),Be(u,"positions",n.positions,r)}}function Qe(e,t,r,i){var n=t.polyline;if(l(n)){var o,a=n.interval;l(a)&&(ct.iso8601=a,o=A.fromIso8601(ct));var s=e.polyline;l(s)||(e.polyline=s=new re),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"width",n.width,o,i,r),Me(s,"material",n.material,o,i,r),be(Boolean,s,"followSurface",n.followSurface,o,i,r),be(Number,s,"granularity",n.granularity,o,i,r),Be(s,"positions",n.positions,r)}}function Je(e,t,r,i,n){var o=e.id;if(l(o)||(o=a()),nt=o,!l(n._version)&&"document"!==o)throw new b("The first CZML packet is required to be the document object.");if(e["delete"]===!0)t.removeById(o);else if("document"===o)ke(e,n);else{var s=t.getOrCreateEntity(o),u=e.parent;l(u)&&(s.parent=t.getOrCreateEntity(u));for(var c=r.length-1;c>-1;c--)r[c](s,e,t,i)}nt=void 0}function $e(e){var t,r=e._documentPacket.clock;if(!l(r)){if(!l(e._clock)){var o=e._entityCollection.computeAvailability();if(!o.start.equals(_.MINIMUM_VALUE)){var a=o.start,u=o.stop,c=g.secondsDifference(u,a),h=Math.round(c/120);return t=new W,t.startTime=g.clone(a),t.stopTime=g.clone(u),t.clockRange=i.LOOP_STOP,t.multiplier=h,t.currentTime=g.clone(a),t.clockStep=n.SYSTEM_CLOCK_MULTIPLIER,e._clock=t,!0}}return!1}if(l(e._clock)?t=e._clock.clone():(t=new W,t.startTime=_.MINIMUM_VALUE.clone(),t.stopTime=_.MAXIMUM_VALUE.clone(),t.currentTime=_.MINIMUM_VALUE.clone(),t.clockRange=i.LOOP_STOP,t.clockStep=n.SYSTEM_CLOCK_MULTIPLIER,t.multiplier=1),l(r.interval)){ct.iso8601=r.interval;var d=A.fromIso8601(ct);t.startTime=d.start,t.stopTime=d.stop}return l(r.currentTime)&&(t.currentTime=g.fromIso8601(r.currentTime)),l(r.range)&&(t.clockRange=s(i[r.range],i.LOOP_STOP)),l(r.step)&&(t.clockStep=s(n[r.step],n.SYSTEM_CLOCK_MULTIPLIER)),l(r.multiplier)&&(t.multiplier=r.multiplier),t.equals(e._clock)?!1:(e._clock=t.clone(e._clock),!0)}function et(e,t,r,i){r=s(r,s.EMPTY_OBJECT);var n=t,o=r.sourceUri;return"string"==typeof t&&(n=E(t),o=s(o,t)),G.setLoading(e,!0),N(n,function(t){return tt(e,t,o,i)}).otherwise(function(t){return G.setLoading(e,!1),e._error.raiseEvent(e,t),console.log(t),N.reject(t)})}function tt(e,t,r,i){G.setLoading(e,!0);var n=e._entityCollection;i&&(e._version=void 0,e._documentPacket=new rt,n.removeAll()),it._processCzml(t,n,r,void 0,e);var o=$e(e),a=e._documentPacket;return l(a.name)&&e._name!==a.name?(e._name=a.name,o=!0):!l(e._name)&&l(r)&&(e._name=m(r),o=!0),G.setLoading(e,!1),o&&e._changed.raiseEvent(e),e}function rt(){this.name=void 0,this.clock=void 0}function it(e){this._name=e,this._changed=new d,this._error=new d,this._isLoading=!1,this._loading=new d,this._clock=void 0,this._documentPacket=new rt,this._version=void 0,this._entityCollection=new j(this)}var nt,ot=new t,at=new P,st=new r,lt=new A,ut={HERMITE:f,LAGRANGE:y,LINEAR:C},ct={iso8601:void 0};return it.load=function(e,t){return(new it).load(e,t)},u(it.prototype,{name:{get:function(){return this._name}},clock:{get:function(){return this._clock}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),it.updaters=[ze,Ue,Ge,We,He,De,Re,je,Ye,Xe,Qe,Ze,Oe,Ne,Ke,Le,Ve],it.prototype.process=function(e,t){return et(this,e,t,!1)},it.prototype.load=function(e,t){return et(this,e,t,!0)},it.processPacketData=be,it.processPositionPacketData=Ae,it.processMaterialPacketData=Me,it._processCzml=function(e,t,r,i,n){if(i=l(i)?i:it.updaters,v(e))for(var o=0,a=e.length;a>o;o++)Je(e[o],t,i,r,n);else Je(e,t,i,r,n)},it}),r("DataSources/DataSourceCollection",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../ThirdParty/when"],function(e,t,r,i,n,o,a){"use strict";function s(){this._dataSources=[],this._dataSourceAdded=new o,this._dataSourceRemoved=new o}return r(s.prototype,{length:{get:function(){return this._dataSources.length}},dataSourceAdded:{get:function(){return this._dataSourceAdded}},dataSourceRemoved:{get:function(){return this._dataSourceRemoved}}}),s.prototype.add=function(e){var t=this,r=this._dataSources;return a(e,function(e){return r===t._dataSources&&(t._dataSources.push(e),t._dataSourceAdded.raiseEvent(t,e)),e})},s.prototype.remove=function(t,r){r=e(r,!1);var i=this._dataSources.indexOf(t);return-1!==i?(this._dataSources.splice(i,1),this._dataSourceRemoved.raiseEvent(this,t),r&&"function"==typeof t.destroy&&t.destroy(),!0):!1},s.prototype.removeAll=function(t){t=e(t,!1);for(var r=this._dataSources,i=0,n=r.length;n>i;++i){var o=r[i];this._dataSourceRemoved.raiseEvent(this,o),t&&"function"==typeof o.destroy&&o.destroy()}this._dataSources=[]},s.prototype.contains=function(e){return-1!==this.indexOf(e)},s.prototype.indexOf=function(e){return this._dataSources.indexOf(e)},s.prototype.get=function(e){return this._dataSources[e]},s.prototype.isDestroyed=function(){return!1},s.prototype.destroy=function(){return this.removeAll(!0),i(this)},s}),r("DataSources/EllipseGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipseGeometry","../Core/EllipseOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C){"use strict";function E(e){this.id=e,this.vertexFormat=void 0,this.center=void 0,this.semiMajorAxis=void 0,this.semiMinorAxis=void 0,this.rotation=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0,this.numberOfVerticalLines=void 0}function S(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(S.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new E(e),this._onEntityPropertyChanged(e,"ellipse",e.ellipse,void 0)}function w(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new E(t._entity)}var T=new v(e.WHITE),x=new _(!0),b=new _(!0),P=new _(!1),A=new _(e.BLACK),I=new e;return n(S,{perInstanceColorAppearanceType:{value:m},materialAppearanceType:{value:p}}),n(S.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!i(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!i(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),S.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},S.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},S.prototype.createFillGeometryInstance=function(r){var n,o,a=this._entity,l=a.isAvailable(r),u=new d(l&&a.isShowing&&this._showProperty.getValue(r)&&this._fillProperty.getValue(r));if(this._materialProperty instanceof v){var h=e.WHITE;i(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(h=this._materialProperty.color.getValue(r)),o=t.fromColor(h),n={show:u,color:o}}else n={show:u};return new c({
id:a,geometry:new s(this._options),attributes:n})},S.prototype.createOutlineGeometryInstance=function(r){var i=this._entity,n=i.isAvailable(r),o=C.getValueOrDefault(this._outlineColorProperty,r,e.BLACK);return new c({id:i,geometry:new l(this._options),attributes:{show:new d(n&&i.isShowing&&this._showProperty.getValue(r)&&this._showOutlineProperty.getValue(r)),color:t.fromColor(o)}})},S.prototype.isDestroyed=function(){return!1},S.prototype.destroy=function(){this._entitySubscription(),o(this)},S.prototype._onEntityPropertyChanged=function(e,t,n,o){if("availability"===t||"position"===t||"ellipse"===t){var a=this._entity.ellipse;if(!i(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,l=i(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,u=a.outline,c=i(u);if(c&&u.isConstant&&(c=u.getValue(h.MINIMUM_VALUE)),!l&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=this._entity.position,f=a.semiMajorAxis,_=a.semiMinorAxis,g=a.show;if(i(g)&&g.isConstant&&!g.getValue(h.MINIMUM_VALUE)||!i(d)||!i(f)||!i(_))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var y=r(a.material,T),E=y instanceof v;this._materialProperty=y,this._fillProperty=r(s,b),this._showProperty=r(g,x),this._showOutlineProperty=r(a.outline,P),this._outlineColorProperty=c?r(a.outlineColor,A):void 0;var S=a.rotation,w=a.height,I=a.extrudedHeight,M=a.granularity,D=a.stRotation,R=a.outlineWidth,O=a.numberOfVerticalLines;if(this._isClosed=i(I),this._fillEnabled=l,this._outlineEnabled=c,d.isConstant&&f.isConstant&&_.isConstant&&C.isConstant(S)&&C.isConstant(w)&&C.isConstant(I)&&C.isConstant(M)&&C.isConstant(D)&&C.isConstant(R)&&C.isConstant(O)){var N=this._options;N.vertexFormat=E?m.VERTEX_FORMAT:p.MaterialSupport.TEXTURED.vertexFormat,N.center=d.getValue(h.MINIMUM_VALUE,N.center),N.semiMajorAxis=f.getValue(h.MINIMUM_VALUE,N.semiMajorAxis),N.semiMinorAxis=_.getValue(h.MINIMUM_VALUE,N.semiMinorAxis),N.rotation=i(S)?S.getValue(h.MINIMUM_VALUE):void 0,N.height=i(w)?w.getValue(h.MINIMUM_VALUE):void 0,N.extrudedHeight=i(I)?I.getValue(h.MINIMUM_VALUE):void 0,N.granularity=i(M)?M.getValue(h.MINIMUM_VALUE):void 0,N.stRotation=i(D)?D.getValue(h.MINIMUM_VALUE):void 0,N.numberOfVerticalLines=i(O)?O.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=i(R)?R.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},S.prototype.createDynamicUpdater=function(e){return new w(e,this)},w.prototype.update=function(r){var n=this._primitives;n.removeAndDestroy(this._primitive),n.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,u=a.ellipse;if(a.isShowing&&a.isAvailable(r)&&C.getValueOrDefault(u.show,r,!0)){var h=this._options,d=C.getValueOrUndefined(a.position,r,h.center),v=C.getValueOrUndefined(u.semiMajorAxis,r),_=C.getValueOrUndefined(u.semiMinorAxis,r);if(i(d)&&i(v)&&i(_)){if(h.center=d,h.semiMajorAxis=v,h.semiMinorAxis=_,h.rotation=C.getValueOrUndefined(u.rotation,r),h.height=C.getValueOrUndefined(u.height,r),h.extrudedHeight=C.getValueOrUndefined(u.extrudedHeight,r),h.granularity=C.getValueOrUndefined(u.granularity,r),h.stRotation=C.getValueOrUndefined(u.stRotation,r),h.numberOfVerticalLines=C.getValueOrUndefined(u.numberOfVerticalLines,r),C.getValueOrDefault(u.fill,r,!0)){var g=y.getValue(r,o.fillMaterialProperty,this._material);this._material=g;var E=new p({material:g,translucent:g.isTranslucent(),closed:i(h.extrudedHeight)});h.vertexFormat=E.vertexFormat,this._primitive=n.add(new f({geometryInstances:new c({id:a,geometry:new s(h)}),appearance:E,asynchronous:!1}))}if(C.getValueOrDefault(u.outline,r,!1)){h.vertexFormat=m.VERTEX_FORMAT;var S=C.getValueOrClonedDefault(u.outlineColor,r,e.BLACK,I),w=C.getValueOrDefault(u.outlineWidth,r,1),T=1!==S.alpha;this._outlinePrimitive=n.add(new f({geometryInstances:new c({id:a,geometry:new l(h),attributes:{color:t.fromColor(S)}}),appearance:new m({flat:!0,translucent:T,renderState:{lineWidth:o._scene.clampLineWidth(w)}}),asynchronous:!1}))}}}},w.prototype.getBoundingSphere=function(e,t){return g(e,this._primitive,this._outlinePrimitive,t)},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},S}),r("DataSources/EllipsoidGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipsoidGeometry","../Core/EllipsoidOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/Matrix4","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","../Scene/SceneMode","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w){"use strict";function T(e){this.id=e,this.vertexFormat=void 0,this.radii=void 0,this.stackPartitions=void 0,this.slicePartitions=void 0,this.subdivisions=void 0}function x(e,t){this._scene=t,this._entity=e,this._entitySubscription=e.definitionChanged.addEventListener(x.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new T(e),this._onEntityPropertyChanged(e,"ellipsoid",e.ellipsoid,void 0)}function b(e,t){this._entity=t._entity,this._scene=t._scene,this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new T(t._entity),this._modelMatrix=new p,this._material=void 0,this._attributes=void 0,this._outlineAttributes=void 0,this._lastSceneMode=void 0,this._lastShow=void 0,this._lastOutlineShow=void 0,this._lastOutlineWidth=void 0,this._lastOutlineColor=void 0}var P=new y(t.WHITE),A=new C(!0),I=new C(!0),M=new C(!1),D=new C(t.BLACK),R=new e,O=new t,N=new e(1,1,1);return o(x,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:f}}),o(x.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),x.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},x.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},x.prototype.createFillGeometryInstance=function(e){var i,o,a=this._entity,s=a.isAvailable(e),u=new m(s&&a.isShowing&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof y){var c=t.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(c=this._materialProperty.color.getValue(e)),o=r.fromColor(c),i={show:u,color:o}}else i={show:u};return new h({id:a,geometry:new l(this._options),modelMatrix:a._getModelMatrix(d.MINIMUM_VALUE),attributes:i})},x.prototype.createOutlineGeometryInstance=function(e){var i=this._entity,n=i.isAvailable(e),o=w.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new h({id:i,geometry:new u(this._options),modelMatrix:i._getModelMatrix(d.MINIMUM_VALUE),attributes:{show:new m(n&&i.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:r.fromColor(o)}})},x.prototype.isDestroyed=function(){return!1},x.prototype.destroy=function(){this._entitySubscription(),a(this)},x.prototype._onEntityPropertyChanged=function(e,t,r,o){if("availability"===t||"position"===t||"orientation"===t||"ellipsoid"===t){var a=e.ellipsoid;if(!n(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,l=n(s)&&s.isConstant?s.getValue(d.MINIMUM_VALUE):!0,u=a.outline,c=n(u);if(c&&u.isConstant&&(c=u.getValue(d.MINIMUM_VALUE)),!l&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var h=e.position,p=a.radii,m=a.show;if(n(m)&&m.isConstant&&!m.getValue(d.MINIMUM_VALUE)||!n(h)||!n(p))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var _=i(a.material,P),g=_ instanceof y;this._materialProperty=_,this._fillProperty=i(s,I),this._showProperty=i(m,A),this._showOutlineProperty=i(a.outline,M),this._outlineColorProperty=c?i(a.outlineColor,D):void 0,this._fillEnabled=l,this._outlineEnabled=c;var C=a.stackPartitions,E=a.slicePartitions,S=a.outlineWidth,T=a.subdivisions;if(h.isConstant&&w.isConstant(e.orientation)&&p.isConstant&&w.isConstant(C)&&w.isConstant(E)&&w.isConstant(S)&&w.isConstant(T)){var x=this._options;x.vertexFormat=g?v.VERTEX_FORMAT:f.MaterialSupport.TEXTURED.vertexFormat,x.radii=p.getValue(d.MINIMUM_VALUE,x.radii),x.stackPartitions=n(C)?C.getValue(d.MINIMUM_VALUE):void 0,x.slicePartitions=n(E)?E.getValue(d.MINIMUM_VALUE):void 0,x.subdivisions=n(T)?T.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=n(S)?S.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},x.prototype.createDynamicUpdater=function(e){return new b(e,this)},b.prototype.update=function(e){var o=this._entity,a=o.ellipsoid;if(!o.isShowing||!o.isAvailable(e)||!w.getValueOrDefault(a.show,e,!0))return n(this._primitive)&&(this._primitive.show=!1),void(n(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1));var s=w.getValueOrUndefined(a.radii,e,R),c=o._getModelMatrix(e,this._modelMatrix);if(!n(c)||!n(s))return n(this._primitive)&&(this._primitive.show=!1),void(n(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1));var d,y=w.getValueOrDefault(a.fill,e,!0),C=w.getValueOrDefault(a.outline,e,!1),E=w.getValueOrClonedDefault(a.outlineColor,e,t.BLACK,O),T=S.getValue(e,i(a.material,P),this._material);this._material=T;var x=w.getValueOrUndefined(a.stackPartitions,e),b=w.getValueOrUndefined(a.slicePartitions,e),A=w.getValueOrUndefined(a.subdivisions,e),I=w.getValueOrDefault(a.outlineWidth,e,1),M=this._scene.mode,D=M===g.SCENE3D,L=this._options,F=!D||this._lastSceneMode!==M||!n(this._primitive)||L.stackPartitions!==x||L.slicePartitions!==b||L.subdivisions!==A||this._lastOutlineWidth!==I;if(F){var B=this._primitives;B.removeAndDestroy(this._primitive),B.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0,this._lastSceneMode=M,this._lastOutlineWidth=I,L.stackPartitions=x,L.slicePartitions=b,L.subdivisions=A,L.radii=D?N:s,d=new f({material:T,translucent:T.isTranslucent(),closed:!0}),L.vertexFormat=d.vertexFormat,this._primitive=B.add(new _({geometryInstances:new h({id:o,geometry:new l(L),modelMatrix:D?void 0:c,attributes:{show:new m(y)}}),appearance:d,asynchronous:!1})),L.vertexFormat=v.VERTEX_FORMAT,this._outlinePrimitive=B.add(new _({geometryInstances:new h({id:o,geometry:new u(L),modelMatrix:D?void 0:c,attributes:{show:new m(C),color:r.fromColor(E)}}),appearance:new v({flat:!0,translucent:1!==E.alpha,renderState:{lineWidth:this._geometryUpdater._scene.clampLineWidth(I)}}),asynchronous:!1})),this._lastShow=y,this._lastOutlineShow=C,this._lastOutlineColor=t.clone(E,this._lastOutlineColor)}else if(this._primitive.ready){var V=this._primitive,z=this._outlinePrimitive;V.show=!0,z.show=!0,d=V.appearance,d.material=T;var k=this._attributes;n(k)||(k=V.getGeometryInstanceAttributes(o),this._attributes=k),y!==this._lastShow&&(k.show=m.toValue(y,k.show),this._lastShow=y);var U=this._outlineAttributes;n(U)||(U=z.getGeometryInstanceAttributes(o),this._outlineAttributes=U),C!==this._lastOutlineShow&&(U.show=m.toValue(C,U.show),this._lastOutlineShow=C),t.equals(E,this._lastOutlineColor)||(U.color=r.toValue(E,U.color),t.clone(E,this._lastOutlineColor))}D&&(s.x=Math.max(s.x,.001),s.y=Math.max(s.y,.001),s.z=Math.max(s.z,.001),c=p.multiplyByScale(c,s,c),this._primitive.modelMatrix=c,this._outlinePrimitive.modelMatrix=c)},b.prototype.getBoundingSphere=function(e,t){return E(e,this._primitive,this._outlinePrimitive,t)},b.prototype.isDestroyed=function(){return!1},b.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),a(this)},x}),r("DataSources/StaticGeometryColorBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState"],function(e,t,r,i,n,o,a){"use strict";function s(t,r,i,n){this.translucent=r,this.appearanceType=i,this.closed=n,this.primitives=t,this.createPrimitive=!1,this.waitingOnCreate=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.subscriptions=new e,this.showsUpdated=new e,this.itemsToRemove=[]}function l(e,t,r){this._solidBatch=new s(e,!1,t,r),this._translucentBatch=new s(e,!0,t,r)}var u=new t;return s.prototype.add=function(e,t){var r=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(r,t),this.updaters.set(r,e),e.hasConstantFill&&e.fillMaterialProperty.isConstant){var i=this;this.subscriptions.set(r,e.entity.definitionChanged.addEventListener(function(t,r,n,o){"isShowing"===r&&i.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(r,e)},s.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var r=this.subscriptions.get(t);i(r)&&(r(),this.subscriptions.remove(t))}},s.prototype.update=function(e){var a,s,l=!0,c=0,h=this.primitive,d=this.primitives;if(this.createPrimitive){var p=this.geometry.values,m=p.length;if(m>0){for(i(h)&&(i(this.oldPrimitive)?d.remove(h):this.oldPrimitive=h),s=0;m>s;s++){var f=p[s],v=f.attributes;a=this.attributes.get(f.id.id),i(a)&&(i(v.show)&&(v.show.value=a.show),i(v.color)&&(v.color.value=a.color))}h=new o({asynchronous:!0,geometryInstances:p,appearance:new this.appearanceType({translucent:this.translucent,closed:this.closed})}),d.add(h),l=!1}else{i(h)&&(d.remove(h),h=void 0);var _=this.oldPrimitive;i(_)&&(d.remove(_),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=h,this.createPrimitive=!1,this.waitingOnCreate=!0}else if(i(h)&&h.ready){i(this.oldPrimitive)&&(d.remove(this.oldPrimitive),this.oldPrimitive=void 0);var g=this.updatersWithAttributes.values,y=g.length,C=this.waitingOnCreate;for(s=0;y>s;s++){var E=g[s],S=this.geometry.get(E.entity.id);if(a=this.attributes.get(S.id.id),i(a)||(a=h.getGeometryInstanceAttributes(S.id),this.attributes.set(S.id.id,a)),!E.fillMaterialProperty.isConstant||C){var w=E.fillMaterialProperty.color;w.getValue(e,u),t.equals(a._lastColor,u)||(a._lastColor=t.clone(u,a._lastColor),a.color=r.toValue(u,a.color),(this.translucent&&255===a.color[3]||!this.translucent&&255!==a.color[3])&&(this.itemsToRemove[c++]=E))}var T=E.entity.isShowing&&(E.hasConstantFill||E.isFilled(e)),x=1===a.show[0];T!==x&&(a.show=n.toValue(T,a.show))}this.updateShows(h),this.waitingOnCreate=!1}else i(h)&&!h.ready&&(l=!1);return this.itemsToRemove.length=c,l},s.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,r=t.length,o=0;r>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),l=this.attributes.get(s.id.id);i(l)||(l=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,l));var u=a.entity.isShowing,c=1===l.show[0];u!==c&&(l.show=n.toValue(u,l.show))}this.showsUpdated.removeAll()},s.prototype.contains=function(e){return this.updaters.contains(e.id)},s.prototype.getBoundingSphere=function(e,t){var r=this.primitive;if(!r.ready)return a.PENDING;var n=r.getGeometryInstanceAttributes(e);return!i(n)||!i(n.boundingSphere)||i(n.show)&&0===n.show[0]?a.FAILED:(n.boundingSphere.clone(t),a.DONE)},s.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;i(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var r=this.oldPrimitive;i(r)&&(e.remove(r),this.oldPrimitive=void 0)},l.prototype.add=function(e,t){var r=t.createFillGeometryInstance(e);255===r.attributes.color.value[3]?this._solidBatch.add(t,r):this._translucentBatch.add(t,r)},l.prototype.remove=function(e){this._solidBatch.remove(e)||this._translucentBatch.remove(e)},l.prototype.update=function(e){var t,r,i=this._solidBatch.update(e);i=this._translucentBatch.update(e)&&i;var n=this._solidBatch.itemsToRemove,o=n.length;if(o>0)for(t=0;o>t;t++)r=n[t],this._solidBatch.remove(r),this._translucentBatch.add(r,r.createFillGeometryInstance(e));n=this._translucentBatch.itemsToRemove;var a=n.length;if(a>0)for(t=0;a>t;t++)r=n[t],this._translucentBatch.remove(r),this._solidBatch.add(r,r.createFillGeometryInstance(e));return(o>0||a>0)&&(i=this._solidBatch.update(e)&&i,i=this._translucentBatch.update(e)&&i),i},l.prototype.getBoundingSphere=function(e,t){return this._solidBatch.contains(e)?this._solidBatch.getBoundingSphere(e,t):this._translucentBatch.contains(e)?this._translucentBatch.getBoundingSphere(e,t):a.FAILED},l.prototype.removeAllPrimitives=function(){this._solidBatch.removeAllPrimitives(),this._translucentBatch.removeAllPrimitives()},l}),r("DataSources/StaticGeometryPerMaterialBatch",["../Core/AssociativeArray","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState","./MaterialProperty"],function(e,t,r,i,n,o){"use strict";function a(t,r,i,n){this.primitives=t,this.appearanceType=r,this.materialProperty=i,this.closed=n,this.updaters=new e,this.createPrimitive=!0,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.material=void 0,this.updatersWithAttributes=new e,this.attributes=new e,this.invalidated=!1,this.removeMaterialSubscription=i.definitionChanged.addEventListener(a.prototype.onMaterialChanged,this),this.subscriptions=new e,this.showsUpdated=new e}function s(e,t,r){this._items=[],this._primitives=e,this._appearanceType=t,this._closed=r}return a.prototype.onMaterialChanged=function(){this.invalidated=!0},a.prototype.isMaterial=function(e){var r=this.materialProperty,i=e.fillMaterialProperty;return i===r?!0:t(r)?r.equals(i):!1},a.prototype.add=function(e,t){var r=t.entity.id;if(this.updaters.set(r,t),this.geometry.set(r,t.createFillGeometryInstance(e)),t.hasConstantFill&&t.fillMaterialProperty.isConstant){var i=this;this.subscriptions.set(r,t.entity.definitionChanged.addEventListener(function(e,r,n,o){"isShowing"===r&&i.showsUpdated.set(e.id,t)}))}else this.updatersWithAttributes.set(r,t);this.createPrimitive=!0},a.prototype.remove=function(e){var r=e.entity.id,i=this.updaters.remove(r);if(i){this.geometry.remove(r),this.updatersWithAttributes.remove(r);var n=this.subscriptions.get(r);t(n)&&(n(),this.subscriptions.remove(r))}return this.createPrimitive=i,i},a.prototype.update=function(e){var n,a,s=!0,l=this.primitive,u=this.primitives,c=this.geometry.values;if(this.createPrimitive){var h=c.length;if(h>0){for(t(l)&&(t(this.oldPrimitive)?u.remove(l):this.oldPrimitive=l),a=0;h>a;a++){var d=c[a],p=d.attributes;n=this.attributes.get(d.id.id),t(n)&&(t(p.show)&&(p.show.value=n.show),t(p.color)&&(p.color.value=n.color))}this.material=o.getValue(e,this.materialProperty,this.material),l=new i({asynchronous:!0,geometryInstances:c,appearance:new this.appearanceType({material:this.material,translucent:this.material.isTranslucent(),closed:this.closed})}),u.add(l),s=!1}else{t(l)&&(u.remove(l),l=void 0);var m=this.oldPrimitive;t(m)&&(u.remove(m),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=l,this.createPrimitive=!1}else if(t(l)&&l.ready){t(this.oldPrimitive)&&(u.remove(this.oldPrimitive),this.oldPrimitive=void 0),this.material=o.getValue(e,this.materialProperty,this.material),this.primitive.appearance.material=this.material;var f=this.updatersWithAttributes.values,v=f.length;for(a=0;v>a;a++){var _=f[a],g=_.entity,y=this.geometry.get(g.id);n=this.attributes.get(y.id.id),t(n)||(n=l.getGeometryInstanceAttributes(y.id),this.attributes.set(y.id.id,n));var C=g.isShowing&&(_.hasConstantFill||_.isFilled(e)),E=1===n.show[0];C!==E&&(n.show=r.toValue(C,n.show))}this.updateShows(l)}else t(l)&&!l.ready&&(s=!1);return s},a.prototype.updateShows=function(e){for(var i=this.showsUpdated.values,n=i.length,o=0;n>o;o++){var a=i[o],s=a.entity,l=this.geometry.get(s.id),u=this.attributes.get(l.id.id);t(u)||(u=e.getGeometryInstanceAttributes(l.id),this.attributes.set(l.id.id,u));var c=s.isShowing,h=1===u.show[0];c!==h&&(u.show=r.toValue(c,u.show))}this.showsUpdated.removeAll()},a.prototype.contains=function(e){return this.updaters.contains(e.id)},a.prototype.getBoundingSphere=function(e,r){var i=this.primitive;if(!i.ready)return n.PENDING;var o=i.getGeometryInstanceAttributes(e);return!t(o)||!t(o.boundingSphere)||t(o.show)&&0===o.show[0]?n.FAILED:(o.boundingSphere.clone(r),n.DONE)},a.prototype.destroy=function(e){var r=this.primitive,i=this.primitives;t(r)&&i.remove(r);var n=this.oldPrimitive;t(n)&&i.remove(n),this.removeMaterialSubscription()},s.prototype.add=function(e,t){for(var r=this._items,i=r.length,n=0;i>n;n++){var o=r[n];if(o.isMaterial(t))return void o.add(e,t)}var s=new a(this._primitives,this._appearanceType,t.fillMaterialProperty,this._closed);s.add(e,t),r.push(s)},s.prototype.remove=function(e){for(var t=this._items,r=t.length,i=r-1;i>=0;i--){var n=t[i];if(n.remove(e)){0===n.updaters.length&&(t.splice(i,1),n.destroy());break}}},s.prototype.update=function(e){var t,r=this._items,i=r.length;for(t=i-1;t>=0;t--){var n=r[t];if(n.invalidated){r.splice(t,1);for(var o=n.updaters.values,a=o.length,s=0;a>s;s++)this.add(e,o[s]);n.destroy()}}var l=!0;for(t=0;i>t;t++)l=r[t].update(e)&&l;return l},s.prototype.getBoundingSphere=function(e,t){for(var r=this._items,i=r.length,o=0;i>o;o++){var a=r[o];if(a.contains(e))return a.getBoundingSphere(e,t)}return n.FAILED},s.prototype.removeAllPrimitives=function(){for(var e=this._items,t=e.length,r=0;t>r;r++)e[r].destroy();this._items.length=0},s}),r("DataSources/StaticOutlineGeometryBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./BoundingSphereState"],function(e,t,r,i,n,o,a,s){"use strict";function l(t,r,i){this.translucent=r,this.primitives=t,this.createPrimitive=!1,this.waitingOnCreate=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.itemsToRemove=[],this.width=i,this.subscriptions=new e,this.showsUpdated=new e}function u(t,r){this._primitives=t,this._scene=r,this._solidBatches=new e,this._translucentBatches=new e}l.prototype.add=function(e,t){var r=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(r,t),this.updaters.set(r,e),e.hasConstantOutline&&e.outlineColorProperty.isConstant){var i=this;this.subscriptions.set(r,e.entity.definitionChanged.addEventListener(function(t,r,n,o){"isShowing"===r&&i.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(r,e)},l.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var r=this.subscriptions.get(t);i(r)&&(r(),this.subscriptions.remove(t))}};var c=new t;return l.prototype.update=function(e){var s,l,u=!0,h=0,d=this.primitive,p=this.primitives;if(this.createPrimitive){var m=this.geometry.values,f=m.length;if(f>0){for(i(d)&&(i(this.oldPrimitive)?p.remove(d):this.oldPrimitive=d),l=0;f>l;l++){var v=m[l],_=v.attributes;s=this.attributes.get(v.id.id),i(s)&&(i(_.show)&&(_.show.value=s.show),i(_.color)&&(_.color.value=s.color))}d=new a({asynchronous:!0,geometryInstances:m,appearance:new o({flat:!0,translucent:this.translucent,renderState:{lineWidth:this.width}})}),p.add(d),u=!1}else{i(d)&&(p.remove(d),d=void 0);var g=this.oldPrimitive;i(g)&&(p.remove(g),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=d,this.createPrimitive=!1,this.waitingOnCreate=!0}else if(i(d)&&d.ready){i(this.oldPrimitive)&&(p.remove(this.oldPrimitive),this.oldPrimitive=void 0);var y=this.updatersWithAttributes.values,C=y.length,E=this.waitingOnCreate;for(l=0;C>l;l++){var S=y[l],w=this.geometry.get(S.entity.id);if(s=this.attributes.get(w.id.id),i(s)||(s=d.getGeometryInstanceAttributes(w.id),this.attributes.set(w.id.id,s)),!S.outlineColorProperty.isConstant||E){var T=S.outlineColorProperty;T.getValue(e,c),t.equals(s._lastColor,c)||(s._lastColor=t.clone(c,s._lastColor),s.color=r.toValue(c,s.color),(this.translucent&&255===s.color[3]||!this.translucent&&255!==s.color[3])&&(this.itemsToRemove[h++]=S))}var x=S.entity.isShowing&&(S.hasConstantOutline||S.isOutlineVisible(e)),b=1===s.show[0];x!==b&&(s.show=n.toValue(x,s.show))}this.updateShows(d),this.waitingOnCreate=!1}else i(d)&&!d.ready&&(u=!1);return this.itemsToRemove.length=h,u},l.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,r=t.length,o=0;r>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),l=this.attributes.get(s.id.id);i(l)||(l=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,l));var u=a.entity.isShowing,c=1===l.show[0];u!==c&&(l.show=n.toValue(u,l.show))}this.showsUpdated.removeAll()},l.prototype.contains=function(e){return this.updaters.contains(e.id)},l.prototype.getBoundingSphere=function(e,t){var r=this.primitive;if(!r.ready)return s.PENDING;var n=r.getGeometryInstanceAttributes(e);return!i(n)||!i(n.boundingSphere)||i(n.show)&&0===n.show[0]?s.FAILED:(n.boundingSphere.clone(t),s.DONE)},l.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;i(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var r=this.oldPrimitive;i(r)&&(e.remove(r),this.oldPrimitive=void 0)},u.prototype.add=function(e,t){var r,n,o=t.createOutlineGeometryInstance(e),a=this._scene.clampLineWidth(t.outlineWidth);255===o.attributes.color.value[3]?(r=this._solidBatches,n=r.get(a),i(n)||(n=new l(this._primitives,!1,a),r.set(a,n)),n.add(t,o)):(r=this._translucentBatches,n=r.get(a),i(n)||(n=new l(this._primitives,!0,a),r.set(a,n)),n.add(t,o))},u.prototype.remove=function(e){var t,r=this._solidBatches.values,i=r.length;for(t=0;i>t;t++)if(r[t].remove(e))return;var n=this._translucentBatches.values,o=n.length;for(t=0;o>t;t++)if(n[t].remove(e))return},u.prototype.update=function(e){var t,r,i,n,o,a=this._solidBatches.values,s=a.length,l=this._translucentBatches.values,u=l.length,c=!0,h=!1;do{for(h=!1,r=0;s>r;r++){n=a[r],c=n.update(e),o=n.itemsToRemove;var d=o.length;if(d>0)for(h=!0,t=0;d>t;t++)i=o[t],n.remove(i),this.add(e,i)}for(r=0;u>r;r++){n=l[r],c=n.update(e),o=n.itemsToRemove;var p=o.length;if(p>0)for(h=!0,t=0;p>t;t++)i=o[t],n.remove(i),this.add(e,i)}}while(h);return c},u.prototype.getBoundingSphere=function(e,t){var r,i=this._solidBatches.values,n=i.length;for(r=0;n>r;r++){var o=i[r];if(o.contains(e))return o.getBoundingSphere(e,t)}var a=this._translucentBatches.values,l=a.length;for(r=0;l>r;r++){var u=a[r];if(u.contains(e))return u.getBoundingSphere(e,t)}return s.FAILED},u.prototype.removeAllPrimitives=function(){var e,t=this._solidBatches.values,r=t.length;for(e=0;r>e;e++)t[e].removeAllPrimitives();var i=this._translucentBatches.values,n=i.length;for(e=0;n>e;e++)i[e].removeAllPrimitives()},u}),r("DataSources/GeometryVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/defined","../Core/destroyObject","../Core/DeveloperError","./BoundingSphereState","./ColorMaterialProperty","./StaticGeometryColorBatch","./StaticGeometryPerMaterialBatch","./StaticOutlineGeometryBatch"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(t){this._primitives=t,this._dynamicUpdaters=new e}function h(e,t){for(var r=e._batches,i=r.length,n=0;i>n;n++)r[n].remove(t)}function d(e,t,r){return r.isDynamic?void e._dynamicBatch.add(t,r):(r.outlineEnabled&&e._outlineBatch.add(t,r),void(r.fillEnabled&&(r.isClosed?r.fillMaterialProperty instanceof a?e._closedColorBatch.add(t,r):e._closedMaterialBatch.add(t,r):r.fillMaterialProperty instanceof a?e._openColorBatch.add(t,r):e._openMaterialBatch.add(t,r))))}function p(t,r,i){this._type=t;var n=r.primitives;this._scene=r,this._primitives=n,this._entityCollection=void 0,this._addedObjects=new e,this._removedObjects=new e,this._changedObjects=new e,this._outlineBatch=new u(n,r),this._closedColorBatch=new s(n,t.perInstanceColorAppearanceType,!0),this._closedMaterialBatch=new l(n,t.materialAppearanceType,!0),this._openColorBatch=new s(n,t.perInstanceColorAppearanceType,!1),this._openMaterialBatch=new l(n,t.materialAppearanceType,!1),this._dynamicBatch=new c(n),this._batches=[this._closedColorBatch,this._closedMaterialBatch,this._openColorBatch,this._openMaterialBatch,this._dynamicBatch,this._outlineBatch],this._subscriptions=new e,this._updaters=new e,this._entityCollection=i,i.collectionChanged.addEventListener(p.prototype._onCollectionChanged,this),this._onCollectionChanged(i,i.values,m)}var m=[];c.prototype.add=function(e,t){this._dynamicUpdaters.set(t.entity.id,t.createDynamicUpdater(this._primitives))},c.prototype.remove=function(e){var t=e.entity.id,i=this._dynamicUpdaters.get(t);r(i)&&(this._dynamicUpdaters.remove(t),i.destroy())},c.prototype.update=function(e){for(var t=this._dynamicUpdaters.values,r=0,i=t.length;i>r;r++)t[r].update(e);return!0},c.prototype.removeAllPrimitives=function(){for(var e=this._dynamicUpdaters.values,t=0,r=e.length;r>t;t++)e[t].destroy();this._dynamicUpdaters.removeAll()},c.prototype.getBoundingSphere=function(e,t){var i=this._dynamicUpdaters.get(e.id);return r(i)&&r(i.getBoundingSphere)?i.getBoundingSphere(e,t):o.FAILED},p.prototype.update=function(e){var t,r,i,n,o=this._addedObjects,a=o.values,s=this._removedObjects,l=s.values,u=this._changedObjects,c=u.values;for(t=c.length-1;t>-1;t--)r=c[t],i=r.id,n=this._updaters.get(i),n.entity===r?(h(this,n),d(this,e,n)):(l.push(r),a.push(r));for(t=l.length-1;t>-1;t--)r=l[t],i=r.id,n=this._updaters.get(i),h(this,n),n.destroy(),this._updaters.remove(i),this._subscriptions.get(i)(),this._subscriptions.remove(i);for(t=a.length-1;t>-1;t--)r=a[t],i=r.id,n=new this._type(r,this._scene),this._updaters.set(i,n),d(this,e,n),this._subscriptions.set(i,n.geometryChanged.addEventListener(p._onGeometryChanged,this));o.removeAll(),s.removeAll(),u.removeAll();var m=!0,f=this._batches,v=f.length;for(t=0;v>t;t++)m=f[t].update(e)&&m;return m};var f=[],v=new t;
return p.prototype.getBoundingSphere=function(e,r){for(var i=f,n=v,a=0,s=o.DONE,l=this._batches,u=l.length,c=0;u>c;c++){if(s=l[c].getBoundingSphere(e,n),s===o.PENDING)return o.PENDING;s===o.DONE&&(i[a]=t.clone(n,i[a]),a++)}return 0===a?o.FAILED:(i.length=a,t.fromBoundingSpheres(i,r),o.DONE)},p.prototype.isDestroyed=function(){return!1},p.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(p.prototype._onCollectionChanged,this),this._addedObjects.removeAll(),this._removedObjects.removeAll();var e,t=this._batches,r=t.length;for(e=0;r>e;e++)t[e].removeAllPrimitives();var n=this._subscriptions.values;for(r=n.length,e=0;r>e;e++)n[e]();return this._subscriptions.removeAll(),i(this)},p._onGeometryChanged=function(e){var t=this._removedObjects,i=this._changedObjects,n=e.entity,o=n.id;r(t.get(o))||r(i.get(o))||i.set(o,n)},p.prototype._onCollectionChanged=function(e,t,r){var i,n,o,a=this._addedObjects,s=this._removedObjects,l=this._changedObjects;for(i=r.length-1;i>-1;i--)o=r[i],n=o.id,a.remove(n)||(s.set(n,o),l.remove(n));for(i=t.length-1;i>-1;i--)o=t[i],n=o.id,s.remove(n)?l.set(n,o):a.set(n,o)},p}),r("Scene/Label",["../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/NearFarScalar","./Billboard","./HeightReference","./HorizontalOrigin","./LabelStyle","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u,c,h,d){"use strict";function p(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._rebindAllGlyphs=!0}function m(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._repositionAllGlyphs=!0}function f(n,o){n=i(n,i.EMPTY_OBJECT),this._text=i(n.text,""),this._show=i(n.show,!0),this._font=i(n.font,"30px sans-serif"),this._fillColor=r.clone(i(n.fillColor,r.WHITE)),this._outlineColor=r.clone(i(n.outlineColor,r.BLACK)),this._outlineWidth=i(n.outlineWidth,1),this._style=i(n.style,h.FILL),this._verticalOrigin=i(n.verticalOrigin,d.BOTTOM),this._horizontalOrigin=i(n.horizontalOrigin,c.LEFT),this._pixelOffset=e.clone(i(n.pixelOffset,e.ZERO)),this._eyeOffset=t.clone(i(n.eyeOffset,t.ZERO)),this._position=t.clone(i(n.position,t.ZERO)),this._scale=i(n.scale,1),this._id=n.id,this._translucencyByDistance=n.translucencyByDistance,this._pixelOffsetScaleByDistance=n.pixelOffsetScaleByDistance,this._heightReference=i(n.heightReference,u.NONE),this._labelCollection=o,this._glyphs=[],this._rebindAllGlyphs=!0,this._repositionAllGlyphs=!0,this._actualClampedPosition=void 0,this._removeCallbackFunc=void 0,this._mode=void 0,this._updateClamping()}return o(f.prototype,{show:{get:function(){return this._show},set:function(e){if(this._show!==e){this._show=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.show=e)}}}},position:{get:function(){return this._position},set:function(e){var r=this._position;if(!t.equals(r,e))if(t.clone(e,r),this._heightReference===u.NONE)for(var i=this._glyphs,o=0,a=i.length;a>o;o++){var s=i[o];n(s.billboard)&&(s.billboard.position=e)}else this._updateClamping()}},heightReference:{get:function(){return this._heightReference},set:function(e){e!==this._heightReference&&(this._heightReference=e,this._updateClamping())}},text:{get:function(){return this._text},set:function(e){this._text!==e&&(this._text=e,p(this))}},font:{get:function(){return this._font},set:function(e){this._font!==e&&(this._font=e,p(this))}},fillColor:{get:function(){return this._fillColor},set:function(e){var t=this._fillColor;r.equals(t,e)||(r.clone(e,t),p(this))}},outlineColor:{get:function(){return this._outlineColor},set:function(e){var t=this._outlineColor;r.equals(t,e)||(r.clone(e,t),p(this))}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){this._outlineWidth!==e&&(this._outlineWidth=e,p(this))}},style:{get:function(){return this._style},set:function(e){this._style!==e&&(this._style=e,p(this))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(t){var r=this._pixelOffset;if(!e.equals(r,t)){e.clone(t,r);for(var i=this._glyphs,o=0,a=i.length;a>o;o++){var s=i[o];n(s.billboard)&&(s.billboard.pixelOffset=t)}}}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){var t=this._translucencyByDistance;if(!s.equals(t,e)){this._translucencyByDistance=s.clone(e,t);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var a=r[i];n(a.billboard)&&(a.billboard.translucencyByDistance=e)}}}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){var t=this._pixelOffsetScaleByDistance;if(!s.equals(t,e)){this._pixelOffsetScaleByDistance=s.clone(e,t);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var a=r[i];n(a.billboard)&&(a.billboard.pixelOffsetScaleByDistance=e)}}}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){var r=this._eyeOffset;if(!t.equals(r,e)){t.clone(e,r);for(var i=this._glyphs,o=0,a=i.length;a>o;o++){var s=i[o];n(s.billboard)&&(s.billboard.eyeOffset=e)}}}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){this._horizontalOrigin!==e&&(this._horizontalOrigin=e,m(this))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){if(this._verticalOrigin!==e){this._verticalOrigin=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.verticalOrigin=e)}m(this)}}},scale:{get:function(){return this._scale},set:function(e){if(this._scale!==e){this._scale=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.scale=e)}m(this)}}},id:{get:function(){return this._id},set:function(e){if(this._id!==e){this._id=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.id=e)}}}},_clampedPosition:{get:function(){return this._actualClampedPosition},set:function(e){this._actualClampedPosition=t.clone(e,this._actualClampedPosition);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var a=r[i];n(a.billboard)&&(a.billboard.position=e)}}}}),f.prototype._updateClamping=function(){l._updateClamping(this._labelCollection,this)},f.prototype.computeScreenSpacePosition=function(t,r){n(r)||(r=new e);var i=this._labelCollection,o=i.modelMatrix,a=l._computeActualPosition(this,this._position,t.frameState,o),s=l._computeScreenSpacePosition(o,a,this._eyeOffset,this._pixelOffset,t,r);return s.y=t.canvas.clientHeight-s.y,s},f.prototype.equals=function(i){return this===i||n(i)&&this._show===i._show&&this._scale===i._scale&&this._style===i._style&&this._verticalOrigin===i._verticalOrigin&&this._horizontalOrigin===i._horizontalOrigin&&this._text===i._text&&this._font===i._font&&t.equals(this._position,i._position)&&r.equals(this._fillColor,i._fillColor)&&r.equals(this._outlineColor,i._outlineColor)&&e.equals(this._pixelOffset,i._pixelOffset)&&t.equals(this._eyeOffset,i._eyeOffset)&&s.equals(this._translucencyByDistance,i._translucencyByDistance)&&s.equals(this._pixelOffsetScaleByDistance,i._pixelOffsetScaleByDistance)&&this._id===i._id},f.prototype.isDestroyed=function(){return!1},f}),r("Scene/LabelCollection",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Core/writeTextToCanvas","./BillboardCollection","./HorizontalOrigin","./Label","./LabelStyle","./TextureAtlas","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(){this.textureInfo=void 0,this.dimensions=void 0,this.billboard=void 0}function f(e,t,r){this.labelCollection=e,this.index=t,this.dimensions=r}function v(e,t,r,i,n,o,a){return w.font=t,w.fillColor=r,w.strokeColor=i,w.strokeWidth=n,a===p.BOTTOM?w.textBaseline="bottom":a===p.TOP?w.textBaseline="top":w.textBaseline="middle",w.fill=o===h.FILL||o===h.FILL_AND_OUTLINE,w.stroke=o===h.OUTLINE||o===h.FILL_AND_OUTLINE,s(e,w)}function _(e,t){t.textureInfo=void 0,t.dimensions=void 0;var i=t.billboard;r(i)&&(i.show=!1,i.image=void 0,e._spareBillboards.push(i),t.billboard=void 0)}function g(e,t,r,i){e.addImage(t,r).then(function(e,t){i.index=e})}function y(e,t){var i,n,o,a=t._text,s=a.length,l=t._glyphs,c=l.length;if(c>s)for(n=s;c>n;++n)_(e,l[n]);l.length=s;var h=e._glyphTextureCache;for(o=0;s>o;++o){var d=a.charAt(o),p=t._font,y=t._fillColor,C=t._outlineColor,E=t._outlineWidth,S=t._style,w=t._verticalOrigin,T=JSON.stringify([d,p,y.toRgba(),C.toRgba(),E,+S,+w]),x=h[T];if(!r(x)){var b=v(d,p,y,C,E,S,w);x=new f(e,-1,b.dimensions),h[T]=x,b.width>0&&b.height>0&&g(e._textureAtlas,T,b,x)}if(i=l[o],r(i)?-1===x.index?_(e,i):r(i.textureInfo)&&(i.textureInfo=void 0):(i=new m,l[o]=i),i.textureInfo=x,i.dimensions=x.dimensions,-1!==x.index){var P=i.billboard;r(P)||(P=e._spareBillboards.length>0?e._spareBillboards.pop():e._billboardCollection.add({collection:e}),i.billboard=P),P.show=t._show,P.position=t._position,P.eyeOffset=t._eyeOffset,P.pixelOffset=t._pixelOffset,P.horizontalOrigin=u.LEFT,P.verticalOrigin=t._verticalOrigin,P.scale=t._scale,P.pickPrimitive=t,P.id=t._id,P.image=T,P.translucencyByDistance=t._translucencyByDistance,P.pixelOffsetScaleByDistance=t._pixelOffsetScaleByDistance}}t._repositionAllGlyphs=!0}function C(e,t){var i,n,o=e._glyphs,a=0,s=0,l=0,c=o.length;for(l=0;c>l;++l)i=o[l],n=i.dimensions,a+=n.computedWidth,s=Math.max(s,n.height);var h=e._scale,d=e._horizontalOrigin,m=0;d===u.CENTER?m-=a/2*h:d===u.RIGHT&&(m-=a*h),T.x=m*t,T.y=0;var f=e._verticalOrigin;for(l=0;c>l;++l)i=o[l],n=i.dimensions,f===p.BOTTOM||n.height===s?T.y=-n.descent*h:f===p.TOP?T.y=-(s-n.height)*h-n.descent*h:f===p.CENTER&&(T.y=-(s-n.height)/2*h-n.descent*h),T.y*=t,r(i.billboard)&&i.billboard._setTranslate(T),T.x+=n.computedWidth*h*t}function E(e,t){for(var i=t._glyphs,o=0,a=i.length;a>o;++o)_(e,i[o]);t._labelCollection=void 0,r(t._removeCallbackFunc)&&t._removeCallbackFunc(),n(t)}function S(e){e=t(e,t.EMPTY_OBJECT),this._scene=e.scene,this._textureAtlas=void 0,this._billboardCollection=new l({scene:this._scene}),this._billboardCollection.destroyTextureAtlas=!1,this._spareBillboards=[],this._glyphTextureCache={},this._labels=[],this._labelsToUpdate=[],this._totalGlyphCount=0,this._resolutionScale=void 0,this.modelMatrix=a.clone(t(e.modelMatrix,a.IDENTITY)),this.debugShowBoundingVolume=t(e.debugShowBoundingVolume,!1)}var w={},T=new e;return i(S.prototype,{length:{get:function(){return this._labels.length}}}),S.prototype.add=function(e){var t=new c(e,this);return this._labels.push(t),this._labelsToUpdate.push(t),t},S.prototype.remove=function(e){if(r(e)&&e._labelCollection===this){var t=this._labels.indexOf(e);if(-1!==t)return this._labels.splice(t,1),E(this,e),!0}return!1},S.prototype.removeAll=function(){for(var e=this._labels,t=0,r=e.length;r>t;++t)E(this,e[t]);e.length=0},S.prototype.contains=function(e){return r(e)&&e._labelCollection===this},S.prototype.get=function(e){return this._labels[e]},S.prototype.update=function(e){var t=this._billboardCollection;t.modelMatrix=this.modelMatrix,t.debugShowBoundingVolume=this.debugShowBoundingVolume;var i=e.context;r(this._textureAtlas)||(this._textureAtlas=new d({context:i}),t.textureAtlas=this._textureAtlas);var n=i.uniformState,o=n.resolutionScale,a=this._resolutionScale!==o;this._resolutionScale=o;var s;s=a?this._labels:this._labelsToUpdate;for(var l=s.length,u=0;l>u;++u){var c=s[u];if(!c.isDestroyed()){var h=c._glyphs.length;c._rebindAllGlyphs&&(y(this,c),c._rebindAllGlyphs=!1),(a||c._repositionAllGlyphs)&&(C(c,o),c._repositionAllGlyphs=!1);var p=c._glyphs.length-h;this._totalGlyphCount+=p}}this._labelsToUpdate.length=0,t.update(e)},S.prototype.isDestroyed=function(){return!1},S.prototype.destroy=function(){return this.removeAll(),this._billboardCollection=this._billboardCollection.destroy(),this._textureAtlas=this._textureAtlas&&this._textureAtlas.destroy(),n(this)},S}),r("DataSources/LabelVisualizer",["../Core/AssociativeArray","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/HorizontalOrigin","../Scene/LabelCollection","../Scene/LabelStyle","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p){"use strict";function m(e){this.entity=e,this.label=void 0,this.index=void 0}function f(t,r){r.collectionChanged.addEventListener(f.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._labelCollection=void 0,this._entityCollection=r,this._items=new e,this._onCollectionChanged(r,r.values,[],[])}function v(e,t){if(n(e)){var r=e.label;n(r)&&(t.push(e.index),r.show=!1,e.label=void 0,e.index=-1)}}var _=1,g="30px sans-serif",y=c.FILL,C=i.WHITE,E=i.BLACK,S=1,w=t.ZERO,T=r.ZERO,x=l.CENTER,b=h.CENTER,P=new r,A=new i,I=new i,M=new r,D=new t,R=new s,O=new s;return f.prototype.update=function(e){for(var t=this._items.values,r=this._unusedIndexes,i=0,o=t.length;o>i;i++){var a,s=t[i],l=s.entity,c=l._label,h=s.label,d=l.isShowing&&l.isAvailable(e)&&p.getValueOrDefault(c._show,e,!0);if(d&&(P=p.getValueOrUndefined(l._position,e,P),a=p.getValueOrUndefined(c._text,e),d=n(P)&&n(a)),d){if(!n(h)){var m=this._labelCollection;n(m)||(m=new u,this._labelCollection=m,this._scene.primitives.add(m));var f=r.length;if(f>0){var N=r.pop();s.index=N,h=m.get(N)}else h=m.add(),s.index=m.length-1;h.id=l,s.label=h}h.show=!0,h.position=P,h.text=a,h.scale=p.getValueOrDefault(c._scale,e,_),h.font=p.getValueOrDefault(c._font,e,g),h.style=p.getValueOrDefault(c._style,e,y),h.fillColor=p.getValueOrDefault(c._fillColor,e,C,A),h.outlineColor=p.getValueOrDefault(c._outlineColor,e,E,I),h.outlineWidth=p.getValueOrDefault(c._outlineWidth,e,S),h.pixelOffset=p.getValueOrDefault(c._pixelOffset,e,w,D),h.eyeOffset=p.getValueOrDefault(c._eyeOffset,e,T,M),h.horizontalOrigin=p.getValueOrDefault(c._horizontalOrigin,e,x),h.verticalOrigin=p.getValueOrDefault(c._verticalOrigin,e,b),h.translucencyByDistance=p.getValueOrUndefined(c._translucencyByDistance,e,R),h.pixelOffsetScaleByDistance=p.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,O)}else v(s,r)}return!0},f.prototype.getBoundingSphere=function(e,t){var i=this._items.get(e.id);return n(i)&&n(i.label)?(t.center=r.clone(i.label.position,t.center),t.radius=0,d.DONE):d.FAILED},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(f.prototype._onCollectionChanged,this),n(this._labelCollection)&&this._scene.primitives.remove(this._labelCollection),o(this)},f.prototype._onCollectionChanged=function(e,t,r,i){var o,a,s=this._unusedIndexes,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],n(a._label)&&n(a._position)&&l.set(a.id,new m(a));for(o=i.length-1;o>-1;o--)a=i[o],n(a._label)&&n(a._position)?l.contains(a.id)||l.set(a.id,new m(a)):(v(l.get(a.id),s),l.remove(a.id));for(o=r.length-1;o>-1;o--)a=r[o],v(l.get(a.id),s),l.remove(a.id)},f}),r("ThirdParty/gltfDefaults",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/Quaternion","../Renderer/WebGLConstants"],function(e,t,r,i,n){"use strict";function o(e){r(e.accessors)||(e.accessors={});var i=e.accessors;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];o.byteStride=t(o.byteStride,0)}}function a(e){r(e.animations)||(e.animations={});var i=e.animations;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];r(o.channels)||(o.channels=[]),r(o.parameters)||(o.parameters={}),r(o.samplers)||(o.samplers={});var a=i.samplers;for(var s in a)if(a.hasOwnProperty(s)){var l=a[s];l.interpolation=t(l.interpolation,"LINEAR")}}}function s(e){r(e.asset)||(e.asset={});var i=e.asset;r(i.profile)&&"string"!=typeof i.profile||(i.profile={});var n=i.profile;i.premultipliedAlpha=t(i.premultipliedAlpha,!1),n.api=t(n.api,"WebGL"),n.version=t(n.version,"1.0.2"),r(e.version)&&(i.version=t(i.version,e.version),delete e.version),"number"==typeof i.version&&(i.version=i.version.toFixed(1).toString())}function l(e){r(e.buffers)||(e.buffers={});var i=e.buffers;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];o.type=t(o.type,"arraybuffer")}}function u(e){r(e.bufferViews)||(e.bufferViews={})}function c(e){r(e.cameras)||(e.cameras={})}function h(e){r(e.images)||(e.images={})}function d(e){r(e.extensions)||(e.extensions={});var i=e.extensions;r(i.KHR_materials_common)||(i.KHR_materials_common={});var n=i.KHR_materials_common;r(e.lights)?(n.lights=e.lights,delete e.lights):r(n.lights)||(n.lights={});var o=n.lights;for(var a in o)if(o.hasOwnProperty(a)){var s=o[a];if("ambient"===s.type){r(s.ambient)||(s.ambient={});var l=s.ambient;r(l.color)||(l.color=[1,1,1])}else if("directional"===s.type){r(s.directional)||(s.directional={});var u=s.directional;r(u.color)||(u.color=[1,1,1])}else if("point"===s.type){r(s.point)||(s.point={});var c=s.point;r(c.color)||(c.color=[1,1,1]),c.constantAttenuation=t(c.constantAttenuation,1),c.linearAttenuation=t(c.linearAttenuation,0),c.quadraticAttenuation=t(c.quadraticAttenuation,0)}else if("spot"===s.type){r(s.spot)||(s.spot={});var h=s.spot;r(h.color)||(h.color=[1,1,1]),h.constantAttenuation=t(h.constantAttenuation,1),h.fallOffAngle=t(h.fallOffAngle,3.14159265),h.fallOffExponent=t(h.fallOffExponent,0),h.linearAttenuation=t(h.linearAttenuation,0),h.quadraticAttenuation=t(h.quadraticAttenuation,0)}}}function p(e){r(e.materials)||(e.materials={});var t=e.materials;for(var i in t)if(t.hasOwnProperty(i)){var o=t[i],a=o.instanceTechnique;if(r(a)&&(o.technique=a.technique,o.values=a.values,delete o.instanceTechnique),!r(o.extensions))if(r(o.technique))r(o.values)||(o.values={});else{delete o.values,o.extensions={KHR_materials_common:{technique:"CONSTANT",transparent:!1,values:{emission:{type:n.FLOAT_VEC4,value:[.5,.5,.5,1]}}}},r(e.extensionsUsed)||(e.extensionsUsed=[]);var s=e.extensionsUsed;-1===s.indexOf("KHR_materials_common")&&s.push("KHR_materials_common")}}}function m(e){r(e.meshes)||(e.meshes={});var i=e.meshes;for(var o in i)if(i.hasOwnProperty(o)){var a=i[o];r(a.primitives)||(a.primitives=[]);for(var s=a.primitives.length,l=s.length,u=0;l>u;++u){var c=s[u];r(c.attributes)||(c.attributes={});var h=t(c.primitive,n.TRIANGLES);c.mode=t(c.mode,h)}}}function f(t){r(t.nodes)||(t.nodes={});var n=t.nodes,o=parseFloat(t.asset.version)<1,a=new e,s=new i;for(var l in n)if(n.hasOwnProperty(l)){var u=n[l];if(r(u.children)||(u.children=[]),o&&r(u.rotation)){var c=u.rotation;e.fromArray(c,0,a),i.fromAxisAngle(a,c[3],s),u.rotation=[s.x,s.y,s.z,s.w]}r(u.matrix)||(r(u.translation)||r(u.rotation)||r(u.scale)?(r(u.translation)||(u.translation=[0,0,0]),r(u.rotation)||(u.rotation=[0,0,0,1]),r(u.scale)||(u.scale=[1,1,1])):u.matrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);var h=u.instanceSkin;r(h)&&(u.skeletons=h.skeletons,u.skin=h.skin,u.meshes=h.meshes,delete u.instanceSkin)}}function v(e){r(e.programs)||(e.programs={});var t=e.programs;for(var i in t)if(t.hasOwnProperty(i)){var n=t[i];r(n.attributes)||(n.attributes=[])}}function _(e){r(e.samplers)||(e.samplers={});var i=e.samplers;for(var o in i)if(i.hasOwnProperty(o)){var a=i[o];a.magFilter=t(a.magFilter,n.LINEAR),a.minFilter=t(a.minFilter,n.NEAREST_MIPMAP_LINEAR),a.wrapS=t(a.wrapS,n.REPEAT),a.wrapT=t(a.wrapT,n.REPEAT)}}function g(e){r(e.scenes)||(e.scenes={});var t=e.scenes;for(var i in t)if(t.hasOwnProperty(i)){var n=t[i];r(n.node)||(n.node=[])}}function y(e){r(e.shaders)||(e.shaders={})}function C(e){r(e.skins)||(e.skins={});var t=e.skins;for(var i in t)if(t.hasOwnProperty(i)){var n=t[i];r(n.bindShapeMatrix)&&(n.bindShapeMatrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}}function E(e){r(e.enable)||(e.enable=[]),r(e.disable)||(e.disable=[])}function S(e){r(e.techniques)||(e.techniques={});var i=e.techniques;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];r(o.parameters)||(o.parameters={});var a=o.parameters;for(var s in a){var l=a[s];l.node=t(l.node,l.source),l.source=void 0}var u=o.passes;if(r(u)){var c=t(o.pass,"defaultPass");if(u.hasOwnProperty(c)){var h=u[c],d=h.instanceProgram;o.attributes=t(o.attributes,d.attributes),o.program=t(o.program,d.program),o.uniforms=t(o.uniforms,d.uniforms),o.states=t(o.states,h.states)}o.passes=void 0,o.pass=void 0}r(o.attributes)||(o.attributes={}),r(o.uniforms)||(o.uniforms={}),r(o.states)||(o.states={}),E(o.states)}}function w(e){r(e.textures)||(e.textures={});var i=e.textures;for(var o in i)if(i.hasOwnProperty(o)){var a=i[o];a.format=t(a.format,n.RGBA),a.internalFormat=t(a.internalFormat,a.format),a.target=t(a.target,n.TEXTURE_2D),a.type=t(a.type,n.UNSIGNED_BYTE)}}var T=function(e){return r(e)?(r(e.allExtensions)&&(e.extensionsUsed=e.allExtensions,e.allExtensions=void 0),e.extensionsUsed=t(e.extensionsUsed,[]),o(e),a(e),s(e),l(e),u(e),c(e),h(e),d(e),p(e),m(e),f(e),v(e),_(e),g(e),y(e),C(e),S(e),w(e),e):void 0};return T}),r("Scene/getModelAccessor",["../Core/ComponentDatatype"],function(e){"use strict";function t(t){var i=t.componentType,n=r[t.type];return{componentsPerAttribute:n,createArrayBufferView:function(t,r,o){return e.createArrayBufferView(i,t,r,n*o)}}}var r={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};return t}),r("Scene/ModelAnimationCache",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/LinearSpline","../Core/Matrix4","../Core/Quaternion","../Core/QuaternionSpline","../Renderer/WebGLConstants","./getModelAccessor"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(){}function c(e,r){var i=e.gltf,n=i.buffers,o=i.bufferViews,a=o[r.bufferView],s=n[a.buffer],u=a.byteOffset+r.byteOffset,c=r.count*l(r).componentsPerAttribute;return e.cacheKey+"//"+t(s.path,"")+"/"+u+"/"+c}function h(e,t,r){return e.cacheKey+"//"+t+"/"+r}function d(e){this._value=e}var p={},m=new e;u.getAnimationParameterValues=function(t,i){var n=c(t,i),a=p[n];if(!r(a)){var u,h=t._loadResources,d=t.gltf,f=parseFloat(d.asset.version)<1,v=d.bufferViews,_=v[i.bufferView],g=i.componentType,y=i.type,C=i.count,E=h.getBuffer(_),S=l(i).createArrayBufferView(E.buffer,E.byteOffset+i.byteOffset,C);if(g===s.FLOAT&&"SCALAR"===y)a=S;else if(g===s.FLOAT&&"VEC3"===y)for(a=new Array(C),u=0;C>u;++u)a[u]=e.fromArray(S,3*u);else if(g===s.FLOAT&&"VEC4"===y)for(a=new Array(C),u=0;C>u;++u){var w=4*u;f?a[u]=o.fromAxisAngle(e.fromArray(S,w,m),S[w+3]):a[u]=o.unpack(S,w)}r(t.cacheKey)&&(p[n]=a)}return a};var f={};d.prototype.evaluate=function(e,t){return this._value},u.getAnimationSpline=function(e,t,n,o,l,u){var c=h(e,t,o),p=f[c];if(!r(p)){var m=u[l.input],v=e.gltf.accessors[n.parameters[l.output]],_=u[l.output];if(1===m.length&&1===_.length)p=new d(_[0]);else{var g=v.componentType,y=v.type;"LINEAR"===l.interpolation&&(g===s.FLOAT&&"VEC3"===y?p=new i({times:m,points:_}):g===s.FLOAT&&"VEC4"===y&&(p=new a({times:m,points:_})))}r(e.cacheKey)&&(f[c]=p)}return p};var v={};return u.getSkinInverseBindMatrices=function(e,t){var i=c(e,t),o=v[i];if(!r(o)){var a=e._loadResources,u=e.gltf,h=u.bufferViews,d=h[t.bufferView],p=t.componentType,m=t.type,f=t.count,_=a.getBuffer(d),g=l(t).createArrayBufferView(_.buffer,_.byteOffset+t.byteOffset,f);if(o=new Array(f),p===s.FLOAT&&"MAT4"===m)for(var y=0;f>y;++y)o[y]=n.fromArray(g,16*y);v[i]=o}return o},u}),r("Scene/ModelAnimationLoop",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,REPEAT:1,MIRRORED_REPEAT:2};return e(t)}),r("Scene/ModelAnimationState",["../Core/freezeObject"],function(e){"use strict";return e({STOPPED:0,ANIMATING:1})}),r("Scene/ModelAnimation",["../Core/defaultValue","../Core/defineProperties","../Core/Event","../Core/JulianDate","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,r,i,n,o){"use strict";function a(t,a,s){this._name=t.name,this._startTime=i.clone(t.startTime),this._delay=e(t.delay,0),this._stopTime=t.stopTime,this.removeOnStop=e(t.removeOnStop,!1),this._speedup=e(t.speedup,1),this._reverse=e(t.reverse,!1),this._loop=e(t.loop,n.NONE),this.start=new r,this.update=new r,this.stop=new r,this._state=o.STOPPED,this._runtimeAnimation=s,this._computedStartTime=void 0,this._duration=void 0;var l=this;this._raiseStartEvent=function(){l.start.raiseEvent(a,l)},this._updateEventTime=0,this._raiseUpdateEvent=function(){l.update.raiseEvent(a,l,l._updateEventTime)},this._raiseStopEvent=function(){l.stop.raiseEvent(a,l)}}return t(a.prototype,{name:{get:function(){return this._name}},startTime:{get:function(){return this._startTime}},delay:{get:function(){return this._delay}},stopTime:{get:function(){return this._stopTime}},speedup:{get:function(){return this._speedup}},reverse:{get:function(){return this._reverse}},loop:{get:function(){return this._loop}}}),a}),r("Scene/ModelAnimationCollection",["../Core/clone","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","../Core/Math","./ModelAnimation","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,r,i,n,o,a,s,l,u,c){"use strict";function h(e){this.animationAdded=new o,this.animationRemoved=new o,this._model=e,this._scheduledAnimations=[],this._previousTime=void 0}function d(e,t){for(var r=e.channelEvaluators,i=r.length,n=0;i>n;++n)r[n](t)}function p(e,t,r){return function(){e.animationRemoved.raiseEvent(t,r)}}i(h.prototype,{length:{get:function(){return this._scheduledAnimations.length}}}),h.prototype.add=function(e){e=t(e,t.EMPTY_OBJECT);var r=this._model,i=r._runtime.animations,n=i[e.name],o=new l(e,r,n);return this._scheduledAnimations.push(o),this.animationAdded.raiseEvent(r,o),o},h.prototype.addAll=function(r){r=t(r,t.EMPTY_OBJECT),r=e(r);for(var i=[],n=this._model._animationIds,o=n.length,a=0;o>a;++a)r.name=n[a],i.push(this.add(r));return i},h.prototype.remove=function(e){if(r(e)){var t=this._scheduledAnimations,i=t.indexOf(e);if(-1!==i)return t.splice(i,1),this.animationRemoved.raiseEvent(this._model,e),!0}return!1},h.prototype.removeAll=function(){var e=this._model,t=this._scheduledAnimations,r=t.length;this._scheduledAnimations=[];for(var i=0;r>i;++i)this.animationRemoved.raiseEvent(e,t[i])},h.prototype.contains=function(e){return r(e)?-1!==this._scheduledAnimations.indexOf(e):!1},h.prototype.get=function(e){return this._scheduledAnimations[e]};var m=[];return h.prototype.update=function(e){var i=this._scheduledAnimations,n=i.length;if(0===n)return this._previousTime=void 0,!1;if(a.equals(e.time,this._previousTime))return!1;this._previousTime=a.clone(e.time,this._previousTime);for(var o=!1,l=e.time,h=this._model,f=0;n>f;++f){var v=i[f],_=v._runtimeAnimation;r(v._computedStartTime)||(v._computedStartTime=a.addSeconds(t(v.startTime,l),v.delay,new a)),r(v._duration)||(v._duration=_.stopTime*(1/v.speedup));var g=v._computedStartTime,y=v._duration,C=v.stopTime,E=0!==y?a.secondsDifference(l,g)/y:0,S=E>=0,w=S&&(1>=E||v.loop===u.REPEAT||v.loop===u.MIRRORED_REPEAT)&&(!r(C)||a.lessThanOrEquals(l,C));if(w){if(v._state===c.STOPPED&&(v._state=c.ANIMATING,v.start.numberOfListeners>0&&e.afterRender.push(v._raiseStartEvent)),v.loop===u.REPEAT)E-=Math.floor(E);else if(v.loop===u.MIRRORED_REPEAT){var T=Math.floor(E),x=E-T;E=T%2===1?1-x:x}v.reverse&&(E=1-E);var b=E*y*v.speedup;b=s.clamp(b,_.startTime,_.stopTime),d(_,b),v.update.numberOfListeners>0&&(v._updateEventTime=b,e.afterRender.push(v._raiseUpdateEvent)),o=!0}else S&&v._state===c.ANIMATING&&(v._state=c.STOPPED,v.stop.numberOfListeners>0&&e.afterRender.push(v._raiseStopEvent),v.removeOnStop&&m.push(v))}n=m.length;for(var P=0;n>P;++P){var A=m[P];i.splice(i.indexOf(A),1),e.afterRender.push(p(this,h,A))}return m.length=0,o},h}),r("Scene/ModelMaterial",["../Core/defined","../Core/defineProperties","../Core/DeveloperError"],function(e,t,r){"use strict";function i(e,t,r){this._name=t.name,this._id=r,this._uniformMap=e._uniformMaps[r]}return t(i.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}}}),i.prototype.setValue=function(e,t){var r=this._uniformMap.values[e];r.value=r.clone(t,r.value)},i.prototype.getValue=function(t){var r=this._uniformMap.values[t];if(e(r))return r.value},i}),r("Scene/modelMaterialsCommon",["../Core/defaultValue","../Core/defined","../Renderer/WebGLConstants"],function(e,t,r){"use strict";function i(e){switch(e){case r.FLOAT:return"float";case r.FLOAT_VEC2:return"vec2";case r.FLOAT_VEC3:return"vec3";case r.FLOAT_VEC4:return"vec4";case r.FLOAT_MAT2:return"mat2";case r.FLOAT_MAT3:return"mat3";case r.FLOAT_MAT4:return"mat4";case r.SAMPLER_2D:return"sampler2D"}}function n(e){var i,n={};if(t(e.extensions)&&t(e.extensions.KHR_materials_common)&&(i=e.extensions.KHR_materials_common.lights),t(i)){var o=e.nodes;for(var a in o)if(o.hasOwnProperty(a)){var s=o[a];if(t(s.extensions)&&t(s.extensions.KHR_materials_common)){var l=s.extensions.KHR_materials_common.light;t(l)&&t(i[l])&&(i[l].node=a),delete s.extensions.KHR_materials_common}}var u=0;for(var c in i)if(i.hasOwnProperty(c)){var h=i[c],d=h.type;if("ambient"!==d&&!t(h.node)){delete i[c];continue}var p="light"+u.toString();switch(h.baseName=p,d){case"ambient":var m=h.ambient;n[p+"Color"]={type:r.FLOAT_VEC3,value:m.color};break;case"directional":var f=h.directional;n[p+"Color"]={type:r.FLOAT_VEC3,value:f.color},t(h.node)&&(n[p+"Transform"]={node:h.node,semantic:"MODELVIEW",type:r.FLOAT_MAT4});break;case"point":var v=h.point;n[p+"Color"]={type:r.FLOAT_VEC3,value:v.color},t(h.node)&&(n[p+"Transform"]={node:h.node,semantic:"MODELVIEW",type:r.FLOAT_MAT4}),n[p+"Attenuation"]={type:r.FLOAT_VEC3,value:[v.constantAttenuation,v.linearAttenuation,v.quadraticAttenuation]};break;case"spot":var _=h.spot;n[p+"Color"]={type:r.FLOAT_VEC3,value:_.color},t(h.node)&&(n[p+"Transform"]={node:h.node,semantic:"MODELVIEW",type:r.FLOAT_MAT4},n[p+"InverseTransform"]={node:h.node,semantic:"MODELVIEWINVERSE",type:r.FLOAT_MAT4,useInFragment:!0}),n[p+"Attenuation"]={type:r.FLOAT_VEC3,value:[_.constantAttenuation,_.linearAttenuation,_.quadraticAttenuation]},n[p+"FallOff"]={type:r.FLOAT_VEC2,value:[_.fallOffAngle,_.fallOffExponent]}}++u}}return n}function o(r,i,n){var o,a=e(n,0);do o=i+(a++).toString();while(t(r[o]));return o}function a(n,a,s){var l,p=n.techniques,m=n.shaders,f=n.programs,v=a.technique.toUpperCase();t(n.extensions)&&t(n.extensions.KHR_materials_common)&&(l=n.extensions.KHR_materials_common.lights);var _=e(a.jointCount,0),g=_>0,y=a.values,C="precision highp float;\n",E="precision highp float;\n",S=o(p,"technique",u),w=o(m,"vertexShader",c),T=o(m,"fragmentShader",h),x=o(f,"program",d),b="CONSTANT"!==v,P={modelViewMatrix:{semantic:"MODELVIEW",type:r.FLOAT_MAT4},projectionMatrix:{semantic:"PROJECTION",type:r.FLOAT_MAT4}};b&&(P.normalMatrix={semantic:"MODELVIEWINVERSETRANSPOSE",type:r.FLOAT_MAT3}),g&&(P.jointMatrix={count:_,semantic:"JOINTMATRIX",type:r.FLOAT_MAT4});var A,I=!1;for(var M in y)if(y.hasOwnProperty(M)){var D=y[M];A=M.toLowerCase(),I||D.type!==r.SAMPLER_2D||(I=!0),P[A]={type:D.type}}if(t(s))for(var R in s)s.hasOwnProperty(R)&&(P[R]=s[R]);var O={};for(var N in P)if(P.hasOwnProperty(N)){var L=P[N];O["u_"+N]=N;var F=t(L.count)?"["+L.count+"]":"";L.type!==r.FLOAT_MAT3&&L.type!==r.FLOAT_MAT4||L.useInFragment?(E+="uniform "+i(L.type)+" u_"+N+F+";\n",delete L.useInFragment):C+="uniform "+i(L.type)+" u_"+N+F+";\n"}var B="";g&&(B+="  mat4 skinMat = a_weight.x * u_jointMatrix[int(a_joint.x)];\n",B+="  skinMat += a_weight.y * u_jointMatrix[int(a_joint.y)];\n",B+="  skinMat += a_weight.z * u_jointMatrix[int(a_joint.z)];\n",B+="  skinMat += a_weight.w * u_jointMatrix[int(a_joint.w)];\n");var V={a_position:"position"};P.position={semantic:"POSITION",type:r.FLOAT_VEC3},C+="attribute vec3 a_position;\n",C+="varying vec3 v_positionEC;\n",B+=g?"  vec4 pos = u_modelViewMatrix * skinMat * vec4(a_position,1.0);\n":"  vec4 pos = u_modelViewMatrix * vec4(a_position,1.0);\n",B+="  v_positionEC = pos.xyz;\n",B+="  gl_Position = u_projectionMatrix * pos;\n",E+="varying vec3 v_positionEC;\n",b&&(V.a_normal="normal",P.normal={semantic:"NORMAL",type:r.FLOAT_VEC3},C+="attribute vec3 a_normal;\n",C+="varying vec3 v_normal;\n",B+=g?"  v_normal = u_normalMatrix * mat3(skinMat) * a_normal;\n":"  v_normal = u_normalMatrix * a_normal;\n",
E+="varying vec3 v_normal;\n");var z;I&&(V.a_texcoord_0="texcoord_0",P.texcoord_0={semantic:"TEXCOORD_0",type:r.FLOAT_VEC2},z="v_texcoord_0",C+="attribute vec2 a_texcoord_0;\n",C+="varying vec2 "+z+";\n",B+="  "+z+" = a_texcoord_0;\n",E+="varying vec2 "+z+";\n"),g&&(V.a_joint="joint",P.joint={semantic:"JOINT",type:r.FLOAT_VEC4},V.a_weight="weight",P.weight={semantic:"WEIGHT",type:r.FLOAT_VEC4},C+="attribute vec4 a_joint;\n",C+="attribute vec4 a_weight;\n");var k=b&&("BLINN"===v||"PHONG"===v)&&t(P.specular)&&t(P.shininess),U=!1,G=!1,W="";for(var H in l)if(l.hasOwnProperty(H)){var q=l[H],j=q.type.toLowerCase(),Y=q.baseName;W+="  {\n";var X,Z,K="u_"+Y+"Color";"ambient"===j?(G=!0,W+="    ambientLight += "+K+";\n"):b&&(U=!0,X="v_"+Y+"Direction",Z="v_"+Y+"Position","point"!==j&&(C+="varying vec3 "+X+";\n",E+="varying vec3 "+X+";\n",B+="  "+X+" = mat3(u_"+Y+"Transform) * vec3(0.,0.,1.);\n","directional"===j&&(W+="    vec3 l = normalize("+X+");\n")),"directional"!==j?(C+="varying vec3 "+Z+";\n",E+="varying vec3 "+Z+";\n",B+="  "+Z+" = u_"+Y+"Transform[3].xyz;\n",W+="    vec3 VP = "+Z+" - v_positionEC;\n",W+="    vec3 l = normalize(VP);\n",W+="    float range = length(VP);\n",W+="    float attenuation = 1.0 / (u_"+Y+"Attenuation.x + ",W+="(u_"+Y+"Attenuation.y * range) + ",W+="(u_"+Y+"Attenuation.z * range * range));\n"):W+="    float attenuation = 1.0;\n","spot"===j&&(W+="    float spotDot = dot(l, normalize("+X+"));\n",W+="    if (spotDot < cos(u_"+Y+"FallOff.x * 0.5))\n",W+="    {\n",W+="      attenuation = 0.0;\n",W+="    }\n",W+="    else\n",W+="    {\n",W+="        attenuation *= max(0.0, pow(spotDot, u_"+Y+"FallOff.y));\n",W+="    }\n"),W+="    diffuseLight += "+K+"* max(dot(normal,l), 0.) * attenuation;\n",k&&("BLINN"===v?(W+="    vec3 h = normalize(l + viewDir);\n",W+="    float specularIntensity = max(0., pow(max(dot(normal, h), 0.), u_shininess)) * attenuation;\n"):(W+="    vec3 reflectDir = reflect(-l, normal);\n",W+="    float specularIntensity = max(0., pow(max(dot(reflectDir, viewDir), 0.), u_shininess)) * attenuation;\n"),W+="    specularLight += "+K+" * specularIntensity;\n")),W+="  }\n"}G||(W+="  ambientLight += vec3(0.2, 0.2, 0.2);\n"),U||"CONSTANT"===v||(W+="  vec3 l = normalize(czm_sunDirectionEC);\n",W+="  diffuseLight += vec3(1.0, 1.0, 1.0) * max(dot(normal,l), 0.);\n",k&&("BLINN"===v?(W+="  vec3 h = normalize(l + viewDir);\n",W+="  float specularIntensity = max(0., pow(max(dot(normal, h), 0.), u_shininess));\n"):(W+="  vec3 reflectDir = reflect(-l, normal);\n",W+="  float specularIntensity = max(0., pow(max(dot(reflectDir, viewDir), 0.), u_shininess));\n"),W+="  specularLight += vec3(1.0, 1.0, 1.0) * specularIntensity;\n")),C+="void main(void) {\n",C+=B,C+="}\n",E+="void main(void) {\n";var Q="  vec3 color = vec3(0.0, 0.0, 0.0);\n";b&&(E+="  vec3 normal = normalize(v_normal);\n",a.doubleSided&&(E+="  if (gl_FrontFacing == false)\n",E+="  {\n",E+="    normal = -normal;\n",E+="  }\n"));var J;"CONSTANT"!==v?(t(P.diffuse)&&(E+=P.diffuse.type===r.SAMPLER_2D?"  vec4 diffuse = texture2D(u_diffuse, "+z+");\n":"  vec4 diffuse = u_diffuse;\n",E+="  vec3 diffuseLight = vec3(0.0, 0.0, 0.0);\n",Q+="  color += diffuse.rgb * diffuseLight;\n"),k&&(E+=P.specular.type===r.SAMPLER_2D?"  vec3 specular = texture2D(u_specular, "+z+").rgb;\n":"  vec3 specular = u_specular.rgb;\n",E+="  vec3 specularLight = vec3(0.0, 0.0, 0.0);\n",Q+="  color += specular * specularLight;\n"),J=t(P.transparency)?"  gl_FragColor = vec4(color * diffuse.a, diffuse.a * u_transparency);\n":"  gl_FragColor = vec4(color * diffuse.a, diffuse.a);\n"):J=t(P.transparency)?"  gl_FragColor = vec4(color, u_transparency);\n":"  gl_FragColor = vec4(color, 1.0);\n",t(P.emission)&&(E+=P.emission.type===r.SAMPLER_2D?"  vec3 emission = texture2D(u_emission, "+z+").rgb;\n":"  vec3 emission = u_emission.rgb;\n",Q+="  color += emission;\n"),(t(P.ambient)||"CONSTANT"!==v)&&(E+=t(P.ambient)?P.ambient.type===r.SAMPLER_2D?"  vec3 ambient = texture2D(u_ambient, "+z+").rgb;\n":"  vec3 ambient = u_ambient.rgb;\n":"  vec3 ambient = diffuse.rgb;\n",Q+="  color += ambient * ambientLight;\n"),E+="  vec3 viewDir = -normalize(v_positionEC);\n",E+="  vec3 ambientLight = vec3(0.0, 0.0, 0.0);\n",E+=W,E+=Q,E+=J,E+="}\n";var $;$=a.transparent?{enable:[r.DEPTH_TEST,r.BLEND],depthMask:!1,functions:{blendEquationSeparate:[r.FUNC_ADD,r.FUNC_ADD],blendFuncSeparate:[r.ONE,r.ONE_MINUS_SRC_ALPHA,r.ONE,r.ONE_MINUS_SRC_ALPHA]}}:a.doubleSided?{enable:[r.DEPTH_TEST]}:{enable:[r.CULL_FACE,r.DEPTH_TEST]},p[S]={attributes:V,parameters:P,program:x,states:$,uniforms:O},m[w]={type:r.VERTEX_SHADER,uri:"",extras:{source:C}},m[T]={type:r.FRAGMENT_SHADER,uri:"",extras:{source:E}};var ee=Object.keys(V);return f[x]={attributes:ee,fragmentShader:T,vertexShader:w},S}function s(t){var r="";r+="technique:"+t.technique+";";for(var i=t.values,n=Object.keys(i).sort(),o=n.length,a=0;o>a;++a){var s=n[a];if(i.hasOwnProperty(s)){var l=i[s];r+=s+":"+l.type.toString(),r+=";"}}var u=e(t.doubleSided,!1);r+=u.toString()+";";var c=e(t.transparent,!1);r+=c.toString()+";";var h=e(t.jointCount,0);return r+=h.toString()+";"}function l(e){if(t(e)){var r=!1,i=e.extensionsUsed;if(t(i))for(var o=i.length,l=0;o>l;++l)if("KHR_materials_common"===i[l]){r=!0,i.splice(l,1);break}if(r){t(e.programs)||(e.programs={}),t(e.shaders)||(e.shaders={}),t(e.techniques)||(e.techniques={});var u=n(e),c={},h=e.materials;for(var d in h)if(h.hasOwnProperty(d)){var p=h[d];if(t(p.extensions)&&t(p.extensions.KHR_materials_common)){var m=p.extensions.KHR_materials_common,f=s(m),v=c[f];t(v)||(v=a(e,m,u),c[f]=v),p.values={};var _=m.values;for(var g in _)if(_.hasOwnProperty(g)){var y=_[g];p.values[g]=y.value}p.technique=v,delete p.extensions.KHR_materials_common}}t(e.extensions)&&delete e.extensions.KHR_materials_common}return e}}var u=0,c=0,h=0,d=0;return l}),r("Scene/ModelMesh",["../Core/defineProperties"],function(e){"use strict";function t(e,t,r){for(var i=[],n=e.primitives,o=n.length,a=0;o>a;++a){var s=n[a];i[a]=t[s.material]}this._name=e.name,this._materials=i,this._id=r}return e(t.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},materials:{get:function(){return this._materials}}}),t}),r("Scene/ModelNode",["../Core/defaultValue","../Core/defineProperties","../Core/Matrix4"],function(e,t,r){"use strict";function i(e,t,i,n,o){this._model=e,this._runtimeNode=i,this._name=t.name,this._id=n,this.useMatrix=!1,this._show=!0,this._matrix=r.clone(o)}return t(i.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,this._model._perNodeShowDirty=!0)}},matrix:{get:function(){return this._matrix},set:function(e){this._matrix=r.clone(e,this._matrix),this.useMatrix=!0;var t=this._model;t._cesiumAnimationsDirty=!0,this._runtimeNode.dirtyNumber=t._maxDirtyNumber}}}),i.prototype.setMatrix=function(e){r.clone(e,this._matrix)},i}),r("Scene/Model",["../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/clone","../Core/combine","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/deprecationWarning","../Core/destroyObject","../Core/DeveloperError","../Core/FeatureDetection","../Core/getBaseUri","../Core/getMagic","../Core/getStringFromTypedArray","../Core/IndexDatatype","../Core/loadArrayBuffer","../Core/loadImage","../Core/loadImageFromTypedArray","../Core/loadText","../Core/Math","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/PrimitiveType","../Core/Quaternion","../Core/Queue","../Core/RuntimeError","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/Sampler","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/Texture","../Renderer/TextureMinificationFilter","../Renderer/TextureWrap","../Renderer/VertexArray","../Renderer/WebGLConstants","../ThirdParty/gltfDefaults","../ThirdParty/Uri","../ThirdParty/when","./getModelAccessor","./ModelAnimationCache","./ModelAnimationCollection","./ModelMaterial","./modelMaterialsCommon","./ModelMesh","./ModelNode","./Pass","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I,M,D,R,O,N,L,F,B,V,z,k,U,G,W,H,q,j,Y,X,Z,K,Q,J,$){"use strict";function ee(){this.buffersToCreate=new A,this.buffers={},this.pendingBufferLoads=0,this.programsToCreate=new A,this.shaders={},this.pendingShaderLoads=0,this.texturesToCreate=new A,this.pendingTextureLoads=0,this.texturesToCreateFromBufferView=new A,this.pendingBufferViewToImage=0,this.createSamplers=!0,this.createSkins=!0,this.createRuntimeAnimations=!0,this.createVertexArrays=!0,this.createRenderStates=!0,this.createUniformMaps=!0,this.createRuntimeNodes=!0,this.skinnedNodesIds=[]}function te(e,t){e._cachedGltf=t,e._animationIds=ie(t)}function re(e){this._gltf=Z(G(e.gltf)),this._bgltf=e.bgltf,this.ready=e.ready,this.modelsToLoad=[],this.count=0}function ie(e){var t=[];if(l(e)&&l(e.gltf)){var r=e.gltf.animations;for(var i in r)r.hasOwnProperty(i)&&t.push(i)}return t}function ne(t){t=s(t,s.EMPTY_OBJECT);var r=t.cacheKey;this._cacheKey=r,this._cachedGltf=void 0,this._releaseGltfJson=s(t.releaseGltfJson,!1),this._animationIds=void 0;var i;if(l(r)&&l(xt[r])&&xt[r].ready)i=xt[r],++i.count;else{var n=t.gltf;if(l(n)){if(n instanceof ArrayBuffer&&(n=new Uint8Array(n)),n instanceof Uint8Array){var o=le(n);0!==o.binaryOffset&&(n=n.subarray(o.binaryOffset)),i=new re({gltf:o.glTF,bgltf:n,ready:!0})}else i=new re({gltf:t.gltf,ready:!0});i.count=1,l(r)&&(xt[r]=i)}}te(this,i),this._basePath=s(t.basePath,"");var a=new W(document.location.href),u=new W(this._basePath);this._baseUri=u.resolve(a),this.show=s(t.show,!0),this.modelMatrix=x.clone(s(t.modelMatrix,x.IDENTITY)),this._modelMatrix=x.clone(this.modelMatrix),this.scale=s(t.scale,1),this._scale=this.scale,this.minimumPixelSize=s(t.minimumPixelSize,0),this._minimumPixelSize=this.minimumPixelSize,this.maximumScale=t.maximumScale,this._maximumScale=this.maximumScale,this.id=t.id,this._id=t.id,this.pickPrimitive=t.pickPrimitive,this._allowPicking=s(t.allowPicking,!0),this._ready=!1,this._readyPromise=H.defer(),this.activeAnimations=new Y(this),this._defaultTexture=void 0,this._incrementallyLoadTextures=s(t.incrementallyLoadTextures,!0),this._asynchronous=s(t.asynchronous,!0),this.debugShowBoundingVolume=s(t.debugShowBoundingVolume,!1),this._debugShowBoundingVolume=!1,this.debugWireframe=s(t.debugWireframe,!1),this._debugWireframe=!1,this._precreatedAttributes=t.precreatedAttributes,this._vertexShaderLoaded=t.vertexShaderLoaded,this._fragmentShaderLoaded=t.fragmentShaderLoaded,this._uniformMapLoaded=t.uniformMapLoaded,this._pickVertexShaderLoaded=t.pickVertexShaderLoaded,this._pickFragmentShaderLoaded=t.pickFragmentShaderLoaded,this._pickUniformMapLoaded=t.pickUniformMapLoaded,this._ignoreCommands=s(t.ignoreCommands,!1),this.cull=s(t.cull,!0),this._computedModelMatrix=new x,this._initialRadius=void 0,this._boundingSphere=void 0,this._scaledBoundingSphere=new e,this._state=wt.NEEDS_LOAD,this._loadResources=void 0,this._perNodeShowDirty=!1,this._cesiumAnimationsDirty=!1,this._dirty=!1,this._maxDirtyNumber=0,this._runtime={animations:void 0,rootNodes:void 0,nodes:void 0,nodesByName:void 0,skinnedNodes:void 0,meshesByName:void 0,materialsByName:void 0,materialsById:void 0},this._uniformMaps={},this._rendererResources={buffers:{},vertexArrays:{},programs:{},pickPrograms:{},textures:{},samplers:{},renderStates:{}},this._cachedRendererResources=void 0,this._loadRendererResourcesFromCache=!1,this._nodeCommands=[],this._pickIds=[],this._rtcCenter=void 0,this._rtcCenterEye=void 0}function oe(e){var t=new W(document.location.href),r=new W(e);return r.resolve(t).toString()}function ae(e,t,r){return e.subarray(t,t+r)}function se(e){var t=f(e);return"glTF"===t}function le(e){if(!se(e))throw new d("bgltf is not a valid Binary glTF file.");var t=new DataView(e.buffer,e.byteOffset,e.byteLength),r=0;r+=bt,r+=bt,r+=bt;var i=t.getUint32(r,!0);r+=bt;var n=t.getUint32(r,!0);r+=bt;var o=r,a=o+i;0!==n&&(o=i,i=n,a=0);var s=v(e,o,i);return{glTF:JSON.parse(s),binaryOffset:a}}function ue(e,t,r){return e._runtime[t][r]}function ce(t){for(var i=t.nodes,n=t.meshes,o=t.accessors,a=t.scenes[t.scene].nodes,s=a.length,u=[],c=new r(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),h=new r(Number.MIN_VALUE,Number.MIN_VALUE,Number.MIN_VALUE),d=0;s>d;++d){var p=i[a[d]];for(p._transformToRoot=Ce(p),u.push(p);u.length>0;){p=u.pop();var m=p._transformToRoot,f=p.meshes;if(l(f))for(var v=f.length,_=0;v>_;++_)for(var g=n[f[_]].primitives,y=g.length,C=0;y>C;++C){var E=g[C].attributes.POSITION;if(l(E)){var S=o[E],w=r.fromArray(S.min,0,Pt),T=r.fromArray(S.max,0,At);l(c)&&l(h)&&(x.multiplyByPoint(m,w,w),x.multiplyByPoint(m,T,T),r.minimumByComponent(c,w,c),r.maximumByComponent(h,T,h))}}for(var b=p.children,P=b.length,A=0;P>A;++A){var I=i[b[A]];I._transformToRoot=Ce(I),x.multiplyTransformation(m,I._transformToRoot,I._transformToRoot),u.push(I)}delete p._transformToRoot}}var M=e.fromCornerPoints(c,h);return e.transformWithoutScale(M,Et,M)}function he(e,t,r){return function(){e._state=wt.FAILED,e._readyPromise.reject(new I("Failed to load "+t+": "+r))}}function de(e,t){return function(r){var i=e._loadResources;i.buffers[t]=new Uint8Array(r),--i.pendingBufferLoads}}function pe(e){var t=e.gltf.buffers;for(var r in t)if(t.hasOwnProperty(r)){var i=t[r];if("CESIUM_binary_glTF"===r||"KHR_binary_glTF"===r){var n=e._loadResources;n.buffers[r]=e._cachedGltf.bgltf}else if("arraybuffer"===i.type){++e._loadResources.pendingBufferLoads;var o=new W(i.uri),a=o.resolve(e._baseUri).toString();g(a).then(de(e,r)).otherwise(he(e,"buffer",a))}}}function me(e){var t=e.gltf.bufferViews;for(var r in t)t.hasOwnProperty(r)&&t[r].target===U.ARRAY_BUFFER&&e._loadResources.buffersToCreate.enqueue(r)}function fe(e,t){return function(r){var i=e._loadResources;i.shaders[t]={source:r,bufferView:void 0},--i.pendingShaderLoads}}function ve(e){var t=e.gltf.shaders;for(var r in t)if(t.hasOwnProperty(r)){var i=t[r];if(l(i.extras)&&l(i.extras.source))e._loadResources.shaders[r]={source:i.extras.source,bufferView:void 0};else if(l(i.extensions)&&(l(i.extensions.CESIUM_binary_glTF)||l(i.extensions.KHR_binary_glTF))){var n;n=l(i.extensions.CESIUM_binary_glTF)?i.extensions.CESIUM_binary_glTF:i.extensions.KHR_binary_glTF,e._loadResources.shaders[r]={source:void 0,bufferView:n.bufferView}}else{++e._loadResources.pendingShaderLoads;var o=new W(i.uri),a=o.resolve(e._baseUri).toString();E(a).then(fe(e,r)).otherwise(he(e,"shader",a))}}}function _e(e){var t=e.gltf.programs;for(var r in t)t.hasOwnProperty(r)&&e._loadResources.programsToCreate.enqueue(r)}function ge(e,t){return function(r){var i=e._loadResources;--i.pendingTextureLoads,i.texturesToCreate.enqueue({id:t,image:r,bufferView:void 0})}}function ye(e){var t=e.gltf.images,r=e.gltf.textures;for(var i in r)if(r.hasOwnProperty(i)){var n=t[r[i].source];if(l(n.extensions)&&(l(n.extensions.CESIUM_binary_glTF)||l(n.extensions.KHR_binary_glTF))){var o;o=l(n.extensions.CESIUM_binary_glTF)?n.extensions.CESIUM_binary_glTF:n.extensions.KHR_binary_glTF,e._loadResources.texturesToCreateFromBufferView.enqueue({id:i,image:void 0,bufferView:o.bufferView,mimeType:o.mimeType})}else{++e._loadResources.pendingTextureLoads;var a=new W(n.uri),s=a.resolve(e._baseUri).toString();y(s).then(ge(e,i)).otherwise(he(e,"image",s))}}}function Ce(e){return l(e.matrix)?x.fromArray(e.matrix):x.fromTranslationQuaternionRotationScale(r.fromArray(e.translation,0,It),P.unpack(e.rotation,0,Mt),r.fromArray(e.scale,0,Dt))}function Ee(e){var t={},r={},i=[],n=e._loadResources.skinnedNodesIds,o=e.gltf.nodes;for(var a in o)if(o.hasOwnProperty(a)){var s=o[a],u={matrix:void 0,translation:void 0,rotation:void 0,scale:void 0,computedShow:!0,transformToRoot:new x,computedMatrix:new x,dirtyNumber:0,commands:[],inverseBindMatrices:void 0,bindShapeMatrix:void 0,joints:[],computedJointMatrices:[],jointName:s.jointName,children:[],parents:[],publicNode:void 0};u.publicNode=new Q(e,s,u,a,Ce(s)),t[a]=u,r[s.name]=u,l(s.skin)&&(n.push(a),i.push(u))}e._runtime.nodes=t,e._runtime.nodesByName=r,e._runtime.skinnedNodes=i}function Se(e){var t={},r={},i=e.gltf.materials,n=e._uniformMaps;for(var o in i)if(i.hasOwnProperty(o)){n[o]={uniformMap:void 0,values:void 0,jointMatrixUniformName:void 0};var a=i[o],s=new X(e,a,o);t[a.name]=s,r[o]=s}e._runtime.materialsByName=t,e._runtime.materialsById=r}function we(e){var t={},r=e._runtime.materialsById,i=e.gltf.meshes;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];t[o.name]=new K(o,r,n)}e._runtime.meshesByName=t}function Te(e){e._loadRendererResourcesFromCache||(pe(e),me(e),ve(e),_e(e),ye(e)),Se(e),we(e),Ee(e)}function xe(e,t){var r=e._loadResources;if(0===r.pendingBufferLoads){for(var i,n=e.gltf.bufferViews,o=e._rendererResources.buffers;r.buffersToCreate.length>0;){var a=r.buffersToCreate.dequeue();i=n[a];var s=M.createVertexBuffer({context:t,typedArray:r.getBuffer(i),usage:D.STATIC_DRAW});s.vertexArrayDestroyable=!1,o[a]=s}var u=e.gltf.accessors;for(var c in u)if(u.hasOwnProperty(c)){var h=u[c];if(i=n[h.bufferView],i.target===U.ELEMENT_ARRAY_BUFFER&&!l(o[h.bufferView])){var d=M.createIndexBuffer({context:t,typedArray:r.getBuffer(i),usage:D.STATIC_DRAW,indexDatatype:h.componentType});d.vertexArrayDestroyable=!1,o[h.bufferView]=d}}}}function be(e){for(var t={},r=e.length,i=0;r>i;++i)t[e[i]]=i;return t}function Pe(e,t){if(l(t.source))return t.source;var r=e._loadResources,i=e.gltf,n=i.bufferViews[t.bufferView];return v(r.getBuffer(n))}function Ae(e,t,r){return l(r)&&(e=r(e,t)),e}function Ie(e,t,r){var i=t.gltf.programs,n=t._loadResources.shaders,o=i[e],a=be(o.attributes),s=Pe(t,n[o.vertexShader]),u=Pe(t,n[o.fragmentShader]),c=Ae(s,e,t._vertexShaderLoaded),h=Ae(u,e,t._fragmentShaderLoaded),d=o.attributes.length,p=t._precreatedAttributes;if(l(p))for(var m in p)p.hasOwnProperty(m)&&(a[m]=d++);if(t._rendererResources.programs[e]=L.fromCache({context:r,vertexShaderSource:c,fragmentShaderSource:h,attributeLocations:a}),t.allowPicking){var f=Ae(s,e,t._pickVertexShaderLoaded),v=Ae(u,e,t._pickFragmentShaderLoaded);t._pickFragmentShaderLoaded||(v=F.createPickFragmentShaderSource(u,"uniform")),t._rendererResources.pickPrograms[e]=L.fromCache({context:r,vertexShaderSource:f,fragmentShaderSource:v,attributeLocations:a})}}function Me(e,t){var r,i=e._loadResources;if(0===i.pendingShaderLoads&&0===i.pendingBufferLoads)if(e.asynchronous)i.programsToCreate.length>0&&(r=i.programsToCreate.dequeue(),Ie(r,e,t));else for(;i.programsToCreate.length>0;)r=i.programsToCreate.dequeue(),Ie(r,e,t)}function De(e,t){return function(r){e.texturesToCreate.enqueue({id:t.id,image:r,bufferView:void 0}),--e.pendingBufferViewToImage}}function Re(e){var t=e._loadResources;if(0===t.pendingBufferLoads)for(;t.texturesToCreateFromBufferView.length>0;){var r=t.texturesToCreateFromBufferView.dequeue(),i=e.gltf,n=i.bufferViews[r.bufferView],o=De(t,r),a=he(e,"image","id: "+r.id+", bufferView: "+r.bufferView);C(t.getBuffer(n),r.mimeType).then(o).otherwise(a),++t.pendingBufferViewToImage}}function Oe(e,t){var r=e._loadResources;if(r.createSamplers){r.createSamplers=!1;var i=e._rendererResources.samplers,n=e.gltf.samplers;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];i[o]=new N({wrapS:a.wrapS,wrapT:a.wrapT,minificationFilter:a.minFilter,magnificationFilter:a.magFilter})}}}function Ne(e,t,r){var i=t.gltf.textures,n=i[e.id],o=t._rendererResources.samplers,a=o[n.sampler],s=a.minificationFilter===V.NEAREST_MIPMAP_NEAREST||a.minificationFilter===V.NEAREST_MIPMAP_LINEAR||a.minificationFilter===V.LINEAR_MIPMAP_NEAREST||a.minificationFilter===V.LINEAR_MIPMAP_LINEAR,l=s||a.wrapS===z.REPEAT||a.wrapS===z.MIRRORED_REPEAT||a.wrapT===z.REPEAT||a.wrapT===z.MIRRORED_REPEAT,u=e.image,c=!S.isPowerOfTwo(u.width)||!S.isPowerOfTwo(u.height);if(l&&c){var h=document.createElement("canvas");h.width=S.nextPowerOfTwo(u.width),h.height=S.nextPowerOfTwo(u.height);var d=h.getContext("2d");d.drawImage(u,0,0,u.width,u.height,0,0,h.width,h.height),u=h}var p;n.target===U.TEXTURE_2D&&(p=new B({context:r,source:u,pixelFormat:n.internalFormat,pixelDatatype:n.type,sampler:a,flipY:!1})),s&&p.generateMipmap(),t._rendererResources.textures[e.id]=p}function Le(e,t){var r,i=e._loadResources;if(e.asynchronous)i.texturesToCreate.length>0&&(r=i.texturesToCreate.dequeue(),Ne(r,e,t));else for(;i.texturesToCreate.length>0;)r=i.texturesToCreate.dequeue(),Ne(r,e,t)}function Fe(e,t){var r=e.gltf,i=r.techniques,n=r.materials,o={},a=i[n[t.material].technique],s=a.parameters,u=a.attributes,c=e._rendererResources.programs[a.program].vertexAttributes;for(var h in c)if(c.hasOwnProperty(h)){var d=u[h],p=c[h].index;if(l(d)){var m=s[d];o[m.semantic]=p}else o[h]=p}return o}function Be(e,t,r){for(var i=e.length,n=0;i>n;++n)for(var o=[e[n]];o.length>0;){var a=o.pop(),s=r[a];if(s.jointName===t)return a;for(var l=s.children,u=l.length,c=0;u>c;++c)o.push(l[c])}}function Ve(e,t){for(var r=e.gltf,i=r.skins,n=r.nodes,o=e._runtime.nodes,a=e._loadResources.skinnedNodesIds,s=a.length,l=0;s>l;++l){var u=a[l],c=o[u],h=n[u],d=t[h.skin];c.inverseBindMatrices=d.inverseBindMatrices,c.bindShapeMatrix=d.bindShapeMatrix;for(var p=[],m=h.skeletons,f=m.length,v=0;f>v;++v)p.push(m[v]);for(var _=i[h.skin].jointNames,g=_.length,y=0;g>y;++y){var C=_[y],E=o[Be(p,C,n)];c.joints.push(E)}}}function ze(e){var t=e._loadResources;if(0===t.pendingBufferLoads&&t.createSkins){t.createSkins=!1;var r=e.gltf,i=r.accessors,n=r.skins,o={};for(var a in n)if(n.hasOwnProperty(a)){var s,l=n[a],u=i[l.inverseBindMatrices];x.equals(l.bindShapeMatrix,x.IDENTITY)||(s=x.clone(l.bindShapeMatrix)),o[a]={inverseBindMatrices:j.getSkinInverseBindMatrices(e,u),bindShapeMatrix:s}}Ve(e,o)}}function ke(e,t,r,i){return function(n){t[r]=i.evaluate(n,t[r]),t.dirtyNumber=e._maxDirtyNumber}}function Ue(e){var t=e._loadResources;if(t.finishedPendingBufferLoads()&&t.createRuntimeAnimations){t.createRuntimeAnimations=!1,e._runtime.animations={};var r=e._runtime.nodes,i=e.gltf.animations,n=e.gltf.accessors;for(var o in i)if(i.hasOwnProperty(o)){var a=i[o],s=a.channels,l=a.parameters,u=a.samplers,c={};for(var h in l)l.hasOwnProperty(h)&&(c[h]=j.getAnimationParameterValues(e,n[l[h]]));for(var d=Number.MAX_VALUE,p=-Number.MAX_VALUE,m=s.length,f=new Array(m),v=0;m>v;++v){var _=s[v],g=_.target,y=u[_.sampler],C=c[y.input];d=Math.min(d,C[0]),p=Math.max(p,C[C.length-1]);var E=j.getAnimationSpline(e,o,a,_.sampler,y,c);f[v]=ke(e,r[g.id],g.path,E)}e._runtime.animations[o]={startTime:d,stopTime:p,channelEvaluators:f}}}}function Ge(e,t){var r=e._loadResources;if(r.finishedBuffersCreation()&&r.finishedProgramCreation()&&r.createVertexArrays){r.createVertexArrays=!1;var i=e._rendererResources.buffers,n=e._rendererResources.vertexArrays,o=e.gltf,a=o.accessors,s=o.meshes;for(var u in s)if(s.hasOwnProperty(u))for(var c=s[u].primitives,h=c.length,d=0;h>d;++d){var p,m,f,v=c[d],_=Fe(e,v),g=[],y=v.attributes;for(p in y)if(y.hasOwnProperty(p)&&(m=_[p],l(m))){var C=a[y[p]];g.push({index:m,vertexBuffer:i[C.bufferView],componentsPerAttribute:q(C).componentsPerAttribute,componentDatatype:C.componentType,normalize:!1,offsetInBytes:C.byteOffset,strideInBytes:C.byteStride})}var E=e._precreatedAttributes;if(l(E))for(p in E)E.hasOwnProperty(p)&&(m=_[p],l(m)&&(f=E[p],f.index=m,g.push(f)));var S;if(l(v.indices)){var w=a[v.indices];S=i[w.bufferView]}n[u+".primitive."+d]=new k({context:t,attributes:g,indexBuffer:S})}}}function We(e){var t={};t[U.BLEND]=!1,t[U.CULL_FACE]=!1,t[U.DEPTH_TEST]=!1,t[U.POLYGON_OFFSET_FILL]=!1,t[U.SCISSOR_TEST]=!1;var r,i=e.enable,n=i.length;for(r=0;n>r;++r)t[i[r]]=!0;return t}function He(e,t){var r=e._loadResources;if(r.createRenderStates){r.createRenderStates=!1;var i=e._rendererResources.renderStates,n=e.gltf.techniques;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o],u=a.states,c=We(u),h=s(u.functions,s.EMPTY_OBJECT),d=s(h.blendColor,[0,0,0,0]),p=s(h.blendEquationSeparate,[U.FUNC_ADD,U.FUNC_ADD]),m=s(h.blendFuncSeparate,[U.ONE,U.ONE,U.ZERO,U.ZERO]),f=s(h.colorMask,[!0,!0,!0,!0]),v=s(h.depthRange,[0,1]),_=s(h.polygonOffset,[0,0]),g=s(h.scissor,[0,0,0,0]);i[o]=O.fromCache({frontFace:l(h.frontFace)?h.frontFace[0]:U.CCW,cull:{enabled:c[U.CULL_FACE],face:l(h.cullFace)?h.cullFace[0]:U.BACK},lineWidth:l(h.lineWidth)?h.lineWidth[0]:1,polygonOffset:{enabled:c[U.POLYGON_OFFSET_FILL],factor:_[0],units:_[1]},scissorTest:{enabled:c[U.SCISSOR_TEST],rectangle:{x:g[0],y:g[1],width:g[2],height:g[3]}},depthRange:{near:v[0],far:v[1]},depthTest:{enabled:c[U.DEPTH_TEST],func:l(h.depthFunc)?h.depthFunc[0]:U.LESS},colorMask:{red:f[0],green:f[1],blue:f[2],alpha:f[3]},depthMask:l(h.depthMask)?h.depthMask[0]:!0,blending:{enabled:c[U.BLEND],color:{red:d[0],green:d[1],blue:d[2],alpha:d[3]},equationRgb:p[0],equationAlpha:p[1],functionSourceRgb:m[0],functionSourceAlpha:m[1],functionDestinationRgb:m[2],functionDestinationAlpha:m[3]}})}}}function qe(e,t){var r={value:e,clone:function(e,t){return e},func:function(){return r.value}};return r}function je(e,r){var i={value:t.fromArray(e),clone:t.clone,func:function(){return i.value}};return i}function Ye(e,t){var i={value:r.fromArray(e),clone:r.clone,func:function(){return i.value}};return i}function Xe(e,t){var r={value:i.fromArray(e),clone:i.clone,func:function(){return r.value}};return r}function Ze(e,t){var r={value:w.fromColumnMajorArray(e),clone:w.clone,func:function(){return r.value}};return r}function Ke(e,t){var r={value:T.fromColumnMajorArray(e),clone:T.clone,func:function(){return r.value}};return r}function Qe(e,t){var r={value:x.fromColumnMajorArray(e),clone:x.clone,func:function(){return r.value}};return r}function Je(e,t){this._value=void 0,this._textureId=e,this._model=t}function $e(e,t){var r=new Je(e,t);return r.func=function(){return r.value},r}function et(e,t,r,i){var n=t._runtime.nodes[e];return Lt[r](i,t,n)}function tt(e,t){var r=e._loadResources;if(r.finishedProgramCreation()&&r.createUniformMaps){r.createUniformMaps=!1;var i=e.gltf,n=i.materials,o=i.techniques,a=e._uniformMaps;for(var s in n)if(n.hasOwnProperty(s)){var u,c=n[s],h=c.values,d=o[c.technique],p=d.parameters,m=d.uniforms,f={},v={};for(var _ in m)if(m.hasOwnProperty(_)){var g=m[_],y=p[g];if(l(h[g])){var C=Nt[y.type](h[g],e);f[_]=C.func,v[g]=C}else if(l(y.node))f[_]=et(y.node,e,y.semantic,t.uniformState);else if(l(y.semantic))"JOINTMATRIX"!==y.semantic?f[_]=Ot[y.semantic](t.uniformState,e):u=_;else if(l(y.value)){var E=Nt[y.type](y.value,e);f[_]=E.func,v[g]=E}}var S=a[s];S.uniformMap=f,S.values=v,S.jointMatrixUniformName=u}}}function rt(e){return function(){return e}}function it(e){return function(){return e.computedJointMatrices}}function nt(t,i,n,u){for(var c=t._nodeCommands,h=t._pickIds,d=t.allowPicking,p=t._runtime.meshesByName,m=t._rendererResources,f=m.vertexArrays,v=m.programs,g=m.pickPrograms,y=m.renderStates,C=t._uniformMaps,E=t.gltf,S=E.accessors,w=E.meshes,T=E.techniques,b=E.materials,P=i.meshes,A=P.length,I=0;A>I;++I)for(var M=P[I],D=w[M],O=D.primitives,N=O.length,L=0;N>L;++L){var F,B=O[L],V=S[B.indices],z=b[B.material],k=T[z.technique],U=k.program,G=B.attributes.POSITION;if(l(G)){var W=S[G];F=e.fromCornerPoints(r.fromArray(W.min),r.fromArray(W.max))}var H,j,Y=f[M+".primitive."+L];if(l(V))j=V.count,H=V.byteOffset/_.getSizeInBytes(V.componentType);else{var X=S[B.attributes.POSITION];j=X.count;var Z=q(X);H=X.byteOffset/(Z.componentsPerAttribute*a.getSizeInBytes(X.componentType))}var K=C[B.material],Q=K.uniformMap;if(l(K.jointMatrixUniformName)){var $={};$[K.jointMatrixUniformName]=it(n),Q=o(Q,$)}l(t._uniformMapLoaded)&&(Q=t._uniformMapLoaded(Q,U,n));var ee,te=y[z.technique],re=te.blending.enabled,ie={primitive:s(t.pickPrimitive,t),id:t.id,node:n.publicNode,mesh:p[D.name]},ne=new R({boundingVolume:new e,cull:t.cull,modelMatrix:new x,primitiveType:B.mode,vertexArray:Y,count:j,offset:H,shaderProgram:v[k.program],uniformMap:Q,renderState:te,owner:ie,pass:re?J.TRANSLUCENT:J.OPAQUE});if(d){var oe;if(l(t._pickFragmentShaderLoaded))oe=l(t._pickUniformMapLoaded)?t._pickUniformMapLoaded(Q):o(Q);else{var ae=u.createPickId(ie);h.push(ae);var se={czm_pickColor:rt(ae.color)};oe=o(Q,se)}ee=new R({boundingVolume:new e,cull:t.cull,modelMatrix:new x,primitiveType:B.mode,vertexArray:Y,count:j,offset:H,shaderProgram:g[k.program],uniformMap:oe,renderState:te,owner:ie,pass:re?J.TRANSLUCENT:J.OPAQUE})}var le={show:!0,boundingSphere:F,command:ne,pickCommand:ee};n.commands.push(le),c.push(le)}}function ot(e,t){var i=e._loadResources;if(i.finishedEverythingButTextureCreation()&&i.createRuntimeNodes){i.createRuntimeNodes=!1;for(var n=[],o=e._runtime.nodes,a=e.gltf,s=a.nodes,u=a.scenes[a.scene],c=u.nodes,h=c.length,d=[],p=0;h>p;++p)for(d.push({parentRuntimeNode:void 0,gltfNode:s[c[p]],id:c[p]});d.length>0;){var m=d.pop(),f=m.parentRuntimeNode,v=m.gltfNode,_=o[m.id];if(0===_.parents.length)if(l(v.matrix))_.matrix=x.fromColumnMajorArray(v.matrix);else{var g=v.rotation;_.translation=r.fromArray(v.translation),_.rotation=P.unpack(g),_.scale=r.fromArray(v.scale)}l(f)?(f.children.push(_),_.parents.push(f)):n.push(_),l(v.meshes)&&nt(e,v,_,t);for(var y=v.children,C=y.length,E=0;C>E;++E)d.push({parentRuntimeNode:_,gltfNode:s[y[E]],id:y[E]})}e._runtime.rootNodes=n,e._runtime.nodes=o}}function at(e,t){var r=t.context;if(e._loadRendererResourcesFromCache){var i=e._rendererResources,n=e._cachedRendererResources;i.buffers=n.buffers,i.vertexArrays=n.vertexArrays,i.programs=n.programs,i.pickPrograms=n.pickPrograms,i.textures=n.textures,i.samplers=n.samplers,i.renderStates=n.renderStates,l(e._precreatedAttributes)&&Ge(e,r)}else xe(e,r),Me(e,r),Oe(e,r),Re(e),Le(e,r);ze(e),Ue(e),e._loadRendererResourcesFromCache||(Ge(e,r),He(e,r)),tt(e,r),ot(e,r)}function st(e,t){var r=e.publicNode,i=r.matrix;r.useMatrix&&l(i)?x.clone(i,t):l(e.matrix)?x.clone(e.matrix,t):(x.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t),r.setMatrix(t))}function lt(t,i,n){for(var o=t._maxDirtyNumber,a=t.allowPicking,s=t._runtime.rootNodes,u=s.length,c=Ft,h=t._computedModelMatrix,d=0;u>d;++d){var p=s[d];for(st(p,p.transformToRoot),c.push(p);c.length>0;){p=c.pop();var m=p.transformToRoot,f=p.commands;if(p.dirtyNumber===o||i||n){var v=x.multiplyTransformation(h,m,p.computedMatrix),_=f.length;if(_>0)for(var g=0;_>g;++g){var y=f[g],C=y.command;if(x.clone(v,C.modelMatrix),e.transform(y.boundingSphere,C.modelMatrix,C.boundingVolume),l(t._rtcCenter)&&r.add(t._rtcCenter,C.boundingVolume.center,C.boundingVolume.center),a){var E=y.pickCommand;x.clone(C.modelMatrix,E.modelMatrix),e.clone(C.boundingVolume,E.boundingVolume)}}}for(var S=p.children,w=S.length,T=0;w>T;++T){var b=S[T];b.dirtyNumber=Math.max(b.dirtyNumber,p.dirtyNumber),(b.dirtyNumber===o||n)&&(st(b,b.transformToRoot),x.multiplyTransformation(m,b.transformToRoot,b.transformToRoot)),c.push(b)}}}++t._maxDirtyNumber}function ut(e){for(var t=e._runtime.skinnedNodes,r=t.length,i=0;r>i;++i){var n=t[i];Bt=x.inverseTransformation(n.transformToRoot,Bt);for(var o=n.computedJointMatrices,a=n.joints,s=n.bindShapeMatrix,u=n.inverseBindMatrices,c=u.length,h=0;c>h;++h)l(o[h])||(o[h]=new x),o[h]=x.multiplyTransformation(Bt,a[h].transformToRoot,o[h]),o[h]=x.multiplyTransformation(o[h],u[h],o[h]),l(s)&&(o[h]=x.multiplyTransformation(o[h],s,o[h]))}}function ct(e){for(var t=e._runtime.rootNodes,r=t.length,i=Ft,n=0;r>n;++n){var o=t[n];for(o.computedShow=o.publicNode.show,i.push(o);i.length>0;){o=i.pop();for(var a=o.computedShow,s=o.commands,l=s.length,u=0;l>u;++u)s[u].show=a;for(var c=o.children,h=c.length,d=0;h>d;++d){var p=c[d];p.computedShow=a&&p.publicNode.show,i.push(p)}}}}function ht(e,t){var r=e.id;if(e._id!==r){e._id=r;for(var i=e._pickIds,n=i.length,o=0;n>o;++o)i[o].object.id=r}}function dt(e){if(e._debugWireframe!==e.debugWireframe){e._debugWireframe=e.debugWireframe;for(var t=e.debugWireframe?b.LINES:b.TRIANGLES,r=e._nodeCommands,i=r.length,n=0;i>n;++n)r[n].command.primitiveType=t}}function pt(e){if(e.debugShowBoundingVolume!==e._debugShowBoundingVolume){
e._debugShowBoundingVolume=e.debugShowBoundingVolume;for(var t=e.debugShowBoundingVolume,r=e._nodeCommands,i=r.length,n=0;i>n;n++)r[n].command.debugShowBoundingVolume=t}}function mt(e,t,r){return Vt.center=e,Vt.radius=t,r.camera.getPixelSize(Vt,r.context.drawingBufferWidth,r.context.drawingBufferHeight)}function ft(e,t){var i=e.scale;if(0!==e.minimumPixelSize){var n=t.context,o=Math.max(n.drawingBufferWidth,n.drawingBufferHeight),a=e.modelMatrix;zt.x=a[12],zt.y=a[13],zt.z=a[14],l(e._rtcCenter)&&r.add(e._rtcCenter,zt,zt);var s=e.boundingSphere.radius,u=mt(zt,s,t),c=1/u,h=Math.min(c*(2*s),o);h<e.minimumPixelSize&&(i=e.minimumPixelSize*u/(2*e._initialRadius))}return l(e.maximumScale)?Math.min(e.maximumScale,i):i}function vt(e){l(e._cacheKey)&&l(e._cachedGltf)&&0===--e._cachedGltf.count&&delete xt[e._cacheKey],e._cachedGltf=void 0}function _t(e){var t=e.gltf.extensionsUsed;if(l(t))for(var r=t.length,i=0;r>i;++i){var n=t[i];if("CESIUM_RTC"!==n&&"CESIUM_binary_glTF"!==n&&"KHR_binary_glTF"!==n&&"KHR_materials_common"!==n)throw new I("Unsupported glTF Extension: "+n);"CESIUM_binary_glTF"===n&&c("CESIUM_binary_glTF extension","Use of the CESIUM_binary_glTF extension has been deprecated. Use the KHR_binary_glTF extension instead.")}}function gt(e,t){this.buffers=void 0,this.vertexArrays=void 0,this.programs=void 0,this.pickPrograms=void 0,this.textures=void 0,this.samplers=void 0,this.renderStates=void 0,this.ready=!1,this.context=e,this.cacheKey=t,this.count=0}function yt(e){for(var t in e)e.hasOwnProperty(t)&&e[t].destroy()}function Ct(e){yt(e.buffers),yt(e.vertexArrays),yt(e.programs),yt(e.pickPrograms),yt(e.textures)}if(!p.supportsTypedArrays())return{};var Et=x.fromRotationTranslation(T.fromRotationX(S.PI_OVER_TWO)),St=new r,wt={NEEDS_LOAD:0,LOADING:1,LOADED:2,FAILED:3},Tt="model/vnd.gltf.binary,model/vnd.gltf+json,model/gltf.binary,model/gltf+json;q=0.8,application/json;q=0.2,*/*;q=0.01";ee.prototype.getBuffer=function(e){return ae(this.buffers[e.buffer],e.byteOffset,e.byteLength)},ee.prototype.finishedPendingBufferLoads=function(){return 0===this.pendingBufferLoads},ee.prototype.finishedBuffersCreation=function(){return 0===this.pendingBufferLoads&&0===this.buffersToCreate.length},ee.prototype.finishedProgramCreation=function(){return 0===this.pendingShaderLoads&&0===this.programsToCreate.length},ee.prototype.finishedTextureCreation=function(){var e=0===this.pendingTextureLoads,t=0===this.texturesToCreate.length&&0===this.texturesToCreateFromBufferView.length;return e&&t},ee.prototype.finishedEverythingButTextureCreation=function(){var e=0===this.pendingBufferLoads&&0===this.pendingShaderLoads,t=0===this.buffersToCreate.length&&0===this.programsToCreate.length&&0===this.pendingBufferViewToImage;return e&&t},ee.prototype.finished=function(){return this.finishedTextureCreation()&&this.finishedEverythingButTextureCreation()},u(re.prototype,{gltf:{set:function(e){this._gltf=Z(G(e))},get:function(){return this._gltf}},bgltf:{get:function(){return this._bgltf}}}),re.prototype.makeReady=function(e,t){this.gltf=e,this._bgltf=t;for(var r=this.modelsToLoad,i=r.length,n=0;i>n;++n){var o=r[n];o.isDestroyed()||te(o,this)}this.modelsToLoad=void 0,this.ready=!0};var xt={};u(ne.prototype,{gltf:{get:function(){return l(this._cachedGltf)?this._cachedGltf.gltf:void 0}},releaseGltfJson:{get:function(){return this._releaseGltfJson}},cacheKey:{get:function(){return this._cacheKey}},basePath:{get:function(){return this._basePath}},boundingSphere:{get:function(){var e=x.getScale(this.modelMatrix,St),t=l(this.maximumScale)?Math.min(this.maximumScale,this.scale):this.scale;r.multiplyByScalar(e,t,e);var i=this._scaledBoundingSphere;return i.center=r.multiplyComponents(this._boundingSphere.center,e,i.center),i.radius=r.maximumComponent(e)*this._initialRadius,l(this._rtcCenter)&&r.add(this._rtcCenter,i.center,i.center),i}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},asynchronous:{get:function(){return this._asynchronous}},allowPicking:{get:function(){return this._allowPicking}},incrementallyLoadTextures:{get:function(){return this._incrementallyLoadTextures}},pendingTextureLoads:{get:function(){return l(this._loadResources)?this._loadResources.pendingTextureLoads:0}},dirty:{get:function(){return this._dirty}}});var bt=Uint32Array.BYTES_PER_ELEMENT;ne.fromGltf=function(e){var t=e.url,r=s(e.cacheKey,oe(t));e=n(e),e.basePath=m(t),e.cacheKey=r;var i=new ne(e);e.headers=l(e.headers)?n(e.headers):{},l(e.headers.Accept)||(e.headers.Accept=Tt);var o=xt[r];return l(o)?o.ready||(++o.count,o.modelsToLoad.push(i)):(o=new re({ready:!1}),o.count=1,o.modelsToLoad.push(i),te(i,o),xt[r]=o,g(t,e.headers).then(function(e){var t=new Uint8Array(e);if(se(t)){var r=le(t);0!==r.binaryOffset&&(t=t.subarray(r.binaryOffset)),o.makeReady(r.glTF,t)}else{var i=v(t);o.makeReady(JSON.parse(i))}}).otherwise(he(i,"model",t))),i},ne._gltfCache=xt,ne.prototype.getNode=function(e){var t=ue(this,"nodesByName",e);return l(t)?t.publicNode:void 0},ne.prototype.getMesh=function(e){return ue(this,"meshesByName",e)},ne.prototype.getMaterial=function(e){return ue(this,"materialsByName",e)};var Pt=new r,At=new r,It=new r,Mt=new P,Dt=new r,Rt=new r,Ot={MODEL:function(e,t){return function(){return e.model}},VIEW:function(e,t){return function(){return e.view}},PROJECTION:function(e,t){return function(){return e.projection}},MODELVIEW:function(e,t){return function(){return e.modelView}},CESIUM_RTC_MODELVIEW:function(e,t){var i=new x;return function(){return x.getTranslation(e.model,Rt),r.add(Rt,t._rtcCenter,Rt),x.multiplyByPoint(e.view,Rt,Rt),x.setTranslation(e.modelView,Rt,i)}},MODELVIEWPROJECTION:function(e,t){return function(){return e.modelViewProjection}},MODELINVERSE:function(e,t){return function(){return e.inverseModel}},VIEWINVERSE:function(e,t){return function(){return e.inverseView}},PROJECTIONINVERSE:function(e,t){return function(){return e.inverseProjection}},MODELVIEWINVERSE:function(e,t){return function(){return e.inverseModelView}},MODELVIEWPROJECTIONINVERSE:function(e,t){return function(){return e.inverseModelViewProjection}},MODELINVERSETRANSPOSE:function(e,t){return function(){return e.inverseTranposeModel}},MODELVIEWINVERSETRANSPOSE:function(e,t){return function(){return e.normal}},VIEWPORT:function(e,t){return function(){return e.viewportCartesian4}}};u(Je.prototype,{value:{get:function(){if(!l(this._value)){var e=this._model._rendererResources.textures[this._textureId];if(!l(e))return this._model._defaultTexture;this._value=e}return this._value},set:function(e){this._value=e}}}),Je.prototype.clone=function(e,t){return e},Je.prototype.func=void 0;var Nt={};Nt[U.FLOAT]=qe,Nt[U.FLOAT_VEC2]=je,Nt[U.FLOAT_VEC3]=Ye,Nt[U.FLOAT_VEC4]=Xe,Nt[U.INT]=qe,Nt[U.INT_VEC2]=je,Nt[U.INT_VEC3]=Ye,Nt[U.INT_VEC4]=Xe,Nt[U.BOOL]=qe,Nt[U.BOOL_VEC2]=je,Nt[U.BOOL_VEC3]=Ye,Nt[U.BOOL_VEC4]=Xe,Nt[U.FLOAT_MAT2]=Ze,Nt[U.FLOAT_MAT3]=Ke,Nt[U.FLOAT_MAT4]=Qe,Nt[U.SAMPLER_2D]=$e;var Lt={MODEL:function(e,t,r){return function(){return r.computedMatrix}},VIEW:function(e,t,r){return function(){return e.view}},PROJECTION:function(e,t,r){return function(){return e.projection}},MODELVIEW:function(e,t,r){var i=new x;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i)}},CESIUM_RTC_MODELVIEW:function(e,t,r){var i=new x;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i),x.setTranslation(i,t._rtcCenterEye,i)}},MODELVIEWPROJECTION:function(e,t,r){var i=new x;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i),x.multiply(e._projection,i,i)}},MODELINVERSE:function(e,t,r){var i=new x;return function(){return x.inverse(r.computedMatrix,i)}},VIEWINVERSE:function(e,t){return function(){return e.inverseView}},PROJECTIONINVERSE:function(e,t,r){return function(){return e.inverseProjection}},MODELVIEWINVERSE:function(e,t,r){var i=new x,n=new x;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i),x.inverse(i,n)}},MODELVIEWPROJECTIONINVERSE:function(e,t,r){var i=new x,n=new x;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i),x.multiply(e._projection,i,i),x.inverse(i,n)}},MODELINVERSETRANSPOSE:function(e,t,r){var i=new x,n=new T;return function(){return x.inverse(r.computedMatrix,i),x.getRotation(i,n),T.transpose(n,n)}},MODELVIEWINVERSETRANSPOSE:function(e,t,r){var i=new x,n=new x,o=new T;return function(){return x.multiplyTransformation(e.view,r.computedMatrix,i),x.inverse(i,n),x.getRotation(n,o),T.transpose(o,o)}},VIEWPORT:function(e,t,r){return function(){return e.viewportCartesian4}}},Ft=[],Bt=new x,Vt=new e,zt=new r;return gt.prototype.release=function(){return 0===--this.count?(l(this.cacheKey)&&delete this.context.cache.modelRendererResourceCache[this.cacheKey],Ct(this),h(this)):void 0},ne.prototype.update=function(e){if(e.mode===$.SCENE3D){var t=e.context;if(this._defaultTexture=t.defaultTexture,this._state===wt.NEEDS_LOAD&&l(this.gltf)){var i,n=this.cacheKey;if(l(n)){t.cache.modelRendererResourceCache=s(t.cache.modelRendererResourceCache,{});var o=t.cache.modelRendererResourceCache;if(i=o[this.cacheKey],l(i)){if(!i.ready)return;++i.count,this._loadRendererResourcesFromCache=!0}else i=new gt(t,n),i.count=1,o[this.cacheKey]=i;this._cachedRendererResources=i}else i=new gt(t),i.count=1,this._cachedRendererResources=i;if(this._state=wt.LOADING,this._boundingSphere=ce(this.gltf),this._initialRadius=this._boundingSphere.radius,_t(this),this._state!==wt.FAILED){var a=this.gltf.extensions;l(a)&&l(a.CESIUM_RTC)&&(this._rtcCenter=r.fromArray(a.CESIUM_RTC.center),this._rtcCenterEye=new r),this._loadResources=new ee,Te(this)}}var u=this._loadResources,c=this._incrementallyLoadTextures,h=!1;if(this._state===wt.LOADING&&(at(this,e),(u.finished()||c&&u.finishedEverythingButTextureCreation())&&(this._state=wt.LOADED,h=!0)),l(u)&&this._state===wt.LOADED&&(c&&!h&&at(this,e),u.finished())){this._loadResources=void 0;var d=this._rendererResources,p=this._cachedRendererResources;p.buffers=d.buffers,p.vertexArrays=d.vertexArrays,p.programs=d.programs,p.pickPrograms=d.pickPrograms,p.textures=d.textures,p.samplers=d.samplers,p.renderStates=d.renderStates,p.ready=!0,l(this._precreatedAttributes)&&(p.vertexArrays={}),this.releaseGltfJson&&vt(this)}var m=this.show&&0!==this.scale;if(m&&this._state===wt.LOADED||h){var f=this.activeAnimations.update(e)||this._cesiumAnimationsDirty;this._cesiumAnimationsDirty=!1,this._dirty=!1;var v=!x.equals(this._modelMatrix,this.modelMatrix)||this._scale!==this.scale||this._minimumPixelSize!==this.minimumPixelSize||0!==this.minimumPixelSize||this._maximumScale!==this.maximumScale;if(v||h){x.clone(this.modelMatrix,this._modelMatrix),this._scale=this.scale,this._minimumPixelSize=this.minimumPixelSize,this._maximumScale=this.maximumScale;var _=ft(this,e),g=this._computedModelMatrix;x.multiplyByUniformScale(this.modelMatrix,_,g),x.multiplyTransformation(g,Et,g)}(f||v||h)&&(lt(this,v,h),this._dirty=!0,(f||h)&&ut(this)),this._perNodeShowDirty&&(this._perNodeShowDirty=!1,ct(this)),ht(this,t),dt(this),pt(this)}if(h){var y=this;return void e.afterRender.push(function(){y._ready=!0,y._readyPromise.resolve(y)})}if(m&&!this._ignoreCommands){var C,E,S=e.commandList,w=e.passes,T=this._nodeCommands,b=T.length;if(w.render)for(C=0;b>C;++C)E=T[C],E.show&&S.push(E.command);if(w.pick&&this.allowPicking)for(C=0;b>C;++C)E=T[C],E.show&&S.push(E.pickCommand)}}},ne.prototype.isDestroyed=function(){return!1},ne.prototype.destroy=function(){l(this._precreatedAttributes)&&yt(this._rendererResources.vertexArrays),this._rendererResources=void 0,this._cachedRendererResources=this._cachedRendererResources&&this._cachedRendererResources.release();for(var e=this._pickIds,t=e.length,r=0;t>r;++r)e[r].destroy();return vt(this),h(this)},ne}),r("DataSources/ModelVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Scene/Model","../Scene/ModelAnimationLoop","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(t,r){r.collectionChanged.addEventListener(c.prototype._onCollectionChanged,this),this._scene=t,this._primitives=t.primitives,this._entityCollection=r,this._modelHash={},this._entitiesToVisualize=new e,this._onCollectionChanged(r,r.values,[],[])}function h(e,t,i,n){var o=i[t.id];r(o)&&(n.removeAndDestroy(o.modelPrimitive),delete i[t.id])}function d(e,t){var i=t[e.id];r(i)&&(i.nodeTransformationsScratch={})}function p(e){console.error(e)}var m=1,f=0,v=!0,_=new o,g=new o;return c.prototype.update=function(e){for(var t=this._entitiesToVisualize.values,i=this._modelHash,n=this._primitives,l=0,c=t.length;c>l;l++){var h,d,y=t[l],C=y._model,E=i[y.id],S=y.isShowing&&y.isAvailable(e)&&u.getValueOrDefault(C._show,e,!0);if(S&&(d=y._getModelMatrix(e,_),h=u.getValueOrUndefined(C._uri,e),S=r(d)&&r(h)),S){var w=r(E)?E.modelPrimitive:void 0;if(r(w)&&h===E.uri||(r(w)&&(n.removeAndDestroy(w),delete i[y.id]),w=a.fromGltf({url:h,incrementallyLoadTextures:u.getValueOrDefault(C._incrementallyLoadTextures,e,v)}),w.readyPromise.otherwise(p),w.id=y,n.add(w),E={modelPrimitive:w,uri:h,animationsRunning:!1,nodeTransformationsScratch:{},originalNodeMatrixHash:{}},i[y.id]=E),w.show=!0,w.scale=u.getValueOrDefault(C._scale,e,m),w.minimumPixelSize=u.getValueOrDefault(C._minimumPixelSize,e,f),w.maximumScale=u.getValueOrUndefined(C._maximumScale,e),w.modelMatrix=o.clone(d,w.modelMatrix),w.ready){var T=u.getValueOrDefault(C._runAnimations,e,!0);E.animationsRunning!==T&&(T?w.activeAnimations.addAll({loop:s.REPEAT}):w.activeAnimations.removeAll(),E.animationsRunning=T);var x=u.getValueOrUndefined(C._nodeTransformations,e,E.nodeTransformationsScratch);if(r(x))for(var b=E.originalNodeMatrixHash,P=Object.keys(x),A=0,I=P.length;I>A;++A){var M=P[A],D=x[M];if(r(D)){var R=w.getNode(M);if(r(R)){var O=b[M];r(O)||(O=R.matrix.clone(),b[M]=O);var N=o.fromTranslationRotationScale(D,g);R.matrix=o.multiply(O,N,N)}}}}}else r(E)&&(E.modelPrimitive.show=!1)}return!0},c.prototype.isDestroyed=function(){return!1},c.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(c.prototype._onCollectionChanged,this);for(var e=this._entitiesToVisualize.values,t=this._modelHash,r=this._primitives,n=e.length-1;n>-1;n--)h(this,e[n],t,r);return i(this)},c.prototype.getBoundingSphere=function(e,i){var n=this._modelHash[e.id];if(!r(n))return l.FAILED;var o=n.modelPrimitive;return r(o)&&o.show?o.ready?(t.transform(o.boundingSphere,o.modelMatrix,i),l.DONE):l.PENDING:l.FAILED},c.prototype._onCollectionChanged=function(e,t,i,n){var o,a,s=this._entitiesToVisualize,l=this._modelHash,u=this._primitives;for(o=t.length-1;o>-1;o--)a=t[o],r(a._model)&&r(a._position)&&s.set(a.id,a);for(o=n.length-1;o>-1;o--)a=n[o],r(a._model)&&r(a._position)?(d(a,l),s.set(a.id,a)):(h(this,a,l,u),s.remove(a.id));for(o=i.length-1;o>-1;o--)a=i[o],h(this,a,l,u),s.remove(a.id)},c}),r("Shaders/PolylineCommon",[],function(){"use strict";return"void clipLineSegmentToNearPlane(\nvec3 p0,\nvec3 p1,\nout vec4 positionWC,\nout bool clipped,\nout bool culledByNearPlane)\n{\nculledByNearPlane = false;\nclipped = false;\nvec3 p1ToP0 = p1 - p0;\nfloat magnitude = length(p1ToP0);\nvec3 direction = normalize(p1ToP0);\nfloat endPoint0Distance =  -(czm_currentFrustum.x + p0.z);\nfloat denominator = -direction.z;\nif (endPoint0Distance < 0.0 && abs(denominator) < czm_epsilon7)\n{\nculledByNearPlane = true;\n}\nelse if (endPoint0Distance < 0.0 && abs(denominator) > czm_epsilon7)\n{\nfloat t = (czm_currentFrustum.x + p0.z) / denominator;\nif (t < 0.0 || t > magnitude)\n{\nculledByNearPlane = true;\n}\nelse\n{\np0 = p0 + t * direction;\nclipped = true;\n}\n}\npositionWC = czm_eyeToWindowCoordinates(vec4(p0, 1.0));\n}\nvec4 getPolylineWindowCoordinates(vec4 position, vec4 previous, vec4 next, float expandDirection, float width, bool usePrevious) {\nvec4 endPointWC, p0, p1;\nbool culledByNearPlane, clipped;\nvec4 positionEC = czm_modelViewRelativeToEye * position;\nvec4 prevEC = czm_modelViewRelativeToEye * previous;\nvec4 nextEC = czm_modelViewRelativeToEye * next;\nclipLineSegmentToNearPlane(prevEC.xyz, positionEC.xyz, p0, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(nextEC.xyz, positionEC.xyz, p1, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(positionEC.xyz, usePrevious ? prevEC.xyz : nextEC.xyz, endPointWC, clipped, culledByNearPlane);\nif (culledByNearPlane)\n{\nreturn vec4(0.0, 0.0, 0.0, 1.0);\n}\nvec2 prevWC = normalize(p0.xy - endPointWC.xy);\nvec2 nextWC = normalize(p1.xy - endPointWC.xy);\nfloat expandWidth = width * 0.5;\nvec2 direction;\nif (czm_equalsEpsilon(normalize(previous.xyz - position.xyz), vec3(0.0), czm_epsilon1) || czm_equalsEpsilon(prevWC, -nextWC, czm_epsilon1))\n{\ndirection = vec2(-nextWC.y, nextWC.x);\n}\nelse if (czm_equalsEpsilon(normalize(next.xyz - position.xyz), vec3(0.0), czm_epsilon1) || clipped)\n{\ndirection = vec2(prevWC.y, -prevWC.x);\n}\nelse\n{\nvec2 normal = vec2(-nextWC.y, nextWC.x);\ndirection = normalize((nextWC + prevWC) * 0.5);\nif (dot(direction, normal) < 0.0)\n{\ndirection = -direction;\n}\nfloat sinAngle = abs(direction.x * nextWC.y - direction.y * nextWC.x);\nexpandWidth = clamp(expandWidth / sinAngle, 0.0, width * 2.0);\n}\nvec2 offset = direction * expandDirection * expandWidth * czm_resolutionScale;\nreturn vec4(endPointWC.xy + offset, -endPointWC.z, 1.0);\n}\n"}),r("Shaders/PolylineFS",[],function(){"use strict";return"varying vec2 v_st;\nvoid main()\n{\nczm_materialInput materialInput;\nmaterialInput.s = v_st.s;\nmaterialInput.st = v_st;\nmaterialInput.str = vec3(v_st, 0.0);\nczm_material material = czm_getMaterial(materialInput);\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n}\n"}),r("Shaders/PolylineVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 position2DHigh;\nattribute vec3 position2DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 prevPosition2DHigh;\nattribute vec3 prevPosition2DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec3 nextPosition2DHigh;\nattribute vec3 nextPosition2DLow;\nattribute vec4 texCoordExpandWidthAndShow;\nattribute vec4 pickColor;\nvarying vec2  v_st;\nvarying float v_width;\nvarying vec4  czm_pickColor;\nvoid main()\n{\nfloat texCoord = texCoordExpandWidthAndShow.x;\nfloat expandDir = texCoordExpandWidthAndShow.y;\nfloat width = abs(texCoordExpandWidthAndShow.z) + 0.5;\nbool usePrev = texCoordExpandWidthAndShow.z < 0.0;\nfloat show = texCoordExpandWidthAndShow.w;\nvec4 p, prev, next;\nif (czm_morphTime == 1.0)\n{\np = czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz);\nprev = czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz);\nnext = czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz);\n}\nelse if (czm_morphTime == 0.0)\n{\np = czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy);\nprev = czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy);\nnext = czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy);\n}\nelse\n{\np = czm_columbusViewMorph(\nczm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy),\nczm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz),\nczm_morphTime);\nprev = czm_columbusViewMorph(\nczm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy),\nczm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz),\nczm_morphTime);\nnext = czm_columbusViewMorph(\nczm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy),\nczm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz),\nczm_morphTime);\n}\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC * show;\nv_st = vec2(texCoord, clamp(expandDir, 0.0, 1.0));\nv_width = width;\nczm_pickColor = pickColor;\n}\n"}),r("Scene/Polyline",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/PolylinePipeline","./Material"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(o,a){o=i(o,i.EMPTY_OBJECT),this._show=i(o.show,!0),this._width=i(o.width,1),this._loop=i(o.loop,!1),this._material=o.material,n(this._material)||(this._material=u.fromType(u.ColorType,{color:new r(1,1,1,1)}));var c=o.positions;n(c)||(c=[]),this._positions=c,this._actualPositions=l.removeDuplicates(c),this._loop&&this._actualPositions.length>2&&(this._actualPositions===this._positions&&(this._actualPositions=c.slice()),this._actualPositions.push(t.clone(this._actualPositions[0]))),this._length=this._actualPositions.length,this._id=o.id;var h;n(a)&&(h=s.clone(a.modelMatrix)),this._modelMatrix=h,this._segments=l.wrapLongitude(this._actualPositions,h),this._actualLength=void 0,this._propertiesChanged=new Uint32Array(_),this._polylineCollection=a,this._dirty=!1,this._pickId=void 0,this._boundingVolume=e.fromPoints(this._actualPositions),this._boundingVolumeWC=e.transform(this._boundingVolume,this._modelMatrix),this._boundingVolume2D=new e}function h(e,t){++e._propertiesChanged[t];var r=e._polylineCollection;n(r)&&(r._updatePolyline(e,t),e._dirty=!0)}var d=c.SHOW_INDEX=0,p=c.WIDTH_INDEX=1,m=c.POSITION_INDEX=2,f=c.MATERIAL_INDEX=3,v=c.POSITION_SIZE_INDEX=4,_=c.NUMBER_OF_PROPERTIES=5;return o(c.prototype,{show:{get:function(){return this._show},set:function(e){e!==this._show&&(this._show=e,h(this,d))}},positions:{get:function(){return this._positions},set:function(r){var i=l.removeDuplicates(r);this._loop&&i.length>2&&(i===r&&(i=r.slice()),i.push(t.clone(i[0]))),(this._actualPositions.length!==i.length||this._actualPositions.length!==this._length)&&h(this,v),this._positions=r,this._actualPositions=i,this._length=i.length,this._boundingVolume=e.fromPoints(this._actualPositions,this._boundingVolume),this._boundingVolumeWC=e.transform(this._boundingVolume,this._modelMatrix,this._boundingVolumeWC),h(this,m),this.update()}},material:{get:function(){return this._material},set:function(e){this._material!==e&&(this._material=e,h(this,f))}},width:{get:function(){return this._width},set:function(e){var t=this._width;e!==t&&(this._width=e,h(this,p))}},loop:{get:function(){return this._loop},set:function(e){if(e!==this._loop){var r=this._actualPositions;e?r.length>2&&!t.equals(r[0],r[r.length-1])&&(r.length===this._positions.length&&(this._actualPositions=r=this._positions.slice()),r.push(t.clone(r[0]))):r.length>2&&t.equals(r[0],r[r.length-1])&&(r.length-1===this._positions.length?this._actualPositions=this._positions:r.pop()),this._loop=e,h(this,v)}}},id:{get:function(){return this._id},set:function(e){this._id=e,n(this._pickId)&&(this._pickId.object.id=e)}}}),c.prototype.update=function(){var t=s.IDENTITY;n(this._polylineCollection)&&(t=this._polylineCollection.modelMatrix);var r=this._segments.positions.length,i=this._segments.lengths,o=this._propertiesChanged[m]>0||this._propertiesChanged[v]>0;if((!s.equals(t,this._modelMatrix)||o)&&(this._segments=l.wrapLongitude(this._actualPositions,t),this._boundingVolumeWC=e.transform(this._boundingVolume,t,this._boundingVolumeWC)),this._modelMatrix=t,this._segments.positions.length!==r)h(this,v);else for(var a=i.length,u=0;a>u;++u)if(i[u]!==this._segments.lengths[u]){h(this,v);break}},c.prototype.getPickId=function(e){return n(this._pickId)||(this._pickId=e.createPickId({primitive:this,collection:this._polylineCollection,id:this._id})),this._pickId},c.prototype._clean=function(){this._dirty=!1;for(var e=this._propertiesChanged,t=0;_-1>t;++t)e[t]=0},c.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._material=this._material&&this._material.destroy(),this._polylineCollection=void 0},c}),r("Scene/PolylineCollection",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/IndexDatatype","../Core/Intersect","../Core/Math","../Core/Matrix4","../Core/Plane","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArray","../Shaders/PolylineCommon","../Shaders/PolylineFS","../Shaders/PolylineVS","./BlendingState","./Material","./Pass","./Polyline","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b,P,A,I,M,D){"use strict";function R(e){e=a(e,a.EMPTY_OBJECT),this.modelMatrix=f.clone(a(e.modelMatrix,f.IDENTITY)),this._modelMatrix=f.clone(f.IDENTITY),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this._opaqueRS=void 0,this._translucentRS=void 0,this._colorCommands=[],this._pickCommands=[],this._polylinesUpdated=!1,this._polylinesRemoved=!1,this._createVertexArray=!1,this._propertiesChanged=new Uint32Array(Q),this._polylines=[],this._polylineBuckets={},this._buffersUsage=[{bufferUsage:g.STATIC_DRAW,frameCount:0},{bufferUsage:g.STATIC_DRAW,frameCount:0},{bufferUsage:g.STATIC_DRAW,frameCount:0}],this._mode=void 0,this._polylinesToUpdate=[],this._vertexArrays=[],this._positionBuffer=void 0,this._pickColorBuffer=void 0,this._texCoordExpandWidthAndShowBuffer=void 0}function O(t,r,i,n,o){for(var a=r.context,l=r.commandList,u=i.length,c=0,h=!0,d=t._vertexArrays,p=t.debugShowBoundingVolume,m=d.length,f=0;m>f;++f)for(var v=d[f],_=v.buckets,g=_.length,C=0;g>C;++C){for(var E,S,w,T=_[C],x=T.offset,b=o?T.bucket.shaderProgram:T.bucket.pickShaderProgram,P=T.bucket.polylines,A=P.length,M=0,R=0;A>R;++R){var O=P[R],N=F(O._material);if(N!==E){if(s(E)&&M>0){var L=S.isTranslucent();c>=u?(w=new y({owner:t}),i.push(w)):w=i[c],++c,w.boundingVolume=e.clone($,w.boundingVolume),w.modelMatrix=n,w.shaderProgram=b,w.vertexArray=v.va,w.renderState=L?t._translucentRS:t._opaqueRS,w.pass=L?I.TRANSLUCENT:I.OPAQUE,w.debugShowBoundingVolume=o?p:!1,w.uniformMap=S._uniforms,w.count=M,w.offset=x,x+=M,M=0,h=!0,l.push(w)}S=O._material,S.update(a),E=N}for(var B=O._locatorBuckets,V=B.length,z=0;V>z;++z){var k=B[z];k.locator===T&&(M+=k.count)}var U;r.mode===D.SCENE3D?U=O._boundingVolumeWC:r.mode===D.COLUMBUS_VIEW?U=O._boundingVolume2D:r.mode===D.SCENE2D?s(O._boundingVolume2D)&&(U=e.clone(O._boundingVolume2D,ee),U.center.x=0):s(O._boundingVolumeWC)&&s(O._boundingVolume2D)&&(U=e.union(O._boundingVolumeWC,O._boundingVolume2D,ee)),h?(h=!1,e.clone(U,$)):e.union(U,$,$)}s(E)&&M>0&&(c>=u?(w=new y({owner:t}),i.push(w)):w=i[c],++c,w.boundingVolume=e.clone($,w.boundingVolume),w.modelMatrix=n,w.shaderProgram=b,w.vertexArray=v.va,w.renderState=S.isTranslucent()?t._translucentRS:t._opaqueRS,w.pass=S.isTranslucent()?I.TRANSLUCENT:I.OPAQUE,w.debugShowBoundingVolume=o?p:!1,w.uniformMap=S._uniforms,w.count=M,w.offset=x,h=!0,l.push(w)),E=void 0}i.length=c}function N(e){for(var t=e._buffersUsage,r=!1,i=e._propertiesChanged,n=0;Q-2>n;++n){var o=t[n];i[n]?o.bufferUsage!==g.STREAM_DRAW?(r=!0,o.bufferUsage=g.STREAM_DRAW,o.frameCount=100):o.frameCount=100:o.bufferUsage!==g.STATIC_DRAW&&(0===o.frameCount?(r=!0,o.bufferUsage=g.STATIC_DRAW):o.frameCount--)}return r}function L(e,t,r){e._createVertexArray=!1,k(e),U(e),B(e);var i,n,a=[[]],l=a[0],u=[0],c=0,h=[[]],p=0,f=e._polylineBuckets;for(i in f)f.hasOwnProperty(i)&&(n=f[i],n.updateShader(t),p+=n.lengthOfPositions);if(p>0){var v,y=e._mode,C=new Float32Array(6*p*3),E=new Uint8Array(4*p),S=new Float32Array(4*p),T=0,x=0,b=0;for(i in f)if(f.hasOwnProperty(i)){n=f[i],n.write(C,E,S,T,x,b,t,r),y===D.MORPHING&&(s(v)||(v=new Float32Array(6*p*3)),n.writeForMorph(v,T));var P=n.lengthOfPositions;T+=6*P*3,x+=4*P,b+=4*P,c=n.updateIndices(a,u,h,c)}var A=e._buffersUsage[X].bufferUsage,I=e._buffersUsage[j].bufferUsage,M=e._buffersUsage[Y].bufferUsage,R=I===g.STREAM_DRAW||M===g.STREAM_DRAW?g.STREAM_DRAW:g.STATIC_DRAW;e._positionBuffer=_.createVertexBuffer({context:t,typedArray:C,usage:A});var O;s(v)&&(O=_.createVertexBuffer({context:t,typedArray:v,usage:A})),e._pickColorBuffer=_.createVertexBuffer({context:t,typedArray:E,usage:g.STATIC_DRAW}),e._texCoordExpandWidthAndShowBuffer=_.createVertexBuffer({context:t,typedArray:S,usage:R});for(var N=4*Uint8Array.BYTES_PER_ELEMENT,L=3*Float32Array.BYTES_PER_ELEMENT,F=4*Float32Array.BYTES_PER_ELEMENT,V=0,z=a.length,G=0;z>G;++G)if(l=a[G],l.length>0){var W=new Uint16Array(l),H=_.createIndexBuffer({context:t,typedArray:W,usage:g.STATIC_DRAW,indexDatatype:d.UNSIGNED_SHORT});V+=u[G];var q,Z,K,Q,$=6*(G*(L*m.SIXTY_FOUR_KILOBYTES)-V*L),ee=L+$,re=L+ee,ie=L+re,ne=L+ie,oe=L+ne,ae=G*(N*m.SIXTY_FOUR_KILOBYTES)-V*N,se=G*(F*m.SIXTY_FOUR_KILOBYTES)-V*F,le=[{index:J.position3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:$,strideInBytes:6*L},{index:J.position3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ee,strideInBytes:6*L},{index:J.position2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:$,strideInBytes:6*L},{index:J.position2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ee,strideInBytes:6*L},{index:J.prevPosition3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:re,strideInBytes:6*L},{index:J.prevPosition3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ie,strideInBytes:6*L},{index:J.prevPosition2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:re,strideInBytes:6*L},{index:J.prevPosition2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ie,strideInBytes:6*L},{index:J.nextPosition3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ne,strideInBytes:6*L},{index:J.nextPosition3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:oe,strideInBytes:6*L},{index:J.nextPosition2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:ne,strideInBytes:6*L},{index:J.nextPosition2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:oe,strideInBytes:6*L},{index:J.texCoordExpandWidthAndShow,componentsPerAttribute:4,componentDatatype:o.FLOAT,vertexBuffer:e._texCoordExpandWidthAndShowBuffer,offsetInBytes:se},{index:J.pickColor,componentsPerAttribute:4,componentDatatype:o.UNSIGNED_BYTE,vertexBuffer:e._pickColorBuffer,offsetInBytes:ae,normalize:!0}];y===D.SCENE3D?(q=e._positionBuffer,Z="vertexBuffer",K=te,Q="value"):y===D.SCENE2D||y===D.COLUMBUS_VIEW?(q=te,Z="value",K=e._positionBuffer,Q="vertexBuffer"):(q=O,Z="vertexBuffer",K=e._positionBuffer,Q="vertexBuffer"),le[0][Z]=q,le[1][Z]=q,le[2][Q]=K,le[3][Q]=K,le[4][Z]=q,le[5][Z]=q,le[6][Q]=K,le[7][Q]=K,le[8][Z]=q,le[9][Z]=q,le[10][Q]=K,le[11][Q]=K;var ue=new w({context:t,attributes:le,indexBuffer:H});e._vertexArrays.push({va:ue,buckets:h[G]})}}}function F(e){var t=A._uniformList[e.type],r=t.length;re.length=2*r;for(var i=0,n=0;r>n;++n){var o=t[n];re[i]=o,re[i+1]=e._uniforms[o](),i+=2}return e.type+":"+JSON.stringify(re)}function B(e){for(var t=e._mode,r=e._modelMatrix,i=e._polylineBuckets={},n=e._polylines,o=n.length,a=0;o>a;++a){var l=n[a];if(l._actualPositions.length>1){l.update();var u=l.material,c=i[u.type];s(c)||(c=i[u.type]=new H(u,t,r)),c.addPolyline(l)}}}function V(e,t){var r=t.mode;e._mode===r&&f.equals(e._modelMatrix,e.modelMatrix)||(e._mode=r,e._modelMatrix=f.clone(e.modelMatrix),e._createVertexArray=!0)}function z(e){if(e._polylinesRemoved){e._polylinesRemoved=!1;for(var t=[],r=e._polylines.length,i=0,n=0;r>i;++i){var o=e._polylines[i];s(o)&&(o._index=n++,t.push(o))}e._polylines=t}}function k(e){for(var t=e._polylines,r=t.length,i=0;r>i;++i)if(s(t[i])){var n=t[i]._bucket;s(n)&&(n.shaderProgram=n.shaderProgram&&n.shaderProgram.destroy())}}function U(e){for(var t=e._vertexArrays.length,r=0;t>r;++r)e._vertexArrays[r].va.destroy();
e._vertexArrays.length=0}function G(e){for(var t=e._polylines,r=t.length,i=0;r>i;++i)s(t[i])&&t[i]._destroy()}function W(e,t,r){this.count=e,this.offset=t,this.bucket=r}function H(e,t,r){this.polylines=[],this.lengthOfPositions=0,this.material=e,this.shaderProgram=void 0,this.pickShaderProgram=void 0,this.mode=t,this.modelMatrix=r}function q(e){return t.dot(t.UNIT_X,e._boundingVolume.center)<0||e._boundingVolume.intersectPlane(v.ORIGIN_ZX_PLANE)===p.INTERSECTING}var j=M.SHOW_INDEX,Y=M.WIDTH_INDEX,X=M.POSITION_INDEX,Z=M.MATERIAL_INDEX,K=M.POSITION_SIZE_INDEX,Q=M.NUMBER_OF_PROPERTIES,J={texCoordExpandWidthAndShow:0,position3DHigh:1,position3DLow:2,position2DHigh:3,position2DLow:4,prevPosition3DHigh:5,prevPosition3DLow:6,prevPosition2DHigh:7,prevPosition2DLow:8,nextPosition3DHigh:9,nextPosition3DLow:10,nextPosition2DHigh:11,nextPosition2DLow:12,pickColor:13};l(R.prototype,{length:{get:function(){return z(this),this._polylines.length}}}),R.prototype.add=function(e){var t=new M(e,this);return t._index=this._polylines.length,this._polylines.push(t),this._createVertexArray=!0,t},R.prototype.remove=function(e){if(this.contains(e)){if(this._polylines[e._index]=void 0,this._polylinesRemoved=!0,this._createVertexArray=!0,s(e._bucket)){var t=e._bucket;t.shaderProgram=t.shaderProgram&&t.shaderProgram.destroy(),t.pickShaderProgram=t.pickShaderProgram&&t.pickShaderProgram.destroy()}return e._destroy(),!0}return!1},R.prototype.removeAll=function(){k(this),G(this),this._polylineBuckets={},this._polylinesRemoved=!1,this._polylines.length=0,this._polylinesToUpdate.length=0,this._createVertexArray=!0},R.prototype.contains=function(e){return s(e)&&e._polylineCollection===this},R.prototype.get=function(e){return z(this),this._polylines[e]},R.prototype.update=function(e,t){if(z(this),0!==this._polylines.length){V(this,e);var r,i=e.context,n=e.mapProjection,o=this._propertiesChanged;if(this._createVertexArray||N(this))L(this,i,n);else if(this._polylinesUpdated){var a=this._polylinesToUpdate;if(this._mode!==D.SCENE3D)for(var l=a.length,u=0;l>u;++u)r=a[u],r.update();if(o[K]||o[Z])L(this,i,n);else for(var c=a.length,h=this._polylineBuckets,d=0;c>d;++d){r=a[d],o=r._propertiesChanged;var p=r._bucket,m=0;for(var v in h)if(h.hasOwnProperty(v)){if(h[v]===p){(o[X]||o[j]||o[Y])&&p.writeUpdate(m,r,this._positionBuffer,this._texCoordExpandWidthAndShowBuffer,n);break}m+=h[v].lengthOfPositions}r._clean()}a.length=0,this._polylinesUpdated=!1}o=this._propertiesChanged;for(var _=0;Q>_;++_)o[_]=0;var g=f.IDENTITY;e.mode===D.SCENE3D&&(g=this.modelMatrix);var y=e.passes,E=0!==e.morphTime;if(s(this._opaqueRS)&&this._opaqueRS.depthTest.enabled===E||(this._opaqueRS=C.fromCache({depthMask:E,depthTest:{enabled:E}})),s(this._translucentRS)&&this._translucentRS.depthTest.enabled===E||(this._translucentRS=C.fromCache({blending:P.ALPHA_BLEND,depthMask:!E,depthTest:{enabled:E}})),y.render){var S=this._colorCommands;O(this,e,S,g,!0)}if(y.pick){var w=this._pickCommands;O(this,e,w,g,!1)}}};var $=new e,ee=new e;R.prototype.isDestroyed=function(){return!1},R.prototype.destroy=function(){return U(this),k(this),G(this),u(this)};var te=[0,0,0],re=[];R.prototype._updatePolyline=function(e,t){this._polylinesUpdated=!0,this._polylinesToUpdate.push(e),++this._propertiesChanged[t]},H.prototype.addPolyline=function(e){var t=this.polylines;t.push(e),e._actualLength=this.getPolylinePositionsLength(e),this.lengthOfPositions+=e._actualLength,e._bucket=this},H.prototype.updateShader=function(e){if(!s(this.shaderProgram)){var t=new S({sources:[T,b]}),r=new S({sources:[this.material.shaderSource,x]}),i=new S({sources:r.sources,pickColorQualifier:"varying"});this.shaderProgram=E.fromCache({context:e,vertexShaderSource:t,fragmentShaderSource:r,attributeLocations:J}),this.pickShaderProgram=E.fromCache({context:e,vertexShaderSource:t,fragmentShaderSource:i,attributeLocations:J})}},H.prototype.getPolylinePositionsLength=function(e){var t;if(this.mode===D.SCENE3D||!q(e))return t=e._actualPositions.length,4*t-4;var r=0,i=e._segments.lengths;t=i.length;for(var n=0;t>n;++n)r+=4*i[n]-4;return r};var ie=new t,ne=new t,oe=new t,ae=new t;H.prototype.write=function(e,r,i,o,a,s,l,u){for(var c=this.mode,d=this.polylines,p=d.length,m=0;p>m;++m)for(var f,v=d[m],_=v.width,g=v.show&&_>0,y=this.getSegments(v,u),C=y.positions,E=y.lengths,S=C.length,w=v.getPickId(l).color,T=0,x=0,b=0;S>b;++b){0===b?v._loop?f=C[S-2]:(f=ae,t.subtract(C[0],C[1],f),t.add(C[0],f,f)):f=C[b-1],ne.x=f.x,ne.y=f.y,ne.z=c!==D.SCENE2D?f.z:0,f=C[b],ie.x=f.x,ie.y=f.y,ie.z=c!==D.SCENE2D?f.z:0,b===S-1?v._loop?f=C[1]:(f=ae,t.subtract(C[S-1],C[S-2],f),t.add(C[S-1],f,f)):f=C[b+1],oe.x=f.x,oe.y=f.y,oe.z=c!==D.SCENE2D?f.z:0;var P=E[T];b===x+P&&(x+=P,++T);for(var A=b-x===0,I=b===x+E[T]-1,M=A?2:0,R=I?2:4,O=M;R>O;++O){h.writeElements(ie,e,o),h.writeElements(ne,e,o+6),h.writeElements(oe,e,o+12),r[a]=n.floatToByte(w.red),r[a+1]=n.floatToByte(w.green),r[a+2]=n.floatToByte(w.blue),r[a+3]=n.floatToByte(w.alpha);var N=0>O-2?-1:1;i[s]=b/(S-1),i[s+1]=2*(O%2)-1,i[s+2]=N*_,i[s+3]=g,o+=18,a+=4,s+=4}}};var se=new t,le=new t,ue=new t,ce=new t;H.prototype.writeForMorph=function(e,r){for(var i=this.modelMatrix,n=this.polylines,o=n.length,a=0;o>a;++a)for(var s=n[a],l=s._segments.positions,u=s._segments.lengths,c=l.length,d=0,p=0,m=0;c>m;++m){var v;0===m?s._loop?v=l[c-2]:(v=ce,t.subtract(l[0],l[1],v),t.add(l[0],v,v)):v=l[m-1],v=f.multiplyByPoint(i,v,le);var _,g=f.multiplyByPoint(i,l[m],se);m===c-1?s._loop?_=l[1]:(_=ce,t.subtract(l[c-1],l[c-2],_),t.add(l[c-1],_,_)):_=l[m+1],_=f.multiplyByPoint(i,_,ue);var y=u[d];m===p+y&&(p+=y,++d);for(var C=m-p===0,E=m===p+u[d]-1,S=C?2:0,w=E?2:4,T=S;w>T;++T)h.writeElements(g,e,r),h.writeElements(v,e,r+6),h.writeElements(_,e,r+12),r+=18}};var he=new Array(1);H.prototype.updateIndices=function(e,t,r,i){var n=r.length-1,o=new W(0,i,this);r[n].push(o);var a=0,s=e[e.length-1],l=0;s.length>0&&(l=s[s.length-1]+1);for(var u=this.polylines,c=u.length,h=0;c>h;++h){var d=u[h];d._locatorBuckets=[];var p;if(this.mode===D.SCENE3D){p=he;var f=d._actualPositions.length;if(!(f>0))continue;p[0]=f}else p=d._segments.lengths;var v=p.length;if(v>0){for(var _=0,g=0;v>g;++g)for(var y=p[g]-1,C=0;y>C;++C)l+4>=m.SIXTY_FOUR_KILOBYTES-2&&(d._locatorBuckets.push({locator:o,count:_}),_=0,t.push(4),s=[],e.push(s),l=0,o.count=a,a=0,i=0,o=new W(0,0,this),r[++n]=[o]),s.push(l,l+2,l+1),s.push(l+1,l+2,l+3),_+=6,a+=6,i+=6,l+=4;d._locatorBuckets.push({locator:o,count:_}),l+4>=m.SIXTY_FOUR_KILOBYTES-2&&(t.push(0),s=[],e.push(s),l=0,o.count=a,i=0,a=0,o=new W(0,0,this),r[++n]=[o])}d._clean()}return o.count=a,i},H.prototype.getPolylineStartIndex=function(e){for(var t=this.polylines,r=0,i=t.length,n=0;i>n;++n){var o=t[n];if(o===e)break;r+=o._actualLength}return r};var de={positions:void 0,lengths:void 0},pe=new Array(1),me=new t,fe=new i;H.prototype.getSegments=function(r,i){var n=r._actualPositions;if(this.mode===D.SCENE3D)return pe[0]=n.length,de.positions=n,de.lengths=pe,de;q(r)&&(n=r._segments.positions);for(var o,a=i.ellipsoid,s=[],l=this.modelMatrix,u=n.length,c=me,h=0;u>h;++h)o=n[h],c=f.multiplyByPoint(l,o,c),s.push(i.project(a.cartesianToCartographic(c,fe)));if(s.length>0){r._boundingVolume2D=e.fromPoints(s,r._boundingVolume2D);var d=r._boundingVolume2D.center;r._boundingVolume2D.center=new t(d.z,d.x,d.y)}return de.positions=s,de.lengths=r._segments.lengths,de};var ve,_e;return H.prototype.writeUpdate=function(e,r,i,n,o){var a=this.mode,l=r._actualLength;if(l){e+=this.getPolylineStartIndex(r);var u=ve,c=_e,d=6*l*3;!s(u)||u.length<d?(u=ve=new Float32Array(d),c=_e=new Float32Array(4*l)):u.length>d&&(u=new Float32Array(u.buffer,0,d),c=new Float32Array(c.buffer,0,4*l));var p,m=0,f=0,v=this.getSegments(r,o),_=v.positions,g=v.lengths,y=0,C=0,E=r.width,S=r.show&&E>0;l=_.length;for(var w=0;l>w;++w){0===w?r._loop?p=_[l-2]:(p=ae,t.subtract(_[0],_[1],p),t.add(_[0],p,p)):p=_[w-1],ne.x=p.x,ne.y=p.y,ne.z=a!==D.SCENE2D?p.z:0,p=_[w],ie.x=p.x,ie.y=p.y,ie.z=a!==D.SCENE2D?p.z:0,w===l-1?r._loop?p=_[1]:(p=ae,t.subtract(_[l-1],_[l-2],p),t.add(_[l-1],p,p)):p=_[w+1],oe.x=p.x,oe.y=p.y,oe.z=a!==D.SCENE2D?p.z:0;var T=g[y];w===C+T&&(C+=T,++y);for(var x=w-C===0,b=w===C+g[y]-1,P=x?2:0,A=b?2:4,I=P;A>I;++I){h.writeElements(ie,u,m),h.writeElements(ne,u,m+6),h.writeElements(oe,u,m+12);var M=0>I-2?-1:1;c[f]=w/(l-1),c[f+1]=2*(I%2)-1,c[f+2]=M*E,c[f+3]=S,m+=18,f+=4}}i.copyFromArrayView(u,18*Float32Array.BYTES_PER_ELEMENT*e),n.copyFromArrayView(c,4*Float32Array.BYTES_PER_ELEMENT*e)}},R}),r("DataSources/ScaledPositionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/ReferenceFrame","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(e){this._definitionChanged=new n,this._value=void 0,this._removeSubscription=void 0,this.setValue(e)}return t(s.prototype,{isConstant:{get:function(){return a.isConstant(this._value)}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return e(this._value)?this._value.referenceFrame:o.FIXED}}}),s.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},s.prototype.setValue=function(t){this._value!==t&&(this._value=t,e(this._removeSubscription)&&(this._removeSubscription(),this._removeSubscription=void 0),e(t)&&(this._removeSubscription=t.definitionChanged.addEventListener(this._raiseDefinitionChanged,this)),this._definitionChanged.raiseEvent(this))},s.prototype.getValueInReferenceFrame=function(t,r,n){return e(this._value)?(n=this._value.getValueInReferenceFrame(t,r,n),e(n)?i.WGS84.scaleToGeodeticSurface(n,n):void 0):void 0},s.prototype.equals=function(e){return this===e||e instanceof s&&this._value===e._value},s.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},s}),r("DataSources/PathVisualizer",["../Core/AssociativeArray","../Core/Cartesian3","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/JulianDate","../Core/Matrix3","../Core/Matrix4","../Core/ReferenceFrame","../Core/TimeInterval","../Core/Transforms","../Scene/PolylineCollection","../Scene/SceneMode","./CompositePositionProperty","./ConstantPositionProperty","./MaterialProperty","./Property","./ReferenceProperty","./SampledPositionProperty","./ScaledPositionProperty","./TimeIntervalCollectionPositionProperty"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C){"use strict";function E(e){this.entity=e,this.polyline=void 0,this.index=void 0,this.updater=void 0}function S(e,t,i,n,a,s,l,u,c){var h,d=u;h=e.getValueInReferenceFrame(t,s,c[d]),r(h)&&(c[d++]=h);for(var p,m,f,v=!r(a)||o.lessThanOrEquals(a,t)||o.greaterThanOrEquals(a,i),_=0,g=n.length,y=n[_],C=i,E=!1;g>_;){if(!v&&o.greaterThanOrEquals(y,a)&&(h=e.getValueInReferenceFrame(a,s,c[d]),r(h)&&(c[d++]=h),v=!0),o.greaterThan(y,t)&&o.lessThan(y,C)&&!y.equals(a)&&(h=e.getValueInReferenceFrame(y,s,c[d]),r(h)&&(c[d++]=h)),g-1>_){if(l>0&&!E){var S=n[_+1],w=o.secondsDifference(S,y);E=w>l,E&&(p=Math.ceil(w/l),m=0,f=w/Math.max(p,2),p=Math.max(p-1,1))}if(E&&p>m){y=o.addSeconds(y,f,new o),m++;continue}}E=!1,_++,y=n[_]}return h=e.getValueInReferenceFrame(i,s,c[d]),r(h)&&(c[d++]=h),d}function w(e,t,i,n,a,s,l,u){for(var c,h=0,d=l,p=t,m=Math.max(s,60),f=!r(n)||o.lessThanOrEquals(n,t)||o.greaterThanOrEquals(n,i);o.lessThan(p,i);)!f&&o.greaterThanOrEquals(p,n)&&(f=!0,c=e.getValueInReferenceFrame(n,a,u[d]),r(c)&&(u[d]=c,d++)),c=e.getValueInReferenceFrame(p,a,u[d]),r(c)&&(u[d]=c,d++),h++,p=o.addSeconds(t,m*h,new o);return c=e.getValueInReferenceFrame(i,a,u[d]),r(c)&&(u[d]=c,d++),d}function T(e,t,i,n,a,s,l,c){L.start=t,L.stop=i;for(var h=l,d=e.intervals,p=0;p<d.length;p++){var m=d.get(p);if(!u.intersect(m,L,O).isEmpty){var f=m.start;m.isStartIncluded||(f=m.isStopIncluded?m.stop:o.addSeconds(m.start,o.secondsDifference(m.stop,m.start)/2,new o));var v=e.getValueInReferenceFrame(f,a,c[h]);r(v)&&(c[h]=v,h++)}}return h}function x(e,t,i,n,o,a,s,l){var u=e.getValueInReferenceFrame(t,o,l[s]);return r(u)&&(l[s++]=u),s}function b(e,t,r,i,n,a,s,l){N.start=t,N.stop=r;for(var c=s,h=e.intervals,d=0;d<h.length;d++){var p=h.get(d);if(!u.intersect(p,N,O).isEmpty){var m=p.start,f=p.stop,v=t;o.greaterThan(m,v)&&(v=m);var _=r;o.lessThan(f,_)&&(_=f),c=P(p.data,v,_,i,n,a,c,l)}}return c}function P(e,t,r,i,n,o,a,s){for(var l=e;l instanceof _||l instanceof y;)l instanceof _&&(l=l.resolvedProperty),l instanceof y&&(l=l._value);if(l instanceof g){var u=l._property._times;a=S(e,t,r,u,i,n,o,a,s)}else a=l instanceof p?b(e,t,r,i,n,o,a,s):l instanceof C?T(e,t,r,i,n,o,a,s):l instanceof m?x(e,t,r,i,n,o,a,s):w(e,t,r,i,n,o,a,s);return a}function A(e,t,i,n,o,a,s){r(s)||(s=[]);var l=P(e,t,i,n,o,a,0,s);return s.length=l,s}function I(e,t){this._unusedIndexes=[],this._polylineCollection=new h,this._scene=e,this._referenceFrame=t,e.primitives.add(this._polylineCollection)}function M(t,r){r.collectionChanged.addEventListener(M.prototype._onCollectionChanged,this),this._scene=t,this._updaters={},this._entityCollection=r,this._items=new e,this._onCollectionChanged(r,r.values,[],[])}var D=60,R=1,O=new u,N=new u,L=new u,F=new a;return I.prototype.update=function(e){if(this._referenceFrame===l.INERTIAL){var i=c.computeIcrfToFixedMatrix(e,F);r(i)||(i=c.computeTemeToPseudoFixedMatrix(e,F)),s.fromRotationTranslation(i,t.ZERO,this._polylineCollection.modelMatrix)}},I.prototype.updateObject=function(e,t){var i,n,a=t.entity,s=a._path,l=a._position,u=s._show,c=t.polyline,h=a.isShowing&&(!r(u)||u.getValue(e));if(h){var d=v.getValueOrUndefined(s._leadTime,e),p=v.getValueOrUndefined(s._trailTime,e),m=a._availability,_=r(m),g=r(d),y=r(p);if(h=_||g&&y){if(y&&(i=o.addSeconds(e,-p,new o)),g&&(n=o.addSeconds(e,d,new o)),_){var C=m.start,E=m.stop;(!y||o.greaterThan(C,i))&&(i=C),(!g||o.lessThan(E,n))&&(n=E)}h=o.lessThan(i,n)}}if(!h)return void(r(c)&&(this._unusedIndexes.push(t.index),t.polyline=void 0,c.show=!1,t.index=void 0));if(!r(c)){var S=this._unusedIndexes,w=S.length;if(w>0){var T=S.pop();c=this._polylineCollection.get(T),t.index=T}else t.index=this._polylineCollection.length,c=this._polylineCollection.add();c.id=a,t.polyline=c}var x=v.getValueOrDefault(s._resolution,e,D);c.show=!0,c.positions=A(l,i,n,e,this._referenceFrame,x,c.positions),c.material=f.getValue(e,s._material,c.material),c.width=v.getValueOrDefault(s._width,e,R)},I.prototype.removeObject=function(e){var t=e.polyline;r(t)&&(this._unusedIndexes.push(e.index),e.polyline=void 0,t.show=!1,e.index=void 0)},I.prototype.destroy=function(){return this._scene.primitives.remove(this._polylineCollection),i(this)},M.prototype.update=function(e){var t=this._updaters;for(var i in t)t.hasOwnProperty(i)&&t[i].update(e);for(var n=this._items.values,o=0,a=n.length;a>o;o++){var s=n[o],u=s.entity,c=u._position,h=s.updater,p=l.FIXED;this._scene.mode===d.SCENE3D&&(p=c.referenceFrame);var m=this._updaters[p];h===m&&r(m)?m.updateObject(e,s):(r(h)&&h.removeObject(s),r(m)||(m=new I(this._scene,p),m.update(e),this._updaters[p]=m),s.updater=m,r(m)&&m.updateObject(e,s))}return!0},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(M.prototype._onCollectionChanged,this);var e=this._updaters;for(var t in e)e.hasOwnProperty(t)&&e[t].destroy();return i(this)},M.prototype._onCollectionChanged=function(e,t,i,n){var o,a,s,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],r(a._path)&&r(a._position)&&l.set(a.id,new E(a));for(o=n.length-1;o>-1;o--)a=n[o],r(a._path)&&r(a._position)?l.contains(a.id)||l.set(a.id,new E(a)):(s=l.get(a.id),r(s)&&(s.updater.removeObject(s),l.remove(a.id)));for(o=i.length-1;o>-1;o--)a=i[o],s=l.get(a.id),r(s)&&(s.updater.removeObject(s),l.remove(a.id))},M._subSample=A,M}),r("Shaders/PointPrimitiveCollectionFS",[],function(){"use strict";return"varying vec4 v_color;\nvarying vec4 v_outlineColor;\nvarying float v_innerPercent;\nvarying float v_pixelDistance;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#endif\nvoid main()\n{\nfloat distanceToCenter = length(gl_PointCoord - vec2(0.5));\nfloat maxDistance = max(0.0, 0.5 - v_pixelDistance);\nfloat wholeAlpha = 1.0 - smoothstep(maxDistance, 0.5, distanceToCenter);\nfloat innerAlpha = 1.0 - smoothstep(maxDistance * v_innerPercent, 0.5 * v_innerPercent, distanceToCenter);\nvec4 color = mix(v_outlineColor, v_color, innerAlpha);\ncolor.a *= wholeAlpha;\nif (color.a < 0.005)\n{\ndiscard;\n}\n#ifdef RENDER_FOR_PICK\ngl_FragColor = v_pickColor;\n#else\ngl_FragColor = color;\n#endif\n}\n"}),r("Shaders/PointPrimitiveCollectionVS",[],function(){"use strict";return"uniform float u_maxTotalPointSize;\nattribute vec4 positionHighAndSize;\nattribute vec4 positionLowAndOutline;\nattribute vec4 compressedAttribute0;\nattribute vec4 compressedAttribute1;\nattribute vec4 scaleByDistance;\nvarying vec4 v_color;\nvarying vec4 v_outlineColor;\nvarying float v_innerPercent;\nvarying float v_pixelDistance;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#endif\nconst float SHIFT_LEFT8 = 256.0;\nconst float SHIFT_RIGHT8 = 1.0 / 256.0;\nvoid main()\n{\nvec3 positionHigh = positionHighAndSize.xyz;\nvec3 positionLow = positionLowAndOutline.xyz;\nfloat outlineWidthBothSides = 2.0 * positionLowAndOutline.w;\nfloat totalSize = positionHighAndSize.w + outlineWidthBothSides;\nfloat outlinePercent = outlineWidthBothSides / totalSize;\ntotalSize *= czm_resolutionScale;\ntotalSize += 3.0;\nfloat temp = compressedAttribute1.x * SHIFT_RIGHT8;\nfloat show = floor(temp);\n#ifdef EYE_DISTANCE_TRANSLUCENCY\nvec4 translucencyByDistance;\ntranslucencyByDistance.x = compressedAttribute1.z;\ntranslucencyByDistance.z = compressedAttribute1.w;\ntranslucencyByDistance.y = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\ntemp = compressedAttribute1.y * SHIFT_RIGHT8;\ntranslucencyByDistance.w = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\n#endif\nvec4 color;\nvec4 outlineColor;\n#ifdef RENDER_FOR_PICK\ncolor = vec4(0.0);\noutlineColor = vec4(0.0);\nvec4 pickColor;\ntemp = compressedAttribute0.z * SHIFT_RIGHT8;\npickColor.b = (temp - floor(temp)) * SHIFT_LEFT8;\ntemp = floor(temp) * SHIFT_RIGHT8;\npickColor.g = (temp - floor(temp)) * SHIFT_LEFT8;\npickColor.r = floor(temp);\n#else\ntemp = compressedAttribute0.x * SHIFT_RIGHT8;\ncolor.b = (temp - floor(temp)) * SHIFT_LEFT8;\ntemp = floor(temp) * SHIFT_RIGHT8;\ncolor.g = (temp - floor(temp)) * SHIFT_LEFT8;\ncolor.r = floor(temp);\ntemp = compressedAttribute0.y * SHIFT_RIGHT8;\noutlineColor.b = (temp - floor(temp)) * SHIFT_LEFT8;\ntemp = floor(temp) * SHIFT_RIGHT8;\noutlineColor.g = (temp - floor(temp)) * SHIFT_LEFT8;\noutlineColor.r = floor(temp);\n#endif\ntemp = compressedAttribute0.w * SHIFT_RIGHT8;\n#ifdef RENDER_FOR_PICK\npickColor.a = (temp - floor(temp)) * SHIFT_LEFT8;\npickColor = pickColor / 255.0;\n#endif\ntemp = floor(temp) * SHIFT_RIGHT8;\noutlineColor.a = (temp - floor(temp)) * SHIFT_LEFT8;\noutlineColor /= 255.0;\ncolor.a = floor(temp);\ncolor /= 255.0;\nvec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\nvec4 positionEC = czm_modelViewRelativeToEye * p;\npositionEC.xyz *= show;\n#if defined(EYE_DISTANCE_SCALING) || defined(EYE_DISTANCE_TRANSLUCENCY)\nfloat lengthSq;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nlengthSq = czm_eyeHeight2D.y;\n}\nelse\n{\nlengthSq = dot(positionEC.xyz, positionEC.xyz);\n}\n#endif\n#ifdef EYE_DISTANCE_SCALING\ntotalSize *= czm_nearFarScalar(scaleByDistance, lengthSq);\n#endif\ntotalSize = min(totalSize, u_maxTotalPointSize);\nif (totalSize < 1.0)\n{\npositionEC.xyz = vec3(0.0);\ntotalSize = 1.0;\n}\nfloat translucency = 1.0;\n#ifdef EYE_DISTANCE_TRANSLUCENCY\ntranslucency = czm_nearFarScalar(translucencyByDistance, lengthSq);\nif (translucency < 0.004)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\nvec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\ngl_Position = czm_viewportOrthographic * vec4(positionWC.xy, -positionWC.z, 1.0);\nv_color = color;\nv_color.a *= translucency;\nv_outlineColor = outlineColor;\nv_outlineColor.a *= translucency;\nv_innerPercent = 1.0 - outlinePercent;\nv_pixelDistance = 2.0 / totalSize;\ngl_PointSize = totalSize;\n#ifdef RENDER_FOR_PICK\nv_pickColor = pickColor;\n#endif\n}\n"}),r("Scene/PointPrimitive",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/NearFarScalar","./SceneMode","./SceneTransforms"],function(e,t,r,i,n,o,a,s,l,u,c,h){"use strict";function d(e,r){e=n(e,n.EMPTY_OBJECT),this._show=n(e.show,!0),this._position=t.clone(n(e.position,t.ZERO)),this._actualPosition=t.clone(this._position),this._color=i.clone(n(e.color,i.WHITE)),this._outlineColor=i.clone(n(e.outlineColor,i.TRANSPARENT)),this._outlineWidth=n(e.outlineWidth,0),this._pixelSize=n(e.pixelSize,10),this._scaleByDistance=e.scaleByDistance,this._translucencyByDistance=e.translucencyByDistance,this._id=e.id,this._collection=n(e.collection,r),this._pickId=void 0,this._pointPrimitiveCollection=r,this._dirty=!1,this._index=-1}function p(e,t){var r=e._pointPrimitiveCollection;o(r)&&(r._updatePointPrimitive(e,t),e._dirty=!0)}var m=d.SHOW_INDEX=0,f=d.POSITION_INDEX=1,v=d.COLOR_INDEX=2,_=d.OUTLINE_COLOR_INDEX=3,g=d.OUTLINE_WIDTH_INDEX=4,y=d.PIXEL_SIZE_INDEX=5,C=d.SCALE_BY_DISTANCE_INDEX=6,E=d.TRANSLUCENCY_BY_DISTANCE_INDEX=7;d.NUMBER_OF_PROPERTIES=8,a(d.prototype,{show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,p(this,m))}},position:{get:function(){return this._position},set:function(e){var r=this._position;t.equals(r,e)||(t.clone(e,r),t.clone(e,this._actualPosition),p(this,f))}},scaleByDistance:{get:function(){return this._scaleByDistance},set:function(e){var t=this._scaleByDistance;u.equals(t,e)||(this._scaleByDistance=u.clone(e,t),p(this,C))}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){var t=this._translucencyByDistance;u.equals(t,e)||(this._translucencyByDistance=u.clone(e,t),p(this,E))}},pixelSize:{get:function(){return this._pixelSize},set:function(e){this._pixelSize!==e&&(this._pixelSize=e,p(this,y))}},color:{get:function(){return this._color},set:function(e){var t=this._color;i.equals(t,e)||(i.clone(e,t),p(this,v))}},outlineColor:{get:function(){return this._outlineColor},set:function(e){var t=this._outlineColor;i.equals(t,e)||(i.clone(e,t),p(this,_))}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){this._outlineWidth!==e&&(this._outlineWidth=e,p(this,g))}},id:{get:function(){return this._id},set:function(e){this._id=e,o(this._pickId)&&(this._pickId.object.id=e)}}}),d.prototype.getPickId=function(e){return o(this._pickId)||(this._pickId=e.createPickId({primitive:this,collection:this._collection,id:this._id})),this._pickId},d.prototype._getActualPosition=function(){return this._actualPosition},d.prototype._setActualPosition=function(e){t.clone(e,this._actualPosition),p(this,f)};var S=new r;d._computeActualPosition=function(e,t,r){return t.mode===c.SCENE3D?e:(l.multiplyByPoint(r,e,S),h.computeActualWgs84Position(t,S))};var w=new l,T=new r;return d._computeScreenSpacePosition=function(e,t,i,n){var o=i.camera,a=o.viewMatrix,s=o.frustum.projectionMatrix,u=l.multiplyTransformation(a,e,w),c=l.multiplyByVector(u,r.fromElements(t.x,t.y,t.z,1,T),T),d=l.multiplyByVector(s,c,T),p=h.clipToGLWindowCoordinates(i,d,n);return p},d.prototype.computeScreenSpacePosition=function(t,r){var i=this._pointPrimitiveCollection;o(r)||(r=new e);var n=i.modelMatrix,a=d._computeScreenSpacePosition(n,this._actualPosition,t,r);return a.y=t.canvas.clientHeight-a.y,a},d.prototype.equals=function(e){return this===e||o(e)&&this._id===e._id&&t.equals(this._position,e._position)&&i.equals(this._color,e._color)&&this._pixelSize===e._pixelSize&&this._outlineWidth===e._outlineWidth&&this._show===e._show&&i.equals(this._outlineColor,e._outlineColor)&&u.equals(this._scaleByDistance,e._scaleByDistance)&&u.equals(this._translucencyByDistance,e._translucencyByDistance)},d.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._pointPrimitiveCollection=void 0},d}),r("Scene/PointPrimitiveCollection",["../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/Math","../Core/Matrix4","../Core/PrimitiveType","../Renderer/BufferUsage","../Renderer/ContextLimits","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArrayFacade","../Shaders/PointPrimitiveCollectionFS","../Shaders/PointPrimitiveCollectionVS","./BlendingState","./Pass","./PointPrimitive","./SceneMode"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S,w,T,x,b){"use strict";function P(t){t=o(t,o.EMPTY_OBJECT),this._sp=void 0,this._rs=void 0,this._vaf=void 0,this._spPick=void 0,this._pointPrimitives=[],this._pointPrimitivesToUpdate=[],this._pointPrimitivesToUpdateIndex=0,this._pointPrimitivesRemoved=!1,this._createVertexArray=!1,this._shaderScaleByDistance=!1,this._compiledShaderScaleByDistance=!1,this._compiledShaderScaleByDistancePick=!1,this._shaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistancePick=!1,this._propertiesChanged=new Uint32Array(Y),this._maxPixelSize=1,this._baseVolume=new e,this._baseVolumeWC=new e,this._baseVolume2D=new e,this._boundingVolume=new e,this._boundingVolumeDirty=!1,this._colorCommands=[],this._pickCommands=[],this.modelMatrix=d.clone(o(t.modelMatrix,d.IDENTITY)),this._modelMatrix=d.clone(d.IDENTITY),this.debugShowBoundingVolume=o(t.debugShowBoundingVolume,!1),this._mode=b.SCENE3D,this._maxTotalPointSize=1,this._buffersUsage=[m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW,m.STATIC_DRAW];var r=this;this._uniforms={u_maxTotalPointSize:function(){return r._maxTotalPointSize}}}function A(e){for(var t=e.length,r=0;t>r;++r)e[r]&&e[r]._destroy()}function I(e){if(e._pointPrimitivesRemoved){e._pointPrimitivesRemoved=!1;for(var t=[],r=e._pointPrimitives,i=r.length,n=0,o=0;i>n;++n){var a=r[n];a&&(a._index=o++,t.push(a))}e._pointPrimitives=t}}function M(e,t,r){return new C(e,[{index:X.positionHighAndSize,componentsPerAttribute:4,componentDatatype:n.FLOAT,usage:r[k]},{index:X.positionLowAndShow,componentsPerAttribute:4,componentDatatype:n.FLOAT,usage:r[k]},{index:X.compressedAttribute0,componentsPerAttribute:4,componentDatatype:n.FLOAT,usage:r[U]},{index:X.compressedAttribute1,componentsPerAttribute:4,componentDatatype:n.FLOAT,usage:r[j]},{index:X.scaleByDistance,componentsPerAttribute:4,componentDatatype:n.FLOAT,usage:r[q]}],t)}function D(t,r,i,n){var o=n._index,a=n._getActualPosition();t._mode===b.SCENE3D&&(e.expand(t._baseVolume,a,t._baseVolume),t._boundingVolumeDirty=!0),c.fromCartesian(a,Z);var s=n.pixelSize,l=n.outlineWidth;t._maxPixelSize=Math.max(t._maxPixelSize,s+l);var u=i[X.positionHighAndSize],h=Z.high;u(o,h.x,h.y,h.z,s);var d=i[X.positionLowAndOutline],p=Z.low;d(o,p.x,p.y,p.z,l)}function R(e,t,r,n){var o=n._index,a=n.color,s=n.getPickId(t).color,l=n.outlineColor,u=i.floatToByte(a.red),c=i.floatToByte(a.green),h=i.floatToByte(a.blue),d=u*K+c*Q+h;u=i.floatToByte(l.red),c=i.floatToByte(l.green),h=i.floatToByte(l.blue);var p=u*K+c*Q+h;u=i.floatToByte(s.red),c=i.floatToByte(s.green),h=i.floatToByte(s.blue);var m=u*K+c*Q+h,f=i.floatToByte(a.alpha)*K+i.floatToByte(l.alpha)*Q+i.floatToByte(s.alpha),v=r[X.compressedAttribute0];v(o,d,p,m,f)}function O(e,t,r,i){var n=i._index,o=0,s=1,l=1,u=1,c=i.translucencyByDistance;a(c)&&(o=c.near,s=c.nearValue,l=c.far,u=c.farValue,(1!==s||1!==u)&&(e._shaderTranslucencyByDistance=!0));var d=i.show;0===i.color.alpha&&0===i.outlineColor.alpha&&(d=!1),s=h.clamp(s,0,1),s=1===s?255:255*s|0;var p=(d?1:0)*Q+s;u=h.clamp(u,0,1),u=1===u?255:255*u|0;var m=u,f=r[X.compressedAttribute1];f(n,p,m,o,l)}function N(e,t,r,i){var n=i._index,o=r[X.scaleByDistance],s=0,l=1,u=1,c=1,h=i.scaleByDistance;a(h)&&(s=h.near,l=h.nearValue,u=h.far,c=h.farValue,(1!==l||1!==c)&&(e._shaderScaleByDistance=!0)),o(n,s,l,u,c)}function L(e,t,r,i){D(e,t,r,i),R(e,t,r,i),O(e,t,r,i),N(e,t,r,i)}function F(t,r,i,n,o,s){var l;n.mode===b.SCENE3D?(l=t._baseVolume,t._boundingVolumeDirty=!0):l=t._baseVolume2D;for(var u=[],c=0;i>c;++c){var h=r[c],d=h.position,p=x._computeActualPosition(d,n,o);a(p)&&(h._setActualPosition(p),s?u.push(p):e.expand(l,p,l))}s&&e.fromPoints(u,l)}function B(e,t){var r=t.mode,i=e._pointPrimitives,n=e._pointPrimitivesToUpdate,o=e._modelMatrix;e._createVertexArray||e._mode!==r||r!==b.SCENE3D&&!d.equals(o,e.modelMatrix)?(e._mode=r,d.clone(e.modelMatrix,o),e._createVertexArray=!0,(r===b.SCENE3D||r===b.SCENE2D||r===b.COLUMBUS_VIEW)&&F(e,i,i.length,t,o,!0)):r===b.MORPHING?F(e,i,i.length,t,o,!0):(r===b.SCENE2D||r===b.COLUMBUS_VIEW)&&F(e,n,e._pointPrimitivesToUpdateIndex,t,o,!1)}function V(e,t,r){var i=t.camera.getPixelSize(r,t.context.drawingBufferWidth,t.context.drawingBufferHeight),n=i*e._maxPixelSize;r.radius+=n}var z=x.SHOW_INDEX,k=x.POSITION_INDEX,U=x.COLOR_INDEX,G=x.OUTLINE_COLOR_INDEX,W=x.OUTLINE_WIDTH_INDEX,H=x.PIXEL_SIZE_INDEX,q=x.SCALE_BY_DISTANCE_INDEX,j=x.TRANSLUCENCY_BY_DISTANCE_INDEX,Y=x.NUMBER_OF_PROPERTIES,X={positionHighAndSize:0,positionLowAndOutline:1,compressedAttribute0:2,compressedAttribute1:3,scaleByDistance:4};s(P.prototype,{length:{get:function(){return I(this),this._pointPrimitives.length}}}),P.prototype.add=function(e){var t=new x(e,this);return t._index=this._pointPrimitives.length,this._pointPrimitives.push(t),this._createVertexArray=!0,t},P.prototype.remove=function(e){return this.contains(e)?(this._pointPrimitives[e._index]=null,this._pointPrimitivesRemoved=!0,this._createVertexArray=!0,e._destroy(),!0):!1},P.prototype.removeAll=function(){A(this._pointPrimitives),this._pointPrimitives=[],this._pointPrimitivesToUpdate=[],this._pointPrimitivesToUpdateIndex=0,this._pointPrimitivesRemoved=!1,this._createVertexArray=!0},P.prototype._updatePointPrimitive=function(e,t){e._dirty||(this._pointPrimitivesToUpdate[this._pointPrimitivesToUpdateIndex++]=e),++this._propertiesChanged[t]},P.prototype.contains=function(e){return a(e)&&e._pointPrimitiveCollection===this},P.prototype.get=function(e){return I(this),this._pointPrimitives[e]},P.prototype.computeNewBuffersUsage=function(){for(var e=this._buffersUsage,t=!1,r=this._propertiesChanged,i=0;Y>i;++i){var n=0===r[i]?m.STATIC_DRAW:m.STREAM_DRAW;t=t||e[i]!==n,e[i]=n}return t};var Z=new c,K=65536,Q=256,J=[];return P.prototype.update=function(t){I(this),this._maxTotalPointSize=f.maximumAliasedPointSize,B(this,t);var r,i=this._pointPrimitives,n=i.length,o=this._pointPrimitivesToUpdate,s=this._pointPrimitivesToUpdateIndex,l=this._propertiesChanged,u=this._createVertexArray,c=t.context,h=t.passes,m=h.pick;if(u||!m&&this.computeNewBuffersUsage()){this._createVertexArray=!1;for(var C=0;Y>C;++C)l[C]=0;if(this._vaf=this._vaf&&this._vaf.destroy(),n>0){this._vaf=M(c,n,this._buffersUsage),r=this._vaf.writers;for(var x=0;n>x;++x){var P=this._pointPrimitives[x];P._dirty=!1,L(this,c,r,P)}this._vaf.commit()}this._pointPrimitivesToUpdateIndex=0}else if(s>0){var A=J;A.length=0,(l[k]||l[W]||l[H])&&A.push(D),(l[U]||l[G])&&A.push(R),(l[z]||l[j])&&A.push(O),l[q]&&A.push(N);var F=A.length;if(r=this._vaf.writers,s/n>.1){for(var Z=0;s>Z;++Z){var K=o[Z];K._dirty=!1;for(var Q=0;F>Q;++Q)A[Q](this,c,r,K)}this._vaf.commit()}else{for(var $=0;s>$;++$){var ee=o[$];ee._dirty=!1;for(var te=0;F>te;++te)A[te](this,c,r,ee);this._vaf.subCommit(ee._index,1)}this._vaf.endSubCommits()}this._pointPrimitivesToUpdateIndex=0}if(s>1.5*n&&(o.length=n),a(this._vaf)&&a(this._vaf.va)){this._boundingVolumeDirty&&(this._boundingVolumeDirty=!1,e.transform(this._baseVolume,this.modelMatrix,this._baseVolumeWC));var re,ie=d.IDENTITY;t.mode===b.SCENE3D?(ie=this.modelMatrix,re=e.clone(this._baseVolumeWC,this._boundingVolume)):re=e.clone(this._baseVolume2D,this._boundingVolume),
V(this,t,re);var ne,oe,ae,se,le,ue,ce=t.commandList;if(h.render){var he=this._colorCommands;for(a(this._rs)||(this._rs=_.fromCache({depthTest:{enabled:!0},blending:w.ALPHA_BLEND})),(!a(this._sp)||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistance||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistance)&&(le=new y({sources:[S]}),this._shaderScaleByDistance&&le.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&le.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._sp=g.replaceCache({context:c,shaderProgram:this._sp,vertexShaderSource:le,fragmentShaderSource:E,attributeLocations:X}),this._compiledShaderScaleByDistance=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistance=this._shaderTranslucencyByDistance),ne=this._vaf.va,oe=ne.length,he.length=oe,se=0;oe>se;++se)ae=he[se],a(ae)||(ae=he[se]=new v({primitiveType:p.POINTS,pass:T.OPAQUE,owner:this})),ae.boundingVolume=re,ae.modelMatrix=ie,ae.shaderProgram=this._sp,ae.uniformMap=this._uniforms,ae.vertexArray=ne[se].va,ae.renderState=this._rs,ae.debugShowBoundingVolume=this.debugShowBoundingVolume,ce.push(ae)}if(m){var de=this._pickCommands;for((!a(this._spPick)||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistancePick||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistancePick)&&(le=new y({defines:["RENDER_FOR_PICK"],sources:[S]}),this._shaderScaleByDistance&&le.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&le.defines.push("EYE_DISTANCE_TRANSLUCENCY"),ue=new y({defines:["RENDER_FOR_PICK"],sources:[E]}),this._spPick=g.replaceCache({context:c,shaderProgram:this._spPick,vertexShaderSource:le,fragmentShaderSource:ue,attributeLocations:X}),this._compiledShaderScaleByDistancePick=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistancePick=this._shaderTranslucencyByDistance),ne=this._vaf.va,oe=ne.length,de.length=oe,se=0;oe>se;++se)ae=de[se],a(ae)||(ae=de[se]=new v({primitiveType:p.POINTS,pass:T.OPAQUE,owner:this})),ae.boundingVolume=re,ae.modelMatrix=ie,ae.shaderProgram=this._spPick,ae.uniformMap=this._uniforms,ae.vertexArray=ne[se].va,ae.renderState=this._rs,ce.push(ae)}}},P.prototype.isDestroyed=function(){return!1},P.prototype.destroy=function(){return this._sp=this._sp&&this._sp.destroy(),this._spPick=this._spPick&&this._spPick.destroy(),this._vaf=this._vaf&&this._vaf.destroy(),A(this._pointPrimitives),l(this)},P}),r("DataSources/PointVisualizer",["../Core/AssociativeArray","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/PointPrimitiveCollection","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,l,u){"use strict";function c(e){this.entity=e,this.pointPrimitive=void 0,this.color=void 0,this.outlineColor=void 0,this.pixelSize=void 0,this.outlineWidth=void 0}function h(t,r){r.collectionChanged.addEventListener(h.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._entityCollection=r,this._pointPrimitiveCollection=void 0,this._items=new e,this._onCollectionChanged(r,r.values,[],[])}function d(e,t){if(i(e)){var r=e.pointPrimitive;i(r)&&(e.pointPrimitive=void 0,r.show=!1,t.push(r._index))}}var p=r.WHITE,m=r.BLACK,f=0,v=1,_=new r,g=new t,y=new r,C=new a,E=new a;return h.prototype.update=function(e){for(var t=this._items.values,r=this._unusedIndexes,n=0,o=t.length;o>n;n++){var a=t[n],l=a.entity,c=l._point,h=a.pointPrimitive,S=l.isShowing&&l.isAvailable(e)&&u.getValueOrDefault(c._show,e,!0);if(S&&(g=u.getValueOrUndefined(l._position,e,g),S=i(g)),S){if(!i(h)){var w=this._pointPrimitiveCollection;i(w)||(w=new s,this._pointPrimitiveCollection=w,this._scene.primitives.add(w));var T=r.length;h=T>0?w.get(r.pop()):w.add(),h.id=l,a.pointPrimitive=h}h.show=!0,h.position=g,h.scaleByDistance=u.getValueOrUndefined(c._scaleByDistance,e,C),h.translucencyByDistance=u.getValueOrUndefined(c._translucencyByDistance,e,E),h.color=u.getValueOrDefault(c._color,e,p,_),h.outlineColor=u.getValueOrDefault(c._outlineColor,e,m,y),h.outlineWidth=u.getValueOrDefault(c._outlineWidth,e,f),h.pixelSize=u.getValueOrDefault(c._pixelSize,e,v)}else d(a,r)}return!0},h.prototype.getBoundingSphere=function(e,r){var n=this._items.get(e.id);return i(n)&&i(n.pointPrimitive)?(r.center=t.clone(n.pointPrimitive.position,r.center),r.radius=0,l.DONE):l.FAILED},h.prototype.isDestroyed=function(){return!1},h.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(h.prototype._onCollectionChanged,this),i(this._pointPrimitiveCollection)&&this._scene.primitives.remove(this._pointPrimitiveCollection),n(this)},h.prototype._onCollectionChanged=function(e,t,r,n){var o,a,s=this._unusedIndexes,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],i(a._point)&&i(a._position)&&l.set(a.id,new c(a));for(o=n.length-1;o>-1;o--)a=n[o],i(a._point)&&i(a._position)?l.contains(a.id)||l.set(a.id,new c(a)):(d(l.get(a.id),s),l.remove(a.id));for(o=r.length-1;o>-1;o--)a=r[o],d(l.get(a.id),s),l.remove(a.id)},h}),r("DataSources/PolygonGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/isArray","../Core/Iso8601","../Core/PolygonGeometry","../Core/PolygonHierarchy","../Core/PolygonOutlineGeometry","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,l,u,c,h,d,p,m,f,v,_,g,y,C,E,S){"use strict";function w(e){this.id=e,this.vertexFormat=void 0,this.polygonHierarchy=void 0,this.perPositionHeight=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0}function T(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(T.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new s,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new w(e),this._onEntityPropertyChanged(e,"polygon",e.polygon,void 0)}function x(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new w(t._entity)}var b=new g(e.WHITE),P=new y(!0),A=new y(!0),I=new y(!1),M=new y(e.BLACK),D=new e;return n(T,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:f}}),n(T.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!i(this._entity.availability)&&S.isConstant(this._showProperty)&&S.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!i(this._entity.availability)&&S.isConstant(this._showProperty)&&S.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),T.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},T.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},T.prototype.createFillGeometryInstance=function(r){var n,o,a=this._entity,s=a.isAvailable(r),u=new m(s&&a.isShowing&&this._showProperty.getValue(r)&&this._fillProperty.getValue(r));if(this._materialProperty instanceof g){var c=e.WHITE;i(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(c=this._materialProperty.color.getValue(r)),o=t.fromColor(c),n={show:u,color:o}}else n={show:u};return new l({id:a,geometry:new h(this._options),attributes:n})},T.prototype.createOutlineGeometryInstance=function(r){var i=this._entity,n=i.isAvailable(r),o=S.getValueOrDefault(this._outlineColorProperty,r,e.BLACK);return new l({id:i,geometry:new p(this._options),attributes:{show:new m(n&&i.isShowing&&this._showProperty.getValue(r)&&this._showOutlineProperty.getValue(r)),color:t.fromColor(o)}})},T.prototype.isDestroyed=function(){return!1},T.prototype.destroy=function(){this._entitySubscription(),o(this)},T.prototype._onEntityPropertyChanged=function(e,t,n,o){if("availability"===t||"polygon"===t){var a=this._entity.polygon;if(!i(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,l=i(s)&&s.isConstant?s.getValue(c.MINIMUM_VALUE):!0,h=a.outline,p=i(h);if(p&&h.isConstant&&(p=h.getValue(c.MINIMUM_VALUE)),!l&&!p)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var m=a.hierarchy,_=a.show;if(i(_)&&_.isConstant&&!_.getValue(c.MINIMUM_VALUE)||!i(m))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var y=r(a.material,b),C=y instanceof g;this._materialProperty=y,this._fillProperty=r(s,A),this._showProperty=r(_,P),this._showOutlineProperty=r(a.outline,I),this._outlineColorProperty=p?r(a.outlineColor,M):void 0;var E=a.height,w=a.extrudedHeight,T=a.granularity,x=a.stRotation,D=a.outlineWidth,R=a.perPositionHeight;if(this._fillEnabled=l,this._outlineEnabled=p,m.isConstant&&S.isConstant(E)&&S.isConstant(w)&&S.isConstant(T)&&S.isConstant(x)&&S.isConstant(D)&&S.isConstant(R)){var O=this._options;O.vertexFormat=C?v.VERTEX_FORMAT:f.MaterialSupport.TEXTURED.vertexFormat;var N=m.getValue(c.MINIMUM_VALUE);u(N)&&(N=new d(N));var L=i(E)?E.getValue(c.MINIMUM_VALUE):void 0,F=i(w)?w.getValue(c.MINIMUM_VALUE):void 0;O.polygonHierarchy=N,O.height=L,O.extrudedHeight=F,O.granularity=i(T)?T.getValue(c.MINIMUM_VALUE):void 0,O.stRotation=i(x)?x.getValue(c.MINIMUM_VALUE):void 0,O.perPositionHeight=i(R)?R.getValue(c.MINIMUM_VALUE):void 0,this._outlineWidth=i(D)?D.getValue(c.MINIMUM_VALUE):1,this._isClosed=i(F)&&F!==L,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},T.prototype.createDynamicUpdater=function(e){return new x(e,this)},x.prototype.update=function(r){var n=this._primitives;n.removeAndDestroy(this._primitive),n.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,s=a.polygon;if(a.isShowing&&a.isAvailable(r)&&S.getValueOrDefault(s.show,r,!0)){var c=this._options,m=S.getValueOrUndefined(s.hierarchy,r);if(i(m)){if(u(m)?c.polygonHierarchy=new d(m):c.polygonHierarchy=m,c.height=S.getValueOrUndefined(s.height,r),c.extrudedHeight=S.getValueOrUndefined(s.extrudedHeight,r),c.granularity=S.getValueOrUndefined(s.granularity,r),c.stRotation=S.getValueOrUndefined(s.stRotation,r),c.perPositionHeight=S.getValueOrUndefined(s.perPositionHeight,r),S.getValueOrDefault(s.fill,r,!0)){var g=E.getValue(r,o.fillMaterialProperty,this._material);this._material=g;var y=new f({material:g,translucent:g.isTranslucent(),closed:i(c.extrudedHeight)&&c.extrudedHeight!==c.height});c.vertexFormat=y.vertexFormat,this._primitive=n.add(new _({geometryInstances:new l({id:a,geometry:new h(c)}),appearance:y,asynchronous:!1}))}if(S.getValueOrDefault(s.outline,r,!1)){c.vertexFormat=v.VERTEX_FORMAT;var C=S.getValueOrClonedDefault(s.outlineColor,r,e.BLACK,D),w=S.getValueOrDefault(s.outlineWidth,r,1),T=1!==C.alpha;this._outlinePrimitive=n.add(new _({geometryInstances:new l({id:a,geometry:new p(c),attributes:{color:t.fromColor(C)}}),appearance:new v({flat:!0,translucent:T,renderState:{lineWidth:o._scene.clampLineWidth(w)}}),asynchronous:!1}))}}}},x.prototype.getBoundingSphere=function(e,t){return C(e,this._primitive,this._outlinePrimitive,t)},x.prototype.isDestroyed=function(){return!1},x.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},T}),r("Shaders/Appearances/PolylineColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec4 color;\nvarying vec4 v_color;\nvoid main()\n{\nfloat expandDir = expandAndWidth.x;\nfloat width = abs(expandAndWidth.y) + 0.5;\nbool usePrev = expandAndWidth.y < 0.0;\nvec4 p = czm_computePosition();\nvec4 prev = czm_computePrevPosition();\nvec4 next = czm_computeNextPosition();\nv_color = color;\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),r("Scene/PolylineColorAppearance",["../Core/defaultValue","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/Appearances/PolylineColorAppearanceVS","../Shaders/PolylineCommon","./Appearance"],function(e,t,r,i,n,o,a){"use strict";function s(t){t=e(t,e.EMPTY_OBJECT);var r=e(t.translucent,!0),i=!1,n=s.VERTEX_FORMAT;this.material=void 0,this.translucent=r,this._vertexShaderSource=e(t.vertexShaderSource,l),this._fragmentShaderSource=e(t.fragmentShaderSource,u),this._renderState=a.getDefaultRenderState(r,i,t.renderState),this._closed=i,this._vertexFormat=n}var l=o+"\n"+n,u=i;return t(s.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}}}),s.VERTEX_FORMAT=r.POSITION_ONLY,s.prototype.getFragmentShaderSource=a.prototype.getFragmentShaderSource,s.prototype.isTranslucent=a.prototype.isTranslucent,s.prototype.getRenderState=a.prototype.getRenderState,s}),r("Shaders/Appearances/PolylineMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec2 st;\nvarying float v_width;\nvarying vec2 v_st;\nvoid main()\n{\nfloat expandDir = expandAndWidth.x;\nfloat width = abs(expandAndWidth.y) + 0.5;\nbool usePrev = expandAndWidth.y < 0.0;\nvec4 p = czm_computePosition();\nvec4 prev = czm_computePrevPosition();\nvec4 next = czm_computeNextPosition();\nv_width = width;\nv_st = st;\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),r("Scene/PolylineMaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PolylineMaterialAppearanceVS","../Shaders/PolylineCommon","../Shaders/PolylineFS","./Appearance","./Material"],function(e,t,r,i,n,o,a,s,l){"use strict";function u(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.translucent,!0),n=!1,o=u.VERTEX_FORMAT;this.material=t(r.material)?r.material:l.fromType(l.ColorType),this.translucent=i,this._vertexShaderSource=e(r.vertexShaderSource,c),this._fragmentS